/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.evaluation.formula;

import com.varial.base.exception.BusinessDomainException;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.employee.valueposition.ValuePosition;
import com.varial.personnel.domain.evaluation.formula.AVBeitragsermittlungGleitzone2022Formula;
import com.varial.personnel.domain.evaluation.library.CalculationLibrary;
import com.varial.personnel.domain.evaluation.library.EmployeeLibrary;
import com.varial.personnel.domain.evaluation.library.GlobalLibrary;
import com.varial.personnel.domain.evaluation.library.ValuePositionLibrary;
import com.varial.personnel.domain.evaluation.mapper.ValueTypeHelper;
import com.varial.personnel.domain.typeofvalue.ValueType;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BigDecimalMapper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;

public class AVBeitragsermittlungGleitzoneFormula {
    private static final BigDecimal ZWEI = BigDecimal.valueOf(2L);
    private static final BigDecimal EINHUNDERT = BigDecimal.valueOf(100L);
    private final ValuePositionLibrary mVpLib;
    private final EmployeeLibrary mEeLib;
    private final GlobalLibrary mGlLib;
    private final CalculationLibrary mCalLib;
    private BigDecimal mAufgelaufenesGesamtEntgelt = BigDecimal.ZERO;
    private BigDecimal mAufgelaufenesFiktivesEntgelt = BigDecimal.ZERO;
    private BigDecimal mAufgelaufenerBeitrag = BigDecimal.ZERO;
    private BigDecimal mVHsatzAG = BigDecimal.ZERO;
    private BigDecimal mVHSatzAN = BigDecimal.ZERO;
    private BigDecimal mGesBeitrPflEntgelt = BigDecimal.ZERO;
    private BigDecimal mFiktivesBeitrPflEntgelt = BigDecimal.ZERO;
    private BigDecimal mAV_Aga = BigDecimal.ZERO;
    private BigDecimal mAV_Ana = BigDecimal.ZERO;
    private boolean mIsAvAgAGekuerzt = false;

    public AVBeitragsermittlungGleitzoneFormula(EmployeeLibrary employeeLibrary, GlobalLibrary globalLibrary, CalculationLibrary calculationLibrary, ValuePositionLibrary valuePositionLibrary) {
        this.mCalLib = calculationLibrary;
        this.mGlLib = globalLibrary;
        this.mEeLib = employeeLibrary;
        this.mVpLib = valuePositionLibrary;
    }

    public void avbeitraege() throws BusinessDomainException {
        if (DateHelper.afterOrEqual((Date)this.mVpLib.gueltigAb(), (Date)new VDate(2022, 9, 1).getDate()) && !this.mEeLib.kennzBestandGleitzone2022()) {
            new AVBeitragsermittlungGleitzone2022Formula(this.mEeLib, this.mGlLib, this.mCalLib, this.mVpLib).avbeitraege();
        } else {
            boolean AGA100Prozent;
            this.mGesBeitrPflEntgelt = this.mVpLib.prozentsatz();
            this.mFiktivesBeitrPflEntgelt = this.mVpLib.result();
            this.ermittleAVEntgeltImMonat(this.mVpLib.wertartenNummer());
            ValuePosition vp = this.mVpLib.wertPosition();
            vp.setSumOfBasicResult(this.mGesBeitrPflEntgelt);
            vp.setSumOfResult(this.mFiktivesBeitrPflEntgelt);
            this.mGesBeitrPflEntgelt = this.mGesBeitrPflEntgelt.add(this.mAufgelaufenesGesamtEntgelt);
            this.mFiktivesBeitrPflEntgelt = this.mFiktivesBeitrPflEntgelt.add(this.mAufgelaufenesFiktivesEntgelt);
            boolean bl = AGA100Prozent = BigDecimalMapper.compareTo((BigDecimal)vp.getPerformanceFactor(), (BigDecimal)BigDecimal.valueOf(100L)) == 0;
            if (AGA100Prozent) {
                this.mVHsatzAG = this.mGlLib.svBsGesamtAv();
                this.mAV_Aga = this.mAV_Aga.add(this.mVpLib.prozentsatz().multiply(this.mVHsatzAG).divide(EINHUNDERT, 2, RoundingMode.HALF_UP));
                vp.setPerformanceFactor(BigDecimal.ZERO);
            } else {
                this.mVHSatzAN = this.mGlLib.svBsGesamtAv().divide(ZWEI, 2, RoundingMode.HALF_UP);
                this.mVHsatzAG = this.mGlLib.svBsGesamtAv().divide(ZWEI, 2, RoundingMode.HALF_UP);
                if (this.mEeLib.marbBgrAv() == 1) {
                    this.normal();
                }
                if (this.mEeLib.marbBgrAv() == 2) {
                    this.nurHalberAgA();
                }
                switch (this.mVpLib.wertartenNummer()) {
                    case 334514: {
                        this.mAV_Ana = this.mAV_Ana.subtract(this.mAufgelaufenerBeitrag);
                        break;
                    }
                    case 335514: {
                        this.mAV_Aga = this.mAV_Aga.subtract(this.mAufgelaufenerBeitrag);
                        break;
                    }
                }
                if (this.mGesBeitrPflEntgelt.compareTo(BigDecimal.ZERO) == 0) {
                    this.mVHSatzAN = BigDecimal.ZERO;
                    this.mVHsatzAG = BigDecimal.ZERO;
                } else {
                    if (this.mIsAvAgAGekuerzt && !BigDecimalMapper.isZeroOrNull((BigDecimal)this.mVpLib.prozentsatz())) {
                        this.mVHsatzAG = this.mAV_Aga.multiply(EINHUNDERT).divide(this.mVpLib.prozentsatz(), 3, RoundingMode.HALF_UP);
                    }
                    if (DateHelper.before((Date)this.mCalLib.berchnungGueltigAb(), (Date)new VDate(2019, 6, 1).getDate())) {
                        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.mVpLib.prozentsatz())) {
                            this.mVHSatzAN = this.mAV_Ana.multiply(EINHUNDERT).divide(this.mVpLib.prozentsatz(), 3, RoundingMode.HALF_UP);
                        }
                    } else {
                        this.mVHSatzAN = BigDecimal.ZERO;
                    }
                }
            }
            this.mCalLib.avANBeitrag(this.mAV_Ana);
            this.mCalLib.avANProzentsatz(this.mVHSatzAN);
            this.mCalLib.avAGBeitrag(this.mAV_Aga);
            this.mCalLib.avAGProzentsatz(this.mVHsatzAG);
        }
    }

    private void normal() {
        this.mAV_Aga = this.mGesBeitrPflEntgelt.multiply(this.mVHsatzAG).divide(EINHUNDERT, 2, RoundingMode.HALF_UP);
        this.mAV_Ana = this.mFiktivesBeitrPflEntgelt.multiply(this.mVHSatzAN).divide(EINHUNDERT, 2, RoundingMode.HALF_UP);
        this.mAV_Ana = this.mAV_Ana.multiply(ZWEI).subtract(this.mAV_Aga).setScale(2);
        if (this.mAV_Ana.compareTo(BigDecimal.ZERO) < 0) {
            this.mIsAvAgAGekuerzt = true;
            this.mAV_Aga = this.mAV_Aga.add(this.mAV_Ana);
            this.mVHSatzAN = BigDecimal.ZERO;
            this.mAV_Ana = BigDecimal.ZERO;
        }
    }

    private void nurHalberAgA() {
        this.mAV_Aga = this.mGesBeitrPflEntgelt.multiply(this.mVHsatzAG).divide(EINHUNDERT, 2, RoundingMode.HALF_UP);
    }

    private void ermittleAVEntgeltImMonat(int valueType) throws BusinessDomainException {
        ValuePosition[] vpArray;
        for (ValuePosition lElement : vpArray = this.sammleValuePosition(ValueTypeHelper.getValueTypes(valueType))) {
            if (lElement.getSumOfBasicResult() != null) {
                this.mAufgelaufenesGesamtEntgelt = this.mAufgelaufenesGesamtEntgelt.add(lElement.getSumOfBasicResult());
            }
            if (lElement.getSumOfResult() == null) continue;
            this.mAufgelaufenesFiktivesEntgelt = this.mAufgelaufenesFiktivesEntgelt.add(lElement.getSumOfResult());
            if (BigDecimalMapper.isZeroOrNull((BigDecimal)lElement.getSumOfResult())) continue;
            this.mAufgelaufenerBeitrag = this.mAufgelaufenerBeitrag.add(lElement.getResult());
        }
    }

    private ValuePosition[] sammleValuePosition(ValueType ... vts) throws BusinessDomainException {
        return this.mVpLib.wpAusWPListeOderDB(this.mVpLib.wirksamAb(), this.mVpLib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.mVpLib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.mVpLib.gueltigAb()), vts);
    }
}

