/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.evaluation.formula;

import com.varial.base.exception.BusinessDomainException;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.employee.valueposition.ValuePosition;
import com.varial.personnel.domain.evaluation.library.CalculationLibrary;
import com.varial.personnel.domain.evaluation.library.EmployeeLibrary;
import com.varial.personnel.domain.evaluation.library.GlobalLibrary;
import com.varial.personnel.domain.evaluation.library.ValuePositionLibrary;
import com.varial.personnel.domain.evaluation.mapper.ValueTypeHelper;
import com.varial.personnel.domain.typeofvalue.ValueType;
import com.varial.serverbase.mapper.BigDecimalMapper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;

public class AVBeitragsermittlungGleitzone2022Formula {
    private static final BigDecimal ZWEI = BigDecimal.valueOf(2L);
    private static final BigDecimal EINHUNDERT = BigDecimal.valueOf(100L);
    private final ValuePositionLibrary mVpLib;
    private final EmployeeLibrary mEeLib;
    private final GlobalLibrary mGlLib;
    private final CalculationLibrary mCalLib;
    private BigDecimal mAufgelaufenesGesamtEntgeltAG = BigDecimal.ZERO;
    private BigDecimal mAufgelaufenesGesamtEntgeltAN = BigDecimal.ZERO;
    private BigDecimal mAufgelaufenerBeitrag = BigDecimal.ZERO;

    public AVBeitragsermittlungGleitzone2022Formula(EmployeeLibrary employeeLibrary, GlobalLibrary globalLibrary, CalculationLibrary calculationLibrary, ValuePositionLibrary valuePositionLibrary) {
        this.mCalLib = calculationLibrary;
        this.mGlLib = globalLibrary;
        this.mEeLib = employeeLibrary;
        this.mVpLib = valuePositionLibrary;
    }

    public void avbeitraege() throws BusinessDomainException {
        BigDecimal gesBeitrPflEntgeltAG = this.mVpLib.prozentsatz();
        BigDecimal gesBeitrPflEntgeltAN = this.mVpLib.result();
        this.ermittleAVEntgeltImMonat(this.mVpLib.wertartenNummer());
        ValuePosition vp = this.mVpLib.wertPosition();
        vp.setSumOfBasicResult(gesBeitrPflEntgeltAG);
        vp.setSumOfResult(gesBeitrPflEntgeltAN);
        gesBeitrPflEntgeltAG = gesBeitrPflEntgeltAG.add(this.mAufgelaufenesGesamtEntgeltAG);
        gesBeitrPflEntgeltAN = gesBeitrPflEntgeltAN.add(this.mAufgelaufenesGesamtEntgeltAN);
        boolean AGA100Prozent = BigDecimalMapper.compareTo((BigDecimal)vp.getPerformanceFactor(), (BigDecimal)BigDecimal.valueOf(100L)) == 0;
        BigDecimal vhSatzAG = BigDecimal.ZERO;
        BigDecimal vhSatzAN = BigDecimal.ZERO;
        BigDecimal avAga = BigDecimal.ZERO;
        BigDecimal avAna = BigDecimal.ZERO;
        if (AGA100Prozent) {
            avAga = avAga.add(this.mVpLib.prozentsatz().multiply(this.mGlLib.svBsGesamtAv()).divide(EINHUNDERT, 2, RoundingMode.HALF_UP));
            this.mCalLib.avAGProzentsatz(this.mGlLib.svBsGesamtAv());
            vp.setPerformanceFactor(BigDecimal.ZERO);
        } else {
            if (this.mEeLib.marbBgrAv() == 1) {
                vhSatzAN = this.mGlLib.svBsGesamtAv().divide(ZWEI, 2, RoundingMode.HALF_UP);
                this.mCalLib.avANProzentsatz(vhSatzAN);
                BigDecimal avGesamt = gesBeitrPflEntgeltAG.multiply(vhSatzAN).divide(EINHUNDERT, 2, RoundingMode.HALF_UP);
                avGesamt = avGesamt.multiply(ZWEI);
                avAna = gesBeitrPflEntgeltAN.multiply(vhSatzAN).divide(EINHUNDERT, 2, RoundingMode.HALF_UP);
                avAga = avGesamt.subtract(avAna);
            } else if (this.mEeLib.marbBgrAv() == 2) {
                vhSatzAG = this.mGlLib.svBsGesamtAv().divide(ZWEI, 2, RoundingMode.HALF_UP);
                this.mCalLib.avAGProzentsatz(vhSatzAG);
                avAga = gesBeitrPflEntgeltAG.multiply(vhSatzAG).divide(EINHUNDERT, 2, RoundingMode.HALF_UP);
            }
            if (BigDecimalMapper.isZeroOrNull((BigDecimal)avAna)) {
                this.mCalLib.avAGProzentsatz(this.mGlLib.svBsGesamtAv());
            }
            switch (this.mVpLib.wertartenNummer()) {
                case 334514: {
                    avAna = avAna.subtract(this.mAufgelaufenerBeitrag);
                    break;
                }
                case 335514: {
                    avAga = avAga.subtract(this.mAufgelaufenerBeitrag);
                    break;
                }
            }
        }
        this.mCalLib.avANBeitrag(avAna);
        this.mCalLib.avAGBeitrag(avAga);
    }

    private void ermittleAVEntgeltImMonat(int valueType) throws BusinessDomainException {
        ValuePosition[] vpArray;
        for (ValuePosition lElement : vpArray = this.sammleValuePosition(ValueTypeHelper.getValueTypes(valueType))) {
            if (!BigDecimalMapper.isZeroOrNull((BigDecimal)lElement.getSumOfBasicResult())) {
                this.mAufgelaufenesGesamtEntgeltAG = this.mAufgelaufenesGesamtEntgeltAG.add(lElement.getSumOfBasicResult());
            }
            if (!BigDecimalMapper.isZeroOrNull((BigDecimal)lElement.getSumOfResult())) {
                this.mAufgelaufenesGesamtEntgeltAN = this.mAufgelaufenesGesamtEntgeltAN.add(lElement.getSumOfResult());
            }
            if (BigDecimalMapper.isZeroOrNull((BigDecimal)lElement.getSumOfBasicResult()) && BigDecimalMapper.isZeroOrNull((BigDecimal)lElement.getSumOfResult())) continue;
            this.mAufgelaufenerBeitrag = this.mAufgelaufenerBeitrag.add(lElement.getResult());
        }
    }

    private ValuePosition[] sammleValuePosition(ValueType ... vts) throws BusinessDomainException {
        return this.mVpLib.wpAusWPListeOderDB(this.mVpLib.wirksamAb(), this.mVpLib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.mVpLib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.mVpLib.gueltigAb()), vts);
    }
}

