/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.evaluation.formula;

import com.varial.base.exception.BusinessDomainException;
import com.varial.personnel.domain.calculation.CertificateCalculationCase;
import com.varial.personnel.domain.calculation.TypeOfCalculationCase;
import com.varial.personnel.domain.employee.valueposition.ValuePosition;
import com.varial.personnel.domain.evaluation.library.CalculationLibrary;
import com.varial.personnel.domain.evaluation.library.EmployeeLibrary;
import com.varial.personnel.domain.evaluation.library.ValuePositionLibrary;
import com.varial.serverbase.mapper.BigDecimalMapper;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class AGZKug80ProzentNettoSollIstFormula {
    private static final BigDecimal EINHUNDERT = BigDecimal.valueOf(100L);
    private final CalculationLibrary mCalLib;
    private final EmployeeLibrary mEeLib;
    private final ValuePositionLibrary mVpLib;

    public AGZKug80ProzentNettoSollIstFormula(CalculationLibrary calLib, EmployeeLibrary eeLib, ValuePositionLibrary wpLib) {
        this.mCalLib = calLib;
        this.mEeLib = eeLib;
        this.mVpLib = wpLib;
    }

    public void ermittle(BigDecimal prozentsatz) throws BusinessDomainException {
        if (BigDecimalMapper.isZeroOrNull((BigDecimal)this.mVpLib.result())) {
            if (this.mCalLib.getTypeOfCalculationCase() == TypeOfCalculationCase.Standard) {
                CertificateCalculationCase calCase = new CertificateCalculationCase();
                calCase.init(this.mEeLib.marb(), this.mCalLib.berchnungWirksamAb(), this.mCalLib.berchnungGueltigAb(), BigDecimal.ZERO, TypeOfCalculationCase.Verdienstausfall);
                calCase.start();
                ValuePosition[] vpos = calCase.getValuePositionHistory().getItems(this.mVpLib.wirksamAb(), this.mVpLib.wirksamBis(), this.mVpLib.gueltigAb(), this.mVpLib.gueltigBis());
                calCase.removeValuesOfCalculation();
                BigDecimal kugAusfallgeld = BigDecimal.ZERO;
                BigDecimal kugNettoSoll = BigDecimal.ZERO;
                BigDecimal kugNettoIst = BigDecimal.ZERO;
                block5: for (ValuePosition vp : vpos) {
                    switch (vp.getValueType().getValueTypeKey()) {
                        case 151020: {
                            kugNettoSoll = kugNettoSoll.add(vp.getResult().multiply(EINHUNDERT).divide(vp.getPercentage(), 2, RoundingMode.HALF_UP));
                            continue block5;
                        }
                        case 151120: {
                            kugNettoIst = kugNettoIst.add(vp.getResult().multiply(EINHUNDERT).divide(vp.getPercentage(), 2, RoundingMode.HALF_UP));
                            continue block5;
                        }
                        case 230510: 
                        case 230520: {
                            kugAusfallgeld = kugAusfallgeld.add(vp.getResult());
                        }
                    }
                }
                BigDecimal nettoDifferenz = kugNettoSoll.subtract(kugNettoIst).multiply(prozentsatz).divide(EINHUNDERT).setScale(2, RoundingMode.HALF_UP);
                BigDecimal kugZuschuss = nettoDifferenz.subtract(kugAusfallgeld);
                if (BigDecimalMapper.compareTo((BigDecimal)kugZuschuss, (BigDecimal)BigDecimal.ZERO) < 0) {
                    kugZuschuss = BigDecimal.ZERO;
                }
                this.mCalLib.result(kugZuschuss);
            }
        } else {
            this.mCalLib.result(this.mVpLib.result());
        }
    }
}

