/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.evaluation;

import com.varial.base.UtilitiesManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.calculation.CalculationCase;
import com.varial.personnel.domain.employee.absenttime.EEAbsentTimeTP;
import com.varial.personnel.domain.employee.valueposition.ValuePosition;
import com.varial.personnel.domain.evaluation.EvaluationFormula;
import com.varial.personnel.domain.evaluation.formula.ErmittlungUmlageerstattungU1Formula;
import com.varial.personnel.domain.evaluation.library.CalculationLibrary;
import com.varial.personnel.domain.evaluation.library.EmployeeLibrary;
import com.varial.personnel.domain.evaluation.library.ValuePositionLibrary;
import com.varial.personnel.domain.evaluation.libraryimpl.CalculationLibraryImpl;
import com.varial.personnel.domain.evaluation.libraryimpl.EmployeeLibraryImpl;
import com.varial.personnel.domain.evaluation.libraryimpl.GlobalLibraryImpl;
import com.varial.personnel.domain.evaluation.libraryimpl.IGlobalLibraryImplFactory;
import com.varial.personnel.domain.evaluation.libraryimpl.MultipleUsedMethodsImpl;
import com.varial.personnel.domain.evaluation.libraryimpl.ValuePositionLibraryImpl;
import com.varial.personnel.domain.evaluation.mapper.ValueTypeHelper;
import com.varial.personnel.domain.typeofvalue.ValueType;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.StringMapper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;

public class ErmittlungUmlageerstattungU1
implements EvaluationFormula {
    private EmployeeLibraryImpl eeLibraryImpl;
    private MultipleUsedMethodsImpl mumLibraryImpl;
    private CalculationLibraryImpl calLibraryImpl;

    public void evaluate(ValuePosition vPos, CalculationCase cCase) throws BusinessDomainException {
        this.calLibraryImpl = new CalculationLibraryImpl(vPos, cCase);
        this.eeLibraryImpl = new EmployeeLibraryImpl(vPos, cCase);
        GlobalLibraryImpl glLibraryImpl = ((IGlobalLibraryImplFactory)UtilitiesManager.getBean((String)"globalLibraryImplFactory", IGlobalLibraryImplFactory.class)).create(vPos, cCase, (EmployeeLibrary)this.eeLibraryImpl);
        ValuePositionLibraryImpl wpLibraryImpl = new ValuePositionLibraryImpl(vPos, cCase, (EmployeeLibrary)this.eeLibraryImpl);
        this.mumLibraryImpl = new MultipleUsedMethodsImpl((CalculationLibrary)this.calLibraryImpl, this.eeLibraryImpl, glLibraryImpl, (ValuePositionLibrary)wpLibraryImpl);
        BigDecimal mGrundlageAlt = vPos.getSumOfBasicResult();
        BigDecimal mErgebnisAlt = vPos.getSumOfResult();
        BigDecimal mGrundlageNeu = BigDecimal.ZERO;
        if (this.eeLibraryImpl.isTeilLZZVorhanden()) {
            switch (wpLibraryImpl.wertartenNummer()) {
                case 371210: 
                case 371220: 
                case 371230: {
                    if (!wpLibraryImpl.genesisParent().is23cPflichtig()) break;
                    vPos.setResult(this.korrektur23c(vPos.getResult()));
                    break;
                }
            }
        }
        mGrundlageNeu = mGrundlageAlt.add(vPos.getResult());
        this.calLibraryImpl.umlageEntgelt(mGrundlageNeu);
        new ErmittlungUmlageerstattungU1Formula((CalculationLibrary)this.calLibraryImpl, this.eeLibraryImpl, glLibraryImpl, (ValuePositionLibrary)wpLibraryImpl).ermittel();
        BigDecimal mErgebnisNeu = this.calLibraryImpl.result();
        boolean vergleich = true;
        switch (vPos.getValueType().getValueTypeKey()) {
            case 371610: 
            case 371620: 
            case 371630: {
                vergleich = false;
            }
        }
        ValuePosition nextVp = wpLibraryImpl.naechsteWP();
        if (nextVp == null) {
            ValueType vt = null;
            switch (vPos.getValueType().getValueTypeKey()) {
                case 371215: {
                    vt = ValueTypeHelper.getValueType(371210);
                    break;
                }
                case 371225: {
                    vt = ValueTypeHelper.getValueType(371220);
                    break;
                }
                case 371235: {
                    vt = ValueTypeHelper.getValueType(371230);
                }
            }
            if (vt != null) {
                nextVp = wpLibraryImpl.naechsteWP(vt);
            }
        }
        if (nextVp != null) {
            if (!BigDecimalMapper.isZeroOrNull((BigDecimal)wpLibraryImpl.parent().getPersistentBuffer5())) {
                nextVp.setPersistentBuffer5(wpLibraryImpl.parent().getPersistentBuffer5().add(vPos.getPersistentBuffer5()));
                nextVp.setSumOfBasicResult(vPos.getSumOfBasicResult());
            } else if (!BigDecimalMapper.isZeroOrNull((BigDecimal)mErgebnisNeu)) {
                nextVp.setSumOfBasicResult(mGrundlageNeu);
            }
            nextVp.setSumOfResult(mErgebnisNeu);
        }
        if (vergleich) {
            if (BigDecimalMapper.compareTo((BigDecimal)mErgebnisNeu, (BigDecimal)mErgebnisAlt) != 0) {
                vPos.setResult(mErgebnisNeu.subtract(mErgebnisAlt));
                vPos.setPercentage(this.calLibraryImpl.percentage());
                vPos.setFactor2(this.calLibraryImpl.factor2());
            } else {
                vPos.setResult(BigDecimal.ZERO);
                if (BigDecimalMapper.isZeroOrNull((BigDecimal)vPos.getPersistentBuffer4())) {
                    wpLibraryImpl.loescheWertPosition(vPos);
                }
            }
        } else if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.calLibraryImpl.result())) {
            vPos.setResult(this.calLibraryImpl.result());
            vPos.setPercentage(this.calLibraryImpl.percentage());
            vPos.setFactor2(this.calLibraryImpl.factor2());
        } else {
            vPos.setResult(BigDecimal.ZERO);
            if (BigDecimalMapper.isZeroOrNull((BigDecimal)vPos.getPersistentBuffer4())) {
                wpLibraryImpl.loescheWertPosition(vPos);
            }
        }
    }

    private BigDecimal korrektur23c(BigDecimal pResult) throws BusinessDomainException {
        switch (this.eeLibraryImpl.marbUmlageErstattungsberechnung().value()) {
            case 0: {
                return this.ermittleKalendertageK(pResult);
            }
            case 1: {
                return this.ermittleArbeitstageK(pResult);
            }
            case 2: {
                return this.ermittleArbeitsstundenK(pResult);
            }
        }
        return pResult;
    }

    private BigDecimal ermittleKalendertageK(BigDecimal pResult) throws BusinessDomainException {
        BigDecimal anzKalenderTage = BigDecimal.valueOf(new VDate(DateHelper.getLastDayOfMonth((Date)this.calLibraryImpl.berchnungGueltigAb())).getDay());
        return pResult.multiply(this.ermittelKalendertageMitarbeiter()).divide(anzKalenderTage, 6, RoundingMode.DOWN);
    }

    private BigDecimal ermittleArbeitstageK(BigDecimal pResult) throws BusinessDomainException {
        if (!BigDecimalMapper.isZero((BigDecimal)this.mumLibraryImpl.monatlicheKonkreteSolltageMitarbeiter())) {
            return pResult.multiply(this.mumLibraryImpl.monatlicheIsttageMitarbeiter()).divide(this.mumLibraryImpl.monatlicheKonkreteSolltageMitarbeiter(), 6, RoundingMode.DOWN);
        }
        return pResult;
    }

    private BigDecimal ermittleArbeitsstundenK(BigDecimal pResult) throws BusinessDomainException {
        if (!BigDecimalMapper.isZero((BigDecimal)this.mumLibraryImpl.monatlicheKonkreteSollstundenMitarbeiter())) {
            return pResult.multiply(this.mumLibraryImpl.monatlicheIstStundenMitarbeiter()).divide(this.mumLibraryImpl.monatlicheKonkreteSollstundenMitarbeiter(), 6, RoundingMode.DOWN);
        }
        return pResult;
    }

    private BigDecimal ermittelKalendertageMitarbeiter() throws BusinessDomainException {
        int i;
        int[] mDays = new int[new VDate(DateHelper.getLastDayOfMonth((Date)this.calLibraryImpl.berchnungGueltigAb())).getDay()];
        for (int i2 = 0; i2 < mDays.length; ++i2) {
            mDays[i2] = 1;
        }
        Date ersterDesMonats = DateHelper.getFirstDayOfMonth((Date)this.calLibraryImpl.berchnungGueltigAb());
        Date letzterDesMonats = DateHelper.getLastDayOfMonth((Date)this.calLibraryImpl.berchnungGueltigAb());
        if (this.eeLibraryImpl.marbAustritt() != null && DateHelper.between((Date)this.eeLibraryImpl.marbAustritt(), (Date)ersterDesMonats, (Date)letzterDesMonats)) {
            for (int i3 = new VDate(this.eeLibraryImpl.marbAustritt()).getDay(); i3 < mDays.length; ++i3) {
                mDays[i3] = 0;
            }
        }
        if (DateHelper.between((Date)this.eeLibraryImpl.marbEintritt(), (Date)ersterDesMonats, (Date)letzterDesMonats)) {
            int eintrittsTag = new VDate(this.eeLibraryImpl.marbEintritt()).getDay();
            for (i = 0; i < eintrittsTag - 1; ++i) {
                mDays[i] = 0;
            }
        }
        EEAbsentTimeTP[] fehlzeiten = this.eeLibraryImpl.aktuelleFehlzeiten();
        for (i = 0; i < fehlzeiten.length; ++i) {
            if (!fehlzeiten[i].getEEAbsentTime().getAbsentTime().getAbsentTimeTP(this.calLibraryImpl.berchnungWirksamAb(), this.calLibraryImpl.berchnungGueltigAb()).getCutByPartTimePayPeriod() || StringMapper.equal((String)fehlzeiten[i].getEEAbsentTime().getAbsentTime().getDEUVAbsentTimeKey(), (String)"9.9") && !this.vortagGekuerzt(fehlzeiten[i])) continue;
            int start = 0;
            int ende = mDays.length - 1;
            if (DateHelper.before((Date)fehlzeiten[i].getValidUntil(), (Date)ersterDesMonats) || DateHelper.after((Date)fehlzeiten[i].getValidFrom(), (Date)letzterDesMonats)) continue;
            if (DateHelper.between((Date)fehlzeiten[i].getValidFrom(), (Date)ersterDesMonats, (Date)letzterDesMonats)) {
                start = new VDate(fehlzeiten[i].getValidFrom()).getDay() - 1;
            }
            if (DateHelper.between((Date)fehlzeiten[i].getValidUntil(), (Date)ersterDesMonats, (Date)letzterDesMonats)) {
                ende = new VDate(fehlzeiten[i].getValidUntil()).getDay() - 1;
            }
            for (int j = start; j <= ende; ++j) {
                mDays[j] = 0;
            }
        }
        BigDecimal kalendertage = BigDecimal.ZERO;
        for (int i4 = 0; i4 < mDays.length; ++i4) {
            kalendertage = kalendertage.add(BigDecimal.valueOf(mDays[i4]));
        }
        return kalendertage;
    }

    private boolean vortagGekuerzt(EEAbsentTimeTP fehlzeit) throws BusinessDomainException {
        EEAbsentTimeTP[] vorFehlzeit;
        Date todesTag = fehlzeit.getValidFrom();
        for (EEAbsentTimeTP absentTimeTP : vorFehlzeit = this.eeLibraryImpl.marb().getEEAbsentTimesTP(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)this.eeLibraryImpl.marb().getObjectid()), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)this.calLibraryImpl.berchnungWirksamAb())), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)this.calLibraryImpl.berchnungWirksamAb())), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)DateHelper.yesterday((Date)todesTag))), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)DateHelper.yesterday((Date)todesTag)))}), true)) {
            if (!absentTimeTP.getEEAbsentTime().getAbsentTime().getAbsentTimeTP(this.calLibraryImpl.berchnungGueltigAb(), absentTimeTP.getValidUntil()).getCutByPartTimePayPeriod()) continue;
            return true;
        }
        return false;
    }
}

