/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.employee.valueposition;

import com.varial.base.UtilitiesManager;
import com.varial.base.exception.ApplicationException;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.PersistentBusinessObject;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Order;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.session.SessionContext;
import com.varial.base.types.date.DateHelper;
import com.varial.framework.domain.taskreminder.TaskReminder;
import com.varial.personnel.domain.absenttime.AbsentTimeTP;
import com.varial.personnel.domain.absenttime.TypeOfDeliveryEnum;
import com.varial.personnel.domain.calculation.CalculationBasic;
import com.varial.personnel.domain.calculation.CalculationCase;
import com.varial.personnel.domain.calculation.MKPosition;
import com.varial.personnel.domain.calculation.TypeOfCalculationCase;
import com.varial.personnel.domain.designationtype.costcenter.CostCenter;
import com.varial.personnel.domain.designationtype.costunit.CostUnit;
import com.varial.personnel.domain.deuv.deuvaccount.adviceable.Validityable;
import com.varial.personnel.domain.employee.Employee;
import com.varial.personnel.domain.employee.IEmployeePersistencyManager;
import com.varial.personnel.domain.employee.IEmployeeReferenced;
import com.varial.personnel.domain.employee.absenttime.EEAbsentTimeTP;
import com.varial.personnel.domain.employee.advancepayment.AdvancePaymentTP;
import com.varial.personnel.domain.employee.attachment.EEAttachmentTP;
import com.varial.personnel.domain.employee.attachment.ModeOfAttachmentEnum;
import com.varial.personnel.domain.employee.dataera.EEDataERA;
import com.varial.personnel.domain.employee.employment.Employment;
import com.varial.personnel.domain.employee.fixedpayment.FixedPaymentTP;
import com.varial.personnel.domain.employee.loan.EELoanTP;
import com.varial.personnel.domain.employee.materialexpenses.EEMaterialExpensesTP;
import com.varial.personnel.domain.employee.materialexpenses.TypeOfCalculation;
import com.varial.personnel.domain.employee.materialexpenses.car.TypeOfVehicle;
import com.varial.personnel.domain.employee.materialexpenses.ebike.TypeOfFinancing;
import com.varial.personnel.domain.employee.paymentdeduction.EEPaymentDeductionTP;
import com.varial.personnel.domain.employee.pensionscheme.EEPensionSchemeTP;
import com.varial.personnel.domain.employee.piecework.EEPieceWorkTP;
import com.varial.personnel.domain.employee.relative.EERelativeTP;
import com.varial.personnel.domain.employee.scalepayment.ScalePaymentTP;
import com.varial.personnel.domain.employee.valueposition.Originator;
import com.varial.personnel.domain.employee.valueposition.OriginatorFactory;
import com.varial.personnel.domain.employee.valueposition.ValuePositionData;
import com.varial.personnel.domain.employee.valueposition.ValuePositionHistory;
import com.varial.personnel.domain.employee.valueposition.ValuePositionPersistencyManager;
import com.varial.personnel.domain.employee.varpayment.VarPaymentTP;
import com.varial.personnel.domain.employee.work.EEWork;
import com.varial.personnel.domain.evaluation.EvaluationFormula;
import com.varial.personnel.domain.evaluation.mapper.EvaluationExceptionMapper;
import com.varial.personnel.domain.global.childallowance.ChildAllowance;
import com.varial.personnel.domain.global.childallowance.ChildAllowanceTP;
import com.varial.personnel.domain.global.eramodel.ERAModel;
import com.varial.personnel.domain.global.eramodel.ERAModelTP;
import com.varial.personnel.domain.global.materialmodel.MaterialExpensesModel;
import com.varial.personnel.domain.global.materialmodel.MaterialExpensesModelTP;
import com.varial.personnel.domain.payscale.payscalegroup.PayScaleGroup;
import com.varial.personnel.domain.payscale.payscalegroup.PayScaleGroupTP;
import com.varial.personnel.domain.payscale.payscalegroup.PayScaleLevel;
import com.varial.personnel.domain.plant.Plant;
import com.varial.personnel.domain.typeofvalue.ValueType;
import com.varial.personnel.domain.typeofvalue.ValueTypeTP;
import com.varial.personnel.domain.typeofvalue.basictypes.CategoryEnum;
import com.varial.personnel.domain.typeofvalue.basictypes.ERAEvaluationEnum;
import com.varial.personnel.domain.typeofvalue.consequenceofvaluetype.ConsequenceOfValueType;
import com.varial.personnel.domain.typeofvalue.evaluation.TypeOfPieceWorkEnum;
import com.varial.personnel.domain.typeofvalue.foundation.general.FoundationGeneral;
import com.varial.personnel.domain.workingtime.WorkingTime;
import com.varial.personnel.framework.IEvaluationFormulaFactory;
import com.varial.personnel.framework.PersonnelHistory;
import com.varial.personnel.framework.PersonnelTimedPersistenceObject;
import com.varial.personnel.framework.basictypes.Interval;
import com.varial.personnel.framework.basictypes.PDateHelper;
import com.varial.personnel.framework.mapper.FrameWorkExceptionMapper;
import com.varial.personnel.framework.taskreminder.TaskReminderHelper;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.ExceptionMapper;
import com.varial.serverbase.mapper.StringMapper;
import com.varial.serverbase.persistency.PersistentObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ValuePosition
extends PersonnelTimedPersistenceObject
implements Cloneable,
Validityable,
IEmployeeReferenced {
    public static final String CLASSNAME = ValuePosition.class.getName();
    private static final ValuePosition[] EMPTY_VP_ARRAY = new ValuePosition[0];
    private static final int PRIORITY = 115;
    private static final BigDecimal EINHUNDERT = BigDecimal.valueOf(100L);
    private static boolean usePaidPublicHoliday = false;
    private Employee mEmployee;
    private ValueType mValueType;
    private PersistentObject mParentObject;
    private PersistentObject mGenesisOfParentObjects;
    private BigDecimal mFactor1;
    private BigDecimal mFactor2;
    private BigDecimal mResult;
    private BigDecimal mPercentage;
    private BigDecimal mPerformanceFactor;
    private CostCenter mCostCenter;
    private CostUnit mCostUnit;
    private BigDecimal mPersistentBuffer1;
    private BigDecimal mPersistentBuffer2;
    private BigDecimal mPersistentBuffer3;
    private BigDecimal mPersistentBuffer4;
    private BigDecimal mPersistentBuffer5;
    private BigDecimal mEraCorrectionFactor;
    private BigDecimal mEraValue;
    private Date mDocumentDate;
    private String mDocumentNumber;
    private String mOrderNumber;
    private String mPartNumber;
    private BigDecimal mSetupTimeAndUnit = BigDecimal.ZERO;
    private BigDecimal mYield = BigDecimal.ZERO;
    private BigDecimal mTargetOfTimeAndUnit = BigDecimal.ZERO;
    private BigDecimal mTotalTarget = BigDecimal.ZERO;
    private BigDecimal mRateOfLaborUtilisation = BigDecimal.ZERO;
    private Date mBookingDate;
    private String mStageNumber;
    private boolean mToAnalyze = true;
    private PersistentObject mRootGenesisOfParentObjects;
    private BigDecimal mBasicFactor1;
    private BigDecimal mBasicFactor2;
    private BigDecimal mBasicResult;
    private BigDecimal mBasicPercentage;
    private BigDecimal mBasicPerformanceFactor;
    private CostCenter mBasicCostCenter;
    private CostUnit mBasicCostUnit;
    private BigDecimal mBufferFactor1;
    private BigDecimal mBufferFactor2;
    private BigDecimal mBufferResult;
    private BigDecimal mBufferPercentage;
    private BigDecimal mBufferPerformanceFactor;
    private CostCenter mBufferCostCenter;
    private CostUnit mBufferCostUnit;
    private BigDecimal mBufferField01 = BigDecimal.ZERO;
    private BigDecimal mBufferField02 = BigDecimal.ZERO;
    private BigDecimal mBufferField03 = BigDecimal.ZERO;
    private BigDecimal mBufferField04 = BigDecimal.ZERO;
    private BigDecimal mBufferField05 = BigDecimal.ZERO;
    private BigDecimal mSumOfResult = BigDecimal.ZERO;
    private BigDecimal mSumOfBasicResult = BigDecimal.ZERO;
    private BigDecimal mSumOfBasicResult23c = BigDecimal.ZERO;
    private String mOldObjectid;
    private int mRanking = 0;
    private boolean mIsDeleteInCalculationCase = false;
    private boolean mIsLimitedInCalculationCase = false;
    private boolean mIsLimitedInEffectivenessInCalculationCase = false;
    private boolean mIsLimitedInValidnessInCalculationCase = false;
    private boolean evaluateComplete = false;
    private boolean evaluateFactor1 = false;
    private boolean evaluateFactor2 = false;
    private boolean evaluateResult = false;
    private boolean netWageIsConsequence = false;
    private boolean resultOfGrossWageConversion = false;
    private boolean mSignedAsClauseOfMarch = false;
    private Date zufluss = null;
    private boolean mSignedAsInCalculation = false;
    private boolean mGrosswageFor23c = false;
    private Date sortDate = null;
    private int secondaryRankingnumber = 0;
    private boolean mBvCopied = false;
    private boolean m23cPflichtig = false;

    public ValuePosition(String objectid) {
        super(115, objectid);
    }

    public ValuePosition(String objectid, int version) {
        super(115, objectid, version);
    }

    public ValuePosition(boolean readOnly) {
        super(115, readOnly);
    }

    public ValuePosition() {
        super(115);
    }

    public ValuePosition(Employee employee, ValueType valueType, PersistentObject parentObject, PersistentObject genesisOfParentObjects) {
        super(115);
        this.mEmployee = employee;
        this.mValueType = valueType;
        this.mParentObject = parentObject;
        this.mGenesisOfParentObjects = genesisOfParentObjects;
    }

    public ValuePosition(Employee employee, ValueType valueType, PersistentObject parentObject, PersistentObject genesisOfParentObjects, PersistentObject rootGenesisOfParentObjects) {
        super(115);
        this.mEmployee = employee;
        this.mValueType = valueType;
        this.mParentObject = parentObject;
        this.mGenesisOfParentObjects = genesisOfParentObjects;
        this.mRootGenesisOfParentObjects = rootGenesisOfParentObjects;
    }

    public static ValuePosition getValuePosition(String objectid) {
        return new ValuePosition(objectid);
    }

    protected void load() {
        ValuePositionPersistencyManager.load((ValuePosition)this);
    }

    protected void saveImpl() throws BusinessDomainException {
        ValuePositionPersistencyManager.save((ValuePosition)this);
    }

    protected void deleteImpl() {
        ValuePositionPersistencyManager.delete((ValuePosition)this);
    }

    public String getClassName() {
        return this.getClass().getName();
    }

    public String getDomainKey() {
        this.requireLoaded();
        return new StringBuffer().append(this.mValueType.getDomainKey()).append(" / ").append(DateMapper.toString((Date)this.mEffectiveFrom)).append(" / ").append(DateMapper.toString((Date)this.mValidFrom)).toString();
    }

    public void setEffectiveFrom(Date effectiveFrom) {
        this.mEffectiveFrom = effectiveFrom;
    }

    public void setEffectiveUntil(Date effectiveUntil) {
        this.mEffectiveUntil = effectiveUntil;
    }

    public void setValidFrom(Date validFrom) {
        this.mValidFrom = validFrom;
    }

    public void setValidUntil(Date validUntil) {
        this.mValidUntil = validUntil;
    }

    public Employee getEmployee() {
        this.requireLoaded();
        return this.mEmployee;
    }

    public void setEmployee(Employee employee) {
        this.mEmployee = employee;
    }

    public ValueType getValueType() {
        this.requireLoaded();
        return this.mValueType;
    }

    public void setValueType(ValueType valueType) {
        this.mValueType = valueType;
    }

    public PersistentObject getParentObject() {
        this.requireLoaded();
        return this.mParentObject;
    }

    public void setParentObject(PersistentObject parentObject) {
        this.mParentObject = parentObject;
    }

    public PersistentObject getGenesisOfParentObjects() {
        this.requireLoaded();
        return this.mGenesisOfParentObjects;
    }

    public void setGenesisOfParentObjects(PersistentObject genesisOfParentObjects) {
        this.mGenesisOfParentObjects = genesisOfParentObjects;
    }

    public PersistentObject getRootGenesisOfParentObjects() {
        this.requireLoaded();
        return this.mRootGenesisOfParentObjects;
    }

    public void setRootGenesisOfParentObjects(PersistentObject rootGenesisOfParentObjects) {
        this.mRootGenesisOfParentObjects = rootGenesisOfParentObjects;
    }

    public BigDecimal getFactor1() {
        this.requireLoaded();
        return this.mFactor1;
    }

    public void setFactor1(BigDecimal factor1) {
        this.mFactor1 = factor1;
    }

    public BigDecimal getFactor2() {
        this.requireLoaded();
        return this.mFactor2;
    }

    public void setFactor2(BigDecimal factor2) {
        this.mFactor2 = factor2;
    }

    public BigDecimal getResult() {
        this.requireLoaded();
        return this.mResult;
    }

    public void setResult(BigDecimal result) {
        this.mResult = result;
    }

    public BigDecimal getPercentage() {
        this.requireLoaded();
        return this.mPercentage;
    }

    public void setPercentage(BigDecimal percentage) {
        this.mPercentage = percentage;
    }

    public BigDecimal getPerformanceFactor() {
        this.requireLoaded();
        return this.mPerformanceFactor;
    }

    public void setPerformanceFactor(BigDecimal performanceFactor) {
        this.mPerformanceFactor = performanceFactor;
    }

    public CostCenter getCostCenter() {
        this.requireLoaded();
        return this.mCostCenter;
    }

    public void setCostCenter(CostCenter costCenter) {
        this.mCostCenter = costCenter;
    }

    public CostUnit getCostUnit() {
        this.requireLoaded();
        return this.mCostUnit;
    }

    public void setCostUnit(CostUnit costUnit) {
        this.mCostUnit = costUnit;
    }

    public BigDecimal getPersistentBuffer1() {
        this.requireLoaded();
        return this.mPersistentBuffer1;
    }

    public void setPersistentBuffer1(BigDecimal persistentBuffer1) {
        this.mPersistentBuffer1 = persistentBuffer1;
    }

    public BigDecimal getPersistentBuffer2() {
        this.requireLoaded();
        return this.mPersistentBuffer2;
    }

    public void setPersistentBuffer2(BigDecimal persistentBuffer2) {
        this.mPersistentBuffer2 = persistentBuffer2;
    }

    public BigDecimal getPersistentBuffer3() {
        this.requireLoaded();
        return this.mPersistentBuffer3;
    }

    public void setPersistentBuffer3(BigDecimal persistentBuffer3) {
        this.mPersistentBuffer3 = persistentBuffer3;
    }

    public BigDecimal getPersistentBuffer4() {
        this.requireLoaded();
        return this.mPersistentBuffer4;
    }

    public void setPersistentBuffer4(BigDecimal persistentBuffer4) {
        this.mPersistentBuffer4 = persistentBuffer4;
    }

    public BigDecimal getPersistentBuffer5() {
        this.requireLoaded();
        return this.mPersistentBuffer5;
    }

    public void setPersistentBuffer5(BigDecimal persistentBuffer5) {
        this.mPersistentBuffer5 = persistentBuffer5;
    }

    public BigDecimal getEraCorrectionFactor() {
        this.requireLoaded();
        return this.mEraCorrectionFactor;
    }

    public void setEraCorrectionFactor(BigDecimal eraCorrectionFactor) {
        this.mEraCorrectionFactor = eraCorrectionFactor;
    }

    public BigDecimal getEraValue() {
        this.requireLoaded();
        return this.mEraValue;
    }

    public void setEraValue(BigDecimal eraValue) {
        this.mEraValue = eraValue;
    }

    public Date getDocumentDate() {
        this.requireLoaded();
        return this.mDocumentDate;
    }

    public void setDocumentDate(Date documentDate) {
        this.mDocumentDate = documentDate;
    }

    public String getDocumentNumber() {
        this.requireLoaded();
        return this.mDocumentNumber;
    }

    public void setDocumentNumber(String documentNumber) {
        this.mDocumentNumber = documentNumber;
    }

    public String getOrderNumber() {
        this.requireLoaded();
        return this.mOrderNumber;
    }

    public void setOrderNumber(String orderNumber) {
        this.mOrderNumber = orderNumber;
    }

    public String getPartNumber() {
        this.requireLoaded();
        return this.mPartNumber;
    }

    public void setPartNumber(String partNumber) {
        this.mPartNumber = partNumber;
    }

    public BigDecimal getSetupTimeAndUnit() {
        this.requireLoaded();
        return this.mSetupTimeAndUnit == null ? new BigDecimal("0.00") : this.mSetupTimeAndUnit;
    }

    public void setSetupTimeAndUnit(BigDecimal setupTimeAndUnit) {
        this.mSetupTimeAndUnit = setupTimeAndUnit;
    }

    public BigDecimal getYield() {
        this.requireLoaded();
        return this.mYield == null ? new BigDecimal("0.00") : this.mYield;
    }

    public void setYield(BigDecimal yield) {
        this.mYield = yield;
    }

    public BigDecimal getTargetOfTimeAndUnit() {
        this.requireLoaded();
        return this.mTargetOfTimeAndUnit == null ? new BigDecimal("0.00") : this.mTargetOfTimeAndUnit;
    }

    public void setTargetOfTimeAndUnit(BigDecimal targetOfTimeAndUnit) {
        this.mTargetOfTimeAndUnit = targetOfTimeAndUnit;
    }

    public BigDecimal getTotalTarget() {
        this.requireLoaded();
        return this.mTotalTarget == null ? new BigDecimal("0.00") : this.mTotalTarget;
    }

    public void setTotalTarget(BigDecimal totalTarget) {
        this.mTotalTarget = totalTarget;
    }

    public BigDecimal getRateOfLaborUtilisation() {
        this.requireLoaded();
        return this.mRateOfLaborUtilisation == null ? new BigDecimal("0.00") : this.mRateOfLaborUtilisation;
    }

    public void setRateOfLaborUtilisation(BigDecimal rateOfLaborUtilisation) {
        this.mRateOfLaborUtilisation = rateOfLaborUtilisation;
    }

    public Date getBookingDate() {
        this.requireLoaded();
        return this.mBookingDate;
    }

    public void setBookingDate(Date bookingDate) {
        this.mBookingDate = bookingDate;
    }

    public String getStageNumber() {
        this.requireLoaded();
        return this.mStageNumber;
    }

    public void setStageNumber(String stageNumber) {
        this.mStageNumber = stageNumber;
    }

    public boolean isToAnalyze() {
        this.requireLoaded();
        return this.mToAnalyze;
    }

    public void setToAnalyze(boolean toAnalyze) {
        this.mToAnalyze = toAnalyze;
    }

    public BigDecimal getBasicFactor1() {
        return this.mBasicFactor1;
    }

    public void setBasicFactor1(BigDecimal basicFactor1) {
        this.mBasicFactor1 = basicFactor1;
    }

    public BigDecimal getBasicFactor2() {
        return this.mBasicFactor2;
    }

    public void setBasicFactor2(BigDecimal basicFactor2) {
        this.mBasicFactor2 = basicFactor2;
    }

    public BigDecimal getBasicResult() {
        return this.mBasicResult;
    }

    public void setBasicResult(BigDecimal basicResult) {
        this.mBasicResult = basicResult;
    }

    public BigDecimal getBasicPercentage() {
        return this.mBasicPercentage;
    }

    public void setBasicPercentage(BigDecimal basicPercentage) {
        this.mBasicPercentage = basicPercentage;
    }

    public BigDecimal getBasicPerformanceFactor() {
        return this.mBasicPerformanceFactor;
    }

    public void setBasicPerformanceFactor(BigDecimal basicPerformanceFactor) {
        this.mBasicPerformanceFactor = basicPerformanceFactor;
    }

    public CostCenter getBasicCostCenter() {
        return this.mBasicCostCenter;
    }

    public void setBasicCostCenter(CostCenter basicCostCenter) {
        this.mBasicCostCenter = basicCostCenter;
    }

    public CostUnit getBasicCostUnit() {
        return this.mBasicCostUnit;
    }

    public void setBasicCostUnit(CostUnit basicCostUnit) {
        this.mBasicCostUnit = basicCostUnit;
    }

    public BigDecimal getBufferFactor1() {
        return this.mBufferFactor1;
    }

    public void setBufferFactor1(BigDecimal bufferFactor1) {
        this.mBufferFactor1 = bufferFactor1;
    }

    public BigDecimal getBufferFactor2() {
        return this.mBufferFactor2;
    }

    public void setBufferFactor2(BigDecimal bufferFactor2) {
        this.mBufferFactor2 = bufferFactor2;
    }

    public BigDecimal getBufferResult() {
        return this.mBufferResult;
    }

    public void setBufferResult(BigDecimal bufferResult) {
        this.mBufferResult = bufferResult;
    }

    public BigDecimal getBufferPercentage() {
        return this.mBufferPercentage;
    }

    public void setBufferPercentage(BigDecimal bufferPercentage) {
        this.mBufferPercentage = bufferPercentage;
    }

    public BigDecimal getBufferPerformanceFactor() {
        return this.mBufferPerformanceFactor;
    }

    public void setBufferPerformanceFactor(BigDecimal bufferPerformanceFactor) {
        this.mBufferPerformanceFactor = bufferPerformanceFactor;
    }

    public CostCenter getBufferCostCenter() {
        return this.mBufferCostCenter;
    }

    public void setBufferCostCenter(CostCenter bufferCostCenter) {
        this.mBufferCostCenter = bufferCostCenter;
    }

    public CostUnit getBufferCostUnit() {
        return this.mBufferCostUnit;
    }

    public void setBufferCostUnit(CostUnit bufferCostUnit) {
        this.mBufferCostUnit = bufferCostUnit;
    }

    public BigDecimal getBufferField01() {
        return this.mBufferField01;
    }

    public void setBufferField01(BigDecimal bufferField01) {
        this.mBufferField01 = bufferField01;
    }

    public BigDecimal getBufferField02() {
        return this.mBufferField02;
    }

    public void setBufferField02(BigDecimal bufferField02) {
        this.mBufferField02 = bufferField02;
    }

    public BigDecimal getBufferField03() {
        return this.mBufferField03;
    }

    public void setBufferField03(BigDecimal bufferFiled03) {
        this.mBufferField03 = bufferFiled03;
    }

    public BigDecimal getBufferField04() {
        return this.mBufferField04;
    }

    public void setBufferField04(BigDecimal bufferField04) {
        this.mBufferField04 = bufferField04;
    }

    public BigDecimal getBufferField05() {
        return this.mBufferField05;
    }

    public void setBufferField05(BigDecimal bufferField05) {
        this.mBufferField05 = bufferField05;
    }

    public BigDecimal getSumOfResult() {
        if (this.mSumOfResult == null) {
            return BigDecimal.ZERO;
        }
        return this.mSumOfResult;
    }

    public void setSumOfResult(BigDecimal sumOfResult) {
        this.mSumOfResult = sumOfResult;
    }

    public BigDecimal getSumOfBasicResult() {
        if (this.mSumOfBasicResult == null) {
            return BigDecimal.ZERO;
        }
        return this.mSumOfBasicResult;
    }

    public void setSumOfBasicResult(BigDecimal sumOfBasicResult) {
        this.mSumOfBasicResult = sumOfBasicResult;
    }

    public BigDecimal getSumOfBasicResult23c() {
        if (this.mSumOfBasicResult23c == null) {
            return BigDecimal.ZERO;
        }
        return this.mSumOfBasicResult23c;
    }

    public void setSumOfBasicResult23c(BigDecimal sumOfBasicResult23c) {
        this.mSumOfBasicResult23c = sumOfBasicResult23c;
    }

    public String getOldObjectid() {
        return this.mOldObjectid;
    }

    public boolean getIsDeleteInCalculationCase() {
        return this.mIsDeleteInCalculationCase;
    }

    public void setIsDeleteInCalculationCase(boolean isDeleteInCalculationCase) {
        this.mIsDeleteInCalculationCase = isDeleteInCalculationCase;
    }

    public boolean getIsLimitedInCalculationCase() {
        return this.mIsLimitedInCalculationCase;
    }

    public void setIsLimitedInCalculationCase(boolean isLimitedInCalculationCase) {
        this.mIsLimitedInCalculationCase = isLimitedInCalculationCase;
    }

    public boolean getIsLimitedInEffectivenessInCalculationCase() {
        return this.mIsLimitedInEffectivenessInCalculationCase;
    }

    public void setIsLimitedInEffectivenessInCalculationCase(boolean isLimitedInEffectivenessInCalculationCase) {
        this.mIsLimitedInEffectivenessInCalculationCase = isLimitedInEffectivenessInCalculationCase;
    }

    public boolean getIsLimitedInValidnessInCalculationCase() {
        return this.mIsLimitedInValidnessInCalculationCase;
    }

    public void setIsLimitedInValidnessInCalculationCase(boolean isLimitedInValidnessInCalculationCase) {
        this.mIsLimitedInValidnessInCalculationCase = isLimitedInValidnessInCalculationCase;
    }

    public boolean getEvaluateFactor1() {
        return this.evaluateFactor1;
    }

    public void setEvaluateFactor1(boolean bool) {
        this.evaluateFactor1 = bool;
    }

    public boolean getEvaluateFactor2() {
        return this.evaluateFactor2;
    }

    public void setEvaluateFactor2(boolean bool) {
        this.evaluateFactor2 = bool;
    }

    public boolean getEvaluateResult() {
        return this.evaluateResult;
    }

    public void setEvaluateResult(boolean bool) {
        this.evaluateResult = bool;
    }

    public boolean getEvaluateComplete() {
        return this.evaluateComplete;
    }

    public void setEvaluateComplete(boolean bool) {
        this.evaluateComplete = bool;
    }

    public boolean getNetWageIsConsequence() {
        return this.netWageIsConsequence;
    }

    public void setNetWageIsConsequence(boolean bool) {
        this.netWageIsConsequence = bool;
    }

    public boolean getResultOfGrossWageConversion() {
        return this.resultOfGrossWageConversion;
    }

    public void setResultOfGrossWageConversion(boolean bool) {
        this.resultOfGrossWageConversion = bool;
    }

    public int getRanking() throws BusinessDomainException {
        if (this.mRanking == 0) {
            this.mRanking = ValuePosition.getRankingNumber(this, this.getEffectiveFrom(), this.getValidFrom());
        }
        return this.mRanking;
    }

    public void setRanking(int ranking) throws BusinessDomainException {
        this.mRanking = ranking;
    }

    public static int getRankingNumber(ValuePosition vp, Date effectiveFrom, Date validFrom) throws BusinessDomainException {
        if (vp.getValueType() == null) {
            return 0;
        }
        return vp.getValueType().getValueTypeTP(effectiveFrom, validFrom).getValueTypeFoundation().getGeneral().getRankingNumber();
    }

    public static CategoryEnum getCategory(ValuePosition vp, Date effectiveFrom, Date validFrom) throws BusinessDomainException {
        return vp.getValueType().getValueTypeTP(effectiveFrom, validFrom).getValueTypeFoundation().getGeneral().getCategory();
    }

    protected void setData(ValuePositionData data) {
        this.mEffectiveFrom = data.getEffectiveFrom();
        this.mEffectiveUntil = data.getEffectiveUntil();
        this.mValidFrom = data.getValidFrom();
        this.mValidUntil = data.getValidUntil();
        this.mFactor1 = data.getFactor1();
        this.mFactor2 = data.getFactor2();
        this.mResult = data.getResult();
        this.mPercentage = data.getPercentage();
        this.mPerformanceFactor = data.getPerformanceFactor();
        this.mCostCenter = data.getCostCenter();
        this.mCostUnit = data.getCostUnit();
        this.mPersistentBuffer1 = data.getPersistentBuffer1();
        this.mPersistentBuffer2 = data.getPersistentBuffer2();
        this.mPersistentBuffer3 = data.getPersistentBuffer3();
        this.mPersistentBuffer4 = data.getPersistentBuffer4();
        this.mPersistentBuffer5 = data.getPersistentBuffer5();
        this.mEraCorrectionFactor = data.getEraCorrectionFactor();
        this.mEraValue = data.getEraValue();
        this.mDocumentDate = data.getDocumentDate();
        this.mDocumentNumber = data.getDocumentNumber();
        this.mOrderNumber = data.getOrderNumber();
        this.mPartNumber = data.getPartNumber();
        this.mSetupTimeAndUnit = data.getSetupTimeAndUnit();
        this.mYield = data.getYield();
        this.mTargetOfTimeAndUnit = data.getTargetOfTimeAndUnit();
        this.mTotalTarget = data.getTotalTarget();
        this.mRateOfLaborUtilisation = data.getRateOfLaborUtilisation();
        this.mBookingDate = data.getBookingDate();
        this.mStageNumber = data.getStageNumber();
        this.mToAnalyze = data.isToAnalyze();
    }

    public static ValuePosition[] getValuePositions(Order[] sortierung, Criterion filters) {
        return ValuePositionPersistencyManager.getValuePositions((Order[])sortierung, (Criterion)filters);
    }

    public static ValuePosition getValuePosition(PersistentObject genesis, int valuetypeNumber) {
        int parentType = 0;
        if (genesis != null) {
            ValuePosition[] vpArray;
            Originator originator = ValuePosition.getOriginatorFactory().valueOf(genesis.getClass().getName());
            if (originator != null) {
                parentType = originator.getPersistentValue();
            }
            if ((vpArray = ValuePositionPersistencyManager.query(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidgenesisparent", (String)genesis.getObjectid()), Restrictions.eq((String)"genesisparenttype", (String)String.valueOf(parentType)), Restrictions.eq((String)"valuetypenumber", (String)Integer.toString(valuetypeNumber))}))).length != 1) {
                return null;
            }
            return vpArray[0];
        }
        return null;
    }

    public static ValuePosition[] getValuePositionen(String oidEmployee, Date effectiveFrom, Date effectiveUntil, Date validFrom, Date validUntil) {
        return ValuePositionPersistencyManager.getValuePositions(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)oidEmployee), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)effectiveUntil)), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)effectiveFrom)), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)validUntil)), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)validFrom))}));
    }

    public static ValuePosition[] getValuePositions(String oidEmployee, Date effectiveFrom, Date effectiveUntil, Date validFrom, Date validUntil, int valuetypeNumber) {
        return ValuePositionPersistencyManager.getValuePositions(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)oidEmployee), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)effectiveUntil)), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)effectiveFrom)), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)validUntil)), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)validFrom)), Restrictions.eq((String)"valuetypenumber", (String)Integer.toString(valuetypeNumber))}));
    }

    public static ValuePosition[] getValuePositionen(String oidEmployee, String oidValueType, Date effectiveTimePoint, Date validTimePoint) {
        return ValuePosition.getValuePositions(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)oidEmployee), Restrictions.eq((String)"oidValuetype", (String)oidValueType), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)effectiveTimePoint))), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)effectiveTimePoint))), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)validTimePoint))), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)validTimePoint)))}));
    }

    public static ValuePosition[] getValuePositionsInside(String oidEmployee, String oidValueType, Date effectiveTimePoint, Date validTimePoint) {
        return ValuePosition.getValuePositions(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)oidEmployee), Restrictions.eq((String)"oidValuetype", (String)oidValueType), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)effectiveTimePoint))), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)effectiveTimePoint))), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)validTimePoint))), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)validTimePoint)))}));
    }

    public static ValuePosition[] getValuePositionen(String oidValueType, Date effectiveTimePoint, Date validTimePoint) {
        return ValuePosition.getValuePositions(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidValuetype", (String)oidValueType), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)effectiveTimePoint)), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)validTimePoint))}));
    }

    public static ValuePosition[] getValuePositions(String oidEmployee, Date effectiveTimePoint, Date validTimePoint) {
        return ValuePosition.getValuePositions(new Order[]{Order.asc((String)"rankingnumber")}, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)oidEmployee), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)effectiveTimePoint))), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)effectiveTimePoint))), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)validTimePoint))), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)validTimePoint)))}));
    }

    public static ValuePosition[] getDifferencesOfNet(String oidEmployee, Date effectiveTimePoint, Date validTimePoint) {
        return ValuePositionPersistencyManager.query(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)oidEmployee), Restrictions.eq((String)"effectiveFrom", (String)DateMapper.toString((Date)effectiveTimePoint)), Restrictions.le((String)"validFrom", (String)DateMapper.toString((Date)validTimePoint)), Restrictions.eq((String)"oidvaluetype", (String)Integer.toString(882110))}));
    }

    public static ValuePosition[] getNotJournalizeVPs(String oidEmployee, Date effectiveTimePoint, Date validTimePoint) {
        return ValuePositionPersistencyManager.query(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)oidEmployee), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)effectiveTimePoint)), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)validTimePoint))}));
    }

    public static ValuePosition[] getVPsOf99998(String oidEmployee, Date timePoint) {
        return ValuePositionPersistencyManager.queryWithOutSort((Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)oidEmployee), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)timePoint)), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)timePoint)), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)timePoint)), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)timePoint)), Restrictions.eq((String)"VALUETYPENUMBER", (String)Integer.toString(99998))}));
    }

    public static ValuePosition[] getVPsOf99992(String oidEmployee, Date timePoint) {
        return ValuePositionPersistencyManager.queryWithOutSort((Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)oidEmployee), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)timePoint)), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)timePoint)), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)timePoint)), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)timePoint)), Restrictions.eq((String)"VALUETYPENUMBER", (String)Integer.toString(99992))}));
    }

    public static ValuePosition[] getValuePositionen(String oidEmployee, CategoryEnum category, Date effectiveTimePoint, Date validTimePoint) {
        return ValuePosition.getValuePositions(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)oidEmployee), Restrictions.eq((String)"category", (String)Integer.toString(category.value())), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)effectiveTimePoint))), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)effectiveTimePoint))), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)validTimePoint))), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)validTimePoint)))}));
    }

    public PersonnelTimedPersistenceObject createNew() {
        ValuePosition vp = new ValuePosition(this.mEmployee, this.mValueType, this.mParentObject, this.mGenesisOfParentObjects, this.mRootGenesisOfParentObjects);
        vp.mEffectiveFrom = this.mEffectiveFrom;
        vp.mEffectiveUntil = this.mEffectiveUntil;
        vp.mValidFrom = this.mValidFrom;
        vp.mValidUntil = this.mValidUntil;
        vp.mFactor1 = this.mFactor1;
        vp.mFactor2 = this.mFactor2;
        vp.mResult = this.mResult;
        vp.mPercentage = this.mPercentage;
        vp.mPerformanceFactor = this.mPerformanceFactor;
        vp.mCostCenter = this.mCostCenter;
        vp.mCostUnit = this.mCostUnit;
        vp.mPersistentBuffer1 = this.mPersistentBuffer1;
        vp.mPersistentBuffer2 = this.mPersistentBuffer2;
        vp.mPersistentBuffer3 = this.mPersistentBuffer3;
        vp.mPersistentBuffer4 = this.mPersistentBuffer4;
        vp.mPersistentBuffer5 = this.mPersistentBuffer5;
        vp.mEraCorrectionFactor = this.mEraCorrectionFactor;
        vp.mEraValue = this.mEraValue;
        vp.mDocumentDate = this.mDocumentDate;
        vp.mDocumentNumber = this.mDocumentNumber;
        vp.mOrderNumber = this.mOrderNumber;
        vp.mPartNumber = this.mPartNumber;
        vp.mSetupTimeAndUnit = this.mSetupTimeAndUnit;
        vp.mYield = this.mYield;
        vp.mTargetOfTimeAndUnit = this.mTargetOfTimeAndUnit;
        vp.mTotalTarget = this.mTotalTarget;
        vp.mRateOfLaborUtilisation = this.mRateOfLaborUtilisation;
        vp.mBookingDate = this.mBookingDate;
        vp.mStageNumber = this.mStageNumber;
        vp.mBasicFactor1 = this.mBasicFactor1;
        vp.mBasicFactor2 = this.mBasicFactor2;
        vp.mBasicResult = this.mBasicResult;
        vp.mBasicPercentage = this.mBasicPercentage;
        vp.mBasicPerformanceFactor = this.mBasicPerformanceFactor;
        vp.mBasicCostCenter = this.mBasicCostCenter;
        vp.mBasicCostUnit = this.mBasicCostUnit;
        vp.mBufferFactor1 = this.mBufferFactor1;
        vp.mBufferFactor2 = this.mBufferFactor2;
        vp.mBufferResult = this.mBufferResult;
        vp.mBufferPercentage = this.mBufferPercentage;
        vp.mBufferPerformanceFactor = this.mBufferPerformanceFactor;
        vp.mBufferCostCenter = this.mBufferCostCenter;
        vp.mBufferCostUnit = this.mBufferCostUnit;
        vp.mSumOfBasicResult = this.getSumOfBasicResult();
        vp.mSumOfResult = this.getSumOfResult();
        vp.mToAnalyze = this.mToAnalyze;
        vp.mOldObjectid = this.getObjectid();
        return vp;
    }

    public static ValuePosition create(EELoanTP boTP, CalculationCase calculationCase) throws BusinessDomainException {
        Date effectiveFrom = calculationCase.getEffectiveFrom();
        Date validFrom = calculationCase.getValidFrom();
        if (DateHelper.after((Date)boTP.getEffectiveFrom(), (Date)calculationCase.getEffectiveFrom())) {
            effectiveFrom = boTP.getEffectiveFrom();
        }
        if (DateHelper.after((Date)boTP.getValidFrom(), (Date)calculationCase.getValidFrom())) {
            validFrom = boTP.getValidFrom();
        }
        ValuePosition vp = null;
        if (ValuePosition.checkCreateByInterval(boTP.getEELoan().getValueType(), effectiveFrom, validFrom) && (vp = ValuePosition.createValuePosition(calculationCase.getEmployee(), boTP.getEELoan().getValueType(), (PersistentObject)boTP, effectiveFrom, boTP.getEffectiveUntil(), validFrom, boTP.getValidUntil())) != null) {
            vp.setResult(boTP.getInstalment());
            vp.setBasicResult(boTP.getInstalment());
        }
        ValuePosition.createNextCalculationBasicFromInterval(boTP.getInterval(), calculationCase, boTP.getEELoan().getClassName());
        return vp;
    }

    public static ValuePosition create(FixedPaymentTP boTP, CalculationCase calculationCase) throws BusinessDomainException {
        ValuePosition vp = null;
        if (ValuePosition.checkInterval(boTP.getInterval(), calculationCase.getValidFrom()) && (DateHelper.between((Date)boTP.getValidFrom(), (Date)calculationCase.getValidFrom(), (Date)DateHelper.getLastDayOfMonth((Date)calculationCase.getValidFrom())) || DateHelper.before((Date)boTP.getValidFrom(), (Date)calculationCase.getValidFrom()))) {
            Date effectiveFrom = calculationCase.getEffectiveFrom();
            Date validFrom = calculationCase.getValidFrom();
            if (DateHelper.after((Date)boTP.getEffectiveFrom(), (Date)calculationCase.getEffectiveFrom())) {
                effectiveFrom = boTP.getEffectiveFrom();
            }
            if (DateHelper.after((Date)boTP.getValidFrom(), (Date)calculationCase.getValidFrom())) {
                validFrom = boTP.getValidFrom();
            }
            if ((vp = ValuePosition.createValuePosition(calculationCase.getEmployee(), boTP.getFixedPayment().getValueType(), (PersistentObject)boTP, effectiveFrom, boTP.getEffectiveUntil(), validFrom, boTP.getValidUntil())) != null) {
                vp.setFactor1(boTP.getFactor1());
                vp.setFactor2(boTP.getFactor2());
                vp.setResult(boTP.getResult());
                vp.setPercentage(boTP.getPercentage());
                vp.setPerformanceFactor(boTP.getPerformanceFactor());
                vp.setCostCenter(boTP.getCostCenter());
                vp.setCostUnit(boTP.getCostUnit());
                vp.setBasicFactor1(boTP.getFactor1());
                vp.setBasicFactor2(boTP.getFactor2());
                vp.setBasicResult(boTP.getResult());
                vp.setBasicPercentage(boTP.getPercentage());
                vp.setBasicPerformanceFactor(boTP.getPerformanceFactor());
                vp.setBasicCostCenter(boTP.getCostCenter());
                vp.setBasicCostUnit(boTP.getCostUnit());
            }
        }
        ValuePosition.createNextCalculationBasicFromInterval(boTP.getInterval(), calculationCase, boTP.getFixedPayment().getClassName());
        return vp;
    }

    public static ValuePosition[] create(CalculationCase calculationCase, int[] valueTypeNumbers) throws BusinessDomainException {
        ValuePosition[] result = new ValuePosition[valueTypeNumbers.length];
        for (int i = 0; i < valueTypeNumbers.length; ++i) {
            result[i] = ValuePosition.create(calculationCase, valueTypeNumbers[i]);
        }
        return result;
    }

    public static ValuePosition create(CalculationCase calculationCase, int valueTypeNumber) throws BusinessDomainException {
        ValuePosition vp = null;
        ValueType vt = ValueType.getValueType((int)valueTypeNumber);
        if (ValuePosition.checkCreateByInterval(vt, calculationCase.getEffectiveFrom(), calculationCase.getValidFrom())) {
            if (valueTypeNumber != 110595) {
                new CalculationBasic(calculationCase.getEmployee(), calculationCase.getEffectiveFrom(), DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)calculationCase.getValidFrom())), calculationCase.getClass().getName());
            }
            vp = new ValuePosition(calculationCase.getEmployee(), ValueType.getValueType((int)valueTypeNumber), (PersistentObject)calculationCase.getCalculation(), (PersistentObject)calculationCase.getCalculation());
            vp.setEffectiveFrom(calculationCase.getEffectiveFrom());
            vp.setEffectiveUntil(VDate.getDateMax());
            vp.setValidFrom(calculationCase.getValidFrom());
            vp.setValidUntil(VDate.getDateMax());
            vp.setBasicFactor1(BigDecimal.ZERO);
            vp.setBasicFactor2(BigDecimal.ZERO);
            vp.setBasicResult(BigDecimal.ZERO);
            vp.setBasicPercentage(BigDecimal.ZERO);
            vp.setBasicPerformanceFactor(BigDecimal.ZERO);
            vp.setBasicCostCenter(null);
            vp.setBasicCostUnit(null);
            vp.setPersistentBuffer1(BigDecimal.ZERO);
            vp.setPersistentBuffer2(BigDecimal.ZERO);
            vp.setPersistentBuffer3(BigDecimal.ZERO);
            vp.setPersistentBuffer4(BigDecimal.ZERO);
            vp.setPersistentBuffer5(BigDecimal.ZERO);
            vp.setEraCorrectionFactor(BigDecimal.ZERO);
            vp.setEraValue(BigDecimal.ZERO);
            vp.setBufferFactor1(BigDecimal.ZERO);
            vp.setBufferFactor2(BigDecimal.ZERO);
            vp.setBufferResult(BigDecimal.ZERO);
            vp.setBufferPercentage(BigDecimal.ZERO);
            vp.setBufferPerformanceFactor(BigDecimal.ZERO);
            vp.setBufferCostCenter(null);
            vp.setBufferCostUnit(null);
            vp.setFactor1(BigDecimal.ZERO);
            vp.setFactor2(BigDecimal.ZERO);
            vp.setResult(BigDecimal.ZERO);
            vp.setPercentage(BigDecimal.ZERO);
            vp.setPerformanceFactor(BigDecimal.ZERO);
            vp.setCostCenter(null);
            vp.setCostUnit(null);
        }
        return vp;
    }

    public static ValuePosition[] createMKVP(CalculationCase calculationCase, int valueTypeNumber, MKPosition[] mk) {
        ArrayList<ValuePosition> result = new ArrayList<ValuePosition>();
        for (MKPosition element : mk) {
            ValuePosition vpTemp;
            OriginatorFactory originatorFactory;
            Originator originator;
            PersistentObject rootGenesisOfParentObjects = null;
            BigDecimal rootGenesisType = null;
            if (element.getGenesisOfParentObjects() != null && (originator = (originatorFactory = (OriginatorFactory)UtilitiesManager.getBean((String)"originatorFactory", OriginatorFactory.class)).valueOf(element.getGenesisOfParentObjects().getClass().getName())) != null) {
                rootGenesisType = BigDecimal.valueOf(originator.getPersistentValue());
                rootGenesisOfParentObjects = element.getGenesisOfParentObjects();
            }
            ValuePosition vp = new ValuePosition(calculationCase.getEmployee(), ValueType.getValueType((int)valueTypeNumber), (PersistentObject)calculationCase.getCalculation(), (PersistentObject)calculationCase.getCalculation());
            if (!BigDecimalMapper.isZeroOrNull(rootGenesisType)) {
                vp.setRootGenesisOfParentObjects(rootGenesisOfParentObjects);
                vp.setPersistentBuffer5(rootGenesisType);
            } else {
                vp.setPersistentBuffer5(BigDecimal.ZERO);
            }
            vp.setEffectiveFrom(calculationCase.getEffectiveFrom());
            vp.setEffectiveUntil(VDate.getDateMax());
            vp.setValidFrom(calculationCase.getValidFrom());
            vp.setValidUntil(DateHelper.getLastDayOfMonth((Date)calculationCase.getValidFrom()));
            vp.setBasicFactor1(BigDecimal.ZERO);
            vp.setBasicFactor2(BigDecimal.ZERO);
            vp.setBasicResult(BigDecimal.ZERO);
            vp.setBasicPercentage(BigDecimal.ZERO);
            vp.setBasicPerformanceFactor(BigDecimal.ZERO);
            vp.setBasicCostCenter(null);
            vp.setBasicCostUnit(null);
            vp.setPersistentBuffer1(BigDecimal.ZERO);
            vp.setPersistentBuffer2(BigDecimal.ZERO);
            vp.setPersistentBuffer3(BigDecimal.ZERO);
            vp.setPersistentBuffer4(BigDecimal.ZERO);
            vp.setBufferFactor1(element.getMValue());
            vp.setBufferFactor2(BigDecimal.ZERO);
            vp.setBufferResult(element.getHatUmlage() ? element.getMValue() : BigDecimal.ZERO);
            vp.setBufferPercentage(BigDecimal.ZERO);
            vp.setBufferPerformanceFactor(BigDecimal.ZERO);
            vp.setBufferCostCenter(null);
            vp.setBufferCostUnit(null);
            vp.setFactor1(BigDecimal.ZERO);
            vp.setFactor2(BigDecimal.ZERO);
            vp.setResult(element.getMValue());
            vp.setPercentage(BigDecimal.ZERO);
            vp.setPerformanceFactor(BigDecimal.ZERO);
            vp.setCostCenter(null);
            vp.setCostUnit(null);
            result.add(vp);
            if (element.isAtzEga109290Gesetzlich()) {
                vpTemp = new ValuePosition(calculationCase.getEmployee(), ValueType.getValueType((int)109290), (PersistentObject)vp, (PersistentObject)vp);
                vpTemp.setData(new ValuePositionData(vp.getEffectiveFrom(), vp.getEffectiveUntil(), vp.getValidFrom(), vp.getValidUntil(), vp.getFactor1(), vp.getFactor2(), vp.getResult(), vp.getPercentage(), vp.getPerformanceFactor(), vp.getCostCenter(), vp.getCostUnit(), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, null, "", "", "", BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, null, "", vp.isToAnalyze()));
                result.add(vpTemp);
            }
            if (element.isAtzEga109310Vertraglich()) {
                vpTemp = new ValuePosition(calculationCase.getEmployee(), ValueType.getValueType((int)109310), (PersistentObject)vp, (PersistentObject)vp);
                vpTemp.setData(new ValuePositionData(vp.getEffectiveFrom(), vp.getEffectiveUntil(), vp.getValidFrom(), vp.getValidUntil(), vp.getFactor1(), vp.getFactor2(), vp.getResult(), vp.getPercentage(), vp.getPerformanceFactor(), vp.getCostCenter(), vp.getCostUnit(), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, null, "", "", "", BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, null, "", vp.isToAnalyze()));
                result.add(vpTemp);
            }
            if (element.isAtzEga109330Gesetzlich()) {
                vpTemp = new ValuePosition(calculationCase.getEmployee(), ValueType.getValueType((int)109330), (PersistentObject)vp, (PersistentObject)vp);
                vpTemp.setData(new ValuePositionData(vp.getEffectiveFrom(), vp.getEffectiveUntil(), vp.getValidFrom(), vp.getValidUntil(), vp.getFactor1(), vp.getFactor2(), vp.getResult(), vp.getPercentage(), vp.getPerformanceFactor(), vp.getCostCenter(), vp.getCostUnit(), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, null, "", "", "", BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, null, "", vp.isToAnalyze()));
                result.add(vpTemp);
            }
            if (element.isAtzEga109340Gesetzlich()) {
                vpTemp = new ValuePosition(calculationCase.getEmployee(), ValueType.getValueType((int)109340), (PersistentObject)vp, (PersistentObject)vp);
                vpTemp.setData(new ValuePositionData(vp.getEffectiveFrom(), vp.getEffectiveUntil(), vp.getValidFrom(), vp.getValidUntil(), vp.getFactor1(), vp.getFactor2(), vp.getResult(), vp.getPercentage(), vp.getPerformanceFactor(), vp.getCostCenter(), vp.getCostUnit(), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, null, "", "", "", BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, null, "", vp.isToAnalyze()));
                result.add(vpTemp);
            }
            if (element.isAtzEga109360Vertraglich()) {
                vpTemp = new ValuePosition(calculationCase.getEmployee(), ValueType.getValueType((int)109360), (PersistentObject)vp, (PersistentObject)vp);
                vpTemp.setData(new ValuePositionData(vp.getEffectiveFrom(), vp.getEffectiveUntil(), vp.getValidFrom(), vp.getValidUntil(), vp.getFactor1(), vp.getFactor2(), vp.getResult(), vp.getPercentage(), vp.getPerformanceFactor(), vp.getCostCenter(), vp.getCostUnit(), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, null, "", "", "", BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, null, "", vp.isToAnalyze()));
                result.add(vpTemp);
            }
            if (!element.isAtzEga109370Vertraglich()) continue;
            vpTemp = new ValuePosition(calculationCase.getEmployee(), ValueType.getValueType((int)109370), (PersistentObject)vp, (PersistentObject)vp);
            vpTemp.setData(new ValuePositionData(vp.getEffectiveFrom(), vp.getEffectiveUntil(), vp.getValidFrom(), vp.getValidUntil(), vp.getFactor1(), vp.getFactor2(), vp.getResult(), vp.getPercentage(), vp.getPerformanceFactor(), vp.getCostCenter(), vp.getCostUnit(), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, null, "", "", "", BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, null, "", vp.isToAnalyze()));
            result.add(vpTemp);
        }
        ValuePosition[] results = new ValuePosition[result.size()];
        result.toArray(results);
        return results;
    }

    private static OriginatorFactory getOriginatorFacotry() {
        return (OriginatorFactory)UtilitiesManager.getBean((String)"originatorFactory", OriginatorFactory.class);
    }

    public static ValuePosition create(EEPieceWorkTP boTP, CalculationCase calculationCase) throws BusinessDomainException {
        ValueType vt = boTP.getEEPieceWork().getValueType();
        boolean createInThisMonth = ValuePosition.checkCreateByInterval(vt, calculationCase.getEffectiveFrom(), calculationCase.getValidFrom());
        if (createInThisMonth) {
            ValuePosition vp = new ValuePosition(boTP.getEmployee(), boTP.getEEPieceWork().getValueType(), (PersistentObject)boTP, (PersistentObject)boTP);
            vp.setDocumentDate(boTP.getDocumentDate());
            vp.setBookingDate(boTP.getBookingDate());
            vp.setDocumentNumber(boTP.getDocumentNumber());
            vp.setOrderNumber(boTP.getOrderNumber());
            vp.setPartNumber(boTP.getPartNumber());
            vp.setStageNumber(boTP.getStageNumber());
            TypeOfPieceWorkEnum taskWageType = boTP.getEEPieceWork().getValueType().getValueTypeTP(boTP.getEffectiveFrom(), boTP.getValidFrom()).getValueTypeEvaluation().getPieceWork().getPieceWork();
            switch (taskWageType.value()) {
                case 0: 
                case 1: 
                case 2: {
                    return ValuePosition.createWithoutTaskWage(boTP, calculationCase, vp);
                }
            }
            return ValuePosition.createTaskWageInTime(boTP, calculationCase, vp);
        }
        return null;
    }

    private static ValuePosition createTaskWageInTime(EEPieceWorkTP boTP, CalculationCase calculationCase, ValuePosition vp) {
        vp = ValuePosition.createWithoutTaskWage(boTP, calculationCase, vp);
        vp.setSetupTimeAndUnit(boTP.getSetupTimeAndUnit());
        vp.setYield(boTP.getYield());
        vp.setTargetOfTimeAndUnit(boTP.getTargetOfTimeAndUnit());
        vp.setTotalTarget(boTP.getTotalTarget());
        vp.setRateOfLaborUtilisation(boTP.getRateOfLaborUtilisation());
        return vp;
    }

    private static ValuePosition createWithoutTaskWage(EEPieceWorkTP boTP, CalculationCase calculationCase, ValuePosition vp) {
        Date effectiveFrom = calculationCase.getEffectiveFrom();
        Date validFrom = calculationCase.getValidFrom();
        if (DateHelper.afterOrEqual((Date)boTP.getEffectiveFrom(), (Date)calculationCase.getEffectiveFrom())) {
            effectiveFrom = boTP.getEffectiveFrom();
        }
        if (DateHelper.afterOrEqual((Date)boTP.getValidFrom(), (Date)calculationCase.getValidFrom())) {
            validFrom = boTP.getValidFrom();
        }
        vp.setEffectiveFrom(effectiveFrom);
        vp.setEffectiveUntil(boTP.getEffectiveUntil());
        vp.setValidFrom(validFrom);
        vp.setValidUntil(boTP.getValidUntil());
        vp.setFactor1(boTP.getFactor1());
        vp.setFactor2(boTP.getFactor2());
        vp.setResult(boTP.getResult());
        vp.setPercentage(boTP.getPercentage());
        vp.setPerformanceFactor(boTP.getPerformanceFactor());
        vp.setCostCenter(boTP.getCostCenter());
        vp.setCostUnit(boTP.getCostUnit());
        vp.setPersistentBuffer1(BigDecimal.ZERO);
        vp.setPersistentBuffer2(BigDecimal.ZERO);
        vp.setPersistentBuffer3(BigDecimal.ZERO);
        vp.setPersistentBuffer4(BigDecimal.ZERO);
        vp.setPersistentBuffer5(BigDecimal.ZERO);
        vp.setEraCorrectionFactor(BigDecimal.ZERO);
        vp.setEraValue(BigDecimal.ZERO);
        vp.setBasicFactor1(boTP.getFactor1());
        vp.setBasicFactor2(boTP.getFactor2());
        vp.setBasicResult(boTP.getResult());
        vp.setBasicPercentage(boTP.getPercentage());
        vp.setBasicPerformanceFactor(boTP.getPerformanceFactor());
        vp.setBasicCostCenter(boTP.getCostCenter());
        vp.setBasicCostUnit(boTP.getCostUnit());
        vp.setBufferFactor1(BigDecimal.ZERO);
        vp.setBufferFactor2(BigDecimal.ZERO);
        vp.setBufferResult(BigDecimal.ZERO);
        vp.setBufferPercentage(BigDecimal.ZERO);
        vp.setBufferPerformanceFactor(BigDecimal.ZERO);
        vp.setBufferCostCenter(null);
        vp.setBufferCostUnit(null);
        return vp;
    }

    public static ValuePosition[] create(EEPensionSchemeTP boTP, CalculationCase calculationCase) throws BusinessDomainException {
        BigDecimal result;
        Date validFrom;
        boTP.checkValueTypesIsNetwageAgreement(calculationCase.getEffectiveFrom(), calculationCase.getValidFrom());
        ArrayList<ValuePosition> vpList = new ArrayList<ValuePosition>();
        if (DateHelper.after((Date)boTP.getDateOfEntry(), (Date)DateHelper.getLastDayOfMonth((Date)calculationCase.getValidFrom()))) {
            new CalculationBasic(calculationCase.getEmployee(), calculationCase.getEffectiveFrom(), DateHelper.getFirstDayOfMonth((Date)boTP.getDateOfEntry()), boTP.getEEPensionScheme().getClassName());
            return EMPTY_VP_ARRAY;
        }
        if (boTP.getDateOfWithDrawal() != null) {
            if (DateHelper.before((Date)boTP.getDateOfWithDrawal(), (Date)calculationCase.getValidFrom())) {
                return EMPTY_VP_ARRAY;
            }
            new CalculationBasic(calculationCase.getEmployee(), calculationCase.getEffectiveFrom(), DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)boTP.getDateOfWithDrawal())), boTP.getEEPensionScheme().getClassName());
        }
        EEPensionSchemeTP boTPVormonat = null;
        if (DateHelper.before((Date)DateHelper.getLastDayOfMonth((Date)calculationCase.getValidFrom()), (Date)DateHelper.getFirstDayOfMonth((Date)calculationCase.getEffectiveFrom()))) {
            boTPVormonat = (EEPensionSchemeTP)boTP.getEEPensionScheme().getHistory().getItemOrNull(new VDate(calculationCase.getEffectiveFrom()).addMonths(-1).getDate(), calculationCase.getValidFrom());
        }
        boolean changedInterval = false;
        boolean checkInterval = false;
        if (boTP.getVtEEpaysAsCtPay() != null) {
            if (boTPVormonat != null) {
                changedInterval = ValuePosition.hasChangedInterval(boTP.getEEExpensesPays(), boTPVormonat.getEEExpensesPays());
            }
            checkInterval = ValuePosition.checkInterval(boTP.getEEExpensesPays(), calculationCase.getValidFrom());
            if ((changedInterval || checkInterval) && DateHelper.afterOrEqual((Date)calculationCase.getValidFrom(), (Date)boTP.getValidFrom())) {
                validFrom = DateHelper.before((Date)calculationCase.getValidFrom(), (Date)boTP.getValidFrom()) ? boTP.getValidFrom() : calculationCase.getValidFrom();
                ValuePosition vpFromVtEEPaysAsCtPay = ValuePosition.createValuePosition(calculationCase.getEmployee(), boTP.getVtEEpaysAsCtPay(), (PersistentObject)boTP, calculationCase.getEffectiveFrom(), VDate.getDateMax(), validFrom, boTP.getValidUntil());
                if (vpFromVtEEPaysAsCtPay != null) {
                    vpFromVtEEPaysAsCtPay.setRootGenesisOfParentObjects((PersistentObject)boTP.getEEPensionScheme());
                    result = checkInterval ? boTP.getDuesEEpaysAsCtPay() : BigDecimal.ZERO;
                    vpFromVtEEPaysAsCtPay.setBasicResult(result);
                    vpFromVtEEPaysAsCtPay.setResult(result);
                    vpList = new ArrayList();
                    vpList.add(vpFromVtEEPaysAsCtPay);
                }
            }
            ValuePosition.createNextCalculationBasicFromInterval(boTP.getEEExpensesPays(), calculationCase, boTP.getEEPensionScheme().getClassName());
        }
        if (boTP.getVtEEpaysAsExtra() != null) {
            if (boTPVormonat != null) {
                changedInterval = ValuePosition.hasChangedInterval(boTP.getEEPaysAsExtra(), boTPVormonat.getEEPaysAsExtra());
            }
            checkInterval = ValuePosition.checkInterval(boTP.getEEPaysAsExtra(), calculationCase.getValidFrom());
            if ((changedInterval || checkInterval) && DateHelper.afterOrEqual((Date)calculationCase.getValidFrom(), (Date)boTP.getValidFrom())) {
                validFrom = DateHelper.before((Date)calculationCase.getValidFrom(), (Date)boTP.getValidFrom()) ? boTP.getValidFrom() : calculationCase.getValidFrom();
                ValuePosition vpFromVtEEPaysAsExtra = ValuePosition.createValuePosition(calculationCase.getEmployee(), boTP.getVtEEpaysAsExtra(), (PersistentObject)boTP, calculationCase.getEffectiveFrom(), VDate.getDateMax(), validFrom, boTP.getValidUntil());
                if (vpFromVtEEPaysAsExtra != null) {
                    vpFromVtEEPaysAsExtra.setRootGenesisOfParentObjects((PersistentObject)boTP.getEEPensionScheme());
                    result = checkInterval ? boTP.getDuesEEpaysAsExtra() : BigDecimal.ZERO;
                    vpFromVtEEPaysAsExtra.setBasicResult(result);
                    vpFromVtEEPaysAsExtra.setResult(result);
                    vpList.add(vpFromVtEEPaysAsExtra);
                }
            }
            ValuePosition.createNextCalculationBasicFromInterval(boTP.getEEPaysAsExtra(), calculationCase, boTP.getClassName());
        }
        if (boTP.getVtERpaysAsCtPay() != null) {
            if (boTPVormonat != null) {
                changedInterval = ValuePosition.hasChangedInterval(boTP.getERExpensesPays(), boTPVormonat.getERExpensesPays());
            }
            checkInterval = ValuePosition.checkInterval(boTP.getERExpensesPays(), calculationCase.getValidFrom());
            if ((changedInterval || checkInterval) && DateHelper.afterOrEqual((Date)calculationCase.getValidFrom(), (Date)boTP.getValidFrom())) {
                validFrom = DateHelper.before((Date)calculationCase.getValidFrom(), (Date)boTP.getValidFrom()) ? boTP.getValidFrom() : calculationCase.getValidFrom();
                ValuePosition vpFromVtERPaysAsCtPay = ValuePosition.createValuePosition(calculationCase.getEmployee(), boTP.getVtERpaysAsCtPay(), (PersistentObject)boTP, calculationCase.getEffectiveFrom(), VDate.getDateMax(), validFrom, boTP.getValidUntil());
                if (vpFromVtERPaysAsCtPay != null) {
                    vpFromVtERPaysAsCtPay.setRootGenesisOfParentObjects((PersistentObject)boTP.getEEPensionScheme());
                    result = checkInterval ? boTP.getDuesERpaysAsCtPay() : BigDecimal.ZERO;
                    vpFromVtERPaysAsCtPay.setBasicResult(result);
                    vpFromVtERPaysAsCtPay.setResult(result);
                    vpList.add(vpFromVtERPaysAsCtPay);
                }
            }
            ValuePosition.createNextCalculationBasicFromInterval(boTP.getERExpensesPays(), calculationCase, boTP.getClassName());
        }
        if (boTP.getVtERpaysAsExtra() != null) {
            if (boTPVormonat != null) {
                changedInterval = ValuePosition.hasChangedInterval(boTP.getERPaysAsExtra(), boTPVormonat.getERPaysAsExtra());
            }
            checkInterval = ValuePosition.checkInterval(boTP.getERPaysAsExtra(), calculationCase.getValidFrom());
            if ((changedInterval || checkInterval) && DateHelper.afterOrEqual((Date)calculationCase.getValidFrom(), (Date)boTP.getValidFrom())) {
                validFrom = DateHelper.before((Date)calculationCase.getValidFrom(), (Date)boTP.getValidFrom()) ? boTP.getValidFrom() : calculationCase.getValidFrom();
                ValuePosition vpFromVtERPaysAsExtra = ValuePosition.createValuePosition(calculationCase.getEmployee(), boTP.getVtERpaysAsExtra(), (PersistentObject)boTP, calculationCase.getEffectiveFrom(), VDate.getDateMax(), validFrom, boTP.getValidUntil());
                if (vpFromVtERPaysAsExtra != null) {
                    vpFromVtERPaysAsExtra.setRootGenesisOfParentObjects((PersistentObject)boTP.getEEPensionScheme());
                    result = checkInterval ? boTP.getDuesERpaysAsExtra() : BigDecimal.ZERO;
                    vpFromVtERPaysAsExtra.setBasicResult(result);
                    vpFromVtERPaysAsExtra.setResult(result);
                    vpList.add(vpFromVtERPaysAsExtra);
                }
            }
            ValuePosition.createNextCalculationBasicFromInterval(boTP.getERPaysAsExtra(), calculationCase, boTP.getClassName());
        }
        ValuePosition[] vpArray = null;
        vpArray = new ValuePosition[vpList.size()];
        vpList.toArray(vpArray);
        return vpArray;
    }

    private static void createNextCalculationBasicFromInterval(Interval interval, CalculationCase calculationCase, String className) {
        boolean calculationBasicCreated = false;
        boolean wertartErzeugt = ValuePosition.checkInterval(interval, calculationCase.getValidFrom());
        if (interval.isUnvalid() || interval.isWholeYearValid()) {
            return;
        }
        VDate nextCheckDate = new VDate(DateHelper.getFirstDayOfMonth((Date)calculationCase.getValidFrom()));
        nextCheckDate.addMonths(1);
        while (!calculationBasicCreated) {
            switch (nextCheckDate.getMonth()) {
                case 0: {
                    if (wertartErzeugt) {
                        if (interval.getJanuary()) break;
                        calculationBasicCreated = true;
                        new CalculationBasic(calculationCase.getEmployee(), calculationCase.getEffectiveFrom(), nextCheckDate.getDate(), className);
                        break;
                    }
                    if (!interval.getJanuary()) break;
                    calculationBasicCreated = true;
                    new CalculationBasic(calculationCase.getEmployee(), calculationCase.getEffectiveFrom(), nextCheckDate.getDate(), className);
                    break;
                }
                case 1: {
                    if (wertartErzeugt) {
                        if (interval.getFebruary()) break;
                        calculationBasicCreated = true;
                        new CalculationBasic(calculationCase.getEmployee(), calculationCase.getEffectiveFrom(), nextCheckDate.getDate(), className);
                        break;
                    }
                    if (!interval.getFebruary()) break;
                    calculationBasicCreated = true;
                    new CalculationBasic(calculationCase.getEmployee(), calculationCase.getEffectiveFrom(), nextCheckDate.getDate(), className);
                    break;
                }
                case 2: {
                    if (wertartErzeugt) {
                        if (interval.getMarch()) break;
                        calculationBasicCreated = true;
                        new CalculationBasic(calculationCase.getEmployee(), calculationCase.getEffectiveFrom(), nextCheckDate.getDate(), className);
                        break;
                    }
                    if (!interval.getMarch()) break;
                    calculationBasicCreated = true;
                    new CalculationBasic(calculationCase.getEmployee(), calculationCase.getEffectiveFrom(), nextCheckDate.getDate(), className);
                    break;
                }
                case 3: {
                    if (wertartErzeugt) {
                        if (interval.getApril()) break;
                        calculationBasicCreated = true;
                        new CalculationBasic(calculationCase.getEmployee(), calculationCase.getEffectiveFrom(), nextCheckDate.getDate(), className);
                        break;
                    }
                    if (!interval.getApril()) break;
                    calculationBasicCreated = true;
                    new CalculationBasic(calculationCase.getEmployee(), calculationCase.getEffectiveFrom(), nextCheckDate.getDate(), className);
                    break;
                }
                case 4: {
                    if (wertartErzeugt) {
                        if (interval.getMay()) break;
                        calculationBasicCreated = true;
                        new CalculationBasic(calculationCase.getEmployee(), calculationCase.getEffectiveFrom(), nextCheckDate.getDate(), className);
                        break;
                    }
                    if (!interval.getMay()) break;
                    calculationBasicCreated = true;
                    new CalculationBasic(calculationCase.getEmployee(), calculationCase.getEffectiveFrom(), nextCheckDate.getDate(), className);
                    break;
                }
                case 5: {
                    if (wertartErzeugt) {
                        if (interval.getJune()) break;
                        calculationBasicCreated = true;
                        new CalculationBasic(calculationCase.getEmployee(), calculationCase.getEffectiveFrom(), nextCheckDate.getDate(), className);
                        break;
                    }
                    if (!interval.getJune()) break;
                    calculationBasicCreated = true;
                    new CalculationBasic(calculationCase.getEmployee(), calculationCase.getEffectiveFrom(), nextCheckDate.getDate(), className);
                    break;
                }
                case 6: {
                    if (wertartErzeugt) {
                        if (interval.getJuly()) break;
                        calculationBasicCreated = true;
                        new CalculationBasic(calculationCase.getEmployee(), calculationCase.getEffectiveFrom(), nextCheckDate.getDate(), className);
                        break;
                    }
                    if (!interval.getJuly()) break;
                    calculationBasicCreated = true;
                    new CalculationBasic(calculationCase.getEmployee(), calculationCase.getEffectiveFrom(), nextCheckDate.getDate(), className);
                    break;
                }
                case 7: {
                    if (wertartErzeugt) {
                        if (interval.getAugust()) break;
                        calculationBasicCreated = true;
                        new CalculationBasic(calculationCase.getEmployee(), calculationCase.getEffectiveFrom(), nextCheckDate.getDate(), className);
                        break;
                    }
                    if (!interval.getAugust()) break;
                    calculationBasicCreated = true;
                    new CalculationBasic(calculationCase.getEmployee(), calculationCase.getEffectiveFrom(), nextCheckDate.getDate(), className);
                    break;
                }
                case 8: {
                    if (wertartErzeugt) {
                        if (interval.getSeptember()) break;
                        calculationBasicCreated = true;
                        new CalculationBasic(calculationCase.getEmployee(), calculationCase.getEffectiveFrom(), nextCheckDate.getDate(), className);
                        break;
                    }
                    if (!interval.getSeptember()) break;
                    calculationBasicCreated = true;
                    new CalculationBasic(calculationCase.getEmployee(), calculationCase.getEffectiveFrom(), nextCheckDate.getDate(), className);
                    break;
                }
                case 9: {
                    if (wertartErzeugt) {
                        if (interval.getOctober()) break;
                        calculationBasicCreated = true;
                        new CalculationBasic(calculationCase.getEmployee(), calculationCase.getEffectiveFrom(), nextCheckDate.getDate(), className);
                        break;
                    }
                    if (!interval.getOctober()) break;
                    calculationBasicCreated = true;
                    new CalculationBasic(calculationCase.getEmployee(), calculationCase.getEffectiveFrom(), nextCheckDate.getDate(), className);
                    break;
                }
                case 10: {
                    if (wertartErzeugt) {
                        if (interval.getNovember()) break;
                        calculationBasicCreated = true;
                        new CalculationBasic(calculationCase.getEmployee(), calculationCase.getEffectiveFrom(), nextCheckDate.getDate(), className);
                        break;
                    }
                    if (!interval.getNovember()) break;
                    calculationBasicCreated = true;
                    new CalculationBasic(calculationCase.getEmployee(), calculationCase.getEffectiveFrom(), nextCheckDate.getDate(), className);
                    break;
                }
                case 11: {
                    if (wertartErzeugt) {
                        if (interval.getDecember()) break;
                        calculationBasicCreated = true;
                        new CalculationBasic(calculationCase.getEmployee(), calculationCase.getEffectiveFrom(), nextCheckDate.getDate(), className);
                        break;
                    }
                    if (!interval.getDecember()) break;
                    calculationBasicCreated = true;
                    new CalculationBasic(calculationCase.getEmployee(), calculationCase.getEffectiveFrom(), nextCheckDate.getDate(), className);
                    break;
                }
            }
            if (calculationBasicCreated) continue;
            nextCheckDate.addMonths(1);
        }
    }

    private static boolean checkInterval(Interval interval, Date validfrom) {
        VDate checkDate = new VDate(validfrom);
        boolean result = false;
        if (!interval.isUnvalid()) {
            switch (checkDate.getMonth()) {
                case 0: {
                    if (!interval.getJanuary()) break;
                    result = true;
                    break;
                }
                case 1: {
                    if (!interval.getFebruary()) break;
                    result = true;
                    break;
                }
                case 2: {
                    if (!interval.getMarch()) break;
                    result = true;
                    break;
                }
                case 3: {
                    if (!interval.getApril()) break;
                    result = true;
                    break;
                }
                case 4: {
                    if (!interval.getMay()) break;
                    result = true;
                    break;
                }
                case 5: {
                    if (!interval.getJune()) break;
                    result = true;
                    break;
                }
                case 6: {
                    if (!interval.getJuly()) break;
                    result = true;
                    break;
                }
                case 7: {
                    if (!interval.getAugust()) break;
                    result = true;
                    break;
                }
                case 8: {
                    if (!interval.getSeptember()) break;
                    result = true;
                    break;
                }
                case 9: {
                    if (!interval.getOctober()) break;
                    result = true;
                    break;
                }
                case 10: {
                    if (!interval.getNovember()) break;
                    result = true;
                    break;
                }
                case 11: {
                    if (!interval.getDecember()) break;
                    result = true;
                    break;
                }
            }
        }
        return result;
    }

    private static boolean hasChangedInterval(Interval intervalNew, Interval intervalOld) {
        return !intervalNew.equals((Object)intervalOld);
    }

    public static ValuePosition create(EEAttachmentTP boTP, CalculationCase calculationCase) throws BusinessDomainException {
        ValuePosition vp;
        Date effectiveFrom = calculationCase.getEffectiveFrom();
        Date validFrom = calculationCase.getValidFrom();
        if (DateHelper.after((Date)boTP.getEffectiveFrom(), (Date)calculationCase.getEffectiveFrom())) {
            effectiveFrom = boTP.getEffectiveFrom();
        }
        if (DateHelper.after((Date)boTP.getValidFrom(), (Date)calculationCase.getValidFrom())) {
            validFrom = boTP.getValidFrom();
        }
        if ((vp = ValuePosition.createValuePosition(calculationCase.getEmployee(), boTP.getEEAttachment().getValueType(), (PersistentObject)boTP.getEEAttachment(), effectiveFrom, boTP.getEffectiveUntil(), validFrom, boTP.getValidUntil())) != null) {
            if (boTP.getModeOfAttachment() == ModeOfAttachmentEnum.MOAE_Abtretung) {
                vp.setSortDate(boTP.getOrderFrom());
            } else {
                vp.setSortDate(boTP.getReceptDate());
            }
            vp.setSecondaryRankingnumber(boTP.getRankingNumber());
            if (boTP.getAttachmentTable().value() == 1 || boTP.getAttachmentTable().value() == 2) {
                vp.setResult(boTP.getMonthlyInstalment());
            }
            if (boTP.getAttachmentTable().value() == 1 || boTP.getAttachmentTable().value() == 2) {
                vp.setBasicResult(boTP.getMonthlyInstalment());
            } else {
                vp.setBasicResult(boTP.getAttachingAmount());
            }
        }
        return vp;
    }

    public static ValuePosition create(VarPaymentTP boTP, CalculationCase calculationCase) throws BusinessDomainException {
        ValuePosition vp;
        Date effectiveFrom = calculationCase.getEffectiveFrom();
        Date validFrom = calculationCase.getValidFrom();
        if (DateHelper.after((Date)boTP.getEffectiveFrom(), (Date)calculationCase.getEffectiveFrom())) {
            effectiveFrom = boTP.getEffectiveFrom();
        }
        if (DateHelper.after((Date)boTP.getValidFrom(), (Date)calculationCase.getValidFrom())) {
            validFrom = boTP.getValidFrom();
        }
        if ((vp = ValuePosition.createValuePosition(calculationCase.getEmployee(), boTP.getVarPayment().getValueType(), (PersistentObject)boTP, effectiveFrom, boTP.getEffectiveUntil(), validFrom, boTP.getValidUntil())) != null) {
            vp.setFactor1(boTP.getFactor1());
            vp.setFactor2(boTP.getFactor2());
            vp.setResult(boTP.getResult());
            vp.setPercentage(boTP.getPercentage());
            vp.setPerformanceFactor(boTP.getPerformanceFactor());
            vp.setCostCenter(boTP.getCostCenter());
            vp.setCostUnit(boTP.getCostUnit());
            vp.setBasicFactor1(boTP.getFactor1());
            vp.setBasicFactor2(boTP.getFactor2());
            vp.setBasicResult(boTP.getResult());
            vp.setBasicPercentage(boTP.getPercentage());
            vp.setBasicPerformanceFactor(boTP.getPerformanceFactor());
            vp.setBasicCostCenter(boTP.getCostCenter());
            vp.setBasicCostUnit(boTP.getCostUnit());
        }
        new CalculationBasic(calculationCase.getEmployee(), calculationCase.getEffectiveFrom(), DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)validFrom)), boTP.getClassName());
        return vp;
    }

    public static ValuePosition[] create(EEDataERA dataERA, CalculationCase calculationCase) throws BusinessDomainException {
        ValuePosition vp;
        BigDecimal lPerformanceFactor;
        BigDecimal lBasisForPerfBonus;
        BigDecimal lERAPaymentBasis;
        BigDecimal resultOfERAPerfBonus;
        BigDecimal resultOfERAPayment;
        ValueType vtOfERAPayment;
        BigDecimal lCorrectionFactor;
        PayScaleGroupTP psgTP;
        ValueType vtOfERADifference;
        ERAModelTP modelTP;
        ArrayList<ValuePosition> vpList;
        boolean lCreatePerformanceBonus;
        block86: {
            PayScaleLevel psl;
            ValueTypeTP valueTypeTP;
            ValueType valueType;
            lCreatePerformanceBonus = false;
            vpList = new ArrayList<ValuePosition>();
            Employee employee = dataERA.getEmployee();
            Employment empl = employee.getEmployment(calculationCase.getEffectiveFrom(), calculationCase.getValidFrom());
            Plant plant = empl.getPlant();
            ERAModel model = null;
            if (plant != null) {
                model = plant.getPlantFoundations(calculationCase.getEffectiveFrom(), calculationCase.getValidFrom()).getFoundations().getEraModel();
            }
            if (model == null) {
                model = employee.getPCompany().getCompanyFoundations(calculationCase.getEffectiveFrom(), calculationCase.getValidFrom()).getFoundations().getEraModel();
            }
            if (model == null) {
                return EMPTY_VP_ARRAY;
            }
            modelTP = model.getERAModelTP(calculationCase.getEffectiveFrom(), calculationCase.getValidFrom());
            BigDecimal addAmountOfERAPerfBonus = BigDecimal.ZERO;
            if (!BigDecimalMapper.isZeroOrNull((BigDecimal)dataERA.getExtraPayment1().getAmount())) {
                valueType = modelTP.getExtraPayment1().getValueType();
                if (valueType == null) {
                    throw EvaluationExceptionMapper.makeNoValueTypeInERAExtraPaymentDomainException(calculationCase.getValidFrom(), 1);
                }
                valueTypeTP = valueType.getValueTypeTP(calculationCase.getEffectiveFrom(), calculationCase.getValidFrom());
                if (valueTypeTP.getValueTypeFoundation().getGeneral().getEraEvaluation() == ERAEvaluationEnum.EEE_GRUNDBESTANDTEIL_ERA || valueTypeTP.getValueTypeFoundation().getGeneral().getEraEvaluation() == ERAEvaluationEnum.EEE_GRUNDBESTANDTEIL_BEIDES) {
                    addAmountOfERAPerfBonus = addAmountOfERAPerfBonus.add(dataERA.getExtraPayment1().getAmount());
                }
                ValuePosition vpEP1 = ValuePosition.createValuePosition(valueType, calculationCase, dataERA, dataERA.getExtraPayment1().getAmount());
                vpList.add(vpEP1);
            }
            if (!BigDecimalMapper.isZeroOrNull((BigDecimal)dataERA.getExtraPayment2().getAmount())) {
                valueType = modelTP.getExtraPayment2().getValueType();
                if (valueType == null) {
                    throw EvaluationExceptionMapper.makeNoValueTypeInERAExtraPaymentDomainException(calculationCase.getValidFrom(), 2);
                }
                valueTypeTP = valueType.getValueTypeTP(calculationCase.getEffectiveFrom(), calculationCase.getValidFrom());
                if (valueTypeTP.getValueTypeFoundation().getGeneral().getEraEvaluation() == ERAEvaluationEnum.EEE_GRUNDBESTANDTEIL_ERA || valueTypeTP.getValueTypeFoundation().getGeneral().getEraEvaluation() == ERAEvaluationEnum.EEE_GRUNDBESTANDTEIL_BEIDES) {
                    addAmountOfERAPerfBonus = addAmountOfERAPerfBonus.add(dataERA.getExtraPayment1().getAmount());
                }
                ValuePosition vpEP2 = ValuePosition.createValuePosition(valueType, calculationCase, dataERA, dataERA.getExtraPayment2().getAmount());
                vpList.add(vpEP2);
            }
            if (!BigDecimalMapper.isZeroOrNull((BigDecimal)dataERA.getExtraPayment3().getAmount())) {
                valueType = modelTP.getExtraPayment3().getValueType();
                if (valueType == null) {
                    throw EvaluationExceptionMapper.makeNoValueTypeInERAExtraPaymentDomainException(calculationCase.getValidFrom(), 3);
                }
                valueTypeTP = valueType.getValueTypeTP(calculationCase.getEffectiveFrom(), calculationCase.getValidFrom());
                if (valueTypeTP.getValueTypeFoundation().getGeneral().getEraEvaluation() == ERAEvaluationEnum.EEE_GRUNDBESTANDTEIL_ERA || valueTypeTP.getValueTypeFoundation().getGeneral().getEraEvaluation() == ERAEvaluationEnum.EEE_GRUNDBESTANDTEIL_BEIDES) {
                    addAmountOfERAPerfBonus = addAmountOfERAPerfBonus.add(dataERA.getExtraPayment1().getAmount());
                }
                ValuePosition vpEP3 = ValuePosition.createValuePosition(valueType, calculationCase, dataERA, dataERA.getExtraPayment3().getAmount());
                vpList.add(vpEP3);
            }
            if (!BigDecimalMapper.isZeroOrNull((BigDecimal)dataERA.getExtraPayment4().getAmount())) {
                valueType = modelTP.getExtraPayment4().getValueType();
                if (valueType == null) {
                    throw EvaluationExceptionMapper.makeNoValueTypeInERAExtraPaymentDomainException(calculationCase.getValidFrom(), 4);
                }
                valueTypeTP = valueType.getValueTypeTP(calculationCase.getEffectiveFrom(), calculationCase.getValidFrom());
                if (valueTypeTP.getValueTypeFoundation().getGeneral().getEraEvaluation() == ERAEvaluationEnum.EEE_GRUNDBESTANDTEIL_ERA || valueTypeTP.getValueTypeFoundation().getGeneral().getEraEvaluation() == ERAEvaluationEnum.EEE_GRUNDBESTANDTEIL_BEIDES) {
                    addAmountOfERAPerfBonus = addAmountOfERAPerfBonus.add(dataERA.getExtraPayment1().getAmount());
                }
                ValuePosition vpEP4 = ValuePosition.createValuePosition(valueType, calculationCase, dataERA, dataERA.getExtraPayment4().getAmount());
                vpList.add(vpEP4);
            }
            if (!BigDecimalMapper.isZeroOrNull((BigDecimal)dataERA.getExtraPayment5().getAmount())) {
                valueType = modelTP.getExtraPayment5().getValueType();
                if (valueType == null) {
                    throw EvaluationExceptionMapper.makeNoValueTypeInERAExtraPaymentDomainException(calculationCase.getValidFrom(), 5);
                }
                valueTypeTP = valueType.getValueTypeTP(calculationCase.getEffectiveFrom(), calculationCase.getValidFrom());
                if (valueTypeTP.getValueTypeFoundation().getGeneral().getEraEvaluation() == ERAEvaluationEnum.EEE_GRUNDBESTANDTEIL_ERA || valueTypeTP.getValueTypeFoundation().getGeneral().getEraEvaluation() == ERAEvaluationEnum.EEE_GRUNDBESTANDTEIL_BEIDES) {
                    addAmountOfERAPerfBonus = addAmountOfERAPerfBonus.add(dataERA.getExtraPayment1().getAmount());
                }
                ValuePosition vpEP5 = ValuePosition.createValuePosition(valueType, calculationCase, dataERA, dataERA.getExtraPayment5().getAmount());
                vpList.add(vpEP5);
            }
            if (!BigDecimalMapper.isZeroOrNull((BigDecimal)dataERA.getExtraPayment6().getAmount())) {
                valueType = modelTP.getExtraPayment6().getValueType();
                if (valueType == null) {
                    throw EvaluationExceptionMapper.makeNoValueTypeInERAExtraPaymentDomainException(calculationCase.getValidFrom(), 6);
                }
                valueTypeTP = valueType.getValueTypeTP(calculationCase.getEffectiveFrom(), calculationCase.getValidFrom());
                if (valueTypeTP.getValueTypeFoundation().getGeneral().getEraEvaluation() == ERAEvaluationEnum.EEE_GRUNDBESTANDTEIL_ERA || valueTypeTP.getValueTypeFoundation().getGeneral().getEraEvaluation() == ERAEvaluationEnum.EEE_GRUNDBESTANDTEIL_BEIDES) {
                    addAmountOfERAPerfBonus = addAmountOfERAPerfBonus.add(dataERA.getExtraPayment1().getAmount());
                }
                ValuePosition vpEP6 = ValuePosition.createValuePosition(valueType, calculationCase, dataERA, dataERA.getExtraPayment6().getAmount());
                vpList.add(vpEP6);
            }
            if (!BigDecimalMapper.isZeroOrNull((BigDecimal)dataERA.getExtraPayment7().getAmount())) {
                valueType = modelTP.getExtraPayment7().getValueType();
                if (valueType == null) {
                    throw EvaluationExceptionMapper.makeNoValueTypeInERAExtraPaymentDomainException(calculationCase.getValidFrom(), 7);
                }
                valueTypeTP = valueType.getValueTypeTP(calculationCase.getEffectiveFrom(), calculationCase.getValidFrom());
                if (valueTypeTP.getValueTypeFoundation().getGeneral().getEraEvaluation() == ERAEvaluationEnum.EEE_GRUNDBESTANDTEIL_ERA || valueTypeTP.getValueTypeFoundation().getGeneral().getEraEvaluation() == ERAEvaluationEnum.EEE_GRUNDBESTANDTEIL_BEIDES) {
                    addAmountOfERAPerfBonus = addAmountOfERAPerfBonus.add(dataERA.getExtraPayment1().getAmount());
                }
                ValuePosition vpEP7 = ValuePosition.createValuePosition(valueType, calculationCase, dataERA, dataERA.getExtraPayment7().getAmount());
                vpList.add(vpEP7);
            }
            if (!BigDecimalMapper.isZeroOrNull((BigDecimal)dataERA.getExtraPayment8().getAmount())) {
                valueType = modelTP.getExtraPayment8().getValueType();
                if (valueType == null) {
                    throw EvaluationExceptionMapper.makeNoValueTypeInERAExtraPaymentDomainException(calculationCase.getValidFrom(), 8);
                }
                valueTypeTP = valueType.getValueTypeTP(calculationCase.getEffectiveFrom(), calculationCase.getValidFrom());
                if (valueTypeTP.getValueTypeFoundation().getGeneral().getEraEvaluation() == ERAEvaluationEnum.EEE_GRUNDBESTANDTEIL_ERA || valueTypeTP.getValueTypeFoundation().getGeneral().getEraEvaluation() == ERAEvaluationEnum.EEE_GRUNDBESTANDTEIL_BEIDES) {
                    addAmountOfERAPerfBonus = addAmountOfERAPerfBonus.add(dataERA.getExtraPayment1().getAmount());
                }
                ValuePosition vpEP8 = ValuePosition.createValuePosition(valueType, calculationCase, dataERA, dataERA.getExtraPayment8().getAmount());
                vpList.add(vpEP8);
            }
            if (!BigDecimalMapper.isZeroOrNull((BigDecimal)dataERA.getExtraPayment9().getAmount())) {
                valueType = modelTP.getExtraPayment9().getValueType();
                if (valueType == null) {
                    throw EvaluationExceptionMapper.makeNoValueTypeInERAExtraPaymentDomainException(calculationCase.getValidFrom(), 9);
                }
                valueTypeTP = valueType.getValueTypeTP(calculationCase.getEffectiveFrom(), calculationCase.getValidFrom());
                if (valueTypeTP.getValueTypeFoundation().getGeneral().getEraEvaluation() == ERAEvaluationEnum.EEE_GRUNDBESTANDTEIL_ERA || valueTypeTP.getValueTypeFoundation().getGeneral().getEraEvaluation() == ERAEvaluationEnum.EEE_GRUNDBESTANDTEIL_BEIDES) {
                    addAmountOfERAPerfBonus = addAmountOfERAPerfBonus.add(dataERA.getExtraPayment1().getAmount());
                }
                ValuePosition vpEP9 = ValuePosition.createValuePosition(valueType, calculationCase, dataERA, dataERA.getExtraPayment9().getAmount());
                vpList.add(vpEP9);
            }
            if (DateHelper.before((Date)modelTP.getValidUntil(), (Date)VDate.getDateMax())) {
                new CalculationBasic(employee, calculationCase.getEffectiveFrom(), DateHelper.tomorrow((Date)modelTP.getValidUntil()), modelTP.getClassName());
            }
            vtOfERADifference = modelTP.getValueType1();
            PayScaleGroup psg = null;
            switch (dataERA.getChoiceOfPayment().value()) {
                case 1: {
                    psg = modelTP.getPayScaleGroup1();
                    break;
                }
                case 2: {
                    psg = modelTP.getPayScaleGroup3();
                    break;
                }
                case 3: {
                    psg = modelTP.getPayScaleGroup4();
                    break;
                }
                case 0: {
                    return EMPTY_VP_ARRAY;
                }
                default: {
                    throw new IllegalArgumentException("ERA-Entgeltart enth\u00e4lt ung\u00fcltige Auspr\u00e4gung!");
                }
            }
            psgTP = psg.getPayScaleGroupTP(calculationCase.getEffectiveFrom(), calculationCase.getValidFrom());
            if (DateHelper.before((Date)psgTP.getValidUntil(), (Date)VDate.getDateMax())) {
                new CalculationBasic(employee, calculationCase.getEffectiveFrom(), DateHelper.tomorrow((Date)psgTP.getValidUntil()), psgTP.getClassName());
            }
            if ((psl = psgTP.getPayScaleLevel(dataERA.getPayScaleLevel())).getDurationInMonth() != 0) {
                Date changeLevelDate;
                Date date = changeLevelDate = dataERA.getClassificationDate() == null ? new VDate(dataERA.getValidFrom()).addMonths(psl.getDurationInMonth()).getDate() : new VDate(dataERA.getClassificationDate()).addMonths(psl.getDurationInMonth()).getDate();
                if (DateHelper.afterOrEqual((Date)calculationCase.getValidFrom(), (Date)changeLevelDate)) {
                    String reminderName = TaskReminderHelper.getFixedMessageWithCompanyCodeAndPersonnelnumber((Employee)dataERA.getEmployee(), (String)"In den ERA-Angaben des Mitarbeiters mu\u00df die Entgeltgruppe erh\u00f6ht werden ");
                    String reminderNote = new StringBuffer().append("Die Anzahl der Monate der aktuellen Entgeltgruppe wurde am " + DateMapper.toDDMMYYYYPointSeparationString((Date)changeLevelDate) + "\u00fcberschritten").toString();
                    if (!TaskReminderHelper.existsTaskReminderInCalculationCase((CalculationCase)calculationCase, (String)reminderName, (Date)changeLevelDate) && !TaskReminderHelper.existsTaskReminder((String)reminderName, (Date)changeLevelDate)) {
                        ValuePosition.createTaskReminder(reminderName, reminderNote, changeLevelDate, calculationCase);
                    }
                }
            }
            lCorrectionFactor = BigDecimal.ZERO;
            switch (dataERA.getMethodOfPayment().value()) {
                case 1: {
                    lCorrectionFactor = modelTP.getCorrectionFactor1();
                    break;
                }
                case 2: {
                    lCorrectionFactor = modelTP.getCorrectionFactor2();
                    break;
                }
                case 3: {
                    lCorrectionFactor = modelTP.getCorrectionFactor3();
                    break;
                }
                case 4: {
                    lCorrectionFactor = modelTP.getCorrectionFactor4();
                    break;
                }
                case 0: {
                    lCorrectionFactor = BigDecimal.ONE;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("ERA-Entgeltmethode enth\u00e4lt ung\u00fcltige Auspr\u00e4gung!");
                }
            }
            vtOfERAPayment = psl.getValueType();
            resultOfERAPayment = psl.getPayScaleValue();
            resultOfERAPerfBonus = psl.getPayScaleValue();
            lERAPaymentBasis = psl.getPayScaleValue();
            if (modelTP.isUseForPayment()) {
                resultOfERAPayment = resultOfERAPayment.multiply(lCorrectionFactor).setScale(2, RoundingMode.HALF_UP);
            }
            if (modelTP.isUseForBonus()) {
                resultOfERAPerfBonus = resultOfERAPerfBonus.multiply(lCorrectionFactor).setScale(2, RoundingMode.HALF_UP);
            }
            if (dataERA.isIRWAZConversion()) {
                BigDecimal lRTWAZ = modelTP.getBasicHours();
                BigDecimal lIRWAZ = ValuePosition.ermittleIRWAZ(calculationCase, employee);
                if (BigDecimalMapper.isZero((BigDecimal)lIRWAZ)) {
                    lIRWAZ = employee.getWorkingTimeTP(calculationCase.getEffectiveFrom(), calculationCase.getValidFrom()).getMonthlyTargetHours().divide(BigDecimal.valueOf(435L, 2), 2, RoundingMode.HALF_UP);
                }
                resultOfERAPayment = resultOfERAPayment.multiply(lIRWAZ).divide(lRTWAZ, 2, RoundingMode.HALF_UP);
                resultOfERAPerfBonus = resultOfERAPerfBonus.multiply(lIRWAZ).divide(lRTWAZ, 2, RoundingMode.HALF_UP);
            }
            lBasisForPerfBonus = BigDecimal.valueOf(resultOfERAPerfBonus.doubleValue());
            lPerformanceFactor = BigDecimal.ZERO;
            lPerformanceFactor = dataERA.getPointOfperformanceERA().compareTo(BigDecimal.ZERO) != 0 ? (DateHelper.before((Date)calculationCase.getValidFrom(), (Date)new VDate(2018, 0, 1).getDate()) ? dataERA.getPointOfperformanceERA().multiply(modelTP.getCashCoefficient()).setScale(4, RoundingMode.HALF_UP) : dataERA.getPointOfperformanceERA().multiply(modelTP.getCashCoefficient()).setScale(3, RoundingMode.HALF_UP)) : dataERA.getPercOfPerformanceERA();
            if (lPerformanceFactor.compareTo(BigDecimal.ZERO) != 0) {
                lCreatePerformanceBonus = true;
                resultOfERAPerfBonus = resultOfERAPerfBonus.add(addAmountOfERAPerfBonus);
                ValuePositionHistory vpHistory = calculationCase.getValuePositionHistory();
                for (ValuePosition vp2 : vpHistory.getAll()) {
                    ValueType valueType2 = vp2.getValueType();
                    ValueTypeTP valueTypeTP2 = valueType2.getValueTypeTP(calculationCase.getEffectiveFrom(), calculationCase.getValidFrom());
                    if (valueTypeTP2.getValueTypeFoundation().getGeneral().getEraEvaluation() != ERAEvaluationEnum.EEE_GRUNDBESTANDTEIL_ERA && valueTypeTP2.getValueTypeFoundation().getGeneral().getEraEvaluation() != ERAEvaluationEnum.EEE_GRUNDBESTANDTEIL_BEIDES) continue;
                    resultOfERAPerfBonus = resultOfERAPerfBonus.add(vp2.getResult());
                }
                resultOfERAPerfBonus = resultOfERAPerfBonus.multiply(lPerformanceFactor).divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP);
            }
            vp = new ValuePosition(calculationCase.getEmployee(), vtOfERAPayment, (PersistentObject)dataERA, (PersistentObject)dataERA);
            if (DateHelper.before((Date)dataERA.getEffectiveFrom(), (Date)calculationCase.getEffectiveFrom())) {
                vp.setEffectiveFrom(calculationCase.getEffectiveFrom());
            } else {
                vp.setEffectiveFrom(dataERA.getEffectiveFrom());
            }
            vp.setEffectiveUntil(dataERA.getEffectiveUntil());
            if (DateHelper.before((Date)dataERA.getValidFrom(), (Date)calculationCase.getValidFrom())) {
                if (DateHelper.before((Date)calculationCase.getValidFrom(), (Date)psgTP.getValidFrom())) {
                    vp.setValidFrom(psgTP.getValidFrom());
                } else {
                    vp.setValidFrom(calculationCase.getValidFrom());
                }
            } else if (DateHelper.before((Date)dataERA.getValidFrom(), (Date)psgTP.getValidFrom())) {
                vp.setValidFrom(psgTP.getValidFrom());
            } else {
                vp.setValidFrom(dataERA.getValidFrom());
            }
            vp.setValidUntil(dataERA.getValidUntil());
            int index = new PersonnelHistory((PersonnelTimedPersistenceObject[])calculationCase.getEmployee().getEEDataERAHistory()).getIndex(dataERA.getEffectiveFrom(), dataERA.getValidFrom());
            try {
                EEDataERA ptpo = (EEDataERA)new PersonnelHistory((PersonnelTimedPersistenceObject[])calculationCase.getEmployee().getEEDataERAHistory()).getItem(index + 1);
                new CalculationBasic(vp.getEmployee(), vp.getEffectiveFrom(), ptpo.getValidFrom(), dataERA.getClassName());
            }
            catch (BusinessDomainException e) {
                if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) break block86;
                throw e;
            }
        }
        ValueTypeTP vttp = vtOfERAPayment.getValueTypeTP(vp.getEffectiveFrom(), vp.getValidFrom());
        if (vttp.getFactor1().getAssignment().getAssignmentSelection().value() == 0 && vttp.getFactor1().getAssignment().getFixAssignment().value() == 1) {
            vp.setFactor1(resultOfERAPayment);
        } else {
            vp.setFactor1(BigDecimal.ZERO);
        }
        if (vttp.getFactor2().getAssignment().getAssignmentSelection().value() == 0 && vttp.getFactor2().getAssignment().getFixAssignment().value() == 1) {
            vp.setFactor2(resultOfERAPayment);
        } else {
            vp.setFactor2(BigDecimal.ZERO);
        }
        if (vttp.getResult().getAssignment().getAssignmentSelection().value() == 0 && vttp.getResult().getAssignment().getFixAssignment().value() == 1) {
            vp.setResult(resultOfERAPayment);
        } else {
            vp.setResult(BigDecimal.ZERO);
        }
        vp.setPercentage(BigDecimal.ZERO);
        vp.setPerformanceFactor(BigDecimal.ZERO);
        vp.setCostCenter(null);
        vp.setCostUnit(null);
        vp.setPersistentBuffer1(BigDecimal.ZERO);
        vp.setPersistentBuffer2(BigDecimal.ZERO);
        vp.setPersistentBuffer3(resultOfERAPayment);
        vp.setPersistentBuffer4(BigDecimal.ZERO);
        vp.setPersistentBuffer5(BigDecimal.ZERO);
        vp.setEraCorrectionFactor(lCorrectionFactor);
        vp.setEraValue(lERAPaymentBasis);
        vp.setBasicFactor1(vp.getFactor1());
        vp.setBasicFactor2(vp.getFactor2());
        vp.setBasicResult(vp.getResult());
        vp.setBasicPercentage(vp.getPercentage());
        vp.setBasicPerformanceFactor(vp.getPerformanceFactor());
        vp.setBasicCostCenter(vp.getCostCenter());
        vp.setBasicCostUnit(vp.getCostUnit());
        vp.setBufferFactor1(BigDecimal.ZERO);
        vp.setBufferFactor2(BigDecimal.ZERO);
        vp.setBufferResult(BigDecimal.ZERO);
        vp.setBufferPercentage(BigDecimal.ZERO);
        vp.setBufferPerformanceFactor(BigDecimal.ZERO);
        vp.setBufferCostCenter(null);
        vp.setBufferCostUnit(null);
        vpList.add(vp);
        if (!dataERA.isNewClassification()) {
            ValuePosition vpERADifference = new ValuePosition(calculationCase.getEmployee(), vtOfERADifference, (PersistentObject)dataERA, (PersistentObject)dataERA);
            vpERADifference.setEffectiveFrom(vp.getEffectiveFrom());
            vpERADifference.setEffectiveUntil(vp.getEffectiveUntil());
            vpERADifference.setValidFrom(vp.getValidFrom());
            vpERADifference.setValidUntil(vp.getValidUntil());
            vpERADifference.setFactor1(vp.getFactor1());
            vpERADifference.setFactor2(vp.getFactor2());
            vpERADifference.setResult(vp.getResult());
            vpERADifference.setPercentage(vp.getPercentage());
            vpERADifference.setPerformanceFactor(BigDecimal.ZERO);
            vpERADifference.setCostCenter(null);
            vpERADifference.setCostUnit(null);
            vpERADifference.setPersistentBuffer1(BigDecimal.ZERO);
            vpERADifference.setPersistentBuffer2(BigDecimal.ZERO);
            vpERADifference.setPersistentBuffer3(resultOfERAPayment);
            vpERADifference.setPersistentBuffer4(BigDecimal.ZERO);
            vpERADifference.setPersistentBuffer5(BigDecimal.ZERO);
            vpERADifference.setEraCorrectionFactor(lCorrectionFactor);
            vpERADifference.setEraValue(lERAPaymentBasis);
            vpERADifference.setBasicFactor1(vpERADifference.getFactor1());
            vpERADifference.setBasicFactor2(vpERADifference.getFactor2());
            vpERADifference.setBasicResult(vpERADifference.getResult());
            vpERADifference.setBasicPercentage(vpERADifference.getPercentage());
            vpERADifference.setBasicPerformanceFactor(vpERADifference.getPerformanceFactor());
            vpERADifference.setBasicCostCenter(vpERADifference.getCostCenter());
            vpERADifference.setBasicCostUnit(vpERADifference.getCostUnit());
            vpERADifference.setBufferFactor1(BigDecimal.ZERO);
            vpERADifference.setBufferFactor2(BigDecimal.ZERO);
            vpERADifference.setBufferResult(BigDecimal.ZERO);
            vpERADifference.setBufferPercentage(BigDecimal.ZERO);
            vpERADifference.setBufferPerformanceFactor(BigDecimal.ZERO);
            vpERADifference.setBufferCostCenter(null);
            vpERADifference.setBufferCostUnit(null);
            vpList.add(vpERADifference);
        }
        if (lCreatePerformanceBonus) {
            ValueType vtOfPerformanceBonus = modelTP.getValueType6();
            ValuePosition vpPF = new ValuePosition(calculationCase.getEmployee(), vtOfPerformanceBonus, (PersistentObject)dataERA, (PersistentObject)dataERA);
            if (DateHelper.before((Date)dataERA.getEffectiveFrom(), (Date)calculationCase.getEffectiveFrom())) {
                vpPF.setEffectiveFrom(calculationCase.getEffectiveFrom());
            } else {
                vpPF.setEffectiveFrom(dataERA.getEffectiveFrom());
            }
            vpPF.setEffectiveUntil(dataERA.getEffectiveUntil());
            if (DateHelper.before((Date)dataERA.getValidFrom(), (Date)calculationCase.getValidFrom())) {
                if (DateHelper.before((Date)calculationCase.getValidFrom(), (Date)psgTP.getValidFrom())) {
                    vpPF.setValidFrom(psgTP.getValidFrom());
                } else {
                    vpPF.setValidFrom(calculationCase.getValidFrom());
                }
            } else if (DateHelper.before((Date)dataERA.getValidFrom(), (Date)psgTP.getValidFrom())) {
                vpPF.setValidFrom(psgTP.getValidFrom());
            } else {
                vpPF.setValidFrom(dataERA.getValidFrom());
            }
            vpPF.setValidUntil(dataERA.getValidUntil());
            ValueTypeTP vttpPF = vtOfERAPayment.getValueTypeTP(vpPF.getEffectiveFrom(), vpPF.getValidFrom());
            if (vttpPF.getFactor1().getAssignment().getAssignmentSelection().value() == 0 && vttp.getFactor1().getAssignment().getFixAssignment().value() == 1) {
                vpPF.setFactor1(resultOfERAPerfBonus);
            } else {
                vpPF.setFactor1(BigDecimal.ZERO);
            }
            if (vttpPF.getFactor2().getAssignment().getAssignmentSelection().value() == 0 && vttp.getFactor2().getAssignment().getFixAssignment().value() == 1) {
                vpPF.setFactor2(resultOfERAPerfBonus);
            } else {
                vpPF.setFactor2(BigDecimal.ZERO);
            }
            if (vttpPF.getResult().getAssignment().getAssignmentSelection().value() == 0 && vttp.getResult().getAssignment().getFixAssignment().value() == 1) {
                vpPF.setResult(resultOfERAPerfBonus);
            } else {
                vpPF.setResult(BigDecimal.ZERO);
            }
            vpPF.setPercentage(lPerformanceFactor);
            vpPF.setPerformanceFactor(BigDecimal.ZERO);
            vpPF.setCostCenter(null);
            vpPF.setCostUnit(null);
            vpPF.setPersistentBuffer1(BigDecimal.ZERO);
            vpPF.setPersistentBuffer2(BigDecimal.ZERO);
            vpPF.setPersistentBuffer3(resultOfERAPerfBonus);
            vpPF.setPersistentBuffer4(BigDecimal.ZERO);
            vpPF.setPersistentBuffer5(BigDecimal.ZERO);
            vpPF.setEraCorrectionFactor(lCorrectionFactor);
            vpPF.setEraValue(lBasisForPerfBonus);
            vpPF.setBasicFactor1(vpPF.getFactor1());
            vpPF.setBasicFactor2(vpPF.getFactor2());
            vpPF.setBasicResult(vpPF.getResult());
            vpPF.setBasicPercentage(vpPF.getPercentage());
            vpPF.setBasicPerformanceFactor(vpPF.getPerformanceFactor());
            vpPF.setBasicCostCenter(vpPF.getCostCenter());
            vpPF.setBasicCostUnit(vpPF.getCostUnit());
            vpPF.setBufferFactor1(BigDecimal.ZERO);
            vpPF.setBufferFactor2(BigDecimal.ZERO);
            vpPF.setBufferResult(BigDecimal.ZERO);
            vpPF.setBufferPercentage(BigDecimal.ZERO);
            vpPF.setBufferPerformanceFactor(BigDecimal.ZERO);
            vpPF.setBufferCostCenter(null);
            vpPF.setBufferCostUnit(null);
            vpList.add(vpPF);
        }
        return vpList.toArray(EMPTY_VP_ARRAY);
    }

    private static ValuePosition createValuePosition(ValueType valueType, CalculationCase calculationCase, EEDataERA dataERA, BigDecimal amount) throws BusinessDomainException {
        ValuePosition result = new ValuePosition(calculationCase.getEmployee(), valueType, (PersistentObject)dataERA, (PersistentObject)dataERA);
        if (DateHelper.before((Date)dataERA.getEffectiveFrom(), (Date)calculationCase.getEffectiveFrom())) {
            result.setEffectiveFrom(calculationCase.getEffectiveFrom());
        } else {
            result.setEffectiveFrom(dataERA.getEffectiveFrom());
        }
        result.setEffectiveUntil(dataERA.getEffectiveUntil());
        if (DateHelper.before((Date)dataERA.getValidFrom(), (Date)calculationCase.getValidFrom())) {
            result.setValidFrom(calculationCase.getValidFrom());
        } else {
            result.setValidFrom(dataERA.getValidFrom());
        }
        result.setValidUntil(dataERA.getValidUntil());
        ValueTypeTP vttp = valueType.getValueTypeTP(result.getEffectiveFrom(), result.getValidFrom());
        if (vttp.getFactor1().getAssignment().getAssignmentSelection().value() == 0 && vttp.getFactor1().getAssignment().getFixAssignment().value() == 1) {
            result.setFactor1(amount);
        } else {
            result.setFactor1(BigDecimal.ZERO);
        }
        if (vttp.getFactor2().getAssignment().getAssignmentSelection().value() == 0 && vttp.getFactor2().getAssignment().getFixAssignment().value() == 1) {
            result.setFactor2(amount);
        } else {
            result.setFactor2(BigDecimal.ZERO);
        }
        if (vttp.getResult().getAssignment().getAssignmentSelection().value() == 0 && vttp.getResult().getAssignment().getFixAssignment().value() == 1) {
            result.setResult(amount);
        } else {
            result.setResult(BigDecimal.ZERO);
        }
        result.setPercentage(BigDecimal.ZERO);
        result.setPerformanceFactor(BigDecimal.ZERO);
        result.setCostCenter(null);
        result.setCostUnit(null);
        result.setPersistentBuffer1(BigDecimal.ZERO);
        result.setPersistentBuffer2(BigDecimal.ZERO);
        result.setPersistentBuffer3(BigDecimal.ZERO);
        result.setPersistentBuffer4(BigDecimal.ZERO);
        result.setPersistentBuffer5(BigDecimal.ZERO);
        result.setEraCorrectionFactor(BigDecimal.ZERO);
        result.setEraValue(BigDecimal.ZERO);
        result.setBasicFactor1(result.getFactor1());
        result.setBasicFactor2(result.getFactor2());
        result.setBasicResult(result.getResult());
        result.setBasicPercentage(result.getPercentage());
        result.setBasicPerformanceFactor(result.getPerformanceFactor());
        result.setBasicCostCenter(result.getCostCenter());
        result.setBasicCostUnit(result.getCostUnit());
        result.setBufferFactor1(BigDecimal.ZERO);
        result.setBufferFactor2(BigDecimal.ZERO);
        result.setBufferResult(BigDecimal.ZERO);
        result.setBufferPercentage(BigDecimal.ZERO);
        result.setBufferPerformanceFactor(BigDecimal.ZERO);
        result.setBufferCostCenter(null);
        result.setBufferCostUnit(null);
        return result;
    }

    private static BigDecimal ermittleIRWAZ(CalculationCase calculationCase, Employee employee) throws BusinessDomainException {
        try {
            EEWork marbAZ = employee.getEEWork(calculationCase.getEffectiveFrom(), calculationCase.getValidFrom());
            if (marbAZ.getPartTimeWork()) {
                if (!BigDecimalMapper.isZeroOrNull((BigDecimal)marbAZ.getPercentageOfPartTimeWork())) {
                    return employee.getAppurtenantWorkingTime(calculationCase.getEffectiveFrom(), calculationCase.getValidFrom()).getWorkingTimeTP(calculationCase.getEffectiveFrom(), calculationCase.getValidFrom()).getWeeklyWorkingTime().multiply(marbAZ.getPercentageOfPartTimeWork()).divide(EINHUNDERT, 2, RoundingMode.HALF_UP);
                }
                return employee.getAppurtenantWorkingTime(calculationCase.getEffectiveFrom(), calculationCase.getValidFrom()).getWorkingTimeTP(calculationCase.getEffectiveFrom(), calculationCase.getValidFrom()).getWeeklyWorkingTime();
            }
            return employee.getAppurtenantWorkingTime(calculationCase.getEffectiveFrom(), calculationCase.getValidFrom()).getWorkingTimeTP(calculationCase.getEffectiveFrom(), calculationCase.getValidFrom()).getWeeklyWorkingTime();
        }
        catch (BusinessDomainException e) {
            if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) {
                return employee.getAppurtenantWorkingTime(calculationCase.getEffectiveFrom(), calculationCase.getValidFrom()).getWorkingTimeTP(calculationCase.getEffectiveFrom(), calculationCase.getValidFrom()).getWeeklyWorkingTime();
            }
            throw e;
        }
    }

    private static void createTaskReminder(String reminderName, String reminderNote, Date changeLevelDate, CalculationCase calculationCase) {
        TaskReminder reminder = TaskReminderHelper.createTaskReminder((String)reminderName, (Date)changeLevelDate, (String)reminderNote, (String)SessionContext.getInstance().getSession().getUserCode());
        calculationCase.addTaskreminder(reminder);
    }

    public static ValuePosition create(ScalePaymentTP boTP, CalculationCase calculationCase) throws BusinessDomainException {
        ValuePosition vp;
        block14: {
            vp = null;
            if (ValuePosition.checkInterval(boTP.getInterval(), calculationCase.getValidFrom()) && (DateHelper.between((Date)boTP.getValidFrom(), (Date)calculationCase.getValidFrom(), (Date)DateHelper.getLastDayOfMonth((Date)calculationCase.getValidFrom())) || DateHelper.before((Date)boTP.getValidFrom(), (Date)calculationCase.getValidFrom()))) {
                boolean createInThisMonth;
                Date effectiveFrom = calculationCase.getEffectiveFrom();
                Date validFrom = calculationCase.getValidFrom();
                if (DateHelper.after((Date)boTP.getEffectiveFrom(), (Date)calculationCase.getEffectiveFrom())) {
                    effectiveFrom = boTP.getEffectiveFrom();
                }
                if (DateHelper.after((Date)boTP.getValidFrom(), (Date)calculationCase.getValidFrom())) {
                    validFrom = boTP.getValidFrom();
                }
                PayScaleGroup psGroup = boTP.getPayScaleGroup();
                PayScaleGroupTP psGroupTP = psGroup.getPayScaleGroupTP(effectiveFrom, validFrom);
                PayScaleLevel psLevel = psGroupTP.getPayScaleLevel(boTP.getPayScaleLevel());
                ValuePosition.checkPayScaleLevel(psLevel, boTP, calculationCase);
                ValueType valueType = psLevel.getValueType();
                if (valueType == null) {
                    return null;
                }
                if (DateHelper.before((Date)validFrom, (Date)psGroupTP.getValidFrom())) {
                    validFrom = psGroupTP.getValidFrom();
                }
                if (createInThisMonth = ValuePosition.checkCreateByInterval(valueType, effectiveFrom, validFrom)) {
                    vp = new ValuePosition(calculationCase.getEmployee(), valueType, (PersistentObject)boTP, (PersistentObject)boTP);
                    vp.setEffectiveFrom(effectiveFrom);
                    vp.setEffectiveUntil(boTP.getEffectiveUntil());
                    vp.setValidFrom(validFrom);
                    vp.setValidUntil(boTP.getValidUntil());
                    ValueTypeTP vttp = valueType.getValueTypeTP(vp.getEffectiveFrom(), vp.getValidFrom());
                    if (vttp.getFactor1().getAssignment().getAssignmentSelection().value() == 0 && vttp.getFactor1().getAssignment().getFixAssignment().value() == 1) {
                        vp.setFactor1(psLevel.getPayScaleValue());
                    } else {
                        vp.setFactor1(BigDecimal.ZERO);
                    }
                    if (vttp.getFactor2().getAssignment().getAssignmentSelection().value() == 0 && vttp.getFactor2().getAssignment().getFixAssignment().value() == 1) {
                        vp.setFactor2(psLevel.getPayScaleValue());
                    } else {
                        vp.setFactor2(BigDecimal.ZERO);
                    }
                    if (vttp.getResult().getAssignment().getAssignmentSelection().value() == 0 && vttp.getResult().getAssignment().getFixAssignment().value() == 1) {
                        vp.setResult(psLevel.getPayScaleValue());
                    } else {
                        vp.setResult(BigDecimal.ZERO);
                    }
                    vp.setPercentage(boTP.getPercentage());
                    vp.setPerformanceFactor(boTP.getPerformanceFactor());
                    vp.setCostCenter(boTP.getCostCenter());
                    vp.setCostUnit(boTP.getCostUnit());
                    vp.setPersistentBuffer1(BigDecimal.ZERO);
                    vp.setPersistentBuffer2(BigDecimal.ZERO);
                    vp.setPersistentBuffer3(BigDecimal.ZERO);
                    vp.setPersistentBuffer4(BigDecimal.ZERO);
                    vp.setPersistentBuffer5(BigDecimal.ZERO);
                    vp.setEraCorrectionFactor(BigDecimal.ZERO);
                    vp.setEraValue(BigDecimal.ZERO);
                    vp.setBasicFactor1(vp.getFactor1());
                    vp.setBasicFactor2(vp.getFactor2());
                    vp.setBasicResult(vp.getResult());
                    vp.setBasicPercentage(vp.getPercentage());
                    vp.setBasicPerformanceFactor(vp.getPerformanceFactor());
                    vp.setBasicCostCenter(vp.getCostCenter());
                    vp.setBasicCostUnit(vp.getCostUnit());
                    vp.setBufferFactor1(BigDecimal.ZERO);
                    vp.setBufferFactor2(BigDecimal.ZERO);
                    vp.setBufferResult(BigDecimal.ZERO);
                    vp.setBufferPercentage(BigDecimal.ZERO);
                    vp.setBufferPerformanceFactor(BigDecimal.ZERO);
                    vp.setBufferCostCenter(null);
                    vp.setBufferCostUnit(null);
                    int index = psGroup.getHistory().getIndex(psGroupTP.getEffectiveFrom(), psGroupTP.getValidFrom());
                    try {
                        PersonnelTimedPersistenceObject ptpo = psGroup.getHistory().getItem(index + 1);
                        new CalculationBasic(vp.getEmployee(), vp.getEffectiveFrom(), ptpo.getValidFrom(), boTP.getClassName());
                    }
                    catch (BusinessDomainException e) {
                        if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) break block14;
                        throw e;
                    }
                }
            }
        }
        ValuePosition.createNextCalculationBasicFromInterval(boTP.getInterval(), calculationCase, boTP.getScalePayment().getClass().getName());
        return vp;
    }

    private static void checkPayScaleLevel(PayScaleLevel psLevel, ScalePaymentTP paymentTP, CalculationCase calculationCase) throws BusinessDomainException {
        if (psLevel.getDurationInMonth() != 0) {
            ScalePaymentTP[] sptps;
            Date bezugsdatum = paymentTP.getValidFrom();
            for (ScalePaymentTP scalePaymentTP : sptps = paymentTP.getScalePayment().getActiveEffectiveScalePaymentHistory()) {
                if (!DateHelper.before((Date)scalePaymentTP.getValidFrom(), (Date)paymentTP.getValidFrom())) continue;
                if (scalePaymentTP.getPayScaleGroup().equals((Object)psLevel.getPayScaleGroupTP().getPayScaleGroup())) {
                    if (scalePaymentTP.getPayScaleLevel() == psLevel.getPayScaleLevel()) {
                        bezugsdatum = scalePaymentTP.getValidFrom();
                        continue;
                    }
                    bezugsdatum = paymentTP.getValidFrom();
                    continue;
                }
                bezugsdatum = paymentTP.getValidFrom();
            }
            Date changeLevelDate = new VDate(bezugsdatum).addMonths(psLevel.getDurationInMonth()).getDate();
            if (DateHelper.afterOrEqual((Date)calculationCase.getValidFrom(), (Date)changeLevelDate)) {
                if (paymentTP.getNoAutomaticIncrease()) {
                    return;
                }
                String reminderName = TaskReminderHelper.getIndividualMessageWithCompanyCodeAndPersonnelnumber((Employee)paymentTP.getScalePayment().getEmployee(), (String)"Die Tarifdaten des Mitarbeiters m\u00fcssen angepasst werden, denn die Tarifstufe l\u00e4uft aus. Anpassung zum: ", (String)DateMapper.toDDMMYYYYPointSeparationString((Date)changeLevelDate));
                String reminderNote = new StringBuffer().append("Die Anzahl der Monate der aktuellen Entgeltgruppe wurde am " + DateMapper.toDDMMYYYYPointSeparationString((Date)changeLevelDate) + " \u00fcberschritten").toString();
                if (!TaskReminderHelper.existsTaskReminderInCalculationCase((CalculationCase)calculationCase, (String)reminderName, (Date)changeLevelDate) && !TaskReminderHelper.existsTaskReminder((String)reminderName, (Date)changeLevelDate)) {
                    ValuePosition.createTaskReminder(reminderName, reminderNote, changeLevelDate, calculationCase);
                }
            } else {
                new CalculationBasic(calculationCase.getEmployee(), calculationCase.getEffectiveFrom(), changeLevelDate, PayScaleLevel.class.getSimpleName());
            }
        }
    }

    public static ValuePosition create(EEPaymentDeductionTP boTP, CalculationCase calculationCase) throws BusinessDomainException {
        ValuePosition vp = null;
        if (ValuePosition.checkInterval(boTP.getInterval(), calculationCase.getValidFrom()) && DateHelper.afterOrEqual((Date)calculationCase.getValidFrom(), (Date)boTP.getValidFrom())) {
            Date effectiveFrom = calculationCase.getEffectiveFrom();
            Date validFrom = calculationCase.getValidFrom();
            if (DateHelper.after((Date)boTP.getEffectiveFrom(), (Date)calculationCase.getEffectiveFrom())) {
                effectiveFrom = boTP.getEffectiveFrom();
            }
            if (DateHelper.after((Date)boTP.getValidFrom(), (Date)calculationCase.getValidFrom())) {
                validFrom = boTP.getValidFrom();
            }
            vp = ValuePosition.createValuePosition(calculationCase.getEmployee(), boTP.getEEPaymentDeduction().getValueType(), (PersistentObject)boTP, effectiveFrom, boTP.getEffectiveUntil(), validFrom, boTP.getValidUntil());
            vp.setRootGenesisOfParentObjects((PersistentObject)boTP.getEEPaymentDeduction());
            vp.setResult(boTP.getAmount());
        }
        ValuePosition.createNextCalculationBasicFromInterval(boTP.getInterval(), calculationCase, boTP.getEEPaymentDeduction().getClassName());
        return vp;
    }

    public static ValuePosition create(EEAbsentTimeTP boTP, CalculationCase calculationCase) throws BusinessDomainException {
        AbsentTimeTP absentTimeTP;
        Date effectiveFrom = calculationCase.getEffectiveFrom();
        Date validFrom = calculationCase.getValidFrom();
        if (DateHelper.after((Date)boTP.getEffectiveFrom(), (Date)calculationCase.getEffectiveFrom())) {
            effectiveFrom = boTP.getEffectiveFrom();
        }
        if (DateHelper.after((Date)boTP.getValidFrom(), (Date)calculationCase.getValidFrom())) {
            validFrom = boTP.getValidFrom();
        }
        if (!(absentTimeTP = boTP.getEEAbsentTime().getAbsentTime().getAbsentTimeTP(boTP.getEffectiveFrom(), validFrom)).getDeliminationOfMonth() && !DateHelper.equal((Date)DateHelper.getFirstDayOfMonth((Date)boTP.getValidFrom()), (Date)DateHelper.getFirstDayOfMonth((Date)calculationCase.getValidFrom()))) {
            return null;
        }
        ValuePosition vp = null;
        if (ValuePosition.checkCreateByInterval(absentTimeTP.getValueType(), effectiveFrom, validFrom)) {
            vp = new ValuePosition(calculationCase.getEmployee(), absentTimeTP.getValueType(), (PersistentObject)boTP, (PersistentObject)boTP);
            vp.setEffectiveFrom(effectiveFrom);
            vp.setEffectiveUntil(boTP.getEffectiveUntil());
            vp.setValidFrom(validFrom);
            vp = DateHelper.after((Date)boTP.getValidUntil(), (Date)DateHelper.getLastDayOfMonth((Date)boTP.getValidFrom())) ? (absentTimeTP.getDeliminationOfMonth() ? ValuePosition.calculationBasicsFromEEAbsentTime(absentTimeTP, boTP, calculationCase, vp) : ValuePosition.calculationBasicFromEEAbsentTime(absentTimeTP, boTP, calculationCase, vp)) : ValuePosition.calculationBasicFromEEAbsentTime(absentTimeTP, boTP, calculationCase, vp);
        }
        return vp;
    }

    private static ValuePosition calculationBasicFromEEAbsentTime(AbsentTimeTP absentTimeTP, EEAbsentTimeTP eeAbsentTimeTP, CalculationCase calculationCase, ValuePosition vp) throws BusinessDomainException {
        vp.setValidUntil(eeAbsentTimeTP.getValidUntil());
        new CalculationBasic(calculationCase.getEmployee(), eeAbsentTimeTP.getEffectiveFrom(), DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)eeAbsentTimeTP.getValidFrom())), eeAbsentTimeTP.getClassName());
        vp = ValuePosition.fillVPbyEEAbsentTime(absentTimeTP, eeAbsentTimeTP, vp);
        return vp;
    }

    private static ValuePosition calculationBasicsFromEEAbsentTime(AbsentTimeTP absentTimeTP, EEAbsentTimeTP eeAbsentTimeTP, CalculationCase calculationCase, ValuePosition vp) throws BusinessDomainException {
        if (PDateHelper.getDiffInMonths((Date)eeAbsentTimeTP.getValidUntil(), (Date)vp.getValidFrom()) == 0) {
            vp.setValidUntil(eeAbsentTimeTP.getValidUntil());
        } else {
            vp.setValidUntil(DateHelper.getLastDayOfMonth((Date)vp.getValidFrom()));
        }
        int monthDiff = PDateHelper.countAffectedMonths((Date)eeAbsentTimeTP.getValidUntil(), (Date)eeAbsentTimeTP.getValidFrom());
        for (int i = 0; i < monthDiff; ++i) {
            new CalculationBasic(calculationCase.getEmployee(), eeAbsentTimeTP.getEffectiveFrom(), DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)new VDate(eeAbsentTimeTP.getValidFrom()).addMonths(i).getDate())), eeAbsentTimeTP.getClassName());
        }
        vp = ValuePosition.fillVPbyEEAbsentTime(absentTimeTP, eeAbsentTimeTP, vp);
        return vp;
    }

    private static ValuePosition fillVPbyEEAbsentTime(AbsentTimeTP absentTimeTP, EEAbsentTimeTP eeAbsentTimeTP, ValuePosition vp) throws BusinessDomainException {
        switch (absentTimeTP.getTypeOfDelivery().value()) {
            case 0: {
                vp.setFactor1(BigDecimal.ZERO);
                vp.setFactor2(BigDecimal.ZERO);
                vp.setResult(BigDecimal.ZERO);
                vp.setBasicFactor1(BigDecimal.ZERO);
                vp.setBasicFactor2(BigDecimal.ZERO);
                vp.setBasicResult(BigDecimal.ZERO);
                break;
            }
            case 7: {
                if (absentTimeTP.getDeliminationOfMonth()) {
                    BigDecimal bd = ValuePosition.getHoursOfAbsence(vp, eeAbsentTimeTP);
                    vp.setFactor1(bd);
                    vp.setBasicFactor1(bd);
                } else {
                    BigDecimal bd = ValuePosition.getHoursOfAbsence(eeAbsentTimeTP);
                    vp.setFactor1(bd);
                    vp.setBasicFactor1(bd);
                }
                vp.setFactor2(BigDecimal.ZERO);
                vp.setResult(BigDecimal.ZERO);
                vp.setBasicFactor2(BigDecimal.ZERO);
                vp.setBasicResult(BigDecimal.ZERO);
                break;
            }
            case 8: {
                if (absentTimeTP.getDeliminationOfMonth()) {
                    BigDecimal bd = ValuePosition.getHoursOfAbsence(vp, eeAbsentTimeTP);
                    vp.setFactor2(bd);
                    vp.setBasicFactor2(bd);
                } else {
                    BigDecimal bd = ValuePosition.getHoursOfAbsence(eeAbsentTimeTP);
                    vp.setFactor2(bd);
                    vp.setBasicFactor2(bd);
                }
                vp.setFactor1(BigDecimal.ZERO);
                vp.setResult(BigDecimal.ZERO);
                vp.setBasicFactor1(BigDecimal.ZERO);
                vp.setBasicResult(BigDecimal.ZERO);
                break;
            }
            case 9: {
                if (absentTimeTP.getDeliminationOfMonth()) {
                    BigDecimal bd = ValuePosition.getHoursOfAbsence(vp, eeAbsentTimeTP);
                    vp.setResult(bd);
                    vp.setBasicResult(bd);
                } else {
                    BigDecimal bd = ValuePosition.getHoursOfAbsence(eeAbsentTimeTP);
                    vp.setResult(bd);
                    vp.setBasicResult(bd);
                }
                vp.setFactor1(BigDecimal.ZERO);
                vp.setFactor2(BigDecimal.ZERO);
                vp.setBasicFactor1(BigDecimal.ZERO);
                vp.setBasicFactor2(BigDecimal.ZERO);
                break;
            }
            case 1: {
                if (absentTimeTP.getDeliminationOfMonth()) {
                    BigDecimal bd = ValuePosition.getDaysOfAbsence(vp, eeAbsentTimeTP);
                    vp.setFactor1(bd);
                    vp.setBasicFactor1(bd);
                } else {
                    BigDecimal bd = ValuePosition.getDaysOfAbsence(eeAbsentTimeTP);
                    vp.setFactor1(bd);
                    vp.setBasicFactor1(bd);
                }
                vp.setFactor2(BigDecimal.ZERO);
                vp.setResult(BigDecimal.ZERO);
                vp.setBasicFactor2(BigDecimal.ZERO);
                vp.setBasicResult(BigDecimal.ZERO);
                break;
            }
            case 2: {
                if (absentTimeTP.getDeliminationOfMonth()) {
                    BigDecimal bd = ValuePosition.getDaysOfAbsence(vp, eeAbsentTimeTP);
                    vp.setFactor2(bd);
                    vp.setBasicFactor2(bd);
                } else {
                    BigDecimal bd = ValuePosition.getDaysOfAbsence(eeAbsentTimeTP);
                    vp.setFactor2(bd);
                    vp.setBasicFactor2(bd);
                }
                vp.setFactor1(BigDecimal.ZERO);
                vp.setResult(BigDecimal.ZERO);
                vp.setBasicFactor1(BigDecimal.ZERO);
                vp.setBasicResult(BigDecimal.ZERO);
                break;
            }
            case 3: {
                if (absentTimeTP.getDeliminationOfMonth()) {
                    BigDecimal bd = ValuePosition.getDaysOfAbsence(vp, eeAbsentTimeTP);
                    vp.setResult(bd);
                    vp.setBasicResult(bd);
                } else {
                    BigDecimal bd = ValuePosition.getDaysOfAbsence(eeAbsentTimeTP);
                    vp.setResult(bd);
                    vp.setBasicResult(bd);
                }
                vp.setFactor1(BigDecimal.ZERO);
                vp.setFactor2(BigDecimal.ZERO);
                vp.setBasicFactor1(BigDecimal.ZERO);
                vp.setBasicFactor2(BigDecimal.ZERO);
                break;
            }
            case 10: {
                if (absentTimeTP.getDeliminationOfMonth()) {
                    BigDecimal bd = ValuePosition.getConcreteTargetHoursOfAbsence(vp.getEmployee(), vp.getEffectiveFrom(), vp.getValidFrom(), vp.getValidUntil(), eeAbsentTimeTP);
                    vp.setFactor1(bd);
                    vp.setBasicFactor1(bd);
                } else {
                    BigDecimal bd = ValuePosition.getConcreteTargetHoursOfAbsence(vp.getEmployee(), vp.getEffectiveFrom(), eeAbsentTimeTP.getValidFrom(), eeAbsentTimeTP.getValidUntil(), eeAbsentTimeTP);
                    vp.setFactor1(bd);
                    vp.setBasicFactor1(bd);
                }
                vp.setFactor2(BigDecimal.ZERO);
                vp.setResult(BigDecimal.ZERO);
                vp.setBasicFactor2(BigDecimal.ZERO);
                vp.setBasicResult(BigDecimal.ZERO);
                break;
            }
            case 11: {
                if (absentTimeTP.getDeliminationOfMonth()) {
                    BigDecimal bd = ValuePosition.getConcreteTargetHoursOfAbsence(vp.getEmployee(), vp.getEffectiveFrom(), vp.getValidFrom(), vp.getValidUntil(), eeAbsentTimeTP);
                    vp.setFactor2(bd);
                    vp.setBasicFactor2(bd);
                } else {
                    BigDecimal bd = ValuePosition.getConcreteTargetHoursOfAbsence(vp.getEmployee(), vp.getEffectiveFrom(), eeAbsentTimeTP.getValidFrom(), eeAbsentTimeTP.getValidUntil(), eeAbsentTimeTP);
                    vp.setFactor2(bd);
                    vp.setBasicFactor2(bd);
                }
                vp.setFactor1(BigDecimal.ZERO);
                vp.setResult(BigDecimal.ZERO);
                vp.setBasicFactor1(BigDecimal.ZERO);
                vp.setBasicResult(BigDecimal.ZERO);
                break;
            }
            case 12: {
                if (absentTimeTP.getDeliminationOfMonth()) {
                    BigDecimal bd = ValuePosition.getConcreteTargetHoursOfAbsence(vp.getEmployee(), vp.getEffectiveFrom(), vp.getValidFrom(), vp.getValidUntil(), eeAbsentTimeTP);
                    vp.setResult(bd);
                    vp.setBasicResult(bd);
                } else {
                    BigDecimal bd = ValuePosition.getConcreteTargetHoursOfAbsence(vp.getEmployee(), vp.getEffectiveFrom(), eeAbsentTimeTP.getValidFrom(), eeAbsentTimeTP.getValidUntil(), eeAbsentTimeTP);
                    vp.setResult(bd);
                    vp.setBasicResult(bd);
                }
                vp.setFactor1(BigDecimal.ZERO);
                vp.setFactor2(BigDecimal.ZERO);
                vp.setBasicFactor1(BigDecimal.ZERO);
                vp.setBasicFactor2(BigDecimal.ZERO);
                break;
            }
            case 4: {
                if (absentTimeTP.getDeliminationOfMonth()) {
                    BigDecimal bd = ValuePosition.getConcreteTargetDaysOfAbsence(vp.getEmployee(), vp.getEffectiveFrom(), vp.getValidFrom(), vp.getValidUntil(), eeAbsentTimeTP);
                    vp.setFactor1(bd);
                    vp.setBasicFactor1(bd);
                } else {
                    BigDecimal bd = ValuePosition.getConcreteTargetDaysOfAbsence(vp.getEmployee(), vp.getEffectiveFrom(), eeAbsentTimeTP.getValidFrom(), eeAbsentTimeTP.getValidUntil(), eeAbsentTimeTP);
                    vp.setFactor1(bd);
                    vp.setBasicFactor1(bd);
                }
                vp.setFactor2(BigDecimal.ZERO);
                vp.setResult(BigDecimal.ZERO);
                vp.setBasicFactor2(BigDecimal.ZERO);
                vp.setBasicResult(BigDecimal.ZERO);
                break;
            }
            case 5: {
                if (absentTimeTP.getDeliminationOfMonth()) {
                    BigDecimal bd = ValuePosition.getConcreteTargetDaysOfAbsence(vp.getEmployee(), vp.getEffectiveFrom(), vp.getValidFrom(), vp.getValidUntil(), eeAbsentTimeTP);
                    vp.setFactor2(bd);
                    vp.setBasicFactor2(bd);
                } else {
                    BigDecimal bd = ValuePosition.getConcreteTargetDaysOfAbsence(vp.getEmployee(), vp.getEffectiveFrom(), eeAbsentTimeTP.getValidFrom(), eeAbsentTimeTP.getValidUntil(), eeAbsentTimeTP);
                    vp.setFactor2(bd);
                    vp.setBasicFactor2(bd);
                }
                vp.setFactor1(BigDecimal.ZERO);
                vp.setResult(BigDecimal.ZERO);
                vp.setBasicFactor1(BigDecimal.ZERO);
                vp.setBasicResult(BigDecimal.ZERO);
                break;
            }
            case 6: {
                if (absentTimeTP.getDeliminationOfMonth()) {
                    BigDecimal bd = ValuePosition.getConcreteTargetDaysOfAbsence(vp.getEmployee(), vp.getEffectiveFrom(), vp.getValidFrom(), vp.getValidUntil(), eeAbsentTimeTP);
                    vp.setResult(bd);
                    vp.setBasicResult(bd);
                } else {
                    BigDecimal bd = ValuePosition.getConcreteTargetDaysOfAbsence(vp.getEmployee(), vp.getEffectiveFrom(), eeAbsentTimeTP.getValidFrom(), eeAbsentTimeTP.getValidUntil(), eeAbsentTimeTP);
                    vp.setResult(bd);
                    vp.setBasicResult(bd);
                }
                vp.setFactor1(BigDecimal.ZERO);
                vp.setFactor2(BigDecimal.ZERO);
                vp.setBasicFactor1(BigDecimal.ZERO);
                vp.setBasicFactor2(BigDecimal.ZERO);
                break;
            }
            default: {
                vp.setFactor1(BigDecimal.ZERO);
                vp.setFactor2(BigDecimal.ZERO);
                vp.setResult(BigDecimal.ZERO);
                vp.setBasicFactor1(BigDecimal.ZERO);
                vp.setBasicFactor2(BigDecimal.ZERO);
                vp.setBasicResult(BigDecimal.ZERO);
            }
        }
        vp.setPercentage(BigDecimal.ZERO);
        vp.setPerformanceFactor(BigDecimal.ZERO);
        vp.setCostCenter(eeAbsentTimeTP.getCostCenter());
        vp.setCostUnit(eeAbsentTimeTP.getCostUnit());
        vp.setPersistentBuffer1(BigDecimal.ZERO);
        vp.setPersistentBuffer2(BigDecimal.ZERO);
        vp.setPersistentBuffer3(BigDecimal.ZERO);
        vp.setPersistentBuffer4(BigDecimal.ZERO);
        vp.setPersistentBuffer5(BigDecimal.ZERO);
        vp.setEraCorrectionFactor(BigDecimal.ZERO);
        vp.setEraValue(BigDecimal.ZERO);
        vp.setBasicPercentage(BigDecimal.ZERO);
        vp.setBasicPerformanceFactor(BigDecimal.ZERO);
        vp.setBasicCostCenter(eeAbsentTimeTP.getCostCenter());
        vp.setBasicCostUnit(eeAbsentTimeTP.getCostUnit());
        vp.setBufferFactor1(BigDecimal.ZERO);
        vp.setBufferFactor2(BigDecimal.ZERO);
        vp.setBufferResult(BigDecimal.ZERO);
        vp.setBufferPercentage(BigDecimal.ZERO);
        vp.setBufferPerformanceFactor(BigDecimal.ZERO);
        vp.setBufferCostCenter(null);
        vp.setBufferCostUnit(null);
        return vp;
    }

    public static ValuePosition fillVPbyEEAbsentTime(AbsentTimeTP absentTimeTP, ValuePosition vp) throws BusinessDomainException {
        PersistentObject persistentObject = vp.getGenesisOfParentObjects();
        if (persistentObject instanceof EEAbsentTimeTP) {
            EEAbsentTimeTP eeAbsentTimeTP = (EEAbsentTimeTP)persistentObject;
            switch (absentTimeTP.getTypeOfDelivery().value()) {
                case 0: {
                    break;
                }
                case 7: {
                    BigDecimal bd = ValuePosition.getHoursOfAbsence(vp, eeAbsentTimeTP);
                    vp.setFactor1(bd);
                    break;
                }
                case 8: {
                    BigDecimal bd = ValuePosition.getHoursOfAbsence(vp, eeAbsentTimeTP);
                    vp.setFactor2(bd);
                    break;
                }
                case 9: {
                    BigDecimal bd = ValuePosition.getHoursOfAbsence(vp, eeAbsentTimeTP);
                    vp.setResult(bd);
                    break;
                }
                case 1: {
                    BigDecimal bd = ValuePosition.getDaysOfAbsence(vp, eeAbsentTimeTP);
                    vp.setFactor1(bd);
                    break;
                }
                case 2: {
                    BigDecimal bd = ValuePosition.getDaysOfAbsence(vp, eeAbsentTimeTP);
                    vp.setFactor2(bd);
                    break;
                }
                case 3: {
                    BigDecimal bd = ValuePosition.getDaysOfAbsence(vp, eeAbsentTimeTP);
                    vp.setResult(bd);
                    break;
                }
                case 10: {
                    BigDecimal bd = ValuePosition.getConcreteTargetHoursOfAbsence(vp.getEmployee(), vp.getEffectiveFrom(), vp.getValidFrom(), vp.getValidUntil(), eeAbsentTimeTP);
                    vp.setFactor1(bd);
                    break;
                }
                case 11: {
                    BigDecimal bd = ValuePosition.getConcreteTargetHoursOfAbsence(vp.getEmployee(), vp.getEffectiveFrom(), vp.getValidFrom(), vp.getValidUntil(), eeAbsentTimeTP);
                    vp.setFactor2(bd);
                    break;
                }
                case 12: {
                    BigDecimal bd = ValuePosition.getConcreteTargetHoursOfAbsence(vp.getEmployee(), vp.getEffectiveFrom(), vp.getValidFrom(), vp.getValidUntil(), eeAbsentTimeTP);
                    vp.setResult(bd);
                    break;
                }
                case 4: {
                    BigDecimal bd = ValuePosition.getConcreteTargetDaysOfAbsence(vp.getEmployee(), vp.getEffectiveFrom(), vp.getValidFrom(), vp.getValidUntil(), eeAbsentTimeTP);
                    vp.setFactor1(bd);
                    break;
                }
                case 5: {
                    BigDecimal bd = ValuePosition.getConcreteTargetDaysOfAbsence(vp.getEmployee(), vp.getEffectiveFrom(), vp.getValidFrom(), vp.getValidUntil(), eeAbsentTimeTP);
                    vp.setFactor2(bd);
                    break;
                }
                case 6: {
                    BigDecimal bd = ValuePosition.getConcreteTargetDaysOfAbsence(vp.getEmployee(), vp.getEffectiveFrom(), vp.getValidFrom(), vp.getValidUntil(), eeAbsentTimeTP);
                    vp.setResult(bd);
                    break;
                }
                default: {
                    vp.setFactor1(BigDecimal.ZERO);
                    vp.setFactor2(BigDecimal.ZERO);
                    vp.setResult(BigDecimal.ZERO);
                }
            }
        }
        return vp;
    }

    public ValuePosition create(Date effectiveFrom, Date effectiveUntil, Date validFrom, Date validUntil) {
        ValuePosition vp = (ValuePosition)this.createNew();
        vp.setEffectiveFrom(effectiveFrom);
        vp.setEffectiveUntil(effectiveUntil);
        vp.setValidFrom(validFrom);
        vp.setValidUntil(validUntil);
        return vp;
    }

    public ValuePosition create(Date effectiveFrom, Date effectiveUntil) {
        ValuePosition vp = (ValuePosition)this.createNew();
        vp.setEffectiveFrom(effectiveFrom);
        vp.setEffectiveUntil(effectiveUntil);
        return vp;
    }

    public ValuePosition create(ValueType vt) throws BusinessDomainException {
        ValuePosition vp = null;
        if (this.getValueType().getValueTypeTP(this.getEffectiveFrom(), this.getValidFrom()).getValueTypeFoundation().getGeneral().getRankingNumber() < 100000) {
            boolean createInThisMonth = ValuePosition.checkCreateByInterval(vt, this.getEffectiveFrom(), this.getValidFrom());
            if (createInThisMonth) {
                vp = new ValuePosition(this.mEmployee, vt, (PersistentObject)this, (PersistentObject)this);
            }
        } else {
            vp = vt.getValueTypeTP(this.getEffectiveFrom(), this.getValidFrom()).getValueTypeFoundation().getGeneral().getCategory().value() == 15 ? new ValuePosition(this.mEmployee, vt, null, null) : new ValuePosition(this.mEmployee, vt, (PersistentObject)this, this.getGenesisOfParentObjects(), this.getRootGenesisOfParentObjects());
        }
        if (vp != null) {
            vp.setData(new ValuePositionData(this.getEffectiveFrom(), this.getEffectiveUntil(), this.getValidFrom(), this.getValidUntil(), this.getFactor1(), this.getFactor2(), this.getResult(), this.getPercentage(), this.getPerformanceFactor(), this.getCostCenter(), this.getCostUnit(), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, null, "", "", "", BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, null, "", this.isToAnalyze()));
            vp.setSumOfBasicResult(this.getSumOfBasicResult());
            vp.setSumOfResult(this.getSumOfResult());
        }
        return vp;
    }

    public ValuePosition create(ValuePosition basicVP, ConsequenceOfValueType covt, Date date) throws BusinessDomainException {
        ValuePosition vp = this.create(basicVP, covt);
        if (vp != null) {
            vp.setValidFrom(date);
        }
        return vp;
    }

    public ValuePosition create(ValuePosition basicVP, ConsequenceOfValueType covt) throws BusinessDomainException {
        ValueType vt = covt.getConsequenceOfValueType();
        ValuePosition vp = null;
        if (this.getValueType().getValueTypeTP(this.getEffectiveFrom(), this.getValidFrom()).getValueTypeFoundation().getGeneral().getRankingNumber() < 100000 || this.getValueType().getValueTypeKey() <= 99970) {
            boolean createInThisMonth = ValuePosition.checkCreateByInterval(vt, this.getEffectiveFrom(), this.getValidFrom());
            if (createInThisMonth) {
                vp = new ValuePosition(this.mEmployee, vt, (PersistentObject)this, (PersistentObject)this);
            }
        } else if (vt.getValueTypeTP(this.getEffectiveFrom(), this.getValidFrom()).getValueTypeFoundation().getGeneral().getCategory().value() == 15) {
            vp = new ValuePosition(this.mEmployee, vt, null, null);
        } else {
            switch (this.getValueType().getValueTypeKey()) {
                case 99970: 
                case 99971: 
                case 99972: 
                case 99973: 
                case 99999: {
                    vp = new ValuePosition(this.mEmployee, vt, (PersistentObject)this, (PersistentObject)this);
                    break;
                }
                default: {
                    vp = new ValuePosition(this.mEmployee, vt, (PersistentObject)this, this.getGenesisOfParentObjects(), this.getRootGenesisOfParentObjects());
                }
            }
        }
        if (vp != null) {
            vp.setData(new ValuePositionData(this.getEffectiveFrom(), this.getEffectiveUntil(), this.getValidFrom(), this.getValidUntil(), this.getFactor1(), this.getFactor2(), this.getResult(), this.getPercentage(), this.getPerformanceFactor(), this.getCostCenter(), this.getCostUnit(), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, null, "", "", "", BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, null, "", this.isToAnalyze()));
            if (vp.getValueType().getValueTypeTP(basicVP.getEffectiveFrom(), basicVP.getValidFrom()).getValueTypeFoundation().getGeneral().getRankingNumber() < 100000) {
                vp.setFactor1(BigDecimal.ZERO);
                vp.setFactor2(BigDecimal.ZERO);
                vp.setResult(BigDecimal.ZERO);
                vp.setPercentage(BigDecimal.ZERO);
                vp.setPerformanceFactor(BigDecimal.ZERO);
                vp.setCostCenter(null);
                vp.setCostUnit(null);
                switch (covt.getDelivieredFactor1().value()) {
                    case 4: {
                        vp.setFactor1(basicVP.getFactor1());
                        break;
                    }
                    case 5: {
                        vp.setFactor2(basicVP.getFactor1());
                        break;
                    }
                    case 6: {
                        vp.setResult(basicVP.getFactor1());
                        break;
                    }
                    case 7: {
                        vp.setFactor1(basicVP.getBufferFactor1());
                        break;
                    }
                    case 8: {
                        vp.setFactor2(basicVP.getBufferFactor1());
                        break;
                    }
                    case 9: {
                        vp.setResult(basicVP.getBufferFactor1());
                        break;
                    }
                    case 1: {
                        vp.setFactor1(basicVP.getBasicFactor1());
                        break;
                    }
                    case 2: {
                        vp.setFactor2(basicVP.getBasicFactor1());
                        break;
                    }
                    case 3: {
                        vp.setResult(basicVP.getBasicFactor1());
                        break;
                    }
                }
                switch (covt.getDelivieredFactor2().value()) {
                    case 5: {
                        vp.setFactor1(basicVP.getFactor2());
                        break;
                    }
                    case 4: {
                        vp.setFactor2(basicVP.getFactor2());
                        break;
                    }
                    case 6: {
                        vp.setResult(basicVP.getFactor2());
                        break;
                    }
                    case 8: {
                        vp.setFactor1(basicVP.getBufferFactor2());
                        break;
                    }
                    case 7: {
                        vp.setFactor2(basicVP.getBufferFactor2());
                        break;
                    }
                    case 9: {
                        vp.setResult(basicVP.getBufferFactor2());
                        break;
                    }
                    case 2: {
                        vp.setFactor1(basicVP.getBasicFactor2());
                        break;
                    }
                    case 1: {
                        vp.setFactor2(basicVP.getBasicFactor2());
                        break;
                    }
                    case 3: {
                        vp.setResult(basicVP.getBasicFactor2());
                        break;
                    }
                }
                switch (covt.getDelivieredResult().value()) {
                    case 5: {
                        vp.setFactor1(basicVP.getResult());
                        break;
                    }
                    case 6: {
                        vp.setFactor2(basicVP.getResult());
                        break;
                    }
                    case 4: {
                        vp.setResult(basicVP.getResult());
                        break;
                    }
                    case 8: {
                        vp.setFactor1(basicVP.getBufferResult());
                        break;
                    }
                    case 9: {
                        vp.setFactor2(basicVP.getBufferResult());
                        break;
                    }
                    case 7: {
                        vp.setResult(basicVP.getBufferResult());
                        break;
                    }
                    case 2: {
                        vp.setFactor1(basicVP.getBasicResult());
                        break;
                    }
                    case 3: {
                        vp.setFactor2(basicVP.getBasicResult());
                        break;
                    }
                    case 1: {
                        vp.setResult(basicVP.getBasicResult());
                        break;
                    }
                }
                switch (covt.getDelivieredPercentage().value()) {
                    case 1: {
                        vp.setPercentage(basicVP.getPercentage());
                        break;
                    }
                    case 2: {
                        vp.setPercentage(basicVP.getBufferPercentage());
                        break;
                    }
                }
                switch (covt.getDelivieredPerformanceFactor().value()) {
                    case 1: {
                        vp.setPerformanceFactor(basicVP.getPerformanceFactor());
                        break;
                    }
                    case 2: {
                        vp.setPerformanceFactor(basicVP.getBufferPerformanceFactor());
                        break;
                    }
                }
                switch (covt.getDelivieredCostCenter().value()) {
                    case 2: {
                        vp.setCostCenter(this.getEmployee().getEmployment(vp.getEffectiveFrom(), vp.getValidFrom()).getCostCenter());
                        break;
                    }
                    case 1: {
                        vp.setCostCenter(basicVP.getCostCenter());
                        break;
                    }
                    case 3: {
                        vp.setCostCenter(basicVP.getBufferCostCenter());
                        break;
                    }
                }
                switch (covt.getDelivieredCostUnit().value()) {
                    case 2: {
                        break;
                    }
                    case 1: {
                        vp.setCostUnit(basicVP.getCostUnit());
                        break;
                    }
                    case 3: {
                        vp.setCostUnit(basicVP.getBufferCostUnit());
                        break;
                    }
                }
                switch (covt.getBufferFactor1().value()) {
                    case 2: {
                        vp.setBufferFactor1(basicVP.getFactor1());
                        break;
                    }
                    case 1: {
                        vp.setBufferFactor1(basicVP.getBasicFactor1());
                        break;
                    }
                }
                switch (covt.getBufferFactor2().value()) {
                    case 2: {
                        vp.setBufferFactor2(basicVP.getFactor2());
                        break;
                    }
                    case 1: {
                        vp.setBufferFactor2(basicVP.getBasicFactor2());
                        break;
                    }
                }
                switch (covt.getBufferResult().value()) {
                    case 2: {
                        vp.setBufferResult(basicVP.getResult());
                        break;
                    }
                    case 1: {
                        vp.setBufferResult(basicVP.getBasicResult());
                        break;
                    }
                }
                switch (covt.getBufferPercentage().value()) {
                    case 1: {
                        vp.setBufferPercentage(basicVP.getPercentage());
                        break;
                    }
                }
                switch (covt.getBufferPerformanceFactor().value()) {
                    case 1: {
                        vp.setBufferPerformanceFactor(basicVP.getPerformanceFactor());
                        break;
                    }
                }
                switch (covt.getBufferCostCenter().value()) {
                    case 2: {
                        break;
                    }
                    case 1: {
                        vp.setBufferCostCenter(basicVP.getCostCenter());
                        break;
                    }
                }
                switch (covt.getBufferCostUnit().value()) {
                    case 0: {
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 1: {
                        vp.setBufferCostUnit(basicVP.getCostUnit());
                        break;
                    }
                }
            } else {
                vp.setFactor1(BigDecimal.ZERO);
                vp.setFactor2(BigDecimal.ZERO);
                vp.setPercentage(BigDecimal.ZERO);
                vp.setPerformanceFactor(BigDecimal.ZERO);
                vp.setPersistentBuffer1(BigDecimal.ZERO);
                vp.setPersistentBuffer2(BigDecimal.ZERO);
                vp.setPersistentBuffer3(BigDecimal.ZERO);
                vp.setPersistentBuffer4(BigDecimal.ZERO);
                vp.setPersistentBuffer5(BigDecimal.ZERO);
                vp.setEraCorrectionFactor(BigDecimal.ZERO);
                vp.setEraValue(BigDecimal.ZERO);
                if (vp.getValueType().getValueTypeTP(vp.getEffectiveFrom(), vp.getValidFrom()).getValueTypeFoundation().getGeneral().getCategory().value() == 15) {
                    vp.setCostCenter(null);
                    vp.setCostUnit(null);
                }
            }
            vp.setSumOfBasicResult(this.getSumOfBasicResult());
            vp.setSumOfResult(this.getSumOfResult());
        }
        return vp;
    }

    public ValuePosition create(ValueType vt, BigDecimal result) throws BusinessDomainException {
        ValuePosition vp = null;
        if (vt.getValueTypeTP(this.getEffectiveFrom(), this.getValidFrom()).getValueTypeFoundation().getGeneral().getRankingNumber() >= 100000) {
            vp = new ValuePosition(this.mEmployee, vt, (PersistentObject)this, this.mGenesisOfParentObjects, this.getRootGenesisOfParentObjects());
        } else {
            boolean createInThisMonth = ValuePosition.checkCreateByInterval(vt, this.getEffectiveFrom(), this.getValidFrom());
            if (createInThisMonth) {
                vp = new ValuePosition(this.mEmployee, vt, (PersistentObject)this, (PersistentObject)this);
            }
        }
        if (vp != null) {
            vp.setData(new ValuePositionData(this.getEffectiveFrom(), this.getEffectiveUntil(), this.getValidFrom(), this.getValidUntil(), this.getFactor1(), this.getFactor2(), result, BigDecimal.ZERO, BigDecimal.ZERO, this.getCostCenter(), this.getCostUnit(), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, null, "", "", "", BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, null, "", this.isToAnalyze()));
        }
        return vp;
    }

    public ValuePosition create(ValueType vt, BigDecimal percentage, BigDecimal performanceFactor, BigDecimal factor1, BigDecimal factor2, BigDecimal result) throws BusinessDomainException {
        ValuePosition vp = null;
        if (vt.getValueTypeTP(this.getEffectiveFrom(), this.getValidFrom()).getValueTypeFoundation().getGeneral().getRankingNumber() >= 100000) {
            vp = new ValuePosition(this.mEmployee, vt, (PersistentObject)this, this.mGenesisOfParentObjects, this.getRootGenesisOfParentObjects());
        } else {
            boolean createInThisMonth = ValuePosition.checkCreateByInterval(vt, this.getEffectiveFrom(), this.getValidFrom());
            if (createInThisMonth) {
                vp = new ValuePosition(this.mEmployee, vt, (PersistentObject)this, (PersistentObject)this);
            }
        }
        if (vp != null) {
            if (vp.getValueType().getValueTypeTP(this.getEffectiveFrom(), this.getValidFrom()).getValueTypeFoundation().getGeneral().getCategory().value() == 15) {
                vp.setData(new ValuePositionData(this.getEffectiveFrom(), this.getEffectiveUntil(), this.getValidFrom(), this.getValidUntil(), factor1, factor2, result, percentage, performanceFactor, null, null, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, null, "", "", "", BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, null, "", this.isToAnalyze()));
            } else {
                vp.setData(new ValuePositionData(this.getEffectiveFrom(), this.getEffectiveUntil(), this.getValidFrom(), this.getValidUntil(), factor1, factor2, result, percentage, performanceFactor, this.getCostCenter(), this.getCostUnit(), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, null, "", "", "", BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, null, "", this.isToAnalyze()));
            }
        }
        return vp;
    }

    public static ValuePosition createValuePosition(String oidEmployee, int valueTypeKey, boolean readOnly, Date effectiveTimePoint) throws BusinessDomainException {
        ValuePosition vp = null;
        ValueType vt = ValueType.getValueType((int)valueTypeKey);
        boolean createInThisMonth = ValuePosition.checkCreateByInterval(vt, effectiveTimePoint, effectiveTimePoint);
        if (createInThisMonth) {
            vp = new ValuePosition(readOnly);
            Date from = DateHelper.getFirstDayOfMonth((Date)effectiveTimePoint);
            Date until = DateHelper.getLastDayOfMonth((Date)effectiveTimePoint);
            vp.setEmployee(ValuePosition.getIEmployeePM().getEmployee(oidEmployee));
            vp.setValueType(ValueType.getValueType((int)valueTypeKey));
            vp.setData(new ValuePositionData(from, until, from, until, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, null, null, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, null, "", "", "", BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, null, "", true));
            vp.setObjectid("fuerClientGrid");
        }
        return vp;
    }

    public static ValuePosition[] getConsequencesOfValueType(ValuePosition[] vpArray, String oidValueType, Date effectiveFrom, Date effectiveUntil, Date validFrom, Date validUntil) {
        ConsequenceOfValueType[] cvt = ConsequenceOfValueType.getConsequencesOfValueTypeByTimePoint((String)oidValueType, (Date)effectiveFrom, (Date)validFrom);
        ArrayList<ValuePosition> mList = new ArrayList<ValuePosition>();
        for (ConsequenceOfValueType element : cvt) {
            for (ValuePosition element2 : vpArray) {
                if (!DateHelper.equal((Date)element2.getEffectiveFrom(), (Date)effectiveFrom) || !DateHelper.equal((Date)element2.getEffectiveUntil(), (Date)effectiveUntil) || !DateHelper.equal((Date)element2.getValidFrom(), (Date)validFrom) || !DateHelper.equal((Date)element2.getValidUntil(), (Date)validUntil) || element2.getValueType().getObjectid().compareTo(element.getValueTypeTP().getValueType().getObjectid()) != 0) continue;
                mList.add(element2);
            }
        }
        ValuePosition[] valuePosition = new ValuePosition[mList.size()];
        return mList.toArray(valuePosition);
    }

    public static ValuePosition[] getValuePositionsCategory(ValuePosition[] vpArray, CategoryEnum category, Date effectiveTimePoint, Date validTimePoint) throws BusinessDomainException {
        ArrayList<ValuePosition> mList = new ArrayList<ValuePosition>();
        for (ValuePosition element : vpArray) {
            if (ValuePosition.getCategory(element, effectiveTimePoint, validTimePoint).value() != category.value()) continue;
            mList.add(element);
        }
        ValuePosition[] valuePosition = new ValuePosition[mList.size()];
        return mList.toArray(valuePosition);
    }

    public static ValuePosition[] listToArray(List<ValuePosition> list) {
        ValuePosition[] vpArray = new ValuePosition[list.size()];
        return list.toArray(vpArray);
    }

    public static List<ValuePosition> arrayToList(ValuePosition[] vpArray) {
        ArrayList<ValuePosition> list = new ArrayList<ValuePosition>();
        for (ValuePosition vp : vpArray) {
            list.add(vp);
        }
        return list;
    }

    public void evaluate(CalculationCase calculationCase) throws BusinessDomainException {
        if (calculationCase.isBerechnungNachAustritt() && this.getValueType().getValueTypeKey() < 99900) {
            return;
        }
        if (this.getValueType().getValueTypeKey() <= 99999) {
            if (this.getGenesisOfParentObjects() != null || this.getParentObject() != null || calculationCase.getTypeOfCalculationCase() == TypeOfCalculationCase.FiktiveBeitragsermittlung || calculationCase.getTypeOfCalculationCase() == TypeOfCalculationCase.NettoBruttoHochrechnungMK) {
                this.evaluateBySpecification(calculationCase);
                this.evaluateFactor1(calculationCase);
                this.evaluateFactor2(calculationCase);
                this.evaluateResult(calculationCase);
            }
        } else {
            this.evaluateFactor1(calculationCase);
            this.evaluateFactor2(calculationCase);
            this.evaluateResult(calculationCase);
        }
    }

    private void evaluateFactor1(CalculationCase calculationCase) throws BusinessDomainException {
        this.setEvaluateFactor1(true);
        this.evaluateByFormula(calculationCase);
        this.setEvaluateFactor1(false);
    }

    private void evaluateFactor2(CalculationCase calculationCase) throws BusinessDomainException {
        this.setEvaluateFactor2(true);
        this.evaluateByFormula(calculationCase);
        this.setEvaluateFactor2(false);
    }

    private void evaluateResult(CalculationCase calculationCase) throws BusinessDomainException {
        this.setEvaluateResult(true);
        this.evaluateByFormula(calculationCase);
        this.setEvaluateResult(false);
    }

    private void evaluateBySpecification(CalculationCase calculationCase) throws BusinessDomainException {
        String className = "BewertungWertposition";
        try {
            IEvaluationFormulaFactory factory = (IEvaluationFormulaFactory)UtilitiesManager.getBean((String)"evaluationFormulaFactory", IEvaluationFormulaFactory.class);
            EvaluationFormula ef = factory.getFormula("BewertungWertposition");
            ef.evaluate(this, calculationCase);
        }
        catch (ApplicationException e) {
            throw e;
        }
        catch (BusinessDomainException e) {
            throw e;
        }
        catch (IllegalArgumentException e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    private void evaluateByFormula(CalculationCase calculationCase) throws BusinessDomainException {
        String className = "";
        try {
            if (this.evaluateFactor1) {
                className = this.getValueType().getValueTypeTP(this.getEffectiveFrom(), this.getValidFrom()).getFactor1().getSpecification().getFormulaName();
            }
            if (this.evaluateFactor2) {
                className = this.getValueType().getValueTypeTP(this.getEffectiveFrom(), this.getValidFrom()).getFactor2().getSpecification().getFormulaName();
            }
            if (this.evaluateResult) {
                className = this.getValueType().getValueTypeTP(this.getEffectiveFrom(), this.getValidFrom()).getResult().getSpecification().getFormulaName();
            }
            if (!StringMapper.isNullString((String)className)) {
                IEvaluationFormulaFactory factory = (IEvaluationFormulaFactory)UtilitiesManager.getBean((String)"evaluationFormulaFactory", IEvaluationFormulaFactory.class);
                EvaluationFormula ef = factory.getFormula(className);
                ef.evaluate(this, calculationCase);
            }
        }
        catch (ApplicationException e) {
            throw e;
        }
        catch (BusinessDomainException e) {
            throw e;
        }
        catch (IllegalArgumentException e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    private static BigDecimal getDaysOfAbsence(ValuePosition vp, EEAbsentTimeTP attp) throws BusinessDomainException {
        return ValuePosition.getDaysOfAbsence(vp.getEmployee(), vp.getEffectiveFrom(), vp.getValidFrom(), vp.getValidUntil(), attp);
    }

    private static BigDecimal getDaysOfAbsence(EEAbsentTimeTP attp) throws BusinessDomainException {
        return ValuePosition.getDaysOfAbsence(attp.getEmployee(), attp.getEffectiveFrom(), attp.getValidFrom(), attp.getValidUntil(), attp);
    }

    private static BigDecimal getDaysOfAbsence(Employee employee, Date effectiveTimePoint, Date from, Date until, EEAbsentTimeTP attp) throws BusinessDomainException {
        Date tempUntil = ValuePosition.checkUntilWithDateOfWithDrawal(employee, effectiveTimePoint, from, until);
        BigDecimal daysOfAbsence = new BigDecimal(DateHelper.compareDate((Date)tempUntil, (Date)from) + 1);
        if (BigDecimalMapper.compareTo((BigDecimal)daysOfAbsence, (BigDecimal)BigDecimal.valueOf(1L)) == 0 && attp.getHalfLeaveDay()) {
            daysOfAbsence = daysOfAbsence.setScale(2);
            return daysOfAbsence.divide(BigDecimal.valueOf(2L), RoundingMode.HALF_DOWN).setScale(2);
        }
        return daysOfAbsence;
    }

    private static BigDecimal getConcreteTargetDaysOfAbsence(Employee employee, Date effectiveTimePoint, Date from, Date until, EEAbsentTimeTP attp) throws BusinessDomainException {
        WorkingTime workingTime = employee.getAppurtenantWorkingTime(effectiveTimePoint, from);
        if (workingTime == null) {
            return BigDecimal.ZERO;
        }
        BigDecimal concreteTargetDaysOfAbsence = workingTime.getConcreteTargetDays(from, until, employee, effectiveTimePoint, from, usePaidPublicHoliday);
        if (BigDecimalMapper.compareTo((BigDecimal)concreteTargetDaysOfAbsence, (BigDecimal)BigDecimal.ONE) == 0 && attp.getHalfLeaveDay()) {
            concreteTargetDaysOfAbsence = concreteTargetDaysOfAbsence.setScale(2);
            return concreteTargetDaysOfAbsence.divide(BigDecimal.valueOf(2L), RoundingMode.HALF_DOWN).setScale(2);
        }
        return concreteTargetDaysOfAbsence;
    }

    private static BigDecimal getHoursOfAbsence(ValuePosition vp, EEAbsentTimeTP eeAbsentTimeTP) throws BusinessDomainException {
        return ValuePosition.getHoursOfAbsence(vp.getEmployee(), vp.getEffectiveFrom(), vp.getValidFrom(), vp.getValidUntil(), eeAbsentTimeTP);
    }

    private static BigDecimal getHoursOfAbsence(EEAbsentTimeTP eeAbsentTimeTP) throws BusinessDomainException {
        return ValuePosition.getHoursOfAbsence(eeAbsentTimeTP.getEmployee(), eeAbsentTimeTP.getEffectiveFrom(), eeAbsentTimeTP.getValidFrom(), eeAbsentTimeTP.getValidUntil(), eeAbsentTimeTP);
    }

    private static BigDecimal getHoursOfAbsence(Employee employee, Date effectiveTimePoint, Date from, Date until, EEAbsentTimeTP eeAbsentTimeTP) throws BusinessDomainException {
        int countOfDays;
        BigDecimal dailyTargetHours;
        block4: {
            Date tempUntil = ValuePosition.checkUntilWithDateOfWithDrawal(employee, effectiveTimePoint, from, until);
            dailyTargetHours = BigDecimal.ZERO;
            countOfDays = DateHelper.compareDate((Date)tempUntil, (Date)from) + 1;
            WorkingTime workingTime = employee.getAppurtenantWorkingTime(effectiveTimePoint, from);
            if (workingTime != null) {
                try {
                    dailyTargetHours = workingTime.getWorkingTimeTP(effectiveTimePoint, from).getDailyTargetHours();
                }
                catch (BusinessDomainException e) {
                    if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) break block4;
                    throw e;
                }
            }
        }
        BigDecimal hourOfAbsence = dailyTargetHours.multiply(new BigDecimal(countOfDays));
        if (countOfDays == 1 && !BigDecimalMapper.isZeroOrNull((BigDecimal)eeAbsentTimeTP.getNumberOfHours())) {
            hourOfAbsence = eeAbsentTimeTP.getNumberOfHours().setScale(2);
        }
        return hourOfAbsence;
    }

    private static Date checkUntilWithDateOfWithDrawal(Employee employee, Date effectiveTimePoint, Date from, Date until) throws BusinessDomainException {
        Date withdrawal;
        Date tempUntil = until;
        Employment[] empls = employee.getEmploymentHistory(effectiveTimePoint, DateHelper.getFirstDayOfMonth((Date)effectiveTimePoint), DateHelper.getLastDayOfMonth((Date)effectiveTimePoint));
        if (empls.length > 0 && (withdrawal = empls[0].getDateOfWithDrawal()) != null && DateHelper.between((Date)withdrawal, (Date)from, (Date)until)) {
            tempUntil = withdrawal;
        }
        return tempUntil;
    }

    private static BigDecimal getConcreteTargetHoursOfAbsence(Employee employee, Date effectiveTimePoint, Date from, Date until, EEAbsentTimeTP eeAbsentTimeTP) throws BusinessDomainException {
        if (StringMapper.equal((String)eeAbsentTimeTP.getEEAbsentTime().getAbsentTime().getAbsentTimeKey(), (String)"EZK") && !BigDecimalMapper.isZero((BigDecimal)eeAbsentTimeTP.getNumberOfHours())) {
            return ValuePosition.getConcreteTargetHoursOfAbsenceEZK(employee, effectiveTimePoint, from, until, eeAbsentTimeTP);
        }
        WorkingTime workingTime = employee.getAppurtenantWorkingTime(effectiveTimePoint, from);
        if (workingTime == null) {
            return BigDecimal.ZERO;
        }
        int countOfDays = DateHelper.compareDate((Date)until, (Date)from) + 1;
        BigDecimal hourOfAbsence = workingTime.getConcreteTargetHours(from, until, employee, effectiveTimePoint, from, usePaidPublicHoliday);
        if (countOfDays == 1 && !BigDecimalMapper.isZeroOrNull((BigDecimal)eeAbsentTimeTP.getNumberOfHours())) {
            hourOfAbsence = eeAbsentTimeTP.getNumberOfHours().setScale(2);
        }
        return hourOfAbsence;
    }

    private static BigDecimal getConcreteTargetHoursOfAbsenceEZK(Employee employee, Date effectiveTimePoint, Date from, Date until, EEAbsentTimeTP eeAbsentTimeTP) throws BusinessDomainException {
        WorkingTime workingTime = employee.getAppurtenantWorkingTime(effectiveTimePoint, from);
        if (workingTime == null) {
            return BigDecimal.ZERO;
        }
        BigDecimal hourOfAbsence = workingTime.getConcreteTargetHours(from, until, employee, effectiveTimePoint, from, usePaidPublicHoliday, eeAbsentTimeTP.getNumberOfHours(), BigDecimal.ZERO);
        return hourOfAbsence;
    }

    public void reset() {
        this.setBasicFactor1(BigDecimal.ZERO);
        this.setBasicFactor2(BigDecimal.ZERO);
        this.setBasicResult(BigDecimal.ZERO);
        this.setBasicPercentage(BigDecimal.ZERO);
        this.setBasicPerformanceFactor(BigDecimal.ZERO);
        this.setBufferFactor1(BigDecimal.ZERO);
        this.setBufferFactor2(BigDecimal.ZERO);
        this.setBufferResult(BigDecimal.ZERO);
        this.setBufferPercentage(BigDecimal.ZERO);
        this.setBufferPerformanceFactor(BigDecimal.ZERO);
        this.setFactor1(BigDecimal.ZERO);
        this.setFactor2(BigDecimal.ZERO);
        this.setResult(BigDecimal.ZERO);
        this.setPercentage(BigDecimal.ZERO);
        this.setPerformanceFactor(BigDecimal.ZERO);
    }

    public static BigDecimal getSumE(ValuePosition[] vpArray, TypeOfDeliveryEnum typeOfDelivery) {
        BigDecimal summation;
        block4: {
            int ind;
            int enumValue;
            block5: {
                block3: {
                    summation = BigDecimal.valueOf(0L);
                    enumValue = typeOfDelivery.value();
                    ind = vpArray.length;
                    if (enumValue != 1 && enumValue != 4 && enumValue != 7 && enumValue != 10) break block3;
                    for (int i = 0; i < ind; ++i) {
                        if (vpArray[i].getFactor1() == null) continue;
                        summation = summation.add(vpArray[i].getFactor1());
                    }
                    break block4;
                }
                if (enumValue != 2 && enumValue != 5 && enumValue != 8 && enumValue != 11) break block5;
                for (int i = 0; i < ind; ++i) {
                    if (vpArray[i].getFactor2() == null) continue;
                    summation = summation.add(vpArray[i].getFactor2());
                }
                break block4;
            }
            if (enumValue != 3 && enumValue != 6 && enumValue != 9 && enumValue != 12) break block4;
            for (int i = 0; i < ind; ++i) {
                if (vpArray[i].getResult() == null) continue;
                summation = summation.add(vpArray[i].getResult());
            }
        }
        return summation;
    }

    public void checkAttributes() {
    }

    public String toString() {
        StringBuffer b = new StringBuffer(80);
        b.append("ValuePosition ");
        b.append('{').append(this.mResult);
        b.append(',').append(DateMapper.toString((Date)this.mEffectiveFrom));
        b.append(',').append(DateMapper.toString((Date)this.mValidFrom));
        b.append(',').append(this.mValueType);
        b.append(',').append(this.getObjectid());
        b.append('}');
        return b.toString();
    }

    public boolean getSignedAsClauseOfMarch() {
        return this.mSignedAsClauseOfMarch;
    }

    public void setSignedAsClauseOfMarch(boolean sign) {
        this.mSignedAsClauseOfMarch = sign;
    }

    public boolean isPaymentAfterWithdrawal() throws BusinessDomainException {
        block15: {
            Date withdrawal = DateHelper.afterOrEqual((Date)this.getValidFrom(), (Date)new VDate(2019, 0, 1).getDate()) ? this.getDateOfWithDrawal(this.getEffectiveFrom(), this.getEffectiveFrom()) : this.getDateOfWithDrawal(this.getEffectiveFrom(), this.getValidFrom());
            if (withdrawal == null) {
                return false;
            }
            try {
                PersonnelTimedPersistenceObject ptpo;
                try {
                    ptpo = (PersonnelTimedPersistenceObject)((ValuePosition)this.getGenesisOfParentObjects()).getGenesisOfParentObjects();
                }
                catch (ClassCastException e) {
                    ptpo = (PersonnelTimedPersistenceObject)this.getGenesisOfParentObjects();
                }
                if (ptpo instanceof ValuePosition) {
                    PersistentObject tempPtpo = ((ValuePosition)ptpo).getGenesisOfParentObjects();
                    ptpo = (PersonnelTimedPersistenceObject)tempPtpo;
                }
                if (!(ptpo instanceof FixedPaymentTP) && !(ptpo instanceof VarPaymentTP)) break block15;
                if (DateHelper.after((Date)ptpo.getEffectiveFrom(), (Date)withdrawal)) {
                    try {
                        FixedPaymentTP fptp = (FixedPaymentTP)ptpo;
                        Date wirksamab = DateHelper.getFirstDayOfMonth((Date)withdrawal);
                        this.zufluss = fptp.getEffectiveFrom();
                        fptp.getFixedPayment().getHistory().getIndex(wirksamab, fptp.getValidFrom());
                        this.zufluss = null;
                        break block15;
                    }
                    catch (ClassCastException e) {
                        try {
                            VarPaymentTP vptp = (VarPaymentTP)ptpo;
                            Date wirksamab = DateHelper.getFirstDayOfMonth((Date)withdrawal);
                            this.zufluss = vptp.getEffectiveFrom();
                            vptp.getVarPayment().getHistory().getIndex(wirksamab, vptp.getValidFrom());
                            this.zufluss = null;
                            break block15;
                        }
                        catch (ClassCastException f) {
                            return false;
                        }
                        catch (BusinessDomainException f) {
                            if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)f)) {
                                return true;
                            }
                            throw e;
                        }
                    }
                    catch (BusinessDomainException e) {
                        if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) {
                            return true;
                        }
                        throw e;
                    }
                }
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }
        return false;
    }

    private Date getDateOfWithDrawal(Date effectiveDate, Date validDate) throws BusinessDomainException {
        Date withdrawal = null;
        Employment[] empls = this.mEmployee.getEmploymentHistory(effectiveDate, DateHelper.getFirstDayOfMonth((Date)validDate), DateHelper.getLastDayOfMonth((Date)validDate));
        if (empls.length > 0) {
            withdrawal = empls[0].getDateOfWithDrawal();
        }
        return withdrawal;
    }

    public Date getZuflussMonat() {
        return this.zufluss;
    }

    public boolean getSignedAsInCalculation() {
        return this.mSignedAsInCalculation;
    }

    public void setSignedAsInCalculation(boolean b) {
        this.mSignedAsInCalculation = b;
    }

    public boolean isGrossWageFor23c() {
        return this.mGrosswageFor23c;
    }

    public void setGrossWageFor23c(boolean b) {
        this.mGrosswageFor23c = b;
    }

    public Date getSortDate() {
        return this.sortDate;
    }

    public void setSortDate(Date sortDate) {
        this.sortDate = sortDate;
    }

    public int getSecondaryRankingnumber() {
        return this.secondaryRankingnumber;
    }

    public void setSecondaryRankingnumber(int rankingnumber) {
        this.secondaryRankingnumber = rankingnumber;
    }

    public String getRootDomainKey() {
        return this.getEmployee().getDomainKey();
    }

    public String getNaturalLanguageClassName() {
        return "Wertposition";
    }

    public static void deleteValuePositions(Date effectiveFrom, Date validFrom, String oidEmployee) {
        ValuePositionPersistencyManager.delete((Criterion)Restrictions.and((Criterion)Restrictions.eq((String)"oidemployee", (String)oidEmployee), (Criterion)Restrictions.disjunction((Criterion[])new Criterion[]{Restrictions.gt((String)"effectivefrom", (String)DateMapper.toString((Date)effectiveFrom)), Restrictions.and((Criterion)Restrictions.eq((String)"effectivefrom", (String)DateMapper.toString((Date)effectiveFrom)), (Criterion)Restrictions.ge((String)"validfrom", (String)DateMapper.toString((Date)validFrom)))})));
    }

    public static List<ValuePosition> create(EEMaterialExpensesTP boTP, CalculationCase calculationCase) throws BusinessDomainException {
        ArrayList<ValuePosition> vpList = new ArrayList<ValuePosition>();
        Date effectiveFrom = calculationCase.getEffectiveFrom();
        Date validFrom = calculationCase.getValidFrom();
        if (DateHelper.after((Date)boTP.getEffectiveFrom(), (Date)calculationCase.getEffectiveFrom())) {
            effectiveFrom = boTP.getEffectiveFrom();
        }
        if (DateHelper.after((Date)boTP.getValidFrom(), (Date)calculationCase.getValidFrom())) {
            validFrom = boTP.getValidFrom();
        }
        Employee employee = calculationCase.getEmployee();
        Employment empl = employee.getEmployment(calculationCase.getEffectiveFrom(), calculationCase.getValidFrom());
        Plant plant = empl.getPlant();
        MaterialExpensesModel materialExpensesModel = null;
        if (boTP.getTypeOfCalculation() == TypeOfCalculation.CAR_PEDELEC) {
            materialExpensesModel = boTP.getCar().getOtherMaterialExpensesModel();
        }
        if (materialExpensesModel == null) {
            if (plant != null) {
                materialExpensesModel = plant.getPlantFoundations(calculationCase.getEffectiveFrom(), calculationCase.getValidFrom()).getFoundations().getMaterialExpensesModel();
            }
            if (materialExpensesModel == null) {
                materialExpensesModel = employee.getPCompany().getCompanyFoundations(calculationCase.getEffectiveFrom(), calculationCase.getValidFrom()).getFoundations().getMaterialExpensesModel();
            }
        }
        MaterialExpensesModelTP materialExpensesModelTP = null;
        if (materialExpensesModel != null) {
            materialExpensesModelTP = (MaterialExpensesModelTP)materialExpensesModel.getHistory().getItemOrNull(calculationCase.getEffectiveFrom(), calculationCase.getValidFrom());
        }
        if (boTP.getTypeOfCalculation() == TypeOfCalculation.CAR_PEDELEC) {
            vpList.addAll(ValuePosition.getCarCalculation(boTP, materialExpensesModelTP, effectiveFrom, validFrom, calculationCase.getEmployee()));
        } else if (boTP.getTypeOfCalculation() == TypeOfCalculation.EBIKE) {
            vpList.addAll(ValuePosition.getEBikeCalculation(boTP, materialExpensesModelTP, effectiveFrom, validFrom, calculationCase.getEmployee()));
        }
        return vpList;
    }

    private static List<ValuePosition> getCarCalculation(EEMaterialExpensesTP boTP, MaterialExpensesModelTP materialExpensesModelTP, Date effectiveFrom, Date validFrom, Employee employee) throws BusinessDomainException {
        ValuePosition vp;
        ValueType vt;
        ArrayList<ValuePosition> vpList = new ArrayList<ValuePosition>();
        BigDecimal bemessungsgrundlageGeldwerterVorteil = ValuePosition.ermittleBemessungsgrundlageGeldwerterVorteil(boTP.getCar().getListPrice(), boTP.getCar().getAssessmentBaseFactor().multiply(BigDecimal.valueOf(100L)));
        BigDecimal berechnungsgrundlageGeldwerterVorteil = ValuePosition.ermittleGeldwerterVorteil(bemessungsgrundlageGeldwerterVorteil);
        BigDecimal bemessungsgrundlageUmsatzsteuer = ValuePosition.ermittleBemessungsgrundlageGeldwerterVorteil(boTP.getCar().getListPrice(), BigDecimal.valueOf(100L));
        BigDecimal berechnungsgrundlageUmsatzsteuer = ValuePosition.ermittleGeldwerterVorteil(bemessungsgrundlageUmsatzsteuer);
        BigDecimal wertGVFahrtenPauschal = BigDecimal.ZERO;
        BigDecimal wertGVFahrten1 = BigDecimal.ZERO;
        BigDecimal wertGVFahrten2 = BigDecimal.ZERO;
        BigDecimal wertGVFahrten3 = BigDecimal.ZERO;
        BigDecimal wertGVUmSt = BigDecimal.ZERO;
        switch (boTP.getCar().getBenefitsCarFares().value()) {
            case 1: {
                wertGVFahrten3 = berechnungsgrundlageGeldwerterVorteil.multiply(boTP.getCar().getDistance()).multiply(BigDecimal.valueOf(3L, 2)).setScale(2, RoundingMode.HALF_UP);
                wertGVUmSt = berechnungsgrundlageUmsatzsteuer.multiply(boTP.getCar().getDistance()).multiply(BigDecimal.valueOf(3L, 2)).setScale(2, RoundingMode.HALF_UP);
                break;
            }
            case 4: {
                wertGVFahrten1 = berechnungsgrundlageGeldwerterVorteil.multiply(boTP.getCar().getNumberOfKilometersPerMonths()).multiply(BigDecimal.valueOf(1L, 3)).setScale(2, RoundingMode.HALF_UP);
                wertGVUmSt = berechnungsgrundlageUmsatzsteuer.multiply(boTP.getCar().getNumberOfKilometersPerMonths()).multiply(BigDecimal.valueOf(1L, 3)).setScale(2, RoundingMode.HALF_UP);
                break;
            }
            case 3: {
                BigDecimal kilometer = boTP.getCar().getDistance().multiply(BigDecimal.valueOf(boTP.getCar().getNumberOfDays()));
                wertGVFahrten2 = berechnungsgrundlageGeldwerterVorteil.multiply(kilometer).multiply(BigDecimal.valueOf(2L, 3)).setScale(2, RoundingMode.HALF_UP);
                wertGVUmSt = berechnungsgrundlageUmsatzsteuer.multiply(kilometer).multiply(BigDecimal.valueOf(2L, 3)).setScale(2, RoundingMode.HALF_UP);
                break;
            }
            case 2: {
                if (DateHelper.before((Date)validFrom, (Date)new VDate(2021, 0, 1).getDate())) {
                    wertGVFahrtenPauschal = BigDecimal.valueOf(15L).multiply(BigDecimal.valueOf(3L, 1)).multiply(boTP.getCar().getDistance()).setScale(2, RoundingMode.HALF_UP);
                } else {
                    BigDecimal ZWANZIG;
                    BigDecimal entfernungsKM = boTP.getCar().getDistance();
                    if (BigDecimalMapper.compareTo((BigDecimal)entfernungsKM, (BigDecimal)(ZWANZIG = BigDecimal.valueOf(20L))) > 0) {
                        BigDecimal kmUeberZwanzig = entfernungsKM.subtract(ZWANZIG);
                        wertGVFahrtenPauschal = BigDecimal.valueOf(15L).multiply(BigDecimal.valueOf(3L, 1)).multiply(ZWANZIG).setScale(2, RoundingMode.HALF_UP);
                        wertGVFahrtenPauschal = DateHelper.before((Date)validFrom, (Date)new VDate(2022, 0, 1).getDate()) ? wertGVFahrtenPauschal.add(BigDecimal.valueOf(15L).multiply(BigDecimal.valueOf(35L, 2)).multiply(kmUeberZwanzig).setScale(2, RoundingMode.HALF_UP)) : wertGVFahrtenPauschal.add(BigDecimal.valueOf(15L).multiply(BigDecimal.valueOf(38L, 2)).multiply(kmUeberZwanzig).setScale(2, RoundingMode.HALF_UP));
                    } else {
                        wertGVFahrtenPauschal = BigDecimal.valueOf(15L).multiply(BigDecimal.valueOf(3L, 1)).multiply(boTP.getCar().getDistance()).setScale(2, RoundingMode.HALF_UP);
                    }
                }
                wertGVFahrten3 = berechnungsgrundlageGeldwerterVorteil.multiply(boTP.getCar().getDistance()).multiply(BigDecimal.valueOf(3L, 2)).setScale(2, RoundingMode.HALF_UP);
                wertGVUmSt = berechnungsgrundlageUmsatzsteuer.multiply(boTP.getCar().getDistance()).multiply(BigDecimal.valueOf(3L, 2)).setScale(2, RoundingMode.HALF_UP);
                if (wertGVFahrten3.subtract(wertGVFahrtenPauschal).compareTo(BigDecimal.ZERO) < 0) {
                    wertGVFahrtenPauschal = wertGVFahrten3;
                    wertGVFahrten3 = BigDecimal.ZERO;
                    break;
                }
                wertGVFahrten3 = wertGVFahrten3.subtract(wertGVFahrtenPauschal);
            }
        }
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)boTP.getCar().getListPrice())) {
            vt = null;
            if (materialExpensesModelTP != null) {
                vt = materialExpensesModelTP.getValueTypeBase();
            }
            if (vt != null && (vp = ValuePosition.createValuePositionMaterialExpenses(employee, vt, boTP, effectiveFrom, validFrom, boTP.getCar().getListPrice())) != null) {
                vpList.add(vp);
            }
        }
        if (boTP.getCar().getPercentRegulation()) {
            vt = null;
            switch (TypeOfVehicle.toInt((TypeOfVehicle)boTP.getCar().getTypeOfVehicle())) {
                case 0: {
                    if (materialExpensesModelTP != null) {
                        vt = materialExpensesModelTP.getValueTypeBenefitCar();
                        break;
                    }
                    vt = boTP.getCar().getMonetaryBenefitValueType();
                    break;
                }
                case 1: {
                    if (materialExpensesModelTP == null) break;
                    vt = materialExpensesModelTP.getValueTypeBenefitHyprid();
                    break;
                }
                case 2: {
                    if (materialExpensesModelTP == null) break;
                    vt = materialExpensesModelTP.getValueTypeBenefitElectrical();
                    break;
                }
                case 3: {
                    if (materialExpensesModelTP == null) break;
                    vt = materialExpensesModelTP.getValueTypeBenefitPedelec();
                }
            }
            if (vt != null && (vp = ValuePosition.createValuePositionMaterialExpenses(employee, vt, boTP, effectiveFrom, validFrom, berechnungsgrundlageGeldwerterVorteil)) != null) {
                vp.setFactor2(bemessungsgrundlageGeldwerterVorteil);
                vpList.add(vp);
            }
        }
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)wertGVUmSt)) {
            vt = null;
            if (materialExpensesModelTP != null) {
                vt = materialExpensesModelTP.getValueTypeBaseRide();
            }
            if (vt != null && (vp = ValuePosition.createValuePositionMaterialExpenses(employee, vt, boTP, effectiveFrom, validFrom, wertGVUmSt)) != null) {
                vpList.add(vp);
            }
        }
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)wertGVFahrten3) && (vt = materialExpensesModelTP != null ? materialExpensesModelTP.getValueTypeWorkplace3() : boTP.getCar().getVTCarFares()) != null && (vp = ValuePosition.createValuePositionMaterialExpenses(employee, vt, boTP, effectiveFrom, validFrom, wertGVFahrten3)) != null) {
            vpList.add(vp);
        }
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)wertGVFahrtenPauschal)) {
            vt = null;
            vt = materialExpensesModelTP != null ? materialExpensesModelTP.getValueTypeWorkplaceLumpSum() : boTP.getCar().getVTLumpSum();
            if (vt != null && (vp = ValuePosition.createValuePositionMaterialExpenses(employee, vt, boTP, effectiveFrom, validFrom, wertGVFahrtenPauschal)) != null) {
                vpList.add(vp);
            }
        }
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)wertGVFahrten2)) {
            vt = null;
            if (materialExpensesModelTP != null) {
                vt = materialExpensesModelTP.getValueTypeWorkplace2();
            }
            if (vt != null && (vp = ValuePosition.createValuePositionMaterialExpenses(employee, vt, boTP, effectiveFrom, validFrom, wertGVFahrten2)) != null) {
                vpList.add(vp);
            }
        }
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)wertGVFahrten1)) {
            vt = null;
            if (materialExpensesModelTP != null) {
                vt = materialExpensesModelTP.getValueTypeWorkplace1();
            }
            if (vt != null && (vp = ValuePosition.createValuePositionMaterialExpenses(employee, vt, boTP, effectiveFrom, validFrom, wertGVFahrten1)) != null) {
                vpList.add(vp);
            }
        }
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)boTP.getCar().getPowerCost())) {
            vt = null;
            if (materialExpensesModelTP != null) {
                vt = materialExpensesModelTP.getValueTypePowerCost();
            }
            if (vt != null && (vp = ValuePosition.createValuePositionMaterialExpenses(employee, vt, boTP, effectiveFrom, validFrom, boTP.getCar().getPowerCost())) != null) {
                vpList.add(vp);
            }
        }
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)boTP.getCar().getVariableAmount())) {
            vt = null;
            if (materialExpensesModelTP != null) {
                vt = materialExpensesModelTP.getValueTypeVariableAmountCarPedelec();
            }
            if (vt != null && (vp = ValuePosition.createValuePositionMaterialExpenses(employee, vt, boTP, effectiveFrom, validFrom, boTP.getCar().getVariableAmount())) != null) {
                vpList.add(vp);
            }
        }
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)boTP.getCar().getOwnShare())) {
            vt = null;
            if (materialExpensesModelTP != null) {
                vt = materialExpensesModelTP.getValueTypeOwnShare();
            }
            if (vt != null && (vp = ValuePosition.createValuePositionMaterialExpenses(employee, vt, boTP, effectiveFrom, validFrom, boTP.getCar().getOwnShare())) != null) {
                vpList.add(vp);
            }
        }
        return vpList;
    }

    private static List<ValuePosition> getEBikeCalculation(EEMaterialExpensesTP boTP, MaterialExpensesModelTP materialExpensesModelTP, Date effectiveFrom, Date validFrom, Employee employee) throws BusinessDomainException {
        ArrayList<ValuePosition> vpList = new ArrayList<ValuePosition>();
        if (materialExpensesModelTP != null) {
            ValuePosition vp;
            ValueType vtLeasingAG;
            BigDecimal agLeistungen;
            ValuePosition vp2;
            ValueType vt;
            if (!BigDecimalMapper.isZeroOrNull((BigDecimal)boTP.getEbike().getListPrice()) && (vt = materialExpensesModelTP.getValueTypeBaseEbike()) != null && (vp2 = ValuePosition.createValuePositionMaterialExpenses(employee, vt, boTP, effectiveFrom, validFrom, boTP.getEbike().getListPrice())) != null) {
                vpList.add(vp2);
            }
            if (boTP.getEbike().getTypeOfFinancing() == TypeOfFinancing.ENTGELTUMWANDLUNG) {
                ValueType vt2;
                ValuePosition vp3;
                ValueType vtUmwandlung;
                if (boTP.getEbike().getBenefitPrivateUse()) {
                    ValuePosition vp4;
                    ValueType vt3;
                    BigDecimal berechnungsgrundlageGeldwerterVorteil = BigDecimal.ZERO;
                    if (boTP.getEbike().getBenefitPrivateUse()) {
                        berechnungsgrundlageGeldwerterVorteil = ValuePosition.ermittleGeldwerterVorteilEBike(boTP);
                    }
                    if (!BigDecimalMapper.isZeroOrNull((BigDecimal)berechnungsgrundlageGeldwerterVorteil) && (vt3 = materialExpensesModelTP.getValueTypeEbikeMandatory()) != null && (vp4 = ValuePosition.createValuePositionMaterialExpenses(employee, vt3, boTP, effectiveFrom, validFrom, berechnungsgrundlageGeldwerterVorteil)) != null) {
                        vpList.add(vp4);
                    }
                }
                BigDecimal leasingRate = boTP.getEbike().getLeasingRate();
                BigDecimal agLeistung = boTP.getEbike().getChargeCompensation();
                if (!BigDecimalMapper.isZeroOrNull((BigDecimal)leasingRate) && (vtUmwandlung = materialExpensesModelTP.getValueTypeEmployeeLeasingRate()) != null && (vp3 = ValuePosition.createValuePositionMaterialExpenses(employee, vtUmwandlung, boTP, effectiveFrom, validFrom, leasingRate)) != null) {
                    vpList.add(vp3);
                }
                if (!BigDecimalMapper.isZeroOrNull((BigDecimal)agLeistung) && (vt2 = materialExpensesModelTP.getValueTypeEmployerRate()) != null && (vp3 = ValuePosition.createValuePositionMaterialExpenses(employee, vt2, boTP, effectiveFrom, validFrom, agLeistung)) != null) {
                    vpList.add(vp3);
                }
            } else if (boTP.getEbike().getBenefitPrivateUse() && !BigDecimalMapper.isZeroOrNull((BigDecimal)(agLeistungen = ValuePosition.ermittleGeldwerterVorteilEBike(boTP))) && (vtLeasingAG = materialExpensesModelTP.getValueTypeEbikeFree()) != null && (vp = ValuePosition.createValuePositionMaterialExpenses(employee, vtLeasingAG, boTP, effectiveFrom, validFrom, agLeistungen)) != null) {
                vpList.add(vp);
            }
            if (!BigDecimalMapper.isZeroOrNull((BigDecimal)boTP.getEbike().getEEServiceCost()) && (vt = materialExpensesModelTP.getValueTypeServiceCost()) != null && (vp2 = ValuePosition.createValuePositionMaterialExpenses(employee, vt, boTP, effectiveFrom, validFrom, boTP.getEbike().getEEServiceCost())) != null) {
                vpList.add(vp2);
            }
            if (!BigDecimalMapper.isZeroOrNull((BigDecimal)boTP.getEbike().getVariableAmount())) {
                vt = null;
                if (materialExpensesModelTP != null) {
                    vt = materialExpensesModelTP.getValueTypeVariableAmountEbike();
                }
                if (vt != null && (vp2 = ValuePosition.createValuePositionMaterialExpenses(employee, vt, boTP, effectiveFrom, validFrom, boTP.getEbike().getVariableAmount())) != null) {
                    vpList.add(vp2);
                }
            }
        }
        return vpList;
    }

    private static BigDecimal ermittleGeldwerterVorteilEBike(EEMaterialExpensesTP boTP) {
        BigDecimal multiplikator = DateHelper.afterOrEqual((Date)boTP.getEbike().getDateOfStartUp(), (Date)new VDate(2019, 0, 1).getDate()) ? BigDecimal.valueOf(25L) : BigDecimal.valueOf(100L);
        BigDecimal bemessungsgrundlageGWV = ValuePosition.ermittleBemessungsgrundlageGeldwerterVorteil(boTP.getEbike().getListPrice(), multiplikator);
        return ValuePosition.ermittleGeldwerterVorteil(bemessungsgrundlageGWV);
    }

    private static BigDecimal ermittleBemessungsgrundlageGeldwerterVorteil(BigDecimal listenPreis, BigDecimal multiplikator) {
        BigDecimal bemessungsgrundlageGeldwerterVorteil = listenPreis;
        bemessungsgrundlageGeldwerterVorteil = bemessungsgrundlageGeldwerterVorteil.divide(BigDecimal.valueOf(100L), 0, RoundingMode.DOWN).multiply(multiplikator);
        bemessungsgrundlageGeldwerterVorteil = bemessungsgrundlageGeldwerterVorteil.divide(BigDecimal.valueOf(100L), 0, RoundingMode.DOWN).multiply(BigDecimal.valueOf(100L));
        return bemessungsgrundlageGeldwerterVorteil;
    }

    private static BigDecimal ermittleGeldwerterVorteil(BigDecimal bemessungsgrundlageGeldwerterVorteil) {
        return bemessungsgrundlageGeldwerterVorteil.divide(BigDecimal.valueOf(100L), 0, RoundingMode.DOWN);
    }

    private static ValuePosition createValuePositionMaterialExpenses(Employee employee, ValueType vt, EEMaterialExpensesTP boTP, Date effectiveFrom, Date validFrom, BigDecimal result) throws BusinessDomainException {
        ValuePosition vp = null;
        vp = ValuePosition.createValuePosition(employee, vt, (PersistentObject)boTP, effectiveFrom, boTP.getEffectiveUntil(), validFrom, boTP.getValidUntil());
        if (vp != null) {
            vp.setResult(result);
            vp.setBasicResult(result);
        }
        return vp;
    }

    public static ValuePosition create(AdvancePaymentTP boTP, CalculationCase calculationCase) throws BusinessDomainException {
        ValuePosition vp = null;
        if (DateHelper.between((Date)boTP.getValidFrom(), (Date)calculationCase.getValidFrom(), (Date)DateHelper.getLastDayOfMonth((Date)calculationCase.getValidFrom())) || DateHelper.before((Date)boTP.getValidFrom(), (Date)calculationCase.getValidFrom())) {
            Date effectiveFrom = calculationCase.getEffectiveFrom();
            Date validFrom = calculationCase.getValidFrom();
            if (DateHelper.afterOrEqual((Date)boTP.getEffectiveFrom(), (Date)calculationCase.getEffectiveFrom())) {
                effectiveFrom = boTP.getEffectiveFrom();
            }
            if (DateHelper.afterOrEqual((Date)boTP.getValidFrom(), (Date)calculationCase.getValidFrom())) {
                validFrom = boTP.getValidFrom();
            }
            if ((vp = ValuePosition.createValuePosition(calculationCase.getEmployee(), boTP.getAdvancePayment().getValueType(), (PersistentObject)boTP, effectiveFrom, boTP.getEffectiveUntil(), validFrom, boTP.getValidUntil())) != null) {
                vp.setFactor1(boTP.getFactor1());
                vp.setFactor2(boTP.getFactor2());
                vp.setResult(boTP.getResult());
                vp.setPercentage(boTP.getPercentage());
                vp.setPerformanceFactor(boTP.getPerformanceFactor());
                vp.setBasicFactor1(boTP.getFactor1());
                vp.setBasicFactor2(boTP.getFactor2());
                vp.setBasicResult(boTP.getResult());
                vp.setBasicPercentage(boTP.getPercentage());
                vp.setBasicPerformanceFactor(boTP.getPerformanceFactor());
            }
        }
        return vp;
    }

    public static ValuePosition create(EERelativeTP boTP, CalculationCase calculationCase) throws BusinessDomainException {
        ChildAllowanceTP[] tps = ChildAllowance.getChildAllowances((Date)calculationCase.getValidFrom());
        if (tps.length == 0) {
            throw FrameWorkExceptionMapper.makeInputIsMissingDomainException((String)"Globale Vorgaben zur Kindergeldberechnung");
        }
        ChildAllowanceTP childAllowanceTP = tps[0];
        ValueType vt = ValueType.getValueType((String)childAllowanceTP.getOidValueType());
        if (vt == null) {
            throw FrameWorkExceptionMapper.makeInputIsMissingDomainException((String)"Globale Vorgaben zur Kindergeldberechnung - Wertart Kindergeld");
        }
        Date effectiveFrom = calculationCase.getEffectiveFrom();
        Date validFrom = calculationCase.getValidFrom();
        if (DateHelper.after((Date)boTP.getEffectiveFrom(), (Date)calculationCase.getEffectiveFrom())) {
            effectiveFrom = boTP.getEffectiveFrom();
        }
        if (DateHelper.after((Date)boTP.getValidFrom(), (Date)calculationCase.getValidFrom())) {
            validFrom = boTP.getValidFrom();
        }
        ValuePosition vp = ValuePosition.createValuePosition(calculationCase.getEmployee(), vt, (PersistentObject)boTP, effectiveFrom, boTP.getEffectiveUntil(), validFrom, boTP.getValidUntil());
        vp.setRootGenesisOfParentObjects((PersistentObject)boTP.getEERelative());
        return vp;
    }

    private static ValuePosition createValuePosition(Employee employee, ValueType vt, PersistentObject genesis, Date effectiveFrom, Date effectiveUntil, Date validFrom, Date validUntil) throws BusinessDomainException {
        ValuePosition vp = null;
        if (ValuePosition.checkCreateByInterval(vt, effectiveFrom, validFrom)) {
            vp = new ValuePosition(employee, vt, genesis, genesis);
            vp.setEffectiveFrom(effectiveFrom);
            vp.setEffectiveUntil(effectiveUntil);
            vp.setValidFrom(validFrom);
            vp.setValidUntil(validUntil);
            vp.setFactor1(BigDecimal.ZERO);
            vp.setFactor2(BigDecimal.ZERO);
            vp.setResult(BigDecimal.ZERO);
            vp.setPercentage(BigDecimal.ZERO);
            vp.setPerformanceFactor(BigDecimal.ZERO);
            vp.setCostCenter(null);
            vp.setCostUnit(null);
            vp.setPersistentBuffer1(BigDecimal.ZERO);
            vp.setPersistentBuffer2(BigDecimal.ZERO);
            vp.setPersistentBuffer3(BigDecimal.ZERO);
            vp.setPersistentBuffer4(BigDecimal.ZERO);
            vp.setPersistentBuffer5(BigDecimal.ZERO);
            vp.setEraCorrectionFactor(BigDecimal.ZERO);
            vp.setEraValue(BigDecimal.ZERO);
            vp.setBasicFactor1(BigDecimal.ZERO);
            vp.setBasicFactor2(BigDecimal.ZERO);
            vp.setBasicResult(BigDecimal.ZERO);
            vp.setBasicPercentage(BigDecimal.ZERO);
            vp.setBasicPerformanceFactor(BigDecimal.ZERO);
            vp.setBasicCostCenter(null);
            vp.setBasicCostUnit(null);
            vp.setBufferFactor1(BigDecimal.ZERO);
            vp.setBufferFactor2(BigDecimal.ZERO);
            vp.setBufferResult(BigDecimal.ZERO);
            vp.setBufferPercentage(BigDecimal.ZERO);
            vp.setBufferPerformanceFactor(BigDecimal.ZERO);
            vp.setBufferCostCenter(null);
            vp.setBufferCostUnit(null);
        }
        return vp;
    }

    public void setBvCopied(boolean b) {
        this.mBvCopied = b;
    }

    public boolean isBvCopied() {
        return this.mBvCopied;
    }

    private static IEmployeePersistencyManager getIEmployeePM() {
        return (IEmployeePersistencyManager)UtilitiesManager.getBean((String)"employeePersistencyManager", IEmployeePersistencyManager.class);
    }

    public void set23cPflichtig(boolean b) {
        this.m23cPflichtig = b;
    }

    public boolean is23cPflichtig() {
        return this.m23cPflichtig;
    }

    private static OriginatorFactory getOriginatorFactory() {
        return (OriginatorFactory)UtilitiesManager.getBean((String)"originatorFactory", OriginatorFactory.class);
    }

    public void interpretationConsequence(ValuePosition basicVP, ConsequenceOfValueType covt) throws BusinessDomainException {
        CostUnit cu;
        CostCenter cc;
        switch (covt.getDelivieredFactor1().value()) {
            case 4: {
                this.setFactor1(this.getFactor1().add(basicVP.getFactor1()));
                break;
            }
            case 5: {
                this.setFactor2(this.getFactor2().add(basicVP.getFactor1()));
                break;
            }
            case 6: {
                this.setResult(this.getResult().add(basicVP.getFactor1()));
                break;
            }
            case 7: {
                this.setFactor1(this.getFactor1().add(basicVP.getBufferFactor1()));
                break;
            }
            case 8: {
                this.setFactor2(this.getFactor2().add(basicVP.getBufferFactor1()));
                break;
            }
            case 9: {
                this.setResult(this.getResult().add(basicVP.getBufferFactor1()));
                break;
            }
            case 1: {
                this.setFactor1(this.getFactor1().add(basicVP.getBasicFactor1()));
                break;
            }
            case 2: {
                this.setFactor2(this.getFactor2().add(basicVP.getBasicFactor1()));
                break;
            }
            case 3: {
                this.setResult(this.getResult().add(basicVP.getBasicFactor1()));
                break;
            }
        }
        switch (covt.getDelivieredFactor2().value()) {
            case 5: {
                this.setFactor1(this.getFactor1().add(basicVP.getFactor2()));
                break;
            }
            case 4: {
                this.setFactor2(this.getFactor2().add(basicVP.getFactor2()));
                break;
            }
            case 6: {
                this.setResult(this.getResult().add(basicVP.getFactor2()));
                break;
            }
            case 8: {
                this.setFactor1(this.getFactor1().add(basicVP.getBufferFactor2()));
                break;
            }
            case 7: {
                this.setFactor2(this.getFactor2().add(basicVP.getBufferFactor2()));
                break;
            }
            case 9: {
                this.setResult(this.getResult().add(basicVP.getBufferFactor2()));
                break;
            }
            case 2: {
                this.setFactor1(this.getFactor1().add(basicVP.getBasicFactor2()));
                break;
            }
            case 1: {
                this.setFactor2(this.getFactor2().add(basicVP.getBasicFactor2()));
                break;
            }
            case 3: {
                this.setResult(this.getResult().add(basicVP.getBasicFactor2()));
                break;
            }
        }
        switch (covt.getDelivieredResult().value()) {
            case 5: {
                this.setFactor1(this.getFactor1().add(basicVP.getResult()));
                break;
            }
            case 6: {
                this.setFactor2(this.getFactor2().add(basicVP.getResult()));
                break;
            }
            case 4: {
                this.setResult(this.getResult().add(basicVP.getResult()));
                break;
            }
            case 8: {
                this.setFactor1(this.getFactor1().add(basicVP.getBufferResult()));
                break;
            }
            case 9: {
                this.setFactor2(this.getFactor2().add(basicVP.getBufferResult()));
                break;
            }
            case 7: {
                this.setResult(this.getResult().add(basicVP.getBufferResult()));
                break;
            }
            case 2: {
                this.setFactor1(this.getFactor1().add(basicVP.getBasicResult()));
                break;
            }
            case 3: {
                this.setFactor2(this.getFactor2().add(basicVP.getBasicResult()));
                break;
            }
            case 1: {
                this.setResult(this.getResult().add(basicVP.getBasicResult()));
                break;
            }
        }
        switch (covt.getDelivieredPercentage().value()) {
            case 1: {
                if (BigDecimalMapper.compareTo((BigDecimal)this.getPercentage(), (BigDecimal)basicVP.getPercentage()) == 0) break;
                throw EvaluationExceptionMapper.makeNoDifferentPercentageOnOneTimeCreate(this.getValueType().getValueTypeKey(), basicVP.getValueType().getValueTypeKey(), this.getValidFrom());
            }
            case 2: {
                if (BigDecimalMapper.compareTo((BigDecimal)this.getPercentage(), (BigDecimal)basicVP.getBufferPercentage()) == 0) break;
                throw EvaluationExceptionMapper.makeNoDifferentPercentageOnOneTimeCreate(this.getValueType().getValueTypeKey(), basicVP.getValueType().getValueTypeKey(), this.getValidFrom());
            }
        }
        switch (covt.getDelivieredPerformanceFactor().value()) {
            case 1: {
                if (BigDecimalMapper.compareTo((BigDecimal)this.getPerformanceFactor(), (BigDecimal)basicVP.getPerformanceFactor()) == 0) break;
                throw EvaluationExceptionMapper.makeNoDifferentPerformanceFactorOnOneTimeCreate(this.getValueType().getValueTypeKey(), basicVP.getValueType().getValueTypeKey(), this.getValidFrom());
            }
            case 2: {
                if (BigDecimalMapper.compareTo((BigDecimal)this.getPerformanceFactor(), (BigDecimal)basicVP.getPerformanceFactor()) == 0) break;
                throw EvaluationExceptionMapper.makeNoDifferentPerformanceFactorOnOneTimeCreate(this.getValueType().getValueTypeKey(), basicVP.getValueType().getValueTypeKey(), this.getValidFrom());
            }
        }
        switch (covt.getDelivieredCostCenter().value()) {
            case 2: {
                cc = this.getEmployee().getEmployment(this.getEffectiveFrom(), this.getValidFrom()).getCostCenter();
                if (this.getCostCenter().compareTo((PersistentBusinessObject)cc) == 0) break;
                throw EvaluationExceptionMapper.makeNoDifferentCostCenterOnOneTimeCreate(this.getValueType().getValueTypeKey(), basicVP.getValueType().getValueTypeKey(), this.getValidFrom());
            }
            case 1: {
                if (this.getCostCenter().compareTo((PersistentBusinessObject)basicVP.getCostCenter()) == 0) break;
                throw EvaluationExceptionMapper.makeNoDifferentCostCenterOnOneTimeCreate(this.getValueType().getValueTypeKey(), basicVP.getValueType().getValueTypeKey(), this.getValidFrom());
            }
            case 3: {
                if (this.getCostCenter().compareTo((PersistentBusinessObject)basicVP.getBufferCostCenter()) == 0) break;
                throw EvaluationExceptionMapper.makeNoDifferentCostCenterOnOneTimeCreate(this.getValueType().getValueTypeKey(), basicVP.getValueType().getValueTypeKey(), this.getValidFrom());
            }
        }
        switch (covt.getDelivieredCostUnit().value()) {
            case 2: {
                cu = this.getEmployee().getEmployment(this.getEffectiveFrom(), this.getValidFrom()).getCostUnit();
                if (this.getCostUnit().compareTo((PersistentBusinessObject)cu) == 0) break;
                throw EvaluationExceptionMapper.makeNoDifferentCostUnitOnOneTimeCreate(this.getValueType().getValueTypeKey(), basicVP.getValueType().getValueTypeKey(), this.getValidFrom());
            }
            case 1: {
                if (this.getCostUnit().compareTo((PersistentBusinessObject)basicVP.getCostUnit()) == 0) break;
                throw EvaluationExceptionMapper.makeNoDifferentCostUnitOnOneTimeCreate(this.getValueType().getValueTypeKey(), basicVP.getValueType().getValueTypeKey(), this.getValidFrom());
            }
            case 3: {
                if (this.getCostUnit().compareTo((PersistentBusinessObject)basicVP.getBufferCostUnit()) == 0) break;
                throw EvaluationExceptionMapper.makeNoDifferentCostUnitOnOneTimeCreate(this.getValueType().getValueTypeKey(), basicVP.getValueType().getValueTypeKey(), this.getValidFrom());
            }
        }
        switch (covt.getBufferFactor1().value()) {
            case 2: {
                this.setBufferFactor1(this.getBufferFactor1().add(basicVP.getFactor1()));
                break;
            }
            case 1: {
                this.setBufferFactor1(this.getBasicFactor1().add(basicVP.getBasicFactor1()));
                break;
            }
        }
        switch (covt.getBufferFactor2().value()) {
            case 2: {
                this.setBufferFactor2(this.getBasicFactor2().add(basicVP.getFactor2()));
                break;
            }
            case 1: {
                this.setBufferFactor2(this.getBasicFactor2().add(basicVP.getBasicFactor2()));
                break;
            }
        }
        switch (covt.getBufferResult().value()) {
            case 2: {
                this.setBufferResult(this.getBufferResult().add(basicVP.getResult()));
                break;
            }
            case 1: {
                this.setBufferResult(this.getBufferResult().add(basicVP.getBasicResult()));
                break;
            }
        }
        switch (covt.getBufferPercentage().value()) {
            case 1: {
                if (BigDecimalMapper.compareTo((BigDecimal)this.getBasicPercentage(), (BigDecimal)basicVP.getPercentage()) == 0) break;
                throw EvaluationExceptionMapper.makeNoDifferentBufferPercentageOnOneTimeCreate(this.getValueType().getValueTypeKey(), basicVP.getValueType().getValueTypeKey(), this.getValidFrom());
            }
        }
        switch (covt.getBufferPerformanceFactor().value()) {
            case 1: {
                if (BigDecimalMapper.compareTo((BigDecimal)this.getBufferPerformanceFactor(), (BigDecimal)basicVP.getPerformanceFactor()) == 0) break;
                throw EvaluationExceptionMapper.makeNoDifferentBufferPerformanceFactorOnOneTimeCreate(this.getValueType().getValueTypeKey(), basicVP.getValueType().getValueTypeKey(), this.getValidFrom());
            }
        }
        switch (covt.getBufferCostCenter().value()) {
            case 2: {
                cc = this.getEmployee().getEmployment(this.getEffectiveFrom(), this.getValidFrom()).getCostCenter();
                if (this.getBufferCostCenter().compareTo((PersistentBusinessObject)cc) == 0) break;
                throw EvaluationExceptionMapper.makeNoDifferentBufferCostCenterOnOneTimeCreate(this.getValueType().getValueTypeKey(), basicVP.getValueType().getValueTypeKey(), this.getValidFrom());
            }
            case 1: {
                if (this.getBufferCostCenter().compareTo((PersistentBusinessObject)basicVP.getCostCenter()) == 0) break;
                throw EvaluationExceptionMapper.makeNoDifferentBufferCostCenterOnOneTimeCreate(this.getValueType().getValueTypeKey(), basicVP.getValueType().getValueTypeKey(), this.getValidFrom());
            }
        }
        switch (covt.getBufferCostUnit().value()) {
            case 2: {
                cu = this.getEmployee().getEmployment(this.getEffectiveFrom(), this.getValidFrom()).getCostUnit();
                if (this.getBufferCostUnit().compareTo((PersistentBusinessObject)cu) == 0) break;
                throw EvaluationExceptionMapper.makeNoDifferentBufferCostUnitOnOneTimeCreate(this.getValueType().getValueTypeKey(), basicVP.getValueType().getValueTypeKey(), this.getValidFrom());
            }
            case 1: {
                if (this.getBufferCostUnit().compareTo((PersistentBusinessObject)basicVP.getCostUnit()) == 0) break;
                throw EvaluationExceptionMapper.makeNoDifferentBufferCostUnitOnOneTimeCreate(this.getValueType().getValueTypeKey(), basicVP.getValueType().getValueTypeKey(), this.getValidFrom());
            }
        }
    }

    public ValuePosition getValuePositionFromGenesisParent() {
        ValuePosition result = null;
        PersistentObject genesis = this.getGenesisOfParentObjects();
        while (genesis instanceof ValuePosition) {
            result = (ValuePosition)genesis;
            genesis = result.getGenesisOfParentObjects();
        }
        return result;
    }

    public static boolean checkCreateByInterval(ValueType vt, Date effectiveFrom, Date validFrom) throws BusinessDomainException {
        FoundationGeneral foundationGeneral;
        boolean createInThisMonth = true;
        if (vt.getValueTypeKey() < 100000 && (foundationGeneral = vt.getValueTypeTP(effectiveFrom, validFrom).getValueTypeFoundation().getGeneral()).getUseIntervalInCalculation()) {
            createInThisMonth = ValuePosition.checkInterval(foundationGeneral.getInterval(), validFrom);
        }
        return createInThisMonth;
    }
}

