/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.elo2.transfer;

import com.varial.base.UtilitiesManager;
import com.varial.base.exception.ApplicationException;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.criterion.Conjunction;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Order;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.security.AuthorizationToken;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.calculation.EmployeeCalculate;
import com.varial.personnel.domain.companyplant.TaxNumberBean;
import com.varial.personnel.domain.elo2.AdviceStateEnum;
import com.varial.personnel.domain.elo2.BaseProtocolContent;
import com.varial.personnel.domain.elo2.CompOrPlantDetails;
import com.varial.personnel.domain.elo2.DetailMarker;
import com.varial.personnel.domain.elo2.ProtocolContentEmployeeData;
import com.varial.personnel.domain.elo2.ProtocolContentType;
import com.varial.personnel.domain.elo2.ReasonOfDeliveryEnum;
import com.varial.personnel.domain.elo2.ReceiveAGProtocolContent;
import com.varial.personnel.domain.elo2.ReceiveProtocolDetailContent;
import com.varial.personnel.domain.elo2.ReceiveProtocolHandler;
import com.varial.personnel.domain.elo2.account.Elo2Account;
import com.varial.personnel.domain.elo2.account.Elo2AccountPersistencyManager;
import com.varial.personnel.domain.elo2.dueab.Elo2Dueab;
import com.varial.personnel.domain.elo2.duean.Elo2Duean;
import com.varial.personnel.domain.elo2.dueum.Elo2Dueum;
import com.varial.personnel.domain.elo2.elstam.Elo2Elstam;
import com.varial.personnel.domain.elo2.elstam.Elo2ElstamTemp;
import com.varial.personnel.domain.elo2.mapper.AdviceStateEnumMapper;
import com.varial.personnel.domain.elo2.mapper.Elo2ExceptionMapper;
import com.varial.personnel.domain.elo2.mapper.ReasonOfDeliveryEnumMapper;
import com.varial.personnel.domain.elo2.transfer.BaseProtocolContentComparator;
import com.varial.personnel.domain.elo2.transfer.Elo2Action;
import com.varial.personnel.domain.elo2.transfer.Elo2ConfirmDataBean;
import com.varial.personnel.domain.elo2.transfer.Elo2Transfer;
import com.varial.personnel.domain.elo2.transfer.Elo2Verfahrenshinweis;
import com.varial.personnel.domain.elo2.transfer.Elo2Verfahrenshinweise;
import com.varial.personnel.domain.elo2.transfer.PerfidiaResult;
import com.varial.personnel.domain.elo2.transfer.ProtocolDetailComparator;
import com.varial.personnel.domain.elo2.transfer.ReceiveProtocolComparator;
import com.varial.personnel.domain.employee.Employee;
import com.varial.personnel.domain.employee.EmployeeHelper;
import com.varial.personnel.domain.employee.IEmployeePersistencyManager;
import com.varial.personnel.domain.employee.mapper.EmployeeExceptionMapper;
import com.varial.personnel.domain.employee.master.Master;
import com.varial.personnel.domain.employee.tax.ChurchTaxEnum;
import com.varial.personnel.domain.employee.tax.IncomeTaxReturnYYEnum;
import com.varial.personnel.domain.employee.tax.PAYETaxFindingsEnum;
import com.varial.personnel.domain.employee.tax.Tax;
import com.varial.personnel.domain.employee.tax.mapper.ChurchTaxEnumMapper;
import com.varial.personnel.domain.global.federalstate.FederalState;
import com.varial.personnel.domain.pcompany.PCompany;
import com.varial.personnel.framework.IValuationManager;
import com.varial.personnel.framework.PFileHelper;
import com.varial.personnel.persistency.employee.taxall.ITaxallDao;
import com.varial.personnel.persistency.employee.taxall.TaxallContainer;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BooleanMapper;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.StringMapper;
import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.IncorrectResultSizeDataAccessException;

public class Elo2Receive {
    private static ITaxallDao taxAllDao = (ITaxallDao)UtilitiesManager.getApplicationContext().getBean("taxallDao");
    private static final int LENGTH_TO_FILENUMBER = 173;
    private static final String PERFIDIA_CONFIRM_PATH = "/ofd/sendq/";
    private static final String PERFIDIA_CONFIRM_PREFIX = "PFDEQ0_";
    private static final Pattern VOSZ = Pattern.compile("VOSZ01..(\\d{8})(\\d{6})(.{2})(\\d{9})(\\d{18})(\\d{7})(.{65})(.{50})");
    private static final Pattern ARBG = Pattern.compile("ARBGSZ01(\\d{13})(\\d{6})(\\d{9})(.{255})(.{221})");
    private static final Pattern ELSTAM = Pattern.compile("ELSTAM01(\\d{13})(.{20})(\\d{11})(\\d{8})(\\d{1})(\\d{4})(\\d{10})(\\d{10})(\\d{10})(\\d{10})(\\d{10})(\\d{10})(\\d{10})(\\d{10})(\\d{3})(.{2})(.{2})(\\d{9})(.{255})(.{96})");
    private static Logger LOGGER = LoggerFactory.getLogger(Elo2Receive.class);
    private static final String ANMELD_LISTE = "ANMELDEBESTAETIGUNGSLISTE";
    private static final String ABMELD_LISTE = "ABMELDEBESTAETIGUNGSLISTE";
    private static final String UMMELD_LISTE = "UMMELDEBESTAETIGUNGSLISTE";
    private static final String MONATS_LISTE = "MONATSLISTE";
    private static final String BRUTTO_LISTE = "BRUTTOLISTE";
    private final PerfidiaResult mPerfidiaResult;
    private final DateFormat mDateFormat;
    private ReasonOfDeliveryEnum currentReasonOfDelivery;
    private ReasonOfDeliveryEnum additionalReasonOfDelivery;
    private final ReasonOfDeliveryEnum initialReasonOfDelivery;
    private final Deque<Elo2Account> mElo2Accounts;
    private final List<Elo2ConfirmDataBean> confirmBeans;
    private final List<ForValuation> emplTaxListForValuation = new ArrayList<ForValuation>();
    private final File currentFile;
    private String currentFileNumber = "0";
    private String currentCreationDate;
    private final ReceiveProtocolHandler protocolHandler;
    private String compObjId;
    private final Map<String, Integer> persNrList;
    private final List<String> oidEmployeesWithAutomaticLstJa = new ArrayList<String>();
    private final BigDecimal ZERO = BigDecimal.ZERO;
    protected final Date currentDate;
    private boolean mRepeatPerfidiaFile;

    public Elo2Receive(AuthorizationToken token, File fileToRead, Map<String, Integer> persNrList, ReasonOfDeliveryEnum currentReason) throws BusinessDomainException {
        this.mDateFormat = new SimpleDateFormat("yyyyMMdd");
        this.mDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.mPerfidiaResult = new PerfidiaResult();
        this.mElo2Accounts = new LinkedList<Elo2Account>();
        this.confirmBeans = new ArrayList<Elo2ConfirmDataBean>();
        this.currentFile = fileToRead;
        this.initialReasonOfDelivery = currentReason;
        this.persNrList = persNrList;
        this.protocolHandler = new ReceiveProtocolHandler(this.currentFile, this.initialReasonOfDelivery);
        this.currentDate = new VDate().getDate();
    }

    public ReceiveProtocolHandler getProtocolHandler() {
        return this.protocolHandler;
    }

    public void addProtocolContent(ProtocolContentEmployeeData employeeData, String message, DetailMarker detail, String agStId, String ordnungsMerkmal, Elo2Verfahrenshinweis hinweis) {
        ReceiveProtocolDetailContent cont = new ReceiveProtocolDetailContent(employeeData, detail, hinweis);
        cont.setAgStId(agStId);
        if (employeeData != null) {
            cont.setCompOrPlantKey(employeeData.getCompanyKey());
        }
        if (!StringMapper.isNullString((String)message)) {
            cont.addMessage(message);
        }
        if (hinweis != null && hinweis.getAction() != null && hinweis.getAction() != Elo2Action.CLOSE_ACCOUNT && hinweis.getAction() != Elo2Action.CLOSE_ACCOUNT_OK_PROTOCOL && hinweis.getAction() != Elo2Action.PROTOCOL_DETAILS_FORMATTED && hinweis.getAction() != Elo2Action.CLOSE_NEWREFDATE) {
            cont.setCreateOrSetAccount(false);
        } else {
            cont.setProtocolContentType(ProtocolContentType.AN_CONTENT);
        }
        this.protocolHandler.addProtocolContent(agStId + "/" + cont.getCompanyKey(), (BaseProtocolContent)cont);
    }

    public void readFile() throws BusinessDomainException {
        PFileHelper.checkFile((File)this.currentFile, (String)"Elstam-Meldung");
        CharSequence content = PFileHelper.getFileContent((File)this.currentFile, (String)"ISO-8859-1", (int)173);
        Matcher matcher = VOSZ.matcher(content);
        if (matcher.matches()) {
            this.checkForReasonOfDelivery(matcher.group(8));
            this.currentFileNumber = matcher.group(6);
            this.currentCreationDate = this.getCreationDate(matcher.group(1));
            this.protocolHandler.setPerfidiaFileNumber(Integer.parseInt(this.currentFileNumber));
            this.protocolHandler.setPerfidiaFilePathAndName(this.currentFile);
            this.protocolHandler.setPerfidiaFileCreation(this.currentCreationDate);
            LinkedList records = PFileHelper.getFileLines((File)this.currentFile, (String)"ISO-8859-1");
            this.checkVosz((String)records.pollFirst());
            this.checkNcsz((String)records.pollLast(), records.size());
            while (!records.isEmpty()) {
                String lineContent = (String)records.pollFirst();
                if (this.isARBGLine(lineContent)) continue;
                this.isElstamLine(lineContent);
            }
            this.checkDetails();
            if (!StringMapper.isNullString((String)this.compObjId)) {
                if (this.confirmBeans.isEmpty()) {
                    this.confirmBeans.add(new Elo2ConfirmDataBean(this.getConfirmDataType(), "0", this.currentFileNumber));
                }
                Elo2Transfer transferConfirm = new Elo2Transfer(this.compObjId, null, PERFIDIA_CONFIRM_PATH, PERFIDIA_CONFIRM_PREFIX, this.currentReasonOfDelivery, null, this.getCurrentFileNameWithoutExtension());
                transferConfirm.setConfirmDataList(this.confirmBeans);
                transferConfirm.exportConfirm();
            }
        } else {
            this.addProtocolContent(this.getEmptyEmployeeDataForProtocol(), "Vorlaufsatz ist nicht korrekt. Datei kann nicht eingelesen werden: " + this.currentFile.getAbsolutePath(), null, "", "", new Elo2Verfahrenshinweis("", Elo2Action.ONLY_PROTOCOL));
        }
    }

    private String getCurrentFileNameWithoutExtension() {
        return this.currentFile.getName().replaceFirst("[.][^.]+$", "");
    }

    private String getCreationDate(String crDate) {
        if (StringMapper.isNullString((String)crDate)) {
            return crDate;
        }
        Date d = null;
        try {
            d = this.mDateFormat.parse(crDate);
            return DateMapper.toDDMMYYYYPointSeparationString((Date)d);
        }
        catch (ParseException parseException) {
            return "";
        }
    }

    private boolean isARBGLine(String input) throws BusinessDomainException {
        Matcher m = ARBG.matcher(input);
        if (!m.matches()) {
            return false;
        }
        String stID = m.group(1);
        String vhCode = m.group(3);
        String vhMessage = m.group(4);
        String compKey = this.fillCompOrPlantDetails(stID);
        Elo2Verfahrenshinweis hinweis = Elo2Verfahrenshinweise.getAGActionForVH((String)vhCode);
        if (hinweis != null) {
            ReceiveAGProtocolContent cont = new ReceiveAGProtocolContent(hinweis);
            cont.setAgStId(stID);
            cont.setCompOrPlantKey(compKey);
            if (!StringMapper.isNullString((String)vhMessage)) {
                hinweis.setMessage(vhMessage);
                cont.addMessage(vhMessage);
            }
            this.protocolHandler.addProtocolContent(stID + "/" + compKey, (BaseProtocolContent)cont);
        }
        return true;
    }

    private void fillCompOrPlantDetailsPerKey(String taxId, String compOrPlantKey) throws BusinessDomainException {
        TaxNumberBean[] taxNumbers = PCompany.getTaxNumberBean();
        Object employerTaxNumber = "";
        CompOrPlantDetails compOrPlantDetails = null;
        for (TaxNumberBean tnb : taxNumbers) {
            employerTaxNumber = tnb.getGeneralTaxOffice().getTaxOffice().getTaxOffice() + "0" + tnb.getConvertedTaxNumber();
            if (!((String)employerTaxNumber).equals(taxId)) continue;
            if (tnb.getPlant() != null && tnb.getPlant().getPlantKey().equals(compOrPlantKey)) {
                compOrPlantDetails = new CompOrPlantDetails(taxId);
                compOrPlantDetails.setPlantKey(tnb.getPlant().getPlantKey());
                if (tnb.getPlant().getActivePlantFoundation() != null) {
                    compOrPlantDetails.setPlantShortName(tnb.getPlant().getActivePlantFoundation().getFoundations().getShortDescription());
                }
                compOrPlantDetails.setCompanyKey(tnb.getPlant().getHeadCompany().getPCompanyKey());
                try {
                    compOrPlantDetails.setCompanyShortName(tnb.getPlant().getHeadCompany().getCompany().getCurrentAddress().getShortName());
                }
                catch (ApplicationException applicationException) {
                    // empty catch block
                }
                this.protocolHandler.addToCompOrPlantDetailList(compOrPlantDetails);
                break;
            }
            if (!tnb.getPcompany().getPCompanyKey().equals(compOrPlantKey)) continue;
            compOrPlantDetails = new CompOrPlantDetails(taxId);
            compOrPlantDetails.setCompanyKey(tnb.getPcompany().getPCompanyKey());
            try {
                compOrPlantDetails.setCompanyShortName(tnb.getPcompany().getCompany().getCurrentAddress().getShortName());
            }
            catch (ApplicationException applicationException) {
                // empty catch block
            }
            this.protocolHandler.addToCompOrPlantDetailList(compOrPlantDetails);
            break;
        }
        if (compOrPlantDetails == null) {
            throw Elo2ExceptionMapper.makeNoCompanyFoundForTaxidDomainException((String)taxId, (String)this.currentFile.getAbsolutePath());
        }
    }

    private String fillCompOrPlantDetails(String taxId) throws BusinessDomainException {
        CompOrPlantDetails details = this.protocolHandler.addCompOrPlantDetails(taxId);
        TaxNumberBean[] taxNumbers = PCompany.getTaxNumberBean();
        PCompany pComp = null;
        Object employerTaxNumber = "";
        for (TaxNumberBean tnb : taxNumbers) {
            employerTaxNumber = tnb.getGeneralTaxOffice().getTaxOffice().getTaxOffice() + "0" + tnb.getConvertedTaxNumber();
            if (!((String)employerTaxNumber).equals(taxId)) continue;
            if (tnb.getPlant() != null) {
                details.addPlantKey(tnb.getPlant().getPlantKey());
                if (tnb.getPlant().getActivePlantFoundation() != null) {
                    details.addPlantShortName(tnb.getPlant().getActivePlantFoundation().getFoundations().getShortDescription());
                }
                pComp = tnb.getPlant().getHeadCompany();
            } else {
                if (tnb.getGeneralTaxOffice().getDateStartELSTAM() == null) continue;
                pComp = tnb.getPcompany();
            }
            if (pComp == null) {
                throw Elo2ExceptionMapper.makeNoCompanyFoundForTaxidDomainException((String)taxId, (String)this.currentFile.getAbsolutePath());
            }
            details.addCompanyKey(pComp.getPCompanyKey());
            try {
                details.addCompanyShortName(pComp.getCompany().getCurrentAddress().getShortName());
            }
            catch (ApplicationException applicationException) {
                // empty catch block
            }
            this.compObjId = pComp.getObjectid();
        }
        if (pComp == null) {
            throw Elo2ExceptionMapper.makeNoCompanyFoundForTaxidDomainException((String)taxId, (String)this.currentFile.getAbsolutePath());
        }
        return details.getCompanyKey();
    }

    private boolean isElstamLine(String lineContent) throws BusinessDomainException {
        FederalState state;
        Elo2Account[] accs;
        Matcher elstamMatcher = ELSTAM.matcher(lineContent);
        if (!elstamMatcher.matches()) {
            return false;
        }
        String vhCode = elstamMatcher.group(18);
        String anIdNr = elstamMatcher.group(3);
        String taxId = elstamMatcher.group(1);
        String ordnungsMerkmal = elstamMatcher.group(2);
        String[] domainKeys = ordnungsMerkmal.split("/");
        if (domainKeys == null || domainKeys.length != 2) {
            ReceiveAGProtocolContent cont = new ReceiveAGProtocolContent(null);
            cont.setAgStId("0000");
            cont.addMessage("Folgende Zeile ist nicht korrekt und kann nicht eingelesen werden: " + lineContent);
            this.protocolHandler.addProtocolContent("0000", (BaseProtocolContent)cont);
            return false;
        }
        String companyKey = domainKeys[0].trim();
        String persKey = domainKeys[1].trim();
        String message = null;
        Elo2Verfahrenshinweis hinweis = Elo2Verfahrenshinweise.getANActionForVH((String)vhCode);
        if (hinweis != null && hinweis.getAction() != null && hinweis.getAction() != Elo2Action.CLOSE_ACCOUNT) {
            message = elstamMatcher.group(19);
            hinweis.setMessage(message);
        }
        PCompany pComp = null;
        try {
            pComp = PCompany.getPCompanyByPCompanyKey(companyKey);
        }
        catch (IncorrectResultSizeDataAccessException e) {
            ReceiveAGProtocolContent cont = new ReceiveAGProtocolContent(null);
            cont.setAgStId("0000");
            cont.addMessage("Folgende Zeile ist nicht korrekt und kann nicht eingelesen werden (Firma wurde nicht gefunden): " + lineContent);
            this.protocolHandler.addProtocolContent("0000", (BaseProtocolContent)cont);
            return false;
        }
        int persNr = 0;
        try {
            persNr = Integer.valueOf(persKey);
        }
        catch (NumberFormatException e) {
            ReceiveAGProtocolContent cont = new ReceiveAGProtocolContent(null);
            cont.setAgStId("0000");
            cont.addMessage("Folgende Zeile ist nicht korrekt und kann nicht eingelesen werden (Mitarbeiter wurde nicht gefunden): " + lineContent);
            this.protocolHandler.addProtocolContent("0000", (BaseProtocolContent)cont);
            return false;
        }
        Employee empl = ((IEmployeePersistencyManager)UtilitiesManager.getBean((String)"employeePersistencyManager", IEmployeePersistencyManager.class)).getEmployeeByKey(pComp, persKey);
        if (empl == null && (accs = this.queryAccountsForOrdnungsmerkmal(ordnungsMerkmal, pComp.getObjectid())) != null && accs.length > 0) {
            persNr = accs[0].getEmployee().getPersonnelnumber();
            empl = accs[0].getEmployee();
        }
        ProtocolContentEmployeeData emplData = new ProtocolContentEmployeeData("", companyKey, persNr, "", "", "", anIdNr);
        this.fillCompOrPlantDetailsPerKey(taxId, companyKey);
        boolean isBavaria = false;
        if (empl != null && (state = EmployeeHelper.getAppurtenantFederalStateForChurchTax((Employee)empl, (Date)VDate.getDateMax(), (Date)VDate.getDateMax())) != null && state.getFederalState() == 9) {
            isBavaria = true;
        }
        Elo2ElstamTemp tempElstam = this.createElo2ElstamTemp(elstamMatcher, anIdNr, isBavaria);
        this.addProtocolContent(emplData, message, (DetailMarker)tempElstam, taxId, ordnungsMerkmal, hinweis);
        return true;
    }

    private void checkDetails() throws BusinessDomainException {
        HashMap tempProtocolMapPerAgStId = new HashMap();
        Map contentMap = this.protocolHandler.getContentsMap();
        for (Map.Entry entry : contentMap.entrySet()) {
            String agTaxId = ((String)entry.getKey()).split("/")[0];
            List protContList = (List)entry.getValue();
            ReceiveAGProtocolContent agCont = null;
            ReceiveProtocolDetailContent detCont = null;
            for (BaseProtocolContent bpc : protContList) {
                if (!(bpc instanceof ReceiveAGProtocolContent)) continue;
                agCont = (ReceiveAGProtocolContent)bpc;
                if (agCont.getVerfahrensHinweis() != null && agCont.getVerfahrensHinweis().getAction() == Elo2Action.SETALL_CREATED && this.currentReasonOfDelivery != ReasonOfDeliveryEnum.ELSTAM) {
                    Elo2Account[] accounts;
                    for (Elo2Account acc : accounts = this.queryAccountsForAGTaxId(agTaxId)) {
                        acc.setAdviceState(AdviceStateEnum.CREATED);
                        acc.makeSaveable();
                    }
                } else {
                    Elo2Account[] accounts;
                    String vhMessage;
                    if (agCont.getVerfahrensHinweis() == null || agCont.getVerfahrensHinweis().getAction() != Elo2Action.SET_ONE_TOCREATED || this.currentReasonOfDelivery == ReasonOfDeliveryEnum.ELSTAM || StringMapper.isNullString((String)(vhMessage = agCont.getVerfahrensHinweis().getMessage())) || !vhMessage.startsWith("Validierungs Fehler")) break;
                    Pattern pat = Pattern.compile("NDTicket=(\\d*)");
                    Matcher mat = pat.matcher(vhMessage);
                    String argbNdTicket = mat.find() ? mat.group(1) : "";
                    pat = Pattern.compile("IdNr=(\\d*)");
                    mat = pat.matcher(vhMessage);
                    String emplIdNr = mat.find() ? mat.group(1) : "";
                    for (Elo2Account acc : accounts = this.queryAccountsForAGTaxId(argbNdTicket)) {
                        if (acc.getTaxnumber().equals(emplIdNr)) {
                            acc.setAdviceState(AdviceStateEnum.CREATED);
                            acc.makeSaveable();
                            continue;
                        }
                        acc.setAdviceState(AdviceStateEnum.READANSWERFAILED);
                        acc.makeSaveable();
                    }
                }
                break;
            }
            if (protContList.size() > 1) {
                this.checkByValidFrom2(protContList);
            }
            for (BaseProtocolContent pc : protContList) {
                if (!(pc instanceof ReceiveProtocolDetailContent)) continue;
                detCont = (ReceiveProtocolDetailContent)pc;
                Elo2ElstamTemp elstamTemp = (Elo2ElstamTemp)detCont.getDetails();
                PCompany pComp = PCompany.getPCompanyByPCompanyKey(detCont.getCompanyKey());
                this.compObjId = pComp.getObjectid();
                Employee empl = ((IEmployeePersistencyManager)UtilitiesManager.getBean((String)"employeePersistencyManager", IEmployeePersistencyManager.class)).getEmployeeByKey(pComp, detCont.getPersNrAsString());
                if (empl == null) {
                    StringBuilder sb = new StringBuilder("Fuer die angegebene Steuer-ID / PersNr. wurde kein Angestellter bzw. Besteuerungssatz gefunden ");
                    sb.append("(PersNr.: ").append(detCont.getPersNrAsString());
                    sb.append(" / SteuerID: ").append(detCont.getTaxID()).append(")");
                    detCont.addMessage(sb.toString());
                    detCont.setCreateOrSetAccount(false);
                    continue;
                }
                Date dateWithDrawal = empl.getActiveEmployment().getDateOfWithDrawal();
                if (dateWithDrawal != null && elstamTemp.getGueltigab() != null && DateHelper.after((Date)elstamTemp.getGueltigab(), (Date)dateWithDrawal)) {
                    StringBuilder sb = new StringBuilder("Die G\u00fcltigkeit des Datensatzes liegt nach dem Austritt des Mitarbeiters. Bitte pr\u00fcfen und ggf. manuell einpflegen.");
                    sb.append("(PersNr.: ").append(detCont.getPersNrAsString());
                    sb.append(" / SteuerID: ").append(detCont.getTaxID()).append(")");
                    detCont.addMessage(sb.toString());
                    detCont.setCreateOrSetAccount(false);
                    continue;
                }
                Master master = empl.getActiveMaster();
                if (master != null) {
                    if (!StringMapper.isNullString((String)master.getDateOfBirthELSTAM())) {
                        detCont.setDateOfBirthAsString(master.getDateOfBirthELSTAM());
                    } else {
                        detCont.setDateOfBirthAsString(DateMapper.toDDMMYYYYPointSeparationString((Date)master.getDateOfBirth()));
                    }
                    detCont.setSurName(master.getSurname());
                    detCont.setFirstName(master.getFirstname());
                }
                Date elstamValidFrom = elstamTemp.getGueltigab();
                if (this.currentReasonOfDelivery == ReasonOfDeliveryEnum.ELSTAM) {
                    Elo2Account[] accounts = this.queryClosedAnfrageAccounts(detCont.getTaxID(), this.compObjId, null, empl.getObjectid(), this.currentFileNumber, elstamValidFrom);
                    if (accounts != null && accounts.length > 0) {
                        detCont.addMessage("Fuer diesen Zeitraum wurde bereits frueher eine Antwort eingelesen.");
                        detCont.setCreateOrSetAccount(false);
                        if (elstamValidFrom == null) continue;
                        this.fetchTaxForValueCompare(pComp.getObjectid(), empl, elstamTemp, null);
                        continue;
                    }
                } else {
                    Integer currentPersNr = empl.getPersonnelnumber();
                    String oidEmpl = empl.getObjectid();
                    if (this.persNrList.containsKey(oidEmpl)) {
                        detCont.addMessage("Diese PersNr. wurde im Einlesevorgang bereits bearbeitet. Evtl. manuell einpflegen.");
                        detCont.setCreateOrSetAccount(false);
                        continue;
                    }
                    this.persNrList.put(oidEmpl, currentPersNr);
                }
                if (elstamValidFrom != null && detCont.isCreateOrSetAccount()) {
                    this.checkTax(elstamValidFrom, pComp.getObjectid(), empl, detCont, elstamTemp);
                }
                if (detCont.isCreateOrSetAccount() && this.currentReasonOfDelivery == ReasonOfDeliveryEnum.ELSTAM) {
                    this.doActionForAnfrage(detCont, empl);
                }
                if (elstamValidFrom != null && !detCont.isCreateOrSetAccount() && this.currentReasonOfDelivery == ReasonOfDeliveryEnum.ELSTAM) {
                    this.fetchTaxForValueCompare(pComp.getObjectid(), empl, elstamTemp, null);
                }
                if (this.currentReasonOfDelivery != ReasonOfDeliveryEnum.ELSTAM) {
                    this.doActionForOtherReasons(detCont, pComp, empl);
                }
                this.confirmBeans.add(new Elo2ConfirmDataBean(this.getConfirmDataType(), "0", this.currentFileNumber));
            }
            ReceiveAGProtocolContent agProtContent = null;
            if (this.protocolHandler.getCompOrPlantDetailsPerTaxId(agTaxId) != null) {
                List compOrPlantDetailsList = this.protocolHandler.getCompOrPlantDetailsPerTaxId(agTaxId);
                if (agCont == null) continue;
                for (CompOrPlantDetails copd : compOrPlantDetailsList) {
                    if (StringMapper.isNullString((String)agCont.getCompOrPlantKey())) {
                        agCont.setCompOrPlantKey(!StringMapper.isNullString((String)copd.getPlantKey()) ? copd.getPlantKey() : copd.getCompanyKey());
                        continue;
                    }
                    agProtContent = new ReceiveAGProtocolContent(agCont.getVerfahrensHinweis());
                    agProtContent.setAgStId(agCont.getAgStId());
                    agProtContent.setPriority(agCont.getPriority());
                    agProtContent.setCompOrPlantKey(!StringMapper.isNullString((String)copd.getPlantKey()) ? copd.getPlantKey() : copd.getCompanyKey());
                    this.protocolHandler.addProtocolContentToTempMap(agCont.getAgStId() + "/" + agProtContent.getCompOrPlantKey(), (BaseProtocolContent)agProtContent, tempProtocolMapPerAgStId);
                }
                continue;
            }
            agProtContent = new ReceiveAGProtocolContent(agCont.getVerfahrensHinweis());
            agProtContent.setAgStId(agCont.getAgStId());
            agProtContent.setPriority(agCont.getPriority());
            agProtContent.setCompOrPlantKey(!StringMapper.isNullString((String)agCont.getCompOrPlantKey()) ? agCont.getCompOrPlantKey() : agProtContent.getCompOrPlantKey());
            this.protocolHandler.addProtocolContentToTempMap(agCont.getAgStId() + "/" + agProtContent.getCompOrPlantKey(), (BaseProtocolContent)agProtContent, tempProtocolMapPerAgStId);
        }
        this.protocolHandler.addTempMapContent(tempProtocolMapPerAgStId);
    }

    private void doActionForOtherReasons(ReceiveProtocolDetailContent detCont, PCompany pComp, Employee empl) {
        Elo2ElstamTemp elstamTemp = (Elo2ElstamTemp)detCont.getDetails();
        Elo2Account[] accounts = this.queryElo2Accounts(elstamTemp.getAnidnr(), pComp.getObjectid(), null, empl.getObjectid(), null);
        if (accounts == null || accounts.length == 0) {
            detCont.addMessage("Fuer die angegebene Steuer-ID wurde kein ELStAM-Meldekonto gefunden.");
            detCont.setCreateOrSetAccount(false);
        } else if (accounts.length > 1) {
            detCont.addMessage("Fuer die angegebene Steuer-ID und den Meldetyp wurden mehrere ELStAM-Meldekonten gefunden");
            detCont.setCreateOrSetAccount(false);
        } else {
            Elo2Account account = accounts[0];
            if (elstamTemp.getGueltigab() != null) {
                Elo2Elstam elstam = this.createElo2Elstam(elstamTemp, account);
                if (detCont.isCreateOrSetAccount()) {
                    try {
                        this.fillEmployeeTax(account, elstam, detCont.getVerfahrensHinweis());
                    }
                    catch (BusinessDomainException bde) {
                        detCont.addMessage(bde.getMessage());
                        detCont.setCreateOrSetAccount(false);
                        detCont.setVerfahrensHinweis(new Elo2Verfahrenshinweis("", Elo2Action.CLOSE_ACCOUNT_PROTOCOL));
                    }
                }
            }
            if (detCont.getVerfahrensHinweis() == null) {
                detCont.setVerfahrensHinweis(new Elo2Verfahrenshinweis("", Elo2Action.CLOSE_ACCOUNT));
            } else {
                this.checkForSpecialActions(detCont, account, elstamTemp.getSteuerklasse());
            }
            this.doAccountAction(detCont.getVerfahrensHinweis(), account);
            this.mElo2Accounts.add(account);
        }
    }

    private void doActionForAnfrage(ReceiveProtocolDetailContent detCont, Employee empl) {
        Elo2ElstamTemp elstamTemp = (Elo2ElstamTemp)detCont.getDetails();
        if (detCont.getVerfahrensHinweis() != null && (detCont.getVerfahrensHinweis().getAction() == Elo2Action.NOACCOUNT_PROTOCOL || detCont.getVerfahrensHinweis().getAction() == Elo2Action.DEFAULT_NEW_VH)) {
            detCont.addMessage("Fehler. Kein Konto erzeugt.");
        } else if (elstamTemp.getGueltigab() == null) {
            detCont.addMessage("Gueltig ab ist leer. Kein Anfrage-Meldekonto erzeugt. Grund siehe Verfahrenshinweis");
        } else {
            Elo2Account account = new Elo2Account(empl);
            account.setValidFrom(elstamTemp.getGueltigab());
            account.setReasonOfDelivery(this.currentReasonOfDelivery);
            account.setCreatedOn(VDate.formatCurrentDateAndTime((Date)VDate.getCurrentLocalizedDateAndTime()));
            account.setPCompany(empl.getPCompany());
            account.setPlant(null);
            account.setTaxnumber(elstamTemp.getAnidnr());
            account.setEffectiveFrom(VDate.getCurrentLocalizedDateAndTime());
            account.setEmployerTaxNumber(detCont.getAgStId());
            account.setAnswerFileNumber(Integer.parseInt(this.currentFileNumber));
            account.setTransmitted(true);
            account.setOrdnungsMerkmal(empl.getDomainKey());
            if (elstamTemp.getGueltigab() != null) {
                try {
                    this.fillEmployeeTax(account, this.createElo2Elstam(elstamTemp, account), detCont.getVerfahrensHinweis());
                }
                catch (BusinessDomainException bde) {
                    detCont.addMessage(bde.getMessage());
                    detCont.setCreateOrSetAccount(false);
                    detCont.setVerfahrensHinweis(new Elo2Verfahrenshinweis("", Elo2Action.CLOSE_ACCOUNT_PROTOCOL));
                }
            }
            if (detCont.getVerfahrensHinweis() == null) {
                detCont.setVerfahrensHinweis(new Elo2Verfahrenshinweis("", Elo2Action.CLOSE_ACCOUNT_PROTOCOL));
            } else {
                this.checkForSpecialActions(detCont, account, elstamTemp.getSteuerklasse());
            }
            this.doAccountAction(detCont.getVerfahrensHinweis(), account);
            this.mElo2Accounts.add(account);
        }
    }

    private void checkForSpecialActions(ReceiveProtocolDetailContent detCont, Elo2Account account, int steuerklasse) {
        Elo2Verfahrenshinweis hinweis = detCont.getVerfahrensHinweis();
        Date newRefDate = hinweis.getNewRefDate();
        if (newRefDate != null) {
            if (hinweis.getCode().equals("552020103")) {
                detCont.setProtocolContentType(ProtocolContentType.AN_CONTENT);
                if (this.currentReasonOfDelivery == ReasonOfDeliveryEnum.ELSTAM) {
                    Elo2Account[] accounts = this.queryLastClosedAnOrUmmeldung(account.getTaxnumber(), account.getPCompany().getObjectid(), account.getEmployee().getObjectid());
                    if (accounts == null || accounts.length == 0) {
                        return;
                    }
                    Elo2Account acc = accounts[0];
                    if (acc.getReasonOfDelivery() == ReasonOfDeliveryEnum.UMMELDUNG) {
                        Elo2Dueum um = acc.getElo2Dueum();
                        um.setRefDate(newRefDate);
                        um.makeSaveable();
                    } else {
                        Elo2Duean an = acc.getElo2Duean();
                        an.setRefdatumag(newRefDate);
                        an.makeSaveable();
                    }
                } else if (this.currentReasonOfDelivery == ReasonOfDeliveryEnum.ANMELDUNG) {
                    Elo2Duean an = account.getElo2Duean();
                    an.setRefdatumag(newRefDate);
                    if (steuerklasse == 6) {
                        an.setHauptag("F");
                    }
                    an.makeSaveable();
                }
            } else if (hinweis.getCode().equals("552020214") && this.currentReasonOfDelivery == ReasonOfDeliveryEnum.ANMELDUNG) {
                detCont.setProtocolContentType(ProtocolContentType.AN_CONTENT);
                Elo2Duean an = account.getElo2Duean();
                an.setRefdatumag(newRefDate);
                an.makeSaveable();
            } else if (hinweis.getCode().equals("552020303") && this.currentReasonOfDelivery == ReasonOfDeliveryEnum.ABMELDUNG) {
                Elo2Dueab ab = account.getElo2Dueab();
                ab.setRefdatumag(newRefDate);
                ab.makeSaveable();
            } else if (hinweis.getCode().equals("552020306")) {
                detCont.setProtocolContentType(ProtocolContentType.AN_CONTENT);
            }
        }
    }

    private void doAccountAction(Elo2Verfahrenshinweis hinweis, Elo2Account account) {
        if (hinweis != null && hinweis.getAction() != null) {
            Elo2Action action = hinweis.getAction();
            if (!StringMapper.isNullString((String)hinweis.getMessage())) {
                account.addError(hinweis.getMessage());
            }
            switch (action) {
                case CLOSE_ACCOUNT_PROTOCOL: {
                    account.setAdviceState(AdviceStateEnum.RECEIPTCREATED);
                    account.makeSaveable();
                    break;
                }
                case CLOSE_NEWREFDATE: {
                    this.setRefDate(account, hinweis.getNewRefDate());
                    account.setAdviceState(AdviceStateEnum.RECEIPTCREATED);
                    account.makeSaveable();
                    break;
                }
                case CLOSE_ACCOUNT: 
                case CLOSE_ACCOUNT_OK_PROTOCOL: {
                    account.setAdviceState(AdviceStateEnum.RECEIPTCREATED);
                    account.makeSaveable();
                    break;
                }
                case SET_CREATED: {
                    account.setAdviceState(AdviceStateEnum.CREATED);
                    account.makeSaveable();
                    break;
                }
                case SETERROR_NEWREFDATE: {
                    Date date;
                    if (hinweis.getCode().equals("552020213") && (account.getReasonOfDelivery().equals(ReasonOfDeliveryEnum.ANMELDUNG) || account.getReasonOfDelivery().equals(ReasonOfDeliveryEnum.ANMELDUNG_SONSTIGERGRUND)) && (date = hinweis.getNewRefDate()) != null) {
                        this.setRefDate(account, DateHelper.add((Date)date, (int)1));
                        account.setAdviceState(AdviceStateEnum.READANSWERFAILED);
                        account.makeSaveable();
                        break;
                    }
                    this.setRefDate(account, hinweis.getNewRefDate());
                    account.setAdviceState(AdviceStateEnum.READANSWERFAILED);
                    account.makeSaveable();
                    break;
                }
                case SETERROR_PROTOCOL: {
                    if (hinweis.getCode().equals("552020300") && (account.getReasonOfDelivery().equals(ReasonOfDeliveryEnum.ABMELDUNG) || account.getReasonOfDelivery().equals(ReasonOfDeliveryEnum.ABMELDUNG_SONSTIGERGRUND))) {
                        account.setAdviceState(AdviceStateEnum.READANSWERSUCCESS);
                        account.makeSaveable();
                        break;
                    }
                    account.setAdviceState(AdviceStateEnum.READANSWERFAILED);
                    account.makeSaveable();
                    break;
                }
                case DEFAULT_NEW_VH: {
                    account.setAdviceState(AdviceStateEnum.READANSWERFAILED);
                    account.makeSaveable();
                    break;
                }
            }
        }
    }

    private void setRefDate(Elo2Account account, Date newRefDate) {
        switch (account.getReasonOfDelivery().value()) {
            case 0: {
                account.getElo2Duean().setRefdatumag(newRefDate);
                account.getElo2Duean().makeSaveable();
                break;
            }
            case 4: {
                account.getElo2Duean().setRefdatumag(newRefDate);
                account.getElo2Duean().makeSaveable();
                break;
            }
            case 1: {
                account.getElo2Dueab().setRefdatumag(newRefDate);
                account.getElo2Dueab().makeSaveable();
                break;
            }
            case 5: {
                account.getElo2Dueab().setRefdatumag(newRefDate);
                account.getElo2Dueab().makeSaveable();
                break;
            }
            case 2: {
                account.getElo2Dueum().setRefDate(newRefDate);
                account.getElo2Dueum().makeSaveable();
                break;
            }
            case 6: {
                account.getElo2Dueum().setRefDate(newRefDate);
                account.getElo2Dueum().makeSaveable();
                break;
            }
        }
    }

    private Date fetchTaxForValueCompare(String oidCompany, Employee empl, Elo2ElstamTemp elstamTemp, Tax newestTax) {
        Conjunction filter = Restrictions.conjunction();
        filter.add(Restrictions.eq((String)"effectiveuntil", (String)VDate.getDateMaxAsString()));
        filter.add(Restrictions.eq((String)"validuntil", (String)VDate.getDateMaxAsString()));
        filter.add(Restrictions.eq((String)"noelstam", (String)BooleanMapper.toString((Boolean)Boolean.FALSE)));
        filter.add(Restrictions.eq((String)"oidpcompany", (String)oidCompany));
        filter.add(Restrictions.eq((String)"oidemployee", (String)empl.getObjectid()));
        TaxallContainer[] taxAll = taxAllDao.getRows(null, (Criterion)filter);
        Date taxValidFrom = null;
        if (taxAll != null && taxAll.length == 1) {
            taxValidFrom = this.fillEmployeeTaxForCompare(empl, elstamTemp, newestTax);
        }
        return taxValidFrom;
    }

    private boolean checkTax(Date elstamValidFrom, String oidCompany, Employee empl, ReceiveProtocolDetailContent detCont, Elo2ElstamTemp elstamTemp) {
        Conjunction filter = Restrictions.conjunction();
        filter.add(Restrictions.eq((String)"effectiveuntil", (String)VDate.getDateMaxAsString()));
        filter.add(Restrictions.eq((String)"validuntil", (String)VDate.getDateMaxAsString()));
        filter.add(Restrictions.eq((String)"noelstam", (String)BooleanMapper.toString((Boolean)Boolean.FALSE)));
        filter.add(Restrictions.eq((String)"oidpcompany", (String)oidCompany));
        filter.add(Restrictions.eq((String)"oidemployee", (String)empl.getObjectid()));
        TaxallContainer[] taxAll = taxAllDao.getRows(null, (Criterion)filter);
        if (taxAll == null || taxAll.length == 0) {
            detCont.addMessage("Keinen Besteuerungssatz gefunden oder keine Teilnahme am Elstam-Verfahren.");
            detCont.setCreateOrSetAccount(false);
            return false;
        }
        if (taxAll.length > 1) {
            detCont.addMessage("Fuer die angegebene Steuer-ID wurden mehrere Besteuerungsangaben gefunden.");
            detCont.setCreateOrSetAccount(false);
            return false;
        }
        if (DateHelper.before((Date)elstamValidFrom, (Date)taxAll[0].validfrom)) {
            detCont.addMessage("Es existiert bereits ein juengerer Gueltigkeitszeitraum in den Besteuerungsdaten, kein automatischer ELStAM-Import moeglich, bitte pr\u00fcfen und ggf. manuell verwalten.");
            detCont.setCreateOrSetAccount(false);
            return false;
        }
        try {
            this.fillEmployeeTaxForTest(empl, elstamTemp);
        }
        catch (BusinessDomainException bde) {
            detCont.addMessage(bde.getMessage());
            detCont.setCreateOrSetAccount(false);
            return false;
        }
        return true;
    }

    private void checkByValidFrom2(List<BaseProtocolContent> protContList) throws BusinessDomainException {
        HashMap<String, List<ReceiveProtocolDetailContent>> anStIdMap = new HashMap<String, List<ReceiveProtocolDetailContent>>();
        this.fillAnStIdMap(protContList, anStIdMap);
        Elo2ElstamTemp elstamTemp = null;
        for (List list : anStIdMap.values()) {
            Collections.sort(list, new ProtocolDetailComparator());
            boolean oneFoundForImport = false;
            for (ReceiveProtocolDetailContent detCont : list) {
                PCompany pComp = PCompany.getPCompanyByPCompanyKey(detCont.getCompanyKey());
                Employee empl = ((IEmployeePersistencyManager)UtilitiesManager.getBean((String)"employeePersistencyManager", IEmployeePersistencyManager.class)).getEmployeeByKey(pComp, detCont.getPersNrAsString());
                if (empl == null || (elstamTemp = (Elo2ElstamTemp)detCont.getDetails()).getGueltigab() == null) continue;
                if (oneFoundForImport) {
                    detCont.addMessage("Kein Import, da ein aelterer Satz bereits importiert wurde.");
                    detCont.setCreateOrSetAccount(false);
                    this.mRepeatPerfidiaFile = true;
                    continue;
                }
                this.fetchTaxForValueCompare(pComp.getObjectid(), empl, elstamTemp, null);
                if (elstamTemp.canBeImported()) {
                    Date dateWithDrawal;
                    Elo2Account[] accounts;
                    Date validFrom = elstamTemp.getGueltigab();
                    detCont.setCreateOrSetAccount(true);
                    if (this.currentReasonOfDelivery == ReasonOfDeliveryEnum.ELSTAM) {
                        accounts = this.queryClosedAnfrageAccounts(detCont.getTaxID(), pComp.getObjectid(), null, empl.getObjectid(), this.currentFileNumber, validFrom);
                        if (accounts == null || accounts.length <= 0) {
                            oneFoundForImport = true;
                        }
                    } else {
                        accounts = this.queryClosedAccounts(detCont.getTaxID(), pComp.getObjectid(), null, empl.getObjectid(), this.currentFileNumber, validFrom, this.currentReasonOfDelivery);
                        if (accounts == null || accounts.length <= 0) {
                            oneFoundForImport = true;
                        }
                    }
                    if (!this.checkTax(elstamTemp.getGueltigab(), pComp.getObjectid(), empl, detCont, elstamTemp)) {
                        oneFoundForImport = false;
                    }
                    if ((dateWithDrawal = empl.getActiveEmployment().getDateOfWithDrawal()) == null || elstamTemp.getGueltigab() == null || !DateHelper.after((Date)elstamTemp.getGueltigab(), (Date)dateWithDrawal)) continue;
                    oneFoundForImport = false;
                    continue;
                }
                if (oneFoundForImport) continue;
                Conjunction filter = Restrictions.conjunction();
                filter.add(Restrictions.eq((String)"effectiveuntil", (String)VDate.getDateMaxAsString()));
                filter.add(Restrictions.eq((String)"validuntil", (String)VDate.getDateMaxAsString()));
                filter.add(Restrictions.eq((String)"noelstam", (String)BooleanMapper.toString((Boolean)Boolean.FALSE)));
                filter.add(Restrictions.eq((String)"oidpcompany", (String)pComp.getObjectid()));
                filter.add(Restrictions.eq((String)"oidemployee", (String)empl.getObjectid()));
                TaxallContainer[] taxAll = taxAllDao.getRows(null, (Criterion)filter);
                if (taxAll != null && taxAll.length == 1 && DateHelper.before((Date)elstamTemp.getGueltigab(), (Date)taxAll[0].validfrom)) {
                    detCont.addMessage("Kein Import. Es ist bereits ein j\u00fcngerer Zeitraum mit identischen ELStAM-Daten vorhanden (aufgrund des Vergleichs der g\u00fcltig-ab-Daten aus ELStAM \u00c4nderungsliste und g\u00fcltig-ab Steuerdaten Mitarbeiter). Bitte Zeitraum l\u00f6schen und erneut importieren.");
                    detCont.setCreateOrSetAccount(false);
                    continue;
                }
                detCont.addMessage("Kein Import, da sich fuer diese Gueltigkeit keine Aenderungen ergeben haben.");
                detCont.setCreateOrSetAccount(false);
            }
        }
        Collections.sort(protContList, new ReceiveProtocolComparator());
    }

    private void fillAnStIdMap(List<BaseProtocolContent> protContList, Map<String, List<ReceiveProtocolDetailContent>> anStIdMap) {
        ReceiveProtocolDetailContent detailCont = null;
        Elo2ElstamTemp elstamTemp = null;
        ArrayList<ReceiveProtocolDetailContent> removeList = new ArrayList<ReceiveProtocolDetailContent>();
        Collections.sort(protContList, new BaseProtocolContentComparator());
        for (BaseProtocolContent baseProtocolContent : protContList) {
            if (!(baseProtocolContent instanceof ReceiveProtocolDetailContent)) continue;
            detailCont = (ReceiveProtocolDetailContent)baseProtocolContent;
            elstamTemp = (Elo2ElstamTemp)detailCont.getDetails();
            List<ReceiveProtocolDetailContent> anList = anStIdMap.get(elstamTemp.getAnidnr());
            if (anList == null) {
                anList = new ArrayList<ReceiveProtocolDetailContent>();
                anStIdMap.put(elstamTemp.getAnidnr(), anList);
            }
            boolean add = true;
            ReceiveProtocolDetailContent remove = null;
            for (ReceiveProtocolDetailContent cont : anList) {
                remove = null;
                Elo2ElstamTemp temp = (Elo2ElstamTemp)cont.getDetails();
                Elo2ElstamTemp tempNew = (Elo2ElstamTemp)detailCont.getDetails();
                if (temp.getGueltigab() == null || tempNew.getGueltigab() == null || !DateHelper.equal((Date)DateHelper.getFirstDayOfMonth((Date)temp.getGueltigab()), (Date)DateHelper.getFirstDayOfMonth((Date)tempNew.getGueltigab()))) continue;
                if (DateHelper.after((Date)tempNew.getGueltigab(), (Date)temp.getGueltigab())) {
                    remove = cont;
                    add = true;
                    continue;
                }
                add = false;
            }
            if (remove != null) {
                anList.remove(remove);
                removeList.add(remove);
            }
            if (!add) continue;
            anList.add(detailCont);
        }
        for (BaseProtocolContent baseProtocolContent : removeList) {
            protContList.remove(baseProtocolContent);
        }
    }

    private void compareTaxValuesForFormatting(Elo2ElstamTemp els, Tax emplTax) {
        BigDecimal taxTest = null;
        BigDecimal bigDecimal = taxTest = emplTax.getAddAmountDaily() == null ? this.ZERO : emplTax.getAddAmountDaily();
        if (taxTest.compareTo(els.getHinzuBetrTag()) != 0) {
            els.getFieldFormat().setFormatHinzuBetrTag(true);
        }
        BigDecimal bigDecimal2 = taxTest = emplTax.getAddAmountMM() == null ? this.ZERO : emplTax.getAddAmountMM();
        if (taxTest.compareTo(els.getHinzuBetrMonat()) != 0) {
            els.getFieldFormat().setFormatHinzuBetrMonat(true);
        }
        BigDecimal bigDecimal3 = taxTest = emplTax.getAddAmountWeekly() == null ? this.ZERO : emplTax.getAddAmountWeekly();
        if (taxTest.compareTo(els.getHinzuBetrWoche()) != 0) {
            els.getFieldFormat().setFormatHinzuBetrWoche(true);
        }
        BigDecimal bigDecimal4 = taxTest = emplTax.getAddAmountYY() == null ? this.ZERO : emplTax.getAddAmountYY();
        if (taxTest.compareTo(els.getHinzuBetrJahr()) != 0) {
            els.getFieldFormat().setFormatHinzuBetrJahr(true);
        }
        BigDecimal bigDecimal5 = taxTest = emplTax.getFreeAllowanceYY() == null ? this.ZERO : emplTax.getFreeAllowanceYY();
        if (taxTest.compareTo(els.getFreiBetrJahr()) != 0) {
            els.getFieldFormat().setFormatFreiBetrJahr(true);
        }
        BigDecimal bigDecimal6 = taxTest = emplTax.getFreeAllowanceMM() == null ? this.ZERO : emplTax.getFreeAllowanceMM();
        if (taxTest.compareTo(els.getFreiBetrMonat()) != 0) {
            els.getFieldFormat().setFormatFreiBetrMonat(true);
        }
        BigDecimal bigDecimal7 = taxTest = emplTax.getChildRelief() == null ? this.ZERO : emplTax.getChildRelief();
        if (taxTest.compareTo(els.getAnzKindFrei()) != 0) {
            els.getFieldFormat().setFormatAnzKindFrei(true);
        }
        BigDecimal bigDecimal8 = taxTest = emplTax.getPercentageSplit() == null ? this.ZERO : emplTax.getPercentageSplit();
        if (taxTest.compareTo(els.getFaktor()) != 0) {
            els.getFieldFormat().setFormatFaktor(true);
        }
        if (emplTax.getTaxBracket() != els.getSteuerklasse()) {
            els.getFieldFormat().setFormatSteuerklasse(true);
        }
        ChurchTaxEnum konfAn = ChurchTaxEnumMapper.toChurchTaxEnum((int)els.getKonfAn());
        ChurchTaxEnum konfEg = ChurchTaxEnumMapper.toChurchTaxEnum((int)els.getKonfEG());
        if (emplTax.getChurchTaxEE() != konfAn) {
            els.getFieldFormat().setFormatKonfAn(true);
        }
        if (emplTax.getChurchTaxSpouse() != konfEg) {
            els.getFieldFormat().setFormatKonfEG(true);
        }
    }

    private Date fillEmployeeTaxForCompare(Employee empl, Elo2ElstamTemp els, Tax newestTax) {
        if (newestTax != null) {
            this.compareTaxValuesForFormatting(els, newestTax);
            return newestTax.getValidFrom();
        }
        Employee reloaded = this.getIEmployeePM().getEmployee(empl.getObjectid());
        Tax emplTax = reloaded.getActiveTax();
        this.compareTaxValuesForFormatting(els, emplTax);
        return emplTax.getValidFrom();
    }

    private void fillEmployeeTaxForTest(Employee empl, Elo2ElstamTemp els) throws BusinessDomainException {
        Employee reloaded = this.getIEmployeePM().getEmployee(empl.getObjectid());
        Tax emplTax = reloaded.getActiveTax();
        ChurchTaxEnum konfAn = ChurchTaxEnumMapper.toChurchTaxEnum((int)els.getKonfAn());
        ChurchTaxEnum konfEg = ChurchTaxEnumMapper.toChurchTaxEnum((int)els.getKonfEG());
        this.compareTaxValuesForFormatting(els, emplTax);
        emplTax.setAddAmountMM(els.getHinzuBetrMonat());
        emplTax.setAddAmountYY(els.getHinzuBetrJahr());
        emplTax.setChildRelief(els.getAnzKindFrei());
        emplTax.setFreeAllowanceMM(els.getFreiBetrMonat());
        emplTax.setFreeAllowanceYY(els.getFreiBetrJahr());
        emplTax.setTaxBracket(els.getSteuerklasse());
        if (els.getSteuerklasse() >= 1 && els.getSteuerklasse() <= 6) {
            emplTax.setPayeTaxFindings(PAYETaxFindingsEnum.PTFE_ALLGEMEINE_LST_TABELLE);
        }
        emplTax.setPercentageSplit(els.getFaktor());
        if (els.getSteuerklasse() == 6) {
            emplTax.setSidelineEmployer(true);
        } else {
            emplTax.setSidelineEmployer(false);
        }
        emplTax.setChurchTaxEE(konfAn);
        emplTax.setChurchTaxSpouse(konfEg);
        if (konfAn != ChurchTaxEnum.CTE_KEIN_EINTRAG) {
            emplTax.setChurchTaxDeduction(true);
        } else {
            emplTax.setChurchTaxDeduction(false);
        }
        try {
            emplTax.checkAttributes();
        }
        catch (BusinessDomainException bde) {
            if (bde.getErrorNumber() == 100234 || bde.getErrorNumber() == 23500 || bde.getErrorNumber() == 23550) {
                this.oidEmployeesWithAutomaticLstJa.add(empl.getObjectid());
            }
            throw bde;
        }
    }

    public List<EmployeeCalculate> createValuationCalculates() throws BusinessDomainException {
        ArrayList<EmployeeCalculate> emplCalculates = new ArrayList<EmployeeCalculate>();
        for (ForValuation forVal : this.emplTaxListForValuation) {
            emplCalculates.add(((IValuationManager)UtilitiesManager.getBean((String)"valuationManager", IValuationManager.class)).createEmplCalculates(forVal.getEmployee(), forVal.getEmplTax().getValidFrom(), ((Object)((Object)forVal.getEmplTax())).getClass().getName()));
        }
        return emplCalculates;
    }

    public void executeFileRenaming() {
        if (!this.mRepeatPerfidiaFile) {
            this.mPerfidiaResult.addReceivedFile(this.currentFile);
        }
    }

    private void checkForReasonOfDelivery(String listTypeContent) {
        this.currentReasonOfDelivery = this.initialReasonOfDelivery;
        this.setAdditionalReasonOfDelivery();
        if (this.initialReasonOfDelivery != ReasonOfDeliveryEnum.ELSTAM) {
            return;
        }
        String listType = listTypeContent.trim().toUpperCase();
        if (listType.equals(MONATS_LISTE) || listType.equals(BRUTTO_LISTE)) {
            this.currentReasonOfDelivery = ReasonOfDeliveryEnum.ELSTAM;
        } else if (listType.equals(ANMELD_LISTE)) {
            this.currentReasonOfDelivery = ReasonOfDeliveryEnum.ANMELDUNG;
        } else if (listType.equals(ABMELD_LISTE)) {
            this.currentReasonOfDelivery = ReasonOfDeliveryEnum.ABMELDUNG;
        } else if (listType.equals(UMMELD_LISTE)) {
            this.currentReasonOfDelivery = ReasonOfDeliveryEnum.UMMELDUNG;
        }
        this.setAdditionalReasonOfDelivery();
        this.protocolHandler.setReasonOfDelivery(this.currentReasonOfDelivery);
    }

    private void setAdditionalReasonOfDelivery() {
        if (this.currentReasonOfDelivery == ReasonOfDeliveryEnum.UMMELDUNG) {
            this.additionalReasonOfDelivery = ReasonOfDeliveryEnum.UMMELDUNG_SONSTIGERGRUND;
        } else if (this.currentReasonOfDelivery == ReasonOfDeliveryEnum.ANMELDUNG) {
            this.additionalReasonOfDelivery = ReasonOfDeliveryEnum.ANMELDUNG_SONSTIGERGRUND;
        } else if (this.currentReasonOfDelivery == ReasonOfDeliveryEnum.ABMELDUNG) {
            this.additionalReasonOfDelivery = ReasonOfDeliveryEnum.ABMELDUNG_SONSTIGERGRUND;
        }
    }

    private void checkVosz(String vosz) {
        LOGGER.debug("VOSZ <{}>", (Object)vosz);
    }

    private void checkNcsz(String ncsz, int countOfRecords) {
        LOGGER.debug("NCSZ <{}>, count of records <{}>", (Object)ncsz, (Object)countOfRecords);
    }

    private ProtocolContentEmployeeData getEmptyEmployeeDataForProtocol() {
        return new ProtocolContentEmployeeData("", "", 0, "", "", "", "");
    }

    private Elo2ElstamTemp createElo2ElstamTemp(Matcher m, String anIdNr, boolean isBavaria) throws BusinessDomainException {
        String ordMerkmal = this.asString(m.group(2));
        Date validFrom = this.asDate(m.group(4));
        int taxBracket = this.asInt(m.group(5));
        BigDecimal factor = this.asBigDecimal(m.group(6), 3);
        BigDecimal freiJahr = this.asBigDecimal(m.group(7), 0);
        BigDecimal freiMonat = this.asBigDecimal(m.group(8), 0);
        BigDecimal freiWoche = this.asBigDecimal(m.group(9), 2);
        BigDecimal freiTag = this.asBigDecimal(m.group(10), 2);
        BigDecimal hinzuJahr = this.asBigDecimal(m.group(11), 0);
        BigDecimal hinzuMonat = this.asBigDecimal(m.group(12), 0);
        BigDecimal hinzuWoche = this.asBigDecimal(m.group(13), 2);
        BigDecimal hinzuTag = this.asBigDecimal(m.group(14), 2);
        BigDecimal anzKindFrei = this.asBigDecimal(m.group(15), 1);
        int konfAN = this.findChurchTaxEnumAsInt(m.group(16), isBavaria);
        int konfEG = this.findChurchTaxEnumAsInt(m.group(17), isBavaria);
        Elo2ElstamTemp els = new Elo2ElstamTemp();
        els.setAnidnr(anIdNr);
        els.setAnzKindFrei(anzKindFrei);
        els.setFaktor(factor);
        els.setFreiBetrJahr(freiJahr);
        els.setFreiBetrMonat(freiMonat);
        els.setFreiBetrTag(freiTag);
        els.setFreiBetrWoche(freiWoche);
        els.setGueltigab(validFrom);
        els.setHinzuBetrJahr(hinzuJahr);
        els.setHinzuBetrMonat(hinzuMonat);
        els.setHinzuBetrTag(hinzuTag);
        els.setHinzuBetrWoche(hinzuWoche);
        els.setKonfAn(konfAN);
        els.setKonfEG(konfEG);
        els.setOrdnungsmerkmal(ordMerkmal);
        els.setSteuerklasse(taxBracket);
        return els;
    }

    private Elo2Elstam createElo2Elstam(Elo2ElstamTemp elstamTemp, Elo2Account account) {
        Elo2Elstam els = new Elo2Elstam(account);
        els.setAnidnr(elstamTemp.getAnidnr());
        els.setAnzKindFrei(elstamTemp.getAnzKindFrei());
        els.setFaktor(elstamTemp.getFaktor());
        els.setFreiBetrJahr(elstamTemp.getFreiBetrJahr());
        els.setFreiBetrMonat(elstamTemp.getFreiBetrMonat());
        els.setFreiBetrTag(elstamTemp.getFreiBetrTag());
        els.setFreiBetrWoche(elstamTemp.getFreiBetrWoche());
        els.setGueltigab(elstamTemp.getGueltigab());
        els.setHinzuBetrJahr(elstamTemp.getHinzuBetrJahr());
        els.setHinzuBetrMonat(elstamTemp.getHinzuBetrMonat());
        els.setHinzuBetrTag(elstamTemp.getHinzuBetrTag());
        els.setHinzuBetrWoche(elstamTemp.getHinzuBetrWoche());
        els.setKonfAn(elstamTemp.getKonfAn());
        els.setKonfEG(elstamTemp.getKonfEG());
        els.setOrdnungsmerkmal(elstamTemp.getOrdnungsmerkmal());
        els.setSteuerklasse(elstamTemp.getSteuerklasse());
        return els;
    }

    private int findChurchTaxEnumAsInt(String value, boolean isBavaria) {
        if ("is".equalsIgnoreCase(value) && isBavaria) {
            return 17;
        }
        ChurchTaxEnum churchTax = ChurchTaxEnum.CTE_KEIN_EINTRAG;
        List<String> chTList = Arrays.asList(ChurchTaxEnumMapper.getStringListValues());
        int index = chTList.indexOf(value);
        if (index > -1) {
            churchTax = ChurchTaxEnumMapper.toChurchTaxEnum((int)index);
        }
        return churchTax.value();
    }

    private Tax fillEmployeeTax(Elo2Account account, Elo2Elstam els, Elo2Verfahrenshinweis hinweis) throws BusinessDomainException {
        if (els.getGueltigab() == null) {
            return null;
        }
        Employee reloaded = this.getIEmployeePM().getEmployee(account.getEmployee().getObjectid());
        Tax emplTax = reloaded.getActiveTax();
        emplTax.setAddAmountMM(els.getHinzuBetrMonat());
        emplTax.setAddAmountYY(els.getHinzuBetrJahr());
        emplTax.setChildRelief(els.getAnzKindFrei());
        emplTax.setFreeAllowanceMM(els.getFreiBetrMonat());
        emplTax.setFreeAllowanceYY(els.getFreiBetrJahr());
        emplTax.setTaxBracket(els.getSteuerklasse());
        if (els.getSteuerklasse() >= 1 && els.getSteuerklasse() <= 6) {
            emplTax.setPayeTaxFindings(PAYETaxFindingsEnum.PTFE_ALLGEMEINE_LST_TABELLE);
        }
        emplTax.setPercentageSplit(els.getFaktor());
        emplTax.setChurchTaxEE(ChurchTaxEnumMapper.toChurchTaxEnum((int)els.getKonfAn()));
        emplTax.setChurchTaxSpouse(ChurchTaxEnumMapper.toChurchTaxEnum((int)els.getKonfEG()));
        if (ChurchTaxEnumMapper.toChurchTaxEnum((int)els.getKonfAn()) != ChurchTaxEnum.CTE_KEIN_EINTRAG) {
            emplTax.setChurchTaxDeduction(true);
        } else {
            emplTax.setChurchTaxDeduction(false);
        }
        if (this.oidEmployeesWithAutomaticLstJa.contains(reloaded.getObjectid())) {
            emplTax.setIncomeTaxReturnYY(IncomeTaxReturnYYEnum.ITRE_KEIN_JAHRESAUSGLEICH);
        }
        if (els.getSteuerklasse() == 6) {
            emplTax.setSidelineEmployer(true);
        } else {
            emplTax.setSidelineEmployer(false);
        }
        emplTax.compareToOld(account.getEmployee().getActiveTax());
        Date oldEffectiveFrom = emplTax.getEffectiveFrom();
        if (emplTax.getValuateNeeded()) {
            if (DateHelper.equal((Date)els.getGueltigab(), (Date)emplTax.getValidFrom())) {
                block17: {
                    try {
                        emplTax.checkAttributes();
                    }
                    catch (BusinessDomainException e) {
                        if (!this.isErrorNotToConsider(e.getErrorNumber())) {
                            throw e;
                        }
                        if (this.allowedByYearChange(reloaded.getJournalizedUntil(), emplTax.getValidFrom())) break block17;
                        throw EmployeeExceptionMapper.makeChangeOfTaxByElstamNotAllowedDomainException();
                    }
                }
                reloaded.setTaxHistoryInternal(emplTax, false, oldEffectiveFrom);
            } else if (DateHelper.after((Date)els.getGueltigab(), (Date)emplTax.getValidFrom())) {
                block18: {
                    emplTax.setValidFrom(els.getGueltigab());
                    try {
                        emplTax.checkAttributes();
                    }
                    catch (BusinessDomainException e) {
                        if (!this.isErrorNotToConsider(e.getErrorNumber())) {
                            throw e;
                        }
                        if (this.allowedByYearChange(reloaded.getJournalizedUntil(), emplTax.getValidFrom())) break block18;
                        throw EmployeeExceptionMapper.makeChangeOfTaxByElstamNotAllowedDomainException();
                    }
                }
                reloaded.addTaxHistoryInternal(emplTax, true);
            }
            this.emplTaxListForValuation.add(new ForValuation(emplTax, reloaded));
        }
        return emplTax;
    }

    private boolean allowedByYearChange(Date journalizedUntil, Date validFrom) {
        VDate journDate = new VDate(journalizedUntil);
        VDate current = new VDate(this.currentDate);
        VDate validDate = new VDate(validFrom);
        if (journDate.getMonth() < 1 && journDate.getYear() == current.getYear() && (validDate.getYear() == current.getYear() || validDate.getYear() == current.getYear() - 1)) {
            return true;
        }
        return journDate.getMonth() == 11 && (journDate.getYear() == current.getYear() - 1 && (validDate.getYear() == current.getYear() || validDate.getYear() == current.getYear() - 1) || journDate.getYear() == current.getYear() && (validDate.getYear() == current.getYear() || validDate.getYear() == current.getYear() + 1));
    }

    private boolean isErrorNotToConsider(int errorNumber) {
        return errorNumber == 100155 || errorNumber == 100156;
    }

    private Elo2Account[] queryClosedAnfrageAccounts(String anIdNr, String compObjectId, String plantObjectId, String oidEmployee, String fileNumber, Date validFrom) {
        Conjunction filter = Restrictions.conjunction();
        filter.add(Restrictions.eq((String)"taxnumber", (String)anIdNr));
        filter.add(Restrictions.eq((String)"oidemployee", (String)oidEmployee));
        filter.add(Restrictions.eq((String)"oidpcompany", (String)compObjectId));
        if (plantObjectId != null) {
            filter.add(Restrictions.eq((String)"oidplant", (String)plantObjectId));
        } else {
            filter.add(Restrictions.isNull((String)"oidplant"));
        }
        filter.add(Restrictions.eq((String)"reasonofdelivery", (String)ReasonOfDeliveryEnumMapper.toString((ReasonOfDeliveryEnum)ReasonOfDeliveryEnum.ELSTAM)));
        filter.add(Restrictions.eq((String)"additionalenum1", (String)AdviceStateEnumMapper.toString((AdviceStateEnum)AdviceStateEnum.RECEIPTCREATED)));
        if (!StringMapper.isNullString((String)fileNumber)) {
            filter.add(Restrictions.eq((String)"additionalint1", (String)Integer.toString(Integer.parseInt(this.currentFileNumber))));
        }
        filter.add(Restrictions.eq((String)"validfrom", (String)DateMapper.toString((Date)validFrom)));
        filter.add(Restrictions.ne((String)"deleted", (String)BooleanMapper.toString((boolean)true)));
        return Elo2AccountPersistencyManager.query((Order[])new Order[]{Order.asc((String)"validfrom")}, (Criterion)filter, (boolean)true);
    }

    private Elo2Account[] queryClosedAccounts(String anIdNr, String compObjectId, String plantObjectId, String oidEmployee, String fileNumber, Date validFrom, ReasonOfDeliveryEnum reasonOfDelivery) {
        Conjunction filter = Restrictions.conjunction();
        filter.add(Restrictions.eq((String)"taxnumber", (String)anIdNr));
        filter.add(Restrictions.eq((String)"oidemployee", (String)oidEmployee));
        filter.add(Restrictions.eq((String)"oidpcompany", (String)compObjectId));
        if (plantObjectId != null) {
            filter.add(Restrictions.eq((String)"oidplant", (String)plantObjectId));
        } else {
            filter.add(Restrictions.isNull((String)"oidplant"));
        }
        filter.add(Restrictions.eq((String)"reasonofdelivery", (String)ReasonOfDeliveryEnumMapper.toString((ReasonOfDeliveryEnum)reasonOfDelivery)));
        filter.add(Restrictions.eq((String)"additionalenum1", (String)AdviceStateEnumMapper.toString((AdviceStateEnum)AdviceStateEnum.RECEIPTCREATED)));
        if (!StringMapper.isNullString((String)fileNumber)) {
            filter.add(Restrictions.eq((String)"additionalint1", (String)Integer.toString(Integer.parseInt(this.currentFileNumber))));
        }
        filter.add(Restrictions.eq((String)"validfrom", (String)DateMapper.toString((Date)validFrom)));
        filter.add(Restrictions.ne((String)"deleted", (String)BooleanMapper.toString((boolean)true)));
        return Elo2AccountPersistencyManager.query((Order[])new Order[]{Order.asc((String)"validfrom")}, (Criterion)filter, (boolean)true);
    }

    private Elo2Account[] queryAccountsForOrdnungsmerkmal(String ordnungsMerkmal, String oidPcompany) {
        Conjunction filter = Restrictions.conjunction();
        filter.add(Restrictions.eq((String)"oidpcompany", (String)oidPcompany));
        filter.add(Restrictions.eq((String)"ordnungsmerkmal", (String)ordnungsMerkmal));
        filter.add(Restrictions.ne((String)"deleted", (String)BooleanMapper.toString((boolean)true)));
        return Elo2AccountPersistencyManager.query(null, (Criterion)filter, (boolean)true);
    }

    private Elo2Account[] queryAccountsForAGTaxId(String taxId) {
        Conjunction filter = Restrictions.conjunction();
        filter.add(Restrictions.eq((String)"additionalstring2", (String)taxId));
        filter.add(this.getReasonOfDeliveryFilter());
        filter.add(Restrictions.in((String)"additionalenum1", (String[])new String[]{AdviceStateEnumMapper.toString((AdviceStateEnum)AdviceStateEnum.TRANSMITTED), AdviceStateEnumMapper.toString((AdviceStateEnum)AdviceStateEnum.READANSWERFAILED)}));
        filter.add(Restrictions.ne((String)"deleted", (String)BooleanMapper.toString((boolean)true)));
        return Elo2AccountPersistencyManager.query((Order[])new Order[]{Order.desc((String)"validfrom")}, (Criterion)filter, (boolean)false);
    }

    private Criterion getReasonOfDeliveryFilter() {
        if (this.additionalReasonOfDelivery == null) {
            return Restrictions.eq((String)"reasonofdelivery", (String)ReasonOfDeliveryEnumMapper.toString((ReasonOfDeliveryEnum)this.currentReasonOfDelivery));
        }
        return Restrictions.in((String)"reasonofdelivery", (String[])new String[]{ReasonOfDeliveryEnumMapper.toString((ReasonOfDeliveryEnum)this.currentReasonOfDelivery), ReasonOfDeliveryEnumMapper.toString((ReasonOfDeliveryEnum)this.additionalReasonOfDelivery)});
    }

    private Elo2Account[] queryLastClosedAnOrUmmeldung(String anIdNr, String compObjectId, String oidEmployee) {
        Conjunction filter = Restrictions.conjunction();
        filter.add(Restrictions.eq((String)"taxnumber", (String)anIdNr));
        filter.add(Restrictions.eq((String)"oidemployee", (String)oidEmployee));
        filter.add(Restrictions.eq((String)"oidpcompany", (String)compObjectId));
        filter.add(Restrictions.in((String)"reasonofdelivery", (String[])new String[]{ReasonOfDeliveryEnumMapper.toString((ReasonOfDeliveryEnum)ReasonOfDeliveryEnum.ANMELDUNG), ReasonOfDeliveryEnumMapper.toString((ReasonOfDeliveryEnum)ReasonOfDeliveryEnum.UMMELDUNG)}));
        filter.add(Restrictions.eq((String)"additionalenum1", (String)AdviceStateEnumMapper.toString((AdviceStateEnum)AdviceStateEnum.RECEIPTCREATED)));
        filter.add(Restrictions.ne((String)"deleted", (String)BooleanMapper.toString((boolean)true)));
        return Elo2AccountPersistencyManager.query((Order[])new Order[]{Order.desc((String)"validfrom"), Order.desc((String)"createdon")}, (Criterion)filter, (boolean)false);
    }

    private Elo2Account[] queryElo2Accounts(String anIdNr, String compObjectId, String plantObjectId, String oidEmployee, String fileNumber) {
        Conjunction filter = Restrictions.conjunction();
        filter.add(Restrictions.eq((String)"taxnumber", (String)anIdNr));
        filter.add(Restrictions.eq((String)"oidemployee", (String)oidEmployee));
        filter.add(Restrictions.eq((String)"oidpcompany", (String)compObjectId));
        if (plantObjectId != null) {
            filter.add(Restrictions.eq((String)"oidplant", (String)plantObjectId));
        }
        filter.add(this.getReasonOfDeliveryFilter());
        filter.add(Restrictions.in((String)"additionalenum1", (String[])new String[]{AdviceStateEnumMapper.toString((AdviceStateEnum)AdviceStateEnum.TRANSMITTED), AdviceStateEnumMapper.toString((AdviceStateEnum)AdviceStateEnum.READANSWERFAILED)}));
        filter.add(Restrictions.ne((String)"deleted", (String)BooleanMapper.toString((boolean)true)));
        if (!StringMapper.isNullString((String)fileNumber)) {
            filter.add(Restrictions.eq((String)"currentfilenumber", (String)fileNumber));
        }
        return Elo2AccountPersistencyManager.query((Order[])new Order[]{Order.desc((String)"validfrom")}, (Criterion)filter, (boolean)true);
    }

    private String getConfirmDataType() {
        String result = "7";
        String fileName = this.currentFile.getName().toUpperCase();
        if (fileName.startsWith("EELAN0_")) {
            result = "4";
        } else if (fileName.startsWith("EELAB0_")) {
            result = "5";
        } else if (fileName.startsWith("EELUM0_")) {
            result = "6";
        }
        return result;
    }

    private BigDecimal asBigDecimal(String source, int scale) {
        int unscaledValue = new BigInteger(source).intValue();
        return BigDecimal.valueOf(unscaledValue, scale);
    }

    private int asInt(String value) {
        return Integer.parseInt(value);
    }

    private Date asDate(String source) {
        if ("00000000".equals(source)) {
            return null;
        }
        try {
            return this.mDateFormat.parse(source);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(source);
        }
    }

    private String asString(String value) {
        return StringMapper.toStringWithTrim((String)value);
    }

    public void writePerfidiaFiles() {
        this.mPerfidiaResult.writePerfidiaFiles();
    }

    private IEmployeePersistencyManager getIEmployeePM() {
        return (IEmployeePersistencyManager)UtilitiesManager.getBean((String)"employeePersistencyManager", IEmployeePersistencyManager.class);
    }

    private static class ForValuation {
        private final Tax emplTax;
        private final Employee employee;

        public ForValuation(Tax emplTax, Employee employee) {
            this.emplTax = emplTax;
            this.employee = employee;
        }

        public Tax getEmplTax() {
            return this.emplTax;
        }

        public Employee getEmployee() {
            return this.employee;
        }
    }
}

