/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.eel.ikdata;

import com.varial.personnel.domain.eel.ikdata.IKData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class IKDataUtil {
    public static Map<String, IKData> mIKList = Collections.unmodifiableMap(new HashMap<String, IKData>(){
        {
            this.put("120390887", new IKData("120390887", "14066582", "BG der Bauwirtschaft", "Region Nord"));
            this.put("120991009", new IKData("120991009", "14066582", "BG der Bauwirtschaft", "Region S\u00fcd"));
            this.put("120590925", new IKData("120590925", "14066582", "BG der Bauwirtschaft", "Region Mitte"));
            this.put("120290671", new IKData("120290671", "37916971", "BG ETEM", "BV Hamburg, PLZ-Gebiet 20-22"));
            this.put("120390466", new IKData("120390466", "37916971", "BG ETEM", "BV Braunschweig, PLZ-Gebiet 26-31, 37, 38, 49"));
            this.put("120590184", new IKData("120590184", "37916971", "BG ETEM", "BV D\u00fcsseldorf, PLZ-Gebiet 40, 41, 45-47"));
            this.put("120590446", new IKData("120590446", "37916971", "BG ETEM", "Hauptverwaltung"));
            this.put("120590479", new IKData("120590479", "37916971", "BG ETEM", "BV K\u00f6ln, PLZ-Gebiet 32, 33, 48, 50-57, 58600-59"));
            this.put("120590685", new IKData("120590685", "37916971", "BG ETEM", "GS Wuppertal, PLZ-Gebiet 42, 44, 58-58599"));
            this.put("120690697", new IKData("120690697", "37916971", "BG ETEM", "BV Wiesbaden, PLZ-Gebiet 34, 35, 54, 55, 60, 61, 65-67"));
            this.put("120890483", new IKData("120890483", "37916971", "BG ETEM", "BV Stuttgart, PLZ-Gebiet 68-72, 74-77, 79"));
            this.put("120990495", new IKData("120990495", "37916971", "BG ETEM", "BV N\u00fcrnberg, PLZ-Gebiet 36, 63, 64, 90-97"));
            this.put("120990747", new IKData("120990747", "37916971", "BG ETEM", "BV Augsburg, PLZ-Gebiet 73, 78, 80-89"));
            this.put("121190455", new IKData("121190455", "37916971", "BG ETEM", "BV Berlin, PLZ-Gebiet 10, 12-19, 23-25, 39"));
            this.put("121490027", new IKData("121490027", "37916971", "BG ETEM", "GS Leipzig, PLZ-Gebiet 04, 06"));
            this.put("121490072", new IKData("121490072", "37916971", "BG ETEM", "BV Dresden, PLZ-Gebiet 01-03, 07-09, 98, 99"));
            this.put("120291466", new IKData("120291466", "15186676", "BG f\u00fcr Gesundheitsdienst und Wohlfahrtspflege", "BV Hamburg"));
            this.put("120292332", new IKData("120292332", "15186676", "BG f\u00fcr Gesundheitsdienst und Wohlfahrtspflege", "Hauptverwaltung"));
            this.put("120392355", new IKData("120392355", "15186676", "BG f\u00fcr Gesundheitsdienst und Wohlfahrtspflege", "BV Delmenhorst"));
            this.put("120592437", new IKData("120592437", "15186676", "BG f\u00fcr Gesundheitsdienst und Wohlfahrtspflege", "BV K\u00f6ln"));
            this.put("120592459", new IKData("120592459", "15186676", "BG f\u00fcr Gesundheitsdienst und Wohlfahrtspflege", "BV Bochum"));
            this.put("120792202", new IKData("120792202", "15186676", "BG f\u00fcr Gesundheitsdienst und Wohlfahrtspflege", "BV Mainz"));
            this.put("120892316", new IKData("120892316", "15186676", "BG f\u00fcr Gesundheitsdienst und Wohlfahrtspflege", "BV Karlsruhe"));
            this.put("120992282", new IKData("120992282", "15186676", "BG f\u00fcr Gesundheitsdienst und Wohlfahrtspflege", "BV M\u00fcnchen"));
            this.put("120992293", new IKData("120992293", "15186676", "BG f\u00fcr Gesundheitsdienst und Wohlfahrtspflege", "BV W\u00fcrzburg"));
            this.put("121191478", new IKData("121191478", "15186676", "BG f\u00fcr Gesundheitsdienst und Wohlfahrtspflege", "BV Berlin"));
            this.put("121490083", new IKData("121490083", "15186676", "BG f\u00fcr Gesundheitsdienst und Wohlfahrtspflege", "BV Dresden"));
            this.put("121590051", new IKData("121590051", "15186676", "BG f\u00fcr Gesundheitsdienst und Wohlfahrtspflege", "BV Magdeburg"));
            this.put("120790335", new IKData("120790335", "52742028", "BG Holz und Metall", "Hauptverwaltung"));
            this.put("120390810", new IKData("120390810", "63800761", "BG Nahrungsmittel und Gastgewerbe", "BV Hannover"));
            this.put("120590801", new IKData("120590801", "63800761", "BG Nahrungsmittel und Gastgewerbe", "BV Dortmund"));
            this.put("120790847", new IKData("120790847", "63800761", "BG Nahrungsmittel und Gastgewerbe", "BV Mainz"));
            this.put("120890780", new IKData("120890780", "63800761", "BG Nahrungsmittel und Gastgewerbe", "Hauptverwaltung"));
            this.put("120890837", new IKData("120890837", "63800761", "BG Nahrungsmittel und Gastgewerbe", "BV Mannheim"));
            this.put("120990792", new IKData("120990792", "63800761", "BG Nahrungsmittel und Gastgewerbe", "RD S\u00fcd"));
            this.put("121190821", new IKData("121190821", "63800761", "BG Nahrungsmittel und Gastgewerbe", "BV Berlin"));
            this.put("121690052", new IKData("121690052", "63800761", "BG Nahrungsmittel und Gastgewerbe", "BV Erfurt"));
            this.put("120892588", new IKData("120892588", "31608112", "BG RCI", ""));
            this.put("120892588", new IKData("120892588", "29029801", "BG RCI", ""));
            this.put("120892588", new IKData("120892588", "18484827", "BG RCI", ""));
            this.put("120892588", new IKData("120892588", "61635458", "BG RCI", ""));
            this.put("120892588", new IKData("120892588", "18484877", "BG RCI", ""));
            this.put("120892588", new IKData("120892588", "52717470", "BG RCI", ""));
            this.put("120291295", new IKData("120291295", "15141364", "BG Verkehr", "Hauptverwaltung"));
            this.put("120291319", new IKData("120291319", "15141364", "BG Verkehr", "BV Hamburg"));
            this.put("120291364", new IKData("120291364", "99011352", "BG Verkehr", "Bereich See / BV Hamburg"));
            this.put("120391321", new IKData("120391321", "15141364", "BG Verkehr", "BV Hannover"));
            this.put("120591334", new IKData("120591334", "15141364", "BG Verkehr", "BV Wuppertal"));
            this.put("120691346", new IKData("120691346", "15141364", "BG Verkehr", "BV Wiesbaden"));
            this.put("120991350", new IKData("120991350", "15141364", "BG Verkehr", "BV M\u00fcnchen"));
            this.put("121191309", new IKData("121191309", "15141364", "BG Verkehr", "BV Berlin"));
            this.put("121490061", new IKData("121490061", "15141364", "BG Verkehr", "BV Dresden"));
            this.put("120892305", new IKData("120892305", "66337061", "BG Verkehr", "Sparte Post, Postbank, Telekom"));
            this.put("120491151", new IKData("120491151", "32064004", "BGHW", "RD Nord"));
            this.put("120591130", new IKData("120591130", "32064004", "BGHW", "Direktion Bonn"));
            this.put("120591141", new IKData("120591141", "32064004", "BGHW", "RD West"));
            this.put("120891053", new IKData("120891053", "32064004", "BGHW", "Hauptverwaltung"));
            this.put("120891100", new IKData("120891100", "32064004", "BGHW", "RD S\u00fcdwest"));
            this.put("120991112", new IKData("120991112", "32064004", "BGHW", "RD S\u00fcdost"));
            this.put("121191172", new IKData("121191172", "32064004", "BGHW", "RD Ost"));
            this.put("120291182", new IKData("120291182", "15250094", "Verwaltungs-BG", "Hauptverwaltung"));
            this.put("120291193", new IKData("120291193", "15250094", "Verwaltungs-BG", "BV Hamburg, BV II"));
            this.put("120592380", new IKData("120592380", "15250094", "Verwaltungs-BG", "BV Bielefeld, BV III"));
            this.put("120592426", new IKData("120592426", "15250094", "Verwaltungs-BG", "BV Duisburg"));
            this.put("120592448", new IKData("120592448", "15250094", "Verwaltungs-BG", "BV Bergisch Gladbach, BV V"));
            this.put("120791212", new IKData("120791212", "15250094", "Verwaltungs-BG", "BV Mainz, BV VI"));
            this.put("120891224", new IKData("120891224", "15250094", "Verwaltungs-BG", "BV Ludwigsburg, BV VII"));
            this.put("120990122", new IKData("120990122", "15250094", "Verwaltungs-BG", "BV W\u00fcrzburg"));
            this.put("120991236", new IKData("120991236", "15250094", "Verwaltungs-BG", "BV M\u00fcnchen, BV VIII"));
            this.put("121191241", new IKData("121191241", "15250094", "Verwaltungs-BG", "BV Berlin"));
            this.put("121490016", new IKData("121490016", "15250094", "Verwaltungs-BG", "BV Dresden, BV XII"));
            this.put("121690030", new IKData("121690030", "15250094", "Verwaltungs-BG", "BV Erfurt, BV XI"));
            this.put("120491754", new IKData("120491754", "20345417", "Unfallkasse Freie Hansestadt Bremen", ""));
            this.put("120692198", new IKData("120692198", "44861264", "Unfallkasse Hessen", ""));
            this.put("120791791", new IKData("120791791", "53149588", "Unfallkasse Rheinland-Pfalz", ""));
            this.put("121091843", new IKData("121091843", "55423519", "Unfallkasse Saarland", ""));
            this.put("121191913", new IKData("121191913", "90276713", "Unfallkasse Berlin", ""));
            this.put("121290003", new IKData("121290003", "02379637", "Unfallkasse Brandenburg", ""));
            this.put("121390015", new IKData("121390015", "01681222", "Unfallkasse Mecklenburg-Vorpommern", ""));
            this.put("121490118", new IKData("121490118", "01064065", "Unfallkasse Sachsen", ""));
            this.put("121590039", new IKData("121590039", "03701377", "Unfallkasse Sachsen-Anhalt", ""));
            this.put("121690063", new IKData("121690063", "07235792", "Unfallkasse Th\u00fcringen", "Landesbereich"));
            this.put("121690074", new IKData("121690074", "07235792", "Unfallkasse Th\u00fcringen", "Kommunaler Bereich"));
            this.put("120891838", new IKData("120891838", "67334480", "Unfallkasse Baden-W\u00fcrttemberg", "Rehabilitation"));
            this.put("120392037", new IKData("120392037", "28143238", "Unfallversicherung Bund und Bahn", "Bereich Bund"));
            this.put("120291934", new IKData("120291934", "16716004", "Unfallkasse Nord", "Standorte Hamburg und Kiel"));
            this.put("120591802", new IKData("120591802", "34239086", "Unfallkasse NRW", "RD Rheinland"));
            this.put("120591824", new IKData("120591824", "34239086", "Unfallkasse NRW", "RD Westfalen-Lippe"));
            this.put("120391968", new IKData("120391968", "18626026", "Landesunfallkasse Niedersachsen", ""));
            this.put("120991942", new IKData("120991942", "88270171", "Bayerische Landesunfallkasse", "Sitz M\u00fcnchen"));
            this.put("120991737", new IKData("120991737", "87661207", "KUVB", "Kommunale Unfallversicherung Bayern"));
            this.put("120391742", new IKData("120391742", "21204943", "Braunschweigischer GUVV", ""));
            this.put("120391764", new IKData("120391764", "29086457", "GUVV Hannover", ""));
            this.put("120391786", new IKData("120391786", "26125562", "GUVV Oldenburg", ""));
            this.put("120692041", new IKData("120692041", "49005902", "Unfallversicherung Bund und Bahn", "Bereich Bahn"));
            this.put("120392333", new IKData("120392333", "29214533", "Feuerwehr-Unfallkasse Niedersachsen", ""));
            this.put("121290025", new IKData("121290025", "02379637", "Feuerwehr-Unfallkasse Brandenburg", ""));
            this.put("121590040", new IKData("121590040", "98705576", "Feuerwehr-Unfallkasse Mitte", "LGSt Sachsen-Anhalt"));
            this.put("121690096", new IKData("121690096", "09322747", "Feuerwehr-Unfallkasse Mitte", "LGSt Th\u00fcringen"));
            this.put("120292321", new IKData("120292321", "18645029", "Hanseatische Feuerwehr Unfallkasse Nord", "LGSt Hamburg"));
            this.put("121390059", new IKData("121390059", "01627953", "Hanseatische Feuerwehr-Unfallkasse Nord", "LGSt Mecklenburg-Vorpommern"));
            this.put("120192397", new IKData("120192397", "13385729", "Hanseatische Feuerwehr Unfallkasse Nord", "LGSt Schleswig-Holstein"));
            this.put("120192718", new IKData("120192718", "13174962", "SVLFG Landw. BG", "Standort Kiel"));
            this.put("120392732", new IKData("120392732", "29139336", "SVLFG Landw. BG", "Standort Hannover"));
            this.put("120592778", new IKData("120592778", "39892693", "SVLFG Landw. BG", "Standort M\u00fcnster"));
            this.put("120692780", new IKData("120692780", "47042806", "SVLFG Landw. BG", "Standort Kassel"));
            this.put("120692893", new IKData("120692893", "47009510", "SVLFG Landw. BG", "Zentrale"));
            this.put("120892884", new IKData("120892884", "67545123", "SVLFG Landw. BG", "Standort Stuttgart"));
            this.put("120992830", new IKData("120992830", "87108525", "SVLFG Landw. BG", "Standort Landshut"));
            this.put("120992943", new IKData("120992943", "72305544", "SVLFG Landw. BG", "Standort Bayreuth"));
            this.put("121192925", new IKData("121192925", "08270878", "SVLFG Landw. BG", "Standort Hoppegarten"));
        }
    });

    private IKDataUtil() {
    }

    public static IKData[] getIKDatas() {
        IKData[] results = new IKData[mIKList.values().size()];
        results = mIKList.values().toArray(results);
        return results;
    }

    public static IKData getIKDatasByFullIKnummer(String iknummer) {
        return mIKList.get(iknummer);
    }

    public static IKData[] getIKDatasByIKnummer(String iknummer) {
        ArrayList<IKData> ikDatas = new ArrayList<IKData>();
        for (IKData each : mIKList.values()) {
            if (!each.getIKnummer().startsWith(iknummer)) continue;
            ikDatas.add(each);
        }
        IKData[] results = new IKData[ikDatas.size()];
        return ikDatas.toArray(results);
    }

    public static IKData[] getIKDatasByBbnr(String bbnr) {
        ArrayList<IKData> ikDatas = new ArrayList<IKData>();
        for (IKData each : mIKList.values()) {
            if (!each.getBbnr().startsWith(bbnr)) continue;
            ikDatas.add(each);
        }
        IKData[] results = new IKData[ikDatas.size()];
        return ikDatas.toArray(results);
    }

    public static IKData[] getIKDatasByName1(String name) {
        ArrayList<IKData> ikDatas = new ArrayList<IKData>();
        for (IKData each : mIKList.values()) {
            if (!each.getName1().contains(name)) continue;
            ikDatas.add(each);
        }
        IKData[] results = new IKData[ikDatas.size()];
        return ikDatas.toArray(results);
    }
}

