/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.eau.receive;

import com.varial.base.UtilitiesManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.criterion.Conjunction;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Order;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.security.AuthorizationToken;
import com.varial.base.session.SessionContext;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.deuv.DataRecipientUtil;
import com.varial.personnel.domain.deuv.Deuv;
import com.varial.personnel.domain.deuv.DeuvResponse;
import com.varial.personnel.domain.deuv.PerfidiaDataType;
import com.varial.personnel.domain.deuvmessaging.BasicReceive;
import com.varial.personnel.domain.deuvmessaging.basiccomponents.Dbap;
import com.varial.personnel.domain.deuvmessaging.perfidia.PerfidiaHelper;
import com.varial.personnel.domain.eau.eauaccount.EauAccount;
import com.varial.personnel.domain.eau.eauaccount.EauAdviceStateEnum;
import com.varial.personnel.domain.eau.eauaccount.IEauAccountPersistencyManager;
import com.varial.personnel.domain.eau.eaudbap.EauDbap;
import com.varial.personnel.domain.eau.eaudxkk.EauDxkk;
import com.varial.personnel.domain.employee.Employee;
import com.varial.personnel.domain.employee.absenttime.EEAbsentTimeTP;
import com.varial.personnel.domain.global.deuv.recipient.DEUVRecipient;
import com.varial.personnel.domain.global.deuv.sender.DEUVSender;
import com.varial.personnel.framework.PFileHelper;
import com.varial.personnel.framework.basictypes.PDateHelper;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.StringMapper;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class EauReceive
extends BasicReceive<EauAccount> {
    private static final String[] FILENAMEFILTER = new String[]{"EEAA0", "TEAA0", "EEAR0", "TEAR0"};
    private static final int LENGTH_TO_FILENUMBER = 71;
    private static final Pattern VOSX_TO_FILENUMBER = Pattern.compile("VOSX010000(.{5})(.{15})(.{15})(\\d{20})(\\d{6})(.*)");
    private static final Pattern DXKK1 = Pattern.compile("DXKK(\\d{6})(.{15})(.{15})(\\d{20})(.{7})(.{8})(.{32})(.{20})(.{1})(.{32})(.{15})(.{1})(.*)");
    private static final Pattern DBAP = Pattern.compile("(.{1})(.{30})(.{20})(.{20})(.{70})(.{30})(.{30})(.{30})(.{10})(.{34})(.{33})(.{09})(.{100})(.*)");
    private static final Pattern DXKK2_1 = Pattern.compile("(.{1})(.{30})(.{30})(.{12})(\\d{8})(\\d{8})(\\d{8})(\\d{8})(.{1})(.{1})(.{1})(.{1})([J])(.{8})(.{8})(.{1})(.*)");
    private static final Pattern DXKK2_2 = Pattern.compile("(.{1})(.{30})(.{30})(.{12})(\\d{8})(\\d{8})(\\d{8})(\\d{8})(.{1})(.{1})(.{1})(.{1})([N])(.{1})(.*)");
    private static final int DBAP_LENGTH = 416;
    private static final int DXKK2_1_LENGTH = 627;
    private static final int DXKK2_2_LENGTH = 611;
    private static final int DXKK_REST_GROUP = 13;
    private static final Pattern DXVE = Pattern.compile("DXVE010000(.{32})(\\d{1})(\\d{6})(.{7})(.{2000})(.*)");
    private static final Pattern DXVD = Pattern.compile("DXVD010000(.{32})(\\d{6})(.{32})(\\d{1})(.*)");
    private static final Pattern DXVD_ERROR = Pattern.compile("(.{7})(.{64})(.{100})(.*)");
    private static final int DXVE_LENGTH = 2156;
    private static final int DXVD_MIN_LENGTH = 352;
    private static final int DXVD_ERROR_LENGTH = 171;
    private final AuthorizationToken mToken;

    public EauReceive(DEUVSender deuvSender, AuthorizationToken token) {
        super(deuvSender);
        this.mToken = token;
    }

    public FilenameFilter getFilenameFilter() {
        return PerfidiaHelper.getFilenameFilter((String[])FILENAMEFILTER);
    }

    protected boolean isFileValid(File file, DEUVRecipient deuvRecipient) throws BusinessDomainException {
        PFileHelper.checkFile((File)file, (String)"Meldung elektronische Arbeitsunf\u00e4higkeitsbescheinigung");
        CharSequence content = PFileHelper.getFileContent((File)file, (String)ISO_8859_1, (int)71);
        Matcher matcherVosx = VOSX_TO_FILENUMBER.matcher(content);
        if (matcherVosx.matches()) {
            String name = file.getName().toUpperCase();
            if (name.startsWith("EEAA0") || name.startsWith("TEAA0")) {
                Matcher dxvdMatcher;
                LinkedList records = PFileHelper.getFileLines((File)file, (String)ISO_8859_1);
                records.pollFirst();
                int fileNumberRecv = this.getFileNumberFromEnding(file.getName());
                if (fileNumberRecv < 0) {
                    fileNumberRecv = Integer.parseInt(matcherVosx.group(5));
                }
                int fileNumberSend = 0;
                String firstRecord = (String)records.getFirst();
                if (firstRecord.startsWith("DXVE")) {
                    Matcher dxveMatcher = DXVE.matcher(firstRecord);
                    if (dxveMatcher.matches()) {
                        fileNumberSend = this.asInteger(dxveMatcher.group(3));
                    }
                } else if (firstRecord.startsWith("DXVD") && (dxvdMatcher = DXVD.matcher(firstRecord)).matches()) {
                    fileNumberSend = this.asInteger(dxvdMatcher.group(2));
                }
                return this.needImport(file, deuvRecipient, PerfidiaDataType.EAA, fileNumberSend, fileNumberRecv);
            }
            return true;
        }
        return false;
    }

    public String getProcedureName() {
        return "eAU";
    }

    public String getFileDescription() {
        return "R\u00fcckmeldung(en) elektronische AU";
    }

    public String getActionName() {
        return "importieren";
    }

    public void readEauReceives(DEUVRecipient deuvRecipient) throws BusinessDomainException {
        this.initFiles();
        this.mRecipient = deuvRecipient;
        for (File file : (List)this.mFiles.get(deuvRecipient)) {
            this.readEauReceives(file);
            SessionContext.getInstance().getPersistencySession().flush();
        }
    }

    private void readEauReceives(File input) throws BusinessDomainException {
        this.mCurrent = input;
        CharSequence content = PFileHelper.getFileContent((File)input, (String)ISO_8859_1, (int)71);
        Matcher matcher = VOSX_TO_FILENUMBER.matcher(content);
        if (matcher.matches()) {
            int currentFileNumber = this.getFileNumberFromEnding(input.getName());
            if (currentFileNumber < 0) {
                currentFileNumber = Integer.parseInt(matcher.group(5));
            }
            LinkedList records = PFileHelper.getFileLines((File)input, (String)ISO_8859_1);
            records.pollFirst();
            records.pollLast();
            String name = input.getName().toUpperCase();
            if (name.startsWith("EEAR0") || name.startsWith("TEAR0")) {
                while (!records.isEmpty()) {
                    this.readDxkk((String)records.pollFirst(), currentFileNumber);
                    SessionContext.getInstance().getPersistencySession().flush();
                }
                this.mAcknowledgement.addProcessedFile(input, PerfidiaDataType.EAR, this.mRecipient, currentFileNumber);
            } else {
                while (!records.isEmpty()) {
                    if (((String)records.getFirst()).startsWith("DXVE")) {
                        this.readDxve(input, (String)records.pollFirst(), currentFileNumber);
                        continue;
                    }
                    if (!((String)records.getFirst()).startsWith("DXVD")) continue;
                    this.readDxvd(input, (String)records.pollFirst(), currentFileNumber);
                }
            }
        } else {
            throw new IllegalStateException(input.getPath() + " don't match: " + matcher);
        }
        this.mPerfidiaResult.addReceivedFile(input);
    }

    private void readDxve(File file, String input, int currentFileNumber) throws BusinessDomainException {
        Matcher matcher = this.checkInputGetMatcher(input, 2156, DXVE);
        String status = this.asString(matcher.group(2));
        int dateiNr = Integer.parseInt(matcher.group(3));
        String errorNr = this.asString(matcher.group(4));
        String error = this.asString(matcher.group(5));
        if (status.equals("1")) {
            EauAccount account = new EauAccount(null, true);
            account.addError("Parser-Fehler bei gesendeten Antrag. Dateiname Verarbeitungsergebnis: " + file.getAbsolutePath() + ", Fehler: " + error + ".");
            account.setAnswerType("DXVE");
            this.mImporteds.add(account);
        } else {
            EauAccount[] accounts;
            for (EauAccount account : accounts = EauAccount.getEauAccountsByFileNr(dateiNr, this.mRecipient)) {
                if (EauAdviceStateEnum.VERARBEITET.equals((Object)account.getAdviceState()) || EauAdviceStateEnum.ABGELEHNT.equals((Object)account.getAdviceState())) continue;
                account.makeSaveable();
                if (status.equals("0")) {
                    account.setAdviceState(EauAdviceStateEnum.VERARBEITET);
                    continue;
                }
                if (!status.equals("2")) continue;
                account.setAdviceState(EauAdviceStateEnum.ABGELEHNT);
                account.addError("(" + errorNr + ")" + error + ".");
            }
        }
        this.mAcknowledgement.addProcessedFile(file, PerfidiaDataType.EAA, this.mRecipient, dateiNr, currentFileNumber);
    }

    private void readDxvd(File file, String input, int currentFileNumber) throws BusinessDomainException {
        Matcher matcher = this.checkInputGetMatcher(input, 352, DXVD);
        int dateiNr = Integer.parseInt(matcher.group(2));
        String datensatzID = this.asString(matcher.group(3));
        Integer anzahl = Integer.valueOf(this.asString(matcher.group(4)));
        String rest = matcher.group(5);
        EauAccount account = this.getOrigin(datensatzID);
        if (account == null) {
            account = new EauAccount(null, true);
            account.addError("Verarbeitungsergebnis wurde nicht eingelesen, da das eAU-Meldekonto nicht gefunden wurde:" + file.getName() + ".");
            this.mImporteds.add(account);
        } else if (!EauAdviceStateEnum.VERARBEITET.equals((Object)account.getAdviceState()) && !EauAdviceStateEnum.ABGELEHNT.equals((Object)account.getAdviceState())) {
            account.setAdviceState(EauAdviceStateEnum.ABGELEHNT);
            account.makeSaveable();
        }
        account.setAnswerType("DXVD");
        for (int i = 0; i < anzahl; ++i) {
            matcher = this.checkInputGetMatcher(rest, 171, DXVD_ERROR);
            String errorNr = this.asString(matcher.group(1));
            String error = this.asString(matcher.group(2));
            rest = matcher.group(4);
            account.addError("(" + errorNr + ")" + error + ".");
        }
        this.mAcknowledgement.addProcessedFile(file, PerfidiaDataType.EAA, this.mRecipient, dateiNr, currentFileNumber);
    }

    private EauAccount getOrigin(String oid) {
        return !StringUtils.isNumeric((CharSequence)oid) || oid.length() > 18 ? null : this.getReceived(oid);
    }

    private EauAccount getReceived(String oid) {
        EauAccount[] receiveds = this.getPm().query(null, Restrictions.eq((String)"OBJECTID", (String)oid), true);
        return receiveds.length == 0 ? null : receiveds[0];
    }

    private boolean needImport(File input, DEUVRecipient responder, PerfidiaDataType type, int fileNumberSend, int fileNumberRecv) throws BusinessDomainException {
        int perfidiaSubFolder = DataRecipientUtil.getSubFolderNumberByCompNo((String)responder.getCurrentDEUVRecipientTP().getStdCompanyNumber());
        DeuvResponse response = new DeuvResponse(type, perfidiaSubFolder, fileNumberSend, fileNumberRecv, input.getName().startsWith("T") || input.getName().startsWith("t") ? 1 : 0);
        return response.needAcknowlegement(this.mDeuvSender);
    }

    private void readDxkk(String input, int currentFileNumber) throws BusinessDomainException {
        Matcher matcher = this.checkInputGetMatcher(input, 0, DXKK1);
        EauDxkk dxkk = this.createEauDxkk(matcher);
        EauAccount account = this.getOrigin(dxkk);
        if (dxkk.getKennzstorno().equals("J")) {
            account.setAdviceState(EauAdviceStateEnum.UEBERMITTELT);
            for (EauDxkk eauDxkk : account.getEauDxkk()) {
                if (!eauDxkk.getAuabag().equals(dxkk.getAuabag())) continue;
                eauDxkk.destroy();
            }
        } else {
            account.setAdviceState(EauAdviceStateEnum.VERARBEITET);
            dxkk.makeSaveable();
        }
        account.setCurrentFileNumber(currentFileNumber);
        account.setDEUVRecipient(this.mRecipient);
        if (!account.isReadOnly() && StringMapper.isNullString((String)dxkk.getMessage()) && !"4".contentEquals(dxkk.getKzaktuelleau()) && !"1".contentEquals(dxkk.getKzaktuelleau())) {
            Date until = this.getUntil(dxkk);
            this.doActionsByReason(account, until, "J".equals(dxkk.getKennzstorno()), dxkk);
        }
        account.addEauDxkkForProtocol(dxkk);
        this.mImporteds.add(account);
    }

    private Date getUntil(EauDxkk dxkk) {
        Date until = dxkk.getAubisvoraussicht();
        if (until == null) {
            until = dxkk.getStationbis();
        }
        return until;
    }

    private EauAccount getOrigin(EauDxkk dxkk) {
        String azvu = dxkk.getAzvu().replaceAll(" / ", "/");
        Employee employee = Deuv.findEmployeeByAzOrVsnr((String)azvu, (String)dxkk.getVsnr(), (String)dxkk.getBbnrempfaenger(), (Date)dxkk.getAuabag());
        if (employee == null) {
            EauAccount account = new EauAccount(null, true);
            account.addError("Zuordnung zum Mitarbeiter anhand AZVU oder VSNR nicht m\u00f6glich: " + dxkk.getAzvu() + " / " + dxkk.getVsnr() + ".");
            return account;
        }
        EauAccount account = this.getReceived(employee, dxkk);
        if (account == null) {
            account = new EauAccount(employee, true);
            account.addError("R\u00fcckmeldung wurde nicht eingelesen, da das eAU-Meldekonto nicht gefunden wurde.");
        } else {
            account.setErrorMessage("");
            if ("J".equals(dxkk.getFolgebescheinigung())) {
                dxkk.addError("F\u00fcr R\u00fcckmeldungen von Folgeanforderungen wird grunds\u00e4tzlich keine \u00dcbernahme in die Mitarbeiterfehlzeit vorgenommen. Bitte ggf. manuell anpassen.");
            } else {
                EauDxkk[] dxkks = account.getEauDxkk();
                if (dxkks.length > 0) {
                    boolean noSave = false;
                    for (EauDxkk each : dxkks) {
                        if (each.isNew() && !DateHelper.afterOrEqual((Date)this.getUntil(each), (Date)this.getUntil(dxkk)) || "4".contentEquals(each.getKzaktuelleau()) || "1".contentEquals(each.getKzaktuelleau())) continue;
                        noSave = true;
                    }
                    if (noSave) {
                        dxkk.addError("Keine \u00dcbernahme in die Mitarbeiterfehlzeit, da bereits eine R\u00fcckmeldung f\u00fcr das AU-ab-AG-Datum eingelesen wurde. Bitte ggf. pr\u00fcfen.");
                    }
                }
            }
            account.makeSaveable();
            dxkk.setEauAccount(account);
            dxkk.makeSaveable();
        }
        return account;
    }

    private void doActionsByReason(EauAccount account, Date until, boolean isStorno, EauDxkk dxkk) throws BusinessDomainException {
        EEAbsentTimeTP absentTimeTP = account.getEEAbsentTimeTP();
        if (absentTimeTP != null) {
            if (isStorno) {
                absentTimeTP.setValidUntil(VDate.getDateMax());
                account.setValidUntil(null);
                account.setCancelFromHF(true);
            } else {
                if (DateHelper.before((Date)until, (Date)absentTimeTP.getValidFrom())) {
                    dxkk.addError("Keine \u00dcbernahme in die Mitarbeiterfehlzeit, da eAU-Bis = " + DateMapper.toDDMMYYYYPointSeparationString((Date)until) + " vor dem Beginn der Fehlzeit = " + DateMapper.toDDMMYYYYPointSeparationString((Date)absentTimeTP.getValidFrom()) + " ist.");
                    return;
                }
                Date validUntil = absentTimeTP.getValidUntil();
                if (validUntil == null || VDate.isDateMax((Date)validUntil) || DateHelper.afterOrEqual((Date)until, (Date)validUntil)) {
                    absentTimeTP.setValidUntil(until);
                    account.setValidUntil(until);
                } else {
                    dxkk.addError("Keine \u00dcbernahme in die Mitarbeiterfehlzeit, da eAU-Bis = " + DateMapper.toDDMMYYYYPointSeparationString((Date)until) + " vor dem Ende der Fehlzeit = " + DateMapper.toDDMMYYYYPointSeparationString((Date)validUntil) + " ist.");
                    return;
                }
            }
            try {
                absentTimeTP.checkPostCondition();
            }
            catch (BusinessDomainException bde) {
                dxkk.addError("Keine \u00dcbernahme in die Mitarbeiterfehlzeit: " + bde.getLocalizedMessage());
                return;
            }
            account.setAbsentTimeChanged(true);
            absentTimeTP.makeSaveable();
            absentTimeTP.updateFromEELOrEAU(this.mToken);
        } else {
            dxkk.addError("Keine \u00dcbernahme in die Mitarbeiterfehlzeit, da eine passende Fehlzeit nicht gefunden wurde.");
        }
    }

    private EauDxkk createEauDxkk(Matcher matcher) throws BusinessDomainException {
        EauDxkk dxkk = this.initEauDxkk(matcher);
        String rest = matcher.group(13);
        if (dxkk.hasMmDbap()) {
            rest = this.initDbap(rest, dxkk.getDbap());
        }
        rest = this.initDxkk2(rest, dxkk);
        dxkk.makeReadOnly();
        return dxkk;
    }

    private EauDxkk initEauDxkk(Matcher matcher) {
        int i = 1;
        String version = this.asString(matcher.group(i++));
        String bbnrab = this.asString(matcher.group(i++));
        String bbnrep = this.asString(matcher.group(i++));
        String datumer = this.asString(matcher.group(i++));
        String prodid = this.asString(matcher.group(i++));
        String modid = this.asString(matcher.group(i++));
        String datensatzID = this.asString(matcher.group(i++));
        String azvu = this.asString(matcher.group(i++));
        String kennzst = this.asString(matcher.group(i++));
        String datensatzIDUrspung = this.asString(matcher.group(i++));
        String bbnrvu = this.asString(matcher.group(i++));
        String mmap = this.asString(matcher.group(i++));
        EauDxkk dxkk = new EauDxkk();
        dxkk.setBbnrabsender(bbnrab);
        dxkk.setBbnrempfaenger(bbnrep);
        dxkk.setDatumerstellung(datumer);
        dxkk.setProdid(prodid);
        dxkk.setModid(modid);
        dxkk.setDatensatzid(datensatzID);
        dxkk.setAzvu(azvu);
        dxkk.setKennzstorno(kennzst);
        dxkk.setDatensatzidursprung(datensatzIDUrspung);
        dxkk.setBbnrverursacher(bbnrvu);
        dxkk.setBbnrabrechnungsstelle("");
        if ("1".equals(mmap)) {
            dxkk.createDbap();
        }
        return dxkk;
    }

    private String initDbap(String input, EauDbap dbap) throws BusinessDomainException {
        Matcher matcher = this.checkInputGetMatcher(input, 416, DBAP);
        int i = 1;
        String geschlechtAP = this.asString(matcher.group(i++));
        String nameAP = this.asString(matcher.group(i++));
        String telefonAP = this.asString(matcher.group(i++));
        String faxAP = this.asString(matcher.group(i++));
        String emailAP = this.asString(matcher.group(i++));
        String name1 = this.asString(matcher.group(i++));
        String name2 = this.asString(matcher.group(i++));
        String name3 = this.asString(matcher.group(i++));
        String plz = this.asString(matcher.group(i++));
        String ort = this.asString(matcher.group(i++));
        String strasse = this.asString(matcher.group(i++));
        String hausnr = this.asString(matcher.group(i++));
        Dbap data = new Dbap();
        data.setAnrap(geschlechtAP);
        data.setNameap(nameAP);
        data.setTelap(telefonAP);
        data.setFaxap(faxAP);
        data.setEmailap(emailAP);
        data.setName1(name1);
        data.setName2(name2);
        data.setName3(name3);
        data.setPlz(plz);
        data.setOrt(ort);
        data.setStrasse(strasse);
        data.setHausnr(hausnr);
        dbap.setDbapData(data);
        return matcher.group(++i);
    }

    private String initDxkk2(String input, EauDxkk dxkk) throws BusinessDomainException {
        boolean mmsa;
        Matcher matcher = this.checkInputGetMatcher(input, 627, DXKK2_1, false);
        if (matcher == null) {
            matcher = this.checkInputGetMatcher(input, 611, DXKK2_2);
            mmsa = false;
        } else {
            mmsa = true;
        }
        int i = 1;
        String geschlecht = this.asString(matcher.group(i++));
        String vorname = this.asString(matcher.group(i++));
        String nachname = this.asString(matcher.group(i++));
        String vsnr = this.asString(matcher.group(i++));
        String auabag = this.asString(matcher.group(i++));
        String auseit = this.asString(matcher.group(i++));
        String aubis = this.asString(matcher.group(i++));
        String festgestelltam = this.asString(matcher.group(i++));
        String kennzAU = this.asString(matcher.group(i++));
        String arbeitsunfall = this.asString(matcher.group(i++));
        String darzt = this.asString(matcher.group(i++));
        String sonstUnfall = this.asString(matcher.group(i++));
        String stationaer = this.asString(matcher.group(i++));
        if (mmsa && "J".equals(stationaer)) {
            String aufnahme = this.asString(matcher.group(i++));
            String dauerKH = this.asString(matcher.group(i++));
            dxkk.setStationab(this.toDateYYYYMMDD(aufnahme));
            dxkk.setStationbis(this.toDateYYYYMMDD(dauerKH));
        }
        String bescheinigungsart = this.asString(matcher.group(i++));
        dxkk.setGeschlecht(geschlecht);
        dxkk.setVorname(vorname);
        dxkk.setFamilienname(nachname);
        dxkk.setVsnr(vsnr);
        dxkk.setAuabag(this.toDateYYYYMMDD(auabag));
        dxkk.setAuabkk(this.toDateYYYYMMDD(auseit));
        dxkk.setAubisvoraussicht(this.toDateYYYYMMDD(aubis));
        dxkk.setFestgestelltam(this.toDateYYYYMMDD(festgestelltam));
        dxkk.setKzaktuelleau(kennzAU);
        dxkk.setArbeitsunfall(arbeitsunfall);
        dxkk.setDarztzugewiesen(darzt);
        dxkk.setSonstigerunfall(sonstUnfall);
        if ("1".equals(bescheinigungsart)) {
            dxkk.setErstbescheinigung("J");
            dxkk.setFolgebescheinigung("N");
        } else if ("2".equals(bescheinigungsart)) {
            dxkk.setErstbescheinigung("N");
            dxkk.setFolgebescheinigung("J");
        } else {
            dxkk.setErstbescheinigung("N");
            dxkk.setFolgebescheinigung("N");
        }
        return "";
    }

    private Date toDateYYYYMMDD(String date) {
        if ("99999999".equals(date)) {
            return null;
        }
        return PDateHelper.toDateYYYYMMDD((String)date);
    }

    private EauAccount getReceived(Employee emp, EauDxkk dxkktemp) {
        Conjunction filter = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"OIDEMPLOYEE", (String)emp.getObjectid()), Restrictions.ge((String)"VALIDFROM", (String)DateMapper.toString((Date)dxkktemp.getAuabag())), Restrictions.eq((String)"REASONOFDELIVERY", (String)"0"), Restrictions.or((Criterion)Restrictions.eq((String)"advicestate", (String)("" + EauAdviceStateEnum.UEBERMITTELT.ordinal())), (Criterion)Restrictions.eq((String)"advicestate", (String)("" + EauAdviceStateEnum.VERARBEITET.ordinal()))), Restrictions.eq((String)"CANCELED", (String)"N")});
        Order[] sort = new Order[]{Order.asc((String)"CREATEDON")};
        EauAccount[] receiveds = this.getPm().query(sort, (Criterion)filter, true);
        if (receiveds == null || receiveds.length == 0) {
            return null;
        }
        return receiveds[0];
    }

    private IEauAccountPersistencyManager getPm() {
        return (IEauAccountPersistencyManager)UtilitiesManager.getBean((String)"eauAccountPersistencyManager", IEauAccountPersistencyManager.class);
    }

    private int getFileNumberFromEnding(String filename) {
        String ending = null;
        if (filename != null && filename.length() >= 7 && filename.charAt(filename.length() - 4) == '.') {
            String firstPart = filename.substring(filename.length() - 7, filename.length() - 4);
            String secondPart = filename.substring(filename.length() - 3, filename.length());
            ending = firstPart.concat(secondPart);
        }
        int fileNumber = -1;
        if (ending != null) {
            try {
                fileNumber = Integer.parseInt(ending);
            }
            catch (NumberFormatException e) {
                fileNumber = -1;
            }
        }
        return fileNumber;
    }
}

