/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.eau.eauaccount;

import com.varial.base.UtilitiesManager;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Order;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.session.SessionContext;
import com.varial.personnel.domain.eau.eauaccount.EauAccount;
import com.varial.personnel.domain.eau.eauaccount.EauAdviceStateEnum;
import com.varial.personnel.domain.eau.eauaccount.IEauAccountPersistencyManager;
import com.varial.personnel.domain.eau.eauaccount.ReasonOfInterruptEnum;
import com.varial.personnel.domain.employee.IEmployeePersistencyManager;
import com.varial.personnel.domain.global.deuv.recipient.DEUVRecipient;
import com.varial.personnel.domain.global.deuv.sender.DEUVSender;
import com.varial.personnel.persistency.eau.eauaccount.EauaccountContainer;
import com.varial.personnel.persistency.eau.eauaccount.IEauaccountDao;
import com.varial.personnel.persistency.eau.eauaccountall.EauaccountallContainer;
import com.varial.personnel.persistency.eau.eauaccountall.IEauaccountallDao;
import com.varial.serverbase.mapper.ExceptionMapper;
import com.varial.serverbase.mapper.StringMapper;
import com.varial.serverbase.persistency.IPersistentObject;
import com.varial.serverbase.persistency.PersistentObjectUtils;

public class EauAccountPersistencyManager
implements IEauAccountPersistencyManager {
    private static IEauaccountDao dao = (IEauaccountDao)UtilitiesManager.getApplicationContext().getBean("eauaccountDao");
    private static IEauaccountallDao daoAll = (IEauaccountallDao)UtilitiesManager.getApplicationContext().getBean("eauaccountallDao");

    public EauAccount[] query(Order[] sort, Criterion filters, boolean readOnly) {
        try {
            EauaccountContainer[] containers = dao.getRows(sort, filters);
            int count = containers.length;
            EauAccount[] result = new EauAccount[count];
            for (int i = 0; i < count; ++i) {
                result[i] = new EauAccount(EauAccountPersistencyManager.getIEmployeePM().getEmployee(containers[i].oidemployee), readOnly);
                this.fillEauAccount(result[i], containers[i]);
            }
            return result;
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    public EauAccount[] queryAll(Order[] sort, Criterion filters, boolean readOnly) {
        try {
            EauaccountallContainer[] containers = daoAll.getRows(sort, filters);
            int count = containers.length;
            EauAccount[] result = new EauAccount[count];
            for (int i = 0; i < count; ++i) {
                result[i] = new EauAccount(EauAccountPersistencyManager.getIEmployeePM().getEmployee(containers[i].oidemployee), readOnly);
                this.fillEauAccount(result[i], containers[i]);
            }
            return result;
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    public void load(EauAccount eauAccount) {
        EauaccountContainer container = null;
        try {
            container = dao.getRowByObjectID(eauAccount.getObjectid());
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        if (container == null) {
            throw ExceptionMapper.makeDataNotFoundPersistencyException((String)eauAccount.getObjectid());
        }
        this.fillEauAccount(eauAccount, container);
    }

    public void save(EauAccount eauAccount) {
        EauaccountContainer container = dao.getInitializedInstance();
        this.fillContainer(container, eauAccount);
        try {
            container = eauAccount.isNew() ? dao.insert(SessionContext.getInstance().getSession().getUserCode(), container) : dao.update(SessionContext.getInstance().getSession().getUserCode(), container);
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        eauAccount.setObjectid(container.getObjectid());
        eauAccount.setVersion(container.getVersion());
        eauAccount.setLastuser(container.getLastUserid());
        eauAccount.setTimestamp(container.getObjectTS());
    }

    public void delete(EauAccount eauAccount) {
        try {
            dao.delete(SessionContext.getInstance().getSession().getUserCode(), eauAccount.getObjectid(), eauAccount.getVersion());
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    public void delete(String oidEmployee) {
        try {
            dao.delete(SessionContext.getInstance().getSession().getUserCode(), Restrictions.eq((String)"oidemployee", (String)oidEmployee));
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    public boolean exists(Criterion criterion) {
        try {
            return dao.exists(criterion);
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    private void fillEauAccount(EauAccount bo, EauaccountContainer container) {
        if (!StringMapper.isNullString((String)container.oidemployee)) {
            bo.setEmployee(EauAccountPersistencyManager.getIEmployeePM().getEmployee(container.oidemployee));
        }
        bo.setEffectiveFrom(container.effectivefrom);
        bo.setValidFrom(container.validfrom);
        bo.setValidUntil(container.validuntil);
        bo.setCreatedOn(container.createdon);
        bo.setReasonOfDelivery(container.reasonofdelivery);
        bo.setTransmitted(container.transmitted);
        bo.setCanceled(container.canceled);
        bo.setAdviceState(EauAdviceStateEnum.toAdviceStateEnum((int)container.advicestate));
        bo.setCurrentFileNumber(container.currentfilenumber);
        bo.setAktenzeichenVU(container.aktenzeichenvu);
        bo.setAktenzeichenSV(container.aktenzeichensv);
        if (!StringMapper.isNullString((String)container.oiddeuvsender)) {
            bo.setDEUVSender(DEUVSender.getDEUVSender((String)container.oiddeuvsender));
        }
        if (!StringMapper.isNullString((String)container.oiddeuvrecipient)) {
            bo.setDEUVRecipient(DEUVRecipient.getDEUVRecipient((String)container.oiddeuvrecipient));
        }
        bo.setErrorMessage(container.errormessage);
        bo.setReasonOfInterrupt(ReasonOfInterruptEnum.toEnum((int)container.reasonofinterrupt));
        bo.setSuccession(container.succession);
        bo.setDateOfRefreshStatusPossible(container.additionaldate1);
        bo.setObjectid(container.getObjectid());
        bo.setVersion(container.getVersion());
        bo.setLastuser(container.getLastUserid());
        bo.setTimestamp(container.getObjectTS());
    }

    private void fillEauAccount(EauAccount bo, EauaccountallContainer container) {
        bo.setEmployee(EauAccountPersistencyManager.getIEmployeePM().getEmployee(container.oidemployee));
        bo.setEffectiveFrom(container.effectivefrom);
        bo.setValidFrom(container.validfrom);
        bo.setValidUntil(container.validuntil);
        bo.setCreatedOn(container.createdon);
        bo.setReasonOfDelivery(container.reasonofdelivery);
        bo.setTransmitted(container.transmitted);
        bo.setCanceled(container.canceled);
        bo.setAdviceState(EauAdviceStateEnum.toAdviceStateEnum((int)container.advicestate));
        bo.setCurrentFileNumber(container.currentfilenumber);
        bo.setAktenzeichenVU(container.aktenzeichenvu);
        bo.setAktenzeichenSV(container.aktenzeichensv);
        bo.setDEUVSender(DEUVSender.getDEUVSender((String)container.oiddeuvrecipient));
        bo.setDEUVRecipient(DEUVRecipient.getDEUVRecipient((String)container.oiddeuvrecipient));
        bo.setErrorMessage(container.errormessage);
        bo.setReasonOfInterrupt(ReasonOfInterruptEnum.toEnum((int)container.reasonofinterrupt));
        bo.setSuccession(container.succession);
        bo.setDateOfRefreshStatusPossible(container.additionaldate1);
        bo.setObjectid(container.getObjectid());
        bo.setVersion(container.getVersion());
        bo.setLastuser(container.getLastUserid());
        bo.setTimestamp(container.getObjectTS());
    }

    private void fillContainer(EauaccountContainer container, EauAccount bo) {
        container.oidemployee = PersistentObjectUtils.getObjectidForContainer((IPersistentObject)bo.getEmployee());
        container.effectivefrom = bo.getEffectiveFrom();
        container.validfrom = bo.getValidFrom();
        container.validuntil = bo.getValidUntil();
        container.createdon = bo.getCreatedOn();
        container.reasonofdelivery = bo.getReasonOfDelivery();
        container.transmitted = bo.getTransmitted();
        container.canceled = bo.getCanceled();
        container.advicestate = EauAdviceStateEnum.toInt((EauAdviceStateEnum)bo.getAdviceState());
        container.currentfilenumber = bo.getCurrentFileNumber();
        container.aktenzeichenvu = bo.getAktenzeichenVU();
        container.aktenzeichensv = bo.getAktenzeichenSV();
        container.oiddeuvsender = PersistentObjectUtils.getObjectidForContainer((IPersistentObject)bo.getDEUVSender());
        container.oiddeuvrecipient = PersistentObjectUtils.getObjectidForContainer((IPersistentObject)bo.getDEUVRecipient());
        container.errormessage = EauAccountPersistencyManager.toMaxLength(bo.getErrorMessage(), 254);
        container.reasonofinterrupt = ReasonOfInterruptEnum.toInt((ReasonOfInterruptEnum)bo.getReasonOfInterrupt());
        container.succession = bo.isSuccession();
        container.additionaldate1 = bo.getDateOfRefreshStatusPossible();
        container.setObjectid(bo.getObjectid());
        container.setObjectTS(bo.getTimestamp());
        container.setLastUserid(bo.getLastuser());
        container.setVersion(bo.getVersion());
        container.additionalenum1 = 0;
        container.additionalenum2 = 0;
        container.additionalint1 = 0;
        container.additionalint2 = 0;
        container.additionalstring1 = "";
        container.additionalstring2 = "";
        container.additionaldate2 = null;
    }

    private static String toMaxLength(String string, int maxLength) {
        return string == null || string.length() <= maxLength ? string : string.substring(0, maxLength);
    }

    private static IEmployeePersistencyManager getIEmployeePM() {
        return (IEmployeePersistencyManager)UtilitiesManager.getBean((String)"employeePersistencyManager", IEmployeePersistencyManager.class);
    }
}

