/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.eau.eauaccount;

import com.varial.base.UtilitiesManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.criterion.Conjunction;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Order;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.eau.advice.EauAdvice;
import com.varial.personnel.domain.eau.eauaccount.EauAdviceStateEnum;
import com.varial.personnel.domain.eau.eauaccount.IEauAccountPersistencyManager;
import com.varial.personnel.domain.eau.eauaccount.ReasonOfInterruptEnum;
import com.varial.personnel.domain.eau.eaudxag.EauDxag;
import com.varial.personnel.domain.eau.eaudxkk.EauDxkk;
import com.varial.personnel.domain.employee.Employee;
import com.varial.personnel.domain.employee.IEmployeePersistencyManager;
import com.varial.personnel.domain.employee.IEmployeeReferenced;
import com.varial.personnel.domain.employee.absenttime.EEAbsentTimeTP;
import com.varial.personnel.domain.employee.absenttime.EEAbsentTimeTPPersistencyManager;
import com.varial.personnel.domain.employee.master.Master;
import com.varial.personnel.domain.global.deuv.recipient.DEUVRecipient;
import com.varial.personnel.domain.global.deuv.sender.DEUVSender;
import com.varial.personnel.domain.reports.ReportFirstFilterStruct;
import com.varial.personnel.framework.basictypes.PRestrictions;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BooleanMapper;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.StringMapper;
import com.varial.serverbase.persistency.PersistentObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class EauAccount
extends PersistentObject
implements IEmployeeReferenced {
    public static final String N = "N";
    public static final String J = "J";
    public static final String X = "X";
    private static final int PRIORITY = 1;
    private EauDxag mEauDxag;
    private EauDxkk[] mEauDxkk;
    private Employee mEmployee;
    private Date mEffectiveFrom;
    private Date mValidFrom;
    private Date mValidUntil;
    private String mCreatedOn;
    private int mReasonOfDelivery;
    private boolean mTransmitted;
    private String mCanceled;
    private EauAdviceStateEnum mAdviceState;
    private int mCurrentFileNumber;
    private String mAktenzeichenVU;
    private String mAktenzeichenSV;
    private ReasonOfInterruptEnum mReasonOfInterrupt;
    private DEUVSender mDEUVSender;
    private DEUVRecipient mDEUVRecipient;
    private String mErrorMessage;
    private boolean mSuccession = false;
    private boolean mIsCancelFromHF = false;
    private boolean mAbsentTimeChanged = false;
    private String mAnswerType = "";
    private Date mDateOfRefreshStatusPossible;
    private final List<EauDxkk> mEauDxkksForProtocol = new ArrayList<EauDxkk>();

    public EauAccount(int priority) {
        super(priority);
    }

    public static EauAccount getEauAccount(String objectID) {
        return new EauAccount(objectID);
    }

    public EauAccount(Employee employee) {
        super(1);
        this.mEmployee = employee;
    }

    public EauAccount(Employee employee, boolean readOnly) {
        super(1, readOnly);
        this.mEmployee = employee;
    }

    public EauAccount(String objectID) {
        super(1, objectID);
    }

    public EauAccount(boolean readOnly) {
        super(1, readOnly);
    }

    protected void load() {
        EauAccount.getIEauAccountPM().load(this);
    }

    protected void saveImpl() throws BusinessDomainException {
        EauAccount.getIEauAccountPM().save(this);
    }

    protected void deleteImpl() {
        EauAccount.getIEauAccountPM().delete(this);
    }

    protected void destroyImpl() throws BusinessDomainException {
        this.requireLoaded();
        if (this.mTransmitted) {
            throw new IllegalStateException("never destroy transmitted accounts!");
        }
        for (EauDxkk each : this.getEauDxkk()) {
            each.makeSaveable();
            each.destroy();
        }
    }

    public void makeReadOnly() {
        super.makeReadOnly();
        if (this.mEauDxag != null) {
            this.mEauDxag.makeReadOnly();
        }
    }

    public void makeSaveable() {
        super.makeSaveable();
        this.requireLoaded();
        if (this.mTransmitted) {
            return;
        }
        if (this.mEauDxag != null) {
            this.mEauDxag.makeSaveable();
        }
    }

    public String getClassName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getDomainKey() {
        return this.getObjectid();
    }

    private static IEauAccountPersistencyManager getIEauAccountPM() {
        return (IEauAccountPersistencyManager)UtilitiesManager.getBean((String)"eauAccountPersistencyManager", IEauAccountPersistencyManager.class);
    }

    private static IEmployeePersistencyManager getEmployeePM() {
        return (IEmployeePersistencyManager)UtilitiesManager.getBean((String)"employeePersistencyManager", IEmployeePersistencyManager.class);
    }

    public Employee getEmployee() {
        this.requireLoaded();
        return this.mEmployee;
    }

    public void setEmployee(Employee employee) {
        this.mEmployee = employee;
    }

    public Date getEffectiveFrom() {
        this.requireLoaded();
        return this.mEffectiveFrom;
    }

    public void setEffectiveFrom(Date effectiveFrom) {
        this.mEffectiveFrom = effectiveFrom;
    }

    public Date getValidFrom() {
        this.requireLoaded();
        return this.mValidFrom;
    }

    public void setValidFrom(Date validFrom) {
        this.mValidFrom = validFrom;
    }

    public Date getValidUntil() {
        this.requireLoaded();
        return this.mValidUntil;
    }

    public void setValidUntil(Date validUntil) {
        this.mValidUntil = validUntil;
    }

    public String getCreatedOn() {
        this.requireLoaded();
        return this.mCreatedOn;
    }

    public void setCreatedOn(String createdOn) {
        this.mCreatedOn = createdOn;
    }

    public int getReasonOfDelivery() {
        this.requireLoaded();
        return this.mReasonOfDelivery;
    }

    public void setReasonOfDelivery(int reasonOfDelivery) {
        this.mReasonOfDelivery = reasonOfDelivery;
    }

    public boolean getTransmitted() {
        this.requireLoaded();
        return this.mTransmitted;
    }

    public void setTransmitted(boolean transmitted) {
        this.mTransmitted = transmitted;
    }

    public String getCanceled() {
        this.requireLoaded();
        return this.mCanceled;
    }

    public void setCanceled(String canceled) {
        this.mCanceled = canceled;
    }

    public EauAdviceStateEnum getAdviceState() {
        this.requireLoaded();
        return this.mAdviceState;
    }

    public void setAdviceState(EauAdviceStateEnum adviceState) {
        this.mAdviceState = adviceState;
    }

    public int getCurrentFileNumber() {
        return this.mCurrentFileNumber;
    }

    public void setCurrentFileNumber(int currentFileNumber) {
        this.mCurrentFileNumber = currentFileNumber;
    }

    public String getErrorMessage() {
        this.requireLoaded();
        return this.mErrorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.mErrorMessage = errorMessage;
    }

    public String getAktenzeichenVU() {
        this.requireLoaded();
        return this.mAktenzeichenVU;
    }

    public void setAktenzeichenVU(String aktenzeichenVU) {
        this.mAktenzeichenVU = aktenzeichenVU;
    }

    public String getAktenzeichenSV() {
        this.requireLoaded();
        return this.mAktenzeichenSV;
    }

    public void setAktenzeichenSV(String aktenzeichenSV) {
        this.mAktenzeichenSV = aktenzeichenSV;
    }

    public ReasonOfInterruptEnum getReasonOfInterrupt() {
        this.requireLoaded();
        return this.mReasonOfInterrupt;
    }

    public void setReasonOfInterrupt(ReasonOfInterruptEnum reasonOfInterrupt) {
        this.mReasonOfInterrupt = reasonOfInterrupt;
    }

    public DEUVSender getDEUVSender() {
        return this.mDEUVSender;
    }

    public void setDEUVSender(DEUVSender dEUVSender) {
        this.requireLoaded();
        this.mDEUVSender = dEUVSender;
    }

    public DEUVRecipient getDEUVRecipient() {
        this.requireLoaded();
        return this.mDEUVRecipient;
    }

    public void setDEUVRecipient(DEUVRecipient deuvRecipient) {
        this.mDEUVRecipient = deuvRecipient;
    }

    public boolean isSuccession() {
        this.requireLoaded();
        return this.mSuccession;
    }

    public void setSuccession(boolean succession) {
        this.mSuccession = succession;
    }

    public boolean isAbsentTimeChanged() {
        this.requireLoaded();
        return this.mAbsentTimeChanged;
    }

    public void setAbsentTimeChanged(boolean absentTimeChanged) {
        this.mAbsentTimeChanged = absentTimeChanged;
    }

    public boolean isCancelFromHF() {
        this.requireLoaded();
        return this.mIsCancelFromHF;
    }

    public void setCancelFromHF(boolean isCancelFromHF) {
        this.mIsCancelFromHF = isCancelFromHF;
    }

    public Date getDateOfRefreshStatusPossible() {
        this.requireLoaded();
        return this.mDateOfRefreshStatusPossible;
    }

    public void setDateOfRefreshStatusPossible(Date dateOfRefreshStatusPossible) {
        this.mDateOfRefreshStatusPossible = dateOfRefreshStatusPossible;
    }

    public EauDxag createEauDxag() {
        if (this.mEauDxag != null) {
            throw new IllegalStateException("EauDxag already exists");
        }
        this.mEauDxag = new EauDxag();
        this.mEauDxag.setEauAccount(this);
        return this.mEauDxag;
    }

    public void setEauDxag(EauDxag dxag) {
        this.mEauDxag = dxag;
    }

    public EauDxag getEauDxag() {
        if (this.mEauDxag == null) {
            EauDxag[] rs = EauDxag.getEauDxags((Criterion)Restrictions.eq((String)"oidEauAccount", (String)this.getObjectid()), null);
            if (rs.length != 1) {
                throw new IllegalStateException("Advice inconsistent, " + rs.length + " DXAG (not 1).");
            }
            this.mEauDxag = rs[0];
        }
        return this.mEauDxag;
    }

    public EauDxkk[] getEauDxkk() {
        if (this.mEauDxkk == null) {
            Order[] sort = new Order[]{Order.desc((String)"ed")};
            this.mEauDxkk = EauDxkk.getEauDxkks((Criterion)Restrictions.eq((String)"oidEauAccount", (String)this.getObjectid()), (Order[])sort);
        }
        return this.mEauDxkk;
    }

    public void addEauDxkkForProtocol(EauDxkk dxkk) {
        this.mEauDxkksForProtocol.add(dxkk);
    }

    public EauDxkk[] getEauDxkkForProtocol() {
        return this.mEauDxkksForProtocol.toArray(new EauDxkk[this.mEauDxkksForProtocol.size()]);
    }

    public EauDxkk[] getEauDxkkAfterEd(String ed) {
        Order[] sort = new Order[]{Order.desc((String)"ed")};
        Conjunction filter = Restrictions.conjunction();
        filter.add(Restrictions.eq((String)"oidEauAccount", (String)this.getObjectid()));
        filter.add(Restrictions.gt((String)"ed", (String)ed));
        return EauDxkk.getEauDxkks((Criterion)filter, (Order[])sort);
    }

    public boolean hasDxkk() {
        return this.getEauDxkk().length > 0;
    }

    public EauAccount createNew() {
        EauAccount account = new EauAccount(this.getEmployee());
        account.mEauDxag = this.getEauDxag().createNew(account);
        account.mEffectiveFrom = this.getEffectiveFrom();
        account.mValidFrom = this.getValidFrom();
        account.mValidUntil = this.getValidUntil();
        account.mCreatedOn = this.getCreatedOn();
        account.mReasonOfDelivery = this.getReasonOfDelivery();
        account.mTransmitted = false;
        account.mCanceled = this.getCanceled();
        account.mAdviceState = this.getAdviceState();
        account.mCurrentFileNumber = 0;
        account.mAktenzeichenVU = this.getAktenzeichenVU();
        account.mAktenzeichenSV = this.getAktenzeichenSV();
        account.mReasonOfInterrupt = this.getReasonOfInterrupt();
        account.mDEUVSender = this.getDEUVSender();
        account.mDEUVRecipient = this.getDEUVRecipient();
        return account;
    }

    public void addError(String errorMessage, Date dateOfRefreshStatus) {
        if (StringMapper.isNullString((String)this.getErrorMessage())) {
            this.mErrorMessage = errorMessage;
            this.setDateOfRefreshStatusPossible(dateOfRefreshStatus);
        } else {
            this.mErrorMessage = this.mErrorMessage.trim() + " " + errorMessage;
            this.setDateOfRefreshStatusPossible(null);
        }
    }

    public void addError(String errorMessage) {
        this.addError(errorMessage, null);
    }

    public void toStringValues(StringBuilder b) {
        b.append(this.mCanceled).append(',');
        b.append(this.mTransmitted ? J : N).append(',');
        b.append(this.mCreatedOn).append(',');
        b.append(DateMapper.toString((Date)this.mEffectiveFrom)).append(',');
        b.append(DateMapper.toString((Date)this.mValidFrom)).append(',');
        b.append(DateMapper.toString((Date)this.mValidUntil)).append(',');
        if (this.mEmployee != null) {
            b.append(this.mEmployee.getDomainID()).append(',');
        }
    }

    public static EauAccount[] getEauAccount(String oidPCompany, String oidPlant, String oidEmployee, Date fromDate, Date untilDate, int reasonOfDelivery, int adviceState) throws BusinessDomainException {
        Order[] sort = new Order[]{Order.asc((String)"aktenzeichenvu"), Order.asc((String)"createdon")};
        Conjunction filter = EauAccount.createFilterEauAccount(fromDate, untilDate, reasonOfDelivery, adviceState);
        ArrayList<EauAccount> accounts = new ArrayList<EauAccount>();
        for (Criterion empFilter : EauAccount.getEmployeeFilter(oidPCompany, oidPlant, oidEmployee)) {
            EauAccount[] rows = EauAccount.getIEauAccountPM().query(sort, Restrictions.and((Criterion)filter, (Criterion)empFilter), true);
            accounts.addAll(Arrays.asList(rows));
        }
        return accounts.toArray(new EauAccount[accounts.size()]);
    }

    public EauAccount[] getExisitingEauAccountsTransmitted() throws BusinessDomainException {
        Order[] sort = new Order[]{Order.desc((String)"createdon")};
        Conjunction filter = Restrictions.conjunction();
        String[] states = new String[]{"" + EauAdviceStateEnum.toInt((EauAdviceStateEnum)EauAdviceStateEnum.UEBERMITTELT), "" + EauAdviceStateEnum.toInt((EauAdviceStateEnum)EauAdviceStateEnum.VERARBEITET), "" + EauAdviceStateEnum.toInt((EauAdviceStateEnum)EauAdviceStateEnum.ABGELEHNT)};
        filter.add(Restrictions.eq((String)"oidemployee", (String)this.getEmployee().getObjectid()));
        filter.add(Restrictions.eq((String)"validfrom", (String)DateMapper.toString((Date)this.getValidFrom())));
        filter.add(Restrictions.eq((String)"canceled", (String)this.getCanceled()));
        filter.add(Restrictions.in((String)"advicestate", (String[])states));
        EauAccount[] rows = EauAccount.getIEauAccountPM().query(sort, (Criterion)filter, true);
        return rows;
    }

    public EauAccount[] getExisitingEauAccountsNotClosed() throws BusinessDomainException {
        Order[] sort = new Order[]{Order.desc((String)"createdon")};
        Conjunction filter = Restrictions.conjunction();
        String[] states = new String[]{"" + EauAdviceStateEnum.toInt((EauAdviceStateEnum)EauAdviceStateEnum.AUFGEBAUT), "" + EauAdviceStateEnum.toInt((EauAdviceStateEnum)EauAdviceStateEnum.BEREIT), "" + EauAdviceStateEnum.toInt((EauAdviceStateEnum)EauAdviceStateEnum.UEBERMITTELT)};
        filter.add(Restrictions.eq((String)"oidemployee", (String)this.getEmployee().getObjectid()));
        filter.add(Restrictions.eq((String)"validfrom", (String)DateMapper.toString((Date)this.getValidFrom())));
        filter.add(Restrictions.eq((String)"succession", (String)BooleanMapper.toString((boolean)this.isSuccession())));
        filter.add(Restrictions.eq((String)"canceled", (String)this.getCanceled()));
        filter.add(Restrictions.in((String)"advicestate", (String[])states));
        if (this.getObjectid() != null) {
            filter.add(Restrictions.ne((String)"objectid", (String)this.getObjectid()));
        }
        EauAccount[] rows = EauAccount.getIEauAccountPM().query(sort, (Criterion)filter, true);
        return rows;
    }

    public EauAccount[] getExisitingEauAccountsForSuccession() throws BusinessDomainException {
        Order[] sort = new Order[]{Order.desc((String)"createdon")};
        Conjunction filter = Restrictions.conjunction();
        String[] states = new String[]{"" + EauAdviceStateEnum.toInt((EauAdviceStateEnum)EauAdviceStateEnum.UEBERMITTELT), "" + EauAdviceStateEnum.toInt((EauAdviceStateEnum)EauAdviceStateEnum.VERARBEITET), "" + EauAdviceStateEnum.toInt((EauAdviceStateEnum)EauAdviceStateEnum.ABGELEHNT)};
        filter.add(Restrictions.eq((String)"oidemployee", (String)this.getEmployee().getObjectid()));
        filter.add(Restrictions.eq((String)"validuntil", (String)DateMapper.toString((Date)DateHelper.add((Date)this.getValidFrom(), (int)-1))));
        filter.add(Restrictions.in((String)"advicestate", (String[])states));
        EauAccount[] rows = EauAccount.getIEauAccountPM().query(sort, (Criterion)filter, true);
        return rows;
    }

    public EauAccount[] getOrigin() throws BusinessDomainException {
        Order[] sort = new Order[]{Order.desc((String)"createdon")};
        Conjunction filter = Restrictions.conjunction();
        filter.add(Restrictions.eq((String)"oidemployee", (String)this.getEmployee().getObjectid()));
        filter.add(Restrictions.eq((String)"validfrom", (String)DateMapper.toString((Date)this.getValidFrom())));
        filter.add(Restrictions.eq((String)"succession", (String)BooleanMapper.toString((boolean)this.isSuccession())));
        filter.add(Restrictions.eq((String)"canceled", (String)X));
        if (this.getObjectid() != null) {
            filter.add(Restrictions.ne((String)"objectid", (String)this.getObjectid()));
        }
        EauAccount[] rows = EauAccount.getIEauAccountPM().query(sort, (Criterion)filter, true);
        return rows;
    }

    public static List<Criterion> getEmployeeFilter(String oidPCompany, String oidPlant, String oidEmployee) {
        String[] oidEmployees = null;
        if (StringMapper.isNullString((String)oidEmployee)) {
            if (!StringMapper.isNullString((String)oidPlant)) {
                ReportFirstFilterStruct firstFilter = new ReportFirstFilterStruct();
                firstFilter.oidPlant = oidPlant;
                firstFilter.oidPCompany = oidPCompany;
                oidEmployees = EauAccount.getEmployeePM().getOidEmployees(oidPCompany, firstFilter);
                return PRestrictions.in((String)"oidemployee", (String[])oidEmployees);
            }
            oidEmployees = EauAccount.getEmployeePM().getOidEmployees(oidPCompany);
            return PRestrictions.in((String)"oidemployee", (String[])oidEmployees);
        }
        ArrayList<Criterion> filter = new ArrayList<Criterion>();
        filter.add(Restrictions.eq((String)"oidEmployee", (String)oidEmployee));
        return filter;
    }

    public static Conjunction createFilterEauAccount(Date fromDate, Date untilDate, int reasonOfDelivery, int adviceState) {
        Conjunction filter = Restrictions.conjunction();
        if (fromDate != null && untilDate != null) {
            filter.add(Restrictions.le((String)"createdon", (String)EauAdvice.formatTimestampForQuery(DateHelper.tomorrow((Date)untilDate))));
            filter.add(Restrictions.ge((String)"createdon", (String)EauAdvice.formatTimestampForQuery(fromDate)));
        } else if (fromDate != null && untilDate == null) {
            filter.add(Restrictions.ge((String)"createdon", (String)EauAdvice.formatTimestampForQuery(fromDate)));
        } else if (fromDate == null && untilDate != null) {
            filter.add(Restrictions.le((String)"createdon", (String)EauAdvice.formatTimestampForQuery(DateHelper.tomorrow((Date)untilDate))));
        }
        if (reasonOfDelivery > 0) {
            filter.add(Restrictions.eq((String)"reasonofdelivery", (String)String.valueOf(reasonOfDelivery)));
        }
        if (adviceState >= 0) {
            filter.add(Restrictions.eq((String)"advicestate", (String)("" + adviceState)));
        } else {
            filter.add(Restrictions.ne((String)"advicestate", (String)("" + EauAdviceStateEnum.toInt((EauAdviceStateEnum)EauAdviceStateEnum.VORSCHLAG_STORNO_GELOESCHT))));
        }
        return filter;
    }

    public EauAccount makeCancelation() throws BusinessDomainException {
        this.mCanceled = X;
        this.makeSaveable();
        EauAccount storno = this.createNew();
        storno.mCanceled = J;
        EauDxag dxag = storno.getEauDxag();
        dxag.setKennzstorno(J);
        storno.setErrorMessage("");
        return storno;
    }

    public boolean hasErrors() {
        return this.mErrorMessage != null && !this.mErrorMessage.isEmpty();
    }

    public boolean isCancelled() {
        this.requireLoaded();
        return !StringMapper.equal((String)this.mCanceled, (String)N);
    }

    public EEAbsentTimeTP getEEAbsentTimeTP() {
        Employee emp = this.getEmployee();
        EEAbsentTimeTP[] tps = EEAbsentTimeTPPersistencyManager.queryAll(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)emp.getObjectid()), Restrictions.eq((String)"deleted", (String)"F"), Restrictions.eq((String)"effectiveuntil", (String)DateMapper.toString((Date)VDate.getDateMax())), Restrictions.eq((String)"validfrom", (String)DateMapper.toString((Date)this.getValidFrom()))}), (boolean)true);
        if (tps.length < 1) {
            return null;
        }
        return tps[0];
    }

    public EauDxkk[] getEauDxkkWithoutReason() {
        EauDxkk[] dxkks;
        ArrayList<EauDxkk> result = new ArrayList<EauDxkk>();
        for (EauDxkk dxkk : dxkks = this.getEauDxkk()) {
            if ("4".contentEquals(dxkk.getKzaktuelleau()) || "1".contentEquals(dxkk.getKzaktuelleau())) continue;
            result.add(dxkk);
        }
        return result.toArray(new EauDxkk[result.size()]);
    }

    public EauDxkk[] getEauDxkkWithReason(String reason) {
        EauDxkk[] dxkks;
        ArrayList<EauDxkk> result = new ArrayList<EauDxkk>();
        for (EauDxkk dxkk : dxkks = this.getEauDxkk()) {
            if (!reason.contentEquals(dxkk.getKzaktuelleau())) continue;
            result.add(dxkk);
        }
        return result.toArray(new EauDxkk[result.size()]);
    }

    public boolean hasDxkkWithAUAfterReason4(String ed) {
        EauDxkk[] dxkks;
        for (EauDxkk dxkk : dxkks = this.getEauDxkkAfterEd(ed)) {
            if ("4".contentEquals(dxkk.getKzaktuelleau()) || "1".contentEquals(dxkk.getKzaktuelleau())) continue;
            return true;
        }
        return false;
    }

    public String getName() throws BusinessDomainException {
        if (this.getEmployee() == null) {
            return "";
        }
        Master master = this.getEmployee().getMaster(VDate.getDateMax(), VDate.getDateMax());
        return master.getSurname() + ", " + master.getFirstname();
    }

    public String getAuseit() {
        if (this.getEmployee() == null) {
            return "";
        }
        return DateMapper.toDDMMYYYYPointSeparationString((Date)this.getEauDxag().getAuabag());
    }

    public void setAnswerType(String type) {
        this.mAnswerType = type;
    }

    public String getAnswerType() {
        return this.mAnswerType;
    }

    public static EauAccount[] getEauAccountsByFileNr(int dateiNr, DEUVRecipient responder) {
        Conjunction filter = Restrictions.conjunction();
        filter.add(Restrictions.eq((String)"currentfilenumber", (String)("" + dateiNr)));
        filter.add(Restrictions.eq((String)"oiddeuvrecipient", (String)responder.getObjectid()));
        return EauAccount.getIEauAccountPM().query(null, (Criterion)filter, true);
    }

    public EauAccount getLastSuccessor() {
        EauAccount successor = this.getSuccessor();
        return successor == null ? this : successor.getLastSuccessor();
    }

    public EauAccount getSuccessor() {
        if (this.getValidUntil() == null) {
            return null;
        }
        EauAccount[] eauAccounts = EauAccount.getIEauAccountPM().query(new Order[]{Order.desc((String)"createdon")}, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)this.getEmployee().getObjectid()), Restrictions.eq((String)"validfrom", (String)DateMapper.toString((Date)DateHelper.tomorrow((Date)this.getValidUntil()))), Restrictions.eq((String)"advicestate", (String)("" + EauAdviceStateEnum.toInt((EauAdviceStateEnum)EauAdviceStateEnum.VERARBEITET))), Restrictions.eq((String)"succession", (String)BooleanMapper.toString((Boolean)Boolean.TRUE))}), true);
        return eauAccounts.length == 0 ? null : eauAccounts[0];
    }
}

