/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.eau.advice;

import com.varial.base.UtilitiesManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.criterion.Conjunction;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.companyplant.Foundations;
import com.varial.personnel.domain.deuv.DeuvBasics;
import com.varial.personnel.domain.deuvmessaging.DeuvHelper;
import com.varial.personnel.domain.deuvmessaging.DeuvRecipientMap;
import com.varial.personnel.domain.deuvmessaging.basiccomponents.Dbap;
import com.varial.personnel.domain.eau.eauaccount.EauAccount;
import com.varial.personnel.domain.eau.eauaccount.EauAccountComparator;
import com.varial.personnel.domain.eau.eauaccount.EauAdviceStateEnum;
import com.varial.personnel.domain.eau.eauaccount.IEauAccountPersistencyManager;
import com.varial.personnel.domain.eau.eauaccount.ReasonOfInterruptEnum;
import com.varial.personnel.domain.eau.eaudbap.EauDbap;
import com.varial.personnel.domain.eau.eaudxag.EauDxag;
import com.varial.personnel.domain.eau.eaudxkk.EauDxkk;
import com.varial.personnel.domain.eau.mapper.EauExceptionMapper;
import com.varial.personnel.domain.employee.Employee;
import com.varial.personnel.domain.employee.IEECompanyPlant;
import com.varial.personnel.domain.employee.IEmployeeReferenced;
import com.varial.personnel.domain.employee.SexEnum;
import com.varial.personnel.domain.employee.absenttime.EEAbsentTimeTP;
import com.varial.personnel.domain.employee.employment.Employment;
import com.varial.personnel.domain.employee.insurance.Insurance;
import com.varial.personnel.domain.employee.mapper.SexEnumMapper;
import com.varial.personnel.domain.employee.master.Master;
import com.varial.personnel.domain.global.deuv.recipient.DEUVRecipient;
import com.varial.personnel.domain.global.deuv.sender.DEUVSender;
import com.varial.personnel.domain.global.deuv.sender.DEUVSenderTP;
import com.varial.personnel.domain.global.healthfund.HealthFund;
import com.varial.personnel.domain.global.healthfund.HealthFundTP;
import com.varial.personnel.domain.pcompany.PCompany;
import com.varial.personnel.domain.plant.Plant;
import com.varial.personnel.framework.SpecialAccess;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.StringMapper;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

public class EauAdvice {
    private static final Date DATE_START_EAU = DateMapper.toDate((String)"2021-10-01");
    private final PCompany mPCompany;
    private boolean mAffectedBySpecialAccess;
    private final Date mCreatedOnDate;
    private final String mCreatedOnString;
    private final DeuvRecipientMap mRecipientMap;
    private final DEUVSenderTP mDEUVSenderTP;
    private IEECompanyPlant mEECompanyPlant;

    public EauAdvice(PCompany pCompany) throws BusinessDomainException {
        this.mPCompany = pCompany;
        this.mCreatedOnDate = VDate.getCurrentLocalizedDateAndTime();
        this.mCreatedOnString = DeuvBasics.formatDEUVTimestamp((Date)this.mCreatedOnDate);
        this.mRecipientMap = new DeuvRecipientMap(DeuvHelper.getDeuvSender((PCompany)this.mPCompany));
        this.mDEUVSenderTP = DeuvHelper.getDeuvSender((PCompany)pCompany).getDEUVSenderTP(VDate.getDateMax(), this.mCreatedOnDate);
    }

    public static final String formatTimestampForQuery(Date d) {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
        return format.format(d);
    }

    public void checkAttributes(EauAccount account) throws BusinessDomainException {
        EauAccount[] accounts = account.getExisitingEauAccountsNotClosed();
        if (accounts != null && accounts.length > 0) {
            int i = 0;
            for (EauAccount each : accounts) {
                if (!EauAdviceStateEnum.AUFGEBAUT.equals((Object)each.getAdviceState()) && !EauAdviceStateEnum.BEREIT.equals((Object)each.getAdviceState())) continue;
                each.makeSaveable();
                each.destroy();
                ++i;
            }
            if (i < accounts.length) {
                account.addError("Zum diesem Datum AU-ab existiert bereits eine Anfrage.");
                return;
            }
        }
        if (DateHelper.after((Date)account.getValidFrom(), (Date)this.getCreatedOnDateTruncated())) {
            account.addError("Der Abruf f\u00fcr zuk\u00fcnftige AU-Zeitr\u00e4ume ist nicht zul\u00e4ssig.");
        }
        if (StringMapper.isNullString((String)account.getEauDxag().getBbnrempfaenger())) {
            account.addError("Der Abruf f\u00fcr Mitarbeiter ohne gesetzliche Krankenversicherung ist nicht zul\u00e4ssig.");
        }
        if (DateHelper.before((Date)account.getValidFrom(), (Date)DATE_START_EAU)) {
            account.addError("Der Abruf f\u00fcr AU-Zeitr\u00e4ume vor dem 01.10.2021 ist nicht zul\u00e4ssig.");
        }
        if (!account.getEmployee().isInEmployment(VDate.getDateMax(), account.getValidFrom())) {
            account.addError("Der Mitarbeiter ist zum Zeitpunkt AU-Beginn nicht aktiv besch\u00e4ftigt.");
        }
        if (ReasonOfInterruptEnum.LEER.equals((Object)account.getReasonOfInterrupt())) {
            account.addError("Die Angabe AU-Grund fehlt.");
        }
        if (account.getValidFrom() == null) {
            account.addError("Die Angabe AU-ab-Datum fehlt.");
        }
        if ((accounts = account.getExisitingEauAccountsTransmitted()).length > 0) {
            EauDxkk[] dxkks4 = accounts[0].getEauDxkkWithReason("4");
            EauDxkk[] dxkks1 = accounts[0].getEauDxkkWithReason("1");
            if (dxkks4.length > 0) {
                Date ed;
                String datumErstellung = dxkks4[0].getDatumerstellung();
                if (!accounts[0].hasDxkkWithAUAfterReason4(datumErstellung) && DateHelper.afterOrEqual((Date)DateHelper.add((Date)(ed = DateHelper.correctDate((Date)DeuvBasics.deuvDateStringToDate((String)datumErstellung))), (int)14), (Date)this.getCreatedOnDateTruncated())) {
                    account.addError("Abfragen die mit Grund 4 abgewiesen wurden k\u00f6nnen erst nach 14 Tagen erneut abgefragt werden.");
                }
            } else if (dxkks1.length > 0) {
                if (account.getEauDxag().getBbnrempfaenger().equals(dxkks1[0].getBbnrempfaenger())) {
                    account.addError("Abfragen die mit Grund 1 abgewiesen wurden k\u00f6nnen nur mit abweichendem Empf\u00e4nger erneut abgefragt werden.");
                }
            } else {
                Date ed = DateHelper.correctDate((Date)DeuvBasics.deuvDateStringToDate((String)accounts[0].getEauDxag().getDatumerstellung()));
                if (DateHelper.afterOrEqual((Date)DateHelper.add((Date)ed, (int)5), (Date)this.getCreatedOnDateTruncated())) {
                    account.addError("Es liegen noch keine R\u00fcckmeldungen vor. Erneute Abfrage erst 5 Kalendertage nach erstmaligen Erstellen m\u00f6glich.");
                }
            }
        }
        if (!account.isSuccession()) {
            int days = this.getAuCertificateFrom(account);
            Date date = DateHelper.add((Date)account.getValidFrom(), (int)days);
            if (DateHelper.after((Date)date, (Date)this.getCreatedOnDateTruncated())) {
                account.addError("Die Erstabfrage ist erst am " + days + ". Kalendertag nach Beginn der Fehlzeit zul\u00e4ssig.", date);
            }
        }
        if (account.isSuccession() && DateHelper.afterOrEqual((Date)account.getValidFrom(), (Date)this.getCreatedOnDateTruncated())) {
            account.addError("Die Zweitabfrage ist erst am zweiten Kalendertag nach Ende der Vor-AU zul\u00e4ssig.");
        }
    }

    private int getAuCertificateFrom(EauAccount account) throws BusinessDomainException {
        int day = 1;
        Employee emp = account.getEmployee();
        Employment employment = emp.getEmployment(VDate.getDateMax(), account.getValidFrom());
        Plant plant = emp.getAppurtenantPlant(VDate.getDateMax(), account.getValidFrom());
        PCompany comp = emp.getPCompany();
        int fromEmployee = 0;
        int fromPlant = 0;
        int fromCompany = 0;
        if (employment != null) {
            fromEmployee = employment.getAuCertificateFrom();
        }
        if (plant != null) {
            fromPlant = plant.getPlantFoundations(VDate.getDateMax(), account.getValidFrom()).getFoundations().getAuCertificateFrom();
        }
        if (comp != null) {
            fromCompany = comp.getCompanyFoundations(VDate.getDateMax(), account.getValidFrom()).getFoundations().getAuCertificateFrom();
        }
        if (fromEmployee > 0) {
            day = fromEmployee;
        } else if (fromPlant > 0) {
            day = fromPlant;
        } else if (fromCompany > 0) {
            day = fromCompany;
        }
        return day;
    }

    public EauAccount create(EEAbsentTimeTP eeAbsentTimeTP, int reasonOfInterrupt) throws BusinessDomainException {
        Employee emp = eeAbsentTimeTP.getEmployee();
        Master master = this.getMaster(eeAbsentTimeTP.getValidFrom(), emp);
        Insurance insurance = this.getInsurance(eeAbsentTimeTP.getValidFrom(), emp);
        EauAccount account = new EauAccount(emp);
        EauDxag dxag = this.createDxag(eeAbsentTimeTP.getValidFrom(), emp);
        this.initDxag(dxag, eeAbsentTimeTP.getEmployee(), master, insurance, eeAbsentTimeTP.getValidFrom(), reasonOfInterrupt, account);
        Date effectiveFrom = new Date();
        Date effectiveFromMaster = master.getEffectiveFrom();
        if (DateHelper.before((Date)effectiveFrom, (Date)effectiveFromMaster)) {
            effectiveFrom = effectiveFromMaster;
        }
        account.setEauDxag(dxag);
        boolean succession = false;
        if (eeAbsentTimeTP.getValidUntil() != null) {
            // empty if block
        }
        this.initAccount(account, emp, reasonOfInterrupt, eeAbsentTimeTP.getValidFrom(), eeAbsentTimeTP.getValidUntil(), effectiveFrom, dxag, false);
        dxag.setEauAccount(account);
        return account;
    }

    public EauAccount create(Employee emp, Date auabag, int reasonOfInterrupt) throws BusinessDomainException {
        Master master = this.getMaster(auabag, emp);
        Insurance insurance = this.getInsurance(auabag, emp);
        EauDxag dxag = this.createDxag(auabag, emp);
        EauAccount account = new EauAccount(emp);
        this.initDxag(dxag, emp, master, insurance, auabag, reasonOfInterrupt, account);
        Date effectiveFrom = new Date();
        Date effectiveFromMaster = master.getEffectiveFrom();
        if (DateHelper.before((Date)effectiveFrom, (Date)effectiveFromMaster)) {
            effectiveFrom = effectiveFromMaster;
        }
        account.setEauDxag(dxag);
        this.initAccount(account, emp, reasonOfInterrupt, auabag, null, effectiveFrom, dxag, false);
        dxag.setEauAccount(account);
        return account;
    }

    private EauDxag createDxag(Date validFrom, Employee emp) throws BusinessDomainException {
        EauDxag dxag = new EauDxag();
        dxag.setBbnrabsender(DeuvHelper.getDeuvSenderStdCompNo((DEUVSender)this.mDEUVSenderTP.getDEUVSender()));
        dxag.setBbnrverursacher(this.getEECompanyPlant(validFrom, emp).getCompanyNumber());
        dxag.setDatumerstellung(this.getCreatedOnString());
        dxag.setProdid(DeuvBasics.getProdId());
        dxag.setModid(DeuvBasics.getModId());
        dxag.setKennzstorno("N");
        EauDbap dbap = dxag.createDbap();
        Dbap dbapData = new Dbap();
        DeuvHelper.fillDbap((Dbap)dbapData, (DEUVSenderTP)this.mDEUVSenderTP, (DeuvHelper.TypeOfCommunication)DeuvHelper.TypeOfCommunication.EAU);
        dbap.setDbapData(dbapData);
        return dxag;
    }

    private void initDxag(EauDxag dxag, Employee employee, Master master, Insurance insurance, Date auabag, int reasonOfInterrupt, EauAccount account) throws BusinessDomainException {
        dxag.setBbnrempfaenger(this.getRecipient(employee, auabag, account));
        dxag.setAzvu(this.getAzvu(employee));
        dxag.setGeschlecht(SexEnumMapper.toUpperCaseLetter((SexEnum)master.getSex()));
        dxag.setVorname(master.getFirstname());
        dxag.setFamilienname(master.getSurname());
        dxag.setVsnr(insurance.getInsuranceNo());
        dxag.setGebname(insurance.getNameAtBirth());
        dxag.setGebdatum(master.getDateOfBirth());
        dxag.setGebort(insurance.getPlaceOfBirth());
        dxag.setAuabag(auabag);
    }

    private void initAccount(EauAccount account, Employee emp, int reasonOfInterrupt, Date validFrom, Date validUntil, Date effectiveFrom, EauDxag dxag, boolean succession) throws BusinessDomainException {
        account.setEffectiveFrom(effectiveFrom);
        account.setValidFrom(validFrom);
        account.setValidUntil(validUntil);
        account.setCreatedOn(this.getCreatedOnString());
        account.setReasonOfDelivery(0);
        account.setCanceled("N");
        account.setAdviceState(EauAdviceStateEnum.AUFGEBAUT);
        account.setAktenzeichenVU(dxag.getAzvu());
        account.setAktenzeichenSV("");
        account.setDEUVRecipient(this.getDEUVRecipient(validFrom, emp, account));
        account.setDEUVSender(this.mPCompany.getCompanySettings(VDate.getDateMax(), validFrom).getDEUVSender());
        account.setReasonOfInterrupt(ReasonOfInterruptEnum.toEnum((int)reasonOfInterrupt));
        account.setSuccession(succession);
    }

    public EauAccount createSuccession(EauAccount account) throws BusinessDomainException {
        Date newAuabag = null;
        EauDxkk[] dxkks = account.getEauDxkk();
        if (dxkks == null || dxkks.length < 1) {
            throw EauExceptionMapper.makeMissingResponseForSuccessionException();
        }
        for (EauDxkk dxkk : dxkks) {
            if (dxkk.getAubisvoraussicht() != null) {
                newAuabag = DateHelper.add((Date)dxkk.getAubisvoraussicht(), (int)1);
                break;
            }
            if (dxkk.getStationbis() == null) continue;
            newAuabag = DateHelper.add((Date)dxkk.getStationbis(), (int)1);
            break;
        }
        if (newAuabag == null) {
            throw EauExceptionMapper.makeMissingResponseForSuccessionException();
        }
        if (DateHelper.after((Date)DateHelper.add(newAuabag, (int)1), (Date)this.getCreatedOnDateTruncated())) {
            throw EauExceptionMapper.makeSuccessionNotAllowedException();
        }
        EauAccount newAccount = account.createNew();
        newAccount.setSuccession(true);
        Master master = newAccount.getEmployee().getMaster(VDate.getDateMax(), newAuabag);
        Date effectiveFrom = new Date();
        Date effectiveFromMaster = master.getEffectiveFrom();
        if (DateHelper.before((Date)effectiveFrom, (Date)effectiveFromMaster)) {
            effectiveFrom = effectiveFromMaster;
        }
        EauDxag dxag = newAccount.getEauDxag();
        dxag.setAuabag(newAuabag);
        this.initAccount(newAccount, account.getEmployee(), newAccount.getReasonOfInterrupt().ordinal(), newAuabag, null, effectiveFrom, dxag, true);
        return newAccount;
    }

    public void retry(EauAccount account) throws BusinessDomainException {
        if (account.getAdviceState().equals((Object)EauAdviceStateEnum.AUFGEBAUT) || account.getAdviceState().equals((Object)EauAdviceStateEnum.BEREIT)) {
            throw EauExceptionMapper.makeRetryNotAllowedException();
        }
        account.setErrorMessage("");
    }

    public void deleteAccount(EauAccount account) throws BusinessDomainException {
        if (account.getAdviceState().equals((Object)EauAdviceStateEnum.AUFGEBAUT) || account.getAdviceState().equals((Object)EauAdviceStateEnum.BEREIT) || account.getAdviceState().equals((Object)EauAdviceStateEnum.VORSCHLAG_STORNO_GELOESCHT)) {
            account.makeSaveable();
            account.destroy();
        } else if (account.getAdviceState().equals((Object)EauAdviceStateEnum.VORSCHLAG_STORNO)) {
            EauAccount[] origin;
            account.makeSaveable();
            for (EauAccount org : origin = account.getOrigin()) {
                org.makeSaveable();
                org.setCanceled("N");
            }
            account.destroy();
        } else {
            throw EauExceptionMapper.makeNoDeleteAllowedDomainException((String)(account.getAktenzeichenVU() + " " + account.getValidFrom()));
        }
    }

    public void makeCancellation(EauAccount account) throws BusinessDomainException {
        EauDxkk[] dxkks = account.getEauDxkkWithoutReason();
        if (account.getAdviceState().equals((Object)EauAdviceStateEnum.AUFGEBAUT) || account.getAdviceState().equals((Object)EauAdviceStateEnum.BEREIT) || account.isCancelled() || account.getAdviceState().equals((Object)EauAdviceStateEnum.VERARBEITET) && dxkks != null && dxkks.length > 0) {
            throw EauExceptionMapper.makeCancellationNotAllowedDomainException((String)(account.getAktenzeichenVU() + " " + account.getValidFrom()));
        }
        Date today = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmssSSSSSS");
        for (EauDxkk dxkk : account.getEauDxkk()) {
            if (!"4".equals(dxkk.getKzaktuelleau())) continue;
            try {
                if (DateHelper.compareDate((Date)today, (Date)dateFormat.parse(dxkk.getDatumerstellung())) < 15) continue;
                throw EauExceptionMapper.makeCancellationNotAllowed15DaysLaterDomainException((String)(account.getAktenzeichenVU() + " " + account.getValidFrom()));
            }
            catch (ParseException e) {
                throw new IllegalStateException("Fehlerhaftes Datum " + dxkk.getDatumerstellung());
            }
        }
        this.initCancellation(account);
    }

    public void initCancellation(EauAccount account) throws BusinessDomainException {
        EauAccount storno = account.makeCancelation();
        storno.makeSaveable();
        storno.setCreatedOn(this.getCreatedOnString());
        storno.getEauDxag().setDatumerstellung(this.getCreatedOnString());
        storno.getEauDxag().setBbnrabsender(DeuvHelper.getDeuvSenderStdCompNo((DEUVSender)this.mDEUVSenderTP.getDEUVSender()));
        storno.getEauDxag().setBbnrempfaenger(this.getUpdatedRecipient(storno.getEauDxag().getBbnrempfaenger(), account.getValidFrom()));
        storno.getEauDxag().setDatensatzid("");
        storno.getEauDxag().setProdid(DeuvBasics.getProdId());
        storno.getEauDxag().setModid(DeuvBasics.getModId());
        storno.getEauDxag().setVsnr(storno.getEmployee().getActiveInsurance().getInsuranceNo());
        storno.getEauDxag().setDatensatzidursprung(account.getEauDxag().getDatensatzid());
        storno.setAdviceState(EauAdviceStateEnum.VORSCHLAG_STORNO);
        DEUVRecipient deuvRecipient = this.mRecipientMap.updateDeuvRecipient(account.getDEUVRecipient(), account.getEauDxag().getBbnrempfaenger());
        storno.setDEUVRecipient(deuvRecipient);
        this.checkAttributes(storno);
    }

    private String getUpdatedRecipient(String bbnr, Date validTimePoint) throws BusinessDomainException {
        return DeuvRecipientMap.updateStdCompNoHealthFund((String)bbnr, (Date)validTimePoint);
    }

    public List<EauAccount> getUntransmitteds(SpecialAccess specialAccess, int reason) throws BusinessDomainException {
        Conjunction filter = Restrictions.conjunction();
        String[] states = new String[]{"" + EauAdviceStateEnum.toInt((EauAdviceStateEnum)EauAdviceStateEnum.BEREIT), "" + EauAdviceStateEnum.toInt((EauAdviceStateEnum)EauAdviceStateEnum.VORSCHLAG_STORNO)};
        filter.add(Restrictions.in((String)"advicestate", (String[])states));
        filter.add(Restrictions.eq((String)"reasonofdelivery", (String)("" + reason)));
        ArrayList<EauAccount> untransmitteds = new ArrayList<EauAccount>();
        for (Criterion empFilter : EauAccount.getEmployeeFilter(this.mPCompany.getObjectid(), null, null)) {
            EauAccount[] rows = EauAdvice.getIEauAccountPM().query(null, Restrictions.and((Criterion)filter, (Criterion)empFilter), true);
            untransmitteds.addAll(Arrays.asList(rows));
        }
        EauAccount[] filtered = (EauAccount[])specialAccess.filter((IEmployeeReferenced[])untransmitteds.toArray(new EauAccount[untransmitteds.size()]));
        if (untransmitteds.size() != filtered.length) {
            this.setAffectedBySpecialAccess(true);
        }
        ArrayList<EauAccount> untransmittedsList = new ArrayList<EauAccount>();
        for (EauAccount account : filtered) {
            if (account.hasErrors() || account.getCanceled().equals("X")) continue;
            untransmittedsList.add(account);
        }
        Collections.sort(untransmittedsList, this.getEauAccountComparator());
        return untransmittedsList;
    }

    private static IEauAccountPersistencyManager getIEauAccountPM() {
        return (IEauAccountPersistencyManager)UtilitiesManager.getBean((String)"eauAccountPersistencyManager", IEauAccountPersistencyManager.class);
    }

    public void setAffectedBySpecialAccess(boolean affectedBySpecialAccess) {
        this.mAffectedBySpecialAccess = affectedBySpecialAccess;
    }

    protected Comparator<EauAccount> getEauAccountComparator() {
        return new EauAccountComparator();
    }

    public Date getCreatedOnDate() {
        return this.mCreatedOnDate;
    }

    public Date getCreatedOnDateTruncated() {
        return DateHelper.correctDate((Date)this.mCreatedOnDate);
    }

    public String getPCompanyName(Date validTimePoint) throws BusinessDomainException {
        return this.getFoundations(validTimePoint).getShortDescription();
    }

    private Foundations getFoundations(Date validTimePoint) throws BusinessDomainException {
        return this.mPCompany.getCompanyFoundations(VDate.getDateMax(), validTimePoint).getFoundations();
    }

    public String getCompanyDescription(Date validTimePoint) throws BusinessDomainException {
        return this.getFoundations(validTimePoint).getShortDescription();
    }

    public boolean isAffectedBySpecialAccess() {
        return this.mAffectedBySpecialAccess;
    }

    public String getCreatedOnString() {
        return this.mCreatedOnString;
    }

    private DEUVRecipient getDEUVRecipient(Date validTimePoint, Employee employee, EauAccount account) throws BusinessDomainException {
        HealthFund hf = this.getHealthFund(employee, validTimePoint, account, false);
        if (hf == null) {
            return null;
        }
        return this.mRecipientMap.getDeuvRecipient(hf);
    }

    /*
     * Enabled aggressive block sorting
     */
    public HealthFund getHealthFund(Employee employee, Date validTimePoint, EauAccount account, boolean addError) throws BusinessDomainException {
        Insurance ins = this.getInsurance(validTimePoint, employee);
        if (ins.getPrivateHI()) {
            if (!addError) return null;
            account.addError("F\u00fcr privat krankenversicherte Mitarbeiter darf keine Abfrage erstellt werden.");
            return null;
        }
        HealthFund hf = null;
        if (ins.getPersonGroup() == 109 || ins.getPersonGroup() == 110 || ins.getPersonGroup() == 106 || ins.getPersonGroup() == 190) {
            hf = this.getHealthFundOptional(validTimePoint, employee);
            if (hf != null) return HealthFund.getHealthFundConsiderFusions((HealthFund)hf, (Date)validTimePoint);
            if (ins.getPersonGroup() == 109 && (ins.getDuesGroupHI() == 3 || ins.getDuesGroupPI() == 1) && ins.getUseTransitionBy31122022()) {
                hf = this.getHealthFund(validTimePoint, employee);
                return HealthFund.getHealthFundConsiderFusions((HealthFund)hf, (Date)validTimePoint);
            } else {
                if (!addError) return null;
                account.addError("Bei den PGS 109, 110, 106 und 190 muss das optionale Feld 'gesetzliche Krankenversicherung bei' unter KV RV AV PV der Sozialversicherung gef\u00fcllt sein.");
                return null;
            }
        }
        hf = this.getHealthFund(validTimePoint, employee);
        return HealthFund.getHealthFundConsiderFusions((HealthFund)hf, (Date)validTimePoint);
    }

    public HealthFund getHealthFund(Date validTimePoint, Employee employee) throws BusinessDomainException {
        return this.getInsurance(validTimePoint, employee).getHealthFund();
    }

    public HealthFund getHealthFundOptional(Date validTimePoint, Employee employee) throws BusinessDomainException {
        return this.getInsurance(validTimePoint, employee).getLegalHealthFund();
    }

    public Insurance getInsurance(Date validTimePoint, Employee employee) throws BusinessDomainException {
        return employee.getInsurance(VDate.getDateMax(), validTimePoint);
    }

    public Master getMaster(Date validTimePoint, Employee employee) throws BusinessDomainException {
        return employee.getMaster(VDate.getDateMax(), validTimePoint);
    }

    private String getAzvu(Employee employee) {
        return this.mPCompany.getPCompanyKey() + " / " + employee.getPersonnelnumber();
    }

    private String getRecipient(Employee employee, Date validTimePoint, EauAccount account) throws BusinessDomainException {
        HealthFund hf = this.getHealthFund(employee, validTimePoint, account, true);
        if (hf == null) {
            account.addError("F\u00fcr folgenden Mitarbeiter und Zeitraum ist keine Krankenkasse hinterlegt: " + employee.getPersonnelnumber() + " / " + DateMapper.toDDMMYYYYPointSeparationString((Date)validTimePoint) + ".");
            return "";
        }
        HealthFundTP hftp = (HealthFundTP)hf.getHistory().getItemOrNull(validTimePoint);
        if (hftp == null) {
            account.addError("F\u00fcr folgende Krankenkasse exisitiert kein Zeitraum: " + hf.getHealthFund() + " / " + DateMapper.toDDMMYYYYPointSeparationString((Date)validTimePoint) + ".");
            return "";
        }
        return hftp.getStandardCompanyNumber();
    }

    private IEECompanyPlant getEECompanyPlant(Date validFrom, Employee emp) {
        if (this.mEECompanyPlant == null) {
            this.mEECompanyPlant = (IEECompanyPlant)UtilitiesManager.getBean((String)"eeCompanyPlant", IEECompanyPlant.class);
        }
        this.mEECompanyPlant.setEmployee(emp);
        this.mEECompanyPlant.setEffectiveFrom(DateHelper.tomorrow((Date)emp.getJournalizedUntil()));
        this.mEECompanyPlant.setValidFrom(validFrom);
        return this.mEECompanyPlant;
    }
}

