/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.deuv.deuvaccount.adviceable;

import com.varial.base.exception.BusinessDomainException;
import com.varial.personnel.domain.deuv.deuvaccount.DEUVAccount;
import com.varial.personnel.domain.deuv.deuvaccount.DEUVEmployee;
import com.varial.personnel.domain.deuv.deuvaccount.adviceable.AbstractAdviceable;
import com.varial.personnel.domain.deuv.deuvaccount.adviceable.Adviceable;
import com.varial.personnel.domain.deuv.deuvtrigger.DEUVTrigger;
import com.varial.personnel.domain.deuv.deuvtrigger.TypeOfDeuvTriggerEnum;
import com.varial.personnel.domain.employee.insurance.Insurance;
import com.varial.serverbase.mapper.StringMapper;
import java.util.Date;

public class EntryImpl
extends AbstractAdviceable
implements Adviceable {
    private static final TypeOfDeuvTriggerEnum[] TYPES = new TypeOfDeuvTriggerEnum[]{TypeOfDeuvTriggerEnum.MITARBEITER_EINTRITT};

    protected TypeOfDeuvTriggerEnum[] getTypes() {
        return TYPES;
    }

    public void makeAccount(DEUVEmployee de, DEUVTrigger trigger) throws BusinessDomainException {
        DEUVAccount begin = new DEUVAccount();
        begin.init(de, trigger);
        Date validFrom = trigger.getValidFrom();
        begin.setEffectiveFrom(de.getEffectiveAfterJournalize());
        if (!begin.create()) {
            begin.makeReadOnly();
            return;
        }
        if (de.isInsolvencyLeaveEntry(validFrom)) {
            begin.setLongReasonOfDeliv("10");
            begin.updateReasonOfDelivery();
            de.setPaymentFrom(validFrom);
            begin.update(de.getCurrent());
            begin.makeReadOnly();
            return;
        }
        if (de.isEntryAs13(validFrom)) {
            begin.setLongReasonOfDeliv("13.07");
            begin.setReasonOfDelivery(13);
        } else {
            begin.setLongReasonOfDeliv(this.reasonBy(de, begin));
            begin.updateReasonOfDelivery();
        }
        if (!de.isLeavedOrInvalid()) {
            begin.addError("Wiedereintritt ohne vorherigen Austritt");
        }
        de.setPaymentFrom(validFrom);
        de.addCurrent(begin);
    }

    private String reasonBy(DEUVEmployee de, DEUVAccount begin) {
        Insurance splitted = de.getSplittedInsurance(begin.getValidFrom(), true);
        if (splitted != null) {
            return "1" + de.reasonBy(splitted, begin.getValidFrom(), true);
        }
        String insolvencyEntryReason = de.getInsolvencyEntryReason(begin.getValidFrom());
        if (!StringMapper.isNullString((String)insolvencyEntryReason)) {
            return insolvencyEntryReason;
        }
        return EntryImpl.reasonBy(begin.getDEUVDsme().getPersonengruppe());
    }

    public static final String reasonBy(int persongroup) {
        if (persongroup == 190) {
            return "10";
        }
        if (persongroup == 110) {
            return "10.02";
        }
        if (persongroup == 111) {
            return "10.05";
        }
        if (persongroup == 103) {
            return "10.03";
        }
        return "10.01";
    }
}

