/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.deuv.deuvaccount.adviceable;

import com.varial.base.exception.BusinessDomainException;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.deuv.deuvaccount.DEUVAccount;
import com.varial.personnel.domain.deuv.deuvaccount.DEUVAdvice;
import com.varial.personnel.domain.deuv.deuvaccount.DEUVEmployee;
import com.varial.personnel.domain.deuv.deuvaccount.adviceable.AbstractAdviceable;
import com.varial.personnel.domain.deuv.deuvaccount.adviceable.Adviceable;
import com.varial.personnel.domain.deuv.deuvaccount.adviceable.EntryImpl;
import com.varial.personnel.domain.deuv.deuvaccount.adviceable.WithdrawalImpl;
import com.varial.personnel.domain.deuv.deuvdbme.DEUVDbme;
import com.varial.personnel.domain.deuv.deuvdsme.DEUVDsme;
import com.varial.personnel.domain.deuv.deuvtrigger.DEUVTrigger;
import com.varial.personnel.domain.deuv.deuvtrigger.TypeOfDeuvTriggerEnum;
import com.varial.personnel.domain.employee.insurance.Insurance;
import com.varial.personnel.domain.employee.insurance.SpecialCategoryEnum;
import com.varial.personnel.framework.basictypes.PDateHelper;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.DateMapper;
import java.math.BigDecimal;
import java.util.Date;

public class ChangeImpl
extends AbstractAdviceable
implements Adviceable {
    private static final TypeOfDeuvTriggerEnum[] TYPES = new TypeOfDeuvTriggerEnum[]{TypeOfDeuvTriggerEnum.FIRMEN_GRUNDLAGEN, TypeOfDeuvTriggerEnum.BST_GRUNDLAGEN, TypeOfDeuvTriggerEnum.FIRMEN_AGENTUR_FUER_ARBEIT, TypeOfDeuvTriggerEnum.BST_AGENTUR_FUER_ARBEIT, TypeOfDeuvTriggerEnum.MITARBEITER_DATEN, TypeOfDeuvTriggerEnum.MITARBEITER_JAHRESMELDUNG, TypeOfDeuvTriggerEnum.RENTENBEGINN, TypeOfDeuvTriggerEnum.VERSORGUNGSAUSGLEICH, TypeOfDeuvTriggerEnum.RVBEAGML57};
    public static final int _31_01 = 0;
    public static final int _31_02 = 1;
    public static final int _31_03 = 2;
    public static final int _31_04 = 3;
    public static final int _31_05 = 4;
    public static final int _32_01 = 5;
    public static final int _32_02 = 6;
    public static final int _32_03 = 7;
    public static final int _33_01 = 8;
    public static final int _33_02 = 9;
    public static final int _33_03 = 10;
    public static final int _33_04 = 11;
    public static final int _33_08 = 14;
    public static final int _33_09 = 15;
    public static final int _31 = 16;
    public static final int _32 = 17;
    public static final int _33 = 18;
    public static final int _50_01 = 19;
    public static final int _70_01 = 20;
    public static final int _57_01 = 21;
    private static final String[] OUT_LONGREASONS = new String[]{"31.01", "31.02", "31.03", "31.04", "31.05", "32.01", "32.02", "32.03", "33.01", "33.02", "33.03", "33.04", "33.05", "33.07", "33.08", "33.09", "31", "32", "33", "50.01", "70.01", "57.01"};
    private static final String[] IN_LONGREASONS = new String[]{"11.01", "11.03", "11.02", "11.04", "11.05", "12.01", "12.02", "12.03", "13.01", "13.03", "13.02", "13.05", "13.06", "13.09", "13.10", "13.12", "11", "12", "13", null, null, null};
    public static final int NO_REASON_TO_DELIV = -1;

    protected TypeOfDeuvTriggerEnum[] getTypes() {
        return TYPES;
    }

    public void makeAccount(DEUVEmployee de, DEUVTrigger trigger) throws BusinessDomainException {
        Date validFrom = trigger.getValidFrom();
        if (de.isEntryOrEntrySI(validFrom)) {
            DEUVAccount begin = new DEUVAccount();
            begin.init(de, trigger);
            if (!begin.create()) {
                begin.makeReadOnly();
                return;
            }
            de.setPaymentFrom(validFrom);
            begin.setLongReasonOfDeliv(EntryImpl.reasonBy(begin.getPersongroup()));
            begin.setReasonOfDelivery(10);
            de.addCurrent(begin);
            return;
        }
        if (de.isLeaved() || this.makeDeuvBegin(de, trigger) || de.isInvalid()) {
            return;
        }
        boolean isDisruption = de.isDisruption(validFrom);
        if (isDisruption) {
            DEUVAccount disruption = de.getDisruption();
            disruption.makeSaveable();
            de.addCurrent(disruption);
            de.makeDifferenceATZ(de.getAbsenceUntil());
            de.clearDisruption();
            de.setPaymentFrom(disruption.getValidAfter());
        }
        if (de.getInsuranceOrNull(de.getEffectiveFrom(), DateHelper.yesterday((Date)validFrom)) == null) {
            return;
        }
        DEUVAccount payment = new DEUVAccount();
        payment.init(de, trigger);
        payment.setValidUntil(DateHelper.yesterday((Date)validFrom));
        de.makeAdvicePeriod(payment);
        payment.computePayment();
        payment.updateDbme();
        DEUVAccount begin = new DEUVAccount();
        begin.init(de, trigger);
        if (!begin.create()) {
            begin.makeReadOnly();
            payment.setLongReasonOfDeliv(WithdrawalImpl.reasonBy((int)payment.getPersongroup()));
            payment.updateReasonOfDelivery();
            de.makeLeave(payment);
            return;
        }
        int reason = this.reasonBy(payment, begin, de, trigger);
        if (reason == -1) {
            payment.makeReadOnly();
            begin.makeReadOnly();
            return;
        }
        payment.setReasonOfDelivery(this.parseReason(OUT_LONGREASONS[reason]));
        payment.setLongReasonOfDeliv(OUT_LONGREASONS[reason]);
        if (reason == 21) {
            begin.makeReadOnly();
            if (isDisruption || BigDecimalMapper.isZeroOrNull((BigDecimal)payment.getPayment())) {
                payment.makeReadOnly();
                return;
            }
            payment.setRvbeaDxar(trigger.getRvbeaDxar());
            de.addCurrent(payment);
            return;
        }
        if (reason == 19 || reason == 20) {
            begin.makeReadOnly();
            if (isDisruption || begin.isInsignificantForAnnual()) {
                payment.makeReadOnly();
                return;
            }
            de.makeAnnualDisruption(payment);
            de.setPaymentFrom(begin.getValidFrom());
            if (!this.isYearlyNecessary(payment)) {
                payment.makeReadOnly();
                return;
            }
            de.addCurrent(payment);
            return;
        }
        if (DateHelper.before((Date)payment.getValidUntil(), (Date)de.getDEUVStart())) {
            payment.makeReadOnly();
        } else {
            de.addCurrent(payment);
        }
        begin.setReasonOfDelivery(this.parseReason(IN_LONGREASONS[reason]));
        begin.setLongReasonOfDeliv(IN_LONGREASONS[reason]);
        de.setPaymentFrom(begin.getValidFrom());
        de.addCurrent(begin);
    }

    private int parseReason(String longreason) {
        return Integer.parseInt(longreason.substring(0, 2));
    }

    private int reasonBy(DEUVAccount payment, DEUVAccount begin, DEUVEmployee employee, DEUVTrigger trigger) throws BusinessDomainException {
        Date from;
        DEUVDsme dsmePayment = payment.getDEUVDsme();
        DEUVDsme dsmeBegin = begin.getDEUVDsme();
        int reasonsIndex = dsmeBegin.reasonBy(dsmePayment);
        if ((reasonsIndex = payment.fixReasonAtFusion(reasonsIndex)) == -1) {
            DEUVDbme dbmeBegin;
            DEUVDbme dbmePayment = payment.getDEUVDbme();
            if (dbmePayment.isDuesgroupChanged(dbmeBegin = begin.getDEUVDbme())) {
                reasonsIndex = this.reasonDuesgroupBy(employee, dsmePayment, dsmeBegin);
            }
            if (reasonsIndex == -1 && DateHelper.equal((Date)begin.getValidFrom(), (Date)DEUVAdvice.START_BESTANDSSCHUTZ_2022) && this.isBestandsschutz2022(payment, begin, employee)) {
                reasonsIndex = 17;
            }
            if (reasonsIndex == -1) {
                reasonsIndex = dsmeBegin.reasonOtherBy(dsmePayment);
            }
            if (reasonsIndex == -1) {
                reasonsIndex = dbmeBegin.reasonOtherBy(dbmePayment);
            }
            if (reasonsIndex == -1 && dsmeBegin.isVerursacherChanged(dsmePayment)) {
                reasonsIndex = 15;
            }
        }
        if (reasonsIndex == -1 && DateHelper.after((Date)begin.getValidFrom(), (Date)DateMapper.toDate((String)"2009-01-01")) && payment.isPensionBalanceDifferent(begin)) {
            reasonsIndex = 18;
        }
        if (reasonsIndex == -1 && DateHelper.afterOrEqual((Date)begin.getValidFrom(), (Date)DateMapper.toDate((String)"2013-01-01")) && this.isNewGfBwithSameBGS(payment, begin, employee)) {
            reasonsIndex = 18;
        }
        if (reasonsIndex == -1 && PDateHelper.isFirstDayOfYear((Date)(from = begin.getValidFrom())) && DateHelper.afterOrEqual((Date)employee.getJournalizedUntil(), (Date)from)) {
            reasonsIndex = employee.isInsolvencyLeaveCompany() ? 20 : 19;
        }
        if (reasonsIndex == -1 && (trigger.getTypeOfDeuvTrigger() == TypeOfDeuvTriggerEnum.RVBEAGML57 || employee.hasRvbeaDxar(trigger))) {
            reasonsIndex = 21;
        }
        if (reasonsIndex == -1 && begin.isSeparateRequired()) {
            reasonsIndex = 21;
        }
        return reasonsIndex;
    }

    boolean isNewGfBwithSameBGS(DEUVAccount payment, DEUVAccount begin, DEUVEmployee employee) throws BusinessDomainException {
        Insurance insurance;
        return begin.getDEUVDsme().getPersonengruppe() == 109 && begin.getDEUVDbme().getBeitragsgruppe().equals("6500") && (insurance = employee.getInsurance(begin.getEffectiveFrom(), begin.getValidFrom())).getOfferForExemptionFromPI() && DateHelper.afterOrEqual((Date)insurance.getDateOfferForExemptionFromPI(), (Date)begin.getValidFrom()) && !employee.getInsurance(payment.getEffectiveFrom(), payment.getValidUntil()).getOfferForExemptionFromPI();
    }

    boolean isBestandsschutz2022(DEUVAccount payment, DEUVAccount begin, DEUVEmployee employee) throws BusinessDomainException {
        if (payment.getDEUVDsme().getPersonengruppe() != 109 && begin.getDEUVDsme().getPersonengruppe() == 109) {
            Insurance insurance = employee.getInsurance(begin.getEffectiveFrom(), begin.getValidFrom());
            return insurance.getSpecialCategoryOfPersons() == SpecialCategoryEnum.SCE_GLEITZONENREGELUNG && insurance.getUseTransitionBy31122022();
        }
        return false;
    }

    private int reasonDuesgroupBy(DEUVEmployee employee, DEUVDsme payment, DEUVDsme begin) {
        if (payment.getPersonengruppe() == 109 && begin.getPersonengruppe() == 110) {
            return 6;
        }
        if (payment.getPersonengruppe() == 110 && begin.getPersonengruppe() == 109) {
            return 6;
        }
        if (employee.getDEUVAdvice().isMinijobStdCompanyNo(payment.getBbnrKrankenkasse()) && employee.getDEUVAdvice().isMinijobStdCompanyNo(begin.getBbnrKrankenkasse())) {
            if (payment.getPersonengruppe() == 109 && begin.getPersonengruppe() == 101) {
                return 3;
            }
            if (payment.getPersonengruppe() == 101 && begin.getPersonengruppe() == 109) {
                return 4;
            }
        }
        return 17;
    }

    private boolean makeDeuvBegin(DEUVEmployee de, DEUVTrigger trigger) throws BusinessDomainException {
        boolean finished;
        DEUVAccount result = null;
        Date validFrom = trigger.getValidFrom();
        if (!DateHelper.equal((Date)de.getDEUVStart(), (Date)validFrom)) {
            return false;
        }
        DEUVAccount begin = new DEUVAccount();
        begin.init(de, trigger);
        if (!begin.create()) {
            begin.makeReadOnly();
            return true;
        }
        if (this.isFromAfterDEUVBegin(de, validFrom)) {
            result = begin;
            if (de.getDeclarationByBreak() && result.getPersongroup() != 110) {
                result.setLongReasonOfDeliv("13.07");
                result.updatePersonalData();
            } else {
                result.setStateAtDeuvBegin();
            }
            finished = true;
        } else if (this.isContinuedDEUVBegin(de, validFrom)) {
            result = de.makeContinuedDEUVBegin();
            result.setStateAtDeuvBegin();
            begin.makeReadOnly();
            finished = false;
        } else if (this.isDbt(de)) {
            result = begin;
            result.setStateAtDeuvBegin();
            finished = false;
        } else {
            result = begin.makeDeuvBegin();
            finished = true;
        }
        result.updateReasonOfDelivery();
        de.setPaymentFrom(result.getValidFrom());
        de.addCurrent(result);
        return finished;
    }

    private boolean isFromAfterDEUVBegin(DEUVEmployee de, Date validFrom) {
        return de.getPaymentFrom() != null && DateHelper.afterOrEqual((Date)de.getPaymentFrom(), (Date)validFrom);
    }

    private boolean isContinuedDEUVBegin(DEUVEmployee de, Date validFrom) throws BusinessDomainException {
        return DateHelper.before((Date)de.getCalculationStart(), (Date)validFrom);
    }

    private boolean isYearlyNecessary(DEUVAccount account) {
        return !BigDecimalMapper.isZero((BigDecimal)account.getPayment()) || account.getPersongroup() == 110 || account.getPersongroup() == 190;
    }

    private boolean isDbt(DEUVEmployee de) throws BusinessDomainException {
        return DateHelper.before((Date)de.getCalculationHistoric(), (Date)de.getCalculationStart());
    }
}

