/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.deuv.deuvaccount;

import com.varial.base.UtilitiesManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.criterion.Conjunction;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Disjunction;
import com.varial.base.persistency.criterion.Order;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.companyplant.Settings;
import com.varial.personnel.domain.deuv.DateInterval;
import com.varial.personnel.domain.deuv.IDbanData;
import com.varial.personnel.domain.deuv.IDbgbData;
import com.varial.personnel.domain.deuv.IDbnaData;
import com.varial.personnel.domain.deuv.deuvaccount.DEUVAbsentTime;
import com.varial.personnel.domain.deuv.deuvaccount.DEUVAccount;
import com.varial.personnel.domain.deuv.deuvaccount.DEUVAccountEmployeeComparator;
import com.varial.personnel.domain.deuv.deuvaccount.DEUVAccountPersistencyManager;
import com.varial.personnel.domain.deuv.deuvaccount.DEUVAdvice;
import com.varial.personnel.domain.deuv.deuvaccount.DEUVAttendance;
import com.varial.personnel.domain.deuv.deuvaccount.DEUVTriggerEmployeeComparator;
import com.varial.personnel.domain.deuv.deuvaccount.PersonalCurrentData;
import com.varial.personnel.domain.deuv.deuvaccount.adviceable.Validityable;
import com.varial.personnel.domain.deuv.deuvaccount.adviceable.ValidityableImpl;
import com.varial.personnel.domain.deuv.deuvaccount.adviceable.ValueInterval;
import com.varial.personnel.domain.deuv.deuvaccount.mapper.DEUVAccountExceptionMapper;
import com.varial.personnel.domain.deuv.deuvdban.DEUVDban;
import com.varial.personnel.domain.deuv.deuvdbgb.DEUVDbgb;
import com.varial.personnel.domain.deuv.deuvdbme.DEUVDbme;
import com.varial.personnel.domain.deuv.deuvdbna.DEUVDbna;
import com.varial.personnel.domain.deuv.deuvdbst.DEUVDbst;
import com.varial.personnel.domain.deuv.deuvtrigger.DEUVTrigger;
import com.varial.personnel.domain.deuv.deuvtrigger.DEUVTriggerPersistencyManager;
import com.varial.personnel.domain.deuv.deuvtrigger.TypeOfDeuvTriggerEnum;
import com.varial.personnel.domain.employee.Employee;
import com.varial.personnel.domain.employee.IEECompanyPlant;
import com.varial.personnel.domain.employee.carriedforward.system.socialinsurance.EECarriedForwardSystemSI;
import com.varial.personnel.domain.employee.employment.Employment;
import com.varial.personnel.domain.employee.employment.InsolvencyDsmRgnReasonEnum;
import com.varial.personnel.domain.employee.employment.InsolvencyEntryReasonEnum;
import com.varial.personnel.domain.employee.insurance.Insurance;
import com.varial.personnel.domain.employee.insurance.SpecialCategoryEnum;
import com.varial.personnel.domain.employee.master.Master;
import com.varial.personnel.domain.employee.successor.EESuccessor;
import com.varial.personnel.domain.employee.successor.IEESuccessorPersistencyManager;
import com.varial.personnel.domain.employee.tax.Tax;
import com.varial.personnel.domain.employee.tax.TaxacationEnum;
import com.varial.personnel.domain.employee.valueposition.ValuePosition;
import com.varial.personnel.domain.employee.valueposition.ValuePositionPersistencyManager;
import com.varial.personnel.domain.global.deuv.recipient.DEUVRecipient;
import com.varial.personnel.domain.global.deuv.sender.DEUVSenderTP;
import com.varial.personnel.domain.global.healthfund.HealthFund;
import com.varial.personnel.domain.global.healthfund.HealthFundPersistencyManager;
import com.varial.personnel.domain.global.healthfund.HealthFundTP;
import com.varial.personnel.domain.global.healthfund.TypeOfHealthFundEnum;
import com.varial.personnel.domain.global.socialinsurance.SocialInsuranceTP;
import com.varial.personnel.domain.pcompany.PCompany;
import com.varial.personnel.domain.pcompany.settings.CompanySettings;
import com.varial.personnel.domain.plant.Plant;
import com.varial.personnel.domain.plant.settings.PlantSettings;
import com.varial.personnel.domain.rvbea.dxar.IRvbeaDxarPersistencyManager;
import com.varial.personnel.domain.rvbea.dxar.RvbeaDxar;
import com.varial.personnel.domain.typeofvalue.ValueType;
import com.varial.personnel.framework.CompareToOldUtil;
import com.varial.personnel.framework.D;
import com.varial.personnel.framework.PersonnelHistory;
import com.varial.personnel.framework.PersonnelTimedPersistenceObject;
import com.varial.personnel.framework.basictypes.PDateHelper;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.StringMapper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class DEUVEmployee {
    private static final Comparator<DEUVTrigger> TRIGGER_COMPARATOR = new DEUVTriggerEmployeeComparator();
    private static final Comparator<DEUVAccount> ACCOUNT_COMPARATOR = new DEUVAccountEmployeeComparator();
    public static final String BGS_6500 = "6500";
    public static final String BGS_6100 = "6100";
    public static final String BGS_6000 = "6000";
    public static final String BGS_0500 = "0500";
    public static final String BGS_0000 = "0000";
    public static final int REASON_10 = 10;
    public static final int REASON_30 = 30;
    public static final int REASON_49 = 49;
    public static final int REASON_50 = 50;
    public static final int REASON_56 = 56;
    public static final int REASON_91 = 91;
    public static final int PGS_101 = 101;
    public static final int PGS_102 = 102;
    public static final int PGS_103 = 103;
    public static final int PGS_105 = 105;
    public static final int PGS_106 = 106;
    public static final int PGS_107 = 107;
    public static final int PGS_108 = 108;
    public static final int PGS_109 = 109;
    public static final int PGS_110 = 110;
    public static final int PGS_111 = 111;
    public static final int PGS_116 = 116;
    public static final int PGS_121 = 121;
    public static final int PGS_122 = 122;
    public static final int PGS_123 = 123;
    public static final int PGS_127 = 127;
    public static final int PGS_141 = 141;
    public static final int PGS_144 = 144;
    public static final int PGS_190 = 190;
    private static final BigDecimal THIRTY = BigDecimal.valueOf(30L);
    private final DEUVAdvice mDEUVAdvice;
    private final Employee mEmployee;
    private final List<DEUVTrigger> mDEUVTriggers;
    private Date mFirstValidFrom;
    private Date mJournalizedUntil;
    private final List<DEUVAccount> mCreateds;
    private List<DEUVAccount> mReferences;
    private final DEUVAccount mCurrent;
    private DEUVAccount mDisruption;
    private Date mEffectiveFrom;
    private DEUVAccount mMerge;
    private Iterator<DEUVAccount> mMergeIterator;
    private ValueInterval mLowWagePositions;
    private ValueInterval mStoerfallMarkerPositions;
    private ValueInterval mStoerfallPositions;
    private ValueInterval mDifferencePositions;
    private ValueInterval mSIDayPositions;
    private ValueInterval mMbbglPositions;
    private ValueInterval mOtherEmployerPositions;
    private ValueInterval mAtzZbeAndKugPositions;
    private ValueInterval mVoluntaryHIPositions;
    private ValueInterval mPaymentBvPositions;
    private final ValueInterval[] mEgaPositions = new ValueInterval[4];
    private final ValueInterval[] mPaymentPositions = new ValueInterval[4];
    private final ValueInterval[] mMidijobBemessungPositions = new ValueInterval[4];
    private Date mAbsenceUntil;
    private boolean mHasErrors;
    private PersonalCurrentData mPersonalCurrentData;
    private final Deque<DEUVAccount> mResults = new LinkedList<DEUVAccount>();
    private DEUVAttendance mAttendance;

    public DEUVEmployee(DEUVAdvice advice, Employee employee) throws BusinessDomainException {
        this.mEmployee = employee;
        this.mDEUVAdvice = advice;
        this.mDEUVTriggers = new LinkedList<DEUVTrigger>();
        this.mCreateds = new ArrayList<DEUVAccount>();
        this.mCurrent = new DEUVAccount(true);
        this.mCurrent.setValidUntil(VDate.getDateMax());
        this.initEmployee();
    }

    private void initEmployee() throws BusinessDomainException {
        this.mJournalizedUntil = this.mEmployee.getJournalizedUntil();
        if (this.mDEUVAdvice.isPreview()) {
            this.mJournalizedUntil = PDateHelper.getLastDayNextMonth((Date)this.mJournalizedUntil);
        }
        this.mEffectiveFrom = DateHelper.max((Date)DateHelper.getFirstDayOfMonth((Date)this.mJournalizedUntil), (Date)this.mEmployee.getMinimumDateOfEntry());
        if (this.getEmployee().getRetroactiveEntry()) {
            this.mEffectiveFrom = DateHelper.max((Date)this.mEffectiveFrom, (Date)this.getEmployee().getStartEffectiveFrom());
        }
        this.mFirstValidFrom = this.mEffectiveFrom;
        this.mPersonalCurrentData = new PersonalCurrentData(this.mEmployee, this.getPersonalCurrentDate());
    }

    public DEUVAdvice getDEUVAdvice() {
        return this.mDEUVAdvice;
    }

    public Employee getEmployee() {
        return this.mEmployee;
    }

    public Date getEffectiveAfterJournalize() {
        return DateHelper.max((Date)DateHelper.tomorrow((Date)this.mEmployee.getJournalizedUntil()), (Date)this.mEmployee.getMaximumDateOfEntry());
    }

    private Date getPersonalCurrentDate() {
        return DateHelper.max((Date[])new Date[]{this.mJournalizedUntil, this.mEmployee.getMinimumDateOfEntry(), this.mDEUVAdvice.getCreatedOnDate()});
    }

    public Date getJournalizedUntil() {
        return this.mJournalizedUntil;
    }

    public DEUVAccount getCurrent() {
        return this.mCurrent;
    }

    public DEUVAccount getDisruption() {
        return this.mDisruption;
    }

    public void setDisruption(DEUVAccount disruption) {
        this.mDisruption = disruption;
    }

    public void clearDisruption() {
        this.mDisruption = null;
    }

    public void makeDifferenceATZ(Date absenceUntil) throws BusinessDomainException {
        if (this.mDisruption == null || !this.mDisruption.isPersongroupATZ() || absenceUntil == null || this.getDifferencePositions().isEmpty()) {
            return;
        }
        Date validFrom = this.mDisruption.getValidAfter();
        while (DateHelper.after((Date)absenceUntil, (Date)DateHelper.getLastDayOfYear((Date)validFrom))) {
            Date validUntil = DateHelper.getLastDayOfYear((Date)validFrom);
            if (this.isInFuture(validUntil)) {
                return;
            }
            this.createReason56(validFrom, validUntil);
            validFrom = PDateHelper.getFirstDayNextYear((Date)validFrom);
        }
        if (!this.isInFuture(absenceUntil)) {
            this.createReason56(validFrom, absenceUntil);
        }
    }

    private void createReason56(Date validFrom, Date validUntil) throws BusinessDomainException {
        BigDecimal payment = this.getDifferencePositions().calculate(validFrom, validUntil);
        if (!BigDecimalMapper.isZero((BigDecimal)payment)) {
            DEUVAccount account56 = this.mDisruption.createNew();
            account56.setLongReasonOfDeliv("56.01");
            account56.setReasonOfDelivery(56);
            account56.setValidFrom(validFrom);
            account56.setValidUntil(validUntil);
            account56.setPayment(DEUVAccount.truncate(payment));
            account56.updateDbme();
            Insurance insurance = this.getInsurance(this.mEffectiveFrom, validUntil);
            HealthFund healthFund = HealthFund.getHealthFundConsiderFusions((HealthFund)insurance.getHealthFund(), (Date)validUntil);
            String bbnrKrk = healthFund.getHealthFundTP(this.mEffectiveFrom, VDate.getDateMax()).getStandardCompanyNumber();
            account56.getDEUVDsme().setBbnrKrankenkasse(bbnrKrk);
            account56.setDEUVRecipient(this.getDEUVAdvice().getDEUVRecipient(insurance.getHealthFund()));
            DEUVDbme dbme = account56.getDEUVDbme();
            if (dbme != null) {
                dbme.setGleitzone("0");
                dbme.setEntgeltRb(null);
            }
            this.addCurrent(account56);
        }
    }

    public void initTriggers() throws BusinessDomainException {
        DEUVTrigger[] triggers = DEUVTriggerPersistencyManager.query(null, (Criterion)Restrictions.eq((String)"oidemployee", (String)this.mEmployee.getObjectid()), (boolean)true);
        for (DEUVTrigger trigger : this.removeUnnecessaryTrigger(triggers)) {
            this.insertApplicable(trigger);
        }
        this.insertApplicable(this.createTrigger(this.getFirstValidDate(), TypeOfDeuvTriggerEnum.MITARBEITER_DATEN));
        this.createDeuvTriggers();
        Date year = PDateHelper.getFirstDayNextYear((Date)this.getFirstValidDate());
        while (DateHelper.before((Date)year, (Date)this.mJournalizedUntil)) {
            this.insert(this.createTrigger(year, TypeOfDeuvTriggerEnum.MITARBEITER_JAHRESMELDUNG));
            year = PDateHelper.getFirstDayNextYear((Date)year);
        }
    }

    public DEUVTrigger createTrigger(Date validFrom, TypeOfDeuvTriggerEnum type) {
        DEUVTrigger trigger = new DEUVTrigger();
        trigger.makeReadOnly();
        trigger.setEmployee(this.mEmployee);
        trigger.setValidFrom(validFrom);
        trigger.setValidUntil(VDate.getDateMax());
        trigger.setEffectiveFrom(this.mEffectiveFrom);
        trigger.setTypeOfDeuvTrigger(type);
        return trigger;
    }

    private void insertApplicable(DEUVTrigger trigger) {
        if (this.isValidTrigger(trigger)) {
            this.insert(trigger);
            this.mFirstValidFrom = DateHelper.min((Date)this.mFirstValidFrom, (Date)trigger.getValidFrom());
        }
    }

    private void insert(DEUVTrigger trigger) {
        int pos = Collections.binarySearch(this.mDEUVTriggers, trigger, TRIGGER_COMPARATOR);
        if (pos < 0) {
            pos = -pos - 1;
            this.mDEUVTriggers.add(pos, trigger);
        }
    }

    private boolean isValidTrigger(DEUVTrigger trigger) {
        Date validUntil = this.mJournalizedUntil;
        if (trigger.isSeparate()) {
            validUntil = new VDate(this.mJournalizedUntil).addMonths(1).getDate();
        } else if (trigger.isEntry()) {
            return true;
        }
        return DateHelper.beforeOrEqual((Date)trigger.getValidFrom(), (Date)validUntil) && DateHelper.beforeOrEqual((Date)trigger.getEffectiveFrom(), (Date)this.mJournalizedUntil);
    }

    public void createDeuvTriggers() throws BusinessDomainException {
        this.createDeuvTriggers(this.mEmployee.getInsuranceHistory());
        this.createDeuvTriggers(this.mEmployee.getEmploymentHistory());
        for (Employment employment : this.mEmployee.getEmploymentHistory().getPeriods(this.mEffectiveFrom, this.getFirstValidDate(), VDate.getDateMax())) {
            Date leaveAt = employment.getDateOfWithDrawal();
            if (leaveAt == null || !this.isDateOfWithdrawal(leaveAt)) continue;
            if (employment.getWithDrawalDeath()) {
                this.insertApplicable(this.createTrigger(leaveAt, TypeOfDeuvTriggerEnum.FEHLZEIT_TOD));
                continue;
            }
            this.insertApplicable(this.createTrigger(leaveAt, TypeOfDeuvTriggerEnum.MITARBEITER_AUSTRITT));
        }
        for (Employment employment : this.mEmployee.getEmploymentHistory(this.getEffectiveAfterJournalize())) {
            Date entryDate = employment.getDateOfEntry();
            if (entryDate == null || !DateHelper.afterOrEqual((Date)entryDate, (Date)this.getDEUVStart()) || !this.isDateOfEntry(entryDate)) continue;
            this.insertApplicable(this.createTrigger(entryDate, TypeOfDeuvTriggerEnum.MITARBEITER_EINTRITT));
        }
        this.createRvbeaDxarTrigger();
    }

    private <T extends PersonnelTimedPersistenceObject> void createDeuvTriggers(PersonnelHistory<T> tps) {
        for (PersonnelTimedPersistenceObject each : tps.getPeriods(this.mEffectiveFrom, this.getFirstValidDate(), VDate.getDateMax())) {
            this.insertApplicable(this.createTrigger(each.getValidFrom(), TypeOfDeuvTriggerEnum.MITARBEITER_DATEN));
        }
    }

    private void createRvbeaDxarTrigger() {
        for (RvbeaDxar each : DEUVEmployee.getRvbeaDxarPM().query(null, Restrictions.eq((String)"OIDEMPLOYEE", (String)this.mEmployee.getObjectid()))) {
            if (each.getRvbeaDxeb() != null) continue;
            LocalDate validFrom = LocalDate.of(each.getEbjahrbis(), each.getEbmonatbis(), 1).plusMonths(1L);
            DEUVTrigger trigger = this.createTrigger(PDateHelper.toDate((LocalDate)validFrom), TypeOfDeuvTriggerEnum.RVBEAGML57);
            trigger.setRvbeaDxar(each);
            this.insertApplicable(trigger);
        }
    }

    public boolean hasRvbeaDxar(DEUVTrigger trigger) {
        LocalDate date = DateHelper.toLocalDate((Date)trigger.getValidFrom()).minusDays(1L);
        Conjunction filter = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"OIDEMPLOYEE", (String)this.mEmployee.getObjectid()), Restrictions.eq((String)"EBJAHRVON", (String)String.valueOf(date.getYear())), Restrictions.eq((String)"EBMONATVON", (String)String.valueOf(date.getMonthValue()))});
        for (RvbeaDxar each : DEUVEmployee.getRvbeaDxarPM().query(null, (Criterion)filter)) {
            if (each.getRvbeaDxeb() != null) continue;
            trigger.setRvbeaDxar(each);
            return true;
        }
        return false;
    }

    private List<DEUVTrigger> removeUnnecessaryTrigger(DEUVTrigger[] triggers) throws BusinessDomainException {
        ArrayList<DEUVTrigger> required = new ArrayList<DEUVTrigger>();
        for (DEUVTrigger trigger : triggers) {
            if (trigger.IsCreatedAutomatically()) {
                required.add(trigger);
                continue;
            }
            trigger.makeSaveable();
            trigger.destroy();
        }
        return required;
    }

    private List<DEUVAccount> getReferences() throws BusinessDomainException {
        if (this.mReferences == null) {
            this.initReferences();
        }
        return this.mReferences;
    }

    private void initReferences() throws BusinessDomainException {
        Criterion filters = Restrictions.eq((String)DEUVAccountPersistencyManager.OIDEMPLOYEE, (String)this.mEmployee.getObjectid());
        DEUVAccount[] allAccounts = DEUVAccountPersistencyManager.query((Order[])DEUVAccount.getSortStruct(), (Criterion)filters);
        ArrayList<DEUVAccount> references = new ArrayList<DEUVAccount>();
        references.addAll(Arrays.asList(allAccounts));
        for (DEUVAccount each : new ArrayList(references)) {
            if (each.getTransmitted() && !each.isStateAtDeuvBegin()) continue;
            references.remove((Object)each);
            each.makeSaveable();
            each.destroy();
        }
        for (DEUVAccount each : new ArrayList(references)) {
            if (!each.isReasonDbkv() && !each.isUvReason()) continue;
            references.remove((Object)each);
        }
        LinkedList inputs = new LinkedList(references);
        block2: while (!inputs.isEmpty()) {
            DEUVAccount current = (DEUVAccount)((Object)inputs.remove(0));
            for (DEUVAccount each : inputs) {
                if (!each.isCancellation() || current.compareToResume(each) != 0) continue;
                each.reorgCancelled("J");
                inputs.remove((Object)each);
                current.reorgCancelled("X");
                references.remove((Object)each);
                references.remove((Object)current);
                continue block2;
            }
        }
        for (Object each : new ArrayList(references)) {
            if (!each.isCancellation()) continue;
            each.reorgCancelled("J");
            references.remove(each);
        }
        Date calculationStart = this.getCalculationStart();
        for (DEUVAccount each : new ArrayList(references)) {
            Date untilDate = each.isPayment() ? each.getValidUntil() : each.getValidFrom();
            if (!DateHelper.before((Date)untilDate, (Date)calculationStart) || !DateHelper.before((Date)untilDate, (Date)this.getDEUVStart())) continue;
            each.reorgCancelled("N");
            references.remove((Object)each);
        }
        Collections.sort(references, new Comparator<DEUVAccount>(){

            @Override
            public int compare(DEUVAccount o1, DEUVAccount o2) {
                int result = o1.compareToResume(o2);
                if (result == 0) {
                    return StringMapper.compareTo((String)o1.getCreatedOn(), (String)o2.getCreatedOn());
                }
                return result;
            }
        });
        DEUVAccount prev = null;
        ListIterator it = references.listIterator(references.size());
        ArrayList<DEUVAccount> obsoletes = new ArrayList<DEUVAccount>();
        while (it.hasPrevious()) {
            DEUVAccount each = (DEUVAccount)((Object)it.previous());
            if (prev != null && each.compareToResume(prev) == 0) {
                each.reorgCancelled("X");
                obsoletes.add(each);
            }
            prev = each;
        }
        references.removeAll(obsoletes);
        for (DEUVAccount each : references) {
            each.reorgCancelled("N");
        }
        this.mReferences = new ArrayList<DEUVAccount>(references.size());
        for (DEUVAccount account : references) {
            account.loadAdvicedState(this);
            this.mReferences.add(account);
        }
    }

    public void makeAdviceables() throws BusinessDomainException {
        for (DEUVTrigger trigger : this.mDEUVTriggers) {
            this.mDEUVAdvice.make(trigger, this);
        }
        for (DEUVAccount each : this.mCreateds) {
            each.updateKennzeichen();
        }
    }

    public void addCurrent(DEUVAccount created) throws BusinessDomainException {
        if (created.isPromptRequired()) {
            DEUVAccount prompt = created.createPrompt();
            this.mCreateds.add(prompt);
        }
        this.addWithSplitting(created);
        created.update(this.mCurrent);
    }

    private void addWithSplitting(DEUVAccount created) throws BusinessDomainException {
        if (created.isStateAtDeuvBegin()) {
            return;
        }
        if (created.checkSplitting()) {
            DEUVAccount split = created.createNew();
            split.updateSplitting();
            this.mCreateds.add(split);
            created.stripSplitting();
        }
        this.checkAndSplitBestandsschutz2022(created);
        if (created.isPensionPayingInstitution()) {
            DEUVAccount bv = created.createNew();
            bv.setDEUVRecipient(this.mDEUVAdvice.getPensionPayingRecipient());
            bv.updatePensionPayingInstitution();
            this.mCreateds.add(bv);
            if (this.isPGSIncluded(created.getPersongroup(), 110, 190) && !BigDecimalMapper.isZeroOrNull((BigDecimal)created.getPayment())) {
                created.setPayment(BigDecimal.ZERO);
                created.getDEUVDbme().setEntgelt(BigDecimal.ZERO);
            }
        }
        this.createDeuvDbst(created);
        this.mCreateds.add(created);
    }

    private void checkAndSplitBestandsschutz2022(DEUVAccount created) throws BusinessDomainException {
        if (this.isBestandsschutz2022(created.getValidDate())) {
            String duesgroupsBuKn;
            DEUVAccount splitBuKn = created.createNew();
            splitBuKn.setSplitting(true);
            splitBuKn.getDEUVDsme().setBbnrKrankenkasse(this.getDEUVAdvice().getMinijobStdCompanyNo());
            splitBuKn.setDEUVRecipient(this.getDEUVAdvice().getBuknRecipient());
            String duesGroupHI = "0";
            if (splitBuKn.getDuesgroups().charAt(0) == '6') {
                duesGroupHI = "6";
            }
            if (BGS_0000.equals(duesgroupsBuKn = duesGroupHI + splitBuKn.getDuesgroups().charAt(1) + "00")) {
                splitBuKn.setPersongroup(190);
                splitBuKn.getDEUVDsme().setPersonengruppe(190);
                if (!BigDecimalMapper.isZeroOrNull((BigDecimal)splitBuKn.getPayment())) {
                    splitBuKn.setPayment(BigDecimal.ZERO);
                    splitBuKn.getDEUVDbme().setEntgelt(BigDecimal.ZERO);
                }
            }
            splitBuKn.setDuesgroups(duesgroupsBuKn);
            splitBuKn.getDEUVDbme().setBeitragsgruppe(duesgroupsBuKn);
            this.createDeuvDbst(splitBuKn);
            this.mCreateds.add(splitBuKn);
            String adjustedDuesGroup = this.getAdjustedDuesGroups2022(created.getDuesgroups());
            created.setDuesgroups(adjustedDuesGroup);
            created.getDEUVDbme().setBeitragsgruppe(adjustedDuesGroup);
            BigDecimal paymentMidijob2022 = created.getPaymentMidijob2022();
            if (!BigDecimalMapper.isZeroOrNull((BigDecimal)created.getPaymentMidijob2022())) {
                created.setPayment(paymentMidijob2022);
                created.getDEUVDbme().setEntgelt(paymentMidijob2022);
            }
        }
    }

    public boolean isBestandsschutz2022(Date validTP) throws BusinessDomainException {
        Insurance insurance = this.getInsurance(this.mEffectiveFrom, validTP);
        return insurance.getPersonGroup() == 109 && insurance.getSpecialCategoryOfPersons() == SpecialCategoryEnum.SCE_GLEITZONENREGELUNG && insurance.getUseTransitionBy31122022();
    }

    public String getAdjustedDuesGroups2022(String duesGroups) {
        StringBuilder duesgroups = new StringBuilder(duesGroups);
        if (duesGroups.charAt(0) == '6') {
            duesgroups.setCharAt(0, '0');
        }
        duesgroups.setCharAt(1, '0');
        return duesgroups.toString();
    }

    public boolean makeAdvicePeriod(DEUVAccount withdrawal) throws BusinessDomainException {
        if (this.mCurrent.isInvalid()) {
            throw DEUVAccountExceptionMapper.makeMissReferenceException((String)DateMapper.toDDMMYYYYPointSeparationString((Date)this.getDEUVStart()));
        }
        Date validFrom = this.getPaymentFrom();
        if (this.isDisruptionAtDeuvBegin(validFrom, withdrawal.getValidFrom())) {
            validFrom = DateHelper.tomorrow((Date)this.mAbsenceUntil);
            this.setPaymentFrom(validFrom);
            this.mAbsenceUntil = null;
        }
        withdrawal.setValidFrom(validFrom);
        return withdrawal.createAdvicePeriod(this.mCurrent);
    }

    private boolean isDisruptionAtDeuvBegin(Date validFrom, Date validAfter) {
        if (this.mAbsenceUntil == null) {
            return false;
        }
        if (DateHelper.before((Date)this.mAbsenceUntil, (Date)validFrom)) {
            return false;
        }
        return DateHelper.after((Date)validAfter, (Date)DateHelper.tomorrow((Date)this.mAbsenceUntil));
    }

    public void initEEAbsenttimes() throws BusinessDomainException {
        this.mAttendance = new DEUVAttendance(this);
        DEUVAbsentTime[] ats = this.mAttendance.getDEUVAbsentTimes();
        Date next = null;
        Date begin = null;
        String key = null;
        int i = 0;
        while (i < ats.length) {
            begin = ats[i].getValidFrom();
            while (i < ats.length && !this.isSeparateAbsenttime(next, ats[i], key)) {
                key = this.getKeyAtLimit(ats[i], begin, key);
                next = DateHelper.tomorrow((Date)ats[i].getValidUntil());
                ++i;
            }
            if (!DateHelper.after((Date)begin, (Date)this.getDEUVStart()) || DateHelper.before(next, (Date)this.mFirstValidFrom)) {
                this.makeAbsenceUntil(key, begin, next);
            } else {
                this.makeAbsenttime(key, begin, next);
            }
            next = null;
        }
    }

    private void makeAbsenceUntil(String key, Date begin, Date next) {
        if ("1.1".equals(key)) {
            return;
        }
        if (DEUVAttendance.FZ_EL_4_7.equals(key)) {
            this.setPaymentFrom(next);
            this.insertAbsenceTrigger(next, key, TypeOfDeuvTriggerEnum.EINTRITT_NACH_KRANK);
            return;
        }
        if (DEUVAttendance.isUndelayed((String)key)) {
            this.setPaymentFrom(next);
            this.insertAbsenceTrigger(next, key, TypeOfDeuvTriggerEnum.ANMELDUNG_FEHLZEIT);
            return;
        }
        if (this.isMonthlimit(key)) {
            Date validFrom = this.getTimeMonth(begin, next);
            if (validFrom != null) {
                this.setPaymentFrom(next);
                this.insertAbsenceTrigger(next, key, TypeOfDeuvTriggerEnum.ANMELDUNG_FEHLZEIT);
            }
            return;
        }
        if (this.isCalendary(key) && this.isCalendary(begin, next)) {
            this.setPaymentFrom(next);
            this.mAbsenceUntil = DateHelper.yesterday((Date)next);
            return;
        }
    }

    private boolean isSeparateAbsenttime(Date next, DEUVAbsentTime at, String key) {
        if (next == null) {
            return false;
        }
        if (!DateHelper.equal((Date)next, (Date)at.getValidFrom())) {
            return true;
        }
        if (key.equals(at.getDEUVAbsentTimeKey())) {
            return false;
        }
        if (this.isCalendary(key)) {
            return !this.isCalendary(at.getDEUVAbsentTimeKey());
        }
        if (this.isMonthlimit(key)) {
            return !this.isMonthlimit(at.getDEUVAbsentTimeKey());
        }
        return true;
    }

    private void makeAbsenttime(String key, Date begin, Date next) {
        if (StringMapper.isNullString((String)key)) {
            return;
        }
        if (DEUVAttendance.FZ_T_9_9.equals(key)) {
            DEUVTrigger t = this.createTrigger(begin, TypeOfDeuvTriggerEnum.FEHLZEIT_TOD);
            t.setDEUVAbsentTimeKey(key);
            this.insertApplicable(t);
            return;
        }
        if (DEUVAttendance.FZ_EL_4_7.equals(key)) {
            if (!this.isInFuture(next)) {
                this.insertAbsenceTrigger(next, key, TypeOfDeuvTriggerEnum.EINTRITT_NACH_KRANK);
            }
            return;
        }
        if (DEUVAttendance.isUndelayed((String)key)) {
            Date absenceUntil = DateHelper.yesterday((Date)next);
            this.insertAbsenceTrigger(begin, absenceUntil, key, TypeOfDeuvTriggerEnum.ABMELDUNG_FEHLZEIT);
            if (DEUVAttendance.isWithdrawalByAbsence((String)key)) {
                if (!this.isInFuture(begin)) {
                    this.insertAbsenceTrigger(next, key, TypeOfDeuvTriggerEnum.ANMELDUNG_FEHLZEIT);
                }
            } else if (!this.isInFuture(absenceUntil)) {
                this.insertAbsenceTrigger(next, key, TypeOfDeuvTriggerEnum.ANMELDUNG_FEHLZEIT);
            }
            return;
        }
        if (this.isMonthlimit(key)) {
            Date validFrom = this.getTimeMonth(begin, next);
            if (validFrom != null) {
                Date absenceUntil = DateHelper.yesterday((Date)next);
                this.insertAbsenceTrigger(validFrom, absenceUntil, key, TypeOfDeuvTriggerEnum.ABMELDUNG_FEHLZEIT);
                if (!this.isInFuture(absenceUntil)) {
                    this.insertAbsenceTrigger(next, key, TypeOfDeuvTriggerEnum.ANMELDUNG_FEHLZEIT);
                }
            }
            return;
        }
        if (this.lesserThanMonth(begin, DateHelper.yesterday((Date)next))) {
            return;
        }
        this.insertAbsenceTrigger(begin, DateHelper.yesterday((Date)next), key, TypeOfDeuvTriggerEnum.UNTERBRECHUNG_BEGINN);
        Date triggerDate = next;
        if (this.isInFuture(triggerDate)) {
            triggerDate = DateHelper.tomorrow((Date)this.mJournalizedUntil);
        }
        this.insertAbsenceTrigger(triggerDate, key, TypeOfDeuvTriggerEnum.UNTERBRECHUNG_ENDE);
    }

    private boolean lesserThanMonth(Date from, Date until) {
        return PDateHelper.inSameMonth((Date)from, (Date)until) && (!PDateHelper.isFirstDayOfMonth((Date)from) || !PDateHelper.isLastDayOfMonth((Date)until));
    }

    private boolean isInFuture(Date after) {
        return DateHelper.before((Date)this.mJournalizedUntil, (Date)after);
    }

    public boolean isCalendary(String deuvAbsenttimeKey) {
        if (deuvAbsenttimeKey == null) {
            return false;
        }
        return "4.1".equals(deuvAbsenttimeKey) || "4.2".equals(deuvAbsenttimeKey) || "4.3".equals(deuvAbsenttimeKey) || "4.4".equals(deuvAbsenttimeKey) || "4.5".equals(deuvAbsenttimeKey) || "5.1".equals(deuvAbsenttimeKey) || "6.1".equals(deuvAbsenttimeKey) || "6.2".equals(deuvAbsenttimeKey) || "6.3".equals(deuvAbsenttimeKey) || "6.4".equals(deuvAbsenttimeKey) || "8.1".equals(deuvAbsenttimeKey) || "10.9".equals(deuvAbsenttimeKey) || "1.1".equals(deuvAbsenttimeKey);
    }

    public boolean isMonthlimit(String deuvAbsenttimeKey) {
        if (deuvAbsenttimeKey == null) {
            return false;
        }
        return deuvAbsenttimeKey.startsWith("2.") || deuvAbsenttimeKey.startsWith("3.") || DEUVAttendance.FZ_FUQ_1_9_4.equals(deuvAbsenttimeKey);
    }

    private Date getTimeMonth(Date begin, Date dayAfter) {
        VDate vd1 = new VDate(begin);
        VDate vd2 = new VDate(begin).addMonths(1);
        Date validFrom = vd1.getDay() == vd2.getDay() ? vd2.getDate() : vd2.addDays(1).getDate();
        Date checkEnd = DateHelper.min((Date)dayAfter, (Date)DateHelper.tomorrow((Date)this.mJournalizedUntil));
        return DateHelper.after((Date)checkEnd, (Date)validFrom) ? validFrom : null;
    }

    private void insertAbsenceTrigger(Date validFrom, String key, TypeOfDeuvTriggerEnum type) {
        this.insertAbsenceTrigger(validFrom, null, key, type);
    }

    private void insertAbsenceTrigger(Date validFrom, Date validUntil, String key, TypeOfDeuvTriggerEnum type) {
        DEUVTrigger trigger = this.createTrigger(validFrom, type);
        trigger.setDEUVAbsentTimeKey(key);
        if (validUntil != null) {
            trigger.setValidUntil(validUntil);
        }
        this.insert(trigger);
    }

    public boolean isWithdrawal() {
        if (this.mCurrent == null) {
            D.at((Object)"miss mCurrent");
            return true;
        }
        int reason = this.mCurrent.getReasonOfDelivery();
        return reason == 30 || reason == 49;
    }

    public boolean isLeaved() {
        return this.mCurrent.isLeave();
    }

    public boolean isAbsenceHidden() {
        return this.mDisruption != null && this.mDisruption.isAbsenceHidden();
    }

    private Employment getEmploymentOrNull(Date effectiveFrom, Date validFrom) {
        return (Employment)this.mEmployee.getEmploymentHistory().getItemOrNull(effectiveFrom, validFrom);
    }

    public boolean isEntryOrEntrySI(Date validFrom) throws BusinessDomainException {
        if (validFrom == null) {
            return false;
        }
        if (DateHelper.equal((Date)validFrom, (Date)this.getCalculationHistoric())) {
            return this.isDateOfEntry(validFrom);
        }
        if (this.isEntrySi(validFrom)) {
            return true;
        }
        return this.isDateOfEntry(validFrom);
    }

    private boolean isDateOfEntry(Date validFrom) {
        Employment independ = this.getEmploymentOrNull(this.getEffectiveAfterJournalize(), validFrom);
        if (independ == null) {
            return false;
        }
        return DateHelper.equal((Date)validFrom, (Date)independ.getDateOfEntry());
    }

    private boolean isEntrySi(Date validTimePoint) throws BusinessDomainException {
        boolean result = false;
        Insurance insurance = this.getInsuranceOrNull(this.mEffectiveFrom, validTimePoint);
        if (insurance != null && DateHelper.equal((Date)insurance.getValidFrom(), (Date)validTimePoint) && insurance.isDEUVAdviceable()) {
            Insurance last = this.getInsuranceOrNull(this.mEffectiveFrom, DateHelper.yesterday((Date)validTimePoint));
            if (last == null) {
                return this.isInEmployment(DateHelper.yesterday((Date)validTimePoint));
            }
            if (!last.isDEUVAdviceable()) {
                result = true;
            }
        }
        return result;
    }

    public Insurance getInsurance(Date effectiveFrom, Date validFrom) throws BusinessDomainException {
        return this.mEmployee.getInsurance(effectiveFrom, validFrom);
    }

    public Insurance getInsuranceOrNull(Date effectiveFrom, Date validFrom) {
        return (Insurance)this.mEmployee.getInsuranceHistory().getItemOrNull(effectiveFrom, validFrom);
    }

    public Master getMaster(Date effectiveFrom, Date validFrom) throws BusinessDomainException {
        return this.mEmployee.getMaster(effectiveFrom, validFrom);
    }

    public HealthFundTP getHealthFundTP(HealthFund healthfund, Date effectiveFrom, Date validFrom) throws BusinessDomainException {
        return HealthFundPersistencyManager.getHealthFund((String)healthfund.getObjectid()).getHealthFundTP(effectiveFrom, validFrom);
    }

    public boolean isDateOfWithdrawal(Date dateOfWithdrawal) throws BusinessDomainException {
        Employment employment = this.getEmploymentOrNull(this.mEffectiveFrom, dateOfWithdrawal);
        return employment != null && DateHelper.equal((Date)employment.getDateOfWithDrawal(), (Date)dateOfWithdrawal);
    }

    public String getInsolvencyEntryReason(Date validTimePoint) {
        InsolvencyEntryReasonEnum entryReasonEnum = this.getEmploymentOrNull(this.getEffectiveAfterJournalize(), validTimePoint).getInsolvencyEntryReason();
        String entryReason = "";
        if (entryReasonEnum == InsolvencyEntryReasonEnum.IERE_E1) {
            entryReason = "13";
        } else if (entryReasonEnum == InsolvencyEntryReasonEnum.IERE_E2) {
            entryReason = "10";
        }
        return entryReason;
    }

    public boolean isInsolvencyLeaveEntry(Date validTimePoint) {
        return this.getEmploymentOrNull(this.getEffectiveAfterJournalize(), validTimePoint).getInsolvencyEntryReason() == InsolvencyEntryReasonEnum.IERE_E3;
    }

    public String getInsolvencyWithdrawalReason(Date validTimePoint) {
        InsolvencyDsmRgnReasonEnum withdrawalReasonEnum = this.getEmploymentOrNull(this.getEffectiveAfterJournalize(), validTimePoint).getInsolvencyDsmRgnReason();
        String withdrawalReason = "";
        if (withdrawalReasonEnum == InsolvencyDsmRgnReasonEnum.IDRRE_A1) {
            withdrawalReason = "33";
        } else if (withdrawalReasonEnum == InsolvencyDsmRgnReasonEnum.IDRRE_A2) {
            withdrawalReason = "30";
        } else if (withdrawalReasonEnum == InsolvencyDsmRgnReasonEnum.IDRRE_A3) {
            withdrawalReason = "71.01";
        } else if (withdrawalReasonEnum == InsolvencyDsmRgnReasonEnum.IDRRE_A4) {
            withdrawalReason = "72.01";
        }
        return withdrawalReason;
    }

    public boolean isInsolvencyLeaveCompany() throws BusinessDomainException {
        return this.mDEUVAdvice.isInsolvencyLeaveCompany();
    }

    public void makeDEUVTriggers() throws BusinessDomainException {
        DEUVTrigger dEUVTrigger;
        Date previous = null;
        boolean wasEntry = false;
        Date first = this.getFirstValidDate();
        ArrayList<DEUVTrigger> trash = new ArrayList<DEUVTrigger>();
        for (DEUVTrigger dEUVTrigger2 : this.mDEUVTriggers) {
            TypeOfDeuvTriggerEnum type = dEUVTrigger2.getTypeOfDeuvTrigger();
            Date validFrom = dEUVTrigger2.getValidFrom();
            if (type == TypeOfDeuvTriggerEnum.MITARBEITER_DATEN && !DateHelper.equal((Date)validFrom, (Date)first)) {
                validFrom = DateHelper.getFirstDayOfMonth((Date)validFrom);
                dEUVTrigger2.setValidFrom(validFrom);
            }
            if (DateHelper.before((Date)validFrom, (Date)first) && type != TypeOfDeuvTriggerEnum.UNTERBRECHUNG_BEGINN) {
                trash.add(dEUVTrigger2);
                continue;
            }
            boolean isEntry = dEUVTrigger2.isEntry();
            if (type == TypeOfDeuvTriggerEnum.UNTERBRECHUNG_BEGINN) continue;
            if (!this.isInEmployment(dEUVTrigger2, isEntry)) {
                trash.add(dEUVTrigger2);
                continue;
            }
            if (wasEntry && type == TypeOfDeuvTriggerEnum.MITARBEITER_AUSTRITT) {
                wasEntry = false;
                continue;
            }
            boolean bl = wasEntry = isEntry || type == TypeOfDeuvTriggerEnum.ANMELDUNG_FEHLZEIT || type == TypeOfDeuvTriggerEnum.EINTRITT_NACH_KRANK;
            if (previous != null && DateHelper.equal((Date)previous, (Date)validFrom)) {
                trash.add(dEUVTrigger2);
                continue;
            }
            previous = validFrom;
        }
        DEUVTrigger last = null;
        for (DEUVTrigger trigger : new ArrayList<DEUVTrigger>(this.mDEUVTriggers)) {
            if (trigger.getTypeOfDeuvTrigger() == TypeOfDeuvTriggerEnum.UNTERBRECHUNG_ENDE && last != null && last.getTypeOfDeuvTrigger() == TypeOfDeuvTriggerEnum.MITARBEITER_AUSTRITT && DateHelper.equal((Date)trigger.getValidFrom(), (Date)last.getValidFrom())) {
                int index = this.mDEUVTriggers.indexOf(trigger);
                this.mDEUVTriggers.remove(index);
                this.mDEUVTriggers.add(index - 1, trigger);
                trash.remove(trigger);
            }
            last = trigger;
        }
        this.mDEUVTriggers.removeAll(trash);
        if (!this.mDEUVTriggers.isEmpty() && (dEUVTrigger = this.mDEUVTriggers.get(0)).getTypeOfDeuvTrigger() == TypeOfDeuvTriggerEnum.UNTERBRECHUNG_BEGINN && DateHelper.beforeOrEqual((Date)dEUVTrigger.getValidFrom(), (Date)this.getDEUVStart())) {
            DEUVTrigger startTrigger = this.createTrigger(this.getDEUVStart(), TypeOfDeuvTriggerEnum.MITARBEITER_DATEN);
            startTrigger.makeReadOnly();
            this.mDEUVTriggers.add(0, startTrigger);
        }
        for (DEUVTrigger deuvTrigger : new LinkedList<DEUVTrigger>(this.mDEUVTriggers)) {
            if (!this.isWithdrawalOnFirstDayOfMonth(deuvTrigger) || this.isDateOfEntry(deuvTrigger.getValidFrom())) continue;
            DEUVTrigger additionalTrigger = this.createTrigger(deuvTrigger.getValidFrom(), TypeOfDeuvTriggerEnum.MITARBEITER_DATEN);
            additionalTrigger.makeReadOnly();
            this.mDEUVTriggers.add(this.mDEUVTriggers.indexOf(deuvTrigger), additionalTrigger);
        }
    }

    private boolean isWithdrawalOnFirstDayOfMonth(DEUVTrigger deuvTrigger) {
        return deuvTrigger.getTypeOfDeuvTrigger() == TypeOfDeuvTriggerEnum.MITARBEITER_AUSTRITT && new VDate(deuvTrigger.getValidFrom()).isFirstDayOfMonth();
    }

    private boolean isInEmployment(DEUVTrigger trigger, boolean isEntry) {
        Date validDate = trigger.getValidFrom();
        if (trigger.getTypeOfDeuvTrigger() == TypeOfDeuvTriggerEnum.ABMELDUNG_FEHLZEIT && DEUVAttendance.isWithdrawalByAbsence((String)trigger.getDEUVAbsentTimeKey())) {
            validDate = DateHelper.yesterday((Date)validDate);
        }
        return (isEntry || this.isInEmployment(validDate)) && !this.mAttendance.isWithdrawalByAbsence(validDate);
    }

    public boolean isInEmployment(Date validDate) {
        boolean result = false;
        Employment employment = this.getEmploymentOrNull(this.mEffectiveFrom, validDate);
        if (employment != null) {
            Date end = employment.getDateOfWithDrawal();
            if (DateHelper.afterOrEqual((Date)validDate, (Date)employment.getDateOfEntry()) && (end == null || DateHelper.beforeOrEqual((Date)validDate, (Date)end))) {
                result = true;
            }
        }
        return result;
    }

    private Date getLastEmploymentDate(Date validDate) {
        Date firstDate = this.getFirstValidDate();
        Date checkDate = validDate;
        Date result = null;
        while (DateHelper.afterOrEqual((Date)checkDate, (Date)firstDate)) {
            if (this.isInEmployment(checkDate) && !this.mAttendance.isWithdrawalByAbsence(checkDate)) {
                result = checkDate;
                break;
            }
            checkDate = DateHelper.yesterday((Date)checkDate);
        }
        return result;
    }

    public boolean isReason34(Date validTP) {
        return DateHelper.afterOrEqual((Date)validTP, (Date)DEUVAdvice.START_OF_2014) && this.mAttendance.isReason34(validTP);
    }

    public boolean isEelAbsence(Date validTP) {
        return this.mAttendance.isEelAbsence(validTP);
    }

    public boolean isAfterTimeMonth(Date validTP) throws BusinessDomainException {
        DEUVAbsentTime[] absentTimes;
        boolean result = false;
        for (DEUVAbsentTime absentTime : absentTimes = this.mAttendance.getDEUVAbsentTimes()) {
            if (!DateHelper.between((Date)validTP, (Date)absentTime.getValidFrom(), (Date)absentTime.getValidUntil())) continue;
            Date timePoint = this.getTimeMonth(absentTime.getValidFrom(), validTP);
            if (timePoint == null) break;
            result = true;
            break;
        }
        return result;
    }

    public void makeResults() throws BusinessDomainException {
        this.removeOldMessages();
        this.mResults.clear();
        Collections.sort(this.mCreateds, ACCOUNT_COMPARATOR);
        this.mMergeIterator = this.mCreateds.iterator();
        Iterator<DEUVAccount> it = this.getReferences().iterator();
        while (it.hasNext()) {
            DEUVAccount reference = it.next();
            reference = this.skipModifications(it, reference);
            DEUVAccount[] inserts = this.getInsertsTo(reference);
            for (int i = 0; i < inserts.length; ++i) {
                this.resume(inserts[i]);
            }
            this.resume(this.getCreatedAt(reference), reference);
        }
        if (this.mMerge != null) {
            this.resume(this.mMerge);
            this.mMerge = null;
        }
        while (this.mMergeIterator.hasNext()) {
            this.resume(this.mMergeIterator.next());
            this.mMerge = null;
        }
        this.makeObsoleteResults();
        this.makePersonalData();
        this.removeSeparatedEgaCancellations();
    }

    private void removeSeparatedEgaCancellations() throws BusinessDomainException {
        LinkedList<DEUVAccount> stored = new LinkedList<DEUVAccount>(this.mResults);
        this.orderByRecipient(this.mResults);
        while (!this.mResults.isEmpty()) {
            DEUVAccount created = this.mResults.removeFirst();
            if (!this.hasSeparatedEgaReduced(created)) continue;
            DEUVAccount reduced = this.mResults.removeFirst();
            if (!this.hasSeparatedEga(created)) continue;
            DEUVAccount separated = this.mResults.removeFirst();
            BigDecimal payment = reduced.getPayment();
            BigDecimal total = payment.add(separated.getPayment());
            reduced.setPayment(total);
            reduced.getDEUVDbme().setEntgelt(total);
            if (!reduced.compareToOld(created)) {
                reduced.destroy();
                separated.destroy();
                created.destroy();
                stored.remove((Object)reduced);
                stored.remove((Object)separated);
                stored.remove((Object)created);
                continue;
            }
            reduced.setPayment(payment);
            reduced.getDEUVDbme().setEntgelt(payment);
        }
        this.mResults.addAll(stored);
    }

    private boolean hasSeparatedEga(DEUVAccount created) {
        if (this.mResults.isEmpty() || !created.isPayment()) {
            return false;
        }
        DEUVAccount separated = this.mResults.getFirst();
        if (separated.getReasonOfDelivery() != 54 || !separated.isCancellation()) {
            return false;
        }
        Date egaMonth = separated.getValidFrom();
        Date lastMonth = created.getValidUntil();
        return PDateHelper.getDiffInMonths((Date)lastMonth, (Date)egaMonth) == 0;
    }

    private boolean hasSeparatedEgaReduced(DEUVAccount created) {
        if (this.mResults.isEmpty()) {
            return false;
        }
        DEUVAccount reduced = this.mResults.getFirst();
        return reduced.isCancellation() && created.compareToResume(reduced) == 0;
    }

    private void orderByRecipient(Collection<DEUVAccount> list) {
        ArrayList<DEUVAccount> results = new ArrayList<DEUVAccount>(list);
        Collections.sort(results, new Comparator<DEUVAccount>(){

            @Override
            public int compare(DEUVAccount acc1, DEUVAccount acc2) {
                int result;
                int type2;
                int type1 = acc1.getDEUVRecipient().getTypeOfHealthFund().value();
                int n = type1 < (type2 = acc2.getDEUVRecipient().getTypeOfHealthFund().value()) ? -1 : (result = type1 == type2 ? 0 : 1);
                if (result == 0) {
                    result = ACCOUNT_COMPARATOR.compare(acc1, acc2);
                }
                return result;
            }
        });
        list.clear();
        for (DEUVAccount deuvAccount : results) {
            list.add(deuvAccount);
        }
    }

    private void removeOldMessages() throws BusinessDomainException {
        Date firstDate = DateHelper.max((Date)this.getDEUVStart(), (Date)DEUVAdvice.NO_MESSAGES_BEFORE);
        ArrayList<DEUVAccount> trash = new ArrayList<DEUVAccount>();
        for (DEUVAccount created : this.mCreateds) {
            if (!DateHelper.before((Date)created.getValidDate(), (Date)firstDate)) continue;
            created.makeReadOnly();
            trash.add(created);
        }
        this.mCreateds.removeAll(trash);
        trash.clear();
        for (DEUVAccount reference : this.getReferences()) {
            if (!DateHelper.before((Date)reference.getValidDate(), (Date)firstDate)) continue;
            trash.add(reference);
        }
        this.getReferences().removeAll(trash);
    }

    private void makeObsoleteResults() throws BusinessDomainException {
        ArrayList<DEUVAccount> trash = new ArrayList<DEUVAccount>();
        for (DEUVAccount reference : this.getReferences()) {
            reference.updateResume(this.mCurrent);
        }
        for (DEUVAccount created : this.mCreateds) {
            if (DateHelper.before((Date)created.getValidAfter(), (Date)this.getDEUVStart())) {
                created.makeReadOnly();
            }
            if (created.isReadOnly()) {
                trash.add(created);
                continue;
            }
            created.updateResume(this.mCurrent);
        }
        this.mCreateds.removeAll(trash);
    }

    private void makePersonalData() {
        int index = this.mCreateds.size() - 1;
        if (index < 0) {
            return;
        }
        DEUVAccount last = this.mCreateds.get(index);
        if (last.makePersonalData(this.mCurrent)) {
            return;
        }
        if (--index < 0) {
            return;
        }
        DEUVAccount split = this.mCreateds.get(index);
        if (split.isSplitting()) {
            split.makePersonalData(this.mCurrent);
        }
    }

    private DEUVAccount skipModifications(Iterator<DEUVAccount> it, DEUVAccount reference) {
        while (it.hasNext() && reference.isModification()) {
            reference = it.next();
        }
        return reference;
    }

    public DEUVAccount getLastCreated() {
        ListIterator<DEUVAccount> it = this.mCreateds.listIterator(this.mCreateds.size());
        while (it.hasPrevious()) {
            DEUVAccount a = it.previous();
            if (a.isSpecialCase()) continue;
            return a;
        }
        return null;
    }

    private DEUVAccount[] getInsertsTo(DEUVAccount reference) {
        ArrayList<DEUVAccount> inserts = new ArrayList<DEUVAccount>();
        this.insertCreated(reference, inserts);
        while (this.mMerge == null && this.mMergeIterator.hasNext()) {
            this.mMerge = this.mMergeIterator.next();
            this.insertCreated(reference, inserts);
        }
        return inserts.toArray(new DEUVAccount[inserts.size()]);
    }

    private void insertCreated(DEUVAccount reference, List<DEUVAccount> inserts) {
        if (this.mMerge != null && ACCOUNT_COMPARATOR.compare(this.mMerge, reference) < 0) {
            inserts.add(this.mMerge);
            this.mMerge = null;
        }
    }

    private DEUVAccount getCreatedAt(DEUVAccount reference) {
        DEUVAccount result = null;
        if (this.mMerge != null && ACCOUNT_COMPARATOR.compare(this.mMerge, reference) == 0) {
            result = this.mMerge;
            this.mMerge = null;
        }
        return result;
    }

    private void resume(DEUVAccount created, DEUVAccount reference) throws BusinessDomainException {
        if (this.mMerge != null && ACCOUNT_COMPARATOR.compare(this.mMerge, reference) <= 0) {
            this.mMerge = null;
        }
        if (reference.getTransmitted()) {
            this.resumeTransmitted(created, reference);
        } else {
            this.resumeUntransmitted(created, reference);
        }
    }

    private void resumeUntransmitted(DEUVAccount created, DEUVAccount reference) throws BusinessDomainException {
        D.enter();
        reference.makeSaveable();
        if (!reference.isAffectedBy(this.mFirstValidFrom)) {
            this.resume(reference);
            if (created != null) {
                created.makeReadOnly();
            }
        } else {
            reference.destroy();
            if (created != null) {
                this.resume(created);
            }
        }
        D.leave();
    }

    private void resumeTransmitted(DEUVAccount created, DEUVAccount reference) throws BusinessDomainException {
        if (!reference.isAffectedBy(this.getDEUVStart())) {
            if (created != null) {
                created.makeReadOnly();
            }
        } else if (reference.isModification() && reference.compareToOldAll(created)) {
            if (created != null) {
                this.resume(created);
            }
        } else if (!reference.isModification() && reference.compareToOld(created)) {
            if (created != null) {
                this.resume(created);
            }
            DEUVAccount storno = reference.makeCancellation(this.mHasErrors, this.mDEUVAdvice);
            this.resume(storno);
            if (!StringMapper.isNullString((String)storno.getInsuranceNo())) {
                storno.setInsuranceNo(this.getInsuranceNo());
                storno.getDEUVDsme().setVersicherungsnr(storno.getInsuranceNo());
            }
            storno.invertSerialNumber();
        } else if (created != null) {
            created.makeReadOnly();
        }
    }

    private void resume(DEUVAccount created) {
        if (this.mMerge == created) {
            this.mMerge = null;
        }
        created.setSerialNumber(this.mDEUVAdvice.incrementCounter());
        created.setCreatedOn(this.mDEUVAdvice.getCreatedOn());
        if (created.isInvalid()) {
            created.makeReadOnly();
            return;
        }
        if (!created.isCancellation() && created.makeErrors(this.mHasErrors) && !created.isReadOnly()) {
            this.mHasErrors = true;
        }
        if (!created.isReadOnly()) {
            this.mResults.add(created);
        }
    }

    public Date getEffectiveFrom() {
        return this.mEffectiveFrom;
    }

    public boolean isMarriage(Date validFrom) {
        try {
            Master yesterday = this.getMaster(this.mPersonalCurrentData.getEffectiveFrom(), DateHelper.yesterday((Date)validFrom));
            Master today = this.getMaster(this.mPersonalCurrentData.getEffectiveFrom(), validFrom);
            if (today.getCivilStatus() == yesterday.getCivilStatus()) {
                return false;
            }
            if (StringMapper.equal((String)today.getSurname(), (String)yesterday.getSurname())) {
                return false;
            }
        }
        catch (BusinessDomainException e) {
            return false;
        }
        return true;
    }

    public String getCreatedOn() {
        return this.mDEUVAdvice.getCreatedOn();
    }

    public Date getCreatedOnDate() {
        return this.mDEUVAdvice.getCreatedOnDate();
    }

    public ValueInterval getPaymentPositions(String duesgroups) throws BusinessDomainException {
        if ("9001".equals(duesgroups)) {
            return this.getVoluntaryHIPositions();
        }
        int groupindex = DEUVEmployee.getGroupindex(duesgroups);
        if (this.mPaymentPositions[groupindex] == null) {
            ArrayList<Validityable> vs = new ArrayList<Validityable>();
            this.addSummaryValueTypes(groupindex, vs);
            this.addDeductionValueTypes(groupindex, vs);
            this.mPaymentPositions[groupindex] = new ValueInterval(vs.toArray(new Validityable[vs.size()]));
        }
        return this.mPaymentPositions[groupindex];
    }

    private void addSummaryValueTypes(int groupindex, List<Validityable> validityables) throws BusinessDomainException {
        ValueType[] vts = this.mDEUVAdvice.getPaymentValueTypes();
        Disjunction filters = Restrictions.disjunction((Criterion[])new Criterion[]{this.createValuePositionFilterStruct(vts[groupindex]), this.createValuePositionFilterStruct(vts[vts.length - 2]), this.createValuePositionFilterStruct(vts[vts.length - 1])});
        ValuePosition[] summaries = ValuePositionPersistencyManager.query(null, (Criterion)filters);
        validityables.addAll(Arrays.asList(summaries));
    }

    private void addDeductionValueTypes(int groupindex, List<Validityable> validityables) throws BusinessDomainException {
        ValueType[] vts = this.mDEUVAdvice.getPaymentDeductions();
        ValueType[] vtsMk = this.mDEUVAdvice.getEgaMkValueTypes();
        ValueType[] vtsMkSys = this.mDEUVAdvice.getEgaMkSysValueTypes();
        Disjunction filters = Restrictions.disjunction((Criterion[])new Criterion[]{this.createValuePositionFilterStruct(vts[0]), this.createValuePositionFilterStruct(vts[1]), this.createValuePositionFilterStruct(vtsMk[groupindex]), this.createValuePositionFilterStruct(vtsMkSys[groupindex])});
        ValuePosition[] vps = ValuePositionPersistencyManager.query(null, (Criterion)filters);
        for (int i = 0; i < vps.length; ++i) {
            ValuePosition vp = vps[i];
            validityables.add((Validityable)new ValidityableImpl(vp.getValidFrom(), vp.getValidUntil(), vp.getResult().negate()));
        }
    }

    public ValueInterval getPaymentBvPositions() throws BusinessDomainException {
        if (this.mPaymentBvPositions == null) {
            ValuePosition[] vpdeductions;
            ArrayList<ValuePosition> validityables = new ArrayList<ValuePosition>();
            Criterion filter = this.createValuePositionFilterStruct(this.mDEUVAdvice.getPaymentBvValueTypes());
            ValuePosition[] vps = ValuePositionPersistencyManager.query(null, (Criterion)filter);
            validityables.addAll(Arrays.asList(vps));
            ValueType[] vtsMk = this.mDEUVAdvice.getEgaMkValueTypes();
            ValueType[] vtsMkSys = this.mDEUVAdvice.getEgaMkSysValueTypes();
            Disjunction filters = Restrictions.disjunction((Criterion[])new Criterion[]{this.createValuePositionFilterStruct(vtsMk[4]), this.createValuePositionFilterStruct(vtsMkSys[4])});
            for (ValuePosition vp : vpdeductions = ValuePositionPersistencyManager.query(null, (Criterion)filters)) {
                validityables.add((ValuePosition)new ValidityableImpl(vp.getValidFrom(), vp.getValidUntil(), vp.getResult().negate()));
            }
            this.mPaymentBvPositions = new ValueInterval(validityables.toArray(new Validityable[validityables.size()]));
        }
        return this.mPaymentBvPositions;
    }

    private ValueInterval getLowWagePositions() throws BusinessDomainException {
        if (this.mLowWagePositions == null) {
            ValueType[] vts = this.mDEUVAdvice.getLowWageValueTypes();
            Disjunction filters = Restrictions.disjunction((Criterion[])new Criterion[]{this.createValuePositionFilterStruct(vts[0]), this.createValuePositionFilterStruct(vts[1])});
            Validityable[] vps = ValuePositionPersistencyManager.query(null, (Criterion)filters);
            this.mLowWagePositions = new ValueInterval(vps);
        }
        return this.mLowWagePositions;
    }

    private ValueInterval getOtherEmployerPositions() throws BusinessDomainException {
        if (this.mOtherEmployerPositions == null) {
            Criterion filter = this.createValuePositionFilterStruct(this.mDEUVAdvice.getOtherEmployerValueType());
            Validityable[] vps = ValuePositionPersistencyManager.query(null, (Criterion)filter);
            this.mOtherEmployerPositions = new ValueInterval(vps);
        }
        return this.mOtherEmployerPositions;
    }

    private ValueInterval getEgaPositions(int groupindex) throws BusinessDomainException {
        if (this.mEgaPositions[groupindex] == null) {
            this.mEgaPositions[groupindex] = this.getEgaPositions(groupindex, this.mEffectiveFrom);
        }
        return this.mEgaPositions[groupindex];
    }

    private ValueInterval getEgaPositions(int groupindex, Date effectiveTimePoint) throws BusinessDomainException {
        ValuePosition[] vps;
        Order[] sort = new Order[]{Order.asc((String)"validfrom")};
        ArrayList<ValuePosition> valuePositions = new ArrayList<ValuePosition>();
        ValueType[] valueTypes = this.mDEUVAdvice.getEgaValueTypes();
        Criterion filter = this.createValuePositionFilterStruct(valueTypes[groupindex], effectiveTimePoint);
        for (ValuePosition vp : ValuePositionPersistencyManager.query((Order[])sort, (Criterion)filter)) {
            valuePositions.add(vp);
        }
        valueTypes = this.mDEUVAdvice.getEgaMkSysValueTypes();
        filter = this.createValuePositionFilterStruct(valueTypes[groupindex], effectiveTimePoint);
        for (ValuePosition each : vps = ValuePositionPersistencyManager.query((Order[])sort, (Criterion)filter)) {
            valuePositions.add((ValuePosition)new ValidityableImpl(each.getValidFrom(), each.getValidUntil(), each.getResult().negate()));
        }
        return new ValueInterval(valuePositions.toArray(new Validityable[valuePositions.size()]));
    }

    private ValueInterval getEgaMk() throws BusinessDomainException {
        Order[] sort = new Order[]{Order.asc((String)"validfrom")};
        Criterion filter = this.createValuePositionFilterStruct(this.mDEUVAdvice.getValueType(130620));
        Validityable[] vps = ValuePositionPersistencyManager.query((Order[])sort, (Criterion)filter);
        return new ValueInterval(vps);
    }

    private ValueInterval getEgaMk(int groupindex) throws BusinessDomainException {
        Order[] sort = new Order[]{Order.asc((String)"validfrom")};
        Criterion filter = this.createValuePositionFilterStruct(this.mDEUVAdvice.getEgaMkValueTypes()[groupindex]);
        Validityable[] vps = ValuePositionPersistencyManager.query((Order[])sort, (Criterion)filter);
        return new ValueInterval(vps);
    }

    private ValueInterval getEgaMkSys() throws BusinessDomainException {
        Order[] sort = new Order[]{Order.asc((String)"validfrom")};
        Criterion filter = this.createValuePositionFilterStruct(this.mDEUVAdvice.getValueType(130640));
        Validityable[] vps = ValuePositionPersistencyManager.query((Order[])sort, (Criterion)filter);
        return new ValueInterval(vps);
    }

    private ValueInterval getEgaMkSys(int groupindex) throws BusinessDomainException {
        Order[] sort = new Order[]{Order.asc((String)"validfrom")};
        Criterion filter = this.createValuePositionFilterStruct(this.mDEUVAdvice.getEgaMkSysValueTypes()[groupindex]);
        Validityable[] vps = ValuePositionPersistencyManager.query((Order[])sort, (Criterion)filter);
        return new ValueInterval(vps);
    }

    private ValueInterval getMidijobBemessungPositions(int groupindex) throws BusinessDomainException {
        if (this.mMidijobBemessungPositions[groupindex] == null) {
            Criterion filter = this.createValuePositionFilterStruct(this.mDEUVAdvice.getMidijobBemessungValueTypes()[groupindex]);
            Validityable[] vps = ValuePositionPersistencyManager.query(null, (Criterion)filter);
            this.mMidijobBemessungPositions[groupindex] = new ValueInterval(vps);
        }
        return this.mMidijobBemessungPositions[groupindex];
    }

    public Criterion createValuePositionFilterStruct(ValueType[] valueTypes) {
        if (valueTypes.length == 1) {
            return this.createValuePositionFilterStruct(valueTypes[0]);
        }
        Criterion[] filters = new Criterion[valueTypes.length];
        for (int i = 0; i < valueTypes.length; ++i) {
            filters[i] = this.createValuePositionFilterStruct(valueTypes[i]);
        }
        return Restrictions.disjunction((Criterion[])filters);
    }

    public Criterion createValuePositionFilterStruct(ValueType valueType) {
        return this.createValuePositionFilterStruct(valueType, this.mEffectiveFrom);
    }

    public Criterion createValuePositionFilterStruct(ValueType valueType, Date effectiveTimePoint) {
        return Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)this.mEmployee.getObjectid()), Restrictions.eq((String)"oidvaluetype", (String)valueType.getObjectid()), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)effectiveTimePoint)), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)effectiveTimePoint))});
    }

    private Map<Date, BigDecimal> makeEgaInAbsence() throws BusinessDomainException {
        Date validFrom = DateHelper.getFirstDayOfMonth((Date)this.getFirstValidDate());
        Date validUntil = this.getJournalizedUntil();
        HashMap<Date, BigDecimal> egaBz = new HashMap<Date, BigDecimal>();
        int count = PDateHelper.countAffectedMonths((Date)validUntil, (Date)validFrom);
        for (int i = 0; i < count; ++i) {
            int index;
            Date until;
            Date from = new VDate(validFrom).addMonths(i).getDate();
            if (!this.isSocialInsuranceFree(from, until = DateHelper.getLastDayOfMonth((Date)from)) || !this.isInEmployment(from) || (index = this.getGroupindex(from)) <= -1) continue;
            BigDecimal payment = this.getEgaPositions(index).calculate(from, until);
            boolean midijob = false;
            if (BigDecimalMapper.isZero((BigDecimal)payment) && this.isMidijobRv(until) && DateHelper.afterOrEqual((Date)from, (Date)DEUVAdvice.MID_OF_2019)) {
                payment = this.getMidijobBemessungPositions(index).calculate(from, until);
                midijob = true;
            }
            if (!BigDecimalMapper.isZero((BigDecimal)payment) && this.isCompleteWithdrawalByAbsence(from, until)) {
                this.makeEgaInBz(from, payment, egaBz);
                payment = BigDecimal.ZERO;
            }
            this.makeSpecialMonth(from, until, payment, "54.01", midijob);
        }
        return egaBz;
    }

    private boolean isCompleteWithdrawalByAbsence(Date validFrom, Date validUntil) {
        boolean result = true;
        Date checkDate = validFrom;
        while (DateHelper.beforeOrEqual((Date)checkDate, (Date)validUntil)) {
            if (this.isInEmployment(checkDate) && !this.mAttendance.isWithdrawalByAbsence(checkDate)) {
                result = false;
                break;
            }
            checkDate = DateHelper.tomorrow((Date)checkDate);
        }
        return result;
    }

    private void makeEgaInBz(Date from, BigDecimal payment, Map<Date, BigDecimal> egaBz) throws BusinessDomainException {
        Date lastEmploymentDate = this.getLastEmploymentDate(from);
        if (lastEmploymentDate == null) {
            this.makeEgaBeforeCalculation(from, payment, false);
        } else {
            BigDecimal ega = payment;
            if (egaBz.containsKey(lastEmploymentDate)) {
                ega = payment.add(egaBz.get(lastEmploymentDate));
            }
            egaBz.put(lastEmploymentDate, ega);
        }
    }

    private Map<Date, BigDecimal> makeEgaMonths(ValueInterval interval, String duesgroup) throws BusinessDomainException {
        HashMap<Date, BigDecimal> result = new HashMap<Date, BigDecimal>();
        for (ValuePosition each : interval.getValuePositions()) {
            Date from = DateHelper.getFirstDayOfMonth((Date)each.getValidFrom());
            if (result.containsKey(from)) continue;
            ValueInterval ega = this.getEgaMkSys(DEUVEmployee.getGroupindex(duesgroup));
            Date until = DateHelper.getLastDayOfMonth((Date)from);
            BigDecimal payment = ega.calculate(from, until);
            result.put(from, payment);
        }
        return result;
    }

    private void makeEgaBeforeCalculation(Date month, BigDecimal ega, boolean systemChange) throws BusinessDomainException {
        Date from = DateHelper.getFirstDayOfMonth((Date)month);
        Date until = DateHelper.getLastDayOfMonth((Date)month);
        DEUVAccount account54 = new DEUVAccount();
        account54.init(this, from, until);
        account54.update(ega, "54.01");
        if (account54.isInvalid()) {
            account54.makeReadOnly();
            return;
        }
        if (systemChange) {
            account54.setSystemChangeEga(true);
        } else {
            account54.setEgaInBZ(true);
        }
        account54.getDEUVDbme().setBeginn(null);
        account54.getDEUVDbme().setEnde(null);
        this.mCreateds.add(account54);
    }

    public void makeStoerfall(Date validFrom, Date validUntil) throws BusinessDomainException {
        if (validFrom == null || validUntil == null) {
            throw new IllegalArgumentException("Must not be null, arguments: " + validFrom + ", " + validUntil);
        }
        if (this.getStoerfallMarkerPositions().isEmpty()) {
            return;
        }
        Date first = DateHelper.getFirstDayOfMonth((Date)validFrom);
        int count = PDateHelper.countAffectedMonths((Date)validUntil, (Date)first);
        for (int i = 0; i < count; ++i) {
            Date from = new VDate(first).addMonths(i).getDate();
            Date until = DateHelper.getLastDayOfMonth((Date)from);
            if (BigDecimalMapper.isZero((BigDecimal)this.getStoerfallMarkerPositions().calculate(from, until))) continue;
            BigDecimal payment = this.getStoerfallPositions().calculate(from, until);
            this.makeSpecialMonth(from, until, payment, "55.01");
        }
    }

    private void makeSpecialMonth(Date from, Date until, BigDecimal payment, String reason) throws BusinessDomainException {
        this.makeSpecialMonth(from, until, payment, reason, false);
    }

    private void makeSpecialMonth(Date from, Date until, BigDecimal payment, String reason, boolean considerMidijob) throws BusinessDomainException {
        BigDecimal paymentTruncated = DEUVAccount.truncate(payment);
        if (BigDecimalMapper.isZero((BigDecimal)paymentTruncated)) {
            return;
        }
        DEUVAccount account = new DEUVAccount();
        account.init(this, from, until);
        account.update(paymentTruncated, reason);
        if (account.isInvalid() || this.isCreated(account)) {
            account.makeReadOnly();
            return;
        }
        if (considerMidijob && DateHelper.afterOrEqual((Date)from, (Date)DEUVAdvice.MID_OF_2019) && this.isMidijobRv(until)) {
            SocialInsuranceTP siTp = this.mDEUVAdvice.getSocialInsuranceTP(from);
            BigDecimal min = siTp.getGlobal().getLowWageFrom();
            BigDecimal max = siTp.getGlobal().getLowWageUntil();
            boolean outside = false;
            if (BigDecimalMapper.compareTo((BigDecimal)payment, (BigDecimal)min) < 0 || BigDecimalMapper.compareTo((BigDecimal)payment, (BigDecimal)max) > 0) {
                outside = true;
            }
            DEUVDbme dbme = account.getDEUVDbme();
            dbme.setGleitzone(outside ? "2" : "1");
            dbme.setEntgeltRb(this.getPaymentRvMidijob(from, until));
        }
        this.addWithSplitting(account);
    }

    private boolean isCreated(DEUVAccount a) {
        for (DEUVAccount each : this.mCreateds) {
            if (each.compareToResume(a) != 0) continue;
            return true;
        }
        return false;
    }

    private int getGroupindex(Date validFrom) throws BusinessDomainException {
        int result = -1;
        Insurance insurance = this.getInsuranceOrNull(this.mEffectiveFrom, validFrom);
        if (insurance != null) {
            result = DEUVEmployee.getGroupindex(insurance.getDuesGroups());
        }
        return result;
    }

    private static final int getGroupindex(String duesgroups) {
        if (duesgroups.charAt(1) != '0') {
            return 0;
        }
        if (duesgroups.charAt(2) != '0') {
            return 1;
        }
        if (duesgroups.charAt(0) != '0') {
            return 2;
        }
        return 3;
    }

    public void makeLeave(DEUVAccount leave) throws BusinessDomainException {
        Date absenceFrom;
        if (this.isAbsenceHidden() && !DateHelper.equal((Date)(absenceFrom = DateHelper.tomorrow((Date)this.mDisruption.getValidUntil())), (Date)leave.getValidFrom())) {
            this.mDisruption.makeSaveable();
            this.addCurrent(this.mDisruption);
            leave.setValidAfter(this.mDisruption.getValidUntil());
        }
        leave.makeLeave(this.mAbsenceUntil);
        this.addCurrent(leave);
        this.mAbsenceUntil = null;
    }

    public Date getAbsenceUntil() {
        return this.mAbsenceUntil;
    }

    public void setAbsenceUntil(Date absenceUntil) {
        this.mAbsenceUntil = absenceUntil;
    }

    public void clearAbsenceUntil() {
        this.mAbsenceUntil = null;
    }

    public Date getPaymentFrom() {
        return this.mCurrent.getValidFrom();
    }

    public void setPaymentFromByAbsenceUntil() {
        if (this.mAbsenceUntil == null) {
            return;
        }
        Date afterAbsence = DateHelper.tomorrow((Date)this.mAbsenceUntil);
        if (DateHelper.after((Date)afterAbsence, (Date)this.mCurrent.getValidFrom())) {
            this.setPaymentFrom(afterAbsence);
        }
    }

    public void setPaymentFrom(Date nextBegin) {
        this.mCurrent.setValidFrom(nextBegin);
        if (this.mAbsenceUntil != null && DateHelper.after((Date)nextBegin, (Date)this.mAbsenceUntil)) {
            this.mAbsenceUntil = null;
        }
    }

    public boolean ignoreFuture(Date validFrom) {
        Date after = DateHelper.tomorrow((Date)this.mJournalizedUntil);
        if (DateHelper.compare((Date)validFrom, (Date)after) > 0) {
            D.at((Object)(DateMapper.toString((Date)validFrom) + " validFrom > journalizedUntil + 1 day"));
            return true;
        }
        return false;
    }

    public Date getCalculationStart() throws BusinessDomainException {
        return this.mDEUVAdvice.getCalculationStart();
    }

    public boolean isCalendary(Date beginDate, Date dayAfter) {
        boolean result = false;
        Date checkEnd = DateHelper.min((Date)dayAfter, (Date)DateHelper.tomorrow((Date)this.mJournalizedUntil));
        VDate beginn = new VDate(beginDate);
        if (beginn.getDay() == 1 && DateHelper.afterOrEqual((Date)checkEnd, (Date)beginn.addMonths(1).getDate())) {
            result = true;
        } else if (DateHelper.afterOrEqual((Date)checkEnd, (Date)DateHelper.getFirstDayOfMonth((Date)beginn.addMonths(2).getDate()))) {
            result = true;
        }
        return result;
    }

    public Date getDEUVStart() {
        return this.mDEUVAdvice.getDEUVStart();
    }

    private Date getFirstValidDate() {
        return DateHelper.max((Date)this.getDEUVStart(), (Date)this.mEmployee.getMinimumDateOfEntry());
    }

    private ValueInterval getLowWagePositions(Date validFrom, Date validUntil) throws BusinessDomainException {
        ArrayList<ValuePosition> vps = new ArrayList<ValuePosition>();
        for (ValuePosition vp : this.getLowWagePositions().getValuePositions()) {
            if (!PDateHelper.isIntersection((Date)vp.getValidFrom(), (Date)vp.getValidUntil(), (Date)validFrom, (Date)validUntil) || BigDecimalMapper.isZeroOrNull((BigDecimal)vp.getResult())) continue;
            vps.add(vp);
        }
        return new ValueInterval((Validityable[])vps.toArray(new ValuePosition[vps.size()]));
    }

    public String getLowWageType(Date validFrom, Date validUntil) throws BusinessDomainException {
        ValueInterval lowWageVi = this.getLowWagePositions(validFrom, validUntil);
        if (lowWageVi.isEmpty()) {
            return "0";
        }
        Date from = validFrom;
        boolean outside = false;
        while (DateHelper.beforeOrEqual((Date)from, (Date)validUntil)) {
            SocialInsuranceTP siTp = this.mDEUVAdvice.getSocialInsuranceTP(from);
            BigDecimal min = siTp.getGlobal().getLowWageFrom();
            BigDecimal max = siTp.getGlobal().getLowWageUntil();
            Date until = DateHelper.getLastDayOfMonth((Date)from);
            BigDecimal payment = lowWageVi.calculate(from, until);
            if (!BigDecimalMapper.isZeroOrNull((BigDecimal)payment)) {
                BigDecimal siDays = this.getSIDayPositions().calculate(ValueInterval.Field.FACTOR1, DateHelper.getFirstDayOfMonth((Date)from), until);
                if (BigDecimalMapper.compareTo((BigDecimal)THIRTY, (BigDecimal)siDays) != 0) {
                    payment = payment.multiply(THIRTY).divide(siDays, RoundingMode.HALF_UP);
                }
                payment = payment.add(this.getOtherEmployerPositions().calculate(from, until));
            }
            if (BigDecimalMapper.compareTo((BigDecimal)payment, (BigDecimal)min) < 0 || BigDecimalMapper.compareTo((BigDecimal)payment, (BigDecimal)max) > 0) {
                outside = true;
                break;
            }
            from = PDateHelper.getFirstDayNextMonth((Date)from);
        }
        if (outside) {
            return "2";
        }
        return "1";
    }

    public BigDecimal getPaymentRvMidijob(Date validFrom, Date validUntil) throws BusinessDomainException {
        BigDecimal result = BigDecimal.ZERO;
        ValueInterval lowWageVi = this.getLowWagePositions(validFrom, validUntil);
        ValueInterval lowWageAdditionalVi = this.getAtzZbeAndKugPositions();
        ValueInterval viPayment = this.getPaymentPositions("0100");
        Date from = validFrom;
        while (DateHelper.beforeOrEqual((Date)from, (Date)validUntil)) {
            Date until = DateHelper.min((Date)DateHelper.getLastDayOfMonth((Date)from), (Date)validUntil);
            BigDecimal payment = lowWageVi.calculate(from, until);
            payment = BigDecimalMapper.isZero((BigDecimal)payment) ? viPayment.calculate(from, until) : payment.add(lowWageAdditionalVi.calculate(from, until));
            result = result.add(payment);
            from = PDateHelper.getFirstDayNextMonth((Date)from);
        }
        return result;
    }

    public DEUVAccount makeContinuedDEUVBegin() throws BusinessDomainException {
        D.enter();
        Date validFrom = this.getDEUVStart();
        Date first = DateHelper.getFirstDayOfYear((Date)new VDate(validFrom).addDays(-1).getDate());
        Date afterAbsence = this.getPaymentFrom();
        if (afterAbsence != null && DateHelper.after((Date)afterAbsence, (Date)first)) {
            first = afterAbsence;
        }
        DEUVAccount result = new DEUVAccount();
        result.init(this, first);
        result.create();
        ArrayList<Date> dates = new ArrayList<Date>();
        Employment[] es = this.mEmployee.getEmploymentHistory(this.mEffectiveFrom);
        for (int i = 0; i < es.length; ++i) {
            this.insertBetween(dates, es[i].getValidFrom(), first, validFrom);
        }
        Insurance[] is = this.mEmployee.getInsuranceHistory(this.mEffectiveFrom);
        for (int i = 0; i < is.length; ++i) {
            this.insertBetween(dates, is[i].getValidFrom(), first, validFrom);
        }
        for (Date date : dates) {
            result = this.checkChangeAdvice(result, date);
        }
        D.leave();
        return result;
    }

    private void insertBetween(List<Date> dates, Date date, Date before, Date after) {
        if (!DateHelper.after((Date)date, (Date)before) || !DateHelper.before((Date)date, (Date)after)) {
            return;
        }
        int pos = Collections.binarySearch(dates, date);
        if (pos < 0) {
            pos = -pos - 1;
            dates.add(pos, date);
        }
    }

    private DEUVAccount checkChangeAdvice(DEUVAccount previous, Date validFrom) throws BusinessDomainException {
        DEUVAccount result = new DEUVAccount();
        result.init(this, validFrom);
        if (result.create() && (this.isEntryOrEntrySI(validFrom) || result.compareToOldState(previous))) {
            previous.makeReadOnly();
            return result;
        }
        result.makeReadOnly();
        return previous;
    }

    public boolean isDisruption(Date validFrom) throws BusinessDomainException {
        if (!this.isAbsenceHidden()) {
            return false;
        }
        Date absenceFrom = this.mDisruption.getValidAfter();
        if (DateHelper.equal((Date)validFrom, (Date)absenceFrom)) {
            return false;
        }
        return this.isCalendary(absenceFrom, DateHelper.tomorrow((Date)this.mAbsenceUntil)) || this.isDateOfWithdrawal(this.mAbsenceUntil);
    }

    public boolean isLeavedOrInvalid() {
        return this.isLeaved() || this.mCurrent.isInvalid();
    }

    public boolean isCalendaryReason() {
        if (this.mDisruption == null) {
            return false;
        }
        return this.mDisruption.isCalendaryReason();
    }

    public DEUVRecipient getPromptRecipient() throws BusinessDomainException {
        return this.mDEUVAdvice.getPromptRecipient();
    }

    public boolean isPromptRequired(Date validFrom) throws BusinessDomainException {
        Settings s = this.getPlantOrCompanySettings(validFrom);
        return s.getPromptDEUVAccount();
    }

    public boolean isInvalid() {
        return this.mCurrent.isInvalid();
    }

    public boolean isInvalidOrInsignificant() {
        return this.mCurrent.isInvalidOrInsignificant();
    }

    public void makeAnnualDisruption(DEUVAccount payment) {
        Date minimumAbsence = new VDate(payment.getValidUntil()).addMonths(1).getDate();
        if (this.mDisruption == null || !DateHelper.equal((Date)this.mDisruption.getValidFrom(), (Date)payment.getValidFrom()) || DateHelper.before((Date)this.mAbsenceUntil, (Date)minimumAbsence)) {
            return;
        }
        payment.setLongReasonOfDeliv(this.mDisruption.getLongReasonOfDeliv());
        payment.setReasonOfDelivery(this.mDisruption.getReasonOfDelivery());
    }

    public String getInsuranceNo() {
        return this.mPersonalCurrentData.getInsuranceNo();
    }

    public DEUVDbna fill(DEUVDbna dbna, Date validFrom) {
        dbna.setAenderung(this.isMarriage(validFrom) ? "A" : null);
        return (DEUVDbna)this.mPersonalCurrentData.fill((IDbnaData)dbna);
    }

    public DEUVDbgb fill(DEUVDbgb dbgb) {
        return (DEUVDbgb)this.mPersonalCurrentData.fill((IDbgbData)dbgb);
    }

    public Date getValidAfter() {
        return this.mCurrent.getValidAfter();
    }

    public boolean isEntryAs13(Date validFrom) {
        if (!DateHelper.equal((Date)DateMapper.toDate((String)"2008-01-01"), (Date)validFrom)) {
            return false;
        }
        return "243939204663955438".equals(this.mEmployee.getPCompany().getObjectid());
    }

    public DEUVDban fill(DEUVDban dban) {
        return (DEUVDban)this.mPersonalCurrentData.fill((IDbanData)dban);
    }

    public void makeStoerfall() throws BusinessDomainException {
        Date validAfter = this.mCurrent.getValidAfter();
        if (validAfter == null) {
            return;
        }
        this.makeStoerfall(validAfter, this.mJournalizedUntil);
    }

    private ValueInterval getStoerfallMarkerPositions() throws BusinessDomainException {
        if (this.mStoerfallMarkerPositions == null) {
            ValueType[] vts = this.mDEUVAdvice.getStoerfallValueTypes();
            Criterion filters = this.createValuePositionFilterStruct(vts[0]);
            Validityable[] vps = ValuePositionPersistencyManager.query(null, (Criterion)filters);
            this.mStoerfallMarkerPositions = new ValueInterval(vps);
        }
        return this.mStoerfallMarkerPositions;
    }

    private ValueInterval getStoerfallPositions() throws BusinessDomainException {
        if (this.mStoerfallPositions == null) {
            ValueType[] vts = this.mDEUVAdvice.getStoerfallValueTypes();
            Criterion filters = this.createValuePositionFilterStruct(vts[1]);
            Validityable[] vps = ValuePositionPersistencyManager.query(null, (Criterion)filters);
            this.mStoerfallPositions = new ValueInterval(vps);
        }
        return this.mStoerfallPositions;
    }

    private ValueInterval getDifferencePositions() throws BusinessDomainException {
        if (this.mDifferencePositions == null) {
            Criterion filters = this.createValuePositionFilterStruct(this.mDEUVAdvice.getDifferenceValueTypes());
            Validityable[] vps = ValuePositionPersistencyManager.query(null, (Criterion)filters);
            this.mDifferencePositions = new ValueInterval(vps);
        }
        return this.mDifferencePositions;
    }

    private ValueInterval getAtzZbeAndKugPositions() throws BusinessDomainException {
        if (this.mAtzZbeAndKugPositions == null) {
            Disjunction filters = Restrictions.disjunction((Criterion[])new Criterion[]{this.createValuePositionFilterStruct(this.mDEUVAdvice.getAtzZBbeValueTypes()), this.createValuePositionFilterStruct(this.mDEUVAdvice.getKugValuesTypes()), this.createValuePositionFilterStruct(this.mDEUVAdvice.getQuarantineValuesTypes())});
            Validityable[] vps = ValuePositionPersistencyManager.query(null, (Criterion)filters);
            this.mAtzZbeAndKugPositions = new ValueInterval(vps);
        }
        return this.mAtzZbeAndKugPositions;
    }

    public ValueInterval getMbbglPositions() throws BusinessDomainException {
        if (this.mMbbglPositions == null) {
            Criterion filters = this.createValuePositionFilterStruct(this.mDEUVAdvice.getMbbglGfBValueTypes());
            Validityable[] vps = ValuePositionPersistencyManager.query(null, (Criterion)filters);
            this.mMbbglPositions = new ValueInterval(vps);
        }
        return this.mMbbglPositions;
    }

    public ValueInterval getVoluntaryHIPositions() throws BusinessDomainException {
        if (this.mVoluntaryHIPositions == null) {
            Criterion filters = this.createValuePositionFilterStruct(this.mDEUVAdvice.getVoluntaryHIValueTypes());
            Validityable[] vps = ValuePositionPersistencyManager.query(null, (Criterion)filters);
            this.mVoluntaryHIPositions = new ValueInterval(vps);
        }
        return this.mVoluntaryHIPositions;
    }

    public BigDecimal getMinPaymentGfB(Date validTP) throws BusinessDomainException {
        SocialInsuranceTP siTp = this.mDEUVAdvice.getSocialInsuranceTP(validTP);
        return siTp.getGlobal().getMinimumCalculationBasisForLowIncomeEarnersAmount();
    }

    private Settings getPlantOrCompanySettings(Date validFrom) throws BusinessDomainException {
        PlantSettings ps;
        Employment em = this.mEmployee.getEmployment(VDate.getDateMax(), validFrom);
        Plant plant = em.getPlant();
        if (plant != null && (ps = plant.getPlantSettingOrNull(VDate.getDateMax(), validFrom)) != null) {
            return ps.getSettings();
        }
        PCompany pc = this.mEmployee.getPCompany();
        CompanySettings cs = pc.getCompanySettings(VDate.getDateMax(), validFrom);
        return cs.getSettings();
    }

    private String getKeyAtLimit(DEUVAbsentTime at, Date begin, String oldKey) {
        if (this.isCalendary(at.getDEUVAbsentTimeKey()) && this.isCalendary(begin, at.getValidFrom())) {
            return oldKey;
        }
        if (this.isMonthlimit(at.getDEUVAbsentTimeKey()) && this.isMonthlimit(begin, at.getValidFrom())) {
            return oldKey;
        }
        return at.getDEUVAbsentTimeKey();
    }

    private boolean isMonthlimit(Date begin, Date after) {
        return this.getTimeMonth(begin, after) != null;
    }

    public boolean isEmployee(int personnelNumber) {
        return this.mEmployee.getPersonnelnumber() == personnelNumber;
    }

    public boolean isPensionPayingEnabled(Date validFrom) {
        Date start = this.mDEUVAdvice.getPensionPayingStart();
        if (DateHelper.validate((Date)start)) {
            return DateHelper.afterOrEqual((Date)validFrom, (Date)start);
        }
        return false;
    }

    public boolean isBeginDisruption(Date validFrom) {
        for (DEUVTrigger each : this.mDEUVTriggers) {
            if (each.getTypeOfDeuvTrigger() != TypeOfDeuvTriggerEnum.UNTERBRECHUNG_BEGINN || !DateHelper.equal((Date)each.getValidFrom(), (Date)validFrom)) continue;
            return true;
        }
        return false;
    }

    public ValueInterval getSIDayPositions() throws BusinessDomainException {
        if (this.mSIDayPositions != null) {
            return this.mSIDayPositions;
        }
        Criterion filters = this.createValuePositionFilterStruct(this.mDEUVAdvice.getSIDaysValueType());
        Validityable[] vps = ValuePositionPersistencyManager.query(null, (Criterion)filters);
        this.mSIDayPositions = new ValueInterval(vps);
        return this.mSIDayPositions;
    }

    public boolean isSocialInsuranceFree(Date validFrom, Date validUntil) throws BusinessDomainException {
        Date from = DateHelper.getFirstDayOfMonth((Date)validFrom);
        Date until = DateHelper.getLastDayOfMonth((Date)validUntil);
        return BigDecimalMapper.isZero((BigDecimal)this.getSIDayPositions().calculate(ValueInterval.Field.FACTOR1, from, until));
    }

    private boolean isSocialInsFreeMonth(Date month) throws BusinessDomainException {
        return this.isSocialInsuranceFree(month, month);
    }

    private boolean isMidijobRv(Date validTP) {
        boolean result = false;
        Insurance insurance = this.getInsuranceOrNull(this.mEffectiveFrom, validTP);
        if (insurance != null) {
            result = insurance.getSpecialCategoryOfPersons() == SpecialCategoryEnum.SCE_GLEITZONENREGELUNG && !insurance.getUseTransitionBy31122022();
        }
        return result;
    }

    public int getKennzkv(DEUVAccount account) {
        int result = 0;
        if (DateHelper.afterOrEqual((Date)account.getValidFrom(), (Date)DEUVAdvice.START_OF_2022) && account.getPersongroup() == 110 && account.getReasonOfDelivery() == 10) {
            Insurance insurance = this.getInsuranceOrNull(this.getEffectiveAfterJournalize(), account.getValidDate());
            result = insurance != null && insurance.getLegalHealthFund() != null ? 1 : 2;
        }
        return result;
    }

    public void createDeuvDbst(DEUVAccount account) throws BusinessDomainException {
        Date validTP = account.getValidDate();
        if (account.getPersongroup() == 109 && this.mDEUVAdvice.isMinijobStdCompanyNo(account.getDEUVDsme().getBbnrEmpfaenger()) && (DateHelper.afterOrEqual((Date)validTP, (Date)DEUVAdvice.START_OF_2022) || account.getReasonOfDelivery() == 50 && DateHelper.equal((Date)validTP, (Date)DateHelper.yesterday((Date)DEUVAdvice.START_OF_2022))) && !account.isEntry() && account.getReasonOfDelivery() != 56) {
            DEUVDbst dbst = account.getDEUVDsme().createDbst();
            account.setDeuvDbst(dbst);
            Tax tax = this.mEmployee.getTaxOrNull(this.mEffectiveFrom, validTP);
            if (tax != null && tax.getTaxacation() == TaxacationEnum.TE_PAUSCHAL_EINHEITLICHE_PAUSCHSTEUER_GFB) {
                dbst.setSteuerart(1);
            } else {
                dbst.setSteuerart(0);
            }
            dbst.setStag(this.getEECompanyPlant(this.mEmployee, validTP).getCompanyTaxNumber());
            tax = this.mEmployee.getTaxOrNull(VDate.getDateMax(), VDate.getDateMax());
            if (tax != null) {
                dbst.setIdnran(tax.getTin());
            }
        }
    }

    public void processEgas() throws BusinessDomainException {
        Map<Date, BigDecimal> egaBz = this.makeEgaInAbsence();
        this.makeEgaMk();
        this.makeEgaSeparateGd54();
        for (Map.Entry<Date, BigDecimal> each : egaBz.entrySet()) {
            Date lastEmploymentDate = each.getKey();
            this.makeSpecialMonth(DateHelper.getFirstDayOfMonth((Date)lastEmploymentDate), DateHelper.getLastDayOfMonth((Date)lastEmploymentDate), each.getValue(), "54.01");
        }
        for (DEUVAccount account : this.mCreateds) {
            if (account.getDEUVDbme() == null) continue;
            account.setPayment(DEUVAccount.truncate(account.getPayment()));
            account.getDEUVDbme().setEntgelt(account.getPayment());
        }
    }

    private void makeEgaSeparateGd54() throws BusinessDomainException {
        for (DEUVAccount each : this.getEgaSeparateGd54Accounts()) {
            BigDecimal difference;
            BigDecimal currentEga;
            Date egaSeparateMonth = DateHelper.getFirstDayOfMonth((Date)each.getValidUntil());
            DEUVAccount reference = this.findReference(each);
            if (reference == null || !this.isGreaterOrEqualOneCent(each.getPayment()) || BigDecimalMapper.isZero((BigDecimal)(currentEga = this.getEgaPositions(this.getGroupindex(each.getValidUntil())).calculate(egaSeparateMonth, each.getValidUntil())))) continue;
            BigDecimal oldEga = this.getReferenceEga(reference, egaSeparateMonth, each.getValidUntil());
            DEUVAccount reference54 = this.findReference54(reference);
            if (reference54 != null) {
                if (DateHelper.beforeOrEqual((Date)reference54.getEffectiveFrom(), (Date)reference.getEffectiveFrom())) {
                    oldEga = oldEga.subtract(this.getSeparatedEga(reference54));
                } else {
                    oldEga = this.getReferenceEga(reference54, egaSeparateMonth, each.getValidUntil());
                    oldEga = oldEga.subtract(this.getSeparatedEga(reference54));
                }
            }
            if (DEUVAccount.truncate(difference = currentEga.subtract(oldEga)).signum() != 1) continue;
            this.makeEgaSeparateGd54(each, egaSeparateMonth, difference);
        }
    }

    private BigDecimal getSeparatedEga(DEUVAccount reference54) throws BusinessDomainException {
        Map<Date, BigDecimal> egas;
        BigDecimal egaInBz;
        BigDecimal result = reference54.getPayment();
        if (this.isGreaterOrEqualOneCent(result) && (egaInBz = (egas = this.getEgaInBz(reference54.getEffectiveFrom())).get(reference54.getValidFrom())) != null) {
            result = result.subtract(egaInBz);
        }
        return this.isGreaterOrEqualOneCent(result) ? result : BigDecimal.ZERO;
    }

    private Map<Date, BigDecimal> getEgaInBz(Date effectiveTimePoint) throws BusinessDomainException {
        HashMap<Date, BigDecimal> egaBz = new HashMap<Date, BigDecimal>();
        Order[] sort = new Order[]{Order.asc((String)"validfrom")};
        ValueType valueType = this.mDEUVAdvice.getValueType(130200);
        Criterion filter = this.createValuePositionFilterStruct(valueType, effectiveTimePoint);
        for (ValuePosition valuePosition : ValuePositionPersistencyManager.query((Order[])sort, (Criterion)filter)) {
            Date lastEmploymentDate;
            BigDecimal payment;
            int index;
            Date until;
            Date from = DateHelper.getFirstDayOfMonth((Date)valuePosition.getValidFrom());
            if (!this.isSocialInsuranceFree(from, until = DateHelper.getLastDayOfMonth((Date)from)) || !this.isCompleteWithdrawalByAbsence(from, until) || (index = this.getGroupindex(from)) < 0 || BigDecimalMapper.isZero((BigDecimal)(payment = this.getEgaPositions(index, effectiveTimePoint).calculate(from, until))) || (lastEmploymentDate = this.getLastEmploymentDate(from)) == null) continue;
            Date lastEmploymentMonth = DateHelper.getFirstDayOfMonth((Date)lastEmploymentDate);
            if (egaBz.containsKey(lastEmploymentMonth)) {
                payment = payment.add((BigDecimal)egaBz.get(lastEmploymentMonth));
            }
            egaBz.put(lastEmploymentMonth, payment);
        }
        return egaBz;
    }

    private void makeEgaMk() throws BusinessDomainException {
        EECarriedForwardSystemSI eECarriedForwardSystemSI;
        ValueInterval egaMkSv = this.getEgaMk();
        HashMap<DateInterval, BigDecimal> egaMks = new HashMap<DateInterval, BigDecimal>();
        for (ValuePosition valuePosition : egaMkSv.getValuePositions()) {
            DateInterval period = new DateInterval(valuePosition.getValidFrom(), valuePosition.getValidUntil());
            if (egaMks.containsKey(period)) continue;
            ValueInterval egaMk = this.getEgaMk(this.getGroupindex(valuePosition.getValidUntil()));
            BigDecimal payment = egaMk.calculate(period.getValidFrom(), period.getValidUntil());
            egaMks.put(period, payment);
        }
        for (Map.Entry entry : egaMks.entrySet()) {
            if (BigDecimalMapper.isZero((BigDecimal)((BigDecimal)entry.getValue()))) continue;
            Date validfrom = ((DateInterval)entry.getKey()).getValidFrom();
            Date validuntil = ((DateInterval)entry.getKey()).getValidUntil();
            if (DateHelper.before((Date)validuntil, (Date)DEUVAdvice.START_OF_2015)) {
                this.checkOldAccounts(entry);
                continue;
            }
            List<DEUVAccount> createds = this.getCreatedForPeriod(new DateInterval(validfrom, validuntil));
            if (createds.isEmpty() || createds.get(0).getReasonOfDelivery() != 30) {
                this.makeSpecialMonth(DateHelper.getFirstDayOfMonth((Date)validfrom), DateHelper.getLastDayOfMonth((Date)validuntil), (BigDecimal)entry.getValue(), "54.01");
                continue;
            }
            if (this.isSocialInsuranceFree(validfrom, validuntil)) continue;
            for (DEUVAccount account : createds) {
                BigDecimal payment = account.getPayment().add((BigDecimal)entry.getValue());
                account.setPayment(payment);
                account.updateDbme();
            }
        }
        ValueInterval egaSystemChange = this.getEgaMkSys();
        if (!egaSystemChange.isEmpty() && (eECarriedForwardSystemSI = EECarriedForwardSystemSI.getEECarriedForwardSystemSI((Employee)this.mEmployee)) != null) {
            Map<Date, BigDecimal> egaMonths = this.makeEgaMonths(egaSystemChange, eECarriedForwardSystemSI.getDuesGroups());
            for (Map.Entry<Date, BigDecimal> each : egaMonths.entrySet()) {
                BigDecimal ega = each.getValue();
                if (BigDecimalMapper.isZero((BigDecimal)ega)) continue;
                this.makeEgaBeforeCalculation(each.getKey(), each.getValue(), true);
            }
        }
    }

    private void checkOldAccounts(Map.Entry<DateInterval, BigDecimal> each) throws BusinessDomainException {
        DateInterval period = each.getKey();
        List<DEUVAccount> createds = this.getCreatedForPeriod(period);
        if (!createds.isEmpty()) {
            DEUVAccount reference = this.findReference(createds.get(0));
            BigDecimal ega54 = BigDecimalMapper.ZERO;
            BigDecimal egaCorretion = BigDecimalMapper.ZERO;
            if (reference != null) {
                if (reference.getReasonOfDelivery() != 30) {
                    BigDecimal currentEga = this.getEgaPositions(this.getGroupindex(period.getValidUntil())).calculate(period.getValidFrom(), period.getValidUntil());
                    BigDecimal oldEga = this.getReferenceEga(reference, period);
                    DEUVAccount reference54 = this.findReference54(reference);
                    if (reference54 != null && DateHelper.after((Date)reference54.getEffectiveFrom(), (Date)reference.getEffectiveFrom())) {
                        oldEga = oldEga.add(reference54.getPayment());
                    }
                    switch (BigDecimalMapper.compareTo((BigDecimal)currentEga, (BigDecimal)oldEga)) {
                        case 0: {
                            if (reference54 != null) {
                                ega54 = reference54.getPayment();
                            }
                            egaCorretion = each.getValue().subtract(ega54);
                            break;
                        }
                        case -1: 
                        case 1: {
                            ega54 = each.getValue();
                            egaCorretion = each.getValue().subtract(ega54);
                            break;
                        }
                    }
                } else {
                    egaCorretion = each.getValue();
                }
            } else {
                ega54 = each.getValue();
            }
            if (!BigDecimalMapper.isZero((BigDecimal)ega54)) {
                this.makeSpecialMonth(DateHelper.getFirstDayOfMonth((Date)period.getValidFrom()), DateHelper.getLastDayOfMonth((Date)period.getValidUntil()), ega54, "54.01");
            }
            if (!BigDecimalMapper.isZero((BigDecimal)egaCorretion)) {
                for (DEUVAccount account : createds) {
                    BigDecimal payment = account.getPayment().add(egaCorretion);
                    account.setPayment(payment);
                    account.updateDbme();
                }
            }
        }
    }

    private DEUVAccount findReference(DEUVAccount account) throws BusinessDomainException {
        for (DEUVAccount each : this.getReferences()) {
            if (account.compareToResume(each) != 0) continue;
            return each;
        }
        return null;
    }

    private BigDecimal getReferenceEga(DEUVAccount reference, DateInterval period) throws BusinessDomainException {
        return this.getReferenceEga(reference, period.getValidFrom(), period.getValidUntil());
    }

    private BigDecimal getReferenceEga(DEUVAccount reference, Date validFrom, Date validUntil) throws BusinessDomainException {
        Date effectiveOld = DateHelper.max((Date)reference.getEffectiveFrom(), (Date)reference.getValidUntil());
        return this.getEgaPositions(this.getGroupindex(validUntil), effectiveOld).calculate(validFrom, validUntil);
    }

    private DEUVAccount findReference54(DEUVAccount account) throws BusinessDomainException {
        for (DEUVAccount each : this.getReferences()) {
            if (each.getReasonOfDelivery() != 54 || !DateHelper.equal((Date)each.getValidUntil(), (Date)DateHelper.getLastDayOfMonth((Date)account.getValidUntil()))) continue;
            return each;
        }
        return null;
    }

    private List<DEUVAccount> getCreatedForPeriod(DateInterval period) {
        ArrayList<DEUVAccount> result = new ArrayList<DEUVAccount>();
        ListIterator<DEUVAccount> iterator = this.mCreateds.listIterator(this.mCreateds.size());
        block0: while (iterator.hasPrevious()) {
            DEUVAccount current = iterator.previous();
            if (!current.isPayment() || !period.isIntersection(current.getValidFrom(), current.getValidUntil()) || DateHelper.after((Date)current.getValidFrom(), (Date)DateHelper.getFirstDayOfMonth((Date)current.getValidUntil())) && BigDecimalMapper.isZero((BigDecimal)current.getPayment())) continue;
            result.add(current);
            while (iterator.hasPrevious()) {
                DEUVAccount previous = iterator.previous();
                if (!DateHelper.equal((Date)current.getValidFrom(), (Date)previous.getValidFrom()) || !DateHelper.equal((Date)current.getValidUntil(), (Date)previous.getValidUntil()) || current.getDEUVDsme().getBbnrKrankenkasse().equals(previous.getDEUVDsme().getBbnrKrankenkasse())) break block0;
                result.add(previous);
            }
            break block0;
        }
        return result;
    }

    private boolean isGreaterOrEqualOneCent(BigDecimal ega) {
        return BigDecimalMapper.compareTo((BigDecimal)ega, (BigDecimal)BigDecimal.ONE.setScale(2)) >= 0;
    }

    private void makeEgaSeparateGd54(DEUVAccount account, Date validDate, BigDecimal ega) throws BusinessDomainException {
        Date from = DateHelper.getFirstDayOfMonth((Date)validDate);
        Date until = DateHelper.getLastDayOfMonth((Date)validDate);
        DEUVAccount account54 = new DEUVAccount();
        account54.init(this, from, until);
        account54.update(ega, "54.01");
        if (account54.isInvalid()) {
            account54.makeReadOnly();
            return;
        }
        if (account.isSplitting() && account.getDEUVRecipient().getTypeOfHealthFund() == TypeOfHealthFundEnum.TOHF_KNAPPSCHAFT) {
            account54.updateSplitting();
        }
        if (account.getDEUVRecipient().getTypeOfHealthFund() == TypeOfHealthFundEnum.TOHF_VERSORGUNG) {
            account54.setDEUVRecipient(account.getDEUVRecipient());
            account54.updatePensionPayingInstitution();
        }
        this.mCreateds.add(account54);
        BigDecimal payment = account.getPayment().subtract(DEUVAccount.truncate(ega));
        account.setPayment(payment);
        account.updateDbme();
    }

    private List<DEUVAccount> getEgaSeparateGd54Accounts() throws BusinessDomainException {
        ArrayList<DEUVAccount> results = new ArrayList<DEUVAccount>();
        for (DEUVAccount each : this.mCreateds) {
            if (!this.isEgaSeparateGd54(each) || this.isSocialInsFreeMonth(each.getValidUntil())) continue;
            results.add(each);
        }
        return results;
    }

    public boolean isEgaSeparateGd54(DEUVAccount account) {
        return DateHelper.afterOrEqual((Date)account.getValidUntil(), (Date)DEUVAccount.BEGIN_OF_SEPARATE_EGA_GD54) && account.getReasonOfDelivery() == 30 || account.getReasonOfDelivery() == 49;
    }

    public Insurance getSplittedInsurance(Date insuranceDate, boolean entry) {
        EESuccessor[] successor;
        Employee splitEmployee = null;
        if (entry) {
            if (DateHelper.equal((Date)insuranceDate, (Date)this.getEmployee().getMinimumDateOfEntry()) && (successor = this.getEESuccessorPM().query(null, Restrictions.eq((String)"OIDSUCCESSOR", (String)this.getEmployee().getObjectid()))).length == 1) {
                splitEmployee = successor[0].getEmployee();
            }
        } else if (DateHelper.equal((Date)insuranceDate, (Date)this.getEmployee().getLastDateOfWithdrawal()) && (successor = this.getEESuccessorPM().query(null, Restrictions.eq((String)"OIDEMPLOYEE", (String)this.getEmployee().getObjectid()))).length == 1) {
            splitEmployee = successor[0].getSuccessor();
        }
        Insurance result = null;
        if (splitEmployee != null) {
            Date splitDate = entry ? DateHelper.yesterday((Date)insuranceDate) : DateHelper.tomorrow((Date)insuranceDate);
            result = (Insurance)splitEmployee.getInsuranceHistory().getItemOrNull(this.mEffectiveFrom, splitDate);
        }
        return result;
    }

    public int reasonBy(Insurance splitted, Date insuranceDate, boolean entry) {
        String lawAreaSplitted;
        Insurance insurance = this.getInsuranceOrNull(this.mEffectiveFrom, insuranceDate);
        if (!this.equals(splitted.getHealthFund(), insurance.getHealthFund())) {
            return 1;
        }
        if (CompareToOldUtil.isDifferent((String)splitted.getDuesGroups(), (String)insurance.getDuesGroups())) {
            return 2;
        }
        if (CompareToOldUtil.isDifferent((int)splitted.getPersonGroup(), (int)insurance.getPersonGroup())) {
            return 3;
        }
        if (!this.equals(splitted.getRecipient(), insurance.getRecipient())) {
            return 3;
        }
        Date splitDate = entry ? DateHelper.yesterday((Date)insuranceDate) : DateHelper.tomorrow((Date)insuranceDate);
        String lawArea = this.getLawArea(this.getEmployee(), insuranceDate);
        if (CompareToOldUtil.isDifferent((String)lawArea, (String)(lawAreaSplitted = this.getLawArea(splitted.getEmployee(), splitDate)))) {
            return 3;
        }
        return 0;
    }

    private boolean equals(Object value1, Object value2) {
        if (value1 == value2) {
            return true;
        }
        return value1 != null && value1.equals(value2);
    }

    public boolean isPGSIncluded(int pgsToCheck, int ... validPgs) {
        for (int pgs : validPgs) {
            if (pgsToCheck != pgs) continue;
            return true;
        }
        return false;
    }

    private String getLawArea(Employee employee, Date validDate) {
        return this.getEECompanyPlant(employee, validDate).getLawArea();
    }

    private IEECompanyPlant getEECompanyPlant(Employee employee, Date validDate) {
        IEECompanyPlant companyPlant = (IEECompanyPlant)UtilitiesManager.getBean((String)"eeCompanyPlant", IEECompanyPlant.class);
        companyPlant.setEmployee(employee);
        companyPlant.setEffectiveFrom(this.getEffectiveFrom());
        companyPlant.setValidFrom(validDate);
        return companyPlant;
    }

    public boolean getDeclarationByBreak() {
        DEUVSenderTP tp = this.mDEUVAdvice.getDEUVSenderTP();
        return tp.getDeclarationByBreak();
    }

    public Date getCalculationHistoric() throws BusinessDomainException {
        return this.mDEUVAdvice.getCalculationHistoric();
    }

    public Collection<DEUVAccount> getResult() {
        return Collections.unmodifiableCollection(this.mResults);
    }

    private IEESuccessorPersistencyManager getEESuccessorPM() {
        return (IEESuccessorPersistencyManager)UtilitiesManager.getBean((String)"eeSuccessorPersistencyManager", IEESuccessorPersistencyManager.class);
    }

    private static IRvbeaDxarPersistencyManager getRvbeaDxarPM() {
        return (IRvbeaDxarPersistencyManager)UtilitiesManager.getBean((String)"rvbeaDxarPersistencyManager", IRvbeaDxarPersistencyManager.class);
    }

    public String toString() {
        StringBuffer b = new StringBuffer(80);
        b.append(this.getClass().getSimpleName());
        b.append('[').append((Object)this.mEmployee);
        b.append(',').append(this.mDEUVTriggers);
        b.append(',').append((Object)this.mCurrent);
        b.append(',').append(this.mCreateds);
        b.append(']');
        return b.toString();
    }
}

