/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.bea.suggestion;

import com.varial.base.UtilitiesManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.criterion.Conjunction;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Order;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.absenttime.AbsentTime;
import com.varial.personnel.domain.bea.BeaAdvice;
import com.varial.personnel.domain.bea.BeaCompany;
import com.varial.personnel.domain.bea.BeaEmployee;
import com.varial.personnel.domain.bea.basics.BasicRecord;
import com.varial.personnel.domain.bea.dbab.BeaDbab;
import com.varial.personnel.domain.bea.dbag.BeaDbag;
import com.varial.personnel.domain.bea.dbsa.BeaDbsa;
import com.varial.personnel.domain.bea.preset.PreSetDsab;
import com.varial.personnel.domain.bea.preset.PreSetDseu;
import com.varial.personnel.domain.bea.preset.PreSetDsne;
import com.varial.personnel.domain.companyplant.Foundations;
import com.varial.personnel.domain.companyplant.GeneralEmploymentOffice;
import com.varial.personnel.domain.designationtype.personincharge.PersonInCharge;
import com.varial.personnel.domain.designationtype.personincharge.PersonInChargeTP;
import com.varial.personnel.domain.deuv.Deuv;
import com.varial.personnel.domain.deuv.DeuvBasics;
import com.varial.personnel.domain.deuvmessaging.DeuvHelper;
import com.varial.personnel.domain.deuvmessaging.basictypes.ContactPerson;
import com.varial.personnel.domain.employee.Employee;
import com.varial.personnel.domain.employee.IEECompanyPlant;
import com.varial.personnel.domain.employee.employment.Employment;
import com.varial.personnel.domain.employee.insurance.Insurance;
import com.varial.personnel.domain.employee.master.Master;
import com.varial.personnel.domain.employee.tax.Tax;
import com.varial.personnel.domain.employee.valueposition.ValuePosition;
import com.varial.personnel.domain.employee.valueposition.ValuePositionPersistencyManager;
import com.varial.personnel.domain.global.deuv.sender.DEUVSender;
import com.varial.personnel.domain.global.deuv.sender.DEUVSenderTP;
import com.varial.personnel.domain.pcompany.PCompany;
import com.varial.personnel.domain.pcompany.emploffice.CompanyEmploymentOffice;
import com.varial.personnel.domain.pcompany.foundations.CompanyFoundations;
import com.varial.personnel.domain.plant.Plant;
import com.varial.personnel.domain.plant.emploffice.PlantEmploymentOffice;
import com.varial.personnel.domain.plant.foundations.PlantFoundations;
import com.varial.personnel.domain.plant.place.PlantPlaceTP;
import com.varial.personnel.domain.reports.library.ReportHelper;
import com.varial.personnel.domain.statisticalvalue.StatisticalValue;
import com.varial.personnel.domain.statisticalvalue.StatisticalValueTP;
import com.varial.personnel.domain.statisticalvalue.valuetypes.ValueTypeOfStatisticalValue;
import com.varial.personnel.domain.workingtime.WorkingTime;
import com.varial.personnel.framework.basictypes.PDateHelper;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.StringMapper;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;

public class CreateSuggestionHelper {
    protected Date mGueltigFuer;
    protected PersonInCharge mBearbeiterEntgelt;
    protected PersonInCharge mBearbeiterPersonal;
    protected static final String ABSENTTIME_AU_2_8 = "AU";
    protected static final String ABSENTTIME_EKT_1_6 = "EKT";
    protected static final String ABSENTTIME_PZ_1_5 = "PZ";
    protected static final String ABSENTTIME_UBF = "UBF";
    protected final ReportHelper mReportHelper = (ReportHelper)UtilitiesManager.getBean((String)"reportHelper", ReportHelper.class);
    protected PreSetDsab mPresetDsab;
    protected PreSetDseu mPresetDseu;
    protected PreSetDsne mPresetDsne;
    protected BeaCompany mBeaCompany;
    protected BeaEmployee mBeaEmployee;
    protected PCompany mPcompany;
    protected Employee mEmployee;
    protected Date mEffectiveTimePoint;
    protected Date mValidTimePoint;
    protected PersonInChargeTP mBearbeiterEntgeltTP;
    protected PersonInChargeTP mBearbeiterPersonalTP;
    protected Master mMaster;
    protected Employment mEmployment;
    protected Tax mTax;
    protected Insurance mInsurance;
    protected Date mDateOfWithdrawal;
    protected Date mDateOfEntry;
    protected boolean mIsFiktivesAustrittsadtum;
    protected int mAnzMonths;
    protected Date[] mAbrMonatVon = null;
    protected Date[] mAbrMonatBis = null;
    protected boolean plantIsEmployer;
    protected Foundations mFoundations;
    protected WorkingTime mWorkingTime;
    protected WorkingTime mWorkingTimeOfCompany;
    protected String[] mThreeNamesOfCompanyOrPlant;
    protected GeneralEmploymentOffice mGeneralEmploymentOffice;
    protected DEUVSenderTP mDEUVSenderTP;
    protected ContactPerson mContactPerson;
    protected Date mStartOfCalculation;

    public CreateSuggestionHelper() {
    }

    public CreateSuggestionHelper(BeaAdvice advice) {
        this.mBeaCompany = advice.getBeaCompany();
        this.mBeaEmployee = advice.getBeaEmployee();
        this.mPcompany = this.mBeaCompany.getPCompany();
        this.mEmployee = this.mBeaEmployee.getEmployee();
    }

    protected void createDataset() throws BusinessDomainException {
        this.mMaster = this.mEmployee.getMaster(this.mEffectiveTimePoint, this.mValidTimePoint);
        this.mEmployment = this.mEmployee.getEmployment(this.mEffectiveTimePoint, this.mValidTimePoint);
        this.mInsurance = this.mEmployee.getInsurance(this.mEffectiveTimePoint, this.mValidTimePoint);
        CompanyFoundations companyFoundations = this.mPcompany.getCompanyFoundations(this.mEffectiveTimePoint, this.mValidTimePoint);
        this.mFoundations = companyFoundations.getFoundations();
        this.mWorkingTime = this.mFoundations.getWorkingTime();
        this.mWorkingTimeOfCompany = this.mFoundations.getWorkingTime();
        this.mDEUVSenderTP = DeuvHelper.getDeuvSender((PCompany)this.mPcompany).getDEUVSenderTP(this.mEffectiveTimePoint, this.mValidTimePoint);
        this.mContactPerson = DeuvHelper.getCommunication((DEUVSenderTP)this.mDEUVSenderTP, (DeuvHelper.TypeOfCommunication)DeuvHelper.TypeOfCommunication.EEL);
        if (this.mBearbeiterEntgelt != null) {
            this.mBearbeiterEntgeltTP = (PersonInChargeTP)this.mBearbeiterEntgelt.getHistory().getItemOrNull(this.mEffectiveTimePoint, this.mValidTimePoint);
        }
        if (this.mBearbeiterPersonal != null) {
            this.mBearbeiterPersonalTP = (PersonInChargeTP)this.mBearbeiterPersonal.getHistory().getItemOrNull(this.mEffectiveTimePoint, this.mValidTimePoint);
        }
        this.mStartOfCalculation = this.mReportHelper.getCalculationStartDate(companyFoundations);
        this.mDateOfEntry = this.mEmployment.getDateOfEntry();
    }

    protected BasicRecord fillBasicRecordOfDataSet() throws BusinessDomainException {
        BasicRecord basicRecord = new BasicRecord();
        basicRecord.setBbnrab(DeuvHelper.getDeuvSenderStdCompNo((DEUVSender)this.mBeaCompany.getDeuvSender()));
        basicRecord.setEd(this.getCreatedOnString());
        basicRecord.setVsnr(this.mBeaEmployee.getPersonalData().getInsuranceNo());
        basicRecord.setBbnrvu(this.getEECompanyPlant(VDate.getDateMax()).getCompanyNumber());
        basicRecord.setAzvu(Deuv.toAzVerursacher((String)this.mEmployee.getIDString()));
        basicRecord.setBbnras("");
        basicRecord.setDatensatzid("");
        basicRecord.setAvbeg(this.mDateOfEntry);
        basicRecord.setFekz(0);
        basicRecord.setFean(0);
        return basicRecord;
    }

    protected Date getCreatedOnDate() {
        return VDate.getCurrentLocalizedDateAndTime();
    }

    protected String getCreatedOnString() {
        return DeuvBasics.formatDEUVTimestamp((Date)this.getCreatedOnDate());
    }

    protected IEECompanyPlant getEECompanyPlant(Date validFrom) {
        IEECompanyPlant mEECompanyPlant = (IEECompanyPlant)UtilitiesManager.getBean((String)"eeCompanyPlant", IEECompanyPlant.class);
        mEECompanyPlant.setEmployee(this.mEmployee);
        mEECompanyPlant.setEffectiveFrom(this.mBeaEmployee.getEffectiveTimePoint());
        mEECompanyPlant.setValidFrom(validFrom);
        return mEECompanyPlant;
    }

    protected void initializeAbrMonth() {
        this.mAbrMonatBis[0] = this.mDateOfWithdrawal;
        this.mAbrMonatVon[0] = DateHelper.max((Date[])new Date[]{DateHelper.getFirstDayOfMonth((Date)this.mAbrMonatBis[0]), this.mDateOfEntry, this.mStartOfCalculation});
        for (int i = 1; i < this.mAnzMonths; ++i) {
            this.mAbrMonatBis[i] = DateHelper.max((Date[])new Date[]{DateHelper.yesterday((Date)this.mAbrMonatVon[i - 1]), DateHelper.getLastDayOfMonth((Date)this.mDateOfEntry), DateHelper.getLastDayOfMonth((Date)this.mStartOfCalculation)});
            this.mAbrMonatVon[i] = DateHelper.max((Date[])new Date[]{DateHelper.getFirstDayOfMonth((Date)this.mAbrMonatBis[i]), this.mDateOfEntry, this.mStartOfCalculation});
        }
    }

    protected void fillDbag(BeaDbag dbag) {
        dbag.init();
        CompanyEmploymentOffice companyEmploymentOffice = (CompanyEmploymentOffice)this.mPcompany.getCompanyEmploymentOfficeHistory().getItemOrNull(this.mEffectiveTimePoint, this.mValidTimePoint);
        Plant plant = null;
        PlantFoundations plantFoundations = null;
        PlantEmploymentOffice plantEmploymentOffice = null;
        plant = this.mEmployment.getPlant();
        if (plant != null) {
            plantEmploymentOffice = (PlantEmploymentOffice)plant.getPlantEmploymentOfficeHistory().getItemOrNull(this.mEffectiveTimePoint, this.mValidTimePoint);
        }
        this.plantIsEmployer = plant == null || plantEmploymentOffice == null ? false : (StringMapper.isNullString((String)plantEmploymentOffice.getGeneralEmploymentOffice().getEmployerNumber()) ? false : !StringMapper.equal((String)plantEmploymentOffice.getGeneralEmploymentOffice().getEmployerNumber(), (String)companyEmploymentOffice.getGeneralEmploymentOffice().getEmployerNumber()));
        if (this.plantIsEmployer) {
            this.mGeneralEmploymentOffice = plantEmploymentOffice.getGeneralEmploymentOffice();
            plantFoundations = (PlantFoundations)plant.getPlantFoundationsHistory().getItemOrNull(this.mEffectiveTimePoint, this.mValidTimePoint);
            if (plantFoundations != null) {
                this.mFoundations = plantFoundations.getFoundations();
                if (this.mFoundations.getWorkingTime() != null) {
                    this.mWorkingTime = this.mFoundations.getWorkingTime();
                }
            }
        } else {
            this.mGeneralEmploymentOffice = companyEmploymentOffice.getGeneralEmploymentOffice();
        }
        this.mThreeNamesOfCompanyOrPlant = this.mFoundations.getLongDescriptionWithNewLine().split("\\r\\n?|\\n");
        dbag.setName1ag(this.mThreeNamesOfCompanyOrPlant[0]);
        dbag.setName2ag(this.mThreeNamesOfCompanyOrPlant.length > 1 ? this.mThreeNamesOfCompanyOrPlant[1] : "");
        dbag.setName3ag(this.mThreeNamesOfCompanyOrPlant.length > 2 ? this.mThreeNamesOfCompanyOrPlant[2] : "");
        dbag.setAgldkz("D");
        dbag.setAgplz(this.mFoundations.getPostalAddress().getPostalCode());
        dbag.setAgort(this.mFoundations.getPostalAddress().getCity());
        dbag.setAgstr(this.mFoundations.getPostalAddress().getStreet());
        dbag.setAghausnr("");
        dbag.setAgadrzu(this.mFoundations.getPostalAddress().getDistrict());
        if (this.mBearbeiterEntgeltTP != null) {
            dbag.setAgape(this.mBearbeiterEntgeltTP.getLongDescription());
            dbag.setAgtele(this.mBearbeiterEntgeltTP.getTelephoneNumber());
            dbag.setAgemaile(this.mBearbeiterEntgeltTP.getEmailAddress());
        } else {
            dbag.setAgape(this.mContactPerson.getContactPerson());
            dbag.setAgtele(this.mContactPerson.getTelephoneNumber());
            dbag.setAgemaile(this.mContactPerson.getEMailAddress());
        }
        if (this.mBearbeiterPersonalTP != null) {
            dbag.setAgapp(this.mBearbeiterPersonalTP.getLongDescription());
            dbag.setAgtelp(this.mBearbeiterPersonalTP.getTelephoneNumber());
            dbag.setAgemailp(this.mBearbeiterPersonalTP.getEmailAddress());
        }
    }

    protected void fillDbab(BeaDbab dbab, PlantPlaceTP plantPlaceTP) {
        dbab.init();
        dbab.setBortldkz("D");
        dbab.setBplz(plantPlaceTP.getAddress().getPostalCode());
        dbab.setBort(plantPlaceTP.getAddress().getCity());
    }

    protected void fillDbsa(BeaDbsa dbsa, Date minDate) throws BusinessDomainException {
        dbsa.init();
        Insurance insurance = this.mEmployee.getInsurance(this.mEffectiveTimePoint, minDate);
        dbsa.setBygra(insurance.getDuesGroups());
        dbsa.setPersgra(insurance.getPersonGroup());
        if (insurance.isIncreasedDuesMinersPISheme()) {
            dbsa.setKnapprv("J");
            dbsa.setKnapprvbeg(insurance.getValidFrom());
        } else {
            dbsa.setKnapprv("N");
            dbsa.setKnapprvbeg(null);
        }
        dbsa.setTtsc(insurance.getOccupationKey(this.mValidTimePoint));
    }

    public BigDecimal[] getValueOfStatisticalValue(StatisticalValue objectOfStatisticalValue, Employee employee, Date effectiveTimePoint, Date from, Date until) throws BusinessDomainException {
        ValueTypeOfStatisticalValue[] valueTypesOfStatiscalValue;
        StatisticalValueTP statisticalValueTP;
        BigDecimal resultForFactor1 = BigDecimal.ZERO;
        BigDecimal resultForResult = BigDecimal.ZERO;
        if (objectOfStatisticalValue != null && (statisticalValueTP = (StatisticalValueTP)objectOfStatisticalValue.getHistory().getItemOrNull(effectiveTimePoint, from)) != null && (valueTypesOfStatiscalValue = statisticalValueTP.getAssignmentOfValueTypes()).length != 0) {
            ValuePosition[] vps;
            HashMap<Integer, ValueTypeOfStatisticalValue> vtOfStatiscalValueMap = new HashMap<Integer, ValueTypeOfStatisticalValue>();
            String[] valueTypeNumbersAsString = new String[valueTypesOfStatiscalValue.length];
            for (int i = 0; i < valueTypesOfStatiscalValue.length; ++i) {
                int valueTypeNumbers = valueTypesOfStatiscalValue[i].getValueType().getValueTypeKey();
                valueTypeNumbersAsString[i] = Integer.toString(valueTypeNumbers);
                vtOfStatiscalValueMap.put(valueTypeNumbers, valueTypesOfStatiscalValue[i]);
            }
            Order[] sort = new Order[]{Order.asc((String)"validfrom")};
            Conjunction filters = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)employee.getObjectid()), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)effectiveTimePoint)), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)effectiveTimePoint)), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)until)), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)from)), Restrictions.in((String)"valuetypenumber", (String[])valueTypeNumbersAsString)});
            block17: for (ValuePosition vp : vps = ValuePositionPersistencyManager.query((Order[])sort, (Criterion)filters)) {
                Date vpFrom = DateHelper.max((Date)vp.getValidFrom(), (Date)from);
                Date vpUntil = DateHelper.min((Date)vp.getValidUntil(), (Date)until);
                int months = PDateHelper.countAffectedMonths((Date)vpUntil, (Date)vpFrom);
                ValueTypeOfStatisticalValue vtOfStatiscalValue = (ValueTypeOfStatisticalValue)vtOfStatiscalValueMap.get(vp.getValueType().getValueTypeKey());
                switch (vtOfStatiscalValue.getInclusionFactor1().value()) {
                    case 1: {
                        if (months == 1) {
                            resultForFactor1 = resultForFactor1.add(vp.getFactor1());
                            break;
                        }
                        if (months <= 1) break;
                        resultForFactor1 = resultForFactor1.add(vp.getFactor1().multiply(BigDecimal.valueOf(months)));
                        break;
                    }
                    case 2: {
                        if (months == 1) {
                            resultForFactor1 = resultForFactor1.add(vp.getFactor2());
                            break;
                        }
                        if (months <= 1) break;
                        resultForFactor1 = resultForFactor1.add(vp.getFactor2().multiply(BigDecimal.valueOf(months)));
                        break;
                    }
                    case 3: {
                        if (months == 1) {
                            resultForFactor1 = resultForFactor1.add(vp.getResult());
                            break;
                        }
                        if (months <= 1) break;
                        resultForFactor1 = resultForFactor1.add(vp.getResult().multiply(BigDecimal.valueOf(months)));
                        break;
                    }
                    case 4: {
                        if (months == 1) {
                            resultForFactor1 = resultForFactor1.subtract(vp.getFactor1());
                            break;
                        }
                        if (months <= 1) break;
                        resultForFactor1 = resultForFactor1.subtract(vp.getFactor1().multiply(BigDecimal.valueOf(months)));
                        break;
                    }
                    case 5: {
                        if (months == 1) {
                            resultForFactor1 = resultForFactor1.subtract(vp.getFactor2());
                            break;
                        }
                        if (months <= 1) break;
                        resultForFactor1 = resultForFactor1.subtract(vp.getFactor2().multiply(BigDecimal.valueOf(months)));
                        break;
                    }
                    case 6: {
                        if (months == 1) {
                            resultForFactor1 = resultForFactor1.subtract(vp.getResult());
                            break;
                        }
                        if (months <= 1) break;
                        resultForFactor1 = resultForFactor1.subtract(vp.getResult().multiply(BigDecimal.valueOf(months)));
                        break;
                    }
                }
                switch (vtOfStatiscalValue.getInclusionResult().value()) {
                    case 1: {
                        if (months == 1) {
                            resultForResult = resultForResult.add(vp.getFactor1());
                            continue block17;
                        }
                        if (months <= 1) continue block17;
                        resultForResult = resultForResult.add(vp.getFactor1().multiply(BigDecimal.valueOf(months)));
                        continue block17;
                    }
                    case 2: {
                        if (months == 1) {
                            resultForResult = resultForResult.add(vp.getFactor2());
                            continue block17;
                        }
                        if (months <= 1) continue block17;
                        resultForResult = resultForResult.add(vp.getFactor2().multiply(BigDecimal.valueOf(months)));
                        continue block17;
                    }
                    case 3: {
                        if (months == 1) {
                            resultForResult = resultForResult.add(vp.getResult());
                            continue block17;
                        }
                        if (months <= 1) continue block17;
                        resultForResult = resultForResult.add(vp.getResult().multiply(BigDecimal.valueOf(months)));
                        continue block17;
                    }
                    case 4: {
                        if (months == 1) {
                            resultForResult = resultForResult.subtract(vp.getFactor1());
                            continue block17;
                        }
                        if (months <= 1) continue block17;
                        resultForResult = resultForResult.subtract(vp.getFactor1().multiply(BigDecimal.valueOf(months)));
                        continue block17;
                    }
                    case 5: {
                        if (months == 1) {
                            resultForResult = resultForResult.subtract(vp.getFactor2());
                            continue block17;
                        }
                        if (months <= 1) continue block17;
                        resultForResult = resultForResult.subtract(vp.getFactor2().multiply(BigDecimal.valueOf(months)));
                        continue block17;
                    }
                    case 6: {
                        if (months == 1) {
                            resultForResult = resultForResult.subtract(vp.getResult());
                            continue block17;
                        }
                        if (months <= 1) continue block17;
                        resultForResult = resultForResult.subtract(vp.getResult().multiply(BigDecimal.valueOf(months)));
                        continue block17;
                    }
                }
            }
        }
        return new BigDecimal[]{resultForFactor1, resultForResult};
    }

    protected int determineType(AbsentTime absentTime) {
        switch (absentTime.getDEUVAbsentTimeKey()) {
            case "9.8": {
                return 10;
            }
            case "8.1": {
                return 1;
            }
            case "6.4": {
                return 8;
            }
            case "6.3": {
                return 8;
            }
            case "6.2": {
                return 8;
            }
            case "6.1": {
                return 8;
            }
            case "5.1": {
                return 6;
            }
            case "4.6": {
                return 13;
            }
            case "4.5": {
                return 3;
            }
            case "4.4": {
                return 4;
            }
            case "4.3": {
                return 1;
            }
            case "4.2": {
                return 1;
            }
            case "4.1": {
                return 1;
            }
            case "3.2": {
                return 1;
            }
            case "3.1": {
                return 1;
            }
            case "2.9": {
                return 7;
            }
            case "2.8": {
                return 11;
            }
            case "2.5": {
                return 1;
            }
            case "2.4": {
                return 1;
            }
            case "2.3": {
                return 1;
            }
            case "2.21": {
                return 1;
            }
            case "2.20": {
                return 1;
            }
            case "2.10": {
                return 1;
            }
            case "2.1": {
                return 9;
            }
            case "10.9": {
                return 2;
            }
            case "10.10": {
                return 1;
            }
            case "1.9.5": {
                return 1;
            }
            case "1.9.4": {
                return 1;
            }
            case "1.9.1": {
                return 1;
            }
            case "1.8": {
                return 1;
            }
            case "1.7": {
                return 12;
            }
            case "1.6": {
                return 1;
            }
            case "1.5": {
                return 14;
            }
            case "1.1": {
                return 2;
            }
        }
        return 0;
    }

    protected WorkingTime getWorkingTimeOfEmployer(Date validTimePoint) throws BusinessDomainException {
        Foundations foundation = this.mEmployee.getAppurtenantFoundations(this.mEffectiveTimePoint, validTimePoint);
        if (foundation.getWorkingTime() != null) {
            return foundation.getWorkingTime();
        }
        CompanyFoundations companyFoundations = this.mPcompany.getCompanyFoundations(this.mEffectiveTimePoint, validTimePoint);
        return companyFoundations.getFoundations().getWorkingTime();
    }
}

