/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.bea.suggestion;

import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.types.date.DateHelper;
import com.varial.base.types.date.GMTCalendar;
import com.varial.personnel.domain.bea.BeaAdvice;
import com.varial.personnel.domain.bea.basics.BasicRecord;
import com.varial.personnel.domain.bea.dbab.BeaDbab;
import com.varial.personnel.domain.bea.dbag.BeaDbag;
import com.varial.personnel.domain.bea.dban.BeaDban;
import com.varial.personnel.domain.bea.dbhn.BeaDbhn;
import com.varial.personnel.domain.bea.dbna.BeaDbna;
import com.varial.personnel.domain.bea.dbnb.BeaDbnb;
import com.varial.personnel.domain.bea.dbne.BeaDbne;
import com.varial.personnel.domain.bea.dbsa.BeaDbsa;
import com.varial.personnel.domain.bea.dsne.BeaDsne;
import com.varial.personnel.domain.bea.suggestion.CreateSuggestionHelper;
import com.varial.personnel.domain.employee.valueposition.ValuePosition;
import com.varial.personnel.domain.employee.valueposition.ValuePositionHistory;
import com.varial.personnel.domain.employee.valueposition.ValuePositionPersistencyManager;
import com.varial.personnel.domain.plant.place.PlantPlaceTP;
import com.varial.personnel.domain.statisticalvalue.StatisticalValue;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.DateMapper;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;

public class CreateSuggestionDsneHelper
extends CreateSuggestionHelper {
    private StatisticalValue mStatisticalValueArbeitsStunden;
    private boolean mHeimarbeit;
    private Date mGueltigBis;

    public CreateSuggestionDsneHelper() {
    }

    public CreateSuggestionDsneHelper(BeaAdvice advice) {
        super(advice);
        this.mPresetDsne = advice.getPresetDsne();
        this.mEffectiveTimePoint = DateHelper.tomorrow((Date)this.mEmployee.getJournalizedUntil());
    }

    public BeaDsne createDsne() throws BusinessDomainException {
        this.fillFromPresetAndCheckCondition();
        super.createDataset();
        BeaDsne dsne = this.fillDsne();
        return dsne;
    }

    private void fillFromPresetAndCheckCondition() throws BusinessDomainException {
        this.mGueltigFuer = this.mPresetDsne.getGueltigFuer() == null ? DateHelper.getFirstDayOfMonth((Date)new Date()) : DateHelper.getFirstDayOfMonth((Date)this.mPresetDsne.getGueltigFuer());
        this.mGueltigBis = DateHelper.getLastDayOfMonth((Date)this.mGueltigFuer);
        this.mDateOfWithdrawal = this.mEmployee.getNextDateOfWithdrawal(this.mGueltigFuer, this.mEffectiveTimePoint);
        this.mBearbeiterEntgelt = this.mPresetDsne.getBearbeiterEntgelt();
        this.mBearbeiterPersonal = this.mPresetDsne.getBearbeiterPersonal();
        this.mStatisticalValueArbeitsStunden = null;
        this.mHeimarbeit = this.mPresetDsne.getHeimarbeit();
        this.mValidTimePoint = this.mGueltigBis;
    }

    private BeaDsne fillDsne() throws BusinessDomainException {
        BeaDsne dsne = new BeaDsne();
        dsne.setVersionsnr(3);
        BasicRecord basicRecord = this.fillBasicRecordOfDataSet();
        dsne.setBasicRecord(basicRecord);
        this.createAndFillDbna(dsne);
        this.createAndFillDban(dsne);
        this.createAndFillDbag(dsne);
        this.createAndFillDbab(dsne);
        this.createAndFillDbsa(dsne);
        this.createAndFillDbne(dsne);
        this.createAndFillDbnb(dsne);
        this.createAndFillDbhn(dsne);
        return dsne;
    }

    private BeaDbna createAndFillDbna(BeaDsne dsba) throws BusinessDomainException {
        BeaDbna result = dsba.createDbna();
        return this.mBeaEmployee.fillDbna(result);
    }

    private BeaDban createAndFillDban(BeaDsne dsba) throws BusinessDomainException {
        BeaDban result = dsba.createDban();
        return this.mBeaEmployee.fillDban(result);
    }

    private void createAndFillDbag(BeaDsne dsne) {
        BeaDbag result = dsne.createDbag();
        this.fillDbag(result);
    }

    private void createAndFillDbab(BeaDsne dsne) {
        if (!this.plantIsEmployer || this.mEmployment.getPlantPlace() == null) {
            return;
        }
        PlantPlaceTP plantPlaceTP = (PlantPlaceTP)this.mEmployment.getPlantPlace().getHistory().getItemOrNull(this.mEffectiveTimePoint, this.mValidTimePoint);
        if (plantPlaceTP == null) {
            return;
        }
        BeaDbab result = dsne.createDbab();
        this.fillDbab(result, plantPlaceTP);
    }

    private void createAndFillDbsa(BeaDsne dsne) throws BusinessDomainException {
        BeaDbsa result = dsne.createDbsa();
        this.fillDbsa(result, this.mGueltigFuer);
        result.setPersgra(0);
        result.setKnapprv(" ");
        result.setKnapprvbeg(null);
    }

    private void createAndFillDbne(BeaDsne dsne) throws BusinessDomainException {
        BeaDbne dbne = dsne.createDbne();
        dbne.init();
        dbne.setAvend(this.mDateOfWithdrawal);
        dbne.setMonatbeg(this.mGueltigFuer);
        if (DateHelper.getYear((Date)this.mDateOfEntry) == DateHelper.getYear((Date)this.mGueltigFuer) && DateHelper.getMonth((Date)this.mDateOfEntry) == DateHelper.getMonth((Date)this.mGueltigFuer)) {
            dbne.setMonatbeg(DateHelper.min((Date)this.mDateOfEntry, (Date)this.mGueltigFuer));
        }
        dbne.setMonatend(this.mGueltigBis);
        if (this.mDateOfWithdrawal != null && DateHelper.getYear((Date)this.mDateOfWithdrawal) == DateHelper.getYear((Date)this.mGueltigBis) && DateHelper.getMonth((Date)this.mDateOfWithdrawal) == DateHelper.getMonth((Date)this.mGueltigBis)) {
            dbne.setMonatend(DateHelper.min((Date)this.mDateOfWithdrawal, (Date)this.mGueltigBis));
        }
        BigDecimal[] results = this.getSVBruttoUndNetto(this.mEffectiveTimePoint, this.mGueltigFuer, this.mGueltigBis);
        dbne.setSvbreglf(results[0]);
        dbne.setSvbrege(results[1]);
        dbne.setNettolfd(results[2]);
        dbne.setNettoeinmal(results[3]);
        if (BigDecimalMapper.isZeroOrNull((BigDecimal)results[3])) {
            dbne.setSvbregebeg(null);
            dbne.setSvbregeend(null);
        } else {
            dbne.setSvbregebeg(dbne.getMonatbeg());
            dbne.setSvbregeend(dbne.getMonatend());
        }
        dbne.setAzwoech(this.mEmployee.getAppurtenantWorkingTime(this.mEffectiveTimePoint, this.mValidTimePoint).getWorkingTimeTP(this.mEffectiveTimePoint, this.mValidTimePoint).getWeeklyWorkingTime());
        dbne.setBvunfort("N");
        dbne.setBvunfortu("N");
    }

    private BigDecimal[] getSVBruttoUndNetto(Date effectiveTimePoint, Date from, Date until) throws BusinessDomainException {
        BigDecimal svBruttoLfd = BigDecimal.ZERO;
        BigDecimal svBruttoEGA = BigDecimal.ZERO;
        BigDecimal svNettoLfd = BigDecimal.ZERO;
        BigDecimal svNettoEGA = BigDecimal.ZERO;
        BigDecimal svBruttoLfdFuerNettobildung = BigDecimal.ZERO;
        BigDecimal svBruttoEGAFuerNettobildung = BigDecimal.ZERO;
        BigDecimal abzuegeLfd = BigDecimal.ZERO;
        BigDecimal abzuegeEGA = BigDecimal.ZERO;
        if (effectiveTimePoint == null || from == null || until == null) {
            return new BigDecimal[]{BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO};
        }
        ValuePositionHistory history = new ValuePositionHistory(ValuePositionPersistencyManager.queryWithOutSort((Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)this.mEmployee.getObjectid()), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)effectiveTimePoint)), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)effectiveTimePoint)), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)until)), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)from))})));
        history.sort();
        int duesGroupindex = this.getDuesGroupindex();
        block12: for (int i = 0; i < history.getSize(); ++i) {
            ValuePosition currentHistoryVP = history.getItem(i);
            switch (currentHistoryVP.getValueType().getValueTypeKey()) {
                case 130110: {
                    svBruttoLfdFuerNettobildung = svBruttoLfdFuerNettobildung.add(currentHistoryVP.getResult());
                    continue block12;
                }
                case 130200: {
                    svBruttoEGAFuerNettobildung = svBruttoEGAFuerNettobildung.add(currentHistoryVP.getResult());
                    continue block12;
                }
                case 327110: 
                case 773110: {
                    if (duesGroupindex != 0) continue block12;
                    svBruttoLfd = svBruttoLfd.add(currentHistoryVP.getResult());
                    continue block12;
                }
                case 333110: {
                    if (duesGroupindex != 1) continue block12;
                    svBruttoLfd = svBruttoLfd.add(currentHistoryVP.getResult());
                    continue block12;
                }
                case 321110: {
                    if (duesGroupindex != 2) continue block12;
                    svBruttoLfd = svBruttoLfd.add(currentHistoryVP.getResult());
                    continue block12;
                }
                case 327200: 
                case 327614: 
                case 773200: {
                    if (duesGroupindex != 0) continue block12;
                    svBruttoEGA = svBruttoEGA.add(currentHistoryVP.getResult());
                    continue block12;
                }
                case 333200: 
                case 333614: {
                    if (duesGroupindex != 1) continue block12;
                    svBruttoEGA = svBruttoEGA.add(currentHistoryVP.getResult());
                    continue block12;
                }
                case 321200: 
                case 321614: {
                    if (duesGroupindex != 2) continue block12;
                    svBruttoEGA = svBruttoEGA.add(currentHistoryVP.getResult());
                    continue block12;
                }
                case 220100: 
                case 223100: 
                case 226100: 
                case 322110: 
                case 328110: 
                case 334110: 
                case 340110: {
                    abzuegeLfd = abzuegeLfd.add(currentHistoryVP.getResult());
                    continue block12;
                }
                case 220200: 
                case 223200: 
                case 226200: 
                case 322200: 
                case 328200: 
                case 334200: 
                case 340200: {
                    abzuegeEGA = abzuegeEGA.add(currentHistoryVP.getResult());
                    continue block12;
                }
            }
        }
        svNettoLfd = svBruttoLfdFuerNettobildung.subtract(abzuegeLfd);
        svNettoEGA = svBruttoEGAFuerNettobildung.subtract(abzuegeEGA);
        return new BigDecimal[]{svBruttoLfd, svBruttoEGA, svNettoLfd, svNettoEGA};
    }

    private int getDuesGroupindex() {
        int duesGroupHI = this.mInsurance.getDuesGroupHI();
        int duesGroupPI = this.mInsurance.getDuesGroupPI();
        int duesGroupUI = this.mInsurance.getDuesGroupUI();
        if (duesGroupPI != 48 || this.mInsurance.getRecipient() != null) {
            return 0;
        }
        if (duesGroupUI != 48) {
            return 1;
        }
        if (duesGroupHI != 48) {
            return 2;
        }
        return 9;
    }

    private void createAndFillDbhn(BeaDsne dsne) {
        if (this.mHeimarbeit) {
            BeaDbhn dbhn = dsne.createDbhn();
            dbhn.init();
        }
    }

    private void createAndFillDbnb(BeaDsne dsne) throws BusinessDomainException {
        BeaDbnb dbnb = dsne.createDbnb();
        dbnb.init();
        this.setStunden(dbnb);
    }

    private void setStunden(BeaDbnb dbnb) throws BusinessDomainException {
        Date von1 = null;
        Date bis1 = null;
        BigDecimal stdProKW1 = BigDecimal.ZERO;
        Date von2 = null;
        Date bis2 = null;
        Date von3 = null;
        Date bis3 = null;
        Date von4 = null;
        Date bis4 = null;
        Date von5 = null;
        Date bis5 = null;
        Calendar calendar = GMTCalendar.getInstance();
        calendar.setTime(this.mGueltigFuer);
        int dayOfWeek = calendar.get(7);
        if (dayOfWeek > 1 && dayOfWeek < 7) {
            von1 = this.mGueltigFuer;
        } else {
            von1 = dayOfWeek == 1 ? DateHelper.add((Date)this.mGueltigFuer, (int)1) : DateHelper.add((Date)this.mGueltigFuer, (int)2);
            dayOfWeek = 2;
        }
        bis1 = DateHelper.add((Date)von1, (int)(6 - dayOfWeek));
        von2 = DateHelper.add((Date)bis1, (int)3);
        bis2 = DateHelper.add((Date)von2, (int)4);
        von3 = DateHelper.add((Date)bis2, (int)3);
        bis3 = DateHelper.add((Date)von3, (int)4);
        von4 = DateHelper.add((Date)bis3, (int)3);
        bis4 = DateHelper.add((Date)von4, (int)4);
        Date lastWorkingDateOfMonth = DateHelper.getLastDayOfMonth((Date)von1);
        calendar.setTime(lastWorkingDateOfMonth);
        if (calendar.get(7) <= 1 || calendar.get(7) >= 7) {
            lastWorkingDateOfMonth = calendar.get(7) == 1 ? DateHelper.add((Date)lastWorkingDateOfMonth, (int)-2) : DateHelper.add((Date)lastWorkingDateOfMonth, (int)-1);
        }
        if (DateHelper.before((Date)bis4, (Date)DateHelper.getLastDayOfMonth((Date)von1))) {
            von5 = DateHelper.add((Date)bis4, (int)3);
            bis5 = lastWorkingDateOfMonth;
        } else {
            bis4 = lastWorkingDateOfMonth;
        }
        stdProKW1 = this.mStatisticalValueArbeitsStunden != null ? this.getValueOfStatisticalValue(this.mStatisticalValueArbeitsStunden, this.mEmployee, this.mEffectiveTimePoint, this.mGueltigFuer, this.mGueltigBis)[0] : this.mEmployee.getAppurtenantWorkingTime(this.mEffectiveTimePoint, this.mValidTimePoint).getConcreteTargetHours(DateHelper.getFirstDayOfMonth((Date)this.mGueltigFuer), DateHelper.getLastDayOfMonth((Date)this.mGueltigBis), this.mEmployee, this.mEffectiveTimePoint, DateHelper.getFirstDayOfMonth((Date)this.mGueltigFuer), true);
        dbnb.setStu1kw(stdProKW1);
    }
}

