/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.bea.suggestion;

import com.varial.base.UtilitiesManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.criterion.Conjunction;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Order;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.bea.BeaAdvice;
import com.varial.personnel.domain.bea.basics.BasicRecord;
import com.varial.personnel.domain.bea.dbab.BeaDbab;
import com.varial.personnel.domain.bea.dbag.BeaDbag;
import com.varial.personnel.domain.bea.dban.BeaDban;
import com.varial.personnel.domain.bea.dbee.BeaDbee;
import com.varial.personnel.domain.bea.dbez.BeaDbez;
import com.varial.personnel.domain.bea.dbfz.BeaDbfz;
import com.varial.personnel.domain.bea.dbku.BeaDbku;
import com.varial.personnel.domain.bea.dbna.BeaDbna;
import com.varial.personnel.domain.bea.dbsa.BeaDbsa;
import com.varial.personnel.domain.bea.dbsb.BeaDbsb;
import com.varial.personnel.domain.bea.dbse.BeaDbse;
import com.varial.personnel.domain.bea.dseu.BeaDseu;
import com.varial.personnel.domain.bea.mapper.BeaExceptionMapper;
import com.varial.personnel.domain.bea.suggestion.CreateSuggestionHelper;
import com.varial.personnel.domain.employee.absenttime.EEAbsentTimeTP;
import com.varial.personnel.domain.employee.absenttime.EEAbsentTimeTPPersistencyManager;
import com.varial.personnel.domain.employee.insurance.IInsurancePersistencyManager;
import com.varial.personnel.domain.employee.insurance.Insurance;
import com.varial.personnel.domain.employee.tax.ITaxPersistencyManager;
import com.varial.personnel.domain.employee.tax.Tax;
import com.varial.personnel.domain.employee.valueposition.ValuePosition;
import com.varial.personnel.domain.employee.valueposition.ValuePositionHistory;
import com.varial.personnel.domain.employee.valueposition.ValuePositionPersistencyManager;
import com.varial.personnel.domain.employee.work.EEWork;
import com.varial.personnel.domain.plant.place.PlantPlaceTP;
import com.varial.personnel.domain.statisticalvalue.StatisticalValue;
import com.varial.personnel.domain.statisticalvalue.valuetypes.ValueTypeOfStatisticalValue;
import com.varial.personnel.domain.workingtime.WorkingTime;
import com.varial.personnel.framework.basictypes.PDateHelper;
import com.varial.personnel.framework.mapper.FrameWorkExceptionMapper;
import com.varial.personnel.framework.mapper.PBigDecimalMapper;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.StringMapper;
import com.varial.serverbase.persistency.PersistentObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;

public class CreateSuggestionDseuHelper
extends CreateSuggestionHelper {
    private boolean mHaetteKuendigungBetriebsbedingt;
    private StatisticalValue mStatisticalValueUrlaubsAbgeltungen;
    private StatisticalValue mStatisticalValueAbfindungen;
    private boolean mUrlAbgeltung;
    private boolean mAbfindung;
    private BigDecimal mBetragAbfindung = BigDecimal.ZERO;
    private boolean mIsUnwiderruflicheFreistellung;
    private Date mDateUnwiderruflicheFreistellung;

    public CreateSuggestionDseuHelper() {
    }

    public CreateSuggestionDseuHelper(BeaAdvice advice) {
        super(advice);
        this.mPresetDseu = advice.getPresetDseu();
        this.mEffectiveTimePoint = DateHelper.tomorrow((Date)this.mEmployee.getJournalizedUntil());
    }

    public BeaDseu createDseu() throws BusinessDomainException {
        this.fillFromPresetAndCheckCondition();
        super.createDataset();
        BeaDseu dseu = this.fillDseu();
        return dseu;
    }

    private void fillFromPresetAndCheckCondition() throws BusinessDomainException {
        this.mGueltigFuer = this.mPresetDseu.getGueltigFuer();
        if (this.mGueltigFuer == null) {
            throw FrameWorkExceptionMapper.makeInputIsMissingDomainException((String)"mGueltigFuer");
        }
        if (DateHelper.after((Date)this.mGueltigFuer, (Date)this.mEffectiveTimePoint)) {
            throw BeaExceptionMapper.makeCondtionDseuNotFulfilledDomainException("das g\u00fcltig ab der Vorgabe muss in einem journalisierten Zeitraum liegen.");
        }
        this.mDateOfWithdrawal = this.mEmployee.getNextDateOfWithdrawal(this.mGueltigFuer, this.mEffectiveTimePoint);
        if (this.mDateOfWithdrawal == null) {
            EEAbsentTimeTP[] eeAbsentTimesTP = EEAbsentTimeTPPersistencyManager.queryAll(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)this.mEmployee.getObjectid()), Restrictions.eq((String)"deleted", (String)"F"), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)this.mEffectiveTimePoint)), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)this.mEffectiveTimePoint)), Restrictions.ge((String)"validfrom", (String)DateMapper.toString((Date)this.mPresetDseu.getGueltigFuer())), Restrictions.or((Criterion)Restrictions.eq((String)"absenttimekey", (String)"AU"), (Criterion)Restrictions.eq((String)"absenttimekey", (String)"EKT"))}), (boolean)true);
            if (eeAbsentTimesTP.length == 0) {
                throw BeaExceptionMapper.makeCondtionDseuNotFulfilledDomainException("kein Austrittsdatum und keine Fehlzeit Aussteuerung im aktuellen, journalisierten Besch\u00e4ftigungszeitraum vorhanden");
            }
            this.mDateOfWithdrawal = eeAbsentTimesTP[0].getValidFrom();
            this.mIsFiktivesAustrittsadtum = true;
        }
        this.mAnzMonths = PDateHelper.countAffectedMonths((Date)this.mDateOfWithdrawal, (Date)this.mGueltigFuer);
        if (this.mAnzMonths > 24) {
            throw BeaExceptionMapper.makeCondtionDseuNotFulfilledDomainException("zwischen dem g\u00fcltig f\u00fcr der Vorgabe und dem folgenden Austritt liegen mehr als 24 Monate, " + this.mAnzMonths);
        }
        this.mHaetteKuendigungBetriebsbedingt = false;
        this.mStatisticalValueUrlaubsAbgeltungen = this.mPresetDseu.getUrlaubsAbgeltungen();
        this.mStatisticalValueAbfindungen = this.mPresetDseu.getAbfindungen();
        this.mBearbeiterEntgelt = this.mPresetDseu.getBearbeiterEntgelt();
        this.mBearbeiterPersonal = this.mPresetDseu.getBearbeiterPersonal();
        this.mAbrMonatVon = new Date[this.mAnzMonths];
        this.mAbrMonatBis = new Date[this.mAnzMonths];
        this.mValidTimePoint = this.mDateOfWithdrawal;
    }

    private BeaDseu fillDseu() throws BusinessDomainException {
        BeaDseu dseu = new BeaDseu();
        dseu.setVersionsnr(3);
        BasicRecord basicRecord = this.fillBasicRecordOfDataSet();
        dseu.setBasicRecord(basicRecord);
        this.createAndFillDbna(dseu);
        this.createAndFillDban(dseu);
        this.createAndFillDbag(dseu);
        this.createAndFillDbab(dseu);
        this.createAndFillDbse(dseu);
        this.createAndFillDbsa(dseu);
        this.createAndFillDbsb(dseu);
        this.createAndFillDbfz(dseu);
        this.createAndFillDbez(dseu);
        this.createAndFillDbee(dseu);
        this.createAndFillDbku(dseu);
        return dseu;
    }

    private BeaDbna createAndFillDbna(BeaDseu dsba) throws BusinessDomainException {
        BeaDbna result = dsba.createDbna();
        return this.mBeaEmployee.fillDbna(result);
    }

    private BeaDban createAndFillDban(BeaDseu dsba) throws BusinessDomainException {
        BeaDban result = dsba.createDban();
        return this.mBeaEmployee.fillDban(result);
    }

    private void createAndFillDbag(BeaDseu dseu) {
        BeaDbag result = dseu.createDbag();
        this.fillDbag(result);
    }

    private void createAndFillDbab(BeaDseu dseu) {
        if (!this.plantIsEmployer || this.mEmployment.getPlantPlace() == null) {
            return;
        }
        PlantPlaceTP plantPlaceTP = (PlantPlaceTP)this.mEmployment.getPlantPlace().getHistory().getItemOrNull(this.mEffectiveTimePoint, this.mValidTimePoint);
        if (plantPlaceTP == null) {
            return;
        }
        BeaDbab result = dseu.createDbab();
        this.fillDbab(result, plantPlaceTP);
    }

    private void createAndFillDbse(BeaDseu dseu) throws BusinessDomainException {
        ArrayList<BeaDbse> dbseList = new ArrayList<BeaDbse>();
        BeaDbse dbse = dseu.createDbse();
        dbse.init();
        Date beginOfYear = DateHelper.getFirstDayOfYear((Date)this.mValidTimePoint);
        Date from = DateHelper.max((Date[])new Date[]{this.mDateOfEntry, beginOfYear, this.mStartOfCalculation});
        Date until = DateHelper.getLastDayOfYear((Date)from);
        Tax tax = this.mEmployee.getTax(this.mEffectiveTimePoint, from);
        dbse.setAestedatbeg(null);
        dbse.setStkl(tax.getTaxBracket());
        dbse.setFkt(tax.getPercentageSplit());
        dbse.setKindfrb(tax.getChildRelief());
        Tax taxPrevious = tax;
        dbseList.add(dbse);
        int i = 0;
        Conjunction filters = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)this.mEmployee.getObjectid()), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)this.mEffectiveTimePoint)), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)this.mEffectiveTimePoint)), Restrictions.ge((String)"validfrom", (String)DateMapper.toString((Date)taxPrevious.getValidUntil()))});
        Tax[] taxs = ((ITaxPersistencyManager)UtilitiesManager.getBean((String)"taxPersistencyManager", ITaxPersistencyManager.class)).query(new Order[]{Order.asc((String)"validfrom")}, (Criterion)filters, true);
        while (DateHelper.before((Date)taxPrevious.getValidUntil(), (Date)VDate.getDateMax()) || DateHelper.before((Date)taxPrevious.getValidUntil(), (Date)until)) {
            if (taxs.length <= 0) continue;
            if (taxs[i].getTaxBracket() != taxPrevious.getTaxBracket() || !PBigDecimalMapper.isEqual((BigDecimal)taxs[i].getChildRelief(), (BigDecimal)taxPrevious.getChildRelief()) || !PBigDecimalMapper.isEqual((BigDecimal)taxs[i].getPercentageSplit(), (BigDecimal)taxPrevious.getPercentageSplit())) {
                dbse = dseu.createDbse();
                dbse.init();
                dbse.setAestedatbeg(taxs[i].getValidFrom());
                dbse.setStkl(taxs[i].getTaxBracket());
                dbse.setFkt(taxs[i].getPercentageSplit());
                dbse.setKindfrb(taxs[i].getChildRelief());
                dbseList.add(dbse);
            }
            taxPrevious = taxs[i];
            ++i;
        }
        dseu.setDbse(dbseList.toArray(new BeaDbse[dbseList.size()]));
    }

    private void createAndFillDbsa(BeaDseu dseu) throws BusinessDomainException {
        BeaDbsa result = dseu.createDbsa();
        Date minDate = DateHelper.addMonths((Date)DateHelper.getFirstDayOfMonth((Date)this.mDateOfWithdrawal), (int)-60);
        minDate = DateHelper.max((Date[])new Date[]{minDate, this.mDateOfEntry, this.mStartOfCalculation});
        this.fillDbsa(result, minDate);
        result.setKnapprv(" ");
        result.setKnapprvbeg(null);
    }

    private void createAndFillDbsb(BeaDseu dseu) throws BusinessDomainException {
        Date minDate = DateHelper.addMonths((Date)DateHelper.getFirstDayOfMonth((Date)this.mDateOfWithdrawal), (int)-60);
        Insurance insurance = this.mEmployee.getInsurance(this.mEffectiveTimePoint, minDate = DateHelper.max((Date[])new Date[]{minDate, this.mDateOfEntry, this.mStartOfCalculation}));
        if (DateHelper.equal((Date)insurance.getValidUntil(), (Date)VDate.getDateMax())) {
            return;
        }
        Insurance insurancePrevious = insurance;
        ArrayList<BeaDbsb> dbsbList = new ArrayList<BeaDbsb>();
        int i = 0;
        Conjunction filters = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)this.mEmployee.getObjectid()), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)this.mEffectiveTimePoint)), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)this.mEffectiveTimePoint)), Restrictions.ge((String)"validfrom", (String)DateMapper.toString((Date)DateHelper.tomorrow((Date)insurance.getValidUntil())))});
        Insurance[] insurances = ((IInsurancePersistencyManager)UtilitiesManager.getBean((String)"insurancePersistencyManager", IInsurancePersistencyManager.class)).query(new Order[]{Order.asc((String)"validfrom")}, (Criterion)filters, true);
        while (DateHelper.before((Date)insurancePrevious.getValidUntil(), (Date)VDate.getDateMax())) {
            if (insurances.length <= 0) continue;
            if (!StringMapper.equal((String)insurances[i].getDuesGroups(), (String)insurancePrevious.getDuesGroups()) || insurances[i].getPersonGroup() != insurancePrevious.getPersonGroup()) {
                BeaDbsb dbsb = dseu.createDbsb();
                dbsb.init();
                dbsb.setPrsbygrbeg(insurances[i].getValidFrom());
                dbsb.setBygrb(insurances[i].getDuesGroups());
                dbsb.setPersgrb(insurances[i].getPersonGroup());
                dbsbList.add(dbsb);
            }
            insurancePrevious = insurances[i];
            ++i;
        }
        dseu.setDbsb(dbsbList.toArray(new BeaDbsb[dbsbList.size()]));
    }

    private void createAndFillDbfz(BeaDseu dseu) {
        Date minDate = DateHelper.addMonths((Date)DateHelper.getFirstDayOfMonth((Date)this.mDateOfWithdrawal), (int)-42);
        minDate = DateHelper.max((Date[])new Date[]{minDate, this.mDateOfEntry, this.mStartOfCalculation});
        Date maxDate = DateHelper.getFirstDayOfMonth((Date)this.mDateOfWithdrawal);
        Conjunction filters = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)this.mEmployee.getObjectid()), Restrictions.eq((String)"deleted", (String)"F"), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)this.mEffectiveTimePoint)), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)this.mEffectiveTimePoint)), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)maxDate)), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)minDate)), Restrictions.eq((String)"deuvrelevant", (String)"T")});
        Order[] sort = new Order[]{Order.desc((String)"validfrom")};
        EEAbsentTimeTP[] eeAbsentTimeTPs = EEAbsentTimeTPPersistencyManager.queryAll((Order[])sort, (Criterion)filters, (boolean)true);
        ArrayList<BeaDbfz> dbfzList = new ArrayList<BeaDbfz>();
        for (EEAbsentTimeTP each : eeAbsentTimeTPs) {
            int type = this.determineType(each.getEEAbsentTime().getAbsentTime());
            if (type <= 0) continue;
            BeaDbfz dbfz = dseu.createDbfz();
            dbfz.init();
            dbfz.setFehlbeg(DateHelper.max((Date)minDate, (Date)each.getValidFrom()));
            dbfz.setFehlend(each.getValidUntil());
            dbfz.setFehlart(String.valueOf(type));
            dbfzList.add(dbfz);
        }
        dseu.setDbfz(dbfzList.toArray(new BeaDbfz[dbfzList.size()]));
    }

    private void createAndFillDbez(BeaDseu dseu) throws BusinessDomainException {
        ArrayList<BeaDbez> dbezTempList = new ArrayList<BeaDbez>();
        BeaDbez dbezTemp = new BeaDbez();
        dbezTemp.makeReadOnly();
        dbezTemp.init();
        Date minDate = DateHelper.addMonths((Date)DateHelper.getFirstDayOfMonth((Date)this.mDateOfWithdrawal), (int)-60);
        minDate = DateHelper.max((Date[])new Date[]{minDate, this.mDateOfEntry, this.mStartOfCalculation});
        Date maxDate = DateHelper.getFirstDayOfMonth((Date)this.mDateOfWithdrawal);
        boolean foundImportedReason = false;
        WorkingTime workingTimeOfEmployer = this.getWorkingTimeOfEmployer(minDate);
        dbezTemp.setAzwoech(this.mEmployee.getWeeklyWorkingTime(this.mEffectiveTimePoint, minDate));
        dbezTemp.setAzduwoech(workingTimeOfEmployer.getWorkingTimeTP(this.mEffectiveTimePoint, minDate).getWeeklyWorkingTime());
        dbezTemp.setAtduwoe(workingTimeOfEmployer.getWorkingTimeTP(this.mEffectiveTimePoint, minDate).getWorkingDaysPerWeek());
        dbezTemp.setAzaegr(0);
        dbezTemp.setAzaebeg(minDate);
        WorkingTime workingTimeOfEmployeePrevious = this.mEmployee.getAssociatedWorkingTime(this.mEffectiveTimePoint, minDate);
        WorkingTime workingTimeOfEmployerPrevious = workingTimeOfEmployer;
        EEWork eeWorkPrevious = (EEWork)this.mEmployee.getWorkHistory().getItemOrNull(this.mEffectiveTimePoint, minDate);
        BigDecimal azwoechPrevious = dbezTemp.getAzwoech();
        BigDecimal azduwoechPrevious = dbezTemp.getAzduwoech();
        BigDecimal atduwoePrevious = dbezTemp.getAtduwoe();
        dbezTempList.add(dbezTemp);
        Date nextDate = DateHelper.addMonths((Date)minDate, (int)1);
        while (DateHelper.beforeOrEqual((Date)nextDate, (Date)maxDate)) {
            WorkingTime workingTimeOfEmployee = this.mEmployee.getAssociatedWorkingTime(this.mEffectiveTimePoint, nextDate);
            workingTimeOfEmployer = this.getWorkingTimeOfEmployer(nextDate);
            EEWork eeWork = (EEWork)this.mEmployee.getWorkHistory().getItemOrNull(this.mEffectiveTimePoint, nextDate);
            BigDecimal azwoech = this.mEmployee.getWeeklyWorkingTime(this.mEffectiveTimePoint, nextDate);
            BigDecimal azduwoech = workingTimeOfEmployer.getWorkingTimeTP(this.mEffectiveTimePoint, nextDate).getWeeklyWorkingTime();
            BigDecimal atduwoe = workingTimeOfEmployer.getWorkingTimeTP(this.mEffectiveTimePoint, nextDate).getWorkingDaysPerWeek();
            if (!(PBigDecimalMapper.isEqual((BigDecimal)azwoech, (BigDecimal)azwoechPrevious) && PBigDecimalMapper.isEqual((BigDecimal)azduwoech, (BigDecimal)azduwoechPrevious) && PBigDecimalMapper.isEqual((BigDecimal)atduwoe, (BigDecimal)atduwoePrevious))) {
                dbezTemp = new BeaDbez();
                dbezTemp.makeReadOnly();
                dbezTemp.init();
                dbezTemp.setAzwoech(azwoech);
                dbezTemp.setAzduwoech(azduwoech);
                dbezTemp.setAtduwoe(atduwoe);
                int reason = this.determineImportedReason();
                if (reason == 1 || reason == 2 || reason == 5 || reason == 6) {
                    foundImportedReason = true;
                }
                dbezTemp.setAzaegr(reason);
                dbezTemp.setAzaebeg(nextDate);
                dbezTempList.add(dbezTemp);
                workingTimeOfEmployerPrevious = workingTimeOfEmployer;
                workingTimeOfEmployeePrevious = workingTimeOfEmployee;
                eeWorkPrevious = eeWork;
                azwoechPrevious = dbezTemp.getAzwoech();
                azduwoechPrevious = dbezTemp.getAzduwoech();
                atduwoePrevious = dbezTemp.getAtduwoe();
            }
            nextDate = DateHelper.addMonths((Date)nextDate, (int)1);
        }
        if (!foundImportedReason) {
            minDate = DateHelper.addMonths((Date)DateHelper.getFirstDayOfMonth((Date)this.mDateOfWithdrawal), (int)-42);
            minDate = DateHelper.max((Date[])new Date[]{minDate, this.mDateOfEntry, this.mStartOfCalculation});
        }
        ArrayList<BeaDbez> dbezList = new ArrayList<BeaDbez>();
        dbezTempList.sort((o1, o2) -> DateHelper.compareDateWithNull((Date)o2.getAzaebeg(), (Date)o1.getAzaebeg()));
        for (int i = 0; i < dbezTempList.size(); ++i) {
            if (DateHelper.before((Date)((BeaDbez)dbezTempList.get(i)).getAzaebeg(), (Date)minDate)) {
                ((BeaDbez)dbezTempList.get(i)).setAzaebeg(minDate);
            }
            if (DateHelper.afterOrEqual((Date)((BeaDbez)dbezTempList.get(i)).getAzaebeg(), (Date)minDate)) {
                BeaDbez dbez = dseu.createDbez();
                dbez.init();
                dbez.setAzwoech(((BeaDbez)dbezTempList.get(i)).getAzwoech());
                dbez.setAzaegr(((BeaDbez)dbezTempList.get(i)).getAzaegr());
                if (((BeaDbez)dbezTempList.get(i)).getAzaegr() == 0) {
                    dbez.setAzaebeg(null);
                    dbez.setAzduwoech(BigDecimal.ZERO);
                } else {
                    dbez.setAzaebeg(DateHelper.max((Date)minDate, (Date)((BeaDbez)dbezTempList.get(i)).getAzaebeg()));
                }
                dbez.setAzduwoech(((BeaDbez)dbezTempList.get(i)).getAzduwoech());
                dbez.setAtduwoe(((BeaDbez)dbezTempList.get(i)).getAtduwoe());
                dbezList.add(dbez);
            }
            if (DateHelper.beforeOrEqual((Date)((BeaDbez)dbezTempList.get(i)).getAzaebeg(), (Date)minDate)) break;
        }
        dbezList.sort((o1, o2) -> DateHelper.compareDateWithNull((Date)o1.getAzaebeg(), (Date)o2.getAzaebeg()));
        dseu.setDbez(dbezList.toArray(new BeaDbez[dbezList.size()]));
    }

    private int determineImportedReason() {
        return 11;
    }

    private void createAndFillDbee(BeaDseu dseu) throws BusinessDomainException {
        this.initializeAbrMonth();
        ArrayList<BeaDbee> dbeeList = new ArrayList<BeaDbee>();
        BigDecimal[] results = this.getSVBruttos(this.mEffectiveTimePoint, this.mAbrMonatVon[0], this.mAbrMonatBis[0]);
        BigDecimal svBruttoLfd = results[0];
        BigDecimal svBruttoEGA = results[1];
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)svBruttoLfd) || !BigDecimalMapper.isZeroOrNull((BigDecimal)svBruttoEGA)) {
            BeaDbee dbee = dseu.createDbee();
            dbee.init();
            this.fill(dbee, this.mAbrMonatVon[0], this.mAbrMonatBis[0], svBruttoLfd, svBruttoEGA);
            dbeeList.add(dbee);
        }
        for (int i = 1; i < this.mAnzMonths; ++i) {
            if (DateHelper.compareDate((Date)this.mAbrMonatVon[i - 1], (Date)this.mAbrMonatVon[i]) != 0) {
                results = this.getSVBruttos(this.mEffectiveTimePoint, this.mAbrMonatVon[i], this.mAbrMonatBis[i]);
                svBruttoLfd = results[0];
                svBruttoEGA = results[1];
                if (BigDecimalMapper.isZeroOrNull((BigDecimal)svBruttoLfd) && BigDecimalMapper.isZeroOrNull((BigDecimal)svBruttoEGA)) continue;
                BeaDbee dbee = dseu.createDbee();
                dbee.init();
                this.fill(dbee, this.mAbrMonatVon[i], this.mAbrMonatBis[i], svBruttoLfd, svBruttoEGA);
                dbeeList.add(dbee);
                continue;
            }
            i = this.mAnzMonths;
        }
        BeaDbee[] result = dbeeList.toArray(new BeaDbee[dbeeList.size()]);
        Arrays.sort(result, (o1, o2) -> DateHelper.compareDateWithNull((Date)o1.getMonatbegeu(), (Date)o2.getMonatbegeu()));
        dseu.setDbee(result);
    }

    private void fill(BeaDbee dbee, Date from, Date until, BigDecimal svBruttoLfd, BigDecimal svBruttoEGA) {
        dbee.setMonatbegeu(from);
        dbee.setMonatendeu(until);
        dbee.setStbreglfeu(svBruttoLfd);
        dbee.setStbregsoeu(svBruttoEGA);
    }

    private BigDecimal[] getSVBruttos(Date effectiveTimePoint, Date from, Date until) throws BusinessDomainException {
        BigDecimal svBruttoLfd = BigDecimal.ZERO;
        BigDecimal svBruttoEGA = BigDecimal.ZERO;
        if (effectiveTimePoint == null || from == null || until == null) {
            return new BigDecimal[]{BigDecimal.ZERO, BigDecimal.ZERO};
        }
        boolean isRVPflichtig = this.mEmployee.getInsurance(effectiveTimePoint, from).getDuesGroupPI() != 0;
        ValuePositionHistory history = new ValuePositionHistory(ValuePositionPersistencyManager.queryWithOutSort((Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)this.mEmployee.getObjectid()), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)effectiveTimePoint)), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)effectiveTimePoint)), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)until)), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)from))})));
        history.sort();
        if (history.getSize() > 0) {
            boolean isUserValueType = true;
            int count = 0;
            while (isUserValueType) {
                ValuePosition currentUserVP = history.getItem(count);
                if (currentUserVP.getValueType().getValueTypeKey() > 99999) {
                    isUserValueType = false;
                    continue;
                }
                ValuePosition[] vpArray = history.getItemsForReports((PersistentObject)currentUserVP);
                boolean isSBZ = false;
                boolean isAbfindung = false;
                block10: for (ValuePosition vp : vpArray) {
                    switch (vp.getValueType().getValueTypeKey()) {
                        case 110610: 
                        case 110620: {
                            isSBZ = true;
                            if (this.checkStatisticalValueAbfindung(vp)) {
                                isAbfindung = true;
                            }
                            svBruttoEGA = svBruttoEGA.add(vp.getResult());
                            continue block10;
                        }
                        case 110510: {
                            svBruttoLfd = svBruttoLfd.add(vp.getResult());
                            continue block10;
                        }
                        case 327610: {
                            if (!isSBZ || isAbfindung) continue block10;
                            this.checkStatisticalValueUrlaubsabgeltung(vp);
                            continue block10;
                        }
                        case 327620: {
                            if (!isSBZ || isAbfindung) continue block10;
                            this.checkStatisticalValueUrlaubsabgeltung(vp);
                            continue block10;
                        }
                        case 333610: {
                            if (isRVPflichtig || !isSBZ || isAbfindung) continue block10;
                            this.checkStatisticalValueUrlaubsabgeltung(vp);
                            continue block10;
                        }
                        case 333620: {
                            if (isRVPflichtig || !isSBZ || isAbfindung) continue block10;
                            this.checkStatisticalValueUrlaubsabgeltung(vp);
                            continue block10;
                        }
                        case 130630: {
                            if (isAbfindung) continue block10;
                            this.checkStatisticalValueUrlaubsabgeltung(vp);
                            continue block10;
                        }
                    }
                }
                ++count;
            }
        }
        return new BigDecimal[]{svBruttoLfd, svBruttoEGA};
    }

    private void checkStatisticalValueUrlaubsabgeltung(ValuePosition vp) throws BusinessDomainException {
        ValuePosition vpGenesis = (ValuePosition)vp.getGenesisOfParentObjects();
        if (vpGenesis.getValueType().getValueTypeKey() == 130610) {
            vpGenesis = (ValuePosition)vpGenesis.getGenesisOfParentObjects();
        }
        if (this.mStatisticalValueUrlaubsAbgeltungen != null) {
            ValueTypeOfStatisticalValue[] vt;
            for (ValueTypeOfStatisticalValue valueTypeOfStatisticalValue : vt = this.mStatisticalValueUrlaubsAbgeltungen.getStatisticalValueTP(vp.getEffectiveFrom(), vp.getValidFrom()).getAssignmentOfValueTypes()) {
                if (valueTypeOfStatisticalValue.getValueType().getValueTypeKey() != vpGenesis.getValueType().getValueTypeKey()) continue;
                this.mUrlAbgeltung = true;
                break;
            }
        }
    }

    private boolean checkStatisticalValueAbfindung(ValuePosition vp) throws BusinessDomainException {
        boolean result = false;
        ValuePosition vpGenesis = (ValuePosition)vp.getGenesisOfParentObjects();
        if (vpGenesis.getValueType().getValueTypeKey() == 130610) {
            vpGenesis = (ValuePosition)vpGenesis.getGenesisOfParentObjects();
        }
        if (this.mStatisticalValueAbfindungen != null) {
            ValueTypeOfStatisticalValue[] vt;
            block8: for (ValueTypeOfStatisticalValue valueTypeOfStatisticalValue : vt = this.mStatisticalValueAbfindungen.getStatisticalValueTP(vp.getEffectiveFrom(), vp.getValidFrom()).getAssignmentOfValueTypes()) {
                if (valueTypeOfStatisticalValue.getValueType().getValueTypeKey() != vpGenesis.getValueType().getValueTypeKey()) continue;
                result = true;
                this.mAbfindung = true;
                switch (valueTypeOfStatisticalValue.getInclusionResult().value()) {
                    case 1: {
                        this.mBetragAbfindung = this.mBetragAbfindung.add(vpGenesis.getFactor1());
                        continue block8;
                    }
                    case 2: {
                        this.mBetragAbfindung = this.mBetragAbfindung.add(vpGenesis.getFactor2());
                        continue block8;
                    }
                    case 3: {
                        this.mBetragAbfindung = this.mBetragAbfindung.add(vpGenesis.getResult());
                        continue block8;
                    }
                    case 4: {
                        this.mBetragAbfindung = this.mBetragAbfindung.subtract(vpGenesis.getFactor1());
                        continue block8;
                    }
                    case 5: {
                        this.mBetragAbfindung = this.mBetragAbfindung.subtract(vpGenesis.getFactor2());
                        continue block8;
                    }
                    case 6: {
                        this.mBetragAbfindung = this.mBetragAbfindung.subtract(vpGenesis.getResult());
                        continue block8;
                    }
                    default: {
                        this.mBetragAbfindung = this.mBetragAbfindung.add(vpGenesis.getResult());
                    }
                }
            }
        }
        return result;
    }

    private void createAndFillDbku(BeaDseu dseu) {
        BeaDbku dbku = dseu.createDbku();
        dbku.init();
        dbku.setAvend(this.mEmployment.getDateOfWithDrawal());
        dbku.setBvend(this.mEmployment.getDateOfWithDrawal());
        if (this.mIsFiktivesAustrittsadtum) {
            dbku.setBvend(DateHelper.yesterday((Date)this.mDateOfWithdrawal));
        }
        if (this.mEmployment.getLimitedEmployment()) {
            if (this.mEmployment.getLimitedByPurpose()) {
                dbku.setAvbfr("Z");
            } else {
                dbku.setAvbfr("J");
            }
            dbku.setAvbfursp(this.mEmployment.getEmploymentLtdBy());
        }
        Date newDateOfWithdrawal = this.fillFreistellungsDaten();
        if (this.mIsUnwiderruflicheFreistellung) {
            dbku.setAvuwfwz("J");
            dbku.setAvuwfwzbeg(this.mDateUnwiderruflicheFreistellung);
            dbku.setBvend(newDateOfWithdrawal);
        }
        dbku.setAvkueam(this.mEmployment.getDateDsmRgn());
        switch (this.mEmployment.getDsmRgnOnPartOf().value()) {
            case 2: {
                dbku.setAvkuedu(1);
                break;
            }
            case 1: {
                dbku.setAvkuedu(2);
                break;
            }
            case 5: {
                dbku.setAvkuedu(4);
                break;
            }
            case 8: {
                dbku.setAvkuedu(6);
            }
        }
        if (this.mHaetteKuendigungBetriebsbedingt) {
            dbku.setAvkuebetr("J");
        }
        if (this.mAbfindung || this.mUrlAbgeltung) {
            dbku.setAvenlz("J");
            dbku.setBetzu(DateHelper.getDiffInDays((Date)this.mEmployment.getDateOfWithDrawal(), (Date)this.mEmployment.getDateOfEntry()) / 360);
        }
        if (this.mAbfindung) {
            dbku.setAbf("J");
            dbku.setAbfhoe(this.mBetragAbfindung);
        }
        if (this.mUrlAbgeltung) {
            dbku.setAvenuag("J");
        }
        if (dbku.getAvend() != null && dbku.getBvend() != null) {
            Date maxValidUntilOfAbsentTime = DateHelper.min((Date)dbku.getAvend(), (Date)dbku.getBvend());
            for (BeaDbfz each : dseu.getDbfz()) {
                if (each.getFehlend() == null || !DateHelper.after((Date)each.getFehlend(), (Date)maxValidUntilOfAbsentTime)) continue;
                each.setFehlend(maxValidUntilOfAbsentTime);
            }
        }
    }

    private Date fillFreistellungsDaten() {
        EEAbsentTimeTP[] eeAbsentTimesTP = EEAbsentTimeTPPersistencyManager.queryAll(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)this.mEmployee.getObjectid()), Restrictions.eq((String)"deleted", (String)"F"), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)this.mEffectiveTimePoint)), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)this.mEffectiveTimePoint)), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)this.mDateOfWithdrawal)), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)this.mDateOfWithdrawal)), Restrictions.disjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"absenttimekey", (String)"UBF")})}), (boolean)true);
        if (eeAbsentTimesTP.length > 0) {
            this.mIsUnwiderruflicheFreistellung = true;
            this.mDateUnwiderruflicheFreistellung = eeAbsentTimesTP[0].getValidFrom();
            return DateHelper.add((Date)eeAbsentTimesTP[0].getValidFrom(), (int)-1);
        }
        return this.mDateOfWithdrawal;
    }
}

