/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.bea.suggestion;

import com.varial.base.UtilitiesManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.criterion.Conjunction;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Order;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.bea.BeaAdvice;
import com.varial.personnel.domain.bea.basics.BasicRecord;
import com.varial.personnel.domain.bea.dbab.BeaDbab;
import com.varial.personnel.domain.bea.dbag.BeaDbag;
import com.varial.personnel.domain.bea.dban.BeaDban;
import com.varial.personnel.domain.bea.dbaz.BeaDbaz;
import com.varial.personnel.domain.bea.dben.BeaDben;
import com.varial.personnel.domain.bea.dbfz.BeaDbfz;
import com.varial.personnel.domain.bea.dbha.BeaDbha;
import com.varial.personnel.domain.bea.dbke.BeaDbke;
import com.varial.personnel.domain.bea.dbna.BeaDbna;
import com.varial.personnel.domain.bea.dbsa.BeaDbsa;
import com.varial.personnel.domain.bea.dbsb.BeaDbsb;
import com.varial.personnel.domain.bea.dbse.BeaDbse;
import com.varial.personnel.domain.bea.dsab.BeaDsab;
import com.varial.personnel.domain.bea.mapper.BeaExceptionMapper;
import com.varial.personnel.domain.bea.suggestion.CreateSuggestionHelper;
import com.varial.personnel.domain.employee.absenttime.EEAbsentTimeTP;
import com.varial.personnel.domain.employee.absenttime.EEAbsentTimeTPPersistencyManager;
import com.varial.personnel.domain.employee.insurance.IInsurancePersistencyManager;
import com.varial.personnel.domain.employee.insurance.Insurance;
import com.varial.personnel.domain.employee.tax.ITaxPersistencyManager;
import com.varial.personnel.domain.employee.tax.Tax;
import com.varial.personnel.domain.employee.valueposition.ValuePosition;
import com.varial.personnel.domain.employee.valueposition.ValuePositionHistory;
import com.varial.personnel.domain.employee.valueposition.ValuePositionPersistencyManager;
import com.varial.personnel.domain.employee.work.EEWork;
import com.varial.personnel.domain.plant.place.PlantPlaceTP;
import com.varial.personnel.domain.statisticalvalue.StatisticalValue;
import com.varial.personnel.domain.statisticalvalue.valuetypes.ValueTypeOfStatisticalValue;
import com.varial.personnel.domain.workingtime.WorkingTime;
import com.varial.personnel.framework.basictypes.PDateHelper;
import com.varial.personnel.framework.mapper.FrameWorkExceptionMapper;
import com.varial.personnel.framework.mapper.PBigDecimalMapper;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.StringMapper;
import com.varial.serverbase.persistency.PersistentObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;

public class CreateSuggestionDsabHelper
extends CreateSuggestionHelper {
    private boolean mKuendigungSchriftl;
    private boolean mAGHaetteArbverhaeltnisGekuendigt;
    private Date mHaetteKuendigungAm;
    private Date mHaetteKuendigungZum;
    private boolean mHaetteKuendigungBetriebsbedingt;
    private StatisticalValue mStatisticalValueUrlaubsAbgeltungen;
    private StatisticalValue mStatisticalValueAbfindungen;
    private StatisticalValue mStatisticalValueFiktivBrutto;
    private boolean mHeimarbeit;
    private boolean mUrlAbgeltung;
    private boolean mAbfindung;
    private BigDecimal mBetragAbfindung = BigDecimal.ZERO;
    private boolean mIsUnwiderruflicheFreistellung;
    private Date mDateUnwiderruflicheFreistellung;

    public CreateSuggestionDsabHelper() {
    }

    public CreateSuggestionDsabHelper(BeaAdvice advice) {
        super(advice);
        this.mPresetDsab = advice.getPresetDsab();
        this.mEffectiveTimePoint = DateHelper.tomorrow((Date)this.mEmployee.getJournalizedUntil());
    }

    public BeaDsab createDsab() throws BusinessDomainException {
        this.fillFromPresetAndCheckCondition();
        super.createDataset();
        BeaDsab dsab = this.fillDsab();
        return dsab;
    }

    private BeaDsab fillDsab() throws BusinessDomainException {
        BeaDsab dsab = new BeaDsab();
        dsab.setVersionsnr(3);
        BasicRecord basicRecord = this.fillBasicRecordOfDataSet();
        dsab.setBasicRecord(basicRecord);
        this.createAndFillDbna(dsab);
        this.createAndFillDban(dsab);
        this.createAndFillDbag(dsab);
        this.createAndFillDbab(dsab);
        this.createAndFillDbse(dsab);
        this.createAndFillDbsa(dsab);
        this.createAndFillDbsb(dsab);
        this.createAndFillDbaz(dsab);
        this.createAndFillDben(dsab);
        this.createAndFillDbfz(dsab);
        this.createAndFillDbha(dsab);
        this.createAndFillDbke(dsab);
        return dsab;
    }

    private void fillFromPresetAndCheckCondition() throws BusinessDomainException {
        this.mGueltigFuer = this.mPresetDsab.getGueltigFuer();
        if (this.mGueltigFuer == null) {
            throw FrameWorkExceptionMapper.makeInputIsMissingDomainException((String)"mGueltigFuer");
        }
        if (DateHelper.after((Date)this.mGueltigFuer, (Date)this.mEffectiveTimePoint)) {
            throw BeaExceptionMapper.makeCondtionDsabNotFulfilledDomainException("das g\u00fcltig ab der Vorgabe muss in einem journalisierten Zeitraum liegen.");
        }
        this.mDateOfWithdrawal = this.mEmployee.getNextDateOfWithdrawal(this.mGueltigFuer, this.mEffectiveTimePoint);
        if (this.mDateOfWithdrawal == null) {
            EEAbsentTimeTP[] eeAbsentTimesTP = EEAbsentTimeTPPersistencyManager.queryAll(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)this.mEmployee.getObjectid()), Restrictions.eq((String)"deleted", (String)"F"), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)this.mEffectiveTimePoint)), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)this.mEffectiveTimePoint)), Restrictions.ge((String)"validfrom", (String)DateMapper.toString((Date)this.mPresetDsab.getGueltigFuer())), Restrictions.or((Criterion)Restrictions.eq((String)"absenttimekey", (String)"AU"), (Criterion)Restrictions.eq((String)"absenttimekey", (String)"EKT"))}), (boolean)true);
            if (eeAbsentTimesTP.length == 0) {
                throw BeaExceptionMapper.makeCondtionDsabNotFulfilledDomainException("kein Austrittsdatum und keine Fehlzeit Aussteuerung im aktuellen, journalisierten Besch\u00e4ftigungszeitraum vorhanden");
            }
            this.mDateOfWithdrawal = eeAbsentTimesTP[0].getValidFrom();
            this.mIsFiktivesAustrittsadtum = true;
        }
        this.mAnzMonths = PDateHelper.countAffectedMonths((Date)this.mDateOfWithdrawal, (Date)this.mGueltigFuer);
        if (this.mAnzMonths > 24) {
            throw BeaExceptionMapper.makeCondtionDsabNotFulfilledDomainException("zwischen dem g\u00fcltig f\u00fcr der Vorgabe und dem folgenden Austritt liegen mehr als 24 Monate, " + this.mAnzMonths);
        }
        this.mKuendigungSchriftl = false;
        this.mAGHaetteArbverhaeltnisGekuendigt = false;
        this.mHaetteKuendigungAm = null;
        this.mHaetteKuendigungZum = null;
        if (this.mAGHaetteArbverhaeltnisGekuendigt) {
            if (this.mHaetteKuendigungAm == null) {
                throw FrameWorkExceptionMapper.makeInputIsMissingDomainException((String)"(Arbeitgeber h\u00e4tte Arbeitsverh\u00e4ltnis gek\u00fcndigt) wenn ja, am");
            }
            if (this.mHaetteKuendigungZum == null) {
                throw FrameWorkExceptionMapper.makeInputIsMissingDomainException((String)"(Arbeitgeber h\u00e4tte Arbeitsverh\u00e4ltnis gek\u00fcndigt) wenn ja, zum");
            }
        }
        this.mHaetteKuendigungBetriebsbedingt = false;
        this.mStatisticalValueUrlaubsAbgeltungen = this.mPresetDsab.getUrlaubsAbgeltungen();
        this.mStatisticalValueAbfindungen = this.mPresetDsab.getAbfindungen();
        this.mStatisticalValueFiktivBrutto = this.mPresetDsab.getFiktivBrutto();
        this.mBearbeiterEntgelt = this.mPresetDsab.getBearbeiterEntgelt();
        this.mBearbeiterPersonal = this.mPresetDsab.getBearbeiterPersonal();
        this.mHeimarbeit = this.mPresetDsab.getHeimarbeit();
        this.mAbrMonatVon = new Date[this.mAnzMonths];
        this.mAbrMonatBis = new Date[this.mAnzMonths];
        this.mValidTimePoint = this.mDateOfWithdrawal;
    }

    private BeaDbna createAndFillDbna(BeaDsab dsba) throws BusinessDomainException {
        BeaDbna result = dsba.createDbna();
        return this.mBeaEmployee.fillDbna(result);
    }

    private BeaDban createAndFillDban(BeaDsab dsba) throws BusinessDomainException {
        BeaDban result = dsba.createDban();
        return this.mBeaEmployee.fillDban(result);
    }

    private void createAndFillDbag(BeaDsab dsab) {
        BeaDbag result = dsab.createDbag();
        this.fillDbag(result);
    }

    private void createAndFillDbab(BeaDsab dsab) {
        if (!this.plantIsEmployer || this.mEmployment.getPlantPlace() == null) {
            return;
        }
        PlantPlaceTP plantPlaceTP = (PlantPlaceTP)this.mEmployment.getPlantPlace().getHistory().getItemOrNull(this.mEffectiveTimePoint, this.mValidTimePoint);
        if (plantPlaceTP == null) {
            return;
        }
        BeaDbab result = dsab.createDbab();
        this.fillDbab(result, plantPlaceTP);
    }

    private void createAndFillDbse(BeaDsab dsab) throws BusinessDomainException {
        ArrayList<BeaDbse> dbseList = new ArrayList<BeaDbse>();
        BeaDbse dbse = dsab.createDbse();
        dbse.init();
        Date beginOfYear = DateHelper.getFirstDayOfYear((Date)this.mValidTimePoint);
        Date from = DateHelper.max((Date[])new Date[]{this.mDateOfEntry, beginOfYear, this.mStartOfCalculation});
        Date until = DateHelper.getLastDayOfYear((Date)from);
        Tax tax = this.mEmployee.getTax(this.mEffectiveTimePoint, from);
        dbse.setAestedatbeg(null);
        dbse.setStkl(tax.getTaxBracket());
        dbse.setFkt(tax.getPercentageSplit());
        dbse.setKindfrb(tax.getChildRelief());
        Tax taxPrevious = tax;
        dbseList.add(dbse);
        int i = 0;
        Conjunction filters = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)this.mEmployee.getObjectid()), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)this.mEffectiveTimePoint)), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)this.mEffectiveTimePoint)), Restrictions.ge((String)"validfrom", (String)DateMapper.toString((Date)taxPrevious.getValidUntil()))});
        Tax[] taxs = ((ITaxPersistencyManager)UtilitiesManager.getBean((String)"taxPersistencyManager", ITaxPersistencyManager.class)).query(new Order[]{Order.asc((String)"validfrom")}, (Criterion)filters, true);
        while (DateHelper.before((Date)taxPrevious.getValidUntil(), (Date)VDate.getDateMax()) || DateHelper.before((Date)taxPrevious.getValidUntil(), (Date)until)) {
            if (taxs.length <= 0) continue;
            if (taxs[i].getTaxBracket() != taxPrevious.getTaxBracket() || !PBigDecimalMapper.isEqual((BigDecimal)taxs[i].getChildRelief(), (BigDecimal)taxPrevious.getChildRelief()) || !PBigDecimalMapper.isEqual((BigDecimal)taxs[i].getPercentageSplit(), (BigDecimal)taxPrevious.getPercentageSplit())) {
                dbse = dsab.createDbse();
                dbse.init();
                dbse.setAestedatbeg(taxs[i].getValidFrom());
                dbse.setStkl(taxs[i].getTaxBracket());
                dbse.setFkt(taxs[i].getPercentageSplit());
                dbse.setKindfrb(taxs[i].getChildRelief());
                dbseList.add(dbse);
            }
            taxPrevious = taxs[i];
            ++i;
        }
        dsab.setDbse(dbseList.toArray(new BeaDbse[dbseList.size()]));
    }

    private void createAndFillDbsa(BeaDsab dsab) throws BusinessDomainException {
        BeaDbsa result = dsab.createDbsa();
        Date minDate = DateHelper.addMonths((Date)DateHelper.getFirstDayOfMonth((Date)this.mDateOfWithdrawal), (int)-60);
        minDate = DateHelper.max((Date[])new Date[]{minDate, this.mDateOfEntry, this.mStartOfCalculation});
        this.fillDbsa(result, minDate);
    }

    private void createAndFillDbsb(BeaDsab dsab) throws BusinessDomainException {
        Date minDate = DateHelper.addMonths((Date)DateHelper.getFirstDayOfMonth((Date)this.mDateOfWithdrawal), (int)-60);
        Insurance insurance = this.mEmployee.getInsurance(this.mEffectiveTimePoint, minDate = DateHelper.max((Date[])new Date[]{minDate, this.mDateOfEntry, this.mStartOfCalculation}));
        if (DateHelper.equal((Date)insurance.getValidUntil(), (Date)VDate.getDateMax())) {
            return;
        }
        Insurance insurancePrevious = insurance;
        ArrayList<BeaDbsb> dbsbList = new ArrayList<BeaDbsb>();
        int i = 0;
        Conjunction filters = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)this.mEmployee.getObjectid()), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)this.mEffectiveTimePoint)), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)this.mEffectiveTimePoint)), Restrictions.ge((String)"validfrom", (String)DateMapper.toString((Date)DateHelper.tomorrow((Date)insurance.getValidUntil())))});
        Insurance[] insurances = ((IInsurancePersistencyManager)UtilitiesManager.getBean((String)"insurancePersistencyManager", IInsurancePersistencyManager.class)).query(new Order[]{Order.asc((String)"validfrom")}, (Criterion)filters, true);
        while (DateHelper.before((Date)insurancePrevious.getValidUntil(), (Date)VDate.getDateMax())) {
            if (insurances.length <= 0) continue;
            if (!StringMapper.equal((String)insurances[i].getDuesGroups(), (String)insurancePrevious.getDuesGroups()) || insurances[i].getPersonGroup() != insurancePrevious.getPersonGroup()) {
                BeaDbsb dbsb = dsab.createDbsb();
                dbsb.init();
                dbsb.setPrsbygrbeg(insurances[i].getValidFrom());
                dbsb.setBygrb(insurances[i].getDuesGroups());
                dbsb.setPersgrb(insurances[i].getPersonGroup());
                dbsbList.add(dbsb);
            }
            insurancePrevious = insurances[i];
            ++i;
        }
        dsab.setDbsb(dbsbList.toArray(new BeaDbsb[dbsbList.size()]));
    }

    private void createAndFillDbaz(BeaDsab dsab) throws BusinessDomainException {
        ArrayList<BeaDbaz> dbazTempList = new ArrayList<BeaDbaz>();
        BeaDbaz dbazTemp = new BeaDbaz();
        dbazTemp.makeReadOnly();
        dbazTemp.init();
        Date minDate = DateHelper.addMonths((Date)DateHelper.getFirstDayOfMonth((Date)this.mDateOfWithdrawal), (int)-42);
        minDate = DateHelper.max((Date[])new Date[]{minDate, this.mDateOfEntry, this.mStartOfCalculation});
        Date maxDate = DateHelper.getFirstDayOfMonth((Date)this.mDateOfWithdrawal);
        boolean foundImportedReason = false;
        WorkingTime workingTimeOfEmployer = this.getWorkingTimeOfEmployer(minDate);
        dbazTemp.setAzwoech(this.mEmployee.getWeeklyWorkingTime(this.mEffectiveTimePoint, minDate));
        dbazTemp.setAzvg(workingTimeOfEmployer.getWorkingTimeTP(this.mEffectiveTimePoint, minDate).getWeeklyWorkingTime());
        dbazTemp.setAzaegr(0);
        dbazTemp.setAzaebeg(minDate);
        WorkingTime workingTimeOfEmployeePrevious = this.mEmployee.getAssociatedWorkingTime(this.mEffectiveTimePoint, minDate);
        WorkingTime workingTimeOfEmployerPrevious = workingTimeOfEmployer;
        EEWork eeWorkPrevious = (EEWork)this.mEmployee.getWorkHistory().getItemOrNull(this.mEffectiveTimePoint, minDate);
        BigDecimal azwoechPrevious = dbazTemp.getAzwoech();
        BigDecimal azvgPrevious = dbazTemp.getAzvg();
        dbazTempList.add(dbazTemp);
        Date nextDate = PDateHelper.getFirstDayNextMonth((Date)minDate);
        while (DateHelper.beforeOrEqual((Date)nextDate, (Date)maxDate)) {
            WorkingTime workingTimeOfEmployee = this.mEmployee.getAssociatedWorkingTime(this.mEffectiveTimePoint, nextDate);
            workingTimeOfEmployer = this.getWorkingTimeOfEmployer(nextDate);
            EEWork eeWork = (EEWork)this.mEmployee.getWorkHistory().getItemOrNull(this.mEffectiveTimePoint, nextDate);
            BigDecimal azwoech = this.mEmployee.getWeeklyWorkingTime(this.mEffectiveTimePoint, nextDate);
            BigDecimal azvg = workingTimeOfEmployer.getWorkingTimeTP(this.mEffectiveTimePoint, nextDate).getWeeklyWorkingTime();
            if (!PBigDecimalMapper.isEqual((BigDecimal)azwoech, (BigDecimal)azwoechPrevious) || !PBigDecimalMapper.isEqual((BigDecimal)azvg, (BigDecimal)azvgPrevious)) {
                dbazTemp = new BeaDbaz();
                dbazTemp.makeReadOnly();
                dbazTemp.init();
                dbazTemp.setAzwoech(azwoech);
                dbazTemp.setAzvg(azvg);
                int reason = this.determineImportedReason();
                if (reason == 1 || reason == 2 || reason == 5 || reason == 6) {
                    foundImportedReason = true;
                }
                dbazTemp.setAzaegr(reason);
                dbazTemp.setAzaebeg(nextDate);
                dbazTempList.add(dbazTemp);
                workingTimeOfEmployerPrevious = workingTimeOfEmployer;
                workingTimeOfEmployeePrevious = workingTimeOfEmployee;
                eeWorkPrevious = eeWork;
                azwoechPrevious = dbazTemp.getAzwoech();
                azvgPrevious = dbazTemp.getAzvg();
            }
            nextDate = DateHelper.addMonths((Date)nextDate, (int)1);
        }
        if (!foundImportedReason) {
            minDate = DateHelper.addMonths((Date)DateHelper.getFirstDayOfMonth((Date)this.mDateOfWithdrawal), (int)-42);
            minDate = DateHelper.max((Date[])new Date[]{minDate, this.mDateOfEntry, this.mStartOfCalculation});
        }
        ArrayList<BeaDbaz> dbazList = new ArrayList<BeaDbaz>();
        dbazTempList.sort((o1, o2) -> DateHelper.compareDateWithNull((Date)o2.getAzaebeg(), (Date)o1.getAzaebeg()));
        for (int i = 0; i < dbazTempList.size(); ++i) {
            if (DateHelper.before((Date)((BeaDbaz)((Object)dbazTempList.get(i))).getAzaebeg(), (Date)minDate)) {
                ((BeaDbaz)((Object)dbazTempList.get(i))).setAzaebeg(minDate);
            }
            if (DateHelper.afterOrEqual((Date)((BeaDbaz)((Object)dbazTempList.get(i))).getAzaebeg(), (Date)minDate)) {
                BeaDbaz dbaz = dsab.createDbaz();
                dbaz.init();
                dbaz.setAzwoech(((BeaDbaz)((Object)dbazTempList.get(i))).getAzwoech());
                dbaz.setAzvg(((BeaDbaz)((Object)dbazTempList.get(i))).getAzvg());
                dbaz.setAzaegr(((BeaDbaz)((Object)dbazTempList.get(i))).getAzaegr());
                if (((BeaDbaz)((Object)dbazTempList.get(i))).getAzaegr() == 0) {
                    dbaz.setAzaebeg(null);
                    dbaz.setAzvg(BigDecimal.ZERO);
                } else {
                    dbaz.setAzaebeg(DateHelper.max((Date)minDate, (Date)((BeaDbaz)((Object)dbazTempList.get(i))).getAzaebeg()));
                }
                dbazList.add(dbaz);
            }
            if (DateHelper.beforeOrEqual((Date)((BeaDbaz)((Object)dbazTempList.get(i))).getAzaebeg(), (Date)minDate)) break;
        }
        dbazList.sort((o1, o2) -> DateHelper.compareDateWithNull((Date)o1.getAzaebeg(), (Date)o2.getAzaebeg()));
        dsab.setDbaz(dbazList.toArray(new BeaDbaz[dbazList.size()]));
    }

    private int determineImportedReason() {
        return 11;
    }

    private void createAndFillDben(BeaDsab dsab) throws BusinessDomainException {
        this.initializeAbrMonth();
        ArrayList<BeaDben> dbenList = new ArrayList<BeaDben>();
        BigDecimal[] results = this.getSVBruttoLfdOhneEGA(this.mEffectiveTimePoint, this.mAbrMonatVon[0], this.mAbrMonatBis[0]);
        BigDecimal svBruttoLfd = results[0];
        BigDecimal svBruttoEGA = results[1];
        BigDecimal svBruttoEGA333614 = results[2];
        BigDecimal kugBruttoSollentgelt151010 = results[3];
        BigDecimal fiktivBrutto = BigDecimal.ZERO;
        boolean mia = false;
        Date miabeg = null;
        Date miaend = null;
        if (!(BigDecimalMapper.isZeroOrNull((BigDecimal)svBruttoLfd) && BigDecimalMapper.isZeroOrNull((BigDecimal)svBruttoEGA) && BigDecimalMapper.isZeroOrNull((BigDecimal)kugBruttoSollentgelt151010))) {
            if (!(this.mStatisticalValueFiktivBrutto == null && BigDecimalMapper.isZeroOrNull((BigDecimal)kugBruttoSollentgelt151010) && BigDecimalMapper.isZeroOrNull((BigDecimal)svBruttoEGA) || BigDecimalMapper.isZeroOrNull((BigDecimal)(fiktivBrutto = this.getValueOfStatisticalValue(this.mStatisticalValueFiktivBrutto, this.mEmployee, this.mEffectiveTimePoint, DateHelper.getFirstDayOfMonth((Date)this.mAbrMonatVon[0]), DateHelper.getLastDayOfMonth((Date)this.mAbrMonatBis[0]))[1])) || BigDecimalMapper.isZeroOrNull((BigDecimal)svBruttoEGA) && BigDecimalMapper.isZeroOrNull((BigDecimal)svBruttoEGA333614))) {
                fiktivBrutto = fiktivBrutto.add(svBruttoEGA).add(svBruttoEGA333614);
                svBruttoEGA = BigDecimal.ZERO;
            }
            Conjunction filter = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)this.mEmployee.getObjectid()), Restrictions.eq((String)"deleted", (String)"F"), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)this.mEffectiveTimePoint)), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)this.mEffectiveTimePoint)), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)this.mAbrMonatVon[0])), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)this.mAbrMonatBis[0])), Restrictions.eq((String)"deuvrelevant", (String)"T"), Restrictions.eq((String)"absenttimekey", (String)"PZ")});
            Order[] sort = new Order[]{Order.desc((String)"validfrom")};
            EEAbsentTimeTP[] eeAbsentTimeTPs = EEAbsentTimeTPPersistencyManager.queryAll((Order[])sort, (Criterion)filter, (boolean)true);
            if (eeAbsentTimeTPs.length > 0) {
                mia = true;
                miabeg = DateHelper.max((Date)eeAbsentTimeTPs[0].getValidFrom(), (Date)this.mAbrMonatVon[0]);
                miabeg = DateHelper.min((Date)eeAbsentTimeTPs[0].getValidUntil(), (Date)this.mAbrMonatBis[0]);
            }
            BeaDben dben = dsab.createDben();
            dben.init();
            this.fill(dben, this.mAbrMonatVon[0], this.mAbrMonatBis[0], svBruttoLfd, svBruttoEGA, fiktivBrutto, mia, miabeg, miaend);
            dbenList.add(dben);
        }
        for (int i = 1; i < this.mAnzMonths; ++i) {
            if (DateHelper.compareDate((Date)this.mAbrMonatVon[i - 1], (Date)this.mAbrMonatVon[i]) != 0) {
                results = this.getSVBruttoLfdOhneEGA(this.mEffectiveTimePoint, this.mAbrMonatVon[i], this.mAbrMonatBis[i]);
                svBruttoLfd = results[0];
                svBruttoEGA = results[1];
                svBruttoEGA333614 = results[2];
                kugBruttoSollentgelt151010 = results[3];
                fiktivBrutto = BigDecimal.ZERO;
                mia = false;
                miabeg = null;
                miaend = null;
                if (BigDecimalMapper.isZeroOrNull((BigDecimal)svBruttoLfd) && BigDecimalMapper.isZeroOrNull((BigDecimal)kugBruttoSollentgelt151010)) continue;
                if (!(this.mStatisticalValueFiktivBrutto == null && BigDecimalMapper.isZeroOrNull((BigDecimal)kugBruttoSollentgelt151010) && BigDecimalMapper.isZeroOrNull((BigDecimal)svBruttoEGA) || BigDecimalMapper.isZeroOrNull((BigDecimal)(fiktivBrutto = this.getValueOfStatisticalValue(this.mStatisticalValueFiktivBrutto, this.mEmployee, this.mEffectiveTimePoint, DateHelper.getFirstDayOfMonth((Date)this.mAbrMonatVon[i]), DateHelper.getLastDayOfMonth((Date)this.mAbrMonatBis[i]))[1])) || BigDecimalMapper.isZeroOrNull((BigDecimal)svBruttoEGA) && BigDecimalMapper.isZeroOrNull((BigDecimal)svBruttoEGA333614))) {
                    fiktivBrutto = fiktivBrutto.add(svBruttoEGA).add(svBruttoEGA333614);
                    svBruttoEGA = BigDecimal.ZERO;
                }
                Conjunction filter = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)this.mEmployee.getObjectid()), Restrictions.eq((String)"deleted", (String)"F"), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)this.mEffectiveTimePoint)), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)this.mEffectiveTimePoint)), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)this.mAbrMonatVon[i])), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)this.mAbrMonatBis[i])), Restrictions.eq((String)"deuvrelevant", (String)"T"), Restrictions.eq((String)"absenttimekey", (String)"PZ")});
                Order[] sort = new Order[]{Order.desc((String)"validfrom")};
                EEAbsentTimeTP[] eeAbsentTimeTPs = EEAbsentTimeTPPersistencyManager.queryAll((Order[])sort, (Criterion)filter, (boolean)true);
                if (eeAbsentTimeTPs.length > 0) {
                    mia = true;
                    miabeg = DateHelper.max((Date)eeAbsentTimeTPs[0].getValidFrom(), (Date)this.mAbrMonatVon[i]);
                    miabeg = DateHelper.min((Date)eeAbsentTimeTPs[0].getValidUntil(), (Date)this.mAbrMonatBis[i]);
                }
                BeaDben dben = dsab.createDben();
                dben.init();
                this.fill(dben, this.mAbrMonatVon[i], this.mAbrMonatBis[i], svBruttoLfd, svBruttoEGA, fiktivBrutto, mia, miabeg, miaend);
                dbenList.add(dben);
                continue;
            }
            i = this.mAnzMonths;
        }
        BeaDben[] result = dbenList.toArray(new BeaDben[dbenList.size()]);
        Arrays.sort(result, (o1, o2) -> DateHelper.compareDateWithNull((Date)o1.getMonatbeg(), (Date)o2.getMonatbeg()));
        dsab.setDben(result);
    }

    private void fill(BeaDben dben, Date from, Date until, BigDecimal svBruttoLfd, BigDecimal svBruttoEGA, BigDecimal fiktivBrutto, boolean mia, Date miabeg, Date miaend) {
        dben.setMonatbeg(from);
        dben.setMonatend(until);
        dben.setKennzrk(this.getLawArea(this.mAbrMonatVon[0]));
        dben.setSvbreglf(svBruttoLfd);
        dben.setSvbrege(svBruttoEGA);
        dben.setFibr(fiktivBrutto);
        if (mia) {
            dben.setMia("J");
        }
        dben.setMiabeg(miabeg);
        dben.setMiaend(miaend);
    }

    private BigDecimal[] getSVBruttoLfdOhneEGA(Date effectiveTimePoint, Date from, Date until) throws BusinessDomainException {
        BigDecimal svBruttoLfd = BigDecimal.ZERO;
        BigDecimal svBruttoEGA = BigDecimal.ZERO;
        BigDecimal svBruttoEGA333614 = BigDecimal.ZERO;
        BigDecimal kugBruttoSollentgelt151010 = BigDecimal.ZERO;
        if (effectiveTimePoint == null || from == null || until == null) {
            return new BigDecimal[]{BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO};
        }
        boolean isRVPflichtig = this.mEmployee.getInsurance(effectiveTimePoint, from).getDuesGroupPI() != 0;
        ValuePositionHistory history = new ValuePositionHistory(ValuePositionPersistencyManager.queryWithOutSort((Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)this.mEmployee.getObjectid()), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)effectiveTimePoint)), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)effectiveTimePoint)), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)until)), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)from))})));
        history.sort();
        if (history.getSize() > 0) {
            boolean isUserValueType = true;
            int count = 0;
            while (isUserValueType) {
                ValuePosition currentUserVP = history.getItem(count);
                if (currentUserVP.getValueType().getValueTypeKey() > 99999) {
                    isUserValueType = false;
                    continue;
                }
                ValuePosition[] vpArray = history.getItemsForReports((PersistentObject)currentUserVP);
                boolean isSBZ = false;
                boolean isAbfindung = false;
                block13: for (ValuePosition vp : vpArray) {
                    switch (vp.getValueType().getValueTypeKey()) {
                        case 110610: 
                        case 110620: {
                            isSBZ = true;
                            if (!this.checkStatisticalValueAbfindung(vp)) continue block13;
                            isAbfindung = true;
                            continue block13;
                        }
                        case 333510: {
                            svBruttoLfd = svBruttoLfd.add(vp.getResult());
                            continue block13;
                        }
                        case 333616: {
                            if (isSBZ) continue block13;
                            svBruttoLfd = svBruttoLfd.add(vp.getResult());
                            continue block13;
                        }
                        case 333614: {
                            svBruttoEGA333614 = svBruttoEGA333614.add(vp.getResult());
                            continue block13;
                        }
                        case 327610: {
                            if (!isSBZ || isAbfindung) continue block13;
                            this.checkStatisticalValueUrlaubsabgeltung(vp);
                            svBruttoEGA = svBruttoEGA.add(vp.getResult());
                            continue block13;
                        }
                        case 327620: {
                            if (!isSBZ || isAbfindung) continue block13;
                            this.checkStatisticalValueUrlaubsabgeltung(vp);
                            svBruttoEGA = svBruttoEGA.add(vp.getResult());
                            continue block13;
                        }
                        case 333610: {
                            if (isRVPflichtig || !isSBZ || isAbfindung) continue block13;
                            this.checkStatisticalValueUrlaubsabgeltung(vp);
                            svBruttoEGA = svBruttoEGA.add(vp.getResult());
                            continue block13;
                        }
                        case 333620: {
                            if (isRVPflichtig || isAbfindung) continue block13;
                            this.checkStatisticalValueUrlaubsabgeltung(vp);
                            svBruttoEGA = svBruttoEGA.add(vp.getResult());
                            continue block13;
                        }
                        case 130630: {
                            if (isAbfindung) continue block13;
                            this.checkStatisticalValueUrlaubsabgeltung(vp);
                            svBruttoEGA = svBruttoEGA.add(vp.getResult());
                            continue block13;
                        }
                        case 151010: {
                            kugBruttoSollentgelt151010 = kugBruttoSollentgelt151010.add(vp.getResult());
                            continue block13;
                        }
                    }
                }
                ++count;
            }
        }
        return new BigDecimal[]{svBruttoLfd, svBruttoEGA, svBruttoEGA333614, kugBruttoSollentgelt151010};
    }

    private void checkStatisticalValueUrlaubsabgeltung(ValuePosition vp) throws BusinessDomainException {
        ValuePosition vpGenesis = (ValuePosition)vp.getGenesisOfParentObjects();
        if (vpGenesis.getValueType().getValueTypeKey() == 130610) {
            vpGenesis = (ValuePosition)vpGenesis.getGenesisOfParentObjects();
        }
        if (this.mStatisticalValueUrlaubsAbgeltungen != null) {
            ValueTypeOfStatisticalValue[] vt;
            for (ValueTypeOfStatisticalValue valueTypeOfStatisticalValue : vt = this.mStatisticalValueUrlaubsAbgeltungen.getStatisticalValueTP(vp.getEffectiveFrom(), vp.getValidFrom()).getAssignmentOfValueTypes()) {
                if (valueTypeOfStatisticalValue.getValueType().getValueTypeKey() != vpGenesis.getValueType().getValueTypeKey()) continue;
                this.mUrlAbgeltung = true;
                break;
            }
        }
    }

    private boolean checkStatisticalValueAbfindung(ValuePosition vp) throws BusinessDomainException {
        boolean result = false;
        ValuePosition vpGenesis = (ValuePosition)vp.getGenesisOfParentObjects();
        if (vpGenesis.getValueType().getValueTypeKey() == 130610) {
            vpGenesis = (ValuePosition)vpGenesis.getGenesisOfParentObjects();
        }
        if (this.mStatisticalValueAbfindungen != null) {
            ValueTypeOfStatisticalValue[] vt;
            block8: for (ValueTypeOfStatisticalValue valueTypeOfStatisticalValue : vt = this.mStatisticalValueAbfindungen.getStatisticalValueTP(vp.getEffectiveFrom(), vp.getValidFrom()).getAssignmentOfValueTypes()) {
                if (valueTypeOfStatisticalValue.getValueType().getValueTypeKey() != vpGenesis.getValueType().getValueTypeKey()) continue;
                result = true;
                this.mAbfindung = true;
                switch (valueTypeOfStatisticalValue.getInclusionResult().value()) {
                    case 1: {
                        this.mBetragAbfindung = this.mBetragAbfindung.add(vpGenesis.getFactor1());
                        continue block8;
                    }
                    case 2: {
                        this.mBetragAbfindung = this.mBetragAbfindung.add(vpGenesis.getFactor2());
                        continue block8;
                    }
                    case 3: {
                        this.mBetragAbfindung = this.mBetragAbfindung.add(vpGenesis.getResult());
                        continue block8;
                    }
                    case 4: {
                        this.mBetragAbfindung = this.mBetragAbfindung.subtract(vpGenesis.getFactor1());
                        continue block8;
                    }
                    case 5: {
                        this.mBetragAbfindung = this.mBetragAbfindung.subtract(vpGenesis.getFactor2());
                        continue block8;
                    }
                    case 6: {
                        this.mBetragAbfindung = this.mBetragAbfindung.subtract(vpGenesis.getResult());
                        continue block8;
                    }
                    default: {
                        this.mBetragAbfindung = this.mBetragAbfindung.add(vpGenesis.getResult());
                    }
                }
            }
        }
        return result;
    }

    private void createAndFillDbfz(BeaDsab dsab) {
        Date minDate = DateHelper.addMonths((Date)DateHelper.getFirstDayOfMonth((Date)this.mDateOfWithdrawal), (int)-42);
        minDate = DateHelper.max((Date[])new Date[]{minDate, this.mDateOfEntry, this.mStartOfCalculation});
        Date maxDate = DateHelper.getFirstDayOfMonth((Date)this.mDateOfWithdrawal);
        Conjunction filters = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)this.mEmployee.getObjectid()), Restrictions.eq((String)"deleted", (String)"F"), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)this.mEffectiveTimePoint)), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)this.mEffectiveTimePoint)), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)maxDate)), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)minDate)), Restrictions.eq((String)"deuvrelevant", (String)"T")});
        Order[] sort = new Order[]{Order.desc((String)"validfrom")};
        EEAbsentTimeTP[] eeAbsentTimeTPs = EEAbsentTimeTPPersistencyManager.queryAll((Order[])sort, (Criterion)filters, (boolean)true);
        ArrayList<BeaDbfz> dbfzList = new ArrayList<BeaDbfz>();
        for (EEAbsentTimeTP each : eeAbsentTimeTPs) {
            int type = this.determineType(each.getEEAbsentTime().getAbsentTime());
            if (type <= 0) continue;
            BeaDbfz dbfz = dsab.createDbfz();
            dbfz.init();
            dbfz.setFehlbeg(DateHelper.max((Date)minDate, (Date)each.getValidFrom()));
            dbfz.setFehlend(each.getValidUntil());
            dbfz.setFehlart(String.valueOf(type));
            dbfzList.add(dbfz);
        }
        dsab.setDbfz(dbfzList.toArray(new BeaDbfz[dbfzList.size()]));
    }

    private void createAndFillDbha(BeaDsab dsab) {
        if (this.mHeimarbeit) {
            BeaDbha dbha = dsab.createDbha();
            dbha.init();
        }
    }

    private void createAndFillDbke(BeaDsab dsab) {
        BeaDbke dbke = dsab.createDbke();
        dbke.init();
        dbke.setAvend(this.mEmployment.getDateOfWithDrawal());
        dbke.setBvend(this.mEmployment.getDateOfWithDrawal());
        if (this.mIsFiktivesAustrittsadtum) {
            dbke.setBvend(DateHelper.yesterday((Date)this.mDateOfWithdrawal));
        }
        if (this.mEmployment.getLimitedEmployment()) {
            if (this.mEmployment.getLimitedByPurpose()) {
                dbke.setAvbfr("Z");
            } else {
                dbke.setAvbfr("J");
            }
            dbke.setAvbfschr("J");
            dbke.setAvbfursp(this.mEmployment.getEmploymentLtdBy());
        }
        dbke.setAvkueam(this.mEmployment.getDateDsmRgn());
        Date newDateOfWithdrawal = this.fillFreistellungsDaten();
        if (this.mIsUnwiderruflicheFreistellung) {
            dbke.setAvuwfwz("J");
            dbke.setAvuwfwzbeg(this.mDateUnwiderruflicheFreistellung);
            dbke.setBvend(newDateOfWithdrawal);
        }
        Date end = dbke.getAvend();
        if (dbke.getAvend() != null && dbke.getBvend() != null) {
            end = DateHelper.min((Date)dbke.getAvend(), (Date)dbke.getBvend());
        }
        dbke.setAvletztrl(DateHelper.getFirstDayOfMonth((Date)end));
        switch (this.mEmployment.getDsmRgnOnPartOf().value()) {
            case 2: {
                dbke.setAvkuedu(1);
                break;
            }
            case 1: {
                dbke.setAvkuedu(2);
                break;
            }
            case 5: {
                dbke.setAvkuedu(4);
                break;
            }
            case 8: {
                dbke.setAvkuedu(6);
            }
        }
        if (this.mKuendigungSchriftl) {
            dbke.setAvkuesch("J");
        }
        if (this.mHaetteKuendigungBetriebsbedingt) {
            dbke.setAvkuebetr("J");
        }
        if (this.mUrlAbgeltung) {
            dbke.setAvenuag("J");
        }
        if (this.mAbfindung) {
            dbke.setAbf("J");
            dbke.setAbfhoe(this.mBetragAbfindung);
        }
        if (this.mUrlAbgeltung) {
            dbke.setAvenuag("J");
        }
        for (BeaDbfz each : dsab.getDbfz()) {
            if (each.getFehlend() == null || !DateHelper.after((Date)each.getFehlend(), (Date)end)) continue;
            each.setFehlend(end);
        }
    }

    private Date fillFreistellungsDaten() {
        EEAbsentTimeTP[] eeAbsentTimesTP = EEAbsentTimeTPPersistencyManager.queryAll(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)this.mEmployee.getObjectid()), Restrictions.eq((String)"deleted", (String)"F"), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)this.mEffectiveTimePoint)), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)this.mEffectiveTimePoint)), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)this.mDateOfWithdrawal)), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)this.mDateOfWithdrawal)), Restrictions.disjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"absenttimekey", (String)"UBF")})}), (boolean)true);
        if (eeAbsentTimesTP.length > 0) {
            this.mIsUnwiderruflicheFreistellung = true;
            this.mDateUnwiderruflicheFreistellung = eeAbsentTimesTP[0].getValidFrom();
            return DateHelper.add((Date)eeAbsentTimesTP[0].getValidFrom(), (int)-1);
        }
        return this.mDateOfWithdrawal;
    }

    private String getLawArea(Date validTimePoint) {
        return this.getEECompanyPlant(validTimePoint).getLawArea();
    }
}

