/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.bea.dsne;

import com.varial.base.UtilitiesManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.personnel.domain.bea.account.BeaAccount;
import com.varial.personnel.domain.bea.basics.BasicRecord;
import com.varial.personnel.domain.bea.dbab.BeaDbab;
import com.varial.personnel.domain.bea.dbab.BeaDbabPersistencyManager;
import com.varial.personnel.domain.bea.dbag.BeaDbag;
import com.varial.personnel.domain.bea.dbag.BeaDbagPersistencyManager;
import com.varial.personnel.domain.bea.dban.BeaDban;
import com.varial.personnel.domain.bea.dban.BeaDbanPersistencyManager;
import com.varial.personnel.domain.bea.dbhn.BeaDbhn;
import com.varial.personnel.domain.bea.dbhn.BeaDbhnPersistencyManager;
import com.varial.personnel.domain.bea.dbna.BeaDbna;
import com.varial.personnel.domain.bea.dbna.BeaDbnaPersistencyManager;
import com.varial.personnel.domain.bea.dbnb.BeaDbnb;
import com.varial.personnel.domain.bea.dbnb.BeaDbnbPersistencyManager;
import com.varial.personnel.domain.bea.dbne.BeaDbne;
import com.varial.personnel.domain.bea.dbne.BeaDbnePersistencyManager;
import com.varial.personnel.domain.bea.dbsa.BeaDbsa;
import com.varial.personnel.domain.bea.dbsa.BeaDbsaPersistencyManager;
import com.varial.personnel.domain.bea.dsne.BeaDsnePersistencyManager;
import com.varial.personnel.domain.deuv.Deuv;
import com.varial.serverbase.persistency.PersistentObject;
import java.util.ArrayList;

public class BeaDsne
extends PersistentObject {
    private final BeaDsnePersistencyManager pm = (BeaDsnePersistencyManager)UtilitiesManager.getBean((String)"beaDsnePersistencyManager", BeaDsnePersistencyManager.class);
    private static final int PRIORITY = 5;
    private static final String DSNE = "DSNE";
    private int mVersionsnr;
    private BasicRecord mBasicRecord;
    private BeaAccount mBeaAccount;
    private BeaDbna mDbna;
    private boolean mMmDbna;
    private BeaDban mDban;
    private boolean mMmDban;
    private BeaDbag mDbag;
    private boolean mMmDbag;
    private BeaDbab mDbab;
    private boolean mMmDbab;
    private BeaDbne mDbne;
    private boolean mMmDbne;
    private BeaDbsa mDbsa;
    private boolean mMmDbsa;
    private BeaDbnb mDbnb;
    private boolean mMmDbnb;
    private BeaDbhn mDbhn;
    private boolean mMmDbhn;

    public BeaDsne getBeaDsneForBeaAccount(String oidBeaAccount) {
        BeaDsne[] rs = this.pm.getBeaDsnes(Restrictions.eq((String)"oidbeaaccount", (String)oidBeaAccount), null);
        if (rs.length != 1) {
            throw new IllegalStateException("Advice inconsistent, " + rs.length + " Dsne (not 1).");
        }
        return rs[0];
    }

    protected BeaDsne(int priority) {
        super(priority);
        this.mMmDbna = false;
        this.mMmDban = false;
        this.mMmDbag = false;
        this.mMmDbab = false;
        this.mMmDbne = false;
        this.mMmDbsa = false;
        this.mMmDbnb = false;
        this.mMmDbhn = false;
    }

    public BeaDsne() {
        this(5);
    }

    public BeaDsne(String objectID) {
        super(5, objectID);
    }

    public BeaDsne(String objectId, int version) {
        super(5, objectId, version);
    }

    public BeaDsne(boolean readOnly) {
        super(5, readOnly);
    }

    protected void load() {
        this.pm.load(this);
    }

    protected void saveImpl() throws BusinessDomainException {
        this.pm.save(this);
    }

    protected void deleteImpl() {
        this.pm.delete(this);
    }

    public String getClassName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getDomainKey() {
        return this.getObjectid();
    }

    public String getKennung() {
        this.requireLoaded();
        return DSNE;
    }

    public BeaAccount getBeaAccount() {
        this.requireLoaded();
        return this.mBeaAccount;
    }

    public void setBeaAccount(BeaAccount account) {
        this.mBeaAccount = account;
    }

    public int getVersionsnr() {
        return this.mVersionsnr;
    }

    public void setVersionsnr(int versionsnr) {
        this.mVersionsnr = versionsnr;
    }

    public BasicRecord getBasicRecord() {
        this.requireLoaded();
        return this.mBasicRecord;
    }

    public void setBasicRecord(BasicRecord basicRecord) {
        this.mBasicRecord = basicRecord;
    }

    public boolean hasMmDbna() {
        this.requireLoaded();
        return this.mMmDbna;
    }

    public boolean hasMmDban() {
        this.requireLoaded();
        return this.mMmDban;
    }

    public boolean hasMmDbag() {
        this.requireLoaded();
        return this.mMmDbag;
    }

    public boolean hasMmDbab() {
        this.requireLoaded();
        return this.mMmDbab;
    }

    public boolean hasMmDbne() {
        this.requireLoaded();
        return this.mMmDbne;
    }

    public boolean hasMmDbsa() {
        this.requireLoaded();
        return this.mMmDbsa;
    }

    public boolean hasMmDbnb() {
        this.requireLoaded();
        return this.mMmDbnb;
    }

    public boolean hasMmDbhn() {
        this.requireLoaded();
        return this.mMmDbhn;
    }

    public void setMmDbna(boolean mmDbna) {
        this.mMmDbna = mmDbna;
    }

    public void setMmDban(boolean mmDban) {
        this.mMmDban = mmDban;
    }

    public void setMmDbag(boolean mmDbag) {
        this.mMmDbag = mmDbag;
    }

    public void setMmDbab(boolean mmDbab) {
        this.mMmDbab = mmDbab;
    }

    public void setMmDbne(boolean mmDbne) {
        this.mMmDbne = mmDbne;
    }

    public void setMmDbsa(boolean mmDbsa) {
        this.mMmDbsa = mmDbsa;
    }

    public void setMmDbnb(boolean mmDbnb) {
        this.mMmDbnb = mmDbnb;
    }

    public void setMmDbhn(boolean mmDbhn) {
        this.mMmDbhn = mmDbhn;
    }

    private Criterion filter() {
        return Restrictions.eq((String)"oidbeadsne", (String)this.getObjectid());
    }

    public BeaDbna getDbna() {
        if (this.hasMmDbna() && this.mDbna == null) {
            this.mDbna = (BeaDbna)Deuv.checkDistinct((Object[])((BeaDbnaPersistencyManager)UtilitiesManager.getBean((String)"beaDbnaPersistencyManager", BeaDbnaPersistencyManager.class)).query(null, this.filter(), true));
        }
        return this.mDbna;
    }

    public BeaDban getDban() {
        if (this.hasMmDban() && this.mDban == null) {
            this.mDban = (BeaDban)Deuv.checkDistinct((Object[])((BeaDbanPersistencyManager)UtilitiesManager.getBean((String)"beaDbanPersistencyManager", BeaDbanPersistencyManager.class)).query(null, this.filter(), true));
        }
        return this.mDban;
    }

    public BeaDbag getDbag() {
        if (this.hasMmDbag() && this.mDbag == null) {
            this.mDbag = (BeaDbag)Deuv.checkDistinct((Object[])((BeaDbagPersistencyManager)UtilitiesManager.getBean((String)"beaDbagPersistencyManager", BeaDbagPersistencyManager.class)).query(null, this.filter(), true));
        }
        return this.mDbag;
    }

    public BeaDbab getDbab() {
        if (this.hasMmDbab() && this.mDbab == null) {
            this.mDbab = (BeaDbab)Deuv.checkDistinct((Object[])((BeaDbabPersistencyManager)UtilitiesManager.getBean((String)"beaDbabPersistencyManager", BeaDbabPersistencyManager.class)).query(null, this.filter(), true));
        }
        return this.mDbab;
    }

    public BeaDbne getDbne() {
        if (this.hasMmDbne() && this.mDbne == null) {
            this.mDbne = (BeaDbne)((Object)Deuv.checkDistinct((Object[])((BeaDbnePersistencyManager)UtilitiesManager.getBean((String)"beaDbnePersistencyManager", BeaDbnePersistencyManager.class)).query(null, this.filter(), true)));
        }
        return this.mDbne;
    }

    public BeaDbsa getDbsa() {
        if (this.hasMmDbsa() && this.mDbsa == null) {
            this.mDbsa = (BeaDbsa)Deuv.checkDistinct((Object[])((BeaDbsaPersistencyManager)UtilitiesManager.getBean((String)"beaDbsaPersistencyManager", BeaDbsaPersistencyManager.class)).query(null, this.filter(), true));
        }
        return this.mDbsa;
    }

    public BeaDbnb getDbnb() {
        if (this.hasMmDbnb() && this.mDbnb == null) {
            this.mDbnb = (BeaDbnb)Deuv.checkDistinct((Object[])((BeaDbnbPersistencyManager)UtilitiesManager.getBean((String)"beaDbnbPersistencyManager", BeaDbnbPersistencyManager.class)).query(null, this.filter(), true));
        }
        return this.mDbnb;
    }

    public BeaDbhn getDbhn() {
        if (this.hasMmDbhn() && this.mDbhn == null) {
            this.mDbhn = (BeaDbhn)Deuv.checkDistinct((Object[])((BeaDbhnPersistencyManager)UtilitiesManager.getBean((String)"beaDbhnPersistencyManager", BeaDbhnPersistencyManager.class)).query(null, this.filter(), true));
        }
        return this.mDbhn;
    }

    public BeaDbna createDbna() {
        if (this.mDbna != null) {
            throw new IllegalStateException("DBNA already exists");
        }
        this.mMmDbna = true;
        this.mDbna = new BeaDbna(this);
        return this.mDbna;
    }

    public BeaDban createDban() {
        if (this.mDban != null) {
            throw new IllegalStateException("DBAN already exists");
        }
        this.mMmDban = true;
        this.mDban = new BeaDban(this);
        return this.mDban;
    }

    public BeaDbag createDbag() {
        if (this.mDbag != null) {
            throw new IllegalStateException("DBAG already exists");
        }
        this.mMmDbag = true;
        this.mDbag = new BeaDbag(this);
        return this.mDbag;
    }

    public BeaDbab createDbab() {
        if (this.mDbab != null) {
            throw new IllegalStateException("DBAB already exists");
        }
        this.mMmDbab = true;
        this.mDbab = new BeaDbab(this);
        return this.mDbab;
    }

    public BeaDbne createDbne() {
        if (this.mDbne != null) {
            throw new IllegalStateException("DBNE already exists");
        }
        this.mMmDbne = true;
        this.mDbne = new BeaDbne(this);
        return this.mDbne;
    }

    public BeaDbsa createDbsa() {
        if (this.mDbsa != null) {
            throw new IllegalStateException("DBSA already exists");
        }
        this.mMmDbsa = true;
        this.mDbsa = new BeaDbsa(this);
        return this.mDbsa;
    }

    public BeaDbnb createDbnb() {
        if (this.mDbnb != null) {
            throw new IllegalStateException("DBNB already exists");
        }
        this.mMmDbnb = true;
        this.mDbnb = new BeaDbnb(this);
        return this.mDbnb;
    }

    public BeaDbhn createDbhn() {
        if (this.mDbhn != null) {
            throw new IllegalStateException("DBHN already exists");
        }
        this.mMmDbhn = true;
        this.mDbhn = new BeaDbhn(this);
        return this.mDbhn;
    }

    public void makeSaveable() {
        if (this.getDbna() != null) {
            this.mDbna.makeSaveable();
        }
        if (this.getDban() != null) {
            this.mDban.makeSaveable();
        }
        if (this.getDbag() != null) {
            this.mDbag.makeSaveable();
        }
        if (this.getDbab() != null) {
            this.mDbab.makeSaveable();
        }
        if (this.getDbne() != null) {
            this.mDbne.makeSaveable();
        }
        if (this.getDbsa() != null) {
            this.mDbsa.makeSaveable();
        }
        if (this.getDbnb() != null) {
            this.mDbnb.makeSaveable();
        }
        if (this.getDbhn() != null) {
            this.mDbhn.makeSaveable();
        }
        super.makeSaveable();
    }

    public void makeReadOnly() {
        if (this.getDbna() != null) {
            this.mDbna.makeReadOnly();
        }
        if (this.getDban() != null) {
            this.mDban.makeReadOnly();
        }
        if (this.getDbag() != null) {
            this.mDbag.makeReadOnly();
        }
        if (this.getDbab() != null) {
            this.mDbab.makeReadOnly();
        }
        if (this.getDbne() != null) {
            this.mDbne.makeReadOnly();
        }
        if (this.getDbsa() != null) {
            this.mDbsa.makeReadOnly();
        }
        if (this.getDbnb() != null) {
            this.mDbnb.makeReadOnly();
        }
        if (this.getDbhn() != null) {
            this.mDbhn.makeReadOnly();
        }
        super.makeReadOnly();
    }

    public BeaDsne createNew(BeaAccount account) throws BusinessDomainException {
        BeaDsne bo = account.createBeaDsne();
        bo.mVersionsnr = this.mVersionsnr;
        bo.mBasicRecord = this.getBasicRecord().createNew();
        if (this.getDbna() != null) {
            this.mDban.createNew(bo);
        }
        if (this.getDban() != null) {
            this.mDban.createNew(bo);
        }
        if (this.getDbag() != null) {
            this.mDbag.createNew(bo);
        }
        if (this.getDbab() != null) {
            this.mDbab.createNew(bo);
        }
        if (this.getDbne() != null) {
            this.mDbne.createNew(bo);
        }
        if (this.getDbsa() != null) {
            this.mDbsa.createNew(bo);
        }
        if (this.getDbnb() != null) {
            this.mDbnb.createNew(bo);
        }
        if (this.getDbhn() != null) {
            this.mDbhn.createNew(bo);
        }
        bo.mMmDbna = this.mMmDbna;
        bo.mMmDban = this.mMmDban;
        bo.mMmDbag = this.mMmDbag;
        bo.mMmDbab = this.mMmDbab;
        bo.mMmDbne = this.mMmDbne;
        bo.mMmDbsa = this.mMmDbsa;
        bo.mMmDbnb = this.mMmDbnb;
        bo.mMmDbhn = this.mMmDbhn;
        return bo;
    }

    public String checkAttributes() {
        ArrayList<String> errorList = new ArrayList<String>();
        errorList.addAll(this.getDbag().checkAttributes());
        errorList.addAll(this.getDbne().checkAttributes());
        Object errorMessage = "";
        for (int i = 0; i < errorList.size(); ++i) {
            errorMessage = (String)errorMessage + (String)errorList.get(i) + " ";
        }
        if (((String)errorMessage).length() > 249) {
            errorMessage = ((String)errorMessage).substring(0, 249);
            errorMessage = (String)errorMessage + " ...";
        }
        return errorMessage;
    }

    public String toString() {
        return "BeaDsne [mVersionsnr = " + this.mVersionsnr + this.mBasicRecord.toString() + ", mMmDbna = " + this.mMmDbna + ", mMmDban = " + this.mMmDban + ", mMmDbag = " + this.mMmDbag + ", mMmDbab = " + this.mMmDbab + ", mMmDbne = " + this.mMmDbne + ", mMmDbsa = " + this.mMmDbsa + ", mMmDbnb = " + this.mMmDbnb + ", mMmDbhn = " + this.mMmDbhn + "]";
    }
}

