/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.bea.dsab;

import com.varial.base.UtilitiesManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Order;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.bea.account.BeaAccount;
import com.varial.personnel.domain.bea.basics.BasicRecord;
import com.varial.personnel.domain.bea.dbab.BeaDbab;
import com.varial.personnel.domain.bea.dbab.BeaDbabPersistencyManager;
import com.varial.personnel.domain.bea.dbag.BeaDbag;
import com.varial.personnel.domain.bea.dbag.BeaDbagPersistencyManager;
import com.varial.personnel.domain.bea.dban.BeaDban;
import com.varial.personnel.domain.bea.dban.BeaDbanPersistencyManager;
import com.varial.personnel.domain.bea.dbaz.BeaDbaz;
import com.varial.personnel.domain.bea.dbaz.BeaDbazPersistencyManager;
import com.varial.personnel.domain.bea.dben.BeaDben;
import com.varial.personnel.domain.bea.dben.BeaDbenPersistencyManager;
import com.varial.personnel.domain.bea.dbfz.BeaDbfz;
import com.varial.personnel.domain.bea.dbfz.BeaDbfzPersistencyManager;
import com.varial.personnel.domain.bea.dbha.BeaDbha;
import com.varial.personnel.domain.bea.dbha.BeaDbhaPersistencyManager;
import com.varial.personnel.domain.bea.dbke.BeaDbke;
import com.varial.personnel.domain.bea.dbke.BeaDbkePersistencyManager;
import com.varial.personnel.domain.bea.dbna.BeaDbna;
import com.varial.personnel.domain.bea.dbna.BeaDbnaPersistencyManager;
import com.varial.personnel.domain.bea.dbsa.BeaDbsa;
import com.varial.personnel.domain.bea.dbsa.BeaDbsaPersistencyManager;
import com.varial.personnel.domain.bea.dbsb.BeaDbsb;
import com.varial.personnel.domain.bea.dbsb.BeaDbsbPersistencyManager;
import com.varial.personnel.domain.bea.dbse.BeaDbse;
import com.varial.personnel.domain.bea.dbse.BeaDbsePersistencyManager;
import com.varial.personnel.domain.bea.dsab.BeaDsabPersistencyManager;
import com.varial.personnel.domain.deuv.Deuv;
import com.varial.serverbase.persistency.PersistentObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;

public class BeaDsab
extends PersistentObject {
    private final BeaDsabPersistencyManager pm = (BeaDsabPersistencyManager)UtilitiesManager.getBean((String)"beaDsabPersistencyManager", BeaDsabPersistencyManager.class);
    private static final int PRIORITY = 5;
    private static final String DSAB = "DSAB";
    private int mVersionsnr;
    private BasicRecord mBasicRecord;
    private BeaAccount mBeaAccount;
    private BeaDbna mDbna;
    private boolean mMmDbna;
    private BeaDban mDban;
    private boolean mMmDban;
    private BeaDbag mDbag;
    private boolean mMmDbag;
    private BeaDbab mDbab;
    private boolean mMmDbab;
    private BeaDbse[] mDbse;
    private boolean mMmDbse;
    private BeaDbsa mDbsa;
    private boolean mMmDbsa;
    private BeaDbsb[] mDbsb;
    private boolean mMmDbsb;
    private BeaDbaz[] mDbaz;
    private boolean mMmDbaz;
    private BeaDben[] mDben;
    private boolean mMmDben;
    private BeaDbfz[] mDbfz;
    private boolean mMmDbfz;
    private BeaDbha mDbha;
    private boolean mMmDbha;
    private BeaDbke mDbke;
    private boolean mMmDbke;

    public BeaDsab getBeaDsabForBeaAccount(String oidBeaAccount) {
        BeaDsab[] rs = this.pm.getBeaDsabs(Restrictions.eq((String)"oidbeaaccount", (String)oidBeaAccount), null);
        if (rs.length != 1) {
            throw new IllegalStateException("Advice inconsistent, " + rs.length + " Dsab (not 1).");
        }
        return rs[0];
    }

    protected BeaDsab(int priority) {
        super(priority);
        this.mMmDbna = false;
        this.mMmDban = false;
        this.mMmDbag = false;
        this.mMmDbab = false;
        this.mMmDbse = false;
        this.mMmDbsa = false;
        this.mMmDbsb = false;
        this.mMmDbaz = false;
        this.mMmDben = false;
        this.mMmDbfz = false;
        this.mMmDbha = false;
        this.mMmDbke = false;
    }

    public BeaDsab() {
        this(5);
    }

    public BeaDsab(String objectID) {
        super(5, objectID);
    }

    public BeaDsab(String objectId, int version) {
        super(5, objectId, version);
    }

    public BeaDsab(boolean readOnly) {
        super(5, readOnly);
    }

    protected void load() {
        this.pm.load(this);
    }

    protected void saveImpl() throws BusinessDomainException {
        this.pm.save(this);
    }

    protected void deleteImpl() {
        this.pm.delete(this);
    }

    public String getClassName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getDomainKey() {
        return this.getObjectid();
    }

    public String getKennung() {
        this.requireLoaded();
        return DSAB;
    }

    public BeaAccount getBeaAccount() {
        this.requireLoaded();
        return this.mBeaAccount;
    }

    public void setBeaAccount(BeaAccount account) {
        this.mBeaAccount = account;
    }

    public int getVersionsnr() {
        return this.mVersionsnr;
    }

    public void setVersionsnr(int versionsnr) {
        this.mVersionsnr = versionsnr;
    }

    public BasicRecord getBasicRecord() {
        this.requireLoaded();
        return this.mBasicRecord;
    }

    public void setBasicRecord(BasicRecord basicRecord) {
        this.mBasicRecord = basicRecord;
    }

    public boolean hasMmDbna() {
        this.requireLoaded();
        return this.mMmDbna;
    }

    public boolean hasMmDban() {
        this.requireLoaded();
        return this.mMmDban;
    }

    public boolean hasMmDbag() {
        this.requireLoaded();
        return this.mMmDbag;
    }

    public boolean hasMmDbab() {
        this.requireLoaded();
        return this.mMmDbab;
    }

    public boolean hasMmDbse() {
        this.requireLoaded();
        return this.mMmDbse;
    }

    public boolean hasMmDbsa() {
        this.requireLoaded();
        return this.mMmDbsa;
    }

    public boolean hasMmDbsb() {
        this.requireLoaded();
        return this.mMmDbsb;
    }

    public boolean hasMmDbaz() {
        this.requireLoaded();
        return this.mMmDbaz;
    }

    public boolean hasMmDben() {
        this.requireLoaded();
        return this.mMmDben;
    }

    public boolean hasMmDbfz() {
        this.requireLoaded();
        return this.mMmDbfz;
    }

    public boolean hasMmDbha() {
        this.requireLoaded();
        return this.mMmDbha;
    }

    public boolean hasMmDbke() {
        this.requireLoaded();
        return this.mMmDbke;
    }

    public void setMmDbna(boolean mmDbna) {
        this.mMmDbna = mmDbna;
    }

    public void setMmDban(boolean mmDban) {
        this.mMmDban = mmDban;
    }

    public void setMmDbag(boolean mmDbag) {
        this.mMmDbag = mmDbag;
    }

    public void setMmDbab(boolean mmDbab) {
        this.mMmDbab = mmDbab;
    }

    public void setMmDbse(boolean mmDbse) {
        this.mMmDbse = mmDbse;
    }

    public void setMmDbsa(boolean mmDbsa) {
        this.mMmDbsa = mmDbsa;
    }

    public void setMmDbsb(boolean mmDbsb) {
        this.mMmDbsb = mmDbsb;
    }

    public void setMmDbaz(boolean mmDbaz) {
        this.mMmDbaz = mmDbaz;
    }

    public void setMmDben(boolean mmDben) {
        this.mMmDben = mmDben;
    }

    public void setMmDbfz(boolean mmDbfz) {
        this.mMmDbfz = mmDbfz;
    }

    public void setMmDbha(boolean mmDbha) {
        this.mMmDbha = mmDbha;
    }

    public void setMmDbke(boolean mmDbke) {
        this.mMmDbke = mmDbke;
    }

    private Criterion filter() {
        return Restrictions.eq((String)"oidbeadsab", (String)this.getObjectid());
    }

    public BeaDbna getDbna() {
        if (this.hasMmDbna() && this.mDbna == null) {
            this.mDbna = (BeaDbna)Deuv.checkDistinct((Object[])((BeaDbnaPersistencyManager)UtilitiesManager.getBean((String)"beaDbnaPersistencyManager", BeaDbnaPersistencyManager.class)).query(null, this.filter(), true));
        }
        return this.mDbna;
    }

    public BeaDban getDban() {
        if (this.hasMmDban() && this.mDban == null) {
            this.mDban = (BeaDban)Deuv.checkDistinct((Object[])((BeaDbanPersistencyManager)UtilitiesManager.getBean((String)"beaDbanPersistencyManager", BeaDbanPersistencyManager.class)).query(null, this.filter(), true));
        }
        return this.mDban;
    }

    public BeaDbag getDbag() {
        if (this.hasMmDbag() && this.mDbag == null) {
            this.mDbag = (BeaDbag)Deuv.checkDistinct((Object[])((BeaDbagPersistencyManager)UtilitiesManager.getBean((String)"beaDbagPersistencyManager", BeaDbagPersistencyManager.class)).query(null, this.filter(), true));
        }
        return this.mDbag;
    }

    public BeaDbab getDbab() {
        if (this.hasMmDbab() && this.mDbab == null) {
            this.mDbab = (BeaDbab)Deuv.checkDistinct((Object[])((BeaDbabPersistencyManager)UtilitiesManager.getBean((String)"beaDbabPersistencyManager", BeaDbabPersistencyManager.class)).query(null, this.filter(), true));
        }
        return this.mDbab;
    }

    public BeaDbse[] getDbse() {
        if (this.hasMmDbse() && (this.mDbse == null || this.mDbse.length == 0)) {
            this.mDbse = ((BeaDbsePersistencyManager)UtilitiesManager.getBean((String)"beaDbsePersistencyManager", BeaDbsePersistencyManager.class)).query(null, this.filter(), true);
            Arrays.sort(this.mDbse, (o1, o2) -> DateHelper.compareDateWithNull((Date)o1.getAestedatbeg(), (Date)o2.getAestedatbeg()));
        }
        return this.mDbse == null ? new BeaDbse[]{} : this.mDbse;
    }

    public BeaDbsa getDbsa() {
        if (this.hasMmDbsa() && this.mDbsa == null) {
            this.mDbsa = (BeaDbsa)Deuv.checkDistinct((Object[])((BeaDbsaPersistencyManager)UtilitiesManager.getBean((String)"beaDbsaPersistencyManager", BeaDbsaPersistencyManager.class)).query(null, this.filter(), true));
        }
        return this.mDbsa;
    }

    public BeaDbsb[] getDbsb() {
        if (this.hasMmDbsb() && (this.mDbsb == null || this.mDbsb.length == 0)) {
            this.mDbsb = ((BeaDbsbPersistencyManager)UtilitiesManager.getBean((String)"beaDbsbPersistencyManager", BeaDbsbPersistencyManager.class)).query(new Order[]{Order.asc((String)"PERSBYGRBEG")}, this.filter(), true);
        }
        return this.mDbsb == null ? new BeaDbsb[]{} : this.mDbsb;
    }

    public BeaDbaz[] getDbaz() {
        if (this.hasMmDbaz() && (this.mDbaz == null || this.mDbaz.length == 0)) {
            this.mDbaz = ((BeaDbazPersistencyManager)UtilitiesManager.getBean((String)"beaDbazPersistencyManager", BeaDbazPersistencyManager.class)).query(null, this.filter(), true);
            Arrays.sort(this.mDbaz, (o1, o2) -> DateHelper.compareDateWithNull((Date)o1.getAzaebeg(), (Date)o2.getAzaebeg()));
        }
        return this.mDbaz == null ? new BeaDbaz[]{} : this.mDbaz;
    }

    public BeaDben[] getDben() {
        if (this.hasMmDben() && (this.mDben == null || this.mDben.length == 0)) {
            this.mDben = ((BeaDbenPersistencyManager)UtilitiesManager.getBean((String)"beaDbenPersistencyManager", BeaDbenPersistencyManager.class)).query(new Order[]{Order.asc((String)"MONATBEG")}, this.filter(), true);
        }
        return this.mDben == null ? new BeaDben[]{} : this.mDben;
    }

    public BeaDbfz[] getDbfz() {
        if (this.hasMmDbfz() && (this.mDbfz == null || this.mDbfz.length == 0)) {
            this.mDbfz = ((BeaDbfzPersistencyManager)UtilitiesManager.getBean((String)"beaDbfzPersistencyManager", BeaDbfzPersistencyManager.class)).query(new Order[]{Order.asc((String)"FEHLBEG")}, this.filter(), true);
        }
        return this.mDbfz == null ? new BeaDbfz[]{} : this.mDbfz;
    }

    public BeaDbha getDbha() {
        if (this.hasMmDbha() && this.mDbha == null) {
            this.mDbha = (BeaDbha)Deuv.checkDistinct((Object[])((BeaDbhaPersistencyManager)UtilitiesManager.getBean((String)"beaDbhaPersistencyManager", BeaDbhaPersistencyManager.class)).query(null, this.filter(), true));
        }
        return this.mDbha;
    }

    public BeaDbke getDbke() {
        if (this.hasMmDbke() && this.mDbke == null) {
            this.mDbke = (BeaDbke)((Object)Deuv.checkDistinct((Object[])((BeaDbkePersistencyManager)UtilitiesManager.getBean((String)"beaDbkePersistencyManager", BeaDbkePersistencyManager.class)).query(null, this.filter(), true)));
        }
        return this.mDbke;
    }

    public BeaDbna createDbna() {
        if (this.mDbna != null) {
            throw new IllegalStateException("DBNA already exists");
        }
        this.mMmDbna = true;
        this.mDbna = new BeaDbna(this);
        return this.mDbna;
    }

    public BeaDban createDban() {
        if (this.mDban != null) {
            throw new IllegalStateException("DBAN already exists");
        }
        this.mMmDban = true;
        this.mDban = new BeaDban(this);
        return this.mDban;
    }

    public BeaDbag createDbag() {
        if (this.mDbag != null) {
            throw new IllegalStateException("DBAG already exists");
        }
        this.mMmDbag = true;
        this.mDbag = new BeaDbag(this);
        return this.mDbag;
    }

    public BeaDbab createDbab() {
        if (this.mDbab != null) {
            throw new IllegalStateException("DBAB already exists");
        }
        this.mMmDbab = true;
        this.mDbab = new BeaDbab(this);
        return this.mDbab;
    }

    public BeaDbse[] createDbse(int length) {
        if (this.mDbse != null && this.mDbse.length > 0) {
            throw new IllegalStateException("DBSE already exists");
        }
        this.mMmDbse = true;
        this.mDbse = new BeaDbse[length];
        for (int i = 0; i < this.mDbse.length; ++i) {
            this.mDbse[i] = this.createDbse();
        }
        return this.mDbse;
    }

    public BeaDbse createDbse() {
        return new BeaDbse(this);
    }

    public void setDbse(BeaDbse[] dbse) {
        this.mDbse = dbse;
    }

    public BeaDbsa createDbsa() {
        if (this.mDbsa != null) {
            throw new IllegalStateException("DBSA already exists");
        }
        this.mMmDbsa = true;
        this.mDbsa = new BeaDbsa(this);
        return this.mDbsa;
    }

    public BeaDbsb[] createDbsb(int length) {
        if (this.mDbsb != null && this.mDbsb.length > 0) {
            throw new IllegalStateException("DBSB already exists");
        }
        this.mMmDbsb = true;
        this.mDbsb = new BeaDbsb[length];
        for (int i = 0; i < this.mDbsb.length; ++i) {
            this.mDbsb[i] = this.createDbsb();
        }
        return this.mDbsb;
    }

    public BeaDbsb createDbsb() {
        return new BeaDbsb(this);
    }

    public void setDbsb(BeaDbsb[] dbsb) {
        this.mDbsb = dbsb;
    }

    public BeaDbaz[] createDbaz(int length) {
        if (this.mDbaz != null && this.mDbaz.length > 0) {
            throw new IllegalStateException("DBAZ already exists");
        }
        this.mMmDbaz = true;
        this.mDbaz = new BeaDbaz[length];
        for (int i = 0; i < this.mDbaz.length; ++i) {
            this.mDbaz[i] = this.createDbaz();
        }
        return this.mDbaz;
    }

    public BeaDbaz createDbaz() {
        return new BeaDbaz(this);
    }

    public void setDbaz(BeaDbaz[] dbaz) {
        this.mDbaz = dbaz;
    }

    public BeaDben[] createDben(int length) {
        if (this.mDben != null && this.mDben.length > 0) {
            throw new IllegalStateException("DBEN already exists");
        }
        this.mMmDben = true;
        this.mDben = new BeaDben[length];
        for (int i = 0; i < this.mDben.length; ++i) {
            this.mDben[i] = this.createDben();
        }
        return this.mDben;
    }

    public BeaDben createDben() {
        return new BeaDben(this);
    }

    public void setDben(BeaDben[] dben) {
        this.mDben = dben;
    }

    public BeaDbfz[] createDbfz(int length) {
        if (this.mDbfz != null && this.mDbfz.length > 0) {
            throw new IllegalStateException("DBFZ already exists");
        }
        this.mMmDbfz = true;
        this.mDbfz = new BeaDbfz[length];
        for (int i = 0; i < this.mDbfz.length; ++i) {
            this.mDbfz[i] = this.createDbfz();
        }
        return this.mDbfz;
    }

    public BeaDbfz createDbfz() {
        return new BeaDbfz(this);
    }

    public void setDbfz(BeaDbfz[] dbfz) {
        this.mDbfz = dbfz;
    }

    public BeaDbha createDbha() {
        if (this.mDbha != null) {
            throw new IllegalStateException("DBHA already exists");
        }
        this.mMmDbha = true;
        this.mDbha = new BeaDbha(this);
        return this.mDbha;
    }

    public BeaDbke createDbke() {
        if (this.mDbke != null) {
            throw new IllegalStateException("DBKE already exists");
        }
        this.mMmDbke = true;
        this.mDbke = new BeaDbke(this);
        return this.mDbke;
    }

    public void makeSaveable() {
        if (this.getDbna() != null) {
            this.mDbna.makeSaveable();
        }
        if (this.getDban() != null) {
            this.mDban.makeSaveable();
        }
        if (this.getDbag() != null) {
            this.mDbag.makeSaveable();
        }
        if (this.getDbab() != null) {
            this.mDbab.makeSaveable();
        }
        for (BeaDbse beaDbse : this.getDbse()) {
            beaDbse.makeSaveable();
        }
        if (this.getDbsa() != null) {
            this.getDbsa().makeSaveable();
        }
        for (BeaDbsb beaDbsb : this.getDbsb()) {
            beaDbsb.makeSaveable();
        }
        for (BeaDbaz beaDbaz : this.getDbaz()) {
            beaDbaz.makeSaveable();
        }
        for (BeaDben beaDben : this.getDben()) {
            beaDben.makeSaveable();
        }
        for (BeaDbfz beaDbfz : this.getDbfz()) {
            beaDbfz.makeSaveable();
        }
        if (this.getDbha() != null) {
            this.mDbha.makeSaveable();
        }
        if (this.getDbke() != null) {
            this.mDbke.makeSaveable();
        }
        super.makeSaveable();
    }

    public void makeReadOnly() {
        if (this.getDbna() != null) {
            this.mDbna.makeReadOnly();
        }
        if (this.getDban() != null) {
            this.mDban.makeReadOnly();
        }
        if (this.getDbag() != null) {
            this.mDbag.makeReadOnly();
        }
        if (this.getDbab() != null) {
            this.mDbab.makeReadOnly();
        }
        for (BeaDbse beaDbse : this.getDbse()) {
            beaDbse.makeReadOnly();
        }
        if (this.getDbsa() != null) {
            this.mDbsa.makeReadOnly();
        }
        for (BeaDbsb beaDbsb : this.getDbsb()) {
            beaDbsb.makeReadOnly();
        }
        for (BeaDbaz beaDbaz : this.getDbaz()) {
            beaDbaz.makeReadOnly();
        }
        for (BeaDben beaDben : this.getDben()) {
            beaDben.makeReadOnly();
        }
        for (BeaDbfz beaDbfz : this.getDbfz()) {
            beaDbfz.makeReadOnly();
        }
        if (this.getDbha() != null) {
            this.mDbha.makeReadOnly();
        }
        if (this.getDbke() != null) {
            this.mDbke.makeReadOnly();
        }
        super.makeReadOnly();
    }

    public BeaDsab createNew(BeaAccount account) throws BusinessDomainException {
        int i;
        BeaDsab bo = account.createBeaDsab();
        bo.mVersionsnr = this.mVersionsnr;
        bo.mBasicRecord = this.getBasicRecord().createNew();
        if (this.getDbna() != null) {
            this.mDban.createNew(bo);
        }
        if (this.getDban() != null) {
            this.mDban.createNew(bo);
        }
        if (this.getDbag() != null) {
            this.mDbag.createNew(bo);
        }
        if (this.getDbab() != null) {
            this.mDbab.createNew(bo);
        }
        if (this.getDbse().length > 0) {
            BeaDbse[] newDbse = new BeaDbse[this.mDbse.length];
            for (i = 0; i < newDbse.length; ++i) {
                newDbse[i] = this.mDbse[i].createNew(bo);
            }
            bo.mDbse = newDbse;
        }
        if (this.getDbsb().length > 0) {
            BeaDbsb[] newDbsb = new BeaDbsb[this.mDbsb.length];
            for (i = 0; i < newDbsb.length; ++i) {
                newDbsb[i] = this.mDbsb[i].createNew(bo);
            }
            bo.mDbsb = newDbsb;
        }
        if (this.getDbaz().length > 0) {
            BeaDbaz[] newDbaz = new BeaDbaz[this.mDbaz.length];
            for (i = 0; i < newDbaz.length; ++i) {
                newDbaz[i] = this.mDbaz[i].createNew(bo);
            }
            bo.mDbaz = newDbaz;
        }
        if (this.getDben().length > 0) {
            BeaDben[] newDben = new BeaDben[this.mDben.length];
            for (i = 0; i < newDben.length; ++i) {
                newDben[i] = this.mDben[i].createNew(bo);
            }
            bo.mDben = newDben;
        }
        if (this.getDbfz().length > 0) {
            BeaDbfz[] newDbfz = new BeaDbfz[this.mDbfz.length];
            for (i = 0; i < newDbfz.length; ++i) {
                newDbfz[i] = this.mDbfz[i].createNew(bo);
            }
            bo.mDbfz = newDbfz;
        }
        if (this.getDbha() != null) {
            this.mDbha.createNew(bo);
        }
        if (this.getDbke() != null) {
            this.mDbke.createNew(bo);
        }
        bo.mMmDbna = this.mMmDbna;
        bo.mMmDban = this.mMmDban;
        bo.mMmDbag = this.mMmDbag;
        bo.mMmDbab = this.mMmDbab;
        bo.mMmDbse = this.mMmDbse;
        bo.mMmDbsa = this.mMmDbsa;
        bo.mMmDbsb = this.mMmDbsb;
        bo.mMmDbaz = this.mMmDbaz;
        bo.mMmDben = this.mMmDben;
        bo.mMmDbfz = this.mMmDbfz;
        bo.mMmDbha = this.mMmDbha;
        bo.mMmDbke = this.mMmDbke;
        return bo;
    }

    public String checkAttributes() {
        ArrayList<String> errorList = new ArrayList<String>();
        errorList.addAll(this.getDbag().checkAttributes());
        errorList.addAll(this.getDbke().checkAttributes(this));
        ArrayList<Date> dateWithReason04 = new ArrayList<Date>();
        for (BeaDbaz beaDbaz : this.getDbaz()) {
            errorList.addAll(beaDbaz.checkAttributes());
            if (beaDbaz.getAzaegr() != 4) continue;
            dateWithReason04.add(beaDbaz.getAzaebeg());
        }
        for (PersistentObject persistentObject : this.getDben()) {
            errorList.addAll(persistentObject.checkAttributes(dateWithReason04));
        }
        Object errorMessage = "";
        for (int i = 0; i < errorList.size(); ++i) {
            errorMessage = (String)errorMessage + (String)errorList.get(i) + " ";
        }
        if (((String)errorMessage).length() > 249) {
            errorMessage = ((String)errorMessage).substring(0, 249);
            errorMessage = (String)errorMessage + " ...";
        }
        return errorMessage;
    }

    public String toString() {
        return "BeaDsab [mVersionsnr = " + this.mVersionsnr + this.mBasicRecord.toString() + ", mMmDbna = " + this.mMmDbna + ", mMmDban = " + this.mMmDban + ", mMmDbag = " + this.mMmDbag + ", mMmDbab = " + this.mMmDbab + ", mMmDbse = " + this.mMmDbse + ", mMmDbsa = " + this.mMmDbsa + ", mMmDbsb = " + this.mMmDbsb + ", mMmDbaz = " + this.mMmDbaz + ", mMmDben = " + this.mMmDben + ", mMmDbfz = " + this.mMmDbfz + ", mMmDbha = " + this.mMmDbha + ", mMmDbha = " + this.mMmDbha + "]";
    }
}

