/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.bea.dbaz;

import com.varial.base.UtilitiesManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.personnel.domain.bea.dbaz.BeaDbazPersistencyManager;
import com.varial.personnel.domain.bea.dsab.BeaDsab;
import com.varial.personnel.domain.bea.mapper.BeaExceptionMapper;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.persistency.PersistentObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class BeaDbaz
extends PersistentObject {
    private final BeaDbazPersistencyManager pm = (BeaDbazPersistencyManager)UtilitiesManager.getBean((String)"beaDbazPersistencyManager", BeaDbazPersistencyManager.class);
    private static final int PRIORITY = 10;
    private static final String DBAZ = "DBAZ";
    private BeaDsab mBeaDsab;
    private BigDecimal mAzwoech;
    private BigDecimal mAzvg;
    private int mAzaegr;
    private Date mAzaebeg;

    public BeaDbaz() {
        super(10);
    }

    public BeaDbaz(String objectID) {
        super(10, objectID);
    }

    public BeaDbaz(String objectId, int version) {
        super(10, objectId, version);
    }

    protected BeaDbaz(boolean readOnly) {
        super(10, readOnly);
    }

    public BeaDbaz(BeaDsab dsab) {
        this();
        this.mBeaDsab = dsab;
    }

    protected void load() {
        this.pm.load(this);
    }

    protected void saveImpl() throws BusinessDomainException {
        this.pm.save(this);
    }

    protected void deleteImpl() {
        this.pm.delete(this);
    }

    public String getClassName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getDomainKey() {
        return this.getObjectid();
    }

    public BeaDsab getBeaDsab() {
        this.requireLoaded();
        return this.mBeaDsab;
    }

    public void setBeaDsab(BeaDsab beaDsab) {
        this.mBeaDsab = beaDsab;
    }

    public String getKennung() {
        return DBAZ;
    }

    public BigDecimal getAzwoech() {
        this.requireLoaded();
        return this.mAzwoech;
    }

    public void setAzwoech(BigDecimal azwoech) {
        this.mAzwoech = azwoech;
    }

    public BigDecimal getAzvg() {
        this.requireLoaded();
        return this.mAzvg;
    }

    public void setAzvg(BigDecimal azvg) {
        this.mAzvg = azvg;
    }

    public int getAzaegr() {
        this.requireLoaded();
        return this.mAzaegr;
    }

    public void setAzaegr(int azaegr) {
        this.mAzaegr = azaegr;
    }

    public Date getAzaebeg() {
        this.requireLoaded();
        return this.mAzaebeg;
    }

    public void setAzaebeg(Date azaebeg) {
        this.mAzaebeg = azaebeg;
    }

    public BeaDbaz createNew(BeaDsab dsab) {
        this.requireLoaded();
        BeaDbaz bo = dsab.createDbaz();
        bo.setAzwoech(this.mAzwoech);
        bo.setAzvg(this.mAzvg);
        bo.setAzaegr(this.mAzaegr);
        bo.setAzaebeg(this.mAzaebeg);
        return bo;
    }

    public void init() {
        this.mAzwoech = BigDecimal.ZERO;
        this.mAzvg = BigDecimal.ZERO;
        this.mAzaegr = 0;
        this.mAzaebeg = null;
    }

    public String toString() {
        return "BeaDbaz [ , mAzwoech = " + this.mAzwoech + ", mAzvg = " + this.mAzvg + ", mAzaegr = " + this.mAzaegr + ", mAzaebeg = " + this.mAzaebeg + "]";
    }

    public String getAzaebegR() {
        return DateMapper.toDDMMYYYYPointSeparationString((Date)this.getAzaebeg());
    }

    public String getAzwoechR() {
        return BigDecimalMapper.toString((BigDecimal)this.getAzwoech());
    }

    public String getAzvgR() {
        return BigDecimalMapper.toString((BigDecimal)this.getAzvg());
    }

    public String getAzaegrR() {
        return "" + this.getAzaegr();
    }

    public List<String> checkAttributes() {
        ArrayList<String> errorList = new ArrayList<String>();
        if (this.mAzaebeg != null && BigDecimalMapper.isZeroOrNull((BigDecimal)this.mAzvg)) {
            errorList.add(BeaExceptionMapper.mErrorList.getDefaultString(8));
        }
        return errorList;
    }
}

