/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.assignments.pcompanyaccidentinsurancefund;

import com.varial.base.exception.BusinessDomainException;
import com.varial.base.session.SessionContext;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.assignments.pcompanyaccidentinsurancefund.AssignmentPCompanyAccidentInsuranceFund;
import com.varial.personnel.domain.assignments.pcompanyaccidentinsurancefund.AssignmentPCompanyAccidentInsuranceFundTPPersistencyManager;
import com.varial.personnel.domain.assignments.pcompanyaccidentinsurancefund.accidentinsurancefundvaluetype.AccidentInsuranceFundValuetype;
import com.varial.personnel.domain.assignments.pcompanyaccidentinsurancefund.assignmentcontact.AssignmentPCompanyAccidentInsuranceFundContact;
import com.varial.personnel.domain.assignments.pcompanyaccidentinsurancefund.mapper.AssignmentPCompanyAccidentInsuranceFundExceptionMapper;
import com.varial.personnel.domain.global.accidentinsurancefund.AccidentInsuranceFund;
import com.varial.personnel.domain.pcompany.PCompany;
import com.varial.personnel.domain.pcompany.mapper.PCompanyExceptionMapper;
import com.varial.personnel.domain.plant.mapper.PlantExceptionMapper;
import com.varial.personnel.domain.uv.UvHelper;
import com.varial.personnel.domain.uv.mapper.UvExceptionMapper;
import com.varial.personnel.framework.PersonnelTimedPersistenceObject;
import com.varial.personnel.framework.basictypes.Communication;
import com.varial.personnel.framework.checkup.CheckUp;
import com.varial.personnel.framework.checkup.MembershipNumberOfAIF;
import com.varial.personnel.framework.mapper.FrameWorkExceptionMapper;
import com.varial.personnel.framework.personnelbasic.PersonnelBasic;
import com.varial.personnel.framework.taskreminder.TaskReminderHelper;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.StringMapper;
import java.util.Date;

public class AssignmentPCompanyAccidentInsuranceFundTP
extends PersonnelTimedPersistenceObject {
    private static final int PRIORITY = 2;
    private static final Date START_OF_CHECK_MEMBERSHIPNUMBER = DateMapper.toDate((String)"2009-12-01");
    private AssignmentPCompanyAccidentInsuranceFund mAssignmentPCompanyAccidentInsuranceFund;
    private String mMembershipNumber;
    private Communication mCommunication;
    private AccidentInsuranceFundValuetype[] mValueTypes;
    private AccidentInsuranceFundValuetype[] mNewValueTypes;
    private boolean mGenerallyResponsible;
    private boolean mParticipationOnUV;
    private String mPin;
    private int mSerialNumber;
    private String mBbnrLB;
    private String mBbnrAS;
    private boolean mMembershipNotValid;
    private String mUnrs;
    private AssignmentPCompanyAccidentInsuranceFundTP mOld = null;

    public AssignmentPCompanyAccidentInsuranceFundTP(AssignmentPCompanyAccidentInsuranceFund apaif) {
        super(2);
        this.mAssignmentPCompanyAccidentInsuranceFund = apaif;
    }

    public AssignmentPCompanyAccidentInsuranceFundTP(AssignmentPCompanyAccidentInsuranceFund apaif, boolean readOnly) {
        super(2, readOnly);
        this.mAssignmentPCompanyAccidentInsuranceFund = apaif;
    }

    public static AssignmentPCompanyAccidentInsuranceFundTP getAssignmentPCompanyAccidentInsuranceFundTP(String objectID) {
        return new AssignmentPCompanyAccidentInsuranceFundTP(objectID);
    }

    private AssignmentPCompanyAccidentInsuranceFundTP(String objectID) {
        super(2, objectID);
    }

    public AssignmentPCompanyAccidentInsuranceFundTP(String objectId, int version) {
        super(2, objectId, version);
    }

    protected AssignmentPCompanyAccidentInsuranceFundTP(AssignmentPCompanyAccidentInsuranceFund apaif, Date effectiveFrom, Date effectiveUntil, Date validFrom, Date validUntil, String membershipNumber, Communication communication, boolean generallyResponsible, boolean participationOnUV, String pin, int serialNumber, String bbnrLB, String bbnrAS, boolean membershipNotValid, String unrs, AccidentInsuranceFundValuetype[] aifvt, boolean readOnly) {
        super(2, readOnly);
        this.mAssignmentPCompanyAccidentInsuranceFund = apaif;
        this.mEffectiveFrom = effectiveFrom;
        this.mEffectiveUntil = effectiveUntil;
        this.mValidFrom = validFrom;
        this.mValidUntil = validUntil;
        this.mMembershipNumber = membershipNumber;
        this.mCommunication = communication;
        this.mGenerallyResponsible = generallyResponsible;
        this.mParticipationOnUV = participationOnUV;
        this.mPin = pin;
        this.mSerialNumber = serialNumber;
        this.mBbnrLB = bbnrLB;
        this.mBbnrAS = bbnrAS;
        this.mMembershipNotValid = membershipNotValid;
        this.mUnrs = unrs;
        this.mValueTypes = aifvt;
    }

    protected void load() {
        AssignmentPCompanyAccidentInsuranceFundTPPersistencyManager.load((AssignmentPCompanyAccidentInsuranceFundTP)this);
    }

    protected void saveImpl() {
        AssignmentPCompanyAccidentInsuranceFundTPPersistencyManager.save((AssignmentPCompanyAccidentInsuranceFundTP)this);
    }

    protected void deleteImpl() {
        AssignmentPCompanyAccidentInsuranceFundTPPersistencyManager.delete((AssignmentPCompanyAccidentInsuranceFundTP)this);
    }

    public void firstExecuteImpl() throws BusinessDomainException {
        if (this.mNewValueTypes != null) {
            int i;
            if (this.getValueTypes() != null) {
                for (i = 0; i < this.getValueTypes().length; ++i) {
                    this.mValueTypes[i].makeSaveable();
                    this.mValueTypes[i].unregisterLastExecute();
                    this.mValueTypes[i].destroy();
                }
            }
            for (i = 0; i < this.mNewValueTypes.length; ++i) {
                this.mNewValueTypes[i].makeSaveable();
                this.mNewValueTypes[i].registerForLastExecute();
            }
        }
    }

    protected void destroyImpl() {
    }

    public void makeSaveable() {
        super.makeSaveable();
        if (this.getValueTypes() != null) {
            for (int i = 0; i < this.getValueTypes().length; ++i) {
                this.mValueTypes[i].makeSaveable();
            }
        }
    }

    public void makeReadOnly() {
        int i;
        super.makeReadOnly();
        for (i = 0; i < this.mValueTypes.length; ++i) {
            this.mValueTypes[i].makeReadOnly();
        }
        if (this.mNewValueTypes != null) {
            for (i = 0; i < this.mNewValueTypes.length; ++i) {
                this.mNewValueTypes[i].makeReadOnly();
            }
        }
    }

    public void registerForLastExecute() {
        int i;
        super.registerForLastExecute();
        if (this.mValueTypes != null) {
            for (i = 0; i < this.mValueTypes.length; ++i) {
                this.mValueTypes[i].registerForLastExecute();
            }
        }
        if (this.mNewValueTypes != null) {
            for (i = 0; i < this.mNewValueTypes.length; ++i) {
                this.mNewValueTypes[i].registerForLastExecute();
            }
        }
    }

    public String getClassName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getDomainKey() {
        this.requireLoaded();
        return new StringBuffer().append(this.mAssignmentPCompanyAccidentInsuranceFund.getDomainKey()).append(" / ").append(DateMapper.toString((Date)this.mEffectiveFrom)).append(" / ").append(DateMapper.toString((Date)this.mValidFrom)).toString();
    }

    public void checkAttributes() throws BusinessDomainException {
        int i;
        this.getAssignmentPCompanyAccidentInsuranceFund().checkAttributes();
        this.checkDates();
        if (this.mNewValueTypes != null) {
            for (i = 0; i < this.mNewValueTypes.length; ++i) {
                this.mNewValueTypes[i].checkAttributes();
            }
        } else {
            for (i = 0; i < this.getValueTypes().length; ++i) {
                this.mValueTypes[i].checkAttributes();
            }
        }
        this.checkMembershipNumber();
        this.checkPin();
        this.checkSerialNumber();
        this.checkDifferentBbnr(this.mBbnrAS);
        this.checkDifferentBbnr(this.mBbnrLB);
        this.checkCreateOfTaskReminderIsNecessary();
        for (AssignmentPCompanyAccidentInsuranceFundContact each : this.getAssignmentPCompanyAccidentInsuranceFund().getAssignmentPCompanyAccidentInsuranceFundContact()) {
            each.getAssignmentContact().checkAttributes();
        }
        this.mCommunication.checkAttributes();
        this.checkUnrs();
    }

    private void checkDifferentBbnr(String bbnr) throws BusinessDomainException {
        CheckUp.stdCompanyNumberCheckup((String)bbnr);
        if (AccidentInsuranceFund.BBNR_NOT_ALLOWED_FOR_LB_OR_AS.contains(bbnr) || AccidentInsuranceFund.BBNR_A08.contains(bbnr) || AccidentInsuranceFund.BBNR_A09.contains(bbnr)) {
            throw AssignmentPCompanyAccidentInsuranceFundExceptionMapper.makeBbnrAsAndLbNotAllowedDomainException((String)bbnr);
        }
    }

    public void checkDates() throws BusinessDomainException {
        super.checkDates();
        if (this.getAssignmentPCompanyAccidentInsuranceFund().getPlant() != null) {
            Date minValidFrom = this.getAssignmentPCompanyAccidentInsuranceFund().getPlant().getStartOfHistory();
            if (DateHelper.before((Date)this.getValidFrom(), (Date)minValidFrom)) {
                throw PlantExceptionMapper.makeStartHistoryBeforePlantFoundationValidFromDomainException((String)"AssignmentPCompanyAccidentInsuranceFundTPcheckDates");
            }
        } else {
            Date minValidFrom = this.getAssignmentPCompanyAccidentInsuranceFund().getPCompany().getStartOfHistory();
            if (DateHelper.before((Date)this.getValidFrom(), (Date)minValidFrom)) {
                throw PCompanyExceptionMapper.makeStartHistoryBeforePCompanyFoundationValidFromDomainException((String)"AssignmentPCompanyAccidentInsuranceFundTPcheckDates");
            }
        }
        if (this.getAssignmentPCompanyAccidentInsuranceFund().isNew()) {
            PersonnelBasic pb = PersonnelBasic.getPersonnelBasic();
            this.setEffectiveFrom(pb.getSystemStart());
        }
    }

    private void checkPin() throws BusinessDomainException {
        if (!StringMapper.isNullString((String)this.getPin())) {
            if (this.mPin.length() > 5) {
                throw AssignmentPCompanyAccidentInsuranceFundExceptionMapper.makeErrorInPinDomainException((String)"zu lang, max. 5 Zeichen erlaubt");
            }
            if (!StringMapper.isNumericValue((String)this.mPin)) {
                throw AssignmentPCompanyAccidentInsuranceFundExceptionMapper.makeErrorInPinDomainException((String)"enth\u00e4lt alphanumerische Zeichen, nur Ziffern erlaubt");
            }
            if (Integer.valueOf(this.mPin) < 10000) {
                throw AssignmentPCompanyAccidentInsuranceFundExceptionMapper.makeErrorInPinDomainException((String)"falscher Wert, zul\u00e4ssig sind nur Werte > 9999");
            }
        }
    }

    private void checkSerialNumber() throws BusinessDomainException {
        boolean bbnrChanged;
        if (this.mOld == null) {
            return;
        }
        this.requireLoaded();
        if (this.mSerialNumber == 0) {
            return;
        }
        if (!StringMapper.equal((String)this.mOld.getMembershipNumber(), (String)this.mMembershipNumber)) {
            this.setSerialNumber(0);
            return;
        }
        Date oldValidDate = this.mOld.getValidFrom();
        if (DateHelper.after((Date)this.mValidFrom, (Date)oldValidDate)) {
            oldValidDate = DateHelper.yesterday((Date)this.mValidFrom);
        }
        String oldBbnrLB = UvHelper.getBbnrLB((AssignmentPCompanyAccidentInsuranceFundTP)this.mOld, (Date)oldValidDate);
        String bbnrLB = UvHelper.getBbnrLB((AssignmentPCompanyAccidentInsuranceFundTP)this, (Date)this.mValidFrom);
        String oldBbnrAS = UvHelper.getBbnrAS((AssignmentPCompanyAccidentInsuranceFundTP)this.mOld, (Date)oldValidDate);
        String bbnrAS = UvHelper.getBbnrAS((AssignmentPCompanyAccidentInsuranceFundTP)this, (Date)this.mValidFrom);
        boolean bl = bbnrChanged = !StringMapper.equal((String)oldBbnrLB, (String)bbnrLB) || !StringMapper.equal((String)oldBbnrAS, (String)bbnrAS);
        if (bbnrChanged) {
            if (UvHelper.getValidUvDslns((String)oldBbnrLB, (String)oldBbnrAS, (AccidentInsuranceFund)this.mOld.getAssignmentPCompanyAccidentInsuranceFund().getAccidentInsuranceFund(), (String)this.mOld.getMembershipNumber(), (PCompany)this.mOld.getAssignmentPCompanyAccidentInsuranceFund().getPCompany(), (Date)this.mValidFrom).isEmpty()) {
                this.setSerialNumber(0);
            } else {
                throw AssignmentPCompanyAccidentInsuranceFundExceptionMapper.makeChangeBbnrAsLbNotAllowedDomainException();
            }
        }
    }

    public void checkCreateOfTaskReminderIsNecessary() {
        if (this.mOld == null) {
            return;
        }
        this.requireLoaded();
        this.mOld.requireLoaded();
        if (this.mOld.mMembershipNotValid != this.mMembershipNotValid) {
            String reminderName = "Bei Wechsel der Zust\u00e4ndigkeit des UV-Tr\u00e4gers ist ein Lohnnachweis mit Abgabegrund 05 zu erstellen; f\u00fcr Mitgliedsnummer: " + this.mMembershipNumber;
            this.createTaskReminder(reminderName, this.mValidFrom);
        }
    }

    public void createTaskReminder(String reminderName, Date reminderDate) {
        TaskReminderHelper.createTaskReminder((String)reminderName, (Date)reminderDate, (String)"", (String)SessionContext.getInstance().getSession().getUserCode());
    }

    public PersonnelTimedPersistenceObject createNew() {
        AssignmentPCompanyAccidentInsuranceFundTP result = new AssignmentPCompanyAccidentInsuranceFundTP(this.getAssignmentPCompanyAccidentInsuranceFund());
        result.mEffectiveFrom = this.getEffectiveFrom();
        result.mEffectiveUntil = this.getEffectiveUntil();
        result.mValidFrom = this.getValidFrom();
        result.mValidUntil = this.getValidUntil();
        result.mMembershipNumber = this.getMembershipNumber();
        result.mCommunication = this.getCommunication();
        result.mGenerallyResponsible = this.getGenerallyResponsible();
        result.mParticipationOnUV = this.getParticipationOnUV();
        result.mPin = this.getPin();
        result.mSerialNumber = this.getSerialNumber();
        result.mBbnrLB = this.getBbnrLB();
        result.mBbnrAS = this.getBbnrAS();
        result.mMembershipNotValid = this.getMembershipNotValid();
        result.mUnrs = this.getUnrs();
        if (this.mNewValueTypes != null) {
            AccidentInsuranceFundValuetype[] aifvtArray = new AccidentInsuranceFundValuetype[this.mNewValueTypes.length];
            for (int i = 0; i < this.mNewValueTypes.length; ++i) {
                aifvtArray[i] = this.mNewValueTypes[i].createNew(result);
            }
            result.mValueTypes = aifvtArray;
        } else {
            AccidentInsuranceFundValuetype[] aifvtArray = new AccidentInsuranceFundValuetype[this.getValueTypes().length];
            for (int i = 0; i < this.getValueTypes().length; ++i) {
                aifvtArray[i] = this.getValueTypes()[i].createNew(result);
            }
            result.mValueTypes = aifvtArray;
        }
        return result;
    }

    public void setData(Date ef, Date eu, Date vf, Date vu, String mnr, Communication comm, boolean generallyResponsible, boolean participationOnUV, String pin, int serialNumber, String bbnrLB, String bbnrAS, boolean membershipNotValid, String unrs, AccidentInsuranceFundValuetype[] vt) {
        this.mEffectiveFrom = ef;
        this.mEffectiveUntil = eu;
        this.mValidFrom = vf;
        this.mValidUntil = vu;
        this.mMembershipNumber = mnr;
        this.mCommunication = comm;
        this.mGenerallyResponsible = generallyResponsible;
        this.mParticipationOnUV = participationOnUV;
        this.mPin = pin;
        this.mSerialNumber = serialNumber;
        this.mBbnrLB = bbnrLB;
        this.mBbnrAS = bbnrAS;
        this.mMembershipNotValid = membershipNotValid;
        this.mUnrs = unrs;
        this.mValueTypes = vt;
    }

    public void setOld(AssignmentPCompanyAccidentInsuranceFundTP old) {
        this.mOld = old;
    }

    public AssignmentPCompanyAccidentInsuranceFund getAssignmentPCompanyAccidentInsuranceFund() {
        this.requireLoaded();
        return this.mAssignmentPCompanyAccidentInsuranceFund;
    }

    public void setAssignmentPCompanyAccidentInsuranceFund(AssignmentPCompanyAccidentInsuranceFund apaif) {
        this.mAssignmentPCompanyAccidentInsuranceFund = apaif;
    }

    public String getMembershipNumber() {
        this.requireLoaded();
        return this.mMembershipNumber;
    }

    public void setMembershipNumber(String membershipNumber) {
        this.mMembershipNumber = membershipNumber;
    }

    public Communication getCommunication() {
        this.requireLoaded();
        return this.mCommunication;
    }

    public void setCommunication(Communication communication) {
        this.mCommunication = communication;
    }

    public AccidentInsuranceFundValuetype[] getValueTypes() {
        this.requireLoaded();
        return this.mValueTypes;
    }

    public void setValueTypes(AccidentInsuranceFundValuetype[] vt) {
        this.mNewValueTypes = vt;
    }

    public boolean getGenerallyResponsible() {
        this.requireLoaded();
        return this.mGenerallyResponsible;
    }

    public void setGenerallyResponsible(boolean generallyResponsible) {
        this.mGenerallyResponsible = generallyResponsible;
    }

    public String getPin() {
        this.requireLoaded();
        return this.mPin;
    }

    public void setPin(String pin) {
        this.mPin = pin;
    }

    public boolean getParticipationOnUV() {
        this.requireLoaded();
        return this.mParticipationOnUV;
    }

    public void setParticipationOnUV(boolean participationOnUV) {
        this.mParticipationOnUV = participationOnUV;
    }

    public int getSerialNumber() {
        this.requireLoaded();
        return this.mSerialNumber;
    }

    public void setSerialNumber(int serialNumber) {
        this.mSerialNumber = serialNumber;
    }

    public String getBbnrLB() {
        this.requireLoaded();
        return this.mBbnrLB;
    }

    public void setBbnrLB(String bbnrLB) {
        this.mBbnrLB = bbnrLB;
    }

    public String getBbnrAS() {
        this.requireLoaded();
        return this.mBbnrAS;
    }

    public void setBbnrAS(String bbnrAS) {
        this.mBbnrAS = bbnrAS;
    }

    public boolean getMembershipNotValid() {
        this.requireLoaded();
        return this.mMembershipNotValid;
    }

    public void setMembershipNotValid(boolean membershipNotValid) {
        this.mMembershipNotValid = membershipNotValid;
    }

    public String getUnrs() {
        this.requireLoaded();
        return this.mUnrs;
    }

    public void setUnrs(String unrs) {
        this.mUnrs = unrs;
    }

    public String getRootDomainKey() {
        return this.getAssignmentPCompanyAccidentInsuranceFund().getDomainKey();
    }

    public String getNaturalLanguageClassName() {
        return "Zuordnung Firma/Betriebsst\u00e4tte Berufsgenossenschaft";
    }

    private void checkMembershipNumber() throws BusinessDomainException {
        if (DateHelper.before((Date)this.mValidFrom, (Date)START_OF_CHECK_MEMBERSHIPNUMBER) || this.mMembershipNotValid) {
            return;
        }
        String result = MembershipNumberOfAIF.checkMembershipNumber(this.mAssignmentPCompanyAccidentInsuranceFund.getAccidentInsuranceFund().getAccidentInsuranceFundTP(this.mEffectiveFrom, this.mValidUntil).getStdCompanyNoOfAccIns(), this.mMembershipNumber);
        if (!StringMapper.isNullString((String)result)) {
            throw FrameWorkExceptionMapper.makeUvCheckMembershipnumberFalseDomainException((String)result);
        }
    }

    private void checkUnrs() throws BusinessDomainException {
        String result;
        if (!StringMapper.isNullString((String)this.mUnrs) && !StringMapper.isNullString((String)(result = MembershipNumberOfAIF.checkUNRS(this.mUnrs)))) {
            throw UvExceptionMapper.makeUnrsFalseDomainException(result);
        }
    }
}

