/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.aeins.receive;

import com.varial.base.UtilitiesManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.security.AuthorizationToken;
import com.varial.base.session.SessionContext;
import com.varial.personnel.domain.aeins.account.AEinsAccount;
import com.varial.personnel.domain.aeins.account.AEinsAdviceStateEnum;
import com.varial.personnel.domain.aeins.account.IAEinsAccountPersistencyManager;
import com.varial.personnel.domain.aeins.basictypes.Person;
import com.varial.personnel.domain.aeins.dxaa.AEinsDxaa;
import com.varial.personnel.domain.aeins.dxab.AEinsDxab;
import com.varial.personnel.domain.aeins.receive.ReasonOfDenialUtil;
import com.varial.personnel.domain.deuv.DataRecipientUtil;
import com.varial.personnel.domain.deuv.DeuvAcknowledgement;
import com.varial.personnel.domain.deuv.DeuvResponse;
import com.varial.personnel.domain.deuv.PerfidiaDataType;
import com.varial.personnel.domain.deuv.deuvsending.DEUVSending;
import com.varial.personnel.domain.deuvmessaging.perfidia.PerfidiaHelper;
import com.varial.personnel.domain.global.deuv.recipient.DEUVRecipient;
import com.varial.personnel.domain.global.deuv.sender.DEUVSender;
import com.varial.personnel.framework.PFileHelper;
import com.varial.serverbase.mapper.StringMapper;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class AEinsReceive {
    private static final int LENGTH_TO_FILENUMBER = 71;
    private static final Pattern VOSX_TO_FILENUMBER = Pattern.compile("VOSX010000(.{5})(.{15})(.{15})(\\d{20})(\\d{6})(.*)");
    private static final Pattern TYPE = Pattern.compile("(.{4})(.*)");
    private static final Pattern DXVE = Pattern.compile("DXVE010000(.{32})(\\d{1})(\\d{6})(.{7})(.{2000})(.*)");
    private static final Pattern DXVD = Pattern.compile("DXVD010000(.{32})(\\d{6})(.{32})(\\d{1})(.*)");
    private static final Pattern DXVD_ERROR = Pattern.compile("(.{7})(.{64})(.{100})(.*)");
    private static final Pattern DXAB = Pattern.compile("DXAB(\\d{6})(.{15})(.{15})(\\d{20})(.{32})([JN])(.{1})(.{30})(.{30})(.{20})(.{20})(.{20})(.{12})(.{32})(.{20})(.{15})(.{1500})(.{64})(.{64})(.{32})(.*)");
    private static final Pattern DXAA = Pattern.compile("DXAA(\\d{6})(.{15})(.{15})(\\d{20})(.{32})([JN])(.{1})(.{30})(.{30})(.{20})(.{20})(.{20})(.{12})(.{32})(.{20})(.{15})(.{2})(.{1000})(.{1500})(.{64})(.{64})(.{32})(.*)");
    private static final Pattern DXAB_101 = Pattern.compile("DXAB(\\d{6})(.{15})(.{15})(\\d{20})(.{32})([JN])(.{1})(.{30})(.{30})(.{20})(.{20})(.{20})(.{12})(.{32})(.{20})(.{15})(.{1500})(.{64})(.*)");
    private static final Pattern DXAA_101 = Pattern.compile("DXAA(\\d{6})(.{15})(.{15})(\\d{20})(.{32})([JN])(.{1})(.{30})(.{30})(.{20})(.{20})(.{20})(.{12})(.{32})(.{20})(.{15})(.{2})(.{1000})(.{1500})(.*)");
    private static final int DXVD_ERROR_LENGTH = 171;
    private final DEUVSender mDEUVSender;
    private final List<AEinsAccount> mImporteds;
    private File mCurrent;
    private final DeuvAcknowledgement mAcknowledgement;

    public AEinsReceive(DEUVSender deuvSender, AuthorizationToken token) {
        this.mDEUVSender = deuvSender;
        this.mImporteds = new ArrayList<AEinsAccount>();
        this.mAcknowledgement = new DeuvAcknowledgement(deuvSender);
    }

    public void readAEinsReceives(DEUVRecipient responder) throws BusinessDomainException {
        File[] files;
        File dir = PerfidiaHelper.getPerfidiaRecvFolder((DEUVSender)this.mDEUVSender, (DEUVRecipient)responder);
        for (File each : files = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                String input = name.toUpperCase();
                return !input.endsWith(".XML") && !input.endsWith(".PDF") && (input.startsWith("EA1S0") || input.startsWith("TA1S0") || input.startsWith("EA1A0") || input.startsWith("TA1A0"));
            }
        })) {
            PFileHelper.checkFile((File)each, (String)"Meldung A1-Antr\u00e4ge");
            this.readAEinsReceives(each, responder);
            SessionContext.getInstance().getPersistencySession().flush();
        }
    }

    private void readAEinsReceives(File input, DEUVRecipient responder) throws BusinessDomainException {
        this.mCurrent = input;
        CharSequence content = PFileHelper.getFileContent((File)input, (String)"ISO-8859-1", (int)71);
        Matcher matcher = VOSX_TO_FILENUMBER.matcher(content);
        if (matcher.matches()) {
            int currentFileNumber = -1;
            String ending = this.getFileEnding(input.getName());
            if (ending != null) {
                try {
                    currentFileNumber = Integer.parseInt(ending);
                }
                catch (NumberFormatException e) {
                    currentFileNumber = -1;
                }
            }
            if (currentFileNumber < 0) {
                currentFileNumber = Integer.parseInt(matcher.group(5));
            }
            LinkedList records = PFileHelper.getFileLines((File)input, (String)"ISO-8859-1");
            records.pollFirst();
            records.pollLast();
            String name = input.getName().toUpperCase();
            if (name.startsWith("EA1S0") || name.startsWith("TA1S0")) {
                while (!records.isEmpty()) {
                    matcher = TYPE.matcher((CharSequence)records.getFirst());
                    if (!matcher.matches()) {
                        throw new IllegalStateException(this.mCurrent.getPath() + ": " + ((String)records.getFirst()).replace(' ', '.') + " don't match into: " + TYPE);
                    }
                    String type = matcher.group(1);
                    if (type.equals("DXAB")) {
                        this.readDxab(input, (String)records.pollFirst(), currentFileNumber, responder);
                    } else if (type.equals("DXAA")) {
                        this.readDxaa(input, (String)records.pollFirst(), currentFileNumber, responder);
                    }
                    SessionContext.getInstance().getPersistencySession().flush();
                }
                this.mAcknowledgement.addProcessedFile(input, PerfidiaDataType.A1S, responder, currentFileNumber);
            } else {
                while (!records.isEmpty()) {
                    matcher = TYPE.matcher((CharSequence)records.getFirst());
                    if (!matcher.matches()) {
                        throw new IllegalStateException(this.mCurrent.getPath() + ": " + ((String)records.getFirst()).replace(' ', '.') + " don't match into: " + TYPE);
                    }
                    String type = matcher.group(1);
                    if (type.equals("DXVE")) {
                        this.readDxve(input, (String)records.pollFirst(), responder, currentFileNumber);
                        continue;
                    }
                    if (type.equals("DXVD")) {
                        this.readDxvd(input, (String)records.pollFirst(), responder, currentFileNumber);
                        continue;
                    }
                    if (!type.equals("DXWL")) continue;
                    this.addProcessedFile(input, PerfidiaDataType.A1A, responder, 0, currentFileNumber);
                }
            }
        } else {
            throw new IllegalStateException(input.getPath() + " don't match: " + matcher);
        }
    }

    private String getFileEnding(String filename) {
        String ending = null;
        if (filename != null && filename.length() >= 7 && filename.charAt(filename.length() - 4) == '.') {
            String firstPart = filename.substring(filename.length() - 7, filename.length() - 4);
            String secondPart = filename.substring(filename.length() - 3, filename.length());
            ending = firstPart.concat(secondPart);
        }
        return ending;
    }

    private boolean needImport(File input, DEUVRecipient responder, PerfidiaDataType type, int fileNumberSend, int fileNumberRecv) throws BusinessDomainException {
        int perfidiaSubFolder = DataRecipientUtil.getSubFolderNumberByCompNo((String)responder.getCurrentDEUVRecipientTP().getStdCompanyNumber());
        DeuvResponse response = new DeuvResponse(type, perfidiaSubFolder, fileNumberSend, fileNumberRecv, input.getName().startsWith("T") || input.getName().startsWith("t") ? 1 : 0);
        return response.needAcknowlegement(this.mDEUVSender);
    }

    private void deleteAEinsSending(File input, DEUVRecipient responder, PerfidiaDataType type, int fileNumberSend, int fileNumberRecv) throws BusinessDomainException {
        DEUVSending[] sendings;
        int perfidiaSubFolder = DataRecipientUtil.getSubFolderNumberByCompNo((String)responder.getCurrentDEUVRecipientTP().getStdCompanyNumber());
        DeuvResponse response = new DeuvResponse(type, perfidiaSubFolder, fileNumberSend, fileNumberRecv, input.getName().startsWith("T") || input.getName().startsWith("t") ? 1 : 0);
        for (DEUVSending each : sendings = response.getDEUVSendings(this.mDEUVSender)) {
            each.makeSaveable();
            each.destroy();
            each.registerForFirstExecute();
        }
    }

    private void readDxab(File file, String input, int currentFileNumber, DEUVRecipient responder) throws BusinessDomainException {
        AEinsDxab dxab;
        Matcher matcher = DXAB.matcher(input);
        if (matcher.matches()) {
            dxab = this.createDxab(matcher);
        } else {
            matcher = DXAB_101.matcher(input);
            if (matcher.matches()) {
                dxab = this.createDxab(matcher);
            } else {
                throw new IllegalStateException(this.mCurrent.getPath() + ": " + input.replace(' ', '.') + " don't match into: " + DXAB);
            }
        }
        AEinsAccount account = this.getOrigin(dxab.getDatensatzidursprung());
        if (!this.needImport(file, responder, PerfidiaDataType.A1S, 0, currentFileNumber)) {
            if (account != null && !account.hasDxab()) {
                this.deleteAEinsSending(file, responder, PerfidiaDataType.A1S, 0, currentFileNumber);
            } else {
                return;
            }
        }
        if (account == null) {
            account = new AEinsAccount(null, true);
            account.addError("R\u00fcckmeldung wurde nicht eingelesen, da das A1-Meldekonto nicht gefunden wurde.");
        } else {
            try {
                AEinsDxab oldDxab = account.getDxab();
                if (oldDxab != null) {
                    oldDxab.makeSaveable();
                    oldDxab.destroy();
                    account.setDxab(null);
                }
            }
            catch (IllegalStateException e) {
                throw new IllegalStateException(e.getMessage() + ", file: " + file.getAbsolutePath());
            }
            account.makeSaveable();
            dxab.makeSaveable();
            account.setAdviceState(AEinsAdviceStateEnum.BEWILLIGT);
        }
        account.setDxab(dxab);
        account.setCurrentFileNumberReceive(currentFileNumber);
        account.setAnswerType("DXAB");
        this.mImporteds.add(account);
    }

    private void readDxaa(File file, String input, int currentFileNumber, DEUVRecipient responder) throws BusinessDomainException {
        AEinsDxaa dxaa;
        Matcher matcher = DXAA.matcher(input);
        if (matcher.matches()) {
            dxaa = this.createDxaa(matcher);
        } else {
            matcher = DXAA_101.matcher(input);
            if (matcher.matches()) {
                dxaa = this.createDxaa(matcher);
            } else {
                throw new IllegalStateException(this.mCurrent.getPath() + ": " + input.replace(' ', '.') + " don't match into: " + DXAA);
            }
        }
        AEinsAccount account = this.getOrigin(dxaa.getDatensatzidursprung());
        if (!this.needImport(file, responder, PerfidiaDataType.A1S, 0, currentFileNumber)) {
            if (account != null && !account.hasDxaa()) {
                this.deleteAEinsSending(file, responder, PerfidiaDataType.A1S, 0, currentFileNumber);
            } else {
                return;
            }
        }
        if (account == null) {
            account = new AEinsAccount(null, true);
            account.addError("R\u00fcckmeldung wurde nicht eingelesen, da das A1-Meldekonto nicht gefunden wurde.");
        } else {
            AEinsDxaa oldDxaa = account.getDxaa();
            if (oldDxaa != null) {
                oldDxaa.makeSaveable();
                oldDxaa.destroy();
                account.setDxaa(null);
            }
            account.makeSaveable();
            dxaa.makeSaveable();
            account.setAdviceState(AEinsAdviceStateEnum.ABGELEHNT);
        }
        account.setDxaa(dxaa);
        account.setCurrentFileNumberReceive(currentFileNumber);
        account.setAnswerType("DXAA");
        this.mImporteds.add(account);
    }

    private AEinsDxab createDxab(Matcher matcher) {
        int i = 1;
        String version = this.asString(matcher.group(i++));
        String absender = this.asString(matcher.group(i++));
        String empfaenger = this.asString(matcher.group(i++));
        String datumerstellung = this.asString(matcher.group(i++));
        String datensatzid = this.asString(matcher.group(i++));
        String storno = this.asString(matcher.group(i++));
        String geschlecht = this.asString(matcher.group(i++));
        String vorname = this.asString(matcher.group(i++));
        String nachname = this.asString(matcher.group(i++));
        String vorsatzwort = this.asString(matcher.group(i++));
        String zusatz = this.asString(matcher.group(i++));
        String titel = this.asString(matcher.group(i++));
        String vsnr = this.asString(matcher.group(i++));
        String datensatzidursprung = this.asString(matcher.group(i++));
        String azvuursprung = this.asString(matcher.group(i++));
        String bnr = this.asString(matcher.group(i++));
        String hinweis = this.asString(matcher.group(i++));
        String pdf1 = this.asString(matcher.group(i++));
        AEinsDxab dxab = new AEinsDxab();
        dxab.setVersionsnummer(version);
        dxab.setAbsendernummer(absender);
        dxab.setEmpfaengernummer(empfaenger);
        dxab.setDatumerstellung(datumerstellung);
        dxab.setDatensatzid(datensatzid);
        dxab.setStornokennzeichen(storno);
        Person person = new Person(geschlecht, vorname, nachname, vorsatzwort, zusatz, titel);
        dxab.setPerson(person);
        dxab.setVersicherungsnr(vsnr);
        dxab.setDatensatzidursprung(datensatzidursprung);
        dxab.setAzvuursprung(azvuursprung);
        dxab.setBetriebsnummervu(bnr);
        dxab.setHinweistext(hinweis);
        dxab.setBescheinigungpdf(pdf1);
        if ("010200".equals(version)) {
            String pdf2 = this.asString(matcher.group(i++));
            String vorgangsid = this.asString(matcher.group(i++));
            dxab.setVorgangsid(vorgangsid);
        }
        dxab.makeReadOnly();
        return dxab;
    }

    private AEinsDxaa createDxaa(Matcher matcher) {
        String hinweis;
        String fehlertext;
        int i = 1;
        String version = this.asString(matcher.group(i++));
        String absender = this.asString(matcher.group(i++));
        String empfaenger = this.asString(matcher.group(i++));
        String datumerstellung = this.asString(matcher.group(i++));
        String datensatzid = this.asString(matcher.group(i++));
        String storno = this.asString(matcher.group(i++));
        String geschlecht = this.asString(matcher.group(i++));
        String vorname = this.asString(matcher.group(i++));
        String nachname = this.asString(matcher.group(i++));
        String vorsatzwort = this.asString(matcher.group(i++));
        String zusatz = this.asString(matcher.group(i++));
        String titel = this.asString(matcher.group(i++));
        String vsnr = this.asString(matcher.group(i++));
        String datensatzidursprung = this.asString(matcher.group(i++));
        String azvuursprung = this.asString(matcher.group(i++));
        String bnr = this.asString(matcher.group(i++));
        String ablehnungsgrund = this.asString(matcher.group(i++));
        AEinsDxaa dxaa = new AEinsDxaa();
        dxaa.setVersionsnummer(version);
        dxaa.setAbsendernummer(absender);
        dxaa.setEmpfaengernummer(empfaenger);
        dxaa.setDatumerstellung(datumerstellung);
        dxaa.setDatensatzid(datensatzid);
        dxaa.setStornokennzeichen(storno);
        Person person = new Person(geschlecht, vorname, nachname, vorsatzwort, zusatz, titel);
        dxaa.setPerson(person);
        dxaa.setVersicherungsnr(vsnr);
        dxaa.setDatensatzidursprung(datensatzidursprung);
        dxaa.setAzvuursprung(azvuursprung);
        dxaa.setBetriebsnummervu(bnr);
        dxaa.setAblehnungsgrund(Integer.valueOf(ablehnungsgrund).intValue());
        if ("010100".equals(version)) {
            fehlertext = this.asString(matcher.group(i++));
            hinweis = this.asString(matcher.group(i++));
            dxaa.setFehlertext(fehlertext);
            dxaa.setHinweistext(hinweis);
        }
        if ("010200".equals(version)) {
            fehlertext = this.asString(matcher.group(i++));
            hinweis = this.asString(matcher.group(i++));
            String pdf1 = this.asString(matcher.group(i++));
            String pdf2 = this.asString(matcher.group(i++));
            String vorgangsid = this.asString(matcher.group(i++));
            dxaa.setVorgangsid(vorgangsid);
            dxaa.setBescheinigungpdf(pdf1);
            dxaa.setFehlertext(ReasonOfDenialUtil.getMessageByNumber((String)ablehnungsgrund));
            dxaa.setHinweistext("");
        }
        dxaa.makeReadOnly();
        return dxaa;
    }

    private void readDxve(File file, String input, DEUVRecipient responder, int currentFileNumber) throws BusinessDomainException {
        Matcher matcher = DXVE.matcher(input);
        if (matcher.matches()) {
            String status = this.asString(matcher.group(2));
            int dateiNr = Integer.parseInt(matcher.group(3));
            String errorNr = this.asString(matcher.group(4));
            String error = this.asString(matcher.group(5));
            if (status.equals("1")) {
                AEinsAccount account = new AEinsAccount(null, true);
                account.addError("Parser-Fehler bei gesendeten Antrag. Dateiname Verarbeitungsergebnis: " + file.getAbsolutePath());
                account.addError(error);
                account.setAnswerType("DXVE");
                this.mImporteds.add(account);
            } else if (this.needImport(file, responder, PerfidiaDataType.A1A, dateiNr, currentFileNumber)) {
                AEinsAccount[] accounts;
                for (AEinsAccount account : accounts = AEinsAccount.getAEinsAccountsByFileNr((int)dateiNr, (DEUVRecipient)responder)) {
                    if (AEinsAdviceStateEnum.BEWILLIGT.equals((Object)account.getAdviceState()) || AEinsAdviceStateEnum.ABGELEHNT.equals((Object)account.getAdviceState())) continue;
                    account.makeSaveable();
                    if (status.equals("0")) {
                        account.setAdviceState(AEinsAdviceStateEnum.VERARBEITET);
                        continue;
                    }
                    if (!status.equals("2")) continue;
                    account.setAdviceState(AEinsAdviceStateEnum.ABGELEHNT);
                    account.addError("(" + errorNr + ")" + error);
                }
                this.addProcessedFile(file, PerfidiaDataType.A1A, responder, dateiNr, currentFileNumber);
            }
        } else {
            throw new IllegalStateException(this.mCurrent.getPath() + ": " + input.replace(' ', '.') + " don't match into: " + DXVE);
        }
    }

    private void readDxvd(File file, String input, DEUVRecipient responder, int currentFileNumber) throws BusinessDomainException {
        Matcher matcher = DXVD.matcher(input);
        if (matcher.matches()) {
            int dateiNr = Integer.parseInt(matcher.group(2));
            String datensatzID = this.asString(matcher.group(3));
            Integer anzahl = Integer.valueOf(this.asString(matcher.group(4)));
            String rest = matcher.group(5);
            if (this.needImport(file, responder, PerfidiaDataType.A1A, dateiNr, currentFileNumber)) {
                AEinsAccount account = this.getOrigin(datensatzID);
                if (account == null) {
                    account = new AEinsAccount(null, true);
                    account.addError("Verarbeitungsergebnis wurde nicht eingelesen, da das A1-Meldekonto nicht gefunden wurde:" + file.getName());
                    this.mImporteds.add(account);
                } else if (!AEinsAdviceStateEnum.BEWILLIGT.equals((Object)account.getAdviceState()) && !AEinsAdviceStateEnum.ABGELEHNT.equals((Object)account.getAdviceState())) {
                    account.setAdviceState(AEinsAdviceStateEnum.ABGELEHNT);
                    account.makeSaveable();
                }
                account.setAnswerType("DXVD");
                for (int i = 0; i < anzahl; ++i) {
                    matcher = this.checkInputGetMatcher(rest, 171, DXVD_ERROR);
                    String errorNr = this.asString(matcher.group(1));
                    String error = this.asString(matcher.group(2));
                    rest = matcher.group(4);
                    account.addError("(" + errorNr + ")" + error);
                }
                this.addProcessedFile(file, PerfidiaDataType.A1A, responder, dateiNr, currentFileNumber);
            }
        } else {
            throw new IllegalStateException(this.mCurrent.getPath() + ": " + input.replace(' ', '.') + " don't match into: " + DXVD);
        }
    }

    private void addProcessedFile(File file, PerfidiaDataType perfidiaDataType, DEUVRecipient deuvRecipient, int fileNumberSend, int fileNumberRecv) throws BusinessDomainException {
        int perfidiaSubFolder = DataRecipientUtil.getSubFolderNumberByCompNo((String)deuvRecipient.getCurrentDEUVRecipientTP().getStdCompanyNumber());
        this.mAcknowledgement.addProcessedFile(file, perfidiaDataType, perfidiaSubFolder, fileNumberSend, fileNumberRecv);
    }

    public void writeAcknowledgements() throws BusinessDomainException {
        this.mAcknowledgement.writeAcknowledgements();
    }

    public void writePerfidiaFiles() {
        this.mAcknowledgement.writePerfidiaFiles();
    }

    public boolean hasImporteds() {
        return !this.mImporteds.isEmpty();
    }

    public List<AEinsAccount> getImporteds() {
        return Collections.unmodifiableList(this.mImporteds);
    }

    public DEUVSender getDEUVSender() {
        return this.mDEUVSender;
    }

    private String asString(String value) {
        return StringMapper.toStringWithTrim((String)value);
    }

    private Matcher checkInputGetMatcher(String input, int length, Pattern pattern) {
        if (input.length() < length) {
            throw new IllegalArgumentException(this.mCurrent.getPath() + ": Input is to short: " + input.replace(' ', '.'));
        }
        Matcher matcher = pattern.matcher(input);
        if (!matcher.matches()) {
            throw new IllegalStateException(this.mCurrent.getPath() + ": " + input.substring(0, length).replace(' ', '.') + " don't match into: " + pattern);
        }
        return matcher;
    }

    private AEinsAccount getOrigin(String oid) {
        if (!StringUtils.isNumeric((CharSequence)oid) || oid.length() > 18) {
            return null;
        }
        return this.getReceived(oid);
    }

    private AEinsAccount getReceived(String oid) {
        AEinsAccount[] receiveds = this.getPm().query(null, Restrictions.eq((String)"OBJECTID", (String)oid));
        if (receiveds == null || receiveds.length == 0) {
            return null;
        }
        return receiveds[0];
    }

    private IAEinsAccountPersistencyManager getPm() {
        return (IAEinsAccountPersistencyManager)UtilitiesManager.getBean((String)"aEinsAccountPersistencyManager", IAEinsAccountPersistencyManager.class);
    }
}

