/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.aeins;

import com.infor.igf.core.util.StacktraceUtils;
import com.varial.base.error.ErrorList;
import com.varial.base.error.ErrorMessage;
import com.varial.base.error.Errors;
import com.varial.base.exception.BusinessDomainException;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.ExceptionMapper;
import java.util.Date;

public class AEinsExceptionMapper {
    private static final String CLASS_GENERAL = "PYAEins";
    private static final int NO_HEALTHFUND_AND_PENSION = 11;
    private static final int MISSING_DATE_OF_EMPLOYMENT = 12;
    private static final int MISSING_DATE_OF_INSURANCE = 13;
    private static final int MISSING_DATE_OF_MASTER = 14;
    private static final int NO_MESSAGES_FOR_TRANSFER = 15;
    private static final int NO_DELETE_OR_CANCELLATION_ALLOWED = 16;
    private static final int NO_FROM_DATE = 17;
    private static final int NO_ECONOMIC_SECTOR = 18;
    private static final int EDIT_NOT_ALLOWED = 19;
    private static final int MONTHS_EXCEEDED = 20;
    private static final int END_FOR_BEGIN = 21;
    private static final int WRONG_TYPE_ADDRESS = 22;
    private static final int NO_BUNDESKNAPPSCHAFT = 23;
    private static final int EMPLOYEE_WITH_CALCULATION_STATE = 24;
    private static final int EMPLOYEE_IN_VALUATION = 25;
    private static final int EMPLOYEE_WAITING_FOR_CALCULATION = 26;
    private static final int STATE_NOT_ALLOWED = 27;
    private static final int DIFF_HEALTHFUND_NEEDED = 28;
    private static final int PGS_NOT_ALLOWED = 29;
    private static final int NO_ADDRESS = 30;
    private static final int NO_CANCELLATION_ALLOWED = 31;
    @Errors
    private static final ErrorList mErrorList = new ErrorList("PYAEins", new ErrorMessage[]{new ErrorMessage(11, "Der A1-Antrag kann nicht aufgebaut werden,\n da der Mitarbeiter weder gesetzlich krankenversichert noch grds. rentenversicherungspflichtig ist"), new ErrorMessage(12, "F\u00fcr den Mitarbeiter fehlen die Besch\u00e4ftigungsdaten."), new ErrorMessage(13, "F\u00fcr den Mitarbeiter fehlen die Sozialversicherungsdaten."), new ErrorMessage(14, "F\u00fcr den Mitarbeiter fehlen die Pers\u00f6nlichen Angaben."), new ErrorMessage(15, "Keine ungesendeten Meldungen vorhanden."), new ErrorMessage(16, "Diese Meldung kann nicht gel\u00f6scht werden, da sie bereits \u00fcbermittelt wurde.\n Bzw. diese Meldung kann nicht storniert werden, da sie noch nicht verarbeitet wurde"), new ErrorMessage(17, "Das Beginn- und Enddatum im Vorspann sind Pflichteingaben."), new ErrorMessage(18, "In den Grundlagen der Firma fehlt die Angabe des Wirtschaftssektors."), new ErrorMessage(19, "Nachdem ein Antrag \u00fcbermittelt wurde darf dieser nicht mehr ver\u00e4ndert werden."), new ErrorMessage(24, "Mitarbeiter mit Meldung nach Berechnung: "), new ErrorMessage(25, "Mitarbeiter befindet sich in Berechnung: "), new ErrorMessage(26, "Mitarbeiter wartet auf die Ausf\u00fchrung eines Berechnungsansto\u00dfes: "), new ErrorMessage(20, "Der Entsendungszeitraum darf 24 Monate nicht \u00fcbersteigen. "), new ErrorMessage(21, "Das Ende der Entsendung darf nicht vor dem Beginn liegen. "), new ErrorMessage(22, "Die Angabe einer zweiten Anschrift muss mit dem Typ 'Aufenthaltsstaat' erfolgen. "), new ErrorMessage(23, "Bei Mitarbeitern mit dem PGS 109 oder 110 darf der Empf\u00e4nger nicht die Minijobzentrale/Bundesknappschaft sein. "), new ErrorMessage(27, "Der angegebene L\u00e4nderschl\u00fcssel entspricht nicht den EU-Staaten, EWR-Staaten oder der Schweiz: "), new ErrorMessage(28, "Bei den PGS 106, 109, 110, 190 m\u00fcssen Angaben zur gesetzlichen oder privaten KV verwaltet sein."), new ErrorMessage(29, "Eine maschinelle Antragstellung ist nur f\u00fcr DE\u00dcV-f\u00e4hige PGS m\u00f6glich. "), new ErrorMessage(30, "Die Angabe einer Wohnanschrift an erster Stelle ist verpflichtend. "), new ErrorMessage(31, "Diese Meldung kann nicht storniert werden, da sie noch nicht \u00fcbermittelt wurde. Die Meldung k\u00f6nnte jedoch gel\u00f6scht werden.")});

    public static BusinessDomainException makeNoDeleteOrCancellationAllowedDomainException(String message) {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)StacktraceUtils.getCallingClassAndMethod((int)1), (String)message, (int)16, (String)mErrorList.getDefaultString(16));
    }

    public static BusinessDomainException makeNoHealtFundAndPensionException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)StacktraceUtils.getCallingClassAndMethod((int)1), (String)"", (int)11, (String)mErrorList.getDefaultString(11));
    }

    public static BusinessDomainException makeMissingDateOfEmploymentDomainException(Date validTimePoint) {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)StacktraceUtils.getCallingClassAndMethod((int)1), (String)DateMapper.toString((Date)validTimePoint), (int)12, (String)mErrorList.getDefaultString(12));
    }

    public static BusinessDomainException makeMissingDateOfInsuranceDomainException(Date validTimePoint) {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)StacktraceUtils.getCallingClassAndMethod((int)1), (String)DateMapper.toString((Date)validTimePoint), (int)13, (String)mErrorList.getDefaultString(13));
    }

    public static BusinessDomainException makeMissingDateOfMasterDomainException(Date validTimePoint) {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)StacktraceUtils.getCallingClassAndMethod((int)1), (String)DateMapper.toString((Date)validTimePoint), (int)14, (String)mErrorList.getDefaultString(14));
    }

    public static BusinessDomainException makeNoMessagesForTransferDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)StacktraceUtils.getCallingClassAndMethod((int)1), (String)"", (int)15, (String)mErrorList.getDefaultString(15));
    }

    public static BusinessDomainException makeEmployeeWithCalculationStateException(String idString) {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)StacktraceUtils.getCallingClassAndMethod((int)1), (String)"", (int)24, (String)(mErrorList.getDefaultString(24) + idString));
    }

    public static BusinessDomainException makeEmployeeInValuationException(String idString) {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)StacktraceUtils.getCallingClassAndMethod((int)1), (String)"", (int)25, (String)(mErrorList.getDefaultString(25) + idString));
    }

    public static BusinessDomainException makeEmployeeWaitingForCalculationException(String idString) {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)StacktraceUtils.getCallingClassAndMethod((int)1), (String)"", (int)26, (String)(mErrorList.getDefaultString(26) + idString));
    }

    public static BusinessDomainException makeNoFromDateException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)StacktraceUtils.getCallingClassAndMethod((int)1), (String)"", (int)17, (String)mErrorList.getDefaultString(17));
    }

    public static BusinessDomainException makeEndForBeginDateException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)StacktraceUtils.getCallingClassAndMethod((int)1), (String)"", (int)21, (String)mErrorList.getDefaultString(21));
    }

    public static BusinessDomainException makeMonthsExceededException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)StacktraceUtils.getCallingClassAndMethod((int)1), (String)"", (int)20, (String)mErrorList.getDefaultString(20));
    }

    public static BusinessDomainException makeNoEconomicSectorException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)StacktraceUtils.getCallingClassAndMethod((int)1), (String)"", (int)18, (String)mErrorList.getDefaultString(18));
    }

    public static BusinessDomainException makeWrongTypeSecondAddressDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)StacktraceUtils.getCallingClassAndMethod((int)1), (String)"", (int)22, (String)mErrorList.getDefaultString(22));
    }

    public static BusinessDomainException makeBundesknappschaftNotAllowedException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)StacktraceUtils.getCallingClassAndMethod((int)1), (String)"", (int)23, (String)mErrorList.getDefaultString(23));
    }

    public static BusinessDomainException makeEditNotAllowedException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)StacktraceUtils.getCallingClassAndMethod((int)1), (String)"", (int)19, (String)mErrorList.getDefaultString(19));
    }

    public static BusinessDomainException makeStateNotAllowed(String state) {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)StacktraceUtils.getCallingClassAndMethod((int)1), (String)"", (int)27, (String)(mErrorList.getDefaultString(27) + state));
    }

    public static BusinessDomainException makeDiffHealthFundNeededException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)StacktraceUtils.getCallingClassAndMethod((int)1), (String)"", (int)28, (String)mErrorList.getDefaultString(28));
    }

    public static BusinessDomainException makePGSNotAllowedException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)StacktraceUtils.getCallingClassAndMethod((int)1), (String)"", (int)29, (String)mErrorList.getDefaultString(29));
    }

    public static BusinessDomainException makeNoAddressDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)StacktraceUtils.getCallingClassAndMethod((int)1), (String)"", (int)30, (String)mErrorList.getDefaultString(30));
    }

    public static BusinessDomainException makeNoCancellationAllowedDomainException(String message) {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)StacktraceUtils.getCallingClassAndMethod((int)1), (String)message, (int)31, (String)mErrorList.getDefaultString(31));
    }
}

