/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.aeins;

import com.varial.base.UtilitiesManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.criterion.Conjunction;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.aeins.AEinsAccountComparator;
import com.varial.personnel.domain.aeins.AEinsAdviceStruct;
import com.varial.personnel.domain.aeins.AEinsAdviceStructPackage.OptDxaa;
import com.varial.personnel.domain.aeins.AEinsAdviceStructPackage.OptDxab;
import com.varial.personnel.domain.aeins.AEinsExceptionMapper;
import com.varial.personnel.domain.aeins.AEinsHelper;
import com.varial.personnel.domain.aeins.AEinsPresetStruct;
import com.varial.personnel.domain.aeins.TypeOfRecordUnion;
import com.varial.personnel.domain.aeins.account.AEinsAccount;
import com.varial.personnel.domain.aeins.account.AEinsAdviceStateEnum;
import com.varial.personnel.domain.aeins.account.IAEinsAccountPersistencyManager;
import com.varial.personnel.domain.aeins.basictypes.Adresse;
import com.varial.personnel.domain.aeins.basictypes.Kommunikation;
import com.varial.personnel.domain.aeins.basictypes.Kurzaddresse;
import com.varial.personnel.domain.aeins.basictypes.Person;
import com.varial.personnel.domain.aeins.basictypes.ReasonEnum;
import com.varial.personnel.domain.aeins.dxa1.AEinsDxa1;
import com.varial.personnel.domain.aeins.dxa1.mapper.AEinsDxa1Mapper;
import com.varial.personnel.domain.aeins.dxag.AEinsDxag;
import com.varial.personnel.domain.aeins.dxag.mapper.AEinsDxagMapper;
import com.varial.personnel.domain.aeins.dxao.AEinsDxao;
import com.varial.personnel.domain.aeins.dxao.mapper.AEinsDxaoMapper;
import com.varial.personnel.domain.aeins.dxav.AEinsDxav;
import com.varial.personnel.domain.aeins.dxav.mapper.AEinsDxavMapper;
import com.varial.personnel.domain.aeins.kontaktsw.AEinsKontaktSW;
import com.varial.personnel.domain.companyplant.CompanyPlantCommunication;
import com.varial.personnel.domain.companyplant.Foundations;
import com.varial.personnel.domain.companyplant.LegalFormEnum;
import com.varial.personnel.domain.companyplant.TypeOfContactEnum;
import com.varial.personnel.domain.companyplant.TypeOfEmployerEnum;
import com.varial.personnel.domain.deuv.DeuvBasics;
import com.varial.personnel.domain.deuvmessaging.DeuvHelper;
import com.varial.personnel.domain.deuvmessaging.DeuvRecipientMap;
import com.varial.personnel.domain.employee.Employee;
import com.varial.personnel.domain.employee.IEmployeeReferenced;
import com.varial.personnel.domain.employee.SexEnum;
import com.varial.personnel.domain.employee.employment.Employment;
import com.varial.personnel.domain.employee.insurance.Insurance;
import com.varial.personnel.domain.employee.master.Master;
import com.varial.personnel.domain.global.deuv.recipient.DEUVRecipient;
import com.varial.personnel.domain.global.deuv.sender.DEUVSender;
import com.varial.personnel.domain.global.healthfund.HealthFund;
import com.varial.personnel.domain.global.healthfund.HealthFundPersistencyManager;
import com.varial.personnel.domain.global.healthfund.HealthFundTP;
import com.varial.personnel.domain.global.healthfund.TypeOfHealthFundEnum;
import com.varial.personnel.domain.global.occupationlong.OccupationLong;
import com.varial.personnel.domain.global.recipient.Recipient;
import com.varial.personnel.domain.global.recipient.RecipientPersistencyManager;
import com.varial.personnel.domain.global.recipient.RecipientTP;
import com.varial.personnel.domain.global.recipient.TypeOfRecipientEnum;
import com.varial.personnel.domain.global.state.State;
import com.varial.personnel.domain.global.state.StatePersistencyManager;
import com.varial.personnel.domain.pcompany.PCompany;
import com.varial.personnel.domain.pcompany.contacts.CompanyContact;
import com.varial.personnel.domain.pcompany.settings.EconomicSectorEnum;
import com.varial.personnel.domain.plant.Plant;
import com.varial.personnel.domain.plant.contacts.PlantContact;
import com.varial.personnel.framework.SpecialAccess;
import com.varial.personnel.framework.basictypes.Communication;
import com.varial.personnel.framework.basictypes.FormOfAddressEnum;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.StringMapper;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

public class AEinsAdvice {
    private final PCompany mPCompany;
    private Employee mEmployee;
    private final Date mCreatedOnDate;
    private final String mCreatedOnString;
    private boolean mAffectedBySpecialAccess;
    private int mReasonOfDelivery = 0;
    public static final String DVKA = "93121302";
    public static final String DRV = "66667777";
    public static final String DASBV = "17625773";
    private final DeuvRecipientMap mRecipientMap;
    private HealthFund mAbwKrankenkasse = null;
    private Date mBeginn = null;
    private Date mEnde = null;
    private State mState = null;

    public AEinsAdvice(PCompany comp, Employee emp, int reasonOfDelivery, AEinsPresetStruct preset) throws BusinessDomainException {
        this(comp, emp);
        this.mReasonOfDelivery = reasonOfDelivery;
        if (!StringMapper.isNullString((String)preset.beginn)) {
            this.mBeginn = DateMapper.toDate((String)preset.beginn);
        }
        if (!StringMapper.isNullString((String)preset.ende)) {
            this.mEnde = DateMapper.toDate((String)preset.ende);
        }
        if (!StringMapper.isNullString((String)preset.oidHealthFund)) {
            this.mAbwKrankenkasse = HealthFundPersistencyManager.getHealthFund((String)preset.oidHealthFund);
        } else {
            Insurance insurance = this.getInsurance(this.mBeginn);
            int pgs = insurance.getPersonGroup();
            if (pgs == 109 || pgs == 110 || pgs == 106 || pgs == 190) {
                this.mAbwKrankenkasse = insurance.getLegalHealthFund();
            }
        }
        if (!StringMapper.isNullString((String)preset.staat)) {
            this.mState = StatePersistencyManager.getState((String)preset.staat);
        }
    }

    public AEinsAdvice(PCompany comp, Employee emp) throws BusinessDomainException {
        this(comp);
        this.mEmployee = emp;
    }

    public AEinsAdvice(PCompany comp) throws BusinessDomainException {
        this.mPCompany = comp;
        this.mCreatedOnDate = VDate.getCurrentLocalizedDateAndTime();
        this.mCreatedOnString = DeuvBasics.formatDEUVTimestamp((Date)this.mCreatedOnDate);
        this.mAffectedBySpecialAccess = false;
        this.mRecipientMap = new DeuvRecipientMap(DeuvHelper.getDeuvSender((PCompany)this.mPCompany));
    }

    public static final String formatTimestampForQuery(Date d) {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
        return format.format(d);
    }

    public AEinsAdviceStruct createSuggestion(AEinsAccount clone) {
        return this.createStruct(clone);
    }

    public AEinsAdviceStruct createSuggestion() throws BusinessDomainException {
        this.isCreateOfSuggestionPossible();
        return this.createStruct();
    }

    private void isCreateOfSuggestionPossible() throws BusinessDomainException {
        if (this.mState == null || !AEinsHelper.checkState((String)this.mState.getState())) {
            throw AEinsExceptionMapper.makeStateNotAllowed(this.mState.getState());
        }
        if (this.mBeginn == null || this.mEnde == null) {
            throw AEinsExceptionMapper.makeNoFromDateException();
        }
        if (DateHelper.before((Date)this.mEnde, (Date)this.mBeginn)) {
            throw AEinsExceptionMapper.makeEndForBeginDateException();
        }
        switch (this.mReasonOfDelivery) {
            case 1: {
                if (!this.getFoundations(this.mBeginn).getTypeOfEmployer().equals(TypeOfEmployerEnum.TOEE_0_privater_Arbeitgeber) || this.mEnde == null || DateHelper.getDiffInMonths((Date)this.mEnde, (Date)this.mBeginn) < 24) break;
                throw AEinsExceptionMapper.makeMonthsExceededException();
            }
            case 2: {
                if (this.mEnde == null || DateHelper.getDiffInMonths((Date)this.mEnde, (Date)this.mBeginn) < 60) break;
                throw AEinsExceptionMapper.makeMonthsExceededException();
            }
            case 6: {
                if (this.mEnde == null || DateHelper.getDiffInMonths((Date)this.mEnde, (Date)this.mBeginn) < 60) break;
                throw AEinsExceptionMapper.makeMonthsExceededException();
            }
        }
        EconomicSectorEnum sector = this.getEconomicSector();
        if (sector == null || sector.equals((Object)EconomicSectorEnum.KEIN)) {
            throw AEinsExceptionMapper.makeNoEconomicSectorException();
        }
        Insurance insurance = this.getInsurance(this.mBeginn);
        int pgs = insurance.getPersonGroup();
        if (!(pgs != 109 && pgs != 110 && pgs != 106 && pgs != 190 || this.mAbwKrankenkasse != null || insurance.getDuesGroupHI() == 0 && insurance.getRecipientPHI() != null || insurance.getPersonGroup() == 109 && (insurance.getDuesGroupHI() == 3 || insurance.getDuesGroupPI() == 1) && insurance.getUseTransitionBy31122022())) {
            throw AEinsExceptionMapper.makeDiffHealthFundNeededException();
        }
        if (pgs >= 900 && this.mReasonOfDelivery != 5) {
            throw AEinsExceptionMapper.makePGSNotAllowedException();
        }
    }

    private EconomicSectorEnum getEconomicSector() throws BusinessDomainException {
        return this.getFoundations(this.mBeginn).getEconomicSector();
    }

    public void check(AEinsAccount account) throws BusinessDomainException {
        switch (account.getReason()) {
            case DXA1: {
                account.getDxa1().checkAttributes(account);
                break;
            }
            case DXAV: {
                account.getDxav().checkAttributes(account);
                break;
            }
            case DXAO: {
                account.getDxao().checkAttributes(account);
                break;
            }
            case DXAG: {
                account.getDxag().checkAttributes(account);
                break;
            }
            default: {
                throw new IllegalArgumentException("The reason of delivery " + this.mReasonOfDelivery + " is not supported.");
            }
        }
    }

    private AEinsAdviceStruct createStruct(AEinsAccount clone) {
        TypeOfRecordUnion typeOfRecordUnion = new TypeOfRecordUnion();
        OptDxab optDxab = new OptDxab();
        OptDxaa optDxaa = new OptDxaa();
        switch (clone.getReason().ordinal() + 1) {
            case 1: {
                AEinsDxa1 dxa1 = clone.getDxa1();
                typeOfRecordUnion.dxa1(AEinsDxa1Mapper.toIdl((AEinsDxa1)dxa1));
                return new AEinsAdviceStruct(typeOfRecordUnion, optDxab, optDxaa);
            }
            case 2: {
                AEinsDxav dxav = clone.getDxav();
                typeOfRecordUnion.dxav(AEinsDxavMapper.toIdl((AEinsDxav)dxav));
                return new AEinsAdviceStruct(typeOfRecordUnion, optDxab, optDxaa);
            }
            case 5: {
                AEinsDxao dxao = clone.getDxao();
                typeOfRecordUnion.dxao(AEinsDxaoMapper.toIdl((AEinsDxao)dxao));
                return new AEinsAdviceStruct(typeOfRecordUnion, optDxab, optDxaa);
            }
            case 6: {
                AEinsDxag dxag = clone.getDxag();
                typeOfRecordUnion.dxag(AEinsDxagMapper.toIdl((AEinsDxag)dxag));
                return new AEinsAdviceStruct(typeOfRecordUnion, optDxab, optDxaa);
            }
        }
        throw new IllegalArgumentException("The reason of delivery " + this.mReasonOfDelivery + " is not supported.");
    }

    private AEinsAdviceStruct createStruct() throws BusinessDomainException {
        TypeOfRecordUnion typeOfRecordUnion = new TypeOfRecordUnion();
        OptDxab optDxab = new OptDxab();
        OptDxaa optDxaa = new OptDxaa();
        switch (this.mReasonOfDelivery) {
            case 1: {
                AEinsDxa1 dxa1 = this.createDxa1();
                typeOfRecordUnion.dxa1(AEinsDxa1Mapper.toIdl((AEinsDxa1)dxa1));
                return new AEinsAdviceStruct(typeOfRecordUnion, optDxab, optDxaa);
            }
            case 2: {
                AEinsDxav dxav = this.createDxav();
                typeOfRecordUnion.dxav(AEinsDxavMapper.toIdl((AEinsDxav)dxav));
                return new AEinsAdviceStruct(typeOfRecordUnion, optDxab, optDxaa);
            }
            case 5: {
                AEinsDxao dxao = this.createDxao();
                typeOfRecordUnion.dxao(AEinsDxaoMapper.toIdl((AEinsDxao)dxao));
                return new AEinsAdviceStruct(typeOfRecordUnion, optDxab, optDxaa);
            }
            case 6: {
                AEinsDxag dxag = this.createDxag();
                typeOfRecordUnion.dxag(AEinsDxagMapper.toIdl((AEinsDxag)dxag));
                return new AEinsAdviceStruct(typeOfRecordUnion, optDxab, optDxaa);
            }
        }
        throw new IllegalArgumentException("The reason of delivery " + this.mReasonOfDelivery + " is not supported.");
    }

    public AEinsDxav createDxav() throws BusinessDomainException {
        HealthFundTP kvtp;
        OccupationLong occupation;
        String appVu;
        AEinsDxav bo = new AEinsDxav();
        bo.setVersionsnummer("010400");
        bo.setAbsendernummer(DeuvHelper.getDeuvSenderStdCompNo((PCompany)this.mPCompany));
        bo.setEmpfaengernummer(this.getRecipient());
        bo.setDatumerstellung(this.mCreatedOnString);
        bo.setProdid(DeuvBasics.getProdId());
        bo.setModid(DeuvBasics.getModId());
        bo.setAktenzeichenverurs(this.getAzvu());
        bo.setStornokennzeichen("N");
        bo.createAEinsAn();
        bo.getAEinsAn().getPerson().setGeschlecht(AEinsHelper.getGeschlecht((SexEnum)this.getMaster(this.mBeginn).getSex()));
        bo.getAEinsAn().getPerson().setVorname(this.getMaster(this.mBeginn).getFirstname());
        bo.getAEinsAn().getPerson().setName(this.getMaster(this.mBeginn).getSurname());
        bo.getAEinsAn().getPerson().setVorsatz(this.getMaster(this.mBeginn).getNamePrefix());
        bo.getAEinsAn().getPerson().setNamenszusatz(this.getMaster(this.mBeginn).getNameAffix());
        bo.getAEinsAn().getPerson().setTitel(this.getMaster(this.mBeginn).getTitle());
        bo.getAEinsAn().setGeburtsname(this.getInsurance(this.mBeginn).getNameAtBirth());
        bo.getAEinsAn().setGeburtsdatum(this.getMaster(this.mBeginn).getDateOfBirth());
        bo.getAEinsAn().setGeburtsort(this.getInsurance(this.mBeginn).getPlaceOfBirth());
        bo.getAEinsAn().setVersicherungsnummer(this.getInsurance(this.mBeginn).getInsuranceNo());
        bo.getAEinsAn().setStaatsangehoerigkeit(this.getInsurance(this.mBeginn).getNationality().getState());
        bo.getAEinsAn().setGeburtsland(this.getInsurance(this.mBeginn).getEuStateOfBirthKey());
        if (StringMapper.isNullString((String)bo.getAEinsAn().getGeburtsland())) {
            bo.getAEinsAn().setGeburtsland(this.getInsurance(this.mBeginn).getNationality().getState());
        }
        bo.createAnschrift(1);
        bo.setAnzahlanschrift(1);
        bo.getAEinsAnschrift()[0].setAnschriftsart(1);
        Adresse adresse = new Adresse(this.getInsurance(this.mBeginn).getStreet(), this.getInsurance(this.mBeginn).getStreetNumber(), this.getInsurance(this.mBeginn).getPostalCode(), this.getInsurance(this.mBeginn).getDomicile(), this.getInsurance(this.mBeginn).getAddressaddendum(), this.getMaster(this.mBeginn).getState() != null ? this.getMaster(this.mBeginn).getState().getState() : "000");
        bo.getAEinsAnschrift()[0].setAdresse(adresse);
        bo.setAnzahkontakte(0);
        bo.createAEinsFirma();
        bo.getAEinsFirma().setName(this.getFoundations(this.mBeginn).getShortDescription());
        adresse = new Adresse(this.getFoundations(this.mBeginn).getPostalAddress().getSeparateStreet().trim(), this.getFoundations(this.mBeginn).getPostalAddress().getSeparateNumber().trim(), this.getFoundations(this.mBeginn).getPostalAddress().getPostalCode(), this.getFoundations(this.mBeginn).getPostalAddress().getCity(), "", "000");
        bo.getAEinsFirma().setAdresse(adresse);
        bo.createKontaktSW(1);
        Kommunikation kom = new Kommunikation(this.getCommunication(this.mBeginn).getPhone(), this.getCommunication(this.mBeginn).getFax(), this.getCommunication(this.mBeginn).getEMail());
        bo.getAEinsKontaktSW()[0].setKommunikation(kom);
        if (this.getFoundations(this.mBeginn).getTypeOfEmployer().equals(TypeOfEmployerEnum.TOEE_0_privater_Arbeitgeber)) {
            if (this.getFoundations(this.mBeginn).getLegalForm().equals(LegalFormEnum.LFE_36_SONSTIGE)) {
                bo.getAEinsFirma().setRechtsform(3);
            } else {
                bo.getAEinsFirma().setRechtsform(1);
            }
        } else {
            bo.getAEinsFirma().setRechtsform(2);
        }
        bo.getAEinsFirma().setBetriebsnummervu(this.getBetriebsnummervu());
        CompanyContact contact = null;
        for (CompanyContact companyContact : this.mPCompany.getCompanyContact()) {
            if (!companyContact.getTypeOfContact().equals(TypeOfContactEnum.TOCE_A1)) continue;
            contact = companyContact;
            break;
        }
        if (contact != null) {
            kom = bo.getAEinsKontaktSW()[0].getKommunikation();
            if (!StringMapper.isNullString((String)contact.getAssignmentContact().getEMail())) {
                kom.setEmail(contact.getAssignmentContact().getEMail());
            }
            if (!StringMapper.isNullString((String)contact.getAssignmentContact().getFax())) {
                kom.setFaxnummer(contact.getAssignmentContact().getFax());
            }
            if (!StringMapper.isNullString((String)contact.getAssignmentContact().getPhone())) {
                kom.setTelefonnummer(contact.getAssignmentContact().getPhone());
            }
        }
        if (!StringMapper.isNullString((String)(appVu = this.getAppurtenantBetriebsnummervu())) && !appVu.equals(bo.getAEinsFirma().getBetriebsnummervu())) {
            Plant plant = this.mEmployee.getAppurtenantPlant(VDate.getDateMax(), this.mBeginn);
            bo.getAEinsFirma().setName(this.getFoundationsPlant(plant, this.mBeginn).getShortDescription());
            adresse = new Adresse(this.getFoundationsPlant(plant, this.mBeginn).getPostalAddress().getSeparateStreet().trim(), this.getFoundationsPlant(plant, this.mBeginn).getPostalAddress().getSeparateNumber().trim(), this.getFoundationsPlant(plant, this.mBeginn).getPostalAddress().getPostalCode(), this.getFoundationsPlant(plant, this.mBeginn).getPostalAddress().getCity(), "", "000");
            bo.getAEinsFirma().setAdresse(adresse);
            kom = new Kommunikation(this.getCommunicationPlant(plant, this.mBeginn).getPhone(), this.getCommunicationPlant(plant, this.mBeginn).getFax(), this.getCommunicationPlant(plant, this.mBeginn).getEMail());
            bo.getAEinsKontaktSW()[0].setKommunikation(kom);
            if (this.getFoundationsPlant(plant, this.mBeginn).getTypeOfEmployer().equals(TypeOfEmployerEnum.TOEE_0_privater_Arbeitgeber)) {
                if (this.getFoundationsPlant(plant, this.mBeginn).getLegalForm().equals(LegalFormEnum.LFE_36_SONSTIGE)) {
                    bo.getAEinsFirma().setRechtsform(3);
                } else {
                    bo.getAEinsFirma().setRechtsform(1);
                }
            } else {
                bo.getAEinsFirma().setRechtsform(2);
            }
            bo.getAEinsFirma().setBetriebsnummervu(this.getAppurtenantBetriebsnummervu());
            PlantContact contactPlant = null;
            for (PlantContact each : plant.getPlantContact()) {
                if (!each.getTypeOfContact().equals(TypeOfContactEnum.TOCE_A1)) continue;
                contactPlant = each;
                break;
            }
            if (contactPlant != null) {
                kom = bo.getAEinsKontaktSW()[0].getKommunikation();
                if (!StringMapper.isNullString((String)contactPlant.getAssignmentContact().getEMail())) {
                    kom.setEmail(contactPlant.getAssignmentContact().getEMail());
                }
                if (!StringMapper.isNullString((String)contactPlant.getAssignmentContact().getFax())) {
                    kom.setFaxnummer(contactPlant.getAssignmentContact().getFax());
                }
                if (!StringMapper.isNullString((String)contactPlant.getAssignmentContact().getPhone())) {
                    kom.setTelefonnummer(contactPlant.getAssignmentContact().getPhone());
                }
            }
        }
        bo.setRechtsvorschrift("J");
        bo.setBeginnantrag(this.mBeginn);
        if (this.mEnde != null) {
            bo.setEndeantrag(this.mEnde);
        }
        if ((occupation = this.getInsurance(this.mBeginn).getOccupationLong()) != null) {
            bo.setTaetigkeiteutsch(occupation.getOccupationKey());
            bo.setTaetigkeitausland(occupation.getOccupationKey());
        }
        if ((kvtp = this.getHealthFundTP()) != null) {
            bo.setBetriebsnummer(kvtp.getStandardCompanyNumber());
        }
        bo.setNametraeger("");
        Kurzaddresse kurzaddresse = new Kurzaddresse("", "", "", "");
        bo.setKurzadressetraeger(kurzaddresse);
        bo.createEinsatzort(1);
        bo.getEinsatzort()[0].getAdresse().setLaenderschluessel(this.mState.getState());
        bo.setNennenswerttaetig("J");
        bo.setWeiterespersonal("J");
        bo.setAntragspflicht("J");
        bo.setTatsacheverhaltnis("J");
        bo.setErfuellungmeldepfl("J");
        bo.setMitteilungaenderg("J");
        bo.setMitteilungweiter("J");
        bo.setErklaerungan("J");
        bo.setBerichtspflichten("J");
        bo.setFortfuehrungbav("J");
        bo.setEinsatzgleichbesch("J");
        bo.setVorhermitgliedland("J");
        bo.setGesamtdauer("J");
        bo.setBeschverbunden("J");
        bo.setAbloesung("N");
        if (StringMapper.equal((String)DASBV, (String)bo.getEmpfaengernummer())) {
            bo.setEmpfaengernummer(this.getRecipientDASBV().getStandardCompanyNumber());
        }
        return bo;
    }

    public AEinsDxa1 createDxa1() throws BusinessDomainException {
        String appVu;
        AEinsDxa1 bo = new AEinsDxa1();
        bo.setVersionsnummer("010500");
        bo.setAbsendernummer(DeuvHelper.getDeuvSenderStdCompNo((PCompany)this.mPCompany));
        bo.setEmpfaengernummer(this.getRecipient());
        bo.setDatumerstellung(this.mCreatedOnString);
        bo.setProdid(DeuvBasics.getProdId());
        bo.setModid(DeuvBasics.getModId());
        bo.setAktenzeichenverurs(this.getAzvu());
        bo.setStornokennzeichen("N");
        bo.createAEinsAn();
        bo.getAEinsAn().getPerson().setGeschlecht(AEinsHelper.getGeschlecht((SexEnum)this.getMaster(this.mBeginn).getSex()));
        bo.getAEinsAn().getPerson().setVorname(this.getMaster(this.mBeginn).getFirstname());
        bo.getAEinsAn().getPerson().setName(this.getMaster(this.mBeginn).getSurname());
        bo.getAEinsAn().getPerson().setVorsatz(this.getMaster(this.mBeginn).getNamePrefix());
        bo.getAEinsAn().getPerson().setNamenszusatz(this.getMaster(this.mBeginn).getNameAffix());
        bo.getAEinsAn().getPerson().setTitel(this.getMaster(this.mBeginn).getTitle());
        bo.getAEinsAn().setGeburtsname(this.getInsurance(this.mBeginn).getNameAtBirth());
        bo.getAEinsAn().setGeburtsdatum(this.getMaster(this.mBeginn).getDateOfBirth());
        bo.getAEinsAn().setGeburtsort(this.getInsurance(this.mBeginn).getPlaceOfBirth());
        bo.getAEinsAn().setVersicherungsnummer(this.getInsurance(this.mBeginn).getInsuranceNo());
        bo.getAEinsAn().setStaatsangehoerigkeit(this.getInsurance(this.mBeginn).getNationality().getState());
        bo.getAEinsAn().setGeburtsland(this.getInsurance(this.mBeginn).getEuStateOfBirthKey());
        if (StringMapper.isNullString((String)bo.getAEinsAn().getGeburtsland())) {
            bo.getAEinsAn().setGeburtsland(this.getInsurance(this.mBeginn).getNationality().getState());
        }
        bo.createAnschrift(1);
        bo.setAnzahlanschrift(1);
        bo.getAEinsAnschrift()[0].setAnschriftsart(1);
        Adresse adresse = new Adresse(this.getInsurance(this.mBeginn).getStreet(), this.getInsurance(this.mBeginn).getStreetNumber(), this.getInsurance(this.mBeginn).getPostalCode(), this.getInsurance(this.mBeginn).getDomicile(), this.getInsurance(this.mBeginn).getAddressaddendum(), this.getMaster(this.mBeginn).getState() != null ? this.getMaster(this.mBeginn).getState().getState() : "000");
        bo.getAEinsAnschrift()[0].setAdresse(adresse);
        bo.setAnzahkontakte(0);
        if (bo.getEmpfaengernummer().equals(DASBV)) {
            bo.setMitgliedsnummerabv(this.getInsurance(this.mBeginn).getPpMembershipNumber());
        }
        bo.setStaatentsendung(this.mState.getState());
        bo.setBeginnentsendung(this.mBeginn);
        bo.setEndeentsendung(this.mEnde);
        bo.setZahlungsvdavor("J");
        OccupationLong occupation = this.getInsurance(this.mBeginn).getOccupationLong();
        if (occupation != null) {
            bo.setTaetigkeitdeutsch(occupation.getOccupationKey());
            bo.setTaetigkeitausland(occupation.getOccupationKey());
        }
        bo.createAEinsFirma();
        bo.getAEinsFirma().setName(this.getFoundations(this.mBeginn).getShortDescription());
        adresse = new Adresse(this.getFoundations(this.mBeginn).getPostalAddress().getSeparateStreet().trim(), this.getFoundations(this.mBeginn).getPostalAddress().getSeparateNumber().trim(), this.getFoundations(this.mBeginn).getPostalAddress().getPostalCode(), this.getFoundations(this.mBeginn).getPostalAddress().getCity(), "", "000");
        bo.getAEinsFirma().setAdresse(adresse);
        Kommunikation kom = new Kommunikation(this.getCommunication(this.mBeginn).getPhone(), this.getCommunication(this.mBeginn).getFax(), this.getCommunication(this.mBeginn).getEMail());
        bo.getAEinsFirma().setKommunikation(kom);
        if (this.getFoundations(this.mBeginn).getTypeOfEmployer().equals(TypeOfEmployerEnum.TOEE_0_privater_Arbeitgeber)) {
            if (this.getFoundations(this.mBeginn).getLegalForm().equals(LegalFormEnum.LFE_36_SONSTIGE)) {
                bo.getAEinsFirma().setRechtsform(3);
            } else {
                bo.getAEinsFirma().setRechtsform(1);
            }
        } else {
            bo.getAEinsFirma().setRechtsform(2);
        }
        bo.getAEinsFirma().setBetriebsnummervu(this.getBetriebsnummervu());
        CompanyContact contact = null;
        for (CompanyContact companyContact : this.mPCompany.getCompanyContact()) {
            if (!companyContact.getTypeOfContact().equals(TypeOfContactEnum.TOCE_A1)) continue;
            contact = companyContact;
            break;
        }
        if (contact != null) {
            String[] split;
            kom = bo.getAEinsFirma().getKommunikation();
            if (!StringMapper.isNullString((String)contact.getAssignmentContact().getEMail())) {
                kom.setEmail(contact.getAssignmentContact().getEMail());
            }
            if (!StringMapper.isNullString((String)contact.getAssignmentContact().getFax())) {
                kom.setFaxnummer(contact.getAssignmentContact().getFax());
            }
            if (!StringMapper.isNullString((String)contact.getAssignmentContact().getPhone())) {
                kom.setTelefonnummer(contact.getAssignmentContact().getPhone());
            }
            bo.createKontaktAG();
            bo.setAnzahlkontakteag(1);
            if (contact.getContactFormOfAddress().equals(FormOfAddressEnum.FOAE_Herr)) {
                bo.getAEinsKontaktAG()[0].setGeschlecht("M");
            } else if (contact.getContactFormOfAddress().equals(FormOfAddressEnum.FOAE_Frau)) {
                bo.getAEinsKontaktAG()[0].setGeschlecht("W");
            }
            if (contact.getAssignmentContact().getContactPerson() != null && (split = contact.getAssignmentContact().getContactPerson().split(" ")) != null && split.length > 0) {
                bo.getAEinsKontaktAG()[0].setVorname(split[0]);
                if (split.length > 1) {
                    bo.getAEinsKontaktAG()[0].setFamilienname(split[1]);
                }
            }
        }
        if (!StringMapper.isNullString((String)(appVu = this.getAppurtenantBetriebsnummervu())) && !appVu.equals(bo.getAEinsFirma().getBetriebsnummervu())) {
            Plant plant = this.mEmployee.getAppurtenantPlant(VDate.getDateMax(), this.mBeginn);
            bo.getAEinsFirma().setName(this.getFoundationsPlant(plant, this.mBeginn).getShortDescription());
            adresse = new Adresse(this.getFoundationsPlant(plant, this.mBeginn).getPostalAddress().getSeparateStreet().trim(), this.getFoundationsPlant(plant, this.mBeginn).getPostalAddress().getSeparateNumber().trim(), this.getFoundationsPlant(plant, this.mBeginn).getPostalAddress().getPostalCode(), this.getFoundationsPlant(plant, this.mBeginn).getPostalAddress().getCity(), "", "000");
            bo.getAEinsFirma().setAdresse(adresse);
            kom = new Kommunikation(this.getCommunicationPlant(plant, this.mBeginn).getPhone(), this.getCommunicationPlant(plant, this.mBeginn).getFax(), this.getCommunicationPlant(plant, this.mBeginn).getEMail());
            bo.getAEinsFirma().setKommunikation(kom);
            if (this.getFoundationsPlant(plant, this.mBeginn).getTypeOfEmployer().equals(TypeOfEmployerEnum.TOEE_0_privater_Arbeitgeber)) {
                if (this.getFoundationsPlant(plant, this.mBeginn).getLegalForm().equals(LegalFormEnum.LFE_36_SONSTIGE)) {
                    bo.getAEinsFirma().setRechtsform(3);
                } else {
                    bo.getAEinsFirma().setRechtsform(1);
                }
            } else {
                bo.getAEinsFirma().setRechtsform(2);
            }
            bo.getAEinsFirma().setBetriebsnummervu(this.getAppurtenantBetriebsnummervu());
            PlantContact contactPlant = null;
            for (PlantContact each : plant.getPlantContact()) {
                if (!each.getTypeOfContact().equals(TypeOfContactEnum.TOCE_A1)) continue;
                contactPlant = each;
                break;
            }
            if (contactPlant != null) {
                String[] stringArray;
                kom = bo.getAEinsFirma().getKommunikation();
                if (!StringMapper.isNullString((String)contactPlant.getAssignmentContact().getEMail())) {
                    kom.setEmail(contactPlant.getAssignmentContact().getEMail());
                }
                if (!StringMapper.isNullString((String)contactPlant.getAssignmentContact().getFax())) {
                    kom.setFaxnummer(contactPlant.getAssignmentContact().getFax());
                }
                if (!StringMapper.isNullString((String)contactPlant.getAssignmentContact().getPhone())) {
                    kom.setTelefonnummer(contactPlant.getAssignmentContact().getPhone());
                }
                if (bo.getAEinsKontaktAG() == null || bo.getAEinsKontaktAG().length <= 0) {
                    bo.createKontaktAG();
                    bo.setAnzahlkontakteag(1);
                }
                if (contactPlant.getContactFormOfAddress().equals(FormOfAddressEnum.FOAE_Herr)) {
                    bo.getAEinsKontaktAG()[0].setGeschlecht("M");
                } else if (contactPlant.getContactFormOfAddress().equals(FormOfAddressEnum.FOAE_Frau)) {
                    bo.getAEinsKontaktAG()[0].setGeschlecht("W");
                }
                if (contactPlant.getAssignmentContact().getContactPerson() != null && (stringArray = contactPlant.getAssignmentContact().getContactPerson().split(" ")) != null && stringArray.length > 0) {
                    bo.getAEinsKontaktAG()[0].setVorname(stringArray[0]);
                    if (stringArray.length > 1) {
                        bo.getAEinsKontaktAG()[0].setFamilienname(stringArray[1]);
                    }
                }
            }
        }
        bo.setWirtschaftssektor("" + EconomicSectorEnum.toInt((EconomicSectorEnum)this.getEconomicSector()));
        bo.setZahlungsvdavor("J");
        bo.setEntgeltanspruchag("J");
        bo.setAnwerbungan("J");
        bo.setEntscheidungarbver("J");
        bo.setEntlassung("J");
        bo.setEntscheidungaufg("J");
        bo.setNennenswerttaetig("J");
        bo.setWeiterespersonal("J");
        bo.setTatsacheverhaltnis("J");
        bo.setInfounterbrechung("J");
        bo.setInfobeinicht("J");
        bo.setInfoandererag("J");
        bo.setInfoweiterbesch("J");
        if (StringMapper.equal((String)DASBV, (String)bo.getEmpfaengernummer())) {
            bo.setEmpfaengernummer(this.getRecipientDASBV().getStandardCompanyNumber());
        }
        return bo;
    }

    public AEinsDxao createDxao() throws BusinessDomainException {
        String appVu;
        AEinsDxao bo = new AEinsDxao();
        bo.setVersionsnummer("010000");
        bo.setAbsendernummer(DeuvHelper.getDeuvSenderStdCompNo((PCompany)this.mPCompany));
        bo.setEmpfaengernummer(this.getRecipient());
        bo.setDatumerstellung(this.mCreatedOnString);
        bo.setProdid(DeuvBasics.getProdId());
        bo.setModid(DeuvBasics.getModId());
        bo.setAktenzeichenverurs(this.getAzvu());
        bo.setStornokennzeichen("N");
        bo.createAEinsAn();
        bo.getAEinsAn().getPerson().setGeschlecht(AEinsHelper.getGeschlecht((SexEnum)this.getMaster(this.mBeginn).getSex()));
        bo.getAEinsAn().getPerson().setVorname(this.getMaster(this.mBeginn).getFirstname());
        bo.getAEinsAn().getPerson().setName(this.getMaster(this.mBeginn).getSurname());
        bo.getAEinsAn().getPerson().setVorsatz(this.getMaster(this.mBeginn).getNamePrefix());
        bo.getAEinsAn().getPerson().setNamenszusatz(this.getMaster(this.mBeginn).getNameAffix());
        bo.getAEinsAn().getPerson().setTitel(this.getMaster(this.mBeginn).getTitle());
        bo.getAEinsAn().setGeburtsname(this.getInsurance(this.mBeginn).getNameAtBirth());
        bo.getAEinsAn().setGeburtsdatum(this.getMaster(this.mBeginn).getDateOfBirth());
        bo.getAEinsAn().setGeburtsort(this.getInsurance(this.mBeginn).getPlaceOfBirth());
        bo.getAEinsAn().setVersicherungsnummer(this.getInsurance(this.mBeginn).getInsuranceNo());
        bo.getAEinsAn().setStaatsangehoerigkeit(this.getInsurance(this.mBeginn).getNationality().getState());
        bo.getAEinsAn().setGeburtsland(this.getInsurance(this.mBeginn).getEuStateOfBirthKey());
        if (StringMapper.isNullString((String)bo.getAEinsAn().getGeburtsland())) {
            bo.getAEinsAn().setGeburtsland(this.getInsurance(this.mBeginn).getNationality().getState());
        }
        bo.createAnschrift(1);
        bo.setAnzahlanschrift(1);
        bo.getAEinsAnschrift()[0].setAnschriftsart(1);
        Adresse adresse = new Adresse(this.getInsurance(this.mBeginn).getStreet(), this.getInsurance(this.mBeginn).getStreetNumber(), this.getInsurance(this.mBeginn).getPostalCode(), this.getInsurance(this.mBeginn).getDomicile(), this.getInsurance(this.mBeginn).getAddressaddendum(), this.getMaster(this.mBeginn).getState() != null ? this.getMaster(this.mBeginn).getState().getState() : "000");
        bo.getAEinsAnschrift()[0].setAdresse(adresse);
        bo.setStaatentsendung(this.mState.getState());
        bo.setBeginnentsendung(this.mBeginn);
        bo.setEndeentsendung(this.mEnde);
        bo.createAEinsFirma();
        bo.getAEinsFirma().setName(this.getFoundations(this.mBeginn).getShortDescription());
        adresse = new Adresse(this.getFoundations(this.mBeginn).getPostalAddress().getSeparateStreet().trim(), this.getFoundations(this.mBeginn).getPostalAddress().getSeparateNumber().trim(), this.getFoundations(this.mBeginn).getPostalAddress().getPostalCode(), this.getFoundations(this.mBeginn).getPostalAddress().getCity(), "", "000");
        bo.getAEinsFirma().setAdresse(adresse);
        Kommunikation kom = new Kommunikation(this.getCommunication(this.mBeginn).getPhone(), this.getCommunication(this.mBeginn).getFax(), this.getCommunication(this.mBeginn).getEMail());
        bo.getAEinsFirma().setKommunikation(kom);
        if (this.getFoundations(this.mBeginn).getTypeOfEmployer().equals(TypeOfEmployerEnum.TOEE_0_privater_Arbeitgeber)) {
            if (this.getFoundations(this.mBeginn).getLegalForm().equals(LegalFormEnum.LFE_36_SONSTIGE)) {
                bo.getAEinsFirma().setRechtsform(3);
            } else {
                bo.getAEinsFirma().setRechtsform(1);
            }
        } else {
            bo.getAEinsFirma().setRechtsform(2);
        }
        bo.getAEinsFirma().setBetriebsnummervu(this.getBetriebsnummervu());
        CompanyContact contact = null;
        for (CompanyContact each : this.mPCompany.getCompanyContact()) {
            if (!each.getTypeOfContact().equals(TypeOfContactEnum.TOCE_A1)) continue;
            contact = each;
            break;
        }
        if (contact != null) {
            kom = bo.getAEinsFirma().getKommunikation();
            if (!StringMapper.isNullString((String)contact.getAssignmentContact().getEMail())) {
                kom.setEmail(contact.getAssignmentContact().getEMail());
            }
            if (!StringMapper.isNullString((String)contact.getAssignmentContact().getFax())) {
                kom.setFaxnummer(contact.getAssignmentContact().getFax());
            }
            if (!StringMapper.isNullString((String)contact.getAssignmentContact().getPhone())) {
                kom.setTelefonnummer(contact.getAssignmentContact().getPhone());
            }
        }
        if (!StringMapper.isNullString((String)(appVu = this.getAppurtenantBetriebsnummervu())) && !appVu.equals(bo.getAEinsFirma().getBetriebsnummervu())) {
            Plant plant = this.mEmployee.getAppurtenantPlant(VDate.getDateMax(), this.mBeginn);
            bo.getAEinsFirma().setName(this.getFoundationsPlant(plant, this.mBeginn).getShortDescription());
            adresse = new Adresse(this.getFoundationsPlant(plant, this.mBeginn).getPostalAddress().getSeparateStreet().trim(), this.getFoundationsPlant(plant, this.mBeginn).getPostalAddress().getSeparateNumber().trim(), this.getFoundationsPlant(plant, this.mBeginn).getPostalAddress().getPostalCode(), this.getFoundationsPlant(plant, this.mBeginn).getPostalAddress().getCity(), "", "000");
            bo.getAEinsFirma().setAdresse(adresse);
            kom = new Kommunikation(this.getCommunicationPlant(plant, this.mBeginn).getPhone(), this.getCommunicationPlant(plant, this.mBeginn).getFax(), this.getCommunicationPlant(plant, this.mBeginn).getEMail());
            bo.getAEinsFirma().setKommunikation(kom);
            if (this.getFoundationsPlant(plant, this.mBeginn).getTypeOfEmployer().equals(TypeOfEmployerEnum.TOEE_0_privater_Arbeitgeber)) {
                if (this.getFoundationsPlant(plant, this.mBeginn).getLegalForm().equals(LegalFormEnum.LFE_36_SONSTIGE)) {
                    bo.getAEinsFirma().setRechtsform(3);
                } else {
                    bo.getAEinsFirma().setRechtsform(1);
                }
            } else {
                bo.getAEinsFirma().setRechtsform(2);
            }
            bo.getAEinsFirma().setBetriebsnummervu(this.getAppurtenantBetriebsnummervu());
            PlantContact contactPlant = null;
            for (PlantContact each : plant.getPlantContact()) {
                if (!each.getTypeOfContact().equals(TypeOfContactEnum.TOCE_A1)) continue;
                contactPlant = each;
                break;
            }
            if (contactPlant != null) {
                kom = bo.getAEinsFirma().getKommunikation();
                if (!StringMapper.isNullString((String)contactPlant.getAssignmentContact().getEMail())) {
                    kom.setEmail(contactPlant.getAssignmentContact().getEMail());
                }
                if (!StringMapper.isNullString((String)contactPlant.getAssignmentContact().getFax())) {
                    kom.setFaxnummer(contactPlant.getAssignmentContact().getFax());
                }
                if (!StringMapper.isNullString((String)contactPlant.getAssignmentContact().getPhone())) {
                    kom.setTelefonnummer(contactPlant.getAssignmentContact().getPhone());
                }
            }
        }
        bo.setAngabeneinverstanden("J");
        bo.setAktivesbeamtenverh("N");
        bo.setBeurlaubung("N");
        bo.setDienstinteresse("N");
        bo.setAktivesoevverh("N");
        bo.setGeltung("N");
        return bo;
    }

    public AEinsDxag createDxag() throws BusinessDomainException {
        String appVu;
        AEinsDxag bo = new AEinsDxag();
        bo.setVersionsnummer("010100");
        bo.setAbsendernummer(DeuvHelper.getDeuvSenderStdCompNo((PCompany)this.mPCompany));
        bo.setEmpfaengernummer(this.getRecipient());
        bo.setDatumerstellung(this.mCreatedOnString);
        bo.setProdid(DeuvBasics.getProdId());
        bo.setModid(DeuvBasics.getModId());
        bo.setAktenzeichenverurs(this.getAzvu());
        bo.setStornokennzeichen("N");
        bo.createAEinsAn();
        bo.getAEinsAn().getPerson().setGeschlecht(AEinsHelper.getGeschlecht((SexEnum)this.getMaster(this.mBeginn).getSex()));
        bo.getAEinsAn().getPerson().setVorname(this.getMaster(this.mBeginn).getFirstname());
        bo.getAEinsAn().getPerson().setName(this.getMaster(this.mBeginn).getSurname());
        bo.getAEinsAn().getPerson().setVorsatz(this.getMaster(this.mBeginn).getNamePrefix());
        bo.getAEinsAn().getPerson().setNamenszusatz(this.getMaster(this.mBeginn).getNameAffix());
        bo.getAEinsAn().getPerson().setTitel(this.getMaster(this.mBeginn).getTitle());
        bo.getAEinsAn().setGeburtsname(this.getInsurance(this.mBeginn).getNameAtBirth());
        bo.getAEinsAn().setGeburtsdatum(this.getMaster(this.mBeginn).getDateOfBirth());
        bo.getAEinsAn().setGeburtsort(this.getInsurance(this.mBeginn).getPlaceOfBirth());
        bo.getAEinsAn().setVersicherungsnummer(this.getInsurance(this.mBeginn).getInsuranceNo());
        bo.getAEinsAn().setStaatsangehoerigkeit(this.getInsurance(this.mBeginn).getNationality().getState());
        bo.getAEinsAn().setGeburtsland(this.getInsurance(this.mBeginn).getEuStateOfBirthKey());
        if (StringMapper.isNullString((String)bo.getAEinsAn().getGeburtsland())) {
            bo.getAEinsAn().setGeburtsland(this.getInsurance(this.mBeginn).getNationality().getState());
        }
        bo.createAnschrift(1);
        bo.setAnzahlanschrift(1);
        bo.getAEinsAnschrift()[0].setAnschriftsart(1);
        Adresse adresse = new Adresse(this.getInsurance(this.mBeginn).getStreet(), this.getInsurance(this.mBeginn).getStreetNumber(), this.getInsurance(this.mBeginn).getPostalCode(), this.getInsurance(this.mBeginn).getDomicile(), this.getInsurance(this.mBeginn).getAddressaddendum(), this.getMaster(this.mBeginn).getState() != null ? this.getMaster(this.mBeginn).getState().getState() : "000");
        bo.getAEinsAnschrift()[0].setAdresse(adresse);
        Communication com = this.getMaster(this.mBeginn).getPrivateCommunication();
        if (com != null) {
            bo.setTelefonnummer(com.getTelephoneNumber());
            bo.setEmail(com.getEMailAddress());
            bo.setFaxnummer(com.getFaxNumber());
        }
        bo.setStaatentsendung(this.mState.getState());
        bo.setBeginnentsendung(this.mBeginn);
        bo.setEndeentsendung(this.mEnde);
        bo.createAEinsFirma();
        bo.getAEinsFirma().setName(this.getFoundations(this.mBeginn).getShortDescription());
        adresse = new Adresse(this.getFoundations(this.mBeginn).getPostalAddress().getSeparateStreet().trim(), this.getFoundations(this.mBeginn).getPostalAddress().getSeparateNumber().trim(), this.getFoundations(this.mBeginn).getPostalAddress().getPostalCode(), this.getFoundations(this.mBeginn).getPostalAddress().getCity(), "", "000");
        bo.getAEinsFirma().setAdresse(adresse);
        bo.createKontaktSW(1);
        Kommunikation kom = new Kommunikation(this.getCommunication(this.mBeginn).getPhone(), this.getCommunication(this.mBeginn).getFax(), this.getCommunication(this.mBeginn).getEMail());
        bo.getAEinsKontaktSW()[0].setKommunikation(kom);
        if (this.getFoundations(this.mBeginn).getTypeOfEmployer().equals(TypeOfEmployerEnum.TOEE_0_privater_Arbeitgeber)) {
            if (this.getFoundations(this.mBeginn).getLegalForm().equals(LegalFormEnum.LFE_36_SONSTIGE)) {
                bo.getAEinsFirma().setRechtsform(3);
            } else {
                bo.getAEinsFirma().setRechtsform(1);
            }
        } else {
            bo.getAEinsFirma().setRechtsform(2);
        }
        bo.getAEinsFirma().setBetriebsnummervu(this.getBetriebsnummervu());
        CompanyContact contact = null;
        for (CompanyContact each : this.mPCompany.getCompanyContact()) {
            if (!each.getTypeOfContact().equals(TypeOfContactEnum.TOCE_A1)) continue;
            contact = each;
            break;
        }
        if (contact != null) {
            kom = bo.getAEinsFirma().getKommunikation();
            if (!StringMapper.isNullString((String)contact.getAssignmentContact().getEMail())) {
                kom.setEmail(contact.getAssignmentContact().getEMail());
            }
            if (!StringMapper.isNullString((String)contact.getAssignmentContact().getFax())) {
                kom.setFaxnummer(contact.getAssignmentContact().getFax());
            }
            if (!StringMapper.isNullString((String)contact.getAssignmentContact().getPhone())) {
                kom.setTelefonnummer(contact.getAssignmentContact().getPhone());
            }
        }
        if (!StringMapper.isNullString((String)(appVu = this.getAppurtenantBetriebsnummervu())) && !appVu.equals(bo.getAEinsFirma().getBetriebsnummervu())) {
            Plant plant = this.mEmployee.getAppurtenantPlant(VDate.getDateMax(), this.mBeginn);
            bo.getAEinsFirma().setName(this.getFoundationsPlant(plant, this.mBeginn).getShortDescription());
            adresse = new Adresse(this.getFoundationsPlant(plant, this.mBeginn).getPostalAddress().getSeparateStreet().trim(), this.getFoundationsPlant(plant, this.mBeginn).getPostalAddress().getSeparateNumber().trim(), this.getFoundationsPlant(plant, this.mBeginn).getPostalAddress().getPostalCode(), this.getFoundationsPlant(plant, this.mBeginn).getPostalAddress().getCity(), "", "000");
            bo.getAEinsFirma().setAdresse(adresse);
            kom = new Kommunikation(this.getCommunicationPlant(plant, this.mBeginn).getPhone(), this.getCommunicationPlant(plant, this.mBeginn).getFax(), this.getCommunicationPlant(plant, this.mBeginn).getEMail());
            bo.getAEinsKontaktSW()[0].setKommunikation(kom);
            if (this.getFoundationsPlant(plant, this.mBeginn).getTypeOfEmployer().equals(TypeOfEmployerEnum.TOEE_0_privater_Arbeitgeber)) {
                if (this.getFoundationsPlant(plant, this.mBeginn).getLegalForm().equals(LegalFormEnum.LFE_36_SONSTIGE)) {
                    bo.getAEinsFirma().setRechtsform(3);
                } else {
                    bo.getAEinsFirma().setRechtsform(1);
                }
            } else {
                bo.getAEinsFirma().setRechtsform(2);
            }
            bo.getAEinsFirma().setBetriebsnummervu(this.getAppurtenantBetriebsnummervu());
            PlantContact contactPlant = null;
            for (PlantContact each : plant.getPlantContact()) {
                if (!each.getTypeOfContact().equals(TypeOfContactEnum.TOCE_A1)) continue;
                contactPlant = each;
                break;
            }
            if (contactPlant != null) {
                kom = bo.getAEinsFirma().getKommunikation();
                if (!StringMapper.isNullString((String)contactPlant.getAssignmentContact().getEMail())) {
                    kom.setEmail(contactPlant.getAssignmentContact().getEMail());
                }
                if (!StringMapper.isNullString((String)contactPlant.getAssignmentContact().getFax())) {
                    kom.setFaxnummer(contactPlant.getAssignmentContact().getFax());
                }
                if (!StringMapper.isNullString((String)contactPlant.getAssignmentContact().getPhone())) {
                    kom.setTelefonnummer(contactPlant.getAssignmentContact().getPhone());
                }
            }
        }
        HealthFundTP kvtp = this.getHealthFundTP();
        if (this.mAbwKrankenkasse != null) {
            kvtp = this.mAbwKrankenkasse.getHealthFundTP(VDate.getDateMax(), this.mBeginn);
        }
        Insurance ins = this.getInsurance(this.mBeginn);
        if (kvtp != null) {
            if (ins.getPrivateHI()) {
                bo.setArtsv(1);
                bo.setBetriebsnummerkkpkv(kvtp.getStandardCompanyNumber());
            } else {
                bo.setArtsv(0);
                bo.setBetriebsnummerkkgkv(kvtp.getStandardCompanyNumber());
            }
        }
        if (this.isMemberProfGroup()) {
            bo.setMitgliedsnummerversorgungswerk(ins.getPpMembershipNumber());
            bo.setNameversorgungswerk(StringMapper.maxLength((String)ins.getRecipient().getRecipientTP(VDate.getDateMax(), this.mBeginn).getLongDescription(), (int)50));
        }
        bo.setAngabeneinverstanden("J");
        bo.setTaetigkeitauchdeutsch("J");
        return bo;
    }

    private String getBetriebsnummervu() throws BusinessDomainException {
        return this.mPCompany.getCompanyEmploymentOffice(VDate.getDateMax(), this.mBeginn).getGeneralEmploymentOffice().getEmployerNumber();
    }

    private String getAppurtenantBetriebsnummervu() throws BusinessDomainException {
        return this.mEmployee.getAppurtenantEmploymentOffice(VDate.getDateMax(), this.mBeginn).getEmployerNumber();
    }

    private RecipientTP getRecipientDASBV() throws BusinessDomainException {
        Recipient bo = this.getInsurance(this.mBeginn).getRecipient();
        if (bo != null) {
            return bo.getRecipientTP(VDate.getDateMax(), this.mBeginn);
        }
        return null;
    }

    private HealthFundTP getHealthFundTP() throws BusinessDomainException {
        HealthFund bo = this.getInsurance(this.mBeginn).getHealthFund();
        if (bo != null) {
            return bo.getHealthFundTP(VDate.getDateMax(), this.mBeginn);
        }
        return null;
    }

    private String getRecipient() throws BusinessDomainException {
        if (this.mReasonOfDelivery == 2 || this.mReasonOfDelivery == 6) {
            return DVKA;
        }
        int pgs = this.getInsurance(this.mBeginn).getPersonGroup();
        if (this.mReasonOfDelivery == 5 && pgs >= 900) {
            return DRV;
        }
        if (this.mAbwKrankenkasse != null) {
            return this.getHealthFundStdCompNo(this.mAbwKrankenkasse, this.mBeginn);
        }
        if (this.isHealthFund()) {
            return this.getHealthFundStdCompNo(this.mEmployee, this.mBeginn);
        }
        if (this.isPension()) {
            if (this.isMemberProfGroup()) {
                return DASBV;
            }
            return DRV;
        }
        throw AEinsExceptionMapper.makeNoHealtFundAndPensionException();
    }

    private boolean isMemberProfGroup() throws BusinessDomainException {
        return this.getInsurance().getRecipient() != null;
    }

    private boolean isPension() throws BusinessDomainException {
        return this.getInsurance().getDuesGroupPI() >= 1 || !this.specialPGSForHi(this.getInsurance()) || this.isMemberProfGroup();
    }

    private boolean isHealthFund() throws BusinessDomainException {
        return !this.getInsurance().getPrivateHI() && !this.specialPGSForHi(this.getInsurance());
    }

    private boolean specialPGSForHi(Insurance insurance) {
        int pgs = insurance.getPersonGroup();
        return (pgs == 109 || pgs == 110 || pgs == 106 || pgs == 190) && insurance.getDuesGroupHI() == 0;
    }

    private Insurance getInsurance() throws BusinessDomainException {
        return this.mEmployee.getInsurance(VDate.getDateMax(), this.mBeginn);
    }

    private String getHealthFundStdCompNo(Employee emp, Date validTimePoint) throws BusinessDomainException {
        Insurance ins = emp.getInsurance(VDate.getDateMax(), validTimePoint);
        HealthFund hf = ins.getHealthFund();
        return this.getHealthFundStdCompNo(hf, validTimePoint);
    }

    private String getHealthFundStdCompNo(HealthFund healthFund, Date validTimePoint) throws BusinessDomainException {
        HealthFund hf = HealthFund.getHealthFundConsiderFusions((HealthFund)healthFund, (Date)validTimePoint);
        return hf.getHealthFundTP(VDate.getDateMax(), validTimePoint).getStandardCompanyNumber();
    }

    public void deleteAccount(AEinsAccount account) throws BusinessDomainException {
        if (account.getAdviceState().equals((Object)AEinsAdviceStateEnum.AUFGEBAUT) || account.getAdviceState().equals((Object)AEinsAdviceStateEnum.BEREIT)) {
            account.makeSaveable();
            account.destroy();
        } else if (account.getAdviceState().equals((Object)AEinsAdviceStateEnum.VERARBEITET) || account.getAdviceState().equals((Object)AEinsAdviceStateEnum.BEWILLIGT)) {
            this.makeCancellation(account);
        } else {
            throw AEinsExceptionMapper.makeNoDeleteOrCancellationAllowedDomainException(account.getAktenzeichenVU() + " " + account.getValidFrom());
        }
    }

    public AEinsAccount makeCancellation(AEinsAccount account) throws BusinessDomainException {
        DEUVRecipient deuvRecipient;
        this.mReasonOfDelivery = account.getReason().ordinal() + 1;
        this.mEmployee = account.getEmployee();
        AEinsAccount storno = account.makeCancelation();
        storno.makeSaveable();
        storno.setCreatedOn(this.mCreatedOnString);
        switch (this.mReasonOfDelivery) {
            case 1: {
                storno.getDxa1().setVersionsnummer("010500");
                storno.getDxa1().setDatumerstellung(this.getCreatedOnString());
                storno.getDxa1().setDatensatzid(null);
                storno.getDxa1().setAbsendernummer(DeuvHelper.getDeuvSenderStdCompNo((PCompany)this.mPCompany));
                storno.getDxa1().setProdid(DeuvBasics.getProdId());
                storno.getDxa1().setModid(DeuvBasics.getModId());
                storno.getDxa1().getAEinsAn().setVersicherungsnummer(this.getInsurance(VDate.getDateMax()).getInsuranceNo());
                if (StringMapper.isNullString((String)storno.getDxa1().getAEinsAn().getGeburtsland())) {
                    storno.getDxa1().getAEinsAn().setGeburtsland("999");
                }
                deuvRecipient = this.mRecipientMap.updateDeuvRecipient(account.getDEUVRecipient(), account.getDxa1().getEmpfaengernummer());
                break;
            }
            case 2: {
                storno.getDxav().setVersionsnummer("010400");
                if (StringMapper.isNullString((String)storno.getDxav().getBetriebsnummer())) {
                    storno.getDxav().setBetriebsnummer("99999998");
                }
                storno.getDxav().setDatumerstellung(this.getCreatedOnString());
                storno.getDxav().setDatensatzid(null);
                storno.getDxav().setAbsendernummer(DeuvHelper.getDeuvSenderStdCompNo((PCompany)this.mPCompany));
                storno.getDxav().setProdid(DeuvBasics.getProdId());
                storno.getDxav().setModid(DeuvBasics.getModId());
                storno.getDxav().getAEinsAn().setVersicherungsnummer(this.getInsurance(VDate.getDateMax()).getInsuranceNo());
                if (StringMapper.isNullString((String)storno.getDxav().getAEinsAn().getGeburtsland())) {
                    storno.getDxav().getAEinsAn().setGeburtsland("999");
                }
                deuvRecipient = this.mRecipientMap.updateDeuvRecipient(account.getDEUVRecipient(), account.getDxav().getEmpfaengernummer());
                break;
            }
            case 5: {
                storno.getDxao().setVersionsnummer("010000");
                storno.getDxao().setDatumerstellung(this.getCreatedOnString());
                storno.getDxao().setDatensatzid(null);
                storno.getDxao().setAbsendernummer(DeuvHelper.getDeuvSenderStdCompNo((PCompany)this.mPCompany));
                storno.getDxao().setProdid(DeuvBasics.getProdId());
                storno.getDxao().setModid(DeuvBasics.getModId());
                storno.getDxao().getAEinsAn().setVersicherungsnummer(this.getInsurance(VDate.getDateMax()).getInsuranceNo());
                if (StringMapper.isNullString((String)storno.getDxao().getAEinsAn().getGeburtsland())) {
                    storno.getDxao().getAEinsAn().setGeburtsland("999");
                }
                deuvRecipient = this.mRecipientMap.updateDeuvRecipient(account.getDEUVRecipient(), account.getDxao().getEmpfaengernummer());
                break;
            }
            case 6: {
                storno.getDxag().setVersionsnummer("010100");
                storno.getDxag().setDatumerstellung(this.getCreatedOnString());
                storno.getDxag().setDatensatzid(null);
                storno.getDxag().setAbsendernummer(DeuvHelper.getDeuvSenderStdCompNo((PCompany)this.mPCompany));
                storno.getDxag().setProdid(DeuvBasics.getProdId());
                storno.getDxag().setModid(DeuvBasics.getModId());
                storno.getDxag().getAEinsAn().setVersicherungsnummer(this.getInsurance(VDate.getDateMax()).getInsuranceNo());
                if (StringMapper.isNullString((String)storno.getDxag().getAEinsAn().getGeburtsland())) {
                    storno.getDxag().getAEinsAn().setGeburtsland("999");
                }
                deuvRecipient = this.mRecipientMap.updateDeuvRecipient(account.getDEUVRecipient(), account.getDxag().getEmpfaengernummer());
                break;
            }
            default: {
                throw new IllegalArgumentException("The reason of delivery " + this.mReasonOfDelivery + " is not supported.");
            }
        }
        storno.setDEUVRecipient(deuvRecipient);
        storno.setAdviceState(AEinsAdviceStateEnum.AUFGEBAUT);
        storno.setErrorMessage("");
        this.check(storno);
        if (!storno.hasErrors()) {
            storno.setAdviceState(AEinsAdviceStateEnum.BEREIT);
        }
        return storno;
    }

    public AEinsAccount createAccount(AEinsDxav dxav) throws BusinessDomainException {
        AEinsAccount account = this.createAEinsAccount(dxav.getBeginnantrag(), dxav.getEmpfaengernummer());
        account.setValidFrom(dxav.getBeginnantrag());
        account.setValidUntil(dxav.getEndeantrag());
        account.setReason(ReasonEnum.DXAV);
        return account;
    }

    public AEinsAccount createAccount(AEinsDxa1 dxa1) throws BusinessDomainException {
        AEinsAccount account = this.createAEinsAccount(dxa1.getBeginnentsendung(), dxa1.getEmpfaengernummer());
        account.setValidFrom(dxa1.getBeginnentsendung());
        account.setValidUntil(dxa1.getEndeentsendung());
        account.setReason(ReasonEnum.DXA1);
        return account;
    }

    public AEinsAccount createAccount(AEinsDxao dxao) throws BusinessDomainException {
        AEinsAccount account = this.createAEinsAccount(dxao.getBeginnentsendung(), dxao.getEmpfaengernummer());
        account.setValidFrom(dxao.getBeginnentsendung());
        account.setValidUntil(dxao.getEndeentsendung());
        account.setReason(ReasonEnum.DXAO);
        return account;
    }

    public AEinsAccount createAccount(AEinsDxag dxag) throws BusinessDomainException {
        AEinsAccount account = this.createAEinsAccount(dxag.getBeginnentsendung(), dxag.getEmpfaengernummer());
        account.setValidFrom(dxag.getBeginnentsendung());
        account.setValidUntil(dxag.getEndeentsendung());
        account.setReason(ReasonEnum.DXAG);
        return account;
    }

    private AEinsAccount createAEinsAccount(Date dueDate, String bbnr) throws BusinessDomainException {
        AEinsAccount account = new AEinsAccount(this.mEmployee);
        account.setPCompany(this.mPCompany);
        account.setCreatedOn(this.getCreatedOnString());
        account.setCanceled("N");
        account.setErrorMessage("");
        account.setAktenzeichenVU(this.getAzvu());
        account.setAdviceState(AEinsAdviceStateEnum.AUFGEBAUT);
        account.setDEUVRecipient(this.getDEUVRecipient(account, dueDate, bbnr));
        return account;
    }

    public String getCreatedOnString() {
        return this.mCreatedOnString;
    }

    private String getAzvu() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.mPCompany.getPCompanyKey());
        sb.append(" / ");
        sb.append(this.mEmployee.getPersonnelnumber());
        return sb.toString();
    }

    public Master getMaster(Date validTimePoint) throws BusinessDomainException {
        Master master = (Master)this.mEmployee.getMasterHistory().getItemOrNull(VDate.getDateMax(), validTimePoint);
        if (master == null) {
            throw AEinsExceptionMapper.makeMissingDateOfMasterDomainException(validTimePoint);
        }
        return master;
    }

    public Employment getEmployment(Date validTimePoint) throws BusinessDomainException {
        Employment employment = (Employment)this.mEmployee.getEmploymentHistory().getItemOrNull(VDate.getDateMax(), validTimePoint);
        if (employment == null) {
            throw AEinsExceptionMapper.makeMissingDateOfEmploymentDomainException(validTimePoint);
        }
        return employment;
    }

    public Insurance getInsurance(Date validTimePoint) throws BusinessDomainException {
        Insurance insurance = (Insurance)this.mEmployee.getInsuranceHistory().getItemOrNull(VDate.getDateMax(), validTimePoint);
        if (insurance == null) {
            throw AEinsExceptionMapper.makeMissingDateOfInsuranceDomainException(validTimePoint);
        }
        return insurance;
    }

    private Foundations getFoundations(Date validTimePoint) throws BusinessDomainException {
        return this.mPCompany.getCompanyFoundations(VDate.getDateMax(), validTimePoint).getFoundations();
    }

    private Foundations getFoundationsPlant(Plant plant, Date validTimePoint) throws BusinessDomainException {
        return plant.getPlantFoundations(VDate.getDateMax(), validTimePoint).getFoundations();
    }

    private CompanyPlantCommunication getCommunication(Date validTimePoint) throws BusinessDomainException {
        CompanyPlantCommunication cpc = this.getFoundations(validTimePoint).getCommunication();
        if (cpc == null) {
            cpc = new CompanyPlantCommunication("", "", "", "", "");
        }
        return cpc;
    }

    private CompanyPlantCommunication getCommunicationPlant(Plant plant, Date validTimePoint) throws BusinessDomainException {
        CompanyPlantCommunication cpc = this.getFoundationsPlant(plant, validTimePoint).getCommunication();
        if (cpc == null) {
            cpc = new CompanyPlantCommunication("", "", "", "", "");
        }
        return cpc;
    }

    public boolean isAffectedBySpecialAccess() {
        return this.mAffectedBySpecialAccess;
    }

    public void setAffectedBySpecialAccess(boolean affectedBySpecialAccess) {
        this.mAffectedBySpecialAccess = affectedBySpecialAccess;
    }

    public List<AEinsAccount> getUntransmitteds(SpecialAccess specialAccess, ReasonEnum reason) throws BusinessDomainException {
        Conjunction filter = Restrictions.conjunction();
        filter.add(Restrictions.eq((String)"oidpcompany", (String)this.mPCompany.getObjectid()));
        filter.add(Restrictions.eq((String)"advicestate", (String)("" + AEinsAdviceStateEnum.toInt((AEinsAdviceStateEnum)AEinsAdviceStateEnum.BEREIT))));
        filter.add(Restrictions.eq((String)"reason", (String)("" + ReasonEnum.toInt((ReasonEnum)reason))));
        AEinsAccount[] untransmitteds = AEinsAdvice.getIAEinsAccountPM().query(null, (Criterion)filter);
        AEinsAccount[] filtered = (AEinsAccount[])specialAccess.filter((IEmployeeReferenced[])untransmitteds);
        if (untransmitteds.length != filtered.length) {
            this.setAffectedBySpecialAccess(true);
        }
        ArrayList<AEinsAccount> untransmittedsList = new ArrayList<AEinsAccount>();
        for (AEinsAccount account : filtered) {
            if (account.hasErrors() || account.getCanceled().equals("X")) continue;
            untransmittedsList.add(account);
        }
        Collections.sort(untransmittedsList, this.getAEinsAccountComparator());
        return untransmittedsList;
    }

    protected Comparator<AEinsAccount> getAEinsAccountComparator() {
        return new AEinsAccountComparator();
    }

    private static IAEinsAccountPersistencyManager getIAEinsAccountPM() {
        return (IAEinsAccountPersistencyManager)UtilitiesManager.getBean((String)"aEinsAccountPersistencyManager", IAEinsAccountPersistencyManager.class);
    }

    public DEUVRecipient getDEUVRecipient(AEinsAccount account, Date dueDate, String bbnr) throws BusinessDomainException {
        if (bbnr.equals(DVKA)) {
            return DeuvRecipientMap.getRecipientByTypeOfHealthFund((TypeOfHealthFundEnum)TypeOfHealthFundEnum.TOHF_DVKA, (DEUVSender)DeuvHelper.getDeuvSender((PCompany)this.mPCompany));
        }
        if (bbnr.equals(DRV)) {
            return DeuvRecipientMap.getRecipientByTypeOfHealthFund((TypeOfHealthFundEnum)TypeOfHealthFundEnum.TOHF_RENTENVERSICHERUNG, (DEUVSender)DeuvHelper.getDeuvSender((PCompany)this.mPCompany));
        }
        if (this.isVersorgungsEinrichtung(bbnr, dueDate)) {
            return DeuvRecipientMap.getRecipientByTypeOfHealthFund((TypeOfHealthFundEnum)TypeOfHealthFundEnum.TOHF_VERSORGUNG, (DEUVSender)DeuvHelper.getDeuvSender((PCompany)this.mPCompany));
        }
        if (this.mAbwKrankenkasse != null) {
            return this.mRecipientMap.getDeuvRecipient(this.mAbwKrankenkasse);
        }
        if (!StringMapper.isNullString((String)bbnr)) {
            return this.mRecipientMap.getDeuvRecipient(HealthFund.getByStdCompanyNo((String)bbnr));
        }
        return this.mRecipientMap.getDeuvRecipient(account.getHealthFund(dueDate));
    }

    private boolean isVersorgungsEinrichtung(String bbnr, Date dueDate) throws BusinessDomainException {
        Recipient[] recipients;
        for (Recipient each : recipients = RecipientPersistencyManager.query(null, null)) {
            RecipientTP tp = each.getRecipientTP(VDate.getDateMax(), dueDate);
            if (tp.getTypeOfRecipientEnum() != TypeOfRecipientEnum.TORE_Versorgungseinrichtung || !StringMapper.equal((String)bbnr, (String)tp.getStandardCompanyNumber())) continue;
            return true;
        }
        return false;
    }

    public Date getCreatedOnDate() {
        return this.mCreatedOnDate;
    }

    public String getPCompanyName(Date validTimePoint) throws BusinessDomainException {
        return this.getFoundations(validTimePoint).getShortDescription();
    }

    public String getCompanyDescription(Date validTimePoint) throws BusinessDomainException {
        return this.getFoundations(validTimePoint).getShortDescription();
    }

    public AEinsKontaktSW getContactPreset(int artanschriftwechsel, Date validTimePoint) throws BusinessDomainException {
        this.mBeginn = validTimePoint;
        if (artanschriftwechsel == 1) {
            return this.getContactAG(validTimePoint);
        }
        return null;
    }

    private AEinsKontaktSW getContactAG(Date validTimePoint) throws BusinessDomainException {
        AEinsKontaktSW bo = new AEinsKontaktSW();
        Foundations foundation = this.getFoundations(validTimePoint);
        Adresse adresse = null;
        Kommunikation kom = null;
        Plant plant = null;
        bo.setKontaktswart(1);
        bo.setAnzahlap(1);
        adresse = new Adresse(foundation.getPostalAddress().getSeparateStreet().trim(), foundation.getPostalAddress().getSeparateNumber().trim(), foundation.getPostalAddress().getPostalCode(), foundation.getPostalAddress().getCity(), "", "000");
        bo.setAdresse(adresse);
        kom = new Kommunikation(this.getCommunication(validTimePoint).getPhone(), this.getCommunication(validTimePoint).getFax(), this.getCommunication(validTimePoint).getEMail());
        bo.setKommunikation(kom);
        bo.setPerson(new Person());
        String appVu = this.getAppurtenantBetriebsnummervu();
        if (!StringMapper.isNullString((String)appVu) && !appVu.equals(this.getBetriebsnummervu())) {
            plant = this.mEmployee.getAppurtenantPlant(VDate.getDateMax(), validTimePoint);
            foundation = this.getFoundationsPlant(plant, validTimePoint);
            adresse = new Adresse(foundation.getPostalAddress().getSeparateStreet().trim(), foundation.getPostalAddress().getSeparateNumber().trim(), foundation.getPostalAddress().getPostalCode(), foundation.getPostalAddress().getCity(), "", "000");
            bo.setAdresse(adresse);
            kom = bo.getKommunikation();
            kom.setTelefonnummer(this.getCommunicationPlant(plant, validTimePoint).getPhone());
            kom.setFaxnummer(this.getCommunicationPlant(plant, validTimePoint).getFax());
            kom.setEmail(this.getCommunicationPlant(plant, validTimePoint).getEMail());
        }
        CompanyContact contact = null;
        for (CompanyContact each : this.mPCompany.getCompanyContact()) {
            if (!each.getTypeOfContact().equals(TypeOfContactEnum.TOCE_A1)) continue;
            contact = each;
            break;
        }
        if (contact != null) {
            String[] split;
            if (!StringMapper.isNullString((String)contact.getAssignmentContact().getEMail())) {
                kom.setEmail(contact.getAssignmentContact().getEMail());
            }
            if (!StringMapper.isNullString((String)contact.getAssignmentContact().getFax())) {
                kom.setFaxnummer(contact.getAssignmentContact().getFax());
            }
            if (!StringMapper.isNullString((String)contact.getAssignmentContact().getPhone())) {
                kom.setTelefonnummer(contact.getAssignmentContact().getPhone());
            }
            if (contact.getContactFormOfAddress().equals(FormOfAddressEnum.FOAE_Herr)) {
                bo.getPerson().setGeschlecht("M");
            } else if (contact.getContactFormOfAddress().equals(FormOfAddressEnum.FOAE_Frau)) {
                bo.getPerson().setGeschlecht("W");
            }
            if (contact.getAssignmentContact().getContactPerson() != null && (split = contact.getAssignmentContact().getContactPerson().split(" ")) != null && split.length > 0) {
                bo.getPerson().setVorname(split[0]);
                if (split.length > 1) {
                    bo.getPerson().setName(contact.getAssignmentContact().getContactPerson().substring(split[0].length() + 1));
                }
            }
        }
        if (plant != null) {
            PlantContact contactPlant = null;
            for (PlantContact each : plant.getPlantContact()) {
                if (!each.getTypeOfContact().equals(TypeOfContactEnum.TOCE_A1)) continue;
                contactPlant = each;
                break;
            }
            if (contactPlant != null) {
                String[] split;
                if (!StringMapper.isNullString((String)contactPlant.getAssignmentContact().getEMail())) {
                    kom.setEmail(contactPlant.getAssignmentContact().getEMail());
                }
                if (!StringMapper.isNullString((String)contactPlant.getAssignmentContact().getFax())) {
                    kom.setFaxnummer(contactPlant.getAssignmentContact().getFax());
                }
                if (!StringMapper.isNullString((String)contactPlant.getAssignmentContact().getPhone())) {
                    kom.setTelefonnummer(contactPlant.getAssignmentContact().getPhone());
                }
                if (contactPlant.getContactFormOfAddress().equals(FormOfAddressEnum.FOAE_Herr)) {
                    bo.getPerson().setGeschlecht("M");
                } else if (contactPlant.getContactFormOfAddress().equals(FormOfAddressEnum.FOAE_Frau)) {
                    bo.getPerson().setGeschlecht("W");
                }
                if (contactPlant.getAssignmentContact().getContactPerson() != null && (split = contactPlant.getAssignmentContact().getContactPerson().split(" ")) != null && split.length > 0) {
                    bo.getPerson().setVorname(split[0]);
                    if (split.length > 1) {
                        bo.getPerson().setName(contactPlant.getAssignmentContact().getContactPerson().substring(split[0].length() + 1));
                    }
                }
            }
        }
        return bo;
    }
}

