/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.aag;

import com.varial.base.UtilitiesManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.criterion.Conjunction;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Order;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.aag.AagAbsentTime;
import com.varial.personnel.domain.aag.AagAdvice;
import com.varial.personnel.domain.calculation.CalculationCase;
import com.varial.personnel.domain.calculation.ICalculationCaseFactory;
import com.varial.personnel.domain.deuv.IDbnaData;
import com.varial.personnel.domain.deuv.deuvaccount.PersonalCurrentData;
import com.varial.personnel.domain.deuv.deuvaccount.adviceable.Validityable;
import com.varial.personnel.domain.deuv.deuvaccount.adviceable.ValueInterval;
import com.varial.personnel.domain.deuv.deuvaccount.mapper.DEUVAccountExceptionMapper;
import com.varial.personnel.domain.employee.Employee;
import com.varial.personnel.domain.employee.absenttime.EEAbsentTimeTP;
import com.varial.personnel.domain.employee.absenttime.EEAbsentTimeTPPersistencyManager;
import com.varial.personnel.domain.employee.carriedforward.system.sibreak.EECarriedForwardSystemSIBreak;
import com.varial.personnel.domain.employee.employment.Employment;
import com.varial.personnel.domain.employee.insurance.AssessmentDutyEnum;
import com.varial.personnel.domain.employee.insurance.Insurance;
import com.varial.personnel.domain.employee.insurance.SpecialCategoryEnum;
import com.varial.personnel.domain.employee.valueposition.ValuePosition;
import com.varial.personnel.domain.evaluation.library.CalculationLibrary;
import com.varial.personnel.domain.evaluation.library.EmployeeLibrary;
import com.varial.personnel.domain.evaluation.library.ValuePositionLibrary;
import com.varial.personnel.domain.evaluation.libraryimpl.CalculationLibraryImpl;
import com.varial.personnel.domain.evaluation.libraryimpl.EmployeeLibraryImpl;
import com.varial.personnel.domain.evaluation.libraryimpl.GlobalLibraryImpl;
import com.varial.personnel.domain.evaluation.libraryimpl.MultipleUsedMethodsImpl;
import com.varial.personnel.domain.evaluation.libraryimpl.ValuePositionLibraryImpl;
import com.varial.personnel.domain.global.fstateregion.FStateRegion;
import com.varial.personnel.domain.global.fstateregion.calendar.FStateRegionCalendarTP;
import com.varial.personnel.domain.global.fstateregion.calendar.FStateRegionCalendarTPPersistencyManager;
import com.varial.personnel.domain.global.healthfund.HealthFund;
import com.varial.personnel.domain.global.healthfund.TypeOfHealthFundEnum;
import com.varial.personnel.domain.plant.Plant;
import com.varial.personnel.domain.typeofvalue.ValueType;
import com.varial.personnel.domain.workingtime.WorkingTime;
import com.varial.personnel.domain.workingtime.WorkingTimeTP;
import com.varial.personnel.framework.basictypes.PDateHelper;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.BooleanMapper;
import com.varial.serverbase.mapper.DateMapper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AagEmployee {
    private final Employee mEmployee;
    private final AagAdvice mAdvice;
    private PersonalCurrentData mCurrentData;
    private final Map<ValueType, ValueInterval> mValueIntervals = new HashMap<ValueType, ValueInterval>();

    public AagEmployee(Employee employee, AagAdvice advice) throws BusinessDomainException {
        this.mEmployee = employee;
        this.mAdvice = advice;
    }

    private Date getEffectiveTimePoint() {
        return this.getJournalizedUntil();
    }

    public Date getJournalizedUntil() {
        Date journalized = this.mEmployee.getJournalizedUntil();
        if (this.mAdvice.isPreview()) {
            journalized = PDateHelper.getLastDayNextMonth((Date)journalized);
        }
        return journalized;
    }

    public PersonalCurrentData getPersonalData() throws BusinessDomainException {
        if (this.mCurrentData == null) {
            this.mCurrentData = new PersonalCurrentData(this.mEmployee, this.getPersonalCurrentDate());
        }
        return this.mCurrentData;
    }

    private Date getPersonalCurrentDate() {
        return DateHelper.max((Date)this.getJournalizedUntil(), (Date)this.mAdvice.getCreatedOnDate());
    }

    public List<AagAbsentTime> getRelevantAbsentTimes() throws BusinessDomainException {
        ArrayList<AagAbsentTime> result = new ArrayList<AagAbsentTime>();
        for (EEAbsentTimeTP each : this.getAbsentTimes()) {
            AagAbsentTime absentTime = new AagAbsentTime(each);
            if (absentTime.getType() == AagAbsentTime.AagType.AAG_SONSTIGE) continue;
            result.add(absentTime);
        }
        Collections.sort(result, new AagAbsentTimeCalculationComparator());
        return result;
    }

    private List<EEAbsentTimeTP> getAbsentTimes() throws BusinessDomainException {
        Order[] sorts = new Order[]{Order.asc((String)"VALIDFROM")};
        Criterion filter = this.getTPFilter(this.mAdvice.getAagStartDate(), this.getJournalizedUntil(), Restrictions.eq((String)"DELETED", (String)BooleanMapper.toString((boolean)false)));
        EEAbsentTimeTP[] absentTimeTPs = EEAbsentTimeTPPersistencyManager.queryAll((Order[])sorts, (Criterion)filter, (boolean)true);
        return Arrays.asList(absentTimeTPs);
    }

    public EECarriedForwardSystemSIBreak getCFAbsentTime(AagAbsentTime absentTime) {
        EECarriedForwardSystemSIBreak result = null;
        for (EECarriedForwardSystemSIBreak each : this.getEmployee().getEECarriedForwardSystemSIBreak()) {
            if (!DateHelper.equal((Date)each.getValidUntil(), (Date)DateHelper.yesterday((Date)absentTime.getFrom())) || !each.getAbsentTime().getDEUVAbsentTimeKey().equals(absentTime.getDeuvKey())) continue;
            result = each;
            break;
        }
        return result;
    }

    private Criterion getTPFilter(Date validFrom, Date validUntil, Criterion ... additionals) {
        String effectiveTp = DateMapper.toString((Date)this.getEffectiveTimePoint());
        Conjunction filter = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"OIDEMPLOYEE", (String)this.mEmployee.getObjectid()), Restrictions.le((String)"EFFECTIVEFROM", (String)effectiveTp), Restrictions.ge((String)"EFFECTIVEUNTIL", (String)effectiveTp), Restrictions.le((String)"VALIDFROM", (String)DateMapper.toString((Date)validUntil)), Restrictions.or((Criterion)Restrictions.ge((String)"VALIDUNTIL", (String)DateMapper.toString((Date)validFrom)), (Criterion)Restrictions.isNull((String)"VALIDUNTIL"))});
        for (Criterion each : additionals) {
            filter.add(each);
        }
        return filter;
    }

    public BigDecimal getAbsentTime(int type, Date from, Date until) throws BusinessDomainException {
        BigDecimal result;
        switch (type) {
            case 1: {
                result = BigDecimal.valueOf(PDateHelper.countAffectedDays((Date)from, (Date)until));
                break;
            }
            case 2: {
                result = this.getWorkDays(from, until);
                break;
            }
            case 3: {
                result = this.getWorkHours(from, until);
                break;
            }
            default: {
                result = BigDecimal.ZERO;
            }
        }
        return result;
    }

    public BigDecimal getWorkDays(Date from, Date until) throws BusinessDomainException {
        return this.getWorkingTime(from).getConcreteTargetDays(from, until, this.getEmployee(), this.getEffectiveTimePoint(), from, true);
    }

    private BigDecimal getWorkHours(Date from, Date until) throws BusinessDomainException {
        return this.getWorkingTime(from).getConcreteTargetHours(from, until, this.mEmployee, this.getEffectiveTimePoint(), from, true);
    }

    public Date getLastWorkingDay(Date day, Date calcStart) throws BusinessDomainException {
        List<EEAbsentTimeTP> absentTimes = this.getAbsentTimes();
        Date entry = DateHelper.max((Date)this.getDateOfEntry(day), (Date)calcStart);
        FStateRegion fstateregion = this.mEmployee.getFStateRegionForCalendar(this.getEffectiveTimePoint(), day);
        Date lastworkingday = null;
        Date checkdate = DateHelper.yesterday((Date)day);
        while (DateHelper.afterOrEqual((Date)checkdate, (Date)entry)) {
            if (!this.isAbsentDay(checkdate, absentTimes) && this.isWorkingDay(checkdate, fstateregion, this.getEffectiveTimePoint())) {
                lastworkingday = checkdate;
                break;
            }
            checkdate = DateHelper.yesterday((Date)checkdate);
        }
        return lastworkingday;
    }

    private boolean isAbsentDay(Date day, List<EEAbsentTimeTP> absentTimes) {
        boolean result = false;
        for (EEAbsentTimeTP absentTimeTP : absentTimes) {
            if (!DateHelper.between((Date)day, (Date)absentTimeTP.getValidFrom(), (Date)absentTimeTP.getValidUntil()) || absentTimeTP.getHalfLeaveDay() || AagAbsentTime.isPartialAbsentTime((EEAbsentTimeTP)absentTimeTP)) continue;
            result = true;
            break;
        }
        return result;
    }

    private boolean isWorkingDay(Date dateToCheck, FStateRegion fstateregion, Date effectiveTimePoint) throws BusinessDomainException {
        WorkingTime workingTime = this.mEmployee.getAssociatedWorkingTime(effectiveTimePoint, dateToCheck);
        WorkingTimeTP wttp = workingTime.getWorkingTimeTP(effectiveTimePoint, dateToCheck);
        boolean dailyWorkingHoursFilled = false;
        BigDecimal[] dailyWorkingHours = new BigDecimal[7];
        if (!(BigDecimalMapper.isZeroOrNull((BigDecimal)wttp.getMondayHours()) && BigDecimalMapper.isZeroOrNull((BigDecimal)wttp.getTuesdayHours()) && BigDecimalMapper.isZeroOrNull((BigDecimal)wttp.getWednesdayHours()) && BigDecimalMapper.isZeroOrNull((BigDecimal)wttp.getThursdayHours()) && BigDecimalMapper.isZeroOrNull((BigDecimal)wttp.getFridayHours()) && BigDecimalMapper.isZeroOrNull((BigDecimal)wttp.getSaturdayHours()) && BigDecimalMapper.isZeroOrNull((BigDecimal)wttp.getSundayHours()))) {
            dailyWorkingHoursFilled = true;
            dailyWorkingHours[0] = wttp.getSundayHours();
            dailyWorkingHours[1] = wttp.getMondayHours();
            dailyWorkingHours[2] = wttp.getTuesdayHours();
            dailyWorkingHours[3] = wttp.getWednesdayHours();
            dailyWorkingHours[4] = wttp.getThursdayHours();
            dailyWorkingHours[5] = wttp.getFridayHours();
            dailyWorkingHours[6] = wttp.getSaturdayHours();
        }
        boolean isWorkingDay = false;
        if (dailyWorkingHoursFilled && !BigDecimalMapper.isZero((BigDecimal)dailyWorkingHours[new VDate(dateToCheck).getDayOfWeek() - 1]) || !dailyWorkingHoursFilled) {
            FStateRegionCalendarTP fSCalendar = this.selectFStateRegionCalendar(fstateregion, dateToCheck, effectiveTimePoint, dateToCheck);
            isWorkingDay = fSCalendar.getWorkingDay();
        }
        return isWorkingDay;
    }

    private FStateRegionCalendarTP selectFStateRegionCalendar(FStateRegion fstateregion, Date day, Date effectiveTimepoint, Date validTimepoint) {
        Conjunction filter = Restrictions.conjunction();
        filter.add(Restrictions.eq((String)"oidfstateregion", (String)fstateregion.getObjectid()));
        filter.add(Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)effectiveTimepoint)));
        filter.add(Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)effectiveTimepoint)));
        filter.add(Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)validTimepoint)));
        filter.add(Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)validTimepoint)));
        filter.add(Restrictions.eq((String)"calendardate", (String)DateMapper.toString((Date)day)));
        FStateRegionCalendarTP[] fstate = FStateRegionCalendarTPPersistencyManager.getFStateRegionCalendar((Order[])new Order[]{Order.asc((String)"calendardate")}, (Criterion)filter);
        return fstate[0];
    }

    private WorkingTime getWorkingTime(Date validTimePoint) throws BusinessDomainException {
        return this.mEmployee.getAssociatedWorkingTime(this.getEffectiveTimePoint(), validTimePoint);
    }

    public Employee getEmployee() {
        return this.mEmployee;
    }

    public Date getDateOfEntry(Date validTimePoint) throws BusinessDomainException {
        return this.getEmployment(validTimePoint).getDateOfEntry();
    }

    public Employment getEmployment(Date validTimePoint) throws BusinessDomainException {
        return this.mEmployee.getEmployment(this.getEffectiveTimePoint(), validTimePoint);
    }

    public Employment getActiveEmployment(Date validTimePoint) throws BusinessDomainException {
        return this.mEmployee.getEmployment(VDate.getDateMax(), validTimePoint);
    }

    public Insurance getInsurance(Date validTimePoint) throws BusinessDomainException {
        return this.mEmployee.getInsurance(this.getEffectiveTimePoint(), validTimePoint);
    }

    public Plant getPlant(Date validTimePoint) throws BusinessDomainException {
        return this.getEmployment(validTimePoint).getPlant();
    }

    public HealthFund getHealthFund(Date validTimePoint) throws BusinessDomainException {
        return this.getInsurance(validTimePoint).getHealthFund();
    }

    public HealthFund getAssessmentHealthFund(Date validTimePoint) throws BusinessDomainException {
        return this.getInsurance(validTimePoint).getAssessmentHealthFund();
    }

    public HealthFund getLegalHealthFund(Date validTimePoint) throws BusinessDomainException {
        return this.getInsurance(validTimePoint).getLegalHealthFund();
    }

    public boolean isBestandsschutz2022(Date validTimePoint) throws BusinessDomainException {
        Insurance insurance = this.getInsurance(validTimePoint);
        return insurance.getPersonGroup() == 109 && insurance.getSpecialCategoryOfPersons() == SpecialCategoryEnum.SCE_GLEITZONENREGELUNG && insurance.getUseTransitionBy31122022();
    }

    public int getArtVersicherung(Date validTimePoint) throws BusinessDomainException {
        if (this.getInsurance(validTimePoint).getPrivateHI() || this.getInsurance(validTimePoint).getRecipientPHI() != null) {
            return 1;
        }
        TypeOfHealthFundEnum type = this.getHealthFund(validTimePoint).getActiveHealthFundTP().getTypeOfHealthFundEnum();
        if (type == TypeOfHealthFundEnum.TOHF_LKK) {
            return 2;
        }
        if (this.getInsurance(validTimePoint).getPersonGroup() == 109) {
            return 3;
        }
        return 0;
    }

    public boolean hasU1Duty(Date validTimePoint) throws BusinessDomainException {
        AssessmentDutyEnum assessmentDuty = this.getInsurance(validTimePoint).getAssessmentDuty();
        return assessmentDuty == AssessmentDutyEnum.ADE_U1 || assessmentDuty == AssessmentDutyEnum.ADE_U1_und_U2;
    }

    public boolean hasU2Duty(Date validTimePoint) throws BusinessDomainException {
        AssessmentDutyEnum assessmentDuty = this.getInsurance(validTimePoint).getAssessmentDuty();
        return assessmentDuty == AssessmentDutyEnum.ADE_U2 || assessmentDuty == AssessmentDutyEnum.ADE_U1_und_U2;
    }

    public String getIDString() throws BusinessDomainException {
        return this.getEmployee().getIDString();
    }

    public void fillDbna(IDbnaData dbna) throws BusinessDomainException {
        this.getPersonalData().fill(dbna);
    }

    private MultipleUsedMethodsImpl getWorkTime(Date validTimePoint) throws BusinessDomainException {
        ValuePosition vPos = new ValuePosition(true);
        vPos.setEmployee(this.getEmployee());
        vPos.setEffectiveFrom(this.getEffectiveTimePoint());
        vPos.setValidFrom(validTimePoint);
        CalculationCase cCase = ((ICalculationCaseFactory)UtilitiesManager.getBean((String)"calculationCaseFactory", ICalculationCaseFactory.class)).createReadOnly(this.getEmployee(), this.getEffectiveTimePoint(), validTimePoint);
        cCase.setEmployee(this.getEmployee());
        cCase.setEffectiveFrom(this.getEffectiveTimePoint());
        cCase.setValidFrom(validTimePoint);
        CalculationLibraryImpl calLibraryImpl = new CalculationLibraryImpl(vPos, cCase);
        EmployeeLibraryImpl eeLibraryImpl = new EmployeeLibraryImpl(vPos, cCase);
        GlobalLibraryImpl glLibraryImpl = new GlobalLibraryImpl(vPos, cCase, eeLibraryImpl);
        ValuePositionLibraryImpl wpLibraryImpl = new ValuePositionLibraryImpl(vPos, cCase, (EmployeeLibrary)eeLibraryImpl);
        MultipleUsedMethodsImpl mumLibraryImpl = new MultipleUsedMethodsImpl((CalculationLibrary)calLibraryImpl, eeLibraryImpl, glLibraryImpl, (ValuePositionLibrary)wpLibraryImpl);
        return mumLibraryImpl;
    }

    public BigDecimal getWeeklyWorkingTime(Date validTimePoint) throws BusinessDomainException {
        return this.getWorkTime(validTimePoint).woechentlicheSollstundenMitarbeiter();
    }

    public BigDecimal getDailyWorkingTime(Date validTimePoint) throws BusinessDomainException {
        return this.getWorkTime(validTimePoint).taeglicheSollstundenMitarbeiter();
    }

    public BigDecimal calculateValue(int valueTypeNumber, Date start, Date end) throws BusinessDomainException {
        return this.calculateValue(valueTypeNumber, start, end, ValueInterval.Field.RESULT);
    }

    public BigDecimal calculateValue(int valueTypeNumber, Date start, Date end, ValueInterval.Field field) throws BusinessDomainException {
        return this.calculateValue(this.getValueInterval(valueTypeNumber), start, end, field);
    }

    public BigDecimal calculateValueWithFallback(int valueTypeNumber, Date start, Date end, ValueInterval.Field field) throws BusinessDomainException {
        BigDecimal fieldValue = this.calculateValue(this.getValueInterval(valueTypeNumber), start, end, field);
        if (BigDecimalMapper.isZero((BigDecimal)fieldValue)) {
            return this.calculateValue(valueTypeNumber, start, end, ValueInterval.Field.RESULT);
        }
        return fieldValue;
    }

    public BigDecimal calculateValue(int valueTypeNumber, Date start, Date end, String absentKey) throws BusinessDomainException {
        return this.calculateValue(valueTypeNumber, start, end, absentKey, ValueInterval.Field.RESULT);
    }

    public BigDecimal calculateValue(int valueTypeNumber, Date start, Date end, String absentKey, ValueInterval.Field field) throws BusinessDomainException {
        ArrayList<ValuePosition> valuePositions = new ArrayList<ValuePosition>();
        for (ValuePosition valuePosition : this.getValueInterval(valueTypeNumber).getValuePositions()) {
            if (!BigDecimalMapper.isZeroOrNull((BigDecimal)valuePosition.getPersistentBuffer1()) && !valuePosition.getPersistentBuffer1().toString().startsWith(absentKey)) continue;
            valuePositions.add(valuePosition);
        }
        ValueInterval vi = new ValueInterval((Validityable[])valuePositions.toArray(new ValuePosition[valuePositions.size()]));
        return this.calculateValue(vi, start, end, field);
    }

    private BigDecimal calculateValue(ValueInterval vi, Date start, Date end, ValueInterval.Field field) {
        Date firstOfMonth = DateHelper.getFirstDayOfMonth((Date)start);
        Date lastOfMonth = DateHelper.getLastDayOfMonth((Date)end);
        BigDecimal result = vi.calculate(field, firstOfMonth, lastOfMonth);
        return result.setScale(2, RoundingMode.HALF_UP);
    }

    public ValueInterval getValueInterval(int vtnumber) throws BusinessDomainException {
        ValueType vt = this.getValueType(vtnumber);
        if (!this.mValueIntervals.containsKey(vt)) {
            Criterion filter = ValueInterval.createValuePositionFilter((Employee)this.getEmployee(), (Date)this.getEffectiveTimePoint(), (ValueType)vt);
            ValueInterval vi = new ValueInterval(filter);
            this.mValueIntervals.put(vt, vi);
        }
        return this.mValueIntervals.get(vt);
    }

    private ValueType getValueType(int number) throws BusinessDomainException {
        ValueType vt = ValueType.getValueType((int)number);
        if (vt == null) {
            throw DEUVAccountExceptionMapper.makeMissValueTypeDomainException((int)number);
        }
        return vt;
    }

    public boolean isNewCalculated(int valueTypeNumber, Date start, Date end) throws BusinessDomainException {
        boolean result = true;
        for (ValuePosition valuePosition : this.getValueInterval(valueTypeNumber).getValuePositions()) {
            if (!PDateHelper.isIntersection((Date)start, (Date)end, (Date)valuePosition.getValidFrom(), (Date)valuePosition.getValidUntil())) continue;
            result = !BigDecimalMapper.isZeroOrNull((BigDecimal)valuePosition.getPersistentBuffer1());
            break;
        }
        return result;
    }

    public String toString() {
        return this.getClass().getSimpleName() + this.getEmployee();
    }

    private class AagAbsentTimeCalculationComparator
    implements Comparator<AagAbsentTime> {
        private AagAbsentTimeCalculationComparator() {
        }

        @Override
        public int compare(AagAbsentTime at1, AagAbsentTime at2) {
            int comp = this.getCalculationType(at1) - this.getCalculationType(at2);
            if (comp == 0) {
                comp = DateHelper.compare((Date)at1.getFrom(), (Date)at2.getFrom());
            }
            return comp;
        }

        private int getCalculationType(AagAbsentTime absentTime) {
            int result;
            switch (absentTime.getType()) {
                case AAG_BT_GENERELL: 
                case AAG_BT_GENERELL_TEILW: {
                    result = 4;
                    break;
                }
                case AAG_BT_INDIVIDUELL: 
                case AAG_BT_INDIVIDUELL_TEILW: {
                    result = 5;
                    break;
                }
                default: {
                    result = absentTime.getType().ordinal();
                }
            }
            return result;
        }
    }
}

