/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.aag;

import com.varial.base.UtilitiesManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.criterion.Conjunction;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Order;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.aag.AagAbsentTime;
import com.varial.personnel.domain.aag.AagAccountComparator;
import com.varial.personnel.domain.aag.AagCompany;
import com.varial.personnel.domain.aag.AagComponents;
import com.varial.personnel.domain.aag.AagEmployee;
import com.varial.personnel.domain.aag.account.AagAccount;
import com.varial.personnel.domain.aag.account.AagAccountPersistencyManager;
import com.varial.personnel.domain.aag.dbaa.AagDbaa;
import com.varial.personnel.domain.aag.dbau.AagDbau;
import com.varial.personnel.domain.aag.dbbt.AagDbbt;
import com.varial.personnel.domain.aag.dbbv.AagDbbv;
import com.varial.personnel.domain.aag.dbna.AagDbna;
import com.varial.personnel.domain.aag.dbzu.AagDbzu;
import com.varial.personnel.domain.aag.dser.AagDser;
import com.varial.personnel.domain.aag.mapper.AagExceptionMapper;
import com.varial.personnel.domain.assignments.pcompanyhealthfund.AssignmentPCompanyHealthFundTP;
import com.varial.personnel.domain.assignments.pcompanyhealthfund.TypeOfRefundEnum;
import com.varial.personnel.domain.assignments.pcompanyhealthfund.mapper.TypeOfRefundEnumMapper;
import com.varial.personnel.domain.deuv.Deuv;
import com.varial.personnel.domain.deuv.DeuvBasics;
import com.varial.personnel.domain.deuv.IDbnaData;
import com.varial.personnel.domain.deuv.deuvaccount.adviceable.ValueInterval;
import com.varial.personnel.domain.deuvmessaging.DeuvHelper;
import com.varial.personnel.domain.deuvmessaging.DeuvRecipientMap;
import com.varial.personnel.domain.deuvmessaging.basiccomponents.Dbna;
import com.varial.personnel.domain.employee.Employee;
import com.varial.personnel.domain.employee.IEECompanyPlant;
import com.varial.personnel.domain.employee.IEmployeePersistencyManager;
import com.varial.personnel.domain.employee.IEmployeeReferenced;
import com.varial.personnel.domain.employee.carriedforward.system.sibreak.EECarriedForwardSystemSIBreak;
import com.varial.personnel.domain.employee.employment.Employment;
import com.varial.personnel.domain.employee.employment.TypeOfEarnedIncomEnum;
import com.varial.personnel.domain.employee.employment.TypeOfTimeOffEnum;
import com.varial.personnel.domain.employee.employment.mapper.TypeOfEarnedIncomEnumMapper;
import com.varial.personnel.domain.employee.employment.mapper.TypeOfTimeOffEnumMapper;
import com.varial.personnel.domain.global.bank.BankTP;
import com.varial.personnel.domain.global.deuv.recipient.DEUVRecipient;
import com.varial.personnel.domain.global.healthfund.HealthFund;
import com.varial.personnel.domain.pcompany.PCompany;
import com.varial.personnel.domain.pcompany.account.CompanyAccount;
import com.varial.personnel.domain.pcompany.account.CompanyAccountTP;
import com.varial.personnel.domain.reports.library.ReportHelper;
import com.varial.personnel.framework.SpecialAccess;
import com.varial.personnel.framework.basictypes.Communication;
import com.varial.personnel.framework.basictypes.PDateHelper;
import com.varial.personnel.framework.basictypes.PostalAddress;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.BooleanMapper;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.StringMapper;
import de.bitmarckservice.kernpruefung.aag.KernpruefungAAGImpl;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import kernpruefung.Kernpruefung;
import kernpruefung.Rueckgabe;

public class AagAdvice {
    private static final int U1_ERSTF_EG_K_10_31 = 371210;
    private static final int U1_ERSTF_EG_U_10_32 = 371220;
    private static final int U1_ERSTF_EG_S_10_33 = 371230;
    private static final int U1_AG_LEISTUNG_BAV_K = 371215;
    private static final int U1_AG_LEISTUNG_BAV_U = 371225;
    private static final int U1_AG_LEISTUNG_BAV_S = 371235;
    private static final int U1_ERSTF_SV_AGA_K = 371310;
    private static final int U1_ERSTF_SV_AGA_U = 371320;
    private static final int U1_ERSTF_SV_AGA_S = 371330;
    private static final int U1_AG_ERSTATTUNG_K = 371610;
    private static final int U1_AG_ERSTATTUNG_U = 371620;
    private static final int U1_AG_ERSTATTUNG_S = 371630;
    private static final int U2_ERSTF_EG_G_10_41 = 372220;
    private static final int U2_ERSTF_EG_I_10_42 = 372230;
    private static final int U2_AG_LEISTUNG_BAV_G = 372225;
    private static final int U2_AG_LEISTUNG_BAV_I = 372235;
    private static final int U2_ERSTF_SV_AGA_G = 372320;
    private static final int U2_ERSTF_SV_AGA_I = 372330;
    private static final int U2_AG_ZUSCHUSS_MUG = 372610;
    private static final int U2_AG_ERSTATTUNG_G = 372620;
    private static final int U2_AG_ERSTATTUNG_I = 372630;
    private static final int MUG_BRUTTO_MTL = 372310;
    private static final int MUG_NETTO_TGL = 372312;
    private static final int MUG_NETTO_MTL = 372314;
    private static final int UEBERWEISUNG = 0;
    private static final int VERRECHNUNG = 1;
    private final AagCompany mAagCompany;
    private final String mCreatedOnString;
    private final Date mCreatedOnDate;
    protected final List<AagAccount> mCreateds;
    protected final List<AagAccount> mCreatedsEmployee;
    private AagEmployee mEmployee;
    private final DeuvRecipientMap mRecipientMap;
    private IEECompanyPlant mEECompanyPlant;
    private List<String> mInsuranceNoBlackList;
    private final List<AagAccount> mForReCalculation;
    private boolean mPreview;
    private boolean mAffectedBySpecialAccess;
    private final ReportHelper mReportHelper = (ReportHelper)UtilitiesManager.getBean((String)"reportHelper", ReportHelper.class);

    public AagAdvice(AagCompany aagCompany) throws BusinessDomainException {
        this.mAagCompany = aagCompany;
        this.mCreatedOnDate = VDate.getCurrentLocalizedDateAndTime();
        this.mCreatedOnString = DeuvBasics.formatDEUVTimestamp((Date)this.mCreatedOnDate);
        this.mCreateds = new ArrayList<AagAccount>();
        this.mCreatedsEmployee = new ArrayList<AagAccount>();
        this.mRecipientMap = new DeuvRecipientMap(this.mAagCompany.getDeuvSender());
        this.mForReCalculation = new ArrayList<AagAccount>();
        this.mPreview = false;
        this.mAffectedBySpecialAccess = false;
    }

    public void createMessagesForEmployee(Employee employee) throws BusinessDomainException {
        this.mEmployee = new AagEmployee(employee, this);
        this.mCreatedsEmployee.clear();
        this.mForReCalculation.clear();
        for (AagAbsentTime absentTime : this.mEmployee.getRelevantAbsentTimes()) {
            this.createAccount(absentTime);
        }
        this.reCalculateValues();
        this.compareToTransmitteds();
        this.mCreateds.addAll(this.mCreatedsEmployee);
    }

    private void createAccount(AagAbsentTime absentTime) throws BusinessDomainException {
        Date start = DateHelper.max((Date)absentTime.getFrom(), (Date)this.getAagStartDate());
        Date end = DateHelper.min((Date)absentTime.getUntil(), (Date)this.mEmployee.getJournalizedUntil());
        Date withdrawal = this.mEmployee.getEmployee().getNextDateOfWithdrawal(absentTime.getFrom(), this.mEmployee.getJournalizedUntil());
        if (withdrawal != null) {
            end = DateHelper.min((Date)end, (Date)withdrawal);
        }
        while (DateHelper.beforeOrEqual((Date)start, (Date)end)) {
            Date tmpend = DateHelper.min((Date)DateHelper.getLastDayOfMonth((Date)start), (Date)end);
            if (absentTime.getTypeOfAbsentTime() == 1 && this.mAagCompany.isAssessable(tmpend) && this.mEmployee.hasU1Duty(tmpend) || absentTime.getTypeOfAbsentTime() != 1 && this.mEmployee.hasU2Duty(tmpend)) {
                AagAccount account = this.createAagAccount(absentTime, start, tmpend);
                if (this.isWithoutZuschussMug(account) || this.isPartialWithoutWorkdays(absentTime, account)) {
                    account.makeReadOnly();
                } else {
                    this.mCreatedsEmployee.add(account);
                }
            }
            start = DateHelper.tomorrow((Date)tmpend);
        }
    }

    private AagAccount createAagAccount(AagAbsentTime absentTime, Date start, Date end) throws BusinessDomainException {
        AagAccount account = this.initAagAccount(start);
        account.setValidFrom(start);
        account.setValidUntil(end);
        AagDser dser = this.initDser(account);
        switch (absentTime.getTypeOfAbsentTime()) {
            case 1: {
                this.createDbau(dser, absentTime);
                break;
            }
            case 2: {
                this.createDbbt(dser, absentTime);
                break;
            }
            case 3: {
                this.createDbzu(dser, absentTime);
                break;
            }
        }
        account.setReasonOfDelivery(absentTime.getTypeOfAbsentTime());
        dser.setAbgabeGrund(absentTime.getTypeOfAbsentTime());
        this.initDbbv(dser);
        this.initDbaa(dser);
        this.initDbna(dser);
        this.correctSameCalculationTypeInMonth(account);
        return account;
    }

    private boolean isWithoutZuschussMug(AagAccount account) {
        AagDbzu aagDbzu = account.getAagDser().getAagDbzu();
        return aagDbzu != null && BigDecimalMapper.isZero((BigDecimal)aagDbzu.getZuschussMug());
    }

    private boolean isPartialWithoutWorkdays(AagAbsentTime absentTime, AagAccount account) throws BusinessDomainException {
        AagDbbt aagDbbt;
        boolean result = false;
        if (absentTime.isPartialAbsentTime() && (aagDbbt = account.getAagDser().getAagDbbt()) != null && (BigDecimalMapper.isZero((BigDecimal)aagDbbt.getFortBruttoAE()) || BigDecimalMapper.isZero((BigDecimal)aagDbbt.getErstattungsBetrag()))) {
            result = BigDecimalMapper.isZero((BigDecimal)this.mEmployee.getWorkDays(account.getValidFrom(), account.getValidUntil()));
        }
        return result;
    }

    private void correctSameCalculationTypeInMonth(AagAccount account) {
        AagAccount last;
        if (!(this.mForReCalculation.isEmpty() || PDateHelper.inSameMonth((Date)(last = this.mForReCalculation.get(0)).getValidFrom(), (Date)account.getValidFrom()) && this.getCalculationType(last) == this.getCalculationType(account))) {
            this.reCalculateValues();
        }
        this.mForReCalculation.add(account);
    }

    private void reCalculateValues() {
        if (this.mForReCalculation.size() > 1) {
            AagAccount first = this.mForReCalculation.get(0);
            if (first.getAagDser().hasMDbau()) {
                AagDbau aagDbauFirst = first.getAagDser().getAagDbau();
                BigDecimal fortAgAnteileRest = aagDbauFirst.getFortAgAnteile();
                BigDecimal svEntgeltRest = aagDbauFirst.getSvae();
                BigDecimal fortBruttoAERest = aagDbauFirst.getFortBruttoAE();
                BigDecimal erstattungsBetragRest = aagDbauFirst.getErstattungsBetrag();
                BigDecimal agLeistungBavRest = aagDbauFirst.getEzb();
                BigDecimal absenttime = BigDecimal.ZERO;
                for (AagAccount account : this.mForReCalculation) {
                    absenttime = absenttime.add(account.getAagDser().getAagDbau().getAusfallzeit());
                }
                for (int i = 0; i < this.mForReCalculation.size() - 1; ++i) {
                    AagDbau aagDbau = this.mForReCalculation.get(i).getAagDser().getAagDbau();
                    BigDecimal factor = aagDbau.getAusfallzeit().divide(absenttime, 6, RoundingMode.HALF_UP);
                    aagDbau.setFortAgAnteile(aagDbau.getFortAgAnteile().multiply(factor).setScale(2, RoundingMode.HALF_UP));
                    aagDbau.setSvae(aagDbau.getSvae().multiply(factor).setScale(2, RoundingMode.HALF_UP));
                    aagDbau.setFortBruttoAE(aagDbau.getFortBruttoAE().multiply(factor).setScale(2, RoundingMode.HALF_UP));
                    aagDbau.setErstattungsBetrag(aagDbau.getErstattungsBetrag().multiply(factor).setScale(2, RoundingMode.HALF_UP));
                    aagDbau.setEzb(aagDbau.getEzb().multiply(factor).setScale(2, RoundingMode.HALF_UP));
                    fortAgAnteileRest = fortAgAnteileRest.subtract(aagDbau.getFortAgAnteile());
                    svEntgeltRest = svEntgeltRest.subtract(aagDbau.getSvae());
                    fortBruttoAERest = fortBruttoAERest.subtract(aagDbau.getFortBruttoAE());
                    erstattungsBetragRest = erstattungsBetragRest.subtract(aagDbau.getErstattungsBetrag());
                    agLeistungBavRest = agLeistungBavRest.subtract(aagDbau.getEzb());
                }
                AagDbau aagDbauLast = this.mForReCalculation.get(this.mForReCalculation.size() - 1).getAagDser().getAagDbau();
                aagDbauLast.setFortAgAnteile(fortAgAnteileRest);
                aagDbauLast.setSvae(svEntgeltRest);
                aagDbauLast.setFortBruttoAE(fortBruttoAERest);
                aagDbauLast.setErstattungsBetrag(erstattungsBetragRest);
                aagDbauLast.setEzb(agLeistungBavRest);
            } else if (first.getAagDser().hasMDbbt()) {
                AagDbbt aagDbbtFirst = first.getAagDser().getAagDbbt();
                BigDecimal fortAgAnteileRest = aagDbbtFirst.getFortAgAnteile();
                BigDecimal svEntgeltRest = aagDbbtFirst.getSvae();
                BigDecimal fortBruttoAERest = aagDbbtFirst.getFortBruttoAE();
                BigDecimal erstattungsBetragRest = aagDbbtFirst.getErstattungsBetrag();
                BigDecimal agLeistungBavRest = aagDbbtFirst.getEzb();
                int absentTime = 0;
                for (AagAccount account : this.mForReCalculation) {
                    absentTime += DateHelper.getDiffInDays((Date)account.getValidUntil(), (Date)account.getValidFrom()) + 1;
                }
                for (int i = 0; i < this.mForReCalculation.size() - 1; ++i) {
                    AagDbbt aagDbbt = this.mForReCalculation.get(i).getAagDser().getAagDbbt();
                    int diff = DateHelper.getDiffInDays((Date)aagDbbt.getEzeitBis(), (Date)aagDbbt.getEzeitVom()) + 1;
                    BigDecimal factor = BigDecimal.valueOf(diff).divide(BigDecimal.valueOf(absentTime), 6, RoundingMode.HALF_UP);
                    aagDbbt.setFortAgAnteile(aagDbbt.getFortAgAnteile().multiply(factor).setScale(2, RoundingMode.HALF_UP));
                    aagDbbt.setSvae(aagDbbt.getSvae().multiply(factor).setScale(2, RoundingMode.HALF_UP));
                    aagDbbt.setFortBruttoAE(aagDbbt.getFortBruttoAE().multiply(factor).setScale(2, RoundingMode.HALF_UP));
                    aagDbbt.setErstattungsBetrag(aagDbbt.getErstattungsBetrag().multiply(factor).setScale(2, RoundingMode.HALF_UP));
                    aagDbbt.setEzb(aagDbbt.getEzb().multiply(factor).setScale(2, RoundingMode.HALF_UP));
                    fortAgAnteileRest = fortAgAnteileRest.subtract(aagDbbt.getFortAgAnteile());
                    svEntgeltRest = svEntgeltRest.subtract(aagDbbt.getSvae());
                    fortBruttoAERest = fortBruttoAERest.subtract(aagDbbt.getFortBruttoAE());
                    erstattungsBetragRest = erstattungsBetragRest.subtract(aagDbbt.getErstattungsBetrag());
                    agLeistungBavRest = agLeistungBavRest.subtract(aagDbbt.getEzb());
                }
                AagDbbt aagDbbtLast = this.mForReCalculation.get(this.mForReCalculation.size() - 1).getAagDser().getAagDbbt();
                aagDbbtLast.setFortAgAnteile(fortAgAnteileRest);
                aagDbbtLast.setSvae(svEntgeltRest);
                aagDbbtLast.setFortBruttoAE(fortBruttoAERest);
                aagDbbtLast.setErstattungsBetrag(erstattungsBetragRest);
                aagDbbtLast.setEzb(agLeistungBavRest);
            }
        }
        this.mForReCalculation.clear();
    }

    private int getCalculationType(AagAccount account) {
        int result = -1;
        AagDser dser = account.getAagDser();
        if (dser.hasMDbau()) {
            result = dser.getAagDbau().getUrsacheAU();
        }
        if (dser.hasMDbzu()) {
            result = 3;
        }
        if (dser.hasMDbbt()) {
            if (account.isNewCalculated()) {
                result = 4 + dser.getAagDbbt().getArtVerbot();
            } else {
                switch (dser.getAagDbbt().getArtVerbot()) {
                    case 0: 
                    case 2: {
                        result = 8;
                        break;
                    }
                    case 1: 
                    case 3: {
                        result = 9;
                        break;
                    }
                }
            }
        }
        return result;
    }

    public Employee[] getAllEmployees() {
        return this.getIEmployeePM().query(new Order[]{Order.asc((String)"PERSONNELNUMBER")}, Restrictions.eq((String)"OIDPCOMPANY", (String)this.mAagCompany.getPCompany().getObjectid()), true);
    }

    private AagDbau createDbau(AagDser dser, AagAbsentTime absentTime) throws BusinessDomainException {
        AagDbau result = this.initDbau(dser);
        Date start = dser.getAagAccount().getValidFrom();
        Date end = dser.getAagAccount().getValidUntil();
        result.setEzeitVom(start);
        result.setEzeitBis(end);
        result.setAusfallzeit(this.mEmployee.getAbsentTime(result.getArtAusfallzeit(), start, end));
        switch (absentTime.getType()) {
            case AAG_EF_KRANKHEIT: {
                result.setFortBruttoAE(this.mEmployee.calculateValueWithFallback(371210, start, end, ValueInterval.Field.PB4));
                result.setFortAgAnteile(this.mEmployee.calculateValue(371310, start, end));
                result.setSvae(this.mEmployee.calculateValue(371310, start, end, ValueInterval.Field.FACTOR2));
                result.setErstattungsBetrag(this.mEmployee.calculateValue(371610, start, end));
                result.setUrsacheAU(0);
                result.setEzb(this.mEmployee.calculateValue(371215, start, end));
                break;
            }
            case AAG_EF_UNFALL: {
                result.setFortBruttoAE(this.mEmployee.calculateValueWithFallback(371220, start, end, ValueInterval.Field.PB4));
                result.setFortAgAnteile(this.mEmployee.calculateValue(371320, start, end));
                result.setSvae(this.mEmployee.calculateValue(371320, start, end, ValueInterval.Field.FACTOR2));
                result.setErstattungsBetrag(this.mEmployee.calculateValue(371620, start, end));
                result.setUrsacheAU(2);
                result.setEzb(this.mEmployee.calculateValue(371225, start, end));
                break;
            }
            case AAG_EF_SCHAEDIGUNG: {
                result.setFortBruttoAE(this.mEmployee.calculateValueWithFallback(371230, start, end, ValueInterval.Field.PB4));
                result.setFortAgAnteile(this.mEmployee.calculateValue(371330, start, end));
                result.setSvae(this.mEmployee.calculateValue(371330, start, end, ValueInterval.Field.FACTOR2));
                result.setErstattungsBetrag(this.mEmployee.calculateValue(371630, start, end));
                result.setUrsacheAU(1);
                result.setEzb(this.mEmployee.calculateValue(371235, start, end));
                break;
            }
        }
        if (result.getUrsacheAU() != 1) {
            result.setAbtretung("N");
        }
        result.setAutag(absentTime.isWaitingDay() ? "J" : "N");
        result.setLetzterArbeitstag(this.mEmployee.getLastWorkingDay(absentTime.getFrom(), this.mAagCompany.getCalculationStart()));
        return result;
    }

    private AagDbbt createDbbt(AagDser dser, AagAbsentTime absentTime) throws BusinessDomainException {
        AagDbbt result = this.initDbbt(dser);
        Date start = dser.getAagAccount().getValidFrom();
        Date end = dser.getAagAccount().getValidUntil();
        result.setEzeitVom(start);
        result.setEzeitBis(end);
        String keyAT = absentTime.getDeuvKey();
        switch (absentTime.getType()) {
            case AAG_BT_GENERELL: 
            case AAG_BT_GENERELL_TEILW: {
                result.setFortBruttoAE(this.mEmployee.calculateValue(372220, start, end, keyAT));
                result.setFortAgAnteile(this.mEmployee.calculateValue(372320, start, end, keyAT));
                result.setSvae(this.mEmployee.calculateValue(372320, start, end, keyAT, ValueInterval.Field.FACTOR2));
                result.setErstattungsBetrag(this.mEmployee.calculateValue(372620, start, end, keyAT));
                result.setEzb(this.mEmployee.calculateValue(372225, start, end, keyAT));
                dser.getAagAccount().setNewCalculated(this.mEmployee.isNewCalculated(372220, start, end));
                break;
            }
            case AAG_BT_INDIVIDUELL: 
            case AAG_BT_INDIVIDUELL_TEILW: {
                result.setFortBruttoAE(this.mEmployee.calculateValue(372230, start, end, keyAT));
                result.setFortAgAnteile(this.mEmployee.calculateValue(372330, start, end, keyAT));
                result.setSvae(this.mEmployee.calculateValue(372330, start, end, keyAT, ValueInterval.Field.FACTOR2));
                result.setErstattungsBetrag(this.mEmployee.calculateValue(372630, start, end, keyAT));
                result.setEzb(this.mEmployee.calculateValue(372235, start, end, keyAT));
                dser.getAagAccount().setNewCalculated(this.mEmployee.isNewCalculated(372230, start, end));
                break;
            }
        }
        result.setArtVerbot(absentTime.getTypeOfProhibition());
        result.setMutEntbindung(absentTime.getDuesDate());
        return result;
    }

    private AagDbzu createDbzu(AagDser dser, AagAbsentTime absentTime) throws BusinessDomainException {
        AagDbzu result = this.initDbzu(dser);
        Date start = dser.getAagAccount().getValidFrom();
        Date end = dser.getAagAccount().getValidUntil();
        result.setEzeitVom(start);
        result.setEzeitBis(end);
        result.setSfristVom(this.getSfirstVom(absentTime));
        result.setSfristBis(this.getSfristBis(absentTime));
        if (this.mEmployee.getEmployment(end).getEarnedIncomeRelevantForCalculation()) {
            Employment employment = this.mEmployee.getEmployment(end);
            result.setBruttoMtl(employment.getAverageMonthlyGrossPay());
            result.setNettoTgl(employment.getCalendarDailyNetPay());
            result.setNettoMtl(employment.getAverageMonthlyNetPay());
        } else {
            result.setBruttoMtl(this.mEmployee.calculateValue(372310, start, end));
            result.setNettoTgl(this.mEmployee.calculateValue(372312, start, end));
            result.setNettoMtl(this.mEmployee.calculateValue(372314, start, end));
        }
        result.setZuschussMug(this.mEmployee.calculateValue(372610, start, end));
        result.setMutEntbindung(absentTime.getDuesDate());
        return result;
    }

    private Date getSfirstVom(AagAbsentTime absentTime) throws BusinessDomainException {
        EECarriedForwardSystemSIBreak cFAbsentTime;
        Date result = absentTime.getFrom();
        if (DateHelper.equal((Date)absentTime.getFrom(), (Date)this.mAagCompany.getCalculationStart()) && (cFAbsentTime = this.mEmployee.getCFAbsentTime(absentTime)) != null) {
            result = cFAbsentTime.getValidFrom();
        }
        return result;
    }

    private Date getSfristBis(AagAbsentTime absentTime) {
        Date result;
        if (DateHelper.equal((Date)absentTime.getUntil(), (Date)VDate.getDateMax())) {
            Date start = absentTime.getFrom();
            if (absentTime.getDuesDate() == null) {
                result = absentTime.getTypeOfBirth() == 0 ? DateHelper.add((Date)start, (int)98) : DateHelper.add((Date)start, (int)126);
            } else {
                start = DateHelper.max((Date)DateHelper.add((Date)start, (int)41), (Date)absentTime.getDuesDate());
                result = absentTime.getTypeOfBirth() == 0 ? DateHelper.add((Date)start, (int)56) : DateHelper.add((Date)start, (int)84);
            }
        } else {
            result = absentTime.getUntil();
        }
        return result;
    }

    private AagAccount initAagAccount(Date validTimePoint) throws BusinessDomainException {
        AagAccount account = new AagAccount(this.mEmployee.getEmployee());
        account.setEffectiveFrom(this.getEffectiveFrom());
        account.setCreatedOn(this.mCreatedOnDate);
        account.setDEUVSender(this.mAagCompany.getDeuvSender());
        account.setDEUVRecipient(this.getDEUVRecipient(validTimePoint));
        account.setCanceled("N");
        account.setInsuranceNo(this.mEmployee.getPersonalData().getInsuranceNo());
        return account;
    }

    private AagDser initDser(AagAccount account) throws BusinessDomainException {
        AagDser result = account.createDser();
        result.setBnrAbsender(this.mAagCompany.getDeuvSenderStdCompNo());
        result.setBnrEmpfaenger(this.getRecipientStdCompNo(account.getValidFrom()));
        result.setErstellungsDatum(this.getCreatedOnDate());
        result.setFehlerKennz("0");
        result.setFehlerAnz(0);
        result.setVersicherungsNr(this.mEmployee.getPersonalData().getInsuranceNo());
        result.setGeburtsdatum(this.mEmployee.getPersonalData().getDateOfBirth());
        result.setBnrVerursacher(this.getEECompanyPlant(account.getValidFrom()).getCompanyNumber());
        result.setAzVerursacher(Deuv.toAzVerursacher((String)this.mEmployee.getIDString()));
        result.setArtVersicherung(this.mEmployee.getArtVersicherung(account.getValidFrom()));
        result.setBnrKK(this.getHealthFundStdCompNo(account.getValidFrom(), result));
        result.setBeschSeit(this.mEmployee.getDateOfEntry(account.getValidFrom()));
        result.setGeschlecht(this.mEmployee.getPersonalData().getSexString());
        result.setArtAbrechnungsProg(1);
        result.setProdId(DeuvBasics.getProdId());
        result.setModId(DeuvBasics.getModId());
        return result;
    }

    protected AagDbau initDbau(AagDser dser) throws BusinessDomainException {
        AagDbau result = dser.createDbau();
        Date validFrom = dser.getAagAccount().getValidFrom();
        result.setKennzv(0);
        Employment employment = this.mEmployee.getActiveEmployment(validFrom);
        result.setArtEntgelt(TypeOfEarnedIncomEnumMapper.toInt((TypeOfEarnedIncomEnum)employment.getTypeOfEarnedIncome()));
        result.setEntgelt(this.getEntgelt(employment.getEarnedIncome(), result.getArtEntgelt(), validFrom, dser.getAagAccount().getValidUntil()));
        result.setArtAusfallzeit(TypeOfTimeOffEnumMapper.toInt((TypeOfTimeOffEnum)employment.getTypeOfTimeOff()) + 1);
        if (result.getArtAusfallzeit() == 3) {
            result.setAzwoechentlich(this.mEmployee.getWeeklyWorkingTime(validFrom));
            result.setAztaeglich(this.mEmployee.getDailyWorkingTime(validFrom));
        }
        result.setErstattungsSatz(this.mAagCompany.getErstattungsSatzU1(this.mEmployee.getHealthFund(validFrom), this.mEmployee.getPlant(validFrom), validFrom));
        result.setAbtretung(employment.getAssignment() ? "J" : "N");
        result.setArtAbrechnung(-1);
        return result;
    }

    private BigDecimal getEntgelt(BigDecimal fromEmployment, int artEntgelt, Date validFrom, Date validUntil) throws BusinessDomainException {
        BigDecimal result = fromEmployment;
        if (artEntgelt == 2 && BigDecimalMapper.isZeroOrNull((BigDecimal)fromEmployment)) {
            Date from = DateHelper.getFirstDayOfMonth((Date)validFrom);
            Date until = DateHelper.getLastDayOfMonth((Date)validUntil);
            BigDecimal siDays = this.getEmployee().calculateValue(130590, from, until, ValueInterval.Field.FACTOR1);
            boolean valid = false;
            if (BigDecimalMapper.compareTo((BigDecimal)BigDecimal.valueOf(30L), (BigDecimal)siDays) == 0) {
                valid = true;
            } else {
                BigDecimal taxDays = this.getEmployee().calculateValue(110590, from, until, ValueInterval.Field.FACTOR1);
                if (BigDecimalMapper.compareTo((BigDecimal)siDays, (BigDecimal)taxDays) == 0) {
                    valid = true;
                }
            }
            if (valid) {
                result = this.getEmployee().calculateValue(371150, validFrom, validUntil);
            }
        }
        return result;
    }

    private AagDbbt initDbbt(AagDser dser) throws BusinessDomainException {
        AagDbbt result = dser.createDbbt();
        Date validFrom = dser.getAagAccount().getValidFrom();
        result.setKennStorno(0);
        result.setErstattungsSatz(this.mAagCompany.getErstattungsSatzU2(this.mEmployee.getHealthFund(validFrom), this.mEmployee.getPlant(validFrom), validFrom));
        result.setArtAbrechnung(-1);
        return result;
    }

    private AagDbzu initDbzu(AagDser dser) throws BusinessDomainException {
        AagDbzu result = dser.createDbzu();
        Date validFrom = dser.getAagAccount().getValidFrom();
        result.setKennzv(0);
        result.setNettoAndereBesch(this.mEmployee.getActiveEmployment(validFrom).getNetIncome());
        result.setArtAbrechnung(-1);
        return result;
    }

    protected void initDbbv(AagDser dser) throws BusinessDomainException {
        this.initDbbv(dser, VDate.getDateMax());
    }

    protected AagDbbv initDbbv(AagDser dser, Date bankValidDate) throws BusinessDomainException {
        AagDbbv result = dser.createDbbv();
        Date validDate = dser.getAagAccount().getValidUntil();
        AssignmentPCompanyHealthFundTP asshftp = this.mAagCompany.getAssignmentPCompanyHealthFundTP(this.mEmployee.getHealthFund(validDate), this.mEmployee.getPlant(validDate), bankValidDate);
        result.setUebver(TypeOfRefundEnumMapper.toInt((TypeOfRefundEnum)asshftp.getTypeOfRefund()));
        if (result.getUebver() == 1) {
            result.setVerMonat(DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)validDate)));
        }
        if (result.getUebver() == 0) {
            CompanyAccount companyAccount = asshftp.getCompanyAccountForSetlementRefundAssessments();
            if (companyAccount == null && (companyAccount = CompanyAccount.getStandardBankAccount((PCompany)this.mAagCompany.getPCompany(), (Date)VDate.getDateMax(), (Date)bankValidDate)) == null) {
                throw AagExceptionMapper.makeNoBankAccountDomainException((String)(this.mAagCompany.getPCompanyName() + " - " + this.mEmployee.getHealthFund(validDate).getHealthFund()));
            }
            BankTP bankTP = companyAccount.getBank().getBankTP(VDate.getDateMax(), VDate.getDateMax());
            result.setBic(bankTP.getBicCode());
            CompanyAccountTP accountTP = companyAccount.getCompanyAccountTP(VDate.getDateMax(), bankValidDate);
            result.setIban(accountTP.getIban());
            result.setKtoinhaber(StringMapper.maxLength((String)accountTP.getAccountHolder(), (int)50));
            String Verwzweck = "";
            switch (dser.getAbgabeGrund()) {
                case 1: {
                    Verwzweck = this.mReportHelper.getReasonForTransferU1(this.mEmployee.getActiveEmployment(VDate.getDateMax()));
                    break;
                }
                case 2: {
                    Verwzweck = this.mReportHelper.getReasonForTransferU2BT(this.mEmployee.getActiveEmployment(VDate.getDateMax()));
                    break;
                }
                case 3: {
                    Verwzweck = this.mReportHelper.getReasonForTransferU2ZU(this.mEmployee.getActiveEmployment(VDate.getDateMax()));
                    break;
                }
            }
            result.setVerwzweck(Verwzweck);
        }
        return result;
    }

    protected AagDbaa initDbaa(AagDser dser) throws BusinessDomainException {
        AagDbaa result = dser.createDbaa();
        result.setGeschlecht(this.getAagCompany().getDeuvSenderPersonSex());
        Communication communication = this.getAagCompany().getCommunication();
        result.setCommunicationAag(new Communication(StringMapper.maxLength((String)communication.getTelephoneNumber(), (int)20), "", StringMapper.maxLength((String)communication.getFaxNumber(), (int)20), StringMapper.maxLength((String)communication.getEMailAddress(), (int)70), "", StringMapper.maxLength((String)communication.getContactPerson(), (int)30)));
        String[] names = this.getAagCompany().getDeuvSenderNameLong().split("\\r\\n?|\\n");
        result.setNabe1(StringMapper.maxLength((String)names[0], (int)30));
        result.setNabe2(StringMapper.maxLength((String)(names.length > 1 ? names[1] : ""), (int)30));
        result.setNabe3(StringMapper.maxLength((String)(names.length > 2 ? names[2] : ""), (int)30));
        PostalAddress address = this.getAagCompany().getDeuvSenderAddress();
        result.setAdresse(new PostalAddress(StringMapper.maxLength((String)address.getStreet(), (int)33), address.getPostalCode(), StringMapper.maxLength((String)address.getCity(), (int)34), ""));
        return result;
    }

    private AagDbna initDbna(AagDser dser) throws BusinessDomainException {
        AagDbna result = dser.createDbna();
        result.setDbnaData(new Dbna());
        this.mEmployee.fillDbna((IDbnaData)result.getDbnaData());
        return result;
    }

    public void checkAccountsForErrors() throws BusinessDomainException {
        Kernpruefung kernpruefung = KernpruefungAAGImpl.getInstance();
        for (AagAccount account : this.mCreateds) {
            String vosz;
            String accountString;
            Rueckgabe rueckgabe;
            ArrayList<String> errorMessages = new ArrayList<String>();
            if (this.getInsuranceNoBlackList().contains(account.getInsuranceNo())) {
                errorMessages.add("Ung\u00fcltige SV-Nummer. ");
            }
            if ((rueckgabe = kernpruefung.pruefe(accountString = AagComponents.getContentAagAccount((AagAccount)account), vosz = AagComponents.getContentVoszForCheck((AagAccount)account))).getReturnCode() >= 2) {
                for (String error : rueckgabe.getRueckgabeMeldungen()) {
                    if (!this.isErrorValid(error)) continue;
                    errorMessages.add(this.improveErrorMessage(error));
                }
            }
            account.setErrorMessage(DeuvHelper.getErrorMessage((String)account.getErrorMessage(), errorMessages, (boolean)true));
        }
        ArrayList<AagAccount> errors = new ArrayList<AagAccount>();
        for (AagAccount each : this.mCreateds) {
            if (!each.hasErrors()) continue;
            errors.add(each);
        }
        if (!errors.isEmpty()) {
            this.mCreateds.removeAll(errors);
            this.mCreateds.addAll(0, errors);
        }
        if (this.isPreview()) {
            for (AagAccount account : this.mCreateds) {
                account.makeReadOnly();
            }
        }
    }

    private boolean isErrorValid(String error) throws BusinessDomainException {
        boolean valid = true;
        if (this.mAagCompany.getDeuvSender().isTestSender() && error.contains("DSER152")) {
            valid = false;
        }
        return valid;
    }

    private String improveErrorMessage(String error) {
        if (error.contains("DBAU071")) {
            return "DBAU071 Bei Ursache AU=1(Sch\u00e4digung durch Dritte) ist Abtretung nur \"J\" zul\u00e4ssig";
        }
        return error;
    }

    public void compareToTransmitteds() throws BusinessDomainException {
        AagAccount storno;
        LinkedList<AagAccount> existing = new LinkedList<AagAccount>(this.getActiveTransmitted());
        Collections.sort(this.mCreatedsEmployee, new AagAccountComparator());
        LinkedList<AagAccount> createds = new LinkedList<AagAccount>(this.mCreatedsEmployee);
        this.mCreatedsEmployee.clear();
        while (!existing.isEmpty() && !createds.isEmpty()) {
            AagAccount existent = (AagAccount)existing.getFirst();
            AagAccount created = (AagAccount)createds.getFirst();
            switch (this.compareAccounts(existent, created)) {
                case 0: {
                    created.makeReadOnly();
                    existing.removeFirst();
                    createds.removeFirst();
                    break;
                }
                case -1: {
                    storno = this.makeCancellation(existent);
                    this.mCreatedsEmployee.add(storno);
                    existing.removeFirst();
                    break;
                }
                case 1: {
                    this.mCreatedsEmployee.add(created);
                    createds.removeFirst();
                    break;
                }
            }
        }
        for (AagAccount account : existing) {
            storno = this.makeCancellation(account);
            this.mCreatedsEmployee.add(storno);
        }
        for (AagAccount account : createds) {
            this.mCreatedsEmployee.add(account);
        }
    }

    private List<AagAccount> getActiveTransmitted() throws BusinessDomainException {
        Conjunction filter = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)this.mEmployee.getEmployee().getObjectid()), Restrictions.ge((String)"validfrom", (String)DateMapper.toString((Date)this.getAagStartDate()))});
        List<AagAccount> query = Arrays.asList(AagAccountPersistencyManager.queryAll(null, (Criterion)filter, (boolean)true));
        ArrayList<AagAccount> existents = new ArrayList<AagAccount>(query);
        for (AagAccount account : new ArrayList<AagAccount>(existents)) {
            if (!account.getTransmitted()) {
                existents.remove(account);
                account.makeSaveable();
                account.destroy();
                continue;
            }
            if (!account.getAagDser().isCancelation()) continue;
            account.updateCanceled("J");
        }
        Collections.sort(existents, new AagAccountComparator());
        LinkedList<AagAccount> inputs = new LinkedList<AagAccount>(existents);
        while (!inputs.isEmpty()) {
            AagAccount current = (AagAccount)inputs.remove(0);
            if (current.getCanceled().equals("X")) {
                for (AagAccount each : inputs) {
                    AagDser dser = each.getAagDser();
                    if (!dser.isCancelation() || (StringMapper.isNullString((String)dser.getDatensatzIdUrsprung()) || !dser.getDatensatzIdUrsprung().equals(current.getAagDser().getDatensatzId())) && each.compareToOld(current)) continue;
                    inputs.remove(each);
                    existents.remove(each);
                    existents.remove(current);
                    current = null;
                    break;
                }
                if (current == null) continue;
                current.updateCanceled("N");
                continue;
            }
            if (!current.getAagDser().isCancelation()) continue;
            existents.remove(current);
        }
        return existents;
    }

    public void getUntransmitteds(SpecialAccess specialAccess) throws BusinessDomainException {
        AagAccount[] filtered;
        Criterion filter = Restrictions.and((Criterion)Restrictions.eq((String)"oidpcompany", (String)this.mAagCompany.getPCompany().getObjectid()), (Criterion)Restrictions.eq((String)"transmitted", (String)BooleanMapper.toString((boolean)false)));
        AagAccount[] untransmitteds = AagAccountPersistencyManager.queryAll(null, (Criterion)filter, (boolean)false);
        if (untransmitteds.length != (filtered = (AagAccount[])specialAccess.filter((IEmployeeReferenced[])untransmitteds)).length) {
            this.setAffectedBySpecialAccess(true);
        }
        this.mCreateds.clear();
        for (AagAccount account : filtered) {
            if (account.hasErrors()) continue;
            this.mCreateds.add(account);
        }
        Collections.sort(this.mCreateds, new AagAccountComparator());
    }

    private int compareAccounts(AagAccount existent, AagAccount created) throws BusinessDomainException {
        int result = created.getEmployee().getPersonnelnumber() - existent.getEmployee().getPersonnelnumber();
        if (result != 0) {
            int n = result = result < 0 ? 1 : -1;
        }
        if (result == 0) {
            result = DateHelper.compare((Date)existent.getValidFrom(), (Date)created.getValidFrom());
        }
        if (result == 0 && created.compareToOld(existent)) {
            result = -1;
        }
        return result;
    }

    private AagAccount makeCancellation(AagAccount account) throws BusinessDomainException {
        AagAccount storno = account.makeCancelation();
        this.mEmployee = new AagEmployee(account.getEmployee(), this);
        this.checkConvertToV6(storno);
        storno.getAagDser().setProdId(DeuvBasics.getProdId());
        storno.getAagDser().setModId(DeuvBasics.getModId());
        storno.setInsuranceNo(this.mEmployee.getPersonalData().getInsuranceNo());
        storno.getAagDser().setVersicherungsNr(storno.getInsuranceNo());
        storno.getAagDser().setErstellungsDatum(this.mCreatedOnDate);
        storno.setCreatedOn(this.mCreatedOnDate);
        storno.getAagDser().setAzVerursacher(Deuv.toAzVerursacher((String)this.mEmployee.getIDString()));
        storno.getAagDser().setBnrAbsender(this.mAagCompany.getDeuvSenderStdCompNo());
        DEUVRecipient deuvRecipient = this.mRecipientMap.updateDeuvRecipient(account.getDEUVRecipient(), account.getAagDser().getBnrEmpfaenger());
        storno.setDEUVRecipient(deuvRecipient);
        this.updateRecipient(storno);
        return storno;
    }

    private void checkConvertToV6(AagAccount storno) {
        storno.getAagDser().setVersionsNr(6);
    }

    private void updateRecipient(AagAccount storno) throws BusinessDomainException {
        AagDser dser = storno.getAagDser();
        String bnrEmpfaenger = dser.getBnrEmpfaenger();
        switch (dser.getArtVersicherung()) {
            case 0: 
            case 1: 
            case 2: {
                bnrEmpfaenger = DeuvRecipientMap.updateStdCompNoHealthFund((String)bnrEmpfaenger, (Date)storno.getValidUntil());
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(dser.getArtVersicherung()));
            }
        }
        dser.setBnrEmpfaenger(bnrEmpfaenger);
    }

    public void sortCreatedsForReport() {
    }

    public List<AagAccount> getCreateds() {
        return Collections.unmodifiableList(this.mCreateds);
    }

    private Date getEffectiveFrom() {
        return DateHelper.tomorrow((Date)this.mEmployee.getJournalizedUntil());
    }

    public AagCompany getAagCompany() {
        return this.mAagCompany;
    }

    public Date getCreatedOnDate() {
        return this.mCreatedOnDate;
    }

    public String getCreatedOnString() {
        return this.mCreatedOnString;
    }

    public Date getAagStartDate() throws BusinessDomainException {
        Date maxMonthRR = DateHelper.addMonths((Date)this.mEmployee.getJournalizedUntil(), (int)(-(this.mAagCompany.getMonthsOfCalculation() + 2)));
        return DateHelper.max((Date[])new Date[]{this.mAagCompany.getDateOfAagStart(), this.mAagCompany.getCalculationStart(), DateHelper.getFirstDayOfMonth((Date)maxMonthRR)});
    }

    private DEUVRecipient getDEUVRecipient(Date validTimePoint) throws BusinessDomainException {
        return this.mRecipientMap.getDeuvRecipient(this.getRecipientHealthFund(validTimePoint));
    }

    private String getRecipientStdCompNo(Date validTimePoint) throws BusinessDomainException {
        return this.getHealthFundStdCompNo(this.getRecipientHealthFund(validTimePoint), validTimePoint);
    }

    private HealthFund getRecipientHealthFund(Date validTimePoint) throws BusinessDomainException {
        if (this.mEmployee.isBestandsschutz2022(validTimePoint)) {
            return this.mEmployee.getAssessmentHealthFund(validTimePoint);
        }
        return this.mEmployee.getHealthFund(validTimePoint);
    }

    private String getHealthFundStdCompNo(Date validTimePoint, AagDser dser) throws BusinessDomainException {
        switch (dser.getArtVersicherung()) {
            case 0: 
            case 2: {
                return dser.getBnrEmpfaenger();
            }
            case 1: {
                return null;
            }
            case 3: {
                if (this.mEmployee.isBestandsschutz2022(validTimePoint)) {
                    return this.getHealthFundStdCompNo(this.mEmployee.getHealthFund(validTimePoint), validTimePoint);
                }
                HealthFund healthFund = this.mEmployee.getLegalHealthFund(validTimePoint);
                if (healthFund == null) {
                    dser.getAagAccount().setErrorMessage("Die Angabe \"gesetzliche KV bei\" bzw. die Eingabe eines privaten KV-Unternehmens fehlt");
                    return null;
                }
                return this.getHealthFundStdCompNo(healthFund, validTimePoint);
            }
        }
        throw new IllegalArgumentException(String.valueOf(dser.getArtVersicherung()));
    }

    private String getHealthFundStdCompNo(HealthFund healthFund, Date validTimePoint) throws BusinessDomainException {
        HealthFund hf = HealthFund.getHealthFundConsiderFusions((HealthFund)healthFund, (Date)validTimePoint);
        return hf.getHealthFundTP(VDate.getDateMax(), VDate.getDateMax()).getStandardCompanyNumber();
    }

    private IEECompanyPlant getEECompanyPlant(Date validFrom) {
        if (this.mEECompanyPlant == null) {
            this.mEECompanyPlant = (IEECompanyPlant)UtilitiesManager.getBean((String)"eeCompanyPlant", IEECompanyPlant.class);
        }
        this.mEECompanyPlant.setEmployee(this.mEmployee.getEmployee());
        this.mEECompanyPlant.setEffectiveFrom(this.getEffectiveFrom());
        this.mEECompanyPlant.setValidFrom(validFrom);
        return this.mEECompanyPlant;
    }

    private IEmployeePersistencyManager getIEmployeePM() {
        return (IEmployeePersistencyManager)UtilitiesManager.getBean((String)"employeePersistencyManager", IEmployeePersistencyManager.class);
    }

    public String getCompanyDescription() throws BusinessDomainException {
        return this.mAagCompany.getPCompanyName();
    }

    public boolean isPreview() {
        return this.mPreview;
    }

    public void setPreview(boolean preview) {
        this.mPreview = preview;
    }

    public boolean isAffectedBySpecialAccess() {
        return this.mAffectedBySpecialAccess;
    }

    public void setAffectedBySpecialAccess(boolean affectedBySpecialAccess) {
        this.mAffectedBySpecialAccess = affectedBySpecialAccess;
    }

    protected AagEmployee getEmployee() {
        return this.mEmployee;
    }

    public List<String> getInsuranceNoBlackList() {
        if (this.mInsuranceNoBlackList == null) {
            this.mInsuranceNoBlackList = DeuvHelper.getInsuranceNoBlackList();
        }
        return this.mInsuranceNoBlackList;
    }
}

