/*
 * Decompiled with CFR 0.152.
 */
package hr.varial.accounting.domain.payment.zaba;

import com.varial.accounting.domain.bankaccount.IBankData;
import com.varial.accounting.domain.custsupaddress.CustSupAddress;
import com.varial.accounting.domain.factoringbase.FactoringHelper;
import com.varial.accounting.domain.financialyear.AccountingCompany;
import com.varial.accounting.domain.payment.PaymentDetailsHolder;
import com.varial.accounting.domain.payment.PaymentHelper;
import com.varial.accounting.domain.personalaccount.PersonalAccount;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.types.date.DateHelper;
import com.varial.framework.basictypes.addresses.IPostalAddress;
import com.varial.framework.basictypes.addresses.PostalAddress;
import com.varial.framework.domain.paymentbase.Payment;
import com.varial.framework.domain.paymentbase.PaymentSession;
import com.varial.interfaces.IBankAccount;
import com.varial.interfaces.ICurrency;
import com.varial.serverbase.domain.textoutput.BigDecimalField;
import com.varial.serverbase.domain.textoutput.IntegerField;
import com.varial.serverbase.domain.textoutput.LineGenerator;
import com.varial.serverbase.domain.textoutput.OutputLine;
import com.varial.serverbase.domain.textoutput.TextField;
import com.varial.serverbase.mapper.DateMapper;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZabaPaymentSessionLineGeneratorImpl
implements LineGenerator {
    private static Logger LOGGER = LoggerFactory.getLogger((String)ZabaPaymentSessionLineGeneratorImpl.class.getName());
    private final AccountingCompany mCompany;
    private final IBankAccount mCompanyBankAccount;
    private final PaymentSession[] mPaymentSessions;
    private final List<OutputLine> mDataList = new LinkedList<OutputLine>();
    private final OutputLine[] mDataLines;
    private final boolean mIsDirectDebit;
    private final BigDecimal mPaymentSum;
    private final BigInteger mBLZSum;
    private final BigInteger mKontoSum;
    private Date mExecutionDate;
    private final Payment[] mPayments;
    private OutputLine mHeadLine;
    private final OutputLine mEndLine;
    private final PaymentDetailsHolder mPaymentDetailsHolder;
    private final ICurrency mBaseCurrency;

    public ZabaPaymentSessionLineGeneratorImpl(PaymentSession[] sessions) throws BusinessDomainException {
        this.mPaymentSessions = sessions;
        this.mIsDirectDebit = PaymentHelper.isDirectDebit((PaymentSession)this.mPaymentSessions[0]);
        this.mPaymentDetailsHolder = PaymentHelper.getPaymentDetailsHolder((PaymentSession)this.mPaymentSessions[0]);
        this.mCompanyBankAccount = PaymentHelper.getIBankAccount((PaymentSession)this.mPaymentSessions[0]);
        this.mCompany = (AccountingCompany)this.mCompanyBankAccount.getCompany();
        this.mBaseCurrency = this.mCompany.getFinanceSetup().getBaseCurrency();
        this.mPayments = PaymentHelper.getPayments((PaymentSession)this.mPaymentSessions[0], (boolean)this.mIsDirectDebit);
        this.mExecutionDate = this.mPaymentSessions[0].getExecuteDate();
        if (this.mExecutionDate == null) {
            this.mExecutionDate = DateHelper.today();
        }
        Number[] noticeData = PaymentHelper.getNoticeData((Payment[])this.mPayments);
        this.mPaymentSum = (BigDecimal)noticeData[0];
        this.mBLZSum = (BigInteger)noticeData[1];
        this.mKontoSum = (BigInteger)noticeData[2];
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("mPayments.length: " + this.mPayments.length);
        }
        if (this.mPayments.length > 0) {
            this.mHeadLine = this.createHeadLine(this.mPayments[0].getCurrency());
            this.mDataList.add(this.createPayerLine(this.mPayments[0].getCurrency()));
        }
        for (int j = 0; j < this.mPayments.length; ++j) {
            this.mDataList.add(this.createPaymentLine(this.mPayments[j]));
        }
        this.mEndLine = this.createEndLine();
        this.mDataLines = new OutputLine[this.mDataList.size()];
        this.mDataList.toArray(this.mDataLines);
    }

    private OutputLine createEndLine() {
        LinkedList<Object> fieldList = new LinkedList<Object>();
        fieldList.add(new TextField(997, ' ', true, 0, ""));
        fieldList.add(new IntegerField(3, '0', false, 399));
        return PaymentHelper.getOutputLine(fieldList);
    }

    private OutputLine createPayerLine(ICurrency currency) throws BusinessDomainException {
        LinkedList<Object> fieldList = new LinkedList<Object>();
        fieldList.add(new TextField(21, ' ', true, 0, PaymentHelper.getIbanForElectronicFormat((String)this.mCompanyBankAccount.getOtherReference())));
        fieldList.add(new TextField(3, ' ', true, 0, currency.getSwift()));
        fieldList.add(new TextField(21, ' ', true, 0, ""));
        fieldList.add(new TextField(3, ' ', true, 0, ""));
        fieldList.add(new IntegerField(5, '0', false, this.mPayments.length));
        fieldList.add(new BigDecimalField(20, '0', false, 0, ',', this.mPaymentSum.setScale(2).movePointRight(2)));
        fieldList.add(new TextField(8, ' ', true, 0, DateMapper.toYYYYMMDDString((Date)this.mExecutionDate)));
        fieldList.add(new TextField(916, ' ', true, 0, ""));
        fieldList.add(new IntegerField(3, '0', false, 301));
        return PaymentHelper.getOutputLine(fieldList);
    }

    private OutputLine createHeadLine(ICurrency currency) throws BusinessDomainException {
        LinkedList<Object> fieldList = new LinkedList<Object>();
        fieldList.add(new TextField(8, ' ', true, 0, DateMapper.toYYYYMMDDString((Date)DateHelper.today())));
        int intValue = 3;
        if (PaymentHelper.isForeignPayment((PaymentSession)this.mPaymentSessions[0])) {
            intValue = 2;
        } else if (currency.getObjectid().equals(this.mBaseCurrency.getObjectid())) {
            intValue = 1;
        }
        fieldList.add(new IntegerField(1, '0', false, intValue));
        intValue = 701;
        if (this.mIsDirectDebit) {
            intValue = 300;
        }
        fieldList.add(new IntegerField(3, '0', false, intValue));
        fieldList.add(new TextField(985, ' ', true, 0, ""));
        fieldList.add(new IntegerField(3, '0', false, 300));
        return PaymentHelper.getOutputLine(fieldList);
    }

    public OutputLine getHeadline() {
        return this.mHeadLine;
    }

    public OutputLine[] getDataLines() {
        return this.mDataLines;
    }

    public OutputLine getEndline() {
        return this.mEndLine;
    }

    public boolean isDirectDebit() {
        return this.mIsDirectDebit;
    }

    public BigDecimal getPaymentSum() {
        return this.mPaymentSum;
    }

    public BigInteger getBLZSum() {
        return this.mBLZSum;
    }

    public BigInteger getKontoSum() {
        return this.mKontoSum;
    }

    public int getAnzahlDatensaetze() {
        return this.mPayments == null ? 0 : this.mPayments.length;
    }

    private OutputLine createPaymentLine(Payment payment) throws BusinessDomainException {
        LinkedList<Object> fieldList = new LinkedList<Object>();
        CustSupAddress custSupAddress = PaymentHelper.getCustSupAddress((Payment)payment);
        PostalAddress paymentAddress = custSupAddress.getPostalAddress();
        IBankData bankData = PaymentHelper.getBankData((Payment)payment);
        IPostalAddress bankAddress = null;
        if (bankData != null) {
            bankAddress = bankData.getPostalAddress();
        }
        String referenceString = PaymentHelper.getFixedOrFreePaymentDetailsAsString((Payment)payment, (int)140, (boolean)true, (PaymentDetailsHolder)this.mPaymentDetailsHolder);
        fieldList.add(new TextField(34, ' ', true, 0, PaymentHelper.getIbanForElectronicFormat((String)payment.getShortAddressOwner())));
        fieldList.add(new TextField(70, ' ', true, 0, FactoringHelper.checkField((String)paymentAddress.getName())));
        fieldList.add(new TextField(35, ' ', true, 0, FactoringHelper.checkField((String)paymentAddress.getStreet())));
        fieldList.add(new TextField(35, ' ', true, 0, paymentAddress.getPostalCode().concat(" ").concat(paymentAddress.getTown())));
        fieldList.add(new TextField(3, '0', false, 0, paymentAddress.getCountry().getCountryNumberAWV()));
        fieldList.add(new TextField(4, ' ', true, 0, ""));
        fieldList.add(new TextField(22, ' ', true, 0, ""));
        fieldList.add(new TextField(4, ' ', true, 0, ""));
        fieldList.add(new TextField(140, ' ', true, 0, referenceString));
        fieldList.add(new BigDecimalField(15, '0', false, 0, ',', payment.getAmount().setScale(2).movePointRight(2)));
        fieldList.add(new TextField(4, ' ', true, 0, ""));
        fieldList.add(new TextField(22, ' ', true, 0, ""));
        fieldList.add(new TextField(11, ' ', true, 0, payment.getSwift()));
        fieldList.add(new TextField(70, ' ', true, 0, payment.getBankName()));
        String value = "";
        if (bankAddress != null) {
            value = FactoringHelper.checkField((String)bankAddress.getStreet());
        }
        fieldList.add(new TextField(35, ' ', true, 0, value));
        if (bankAddress != null) {
            value = bankAddress.getPostalCode().concat(" ").concat(bankAddress.getTown());
        }
        fieldList.add(new TextField(35, ' ', true, 0, value));
        fieldList.add(new TextField(3, '0', false, 0, payment.getBankCountry().getCountryNumberAWV()));
        value = "0";
        if (PaymentHelper.isForeignPayment((PaymentSession)this.mPaymentSessions[0])) {
            value = "1";
        }
        fieldList.add(new TextField(value));
        fieldList.add(new TextField(3, ' ', true, 0, payment.getCurrency().getSwift()));
        PersonalAccount pa = PaymentHelper.getPersonalAccount((Payment)payment);
        int intValue = 0;
        if (pa != null) {
            switch (pa.getExpenseArrangementType().externalValue()) {
                case 1: {
                    intValue = 1;
                    break;
                }
                case 2: {
                    intValue = 2;
                    break;
                }
                case 0: {
                    intValue = 3;
                    break;
                }
            }
        }
        fieldList.add(new IntegerField(1, '0', false, intValue));
        fieldList.add(new IntegerField(1, '0', false, 0));
        fieldList.add(new TextField(449, ' ', true, 0, ""));
        fieldList.add(new IntegerField(3, '0', false, 309));
        return PaymentHelper.getOutputLine(fieldList);
    }
}

