/*
 * Decompiled with CFR 0.152.
 */
package de.varial.accounting.domain.dataexport;

import com.infor.igf.core.persistency.PersistencyContainer;
import com.infor.igf.core.types.PersistableEnum;
import com.infor.igf.core.util.PersistableEnumUtils;
import com.varial.accounting.domain.financialyear.AccountingCompany;
import com.varial.accounting.domain.nominalledger.NominalLedger;
import com.varial.accounting.domain.nominalledger.NominalLedgerTaxAccounts;
import com.varial.accounting.domain.nominalledger.NominalLedgerTaxAccountsPersistencyManager;
import com.varial.accounting.domain.taxcode.TaxCodePersistencyManager;
import com.varial.accounting.domain.taxcode.TaxRate;
import com.varial.accounting.domain.taxcode.TaxRatePersistencyManager;
import com.varial.accounting.persistency.taxcode.TaxcodeContainerInfo;
import com.varial.accounting.persistency.taxrate.ITaxrateDao;
import com.varial.accounting.persistency.taxrate.TaxrateContainer;
import com.varial.accounting.persistency.taxrate.TaxrateContainerInfo;
import com.varial.base.UtilitiesManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.PersistencyDataSet;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Order;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.common.persistency.global.country.CountryContainerInfo;
import com.varial.framework.domain.company.JurisdictionType;
import com.varial.serverbase.domain.language.LanguageManager;
import com.varial.serverbase.domain.textoutput.FieldSeparator;
import com.varial.serverbase.domain.textoutput.LineSeparator;
import com.varial.serverbase.mapper.ExceptionMapper;
import com.varial.serverbase.mapper.StringMapper;
import de.varial.accounting.domain.dataexport.BigDecimalExportColumn;
import de.varial.accounting.domain.dataexport.BooleanExportColumn;
import de.varial.accounting.domain.dataexport.DateExportColumn;
import de.varial.accounting.domain.dataexport.EnumExportColumn;
import de.varial.accounting.domain.dataexport.ExportColumn;
import de.varial.accounting.domain.dataexport.GdPdUExportTable;
import de.varial.accounting.domain.dataexport.LocalizedStringExportColumn;
import de.varial.accounting.domain.dataexport.TextExportColumn;
import de.varial.accounting.domain.taxcode.TaxCodeDE;
import de.varial.accounting.domain.taxcode.TaxRateDE;
import java.math.BigDecimal;

public class TaxCodeExportTable
extends GdPdUExportTable {
    private static final ITaxrateDao dao = (ITaxrateDao)UtilitiesManager.getBean((String)"taxrateDao", ITaxrateDao.class);
    private final TextExportColumn mCode;
    private final TextExportColumn mOidTaxCode;
    private final LocalizedStringExportColumn mDescription;
    private final BigDecimalExportColumn mTaxRate;
    private final TextExportColumn mOidTaxRate;
    private final EnumExportColumn mTaxType;
    private final DateExportColumn mValidFrom;
    private final BigDecimalExportColumn mBaseAmountPercent;
    private final BooleanExportColumn mIsActTaxation;
    private final TextExportColumn mISOCodeCountry;
    private final BooleanExportColumn mIsOneStopShop;
    private final EnumExportColumn mTaxTypeForSpeso;
    private final TextExportColumn mCodeInputTaxAcc;
    private final TextExportColumn mCodeInputNotDueAcc;
    private final TextExportColumn mCodeInputTaxPreAcc;
    private final TextExportColumn mCodeNonDeductTaxAcc;
    private final TextExportColumn mCodeOutputTaxAcc;
    private final TextExportColumn mCodeOutputNotDueAcc;
    private final TextExportColumn mCodeOutputTaxPreAcc;
    private NominalLedger mNominalLedger;

    public TaxCodeExportTable(FieldSeparator fieldSeparator, LineSeparator lineSeparator, char decimalPoint, String code, String description, String filename) {
        super(code, description, filename, fieldSeparator, lineSeparator, decimalPoint);
        TaxcodeContainerInfo taxCodeInfo = new TaxcodeContainerInfo();
        TaxrateContainerInfo taxRateInfo = new TaxrateContainerInfo();
        CountryContainerInfo countryInfo = new CountryContainerInfo();
        this.mCode = new TextExportColumn("Steuerschluessel", "Steuerschluessel", taxCodeInfo.getCode().getLength(), true);
        this.mOidTaxCode = new TextExportColumn("SteuerschluesselID", "ID Steuerschluessel", taxCodeInfo.getObjectid().getLength(), true);
        this.mDescription = new LocalizedStringExportColumn("Bezeichnung", "Bezeichnung", false, LanguageManager.getInstance().getDefaultLanguage(), "taxratels_T");
        this.mTaxRate = new BigDecimalExportColumn("Steuersatz", "Steuersatz", taxRateInfo.getRate().getLength(), true, taxRateInfo.getRate().getScale(), decimalPoint);
        this.mOidTaxRate = new TextExportColumn("SteuersatzID", "ID Steuersatz", taxRateInfo.getObjectid().getLength(), true);
        this.mTaxType = new EnumExportColumn("Steuertyp", "Steuertyp", new String[]{"Umsatzsteuer", "Mehrwertsteuer", "Vorsteuer", "EU-Lieferung", "EU-Erwerb", "Dreiecksgeschaeft", "Altteilsteuer", "Einfuhrumsatzsteuer", "Manuelle Steuer", "USt fuer Bauleistungen nach \u00a7 13b", "EU-Leistung"}, false);
        this.mValidFrom = new DateExportColumn("GueltigAb", "Gueltig ab", false);
        this.mBaseAmountPercent = new BigDecimalExportColumn("VStAbzug", "Vorsteuerabzug", taxRateInfo.getBaseamountpercent().getLength(), false, taxRateInfo.getBaseamountpercent().getScale(), decimalPoint);
        this.mIsActTaxation = new BooleanExportColumn("IstVerst", "Ist-Versteuerung", "Ja", "  ", false);
        this.mISOCodeCountry = new TextExportColumn("Land", "Land", countryInfo.getIsocode().getLength(), true);
        this.mIsOneStopShop = new BooleanExportColumn("OSS", "OneStopShop", "Ja", "  ", false);
        this.mTaxTypeForSpeso = new EnumExportColumn("Steuerart", "Steuerart", new String[]{"", "uneinbringlich"}, false);
        this.mCodeInputTaxAcc = new TextExportColumn("KtoVSt", "Konto VSt", taxCodeInfo.getCode().getLength(), false);
        this.mCodeInputNotDueAcc = new TextExportColumn("KtoVStNFaellig", "Konto VSt nicht faellig", taxCodeInfo.getCode().getLength(), false);
        this.mCodeInputTaxPreAcc = new TextExportColumn("KtoVStAnzahl", "Konto VSt fuer Anzahlungen", taxCodeInfo.getCode().getLength(), false);
        this.mCodeNonDeductTaxAcc = new TextExportColumn("KtoVStNAbziehb", "Konto VSt nicht abziehbar", taxCodeInfo.getCode().getLength(), false);
        this.mCodeOutputTaxAcc = new TextExportColumn("KtoMwSt", "Konto MwSt", taxCodeInfo.getCode().getLength(), false);
        this.mCodeOutputNotDueAcc = new TextExportColumn("KtoMwStNFaellig", "Konto MwSt nicht faellig", taxCodeInfo.getCode().getLength(), false);
        this.mCodeOutputTaxPreAcc = new TextExportColumn("KtoMwStAnzahl", "Konto MwSt fuer Anzahlungen", taxCodeInfo.getCode().getLength(), false);
        this.setColumns(new ExportColumn[]{this.mCode, this.mOidTaxCode, this.mDescription, this.mTaxRate, this.mOidTaxRate, this.mTaxType, this.mValidFrom, this.mBaseAmountPercent, this.mIsActTaxation, this.mISOCodeCountry, this.mIsOneStopShop, this.mTaxTypeForSpeso, this.mCodeInputTaxAcc, this.mCodeInputNotDueAcc, this.mCodeInputTaxPreAcc, this.mCodeNonDeductTaxAcc, this.mCodeOutputTaxAcc, this.mCodeOutputNotDueAcc, this.mCodeOutputTaxPreAcc});
    }

    protected PersistencyDataSet getDataSet() {
        try {
            AccountingCompany[] companies = this.getCompanyYears().getCompanies();
            if (companies != null) {
                this.mNominalLedger = companies[0].getFinanceSetup().getNominalLedger();
            }
            Criterion filter = Restrictions.eq((String)"jurisdiction", (String)PersistableEnumUtils.toSQLPropertyValue((PersistableEnum)JurisdictionType.DE));
            return dao.getDataSet(new Order[]{Order.asc((String)"code")}, filter);
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    protected void fillVisibleOutputFields(PersistencyContainer persistencyContainer) throws BusinessDomainException {
        TaxrateContainer container = (TaxrateContainer)persistencyContainer;
        TaxRateDE taxRate = (TaxRateDE)TaxRatePersistencyManager.getTaxRate((String)container.getObjectid());
        TaxCodeDE taxCode = (TaxCodeDE)TaxCodePersistencyManager.getTaxCode((String)container.oidtaxcode);
        if (this.mCode.getIsVsisible()) {
            if (taxRate != null && taxCode != null) {
                this.mCode.setText(taxCode.getCode());
            } else {
                this.mCode.setText("");
            }
        }
        if (this.mOidTaxCode.getIsVsisible()) {
            if (!StringMapper.isNullString((String)container.oidtaxcode)) {
                this.mOidTaxCode.setText(container.oidtaxcode);
            } else {
                this.mOidTaxCode.setText("");
            }
        }
        if (this.mDescription.getIsVsisible()) {
            if (taxRate != null) {
                this.mDescription.setText(taxRate.getDescription(LanguageManager.getInstance().getDefaultLanguage()));
            } else {
                this.mDescription.setText("");
            }
        }
        if (this.mTaxRate.getIsVsisible()) {
            if (taxRate != null) {
                this.mTaxRate.setBigDecimal(taxRate.getRate());
            } else {
                this.mTaxRate.setBigDecimal(BigDecimal.ZERO);
            }
        }
        if (this.mOidTaxRate.getIsVsisible()) {
            if (!StringMapper.isNullString((String)container.getObjectid())) {
                this.mOidTaxRate.setText(container.getObjectid());
            } else {
                this.mOidTaxRate.setText("");
            }
        }
        if (this.mTaxType.getIsVsisible() && taxCode != null) {
            this.mTaxType.setValue(taxCode.getTaxTypeDE().value());
        }
        if (this.mValidFrom.getIsVsisible()) {
            if (taxRate != null) {
                this.mValidFrom.setDate(taxRate.getValidFrom());
            } else {
                this.mValidFrom.setDate(null);
            }
        }
        if (this.mBaseAmountPercent.getIsVsisible()) {
            if (taxRate != null) {
                this.mBaseAmountPercent.setBigDecimal(taxRate.getTaxDeductionPercent());
            } else {
                this.mBaseAmountPercent.setBigDecimal(BigDecimal.ZERO);
            }
        }
        if (this.mIsActTaxation.getIsVsisible() && taxRate != null) {
            this.mIsActTaxation.setBoolean(taxRate.getIsActTaxation());
        }
        if (this.mIsOneStopShop.getIsVsisible() && taxRate != null) {
            this.mIsOneStopShop.setBoolean(taxRate.isOneStopShop());
        }
        if (this.mISOCodeCountry.getIsVsisible()) {
            if (taxRate != null && taxCode != null && taxCode.getCountry() != null) {
                this.mISOCodeCountry.setText(taxCode.getCountry().getIsoCode());
            } else {
                this.mISOCodeCountry.setText("");
            }
        }
        if (this.mTaxTypeForSpeso.getIsVsisible()) {
            if (taxRate != null && taxRate.getTypeOfTaxes() != null) {
                this.mTaxTypeForSpeso.setValue(taxRate.getTypeOfTaxes().externalValue());
            } else {
                this.mTaxTypeForSpeso.setValue(0);
            }
        }
        NominalLedgerTaxAccounts taxAccounts = null;
        if (this.mNominalLedger != null) {
            taxAccounts = NominalLedgerTaxAccountsPersistencyManager.getNominalLedgerTaxAccounts(this.mNominalLedger, (TaxRate)taxRate);
        }
        if (this.mCodeInputTaxAcc.getIsVsisible()) {
            if (taxAccounts != null && taxAccounts.getInputTaxAccount() != null) {
                this.mCodeInputTaxAcc.setText(taxAccounts.getInputTaxAccount().getCode());
            } else {
                this.mCodeInputTaxAcc.setText("");
            }
        }
        if (this.mCodeInputNotDueAcc.getIsVsisible()) {
            if (taxAccounts != null && taxAccounts.getNotDueInputTaxAccount() != null) {
                this.mCodeInputNotDueAcc.setText(taxAccounts.getNotDueInputTaxAccount().getCode());
            } else {
                this.mCodeInputNotDueAcc.setText("");
            }
        }
        if (this.mCodeInputTaxPreAcc.getIsVsisible()) {
            if (taxAccounts != null && taxAccounts.getInputTaxPrepaymentAccount() != null) {
                this.mCodeInputTaxPreAcc.setText(taxAccounts.getInputTaxPrepaymentAccount().getCode());
            } else {
                this.mCodeInputTaxPreAcc.setText("");
            }
        }
        if (this.mCodeNonDeductTaxAcc.getIsVsisible()) {
            if (taxAccounts != null && taxAccounts.getNonDeductibleInputTaxAccount() != null) {
                this.mCodeNonDeductTaxAcc.setText(taxAccounts.getNonDeductibleInputTaxAccount().getCode());
            } else {
                this.mCodeNonDeductTaxAcc.setText("");
            }
        }
        if (this.mCodeOutputTaxAcc.getIsVsisible()) {
            if (taxAccounts != null && taxAccounts.getOutputTaxAccount() != null) {
                this.mCodeOutputTaxAcc.setText(taxAccounts.getOutputTaxAccount().getCode());
            } else {
                this.mCodeOutputTaxAcc.setText("");
            }
        }
        if (this.mCodeOutputNotDueAcc.getIsVsisible()) {
            if (taxAccounts != null && taxAccounts.getNotDueOutputTaxAccount() != null) {
                this.mCodeOutputNotDueAcc.setText(taxAccounts.getNotDueOutputTaxAccount().getCode());
            } else {
                this.mCodeOutputNotDueAcc.setText("");
            }
        }
        if (this.mCodeOutputTaxPreAcc.getIsVsisible()) {
            if (taxAccounts != null && taxAccounts.getOutputTaxPrepaymentAccount() != null) {
                this.mCodeOutputTaxPreAcc.setText(taxAccounts.getOutputTaxPrepaymentAccount().getCode());
            } else {
                this.mCodeOutputTaxPreAcc.setText("");
            }
        }
    }
}

