/*
 * Decompiled with CFR 0.152.
 */
package com.varial.framework.servantimpl.advisor;

import com.infor.igf.ca.model.accountingclerk.AccountingClerkFilterModel;
import com.infor.igf.ca.model.accountingclerk.AccountingClerkModel;
import com.infor.igf.ca.model.common.ObjectIdentifierModel;
import com.varial.administration.servantimpl.AdministrationRightList;
import com.varial.administration.servantimpl.gdpr.GDPRAnonymizationValueManager;
import com.varial.administration.servantimpl.gdpr.GDPRCallbackImpl;
import com.varial.base.UtilitiesManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Junction;
import com.varial.base.persistency.criterion.Order;
import com.varial.base.security.AuthorizationToken;
import com.varial.base.service.AbstractApplicationService;
import com.varial.base.service.LazyRunnableHolder;
import com.varial.framework.advisor.AdvisorStructCallback;
import com.varial.framework.basictypes.ReportFileStructCallback;
import com.varial.framework.domain.advisor.Advisor;
import com.varial.framework.domain.advisor.AdvisorPersistencyManager;
import com.varial.framework.domain.advisor.GDPRAdvisorPersistentObject;
import com.varial.framework.domain.advisor.IAdvisor;
import com.varial.framework.domain.advisor.export.AdvisorCSVExport;
import com.varial.framework.domain.advisor.export.CSVExportable;
import com.varial.framework.domain.advisor.export.CSVExporter;
import com.varial.framework.domain.company.CompanyPersistencyManager;
import com.varial.framework.domain.gdpr.GDPRData;
import com.varial.framework.domain.gdpr.GDPRExceptionMapper;
import com.varial.framework.domain.gdpr.GDPRUserData;
import com.varial.framework.domain.gdpr.commands.GDPRCommandManager;
import com.varial.framework.domain.gdpr.commands.IGDPRCommandManager;
import com.varial.framework.domain.gdpr.criteriondata.IGDPRPersistentObject;
import com.varial.framework.domain.gdpr.report.GDPRReportData;
import com.varial.framework.servantimpl.FrameworkRightList;
import com.varial.framework.servantimpl.advisor.AccountingClerkMapper;
import com.varial.framework.servantimpl.advisor.AdvisorQueryCommand;
import com.varial.framework.servantimpl.advisor.AdvisorServantService;
import com.varial.serverbase.domain.user.IUser;
import com.varial.serverbase.domain.user.IUserPersistencyManager;
import com.varial.serverbase.domain.user.User;
import com.varial.serverbase.mapper.ExceptionMapper;
import com.varial.serverbase.mapper.StringMapper;
import java.util.List;
import java.util.function.Function;

public class AdvisorServantImpl
extends AbstractApplicationService
implements AdvisorServantService {
    private static final IUserPersistencyManager userPersistencyManager = (IUserPersistencyManager)UtilitiesManager.getBean((String)"userPersistencyManager", IUserPersistencyManager.class);
    private final Function<String, IUser> getUserFunction = oidUser -> userPersistencyManager.getUser(oidUser);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AccountingClerkModel> getAdvisors(AuthorizationToken token, String oidCompany) throws BusinessDomainException {
        try {
            token.checkAccess(FrameworkRightList.getGetAdvisorRight(), oidCompany);
            this.beginQueryService();
            Advisor[] advisors = Advisor.getAdvisors((String)oidCompany);
            List<AccountingClerkModel> list = AccountingClerkMapper.getInstance().toModel((IAdvisor[])advisors);
            return list;
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccountingClerkModel getAdvisorByCode(AuthorizationToken token, String oidCompany, String code) throws BusinessDomainException {
        try {
            token.checkAccess(FrameworkRightList.getGetAdvisorRight(), oidCompany);
            this.beginQueryService();
            Advisor advisor = Advisor.getAdvisorByCode((String)oidCompany, (String)code);
            if (advisor == null) {
                throw ExceptionMapper.makeDataNotFoundPersistencyException((String)code);
            }
            AccountingClerkModel accountingClerkModel = new AccountingClerkModel((IAdvisor)advisor);
            return accountingClerkModel;
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccountingClerkModel createAdvisor(AuthorizationToken token, AccountingClerkModel in) throws BusinessDomainException {
        try {
            token.checkAccess(FrameworkRightList.getCreateAdvisorRight(), in.getOidCompany());
            this.beginUpdateService();
            Advisor bo = new Advisor(CompanyPersistencyManager.getCompany((String)in.getOidCompany()));
            if (in.getUser().isPresent() && in.isCostCentreHead()) {
                AccountingClerkMapper.getInstance().checkUserIsStillInUseInAnotherAdvisor(in);
            }
            AccountingClerkMapper.getInstance().fillBO((IAdvisor)bo, in, this.getUserFunction);
            this.getContext().flush();
            AccountingClerkModel accountingClerkModel = new AccountingClerkModel((IAdvisor)bo);
            return accountingClerkModel;
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccountingClerkModel setAdvisor(AuthorizationToken token, AccountingClerkModel in) throws BusinessDomainException {
        try {
            token.checkAccess(FrameworkRightList.getCreateAdvisorRight(), in.getOidCompany());
            this.beginUpdateService();
            Advisor advisor = new Advisor(in.getIdent().getObjectID(), in.getIdent().getVersion());
            if (in.isAccessTorAllCostCentres() != advisor.getIsLeaderForAllCostCentres() || in.isCostCentreHead() != advisor.getIsLeaderForCostCentre()) {
                token.checkAccess(FrameworkRightList.setAdvisorAccessForCostCentreRight(), in.getOidCompany());
            }
            if (!in.isCostCentreHead() && advisor.getIsLeaderForCostCentre()) {
                AccountingClerkMapper.getInstance().checkAdvisorForCostCentreUse((IAdvisor)advisor);
            }
            if (advisor.getUser() != null && in.getUser().isPresent() && in.isCostCentreHead()) {
                AccountingClerkMapper.getInstance().checkUserIsStillInUseInAnotherAdvisor(in);
            }
            AccountingClerkMapper.getInstance().fillBO((IAdvisor)advisor, in, this.getUserFunction);
            this.getContext().flush();
            AccountingClerkModel accountingClerkModel = new AccountingClerkModel((IAdvisor)advisor);
            return accountingClerkModel;
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAdvisor(AuthorizationToken token, String oidCompany, List<ObjectIdentifierModel> oidTs) throws BusinessDomainException {
        try {
            token.checkAccess(FrameworkRightList.getCreateAdvisorRight(), oidCompany);
            this.beginUpdateService();
            for (ObjectIdentifierModel objectIdentifierModel : oidTs) {
                Advisor bo = new Advisor(objectIdentifierModel.getObjectID(), objectIdentifierModel.getVersion());
                token.checkAccess(FrameworkRightList.getCreateAdvisorRight(), bo.getAccountingCompany().getObjectid());
                if (bo.getIsLeaderForCostCentre()) {
                    AccountingClerkMapper.getInstance().checkAdvisorForCostCentreUse((IAdvisor)bo);
                }
                bo.destroy();
            }
            this.getContext().flush();
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccountingClerkModel getAdvisor(AuthorizationToken token, String oidCompany, String oidAdvisor) throws BusinessDomainException {
        try {
            token.checkAccess(FrameworkRightList.getGetAdvisorRight(), oidCompany);
            this.beginQueryService();
            Advisor advisor = AdvisorPersistencyManager.getAdvisor((String)oidAdvisor);
            AccountingClerkModel accountingClerkModel = new AccountingClerkModel((IAdvisor)advisor);
            return accountingClerkModel;
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getAdvisorsByFilter(AuthorizationToken token, AccountingClerkFilterModel filterModel, AdvisorStructCallback callback, LazyRunnableHolder lazyHolder) throws BusinessDomainException {
        try {
            this.beginQueryService();
            int maxRows = 50;
            Junction filter = AccountingClerkMapper.getInstance().makeFilter(filterModel);
            AdvisorQueryCommand command = new AdvisorQueryCommand(token, Order.CODE_ASCENDING, (Criterion)filter, callback, 50);
            lazyHolder.setStandardRunnable((Runnable)command);
            return;
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AccountingClerkModel> getAdvisorsByFilter(AuthorizationToken token, AccountingClerkFilterModel filterModel) throws BusinessDomainException {
        try {
            this.beginQueryService();
            Junction filter = AccountingClerkMapper.getInstance().makeFilter(filterModel);
            User user = userPersistencyManager.getUser(token.getUserObjectId());
            AccountingClerkMapper.addAdditionalAccessFilter(filter, user);
            Advisor[] advisors = AdvisorPersistencyManager.getAdvisors((Criterion)filter);
            List<AccountingClerkModel> list = AccountingClerkMapper.getInstance().toModel((IAdvisor[])advisors);
            return list;
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void anonymizeAdvisor(AuthorizationToken token, String oidAdvisor, String oidGlobalLanguage, ReportFileStructCallback callback, String printTime, LazyRunnableHolder lazyHolder) throws BusinessDomainException {
        try {
            token.checkAccess(AdministrationRightList.getGetGDPRRight());
            this.beginQueryService();
            Advisor advisor = this.getAdvisor(oidAdvisor);
            GDPRAdvisorPersistentObject criterionUserPersistentObject = new GDPRAdvisorPersistentObject(advisor);
            GDPRAnonymizationValueManager anonymizationValueManager = (GDPRAnonymizationValueManager)UtilitiesManager.getBean((String)"gdprAnonymizationValueManager", GDPRAnonymizationValueManager.class);
            String anonymizationValue = anonymizationValueManager.getNextAnonymizationValue(GDPRAnonymizationValueManager.AnonymizationType.ADVISOR);
            GDPRUserData userData = new GDPRUserData(true, advisor.getIsLeaderForCostCentre(), false, false, false, false);
            GDPRData gdprData = new GDPRData((IGDPRPersistentObject)criterionUserPersistentObject, anonymizationValue, userData, new GDPRReportData(oidGlobalLanguage, printTime, token.getUserId()));
            IGDPRCommandManager commandManager = (IGDPRCommandManager)UtilitiesManager.getBean((String)"gdprAdvisorCommandManager", GDPRCommandManager.class);
            commandManager.validate(gdprData);
            GDPRCallbackImpl command = new GDPRCallbackImpl(token, callback, gdprData, commandManager);
            lazyHolder.setStandardRunnable((Runnable)command);
        }
        finally {
            this.endService();
        }
    }

    private Advisor getAdvisor(String oidAdvisor) throws BusinessDomainException {
        Advisor advisor = null;
        if (!StringMapper.isNullString((String)oidAdvisor)) {
            advisor = AdvisorPersistencyManager.getAdvisor((String)oidAdvisor);
        }
        if (advisor == null) {
            throw GDPRExceptionMapper.makeAdvisorIsMissingDomainException();
        }
        return advisor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportAdvisor(AuthorizationToken token, String oidCompany, String oidAdvisor, String oidGlobalLanguage, ReportFileStructCallback callback, LazyRunnableHolder lazyRunnable) throws BusinessDomainException {
        try {
            token.checkAccess(FrameworkRightList.getExportAdvisorRight(), oidCompany);
            this.beginQueryService();
            Advisor advisor = AdvisorPersistencyManager.getAdvisor((String)oidAdvisor);
            AdvisorCSVExport export = new AdvisorCSVExport(advisor);
            CSVExporter command = new CSVExporter(callback, token, (CSVExportable)export);
            lazyRunnable.setLowPriorityRunnable((Runnable)command);
            return;
        }
        finally {
            this.endService();
        }
    }
}

