/*
 * Decompiled with CFR 0.152.
 */
package com.varial.framework.servantimpl.advisor;

import com.infor.igf.ca.mapper.SimpleModelMapper;
import com.infor.igf.ca.model.accountingclerk.AccountingClerkFilterModel;
import com.infor.igf.ca.model.accountingclerk.AccountingClerkModel;
import com.infor.igf.ca.model.user.UserModel;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.criterion.Conjunction;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Junction;
import com.varial.base.persistency.criterion.MatchMode;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.persistency.criterion.SubSelect;
import com.varial.base.persistency.criterion.Subqueries;
import com.varial.framework.domain.advisor.AdvisorExceptionMapper;
import com.varial.framework.domain.advisor.AdvisorPersistencyManager;
import com.varial.framework.domain.advisor.IAdvisor;
import com.varial.framework.domain.company.CompanyPersistencyManager;
import com.varial.serverbase.domain.language.ILanguage;
import com.varial.serverbase.domain.language.LanguageManager;
import com.varial.serverbase.domain.user.IUser;
import com.varial.serverbase.domain.user.User;
import com.varial.serverbase.mapper.BooleanMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public class AccountingClerkMapper {
    private AccountingClerkMapper() {
    }

    public static AccountingClerkMapper getInstance() {
        return SingletonHelper.INSTANCE;
    }

    public List<AccountingClerkModel> toModel(IAdvisor[] in) {
        if (in == null) {
            return new ArrayList<AccountingClerkModel>();
        }
        return Arrays.stream(in).map(AccountingClerkModel::new).collect(Collectors.toList());
    }

    public Optional<AccountingClerkModel> toOptionalModel(IAdvisor in) {
        return Optional.ofNullable(in != null ? new AccountingClerkModel(in) : null);
    }

    public void fillBO(IAdvisor bo, AccountingClerkModel model, Function<String, IUser> getUserFunction) throws BusinessDomainException {
        bo.setAccountingCompany(CompanyPersistencyManager.getCompany((String)model.getOidCompany()));
        bo.setCode(model.getCode());
        bo.setName(model.getName());
        bo.setUser((IUser)model.getUser().map(user -> (IUser)getUserFunction.apply(user.getIdent().getObjectID())).orElse(null));
        bo.setDepartment(SimpleModelMapper.getInstance().toString(model.getDepartment()));
        bo.setEmail(SimpleModelMapper.getInstance().toString(model.getEmail()));
        bo.setPhone(SimpleModelMapper.getInstance().toString(model.getPhone()));
        bo.setLanguage((ILanguage)model.getOidLanguage().map(oidLanguage -> LanguageManager.getInstance().getLanguage(oidLanguage)).orElse(null));
        bo.setPasswd(SimpleModelMapper.getInstance().toString(model.getPassword()));
        bo.setNote(SimpleModelMapper.getInstance().toString(model.getNotes()));
        bo.setIsLeaderForCostCentre(model.isCostCentreHead());
        bo.setIsLeaderForAllCostCentres(model.isAccessTorAllCostCentres());
    }

    public static void addAdditionalAccessFilter(Junction filter, User user) {
        if (user.getOnlyAdvisor()) {
            filter.add(Restrictions.eq((String)"OIDUSER", (String)user.getObjectid()));
        }
    }

    public Junction makeFilter(AccountingClerkFilterModel filter) {
        Conjunction junction = Restrictions.conjunction();
        junction.add(Restrictions.eq((String)"OIDCOMPANY", (String)filter.getOidCompany()));
        SimpleModelMapper.getInstance().trim(filter.getCode()).ifPresent(arg_0 -> AccountingClerkMapper.lambda$makeFilter$2((Junction)junction, arg_0));
        SimpleModelMapper.getInstance().trim(filter.getName()).ifPresent(arg_0 -> AccountingClerkMapper.lambda$makeFilter$3((Junction)junction, arg_0));
        filter.isCostCentreHead().ifPresent(arg_0 -> AccountingClerkMapper.lambda$makeFilter$4((Junction)junction, arg_0));
        filter.isAccessTorAllCostCentres().ifPresent(arg_0 -> AccountingClerkMapper.lambda$makeFilter$5((Junction)junction, arg_0));
        return junction;
    }

    public void checkAdvisorForCostCentreUse(IAdvisor advisor) throws BusinessDomainException {
        if (AdvisorPersistencyManager.isInUseAsCostCentreLeaderInCosting((IAdvisor)advisor)) {
            throw AdvisorExceptionMapper.makeAdvisorIsInUseAsCostCentreLeaderDomainException();
        }
        if (AdvisorPersistencyManager.isInUseAsAccessToOneOrMoreCostCentresInCosting((IAdvisor)advisor)) {
            throw AdvisorExceptionMapper.makeAdvisorHasAccessToOneOrMoreCostCentresDomainException();
        }
    }

    public void checkUserIsStillInUseInAnotherAdvisor(AccountingClerkModel model) throws BusinessDomainException {
        if (AdvisorPersistencyManager.isStillInUseAsUserInAnotherAdvisor((String)model.getIdent().getObjectID(), (String)((UserModel)model.getUser().get()).getIdent().getObjectID(), (String)model.getOidCompany())) {
            throw AdvisorExceptionMapper.makeUserIsStillInUseForAnotherAdvisorDomainException();
        }
    }

    private static /* synthetic */ void lambda$makeFilter$5(Junction junction, Boolean element) {
        junction.add(Restrictions.eq((String)"ISLEADERALLCENTRES", (String)BooleanMapper.toString((Boolean)element)));
    }

    private static /* synthetic */ void lambda$makeFilter$4(Junction junction, Boolean element) {
        junction.add(Restrictions.eq((String)"ISLEADERFORCENTRE", (String)BooleanMapper.toString((Boolean)element)));
    }

    private static /* synthetic */ void lambda$makeFilter$3(Junction junction, String element) {
        junction.add((Criterion)Restrictions.disjunction((Criterion[])new Criterion[]{Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.isNull((String)"OIDUSER"), Restrictions.like((String)"NAME", (String)element, (MatchMode)MatchMode.START)}), Subqueries.exists((SubSelect)new SubSelect("SELECT USER_T.OBJECTID FROM USER_T", (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eqProperty((String)"ADVISOR_T.OIDUSER", (String)"USER_T.OBJECTID"), Restrictions.like((String)"USER_T.NAME", (String)element, (MatchMode)MatchMode.START)})))}));
    }

    private static /* synthetic */ void lambda$makeFilter$2(Junction junction, String element) {
        junction.add(Restrictions.like((String)"CODE", (String)element, (MatchMode)MatchMode.START));
    }

    private static class SingletonHelper {
        private static final AccountingClerkMapper INSTANCE = new AccountingClerkMapper();

        private SingletonHelper() {
        }
    }
}

