/*
 * Decompiled with CFR 0.152.
 */
package com.varial.framework.domain.payment.sepa.data;

import com.varial.framework.domain.country.ICountry;
import com.varial.framework.domain.payment.sepa.data.PartyData;
import com.varial.framework.domain.payment.sepa.data.PaymentData;
import com.varial.framework.domain.payment.sepa.data.SepaLocalInstrumentTypeEnum;
import com.varial.framework.domain.payment.sepa.data.SepaSequenceTypeEnum;
import com.varial.framework.domain.payment.sepa.data.SepaServiceLevelTypeEnum;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class PaymentInfoData {
    private SepaServiceLevelTypeEnum serviceLevelType;
    private SepaLocalInstrumentTypeEnum localInstrumentType;
    private SepaSequenceTypeEnum sequenceType;
    private String paymentInfoID;
    private PartyData partyData;
    private String companyIban;
    private String companyBic;
    private String companyBankSortingCode;
    private Date requestedExecutionDate;
    private int numberOfTransactions;
    private BigDecimal controlSum;
    private String categoryPurpose;
    private ICountry bankAccountCountry;
    private List<PaymentData> payments;

    public Date getRequestedExecutionDate() {
        return this.requestedExecutionDate;
    }

    public void setRequestedExecutionDate(Date requestedExecutionDate) {
        this.requestedExecutionDate = requestedExecutionDate;
    }

    public String getPaymentInfoID() {
        return this.paymentInfoID;
    }

    public void setPaymentInfoID(String paymentInfoID) {
        this.paymentInfoID = paymentInfoID;
    }

    public String getBankSortingCode() {
        return this.companyBankSortingCode;
    }

    public void setBankSortingCode(String bankSortingCode) {
        this.companyBankSortingCode = bankSortingCode;
    }

    public String getCompanyBic() {
        return this.companyBic;
    }

    public void setCompanyBic(String bic) {
        this.companyBic = bic;
    }

    public PartyData getPartyData() {
        return this.partyData;
    }

    public void setPartyData(PartyData partyData) {
        this.partyData = partyData;
    }

    public String getCompanyIban() {
        return this.companyIban;
    }

    public void setCompanyIban(String iban) {
        this.companyIban = iban;
    }

    public BigDecimal getControlSum() {
        return this.controlSum.setScale(2, RoundingMode.HALF_DOWN);
    }

    public void addControlSum(BigDecimal controlSum) {
        if (this.controlSum == null) {
            this.controlSum = BigDecimal.ZERO;
        }
        this.controlSum = this.controlSum.add(controlSum);
    }

    public int getNumberOfTransactions() {
        return this.numberOfTransactions;
    }

    public void addNumberOfTransactions() {
        ++this.numberOfTransactions;
    }

    public void setNumberOfTransactions(int numberOfTransactions) {
        this.numberOfTransactions = numberOfTransactions;
    }

    public List<PaymentData> getPayments() {
        if (this.payments == null) {
            this.payments = new ArrayList<PaymentData>();
        }
        return this.payments;
    }

    public SepaSequenceTypeEnum getSequenceType() {
        return this.sequenceType;
    }

    public void setSequenceType(SepaSequenceTypeEnum sequenceType) {
        this.sequenceType = sequenceType;
    }

    public SepaLocalInstrumentTypeEnum getSepaLocalInstrumentType() {
        return this.localInstrumentType;
    }

    public void setSepaLocalInstrumentType(SepaLocalInstrumentTypeEnum localInstrumentType) {
        this.localInstrumentType = localInstrumentType;
    }

    public SepaServiceLevelTypeEnum getServiceLevelType() {
        return this.serviceLevelType;
    }

    public void setServiceLevelType(SepaServiceLevelTypeEnum serviceLevelType) {
        this.serviceLevelType = serviceLevelType;
    }

    public String getCategoryPurpose() {
        return this.categoryPurpose;
    }

    public void setCategoryPurpose(String categoryPurpose) {
        this.categoryPurpose = categoryPurpose;
    }

    public ICountry getBankAccountCountry() {
        return this.bankAccountCountry;
    }

    public void setBankAccountCountry(ICountry bankAccountCountry) {
        this.bankAccountCountry = bankAccountCountry;
    }
}

