/*
 * Decompiled with CFR 0.152.
 */
package com.varial.assetaccounting.servantimpl.fixedassetreport;

import com.varial.assetaccounting.domain.fixedassetreport.FixedAssetReportFilterMapper;
import com.varial.assetaccounting.fixedassetreport.FixedAssetReportFilterStruct;
import com.varial.assetaccounting.fixedassetreport.PrintTypePLEnum;
import com.varial.base.persistency.criterion.Conjunction;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Junction;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.persistency.criterion.SubSelect;
import com.varial.base.persistency.criterion.Subqueries;
import com.varial.serverbase.mapper.StringMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssetRegisterReportMapper {
    private static Logger LOGGER = LoggerFactory.getLogger((String)AssetRegisterReportMapper.class.getName());

    public static Criterion fillQueryFilter(FixedAssetReportFilterStruct filter) {
        LOGGER.debug("fillQueryFilter(...)");
        Junction junctionForSubSelect = Restrictions.conjunction().add((Criterion)Restrictions.eqProperty((String)"oidfixedasset", (String)"fa.objectid"));
        if (filter.areaShortSeq.length > 0) {
            junctionForSubSelect.add(Restrictions.eq((String)"oiddeprearea", (String)filter.areaShortSeq[0].oidTs.objectid));
        }
        if (filter.fixedAssetReportType.assetRegisterFilter().printType == PrintTypePLEnum.PTPE_ADDITIONS) {
            junctionForSubSelect.add(Restrictions.in((String)"transactenum", (String[])new String[]{"00", "02", "03", "25"}));
        } else if (filter.fixedAssetReportType.assetRegisterFilter().printType == PrintTypePLEnum.PTPE_DISPOSALS) {
            junctionForSubSelect.add(Restrictions.in((String)"transactenum", (String[])new String[]{"19", "20"}));
        }
        if (filter.fixedAssetReportType.assetRegisterFilter().printType == PrintTypePLEnum.PTPE_ADDITIONS || filter.fixedAssetReportType.assetRegisterFilter().printType == PrintTypePLEnum.PTPE_DISPOSALS) {
            if (!StringMapper.isNullString((String)filter.fixedAssetReportType.assetRegisterFilter().fromProcessingDate)) {
                junctionForSubSelect.add(Restrictions.ge((String)"processingdate", (String)filter.fixedAssetReportType.assetRegisterFilter().fromProcessingDate));
            }
            if (!StringMapper.isNullString((String)filter.fixedAssetReportType.assetRegisterFilter().toProcessingDate)) {
                junctionForSubSelect.add(Restrictions.le((String)"processingdate", (String)filter.fixedAssetReportType.assetRegisterFilter().toProcessingDate));
            }
        }
        SubSelect subSelect = new SubSelect("select objectid from fatransaction_T", (Criterion)junctionForSubSelect);
        Conjunction junction = Restrictions.conjunction((Criterion[])new Criterion[]{Subqueries.exists((SubSelect)subSelect)});
        String[] dontUseFields = new String[]{FixedAssetReportFilterMapper.getField((int)7), FixedAssetReportFilterMapper.getField((int)26), FixedAssetReportFilterMapper.getField((int)27), FixedAssetReportFilterMapper.getField((int)28), FixedAssetReportFilterMapper.getField((int)29), FixedAssetReportFilterMapper.getField((int)30), FixedAssetReportFilterMapper.getField((int)31), FixedAssetReportFilterMapper.getField((int)32), FixedAssetReportFilterMapper.getField((int)33), FixedAssetReportFilterMapper.getField((int)34), FixedAssetReportFilterMapper.getField((int)35)};
        for (int i = 0; i < filter.filtersSeq.length; ++i) {
            if (!filter.filtersSeq[i].attributeCode.equals(FixedAssetReportFilterMapper.getField((int)5))) continue;
            filter.filtersSeq[i].attributeCode = "FA.RETIREMENTDATE";
        }
        junction = FixedAssetReportFilterMapper.fillQueryFilter((FixedAssetReportFilterStruct)filter, (Junction)junction, (String[])dontUseFields, (boolean)false);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Created filter : {}", (Object)junction.toString());
        }
        return junction;
    }
}

