/*
 * Decompiled with CFR 0.152.
 */
package com.varial.assetaccounting.domain.fixedassetreport.quickchangeattributes;

import com.varial.accounting.domain.financialyear.AccountingCompany;
import com.varial.accounting.domain.nominalledger.NLAccountCompanySetting;
import com.varial.accounting.domain.nominalledger.NominalLedgerAccount;
import com.varial.accounting.domain.nominalledger.NominalLedgerItemPersistencyManager;
import com.varial.accounting.domain.personalaccount.PersonalAccount;
import com.varial.accounting.domain.personalaccount.PersonalAccountPersistencyManager;
import com.varial.assetaccounting.calculationmethod.DepreciationTypeEnum;
import com.varial.assetaccounting.depreciationarea.DepreciationFromUntilEnum;
import com.varial.assetaccounting.depreciationarea.FullDisposDeprecUntilEnum;
import com.varial.assetaccounting.domain.accountgroup.AccountGroup;
import com.varial.assetaccounting.domain.accountgroup.AccountGroupPersistencyManager;
import com.varial.assetaccounting.domain.assetaccsetup.AssetaccountingSetup;
import com.varial.assetaccounting.domain.calculationmethod.CalcMethod;
import com.varial.assetaccounting.domain.calculationmethod.CalcMethodPersistencyManager;
import com.varial.assetaccounting.domain.calculationmethod.DepreciationMethodData;
import com.varial.assetaccounting.domain.calculationmethod.DepreciationPlanMethodData;
import com.varial.assetaccounting.domain.fafinancialyear.FAFinancialYear;
import com.varial.assetaccounting.domain.falocation.Falocation;
import com.varial.assetaccounting.domain.falocation.FalocationPersistencyManager;
import com.varial.assetaccounting.domain.faperson.FAPerson;
import com.varial.assetaccounting.domain.faperson.FAPersonPersistencyManager;
import com.varial.assetaccounting.domain.faproject.FAProject;
import com.varial.assetaccounting.domain.faproject.FAProjectPersistencyManager;
import com.varial.assetaccounting.domain.fixedasset.AssetTypeMapper;
import com.varial.assetaccounting.domain.fixedasset.FACostCentre;
import com.varial.assetaccounting.domain.fixedasset.FATransactionSequenceNoPersistencyManager;
import com.varial.assetaccounting.domain.fixedasset.FixedAsset;
import com.varial.assetaccounting.domain.fixedasset.FixedAssetArea;
import com.varial.assetaccounting.domain.fixedasset.FixedAssetData;
import com.varial.assetaccounting.domain.fixedasset.FixedAssetPersistencyManager;
import com.varial.assetaccounting.domain.fixedasset.FixedAssetTransaction;
import com.varial.assetaccounting.domain.fixedasset.TransactionMapper;
import com.varial.assetaccounting.domain.fixedassetreport.FixedAssetReportPreset;
import com.varial.assetaccounting.domain.fixedassetreport.quickchangeattributes.QuickChangeAttribute;
import com.varial.assetaccounting.domain.indexseries.IndexSeries;
import com.varial.assetaccounting.domain.indexseries.IndexSeriesPersistencyManager;
import com.varial.assetaccounting.fixedasset.AssetTypeEnum;
import com.varial.assetaccounting.fixedasset.TransactionEnum;
import com.varial.assetaccounting.fixedassetreport.CopyDepreciationAreaStruct;
import com.varial.assetaccounting.fixedassetreport.QuickChangeValueStruct;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.types.date.DateHelper;
import com.varial.costing.base.domain.costcentrebase.CostCentreBase;
import com.varial.costing.base.domain.costcentrebase.CostCentreBasePersistencyManager;
import com.varial.costing.base.domain.costunit.CostUnit;
import com.varial.costing.base.domain.costunit.CostUnitPersistencyManager;
import com.varial.framework.domain.analysiscode.AnalysisCodeCategory;
import com.varial.framework.domain.analysiscode.AnalysisCodeCategoryPersistencyManager;
import com.varial.framework.domain.analysiscode.AnalysisCodeCategoryType;
import com.varial.framework.domain.analysiscode.AnalysisCodeTable;
import com.varial.framework.domain.company.ICompany;
import com.varial.framework.domain.quantityunit.QuantityUnit;
import com.varial.framework.domain.quantityunit.QuantityUnitPersistencyManager;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.domain.language.ILanguage;
import com.varial.serverbase.domain.language.Language;
import com.varial.serverbase.domain.language.LanguageManager;
import com.varial.serverbase.domain.resource.TranslateableResourceList;
import com.varial.serverbase.extendedquery.AttributeStruct;
import com.varial.serverbase.extendedquery.AttributeTypeEnum;
import com.varial.serverbase.language.LocalizedStringStruct;
import com.varial.serverbase.mapper.BigDecimalFormatter;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.BooleanMapper;
import com.varial.serverbase.mapper.ExceptionMapper;
import com.varial.serverbase.mapper.StringMapper;
import com.varial.serverbase.persistency.application.localizedstring.LocalizedStringContainer;
import com.varial.serverbase.persistency.application.localizedstring.LocalizedStringMapper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;

public class QuickChangeAttributeMapper {
    public static final String FIELD_ASSETGROUPS = "FA.OIDPARENT";
    public static final String FIELD_SHORTNAME = "TEXT";
    public static final String FIELD_FIXEDASSETTYPE = "FA.ASSETTYPE";
    public static final String FIELD_QUANTITYUNIT = "FA.OIDQUANTITYUNIT";
    public static final String FIELD_QUANTITY = "FA.QUANTITY";
    public static final String FIELD_LOCATIONS = "FA.OIDLOCATION";
    public static final String FIELD_PROJECTS = "FA.OIDPROJECT";
    public static final String FIELD_ASSETACCOUNTS = "FA.OIDASSETACCOUNT";
    public static final String FIELD_VALUATIONACC = "FA.OIDVALUATIONACC";
    public static final String FIELD_ACCVALSPECDEPR = "FA.OIDACCVALSPECDEPR";
    public static final String FIELD_NEWADDOFFSACC = "FA.OIDNEWADDOFFSACC";
    public static final String FIELD_DISPOSOFFSACC = "FA.OIDDISPOSOFFSACC";
    public static final String FIELD_SUPPLIERS = "FA.OIDSUPPLIERACCOUNT";
    public static final String FIELD_COSTCENTRES = "FA.OIDCOSTCENTRE";
    public static final String FIELD_COSTUNITS = "FA.OIDCOSTUNIT";
    public static final String FIELD_ACCOUNTGROUP = "FAA.OIDACCOUNTGROUP";
    public static final String FIELD_LIFEINMONTH = "FAA.LIFEINMONTH";
    public static final String FIELD_DEPRMETHOD = "FAA.OIDDEPRECMETHOD";
    public static final String FIELD_DEPRECPERCENT = "FAA.DEPRECPERCENT";
    public static final String FIELD_SHIFTFACTOR = "FAA.SHIFTFACTOR";
    public static final String FIELD_SPECDEPRMETHOD = "FAA.OIDSPECDEPREMETHOD";
    public static final String FIELD_SPECDEPREPERCENT = "FAA.SPRECDEPREPERCENT";
    public static final String FIELD_DEPRBELOWZERO = "FAA.DEPBELOWZERO";
    public static final String FIELD_DEPRRESIDUALVALUE = "FAA.DEPRESVALUE";
    public static final String FIELD_REPLACEINDEX = "FAA.OIDREPLACEINDEX";
    public static final String FIELD_IMPINTERESTMETHOD = "FAA.OIDIMPINTERESTMETH";
    public static final String FIELD_IMPINTERESTPERCENT = "FAA.IMPINTERESTPERCENT";
    public static final String FIELD_PERSONS = "FA.OIDPERSON";
    public static final String FIELD_AC0 = "FA.AC0";
    public static final String FIELD_AC1 = "FA.AC1";
    public static final String FIELD_AC2 = "FA.AC2";
    public static final String FIELD_AC3 = "FA.AC3";
    public static final String FIELD_AC4 = "FA.AC4";
    public static final String FIELD_AC5 = "FA.AC5";
    public static final String FIELD_AC6 = "FA.AC6";
    public static final String FIELD_AC7 = "FA.AC7";
    public static final String FIELD_AC8 = "FA.AC8";
    public static final String FIELD_AC9 = "FA.AC9";
    public static final String FIELD_DEPRAREA = "Depreciation Area";
    private static final int POS_ASSETGROUPS = 0;
    private static final int POS_SHORTNAME = 1;
    private static final int POS_FIXEDASSETTYPE = 2;
    private static final int POS_QUANTITYUNIT = 3;
    private static final int POS_QUANTITY = 4;
    private static final int POS_LOCATIONS = 5;
    private static final int POS_PROJECTS = 6;
    private static final int POS_ASSETACCOUNTS = 7;
    private static final int POS_VALUATIONACC = 8;
    private static final int POS_ACCVALSPECDEPR = 9;
    private static final int POS_NEWADDOFFSACC = 10;
    private static final int POS_DISPOSOFFSACC = 11;
    private static final int POS_SUPPLIERS = 12;
    private static final int POS_COSTCENTRES = 13;
    private static final int POS_COSTUNITS = 14;
    private static final int POS_ACCOUNTGROUP = 15;
    private static final int POS_USEFULLLIFE = 16;
    private static final int POS_DEPRMETHOD = 17;
    private static final int POS_DEPRECPERCENT = 18;
    private static final int POS_SHIFTFACTOR = 19;
    private static final int POS_SPECDEPRMETHOD = 20;
    private static final int POS_SPECDEPREPERCENT = 21;
    private static final int POS_DEPRBELOWZERO = 22;
    private static final int POS_DEPRRESIDUALVALUE = 23;
    private static final int POS_REPLACEINDEX = 24;
    private static final int POS_IMPINTERESTMETHOD = 25;
    private static final int POS_IMPINTERESTPERCENT = 26;
    private static final int POS_AC0 = 27;
    private static final int POS_AC1 = 28;
    private static final int POS_AC2 = 29;
    private static final int POS_AC3 = 30;
    private static final int POS_AC4 = 31;
    private static final int POS_AC5 = 32;
    private static final int POS_AC6 = 33;
    private static final int POS_AC7 = 34;
    private static final int POS_AC8 = 35;
    private static final int POS_AC9 = 36;
    private static final int POS_PERSONS = 37;
    private static final AttributeTypeEnum TYPE_ASSETGROUPS = AttributeTypeEnum.ATE_OBJECT;
    private static final AttributeTypeEnum TYPE_SHORTNAME = AttributeTypeEnum.ATE_STRING;
    private static final AttributeTypeEnum TYPE_FIXEDASSETTYPE = AttributeTypeEnum.ATE_ENUM;
    private static final AttributeTypeEnum TYPE_QUANTITYUNIT = AttributeTypeEnum.ATE_OBJECT;
    private static final AttributeTypeEnum TYPE_QUANTITY = AttributeTypeEnum.ATE_NUMBER;
    private static final AttributeTypeEnum TYPE_LOCATIONS = AttributeTypeEnum.ATE_OBJECT;
    private static final AttributeTypeEnum TYPE_PROJECTS = AttributeTypeEnum.ATE_OBJECT;
    private static final AttributeTypeEnum TYPE_ASSETACCOUNTS = AttributeTypeEnum.ATE_OBJECT;
    private static final AttributeTypeEnum TYPE_VALUATIONACC = AttributeTypeEnum.ATE_OBJECT;
    private static final AttributeTypeEnum TYPE_ACCVALSPECDEPR = AttributeTypeEnum.ATE_OBJECT;
    private static final AttributeTypeEnum TYPE_NEWADDOFFSACC = AttributeTypeEnum.ATE_OBJECT;
    private static final AttributeTypeEnum TYPE_DISPOSOFFSACC = AttributeTypeEnum.ATE_OBJECT;
    private static final AttributeTypeEnum TYPE_SUPPLIERS = AttributeTypeEnum.ATE_OBJECT;
    private static final AttributeTypeEnum TYPE_COSTCENTRES = AttributeTypeEnum.ATE_OBJECT;
    private static final AttributeTypeEnum TYPE_COSTUNITS = AttributeTypeEnum.ATE_OBJECT;
    private static final AttributeTypeEnum TYPE_ACCOUNTGROUP = AttributeTypeEnum.ATE_OBJECT;
    private static final AttributeTypeEnum TYPE_LIFEINMONTH = AttributeTypeEnum.ATE_NUMBER;
    private static final AttributeTypeEnum TYPE_DEPRMETHOD = AttributeTypeEnum.ATE_OBJECT;
    private static final AttributeTypeEnum TYPE_DEPRECPERCENT = AttributeTypeEnum.ATE_NUMBER;
    private static final AttributeTypeEnum TYPE_SHIFTFACTOR = AttributeTypeEnum.ATE_NUMBER;
    private static final AttributeTypeEnum TYPE_SPECDEPRMETHOD = AttributeTypeEnum.ATE_OBJECT;
    private static final AttributeTypeEnum TYPE_SPECDEPREPERCENT = AttributeTypeEnum.ATE_NUMBER;
    private static final AttributeTypeEnum TYPE_DEPRBELOWZERO = AttributeTypeEnum.ATE_BOOLEAN;
    private static final AttributeTypeEnum TYPE_DEPRRESIDUALVALUE = AttributeTypeEnum.ATE_NUMBER;
    private static final AttributeTypeEnum TYPE_REPLACEINDEX = AttributeTypeEnum.ATE_OBJECT;
    private static final AttributeTypeEnum TYPE_IMPINTERESTMETHOD = AttributeTypeEnum.ATE_OBJECT;
    private static final AttributeTypeEnum TYPE_IMPINTERESTPERCENT = AttributeTypeEnum.ATE_NUMBER;
    private static final AttributeTypeEnum TYPE_ANALYSISCODES = AttributeTypeEnum.ATE_STRING;
    private static final AttributeTypeEnum TYPE_PERSONS = AttributeTypeEnum.ATE_OBJECT;
    private static String[] mFields = new String[]{"FA.OIDPARENT", "TEXT", "FA.ASSETTYPE", "FA.OIDQUANTITYUNIT", "FA.QUANTITY", "FA.OIDLOCATION", "FA.OIDPROJECT", "FA.OIDASSETACCOUNT", "FA.OIDVALUATIONACC", "FA.OIDACCVALSPECDEPR", "FA.OIDNEWADDOFFSACC", "FA.OIDDISPOSOFFSACC", "FA.OIDSUPPLIERACCOUNT", "FA.OIDCOSTCENTRE", "FA.OIDCOSTUNIT", "FAA.OIDACCOUNTGROUP", "FAA.LIFEINMONTH", "FAA.OIDDEPRECMETHOD", "FAA.DEPRECPERCENT", "FAA.SHIFTFACTOR", "FAA.OIDSPECDEPREMETHOD", "FAA.DEPBELOWZERO", "FAA.DEPRESVALUE", "FAA.OIDREPLACEINDEX", "FAA.OIDIMPINTERESTMETH", "FAA.IMPINTERESTPERCENT", "FA.AC0", "FA.AC1", "FA.AC2", "FA.AC3", "FA.AC4", "FA.AC5", "FA.AC6", "FA.AC7", "FA.AC8", "FA.AC9", "FA.OIDPERSON"};
    private static TranslateableResourceList mFixedAssetQuickChangeAttrList = TranslateableResourceList.createTranslateableResourceList("FixedAssetQuickChangeAttrList", new String[]{"Asset Group", "Short Name", "Asset Type", "Quantity Unit", "Quantity", "Location", "Project", "Asset Account", "Accumulated Depreciation Account", "Accumulated Special Depreciation Account", "Intermediate Account Addition", "Intermediate Account Disposal", "Supplier", "Cost Centre", "Cost Unit", "Account Allocation Group", "Life in Months", "Depreciation Type", "Depreciation Rate", "Shift Factor", "Special Depreciation Type", "Special Depreciation Rate", "Depreciation below Zero", "Depreciation to Residual Value", "Replacement Value Index", "Interest Calculation Type", "Interest Calculation Rate", "Analysis Code 1", "Analysis Code 2", "Analysis Code 3", "Analysis Code 4", "Analysis Code 5", "Analysis Code 6", "Analysis Code 7", "Analysis Code 8", "Analysis Code 9", "Analysis Code 10", "Responsible Person"});

    public static LocalizedStringStruct[] getFixedAssetFieldNames(String fieldName, AccountingCompany company) {
        AnalysisCodeTable[] analCodeTable = null;
        if (company != null) {
            analCodeTable = QuickChangeAttributeMapper.getAnalysisCodeTable(company);
        }
        if (FIELD_ASSETGROUPS.equals(fieldName)) {
            return mFixedAssetQuickChangeAttrList.getLocalizedStrings(0);
        }
        if (FIELD_SHORTNAME.equals(fieldName)) {
            return mFixedAssetQuickChangeAttrList.getLocalizedStrings(1);
        }
        if (FIELD_FIXEDASSETTYPE.equals(fieldName)) {
            return mFixedAssetQuickChangeAttrList.getLocalizedStrings(2);
        }
        if (FIELD_QUANTITYUNIT.equals(fieldName)) {
            return mFixedAssetQuickChangeAttrList.getLocalizedStrings(3);
        }
        if (FIELD_QUANTITY.equals(fieldName)) {
            return mFixedAssetQuickChangeAttrList.getLocalizedStrings(4);
        }
        if (FIELD_LOCATIONS.equals(fieldName)) {
            return mFixedAssetQuickChangeAttrList.getLocalizedStrings(5);
        }
        if (FIELD_PROJECTS.equals(fieldName)) {
            return mFixedAssetQuickChangeAttrList.getLocalizedStrings(6);
        }
        if (FIELD_ASSETACCOUNTS.equals(fieldName)) {
            return mFixedAssetQuickChangeAttrList.getLocalizedStrings(7);
        }
        if (FIELD_VALUATIONACC.equals(fieldName)) {
            return mFixedAssetQuickChangeAttrList.getLocalizedStrings(8);
        }
        if (FIELD_ACCVALSPECDEPR.equals(fieldName)) {
            return mFixedAssetQuickChangeAttrList.getLocalizedStrings(9);
        }
        if (FIELD_NEWADDOFFSACC.equals(fieldName)) {
            return mFixedAssetQuickChangeAttrList.getLocalizedStrings(10);
        }
        if (FIELD_DISPOSOFFSACC.equals(fieldName)) {
            return mFixedAssetQuickChangeAttrList.getLocalizedStrings(11);
        }
        if (FIELD_SUPPLIERS.equals(fieldName)) {
            return mFixedAssetQuickChangeAttrList.getLocalizedStrings(12);
        }
        if (FIELD_COSTCENTRES.equals(fieldName)) {
            return mFixedAssetQuickChangeAttrList.getLocalizedStrings(13);
        }
        if (FIELD_COSTUNITS.equals(fieldName)) {
            return mFixedAssetQuickChangeAttrList.getLocalizedStrings(14);
        }
        if (FIELD_ACCOUNTGROUP.equals(fieldName)) {
            return mFixedAssetQuickChangeAttrList.getLocalizedStrings(15);
        }
        if (FIELD_LIFEINMONTH.equals(fieldName)) {
            return mFixedAssetQuickChangeAttrList.getLocalizedStrings(16);
        }
        if (FIELD_DEPRMETHOD.equals(fieldName)) {
            return mFixedAssetQuickChangeAttrList.getLocalizedStrings(17);
        }
        if (FIELD_DEPRECPERCENT.equals(fieldName)) {
            return mFixedAssetQuickChangeAttrList.getLocalizedStrings(18);
        }
        if (FIELD_SHIFTFACTOR.equals(fieldName)) {
            return mFixedAssetQuickChangeAttrList.getLocalizedStrings(19);
        }
        if (FIELD_SPECDEPRMETHOD.equals(fieldName)) {
            return mFixedAssetQuickChangeAttrList.getLocalizedStrings(20);
        }
        if (FIELD_SPECDEPREPERCENT.equals(fieldName)) {
            return mFixedAssetQuickChangeAttrList.getLocalizedStrings(21);
        }
        if (FIELD_DEPRBELOWZERO.equals(fieldName)) {
            return mFixedAssetQuickChangeAttrList.getLocalizedStrings(22);
        }
        if (FIELD_DEPRRESIDUALVALUE.equals(fieldName)) {
            return mFixedAssetQuickChangeAttrList.getLocalizedStrings(23);
        }
        if (FIELD_REPLACEINDEX.equals(fieldName)) {
            return mFixedAssetQuickChangeAttrList.getLocalizedStrings(24);
        }
        if (FIELD_IMPINTERESTMETHOD.equals(fieldName)) {
            return mFixedAssetQuickChangeAttrList.getLocalizedStrings(25);
        }
        if (FIELD_IMPINTERESTPERCENT.equals(fieldName)) {
            return mFixedAssetQuickChangeAttrList.getLocalizedStrings(26);
        }
        if (FIELD_AC0.equals(fieldName)) {
            return QuickChangeAttributeMapper.getLocalStringStructForAnalysisCodes(mFixedAssetQuickChangeAttrList.getLocalizedStrings(27), analCodeTable, 0);
        }
        if (FIELD_AC1.equals(fieldName)) {
            return QuickChangeAttributeMapper.getLocalStringStructForAnalysisCodes(mFixedAssetQuickChangeAttrList.getLocalizedStrings(28), analCodeTable, 1);
        }
        if (FIELD_AC2.equals(fieldName)) {
            return QuickChangeAttributeMapper.getLocalStringStructForAnalysisCodes(mFixedAssetQuickChangeAttrList.getLocalizedStrings(29), analCodeTable, 2);
        }
        if (FIELD_AC3.equals(fieldName)) {
            return QuickChangeAttributeMapper.getLocalStringStructForAnalysisCodes(mFixedAssetQuickChangeAttrList.getLocalizedStrings(30), analCodeTable, 3);
        }
        if (FIELD_AC4.equals(fieldName)) {
            return QuickChangeAttributeMapper.getLocalStringStructForAnalysisCodes(mFixedAssetQuickChangeAttrList.getLocalizedStrings(31), analCodeTable, 4);
        }
        if (FIELD_AC5.equals(fieldName)) {
            return QuickChangeAttributeMapper.getLocalStringStructForAnalysisCodes(mFixedAssetQuickChangeAttrList.getLocalizedStrings(32), analCodeTable, 5);
        }
        if (FIELD_AC6.equals(fieldName)) {
            return QuickChangeAttributeMapper.getLocalStringStructForAnalysisCodes(mFixedAssetQuickChangeAttrList.getLocalizedStrings(33), analCodeTable, 6);
        }
        if (FIELD_AC7.equals(fieldName)) {
            return QuickChangeAttributeMapper.getLocalStringStructForAnalysisCodes(mFixedAssetQuickChangeAttrList.getLocalizedStrings(34), analCodeTable, 7);
        }
        if (FIELD_AC8.equals(fieldName)) {
            return QuickChangeAttributeMapper.getLocalStringStructForAnalysisCodes(mFixedAssetQuickChangeAttrList.getLocalizedStrings(35), analCodeTable, 8);
        }
        if (FIELD_AC9.equals(fieldName)) {
            return QuickChangeAttributeMapper.getLocalStringStructForAnalysisCodes(mFixedAssetQuickChangeAttrList.getLocalizedStrings(36), analCodeTable, 9);
        }
        if (FIELD_DEPRAREA.equals(fieldName)) {
            return new LocalizedStringStruct[0];
        }
        if (FIELD_PERSONS.equals(fieldName)) {
            return mFixedAssetQuickChangeAttrList.getLocalizedStrings(37);
        }
        throw ExceptionMapper.makeApplicationException((String)("Invalid Fieldname >" + fieldName + "<  ; in: FixedAssetQuickChangeAttrMapper:getFixedAssetFieldNames"));
    }

    public static String getFieldName(String fieldName, Language language) {
        if (FIELD_ASSETGROUPS.equals(fieldName)) {
            return mFixedAssetQuickChangeAttrList.getString((ILanguage)language, 0);
        }
        if (FIELD_SHORTNAME.equals(fieldName)) {
            return mFixedAssetQuickChangeAttrList.getString((ILanguage)language, 1);
        }
        if (FIELD_FIXEDASSETTYPE.equals(fieldName)) {
            return mFixedAssetQuickChangeAttrList.getString((ILanguage)language, 2);
        }
        if (FIELD_QUANTITYUNIT.equals(fieldName)) {
            return mFixedAssetQuickChangeAttrList.getString((ILanguage)language, 3);
        }
        if (FIELD_QUANTITY.equals(fieldName)) {
            return mFixedAssetQuickChangeAttrList.getString((ILanguage)language, 4);
        }
        if (FIELD_LOCATIONS.equals(fieldName)) {
            return mFixedAssetQuickChangeAttrList.getString((ILanguage)language, 5);
        }
        if (FIELD_PROJECTS.equals(fieldName)) {
            return mFixedAssetQuickChangeAttrList.getString((ILanguage)language, 6);
        }
        if (FIELD_ASSETACCOUNTS.equals(fieldName)) {
            return mFixedAssetQuickChangeAttrList.getString((ILanguage)language, 7);
        }
        if (FIELD_VALUATIONACC.equals(fieldName)) {
            return mFixedAssetQuickChangeAttrList.getString((ILanguage)language, 8);
        }
        if (FIELD_ACCVALSPECDEPR.equals(fieldName)) {
            return mFixedAssetQuickChangeAttrList.getString((ILanguage)language, 9);
        }
        if (FIELD_NEWADDOFFSACC.equals(fieldName)) {
            return mFixedAssetQuickChangeAttrList.getString((ILanguage)language, 10);
        }
        if (FIELD_DISPOSOFFSACC.equals(fieldName)) {
            return mFixedAssetQuickChangeAttrList.getString((ILanguage)language, 11);
        }
        if (FIELD_SUPPLIERS.equals(fieldName)) {
            return mFixedAssetQuickChangeAttrList.getString((ILanguage)language, 12);
        }
        if (FIELD_COSTCENTRES.equals(fieldName)) {
            return mFixedAssetQuickChangeAttrList.getString((ILanguage)language, 13);
        }
        if (FIELD_COSTUNITS.equals(fieldName)) {
            return mFixedAssetQuickChangeAttrList.getString((ILanguage)language, 14);
        }
        if (FIELD_ACCOUNTGROUP.equals(fieldName)) {
            return mFixedAssetQuickChangeAttrList.getString((ILanguage)language, 15);
        }
        if (FIELD_LIFEINMONTH.equals(fieldName)) {
            return mFixedAssetQuickChangeAttrList.getString((ILanguage)language, 16);
        }
        if (FIELD_DEPRMETHOD.equals(fieldName)) {
            return mFixedAssetQuickChangeAttrList.getString((ILanguage)language, 17);
        }
        if (FIELD_DEPRECPERCENT.equals(fieldName)) {
            return mFixedAssetQuickChangeAttrList.getString((ILanguage)language, 18);
        }
        if (FIELD_SHIFTFACTOR.equals(fieldName)) {
            return mFixedAssetQuickChangeAttrList.getString((ILanguage)language, 19);
        }
        if (FIELD_SPECDEPRMETHOD.equals(fieldName)) {
            return mFixedAssetQuickChangeAttrList.getString((ILanguage)language, 20);
        }
        if (FIELD_SPECDEPREPERCENT.equals(fieldName)) {
            return mFixedAssetQuickChangeAttrList.getString((ILanguage)language, 21);
        }
        if (FIELD_DEPRBELOWZERO.equals(fieldName)) {
            return mFixedAssetQuickChangeAttrList.getString((ILanguage)language, 22);
        }
        if (FIELD_DEPRRESIDUALVALUE.equals(fieldName)) {
            return mFixedAssetQuickChangeAttrList.getString((ILanguage)language, 23);
        }
        if (FIELD_REPLACEINDEX.equals(fieldName)) {
            return mFixedAssetQuickChangeAttrList.getString((ILanguage)language, 24);
        }
        if (FIELD_IMPINTERESTMETHOD.equals(fieldName)) {
            return mFixedAssetQuickChangeAttrList.getString((ILanguage)language, 25);
        }
        if (FIELD_IMPINTERESTPERCENT.equals(fieldName)) {
            return mFixedAssetQuickChangeAttrList.getString((ILanguage)language, 26);
        }
        if (FIELD_AC0.equals(fieldName)) {
            return mFixedAssetQuickChangeAttrList.getString((ILanguage)language, 27);
        }
        if (FIELD_AC1.equals(fieldName)) {
            return mFixedAssetQuickChangeAttrList.getString((ILanguage)language, 28);
        }
        if (FIELD_AC2.equals(fieldName)) {
            return mFixedAssetQuickChangeAttrList.getString((ILanguage)language, 29);
        }
        if (FIELD_AC3.equals(fieldName)) {
            return mFixedAssetQuickChangeAttrList.getString((ILanguage)language, 30);
        }
        if (FIELD_AC4.equals(fieldName)) {
            return mFixedAssetQuickChangeAttrList.getString((ILanguage)language, 31);
        }
        if (FIELD_AC5.equals(fieldName)) {
            return mFixedAssetQuickChangeAttrList.getString((ILanguage)language, 32);
        }
        if (FIELD_AC6.equals(fieldName)) {
            return mFixedAssetQuickChangeAttrList.getString((ILanguage)language, 33);
        }
        if (FIELD_AC7.equals(fieldName)) {
            return mFixedAssetQuickChangeAttrList.getString((ILanguage)language, 34);
        }
        if (FIELD_AC8.equals(fieldName)) {
            return mFixedAssetQuickChangeAttrList.getString((ILanguage)language, 35);
        }
        if (FIELD_AC9.equals(fieldName)) {
            return mFixedAssetQuickChangeAttrList.getString((ILanguage)language, 36);
        }
        if (FIELD_PERSONS.equals(fieldName)) {
            return mFixedAssetQuickChangeAttrList.getString((ILanguage)language, 37);
        }
        throw ExceptionMapper.makeApplicationException((String)("Invalid Fieldname >" + fieldName + "<  ; in: FixedAssetQuickChangeAttrMapper:getFixedAssetFieldNames"));
    }

    private static AttributeTypeEnum getFixedAssetFieldType(String fieldName) {
        if (FIELD_ASSETGROUPS.equals(fieldName)) {
            return TYPE_ASSETGROUPS;
        }
        if (FIELD_SHORTNAME.equals(fieldName)) {
            return TYPE_SHORTNAME;
        }
        if (FIELD_FIXEDASSETTYPE.equals(fieldName)) {
            return TYPE_FIXEDASSETTYPE;
        }
        if (FIELD_QUANTITYUNIT.equals(fieldName)) {
            return TYPE_QUANTITYUNIT;
        }
        if (FIELD_QUANTITY.equals(fieldName)) {
            return TYPE_QUANTITY;
        }
        if (FIELD_LOCATIONS.equals(fieldName)) {
            return TYPE_LOCATIONS;
        }
        if (FIELD_PROJECTS.equals(fieldName)) {
            return TYPE_PROJECTS;
        }
        if (FIELD_ASSETACCOUNTS.equals(fieldName)) {
            return TYPE_ASSETACCOUNTS;
        }
        if (FIELD_VALUATIONACC.equals(fieldName)) {
            return TYPE_VALUATIONACC;
        }
        if (FIELD_ACCVALSPECDEPR.equals(fieldName)) {
            return TYPE_ACCVALSPECDEPR;
        }
        if (FIELD_NEWADDOFFSACC.equals(fieldName)) {
            return TYPE_NEWADDOFFSACC;
        }
        if (FIELD_DISPOSOFFSACC.equals(fieldName)) {
            return TYPE_DISPOSOFFSACC;
        }
        if (FIELD_SUPPLIERS.equals(fieldName)) {
            return TYPE_SUPPLIERS;
        }
        if (FIELD_COSTCENTRES.equals(fieldName)) {
            return TYPE_COSTCENTRES;
        }
        if (FIELD_COSTUNITS.equals(fieldName)) {
            return TYPE_COSTUNITS;
        }
        if (FIELD_ACCOUNTGROUP.equals(fieldName)) {
            return TYPE_ACCOUNTGROUP;
        }
        if (FIELD_LIFEINMONTH.equals(fieldName)) {
            return TYPE_LIFEINMONTH;
        }
        if (FIELD_DEPRMETHOD.equals(fieldName)) {
            return TYPE_DEPRMETHOD;
        }
        if (FIELD_DEPRECPERCENT.equals(fieldName)) {
            return TYPE_DEPRECPERCENT;
        }
        if (FIELD_SHIFTFACTOR.equals(fieldName)) {
            return TYPE_SHIFTFACTOR;
        }
        if (FIELD_SPECDEPRMETHOD.equals(fieldName)) {
            return TYPE_SPECDEPRMETHOD;
        }
        if (FIELD_SPECDEPREPERCENT.equals(fieldName)) {
            return TYPE_SPECDEPREPERCENT;
        }
        if (FIELD_DEPRBELOWZERO.equals(fieldName)) {
            return TYPE_DEPRBELOWZERO;
        }
        if (FIELD_DEPRRESIDUALVALUE.equals(fieldName)) {
            return TYPE_DEPRRESIDUALVALUE;
        }
        if (FIELD_REPLACEINDEX.equals(fieldName)) {
            return TYPE_REPLACEINDEX;
        }
        if (FIELD_IMPINTERESTMETHOD.equals(fieldName)) {
            return TYPE_IMPINTERESTMETHOD;
        }
        if (FIELD_IMPINTERESTPERCENT.equals(fieldName)) {
            return TYPE_IMPINTERESTPERCENT;
        }
        if (FIELD_AC0.equals(fieldName)) {
            return TYPE_ANALYSISCODES;
        }
        if (FIELD_AC1.equals(fieldName)) {
            return TYPE_ANALYSISCODES;
        }
        if (FIELD_AC2.equals(fieldName)) {
            return TYPE_ANALYSISCODES;
        }
        if (FIELD_AC3.equals(fieldName)) {
            return TYPE_ANALYSISCODES;
        }
        if (FIELD_AC4.equals(fieldName)) {
            return TYPE_ANALYSISCODES;
        }
        if (FIELD_AC5.equals(fieldName)) {
            return TYPE_ANALYSISCODES;
        }
        if (FIELD_AC6.equals(fieldName)) {
            return TYPE_ANALYSISCODES;
        }
        if (FIELD_AC7.equals(fieldName)) {
            return TYPE_ANALYSISCODES;
        }
        if (FIELD_AC8.equals(fieldName)) {
            return TYPE_ANALYSISCODES;
        }
        if (FIELD_AC9.equals(fieldName)) {
            return TYPE_ANALYSISCODES;
        }
        if (FIELD_PERSONS.equals(fieldName)) {
            return TYPE_PERSONS;
        }
        throw ExceptionMapper.makeApplicationException((String)("Invalid Fieldname >" + fieldName + "<  ; in: FixedAssetQuickChangeAttrMapper:getFixedAssetFieldType"));
    }

    private static int getSize() {
        return mFields.length;
    }

    public static String getField(int i) {
        return mFields[i];
    }

    public static QuickChangeAttribute[] getFixedAssetQuickChangeAttributes(AccountingCompany company) {
        AssetaccountingSetup aaSetup = AssetaccountingSetup.getValidAssetaccountingSetup((AccountingCompany)company);
        LinkedList<QuickChangeAttribute> filterAttrList = new LinkedList<QuickChangeAttribute>();
        boolean isPerson = false;
        for (int i = 0; i < QuickChangeAttributeMapper.getSize(); ++i) {
            if (i == 6 && !isPerson) {
                isPerson = true;
                i = 36;
            } else if (i == 36 && isPerson) continue;
            if ((aaSetup == null || !aaSetup.getIsSepcialDepr()) && (mFields[i].equals(FIELD_SPECDEPRMETHOD) || mFields[i].equals(FIELD_SPECDEPREPERCENT)) || (aaSetup == null || !aaSetup.getIsImputedInterests()) && (mFields[i].equals(FIELD_IMPINTERESTMETHOD) || mFields[i].equals(FIELD_IMPINTERESTPERCENT)) || (aaSetup == null || !aaSetup.getIsIndirDeprWithValAcc()) && (mFields[i].equals(FIELD_VALUATIONACC) || mFields[i].equals(FIELD_ACCVALSPECDEPR)) || (aaSetup == null || !aaSetup.getIsNewAddingOffsetAcc()) && mFields[i].equals(FIELD_NEWADDOFFSACC) || (aaSetup == null || !aaSetup.getIsDisposalOffsetAcc()) && mFields[i].equals(FIELD_DISPOSOFFSACC)) continue;
            LocalizedStringStruct[] lsStruct = QuickChangeAttributeMapper.getFixedAssetFieldNames(mFields[i], company);
            if (lsStruct != null) {
                QuickChangeAttribute extFilterAttribute = new QuickChangeAttribute(true);
                extFilterAttribute.setAttributeType(QuickChangeAttributeMapper.getFixedAssetFieldType(mFields[i]));
                extFilterAttribute.setAttributeCode(mFields[i]);
                extFilterAttribute.setReplace(false);
                extFilterAttribute.setNewStringValue("");
                extFilterAttribute.setOldStringValue("");
                extFilterAttribute.setNewBooleanValue(false);
                extFilterAttribute.setOldBooleanValue(false);
                extFilterAttribute.setNames(lsStruct);
                filterAttrList.add(extFilterAttribute);
            }
            if (i != 36 || !isPerson) continue;
            i = 5;
        }
        QuickChangeAttribute[] extFilterAttr = new QuickChangeAttribute[filterAttrList.size()];
        filterAttrList.toArray(extFilterAttr);
        return extFilterAttr;
    }

    private static AnalysisCodeTable[] getAnalysisCodeTable(AccountingCompany company) {
        AnalysisCodeTable[] analCodeTable = null;
        AnalysisCodeCategory analCodeCat = AnalysisCodeCategoryPersistencyManager.getCategory((ICompany)company, (AnalysisCodeCategoryType)AnalysisCodeCategoryType.FIXED_ASSETS);
        if (analCodeCat != null) {
            analCodeTable = analCodeCat.getAnalysisCodeTables();
        }
        return analCodeTable;
    }

    private static LocalizedStringStruct[] getLocalStringStructForAnalysisCodes(LocalizedStringStruct[] lsStruct, AnalysisCodeTable[] analCodeTable, int analCodeNumber) {
        if (analCodeTable != null && analCodeTable.length > 0 && analCodeNumber < analCodeTable.length) {
            for (int i = 0; i < lsStruct.length; ++i) {
                AnalysisCodeTable act = analCodeTable[analCodeNumber];
                Language language = LanguageManager.getInstance().getLanguage(lsStruct[i].oidLanguage);
                lsStruct[i].text = lsStruct[i].text + ": " + act.getShortName(language);
            }
            return lsStruct;
        }
        return null;
    }

    public static QuickChangeValueStruct[] toIdl(QuickChangeAttribute[] qcAttr) {
        if (qcAttr == null) {
            return new QuickChangeValueStruct[0];
        }
        QuickChangeValueStruct[] result = new QuickChangeValueStruct[qcAttr.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = QuickChangeAttributeMapper.toIdl(qcAttr[i]);
        }
        return result;
    }

    private static QuickChangeValueStruct toIdl(QuickChangeAttribute qcAttr) {
        QuickChangeValueStruct qcAttrStruct = new QuickChangeValueStruct();
        AttributeStruct attrStruct = new AttributeStruct();
        attrStruct.attributeCode = qcAttr.getAttributeCode();
        attrStruct.attributeType = qcAttr.getAttributeType();
        attrStruct.attributeName = qcAttr.getNames();
        attrStruct.decimals = 0;
        attrStruct.type = "";
        attrStruct.attributeValues = new String[0];
        qcAttrStruct.attrib = attrStruct;
        qcAttrStruct.replace = qcAttr.getReplace();
        qcAttrStruct.oldStringValue = qcAttr.getOldStringValue();
        qcAttrStruct.newStringValue = qcAttr.getNewStringValue();
        qcAttrStruct.oldBooleanValue = qcAttr.getOldBooleanValue();
        qcAttrStruct.newBooleanValue = qcAttr.getNewBooleanValue();
        return qcAttrStruct;
    }

    public static CopyDepreciationAreaStruct[] copyDataToIdl(QuickChangeAttribute[] copyAttr) {
        if (copyAttr == null) {
            return new CopyDepreciationAreaStruct[0];
        }
        CopyDepreciationAreaStruct[] result = new CopyDepreciationAreaStruct[copyAttr.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = QuickChangeAttributeMapper.copyDataToIdl(copyAttr[i]);
        }
        return result;
    }

    private static CopyDepreciationAreaStruct copyDataToIdl(QuickChangeAttribute copyAttr) {
        CopyDepreciationAreaStruct copyDeprStruct = new CopyDepreciationAreaStruct();
        copyDeprStruct.oidFromArea = copyAttr.getOldStringValue();
        copyDeprStruct.oidToArea = copyAttr.getNewStringValue();
        return copyDeprStruct;
    }

    public static AttributeStruct[] toIdl(QuickChangeValueStruct[] qcAttrStruct) {
        if (qcAttrStruct == null) {
            return new AttributeStruct[0];
        }
        AttributeStruct[] result = new AttributeStruct[qcAttrStruct.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = qcAttrStruct[i].attrib;
        }
        return result;
    }

    public static QuickChangeAttribute[] fillQuickChangeAttribute(FixedAssetReportPreset preset, QuickChangeValueStruct[] qcAttrStruct) {
        if (qcAttrStruct == null) {
            return new QuickChangeAttribute[0];
        }
        QuickChangeAttribute[] qcAttr = new QuickChangeAttribute[qcAttrStruct.length];
        for (int i = 0; i < qcAttrStruct.length; ++i) {
            qcAttr[i] = new QuickChangeAttribute(preset);
            QuickChangeAttributeMapper.fillQuickChangeAttributes(qcAttr[i], qcAttrStruct[i], i);
        }
        return qcAttr;
    }

    private static void fillQuickChangeAttributes(QuickChangeAttribute qcAttr, QuickChangeValueStruct qcAttrStruct, int sortSequence) {
        qcAttr.setAttributeCode(qcAttrStruct.attrib.attributeCode);
        qcAttr.setAttributeType(qcAttrStruct.attrib.attributeType);
        qcAttr.setReplace(qcAttrStruct.replace);
        qcAttr.setOldStringValue(qcAttrStruct.oldStringValue);
        qcAttr.setNewStringValue(qcAttrStruct.newStringValue);
        qcAttr.setOldBooleanValue(qcAttrStruct.oldBooleanValue);
        qcAttr.setNewBooleanValue(qcAttrStruct.newBooleanValue);
        qcAttr.setNames(qcAttrStruct.attrib.attributeName);
        qcAttr.setSortSequence(sortSequence);
    }

    public static QuickChangeAttribute[] fillCopyDataAttribute(FixedAssetReportPreset preset, CopyDepreciationAreaStruct[] copyStruct) {
        if (copyStruct == null) {
            return new QuickChangeAttribute[0];
        }
        QuickChangeAttribute[] copyAttr = new QuickChangeAttribute[copyStruct.length];
        for (int i = 0; i < copyStruct.length; ++i) {
            copyAttr[i] = new QuickChangeAttribute(preset);
            QuickChangeAttributeMapper.fillCopyDataAttributes(copyAttr[i], copyStruct[i], i);
        }
        return copyAttr;
    }

    private static void fillCopyDataAttributes(QuickChangeAttribute qcAttr, CopyDepreciationAreaStruct copyStruct, int sortSequence) {
        qcAttr.setAttributeCode(FIELD_DEPRAREA);
        qcAttr.setAttributeType(AttributeTypeEnum.ATE_OBJECT);
        qcAttr.setReplace(false);
        qcAttr.setOldStringValue(copyStruct.oidFromArea);
        qcAttr.setNewStringValue(copyStruct.oidToArea);
        qcAttr.setOldBooleanValue(false);
        qcAttr.setNewBooleanValue(false);
        qcAttr.setNames(null);
        qcAttr.setSortSequence(sortSequence);
    }

    public static String[] getOldValueFromFixedAsset(FixedAssetArea faArea, String fieldName, Language globalLanguage, Language languageForLanguageDependentTexts, String oldValue) throws BusinessDomainException {
        FixedAssetData fixedAsset = (FixedAssetData)faArea.getFixedAsset();
        String[] result = new String[2];
        BigDecimalFormatter bdFormatter = new BigDecimalFormatter(globalLanguage.getLocale(), Integer.valueOf(2));
        if (FIELD_ASSETGROUPS.equals(fieldName)) {
            result[0] = fixedAsset.getParent().getObjectid();
            FixedAsset fa = FixedAssetPersistencyManager.getFixedAssetWithCache((String)result[0]);
            if (fa != null) {
                StringBuffer strBuffer = new StringBuffer(fa.getCode());
                strBuffer.append(' ').append(fa.getName(languageForLanguageDependentTexts));
                result[1] = strBuffer.toString();
            }
        } else if (FIELD_SHORTNAME.equals(fieldName)) {
            result[0] = fixedAsset.getShortNames().getString((ILanguage)languageForLanguageDependentTexts);
            result[1] = result[0];
        } else if (FIELD_FIXEDASSETTYPE.equals(fieldName)) {
            result[0] = String.valueOf(fixedAsset.getAssetType().value());
            result[1] = AssetTypeMapper.toString((Language)globalLanguage, (AssetTypeEnum)fixedAsset.getAssetType());
        } else if (FIELD_QUANTITYUNIT.equals(fieldName)) {
            if (!StringMapper.isNullString((String)fixedAsset.getOidQuantityUnit())) {
                result[0] = fixedAsset.getOidQuantityUnit();
                QuantityUnit quantityUnit = QuantityUnitPersistencyManager.getQuantityUnit((String)fixedAsset.getOidQuantityUnit());
                if (quantityUnit != null) {
                    StringBuffer strBuffer = new StringBuffer(quantityUnit.getCode());
                    strBuffer.append(' ').append(quantityUnit.getNames().getString((ILanguage)languageForLanguageDependentTexts));
                    result[1] = strBuffer.toString();
                } else {
                    result[1] = "";
                }
            }
        } else if (FIELD_QUANTITY.equals(fieldName)) {
            QuantityUnit qu = QuantityUnitPersistencyManager.getQuantityUnit((String)fixedAsset.getOidQuantityUnit());
            if (qu != null) {
                BigDecimal quantity = BigDecimal.ZERO;
                if (!StringMapper.isNullString((String)fixedAsset.getQuantity())) {
                    quantity = new BigDecimal(fixedAsset.getQuantity());
                }
                quantity = quantity.setScale(5, RoundingMode.HALF_DOWN);
                result[0] = BigDecimalMapper.toString((BigDecimal)quantity);
                quantity = quantity.setScale((int)qu.getDecimalPlaces(), RoundingMode.HALF_DOWN);
                result[1] = bdFormatter.toString(quantity, (int)qu.getDecimalPlaces());
            }
        } else if (FIELD_LOCATIONS.equals(fieldName)) {
            if (fixedAsset.getLocation() != null) {
                result[0] = fixedAsset.getLocation().getObjectid();
                StringBuffer strBuffer = new StringBuffer(fixedAsset.getLocation().getCode());
                strBuffer.append(' ').append(fixedAsset.getLocation().getNames().getString((ILanguage)languageForLanguageDependentTexts));
                result[1] = strBuffer.toString();
            }
        } else if (FIELD_PROJECTS.equals(fieldName)) {
            if (fixedAsset.getProject() != null) {
                result[0] = fixedAsset.getProject().getObjectid();
                StringBuffer strBuffer = new StringBuffer(fixedAsset.getProject().getCode());
                strBuffer.append(' ').append(fixedAsset.getProject().getNames().getString((ILanguage)languageForLanguageDependentTexts));
                result[1] = strBuffer.toString();
            }
        } else if (FIELD_ASSETACCOUNTS.equals(fieldName)) {
            if (fixedAsset.getAssetAccount() != null) {
                result[0] = fixedAsset.getAssetAccount().getObjectid();
                StringBuffer strBuffer = new StringBuffer(fixedAsset.getAssetAccount().getCode());
                strBuffer.append(' ').append(fixedAsset.getAssetAccount().getLocalizedStringContainer().getString((ILanguage)languageForLanguageDependentTexts));
                result[1] = strBuffer.toString();
            }
        } else if (FIELD_VALUATIONACC.equals(fieldName)) {
            if (fixedAsset.getAccValuationDepreciation() != null) {
                result[0] = fixedAsset.getAccValuationDepreciation().getObjectid();
                StringBuffer strBuffer = new StringBuffer(fixedAsset.getAccValuationDepreciation().getCode());
                strBuffer.append(' ').append(fixedAsset.getAccValuationDepreciation().getLocalizedStringContainer().getString((ILanguage)languageForLanguageDependentTexts));
                result[1] = strBuffer.toString();
            }
        } else if (FIELD_ACCVALSPECDEPR.equals(fieldName)) {
            if (fixedAsset.getAccValuationSpecDepreciation() != null) {
                result[0] = fixedAsset.getAccValuationSpecDepreciation().getObjectid();
                StringBuffer strBuffer = new StringBuffer(fixedAsset.getAccValuationSpecDepreciation().getCode());
                strBuffer.append(' ').append(fixedAsset.getAccValuationSpecDepreciation().getLocalizedStringContainer().getString((ILanguage)languageForLanguageDependentTexts));
                result[1] = strBuffer.toString();
            }
        } else if (FIELD_NEWADDOFFSACC.equals(fieldName)) {
            if (fixedAsset.getNewAddOffsetAccount() != null) {
                result[0] = fixedAsset.getNewAddOffsetAccount().getObjectid();
                StringBuffer strBuffer = new StringBuffer(fixedAsset.getNewAddOffsetAccount().getCode());
                strBuffer.append(' ').append(fixedAsset.getNewAddOffsetAccount().getLocalizedStringContainer().getString((ILanguage)languageForLanguageDependentTexts));
                result[1] = strBuffer.toString();
            }
        } else if (FIELD_DISPOSOFFSACC.equals(fieldName)) {
            if (fixedAsset.getDisposalOffsetAccount() != null) {
                result[0] = fixedAsset.getDisposalOffsetAccount().getObjectid();
                StringBuffer strBuffer = new StringBuffer(fixedAsset.getDisposalOffsetAccount().getCode());
                strBuffer.append(' ').append(fixedAsset.getDisposalOffsetAccount().getLocalizedStringContainer().getString((ILanguage)languageForLanguageDependentTexts));
                result[1] = strBuffer.toString();
            }
        } else if (FIELD_SUPPLIERS.equals(fieldName)) {
            PersonalAccount[] supplier = fixedAsset.getSupplAccounts();
            if (!StringMapper.isNullString((String)oldValue)) {
                for (int i = 0; i < supplier.length; ++i) {
                    if (!supplier[i].getObjectid().equals(oldValue)) continue;
                    result[0] = supplier[i].getObjectid();
                    StringBuffer strBuffer = new StringBuffer(supplier[i].getCode());
                    strBuffer.append(' ').append(supplier[i].getShortAddress());
                    result[1] = strBuffer.toString();
                }
            } else if (supplier.length > 0) {
                result[0] = supplier[0].getObjectid();
            }
        } else if (FIELD_COSTCENTRES.equals(fieldName)) {
            FACostCentre[] faCostCentre = fixedAsset.getCostCenters();
            if (!StringMapper.isNullString((String)oldValue)) {
                for (int i = 0; i < faCostCentre.length; ++i) {
                    if (!faCostCentre[i].getCostCentreBase().getObjectid().equals(oldValue)) continue;
                    result[0] = faCostCentre[i].getCostCentreBase().getObjectid();
                    StringBuffer strBuffer = new StringBuffer(faCostCentre[i].getCostCentreBase().getCode());
                    strBuffer.append(' ').append(faCostCentre[i].getCostCentreBase().getCurrentIdentifier().getDescriptions().getLocalizedString((ILanguage)languageForLanguageDependentTexts).getText());
                    result[1] = strBuffer.toString();
                }
            } else if (faCostCentre.length > 0) {
                result[0] = faCostCentre[0].getCostCentreBase().getObjectid();
            }
        } else if (FIELD_COSTUNITS.equals(fieldName)) {
            CostUnit costUnit;
            result[0] = fixedAsset.getOidCostUnit();
            if (!StringMapper.isNullString((String)result[0]) && (costUnit = CostUnitPersistencyManager.getCostUnit((String)result[0])) != null) {
                StringBuffer strBuffer = new StringBuffer(costUnit.getCode());
                strBuffer.append(' ').append(costUnit.getDescriptions().getLocalizedString((ILanguage)languageForLanguageDependentTexts).getText());
                result[1] = strBuffer.toString();
            }
        } else if (FIELD_ACCOUNTGROUP.equals(fieldName)) {
            if (faArea.getAccountGroup() != null) {
                result[0] = faArea.getAccountGroup().getObjectid();
                StringBuffer strBuffer = new StringBuffer(faArea.getAccountGroup().getCode());
                strBuffer.append(' ').append(faArea.getAccountGroup().getName(languageForLanguageDependentTexts));
                result[1] = strBuffer.toString();
            }
        } else if (FIELD_LIFEINMONTH.equals(fieldName)) {
            BigDecimal temp = new BigDecimal(faArea.getUsefullLifeInMonth());
            temp = temp.setScale(2);
            result[0] = BigDecimalMapper.toString((BigDecimal)temp);
            result[1] = String.valueOf(faArea.getUsefullLifeInMonth());
        } else if (FIELD_DEPRMETHOD.equals(fieldName)) {
            CalcMethod calcMethod;
            result[0] = faArea.getOidDepreciationMethod();
            if (!StringMapper.isNullString((String)result[0]) && (calcMethod = CalcMethodPersistencyManager.getCalcMethod((String)result[0])) != null) {
                StringBuffer strBuffer = new StringBuffer(calcMethod.getCode());
                strBuffer.append(' ').append(calcMethod.getName(languageForLanguageDependentTexts));
                result[1] = strBuffer.toString();
            }
        } else if (FIELD_DEPRECPERCENT.equals(fieldName)) {
            result[0] = BigDecimalMapper.toString((BigDecimal)faArea.getDepreciationPercent().setScale(2, RoundingMode.HALF_DOWN));
            StringBuffer strBuffer = new StringBuffer(bdFormatter.toString(faArea.getDepreciationPercent()));
            strBuffer.append(" %");
            result[1] = strBuffer.toString();
        } else if (FIELD_SHIFTFACTOR.equals(fieldName)) {
            result[0] = BigDecimalMapper.toString((BigDecimal)faArea.getShiftFactor().setScale(2, RoundingMode.HALF_DOWN));
            result[1] = bdFormatter.toString(faArea.getShiftFactor());
        } else if (FIELD_SPECDEPRMETHOD.equals(fieldName)) {
            CalcMethod calcMethod;
            result[0] = faArea.getOidSpecDepreciationMethod();
            if (!StringMapper.isNullString((String)result[0]) && (calcMethod = CalcMethodPersistencyManager.getCalcMethod((String)result[0])) != null) {
                StringBuffer strBuffer = new StringBuffer(calcMethod.getCode());
                strBuffer.append(' ').append(calcMethod.getName(languageForLanguageDependentTexts));
                result[1] = strBuffer.toString();
            }
        } else if (FIELD_SPECDEPREPERCENT.equals(fieldName)) {
            result[0] = BigDecimalMapper.toString((BigDecimal)faArea.getSpecDepreciationPercent().setScale(2, RoundingMode.HALF_DOWN));
            StringBuffer strBuffer = new StringBuffer(bdFormatter.toString(faArea.getSpecDepreciationPercent()));
            strBuffer.append(" %");
            result[1] = strBuffer.toString();
        } else if (FIELD_DEPRBELOWZERO.equals(fieldName)) {
            result[0] = BooleanMapper.toString((boolean)faArea.getDepBelowZero());
            result[1] = BooleanMapper.toString((Language)globalLanguage, (boolean)faArea.getDepBelowZero());
        } else if (FIELD_DEPRRESIDUALVALUE.equals(fieldName)) {
            result[0] = BigDecimalMapper.toString((BigDecimal)faArea.getDepResValue().setScale(2, RoundingMode.HALF_DOWN));
            result[1] = bdFormatter.toString(faArea.getDepResValue());
        } else if (FIELD_REPLACEINDEX.equals(fieldName)) {
            if (faArea.getReplacementIndex() != null) {
                result[0] = faArea.getReplacementIndex().getObjectid();
                StringBuffer strBuffer = new StringBuffer(faArea.getReplacementIndex().getCode());
                strBuffer.append(' ').append(faArea.getReplacementIndex().getName(languageForLanguageDependentTexts));
                result[1] = strBuffer.toString();
            }
        } else if (FIELD_IMPINTERESTMETHOD.equals(fieldName)) {
            CalcMethod calcMethod;
            result[0] = faArea.getOidImputedInterestMethod();
            if (!StringMapper.isNullString((String)result[0]) && (calcMethod = CalcMethodPersistencyManager.getCalcMethod((String)result[0])) != null) {
                StringBuffer strBuffer = new StringBuffer(calcMethod.getCode());
                strBuffer.append(' ').append(calcMethod.getName(languageForLanguageDependentTexts));
                result[1] = strBuffer.toString();
            }
        } else if (FIELD_IMPINTERESTPERCENT.equals(fieldName)) {
            result[0] = BigDecimalMapper.toString((BigDecimal)faArea.getImputedInterestPercent().setScale(2, RoundingMode.HALF_DOWN));
            result[1] = bdFormatter.toString(faArea.getSpecDepreciationPercent());
        } else if (FIELD_AC0.equals(fieldName)) {
            result[0] = fixedAsset.getAnalysisCodes()[0];
            result[1] = result[0];
        } else if (FIELD_AC1.equals(fieldName)) {
            result[0] = fixedAsset.getAnalysisCodes()[1];
            result[1] = result[0];
        } else if (FIELD_AC2.equals(fieldName)) {
            result[0] = fixedAsset.getAnalysisCodes()[2];
            result[1] = result[0];
        } else if (FIELD_AC3.equals(fieldName)) {
            result[0] = fixedAsset.getAnalysisCodes()[3];
            result[1] = result[0];
        } else if (FIELD_AC4.equals(fieldName)) {
            result[0] = fixedAsset.getAnalysisCodes()[4];
            result[1] = result[0];
        } else if (FIELD_AC5.equals(fieldName)) {
            result[0] = fixedAsset.getAnalysisCodes()[5];
            result[1] = result[0];
        } else if (FIELD_AC6.equals(fieldName)) {
            result[0] = fixedAsset.getAnalysisCodes()[6];
            result[1] = result[0];
        } else if (FIELD_AC7.equals(fieldName)) {
            result[0] = fixedAsset.getAnalysisCodes()[7];
            result[1] = result[0];
        } else if (FIELD_AC8.equals(fieldName)) {
            result[0] = fixedAsset.getAnalysisCodes()[8];
            result[1] = result[0];
        } else if (FIELD_AC9.equals(fieldName)) {
            result[0] = fixedAsset.getAnalysisCodes()[9];
            result[1] = result[0];
        } else if (FIELD_PERSONS.equals(fieldName)) {
            if (fixedAsset.getPerson() != null) {
                result[0] = fixedAsset.getPerson().getObjectid();
                StringBuffer strBuffer = new StringBuffer(fixedAsset.getPerson().getCode());
                strBuffer.append(' ').append(fixedAsset.getPerson().getNames().getString((ILanguage)languageForLanguageDependentTexts));
                result[1] = strBuffer.toString();
            }
        } else {
            throw ExceptionMapper.makeApplicationException((String)("Invalid Fieldname >" + fieldName + "<  ; in: FixedAssetQuickChangeAttrMapper:getFixedAssetFieldNames"));
        }
        return result;
    }

    public static String getNewValueForFixedAsset(String fieldName, String newValue, Language globalLanguage, Language languageForLanguageDependentTexts) throws BusinessDomainException {
        BigDecimalFormatter bdFormatter = new BigDecimalFormatter(globalLanguage.getLocale(), Integer.valueOf(2));
        String result = "";
        if (StringMapper.isNullString((String)newValue)) {
            return result;
        }
        if (FIELD_ASSETGROUPS.equals(fieldName)) {
            FixedAsset fa = FixedAssetPersistencyManager.getFixedAssetWithCache((String)newValue);
            if (fa != null) {
                StringBuffer strBuffer = new StringBuffer(fa.getCode());
                strBuffer.append(' ').append(fa.getName(languageForLanguageDependentTexts));
                result = strBuffer.toString();
            }
        } else if (FIELD_FIXEDASSETTYPE.equals(fieldName)) {
            int assetType = Integer.parseInt(newValue);
            result = AssetTypeMapper.toString((Language)globalLanguage, (AssetTypeEnum)AssetTypeMapper.toAssetType((int)assetType));
        } else if (FIELD_QUANTITYUNIT.equals(fieldName)) {
            QuantityUnit quantUnit = QuantityUnitPersistencyManager.getQuantityUnit((String)newValue);
            if (quantUnit != null) {
                StringBuffer strBuffer = new StringBuffer(quantUnit.getCode());
                strBuffer.append(' ').append(quantUnit.getNames().getString((ILanguage)languageForLanguageDependentTexts));
                result = strBuffer.toString();
            }
        } else if (FIELD_QUANTITY.equals(fieldName)) {
            BigDecimal quantity = new BigDecimal(newValue);
            quantity = quantity.setScale(5, RoundingMode.HALF_DOWN);
            result = bdFormatter.toString(quantity, 5);
        } else if (FIELD_LOCATIONS.equals(fieldName)) {
            Falocation location = FalocationPersistencyManager.getFalocation((String)newValue);
            if (location != null) {
                StringBuffer strBuffer = new StringBuffer(location.getCode());
                strBuffer.append(' ').append(location.getNames().getString((ILanguage)languageForLanguageDependentTexts));
                result = strBuffer.toString();
            }
        } else if (FIELD_PROJECTS.equals(fieldName)) {
            FAProject project = FAProjectPersistencyManager.getFAProject((String)newValue);
            if (project != null) {
                StringBuffer strBuffer = new StringBuffer(project.getCode());
                strBuffer.append(' ').append(project.getNames().getString((ILanguage)languageForLanguageDependentTexts));
                result = strBuffer.toString();
            }
        } else if (FIELD_ASSETACCOUNTS.equals(fieldName) || FIELD_VALUATIONACC.equals(fieldName) || FIELD_ACCVALSPECDEPR.equals(fieldName) || FIELD_NEWADDOFFSACC.equals(fieldName) || FIELD_DISPOSOFFSACC.equals(fieldName)) {
            NominalLedgerAccount nlAccount = NominalLedgerItemPersistencyManager.getNominalLedgerAccount((String)newValue);
            if (nlAccount != null) {
                StringBuffer strBuffer = new StringBuffer(nlAccount.getCode());
                strBuffer.append(' ').append(nlAccount.getLocalizedStringContainer().getString((ILanguage)languageForLanguageDependentTexts));
                result = strBuffer.toString();
            }
        } else if (FIELD_SUPPLIERS.equals(fieldName)) {
            PersonalAccount persAcc = PersonalAccountPersistencyManager.getPersonalAccount((String)newValue);
            if (persAcc != null) {
                StringBuffer strBuffer = new StringBuffer(persAcc.getCode());
                strBuffer.append(' ').append(persAcc.getShortAddress());
                result = strBuffer.toString();
            }
        } else if (FIELD_COSTCENTRES.equals(fieldName)) {
            CostCentreBase costCenter = CostCentreBasePersistencyManager.getCostCentreBase((String)newValue);
            if (costCenter != null) {
                StringBuffer strBuffer = new StringBuffer(costCenter.getCurrentIdentifier().getCode());
                strBuffer.append(' ').append(costCenter.getCurrentIdentifier().getDescriptions().getLocalizedString((ILanguage)languageForLanguageDependentTexts).getText());
                result = strBuffer.toString();
            }
        } else if (FIELD_COSTUNITS.equals(fieldName)) {
            CostUnit costUnit = CostUnitPersistencyManager.getCostUnit((String)newValue);
            if (costUnit != null) {
                StringBuffer strBuffer = new StringBuffer(costUnit.getCode());
                strBuffer.append(' ').append(costUnit.getDescriptions().getLocalizedString((ILanguage)languageForLanguageDependentTexts).getText());
                result = strBuffer.toString();
            }
        } else if (FIELD_ACCOUNTGROUP.equals(fieldName)) {
            AccountGroup accGroup = AccountGroupPersistencyManager.getAccountGroup((String)newValue);
            if (accGroup != null) {
                StringBuffer strBuffer = new StringBuffer(accGroup.getCode());
                strBuffer.append(' ').append(accGroup.getName(languageForLanguageDependentTexts));
                result = strBuffer.toString();
            }
        } else if (FIELD_DEPRMETHOD.equals(fieldName) || FIELD_SPECDEPRMETHOD.equals(fieldName) || FIELD_IMPINTERESTMETHOD.equals(fieldName)) {
            CalcMethod calcMethod = CalcMethodPersistencyManager.getCalcMethod((String)newValue);
            if (calcMethod != null) {
                StringBuffer strBuffer = new StringBuffer(calcMethod.getCode());
                strBuffer.append(' ').append(calcMethod.getName(languageForLanguageDependentTexts));
                result = strBuffer.toString();
            }
        } else if (FIELD_DEPRECPERCENT.equals(fieldName) || FIELD_SPECDEPREPERCENT.equals(fieldName) || FIELD_IMPINTERESTPERCENT.equals(fieldName)) {
            StringBuffer strBuffer = new StringBuffer(bdFormatter.toString(new BigDecimal(newValue)));
            strBuffer.append(" %");
            result = strBuffer.toString();
        } else if (FIELD_SHIFTFACTOR.equals(fieldName)) {
            result = bdFormatter.toString(new BigDecimal(newValue));
        } else if (FIELD_DEPRRESIDUALVALUE.equals(fieldName)) {
            result = bdFormatter.toString(new BigDecimal(newValue));
        } else if (FIELD_REPLACEINDEX.equals(fieldName)) {
            IndexSeries index = IndexSeriesPersistencyManager.getIndexSeries((String)newValue);
            if (index != null) {
                StringBuffer strBuffer = new StringBuffer(index.getCode());
                strBuffer.append(' ').append(index.getName(languageForLanguageDependentTexts));
                result = strBuffer.toString();
            }
        } else if (FIELD_PERSONS.equals(fieldName)) {
            FAPerson person = FAPersonPersistencyManager.getFAPerson((String)newValue);
            if (person != null) {
                StringBuffer strBuffer = new StringBuffer(person.getCode());
                strBuffer.append(' ').append(person.getNames().getString((ILanguage)languageForLanguageDependentTexts));
                result = strBuffer.toString();
            }
        } else {
            result = newValue;
        }
        return result;
    }

    public static void setNewValueForFixedAsset(FixedAssetData fixedAsset, FixedAssetArea faArea, String fieldName, String oldValue, String newValue, Language globalLanguage, boolean replace) throws BusinessDomainException {
        boolean fixedAssetChanged = false;
        boolean faAreaChanged = false;
        if (FIELD_ASSETGROUPS.equals(fieldName)) {
            FixedAsset faParent = null;
            if (!StringMapper.isNullString((String)newValue)) {
                faParent = FixedAssetPersistencyManager.getFixedAssetWithCache((String)newValue);
            }
            if (faParent != null) {
                fixedAsset.setParent(faParent);
                fixedAssetChanged = true;
            }
        } else if (FIELD_SHORTNAME.equals(fieldName)) {
            fixedAssetChanged = QuickChangeAttributeMapper.setNewShortNames(fixedAsset, oldValue, newValue, globalLanguage, replace);
        } else if (FIELD_FIXEDASSETTYPE.equals(fieldName)) {
            int assetType = Integer.parseInt(newValue);
            fixedAsset.setAssetType(AssetTypeMapper.toAssetType((int)assetType));
            fixedAssetChanged = true;
        } else if (FIELD_QUANTITYUNIT.equals(fieldName)) {
            QuantityUnit quantUnit = null;
            String oidQuantityUnit = "";
            if (!StringMapper.isNullString((String)newValue) && (quantUnit = QuantityUnitPersistencyManager.getQuantityUnit((String)newValue)) != null) {
                oidQuantityUnit = quantUnit.getObjectid();
            }
            fixedAsset.setOidQuantityUnit(oidQuantityUnit);
            fixedAssetChanged = true;
        } else if (FIELD_QUANTITY.equals(fieldName)) {
            fixedAsset.setQuantity(newValue);
            fixedAssetChanged = true;
        } else if (FIELD_LOCATIONS.equals(fieldName)) {
            Falocation location = null;
            if (!StringMapper.isNullString((String)newValue)) {
                location = FalocationPersistencyManager.getFalocation((String)newValue);
            }
            fixedAsset.setLocation(location);
            fixedAssetChanged = true;
        } else if (FIELD_PROJECTS.equals(fieldName)) {
            FAProject project = null;
            if (!StringMapper.isNullString((String)newValue)) {
                project = FAProjectPersistencyManager.getFAProject((String)newValue);
            }
            fixedAsset.setProject(project);
            fixedAssetChanged = true;
        } else if (FIELD_ASSETACCOUNTS.equals(fieldName)) {
            NominalLedgerAccount nlAccount = null;
            if (!StringMapper.isNullString((String)newValue)) {
                nlAccount = NominalLedgerItemPersistencyManager.getNominalLedgerAccount((String)newValue);
            }
            if (nlAccount != null) {
                QuickChangeAttributeMapper.createNewTransaction(globalLanguage, fixedAsset, faArea, nlAccount);
                fixedAsset.setAssetAccount(nlAccount);
                fixedAssetChanged = true;
            }
        } else if (FIELD_VALUATIONACC.equals(fieldName)) {
            NominalLedgerAccount nlAccount = null;
            if (!StringMapper.isNullString((String)newValue)) {
                nlAccount = NominalLedgerItemPersistencyManager.getNominalLedgerAccount((String)newValue);
            }
            fixedAsset.setAccValuationDepreciation(nlAccount);
            fixedAssetChanged = true;
        } else if (FIELD_ACCVALSPECDEPR.equals(fieldName)) {
            NominalLedgerAccount nlAccount = null;
            if (!StringMapper.isNullString((String)newValue)) {
                nlAccount = NominalLedgerItemPersistencyManager.getNominalLedgerAccount((String)newValue);
            }
            fixedAsset.setAccValuationSpecDepreciation(nlAccount);
            fixedAssetChanged = true;
        } else if (FIELD_NEWADDOFFSACC.equals(fieldName)) {
            NominalLedgerAccount nlAccount = null;
            if (!StringMapper.isNullString((String)newValue)) {
                nlAccount = NominalLedgerItemPersistencyManager.getNominalLedgerAccount((String)newValue);
            }
            fixedAsset.setNewAddOffsetAccount(nlAccount);
            fixedAssetChanged = true;
        } else if (FIELD_DISPOSOFFSACC.equals(fieldName)) {
            NominalLedgerAccount nlAccount = null;
            if (!StringMapper.isNullString((String)newValue)) {
                nlAccount = NominalLedgerItemPersistencyManager.getNominalLedgerAccount((String)newValue);
            }
            fixedAsset.setDisposalOffsetAccount(nlAccount);
            fixedAssetChanged = true;
        } else if (FIELD_SUPPLIERS.equals(fieldName)) {
            fixedAssetChanged = QuickChangeAttributeMapper.setNewSupplier(fixedAsset, oldValue, newValue, replace);
        } else if (FIELD_COSTCENTRES.equals(fieldName)) {
            fixedAssetChanged = QuickChangeAttributeMapper.setNewCostCenter(fixedAsset, oldValue, newValue, replace);
        } else if (FIELD_COSTUNITS.equals(fieldName)) {
            fixedAsset.setOidCostUnit(newValue);
            fixedAssetChanged = true;
        } else if (FIELD_ACCOUNTGROUP.equals(fieldName)) {
            AccountGroup accGroup = null;
            if (!StringMapper.isNullString((String)newValue)) {
                accGroup = AccountGroupPersistencyManager.getAccountGroup((String)newValue);
            }
            faArea.setAccountGroup(accGroup);
            faAreaChanged = true;
        } else if (FIELD_LIFEINMONTH.equals(fieldName)) {
            Date endDate;
            faArea.setUsefullLifeInMonth(Integer.parseInt(newValue));
            int lifeInDays = FixedAssetArea.calculateLifeInDays((Date)fixedAsset.getAcquisitionDate(), (Date)faArea.getDeprStartDate(), (int)Integer.parseInt(newValue));
            faArea.setUsefullLifeInDays(lifeInDays);
            Date startDate = faArea.getDeprStartDate();
            if (startDate == null) {
                startDate = fixedAsset.getAcquisitionDate();
            }
            if ((endDate = faArea.getProcessingDate()) == null) {
                endDate = faArea.getLastDeprDate();
            }
            if (endDate == null) {
                faArea.setResidualLifeInMonth(Integer.parseInt(newValue));
                faArea.setResLifeInDays(lifeInDays);
            } else {
                faArea.setResidualLifeInMonth(FixedAssetArea.calculateResidualLifeInMonth((int)Integer.parseInt(newValue), (Date)startDate, (Date)endDate));
                int resLifeInDays = 0;
                resLifeInDays = FixedAssetArea.calculateResLifeInDays((int)lifeInDays, (Date)startDate, (Date)endDate, (boolean)true);
                faArea.setResLifeInDays(resLifeInDays);
            }
            faAreaChanged = true;
        } else if (FIELD_DEPRMETHOD.equals(fieldName)) {
            faArea.setOidDepreciationMethod(newValue);
            faAreaChanged = true;
            if (!StringMapper.isNullString((String)newValue)) {
                CalcMethod calcMethod = CalcMethodPersistencyManager.getCalcMethod((String)newValue);
                if (calcMethod != null) {
                    if (calcMethod instanceof DepreciationPlanMethodData) {
                        faArea.setDepreciationPercent(BigDecimal.ZERO);
                    } else {
                        DepreciationMethodData deprMethod = (DepreciationMethodData)calcMethod;
                        if (deprMethod != null) {
                            BigDecimal newDeprPercent;
                            if (deprMethod.getDepreciationType() == DepreciationTypeEnum.DTE_DECLINING_SINGLE_COEFFICIENT) {
                                newDeprPercent = new BigDecimal(1200.0 / (double)faArea.getUsefullLifeInMonth()).multiply(deprMethod.getPercentage());
                                if (newDeprPercent.compareTo(BigDecimal.valueOf(100L)) > 0) {
                                    newDeprPercent = BigDecimal.valueOf(100L);
                                }
                                faArea.setDepreciationPercent(newDeprPercent);
                            }
                            if (deprMethod.getDepreciationType() == DepreciationTypeEnum.DTE_STRAIGHT_LINE || deprMethod.getDepreciationType() == DepreciationTypeEnum.DTE_DECLINING_BAL || deprMethod.getDepreciationType() == DepreciationTypeEnum.DTE_DISTR_REM_LIFE) {
                                newDeprPercent = BigDecimal.ZERO;
                                if (!BigDecimalMapper.isZeroOrNull((BigDecimal)deprMethod.getPercentage())) {
                                    newDeprPercent = deprMethod.getPercentage();
                                    if (newDeprPercent.compareTo(BigDecimal.valueOf(100L)) > 0) {
                                        newDeprPercent = BigDecimal.valueOf(100L);
                                    }
                                } else {
                                    newDeprPercent = new BigDecimal(1200 / faArea.getUsefullLifeInMonth());
                                }
                                faArea.setDepreciationPercent(newDeprPercent);
                            }
                        }
                    }
                }
            } else {
                faArea.setDepreciationPercent(BigDecimal.ZERO);
            }
        } else if (FIELD_SPECDEPRMETHOD.equals(fieldName)) {
            faArea.setOidSpecDepreciationMethod(newValue);
            faAreaChanged = true;
        } else if (FIELD_IMPINTERESTMETHOD.equals(fieldName)) {
            faArea.setOidImputedInterestMethod(newValue);
            faAreaChanged = true;
        } else if (FIELD_DEPRECPERCENT.equals(fieldName)) {
            faArea.setDepreciationPercent(new BigDecimal(newValue));
            faAreaChanged = true;
        } else if (FIELD_SPECDEPREPERCENT.equals(fieldName)) {
            faArea.setSpecDepreciationPercent(new BigDecimal(newValue));
            faAreaChanged = true;
        } else if (FIELD_DEPRBELOWZERO.equals(fieldName)) {
            faArea.setDepBelowZero(BooleanMapper.toBoolean((String)newValue));
            faAreaChanged = true;
        } else if (FIELD_IMPINTERESTPERCENT.equals(fieldName)) {
            faArea.setImputedInterestPercent(new BigDecimal(newValue));
            faAreaChanged = true;
        } else if (FIELD_SHIFTFACTOR.equals(fieldName)) {
            faArea.setShiftFactor(new BigDecimal(newValue));
            faAreaChanged = true;
        } else if (FIELD_DEPRRESIDUALVALUE.equals(fieldName)) {
            faArea.setDepResValue(new BigDecimal(newValue));
            faAreaChanged = true;
        } else if (FIELD_REPLACEINDEX.equals(fieldName)) {
            IndexSeries index = null;
            if (!StringMapper.isNullString((String)newValue)) {
                index = IndexSeriesPersistencyManager.getIndexSeries((String)newValue);
            }
            faArea.setReplacementIndex(index);
            faAreaChanged = true;
        } else if (FIELD_AC0.equals(fieldName)) {
            String[] analCodes = fixedAsset.getAnalysisCodes();
            analCodes[0] = newValue;
            fixedAsset.setAnalysisCodes(analCodes);
            fixedAssetChanged = true;
        } else if (FIELD_AC1.equals(fieldName)) {
            String[] analCodes = fixedAsset.getAnalysisCodes();
            analCodes[1] = newValue;
            fixedAsset.setAnalysisCodes(analCodes);
            fixedAssetChanged = true;
        } else if (FIELD_AC2.equals(fieldName)) {
            String[] analCodes = fixedAsset.getAnalysisCodes();
            analCodes[2] = newValue;
            fixedAsset.setAnalysisCodes(analCodes);
            fixedAssetChanged = true;
        } else if (FIELD_AC3.equals(fieldName)) {
            String[] analCodes = fixedAsset.getAnalysisCodes();
            analCodes[3] = newValue;
            fixedAsset.setAnalysisCodes(analCodes);
            fixedAssetChanged = true;
        } else if (FIELD_AC4.equals(fieldName)) {
            String[] analCodes = fixedAsset.getAnalysisCodes();
            analCodes[4] = newValue;
            fixedAsset.setAnalysisCodes(analCodes);
            fixedAssetChanged = true;
        } else if (FIELD_AC5.equals(fieldName)) {
            String[] analCodes = fixedAsset.getAnalysisCodes();
            analCodes[5] = newValue;
            fixedAsset.setAnalysisCodes(analCodes);
            fixedAssetChanged = true;
        } else if (FIELD_AC6.equals(fieldName)) {
            String[] analCodes = fixedAsset.getAnalysisCodes();
            analCodes[6] = newValue;
            fixedAsset.setAnalysisCodes(analCodes);
            fixedAssetChanged = true;
        } else if (FIELD_AC7.equals(fieldName)) {
            String[] analCodes = fixedAsset.getAnalysisCodes();
            analCodes[7] = newValue;
            fixedAsset.setAnalysisCodes(analCodes);
            fixedAssetChanged = true;
        } else if (FIELD_AC8.equals(fieldName)) {
            String[] analCodes = fixedAsset.getAnalysisCodes();
            analCodes[8] = newValue;
            fixedAsset.setAnalysisCodes(analCodes);
            fixedAssetChanged = true;
        } else if (FIELD_AC9.equals(fieldName)) {
            String[] analCodes = fixedAsset.getAnalysisCodes();
            analCodes[9] = newValue;
            fixedAsset.setAnalysisCodes(analCodes);
            fixedAssetChanged = true;
        } else if (FIELD_PERSONS.equals(fieldName)) {
            FAPerson person = null;
            if (!StringMapper.isNullString((String)newValue)) {
                person = FAPersonPersistencyManager.getFAPerson((String)newValue);
            }
            fixedAsset.setPerson(person);
            fixedAssetChanged = true;
        }
        if (faAreaChanged) {
            faArea.makeSaveable();
        }
        if (fixedAssetChanged) {
            fixedAsset.makeSaveable();
        }
    }

    private static boolean setNewSupplier(FixedAssetData fixedAsset, String oldValue, String newValue, boolean replace) {
        LinkedList<PersonalAccount> newSupplAccList = new LinkedList<PersonalAccount>();
        boolean containsAllrNewSuppl = false;
        boolean fixedAssetChanged = false;
        PersonalAccount newPersAcc = null;
        if (!StringMapper.isNullString((String)newValue)) {
            newPersAcc = PersonalAccountPersistencyManager.getPersonalAccount((String)newValue);
        }
        PersonalAccount[] supplAccounts = fixedAsset.getSupplAccounts();
        for (int i = 0; i < supplAccounts.length; ++i) {
            if (!supplAccounts[i].getObjectid().equals(oldValue)) {
                newSupplAccList.add(supplAccounts[i]);
            }
            if (newPersAcc == null || !supplAccounts[i].getObjectid().equals(newPersAcc.getObjectid())) continue;
            containsAllrNewSuppl = true;
        }
        if (newPersAcc != null && !containsAllrNewSuppl) {
            if (replace && StringMapper.isNullString((String)oldValue)) {
                if (supplAccounts.length == 0) {
                    newSupplAccList.add(newPersAcc);
                    fixedAssetChanged = true;
                }
            } else {
                newSupplAccList.add(newPersAcc);
                fixedAssetChanged = true;
            }
        }
        PersonalAccount[] newSupplAccounts = new PersonalAccount[newSupplAccList.size()];
        newSupplAccList.toArray(newSupplAccounts);
        fixedAsset.setSupplAccounts(newSupplAccounts);
        if (fixedAsset.getOidSupplierAccount() == null || fixedAsset.getOidSupplierAccount().equals(oldValue)) {
            fixedAsset.setOidSupplierAccount(newValue);
            fixedAssetChanged = true;
        }
        return fixedAssetChanged;
    }

    private static boolean setNewCostCenter(FixedAssetData fixedAsset, String oldValue, String newValue, boolean replace) throws BusinessDomainException {
        LinkedList<FACostCentre> newCostCentreList = new LinkedList<FACostCentre>();
        boolean containsAllrNewCostCentre = false;
        boolean fixedAssetChanged = false;
        FACostCentre oldFACostCentre = null;
        CostCentreBase newCostCentre = null;
        if (!StringMapper.isNullString((String)newValue)) {
            newCostCentre = CostCentreBasePersistencyManager.getCostCentreBase((String)newValue);
        }
        FACostCentre[] faCostCentre = fixedAsset.getCostCenters();
        for (int i = 0; i < faCostCentre.length; ++i) {
            if (!faCostCentre[i].getCostCentreBase().getObjectid().equals(oldValue)) {
                newCostCentreList.add(faCostCentre[i]);
            } else {
                oldFACostCentre = faCostCentre[i];
            }
            if (newCostCentre == null || !faCostCentre[i].getCostCentreBase().getObjectid().equals(newCostCentre.getObjectid())) continue;
            containsAllrNewCostCentre = true;
        }
        if (newCostCentre != null && !containsAllrNewCostCentre) {
            FACostCentre newFACostCentre = new FACostCentre(fixedAsset);
            newFACostCentre.setCostCentreBase(newCostCentre);
            newFACostCentre.setShare(1);
            if (replace && StringMapper.isNullString((String)oldValue)) {
                if (faCostCentre.length == 0) {
                    newCostCentreList.add(newFACostCentre);
                    fixedAssetChanged = true;
                }
            } else {
                if (replace) {
                    newFACostCentre.setShare(oldFACostCentre.getShare());
                }
                newCostCentreList.add(newFACostCentre);
                fixedAssetChanged = true;
            }
        }
        FACostCentre[] newFACostCentres = new FACostCentre[newCostCentreList.size()];
        newCostCentreList.toArray(newFACostCentres);
        fixedAsset.setCostCenters(newFACostCentres);
        if (fixedAsset.getCostCentreBase() == null || fixedAsset.getCostCentreBase().getObjectid().equals(oldValue)) {
            fixedAsset.setCostCentreBase(newCostCentre);
            fixedAssetChanged = true;
        }
        return fixedAssetChanged;
    }

    private static boolean setNewShortNames(FixedAssetData fixedAsset, String oldValue, String newValue, Language globalLanguage, boolean replace) throws BusinessDomainException {
        boolean fixedAssetChanged = false;
        LocalizedStringStruct[] shortNames = LocalizedStringMapper.toIdl((LocalizedStringContainer)fixedAsset.getShortNames());
        for (int i = 0; i < shortNames.length; ++i) {
            if (!shortNames[i].oidLanguage.equals(globalLanguage.getObjectid())) continue;
            if (!replace) {
                shortNames[i].text = newValue;
                fixedAssetChanged = true;
                continue;
            }
            if (!shortNames[i].text.equals(oldValue)) continue;
            shortNames[i].text = newValue;
            fixedAssetChanged = true;
        }
        if (fixedAssetChanged) {
            fixedAsset.setNames(shortNames);
        }
        return fixedAssetChanged;
    }

    private static void createNewTransaction(Language globalLanguage, FixedAssetData fixedAsset, FixedAssetArea faArea, NominalLedgerAccount nlAccount) throws BusinessDomainException {
        FixedAssetTransaction faTransaction = new FixedAssetTransaction();
        faTransaction.setAmount(BigDecimalMapper.ZERO);
        faTransaction.setOidCompany(fixedAsset.getAccountCompany().getObjectid());
        faTransaction.setTransactionEnum(TransactionEnum.TRE_NOM_LEDGER_TRANSFER);
        faTransaction.setTransactionSeqNumber(FATransactionSequenceNoPersistencyManager.getNextNumber((AccountingCompany)fixedAsset.getAccountCompany()));
        faTransaction.setFixedAsset(fixedAsset);
        faTransaction.setDeprArea(faArea.getDeprArea());
        ArrayList<FAFinancialYear> finYearsList = new ArrayList<FAFinancialYear>(Arrays.asList(FAFinancialYear.getFAFinancialYears((AccountingCompany)fixedAsset.getAccountCompany())));
        FAFinancialYear lastFinYear = (FAFinancialYear)finYearsList.get(finYearsList.size() - 1);
        if (faArea.getProcessingDate() != null) {
            faTransaction.setProcessingDate(DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)faArea.getProcessingDate())));
        } else if (faArea.getLastDeprDate() != null) {
            faTransaction.setProcessingDate(DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)faArea.getLastDeprDate())));
        } else if (faArea.getDeprStartDate() != null) {
            faTransaction.setProcessingDate(DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)faArea.getDeprStartDate())));
        } else {
            faTransaction.setProcessingDate(DateHelper.getFirstDayOfMonth((Date)lastFinYear.getValidFrom()));
        }
        faTransaction.setFinancialYear(FAFinancialYear.getFAFinancialYearForDate((AccountingCompany)fixedAsset.getAccountCompany(), (Date)faTransaction.getProcessingDate()));
        faTransaction.setDocumentDate(faTransaction.getProcessingDate());
        faTransaction.setTransactionDate(faTransaction.getProcessingDate());
        VDate vdate = new VDate(faTransaction.getProcessingDate());
        Object refNumber = String.valueOf(vdate.getYear());
        if (faArea.getDeprArea().getDepreciationFrequencies().value() == 0) {
            refNumber = (String)refNumber + "/" + (vdate.getMonth() + 1);
        }
        faTransaction.setReferenceNumber((String)refNumber);
        faTransaction.setSequenceNumber("");
        faTransaction.setOrderNumber("");
        NLAccountCompanySetting nominalAccountSetting = nlAccount.getNLAccountCompanySetting(fixedAsset.getAccountCompany());
        faTransaction.setAssetAccount(nominalAccountSetting);
        NLAccountCompanySetting nominalAccountSettingOld = fixedAsset.getAssetAccount().getNLAccountCompanySetting(fixedAsset.getAccountCompany());
        faTransaction.setAssetAccountOld(nominalAccountSettingOld);
        faTransaction.setPostingText(TransactionMapper.toString((Language)globalLanguage, (TransactionEnum)TransactionEnum.TRE_NOM_LEDGER_TRANSFER));
        faTransaction.setQuantity(null);
        faTransaction.setQuantityUnit(null);
        faTransaction.setPersonalAccount(null);
        faTransaction.setFixedAsset(fixedAsset);
        faTransaction.setCalcMethod(null);
        faTransaction.setFullDisposDeprecUntil(FullDisposDeprecUntilEnum.DUE_NO_DEPRECIATION);
        faTransaction.setPartialDisposDeprecUntil(DepreciationFromUntilEnum.DFUE_BEGIN_FINANCIAL_YEAR);
        faTransaction.makeSaveable();
    }
}

