/*
 * Decompiled with CFR 0.152.
 */
package com.varial.assetaccounting.domain.fixedassetreport;

import com.infor.igf.core.util.StringUtil;
import com.varial.accounting.domain.financialyear.AccountingCompany;
import com.varial.accounting.domain.financialyear.AccountingCompanyPersistencyManager;
import com.varial.assetaccounting.domain.assetaccsetup.AssetaccountingSetup;
import com.varial.assetaccounting.domain.calculationmethod.CalcMethod;
import com.varial.assetaccounting.domain.calculationmethod.CalcMethodPersistencyManager;
import com.varial.assetaccounting.domain.calculationmethod.DepreciationMethodData;
import com.varial.assetaccounting.domain.depreciationarea.DepreciationArea;
import com.varial.assetaccounting.domain.depreciationarea.DepreciationAreaPersistencyManager;
import com.varial.assetaccounting.domain.fixedasset.FixedAsset;
import com.varial.assetaccounting.domain.fixedasset.FixedAssetArea;
import com.varial.assetaccounting.domain.fixedasset.FixedAssetAreaHistoryPersistencyManager;
import com.varial.assetaccounting.domain.fixedasset.FixedAssetData;
import com.varial.assetaccounting.domain.fixedasset.FixedAssetHistory;
import com.varial.assetaccounting.domain.fixedasset.FixedAssetHistoryMapper;
import com.varial.assetaccounting.domain.fixedasset.FixedAssetHistoryPersistencyManager;
import com.varial.assetaccounting.domain.fixedasset.FixedAssetMapper;
import com.varial.assetaccounting.domain.fixedasset.FixedAssetPersistencyManager;
import com.varial.assetaccounting.domain.fixedassetreport.FixedAssetReportFilterMapper;
import com.varial.assetaccounting.domain.fixedassetreport.QuickChangeReportContainer;
import com.varial.assetaccounting.domain.fixedassetreport.quickchangeattributes.QuickChangeAttributeMapper;
import com.varial.assetaccounting.fixedasset.FixedAssetStruct;
import com.varial.assetaccounting.fixedassetreport.FixedAssetReportFilterStruct;
import com.varial.assetaccounting.fixedassetreport.QuickChangeValueStruct;
import com.varial.assetaccounting.persistency.fixedasset.FixedassetContainer;
import com.varial.base.UtilitiesManager;
import com.varial.base.configuration.Configuration;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.jasperreports.JasperParameterHashMap;
import com.varial.base.jasperreports.ReportFlags;
import com.varial.base.session.SessionContext;
import com.varial.base.types.date.DateHelper;
import com.varial.framework.basictypes.ReportFileStructCallback;
import com.varial.framework.domain.quantityunit.QuantityUnit;
import com.varial.framework.domain.quantityunit.QuantityUnitPersistencyManager;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.domain.language.ILanguage;
import com.varial.serverbase.domain.language.Language;
import com.varial.serverbase.domain.language.LanguageManager;
import com.varial.serverbase.domain.locale.ILocalePersistencyManager;
import com.varial.serverbase.domain.resource.TranslateableResourceList;
import com.varial.serverbase.extendedquery.AttributeOperationEnum;
import com.varial.serverbase.mapper.BigDecimalFormatter;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.BooleanMapper;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.ExceptionMapper;
import com.varial.serverbase.mapper.StringMapper;
import com.varial.serverbase.persistency.SelectGeneratorDataSet;
import com.varial.serverbase.query.AllCallback;
import com.varial.shared.Version;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;

public class QuickChangeReportDataSource
implements JRDataSource {
    private final Configuration configuration = (Configuration)UtilitiesManager.getBean((String)"com.infor.igf.configuration", Configuration.class);
    private static final ILocalePersistencyManager localePersistencyManager = (ILocalePersistencyManager)UtilitiesManager.getBean((String)"localePersistencyManager", ILocalePersistencyManager.class);
    private final ReportFlags mReportFlags;
    private final Language mLanguageForLanguageDependentTexts;
    private Language mGlobalLanguage;
    private final String mRelease;
    private final String mDate;
    private final String mTime;
    private final String mUserID;
    private final String mCompanyShort;
    private boolean mHasNext = false;
    private int mZaehler = 0;
    private int mCountFAChanged;
    private int mRowCount;
    private int mRowsProcessed = 0;
    public FixedAssetReportFilterStruct mQuery;
    private String mDepreciationArea;
    private final Date mValidFromDate;
    private final String mDate1950 = "1950-01-01";
    private QuickChangeReportContainer mContainer;
    private final List<QuickChangeReportContainer> mContainerList;
    private final AllCallback mCallback;
    private final String[] mCallBackResult = new String[1];
    private static final String PROPKEY_RELEASEINFOPREFIX = "com.varial.reports.ReleaseInfoPrefix";
    private String mReleaseInfoPrefix;
    private final AccountingCompany mCompany;
    private final SelectGeneratorDataSet mDataset;
    private BigDecimalFormatter mBigDecimalFormatter;
    private boolean mIsAcquisitionValueFilterSet = false;
    private BigDecimal mFromAcquisitionValue;
    private BigDecimal mToAcquisitionValue;
    private boolean mIsResidualValueFilterSet = false;
    private BigDecimal mFromResidualValue;
    private BigDecimal mToResidualValue;
    private static final String PARAMETER_JASPERHELPER = "ReportFlags";
    private static final String PARAMETER_BIGDECIMALFORMATTER = "Parameter_BigDecimalFormatter";
    private static final String PARAMETER_COMPANYSHORT = "Parameter_CompanyShort";
    private static final String PARAMETER_DATE = "Parameter_Date";
    private static final String PARAMETER_TIME = "Parameter_Time";
    private static final String PARAMETER_USER = "Parameter_User";
    private static final String PARAMETER_DEPRECIATIONAREA = "Parameter_DepreciationArea";
    private static final String PARAMETER_RELEASE = "Parameter_Release";
    private static final String PARAMETER_PREVIEW = "Parameter_Preview";
    private static final String STATIC_TITLE = "Static_Title";
    private static final String STATIC_COMPANY = "Static_Company";
    private static final String STATIC_FINANCIALYEAR = "Static_FinancialYear";
    private static final String STATIC_DATE = "Static_Date";
    private static final String STATIC_TIME = "Static_Time";
    private static final String STATIC_USER = "Static_User";
    private static final String STATIC_PAGE = "Static_Page";
    private static final String STATIC_DEPRECIATIONAREA = "Static_DepreciationArea";
    private static final String STATIC_CODE = "Static_Code";
    private static final String STATIC_SHORTNAME_FULLNAME = "Static_Shortname_FullName";
    private static final String STATIC_FIELDNAME = "Static_FieldName";
    private static final String STATIC_OLDVALUE = "Static_OldValue";
    private static final String STATIC_NEWVALUE = "Static_NewValue";
    private static final int TITLE = 0;
    private static final int COMPANY = 1;
    private static final int FINANCIALYEAR = 2;
    private static final int DATE = 3;
    private static final int TIME = 4;
    private static final int USER = 5;
    private static final int PAGE = 6;
    private static final int CODE = 7;
    private static final int SHORTNAME = 8;
    private static final int DEPRECIATIONAREA = 9;
    private static final int FIELDNAME = 10;
    private static final int OLDVALUE = 11;
    private static final int NEWVALUE = 12;
    private static final int MESSAGE_FULLDISPOSED = 13;
    private static final int TITLE_PREVIEW = 14;
    public static final int COUNTCHANGEDFA = 15;
    private static final int MESSAGE_NOCOSTCENTRE = 16;
    private static final int MESSAGE_NOOFFSETACCFORADDITIONS = 17;
    private static final int MESSAGE_NOOFFSETACCFORDISPOSALS = 18;
    private static final int MESSAGE_NOVALUATIONACCOUNT = 19;
    private static final int MESSAGE_NOQUANTITYUNIT = 20;
    private static final int MESSAGE_NODEPRMETHOD = 21;
    private static final int MESSAGE_FIXDEPRPERCENTAGE = 22;
    private static final int MESSAGE_DEPRMETHODNOTALLOWED = 23;
    private static final int MESSAGE_SPECDEPRMETHODNOTALLOWED = 24;
    private static final int MESSAGE_DEPRBELOWZERONOTALLOWED = 25;
    private static final int MESSAGE_SPECDEPRNOTVALID = 25;
    private static final int MESSAGE_IMPUTEDINTERESTNOTVALID = 26;
    private static final int MESSAGE_NOIMPUTEDINTERESTMETHOD = 27;
    private static final String FIELD_SHORTNAME_FULLNAME = "Field_Shortname_FullName";
    private static final String FIELD_CODE = "Field_Code";
    private static final String FIELD_FIELDNAME = "Field_FieldName";
    private static final String FIELD_OLDVALUE = "Field_OldValue";
    private static final String FIELD_NEWVALUE = "Field_NewValue";
    private static final String FIELD_MESSAGE = "Field_Message";
    private static TranslateableResourceList mQuickChangeReportList = TranslateableResourceList.createTranslateableResourceList("AAQuickChangeReportList", new String[]{"Quick Change Report", "Company", "Financial Year", "Date", "Time", "User", "Page", "Code", "Short Name", "Depreciation Area", "Field Name", "Old Value", "New Value", "Keine Feld\u00e4nderung ! F\u00fcr dieses Anlagegut ist bereits ein Vollabgang erfolgt !", "Quick Change Preview", "Anzahl ge\u00e4nderte Anlageg\u00fcter: ", "Keine Feld\u00e4nderung ! Bei diesem Anlagegut fehlt die obligatorische Kostenstelle (siehe Einstellungen)!", "Keine Feld\u00e4nderung ! Bei diesem Anlagegut fehlt das obligatorische Verrechnungkonto f\u00fcr Zug\u00e4nge (siehe Einstellungen)!", "Keine Feld\u00e4nderung ! Bei diesem Anlagegut fehlt das obligatorische Verrechnungkonto f\u00fcr Abg\u00e4nge (siehe Einstellungen)!", "Keine Feld\u00e4nderung ! Bei diesem Anlagegut fehlt das obligatorische AfA-Wertberichtigungskonto (siehe Einstellungen)!", "Keine \u00c4nderung der Menge! Bei diesem Anlagegut wurde keine Mengeneinheit hinterlegt!", "Keine \u00c4nderung AfA-Prozentsatz! Bei diesem Anlagegut wurde keine Abschreibungsart hinterlegt!", "Keine \u00c4nderung AfA-Prozentsatz! Bei diesem Anlagegut wurde eine Abschreibungsart mit fixem %-Satz hinterlegt!", "Keine \u00c4nderung der Abschreibungsart! Bei dieser Anlagenart ist keine Abschreibungsart zul\u00e4ssig!", "Keine \u00c4nderung der Sonderabschreibungsart! Bei dieser Anlagenart ist keine Sonderabschreibungsart zul\u00e4ssig!", "Keine Feld\u00e4nderung ! Die Abschreibung unter Null wurde in diesem Bewertungsbereich nicht aktiviert!", "Keine \u00c4nderung der Sonderabschreibungsart! Sonderabschreibungen wurden im Bewertungsbereich nicht aktiviert!", "Keine Feld\u00e4nderung Zinsart oder Zins-%-Satz! Kalkulatorische Zinsen wurden im Bewertungsbereich nicht aktiviert!", "Keine \u00c4nderung des Zins-Prozentsatzes! Bei diesem Anlagegut wurde keine Zinsart hinterlegt!"});

    public QuickChangeReportDataSource(SelectGeneratorDataSet dataset, FixedAssetReportFilterStruct query, Language globalLanguage, AllCallback callback, int rowCount, String printTime) throws BusinessDomainException {
        int i;
        this.mDataset = dataset;
        this.mQuery = query;
        this.mCompany = AccountingCompanyPersistencyManager.getAccountingCompany((String)query.oidCompany);
        this.mRelease = Version.getVersion();
        try {
            this.mReleaseInfoPrefix = StringMapper.toString((String)this.configuration.getString(PROPKEY_RELEASEINFOPREFIX)).trim() + " ";
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mReportFlags = new ReportFlags();
        this.mCompanyShort = this.mCompany.getCurrentAddress().getShortName();
        this.mUserID = SessionContext.getInstance().getSession().getUserCode();
        this.mCallback = callback;
        this.mRowCount = rowCount * 2;
        this.mLanguageForLanguageDependentTexts = LanguageManager.getInstance().getLanguage(this.mQuery.languageForLanguageDependentTexts.oidTimestamp.objectid);
        this.mGlobalLanguage = localePersistencyManager.getLocalesContainsLanguage(this.mLanguageForLanguageDependentTexts) ? this.mLanguageForLanguageDependentTexts : globalLanguage;
        this.mDate = DateMapper.toString((ILanguage)this.mLanguageForLanguageDependentTexts, (Date)DateHelper.today());
        this.mTime = printTime;
        AssetaccountingSetup mAssetAccSetup = AssetaccountingSetup.getValidAssetaccountingSetup((AccountingCompany)this.mCompany);
        DepreciationArea deprArea = DepreciationAreaPersistencyManager.getDepreciationArea((String)this.mQuery.areaShortSeq[0].oidTs.objectid);
        this.mDepreciationArea = deprArea.getName(this.mLanguageForLanguageDependentTexts);
        if (StringMapper.isNullString((String)this.mDepreciationArea)) {
            this.mDepreciationArea = deprArea.getCode();
        }
        this.mBigDecimalFormatter = this.mLanguageForLanguageDependentTexts.hasLocale() ? new BigDecimalFormatter(this.mLanguageForLanguageDependentTexts.getLocale()) : new BigDecimalFormatter();
        this.mBigDecimalFormatter.setDecimalPlaces(Integer.valueOf(2));
        this.mValidFromDate = DateMapper.toDate((String)this.mQuery.fixedAssetReportType.changeTopic().validFromDate);
        for (i = 0; i < query.filtersSeq.length; ++i) {
            if (!query.filtersSeq[i].attributeCode.equals(FixedAssetReportFilterMapper.getField((int)23))) continue;
            this.mIsAcquisitionValueFilterSet = true;
            if (query.filtersSeq[i].operation.equals(AttributeOperationEnum.AOE_GREATEREQUAL)) {
                this.mFromAcquisitionValue = BigDecimalMapper.toBigDecimalZero((String)query.filtersSeq[i].stringValue);
            }
            if (!query.filtersSeq[i].operation.equals(AttributeOperationEnum.AOE_LESSEQUAL)) continue;
            this.mToAcquisitionValue = BigDecimalMapper.toBigDecimalZero((String)query.filtersSeq[i].stringValue);
        }
        for (i = 0; i < query.filtersSeq.length; ++i) {
            if (!query.filtersSeq[i].attributeCode.equals(FixedAssetReportFilterMapper.getField((int)24))) continue;
            this.mIsResidualValueFilterSet = true;
            if (query.filtersSeq[i].operation.equals(AttributeOperationEnum.AOE_GREATEREQUAL)) {
                this.mFromResidualValue = BigDecimalMapper.toBigDecimalZero((String)query.filtersSeq[i].stringValue);
            }
            if (!query.filtersSeq[i].operation.equals(AttributeOperationEnum.AOE_LESSEQUAL)) continue;
            this.mToResidualValue = BigDecimalMapper.toBigDecimalZero((String)query.filtersSeq[i].stringValue);
        }
        this.mContainerList = new LinkedList<QuickChangeReportContainer>();
        try {
            QuickChangeValueStruct[] valuesToChange = this.mQuery.fixedAssetReportType.changeTopic().changeSeq;
            String[] newValuesForProt = new String[valuesToChange.length];
            for (int i2 = 0; i2 < valuesToChange.length; ++i2) {
                if (valuesToChange[i2].attrib.attributeType.value() == 2) continue;
                newValuesForProt[i2] = QuickChangeAttributeMapper.getNewValueForFixedAsset(valuesToChange[i2].attrib.attributeCode, valuesToChange[i2].newStringValue, this.mGlobalLanguage, this.mLanguageForLanguageDependentTexts);
            }
            this.mCountFAChanged = 0;
            while (this.mDataset.hasNext()) {
                FixedassetContainer faContainer = (FixedassetContainer)this.mDataset.getNext()[0];
                FixedAssetArea faaArea = FixedAssetArea.getFixedAssetArea((FixedAsset)FixedAssetPersistencyManager.getFixedAssetData((String)faContainer.getObjectid()), (DepreciationArea)deprArea);
                if (this.mIsAcquisitionValueFilterSet && (this.mFromAcquisitionValue != null && faaArea.getAccumulatedValues().getAccumAcquisitionValue().compareTo(this.mFromAcquisitionValue) < 0 || this.mToAcquisitionValue != null && faaArea.getAccumulatedValues().getAccumAcquisitionValue().compareTo(this.mToAcquisitionValue) > 0) || this.mIsResidualValueFilterSet && (this.mFromResidualValue != null && faaArea.getAccumulatedValues().getNetBookValue().compareTo(this.mFromResidualValue) < 0 || this.mToResidualValue != null && faaArea.getAccumulatedValues().getNetBookValue().compareTo(this.mToResidualValue) > 0)) continue;
                String shortName = faaArea.getFixedAsset().getShortNames().getString((ILanguage)this.mLanguageForLanguageDependentTexts);
                String fieldName = "";
                String fieldNamePrinted = "";
                String oldValue = "";
                String[] oldValueFA = new String[2];
                String newValue = "";
                String message = "";
                FixedAssetData fad = (FixedAssetData)faaArea.getFixedAsset();
                FixedAssetData fadOld = new FixedAssetData(true);
                FixedAssetPersistencyManager.fillFixedAssetData((FixedAssetData)fadOld, (FixedassetContainer)FixedAssetPersistencyManager.getFixedAssetContainer((String)fad.getObjectid()));
                FixedAssetHistory[] fahs = FixedAssetHistoryPersistencyManager.getFixedAssetHistory((FixedAsset)fad);
                boolean valuesChanged = false;
                for (int i3 = 0; i3 < valuesToChange.length; ++i3) {
                    QuantityUnit qu;
                    fieldNamePrinted = QuickChangeAttributeMapper.getFieldName(valuesToChange[i3].attrib.attributeCode, this.mGlobalLanguage);
                    fieldName = valuesToChange[i3].attrib.attributeCode;
                    if (!StringMapper.isNullString((String)this.getAttributeIsChangeable(faaArea, valuesToChange[i3].attrib.attributeCode))) {
                        message = this.getAttributeIsChangeable(faaArea, valuesToChange[i3].attrib.attributeCode);
                        this.mContainerList.add(new QuickChangeReportContainer(faContainer.code, shortName, fieldNamePrinted, oldValue, newValue, message));
                        continue;
                    }
                    oldValueFA = QuickChangeAttributeMapper.getOldValueFromFixedAsset(faaArea, valuesToChange[i3].attrib.attributeCode, this.mGlobalLanguage, this.mLanguageForLanguageDependentTexts, valuesToChange[i3].oldStringValue);
                    if (valuesToChange[i3].replace) {
                        oldValue = valuesToChange[i3].oldStringValue;
                        if (valuesToChange[i3].attrib.attributeType.value() == 2) {
                            oldValue = BooleanMapper.toString((boolean)valuesToChange[i3].oldBooleanValue);
                        } else if (valuesToChange[i3].attrib.attributeType.value() == 1) {
                            if ("FA.QUANTITY".equals(valuesToChange[i3].attrib.attributeCode)) {
                                qu = QuantityUnitPersistencyManager.getQuantityUnit((String)fad.getOidQuantityUnit());
                                if (qu != null) {
                                    BigDecimal bdValue = new BigDecimal(oldValue);
                                    bdValue = bdValue.setScale(5, RoundingMode.HALF_DOWN);
                                    oldValue = BigDecimalMapper.toString((BigDecimal)bdValue);
                                }
                            } else {
                                BigDecimal bdValue = new BigDecimal(oldValue);
                                bdValue = bdValue.setScale(2, RoundingMode.HALF_DOWN);
                                oldValue = BigDecimalMapper.toString((BigDecimal)bdValue);
                            }
                        }
                    }
                    newValue = valuesToChange[i3].newStringValue;
                    if (valuesToChange[i3].attrib.attributeType.value() == 2) {
                        newValue = BooleanMapper.toString((boolean)valuesToChange[i3].newBooleanValue);
                    }
                    if (oldValueFA[0] == null) {
                        oldValueFA[0] = "";
                    }
                    if (oldValueFA[0].equals(newValue) || valuesToChange[i3].replace && !oldValueFA[0].equals(oldValue)) continue;
                    if (faaArea.getIsFullDisposed()) {
                        message = mQuickChangeReportList.getString((ILanguage)this.mGlobalLanguage, 13);
                        this.mContainerList.add(new QuickChangeReportContainer(faContainer.code, shortName, fieldName, oldValue, newValue, message));
                        continue;
                    }
                    if (!"FA.OIDCOSTCENTRE".equals(fieldName) && mAssetAccSetup.getCheckCostCentre() && fad.getCostCentreBase() == null) {
                        message = mQuickChangeReportList.getString((ILanguage)this.mGlobalLanguage, 16);
                        this.mContainerList.add(new QuickChangeReportContainer(faContainer.code, shortName, fieldNamePrinted, oldValue, newValue, message));
                        continue;
                    }
                    if (!"FA.OIDNEWADDOFFSACC".equals(fieldName) && mAssetAccSetup.getIsNewAddingOffsetAcc() && fad.getNewAddOffsetAccount() == null) {
                        message = mQuickChangeReportList.getString((ILanguage)this.mGlobalLanguage, 17);
                        this.mContainerList.add(new QuickChangeReportContainer(faContainer.code, shortName, fieldNamePrinted, oldValue, newValue, message));
                        continue;
                    }
                    if (!"FA.OIDDISPOSOFFSACC".equals(fieldName) && mAssetAccSetup.getIsDisposalOffsetAcc() && fad.getDisposalOffsetAccount() == null) {
                        message = mQuickChangeReportList.getString((ILanguage)this.mGlobalLanguage, 18);
                        this.mContainerList.add(new QuickChangeReportContainer(faContainer.code, shortName, fieldNamePrinted, oldValue, newValue, message));
                        continue;
                    }
                    if (!"FA.OIDVALUATIONACC".equals(fieldName) && mAssetAccSetup.getIsIndirDeprWithValAcc() && fad.getAccValuationDepreciation() == null) {
                        message = mQuickChangeReportList.getString((ILanguage)this.mGlobalLanguage, 19);
                        this.mContainerList.add(new QuickChangeReportContainer(faContainer.code, shortName, fieldNamePrinted, oldValue, newValue, message));
                        continue;
                    }
                    if (!this.mQuery.fixedAssetReportType.changeTopic().preview) {
                        QuickChangeAttributeMapper.setNewValueForFixedAsset(fad, faaArea, valuesToChange[i3].attrib.attributeCode, oldValue, newValue, this.mGlobalLanguage, valuesToChange[i3].replace);
                        valuesChanged = true;
                    }
                    oldValue = oldValueFA[1];
                    newValue = newValuesForProt[i3];
                    if (valuesToChange[i3].attrib.attributeType.value() == 2) {
                        if (valuesToChange[i3].replace) {
                            oldValue = BooleanMapper.toString((Language)this.mGlobalLanguage, (boolean)valuesToChange[i3].oldBooleanValue);
                        }
                        newValue = BooleanMapper.toString((Language)this.mGlobalLanguage, (boolean)valuesToChange[i3].newBooleanValue);
                    } else if ("FA.QUANTITY".equals(valuesToChange[i3].attrib.attributeCode) && (qu = QuantityUnitPersistencyManager.getQuantityUnit((String)fad.getOidQuantityUnit())) != null) {
                        BigDecimalFormatter bdFormatter = new BigDecimalFormatter(globalLanguage.getLocale());
                        BigDecimal quantity = new BigDecimal(valuesToChange[i3].newStringValue);
                        quantity = quantity.setScale((int)qu.getDecimalPlaces(), RoundingMode.HALF_DOWN);
                        newValue = bdFormatter.toString(quantity, (int)qu.getDecimalPlaces());
                    }
                    this.mContainerList.add(new QuickChangeReportContainer(faContainer.code, shortName, fieldNamePrinted, oldValue, newValue, ""));
                }
                if (valuesChanged) {
                    FixedAssetStruct faStructNew;
                    if (fahs.length == 0 && this.mValidFromDate != null && !DateHelper.beforeOrEqual((Date)this.mValidFromDate, (Date)DateMapper.toDate((String)"1950-01-01"))) {
                        FixedAssetStruct faStructOld = FixedAssetMapper.toIdl((FixedAsset)fadOld, (boolean)false);
                        FixedAssetHistory fahOld = new FixedAssetHistory("", -1, (FixedAsset)fadOld);
                        fahOld.setAccountingCompany(fadOld.getAccountCompany());
                        FixedAssetHistoryMapper.fillFixedAssetHistory((FixedAssetHistory)fahOld, (FixedAssetStruct)faStructOld, (String)fadOld.getCode(), (boolean)true, (Date)VDate.getDateMin(), (Date)DateHelper.yesterday((Date)this.mValidFromDate));
                        faStructNew = FixedAssetMapper.toIdl((FixedAsset)fad, (boolean)false);
                        FixedAssetHistory fahNew = new FixedAssetHistory("", -1, (FixedAsset)fad);
                        fahNew.setAccountingCompany(fad.getAccountCompany());
                        FixedAssetHistoryMapper.fillFixedAssetHistory((FixedAssetHistory)fahNew, (FixedAssetStruct)faStructNew, (String)fad.getCode(), (boolean)true, (Date)this.mValidFromDate, (Date)VDate.getDateMax());
                        fad.setValidFromDate(this.mValidFromDate);
                        fad.makeSaveable();
                        FixedAssetArea[] faaAreas = fad.getFixedAssetAreas();
                        for (int k = 0; k < faaAreas.length; ++k) {
                            if (!faaArea.getObjectid().equals(faaAreas[k].getObjectid())) continue;
                            faaArea = faaAreas[k];
                            faaArea.makeSaveable();
                        }
                    } else if (fahs.length > 0) {
                        Date validFromDate = this.mValidFromDate;
                        if (this.mValidFromDate == null) {
                            validFromDate = fad.getValidFromDate();
                        }
                        for (int j = 0; j < fahs.length; ++j) {
                            fahs[j].setFixedAssetAreasHistory(FixedAssetAreaHistoryPersistencyManager.getFixedAssetAreasHistory((FixedAssetHistory)fahs[j]));
                        }
                        faStructNew = FixedAssetMapper.toIdl((FixedAsset)fad, (boolean)false);
                        FixedAssetHistory fah = null;
                        boolean sameValidFromDate = false;
                        for (int k = 0; k < fahs.length; ++k) {
                            if (!validFromDate.equals(fahs[k].getValidFrom())) continue;
                            fah = new FixedAssetHistory(fahs[k].getObjectid(), fahs[k].getVersion(), (FixedAsset)fadOld);
                            sameValidFromDate = true;
                            break;
                        }
                        if (!sameValidFromDate) {
                            fah = new FixedAssetHistory("", -1, (FixedAsset)fadOld);
                        }
                        fah.setAccountingCompany(fadOld.getAccountCompany());
                        FixedAssetHistoryMapper.fillFixedAssetHistory((FixedAssetHistory)fah, (FixedAssetStruct)faStructNew, (String)faStructNew.fixedAssetShort.code, (boolean)true, (Date)this.mValidFromDate, (Date)DateMapper.toDate((String)faStructNew.fixedAssetShort.shortData.fixedAssetShortData().validToDate));
                        if (validFromDate != null && fadOld.getValidFromDate() != null && DateHelper.before((Date)validFromDate, (Date)fadOld.getValidFromDate())) {
                            fah.setValidUntil(DateHelper.yesterday((Date)fadOld.getValidFromDate()));
                            for (int j = 0; j < fah.getFixedAssetAreasHistory().length; ++j) {
                                fah.getFixedAssetAreasHistory()[j].setValidUntil(DateHelper.yesterday((Date)fadOld.getValidFromDate()));
                            }
                            fadOld.setFixedAssetHistory(fah);
                            fadOld.makeSaveable();
                        } else {
                            fad.setValidFromDate(validFromDate);
                            fad.setFixedAssetHistory(fah);
                            fad.makeSaveable();
                            FixedAssetArea[] faaAreas = fad.getFixedAssetAreas();
                            for (int k = 0; k < faaAreas.length; ++k) {
                                if (!faaArea.getObjectid().equals(faaAreas[k].getObjectid())) continue;
                                faaArea = faaAreas[k];
                                faaArea.makeSaveable();
                            }
                        }
                    }
                }
                ++this.mRowsProcessed;
                this.mCallBackResult[0] = this.mRowsProcessed + ";" + this.mRowCount;
                ((ReportFileStructCallback)this.mCallback).putData(this.mCallBackResult);
                if (faaArea.isReadOnly() && fad.isReadOnly()) continue;
                ++this.mCountFAChanged;
            }
            this.mRowCount = this.mContainerList.size() * 2;
            this.mRowsProcessed = this.mRowCount / 2;
        }
        catch (Exception e) {
            ExceptionMapper.printException((Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getAttributeIsChangeable(FixedAssetArea faArea, String fieldName) {
        FixedAssetData fixedAsset = (FixedAssetData)faArea.getFixedAsset();
        if ("FAA.DEPRECPERCENT".equals(fieldName)) {
            if (StringMapper.isNullString((String)faArea.getOidDepreciationMethod())) return mQuickChangeReportList.getString((ILanguage)this.mGlobalLanguage, 21);
            CalcMethod deprMethod = CalcMethodPersistencyManager.getCalcMethod((String)faArea.getOidDepreciationMethod());
            if (!(deprMethod instanceof DepreciationMethodData) || BigDecimalMapper.isZeroOrNull((BigDecimal)((DepreciationMethodData)deprMethod).getPercentage())) return "";
            return mQuickChangeReportList.getString((ILanguage)this.mGlobalLanguage, 22);
        }
        if ("FAA.OIDDEPRECMETHOD".equals(fieldName)) {
            if (faArea.getStatus().value() != 1 && faArea.getStatus().value() != 7 && faArea.getStatus().value() != 3 && faArea.getStatus().value() != 5) return "";
            return mQuickChangeReportList.getString((ILanguage)this.mGlobalLanguage, 23);
        }
        if ("FAA.OIDSPECDEPREMETHOD".equals(fieldName)) {
            if (!faArea.getDeprArea().getSpecialDep()) {
                return mQuickChangeReportList.getString((ILanguage)this.mGlobalLanguage, 25);
            }
            if (faArea.getStatus().value() != 1 && faArea.getStatus().value() != 7 && faArea.getStatus().value() != 3 && faArea.getStatus().value() != 5) return "";
            return mQuickChangeReportList.getString((ILanguage)this.mGlobalLanguage, 24);
        }
        if ("FA.QUANTITY".equals(fieldName)) {
            if (!StringMapper.isNullString((String)fixedAsset.getOidQuantityUnit())) return "";
            return mQuickChangeReportList.getString((ILanguage)this.mGlobalLanguage, 20);
        }
        if ("FAA.DEPBELOWZERO".equals(fieldName)) {
            if (faArea.getDeprArea().getCalculative() && faArea.getDeprArea().getDepBelowZero()) return "";
            return mQuickChangeReportList.getString((ILanguage)this.mGlobalLanguage, 25);
        }
        if ("FAA.OIDIMPINTERESTMETH".equals(fieldName)) {
            if (faArea.getDeprArea().getImputedInterest()) return "";
            return mQuickChangeReportList.getString((ILanguage)this.mGlobalLanguage, 26);
        }
        if (!"FAA.IMPINTERESTPERCENT".equals(fieldName)) return "";
        if (!faArea.getDeprArea().getImputedInterest()) {
            return mQuickChangeReportList.getString((ILanguage)this.mGlobalLanguage, 26);
        }
        if (!StringMapper.isNullString((String)faArea.getOidImputedInterestMethod())) return "";
        return mQuickChangeReportList.getString((ILanguage)this.mGlobalLanguage, 27);
    }

    public boolean getHasNext() {
        return this.mHasNext;
    }

    public boolean next() throws JRException {
        boolean result = false;
        try {
            result = this.mHasNext = this.mZaehler < this.mContainerList.size();
            if (this.mHasNext) {
                this.mContainer = this.mContainerList.get(this.mZaehler);
                ++this.mZaehler;
                ++this.mRowsProcessed;
                this.mCallBackResult[0] = this.mRowsProcessed + ";" + this.mRowCount;
                ((ReportFileStructCallback)this.mCallback).putData(this.mCallBackResult);
            } else {
                this.mContainer = null;
            }
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        return result;
    }

    public Object getFieldValue(JRField field) throws JRException {
        String value = null;
        if (this.mContainer != null) {
            String fieldName = field.getName();
            try {
                if (FIELD_CODE.equals(fieldName)) {
                    value = this.mContainer.mCode;
                } else if (FIELD_SHORTNAME_FULLNAME.equals(fieldName)) {
                    value = this.mContainer.mShortName;
                } else if (FIELD_FIELDNAME.equals(fieldName)) {
                    value = this.mContainer.mFieldName;
                } else if (FIELD_OLDVALUE.equals(fieldName)) {
                    value = this.mContainer.mOldValue;
                } else if (FIELD_NEWVALUE.equals(fieldName)) {
                    value = this.mContainer.mNewValue;
                } else if (FIELD_MESSAGE.equals(fieldName)) {
                    value = this.mContainer.mMessage;
                }
                if (value == null) {
                    value = "";
                } else if (value instanceof String) {
                    value = StringUtil.toJasperString((String)value);
                } else if (value instanceof Date) {
                    value = DateMapper.toString((ILanguage)this.mLanguageForLanguageDependentTexts, (Date)((Date)((Object)value)));
                }
            }
            catch (Exception e) {
                ExceptionMapper.printException((Throwable)e);
            }
        }
        return value;
    }

    public Map<String, Object> getParameters() {
        JasperParameterHashMap parameters = new JasperParameterHashMap();
        parameters.put(PARAMETER_JASPERHELPER, this.mReportFlags);
        parameters.put(PARAMETER_BIGDECIMALFORMATTER, this.mBigDecimalFormatter);
        if (this.mQuery.fixedAssetReportType.changeTopic().preview) {
            parameters.put(STATIC_TITLE, mQuickChangeReportList.getString((ILanguage)this.mGlobalLanguage, 14));
        } else {
            parameters.put(STATIC_TITLE, mQuickChangeReportList.getString((ILanguage)this.mGlobalLanguage, 0));
        }
        parameters.put(STATIC_COMPANY, mQuickChangeReportList.getString((ILanguage)this.mGlobalLanguage, 1));
        parameters.put(STATIC_FINANCIALYEAR, mQuickChangeReportList.getString((ILanguage)this.mGlobalLanguage, 2));
        parameters.put(STATIC_DATE, mQuickChangeReportList.getString((ILanguage)this.mGlobalLanguage, 3));
        parameters.put(STATIC_TIME, mQuickChangeReportList.getString((ILanguage)this.mGlobalLanguage, 4));
        parameters.put(STATIC_USER, mQuickChangeReportList.getString((ILanguage)this.mGlobalLanguage, 5));
        parameters.put(STATIC_PAGE, mQuickChangeReportList.getString((ILanguage)this.mGlobalLanguage, 6));
        parameters.put(STATIC_DEPRECIATIONAREA, mQuickChangeReportList.getString((ILanguage)this.mGlobalLanguage, 9));
        parameters.put(STATIC_CODE, mQuickChangeReportList.getString((ILanguage)this.mGlobalLanguage, 7));
        parameters.put(STATIC_SHORTNAME_FULLNAME, mQuickChangeReportList.getString((ILanguage)this.mGlobalLanguage, 8));
        parameters.put(STATIC_FIELDNAME, mQuickChangeReportList.getString((ILanguage)this.mGlobalLanguage, 10));
        parameters.put(STATIC_OLDVALUE, mQuickChangeReportList.getString((ILanguage)this.mGlobalLanguage, 11));
        parameters.put(STATIC_NEWVALUE, mQuickChangeReportList.getString((ILanguage)this.mGlobalLanguage, 12));
        parameters.put(PARAMETER_COMPANYSHORT, this.mCompanyShort);
        parameters.put(PARAMETER_RELEASE, this.mReleaseInfoPrefix.concat(this.mRelease));
        parameters.put(PARAMETER_USER, this.mUserID);
        parameters.put(PARAMETER_DATE, this.mDate);
        parameters.put(PARAMETER_TIME, this.mTime);
        parameters.put(PARAMETER_PREVIEW, this.mQuery.fixedAssetReportType.changeTopic().preview);
        parameters.put(PARAMETER_DEPRECIATIONAREA, this.mDepreciationArea);
        return parameters;
    }

    public static String getLocalizedString(Language globalLanguage, int index) {
        return mQuickChangeReportList.getString((ILanguage)globalLanguage, index);
    }

    public int getCountFAChanged() {
        return this.mCountFAChanged;
    }

    public List<QuickChangeReportContainer> getContainerList() {
        return this.mContainerList;
    }
}

