/*
 * Decompiled with CFR 0.152.
 */
package com.varial.assetaccounting.domain.fixedassetreport;

import com.varial.accounting.domain.financialyear.AccountingCompany;
import com.varial.accounting.domain.financialyear.AccountingCompanyPersistencyManager;
import com.varial.assetaccounting.depreciation.PreviewVersionEnum;
import com.varial.assetaccounting.domain.depreciation.DepreciationPreviewVersionMapper;
import com.varial.assetaccounting.domain.depreciationarea.DepreciationArea;
import com.varial.assetaccounting.domain.fafinancialyear.FAFinancialYear;
import com.varial.assetaccounting.domain.fafinancialyear.FAFinancialYearPersistencyManager;
import com.varial.assetaccounting.domain.fixedasset.SortEnumMapper;
import com.varial.assetaccounting.domain.fixedassetreport.AssetNameTypeMapper;
import com.varial.assetaccounting.domain.fixedassetreport.DeprAreasRelPersistencyManager;
import com.varial.assetaccounting.domain.fixedassetreport.FixedAssetReportPreset;
import com.varial.assetaccounting.domain.fixedassetreport.FixedAssetReportPresetCompanyPersistencyManager;
import com.varial.assetaccounting.domain.fixedassetreport.FixedAssetReportPresetData;
import com.varial.assetaccounting.domain.fixedassetreport.FixedAssetReportTypeMapper;
import com.varial.assetaccounting.domain.fixedassetreport.FormFeedTypeMapper;
import com.varial.assetaccounting.domain.fixedassetreport.MainDataTypeMapper;
import com.varial.assetaccounting.domain.fixedassetreport.MainSubCompactedMapper;
import com.varial.assetaccounting.domain.fixedassetreport.PrintTypePLMapper;
import com.varial.assetaccounting.domain.fixedassetreport.copyfixedassets.CopyAssetDataMapper;
import com.varial.assetaccounting.domain.fixedassetreport.copyfixedassets.CopyTypeMapper;
import com.varial.assetaccounting.domain.fixedassetreport.quickchangeattributes.QuickChangeAttribute;
import com.varial.assetaccounting.domain.fixedassetreport.quickchangeattributes.QuickChangeAttributePersistencyManager;
import com.varial.assetaccounting.fixedasset.SortEnum;
import com.varial.assetaccounting.fixedassetreport.AssetNameEnum;
import com.varial.assetaccounting.fixedassetreport.CopyAssetDataEnum;
import com.varial.assetaccounting.fixedassetreport.CopyTypeEnum;
import com.varial.assetaccounting.fixedassetreport.FixedAssetReportEnum;
import com.varial.assetaccounting.fixedassetreport.FormFeedEnum;
import com.varial.assetaccounting.fixedassetreport.MainDataEnum;
import com.varial.assetaccounting.fixedassetreport.MainSubCompactedEnum;
import com.varial.assetaccounting.fixedassetreport.PrintTypePLEnum;
import com.varial.assetaccounting.persistency.fareportpreset.FareportpresetContainer;
import com.varial.assetaccounting.persistency.fareportpreset.IFareportpresetDao;
import com.varial.base.CacheUtil;
import com.varial.base.UtilitiesManager;
import com.varial.base.cache.Cache;
import com.varial.base.cache.CacheProvider;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Order;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.session.SessionContext;
import com.varial.framework.domain.currency.CurrencyPersistencyManager;
import com.varial.framework.domain.quantityunit.QuantityUnit;
import com.varial.framework.domain.quantityunit.QuantityUnitPersistencyManager;
import com.varial.serverbase.domain.filter.ExtendedFilter;
import com.varial.serverbase.domain.filter.IExtendedFilterPersistencyManager;
import com.varial.serverbase.domain.language.LanguageManager;
import com.varial.serverbase.domain.sort.Sort;
import com.varial.serverbase.domain.sort.SortPersistencyManager;
import com.varial.serverbase.mapper.ExceptionMapper;
import com.varial.serverbase.mapper.StringMapper;
import com.varial.serverbase.persistency.IPersistentObject;
import com.varial.serverbase.persistency.PersistentObjectUtils;
import java.util.Date;
import net.sf.ehcache.Element;

public class FixedAssetReportPresetPersistencyManager {
    private static final IFareportpresetDao dao = (IFareportpresetDao)UtilitiesManager.getBean((String)"fareportpresetDao", IFareportpresetDao.class);
    private static final IExtendedFilterPersistencyManager extendedFilterPersistencyManager = (IExtendedFilterPersistencyManager)UtilitiesManager.getBean((String)"extendedFilterPersistencyManager", IExtendedFilterPersistencyManager.class);
    private static final CacheProvider cacheManager = (CacheProvider)UtilitiesManager.getBean((String)"localCacheManager", CacheProvider.class);

    public static boolean getExistsPresetsForArea(DepreciationArea deprArea) {
        long rowCount = FixedAssetReportPresetPersistencyManager.queryRowCount(Restrictions.eq((String)"oiddeprarea", (String)deprArea.getObjectid()));
        return rowCount > 0L;
    }

    private static FixedAssetReportPreset[] query(Order[] order, Criterion filters) {
        try {
            FareportpresetContainer[] containers = dao.getRows(order, filters);
            int count = containers.length;
            FixedAssetReportPreset[] result = new FixedAssetReportPreset[count];
            for (int i = 0; i < count; ++i) {
                result[i] = new FixedAssetReportPreset(true);
                FixedAssetReportPresetPersistencyManager.fillFixedAssetReportPreset(result[i], containers[i]);
            }
            return result;
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    private static long queryRowCount(Criterion filters) {
        try {
            return dao.getRowCount(filters);
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    public static FixedAssetReportPreset[] getFixedAssetReportPresets(AccountingCompany company, FixedAssetReportEnum reportType) {
        return FixedAssetReportPresetPersistencyManager.query(null, Restrictions.and((Criterion)Restrictions.eq((String)"oidcompany", (String)company.getObjectid()), (Criterion)Restrictions.eq((String)"reporttype", (String)Integer.toString(reportType.value()))));
    }

    public static void load(FixedAssetReportPreset c) {
        FareportpresetContainer container = null;
        try {
            container = dao.getRowByObjectID(c.getObjectid());
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        if (container == null) {
            throw ExceptionMapper.makeDataNotFoundPersistencyException((String)c.getObjectid());
        }
        FixedAssetReportPresetPersistencyManager.fillFixedAssetReportPreset(c, container);
    }

    public static void save(FixedAssetReportPreset c) {
        FareportpresetContainer container = new FareportpresetContainer();
        FixedAssetReportPresetPersistencyManager.fillContainer(container, c);
        try {
            if (c.isNew()) {
                container = dao.insert(SessionContext.getInstance().getSession().getUserCode(), container);
            } else {
                container = dao.update(SessionContext.getInstance().getSession().getUserCode(), container);
                DeprAreasRelPersistencyManager.delete((FixedAssetReportPreset)c);
                QuickChangeAttributePersistencyManager.delete((FixedAssetReportPreset)c);
                FixedAssetReportPresetCompanyPersistencyManager.delete((FixedAssetReportPreset)c);
            }
            c.setLastuser(container.getLastUserid());
            c.setObjectid(container.getObjectid());
            c.setTimestamp(container.getObjectTS());
            c.setVersion(container.getVersion());
            if (c.getWithConsolidation()) {
                FixedAssetReportPresetCompanyPersistencyManager.insert((FixedAssetReportPreset)c);
            }
            DeprAreasRelPersistencyManager.insert((DepreciationArea[])c.getAssetAreas(), (FixedAssetReportPreset)c);
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    public static void delete(FixedAssetReportPreset c) {
        try {
            dao.delete(SessionContext.getInstance().getSession().getUserCode(), c.getObjectid(), c.getVersion());
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    private static void fillFixedAssetReportPreset(FixedAssetReportPreset preset, FareportpresetContainer container) {
        preset.setLastuser(container.getLastUserid());
        preset.setObjectid(container.getObjectid());
        preset.setTimestamp(container.getObjectTS());
        preset.setVersion(container.getVersion());
        FAFinancialYear financialYear = null;
        if (!StringMapper.isNullString((String)container.oidfinancialyear)) {
            financialYear = FAFinancialYearPersistencyManager.getFAFinancialYear((String)container.oidfinancialyear);
        }
        ExtendedFilter filter = null;
        if (!StringMapper.isNullString((String)container.oidextendedfilter)) {
            filter = extendedFilterPersistencyManager.getExtendedFilter(container.oidextendedfilter);
        }
        Sort sort = null;
        if (!StringMapper.isNullString((String)container.oidsort)) {
            sort = SortPersistencyManager.getSort((String)container.oidsort);
        }
        Sort groupTotal = null;
        if (!StringMapper.isNullString((String)container.oidgrptotal)) {
            groupTotal = SortPersistencyManager.getSort((String)container.oidgrptotal);
        }
        DepreciationArea[] assetAreas = DeprAreasRelPersistencyManager.getDeprAreaRels((FixedAssetReportPreset)preset);
        boolean printAssetNotes = false;
        boolean printAnalysisCodes = false;
        boolean printGroupTotalOnly = false;
        boolean withSingleTransactions = false;
        boolean withoutZeroValues = false;
        boolean withValues = false;
        boolean withFullDisposal = false;
        boolean printAC0 = false;
        boolean printAC1 = false;
        boolean printAC2 = false;
        boolean printAC3 = false;
        boolean printAC4 = false;
        boolean printAC5 = false;
        boolean printAC6 = false;
        boolean printAC7 = false;
        boolean printAC8 = false;
        boolean printAC9 = false;
        Date fromProcessingDate = null;
        Date toProcessingDate = null;
        AssetNameEnum assetNameType = null;
        int numberOfYears = 0;
        PreviewVersionEnum previewVersion = null;
        SortEnum sortAscDesc = null;
        QuickChangeAttribute[] qcAttr = new QuickChangeAttribute[]{};
        boolean quickChangePreview = false;
        MainDataEnum mainDataType = MainDataTypeMapper.toMainSubType((int)container.maindatatype);
        boolean printTransactions = false;
        PrintTypePLEnum printTypePL = null;
        boolean withCostCentres = false;
        FormFeedEnum formFeedType = null;
        CopyTypeEnum copyType = null;
        CopyAssetDataEnum copyAssetData = null;
        AccountingCompany inCompany = null;
        boolean printFixedAssetData = false;
        boolean printCostCentres = false;
        boolean printSubFixedAssets = false;
        boolean printInventoryData = false;
        boolean withConsolidation = false;
        AccountingCompany[] companies = null;
        boolean printProtocol = container.withprotocol;
        boolean printHistory = false;
        Date dateForHistory = null;
        boolean printFurtherDeprData = false;
        boolean printSupplierData = false;
        boolean printInterest = false;
        boolean withGrants = false;
        boolean withAdditionalTexts = false;
        QuantityUnit quantityUnit = null;
        boolean isSelectDocDate = false;
        MainSubCompactedEnum mainSubCompactedType = null;
        Date fromRetirementDate = null;
        Date toRetirementDate = null;
        Date interchangeDate = null;
        boolean calculateReplValue = false;
        boolean withSummarizedAdditions = false;
        switch (container.reporttype) {
            case 0: {
                printAssetNotes = container.printnotes;
                printAnalysisCodes = container.printanalysiscodes;
                printTransactions = container.withhistory;
                printTypePL = PrintTypePLMapper.toPrintTypePL((int)container.printtypepl);
                fromProcessingDate = container.fromprocessingdate;
                toProcessingDate = container.toprocessingdate;
                printCostCentres = container.withcostcentres;
                printSubFixedAssets = container.withsubassets;
                printInventoryData = container.withinventorydata;
                printHistory = container.withhistory;
                dateForHistory = container.dateforhistory;
                printHistory = container.withhistory;
                withAdditionalTexts = container.withaddtexts;
                withSummarizedAdditions = container.withinterest;
                break;
            }
            case 1: {
                fromProcessingDate = container.fromprocessingdate;
                toProcessingDate = container.toprocessingdate;
                assetNameType = AssetNameTypeMapper.toMainSubType((int)container.assetnametype);
                printGroupTotalOnly = container.printgrtotalonly;
                printFixedAssetData = container.withmaindata;
                withConsolidation = container.withinventorydata;
                printHistory = container.withhistory;
                dateForHistory = container.dateforhistory;
                if (withConsolidation && (companies = FixedAssetReportPresetCompanyPersistencyManager.getCompanies((String)container.getObjectid())) == null) {
                    companies = new AccountingCompany[]{};
                }
                printFurtherDeprData = container.withvalues;
                printSupplierData = container.withzerovalues;
                printInterest = container.withinterest;
                withCostCentres = container.withcostcentres;
                withAdditionalTexts = container.withaddtexts;
                withGrants = container.withgrants;
                mainSubCompactedType = MainSubCompactedMapper.toMainSubCompactedType((int)container.mainsuborder);
                formFeedType = container.withformfeed == Integer.MIN_VALUE ? FormFeedTypeMapper.toFormFeedType((int)0) : FormFeedTypeMapper.toFormFeedType((int)container.withformfeed);
                break;
            }
            case 2: {
                fromProcessingDate = container.fromprocessingdate;
                toProcessingDate = container.toprocessingdate;
                assetNameType = AssetNameTypeMapper.toMainSubType((int)container.assetnametype);
                withSingleTransactions = container.withsingletransact;
                printFixedAssetData = container.withmaindata;
                printHistory = container.withhistory;
                dateForHistory = container.dateforhistory;
                printGroupTotalOnly = container.printgrtotalonly;
                isSelectDocDate = container.sortbydocumdate;
                break;
            }
            case 4: {
                fromProcessingDate = container.fromprocessingdate;
                toProcessingDate = container.toprocessingdate;
                assetNameType = AssetNameTypeMapper.toMainSubType((int)container.assetnametype);
                printGroupTotalOnly = container.printgrtotalonly;
                numberOfYears = container.numberofyears;
                previewVersion = DepreciationPreviewVersionMapper.toReportType((int)container.previewversion);
                sortAscDesc = SortEnumMapper.toStatusType((int)container.sortdeprvalues);
                withCostCentres = container.withcostcentres;
                break;
            }
            case 3: {
                fromProcessingDate = container.fromprocessingdate;
                toProcessingDate = container.toprocessingdate;
                printGroupTotalOnly = container.printgrtotalonly;
                assetNameType = AssetNameTypeMapper.toMainSubType((int)container.assetnametype);
                withoutZeroValues = container.withzerovalues;
                printHistory = container.withhistory;
                dateForHistory = container.dateforhistory;
                break;
            }
            case 5: {
                fromProcessingDate = container.fromprocessingdate;
                toProcessingDate = container.toprocessingdate;
                assetNameType = AssetNameTypeMapper.toMainSubType((int)container.assetnametype);
                printGroupTotalOnly = container.printgrtotalonly;
                withCostCentres = container.withcostcentres;
                printHistory = container.withhistory;
                dateForHistory = container.dateforhistory;
                withGrants = container.withgrants;
                printFixedAssetData = container.withmaindata;
                break;
            }
            case 6: {
                toProcessingDate = container.toprocessingdate;
                withFullDisposal = container.withfulldisposal;
                withValues = container.withvalues;
                assetNameType = AssetNameTypeMapper.toMainSubType((int)container.assetnametype);
                printAC0 = container.printac0;
                printAC1 = container.printac1;
                printAC2 = container.printac2;
                printAC3 = container.printac3;
                printAC4 = container.printac4;
                printAC5 = container.printac5;
                printAC6 = container.printac6;
                printAC7 = container.printac7;
                printAC8 = container.printac8;
                printAC9 = container.printac9;
                printHistory = container.withhistory;
                dateForHistory = container.dateforhistory;
                formFeedType = container.withformfeed == Integer.MIN_VALUE ? FormFeedTypeMapper.toFormFeedType((int)0) : FormFeedTypeMapper.toFormFeedType((int)container.withformfeed);
                withCostCentres = container.withcostcentres;
                withAdditionalTexts = container.withaddtexts;
                break;
            }
            case 7: {
                assetNameType = AssetNameTypeMapper.toMainSubType((int)container.assetnametype);
                printGroupTotalOnly = container.printgrtotalonly;
                printHistory = container.withhistory;
                dateForHistory = container.dateforhistory;
                calculateReplValue = container.withzerovalues;
                break;
            }
            case 8: {
                qcAttr = QuickChangeAttribute.getQuickChangeAttributess((FixedAssetReportPreset)preset);
                quickChangePreview = container.quickchangepreview;
                dateForHistory = container.dateforhistory;
                break;
            }
            case 9: {
                fromProcessingDate = container.fromprocessingdate;
                toProcessingDate = container.toprocessingdate;
                assetNameType = AssetNameTypeMapper.toMainSubType((int)container.assetnametype);
                printGroupTotalOnly = container.printgrtotalonly;
                formFeedType = FormFeedTypeMapper.toFormFeedType((int)0);
                break;
            }
            case 10: {
                if (container.copymaindata) {
                    copyType = CopyTypeMapper.toCopyType((int)0);
                    copyAssetData = CopyAssetDataMapper.toCopyAssetData((int)0);
                } else {
                    copyType = CopyTypeMapper.toCopyType((int)1);
                    if (container.copyfixedassets) {
                        copyAssetData = CopyAssetDataMapper.toCopyAssetData((int)0);
                    }
                    if (container.copyassetgroups) {
                        copyAssetData = CopyAssetDataMapper.toCopyAssetData((int)1);
                    }
                }
                withFullDisposal = container.withfulldisposal;
                inCompany = AccountingCompanyPersistencyManager.getAccountingCompany((String)container.oidincompany);
                qcAttr = QuickChangeAttribute.getQuickChangeAttributess((FixedAssetReportPreset)preset);
                printAssetNotes = container.printnotes;
                printAnalysisCodes = container.printanalysiscodes;
                printGroupTotalOnly = container.printgrtotalonly;
                printTransactions = container.withhistory;
                break;
            }
            case 11: {
                fromProcessingDate = container.fromprocessingdate;
                toProcessingDate = container.toprocessingdate;
                assetNameType = AssetNameTypeMapper.toMainSubType((int)container.assetnametype);
                withSingleTransactions = container.withsingletransact;
                printHistory = container.withhistory;
                dateForHistory = container.dateforhistory;
                printGroupTotalOnly = container.printgrtotalonly;
                isSelectDocDate = container.sortbydocumdate;
                break;
            }
            case 13: {
                fromProcessingDate = container.fromprocessingdate;
                toProcessingDate = container.toprocessingdate;
                assetNameType = AssetNameTypeMapper.toMainSubType((int)container.assetnametype);
                printGroupTotalOnly = container.printgrtotalonly;
                printHistory = container.withhistory;
                dateForHistory = container.dateforhistory;
                quantityUnit = QuantityUnitPersistencyManager.getQuantityUnit((String)container.oidquantity);
                withAdditionalTexts = container.withaddtexts;
                printFixedAssetData = container.withmaindata;
                break;
            }
            case 14: {
                inCompany = AccountingCompanyPersistencyManager.getAccountingCompany((String)container.oidincompany);
                qcAttr = QuickChangeAttribute.getQuickChangeAttributess((FixedAssetReportPreset)preset);
                fromRetirementDate = container.fromprocessingdate;
                toRetirementDate = container.toprocessingdate;
                interchangeDate = container.interchangedate;
            }
        }
        FixedAssetReportPresetData data = new FixedAssetReportPresetData();
        data.setCompany(AccountingCompanyPersistencyManager.getAccountingCompany((String)container.oidcompany));
        data.setName(container.name);
        data.setCreator(container.createdby);
        data.setNote(container.note);
        data.setLanguage(LanguageManager.getInstance().getLanguage(container.oidlanguage));
        data.setCurrency(CurrencyPersistencyManager.getCurrency((String)container.oidcurrency));
        data.setAssetAreas(assetAreas);
        data.setFinancialYear(financialYear);
        data.setToProcessingDate(toProcessingDate);
        data.setFromProcessingDate(fromProcessingDate);
        data.setAssetNameType(assetNameType);
        data.setReportType(FixedAssetReportTypeMapper.toReportType((int)container.reporttype));
        data.setPrintAssetNotes(printAssetNotes);
        data.setPrintAnalysisCodes(printAnalysisCodes);
        data.setPrintGroupTotalOnly(printGroupTotalOnly);
        data.setWithSingleTransactions(withSingleTransactions);
        data.setFilter(filter);
        data.setSort(sort);
        data.setGroupTotal(groupTotal);
        data.setNumberOfYears(numberOfYears);
        data.setPreviewVersion(previewVersion);
        data.setSortDeprValuesAscDesc(sortAscDesc);
        data.setWithZeroValues(withoutZeroValues);
        data.setWithValues(withValues);
        data.setWithFullDisposal(withFullDisposal);
        data.setPrintAC0(printAC0);
        data.setPrintAC1(printAC1);
        data.setPrintAC2(printAC2);
        data.setPrintAC3(printAC3);
        data.setPrintAC4(printAC4);
        data.setPrintAC5(printAC5);
        data.setPrintAC6(printAC6);
        data.setPrintAC7(printAC7);
        data.setPrintAC8(printAC8);
        data.setPrintAC9(printAC9);
        data.setQuickChangeAttr(qcAttr);
        data.setQuickChangePreview(quickChangePreview);
        data.setMainDataType(mainDataType);
        data.setPrintTransactions(printTransactions);
        data.setPrintTypePL(printTypePL);
        data.setWithCostCentres(withCostCentres);
        data.setFormFeedType(formFeedType);
        data.setCopyType(copyType);
        data.setCopyAssetData(copyAssetData);
        data.setInCompany(inCompany);
        data.setMainSubCompactedType(mainSubCompactedType);
        data.setPrintFixedAssetData(printFixedAssetData);
        data.setPrintCostCentres(printCostCentres);
        data.setPrintSubFixedAssets(printSubFixedAssets);
        data.setPrintInventoryDate(printInventoryData);
        data.setWithConsolidation(withConsolidation);
        data.setCompanies(companies);
        data.setPrintProtocol(printProtocol);
        data.setPrintHistory(printHistory);
        data.setDateForHistory(dateForHistory);
        data.setPrintFurtherDeprData(printFurtherDeprData);
        data.setPrintSupplierData(printSupplierData);
        data.setPrintInterest(printInterest);
        data.setWithGrants(withGrants);
        data.setWithAdditionalTexts(withAdditionalTexts);
        data.setQuantityUnit(quantityUnit);
        data.setIsSelectDocDate(isSelectDocDate);
        data.setToRetirementDate(toRetirementDate);
        data.setFromRetirementDate(fromRetirementDate);
        data.setInterchangeDate(interchangeDate);
        data.setCalculateReplValue(calculateReplValue);
        data.setWithSummarizedAdditions(withSummarizedAdditions);
        preset.setData(data);
    }

    private static void fillContainer(FareportpresetContainer container, FixedAssetReportPreset preset) {
        container.oidcompany = preset.getAccountingCompany().getObjectid();
        container.name = preset.getName();
        container.createdby = preset.getCreator();
        container.note = preset.getNote();
        container.oidlanguage = PersistentObjectUtils.getObjectidForContainer((IPersistentObject)preset.getLanguage());
        container.oidcurrency = PersistentObjectUtils.getObjectidForContainer((IPersistentObject)preset.getCurrency());
        container.oidextendedfilter = PersistentObjectUtils.getObjectidForContainer((IPersistentObject)preset.getFilter());
        container.oidsort = PersistentObjectUtils.getObjectidForContainer((IPersistentObject)preset.getSort());
        container.reporttype = preset.getFixedAssetReportType().value();
        container.oidfinancialyear = PersistentObjectUtils.getObjectidForContainer((IPersistentObject)preset.getFinancialYear());
        container.oidgrptotal = PersistentObjectUtils.getObjectidForContainer((IPersistentObject)preset.getGroupTotal());
        container.maindatatype = preset.getMainDataType() == null ? 0 : preset.getMainDataType().value();
        container.withformfeed = 0;
        container.copyhistorie = 0;
        container.printtypepl = 0;
        container.copyhistorie = 0;
        container.subscompacted = false;
        container.withprotocol = preset.getPrintProtocol();
        container.mainsuborder = 0;
        container.mainsubscomptype = 0;
        switch (preset.getFixedAssetReportType().value()) {
            case 0: {
                container.printnotes = preset.getPrintAssetNotes();
                container.printanalysiscodes = preset.getPrintAnalysisCodes();
                container.withhistory = preset.getPrintTransactions();
                container.printtypepl = preset.getPrintTypePL().value();
                container.fromprocessingdate = preset.getFromProcessingDate();
                container.toprocessingdate = preset.getToProcessingDate();
                container.withcostcentres = preset.getPrintCostCentres();
                container.withsubassets = preset.getPrintSubFixedAssets();
                container.withinventorydata = preset.getPrintInventoryData();
                container.withhistory = preset.getPrintHistory();
                container.dateforhistory = preset.getDateForHistory();
                container.withaddtexts = preset.getWithAdditionalTexts();
                container.withinterest = preset.getWithSummarizedAdditions();
                break;
            }
            case 1: {
                container.fromprocessingdate = preset.getFromProcessingDate();
                container.toprocessingdate = preset.getToProcessingDate();
                container.assetnametype = preset.getAssetNameType().value();
                container.printgrtotalonly = preset.getPrintGroupTotalOnly();
                container.withmaindata = preset.getPrintFixedAssetData();
                container.withinventorydata = preset.getWithConsolidation();
                container.withhistory = preset.getPrintHistory();
                container.dateforhistory = preset.getDateForHistory();
                container.withvalues = preset.getPrintFurtherDeprData();
                container.withzerovalues = preset.getPrintSupplierData();
                container.withinterest = preset.getPrintInterest();
                container.withcostcentres = preset.getWithCostCentres();
                container.withaddtexts = preset.getWithAdditionalTexts();
                container.withgrants = preset.getWithGrants();
                container.mainsuborder = preset.getMainSubCompactedType().value();
                container.withformfeed = preset.getFormFeedType().value();
                break;
            }
            case 2: {
                container.fromprocessingdate = preset.getFromProcessingDate();
                container.toprocessingdate = preset.getToProcessingDate();
                container.assetnametype = preset.getAssetNameType().value();
                container.withsingletransact = preset.getWithSingleTransactions();
                container.withmaindata = preset.getPrintFixedAssetData();
                container.withhistory = preset.getPrintHistory();
                container.dateforhistory = preset.getDateForHistory();
                container.printgrtotalonly = preset.getPrintGroupTotalOnly();
                container.sortbydocumdate = preset.getIsSelectDocDate();
                break;
            }
            case 4: {
                container.fromprocessingdate = preset.getFromProcessingDate();
                container.toprocessingdate = preset.getToProcessingDate();
                container.assetnametype = preset.getAssetNameType().value();
                container.printgrtotalonly = preset.getPrintGroupTotalOnly();
                container.numberofyears = preset.getNumberOfYears();
                container.previewversion = DepreciationPreviewVersionMapper.toInt((PreviewVersionEnum)preset.getPreviewVersion());
                container.sortdeprvalues = SortEnumMapper.toInt((SortEnum)preset.getSortDeprValuesAscDesc());
                container.withcostcentres = preset.getWithCostCentres();
                break;
            }
            case 3: {
                container.fromprocessingdate = preset.getFromProcessingDate();
                container.toprocessingdate = preset.getToProcessingDate();
                container.printgrtotalonly = preset.getPrintGroupTotalOnly();
                container.assetnametype = preset.getAssetNameType().value();
                container.withzerovalues = preset.getWithZeroValues();
                container.withhistory = preset.getPrintHistory();
                container.dateforhistory = preset.getDateForHistory();
                break;
            }
            case 5: {
                container.fromprocessingdate = preset.getFromProcessingDate();
                container.toprocessingdate = preset.getToProcessingDate();
                container.assetnametype = preset.getAssetNameType().value();
                container.printgrtotalonly = preset.getPrintGroupTotalOnly();
                container.withcostcentres = preset.getWithCostCentres();
                container.withhistory = preset.getPrintHistory();
                container.dateforhistory = preset.getDateForHistory();
                container.withgrants = preset.getWithGrants();
                container.withmaindata = preset.getPrintFixedAssetData();
                break;
            }
            case 6: {
                container.toprocessingdate = preset.getToProcessingDate();
                container.withvalues = preset.getWithValues();
                container.withfulldisposal = preset.getWithFullDisposal();
                container.assetnametype = preset.getAssetNameType().value();
                container.printac0 = preset.getPrintAC0();
                container.printac1 = preset.getPrintAC1();
                container.printac2 = preset.getPrintAC2();
                container.printac3 = preset.getPrintAC3();
                container.printac4 = preset.getPrintAC4();
                container.printac5 = preset.getPrintAC5();
                container.printac6 = preset.getPrintAC6();
                container.printac7 = preset.getPrintAC7();
                container.printac8 = preset.getPrintAC8();
                container.printac9 = preset.getPrintAC9();
                container.withhistory = preset.getPrintHistory();
                container.dateforhistory = preset.getDateForHistory();
                container.withformfeed = preset.getFormFeedType().value();
                container.withcostcentres = preset.getWithCostCentres();
                container.withaddtexts = preset.getWithAdditionalTexts();
                break;
            }
            case 7: {
                container.assetnametype = preset.getAssetNameType().value();
                container.printgrtotalonly = preset.getPrintGroupTotalOnly();
                container.withhistory = preset.getPrintHistory();
                container.dateforhistory = preset.getDateForHistory();
                container.withzerovalues = preset.getCalculateReplValue();
                break;
            }
            case 8: {
                container.quickchangepreview = preset.getQuickChangePreview();
                container.dateforhistory = preset.getDateForHistory();
                break;
            }
            case 9: {
                container.fromprocessingdate = preset.getFromProcessingDate();
                container.toprocessingdate = preset.getToProcessingDate();
                container.assetnametype = preset.getAssetNameType().value();
                container.printgrtotalonly = preset.getPrintGroupTotalOnly();
                break;
            }
            case 10: {
                if (preset.getCopyType().equals(CopyTypeEnum.CTE_GENERAL)) {
                    container.copymaindata = true;
                    container.copyfixedassets = false;
                    container.copyassetgroups = false;
                } else {
                    container.copymaindata = false;
                    if (preset.getCopyAssetData().equals(CopyAssetDataEnum.CADE_FIXEDASSETS)) {
                        container.copyfixedassets = true;
                        container.copyassetgroups = false;
                    } else {
                        container.copyfixedassets = false;
                        container.copyassetgroups = true;
                    }
                }
                container.withfulldisposal = preset.getWithFullDisposal();
                container.oidincompany = preset.getInAccountingCompany().getObjectid();
                container.printnotes = preset.getPrintAssetNotes();
                container.printanalysiscodes = preset.getPrintAnalysisCodes();
                container.printgrtotalonly = preset.getPrintGroupTotalOnly();
                container.withhistory = preset.getPrintTransactions();
                break;
            }
            case 11: {
                container.fromprocessingdate = preset.getFromProcessingDate();
                container.toprocessingdate = preset.getToProcessingDate();
                container.assetnametype = preset.getAssetNameType().value();
                container.withsingletransact = preset.getWithSingleTransactions();
                container.withhistory = preset.getPrintHistory();
                container.dateforhistory = preset.getDateForHistory();
                container.printgrtotalonly = preset.getPrintGroupTotalOnly();
                container.sortbydocumdate = preset.getIsSelectDocDate();
                break;
            }
            case 13: {
                container.fromprocessingdate = preset.getFromProcessingDate();
                container.toprocessingdate = preset.getToProcessingDate();
                container.assetnametype = preset.getAssetNameType().value();
                container.printgrtotalonly = preset.getPrintGroupTotalOnly();
                container.withhistory = preset.getPrintHistory();
                container.dateforhistory = preset.getDateForHistory();
                container.oidquantity = preset.getQuantityUnit().getObjectid();
                container.copyassetgroups = preset.getWithAdditionalTexts();
                container.withmaindata = preset.getPrintFixedAssetData();
                break;
            }
            case 14: {
                container.fromprocessingdate = preset.getFromRetirementDate();
                container.toprocessingdate = preset.getToRetirementDate();
                container.interchangedate = preset.getInterchangeDate();
                container.oidincompany = preset.getInAccountingCompany().getObjectid();
            }
        }
        container.setLastUserid(preset.getLastuser());
        container.setObjectid(preset.getObjectid());
        container.setObjectTS(preset.getTimestamp());
        container.setVersion(preset.getVersion());
    }

    public static FixedAssetReportPreset getFixedAssetReportPreset(String objectid) {
        FixedAssetReportPreset result;
        Cache cache = cacheManager.getCache(FixedAssetReportPreset.CLASSNAME);
        IPersistentObject po = CacheUtil.value((Element)cache.get((Object)objectid));
        if (po == null) {
            result = new FixedAssetReportPreset(objectid);
            cache.put(CacheUtil.element((IPersistentObject)result));
        } else {
            result = (FixedAssetReportPreset)po;
        }
        return result;
    }
}

