/*
 * Decompiled with CFR 0.152.
 */
package com.varial.assetaccounting.domain.fixedassetreport;

import com.varial.accounting.domain.financialyear.AccountingCompany;
import com.varial.accounting.domain.financialyear.AccountingCompanyPersistencyManager;
import com.varial.assetaccounting.depreciationarea.StatusOfDepreciationEnum;
import com.varial.assetaccounting.domain.assetaccsetup.AssetaccountingSetup;
import com.varial.assetaccounting.domain.depreciationarea.DepreciationArea;
import com.varial.assetaccounting.domain.depreciationarea.DepreciationAreaMapper;
import com.varial.assetaccounting.domain.depreciationarea.DepreciationAreaPersistencyManager;
import com.varial.assetaccounting.domain.fafinancialyear.FAFinancialYear;
import com.varial.assetaccounting.domain.fafinancialyear.FAFinancialYearMapper;
import com.varial.assetaccounting.domain.fafinancialyear.FAFinancialYearPersistencyManager;
import com.varial.assetaccounting.domain.fixedasset.FixedAsset;
import com.varial.assetaccounting.domain.fixedasset.FixedAssetMapper;
import com.varial.assetaccounting.domain.fixedasset.FixedAssetPersistencyManager;
import com.varial.assetaccounting.domain.fixedassetreport.FixedAssetReportFilterMapper;
import com.varial.assetaccounting.domain.fixedassetreport.FixedAssetReportPreset;
import com.varial.assetaccounting.domain.fixedassetreport.quickchangeattributes.QuickChangeAttributeMapper;
import com.varial.assetaccounting.fafinancialyear.optFAFinancialYearShort;
import com.varial.assetaccounting.fixedasset.FixedAssetShortStruct;
import com.varial.assetaccounting.fixedassetreport.AssetAdditionDisposalReportFilterStruct;
import com.varial.assetaccounting.fixedassetreport.AssetNameEnum;
import com.varial.assetaccounting.fixedassetreport.AssetRegisterReportFilterStruct;
import com.varial.assetaccounting.fixedassetreport.AssetsAnalysisReportFilterStruct;
import com.varial.assetaccounting.fixedassetreport.CopyDataStruct;
import com.varial.assetaccounting.fixedassetreport.DepreciationPreviewReportFilterStruct;
import com.varial.assetaccounting.fixedassetreport.DepreciationReportFilterStruct;
import com.varial.assetaccounting.fixedassetreport.FixedAssetReportEnum;
import com.varial.assetaccounting.fixedassetreport.FixedAssetReportFilterStruct;
import com.varial.assetaccounting.fixedassetreport.FixedAssetReportFilterStructPackage.FixedAssetReportTypeUnion;
import com.varial.assetaccounting.fixedassetreport.FixedAssetReportStruct;
import com.varial.assetaccounting.fixedassetreport.InsuranceReportFilterStruct;
import com.varial.assetaccounting.fixedassetreport.InterchangeAssetStruct;
import com.varial.assetaccounting.fixedassetreport.InventoryReportFilterStruct;
import com.varial.assetaccounting.fixedassetreport.MainSubCompactedEnum;
import com.varial.assetaccounting.fixedassetreport.ProfitLossReportFilterStruct;
import com.varial.assetaccounting.fixedassetreport.QuantityReportFilterStruct;
import com.varial.assetaccounting.fixedassetreport.QuickChangeTopicStruct;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.IdentifiableBusinessObject;
import com.varial.framework.company.CompanyShortStruct;
import com.varial.framework.domain.company.Company;
import com.varial.framework.domain.company.CompanyMapper;
import com.varial.framework.domain.currency.CurrencyMapper;
import com.varial.framework.domain.currency.CurrencyPersistencyManager;
import com.varial.framework.domain.quantityunit.QuantityUnit;
import com.varial.framework.domain.quantityunit.QuantityUnitMapper;
import com.varial.framework.domain.quantityunit.QuantityUnitPersistencyManager;
import com.varial.interfaces.ICurrency;
import com.varial.serverbase.domain.filter.ExtendedFilter;
import com.varial.serverbase.domain.filter.ExtendedFilterMapper;
import com.varial.serverbase.domain.language.ILanguage;
import com.varial.serverbase.domain.language.LanguageManager;
import com.varial.serverbase.domain.language.LanguageMapper;
import com.varial.serverbase.domain.sort.Sort;
import com.varial.serverbase.domain.sort.SortMapper;
import com.varial.serverbase.extendedquery.AttributeOperationEnum;
import com.varial.serverbase.extendedquery.AttributeStruct;
import com.varial.serverbase.extendedquery.ExtendedFilterJoinEnum;
import com.varial.serverbase.extendedquery.ExtendedFilterStruct;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.ObjectMapper;
import com.varial.serverbase.mapper.StringMapper;
import com.varial.serverbase.persistency.IPersistentObject;
import com.varial.serverbase.persistency.PersistentObjectUtils;
import com.varial.serverbase.query.SortierungElementStruct;
import com.varial.serverbase.query.SortierungStruct;
import com.varial.serverbase.query.optSortierung;
import java.util.ArrayList;
import java.util.Date;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixedAssetReportPresetMapper {
    private static Logger LOGGER = LoggerFactory.getLogger((String)FixedAssetReportPresetMapper.class.getName());

    public static void fillFixedAssetReportPreset(FixedAssetReportStruct presetStruct, FixedAssetReportPreset preset) throws BusinessDomainException {
        preset.setName(presetStruct.name);
        preset.setNote(presetStruct.note);
        preset.setFixedAssetReportType(presetStruct.reportType);
        preset.setLanguage(LanguageManager.getInstance().getLanguage(presetStruct.filter.languageForLanguageDependentTexts.oidTimestamp.objectid));
        preset.setCurrency(CurrencyPersistencyManager.getCurrency((String)presetStruct.filter.currency.oidTimestamp.objectid));
        DepreciationArea[] deprAreas = new DepreciationArea[presetStruct.filter.areaShortSeq.length];
        for (int i = 0; i < presetStruct.filter.areaShortSeq.length; ++i) {
            deprAreas[i] = DepreciationAreaPersistencyManager.getDepreciationArea((String)presetStruct.filter.areaShortSeq[i].oidTs.objectid);
        }
        preset.setAssetAreas(deprAreas);
        FAFinancialYear faFinYear = null;
        if (presetStruct.filter.fixedAssetReportType.discriminator().value() != 10) {
            if (presetStruct.filter.financialYear.discriminator()) {
                faFinYear = FAFinancialYearPersistencyManager.getFAFinancialYear((String)presetStruct.filter.financialYear.yearShort().oidTs.objectid);
            }
            preset.setFinancialYear(faFinYear);
        }
        presetStruct.filter.filtersSeq = FixedAssetReportPresetMapper.filterEelementSplitup(presetStruct.filter.filtersSeq);
        if (presetStruct.filter.fixedAssetShortSeq.length > 0) {
            presetStruct.filter.filtersSeq = FixedAssetReportPresetMapper.addFilterElement(presetStruct.filter.filtersSeq, presetStruct.filter.fixedAssetShortSeq);
        }
        if (preset.getFilter() == null) {
            preset.setFilter(ExtendedFilterMapper.createExtendedFilter(null, (ExtendedFilterStruct[])presetStruct.filter.filtersSeq));
        } else {
            ExtendedFilterMapper.fillBO((ExtendedFilter)preset.getFilter(), (ExtendedFilterStruct[])presetStruct.filter.filtersSeq);
            preset.getFilter().makeSaveable();
        }
        optSortierung optSort = FixedAssetReportPresetMapper.toSortIdl(presetStruct.filter.sortSeq);
        if (preset.getSort() == null) {
            preset.setSort(SortMapper.createSort(null, (optSortierung)optSort));
        } else {
            if (optSort.discriminator()) {
                SortMapper.fillBO((Sort)preset.getSort(), (SortierungStruct)optSort.sort());
            } else {
                SortMapper.fillBO((Sort)preset.getSort(), (SortierungStruct)new SortierungStruct(new SortierungElementStruct[0]));
            }
            preset.getSort().makeSaveable();
        }
        preset.setMainSubCompactedType(presetStruct.filter.mainSubCompactedType);
        preset.setPrintProtocol(presetStruct.printProtocol);
        switch (presetStruct.filter.fixedAssetReportType.discriminator().value()) {
            case 0: {
                preset.setPrintAssetNotes(presetStruct.filter.fixedAssetReportType.assetRegisterFilter().printAssetNotes);
                preset.setPrintAnalysisCodes(presetStruct.filter.fixedAssetReportType.assetRegisterFilter().printAnalysisCodes);
                preset.setPrintTransactions(presetStruct.filter.fixedAssetReportType.assetRegisterFilter().printTransactions);
                preset.setPrintTypePL(presetStruct.filter.fixedAssetReportType.assetRegisterFilter().printType);
                preset.setFromProcessingDate(DateMapper.toDate((String)presetStruct.filter.fixedAssetReportType.assetRegisterFilter().fromProcessingDate));
                preset.setToProcessingDate(DateMapper.toDate((String)presetStruct.filter.fixedAssetReportType.assetRegisterFilter().toProcessingDate));
                preset.setPrintInventoryData(presetStruct.filter.fixedAssetReportType.assetRegisterFilter().printInventoryData);
                preset.setPrintCostCentres(presetStruct.filter.fixedAssetReportType.assetRegisterFilter().withCostCentres);
                preset.setPrintSubFixedAssets(presetStruct.filter.fixedAssetReportType.assetRegisterFilter().withSubAssets);
                preset.setPrintHistory(presetStruct.filter.withHistory);
                preset.setDateForHistory(DateMapper.toDate((String)presetStruct.filter.historyDate));
                preset.setWithAdditionalTexts(presetStruct.filter.withAdditionalText);
                preset.setWithSummarizedAdditions(presetStruct.filter.fixedAssetReportType.assetRegisterFilter().summarizedAdditions);
                break;
            }
            case 1: {
                preset.setFromProcessingDate(DateMapper.toDate((String)presetStruct.filter.fixedAssetReportType.assetsAnalysisFilter().fromProcessingDate));
                preset.setToProcessingDate(DateMapper.toDate((String)presetStruct.filter.fixedAssetReportType.assetsAnalysisFilter().toProcessingDate));
                preset.setAssetNameType(presetStruct.filter.fixedAssetReportType.assetsAnalysisFilter().assetNameType);
                preset.setPrintGroupTotalOnly(presetStruct.filter.fixedAssetReportType.assetsAnalysisFilter().printGroupTotalOnly);
                preset.setWithGrants(presetStruct.filter.fixedAssetReportType.assetsAnalysisFilter().withGrants);
                preset.setPrintHistory(presetStruct.filter.withHistory);
                preset.setDateForHistory(DateMapper.toDate((String)presetStruct.filter.historyDate));
                optSortierung optGroupTotal = FixedAssetReportPresetMapper.toSortIdl(presetStruct.filter.groupTotalSeq);
                if (preset.getGroupTotal() == null) {
                    preset.setGroupTotal(SortMapper.createSort(null, (optSortierung)optGroupTotal));
                } else {
                    if (optGroupTotal.discriminator()) {
                        SortMapper.fillBO((Sort)preset.getGroupTotal(), (SortierungStruct)optGroupTotal.sort());
                    } else {
                        SortMapper.fillBO((Sort)preset.getGroupTotal(), (SortierungStruct)new SortierungStruct(new SortierungElementStruct[0]));
                    }
                    preset.getGroupTotal().makeSaveable();
                }
                preset.setPrintFixedAssetData(presetStruct.filter.fixedAssetReportType.assetsAnalysisFilter().printFixedAssetData);
                preset.setWithConsolidation(presetStruct.filter.fixedAssetReportType.assetsAnalysisFilter().consolidation);
                if (preset.getWithConsolidation()) {
                    AccountingCompany[] companies = new AccountingCompany[presetStruct.filter.fixedAssetReportType.assetsAnalysisFilter().consolidationCompanies.length];
                    for (int i = 0; i < companies.length; ++i) {
                        companies[i] = AccountingCompanyPersistencyManager.getAccountingCompany((String)presetStruct.filter.fixedAssetReportType.assetsAnalysisFilter().consolidationCompanies[i].oidTs.objectid);
                    }
                    preset.setCompanies(companies);
                } else {
                    preset.setCompanies(null);
                }
                preset.setPrintFurtherDeprData(presetStruct.filter.fixedAssetReportType.assetsAnalysisFilter().printFurtherDeprData);
                preset.setPrintSupplierData(presetStruct.filter.fixedAssetReportType.assetsAnalysisFilter().printSupplierData);
                preset.setPrintInterest(presetStruct.filter.fixedAssetReportType.assetsAnalysisFilter().printInterest);
                preset.setWithCostCentres(presetStruct.filter.fixedAssetReportType.assetsAnalysisFilter().withCostCentres);
                preset.setWithAdditionalTexts(presetStruct.filter.withAdditionalText);
                preset.setFormFeedType(presetStruct.filter.fixedAssetReportType.assetsAnalysisFilter().formFeedType);
                break;
            }
            case 2: {
                preset.setFromProcessingDate(DateMapper.toDate((String)presetStruct.filter.fixedAssetReportType.assetAddDispFilter().fromProcessingDate));
                preset.setToProcessingDate(DateMapper.toDate((String)presetStruct.filter.fixedAssetReportType.assetAddDispFilter().toProcessingDate));
                preset.setAssetNameType(presetStruct.filter.fixedAssetReportType.assetAddDispFilter().assetNameType);
                preset.setWithSingleTransactions(presetStruct.filter.fixedAssetReportType.assetAddDispFilter().withSingleTransactions);
                preset.setPrintFixedAssetData(presetStruct.filter.fixedAssetReportType.assetAddDispFilter().printFixedAssetData);
                preset.setPrintHistory(presetStruct.filter.withHistory);
                preset.setDateForHistory(DateMapper.toDate((String)presetStruct.filter.historyDate));
                preset.setPrintGroupTotalOnly(presetStruct.filter.fixedAssetReportType.assetAddDispFilter().printGroupTotalOnly);
                preset.setIsSelectDocDate(presetStruct.filter.fixedAssetReportType.assetAddDispFilter().isSelectDocDate);
                optSortierung optGroupTotal = FixedAssetReportPresetMapper.toSortIdl(presetStruct.filter.groupTotalSeq);
                if (preset.getGroupTotal() == null) {
                    preset.setGroupTotal(SortMapper.createSort(null, (optSortierung)optGroupTotal));
                    break;
                }
                if (optGroupTotal.discriminator()) {
                    SortMapper.fillBO((Sort)preset.getGroupTotal(), (SortierungStruct)optGroupTotal.sort());
                } else {
                    SortMapper.fillBO((Sort)preset.getGroupTotal(), (SortierungStruct)new SortierungStruct(new SortierungElementStruct[0]));
                }
                preset.getGroupTotal().makeSaveable();
                break;
            }
            case 4: {
                preset.setPreviewVersion(presetStruct.filter.fixedAssetReportType.deprPreviewFilter().version);
                preset.setNumberOfYears((int)presetStruct.filter.fixedAssetReportType.deprPreviewFilter().numberOfYears);
                preset.setFromProcessingDate(DateMapper.toDate((String)presetStruct.filter.fixedAssetReportType.deprPreviewFilter().fromDate));
                preset.setToProcessingDate(DateMapper.toDate((String)presetStruct.filter.fixedAssetReportType.deprPreviewFilter().toDate));
                preset.setPrintGroupTotalOnly(presetStruct.filter.fixedAssetReportType.deprPreviewFilter().printGroupTotalOnly);
                preset.setAssetNameType(presetStruct.filter.fixedAssetReportType.deprPreviewFilter().assetNameType);
                preset.setSortDeprValuesAscDesc(presetStruct.filter.fixedAssetReportType.deprPreviewFilter().sort);
                preset.setWithCostCentres(presetStruct.filter.fixedAssetReportType.deprPreviewFilter().withCostCentres);
                optSortierung optGroupTotal = FixedAssetReportPresetMapper.toSortIdl(presetStruct.filter.groupTotalSeq);
                if (preset.getGroupTotal() == null) {
                    preset.setGroupTotal(SortMapper.createSort(null, (optSortierung)optGroupTotal));
                    break;
                }
                if (optGroupTotal.discriminator()) {
                    SortMapper.fillBO((Sort)preset.getGroupTotal(), (SortierungStruct)optGroupTotal.sort());
                } else {
                    SortMapper.fillBO((Sort)preset.getGroupTotal(), (SortierungStruct)new SortierungStruct(new SortierungElementStruct[0]));
                }
                preset.getGroupTotal().makeSaveable();
                break;
            }
            case 3: {
                preset.setFromProcessingDate(DateMapper.toDate((String)presetStruct.filter.fixedAssetReportType.profitLossFilter().fromProcessingDate));
                preset.setToProcessingDate(DateMapper.toDate((String)presetStruct.filter.fixedAssetReportType.profitLossFilter().toProcessingDate));
                preset.setPrintGroupTotalOnly(presetStruct.filter.fixedAssetReportType.profitLossFilter().printGroupTotalOnly);
                preset.setAssetNameType(presetStruct.filter.fixedAssetReportType.profitLossFilter().assetNameType);
                preset.setWithZeroValues(!presetStruct.filter.fixedAssetReportType.profitLossFilter().withoutNullPositions);
                preset.setPrintHistory(presetStruct.filter.withHistory);
                preset.setDateForHistory(DateMapper.toDate((String)presetStruct.filter.historyDate));
                optSortierung optGroupTotal = FixedAssetReportPresetMapper.toSortIdl(presetStruct.filter.groupTotalSeq);
                if (preset.getGroupTotal() == null) {
                    preset.setGroupTotal(SortMapper.createSort(null, (optSortierung)optGroupTotal));
                    break;
                }
                if (optGroupTotal.discriminator()) {
                    SortMapper.fillBO((Sort)preset.getGroupTotal(), (SortierungStruct)optGroupTotal.sort());
                } else {
                    SortMapper.fillBO((Sort)preset.getGroupTotal(), (SortierungStruct)new SortierungStruct(new SortierungElementStruct[0]));
                }
                preset.getGroupTotal().makeSaveable();
                break;
            }
            case 5: {
                preset.setFromProcessingDate(DateMapper.toDate((String)presetStruct.filter.fixedAssetReportType.depreciationFilter().fromProcessingDate));
                preset.setToProcessingDate(DateMapper.toDate((String)presetStruct.filter.fixedAssetReportType.depreciationFilter().toProcessingDate));
                preset.setAssetNameType(presetStruct.filter.fixedAssetReportType.depreciationFilter().assetNameType);
                preset.setPrintGroupTotalOnly(presetStruct.filter.fixedAssetReportType.depreciationFilter().printGroupTotalOnly);
                preset.setWithCostCentres(presetStruct.filter.fixedAssetReportType.depreciationFilter().withCostCentres);
                preset.setPrintHistory(presetStruct.filter.withHistory);
                preset.setDateForHistory(DateMapper.toDate((String)presetStruct.filter.historyDate));
                preset.setWithGrants(presetStruct.filter.fixedAssetReportType.depreciationFilter().withGrants);
                preset.setPrintFixedAssetData(presetStruct.filter.fixedAssetReportType.depreciationFilter().withFixedAssetData);
                optSortierung optGroupTotal = FixedAssetReportPresetMapper.toSortIdl(presetStruct.filter.groupTotalSeq);
                if (preset.getGroupTotal() == null) {
                    preset.setGroupTotal(SortMapper.createSort(null, (optSortierung)optGroupTotal));
                    break;
                }
                if (optGroupTotal.discriminator()) {
                    SortMapper.fillBO((Sort)preset.getGroupTotal(), (SortierungStruct)optGroupTotal.sort());
                } else {
                    SortMapper.fillBO((Sort)preset.getGroupTotal(), (SortierungStruct)new SortierungStruct(new SortierungElementStruct[0]));
                }
                preset.getGroupTotal().makeSaveable();
                break;
            }
            case 6: {
                int i;
                preset.setToProcessingDate(DateMapper.toDate((String)presetStruct.filter.fixedAssetReportType.inventoryFilter().toProcessingDate));
                preset.setWithFullDisposal(presetStruct.filter.fixedAssetReportType.inventoryFilter().withFullDisposal);
                preset.setWithValues(presetStruct.filter.fixedAssetReportType.inventoryFilter().withValues);
                preset.setAssetNameType(presetStruct.filter.fixedAssetReportType.inventoryFilter().assetNameType);
                preset.setFormFeedType(presetStruct.filter.fixedAssetReportType.inventoryFilter().formFeedType);
                preset.setPrintHistory(presetStruct.filter.withHistory);
                preset.setDateForHistory(DateMapper.toDate((String)presetStruct.filter.historyDate));
                preset.setWithCostCentres(presetStruct.filter.fixedAssetReportType.inventoryFilter().withCostCentres);
                preset.setWithAdditionalTexts(presetStruct.filter.withAdditionalText);
                boolean[] analCodes = new boolean[10];
                for (i = 0; i < analCodes.length; ++i) {
                    analCodes[i] = false;
                }
                if (presetStruct.filter.fixedAssetReportType.inventoryFilter().withACSeq.length != 0) {
                    for (i = 0; i < presetStruct.filter.fixedAssetReportType.inventoryFilter().withACSeq.length; ++i) {
                        analCodes[i] = presetStruct.filter.fixedAssetReportType.inventoryFilter().withACSeq[i];
                    }
                }
                preset.setPrintAC0(analCodes[0]);
                preset.setPrintAC1(analCodes[1]);
                preset.setPrintAC2(analCodes[2]);
                preset.setPrintAC3(analCodes[3]);
                preset.setPrintAC4(analCodes[4]);
                preset.setPrintAC5(analCodes[5]);
                preset.setPrintAC6(analCodes[6]);
                preset.setPrintAC7(analCodes[7]);
                preset.setPrintAC8(analCodes[8]);
                preset.setPrintAC9(analCodes[9]);
                optSortierung optGroupTotal = FixedAssetReportPresetMapper.toSortIdl(presetStruct.filter.groupTotalSeq);
                if (preset.getGroupTotal() == null) {
                    preset.setGroupTotal(SortMapper.createSort(null, (optSortierung)optGroupTotal));
                    break;
                }
                if (optGroupTotal.discriminator()) {
                    SortMapper.fillBO((Sort)preset.getGroupTotal(), (SortierungStruct)optGroupTotal.sort());
                } else {
                    SortMapper.fillBO((Sort)preset.getGroupTotal(), (SortierungStruct)new SortierungStruct(new SortierungElementStruct[0]));
                }
                preset.getGroupTotal().makeSaveable();
                break;
            }
            case 7: {
                preset.setAssetNameType(presetStruct.filter.fixedAssetReportType.insuranceFilter().assetNameType);
                preset.setPrintGroupTotalOnly(presetStruct.filter.fixedAssetReportType.insuranceFilter().printGroupTotalOnly);
                preset.setPrintHistory(presetStruct.filter.withHistory);
                preset.setDateForHistory(DateMapper.toDate((String)presetStruct.filter.historyDate));
                optSortierung optGroupTotal = FixedAssetReportPresetMapper.toSortIdl(presetStruct.filter.groupTotalSeq);
                if (preset.getGroupTotal() == null) {
                    preset.setGroupTotal(SortMapper.createSort(null, (optSortierung)optGroupTotal));
                } else {
                    if (optGroupTotal.discriminator()) {
                        SortMapper.fillBO((Sort)preset.getGroupTotal(), (SortierungStruct)optGroupTotal.sort());
                    } else {
                        SortMapper.fillBO((Sort)preset.getGroupTotal(), (SortierungStruct)new SortierungStruct(new SortierungElementStruct[0]));
                    }
                    preset.getGroupTotal().makeSaveable();
                }
                preset.setCalculateReplValue(presetStruct.filter.fixedAssetReportType.insuranceFilter().calculateReplValue);
                break;
            }
            case 8: {
                preset.setQuickChangeAttribute(QuickChangeAttributeMapper.fillQuickChangeAttribute(preset, presetStruct.filter.fixedAssetReportType.changeTopic().changeSeq));
                preset.setQuickChangePreview(presetStruct.filter.fixedAssetReportType.changeTopic().preview);
                preset.setDateForHistory(DateMapper.toDate((String)presetStruct.filter.fixedAssetReportType.changeTopic().validFromDate));
                break;
            }
            case 9: {
                preset.setFromProcessingDate(DateMapper.toDate((String)presetStruct.filter.fixedAssetReportType.assetsAnalysisFilter().fromProcessingDate));
                preset.setToProcessingDate(DateMapper.toDate((String)presetStruct.filter.fixedAssetReportType.assetsAnalysisFilter().toProcessingDate));
                preset.setAssetNameType(presetStruct.filter.fixedAssetReportType.assetsAnalysisFilter().assetNameType);
                preset.setPrintGroupTotalOnly(presetStruct.filter.fixedAssetReportType.assetsAnalysisFilter().printGroupTotalOnly);
                optSortierung optGroupTotal = FixedAssetReportPresetMapper.toSortIdl(presetStruct.filter.groupTotalSeq);
                if (preset.getGroupTotal() == null) {
                    preset.setGroupTotal(SortMapper.createSort(null, (optSortierung)optGroupTotal));
                    break;
                }
                if (optGroupTotal.discriminator()) {
                    SortMapper.fillBO((Sort)preset.getGroupTotal(), (SortierungStruct)optGroupTotal.sort());
                } else {
                    SortMapper.fillBO((Sort)preset.getGroupTotal(), (SortierungStruct)new SortierungStruct(new SortierungElementStruct[0]));
                }
                preset.getGroupTotal().makeSaveable();
                break;
            }
            case 10: {
                preset.setWithFullDisposal(presetStruct.filter.fixedAssetReportType.copyData().withFullDisposals);
                preset.setCopyType(presetStruct.filter.fixedAssetReportType.copyData().copyType);
                preset.setCopyAssetData(presetStruct.filter.fixedAssetReportType.copyData().assetData);
                AccountingCompany inCompany = AccountingCompanyPersistencyManager.getAccountingCompany((String)presetStruct.filter.fixedAssetReportType.copyData().oidToCompany);
                preset.setInAccountingCompany(inCompany);
                preset.setQuickChangeAttribute(QuickChangeAttributeMapper.fillCopyDataAttribute(preset, presetStruct.filter.fixedAssetReportType.copyData().copyAreasSeq));
                preset.setPrintAssetNotes(presetStruct.filter.fixedAssetReportType.copyData().copyLocations);
                preset.setPrintAnalysisCodes(presetStruct.filter.fixedAssetReportType.copyData().copyProjects);
                preset.setPrintGroupTotalOnly(presetStruct.filter.fixedAssetReportType.copyData().copyPersons);
                preset.setPrintTransactions(presetStruct.filter.fixedAssetReportType.copyData().copyInsurances);
                break;
            }
            case 11: {
                preset.setFromProcessingDate(DateMapper.toDate((String)presetStruct.filter.fixedAssetReportType.assetAddDispFilter().fromProcessingDate));
                preset.setToProcessingDate(DateMapper.toDate((String)presetStruct.filter.fixedAssetReportType.assetAddDispFilter().toProcessingDate));
                preset.setAssetNameType(presetStruct.filter.fixedAssetReportType.assetAddDispFilter().assetNameType);
                preset.setWithSingleTransactions(true);
                preset.setPrintHistory(presetStruct.filter.withHistory);
                preset.setDateForHistory(DateMapper.toDate((String)presetStruct.filter.historyDate));
                preset.setPrintGroupTotalOnly(presetStruct.filter.fixedAssetReportType.assetAddDispFilter().printGroupTotalOnly);
                preset.setIsSelectDocDate(presetStruct.filter.fixedAssetReportType.assetAddDispFilter().isSelectDocDate);
                preset.setPrintFixedAssetData(presetStruct.filter.fixedAssetReportType.assetAddDispFilter().printFixedAssetData);
                optSortierung optGroupTotal = FixedAssetReportPresetMapper.toSortIdl(presetStruct.filter.groupTotalSeq);
                if (preset.getGroupTotal() == null) {
                    preset.setGroupTotal(SortMapper.createSort(null, (optSortierung)optGroupTotal));
                    break;
                }
                if (optGroupTotal.discriminator()) {
                    SortMapper.fillBO((Sort)preset.getGroupTotal(), (SortierungStruct)optGroupTotal.sort());
                } else {
                    SortMapper.fillBO((Sort)preset.getGroupTotal(), (SortierungStruct)new SortierungStruct(new SortierungElementStruct[0]));
                }
                preset.getGroupTotal().makeSaveable();
                break;
            }
            case 13: {
                preset.setFromProcessingDate(DateMapper.toDate((String)presetStruct.filter.fixedAssetReportType.quantityFilter().fromProcessingDate));
                preset.setToProcessingDate(DateMapper.toDate((String)presetStruct.filter.fixedAssetReportType.quantityFilter().toProcessingDate));
                preset.setAssetNameType(presetStruct.filter.fixedAssetReportType.quantityFilter().assetNameType);
                preset.setPrintGroupTotalOnly(presetStruct.filter.fixedAssetReportType.quantityFilter().printGroupTotalOnly);
                preset.setQuantityUnit(QuantityUnitPersistencyManager.getUnitByOID((String)presetStruct.filter.fixedAssetReportType.quantityFilter().quantityUnit.oidTs.objectid));
                preset.setPrintFixedAssetData(presetStruct.filter.fixedAssetReportType.quantityFilter().printFixedAssetData);
                preset.setPrintHistory(presetStruct.filter.withHistory);
                preset.setDateForHistory(DateMapper.toDate((String)presetStruct.filter.historyDate));
                preset.setWithAdditionalTexts(presetStruct.filter.withAdditionalText);
                optSortierung optGroupTotal = FixedAssetReportPresetMapper.toSortIdl(presetStruct.filter.groupTotalSeq);
                if (preset.getGroupTotal() == null) {
                    preset.setGroupTotal(SortMapper.createSort(null, (optSortierung)optGroupTotal));
                    break;
                }
                if (optGroupTotal.discriminator()) {
                    SortMapper.fillBO((Sort)preset.getGroupTotal(), (SortierungStruct)optGroupTotal.sort());
                } else {
                    SortMapper.fillBO((Sort)preset.getGroupTotal(), (SortierungStruct)new SortierungStruct(new SortierungElementStruct[0]));
                }
                preset.getGroupTotal().makeSaveable();
                break;
            }
            case 14: {
                AccountingCompany toCompany = AccountingCompanyPersistencyManager.getAccountingCompany((String)presetStruct.filter.fixedAssetReportType.interchangeFilter().oidToCompany);
                preset.setInAccountingCompany(toCompany);
                preset.setFromRetirementDate(DateMapper.toDate((String)presetStruct.filter.fixedAssetReportType.interchangeFilter().fromRetirementDate));
                preset.setToRetirementDate(DateMapper.toDate((String)presetStruct.filter.fixedAssetReportType.interchangeFilter().toRetirementDate));
                preset.setInterchangeDate(DateMapper.toDate((String)presetStruct.filter.fixedAssetReportType.interchangeFilter().interchangeDate));
                preset.setQuickChangeAttribute(QuickChangeAttributeMapper.fillCopyDataAttribute(preset, presetStruct.filter.fixedAssetReportType.interchangeFilter().copyAreasForInterchangeSeq));
            }
        }
    }

    private static optSortierung toSortIdl(AttributeStruct[] sortSeq) {
        if (sortSeq.length == 0) {
            optSortierung optSort = new optSortierung();
            optSort.__default();
            return optSort;
        }
        optSortierung result = new optSortierung();
        result.sort(new SortierungStruct());
        result.sort().sortierungElements = new SortierungElementStruct[sortSeq.length];
        for (int i = 0; i < sortSeq.length; ++i) {
            result.sort().sortierungElements[i] = FixedAssetReportPresetMapper.toSortElementsIdl(sortSeq[i]);
        }
        return result;
    }

    private static SortierungElementStruct toSortElementsIdl(AttributeStruct sortSeq) {
        SortierungElementStruct sortElement = new SortierungElementStruct();
        sortElement.attributeName = sortSeq.attributeCode;
        sortElement.order = true;
        return sortElement;
    }

    private static FixedAssetReportFilterStruct toFilterIdl(FixedAssetReportPreset preset) throws BusinessDomainException {
        FixedAssetReportFilterStruct filterStruct = new FixedAssetReportFilterStruct();
        filterStruct.oidCompany = StringMapper.toString((String)PersistentObjectUtils.getObjectidForContainer((IPersistentObject)preset.getAccountingCompany()));
        if (preset.getFilter() != null) {
            filterStruct.filtersSeq = ExtendedFilterMapper.toIdl((ExtendedFilter)preset.getFilter());
            filterStruct.filtersSeq = FixedAssetReportPresetMapper.filterElementJoin(filterStruct.filtersSeq);
        } else {
            filterStruct.filtersSeq = new ExtendedFilterStruct[0];
        }
        if (preset.getSort() != null) {
            SortierungStruct sortStruct = SortMapper.toIdl((Sort)preset.getSort());
            filterStruct.sortSeq = new AttributeStruct[sortStruct.sortierungElements.length];
            for (int i = 0; i < filterStruct.sortSeq.length; ++i) {
                filterStruct.sortSeq[i] = new AttributeStruct();
                filterStruct.sortSeq[i].attributeCode = sortStruct.sortierungElements[i].attributeName;
                filterStruct.sortSeq[i].attributeName = FixedAssetReportFilterMapper.getFixedAssetFieldNames((String)filterStruct.sortSeq[i].attributeCode, (AccountingCompany)preset.getAccountingCompany());
                filterStruct.sortSeq[i].attributeType = FixedAssetReportFilterMapper.getFixedAssetFieldType((String)filterStruct.sortSeq[i].attributeCode);
                filterStruct.sortSeq[i].decimals = Short.MIN_VALUE;
                filterStruct.sortSeq[i].type = "";
                filterStruct.sortSeq[i].attributeValues = new String[0];
            }
        } else {
            filterStruct.sortSeq = new AttributeStruct[0];
        }
        filterStruct.languageForLanguageDependentTexts = LanguageMapper.toIdl((ILanguage)preset.getLanguage());
        filterStruct.currency = CurrencyMapper.toIdl((ICurrency)preset.getCurrency());
        if (preset.getFixedAssetReportType().equals(FixedAssetReportEnum.FARE_COPYDATA) || preset.getFixedAssetReportType().equals(FixedAssetReportEnum.FARE_INTERCHANGE_ASSETS)) {
            DepreciationArea[] areas = DepreciationArea.getDepreciationAreas((AccountingCompany)preset.getAccountingCompany());
            filterStruct.areaShortSeq = DepreciationAreaMapper.toShortIdl((DepreciationArea[])areas);
        } else {
            filterStruct.areaShortSeq = DepreciationAreaMapper.toShortIdl((DepreciationArea[])preset.getAssetAreas());
        }
        optFAFinancialYearShort faYear = new optFAFinancialYearShort();
        if (preset.getFinancialYear() == null) {
            faYear.__default();
        } else {
            faYear.yearShort(FAFinancialYearMapper.toShortIdl((FAFinancialYear)preset.getFinancialYear()));
        }
        filterStruct.financialYear = faYear;
        filterStruct.fixedAssetReportType = new FixedAssetReportTypeUnion();
        filterStruct.mainSubCompactedType = MainSubCompactedEnum.MSCE_NO;
        switch (preset.getFixedAssetReportType().value()) {
            case 0: {
                filterStruct.fixedAssetReportType.assetRegisterFilter(new AssetRegisterReportFilterStruct());
                filterStruct.fixedAssetReportType.assetRegisterFilter().printAssetNotes = preset.getPrintAssetNotes();
                filterStruct.fixedAssetReportType.assetRegisterFilter().printAnalysisCodes = preset.getPrintAnalysisCodes();
                filterStruct.fixedAssetReportType.assetRegisterFilter().printTransactions = preset.getPrintTransactions();
                filterStruct.groupTotalSeq = new AttributeStruct[0];
                filterStruct.fixedAssetReportType.assetRegisterFilter().printType = preset.getPrintTypePL();
                filterStruct.fixedAssetReportType.assetRegisterFilter().fromProcessingDate = DateMapper.toString((Date)preset.getFromProcessingDate());
                filterStruct.fixedAssetReportType.assetRegisterFilter().toProcessingDate = DateMapper.toString((Date)preset.getToProcessingDate());
                filterStruct.fixedAssetReportType.assetRegisterFilter().printInventoryData = preset.getPrintInventoryData();
                filterStruct.fixedAssetReportType.assetRegisterFilter().withCostCentres = preset.getPrintCostCentres();
                filterStruct.fixedAssetReportType.assetRegisterFilter().withSubAssets = preset.getPrintSubFixedAssets();
                filterStruct.withHistory = preset.getPrintHistory();
                filterStruct.historyDate = DateMapper.toString((Date)preset.getDateForHistory());
                filterStruct.withAdditionalText = preset.getWithAdditionalTexts();
                filterStruct.fixedAssetReportType.assetRegisterFilter().summarizedAdditions = preset.getWithSummarizedAdditions();
                break;
            }
            case 1: {
                int i;
                AttributeStruct[] groupTotals;
                filterStruct.fixedAssetReportType.assetsAnalysisFilter(new AssetsAnalysisReportFilterStruct());
                filterStruct.fixedAssetReportType.assetsAnalysisFilter().fromProcessingDate = DateMapper.toString((Date)preset.getFromProcessingDate());
                filterStruct.fixedAssetReportType.assetsAnalysisFilter().toProcessingDate = DateMapper.toString((Date)preset.getToProcessingDate());
                filterStruct.fixedAssetReportType.assetsAnalysisFilter().assetNameType = preset.getAssetNameType();
                filterStruct.fixedAssetReportType.assetsAnalysisFilter().printGroupTotalOnly = preset.getPrintGroupTotalOnly();
                filterStruct.fixedAssetReportType.assetsAnalysisFilter().withGrants = preset.getWithGrants();
                filterStruct.withHistory = preset.getPrintHistory();
                filterStruct.historyDate = DateMapper.toString((Date)preset.getDateForHistory());
                if (preset.getSort() != null && preset.getGroupTotal() != null) {
                    SortierungStruct gorupTotalStruct = SortMapper.toIdl((Sort)preset.getGroupTotal());
                    groupTotals = new AttributeStruct[gorupTotalStruct.sortierungElements.length];
                    for (i = 0; i < groupTotals.length; ++i) {
                        groupTotals[i] = new AttributeStruct();
                        groupTotals[i].attributeCode = gorupTotalStruct.sortierungElements[i].attributeName;
                        groupTotals[i].attributeName = FixedAssetReportFilterMapper.getFixedAssetFieldNames((String)groupTotals[i].attributeCode, (AccountingCompany)preset.getAccountingCompany());
                        groupTotals[i].attributeType = FixedAssetReportFilterMapper.getFixedAssetFieldType((String)groupTotals[i].attributeCode);
                        groupTotals[i].decimals = Short.MIN_VALUE;
                        groupTotals[i].type = "";
                        groupTotals[i].attributeValues = new String[0];
                    }
                    filterStruct.groupTotalSeq = groupTotals;
                } else {
                    filterStruct.groupTotalSeq = new AttributeStruct[0];
                }
                filterStruct.fixedAssetReportType.assetsAnalysisFilter().printFixedAssetData = preset.getPrintFixedAssetData();
                filterStruct.fixedAssetReportType.assetsAnalysisFilter().consolidation = preset.getWithConsolidation();
                if (preset.getWithConsolidation()) {
                    AccountingCompany[] companies = preset.getCompanies();
                    if (companies != null && companies.length != 0) {
                        filterStruct.fixedAssetReportType.assetsAnalysisFilter().consolidationCompanies = CompanyMapper.toShortIdl((Company[])preset.getCompanies());
                    }
                } else {
                    filterStruct.fixedAssetReportType.assetsAnalysisFilter().consolidationCompanies = new CompanyShortStruct[0];
                }
                filterStruct.fixedAssetReportType.assetsAnalysisFilter().printFurtherDeprData = preset.getPrintFurtherDeprData();
                filterStruct.fixedAssetReportType.assetsAnalysisFilter().printSupplierData = preset.getPrintSupplierData();
                filterStruct.fixedAssetReportType.assetsAnalysisFilter().printInterest = preset.getPrintInterest();
                filterStruct.fixedAssetReportType.assetsAnalysisFilter().withCostCentres = preset.getWithCostCentres();
                filterStruct.withAdditionalText = preset.getWithAdditionalTexts();
                filterStruct.mainSubCompactedType = preset.getMainSubCompactedType();
                filterStruct.fixedAssetReportType.assetsAnalysisFilter().formFeedType = preset.getFormFeedType();
                break;
            }
            case 2: {
                int i;
                AttributeStruct[] groupTotals;
                filterStruct.fixedAssetReportType.assetAddDispFilter(new AssetAdditionDisposalReportFilterStruct());
                filterStruct.fixedAssetReportType.assetAddDispFilter().fromProcessingDate = DateMapper.toString((Date)preset.getFromProcessingDate());
                filterStruct.fixedAssetReportType.assetAddDispFilter().toProcessingDate = DateMapper.toString((Date)preset.getToProcessingDate());
                filterStruct.fixedAssetReportType.assetAddDispFilter().assetNameType = preset.getAssetNameType();
                filterStruct.fixedAssetReportType.assetAddDispFilter().printFixedAssetData = preset.getPrintFixedAssetData();
                filterStruct.withHistory = preset.getPrintHistory();
                filterStruct.historyDate = DateMapper.toString((Date)preset.getDateForHistory());
                filterStruct.fixedAssetReportType.assetAddDispFilter().printGroupTotalOnly = preset.getPrintGroupTotalOnly();
                filterStruct.fixedAssetReportType.assetAddDispFilter().withSingleTransactions = preset.getWithSingleTransactions();
                filterStruct.fixedAssetReportType.assetAddDispFilter().isSelectDocDate = preset.getIsSelectDocDate();
                if (preset.getSort() != null && preset.getGroupTotal() != null) {
                    SortierungStruct gorupTotalStruct = SortMapper.toIdl((Sort)preset.getGroupTotal());
                    groupTotals = new AttributeStruct[gorupTotalStruct.sortierungElements.length];
                    for (i = 0; i < groupTotals.length; ++i) {
                        groupTotals[i] = new AttributeStruct();
                        groupTotals[i].attributeCode = gorupTotalStruct.sortierungElements[i].attributeName;
                        groupTotals[i].attributeName = FixedAssetReportFilterMapper.getFixedAssetFieldNames((String)groupTotals[i].attributeCode, (AccountingCompany)preset.getAccountingCompany());
                        groupTotals[i].attributeType = FixedAssetReportFilterMapper.getFixedAssetFieldType((String)groupTotals[i].attributeCode);
                        groupTotals[i].decimals = Short.MIN_VALUE;
                        groupTotals[i].type = "";
                        groupTotals[i].attributeValues = new String[0];
                    }
                    filterStruct.groupTotalSeq = groupTotals;
                    break;
                }
                filterStruct.groupTotalSeq = new AttributeStruct[0];
                break;
            }
            case 4: {
                int i;
                AttributeStruct[] groupTotals;
                filterStruct.fixedAssetReportType.deprPreviewFilter(new DepreciationPreviewReportFilterStruct());
                filterStruct.fixedAssetReportType.deprPreviewFilter().version = preset.getPreviewVersion();
                filterStruct.fixedAssetReportType.deprPreviewFilter().numberOfYears = (short)preset.getNumberOfYears();
                filterStruct.fixedAssetReportType.deprPreviewFilter().fromDate = DateMapper.toString((Date)preset.getFromProcessingDate());
                filterStruct.fixedAssetReportType.deprPreviewFilter().toDate = DateMapper.toString((Date)preset.getToProcessingDate());
                filterStruct.fixedAssetReportType.deprPreviewFilter().printGroupTotalOnly = preset.getPrintGroupTotalOnly();
                filterStruct.fixedAssetReportType.deprPreviewFilter().assetNameType = preset.getAssetNameType();
                filterStruct.fixedAssetReportType.deprPreviewFilter().sort = preset.getSortDeprValuesAscDesc();
                filterStruct.fixedAssetReportType.deprPreviewFilter().withCostCentres = preset.getWithCostCentres();
                if (preset.getSort() != null && preset.getGroupTotal() != null) {
                    SortierungStruct gorupTotalStruct = SortMapper.toIdl((Sort)preset.getGroupTotal());
                    groupTotals = new AttributeStruct[gorupTotalStruct.sortierungElements.length];
                    for (i = 0; i < groupTotals.length; ++i) {
                        groupTotals[i] = new AttributeStruct();
                        groupTotals[i].attributeCode = gorupTotalStruct.sortierungElements[i].attributeName;
                        groupTotals[i].attributeName = FixedAssetReportFilterMapper.getFixedAssetFieldNames((String)groupTotals[i].attributeCode, (AccountingCompany)preset.getAccountingCompany());
                        groupTotals[i].attributeType = FixedAssetReportFilterMapper.getFixedAssetFieldType((String)groupTotals[i].attributeCode);
                        groupTotals[i].decimals = Short.MIN_VALUE;
                        groupTotals[i].type = "";
                        groupTotals[i].attributeValues = new String[0];
                    }
                    filterStruct.groupTotalSeq = groupTotals;
                    break;
                }
                filterStruct.groupTotalSeq = new AttributeStruct[0];
                break;
            }
            case 3: {
                int i;
                AttributeStruct[] groupTotals;
                filterStruct.fixedAssetReportType.profitLossFilter(new ProfitLossReportFilterStruct());
                filterStruct.fixedAssetReportType.profitLossFilter().fromProcessingDate = DateMapper.toString((Date)preset.getFromProcessingDate());
                filterStruct.fixedAssetReportType.profitLossFilter().toProcessingDate = DateMapper.toString((Date)preset.getToProcessingDate());
                filterStruct.fixedAssetReportType.profitLossFilter().assetNameType = preset.getAssetNameType();
                filterStruct.fixedAssetReportType.profitLossFilter().printGroupTotalOnly = preset.getPrintGroupTotalOnly();
                filterStruct.fixedAssetReportType.profitLossFilter().withoutNullPositions = !preset.getWithZeroValues();
                filterStruct.withHistory = preset.getPrintHistory();
                filterStruct.historyDate = DateMapper.toString((Date)preset.getDateForHistory());
                if (preset.getSort() != null && preset.getGroupTotal() != null) {
                    SortierungStruct gorupTotalStruct = SortMapper.toIdl((Sort)preset.getGroupTotal());
                    groupTotals = new AttributeStruct[gorupTotalStruct.sortierungElements.length];
                    for (i = 0; i < groupTotals.length; ++i) {
                        groupTotals[i] = new AttributeStruct();
                        groupTotals[i].attributeCode = gorupTotalStruct.sortierungElements[i].attributeName;
                        groupTotals[i].attributeName = FixedAssetReportFilterMapper.getFixedAssetFieldNames((String)groupTotals[i].attributeCode, (AccountingCompany)preset.getAccountingCompany());
                        groupTotals[i].attributeType = FixedAssetReportFilterMapper.getFixedAssetFieldType((String)groupTotals[i].attributeCode);
                        groupTotals[i].decimals = Short.MIN_VALUE;
                        groupTotals[i].type = "";
                        groupTotals[i].attributeValues = new String[0];
                    }
                    filterStruct.groupTotalSeq = groupTotals;
                    break;
                }
                filterStruct.groupTotalSeq = new AttributeStruct[0];
                break;
            }
            case 5: {
                int i;
                AttributeStruct[] groupTotals;
                filterStruct.fixedAssetReportType.depreciationFilter(new DepreciationReportFilterStruct());
                filterStruct.fixedAssetReportType.depreciationFilter().fromProcessingDate = DateMapper.toString((Date)preset.getFromProcessingDate());
                filterStruct.fixedAssetReportType.depreciationFilter().toProcessingDate = DateMapper.toString((Date)preset.getToProcessingDate());
                filterStruct.fixedAssetReportType.depreciationFilter().assetNameType = preset.getAssetNameType();
                filterStruct.fixedAssetReportType.depreciationFilter().printGroupTotalOnly = preset.getPrintGroupTotalOnly();
                filterStruct.fixedAssetReportType.depreciationFilter().withCostCentres = preset.getWithCostCentres();
                filterStruct.withHistory = preset.getPrintHistory();
                filterStruct.historyDate = DateMapper.toString((Date)preset.getDateForHistory());
                filterStruct.fixedAssetReportType.depreciationFilter().withGrants = preset.getWithGrants();
                filterStruct.fixedAssetReportType.depreciationFilter().withFixedAssetData = preset.getPrintFixedAssetData();
                if (preset.getSort() != null && preset.getGroupTotal() != null) {
                    SortierungStruct gorupTotalStruct = SortMapper.toIdl((Sort)preset.getGroupTotal());
                    groupTotals = new AttributeStruct[gorupTotalStruct.sortierungElements.length];
                    for (i = 0; i < groupTotals.length; ++i) {
                        groupTotals[i] = new AttributeStruct();
                        groupTotals[i].attributeCode = gorupTotalStruct.sortierungElements[i].attributeName;
                        groupTotals[i].attributeName = FixedAssetReportFilterMapper.getFixedAssetFieldNames((String)groupTotals[i].attributeCode, (AccountingCompany)preset.getAccountingCompany());
                        groupTotals[i].attributeType = FixedAssetReportFilterMapper.getFixedAssetFieldType((String)groupTotals[i].attributeCode);
                        groupTotals[i].decimals = Short.MIN_VALUE;
                        groupTotals[i].type = "";
                        groupTotals[i].attributeValues = new String[0];
                    }
                    filterStruct.groupTotalSeq = groupTotals;
                    break;
                }
                filterStruct.groupTotalSeq = new AttributeStruct[0];
                break;
            }
            case 6: {
                int i;
                AttributeStruct[] groupTotals;
                filterStruct.fixedAssetReportType.inventoryFilter(new InventoryReportFilterStruct());
                filterStruct.fixedAssetReportType.inventoryFilter().toProcessingDate = DateMapper.toString((Date)preset.getToProcessingDate());
                filterStruct.fixedAssetReportType.inventoryFilter().withFullDisposal = preset.getWithFullDisposal();
                filterStruct.fixedAssetReportType.inventoryFilter().withValues = preset.getWithValues();
                filterStruct.fixedAssetReportType.inventoryFilter().assetNameType = preset.getAssetNameType();
                filterStruct.fixedAssetReportType.inventoryFilter().formFeedType = preset.getFormFeedType();
                filterStruct.fixedAssetReportType.inventoryFilter().withCostCentres = preset.getWithCostCentres();
                filterStruct.fixedAssetReportType.inventoryFilter().withACSeq = new boolean[10];
                filterStruct.fixedAssetReportType.inventoryFilter().withACSeq[0] = preset.getPrintAC0();
                filterStruct.fixedAssetReportType.inventoryFilter().withACSeq[1] = preset.getPrintAC1();
                filterStruct.fixedAssetReportType.inventoryFilter().withACSeq[2] = preset.getPrintAC2();
                filterStruct.fixedAssetReportType.inventoryFilter().withACSeq[3] = preset.getPrintAC3();
                filterStruct.fixedAssetReportType.inventoryFilter().withACSeq[4] = preset.getPrintAC4();
                filterStruct.fixedAssetReportType.inventoryFilter().withACSeq[5] = preset.getPrintAC5();
                filterStruct.fixedAssetReportType.inventoryFilter().withACSeq[6] = preset.getPrintAC6();
                filterStruct.fixedAssetReportType.inventoryFilter().withACSeq[7] = preset.getPrintAC7();
                filterStruct.fixedAssetReportType.inventoryFilter().withACSeq[8] = preset.getPrintAC8();
                filterStruct.fixedAssetReportType.inventoryFilter().withACSeq[9] = preset.getPrintAC9();
                filterStruct.withHistory = preset.getPrintHistory();
                filterStruct.historyDate = DateMapper.toString((Date)preset.getDateForHistory());
                filterStruct.withAdditionalText = preset.getWithAdditionalTexts();
                if (preset.getSort() != null && preset.getGroupTotal() != null) {
                    SortierungStruct gorupTotalStruct = SortMapper.toIdl((Sort)preset.getGroupTotal());
                    groupTotals = new AttributeStruct[gorupTotalStruct.sortierungElements.length];
                    for (i = 0; i < groupTotals.length; ++i) {
                        groupTotals[i] = new AttributeStruct();
                        groupTotals[i].attributeCode = gorupTotalStruct.sortierungElements[i].attributeName;
                        groupTotals[i].attributeName = FixedAssetReportFilterMapper.getFixedAssetFieldNames((String)groupTotals[i].attributeCode, (AccountingCompany)preset.getAccountingCompany());
                        groupTotals[i].attributeType = FixedAssetReportFilterMapper.getFixedAssetFieldType((String)groupTotals[i].attributeCode);
                        groupTotals[i].decimals = Short.MIN_VALUE;
                        groupTotals[i].type = "";
                        groupTotals[i].attributeValues = new String[0];
                    }
                    filterStruct.groupTotalSeq = groupTotals;
                    break;
                }
                filterStruct.groupTotalSeq = new AttributeStruct[0];
                break;
            }
            case 7: {
                int i;
                AttributeStruct[] groupTotals;
                filterStruct.fixedAssetReportType.insuranceFilter(new InsuranceReportFilterStruct());
                filterStruct.fixedAssetReportType.insuranceFilter().assetNameType = preset.getAssetNameType();
                filterStruct.fixedAssetReportType.insuranceFilter().printGroupTotalOnly = preset.getPrintGroupTotalOnly();
                filterStruct.withHistory = preset.getPrintHistory();
                filterStruct.historyDate = DateMapper.toString((Date)preset.getDateForHistory());
                if (preset.getSort() != null && preset.getGroupTotal() != null) {
                    SortierungStruct gorupTotalStruct = SortMapper.toIdl((Sort)preset.getGroupTotal());
                    groupTotals = new AttributeStruct[gorupTotalStruct.sortierungElements.length];
                    for (i = 0; i < groupTotals.length; ++i) {
                        groupTotals[i] = new AttributeStruct();
                        groupTotals[i].attributeCode = gorupTotalStruct.sortierungElements[i].attributeName;
                        groupTotals[i].attributeName = FixedAssetReportFilterMapper.getFixedAssetFieldNames((String)groupTotals[i].attributeCode, (AccountingCompany)preset.getAccountingCompany());
                        groupTotals[i].attributeType = FixedAssetReportFilterMapper.getFixedAssetFieldType((String)groupTotals[i].attributeCode);
                        groupTotals[i].decimals = Short.MIN_VALUE;
                        groupTotals[i].type = "";
                        groupTotals[i].attributeValues = new String[0];
                    }
                    filterStruct.groupTotalSeq = groupTotals;
                } else {
                    filterStruct.groupTotalSeq = new AttributeStruct[0];
                }
                filterStruct.fixedAssetReportType.insuranceFilter().calculateReplValue = preset.getCalculateReplValue();
                break;
            }
            case 8: {
                filterStruct.fixedAssetReportType.changeTopic(new QuickChangeTopicStruct());
                filterStruct.fixedAssetReportType.changeTopic().changeSeq = QuickChangeAttributeMapper.toIdl(preset.getQuickChangeAttribute());
                filterStruct.groupTotalSeq = new AttributeStruct[0];
                filterStruct.fixedAssetReportType.changeTopic().preview = preset.getQuickChangePreview();
                filterStruct.fixedAssetReportType.changeTopic().validFromDate = DateMapper.toString((Date)preset.getDateForHistory());
                break;
            }
            case 9: {
                int i;
                AttributeStruct[] groupTotals;
                filterStruct.fixedAssetReportType.assetsAnalysisFilter(new AssetsAnalysisReportFilterStruct());
                filterStruct.fixedAssetReportType.assetsAnalysisFilter().fromProcessingDate = DateMapper.toString((Date)preset.getFromProcessingDate());
                filterStruct.fixedAssetReportType.assetsAnalysisFilter().toProcessingDate = DateMapper.toString((Date)preset.getToProcessingDate());
                filterStruct.fixedAssetReportType.assetsAnalysisFilter().assetNameType = preset.getAssetNameType();
                filterStruct.fixedAssetReportType.assetsAnalysisFilter().printGroupTotalOnly = preset.getPrintGroupTotalOnly();
                if (preset.getSort() != null && preset.getGroupTotal() != null) {
                    SortierungStruct gorupTotalStruct = SortMapper.toIdl((Sort)preset.getGroupTotal());
                    groupTotals = new AttributeStruct[gorupTotalStruct.sortierungElements.length];
                    for (i = 0; i < groupTotals.length; ++i) {
                        groupTotals[i] = new AttributeStruct();
                        groupTotals[i].attributeCode = gorupTotalStruct.sortierungElements[i].attributeName;
                        groupTotals[i].attributeName = FixedAssetReportFilterMapper.getFixedAssetFieldNames((String)groupTotals[i].attributeCode, (AccountingCompany)preset.getAccountingCompany());
                        groupTotals[i].attributeType = FixedAssetReportFilterMapper.getFixedAssetFieldType((String)groupTotals[i].attributeCode);
                        groupTotals[i].decimals = Short.MIN_VALUE;
                        groupTotals[i].type = "";
                        groupTotals[i].attributeValues = new String[0];
                    }
                    filterStruct.groupTotalSeq = groupTotals;
                } else {
                    filterStruct.groupTotalSeq = new AttributeStruct[0];
                }
                filterStruct.fixedAssetReportType.assetsAnalysisFilter().consolidation = false;
                filterStruct.fixedAssetReportType.assetsAnalysisFilter().consolidationCompanies = new CompanyShortStruct[0];
                filterStruct.fixedAssetReportType.assetsAnalysisFilter().formFeedType = preset.getFormFeedType();
                break;
            }
            case 10: {
                filterStruct.fixedAssetReportType.copyData(new CopyDataStruct());
                filterStruct.fixedAssetReportType.copyData().copyType = preset.getCopyType();
                filterStruct.fixedAssetReportType.copyData().assetData = preset.getCopyAssetData();
                filterStruct.fixedAssetReportType.copyData().oidToCompany = preset.getInAccountingCompany().getObjectid();
                filterStruct.fixedAssetReportType.copyData().withFullDisposals = preset.getWithFullDisposal();
                filterStruct.fixedAssetReportType.copyData().copyAreasSeq = QuickChangeAttributeMapper.copyDataToIdl(preset.getQuickChangeAttribute());
                filterStruct.groupTotalSeq = new AttributeStruct[0];
                filterStruct.fixedAssetReportType.copyData().copyLocations = preset.getPrintAssetNotes();
                filterStruct.fixedAssetReportType.copyData().copyProjects = preset.getPrintAnalysisCodes();
                filterStruct.fixedAssetReportType.copyData().copyPersons = preset.getPrintGroupTotalOnly();
                filterStruct.fixedAssetReportType.copyData().copyInsurances = preset.getPrintTransactions();
                filterStruct.fixedAssetReportType.copyData().historicTransactions = false;
                filterStruct.fixedAssetReportType.copyData().oidFAFinancialYear = "";
                filterStruct.fixedAssetReportType.copyData().status = StatusOfDepreciationEnum.SODE_ACTUAL;
                break;
            }
            case 11: {
                int i;
                AttributeStruct[] groupTotals;
                filterStruct.fixedAssetReportType.assetAddDispFilter(new AssetAdditionDisposalReportFilterStruct());
                filterStruct.fixedAssetReportType.assetAddDispFilter().fromProcessingDate = DateMapper.toString((Date)preset.getFromProcessingDate());
                filterStruct.fixedAssetReportType.assetAddDispFilter().toProcessingDate = DateMapper.toString((Date)preset.getToProcessingDate());
                filterStruct.fixedAssetReportType.assetAddDispFilter().assetNameType = preset.getAssetNameType();
                filterStruct.withHistory = preset.getPrintHistory();
                filterStruct.historyDate = DateMapper.toString((Date)preset.getDateForHistory());
                filterStruct.fixedAssetReportType.assetAddDispFilter().withSingleTransactions = true;
                filterStruct.fixedAssetReportType.assetAddDispFilter().printGroupTotalOnly = preset.getPrintGroupTotalOnly();
                filterStruct.fixedAssetReportType.assetAddDispFilter().isSelectDocDate = preset.getIsSelectDocDate();
                filterStruct.fixedAssetReportType.assetAddDispFilter().printFixedAssetData = preset.getPrintFixedAssetData();
                if (preset.getSort() != null && preset.getGroupTotal() != null) {
                    SortierungStruct gorupTotalStruct = SortMapper.toIdl((Sort)preset.getGroupTotal());
                    groupTotals = new AttributeStruct[gorupTotalStruct.sortierungElements.length];
                    for (i = 0; i < groupTotals.length; ++i) {
                        groupTotals[i] = new AttributeStruct();
                        groupTotals[i].attributeCode = gorupTotalStruct.sortierungElements[i].attributeName;
                        groupTotals[i].attributeName = FixedAssetReportFilterMapper.getFixedAssetFieldNames((String)groupTotals[i].attributeCode, (AccountingCompany)preset.getAccountingCompany());
                        groupTotals[i].attributeType = FixedAssetReportFilterMapper.getFixedAssetFieldType((String)groupTotals[i].attributeCode);
                        groupTotals[i].decimals = Short.MIN_VALUE;
                        groupTotals[i].type = "";
                        groupTotals[i].attributeValues = new String[0];
                    }
                    filterStruct.groupTotalSeq = groupTotals;
                    break;
                }
                filterStruct.groupTotalSeq = new AttributeStruct[0];
                break;
            }
            case 13: {
                int i;
                AttributeStruct[] groupTotals;
                filterStruct.fixedAssetReportType.quantityFilter(new QuantityReportFilterStruct());
                filterStruct.fixedAssetReportType.quantityFilter().fromProcessingDate = DateMapper.toString((Date)preset.getFromProcessingDate());
                filterStruct.fixedAssetReportType.quantityFilter().toProcessingDate = DateMapper.toString((Date)preset.getToProcessingDate());
                filterStruct.fixedAssetReportType.quantityFilter().assetNameType = preset.getAssetNameType();
                filterStruct.fixedAssetReportType.quantityFilter().printGroupTotalOnly = preset.getPrintGroupTotalOnly();
                filterStruct.fixedAssetReportType.quantityFilter().printFixedAssetData = preset.getPrintFixedAssetData();
                filterStruct.fixedAssetReportType.quantityFilter().quantityUnit = QuantityUnitMapper.toIdl((QuantityUnit)preset.getQuantityUnit());
                filterStruct.withHistory = preset.getPrintHistory();
                filterStruct.historyDate = DateMapper.toString((Date)preset.getDateForHistory());
                filterStruct.withAdditionalText = preset.getWithAdditionalTexts();
                if (preset.getSort() != null && preset.getGroupTotal() != null) {
                    SortierungStruct gorupTotalStruct = SortMapper.toIdl((Sort)preset.getGroupTotal());
                    groupTotals = new AttributeStruct[gorupTotalStruct.sortierungElements.length];
                    for (i = 0; i < groupTotals.length; ++i) {
                        groupTotals[i] = new AttributeStruct();
                        groupTotals[i].attributeCode = gorupTotalStruct.sortierungElements[i].attributeName;
                        groupTotals[i].attributeName = FixedAssetReportFilterMapper.getFixedAssetFieldNames((String)groupTotals[i].attributeCode, (AccountingCompany)preset.getAccountingCompany());
                        groupTotals[i].attributeType = FixedAssetReportFilterMapper.getFixedAssetFieldType((String)groupTotals[i].attributeCode);
                        groupTotals[i].decimals = Short.MIN_VALUE;
                        groupTotals[i].type = "";
                        groupTotals[i].attributeValues = new String[0];
                    }
                    filterStruct.groupTotalSeq = groupTotals;
                    break;
                }
                filterStruct.groupTotalSeq = new AttributeStruct[0];
                break;
            }
            case 14: {
                filterStruct.fixedAssetReportType.interchangeFilter(new InterchangeAssetStruct());
                filterStruct.fixedAssetReportType.interchangeFilter().fromRetirementDate = DateMapper.toString((Date)preset.getFromRetirementDate());
                filterStruct.fixedAssetReportType.interchangeFilter().toRetirementDate = DateMapper.toString((Date)preset.getToRetirementDate());
                filterStruct.fixedAssetReportType.interchangeFilter().interchangeDate = DateMapper.toString((Date)preset.getInterchangeDate());
                filterStruct.fixedAssetReportType.interchangeFilter().oidToCompany = preset.getInAccountingCompany().getObjectid();
                filterStruct.fixedAssetReportType.interchangeFilter().copyAreasForInterchangeSeq = QuickChangeAttributeMapper.copyDataToIdl(preset.getQuickChangeAttribute());
                filterStruct.groupTotalSeq = new AttributeStruct[0];
            }
        }
        ArrayList<FixedAssetShortStruct> shortStructList = new ArrayList<FixedAssetShortStruct>();
        for (int i = 0; i < filterStruct.filtersSeq.length; ++i) {
            FixedAsset fa;
            if (!filterStruct.filtersSeq[i].attributeCode.equals("FA.OBJECTID") || (fa = FixedAssetPersistencyManager.getFixedAsset((String)filterStruct.filtersSeq[i].stringValue)) == null) continue;
            shortStructList.add(FixedAssetMapper.toShortIdl((FixedAsset)fa, (boolean)false, (boolean)false));
        }
        filterStruct.fixedAssetShortSeq = shortStructList.toArray(new FixedAssetShortStruct[shortStructList.size()]);
        return filterStruct;
    }

    public static FixedAssetReportStruct[] toIdl(FixedAssetReportPreset[] c) throws BusinessDomainException {
        LOGGER.debug("FixedAssetReportPresetMapper.toIdl(FixedAssetReportPreset[]");
        if (c == null) {
            return new FixedAssetReportStruct[0];
        }
        FixedAssetReportStruct[] result = new FixedAssetReportStruct[c.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = FixedAssetReportPresetMapper.toIdl(c[i]);
        }
        return result;
    }

    private static ExtendedFilterStruct[] filterEelementSplitup(ExtendedFilterStruct[] filtersSeq) {
        ArrayList<ExtendedFilterStruct> newExtFilter = new ArrayList<ExtendedFilterStruct>(filtersSeq.length);
        for (int i = 0; i < filtersSeq.length; ++i) {
            if (filtersSeq[i].attributeCode.equals("FA.OIDPARENT") || filtersSeq[i].attributeCode.equals("FA.OIDASSETACCOUNT") || filtersSeq[i].attributeCode.equals("FA.OIDCOSTCENTRE") || filtersSeq[i].attributeCode.equals("FA.OIDCOSTUNIT") || filtersSeq[i].attributeCode.equals("FA.OIDSUPPLIERACCOUNT") || filtersSeq[i].attributeCode.equals("FA.OIDLOCATION") || filtersSeq[i].attributeCode.equals("FA.OIDPROJECT") || filtersSeq[i].attributeCode.equals("FAI.OIDINSURANCE") || filtersSeq[i].attributeCode.equals("FAA.OIDACCOUNTGROUP") || filtersSeq[i].attributeCode.equals("FAA.OIDDEPRECMETHOD") || filtersSeq[i].attributeCode.equals("FAA.OIDSPECDEPREMETHOD") || filtersSeq[i].attributeCode.equals("FA.OIDPERSON")) {
                StringTokenizer tokens = new StringTokenizer(filtersSeq[i].stringValue, ",");
                while (tokens.hasMoreTokens()) {
                    ExtendedFilterStruct newStruct = new ExtendedFilterStruct();
                    newStruct.attributeCode = filtersSeq[i].attributeCode;
                    switch (filtersSeq[i].operation.value()) {
                        case 9: {
                            newStruct.operation = AttributeOperationEnum.AOE_EQUAL;
                            break;
                        }
                        case 10: {
                            newStruct.operation = AttributeOperationEnum.AOE_NOTEQUAL;
                        }
                    }
                    newStruct.stringValue = tokens.nextToken();
                    newStruct.booleanValue = false;
                    newStruct.join = ExtendedFilterJoinEnum.EFJE_OR;
                    newExtFilter.add(newStruct);
                }
                continue;
            }
            newExtFilter.add(filtersSeq[i]);
        }
        if (!newExtFilter.isEmpty()) {
            ExtendedFilterStruct[] arr = new ExtendedFilterStruct[newExtFilter.size()];
            return newExtFilter.toArray(arr);
        }
        return new ExtendedFilterStruct[0];
    }

    private static ExtendedFilterStruct[] filterElementJoin(ExtendedFilterStruct[] filtersSeq) {
        ArrayList<ExtendedFilterStruct> newExtFilter = new ArrayList<ExtendedFilterStruct>();
        ExtendedFilterStruct filterOidParent = null;
        ExtendedFilterStruct filterOidAssetacc = null;
        ExtendedFilterStruct filterOidCostCentre = null;
        ExtendedFilterStruct filterOidCostUnit = null;
        ExtendedFilterStruct filterOidSupplAcc = null;
        ExtendedFilterStruct filterOidLocation = null;
        ExtendedFilterStruct filterOidProject = null;
        ExtendedFilterStruct filterOidInsurance = null;
        ExtendedFilterStruct filterOidAccGroup = null;
        ExtendedFilterStruct filterOidDeprMethod = null;
        ExtendedFilterStruct filterOidSpecDeprMethod = null;
        ExtendedFilterStruct filterOidPerson = null;
        for (int i = 0; i < filtersSeq.length; ++i) {
            if (filtersSeq[i].operation.value() != 9 && filtersSeq[i].operation.value() != 10) {
                if (filtersSeq[i].attributeCode.equals("FA.OIDPARENT")) {
                    if (filterOidParent == null) {
                        filterOidParent = new ExtendedFilterStruct();
                        filterOidParent.attributeCode = filtersSeq[i].attributeCode;
                        switch (filtersSeq[i].operation.value()) {
                            case 4: {
                                filterOidParent.operation = AttributeOperationEnum.AOE_IN;
                                break;
                            }
                            case 5: {
                                filterOidParent.operation = AttributeOperationEnum.AOE_NOTIN;
                            }
                        }
                        filterOidParent.stringValue = filtersSeq[i].stringValue;
                        filterOidParent.booleanValue = true;
                        filterOidParent.join = ExtendedFilterJoinEnum.EFJE_AND;
                        continue;
                    }
                    filterOidParent.stringValue = filterOidParent.stringValue + "," + filtersSeq[i].stringValue;
                    continue;
                }
                if (filtersSeq[i].attributeCode.equals("FA.OIDASSETACCOUNT")) {
                    if (filterOidAssetacc == null) {
                        filterOidAssetacc = new ExtendedFilterStruct();
                        filterOidAssetacc.attributeCode = filtersSeq[i].attributeCode;
                        switch (filtersSeq[i].operation.value()) {
                            case 4: {
                                filterOidAssetacc.operation = AttributeOperationEnum.AOE_IN;
                                break;
                            }
                            case 5: {
                                filterOidAssetacc.operation = AttributeOperationEnum.AOE_NOTIN;
                            }
                        }
                        filterOidAssetacc.stringValue = filtersSeq[i].stringValue;
                        filterOidAssetacc.booleanValue = true;
                        filterOidAssetacc.join = ExtendedFilterJoinEnum.EFJE_AND;
                        continue;
                    }
                    filterOidAssetacc.stringValue = filterOidAssetacc.stringValue + "," + filtersSeq[i].stringValue;
                    continue;
                }
                if (filtersSeq[i].attributeCode.equals("FA.OIDCOSTCENTRE")) {
                    if (filterOidCostCentre == null) {
                        filterOidCostCentre = new ExtendedFilterStruct();
                        filterOidCostCentre.attributeCode = filtersSeq[i].attributeCode;
                        switch (filtersSeq[i].operation.value()) {
                            case 4: {
                                filterOidCostCentre.operation = AttributeOperationEnum.AOE_IN;
                                break;
                            }
                            case 5: {
                                filterOidCostCentre.operation = AttributeOperationEnum.AOE_NOTIN;
                            }
                        }
                        filterOidCostCentre.stringValue = filtersSeq[i].stringValue;
                        filterOidCostCentre.booleanValue = true;
                        filterOidCostCentre.join = ExtendedFilterJoinEnum.EFJE_AND;
                        continue;
                    }
                    filterOidCostCentre.stringValue = filterOidCostCentre.stringValue + "," + filtersSeq[i].stringValue;
                    continue;
                }
                if (filtersSeq[i].attributeCode.equals("FA.OIDCOSTUNIT")) {
                    if (filterOidCostUnit == null) {
                        filterOidCostUnit = new ExtendedFilterStruct();
                        filterOidCostUnit.attributeCode = filtersSeq[i].attributeCode;
                        switch (filtersSeq[i].operation.value()) {
                            case 4: {
                                filterOidCostUnit.operation = AttributeOperationEnum.AOE_IN;
                                break;
                            }
                            case 5: {
                                filterOidCostUnit.operation = AttributeOperationEnum.AOE_NOTIN;
                            }
                        }
                        filterOidCostUnit.stringValue = filtersSeq[i].stringValue;
                        filterOidCostUnit.booleanValue = true;
                        filterOidCostUnit.join = ExtendedFilterJoinEnum.EFJE_AND;
                        continue;
                    }
                    filterOidCostUnit.stringValue = filterOidCostUnit.stringValue + "," + filtersSeq[i].stringValue;
                    continue;
                }
                if (filtersSeq[i].attributeCode.equals("FA.OIDSUPPLIERACCOUNT")) {
                    if (filterOidSupplAcc == null) {
                        filterOidSupplAcc = new ExtendedFilterStruct();
                        filterOidSupplAcc.attributeCode = filtersSeq[i].attributeCode;
                        switch (filtersSeq[i].operation.value()) {
                            case 4: {
                                filterOidSupplAcc.operation = AttributeOperationEnum.AOE_IN;
                                break;
                            }
                            case 5: {
                                filterOidSupplAcc.operation = AttributeOperationEnum.AOE_NOTIN;
                            }
                        }
                        filterOidSupplAcc.stringValue = filtersSeq[i].stringValue;
                        filterOidSupplAcc.booleanValue = true;
                        filterOidSupplAcc.join = ExtendedFilterJoinEnum.EFJE_AND;
                        continue;
                    }
                    filterOidSupplAcc.stringValue = filterOidSupplAcc.stringValue + "," + filtersSeq[i].stringValue;
                    continue;
                }
                if (filtersSeq[i].attributeCode.equals("FA.OIDLOCATION")) {
                    if (filterOidLocation == null) {
                        filterOidLocation = new ExtendedFilterStruct();
                        filterOidLocation.attributeCode = filtersSeq[i].attributeCode;
                        switch (filtersSeq[i].operation.value()) {
                            case 4: {
                                filterOidLocation.operation = AttributeOperationEnum.AOE_IN;
                                break;
                            }
                            case 5: {
                                filterOidLocation.operation = AttributeOperationEnum.AOE_NOTIN;
                            }
                        }
                        filterOidLocation.stringValue = filtersSeq[i].stringValue;
                        filterOidLocation.booleanValue = true;
                        filterOidLocation.join = ExtendedFilterJoinEnum.EFJE_AND;
                        continue;
                    }
                    filterOidLocation.stringValue = filterOidLocation.stringValue + "," + filtersSeq[i].stringValue;
                    continue;
                }
                if (filtersSeq[i].attributeCode.equals("FA.OIDPROJECT")) {
                    if (filterOidProject == null) {
                        filterOidProject = new ExtendedFilterStruct();
                        filterOidProject.attributeCode = filtersSeq[i].attributeCode;
                        switch (filtersSeq[i].operation.value()) {
                            case 4: {
                                filterOidProject.operation = AttributeOperationEnum.AOE_IN;
                                break;
                            }
                            case 5: {
                                filterOidProject.operation = AttributeOperationEnum.AOE_NOTIN;
                            }
                        }
                        filterOidProject.stringValue = filtersSeq[i].stringValue;
                        filterOidProject.booleanValue = true;
                        filterOidProject.join = ExtendedFilterJoinEnum.EFJE_AND;
                        continue;
                    }
                    filterOidProject.stringValue = filterOidProject.stringValue + "," + filtersSeq[i].stringValue;
                    continue;
                }
                if (filtersSeq[i].attributeCode.equals("FAI.OIDINSURANCE")) {
                    if (filterOidInsurance == null) {
                        filterOidInsurance = new ExtendedFilterStruct();
                        filterOidInsurance.attributeCode = filtersSeq[i].attributeCode;
                        switch (filtersSeq[i].operation.value()) {
                            case 4: {
                                filterOidInsurance.operation = AttributeOperationEnum.AOE_IN;
                                break;
                            }
                            case 5: {
                                filterOidInsurance.operation = AttributeOperationEnum.AOE_NOTIN;
                            }
                        }
                        filterOidInsurance.stringValue = filtersSeq[i].stringValue;
                        filterOidInsurance.booleanValue = true;
                        filterOidInsurance.join = ExtendedFilterJoinEnum.EFJE_AND;
                        continue;
                    }
                    filterOidInsurance.stringValue = filterOidInsurance.stringValue + "," + filtersSeq[i].stringValue;
                    continue;
                }
                if (filtersSeq[i].attributeCode.equals("FAA.OIDACCOUNTGROUP")) {
                    if (filterOidAccGroup == null) {
                        filterOidAccGroup = new ExtendedFilterStruct();
                        filterOidAccGroup.attributeCode = filtersSeq[i].attributeCode;
                        switch (filtersSeq[i].operation.value()) {
                            case 4: {
                                filterOidAccGroup.operation = AttributeOperationEnum.AOE_IN;
                                break;
                            }
                            case 5: {
                                filterOidAccGroup.operation = AttributeOperationEnum.AOE_NOTIN;
                            }
                        }
                        filterOidAccGroup.stringValue = filtersSeq[i].stringValue;
                        filterOidAccGroup.booleanValue = true;
                        filterOidAccGroup.join = ExtendedFilterJoinEnum.EFJE_AND;
                        continue;
                    }
                    filterOidAccGroup.stringValue = filterOidAccGroup.stringValue + "," + filtersSeq[i].stringValue;
                    continue;
                }
                if (filtersSeq[i].attributeCode.equals("FAA.OIDDEPRECMETHOD")) {
                    if (filterOidDeprMethod == null) {
                        filterOidDeprMethod = new ExtendedFilterStruct();
                        filterOidDeprMethod.attributeCode = filtersSeq[i].attributeCode;
                        switch (filtersSeq[i].operation.value()) {
                            case 4: {
                                filterOidDeprMethod.operation = AttributeOperationEnum.AOE_IN;
                                break;
                            }
                            case 5: {
                                filterOidDeprMethod.operation = AttributeOperationEnum.AOE_NOTIN;
                            }
                        }
                        filterOidDeprMethod.stringValue = filtersSeq[i].stringValue;
                        filterOidDeprMethod.booleanValue = true;
                        filterOidDeprMethod.join = ExtendedFilterJoinEnum.EFJE_AND;
                        continue;
                    }
                    filterOidDeprMethod.stringValue = filterOidDeprMethod.stringValue + "," + filtersSeq[i].stringValue;
                    continue;
                }
                if (filtersSeq[i].attributeCode.equals("FAA.OIDSPECDEPREMETHOD")) {
                    if (filterOidSpecDeprMethod == null) {
                        filterOidSpecDeprMethod = new ExtendedFilterStruct();
                        filterOidSpecDeprMethod.attributeCode = filtersSeq[i].attributeCode;
                        switch (filtersSeq[i].operation.value()) {
                            case 4: {
                                filterOidSpecDeprMethod.operation = AttributeOperationEnum.AOE_IN;
                                break;
                            }
                            case 5: {
                                filterOidSpecDeprMethod.operation = AttributeOperationEnum.AOE_NOTIN;
                            }
                        }
                        filterOidSpecDeprMethod.stringValue = filtersSeq[i].stringValue;
                        filterOidSpecDeprMethod.booleanValue = true;
                        filterOidSpecDeprMethod.join = ExtendedFilterJoinEnum.EFJE_AND;
                        continue;
                    }
                    filterOidSpecDeprMethod.stringValue = filterOidSpecDeprMethod.stringValue + "," + filtersSeq[i].stringValue;
                    continue;
                }
                if (filtersSeq[i].attributeCode.equals("FA.OIDPERSON")) {
                    if (filterOidPerson == null) {
                        filterOidPerson = new ExtendedFilterStruct();
                        filterOidPerson.attributeCode = filtersSeq[i].attributeCode;
                        switch (filtersSeq[i].operation.value()) {
                            case 4: {
                                filterOidPerson.operation = AttributeOperationEnum.AOE_IN;
                                break;
                            }
                            case 5: {
                                filterOidPerson.operation = AttributeOperationEnum.AOE_NOTIN;
                            }
                        }
                        filterOidPerson.stringValue = filtersSeq[i].stringValue;
                        filterOidPerson.booleanValue = true;
                        filterOidPerson.join = ExtendedFilterJoinEnum.EFJE_AND;
                        continue;
                    }
                    filterOidPerson.stringValue = filterOidPerson.stringValue + "," + filtersSeq[i].stringValue;
                    continue;
                }
                newExtFilter.add(filtersSeq[i]);
                continue;
            }
            newExtFilter.add(filtersSeq[i]);
        }
        if (filterOidParent != null) {
            newExtFilter.add(filterOidParent);
        }
        if (filterOidAssetacc != null) {
            newExtFilter.add(filterOidAssetacc);
        }
        if (filterOidCostCentre != null) {
            newExtFilter.add(filterOidCostCentre);
        }
        if (filterOidCostUnit != null) {
            newExtFilter.add(filterOidCostUnit);
        }
        if (filterOidSupplAcc != null) {
            newExtFilter.add(filterOidSupplAcc);
        }
        if (filterOidLocation != null) {
            newExtFilter.add(filterOidLocation);
        }
        if (filterOidProject != null) {
            newExtFilter.add(filterOidProject);
        }
        if (filterOidInsurance != null) {
            newExtFilter.add(filterOidInsurance);
        }
        if (filterOidAccGroup != null) {
            newExtFilter.add(filterOidAccGroup);
        }
        if (filterOidDeprMethod != null) {
            newExtFilter.add(filterOidDeprMethod);
        }
        if (filterOidSpecDeprMethod != null) {
            newExtFilter.add(filterOidSpecDeprMethod);
        }
        if (filterOidPerson != null) {
            newExtFilter.add(filterOidPerson);
        }
        if (!newExtFilter.isEmpty()) {
            ExtendedFilterStruct[] arr = new ExtendedFilterStruct[newExtFilter.size()];
            return newExtFilter.toArray(arr);
        }
        return new ExtendedFilterStruct[0];
    }

    private static ExtendedFilterStruct[] addFilterElement(ExtendedFilterStruct[] filterStruct, FixedAssetShortStruct[] faShortStruct) {
        ExtendedFilterStruct[] newFilterStruct = new ExtendedFilterStruct[filterStruct.length + faShortStruct.length];
        System.arraycopy(filterStruct, 0, newFilterStruct, 0, filterStruct.length);
        for (int i = 0; i < faShortStruct.length; ++i) {
            ExtendedFilterStruct extFilter = new ExtendedFilterStruct();
            extFilter.attributeCode = "FA.OBJECTID";
            extFilter.operation = AttributeOperationEnum.AOE_EQUAL;
            extFilter.stringValue = faShortStruct[i].oidTs.objectid;
            extFilter.booleanValue = true;
            extFilter.join = ExtendedFilterJoinEnum.EFJE_OR;
            newFilterStruct[i + filterStruct.length] = extFilter;
        }
        return newFilterStruct;
    }

    public static void fillPostingsSummaryPreset(FixedAssetReportStruct presetStruct, FixedAssetReportPreset preset) throws BusinessDomainException {
        LOGGER.debug("IDL - PresetStruct:");
        LOGGER.debug("PresetStruct- ost.objectid: = " + presetStruct.oidTs.objectid);
        LOGGER.debug("PresetStruct- ost.lastuserid: = " + presetStruct.oidTs.lastuserid);
        LOGGER.debug("PresetStruct- ost.version: = " + presetStruct.oidTs.version);
        LOGGER.debug("PresetStruct- name: = " + presetStruct.name);
        LOGGER.debug("PresetStruct- note: = " + presetStruct.note);
        LOGGER.debug("PresetStruct- createor: = " + presetStruct.creator);
        LOGGER.debug("PresetStruct- reporttype: = " + presetStruct.reportType.value());
        LOGGER.debug("PresetStruct- oidcompany: = " + presetStruct.filter.oidCompany);
        LOGGER.debug("PresetStruct- currency: = " + presetStruct.filter.currency.code);
        LOGGER.debug("PresetStruct- Gesch\u00e4ftsjahr: = " + presetStruct.filter.financialYear.yearShort().code);
        LOGGER.debug("PresetStruct- language: = " + presetStruct.filter.languageForLanguageDependentTexts.code);
        for (int i = 0; i < presetStruct.filter.areaShortSeq.length; ++i) {
            LOGGER.debug("PresetStruct- area: = " + presetStruct.filter.areaShortSeq[i].oidTs.objectid);
        }
        preset.setName(presetStruct.name);
        preset.setNote(presetStruct.note);
        preset.setPrintProtocol(presetStruct.printProtocol);
        AccountingCompany company = AccountingCompanyPersistencyManager.getAccountingCompany((String)presetStruct.filter.oidCompany);
        preset.setLanguage(company.getDefaultLanguage());
        preset.setFixedAssetReportType(FixedAssetReportEnum.FARE_POSTINGSSUMMARY);
        AssetaccountingSetup aaSetUp = AssetaccountingSetup.getValidAssetaccountingSetup((AccountingCompany)company);
        preset.setCurrency(aaSetUp.getBaseCurrency());
        DepreciationArea[] deprAreas = new DepreciationArea[presetStruct.filter.areaShortSeq.length];
        for (int i = 0; i < presetStruct.filter.areaShortSeq.length; ++i) {
            deprAreas[i] = DepreciationAreaPersistencyManager.getDepreciationArea((String)presetStruct.filter.areaShortSeq[i].oidTs.objectid);
        }
        preset.setAssetAreas(deprAreas);
        FAFinancialYear faFinYear = null;
        faFinYear = FAFinancialYearPersistencyManager.getFAFinancialYear((String)presetStruct.filter.financialYear.yearShort().oidTs.objectid);
        preset.setFinancialYear(faFinYear);
        preset.setMainSubCompactedType(MainSubCompactedEnum.MSCE_NO);
        preset.setFromProcessingDate(null);
        preset.setToProcessingDate(null);
        preset.setAssetNameType(AssetNameEnum.ANE_SHORTNAME);
        preset.setWithSingleTransactions(false);
        preset.setPrintHistory(false);
        preset.setDateForHistory(null);
    }

    public static FixedAssetReportStruct toIdl(FixedAssetReportPreset preset) throws BusinessDomainException {
        FixedAssetReportStruct presetStruct = new FixedAssetReportStruct();
        presetStruct.oidTs = ObjectMapper.toIdl((IdentifiableBusinessObject)preset);
        presetStruct.name = StringMapper.toString((String)preset.getName());
        presetStruct.creator = preset.getCreator();
        presetStruct.note = preset.getNote();
        presetStruct.reportType = preset.getFixedAssetReportType();
        presetStruct.printProtocol = preset.getPrintProtocol();
        presetStruct.filter = FixedAssetReportPresetMapper.toFilterIdl(preset);
        return presetStruct;
    }
}

