/*
 * Decompiled with CFR 0.152.
 */
package com.varial.assetaccounting.domain.fixedassetreport;

import com.varial.accounting.domain.personalaccount.PersonalAccount;
import com.varial.accounting.domain.personalaccount.PersonalAccountPersistencyManager;
import com.varial.assetaccounting.calculationmethod.DepreciationTypeEnum;
import com.varial.assetaccounting.domain.calculationmethod.CalcMethodPersistencyManager;
import com.varial.assetaccounting.domain.calculationmethod.DepreciationMethodData;
import com.varial.assetaccounting.domain.depreciationarea.DepreciationArea;
import com.varial.assetaccounting.domain.depreciationarea.DepreciationAreaPersistencyManager;
import com.varial.assetaccounting.domain.fixedasset.FixedAsset;
import com.varial.assetaccounting.domain.fixedasset.FixedAssetArea;
import com.varial.assetaccounting.domain.fixedasset.FixedAssetData;
import com.varial.assetaccounting.domain.fixedasset.FixedAssetTransaction;
import com.varial.assetaccounting.domain.fixedasset.FixedAssetTransactionPersistencyManager;
import com.varial.assetaccounting.domain.fixedassetreport.AssetRegisterReportPLDataSource;
import com.varial.assetaccounting.fixedasset.TransactionEnum;
import com.varial.assetaccounting.fixedassetreport.PrintTypePLEnum;
import com.varial.base.UtilitiesManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.framework.domain.quantityunit.QuantityUnit;
import com.varial.framework.domain.quantityunit.QuantityUnitPersistencyManager;
import com.varial.serverbase.domain.language.ILanguage;
import com.varial.serverbase.domain.language.Language;
import com.varial.serverbase.domain.locale.ILocalePersistencyManager;
import com.varial.serverbase.mapper.BigDecimalFormatter;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.StringMapper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;

public class AssetRegisterReportPLContainer {
    private static final ILocalePersistencyManager localePersistencyManager = (ILocalePersistencyManager)UtilitiesManager.getBean((String)"localePersistencyManager", ILocalePersistencyManager.class);
    public AssetRegisterReportPLDataSource mDataSource;
    public String mCode;
    public String mShortName;
    public String mNameOfAsset;
    public String mAssetGroup;
    public Date mAcquisitionDate;
    public Date mCommissioningDate;
    public Date mDisposalDate;
    public BigDecimal mDisposalValue;
    public Date mDocumentDate;
    public String mLocation;
    public String mDocumentNumber;
    public String mDocumentName;
    public String mQuantity;
    public QuantityUnit mQuantityUnit;
    public String mAssetAccount;
    public String mSupplier;
    public String mCostCentre;
    public String mDepreciationAreaBal;
    public BigDecimal mAcquisitionValueBal = BigDecimal.ZERO;
    public Date mDateDeprStartBal;
    public String mDeprMethodBal;
    public BigDecimal mDeprPercentBal;
    public BigDecimal mDeprFactorBal;
    public String mDepreciationAreaTax;
    public BigDecimal mAcquisitionValueTax = BigDecimal.ZERO;
    public Date mDateDeprStartTax;
    public String mDeprMethodTax;
    public BigDecimal mDeprPercentTax;
    public BigDecimal mDeprFactorTax;
    public String mPostingText;
    public String mPostingTextDisposal;
    public String mAssetAccount1;
    public String mAssetAccount2;
    public String mAssetAccount3;
    public BigDecimal mDebitValue1;
    public BigDecimal mDebitValue2;
    public BigDecimal mDebitValue3;
    public BigDecimal mCreditValue1;
    public BigDecimal mCreditValue2;
    public BigDecimal mCreditValue3;
    public BigDecimal mDebitSum;
    public BigDecimal mCreditSum;
    public String mType;
    public FixedAssetData mFixedAsset;
    public Language mGlobalLanguage;
    public Language mLanguageForLanguageDependentTexts;
    public BigDecimal mQuantityBD;

    public AssetRegisterReportPLContainer(FixedAssetData fixedAsset, FixedAssetTransaction faTrans, Language languageForLanguageDependentTexts, Language globalLanguage, String[] oidDeprArea, AssetRegisterReportPLDataSource dataSource, DepreciationArea deprAreaBelToBalSheet, PrintTypePLEnum printTypePL) throws BusinessDomainException {
        this.mDisposalValue = BigDecimal.ZERO;
        this.mDataSource = dataSource;
        this.mFixedAsset = fixedAsset;
        this.mGlobalLanguage = globalLanguage;
        this.mLanguageForLanguageDependentTexts = languageForLanguageDependentTexts;
        this.mCode = fixedAsset.getCode();
        this.mShortName = fixedAsset.getShortNames().getLocalizedString((ILanguage)languageForLanguageDependentTexts).getText();
        this.mNameOfAsset = fixedAsset.getAssetName();
        this.mAssetGroup = fixedAsset.getParent().getCode() + " " + fixedAsset.getParent().getShortNames().getLocalizedString((ILanguage)languageForLanguageDependentTexts).getText();
        if (printTypePL == PrintTypePLEnum.PTPE_ADDITIONS) {
            this.mDocumentName = "OT/" + fixedAsset.getCode() + "/" + faTrans.getReferenceNumber();
            this.mType = "OT";
        } else {
            this.mDocumentName = "LT/" + fixedAsset.getCode() + "/" + faTrans.getReferenceNumber();
            this.mType = "LT";
        }
        this.mLocation = fixedAsset.getLocation() != null ? fixedAsset.getLocation().getCode() + " " + fixedAsset.getLocation().getNames().getString((ILanguage)languageForLanguageDependentTexts) : "";
        this.setQuantity(faTrans.getQuantity());
        this.mAssetAccount = fixedAsset.getAssetAccount() != null ? fixedAsset.getAssetAccount().getCode() + "  " + fixedAsset.getAssetAccount().getLocalizedStringContainer().getString((ILanguage)languageForLanguageDependentTexts) : "";
        this.mSupplier = "";
        if (faTrans != null && (faTrans.getTransactionEnum() == TransactionEnum.TRE_NEW_ADDITION || faTrans.getTransactionEnum() == TransactionEnum.TRE_PARTIAL_ADDITION || faTrans.getTransactionEnum() == TransactionEnum.TRE_CREDIT_NOTE || faTrans.getTransactionEnum() == TransactionEnum.TRE_REPOST_ADDITION || faTrans.getTransactionEnum() == TransactionEnum.TRE_POST_CAPITALIZATION)) {
            PersonalAccount pa;
            this.mAcquisitionDate = fixedAsset.getAcquisitionDate();
            this.mCommissioningDate = fixedAsset.getCommissioningDate();
            this.mDocumentDate = faTrans.getDocumentDate();
            this.mDocumentNumber = faTrans.getReferenceNumber();
            this.mPostingText = faTrans.getPostingText();
            this.mAcquisitionValueBal = faTrans.getAmount();
            if (faTrans.getPersonalAccount() != null && (pa = PersonalAccountPersistencyManager.getPersonalAccount((String)faTrans.getPersonalAccount().getObjectid())) != null) {
                this.mSupplier = pa.getCode() + "  " + pa.getShortAddress();
            }
        }
        if (faTrans != null && (faTrans.getTransactionEnum() == TransactionEnum.TRE_FULL_DISPOSAL || faTrans.getTransactionEnum() == TransactionEnum.TRE_PARTIAL_DISPOSAL)) {
            this.mDisposalDate = faTrans.getProcessingDate();
            this.mPostingTextDisposal = faTrans.getPostingText();
            this.mDisposalValue = faTrans.getSalesAmount();
        }
        this.mCostCentre = fixedAsset.getCostCenters().length > 0 ? fixedAsset.getCostCenters()[0].getCostCentreBase().getCurrentIdentifier().getCode() + "  " + fixedAsset.getCostCenters()[0].getCostCentreBase().getCurrentIdentifier().getShortname() : "";
        FixedAssetArea faAreaBal = FixedAssetArea.getFixedAssetArea((FixedAsset)fixedAsset, (DepreciationArea)deprAreaBelToBalSheet);
        this.mDepreciationAreaBal = deprAreaBelToBalSheet.getCode();
        this.mDateDeprStartBal = faAreaBal.getDeprStartDate();
        if (!StringMapper.isNullString((String)faAreaBal.getOidDepreciationMethod())) {
            this.mDeprMethodBal = CalcMethodPersistencyManager.getCalcMethod((String)faAreaBal.getOidDepreciationMethod()).getName(languageForLanguageDependentTexts);
        }
        this.mDeprPercentBal = faAreaBal.getDepreciationPercent();
        DepreciationMethodData deprMethod = (DepreciationMethodData)CalcMethodPersistencyManager.getCalcMethod((String)faAreaBal.getOidDepreciationMethod());
        this.mDeprFactorBal = BigDecimal.ZERO;
        if (deprMethod != null && deprMethod.getDepreciationType() == DepreciationTypeEnum.DTE_DECLINING_SINGLE_COEFFICIENT) {
            this.mDeprFactorBal = deprMethod.getPercentage();
            if (!BigDecimalMapper.isZeroOrNull((BigDecimal)deprMethod.getPercentage()) && !BigDecimalMapper.isZeroOrNull((BigDecimal)this.mDeprPercentBal)) {
                this.mDeprPercentBal = this.mDeprPercentBal.divide(new BigDecimal("2.00"), 2, RoundingMode.HALF_EVEN);
            }
        }
        this.mDepreciationAreaTax = "";
        this.mDateDeprStartTax = null;
        this.mDeprMethodTax = "";
        this.mDeprPercentTax = BigDecimal.ZERO;
        this.mDeprFactorTax = BigDecimal.ZERO;
        for (int i = 0; i < oidDeprArea.length; ++i) {
            FixedAssetTransaction faTransTax;
            DepreciationArea deprArea = DepreciationAreaPersistencyManager.getDepreciationArea((String)oidDeprArea[i]);
            if (deprArea.getBelongsToBalanceSheet() || deprArea.getCalculative()) continue;
            FixedAssetArea faAreaTax = FixedAssetArea.getFixedAssetArea((FixedAsset)fixedAsset, (DepreciationArea)deprArea);
            this.mDepreciationAreaTax = deprArea.getCode();
            this.mDateDeprStartTax = faAreaTax.getDeprStartDate();
            if (!StringMapper.isNullString((String)faAreaTax.getOidDepreciationMethod())) {
                this.mDeprMethodTax = CalcMethodPersistencyManager.getCalcMethod((String)faAreaTax.getOidDepreciationMethod()).getName(languageForLanguageDependentTexts);
            }
            this.mDeprPercentTax = faAreaTax.getDepreciationPercent();
            DepreciationMethodData deprMethodTax = (DepreciationMethodData)CalcMethodPersistencyManager.getCalcMethod((String)faAreaTax.getOidDepreciationMethod());
            this.mDeprFactorTax = BigDecimal.ZERO;
            if (deprMethodTax != null && deprMethodTax.getDepreciationType() == DepreciationTypeEnum.DTE_DECLINING_SINGLE_COEFFICIENT) {
                this.mDeprFactorTax = deprMethodTax.getPercentage();
                if (!BigDecimalMapper.isZeroOrNull((BigDecimal)deprMethodTax.getPercentage()) && !BigDecimalMapper.isZeroOrNull((BigDecimal)this.mDeprPercentTax)) {
                    this.mDeprPercentTax = this.mDeprPercentTax.divide(new BigDecimal("2.00"), 2, RoundingMode.HALF_EVEN);
                }
            }
            if ((faTransTax = FixedAssetTransactionPersistencyManager.getSameTransactionFromOtherArea((FixedAssetData)fixedAsset, (String)deprArea.getObjectid(), (String)faTrans.getReferenceNumber(), (String)faTrans.getBarcodeNumber())) == null) continue;
            this.mAcquisitionValueTax = faTransTax.getAmount();
        }
        this.mAssetAccount1 = "";
        this.mAssetAccount2 = "";
        this.mAssetAccount3 = "";
        this.mDebitValue1 = BigDecimal.ZERO;
        this.mDebitValue2 = BigDecimal.ZERO;
        this.mDebitValue3 = BigDecimal.ZERO;
        this.mCreditValue1 = BigDecimal.ZERO;
        this.mCreditValue2 = BigDecimal.ZERO;
        this.mCreditValue3 = BigDecimal.ZERO;
        this.mDebitSum = BigDecimal.ZERO;
        this.mCreditSum = BigDecimal.ZERO;
        if (printTypePL == PrintTypePLEnum.PTPE_ADDITIONS) {
            if (fixedAsset.getAssetAccount() != null) {
                this.mAssetAccount1 = fixedAsset.getAssetAccount().getCode() + "  " + fixedAsset.getAssetAccount().getLocalizedStringContainer().getString((ILanguage)languageForLanguageDependentTexts);
                this.mDebitValue1 = this.mAcquisitionValueBal;
            }
            if (fixedAsset.getNewAddOffsetAccount() != null) {
                this.mAssetAccount2 = fixedAsset.getNewAddOffsetAccount().getCode() + "  " + fixedAsset.getAssetAccount().getLocalizedStringContainer().getString((ILanguage)languageForLanguageDependentTexts);
                this.mCreditValue2 = this.mAcquisitionValueBal;
            }
            this.mDebitSum = this.mDebitValue1;
            this.mCreditSum = this.mCreditValue2;
        }
        if (printTypePL == PrintTypePLEnum.PTPE_DISPOSALS) {
            if (fixedAsset.getAssetAccount() != null) {
                this.mAssetAccount1 = fixedAsset.getAssetAccount().getCode() + "  " + fixedAsset.getAssetAccount().getLocalizedStringContainer().getString((ILanguage)languageForLanguageDependentTexts);
                this.mCreditValue1 = faTrans.getAmount().negate();
            }
            if (faAreaBal.getAccountGroup() != null && faAreaBal.getAccountGroup().getAccDepreciation() != null) {
                this.mAssetAccount2 = faAreaBal.getAccountGroup().getAccDepreciation().getCode() + "  " + faAreaBal.getAccountGroup().getAccDepreciation().getLocalizedStringContainer().getString((ILanguage)languageForLanguageDependentTexts);
                this.mDebitValue2 = faTrans.getAccumDepr();
            } else if (deprAreaBelToBalSheet.getAccDepreciation() != null) {
                this.mAssetAccount2 = deprAreaBelToBalSheet.getAccDepreciation().getCode() + "  " + deprAreaBelToBalSheet.getAccDepreciation().getLocalizedStringContainer().getString((ILanguage)languageForLanguageDependentTexts);
                this.mDebitValue2 = faTrans.getAccumDepr();
            }
            if (faAreaBal.getAccountGroup() != null && faAreaBal.getAccountGroup().getAccExpRetirement() != null) {
                this.mAssetAccount3 = faAreaBal.getAccountGroup().getAccExpRetirement().getCode() + "  " + faAreaBal.getAccountGroup().getAccExpRetirement().getLocalizedStringContainer().getString((ILanguage)languageForLanguageDependentTexts);
                BigDecimal disposalAmount = faTrans.getAmount().negate();
                this.mDebitValue3 = disposalAmount.subtract(faTrans.getAccumDepr());
            } else if (deprAreaBelToBalSheet.getAccExpRetirement() != null) {
                this.mAssetAccount3 = deprAreaBelToBalSheet.getAccExpRetirement().getCode() + "  " + deprAreaBelToBalSheet.getAccExpRetirement().getLocalizedStringContainer().getString((ILanguage)languageForLanguageDependentTexts);
                BigDecimal disposalAmount = faTrans.getAmount().negate();
                this.mDebitValue3 = disposalAmount.subtract(faTrans.getAccumDepr());
            }
        }
    }

    public BigDecimal getDisposalValue() {
        return this.mDisposalValue;
    }

    public void setDisposalValue(BigDecimal disposalValue) {
        this.mDisposalValue = disposalValue;
    }

    public String getQuantity() {
        return this.mQuantity;
    }

    public void setQuantity(String quantity) {
        if (!StringMapper.isNullString((String)this.mFixedAsset.getQuantity()) && !StringMapper.isNullString((String)this.mFixedAsset.getOidQuantityUnit())) {
            this.mQuantityUnit = QuantityUnitPersistencyManager.getQuantityUnit((String)this.mFixedAsset.getOidQuantityUnit());
            BigDecimalFormatter big = new BigDecimalFormatter(localePersistencyManager.getLocale(this.mGlobalLanguage));
            this.mQuantity = big.toString(BigDecimalMapper.toBigDecimal((String)quantity), (int)this.mQuantityUnit.getDecimalPlaces()) + " " + this.mQuantityUnit.getNames().getLocalizedString((ILanguage)this.mLanguageForLanguageDependentTexts).getText();
            this.setQuantityBD(BigDecimalMapper.toBigDecimal((String)quantity));
        } else {
            this.mQuantity = "";
            this.setQuantityBD(BigDecimal.ZERO);
        }
    }

    public BigDecimal getQuantityBD() {
        return this.mQuantityBD;
    }

    public void setQuantityBD(BigDecimal quantityBD) {
        this.mQuantityBD = quantityBD;
    }

    public BigDecimal getDebitValue1() {
        return this.mDebitValue1;
    }

    public void setDebitValue1(BigDecimal debitValue1) {
        this.mDebitValue1 = debitValue1;
    }

    public BigDecimal getDebitValue2() {
        return this.mDebitValue2;
    }

    public void setDebitValue2(BigDecimal debitValue2) {
        this.mDebitValue2 = debitValue2;
    }

    public BigDecimal getDebitValue3() {
        return this.mDebitValue3;
    }

    public void setDebitValue3(BigDecimal debitValue3) {
        this.mDebitValue3 = debitValue3;
    }

    public BigDecimal getCreditValue1() {
        return this.mCreditValue1;
    }

    public void setCreditValue1(BigDecimal creditValue1) {
        this.mCreditValue1 = creditValue1;
    }

    public BigDecimal getCreditValue2() {
        return this.mCreditValue2;
    }

    public void setCreditValue2(BigDecimal creditValue2) {
        this.mCreditValue2 = creditValue2;
    }

    public BigDecimal getCreditValue3() {
        return this.mCreditValue3;
    }

    public void setCreditValue3(BigDecimal creditValue3) {
        this.mCreditValue3 = creditValue3;
    }

    public BigDecimal getDebitSum() {
        return this.mDebitSum;
    }

    public void setDebitSum(BigDecimal debitSum) {
        this.mDebitSum = debitSum;
    }

    public BigDecimal getCreditSum() {
        return this.mCreditSum;
    }

    public void setCreditSum(BigDecimal creditSum) {
        this.mCreditSum = creditSum;
    }

    public void setDocumentDate(Date documentDate) {
        this.mDocumentDate = documentDate;
    }

    public void setDocumentNumber(String documentNumber) {
        this.mDocumentNumber = documentNumber;
    }

    public void setDocumentName(String documentName) {
        this.mDocumentName = documentName;
    }

    public void setSupplier(String supplier) {
        this.mSupplier = supplier;
    }

    public void setPostingText(String postingText) {
        this.mPostingText = postingText;
    }

    public BigDecimal getmAcquisitionValueBal() {
        return this.mAcquisitionValueBal;
    }

    public void setmAcquisitionValueBal(BigDecimal mAcquisitionValueBal) {
        this.mAcquisitionValueBal = mAcquisitionValueBal;
    }

    public BigDecimal getmAcquisitionValueTax() {
        return this.mAcquisitionValueTax;
    }

    public void setmAcquisitionValueTax(BigDecimal mAcquisitionValueTax) {
        this.mAcquisitionValueTax = mAcquisitionValueTax;
    }
}

