/*
 * Decompiled with CFR 0.152.
 */
package com.varial.assetaccounting.domain.fixedasset;

import com.varial.accounting.domain.financialyear.AccountingCompany;
import com.varial.accounting.domain.financialyear.FinancialYear;
import com.varial.accounting.domain.nominalledger.NominalLedgerAccount;
import com.varial.accounting.domain.personalaccount.PersonalAccount;
import com.varial.assetaccounting.accountingtransaction.TransactionStatusEnum;
import com.varial.assetaccounting.accountingtransaction.optFATransactionFromAccounting;
import com.varial.assetaccounting.calculationmethod.BaseCalcEnum;
import com.varial.assetaccounting.depreciation.DepreciationFunctionEnum;
import com.varial.assetaccounting.domain.accounting.Accounting;
import com.varial.assetaccounting.domain.accountingtransaction.FATransactionFromAccounting;
import com.varial.assetaccounting.domain.accountingtransaction.FATransactionFromAccountingPersistencyManager;
import com.varial.assetaccounting.domain.assetaccsetup.AssetaccountingSetup;
import com.varial.assetaccounting.domain.assetaccsetup.OffsetAccount;
import com.varial.assetaccounting.domain.calculationmethod.CalcMethod;
import com.varial.assetaccounting.domain.calculationmethod.CalcMethodPersistencyManager;
import com.varial.assetaccounting.domain.calculationmethod.DepreciationMethodData;
import com.varial.assetaccounting.domain.depreciation.DepreciationCalculation;
import com.varial.assetaccounting.domain.depreciation.DepreciationCalculationHelper;
import com.varial.assetaccounting.domain.depreciationarea.DepreciationArea;
import com.varial.assetaccounting.domain.depreciationarea.DepreciationAreaPersistencyManager;
import com.varial.assetaccounting.domain.fafinancialyear.FAFinancialPeriod;
import com.varial.assetaccounting.domain.fafinancialyear.FAFinancialYear;
import com.varial.assetaccounting.domain.fasingleposting.FASinglePostingPersistencyManager;
import com.varial.assetaccounting.domain.fixedasset.FACostCentre;
import com.varial.assetaccounting.domain.fixedasset.FixedAsset;
import com.varial.assetaccounting.domain.fixedasset.FixedAssetArea;
import com.varial.assetaccounting.domain.fixedasset.FixedAssetData;
import com.varial.assetaccounting.domain.fixedasset.FixedAssetExceptionMapper;
import com.varial.assetaccounting.domain.fixedasset.FixedAssetGroupData;
import com.varial.assetaccounting.domain.fixedasset.FixedAssetMapper;
import com.varial.assetaccounting.domain.fixedasset.FixedAssetPersistencyManager;
import com.varial.assetaccounting.domain.fixedasset.FixedAssetTransaction;
import com.varial.assetaccounting.domain.fixedasset.FixedAssetTransactionExceptionMapper;
import com.varial.assetaccounting.domain.fixedasset.FixedAssetTransactionMapper;
import com.varial.assetaccounting.domain.fixedasset.FixedAssetTransactionPersistencyManager;
import com.varial.assetaccounting.fixedasset.DepreciationStartEnum;
import com.varial.assetaccounting.fixedasset.DeterminationDisposalValueEnum;
import com.varial.assetaccounting.fixedasset.ExistingDepreciationStruct;
import com.varial.assetaccounting.fixedasset.FixedAssetTransactionStruct;
import com.varial.assetaccounting.fixedasset.IncreaseLifeEnum;
import com.varial.assetaccounting.fixedasset.NewManualDepreciationStruct;
import com.varial.assetaccounting.fixedasset.StatusEnum;
import com.varial.assetaccounting.fixedasset.TransactionEnum;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.PersistencySession;
import com.varial.base.types.date.DateHelper;
import com.varial.framework.domain.company.JurisdictionType;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.StringMapper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixedAssetTransactionManager {
    protected static Logger LOGGER = LoggerFactory.getLogger((String)FixedAssetTransactionManager.class.getName());
    private static final BigDecimal HUNDRED = new BigDecimal("100.00");

    public static FixedAssetTransaction[] createTransactions(FixedAssetTransactionStruct[] transactionStruct, FixedAssetData fixedAsset, optFATransactionFromAccounting transactFromAccountingStruct, List<FixedAssetTransaction> listTransactToFA, PersistencySession session, boolean deleteCorrespTransactions) throws BusinessDomainException {
        LOGGER.debug("createTransactions(...)");
        FixedAssetTransaction[] transactions = new FixedAssetTransaction[transactionStruct.length];
        boolean sameIdentity = false;
        FixedAsset newFixedAssedGroup = null;
        FixedAsset oldFixedAssedGroup = null;
        String barCode = "";
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal salesAmount = BigDecimal.ZERO;
        for (int h = 0; h < transactionStruct.length; ++h) {
            if (!transactionStruct[h].area.belongsToBalanceSheet) continue;
            amount = BigDecimalMapper.toBigDecimal((String)transactionStruct[h].amount);
            salesAmount = BigDecimalMapper.toBigDecimal((String)transactionStruct[h].salesAmount);
        }
        boolean isSingleAllocation = false;
        for (int i = 0; i < transactionStruct.length; ++i) {
            FixedAssetArea area;
            block196: {
                int days;
                short newMonth;
                List transactCache;
                block197: {
                    block200: {
                        block198: {
                            FixedAssetTransaction canceledTransaction;
                            block199: {
                                block195: {
                                    if (transactionStruct[i].isSingleAllocation) {
                                        isSingleAllocation = true;
                                    }
                                    if (!transactionStruct[i].area.belongsToBalanceSheet && (transactionStruct[i].transactionType.equals(TransactionEnum.TRE_PARTIAL_ADDITION) || transactionStruct[i].transactionType.equals(TransactionEnum.TRE_PARTIAL_ADDITION_SPLIT) || transactionStruct[i].transactionType.equals(TransactionEnum.TRE_POST_CAPITALIZATION) || transactionStruct[i].transactionType.equals(TransactionEnum.TRE_CREDIT_NOTE) || transactionStruct[i].transactionType.equals(TransactionEnum.TRE_CREDIT_NOTE_SPLIT) || transactionStruct[i].transactionType.equals(TransactionEnum.TRE_PARTIAL_DISPOSAL) || transactionStruct[i].transactionType.equals(TransactionEnum.TRE_FULL_DISPOSAL)) && transactFromAccountingStruct.discriminator()) {
                                        FATransactionFromAccounting transactionFromAccounting = FATransactionFromAccountingPersistencyManager.getFATransactionFromAccounting((String)transactFromAccountingStruct.accTransaction().oidTs.objectid);
                                        boolean newCalculation = false;
                                        for (int j = 0; j < transactFromAccountingStruct.accTransaction().transactCurrencyAmounts.length; ++j) {
                                            if (StringMapper.isNullString((String)transactFromAccountingStruct.accTransaction().transactCurrencyAmounts[j].currency.oidTimestamp.objectid) || StringMapper.isNullString((String)transactFromAccountingStruct.accTransaction().transactCurrencyAmounts[j].amount) || !transactionStruct[i].area.currency.oidTimestamp.objectid.equals(transactFromAccountingStruct.accTransaction().transactCurrencyAmounts[j].currency.oidTimestamp.objectid)) continue;
                                            newCalculation = true;
                                        }
                                        if (newCalculation) {
                                            BigDecimal bookedAmount = transactionFromAccounting.getAmount();
                                            BigDecimal foreignBookedAmount = transactionFromAccounting.getForeignAmount();
                                            if (transactionStruct[i].transactionType.equals(TransactionEnum.TRE_PARTIAL_DISPOSAL) || transactionStruct[i].transactionType.equals(TransactionEnum.TRE_FULL_DISPOSAL)) {
                                                BigDecimal persentageBookedAmount = salesAmount.multiply(HUNDRED).divide(bookedAmount, 10, RoundingMode.HALF_EVEN);
                                                BigDecimal newForeignAmount = foreignBookedAmount.multiply(persentageBookedAmount).divide(HUNDRED, 2, RoundingMode.HALF_EVEN);
                                                transactionStruct[i].salesAmount = BigDecimalMapper.toString((BigDecimal)newForeignAmount);
                                            } else {
                                                BigDecimal persentageBookedAmount = amount.multiply(HUNDRED).divide(bookedAmount, 10, RoundingMode.HALF_EVEN);
                                                BigDecimal newForeignAmount = foreignBookedAmount.multiply(persentageBookedAmount).divide(HUNDRED, 2, RoundingMode.HALF_EVEN);
                                                transactionStruct[i].amount = BigDecimalMapper.toString((BigDecimal)newForeignAmount);
                                            }
                                        }
                                    }
                                    area = null;
                                    transactions[i] = new FixedAssetTransaction();
                                    FixedAssetTransactionMapper.fillFixedAssetTransaction((FixedAssetTransaction)transactions[i], (FixedAssetTransactionStruct)transactionStruct[i], (FixedAssetData)fixedAsset);
                                    if (!sameIdentity) {
                                        barCode = String.valueOf(transactions[i].getTransactionSeqNumber());
                                        sameIdentity = true;
                                    }
                                    transactions[i].setBarcodeNumber(barCode);
                                    transactions[i].setIsBooked(false);
                                    if (transactFromAccountingStruct.discriminator()) {
                                        transactions[i].setOidFATransactionFromAccounting(transactFromAccountingStruct.accTransaction().oidTs.objectid);
                                        if (transactFromAccountingStruct.accTransaction().transactType.value() == 9 && !isSingleAllocation) {
                                            FATransactionFromAccounting[] FAtransaction;
                                            BigDecimal amountFAT = BigDecimalMapper.toBigDecimal((String)transactFromAccountingStruct.accTransaction().amount);
                                            FATransactionFromAccounting transactionFromAccounting = FATransactionFromAccountingPersistencyManager.getFATransactionFromAccounting((String)transactFromAccountingStruct.accTransaction().oidTs.objectid);
                                            if (transactionFromAccounting != null && transactionFromAccounting.getOidNlTransaction() != "" && BigDecimalMapper.compareTo((BigDecimal)amountFAT, (BigDecimal)BigDecimalMapper.ZERO) > 0 && (FAtransaction = FATransactionFromAccountingPersistencyManager.getCorrespFinalSettlementTransaction((String)transactionFromAccounting.getOidNlTransaction(), (String)transactFromAccountingStruct.accTransaction().transactionNumber)) != null && FAtransaction.length > 0) {
                                                for (int j = 0; j < FAtransaction.length; ++j) {
                                                    transactions[i].setAmount(transactions[i].getAmount().add(FAtransaction[j].getAmount()));
                                                    if (BigDecimalMapper.compareTo((BigDecimal)transactions[i].getAmount(), (BigDecimal)BigDecimalMapper.ZERO) < 0) {
                                                        transactions[i].setTransactionEnum(TransactionEnum.TRE_CREDIT_NOTE);
                                                    }
                                                    if (!transactions[i].getDeprArea().getBelongsToBalanceSheet()) continue;
                                                    FixedAssetTransactionManager.updateCorrespSettlementTransactionFromAccounting(fixedAsset, transactions[i], FAtransaction[j]);
                                                }
                                            }
                                        }
                                    }
                                    BigDecimal transactQuantity = BigDecimalMapper.toBigDecimalZero((String)transactions[i].getQuantity());
                                    if (transactionStruct[i].isCancellation) {
                                        if (transactionStruct[i].transactionType.value() == 21 && FixedAssetTransaction.checkTransactionsAfterActivateAssetUnderConstruction((FixedAsset)fixedAsset, transactions[i].getDeprArea(), transactions[i].getProcessingDate())) {
                                            throw FixedAssetTransactionExceptionMapper.makeCancelActivateTransactDomainException((String)"FixedAssetTransaction.check");
                                        }
                                        transactQuantity = transactQuantity.negate();
                                        FixedAssetTransaction canceledTransaction2 = FixedAssetTransactionPersistencyManager.getFixedAssetTransaction((String)transactionStruct[i].oidTs.objectid);
                                        canceledTransaction2.makeSaveable();
                                        if (canceledTransaction2.getIsBooked()) {
                                            canceledTransaction2.setIsCanceled(true);
                                            if (transactions[i].getTransactionEnum().value() == 19 || transactions[i].getTransactionEnum().value() == 20 || transactions[i].getTransactionEnum().value() == 4 || transactions[i].getTransactionEnum().value() == 26 || (transactions[i].getTransactionEnum().value() == 5 || transactions[i].getTransactionEnum().value() == 25 || transactions[i].getTransactionEnum().value() == 6) && (canceledTransaction2.getFixedAsset().getObjectid().equals(canceledTransaction2.getFixedAssetTransferFrom().getObjectid()) || canceledTransaction2.getFixedAsset().getObjectid().equals(canceledTransaction2.getFixedAssetTransferTo().getObjectid()))) {
                                                transactions[i].setAccumDepr(canceledTransaction2.getAccumDepr().negate());
                                                transactions[i].setAccumSpecDepr(canceledTransaction2.getAccumSpecDepr().negate());
                                                if (transactions[i].getTransactionEnum().value() == 19 || transactions[i].getTransactionEnum().value() == 20) {
                                                    transactions[i].setSalesAmount(canceledTransaction2.getSalesAmount().negate());
                                                    transactions[i].setPartDisposalNetBookValue(canceledTransaction2.getPartDisposalNetBookValue().negate());
                                                }
                                                if (transactions[i].getTransactionEnum().value() == 26) {
                                                    transactions[i].setReserveAmount(canceledTransaction2.getReserveAmount().negate());
                                                    transactions[i].setLifeInMonth(canceledTransaction2.getLifeInMonth());
                                                    transactions[i].setResLifeInMonth(canceledTransaction2.getResLifeInMonth());
                                                    transactions[i].setDepResValueOld(canceledTransaction2.getDepResValueOld());
                                                    transactions[i].setDepreciationMethodOld(canceledTransaction2.getDepreciationMethodOld());
                                                }
                                            }
                                        } else {
                                            FixedAssetTransactionPersistencyManager.removeOIDInTransferFATransaction((FixedAssetTransaction)canceledTransaction2);
                                            FASinglePostingPersistencyManager.removeOIDTransaction((FixedAssetTransaction)canceledTransaction2);
                                            if (canceledTransaction2.getCorrespondingTransaction() != null) {
                                                FixedAssetTransactionPersistencyManager.removeOIDInCorrespondingTransaction((FixedAssetTransaction)canceledTransaction2);
                                            }
                                            if (transactions[i].getTransactionEnum().value() == 26) {
                                                transactions[i].setLifeInMonth(canceledTransaction2.getLifeInMonth());
                                                transactions[i].setResLifeInMonth(canceledTransaction2.getResLifeInMonth());
                                                transactions[i].setDepResValueOld(canceledTransaction2.getDepResValueOld());
                                                transactions[i].setDepreciationMethodOld(canceledTransaction2.getDepreciationMethodOld());
                                            }
                                            if (transactions[i].getTransactionEnum().value() == 3) {
                                                transactions[i].setDepResValueOld(canceledTransaction2.getDepResValueOld());
                                                transactions[i].setDepreciationMethodOld(canceledTransaction2.getDepreciationMethodOld());
                                            }
                                            canceledTransaction2.destroy();
                                            if (deleteCorrespTransactions) {
                                                transactions[i].setTimestamp(canceledTransaction2.getTimestamp());
                                                transactions[i].setObjectid(canceledTransaction2.getObjectid());
                                                transactions[i].setVersion(canceledTransaction2.getVersion());
                                                transactions[i].setLastuser(canceledTransaction2.getLastuser());
                                            }
                                            transactions[i].makeReadOnly();
                                        }
                                    }
                                    if (transactions[i].getDeprArea().getBelongsToBalanceSheet() && !BigDecimalMapper.isZeroOrNull((BigDecimal)transactQuantity)) {
                                        BigDecimal faQuantity = BigDecimalMapper.toBigDecimalZero((String)fixedAsset.getQuantity());
                                        BigDecimal newQuantity = faQuantity.add(transactQuantity);
                                        fixedAsset.setQuantity(BigDecimalMapper.toString((BigDecimal)newQuantity));
                                        fixedAsset.makeSaveable();
                                    }
                                    if (transactions[i].getTransactionEnum().value() == 19 && transactions[i].getDeterminationDisposalValueType() == DeterminationDisposalValueEnum.DDE_NETBOOKVALUE && !transactionStruct[i].isCancellation && BigDecimalMapper.compareTo((BigDecimal)transactions[i].getPartDisposalNetBookValue(), (BigDecimal)BigDecimal.ZERO) < 0) {
                                        DepreciationCalculation deprCalc;
                                        DepreciationCalculationHelper dchPartDisposalDate;
                                        if (area == null) {
                                            area = FixedAssetArea.getFixedAssetArea((FixedAsset)fixedAsset, (DepreciationArea)transactions[i].getDeprArea());
                                        }
                                        if ((dchPartDisposalDate = DepreciationCalculation.getDeprCalcHelperBeforeOrEqualDate((List)(transactCache = (deprCalc = new DepreciationCalculation(area, DepreciationFunctionEnum.DEFE_CALCULATION)).buildTransactionsCache(null)), (Date)transactions[i].getProcessingDate(), (boolean)false, (boolean)false)) != null) {
                                            BigDecimal partDisposalNetBookValue = transactions[i].getPartDisposalNetBookValue().negate();
                                            if (BigDecimalMapper.compareTo((BigDecimal)dchPartDisposalDate.getNetBookValue(), (BigDecimal)partDisposalNetBookValue) < 0) {
                                                throw FixedAssetTransactionExceptionMapper.makePartDisposalValueToLargeDomainException((String)"FixedAssetTransaction.check", (String)transactions[i].getDeprArea().getCode());
                                            }
                                        }
                                    }
                                    if (transactions[i].getTransactionEnum().value() != 20) break block195;
                                    if (area == null) {
                                        area = FixedAssetArea.getFixedAssetArea((FixedAsset)fixedAsset, (DepreciationArea)transactions[i].getDeprArea());
                                    }
                                    if (transactionStruct[i].isCancellation) {
                                        area.setIsFullDisposed(false);
                                        area.setRetirementDate(null);
                                        if (transactions[i].getDeprArea().getBelongsToBalanceSheet()) {
                                            fixedAsset.setDisposalDate(null);
                                        }
                                        if (area.getProcessingDate() != null) {
                                            if (transactions[i].getDeprArea().getDeprToResValueFullDisposal() && BigDecimalMapper.compareTo((BigDecimal)area.getDepResValue(), (BigDecimal)BigDecimal.ZERO) > 0) {
                                                area.setProcessingDate(DateHelper.yesterday((Date)DateHelper.getFirstDayOfMonth((Date)transactions[i].getProcessingDate())));
                                            } else if (DateHelper.after((Date)DateHelper.getLastDayOfMonth((Date)transactions[i].getProcessingDate()), (Date)transactions[i].getProcessingDate())) {
                                                area.setProcessingDate(DateHelper.yesterday((Date)DateHelper.getFirstDayOfMonth((Date)transactions[i].getProcessingDate())));
                                            } else {
                                                area.setProcessingDate(transactions[i].getProcessingDate());
                                            }
                                        }
                                    } else {
                                        if (!StringMapper.isNullString((String)fixedAsset.getQuantity())) {
                                            transactions[i].setQuantity(BigDecimalMapper.toString((BigDecimal)BigDecimalMapper.toBigDecimal((String)fixedAsset.getQuantity()).negate()));
                                        } else {
                                            transactions[i].setQuantity(BigDecimalMapper.toString((BigDecimal)BigDecimal.ZERO));
                                        }
                                        area.setIsFullDisposed(true);
                                        area.setRetirementDate(DateMapper.toDate((String)transactionStruct[i].processingDate));
                                        if (transactions[i].getDeprArea().getBelongsToBalanceSheet()) {
                                            fixedAsset.setDisposalDate(DateMapper.toDate((String)transactionStruct[i].processingDate));
                                        }
                                        if (transactions[i].getDeprArea().getDeprToResValueFullDisposal() && BigDecimalMapper.compareTo((BigDecimal)area.getDepResValue(), (BigDecimal)BigDecimal.ZERO) > 0 && !transactionStruct[i].isCanceled && area.getLastDeprDate() != null && area.getResidualLifeInMonth() == 0 && DateHelper.before((Date)area.getLastDeprDate(), (Date)transactions[i].getProcessingDate())) {
                                            area.setProcessingDate(DateHelper.yesterday((Date)DateHelper.getFirstDayOfMonth((Date)transactions[i].getProcessingDate())));
                                            area.setLastDeprDate(DateHelper.yesterday((Date)DateHelper.getFirstDayOfMonth((Date)transactions[i].getProcessingDate())));
                                        }
                                    }
                                    fixedAsset.makeSaveable();
                                    area.makeSaveable();
                                    break block196;
                                }
                                if (transactions[i].getTransactionEnum().value() != 21) break block197;
                                if (area == null) {
                                    area = FixedAssetArea.getFixedAssetArea((FixedAsset)fixedAsset, (DepreciationArea)transactions[i].getDeprArea());
                                }
                                if (!transactionStruct[i].isCancellation) break block198;
                                canceledTransaction = FixedAssetTransactionPersistencyManager.getFixedAssetTransaction((String)transactionStruct[i].oidTs.objectid);
                                area.setDeprStartDate(null);
                                area.setDepreciationStart(null);
                                area.setStatus(StatusEnum.STE_UNDER_CONSTR);
                                area.setUsefullLifeInMonth(0);
                                area.setResidualLifeInMonth(0);
                                area.setLastDeprDate(null);
                                area.setUsefullLifeInDays(0);
                                area.setResLifeInDays(0);
                                area.setDepBelowZero(false);
                                area.setShiftFactor(BigDecimal.ZERO);
                                area.setDepResValue(BigDecimal.ZERO);
                                if (transactionStruct[i].oidDepreciationMethod.discriminator()) {
                                    area.setOidDepreciationMethod(null);
                                    area.setDepreciationPercent(null);
                                }
                                if (canceledTransaction.getAccountGroupOld() != null) {
                                    area.setAccountGroup(canceledTransaction.getAccountGroupOld());
                                }
                                if (!transactions[i].getDeprArea().getBelongsToBalanceSheet()) break block199;
                                fixedAsset.setAssetAccount(canceledTransaction.getAssetAccountOld());
                                fixedAsset.setCommissioningDate(null);
                                if (canceledTransaction.getChangeAssetNumber() && !StringMapper.isNullString((String)canceledTransaction.getOldAssetNumber())) {
                                    fixedAsset.setCodeFromTransaction(transactions[i].getOldAssetNumber(), Boolean.valueOf(true));
                                }
                                if (canceledTransaction.getAccValuationDeprOld() != null) {
                                    fixedAsset.setAccValuationDepreciation(canceledTransaction.getAccValuationDeprOld());
                                }
                                if (canceledTransaction.getAssetGroupOld() != null) {
                                    fixedAsset.setParent(canceledTransaction.getAssetGroupOld());
                                }
                                break block200;
                            }
                            if (!transactions[i].getDeprArea().getDifferingAssetAccount()) break block200;
                            area.setAssetAccount(canceledTransaction.getAssetAccountOld());
                            if (canceledTransaction.getAccValuationDeprOld() == null) break block200;
                            area.setAccValuationDepreciation(canceledTransaction.getAccValuationDeprOld());
                            break block200;
                        }
                        FixedAssetTransaction newAdd = FixedAssetTransactionPersistencyManager.getNewAddition((FixedAssetArea)area);
                        if (newAdd != null && DateHelper.after((Date)newAdd.getProcessingDate(), (Date)transactions[i].getProcessingDate())) {
                            throw FixedAssetTransactionExceptionMapper.transactionDateNotAllowedDomainException((String)"FixedAssetTransaction.check");
                        }
                        if (area.getDeprArea().getLandOfDepreciation() == null && fixedAsset.getAccountCompany().getJurisdictionType() == JurisdictionType.PL || area.getDeprArea().getLandOfDepreciation() != null && area.getDeprArea().getLandOfDepreciation() == JurisdictionType.PL) {
                            area.setDeprStartDate(DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)transactions[i].getProcessingDate())));
                        } else {
                            area.setDeprStartDate(DateHelper.getFirstDayOfMonth((Date)transactions[i].getProcessingDate()));
                        }
                        area.setDepreciationStart(DepreciationStartEnum.DSE_USER);
                        area.setStatus(StatusEnum.STE_ACTIVATED);
                        area.setUsefullLifeInMonth((int)transactionStruct[i].increasePeriodInMonths);
                        area.setResidualLifeInMonth((int)transactionStruct[i].increasePeriodInMonths);
                        int lifeInDays = 0;
                        lifeInDays = FixedAssetArea.calculateLifeInDays((Date)fixedAsset.getAcquisitionDate(), (Date)area.getDeprStartDate(), (int)area.getUsefullLifeInMonth());
                        area.setUsefullLifeInDays(lifeInDays);
                        area.setResLifeInDays(lifeInDays);
                        if (transactionStruct[i].oidDepreciationMethod.discriminator()) {
                            area.setOidDepreciationMethod(transactionStruct[i].oidDepreciationMethod.objectId());
                            BigDecimal deprPercent = CalcMethod.getInitialDepreciationPercentage((CalcMethod)transactions[i].getCalcMethod(), (int)transactionStruct[i].increasePeriodInMonths);
                            deprPercent = deprPercent.setScale(2, RoundingMode.HALF_EVEN);
                            area.setDepreciationPercent(deprPercent);
                        }
                        if (transactions[i].getAccountGroupNew() != null) {
                            area.setAccountGroup(transactions[i].getAccountGroupNew());
                        }
                        if (transactions[i].getDeprArea().getBelongsToBalanceSheet()) {
                            oldFixedAssedGroup = transactions[i].getAssetGroupOld();
                            fixedAsset.setAssetAccount(transactions[i].getAssetAccount());
                            fixedAsset.setCommissioningDate(transactions[i].getProcessingDate());
                            if (transactions[i].getAccValuationDeprNew() != null) {
                                fixedAsset.setAccValuationDepreciation(transactions[i].getAccValuationDeprNew());
                            }
                            if (transactions[i].getAssetGroupNew() != null) {
                                fixedAsset.setParent(transactions[i].getAssetGroupNew());
                                newFixedAssedGroup = transactions[i].getAssetGroupNew();
                            }
                            if (transactions[i].getChangeAssetNumber()) {
                                if (!StringMapper.isNullString((String)transactions[i].getNewAssetNumber())) {
                                    String newAutomaticFixedAssetCode = "";
                                    if (newFixedAssedGroup != null) {
                                        newAutomaticFixedAssetCode = FixedAssetMapper.getNextAutomaticFixedAssetNumber((FixedAsset)newFixedAssedGroup, (AccountingCompany)fixedAsset.getAccountCompany());
                                    } else if (transactions[i].getAssetGroupOld() != null) {
                                        newAutomaticFixedAssetCode = FixedAssetMapper.getNextAutomaticFixedAssetNumber((FixedAsset)oldFixedAssedGroup, (AccountingCompany)fixedAsset.getAccountCompany());
                                    }
                                    fixedAsset.setCodeFromTransaction(transactions[i].getNewAssetNumber(), Boolean.valueOf(false));
                                    if (!StringMapper.isNullString((String)newAutomaticFixedAssetCode) && newAutomaticFixedAssetCode.equals(transactions[i].getNewAssetNumber())) {
                                        if (newFixedAssedGroup != null) {
                                            newFixedAssedGroup.makeSaveable();
                                        } else {
                                            oldFixedAssedGroup.makeSaveable();
                                        }
                                    }
                                } else {
                                    FixedAssetMapper.setAutomaticFixedAssetNumber((FixedAsset)fixedAsset);
                                }
                            }
                        } else if (transactions[i].getDeprArea().getDifferingAssetAccount()) {
                            area.setAssetAccount(transactions[i].getAssetAccount());
                            if (transactions[i].getAccValuationDeprNew() != null) {
                                area.setAccValuationDepreciation(transactions[i].getAccValuationDeprNew());
                            }
                        }
                        if (transactions[i].getAssetGroupNew() != null || !transactions[i].getDeprArea().getBelongsToBalanceSheet() && transactionStruct[i].oidAssetGroupNew.discriminator()) {
                            FixedAssetGroupData fagd = null;
                            if (transactions[i].getDeprArea().getBelongsToBalanceSheet()) {
                                fagd = (FixedAssetGroupData)transactions[i].getAssetGroupNew();
                            } else {
                                newFixedAssedGroup = FixedAssetPersistencyManager.getFixedAssetWithCache((String)transactionStruct[i].oidAssetGroupNew.objectId());
                                fagd = (FixedAssetGroupData)newFixedAssedGroup;
                            }
                            FixedAssetArea[] faas = fagd.getFixedAssetAreas();
                            if (faas != null) {
                                for (int j = 0; j < faas.length; ++j) {
                                    if (!faas[j].getDeprArea().equals((Object)transactions[i].getDeprArea()) || faas[j].getStatus().value() != 0) continue;
                                    switch (faas[j].getDepreciationStart().value()) {
                                        case 5: {
                                            area.setDepreciationStart(DepreciationStartEnum.DSE_ACQ_DAY);
                                            if (DateHelper.after((Date)transactions[i].getDocumentDate(), (Date)fixedAsset.getAcquisitionDate())) {
                                                area.setDeprStartDate(transactions[i].getDocumentDate());
                                                break;
                                            }
                                            area.setDeprStartDate(fixedAsset.getAcquisitionDate());
                                            break;
                                        }
                                        case 3: {
                                            area.setDepreciationStart(DepreciationStartEnum.DSE_BEGIN_ACC_YEAR);
                                            area.setDeprStartDate(DateHelper.getFirstDayOfYear((Date)transactions[i].getDocumentDate()));
                                            break;
                                        }
                                        case 4: {
                                            area.setDepreciationStart(DepreciationStartEnum.DSE_BEGIN_NEXT_YEAR);
                                            VDate vdate = new VDate(DateHelper.tomorrow((Date)DateHelper.getLastDayOfYear((Date)transactions[i].getDocumentDate())));
                                            area.setDeprStartDate(vdate.getDate());
                                            break;
                                        }
                                        case 0: {
                                            area.setDepreciationStart(DepreciationStartEnum.DSE_HALF_YEAR);
                                            area.setDeprStartDate(DateHelper.getFirstDayOfHalfYear((Date)transactions[i].getDocumentDate()));
                                            break;
                                        }
                                        default: {
                                            area.setDeprStartDate(DateHelper.getFirstDayOfMonth((Date)transactions[i].getProcessingDate()));
                                            if ((area.getDeprArea().getLandOfDepreciation() != null || fixedAsset.getAccountCompany().getJurisdictionType() != JurisdictionType.PL) && (area.getDeprArea().getLandOfDepreciation() == null || area.getDeprArea().getLandOfDepreciation() != JurisdictionType.PL)) break;
                                            area.setDeprStartDate(DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)transactions[i].getProcessingDate())));
                                        }
                                    }
                                    area.setDepBelowZero(faas[j].getDepBelowZero());
                                    if (BigDecimalMapper.isZeroOrNull((BigDecimal)faas[j].getDepResValue())) {
                                        area.setDepResValue(BigDecimal.ZERO);
                                    } else {
                                        area.setDepResValue(faas[j].getDepResValue());
                                    }
                                    if (BigDecimalMapper.isZeroOrNull((BigDecimal)faas[j].getShiftFactor())) {
                                        area.setShiftFactor(BigDecimal.ZERO);
                                    } else {
                                        area.setShiftFactor(faas[j].getShiftFactor());
                                    }
                                    area.setReplacementIndex(faas[j].getReplacementIndex());
                                }
                            }
                        }
                    }
                    FixedAssetArea[] faAreasNew = fixedAsset.getFixedAssetAreas();
                    for (int k = 0; k < faAreasNew.length; ++k) {
                        if (!faAreasNew[k].getObjectid().equals(area.getObjectid())) continue;
                        faAreasNew[k] = area;
                    }
                    fixedAsset.setFixedAssetAreas(faAreasNew);
                    fixedAsset.makeSaveable();
                    area.makeSaveable();
                    break block196;
                }
                if (transactions[i].getTransactionEnum().value() == 8) {
                    if (area == null) {
                        area = FixedAssetArea.getFixedAssetArea((FixedAsset)fixedAsset, (DepreciationArea)transactions[i].getDeprArea());
                    }
                    if (transactionStruct[i].isCancellation) {
                        FixedAssetTransaction canceledTransaction = FixedAssetTransactionPersistencyManager.getFixedAssetTransaction((String)transactionStruct[i].oidTs.objectid);
                        if (transactions[i].getDeprArea().getBelongsToBalanceSheet()) {
                            fixedAsset.setAssetAccount(canceledTransaction.getAssetAccountOld());
                            if (canceledTransaction.getAccValuationDeprOld() != null) {
                                fixedAsset.setAccValuationDepreciation(canceledTransaction.getAccValuationDeprOld());
                            }
                            if (canceledTransaction.getAssetGroupOld() != null) {
                                fixedAsset.setParent(canceledTransaction.getAssetGroupOld());
                            }
                            if (canceledTransaction.getAccountGroupOld() != null) {
                                area.setAccountGroup(canceledTransaction.getAccountGroupOld());
                            }
                        } else if (transactions[i].getDeprArea().getDifferingAssetAccount()) {
                            area.setAssetAccount(canceledTransaction.getAssetAccountOld());
                            if (canceledTransaction.getAccValuationDeprOld() != null) {
                                area.setAccValuationDepreciation(canceledTransaction.getAccValuationDeprOld());
                            }
                            if (canceledTransaction.getAccountGroupOld() != null) {
                                area.setAccountGroup(canceledTransaction.getAccountGroupOld());
                            }
                        }
                    } else if (transactions[i].getDeprArea().getBelongsToBalanceSheet()) {
                        transactions[i].setAssetAccountOld(fixedAsset.getAssetAccount().getNLAccountCompanySetting(fixedAsset.getAccountCompany()));
                        fixedAsset.setAssetAccount(transactions[i].getAssetAccount());
                        if (transactions[i].getAccValuationDeprNew() != null) {
                            fixedAsset.setAccValuationDepreciation(transactions[i].getAccValuationDeprNew());
                        }
                        if (transactions[i].getAssetGroupNew() != null) {
                            fixedAsset.setParent(transactions[i].getAssetGroupNew());
                        }
                        if (transactions[i].getAccountGroupNew() != null) {
                            area.setAccountGroup(transactions[i].getAccountGroupNew());
                        }
                    } else if (transactions[i].getDeprArea().getDifferingAssetAccount()) {
                        transactions[i].setAssetAccountOld(area.getAssetAccount().getNLAccountCompanySetting(fixedAsset.getAccountCompany()));
                        area.setAssetAccount(transactions[i].getAssetAccount());
                        if (transactions[i].getAccValuationDeprNew() != null) {
                            area.setAccValuationDepreciation(transactions[i].getAccValuationDeprNew());
                        }
                        if (transactions[i].getAccountGroupNew() != null) {
                            area.setAccountGroup(transactions[i].getAccountGroupNew());
                        }
                    }
                    fixedAsset.makeSaveable();
                    area.makeSaveable();
                } else if (transactions[i].getTransactionEnum().value() == 9) {
                    if (transactionStruct[i].isCancellation) {
                        FixedAssetTransaction canceledTransaction = FixedAssetTransactionPersistencyManager.getFixedAssetTransaction((String)transactionStruct[i].oidTs.objectid);
                        if (transactions[i].getDeprArea().getBelongsToBalanceSheet()) {
                            if (canceledTransaction.getCostCentreOld() == null) {
                                fixedAsset.setCostCentreBase(null);
                                fixedAsset.setCostCenters(null);
                            } else {
                                FACostCentre[] costCentres = FACostCentre.getFACostCentres((FixedAssetData)fixedAsset);
                                for (int i2 = 0; i2 < costCentres.length; ++i2) {
                                    if (!costCentres[i2].getCostCentreBase().equals((Object)canceledTransaction.getCostCentreNew())) continue;
                                    costCentres[i2].setCostCentreBase(canceledTransaction.getCostCentreOld());
                                    costCentres[i2].setShare(1);
                                    fixedAsset.setCostCenters(costCentres);
                                    fixedAsset.setCostCentreBase(canceledTransaction.getCostCentreOld());
                                }
                            }
                            if (canceledTransaction.getLocationOld() != null) {
                                fixedAsset.setLocation(canceledTransaction.getLocationOld());
                            } else {
                                fixedAsset.setLocation(null);
                            }
                        }
                    } else {
                        if (transactions[i].getCostCentreNew() == null && transactions[i].getLocationNew() == null) {
                            throw FixedAssetTransactionExceptionMapper.makeNoCostCentreException((String)"FixedAssetTransaction.check");
                        }
                        if (transactions[i].getDeprArea().getBelongsToBalanceSheet()) {
                            if (fixedAsset.getCostCentreBase() != null) {
                                FACostCentre[] costCentres = FACostCentre.getFACostCentres((FixedAssetData)fixedAsset);
                                for (int i2 = 0; i2 < costCentres.length; ++i2) {
                                    if (!costCentres[i2].getCostCentreBase().equals((Object)fixedAsset.getCostCentreBase())) continue;
                                    costCentres[i2].setCostCentreBase(transactions[i].getCostCentreNew());
                                    costCentres[i2].setShare(1);
                                    fixedAsset.setCostCenters(costCentres);
                                    fixedAsset.setCostCentreBase(transactions[i].getCostCentreNew());
                                }
                            } else if (transactions[i].getCostCentreNew() != null) {
                                fixedAsset.setCostCentreBase(transactions[i].getCostCentreNew());
                                FACostCentre[] costCentres = new FACostCentre[]{new FACostCentre(fixedAsset)};
                                costCentres[0].setCostCentreBase(transactions[i].getCostCentreNew());
                                costCentres[0].setShare(1);
                                fixedAsset.setCostCenters(costCentres);
                            }
                            if (transactions[i].getLocationNew() != null) {
                                if (fixedAsset.getLocation() != null) {
                                    transactions[i].setLocationOld(fixedAsset.getLocation());
                                }
                                fixedAsset.setLocation(transactions[i].getLocationNew());
                            }
                        }
                    }
                    fixedAsset.makeSaveable();
                } else if (transactions[i].getTransactionEnum().value() == 3) {
                    if (area == null) {
                        area = FixedAssetArea.getFixedAssetArea((FixedAsset)fixedAsset, (DepreciationArea)transactions[i].getDeprArea());
                    }
                    if (area != null && (area.getStatus().value() == 7 || area.getStatus().value() == 3 || area.getStatus().value() == 8 || area.getStatus().value() == 1 || area.getStatus().value() == 5)) {
                        if (transactionStruct[i].oidDepreciationMethod.discriminator()) {
                            throw FixedAssetTransactionExceptionMapper.makeDeprMethodNotAllowedDomainException((String)"FixedAssetTransaction.check");
                        }
                        if (transactions[i].getIncreasePeriodInMonth() != 0) {
                            throw FixedAssetTransactionExceptionMapper.makeUsefulLifeNotAllowedDomainException((String)"FixedAssetTransaction.check");
                        }
                    }
                    if (transactions[i].getDeprArea().getCalcRemLifeForPostCapitalization() && !transactionStruct[i].isCancellation && transactions[i].getIncreasePeriodInMonth() == 0 && (area.getDeprArea().getLandOfDepreciation() == null && fixedAsset.getAccountCompany().getJurisdictionType() == JurisdictionType.PL || area.getDeprArea().getLandOfDepreciation() != null && area.getDeprArea().getLandOfDepreciation() == JurisdictionType.PL)) {
                        if (area.getLastDeprDate() != null && DateHelper.before((Date)area.getLastDeprDate(), (Date)DateHelper.yesterday((Date)DateHelper.getFirstDayOfMonth((Date)transactions[i].getProcessingDate()))) || area.getLastInterestCalcDate() != null && transactions[i].getDeprArea().getImputedInterest() && DateHelper.beforeOrEqual((Date)area.getLastInterestCalcDate(), (Date)transactions[i].getProcessingDate())) {
                            session.flush();
                            FixedAssetTransactionManager.createDepreciations(transactions[i], area);
                            session.flush();
                        } else {
                            session.flush();
                            FixedAssetTransactionManager.updateDepreciations(transactions[i], area);
                            session.flush();
                        }
                        DepreciationCalculation deprCalc = new DepreciationCalculation(area, DepreciationFunctionEnum.DEFE_CALCULATION);
                        transactCache = deprCalc.buildTransactionsCache(null);
                        DepreciationCalculationHelper dch = null;
                        DepreciationCalculationHelper dchDepr = null;
                        DepreciationCalculationHelper dchPostCapitalization = null;
                        Date newLastDeprDate = transactions[i].getProcessingDate();
                        for (int j = 0; j < transactCache.size(); ++j) {
                            dch = (DepreciationCalculationHelper)transactCache.get(j);
                            if (dch.getIsCancelation() || dch.getIsCanceled()) continue;
                            if (dch.getTransactionType().value() == 10 || dch.getTransactionType().value() == 11) {
                                if (DateHelper.after((Date)dch.getProcessingDate(), (Date)newLastDeprDate)) {
                                    j = transactCache.size();
                                } else {
                                    dchDepr = dch;
                                }
                            }
                            if ((dch.getTransactionType().value() == 20 || dch.getTransactionType().value() == 6) && BigDecimalMapper.compareTo((BigDecimal)dch.getAccumAcquisitionValueRepost(), (BigDecimal)BigDecimal.ZERO) < 0) {
                                j = transactCache.size();
                            }
                            if (dch.getTransactionType().value() != 3 || !DateHelper.equal((Date)transactions[i].getProcessingDate(), (Date)dch.getProcessingDate()) || !DateHelper.equal((Date)transactions[i].getDocumentDate(), (Date)dch.getDocumentDate()) || BigDecimalMapper.compareTo((BigDecimal)transactions[i].getAmount(), (BigDecimal)dch.getAmount()) != 0 || !StringMapper.equal((String)transactions[i].getObjectid(), (String)dch.getOidFATransaction())) continue;
                            dchPostCapitalization = dch;
                            j = transactCache.size();
                        }
                        if (dchDepr != null && !StringMapper.isNullString((String)area.getOidDepreciationMethod())) {
                            CalcMethod calcMethod = CalcMethodPersistencyManager.getCalcMethod((String)area.getOidDepreciationMethod());
                            BigDecimal lastAcquistionValue = dchDepr.getAccumAcquisitionValue();
                            BigDecimal lastNetBookValue = dchDepr.getNetBookValue();
                            BigDecimal newAcquistionValue = BigDecimal.ZERO;
                            BigDecimal newNetBookValue = BigDecimal.ZERO;
                            if (dchPostCapitalization != null) {
                                newAcquistionValue = dchPostCapitalization.getAccumAcquisitionValue();
                                newNetBookValue = dchPostCapitalization.getNetBookValue();
                            } else {
                                newAcquistionValue = lastAcquistionValue.add(transactions[i].getAmount());
                                newNetBookValue = lastNetBookValue.add(transactions[i].getAmount());
                            }
                            BigDecimal newMonthlyDepreciation = BigDecimal.ZERO;
                            newMonthlyDepreciation = area.getUsefullLifeInMonth() > 0 && calcMethod.getBaseForCalc().equals(BaseCalcEnum.BCE_PURCHASE_VAL) ? DepreciationCalculation.getNewMonthlyDepreciation((Boolean)true, (BigDecimal)newAcquistionValue, (FixedAssetArea)area, (short)0) : DepreciationCalculation.getNewMonthlyDepreciation((Boolean)false, (BigDecimal)newNetBookValue, (FixedAssetArea)area, (short)0);
                            BigDecimal newResLifeInMonthBD = BigDecimal.ZERO;
                            if (BigDecimalMapper.compareTo((BigDecimal)newNetBookValue, (BigDecimal)newMonthlyDepreciation) > 0 && BigDecimalMapper.compareTo((BigDecimal)newMonthlyDepreciation, (BigDecimal)BigDecimal.ZERO) > 0) {
                                newResLifeInMonthBD = newNetBookValue.divide(newMonthlyDepreciation, 0, RoundingMode.UP);
                            }
                            int newResLifeInMonth = newResLifeInMonthBD.intValue();
                            int diffMonth = FixedAssetArea.calculateLifeInMonth((Date)area.getDeprStartDate(), (Date)transactions[i].getProcessingDate());
                            int newLifeInMonth = newResLifeInMonth + diffMonth;
                            transactions[i].setIncreasePeriodInMonth((short)(newLifeInMonth - area.getUsefullLifeInMonth()));
                            transactions[i].makeSaveable();
                            area.setResidualLifeInMonth(newResLifeInMonth);
                            area.setUsefullLifeInMonth(newLifeInMonth);
                            area.setPeriodInYears((short)(area.getUsefullLifeInMonth() / 12));
                            area.setPeriodInMonth((short)(area.getUsefullLifeInMonth() - area.getPeriodInYears() * 12));
                            int days2 = FixedAssetArea.calculateLifeInDays((Date)fixedAsset.getAcquisitionDate(), (Date)area.getDeprStartDate(), (int)area.getUsefullLifeInMonth());
                            area.setUsefullLifeInDays(days2);
                            if (days2 > 0 && area.getProcessingDate() != null) {
                                area.setResLifeInDays(FixedAssetArea.calculateResLifeInDays((Date)DateHelper.tomorrow((Date)area.getProcessingDate()), (int)area.getResidualLifeInMonth()));
                            } else {
                                area.setResLifeInDays(days2);
                            }
                            area.makeSaveable();
                        }
                    } else if (transactions[i].getIncreasePeriodInMonth() != 0) {
                        short newResMonth = newMonth = transactions[i].getIncreasePeriodInMonth();
                        short diffMonth = (short)FixedAssetArea.calculateLifeInMonth((Date)area.getDeprStartDate(), (Date)area.getProcessingDate());
                        short diffMonthLastDepr = (short)FixedAssetArea.calculateLifeInMonth((Date)area.getDeprStartDate(), (Date)area.getLastDeprDate());
                        if (transactionStruct[i].isCancellation) {
                            if (diffMonth > 0) {
                                if (transactions[i].getIncreaseLifeType() == IncreaseLifeEnum.ILE_REMAINING_LIFE || transactions[i].getDeprArea().getCalcRemLifeForPostCapitalization()) {
                                    newResMonth = (short)(area.getResidualLifeInMonth() - transactions[i].getIncreasePeriodInMonth());
                                    if (newResMonth < 0) {
                                        newResMonth = 0;
                                    }
                                    newMonth = newResMonth == 0 ? diffMonthLastDepr : (short)(area.getUsefullLifeInMonth() - transactions[i].getIncreasePeriodInMonth());
                                } else {
                                    newMonth = (short)(area.getUsefullLifeInMonth() - transactions[i].getIncreasePeriodInMonth());
                                    newResMonth = (short)(newMonth - diffMonth);
                                    if (newResMonth < 0) {
                                        newResMonth = 0;
                                    }
                                }
                            } else {
                                newMonth = (short)(area.getUsefullLifeInMonth() - transactions[i].getIncreasePeriodInMonth());
                                newResMonth = (short)(area.getResidualLifeInMonth() - transactions[i].getIncreasePeriodInMonth());
                            }
                        } else if (diffMonth > 0) {
                            if (transactions[i].getIncreaseLifeType() == IncreaseLifeEnum.ILE_REMAINING_LIFE) {
                                if (area.getResidualLifeInMonth() > 0) {
                                    newMonth = (short)(area.getUsefullLifeInMonth() + transactions[i].getIncreasePeriodInMonth());
                                    newResMonth = (short)(area.getResidualLifeInMonth() + transactions[i].getIncreasePeriodInMonth());
                                } else {
                                    newMonth = (short)(diffMonth + transactions[i].getIncreasePeriodInMonth());
                                    newResMonth = (short)(area.getResidualLifeInMonth() + transactions[i].getIncreasePeriodInMonth());
                                }
                            } else {
                                newMonth = (short)(area.getUsefullLifeInMonth() + transactions[i].getIncreasePeriodInMonth());
                                newResMonth = (short)(newMonth - diffMonth);
                            }
                        } else {
                            newMonth = (short)(area.getUsefullLifeInMonth() + transactions[i].getIncreasePeriodInMonth());
                            newResMonth = (short)(area.getResidualLifeInMonth() + transactions[i].getIncreasePeriodInMonth());
                        }
                        area.setResidualLifeInMonth((int)newResMonth);
                        area.setUsefullLifeInMonth((int)newMonth);
                        area.setPeriodInYears((short)(newMonth / 12));
                        area.setPeriodInMonth((short)(newMonth - area.getPeriodInYears() * 12));
                        days = FixedAssetArea.calculateLifeInDays((Date)fixedAsset.getAcquisitionDate(), (Date)area.getDeprStartDate(), (int)newMonth);
                        area.setUsefullLifeInDays(days);
                        if (days > 0 && area.getProcessingDate() != null) {
                            area.setResLifeInDays(FixedAssetArea.calculateResLifeInDays((Date)DateHelper.tomorrow((Date)area.getProcessingDate()), (int)newResMonth));
                        } else {
                            area.setResLifeInDays(days);
                        }
                        area.makeSaveable();
                    }
                } else if (transactions[i].getTransactionEnum().value() == 26) {
                    if (area == null) {
                        area = FixedAssetArea.getFixedAssetArea((FixedAsset)fixedAsset, (DepreciationArea)transactions[i].getDeprArea());
                    }
                    if (area != null && area.getStatus().value() == 7 || area.getStatus().value() == 3 || area.getStatus().value() == 8 || area.getStatus().value() == 1 || area.getStatus().value() == 5) {
                        if (transactionStruct[i].oidDepreciationMethod.discriminator()) {
                            throw FixedAssetTransactionExceptionMapper.makeDeprMethodNotAllowedDomainException((String)"FixedAssetTransaction.check");
                        }
                        if (transactions[i].getIncreasePeriodInMonth() != 0) {
                            throw FixedAssetTransactionExceptionMapper.makeUsefulLifeNotAllowedDomainException((String)"FixedAssetTransaction.check");
                        }
                    }
                    if (transactions[i].getIncreasePeriodInMonth() != 0) {
                        newMonth = 0;
                        short newResMonth = 0;
                        short diffMonth = (short)FixedAssetArea.calculateLifeInMonth((Date)area.getDeprStartDate(), (Date)area.getProcessingDate());
                        short diffMonthLastDepr = (short)FixedAssetArea.calculateLifeInMonth((Date)area.getDeprStartDate(), (Date)area.getLastDeprDate());
                        if (transactionStruct[i].isCancellation) {
                            newMonth = (short)transactions[i].getLifeInMonth();
                            newResMonth = (short)transactions[i].getResLifeInMonth();
                        } else {
                            newResMonth = newMonth = transactions[i].getIncreasePeriodInMonth();
                            if (diffMonth > 0) {
                                newMonth = (short)(diffMonth + transactions[i].getIncreasePeriodInMonth());
                                newResMonth = transactions[i].getIncreasePeriodInMonth();
                            } else {
                                newMonth = transactions[i].getIncreasePeriodInMonth();
                                newResMonth = transactions[i].getIncreasePeriodInMonth();
                            }
                            transactions[i].setLifeInMonth(area.getUsefullLifeInMonth());
                            transactions[i].setResLifeInMonth(area.getResidualLifeInMonth());
                            transactions[i].makeSaveable();
                        }
                        area.setResidualLifeInMonth((int)newResMonth);
                        area.setUsefullLifeInMonth((int)newMonth);
                        area.setPeriodInYears((short)(newMonth / 12));
                        area.setPeriodInMonth((short)(newMonth - area.getPeriodInYears() * 12));
                        days = FixedAssetArea.calculateLifeInDays((Date)fixedAsset.getAcquisitionDate(), (Date)area.getDeprStartDate(), (int)newMonth);
                        area.setUsefullLifeInDays(days);
                        if (days > 0 && area.getProcessingDate() != null) {
                            area.setResLifeInDays(FixedAssetArea.calculateResLifeInDays((Date)DateHelper.tomorrow((Date)area.getProcessingDate()), (int)newResMonth));
                        } else {
                            area.setResLifeInDays(days);
                        }
                        area.makeSaveable();
                    }
                    if (!transactionStruct[i].isCancellation) {
                        transactions[i].setDepResValueOld(area.getDepResValue() != null ? area.getDepResValue() : BigDecimal.ZERO);
                        area.setDepResValue(transactions[i].getDepResValueNew() != null ? transactions[i].getDepResValueNew() : BigDecimal.ZERO);
                    } else {
                        area.setDepResValue(transactions[i].getDepResValueOld() != null ? transactions[i].getDepResValueOld() : BigDecimal.ZERO);
                    }
                }
            }
            if ((transactions[i].getTransactionEnum().value() == 3 || transactions[i].getTransactionEnum().value() == 14 || transactions[i].getTransactionEnum().value() == 15 || transactions[i].getTransactionEnum().value() == 26) && transactions[i].getCalcMethod() != null) {
                if (area == null) {
                    area = FixedAssetArea.getFixedAssetArea((FixedAsset)fixedAsset, (DepreciationArea)transactions[i].getDeprArea());
                }
                CalcMethod calcMethod = transactions[i].getCalcMethod();
                if (!transactions[i].getIsCancelation()) {
                    if (!StringMapper.isNullString((String)area.getOidDepreciationMethod())) {
                        transactions[i].setDepreciationMethodOld(CalcMethodPersistencyManager.getCalcMethod((String)area.getOidDepreciationMethod()));
                    }
                    area.setOidDepreciationMethod(calcMethod.getObjectid());
                } else if (transactions[i].getDepreciationMethodOld() != null) {
                    calcMethod = transactions[i].getDepreciationMethodOld();
                    area.setOidDepreciationMethod(calcMethod.getObjectid());
                }
                if (calcMethod.getMethodTypeEnum().value() == 0) {
                    BigDecimal deprPercentage = ((DepreciationMethodData)calcMethod).getPercentage();
                    if (BigDecimalMapper.isZeroOrNull((BigDecimal)deprPercentage) && area.getUsefullLifeInMonth() > 0 && BigDecimalMapper.compareTo((BigDecimal)(deprPercentage = new BigDecimal(100).multiply(new BigDecimal(12)).divide(new BigDecimal(area.getUsefullLifeInMonth()), 2, RoundingMode.HALF_EVEN)), (BigDecimal)new BigDecimal("100.00")) > 0) {
                        deprPercentage = new BigDecimal(100);
                    }
                    area.setDepreciationPercent(deprPercentage);
                }
                area.makeSaveable();
            }
            if (transactions[i].getTransactionEnum().value() != 2 && transactions[i].getTransactionEnum().value() != 23 && transactions[i].getTransactionEnum().value() != 3 || transactions[i].getPersonalAccount() == null || !transactions[i].getDeprArea().getBelongsToBalanceSheet() || transactions[i].getIsCancelation()) continue;
            ArrayList<PersonalAccount> faPersonalAccounts = new ArrayList<PersonalAccount>(Arrays.asList(fixedAsset.getSupplAccounts()));
            if (faPersonalAccounts == null || faPersonalAccounts.isEmpty()) {
                PersonalAccount[] persAccount = new PersonalAccount[]{transactions[i].getPersonalAccount()};
                fixedAsset.setSupplAccounts(persAccount);
                fixedAsset.makeSaveable();
                continue;
            }
            Boolean supplExists = false;
            for (int j = 0; j < faPersonalAccounts.size(); ++j) {
                if (!((PersonalAccount)faPersonalAccounts.get(j)).equals((Object)transactions[i].getPersonalAccount())) continue;
                supplExists = true;
            }
            if (supplExists.booleanValue()) continue;
            faPersonalAccounts.add(transactions[i].getPersonalAccount());
            PersonalAccount[] faPersonalAccountsNew = new PersonalAccount[faPersonalAccounts.size()];
            fixedAsset.setSupplAccounts(faPersonalAccounts.toArray(faPersonalAccountsNew));
            fixedAsset.makeSaveable();
        }
        if (transactionStruct[0].transactionType.value() == 20 && !transactionStruct[0].isCancellation) {
            fixedAsset.setQuantity(BigDecimalMapper.toString((BigDecimal)BigDecimal.ZERO));
            fixedAsset.makeSaveable();
        }
        if (!(transactionStruct[0].transactionType.value() != 5 && transactionStruct[0].transactionType.value() != 25 && transactionStruct[0].transactionType.value() != 6 || transactionStruct[0].isCancellation)) {
            FixedAssetData fixedAssetTransferTo = (FixedAssetData)FixedAssetPersistencyManager.getFixedAssetWithCache((String)transactionStruct[0].oidFixedAsset_TransferTo.objectId());
            FixedAssetTransaction[] transactionTransferTo = new FixedAssetTransaction[transactionStruct.length];
            Date processingDate = DateMapper.toDate((String)transactionStruct[0].processingDate);
            if (DateHelper.before((Date)processingDate, (Date)DateHelper.getFirstDayOfMonth((Date)fixedAssetTransferTo.getAcquisitionDate()))) {
                throw FixedAssetTransactionExceptionMapper.transferTransactionNotAllowedDomainException((String)"FixedAssetTransaction.check");
            }
            sameIdentity = false;
            for (int i = 0; i < transactionStruct.length; ++i) {
                transactionTransferTo[i] = new FixedAssetTransaction();
                listTransactToFA.add(transactionTransferTo[i]);
                FixedAssetTransactionMapper.fillFixedAssetTransaction((FixedAssetTransaction)transactionTransferTo[i], (FixedAssetTransactionStruct)transactionStruct[i], (FixedAssetData)fixedAssetTransferTo);
                if (!sameIdentity) {
                    barCode = String.valueOf(transactions[i].getTransactionSeqNumber());
                    sameIdentity = true;
                }
                transactionTransferTo[i].setBarcodeNumber(barCode);
                transactionTransferTo[i].setIsBooked(false);
                BigDecimal transactQuantity = BigDecimal.ZERO.setScale(2);
                if (transactionTransferTo[i].getIsQuantityFor_ToFixedAsset()) {
                    transactQuantity = BigDecimalMapper.toBigDecimalZero((String)transactionTransferTo[i].getQuantity()).negate();
                }
                transactionTransferTo[i].setQuantity(BigDecimalMapper.toString((BigDecimal)transactQuantity));
                transactionTransferTo[i].setAmount(transactionTransferTo[i].getAmount().negate());
                transactionTransferTo[i].setCorrespondingTransaction(null);
                if (!transactionTransferTo[i].getDeprArea().getBelongsToBalanceSheet() || transactQuantity.compareTo(BigDecimalMapper.ZERO) == 0) continue;
                BigDecimal faQuantity = BigDecimalMapper.toBigDecimalZero((String)fixedAssetTransferTo.getQuantity());
                BigDecimal newQuantity = faQuantity.add(transactQuantity);
                fixedAssetTransferTo.setQuantity(BigDecimalMapper.toString((BigDecimal)newQuantity));
                if (StringMapper.isNullString((String)fixedAssetTransferTo.getOidQuantityUnit())) {
                    fixedAssetTransferTo.setOidQuantityUnit(transactionTransferTo[i].getQuantityUnit().getObjectid());
                }
                fixedAssetTransferTo.makeSaveable();
            }
        }
        if (transactFromAccountingStruct.discriminator()) {
            FixedAssetTransactionManager.updateTransactionFromAccounting(transactions, fixedAsset, transactFromAccountingStruct);
        }
        return transactions;
    }

    private static void updateTransactionFromAccounting(FixedAssetTransaction[] transactions, FixedAssetData fixedAsset, optFATransactionFromAccounting transactFromAccountingStruct) throws BusinessDomainException {
        FATransactionFromAccounting transactionFromAccounting = FATransactionFromAccountingPersistencyManager.getFATransactionFromAccounting((String)transactFromAccountingStruct.accTransaction().oidTs.objectid);
        FixedAssetTransaction transactionForBalanceSheetArea = FixedAssetTransaction.getTransactionForBelongsToBalanceSheetArea(transactions);
        BigDecimal remainingQuantity = BigDecimalMapper.toBigDecimalZero((String)transactionFromAccounting.getRemainingQuantity());
        BigDecimal quantity = BigDecimal.ZERO;
        if (transactionForBalanceSheetArea.getTransactionEnum().value() == 20 || transactionForBalanceSheetArea.getTransactionEnum().value() == 19) {
            if (BigDecimalMapper.compareTo((BigDecimal)transactionFromAccounting.getAmount(), (BigDecimal)BigDecimalMapper.ZERO) < 0) {
                transactionFromAccounting.setRemainingAmount(transactionFromAccounting.getRemainingAmount().subtract(transactionForBalanceSheetArea.getSalesAmount().negate()));
            } else {
                transactionFromAccounting.setRemainingAmount(transactionFromAccounting.getRemainingAmount().subtract(transactionForBalanceSheetArea.getSalesAmount()));
            }
            quantity = BigDecimalMapper.toBigDecimalZero((String)transactionForBalanceSheetArea.getQuantity());
            transactionFromAccounting.setRemainingQuantity(BigDecimalMapper.toString((BigDecimal)remainingQuantity.subtract(quantity)));
        } else {
            if (transactFromAccountingStruct.accTransaction().transactType.value() == 9) {
                if (BigDecimalMapper.compareTo((BigDecimal)transactionFromAccounting.getAmount(), (BigDecimal)BigDecimalMapper.ZERO) < 0 && BigDecimalMapper.compareTo((BigDecimal)transactionForBalanceSheetArea.getAmount(), (BigDecimal)BigDecimalMapper.ZERO) > 0) {
                    transactionFromAccounting.setRemainingAmount(transactionFromAccounting.getRemainingAmount().subtract(transactionFromAccounting.getAmount().negate()));
                } else {
                    transactionFromAccounting.setRemainingAmount(transactionFromAccounting.getRemainingAmount().subtract(transactionFromAccounting.getAmount()));
                }
                quantity = BigDecimalMapper.toBigDecimalZero((String)transactionFromAccounting.getQuantity());
            } else {
                if (BigDecimalMapper.compareTo((BigDecimal)transactionFromAccounting.getAmount(), (BigDecimal)BigDecimalMapper.ZERO) < 0 && BigDecimalMapper.compareTo((BigDecimal)transactionForBalanceSheetArea.getAmount(), (BigDecimal)BigDecimalMapper.ZERO) > 0) {
                    transactionFromAccounting.setRemainingAmount(transactionFromAccounting.getRemainingAmount().subtract(transactionForBalanceSheetArea.getAmount().negate()));
                } else if (BigDecimalMapper.compareTo((BigDecimal)transactionFromAccounting.getAmount(), (BigDecimal)BigDecimalMapper.ZERO) > 0 && BigDecimalMapper.compareTo((BigDecimal)transactionForBalanceSheetArea.getAmount(), (BigDecimal)BigDecimalMapper.ZERO) < 0 && transactionForBalanceSheetArea.getTransactionEnum().value() == 4) {
                    transactionFromAccounting.setRemainingAmount(transactionFromAccounting.getRemainingAmount().add(transactionForBalanceSheetArea.getAmount()));
                } else {
                    transactionFromAccounting.setRemainingAmount(transactionFromAccounting.getRemainingAmount().subtract(transactionForBalanceSheetArea.getAmount()));
                }
                quantity = BigDecimalMapper.toBigDecimalZero((String)transactionForBalanceSheetArea.getQuantity());
            }
            transactionFromAccounting.setRemainingQuantity(BigDecimalMapper.toString((BigDecimal)remainingQuantity.subtract(quantity)));
        }
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)transactionFromAccounting.getRemainingForeignAmount()) && transactionFromAccounting.getForeignCurrency() != null) {
            FixedAssetTransaction transactionForForeignArea;
            AssetaccountingSetup aaSetup = AssetaccountingSetup.getValidAssetaccountingSetup((AccountingCompany)fixedAsset.getAccountCompany());
            if (aaSetup != null) {
                aaSetup.getBaseCurrency();
            }
            if ((transactionForForeignArea = FixedAssetTransaction.getTransactionForForeignArea(transactions, transactionFromAccounting)) != null) {
                if (transactionForForeignArea.getTransactionEnum().value() == 20 || transactionForForeignArea.getTransactionEnum().value() == 19) {
                    if (BigDecimalMapper.compareTo((BigDecimal)transactionFromAccounting.getForeignAmount(), (BigDecimal)BigDecimalMapper.ZERO) < 0) {
                        transactionFromAccounting.setRemainingForeignAmount(transactionFromAccounting.getRemainingForeignAmount().subtract(transactionForForeignArea.getSalesAmount().negate()));
                    } else {
                        transactionFromAccounting.setRemainingForeignAmount(transactionFromAccounting.getRemainingForeignAmount().subtract(transactionForForeignArea.getSalesAmount()));
                    }
                } else if (transactFromAccountingStruct.accTransaction().transactType.value() == 9) {
                    if (BigDecimalMapper.compareTo((BigDecimal)transactionFromAccounting.getForeignAmount(), (BigDecimal)BigDecimalMapper.ZERO) < 0 && BigDecimalMapper.compareTo((BigDecimal)transactionForBalanceSheetArea.getAmount(), (BigDecimal)BigDecimalMapper.ZERO) > 0) {
                        transactionFromAccounting.setRemainingForeignAmount(transactionFromAccounting.getRemainingForeignAmount().subtract(transactionFromAccounting.getForeignAmount().negate()));
                    } else {
                        transactionFromAccounting.setRemainingForeignAmount(transactionFromAccounting.getRemainingForeignAmount().subtract(transactionFromAccounting.getForeignAmount()));
                    }
                } else if (BigDecimalMapper.compareTo((BigDecimal)transactionFromAccounting.getForeignAmount(), (BigDecimal)BigDecimalMapper.ZERO) < 0 && BigDecimalMapper.compareTo((BigDecimal)transactionForBalanceSheetArea.getAmount(), (BigDecimal)BigDecimalMapper.ZERO) > 0) {
                    transactionFromAccounting.setRemainingForeignAmount(transactionFromAccounting.getRemainingForeignAmount().subtract(transactionForForeignArea.getAmount().negate()));
                } else {
                    transactionFromAccounting.setRemainingForeignAmount(transactionFromAccounting.getRemainingForeignAmount().subtract(transactionForForeignArea.getAmount()));
                }
            }
        }
        TransactionStatusEnum transactionStatus = TransactionStatusEnum.TSE_NEW;
        if (transactionFromAccounting.getAmount().compareTo(transactionFromAccounting.getRemainingAmount()) != 0) {
            transactionStatus = transactionFromAccounting.getRemainingAmount().compareTo(BigDecimalMapper.ZERO) != 0 ? TransactionStatusEnum.TSE_INPROCESS : TransactionStatusEnum.TSE_FINISHED;
        }
        transactionFromAccounting.setTransactionStatus(transactionStatus);
        transactionFromAccounting.makeSaveable();
        if (transactionFromAccounting.getTransactionStatus() != TransactionStatusEnum.TSE_NEW) {
            transactionFromAccounting.getNominalLedgerEntry().getTransaction().makeSaveable();
            if (!transactionFromAccounting.getNominalLedgerEntry().getTransaction().getIsJournalized()) {
                transactionFromAccounting.getNominalLedgerEntry().getTransaction().journalize();
            }
        }
        AccountingCompany company = fixedAsset.getAccountCompany();
        AssetaccountingSetup aaSetup = AssetaccountingSetup.getValidAssetaccountingSetup((AccountingCompany)company);
        int postWithAnalysisCode = transactionForBalanceSheetArea.getDeprArea().getPostWithAnalysisCode(false);
        String analysisCode = postWithAnalysisCode > 0 ? fixedAsset.getAnalysisCodes()[postWithAnalysisCode - 1] : "";
        boolean offsetAccountDisExists = false;
        OffsetAccount[] offsetAccountsDis = null;
        if (aaSetup.getIsDisposalOffsetAcc()) {
            offsetAccountsDis = aaSetup.getDisposalOffsetAccounts();
        }
        boolean offsetAccountAddExists = false;
        OffsetAccount[] offsetAccountsAdd = null;
        if (aaSetup.getIsNewAddingOffsetAcc()) {
            offsetAccountsAdd = aaSetup.getNewAdditionOffsetAccounts();
        }
        if (transactionFromAccounting.getTransactionType().value() == 2 || transactionFromAccounting.getTransactionType().value() == 3) {
            if (transactions[0].getTransactionEnum().value() == 20 || transactions[0].getTransactionEnum().value() == 19) {
                if (!aaSetup.getIsDisposalOffsetAcc()) {
                    throw FixedAssetExceptionMapper.makeNoDisposalIntermediateAccountDomainException((String)fixedAsset.getCode(), (String)"FixedAssetTransactionManager.updateTransactionFromAccounting");
                }
                if (offsetAccountsDis != null) {
                    for (int i = 0; i < offsetAccountsDis.length; ++i) {
                        if (!offsetAccountsDis[i].getOffsetAccount().getObjectid().equals(transactionFromAccounting.getAssetAccount().getObjectid())) continue;
                        offsetAccountDisExists = true;
                    }
                }
                if (!offsetAccountDisExists) {
                    throw FixedAssetExceptionMapper.makeDisposalIntermediateAccountDomainException((String)fixedAsset.getCode(), (String)"FixedAssetTransactionManager.updateTransactionFromAccounting");
                }
                boolean postingType = false;
                BigDecimal amount = BigDecimalMapper.ZERO;
                NominalLedgerAccount account = null;
                NominalLedgerAccount contraAccount = null;
                amount = transactionForBalanceSheetArea.getSalesAmount();
                account = transactionFromAccounting.getAssetAccount();
                contraAccount = fixedAsset.getAssetAccount();
                FinancialYear acFinYear = FinancialYear.getFinancialYearByCode((AccountingCompany)company, (String)transactFromAccountingStruct.accTransaction().financialYear.code);
                if (acFinYear == null) {
                    LOGGER.debug("Financial Year = " + transactionFromAccounting.getFinancialYear().getCode());
                    acFinYear = transactionFromAccounting.getFinancialYear();
                }
                Accounting.singlePosting((AccountingCompany)company, (DepreciationArea)transactionForBalanceSheetArea.getDeprArea(), (Date)transactionForBalanceSheetArea.getTransactionDate(), (Date)transactionForBalanceSheetArea.getTransactionDate(), (Date)transactionForBalanceSheetArea.getDocumentDate(), (BigDecimal)amount, (NominalLedgerAccount)account, (NominalLedgerAccount)contraAccount, (String)analysisCode, (String)transactionForBalanceSheetArea.getPostingText(), (FinancialYear)acFinYear, null, (String)transactionForBalanceSheetArea.getReferenceNumber(), (FixedAssetData)((FixedAssetData)transactionForBalanceSheetArea.getFixedAsset()), (String[])transactionFromAccounting.getAnalysisCodes(), (int)0);
                transactionForBalanceSheetArea.makeSaveable();
            } else if (aaSetup.getIsNewAddingOffsetAcc()) {
                if (offsetAccountsAdd != null) {
                    for (int i = 0; i < offsetAccountsAdd.length; ++i) {
                        if (!offsetAccountsAdd[i].getOffsetAccount().getObjectid().equals(transactionFromAccounting.getAssetAccount().getObjectid())) continue;
                        offsetAccountAddExists = true;
                    }
                }
                if (!offsetAccountAddExists) {
                    throw FixedAssetExceptionMapper.makeAdditionIntermediateAccountDomainException((String)fixedAsset.getCode(), (String)"FixedAssetTransactionManager.updateTransactionFromAccounting");
                }
                boolean postingType = false;
                BigDecimal amount = BigDecimalMapper.ZERO;
                NominalLedgerAccount account = null;
                NominalLedgerAccount contraAccount = null;
                amount = transactionForBalanceSheetArea.getAmount();
                account = fixedAsset.getAssetAccount();
                contraAccount = transactionFromAccounting.getAssetAccount();
                FinancialYear acFinYear = FinancialYear.getFinancialYearByCode((AccountingCompany)company, (String)transactFromAccountingStruct.accTransaction().financialYear.code);
                if (acFinYear == null) {
                    LOGGER.debug("Financial Year = " + transactionFromAccounting.getFinancialYear().getCode());
                    acFinYear = transactionFromAccounting.getFinancialYear();
                }
                Accounting.singlePosting((AccountingCompany)company, (DepreciationArea)transactionForBalanceSheetArea.getDeprArea(), (Date)transactionForBalanceSheetArea.getTransactionDate(), (Date)transactionForBalanceSheetArea.getTransactionDate(), (Date)transactionForBalanceSheetArea.getDocumentDate(), (BigDecimal)amount, (NominalLedgerAccount)account, (NominalLedgerAccount)contraAccount, (String)analysisCode, (String)transactionForBalanceSheetArea.getPostingText(), (FinancialYear)acFinYear, null, (String)transactionForBalanceSheetArea.getReferenceNumber(), (FixedAssetData)((FixedAssetData)transactionForBalanceSheetArea.getFixedAsset()), (String[])transactionFromAccounting.getAnalysisCodes(), (int)0);
                transactionForBalanceSheetArea.makeSaveable();
            } else {
                FixedAssetData.checkAssetAccount((NominalLedgerAccount)fixedAsset.getAssetAccount(), (NominalLedgerAccount)transactionFromAccounting.getAssetAccount());
            }
        } else {
            if (!(aaSetup.getIsDisposalOffsetAcc() || transactions[0].getTransactionEnum().value() != 20 && transactions[0].getTransactionEnum().value() != 19)) {
                throw FixedAssetExceptionMapper.makeNoDisposalIntermediateAccountDomainException((String)fixedAsset.getCode(), (String)"FixedAssetTransactionManager.updateTransactionFromAccounting");
            }
            if (transactions[0].getTransactionEnum().value() == 20 || transactions[0].getTransactionEnum().value() == 19) {
                if (offsetAccountsDis != null) {
                    for (int i = 0; i < offsetAccountsDis.length; ++i) {
                        if (!offsetAccountsDis[i].getOffsetAccount().getObjectid().equals(transactionFromAccounting.getAssetAccount().getObjectid())) continue;
                        offsetAccountDisExists = true;
                    }
                }
                if (!offsetAccountDisExists) {
                    throw FixedAssetExceptionMapper.makeDisposalIntermediateAccountDomainException((String)fixedAsset.getCode(), (String)"FixedAssetTransactionManager.updateTransactionFromAccounting");
                }
                FinancialYear acFinYear = FinancialYear.getFinancialYearByCode((AccountingCompany)company, (String)transactFromAccountingStruct.accTransaction().financialYear.code);
                if (acFinYear == null) {
                    LOGGER.debug("Financial Year = " + transactionFromAccounting.getFinancialYear().getCode());
                    acFinYear = transactionFromAccounting.getFinancialYear();
                }
                boolean postingType = false;
                Accounting.singlePosting((AccountingCompany)company, (DepreciationArea)transactionForBalanceSheetArea.getDeprArea(), (Date)transactionForBalanceSheetArea.getTransactionDate(), (Date)transactionForBalanceSheetArea.getTransactionDate(), (Date)transactionForBalanceSheetArea.getDocumentDate(), (BigDecimal)transactionForBalanceSheetArea.getSalesAmount().negate(), (NominalLedgerAccount)fixedAsset.getAssetAccount(), (NominalLedgerAccount)transactionFromAccounting.getAssetAccount(), (String)analysisCode, (String)transactionForBalanceSheetArea.getPostingText(), (FinancialYear)acFinYear, null, (String)transactionForBalanceSheetArea.getReferenceNumber(), (FixedAssetData)((FixedAssetData)transactionForBalanceSheetArea.getFixedAsset()), (String[])transactionFromAccounting.getAnalysisCodes(), (int)0);
                transactionForBalanceSheetArea.makeSaveable();
            } else if (aaSetup.getIsNewAddingOffsetAcc()) {
                FinancialYear acFinYear;
                if (offsetAccountsAdd != null) {
                    for (int i = 0; i < offsetAccountsAdd.length; ++i) {
                        if (!offsetAccountsAdd[i].getOffsetAccount().getObjectid().equals(transactionFromAccounting.getAssetAccount().getObjectid())) continue;
                        offsetAccountAddExists = true;
                    }
                }
                if (!offsetAccountAddExists) {
                    throw FixedAssetExceptionMapper.makeAdditionIntermediateAccountDomainException((String)fixedAsset.getCode(), (String)"FixedAssetTransactionManager.updateTransactionFromAccounting");
                }
                NominalLedgerAccount account = null;
                NominalLedgerAccount contraAccount = null;
                BigDecimal postingAmount = BigDecimal.ZERO.setScale(2);
                if (transactionFromAccounting.getTransactionType().value() == 9) {
                    postingAmount = transactionFromAccounting.getAmount();
                    account = fixedAsset.getAssetAccount();
                    contraAccount = transactionFromAccounting.getAssetAccount();
                } else {
                    postingAmount = transactionForBalanceSheetArea.getAmount();
                    account = fixedAsset.getAssetAccount();
                    contraAccount = transactionFromAccounting.getAssetAccount();
                }
                if (BigDecimalMapper.compareTo((BigDecimal)transactionFromAccounting.getAmount(), (BigDecimal)BigDecimalMapper.ZERO) < 0 && BigDecimalMapper.compareTo((BigDecimal)transactionForBalanceSheetArea.getAmount(), (BigDecimal)BigDecimalMapper.ZERO) > 0 || BigDecimalMapper.compareTo((BigDecimal)transactionFromAccounting.getAmount(), (BigDecimal)BigDecimalMapper.ZERO) > 0 && BigDecimalMapper.compareTo((BigDecimal)transactionForBalanceSheetArea.getAmount(), (BigDecimal)BigDecimalMapper.ZERO) < 0 && transactionForBalanceSheetArea.getTransactionEnum().value() == 4) {
                    postingAmount = postingAmount.negate();
                }
                if ((acFinYear = FinancialYear.getFinancialYearByCode((AccountingCompany)company, (String)transactFromAccountingStruct.accTransaction().financialYear.code)) == null) {
                    LOGGER.debug("Financial Year = " + transactionFromAccounting.getFinancialYear().getCode());
                    acFinYear = transactionFromAccounting.getFinancialYear();
                }
                boolean postingType = false;
                Accounting.singlePosting((AccountingCompany)company, (DepreciationArea)transactionForBalanceSheetArea.getDeprArea(), (Date)transactionForBalanceSheetArea.getTransactionDate(), (Date)transactionForBalanceSheetArea.getTransactionDate(), (Date)transactionForBalanceSheetArea.getDocumentDate(), (BigDecimal)postingAmount, (NominalLedgerAccount)account, (NominalLedgerAccount)contraAccount, (String)analysisCode, (String)transactionForBalanceSheetArea.getPostingText(), (FinancialYear)acFinYear, null, (String)transactionForBalanceSheetArea.getReferenceNumber(), (FixedAssetData)((FixedAssetData)transactionForBalanceSheetArea.getFixedAsset()), (String[])transactionFromAccounting.getAnalysisCodes(), (int)0);
                transactionForBalanceSheetArea.makeSaveable();
                transactionForBalanceSheetArea.setIsBooked(true);
            } else {
                FixedAssetData.checkAssetAccount((NominalLedgerAccount)fixedAsset.getAssetAccount(), (NominalLedgerAccount)transactionFromAccounting.getAssetAccount());
            }
        }
    }

    public static void updateCorrespSettlementTransactionFromAccounting(FixedAssetData fixedAsset, FixedAssetTransaction FATransaction, FATransactionFromAccounting correspTransactionFromAccounting) throws BusinessDomainException {
        correspTransactionFromAccounting.setRemainingAmount(correspTransactionFromAccounting.getRemainingAmount().subtract(correspTransactionFromAccounting.getAmount()));
        TransactionStatusEnum transactionStatus = TransactionStatusEnum.TSE_NEW;
        if (correspTransactionFromAccounting.getAmount().compareTo(correspTransactionFromAccounting.getRemainingAmount()) != 0) {
            transactionStatus = correspTransactionFromAccounting.getRemainingAmount().compareTo(BigDecimalMapper.ZERO) != 0 ? TransactionStatusEnum.TSE_INPROCESS : TransactionStatusEnum.TSE_FINISHED;
        }
        correspTransactionFromAccounting.setTransactionStatus(transactionStatus);
        correspTransactionFromAccounting.makeSaveable();
        AccountingCompany company = fixedAsset.getAccountCompany();
        AssetaccountingSetup aaSetup = AssetaccountingSetup.getValidAssetaccountingSetup((AccountingCompany)company);
        if (aaSetup.getIsNewAddingOffsetAcc()) {
            OffsetAccount[] offsetAccounts = aaSetup.getNewAdditionOffsetAccounts();
            boolean offsetAccountExists = false;
            for (int i = 0; i < offsetAccounts.length; ++i) {
                if (!offsetAccounts[i].getOffsetAccount().getObjectid().equals(correspTransactionFromAccounting.getAssetAccount().getObjectid())) continue;
                offsetAccountExists = true;
            }
            if (!offsetAccountExists) {
                throw FixedAssetExceptionMapper.makeAdditionIntermediateAccountDomainException((String)fixedAsset.getCode(), (String)"FixedAssetTransactionManager.updateTransactionFromAccounting");
            }
            LOGGER.debug("Financial Year = " + correspTransactionFromAccounting.getFinancialYear().getCode());
            FinancialYear acFinYear = correspTransactionFromAccounting.getFinancialYear();
            if (acFinYear == null) {
                acFinYear = FinancialYear.getFinancialYearByDate((AccountingCompany)company, (Date)correspTransactionFromAccounting.getTransactionDate());
            }
            boolean postingType = false;
            Accounting.singlePosting((AccountingCompany)company, (DepreciationArea)FATransaction.getDeprArea(), (Date)FATransaction.getTransactionDate(), (Date)FATransaction.getTransactionDate(), (Date)FATransaction.getDocumentDate(), (BigDecimal)correspTransactionFromAccounting.getAmount(), (NominalLedgerAccount)fixedAsset.getAssetAccount(), (NominalLedgerAccount)correspTransactionFromAccounting.getAssetAccount(), (String)"", (String)correspTransactionFromAccounting.getPostingText(), (FinancialYear)acFinYear, null, (String)correspTransactionFromAccounting.getReferenceNumber(), (FixedAssetData)((FixedAssetData)FATransaction.getFixedAsset()), null, (int)0);
        } else {
            FixedAssetData.checkAssetAccount((NominalLedgerAccount)fixedAsset.getAssetAccount(), (NominalLedgerAccount)correspTransactionFromAccounting.getAssetAccount());
        }
    }

    public static FixedAssetTransaction[] manualDepreciationProcessing(String oidFixedAsset, NewManualDepreciationStruct manualDepreciationsStruct, FAFinancialYear financialYear) throws BusinessDomainException {
        FixedAssetArea faArea;
        FixedAssetData fixedAsset = (FixedAssetData)FixedAssetPersistencyManager.getFixedAssetWithCache((String)oidFixedAsset);
        ExistingDepreciationStruct[] manDeprecStruct = manualDepreciationsStruct.manualDepreciations;
        ArrayList<FixedAssetTransaction> newTransactList = new ArrayList<FixedAssetTransaction>();
        FAFinancialPeriod[] periods = financialYear.getFinancialPeriods();
        Date disposalDate = null;
        DepreciationArea deprArea = DepreciationAreaPersistencyManager.getDepreciationArea((String)manualDepreciationsStruct.manualDeprTransaction.area.oidTs.objectid);
        if (deprArea != null && (faArea = FixedAssetArea.getFixedAssetArea((FixedAsset)fixedAsset, (DepreciationArea)deprArea)) != null) {
            disposalDate = faArea.getRetirementDate();
        }
        for (int i = 0; i < manDeprecStruct.length; ++i) {
            BigDecimal oldDeprAmount = BigDecimalMapper.toBigDecimalZero((String)manDeprecStruct[i].existingDeprAmount);
            BigDecimal newDeprAmount = BigDecimalMapper.toBigDecimalZero((String)manDeprecStruct[i].newDeprAmount);
            if (!StringMapper.isNullString((String)manDeprecStruct[i].oidExistingTransaction)) {
                FixedAssetTransaction canceledTransaction;
                if (manDeprecStruct[i].isTransaction) {
                    if (oldDeprAmount.compareTo(newDeprAmount) != 0) {
                        canceledTransaction = FixedAssetTransactionPersistencyManager.getFixedAssetTransaction((String)manDeprecStruct[i].oidExistingTransaction);
                        FixedAssetTransactionManager.createCancelationTransaction(canceledTransaction);
                    }
                } else {
                    canceledTransaction = FixedAssetTransactionPersistencyManager.getFixedAssetTransaction((String)manDeprecStruct[i].oidExistingTransaction);
                    FixedAssetTransactionManager.createCancelationTransaction(canceledTransaction);
                }
            }
            if (!manDeprecStruct[i].isTransaction || oldDeprAmount.compareTo(newDeprAmount) == 0 && !StringMapper.isNullString((String)manDeprecStruct[i].oidExistingTransaction) || disposalDate != null && !DateHelper.beforeOrEqual((Date)periods[manDeprecStruct[i].month.value()].getValidUntil(), (Date)DateHelper.getLastDayOfMonth((Date)disposalDate))) continue;
            FixedAssetTransaction transaction = new FixedAssetTransaction();
            newTransactList.add(transaction);
            FixedAssetTransactionMapper.fillFixedAssetTransaction((FixedAssetTransaction)transaction, (FixedAssetTransactionStruct)manualDepreciationsStruct.manualDeprTransaction, (FixedAssetData)fixedAsset);
            transaction.setAmount(newDeprAmount);
            transaction.setProcessingDate(periods[manDeprecStruct[i].month.value()].getValidUntil());
            transaction.makeSaveable();
        }
        FixedAssetTransaction[] newTransactions = new FixedAssetTransaction[newTransactList.size()];
        newTransactList.toArray(newTransactions);
        return newTransactions;
    }

    private static void createCancelationTransaction(FixedAssetTransaction canceledTransaction) throws BusinessDomainException {
        canceledTransaction.makeSaveable();
        if (canceledTransaction.getIsBooked()) {
            canceledTransaction.setIsCanceled(true);
            FixedAssetTransaction cancelationTransaction = new FixedAssetTransaction(canceledTransaction);
            cancelationTransaction.setIsBooked(false);
            cancelationTransaction.setIsCanceled(false);
            cancelationTransaction.setIsCancelation(true);
            cancelationTransaction.setAmount(cancelationTransaction.getAmount().negate());
        } else {
            FASinglePostingPersistencyManager.removeOIDTransaction((FixedAssetTransaction)canceledTransaction);
            canceledTransaction.destroy();
        }
    }

    public static void updateDepreciationCalculation(FixedAssetTransaction[] transaction, FixedAssetData fixedAsset, boolean isCancellation) throws BusinessDomainException {
        LOGGER.debug("updateDepreciationCalculation(...)");
        AccountingCompany company = fixedAsset.getAccountCompany();
        DepreciationArea deprArea = null;
        FixedAssetArea faArea = null;
        boolean isTransactTypeIsDisposalOrRepost = false;
        boolean isTransactTypeIsFullDisposal = false;
        List transactCache = null;
        Arrays.sort(transaction, FixedAssetTransaction.getFATComparator());
        for (int i = 0; i < transaction.length; ++i) {
            deprArea = transaction[i].getDeprArea();
            FixedAssetArea faa = fixedAsset.getFixedAssetArea(deprArea);
            if (faArea == null || !faa.getObjectid().equals(faArea.getObjectid())) {
                faArea = faa;
                transactCache = null;
            }
            isTransactTypeIsDisposalOrRepost = false;
            if (transaction[i].getTransactionEnum().value() == 20 || transaction[i].getTransactionEnum().value() == 19 || transaction[i].getTransactionEnum().value() == 6 || transaction[i].getTransactionEnum().value() == 5 || transaction[i].getTransactionEnum().value() == 25 || transaction[i].getTransactionEnum().value() == 4) {
                isTransactTypeIsDisposalOrRepost = true;
            }
            if (!(faArea.getLastDeprDate() != null && DateHelper.beforeOrEqual((Date)transaction[i].getProcessingDate(), (Date)faArea.getLastDeprDate()) || faArea.getLastInterestCalcDate() != null && deprArea.getImputedInterest() && DateHelper.beforeOrEqual((Date)transaction[i].getProcessingDate(), (Date)faArea.getLastInterestCalcDate())) && !isTransactTypeIsDisposalOrRepost) continue;
            Date deprUntil = faArea.getLastDeprDate();
            if (deprArea.getImputedInterest() && faArea.getLastInterestCalcDate() != null && deprUntil != null && DateHelper.after((Date)faArea.getLastInterestCalcDate(), (Date)deprUntil)) {
                deprUntil = faArea.getLastInterestCalcDate();
            }
            if (transaction[i].getTransactionEnum().value() == 20 || transaction[i].getTransactionEnum().value() == 6) {
                isTransactTypeIsFullDisposal = true;
                if (faArea.getLastDeprDate() != null && DateHelper.before((Date)transaction[i].getProcessingDate(), (Date)faArea.getLastDeprDate()) && DateHelper.before((Date)faArea.getLastDeprDate(), (Date)DateHelper.getLastDayOfMonth((Date)faArea.getLastDeprDate()))) {
                    deprUntil = DateHelper.getLastDayOfMonth((Date)faArea.getLastDeprDate());
                }
            }
            if (isTransactTypeIsDisposalOrRepost && faArea.getLastDeprDate() != null && DateHelper.after((Date)transaction[i].getProcessingDate(), (Date)DateHelper.getLastDayOfMonth((Date)faArea.getLastDeprDate()))) {
                deprUntil = DateHelper.getLastDayOfMonth((Date)transaction[i].getProcessingDate());
            }
            if (faArea.getLastDeprDate() != null && DateHelper.before((Date)transaction[i].getProcessingDate(), (Date)faArea.getLastDeprDate())) {
                faArea.setLastDeprDate(DateHelper.yesterday((Date)DateHelper.getFirstDayOfMonth((Date)transaction[i].getProcessingDate())));
                faArea.setResidualLifeInMonth(FixedAssetArea.calculateResidualLifeInMonth((int)faArea.getUsefullLifeInMonth(), (Date)faArea.getDeprStartDate(), (Date)faArea.getLastDeprDate()));
            }
            if (faArea.getLastInterestCalcDate() != null && DateHelper.before((Date)transaction[i].getProcessingDate(), (Date)faArea.getLastInterestCalcDate())) {
                faArea.setLastInterestCalcDate(DateHelper.yesterday((Date)DateHelper.getFirstDayOfMonth((Date)transaction[i].getProcessingDate())));
            }
            DepreciationCalculation deprCalc = new DepreciationCalculation(company, fixedAsset, deprArea, faArea, company.getDefaultLanguage(), DepreciationFunctionEnum.DEFE_CALCULATION, deprUntil, null, transaction[i].getDocumentDate(), true, isTransactTypeIsDisposalOrRepost, false, null, null, false, isTransactTypeIsFullDisposal, isCancellation);
            if (transactCache == null) {
                transactCache = deprCalc.buildTransactionsCache(null);
            }
            deprCalc.depreciation(null, transactCache, true);
        }
    }

    public static void updateDepreciations(FixedAssetTransaction transaction, FixedAssetArea faArea) throws BusinessDomainException {
        LOGGER.debug("updateDepreciations(...)");
        AccountingCompany company = faArea.getFixedAsset().getAccountCompany();
        DepreciationArea deprArea = null;
        boolean isTransactTypeIsDisposalOrRepost = false;
        List transactCache = null;
        deprArea = transaction.getDeprArea();
        if (faArea.getLastDeprDate() != null && DateHelper.beforeOrEqual((Date)transaction.getProcessingDate(), (Date)faArea.getLastDeprDate()) || faArea.getLastInterestCalcDate() != null && deprArea.getImputedInterest() && DateHelper.beforeOrEqual((Date)transaction.getProcessingDate(), (Date)faArea.getLastInterestCalcDate())) {
            Date deprUntil = faArea.getLastDeprDate();
            if (deprArea.getImputedInterest() && faArea.getLastInterestCalcDate() != null && deprUntil != null && DateHelper.after((Date)faArea.getLastInterestCalcDate(), (Date)deprUntil)) {
                deprUntil = faArea.getLastInterestCalcDate();
            }
            if (faArea.getLastDeprDate() != null && DateHelper.before((Date)transaction.getProcessingDate(), (Date)faArea.getLastDeprDate())) {
                faArea.setLastDeprDate(DateHelper.yesterday((Date)DateHelper.getFirstDayOfMonth((Date)transaction.getProcessingDate())));
                faArea.setResidualLifeInMonth(FixedAssetArea.calculateResidualLifeInMonth((int)faArea.getUsefullLifeInMonth(), (Date)faArea.getDeprStartDate(), (Date)faArea.getLastDeprDate()));
            }
            if (faArea.getLastInterestCalcDate() != null && DateHelper.before((Date)transaction.getProcessingDate(), (Date)faArea.getLastInterestCalcDate())) {
                faArea.setLastInterestCalcDate(DateHelper.yesterday((Date)DateHelper.getFirstDayOfMonth((Date)transaction.getProcessingDate())));
            }
            DepreciationCalculation deprCalc = new DepreciationCalculation(company, (FixedAssetData)faArea.getFixedAsset(), deprArea, faArea, company.getDefaultLanguage(), DepreciationFunctionEnum.DEFE_CALCULATION, deprUntil, null, transaction.getDocumentDate(), true, false, false, null, null, false, false, false);
            if (transactCache == null) {
                transactCache = deprCalc.buildTransactionsCache(null);
            }
            deprCalc.depreciation(null, transactCache, true);
        }
    }

    public static void createDepreciations(FixedAssetTransaction transaction, FixedAssetArea faArea) throws BusinessDomainException {
        FAFinancialYear finYear;
        LOGGER.debug("calculateDepreciations(...)");
        AccountingCompany company = faArea.getFixedAsset().getAccountCompany();
        DepreciationArea deprArea = transaction.getDeprArea();
        List transactCache = null;
        Date deprUntil = DateHelper.getLastDayOfMonth((Date)DateHelper.yesterday((Date)DateHelper.getFirstDayOfMonth((Date)transaction.getProcessingDate())));
        if (DateHelper.after((Date)transaction.getProcessingDate(), (Date)DateHelper.getFirstDayOfMonth((Date)transaction.getProcessingDate()))) {
            deprUntil = DateHelper.getLastDayOfMonth((Date)transaction.getProcessingDate());
        }
        if ((finYear = FAFinancialYear.getFAFinancialYearForDate((AccountingCompany)faArea.getFixedAsset().getAccountCompany(), (Date)deprUntil)) == null) {
            deprUntil = DateHelper.getLastDayOfMonth((Date)transaction.getProcessingDate());
        }
        DepreciationCalculation deprCalc = new DepreciationCalculation(company, (FixedAssetData)faArea.getFixedAsset(), deprArea, faArea, company.getDefaultLanguage(), DepreciationFunctionEnum.DEFE_CALCULATION, deprUntil, null, transaction.getDocumentDate(), true, false, false, null, null, false, false, false);
        if (transactCache == null) {
            transactCache = deprCalc.buildTransactionsCache(null);
        }
        deprCalc.depreciation(null, transactCache, true);
        if (faArea.getLastDeprDate() != null && DateHelper.before((Date)faArea.getLastDeprDate(), (Date)transaction.getProcessingDate())) {
            faArea.setLastDeprDate(DateHelper.getLastDayOfMonth((Date)transaction.getProcessingDate()));
            faArea.setResidualLifeInMonth(FixedAssetArea.calculateResidualLifeInMonth((int)faArea.getUsefullLifeInMonth(), (Date)faArea.getDeprStartDate(), (Date)faArea.getLastDeprDate()));
        }
        if (faArea.getLastInterestCalcDate() != null && DateHelper.before((Date)faArea.getLastInterestCalcDate(), (Date)transaction.getProcessingDate())) {
            faArea.setLastInterestCalcDate(DateHelper.getLastDayOfMonth((Date)transaction.getProcessingDate()));
        }
    }

    public static FixedAssetTransaction updateTransferToTransactions(FixedAssetTransaction[] transaction, FixedAssetData fixedAsset, List<FixedAssetTransaction> listTransactToFA) {
        LOGGER.debug("updateTransferToTransactions(...)");
        FixedAssetTransaction transactTransferTo = null;
        if (!listTransactToFA.isEmpty()) {
            for (int i = 0; i < transaction.length; ++i) {
                DepreciationArea deprArea;
                FixedAssetArea faArea;
                DepreciationCalculation deprCalc;
                List transactCache;
                DepreciationCalculationHelper dch;
                if (transaction[i].getTransactionEnum().value() != 5 && transaction[i].getTransactionEnum().value() != 25 && transaction[i].getTransactionEnum().value() != 6 || (dch = DepreciationCalculation.getDeprCalcHelperForTransactOID((List)(transactCache = (deprCalc = new DepreciationCalculation(faArea = fixedAsset.getFixedAssetArea(deprArea = transaction[i].getDeprArea()), DepreciationFunctionEnum.DEFE_CALCULATION)).buildTransactionsCache(null)), (String)transaction[i].getObjectid())) == null) continue;
                String oidTransactToFa = "";
                for (FixedAssetTransaction transactToFa : listTransactToFA) {
                    String oidDeprArea = transactToFa.getDeprArea().getObjectid();
                    if (!oidDeprArea.equals(transaction[i].getDeprArea().getObjectid())) continue;
                    oidTransactToFa = transactToFa.getObjectid();
                }
                if (StringMapper.isNullString((String)oidTransactToFa) || (transactTransferTo = FixedAssetTransactionPersistencyManager.getFixedAssetTransaction((String)oidTransactToFa)) == null) continue;
                transactTransferTo.makeSaveable();
                transaction[i].reload();
                transactTransferTo.setAccumDepr(transaction[i].getAccumDepr());
                transactTransferTo.setAccumSpecDepr(transaction[i].getAccumSpecDepr());
                transactTransferTo.setAccumGrant(transaction[i].getAccumGrant());
                transactTransferTo.setAccumWriteUp(transaction[i].getAccumWriteUp());
                transactTransferTo.setAccumWriteDown(transaction[i].getAccumWriteDown());
            }
        }
        return transactTransferTo;
    }

    public static void updateCorrespAdditions(FixedAssetTransaction[] transactions) throws BusinessDomainException {
        LOGGER.debug("updateCorrespAdditions(...)");
        for (int i = 0; i < transactions.length; ++i) {
            FixedAssetTransaction corrTransaction;
            if (transactions[i].getTransactionEnum().value() != 5 || transactions[i].getCorrespondingTransaction() == null || (corrTransaction = transactions[i].getCorrespondingTransaction()) == null) continue;
            corrTransaction.makeSaveable();
            corrTransaction.setCorrespondingTransaction(transactions[i]);
        }
    }
}

