/*
 * Decompiled with CFR 0.152.
 */
package com.varial.assetaccounting.domain.fixedasset;

import com.infor.igf.core.types.PersistableEnum;
import com.infor.igf.core.util.PersistableEnumUtils;
import com.varial.accounting.domain.financesetup.FinanceSetup;
import com.varial.accounting.domain.financialyear.AccountingCompany;
import com.varial.accounting.domain.nominalledger.NLAccountCompanySetting;
import com.varial.accounting.domain.nominalledger.NominalLedgerAccount;
import com.varial.accounting.domain.nominaltransactionbase.TransactionType;
import com.varial.accounting.domain.personalaccount.PersonalAccount;
import com.varial.assetaccounting.accountingtransaction.TransactionTypeEnum;
import com.varial.assetaccounting.depreciation.DepreciationFunctionEnum;
import com.varial.assetaccounting.depreciationarea.DepreciationFromUntilEnum;
import com.varial.assetaccounting.depreciationarea.FullDisposDeprecUntilEnum;
import com.varial.assetaccounting.domain.accountgroup.AccountGroup;
import com.varial.assetaccounting.domain.accountingtransaction.FATransactionFromAccounting;
import com.varial.assetaccounting.domain.accountingtransaction.TransactionTypeMapper;
import com.varial.assetaccounting.domain.assetaccsetup.AssetaccountingSetup;
import com.varial.assetaccounting.domain.calculationmethod.CalcMethod;
import com.varial.assetaccounting.domain.calculationmethod.DepreciationMethodData;
import com.varial.assetaccounting.domain.depreciation.DepreciationCalculation;
import com.varial.assetaccounting.domain.depreciation.DepreciationCalculationHelper;
import com.varial.assetaccounting.domain.depreciationarea.DepreciationArea;
import com.varial.assetaccounting.domain.depreciationarea.DepreciationAreaPersistencyManager;
import com.varial.assetaccounting.domain.depreciationarea.DepreciationFromUntilMapper;
import com.varial.assetaccounting.domain.depreciationarea.FullDisposDeprecUntilMapper;
import com.varial.assetaccounting.domain.fafinancialyear.FAFinancialPeriod;
import com.varial.assetaccounting.domain.fafinancialyear.FAFinancialPeriodDetail;
import com.varial.assetaccounting.domain.fafinancialyear.FAFinancialYear;
import com.varial.assetaccounting.domain.falocation.Falocation;
import com.varial.assetaccounting.domain.fixedasset.AutomaticDepreciationTypeMapper;
import com.varial.assetaccounting.domain.fixedasset.CreditNoteProcessingTimeMapper;
import com.varial.assetaccounting.domain.fixedasset.DeterminationDisposalValueTypeMapper;
import com.varial.assetaccounting.domain.fixedasset.FATransactionAmount;
import com.varial.assetaccounting.domain.fixedasset.FatransactionPersistencyAppl;
import com.varial.assetaccounting.domain.fixedasset.FixedAsset;
import com.varial.assetaccounting.domain.fixedasset.FixedAssetArea;
import com.varial.assetaccounting.domain.fixedasset.FixedAssetData;
import com.varial.assetaccounting.domain.fixedasset.FixedAssetExceptionMapper;
import com.varial.assetaccounting.domain.fixedasset.FixedAssetPersistencyManager;
import com.varial.assetaccounting.domain.fixedasset.FixedAssetTransactionComparator;
import com.varial.assetaccounting.domain.fixedasset.FixedAssetTransactionData;
import com.varial.assetaccounting.domain.fixedasset.FixedAssetTransactionDefaultComparator;
import com.varial.assetaccounting.domain.fixedasset.FixedAssetTransactionDefaultComparatorDocumentDate;
import com.varial.assetaccounting.domain.fixedasset.FixedAssetTransactionDefaultComparatorOld;
import com.varial.assetaccounting.domain.fixedasset.FixedAssetTransactionDefaultDescendingComparator;
import com.varial.assetaccounting.domain.fixedasset.FixedAssetTransactionDefaultDescendingComparatorOld;
import com.varial.assetaccounting.domain.fixedasset.FixedAssetTransactionExceptionMapper;
import com.varial.assetaccounting.domain.fixedasset.FixedAssetTransactionPersistencyManager;
import com.varial.assetaccounting.domain.fixedasset.IncreaseLifeTypeMapper;
import com.varial.assetaccounting.domain.fixedasset.ReserveCreationTypeMapper;
import com.varial.assetaccounting.domain.fixedasset.TransactionMapper;
import com.varial.assetaccounting.fixedasset.AutomaticDepreciationTypeEnum;
import com.varial.assetaccounting.fixedasset.CreditNoteProcessingTimeEnum;
import com.varial.assetaccounting.fixedasset.DeterminationDisposalValueEnum;
import com.varial.assetaccounting.fixedasset.FixedAssetAreaStruct;
import com.varial.assetaccounting.fixedasset.FixedAssetStruct;
import com.varial.assetaccounting.fixedasset.IncreaseLifeEnum;
import com.varial.assetaccounting.fixedasset.PartialDispAcqValueAndPercentageStruct;
import com.varial.assetaccounting.fixedasset.ReserveCreationEnum;
import com.varial.assetaccounting.fixedasset.StatusEnum;
import com.varial.assetaccounting.fixedasset.TransactionEnum;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Junction;
import com.varial.base.persistency.criterion.Order;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.types.date.DateHelper;
import com.varial.costing.base.domain.costcentrebase.CostCentreBase;
import com.varial.framework.domain.analysiscode.AnalysisCodeManager;
import com.varial.framework.domain.company.Company;
import com.varial.framework.domain.company.JurisdictionType;
import com.varial.framework.domain.quantityunit.QuantityUnit;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.BooleanMapper;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.ExceptionMapper;
import com.varial.serverbase.mapper.StringMapper;
import com.varial.serverbase.persistency.IPersistentObject;
import com.varial.serverbase.persistency.PersistentObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixedAssetTransaction
extends PersistentObject
implements Cloneable {
    protected static Logger LOGGER = LoggerFactory.getLogger((String)FixedAssetTransaction.class.getName());
    private static final int PRIORITY = 3;
    protected static final String CLASSNAME = FixedAssetTransaction.class.getName();
    private TransactionEnum mTransactionType;
    private long mTransactionSeqNumber;
    private FixedAssetData mFixedAsset;
    private DepreciationArea mDeprArea;
    private Date mProcessingDate;
    private Date mDocumentDate;
    private Date mTransactionDate;
    private String mReferenceNumber;
    private String mSequenceNumber;
    private String mOrderNumber;
    private NLAccountCompanySetting mNominalAccount;
    private String mPostingText;
    private String mQuantity;
    private QuantityUnit mQuantityUnit;
    private PersonalAccount mSupplierAccount;
    private FAFinancialYear mFinancialYear;
    private BigDecimal mAmount;
    private BigDecimal mAcquisitionAmount;
    private BigDecimal mDepreciationAmount;
    private BigDecimal mSpecDepreciationAmount;
    private BigDecimal mGrant;
    private BigDecimal mPartDisposalPercent;
    private BigDecimal mReserveAmount;
    private BigDecimal mSalesAmount;
    private short mIncreasePeriodInMonth;
    private CalcMethod mDepreciationMethod;
    private String mNote;
    private String[] mAnalcodes;
    private boolean mIsBooked;
    private boolean mIsCanceled;
    private boolean mIsCancelation;
    private boolean mIsQuantityFor_ToFixedAsset;
    private ReserveCreationEnum mReserveCreationType;
    private DeterminationDisposalValueEnum mDeterminationDisposalValueType;
    private BigDecimal mAccumulatedAcquisitionAmount;
    private BigDecimal mAccumulatedDepreciationAmount;
    private BigDecimal mAccumulatedSpecDepreciationAmount;
    private BigDecimal mAccumulatedGrant;
    private BigDecimal mAccumulatedInterest;
    private BigDecimal mNetBookValue;
    private BigDecimal mAccumulatedQuantity;
    private BigDecimal mPartDisposAccumDeprecAmount;
    private BigDecimal mPartDisposAccumSpecDeprecAmount;
    private BigDecimal mPartDisposAccumGrant;
    private BigDecimal mPartDisposNetBookValue;
    private FATransactionAmount[] mCurrencyAmounts;
    private FixedAssetData mFixedAssetTransferFrom;
    private FixedAssetData mFixedAssetTransferTo;
    private String mDerivation;
    private AutomaticDepreciationTypeEnum mAutomDeprType;
    private NLAccountCompanySetting mAssetAccountOld;
    private Date mLastDeprDate;
    private BigDecimal mNetBookValueBeginFY;
    private BigDecimal mAccumDepr;
    private BigDecimal mAccumDeprCancel;
    private BigDecimal mAccumSpecDepr;
    private BigDecimal mAccumSpecDeprCancel;
    private BigDecimal mIncomeOrExpense;
    private BigDecimal mIncomeOrExpenseCancel;
    private BigDecimal mAccumGrant;
    private BigDecimal mAccumGrantCancel;
    private BigDecimal mAccumWriteUp;
    private BigDecimal mAccumWriteUpCancel;
    private BigDecimal mAccumWriteDown;
    private BigDecimal mAccumWriteDownCancel;
    private BigDecimal mPartDisposalNetBookValue;
    private IncreaseLifeEnum mIncreaseLifeType;
    private Date mCommissioningDate;
    private FixedAsset mAssetGroupOld;
    private FixedAsset mAssetGroupNew;
    private NLAccountCompanySetting mAccValuationDeprOld;
    private NLAccountCompanySetting mAccValuationDeprNew;
    private AccountGroup mAccountGroupOld;
    private AccountGroup mAccountGroupNew;
    private String mOidFATransactionFromAccounting;
    private Falocation mLocationOld;
    private Falocation mLocationNew;
    private CostCentreBase mCostCentreOld;
    private CostCentreBase mCostCentreNew;
    private CreditNoteProcessingTimeEnum mCreditNoteProcessingTime;
    private TransactionTypeEnum mTransactionTypeAcc;
    private TransactionType mNLTransactionTypeAcc;
    private String mBarcodeNumber;
    private String mOidCompany;
    private boolean mWithDisposalDepr;
    private FullDisposDeprecUntilEnum mFullDisposDeprecUntil;
    private boolean mShowAsAddition;
    private boolean mChangeAssetNumber;
    private String mNewAssetNumber;
    private String mOldAssetNumber;
    private DepreciationFromUntilEnum mPartialDisposDeprecUntil;
    private boolean mPostTransaction;
    private final String mYearLowValue2018 = "2017-12-31";
    private FinanceSetup mFinanceSetup;
    private BigDecimal mAmountNotUsedDeprIT;
    private boolean mBasedOnExternalAudit;
    private String mSummarizedPostingText;
    private int mLifeInMonth;
    private int mResLifeInMonth;
    private FixedAssetTransaction mCorrespondingTransaction;
    private BigDecimal mDepResValueNew;
    private BigDecimal mDepResValueOld;
    private CalcMethod mDepreciationMethodOld;

    public FixedAssetTransaction() {
        super(3);
        this.mAccumulatedAcquisitionAmount = BigDecimal.ZERO;
        this.mAccumulatedDepreciationAmount = BigDecimal.ZERO;
        this.mAccumulatedSpecDepreciationAmount = BigDecimal.ZERO;
        this.mAccumulatedGrant = BigDecimal.ZERO;
        this.mAccumulatedInterest = BigDecimal.ZERO;
        this.mNetBookValue = BigDecimal.ZERO;
        this.mAccumulatedQuantity = BigDecimal.ZERO;
        this.mPartDisposAccumDeprecAmount = BigDecimal.ZERO;
        this.mPartDisposAccumSpecDeprecAmount = BigDecimal.ZERO;
        this.mPartDisposAccumGrant = BigDecimal.ZERO;
        this.mPartDisposNetBookValue = BigDecimal.ZERO;
        this.mAccumDepr = BigDecimal.ZERO;
        this.mAccumDeprCancel = BigDecimal.ZERO;
        this.mAccumSpecDepr = BigDecimal.ZERO;
        this.mAccumSpecDeprCancel = BigDecimal.ZERO;
        this.mIncomeOrExpense = BigDecimal.ZERO;
        this.mIncomeOrExpenseCancel = BigDecimal.ZERO;
        this.mAccumGrant = BigDecimal.ZERO;
        this.mAccumGrantCancel = BigDecimal.ZERO;
        this.mAccumWriteUp = BigDecimal.ZERO;
        this.mAccumWriteUpCancel = BigDecimal.ZERO;
        this.mAccumWriteDown = BigDecimal.ZERO;
        this.mAccumWriteDownCancel = BigDecimal.ZERO;
        this.mAmountNotUsedDeprIT = BigDecimal.ZERO;
        this.mDepResValueNew = BigDecimal.ZERO;
        this.mDepResValueOld = BigDecimal.ZERO;
    }

    public FixedAssetTransaction(boolean readOnly) {
        super(3, readOnly);
    }

    FixedAssetTransaction(String objectid) {
        super(3, objectid);
    }

    public FixedAssetTransaction(String objectid, int version) {
        super(3, objectid, version);
    }

    public FixedAssetTransaction(FixedAssetTransaction originalTransaction) {
        super(3);
        this.mTransactionType = originalTransaction.getTransactionEnum();
        this.mTransactionSeqNumber = originalTransaction.getTransactionSeqNumber();
        this.mFixedAsset = (FixedAssetData)originalTransaction.getFixedAsset();
        this.mDeprArea = originalTransaction.getDeprArea();
        this.mProcessingDate = originalTransaction.getProcessingDate();
        this.mDocumentDate = originalTransaction.getDocumentDate();
        this.mTransactionDate = originalTransaction.getTransactionDate();
        this.mReferenceNumber = originalTransaction.getReferenceNumber();
        this.mSequenceNumber = originalTransaction.getSequenceNumber();
        this.mOrderNumber = originalTransaction.getOrderNumber();
        this.mNominalAccount = originalTransaction.getAssetAccountSetting();
        this.mPostingText = originalTransaction.getPostingText();
        this.mQuantity = originalTransaction.getQuantity();
        this.mQuantityUnit = originalTransaction.getQuantityUnit();
        this.mSupplierAccount = originalTransaction.getPersonalAccount();
        this.mFinancialYear = originalTransaction.getFinancialYear();
        this.mAmount = originalTransaction.getAmount();
        this.mAcquisitionAmount = originalTransaction.getAcquisitionAmount();
        this.mDepreciationAmount = originalTransaction.getDepreciationAmount();
        this.mSpecDepreciationAmount = originalTransaction.getSpecDepreciationAmount();
        this.mGrant = originalTransaction.getGrant();
        this.mPartDisposalPercent = originalTransaction.getPartDisposalPercent();
        this.mReserveAmount = originalTransaction.getReserveAmount();
        this.mSalesAmount = originalTransaction.getSalesAmount();
        this.mIncreasePeriodInMonth = originalTransaction.getIncreasePeriodInMonth();
        this.mDepreciationMethod = originalTransaction.getCalcMethod();
        this.mNote = originalTransaction.getNote();
        this.mAnalcodes = originalTransaction.getAnalysisCodes();
        this.mIsBooked = originalTransaction.getIsBooked();
        this.mIsCanceled = originalTransaction.getIsCanceled();
        this.mIsCancelation = originalTransaction.getIsCancelation();
        this.mIsQuantityFor_ToFixedAsset = originalTransaction.getIsQuantityFor_ToFixedAsset();
        this.mReserveCreationType = originalTransaction.getReserveCreationType();
        this.mDeterminationDisposalValueType = originalTransaction.getDeterminationDisposalValueType();
        this.mAccumulatedAcquisitionAmount = originalTransaction.getAccumulatedAcquisitionAmount();
        this.mAccumulatedDepreciationAmount = originalTransaction.getAccumulatedDepreciationAmount();
        this.mAccumulatedSpecDepreciationAmount = originalTransaction.getAccumulatedSpecDepreciationAmount();
        this.mAccumulatedGrant = originalTransaction.getAccumulatedGrant();
        this.mNetBookValue = originalTransaction.getNetBookValue();
        this.mAccumulatedQuantity = originalTransaction.getAccumulatedQuantity();
        this.mPartDisposAccumDeprecAmount = originalTransaction.getPartDisposAccumDeprecAmount();
        this.mPartDisposAccumSpecDeprecAmount = originalTransaction.getPartDisposAccumSpecDeprecAmount();
        this.mPartDisposAccumGrant = originalTransaction.getPartDisposAccumGrant();
        this.mPartDisposNetBookValue = originalTransaction.getPartDisposNetBookValue();
        this.mCurrencyAmounts = originalTransaction.getCurrencyAmounts();
        this.mFixedAssetTransferFrom = (FixedAssetData)originalTransaction.getFixedAssetTransferFrom();
        this.mFixedAssetTransferTo = (FixedAssetData)originalTransaction.getFixedAssetTransferTo();
        this.mDerivation = originalTransaction.getDerivation();
        this.mLastDeprDate = originalTransaction.getLastDeprDate();
        this.mNetBookValueBeginFY = originalTransaction.getNetBookValueBeginFY();
        this.mAccumDepr = originalTransaction.getAccumDepr();
        this.mAccumDeprCancel = originalTransaction.getAccumDeprCancel();
        this.mAccumSpecDepr = originalTransaction.getAccumSpecDepr();
        this.mAccumSpecDeprCancel = originalTransaction.getAccumSpecDeprCancel();
        this.mIncomeOrExpense = originalTransaction.getIncomeOrExpense();
        this.mIncomeOrExpenseCancel = originalTransaction.getIncomeOrExpenseCancel();
        this.mAmountNotUsedDeprIT = originalTransaction.getAmountNotUsedDeprIT();
        this.mAutomDeprType = originalTransaction.getAutomaticDepreciationTyp();
        this.mAssetAccountOld = originalTransaction.getAssetAccountOldSetting();
        this.mPartDisposalNetBookValue = originalTransaction.getPartDisposalNetBookValue();
        this.mBasedOnExternalAudit = originalTransaction.getBasedOnExternalAudit();
        this.mIncreaseLifeType = originalTransaction.getIncreaseLifeType();
        this.mCommissioningDate = originalTransaction.getCommissioningDate();
        this.mAssetGroupOld = originalTransaction.getAssetGroupOld();
        this.mAssetGroupNew = originalTransaction.getAssetGroupNew();
        this.mAccValuationDeprOld = originalTransaction.getAccValuationDeprOldSetting();
        this.mAccValuationDeprNew = originalTransaction.getAccValuationDeprNewSetting();
        this.mCostCentreOld = originalTransaction.getCostCentreOld();
        this.mCostCentreNew = originalTransaction.getCostCentreNew();
        this.mLocationOld = originalTransaction.getLocationOld();
        this.mLocationNew = originalTransaction.getLocationNew();
        this.mTransactionTypeAcc = originalTransaction.getTransactionType();
        this.mNLTransactionTypeAcc = originalTransaction.getNLTransactionType();
        this.mBarcodeNumber = originalTransaction.getBarcodeNumber();
        this.mOidCompany = originalTransaction.getOidCompany();
        this.mWithDisposalDepr = originalTransaction.getWithDisposalDepr();
        this.mFullDisposDeprecUntil = originalTransaction.getFullDisposDeprecUntil();
        this.mShowAsAddition = originalTransaction.getShowAsAddition();
        this.mChangeAssetNumber = originalTransaction.getChangeAssetNumber();
        this.mNewAssetNumber = originalTransaction.getNewAssetNumber();
        this.mOldAssetNumber = originalTransaction.getOldAssetNumber();
        this.mPartialDisposDeprecUntil = originalTransaction.getPartialDisposDeprecUntil();
        this.mPostTransaction = originalTransaction.getPostTransaction();
        this.mSummarizedPostingText = originalTransaction.getSummarizedPostingText();
        this.mLifeInMonth = originalTransaction.getLifeInMonth();
        this.mResLifeInMonth = originalTransaction.getResLifeInMonth();
        this.mCorrespondingTransaction = originalTransaction.getCorrespondingTransaction();
        this.mDepreciationMethodOld = originalTransaction.getDepreciationMethodOld();
        this.mDepResValueNew = originalTransaction.getDepResValueNew();
        this.mDepResValueOld = originalTransaction.getDepResValueOld();
    }

    protected void load() {
        FixedAssetTransactionPersistencyManager.load((FixedAssetTransaction)this);
    }

    protected void destroyImpl() throws BusinessDomainException {
        if (this.mTransactionType.value() == 1 || this.mTransactionType.value() == 0 || this.mTransactionType.value() == 2 || this.mTransactionType.value() == 3 || this.mTransactionType.value() == 7 || this.mTransactionType.value() == 11 || this.mTransactionType.value() == 13 || this.mTransactionType.value() == 14) {
            FixedAssetArea faArea = ((FixedAssetData)this.getFixedAsset()).getFixedAssetArea(this.getDeprArea());
            FixedAssetTransaction.checkAccumulatedAmounts(faArea, this, true);
        }
    }

    protected void deleteImpl() {
        FixedAssetTransactionPersistencyManager.delete((FixedAssetTransaction)this);
    }

    public String getClassName() {
        return CLASSNAME;
    }

    public String getDomainKey() {
        return this.getObjectid();
    }

    protected void saveImpl() throws BusinessDomainException {
        FixedAssetTransactionPersistencyManager.save((FixedAssetTransaction)this);
    }

    public static FixedAssetTransaction[] getFixedAssetTransactions(FixedAsset fa) {
        return FixedAssetTransactionPersistencyManager.getTransactions((FixedAsset)fa);
    }

    public static FixedAssetTransaction[] getFixedAssetTransactions(FixedAssetArea faArea, Date untilDate, boolean sortWithDocumentDate) {
        return FixedAssetTransactionPersistencyManager.getTransactions((FixedAssetArea)faArea, (Date)untilDate, (boolean)sortWithDocumentDate);
    }

    public static FixedAssetTransaction[] getFixedAssetTransactions(DepreciationArea deprArea) {
        return FixedAssetTransactionPersistencyManager.getTransactions((DepreciationArea)deprArea);
    }

    public static FixedAssetTransaction[] getFixedAssetTransactions(AssetaccountingSetup aaSetup, Criterion filter) {
        return FixedAssetTransactionPersistencyManager.getTransactions((AssetaccountingSetup)aaSetup, (Criterion)filter);
    }

    protected void check() throws BusinessDomainException {
        if (this.mTransactionType.value() != 10 && this.mTransactionType.value() != 12) {
            FAFinancialYear finYearForTransaction = this.mFinancialYear;
            if (this.mTransactionType.value() == 1 && !DateHelper.between((Date)this.mProcessingDate, (Date)this.mFinancialYear.getValidFrom(), (Date)this.mFinancialYear.getValidUntil()) && (finYearForTransaction = FAFinancialYear.getFAFinancialYearOrNullForDate((AccountingCompany)this.getAccountingCompany(), (Date)this.mProcessingDate, null)) == null) {
                finYearForTransaction = this.mFinancialYear;
            }
            if (finYearForTransaction != null) {
                FAFinancialPeriodDetail detail;
                if (finYearForTransaction.getYearClosed()) {
                    throw FixedAssetTransactionExceptionMapper.makeFinancialYearClosedForCreateDomainException((String)"FixedAssetTransaction.check");
                }
                FAFinancialPeriod finPeriod = FAFinancialPeriod.getFAFinancialPeriodForDate((FAFinancialPeriod[])finYearForTransaction.getFinancialPeriods(), (Date)this.mProcessingDate);
                if (finPeriod != null && (detail = FAFinancialPeriod.getFinancialPeriodDetailsForDeprArea((FAFinancialPeriodDetail[])finPeriod.getFinancialPeriodDetails(), (DepreciationArea)this.mDeprArea)) != null && detail.getDeprAreaClosed()) {
                    String message = "Anlagenummer = " + this.mFixedAsset.getCode() + ", Verarbeitungsdatum = " + DateMapper.toString((Date)this.mProcessingDate) + ", Bewertungsbereich = " + this.mDeprArea.getCode() + ", Bewegungsart = " + this.mTransactionType.value() + ", Belegnummer = " + this.mReferenceNumber + ", Betrag = " + this.mAmount;
                    throw FixedAssetTransactionExceptionMapper.makePeriodWrongException((String)message);
                }
            }
        }
        if (this.mTransactionDate == null) {
            throw FixedAssetTransactionExceptionMapper.makeNoTransactiondateException((String)"FixedAssetTransaction.check");
        }
        if (this.mDocumentDate == null) {
            throw FixedAssetTransactionExceptionMapper.makeNoDocumentdateException((String)"FixedAssetTransaction.check");
        }
        if (this.mReferenceNumber == null || this.mReferenceNumber.equals("")) {
            throw FixedAssetTransactionExceptionMapper.makeNoReferencenumberException((String)"FixedAssetTransaction.check");
        }
        if (this.mNominalAccount == null && (this.mTransactionType.value() == 0 || this.mTransactionType.value() == 1) && StringMapper.isNullString((String)this.mDerivation)) {
            throw FixedAssetTransactionExceptionMapper.makeNoAssetAccountException((String)"FixedAssetTransaction.check");
        }
        if (this.mPostingText == null || this.mPostingText.equals("")) {
            throw FixedAssetTransactionExceptionMapper.makeNoPostingtextException((String)"FixedAssetTransaction.check");
        }
        if ((this.mTransactionType.value() == 2 || this.mTransactionType.value() == 4) && this.mCreditNoteProcessingTime != null && this.mCreditNoteProcessingTime == CreditNoteProcessingTimeEnum.CPTE_BEGIN_HALFYEAR && this.mDeprArea.getJurisdictionType() == JurisdictionType.DE) {
            throw FixedAssetTransactionExceptionMapper.halfYearRuleWrongDomainException((String)this.mFixedAsset.getCode(), (String)"FixedAssetTransaction.check");
        }
        if (!(this.mTransactionType.value() != 20 && (this.mTransactionType.value() != 6 || this.isDestroyed() || this.mFixedAsset.getObjectid().equals(this.mFixedAssetTransferTo.getObjectid())) || this.mIsCancelation || this.mIsCanceled || !FixedAssetTransaction.checkTransactionsAfterDisposal((FixedAsset)this.mFixedAsset, this.mDeprArea, this.mProcessingDate))) {
            String message = "Anlagenummer = " + this.mFixedAsset.getCode() + ", Verarbeitungsdatum = " + DateMapper.toString((Date)this.mProcessingDate) + ", Bewertungsbereich = " + this.mDeprArea.getCode() + ", Bewegungsart = " + this.mTransactionType.value() + ", Belegnummer = " + this.mReferenceNumber + ", Betrag = " + this.mAmount;
            throw FixedAssetTransactionExceptionMapper.makeTransactionNotAllowedException((String)message);
        }
        if (this.mTransactionType.value() == 21 && this.mIsCancelation && !this.mIsCanceled && !this.mIsBooked && FixedAssetTransaction.checkTransactionsAfterActivateAssetUnderConstruction((FixedAsset)this.mFixedAsset, this.mDeprArea, this.mProcessingDate)) {
            throw FixedAssetTransactionExceptionMapper.makeCancelActivateTransactDomainException((String)"FixedAssetTransaction.check");
        }
        FixedAssetArea faArea = this.mFixedAsset.getFixedAssetArea(this.mDeprArea);
        if (!(this.mTransactionType.value() != 19 && this.mTransactionType.value() != 5 && this.mTransactionType.value() != 25 && this.mTransactionType.value() != 4 && this.mTransactionType.value() != 15 && this.mTransactionType.value() != 0 && this.mTransactionType.value() != 14 && this.mTransactionType.value() != 26 || this.mIsCancelation || this.mIsCanceled)) {
            FixedAssetTransaction.checkAccumulatedAmounts(faArea, this, false);
        }
        if (faArea.getStatus() == StatusEnum.STE_LOW_VALUE_5_YEARS) {
            VDate startDate;
            int startYear;
            VDate processingDate = new VDate(this.mProcessingDate);
            int processingYear = processingDate.getYear();
            if (processingYear > (startYear = (startDate = new VDate(faArea.getDeprStartDate())).getYear()) && (this.mTransactionType.value() == 2 || this.mTransactionType.value() == 3 || this.mTransactionType.value() == 19 || this.mTransactionType.value() == 4)) {
                throw FixedAssetTransactionExceptionMapper.makeTransactionNotAllowedDomainException((String)"FixedAssetTransaction.check");
            }
            if ((this.mTransactionType.value() == 2 || this.mTransactionType.value() == 4) && this.mCreditNoteProcessingTime != null && this.mCreditNoteProcessingTime != CreditNoteProcessingTimeEnum.CPTE_DEPR_START) {
                String message = "Anlagenummer = " + this.mFixedAsset.getCode() + ", Verarbeitungsdatum = " + DateMapper.toString((Date)this.mProcessingDate) + ", Bewertungsbereich = " + this.mDeprArea.getCode() + ", Bewegungsart = " + this.mTransactionType.value() + ", Belegnummer = " + this.mReferenceNumber + ", Betrag = " + this.mAmount;
                throw FixedAssetTransactionExceptionMapper.makeProcessingTimeWrongDomainException((String)message);
            }
        }
        if (!(faArea.getStatus() != StatusEnum.STE_LOW_VALUE || this.mTransactionType.value() != 0 && this.mTransactionType.value() != 22 && this.mTransactionType.value() != 1 || this.mDerivation.equals("Import") || BigDecimalMapper.isZeroOrNull((BigDecimal)this.mDeprArea.getLimit()))) {
            BigDecimal lowValueAmount = this.mDeprArea.getLimit();
            if (this.mDeprArea.getJurisdictionType() == JurisdictionType.DE && DateHelper.beforeOrEqual((Date)this.mFixedAsset.getAcquisitionDate(), (Date)DateMapper.toDate((String)"2017-12-31"))) {
                lowValueAmount = new BigDecimal(410);
            }
            BigDecimal quantity = BigDecimal.ZERO;
            if (this.mFixedAsset.getQuantity() != "" && !BigDecimalMapper.isZeroOrNull((BigDecimal)(quantity = BigDecimalMapper.toBigDecimal((String)this.mFixedAsset.getQuantity())))) {
                quantity = quantity.setScale(0, RoundingMode.HALF_EVEN);
                lowValueAmount = lowValueAmount.multiply(quantity);
            }
            if (this.mAmount.compareTo(lowValueAmount) > 0) {
                if (this.mDeprArea.getJurisdictionType() == JurisdictionType.DE && DateHelper.after((Date)this.mFixedAsset.getAcquisitionDate(), (Date)DateMapper.toDate((String)"2017-12-31"))) {
                    throw FixedAssetExceptionMapper.makeLowValueAssetToHighException((String)this.mFixedAsset.getCode());
                }
                throw FixedAssetTransactionExceptionMapper.makeAmountLowValueToLargeDomainException((String)"FixedAssetTransaction.check", (String)this.mDeprArea.getCode());
            }
        }
        if (this.mFinancialYear == null) {
            throw ExceptionMapper.makeApplicationException((String)"mFinancialYear must be filled");
        }
        if (this.mProcessingDate == null) {
            throw ExceptionMapper.makeApplicationException((String)"mProcessingDate must be filled");
        }
        if (!(faArea.getStatus().value() != 3 && faArea.getStatus().value() != 8 && faArea.getStatus().value() != 1 && faArea.getStatus().value() != 5 || this.mTransactionType.value() != 11 && this.mTransactionType.value() != 13 && this.mTransactionType.value() != 14 && this.mTransactionType.value() != 15 && this.mTransactionType.value() != 26)) {
            throw FixedAssetTransactionExceptionMapper.makeDeprTypeNotAllowedDomainException((String)"FixedAssetTransaction.check");
        }
        if (!(this.mTransactionType.value() != 11 && this.mTransactionType.value() != 13 && this.mTransactionType.value() != 14 || this.mIsCancelation || this.mIsCanceled || this.mDerivation.equals("Import"))) {
            FixedAssetTransaction.checkNetBookValue(faArea, this, false);
        }
    }

    protected void setData(FixedAssetTransactionData data) {
        this.mTransactionType = data.getTransactionType();
        this.mTransactionSeqNumber = data.getTransactionSeqNumber();
        this.mFixedAsset = data.getFixedAsset();
        this.mDeprArea = data.getDeprArea();
        this.mProcessingDate = data.getProcessingDate();
        this.mDocumentDate = data.getDocumentDate();
        this.mTransactionDate = data.getTransactionDate();
        this.mReferenceNumber = data.getReferenceNumber();
        this.mSequenceNumber = data.getSequenceNumber();
        this.mOrderNumber = data.getOrderNumber();
        this.mNominalAccount = data.getNominalAccount();
        this.mPostingText = data.getPostingText();
        this.mQuantity = data.getQuantity();
        this.mQuantityUnit = data.getQuantityUnit();
        this.mSupplierAccount = data.getSupplierAccount();
        this.mFinancialYear = data.getFinancialYear();
        this.mAmount = data.getAmount();
        this.mDepreciationAmount = data.getDepreciationAmount();
        this.mSpecDepreciationAmount = data.getSpecDepreciationAmount();
        this.mGrant = data.getGrant();
        this.mPartDisposalPercent = data.getPartDisposalPercent();
        this.mReserveAmount = data.getReserveAmount();
        this.mSalesAmount = data.getSalesAmount();
        this.mIncreasePeriodInMonth = data.getIncreasePeriodInMonth();
        this.mDepreciationMethod = data.getDepreciationMethod();
        this.mNote = data.getNote();
        this.mAnalcodes = data.getAnalcodes();
        this.mIsBooked = data.isBooked();
        this.mIsCanceled = data.isCanceled();
        this.mIsCancelation = data.isCancelation();
        this.mIsQuantityFor_ToFixedAsset = data.isQuantityFor_ToFixedAsset();
        this.mCurrencyAmounts = data.getCurrencyAmounts();
        this.mReserveCreationType = data.getReserveCreationType();
        this.mDeterminationDisposalValueType = data.getDeterminationDisposalValueType();
        this.mAccumulatedAcquisitionAmount = data.getAccumulatedAcquisitionAmount();
        this.mAccumulatedDepreciationAmount = data.getAccumulatedDepreciationAmount();
        this.mAccumulatedSpecDepreciationAmount = data.getAccumulatedSpecDepreciationAmount();
        this.mAccumulatedGrant = data.getAccumulatedGrant();
        this.mAccumulatedInterest = data.getAccumulatedInterest();
        this.mNetBookValue = data.getNetBookValue();
        this.mAccumulatedQuantity = data.getAccumulatedQuantity();
        this.mPartDisposAccumDeprecAmount = data.getPartDisposAccumDeprecAmount();
        this.mPartDisposAccumSpecDeprecAmount = data.getPartDisposAccumSpecDeprecAmount();
        this.mPartDisposAccumGrant = data.getPartDisposAccumGrant();
        this.mPartDisposNetBookValue = data.getPartDisposNetBookValue();
        this.mFixedAssetTransferFrom = data.getFixedAssetTransferFrom();
        this.mFixedAssetTransferTo = data.getFixedAssetTransferTo();
        this.mDerivation = data.getDerivation();
        this.mLastDeprDate = data.getLastDeprDate();
        this.mNetBookValueBeginFY = data.getNetBookValueBeginFY();
        this.mAccumDepr = data.getAccumDepr();
        this.mAccumDeprCancel = data.getAccumDeprCancel();
        this.mAccumSpecDepr = data.getAccumSpecDepr();
        this.mAccumSpecDeprCancel = data.getAccumSpecDeprCancel();
        this.mIncomeOrExpense = data.getIncomeOrExpense();
        this.mIncomeOrExpenseCancel = data.getIncomeOrExpenseCancel();
        this.mAmountNotUsedDeprIT = data.getAmountNotUsedDeprIT();
        this.mAutomDeprType = data.getAutomDeprType();
        this.mAssetAccountOld = data.getAssetAccountOld();
        this.mPartDisposalNetBookValue = data.getPartDisposalNetBookValue();
        this.mBasedOnExternalAudit = data.isBasedOnExternalAudit();
        this.mIncreaseLifeType = data.getIncreaseLifeType();
        this.mCommissioningDate = data.getCommissioningDate();
        this.mAssetGroupOld = data.getAssetGroupOld();
        this.mAssetGroupNew = data.getAssetGroupNew();
        this.mAccValuationDeprOld = data.getAccValuationDeprOld();
        this.mAccValuationDeprNew = data.getAccValuationDeprNew();
        this.mAccountGroupOld = data.getAccountGroupOld();
        this.mAccountGroupNew = data.getAccountGroupNew();
        this.mCostCentreOld = data.getCostCentreOld();
        this.mCostCentreNew = data.getCostCentreNew();
        this.mLocationOld = data.getLocationOld();
        this.mLocationNew = data.getLocationNew();
        this.mCreditNoteProcessingTime = data.getCreditNoteProcessingTimeType();
        this.mOidFATransactionFromAccounting = data.getOidFATransactionFromAccounting();
        this.mTransactionTypeAcc = data.getTransactionTypeAcc();
        this.mNLTransactionTypeAcc = data.getNlTransactionTypeAcc();
        this.mBarcodeNumber = data.getBarcodeNumber();
        this.mOidCompany = data.getOidCompany();
        this.mWithDisposalDepr = data.isWithDisposalDepr();
        this.mFullDisposDeprecUntil = data.getFullDisposDeprecUntil();
        this.mShowAsAddition = data.getShowAsAddition();
        this.mChangeAssetNumber = data.getChangeAssetNumber();
        this.mNewAssetNumber = data.getNewAssetNumber();
        this.mOldAssetNumber = data.getOldAssetNumber();
        this.mPartialDisposDeprecUntil = data.getPartialDisposDeprecUntil();
        this.mPostTransaction = data.getPostTransaction();
        this.mSummarizedPostingText = data.getSummarizedPostingText();
        this.mLifeInMonth = data.getLifeInMonth();
        this.mResLifeInMonth = data.getResLifeInMonth();
        this.mCorrespondingTransaction = data.getCorrespondingTransaction();
        this.mDepreciationMethodOld = data.getDepreciationMethodOld();
        this.mDepResValueNew = data.getDepResValueNew();
        this.mDepResValueOld = data.getDepResValueOld();
    }

    public String getOidCompany() {
        this.requireLoaded();
        return this.mOidCompany;
    }

    public void setOidCompany(String oidCompany) {
        this.mOidCompany = oidCompany;
    }

    public AccountingCompany getAccountingCompany() {
        this.requireLoaded();
        return this.mFixedAsset.getAccountCompany();
    }

    public FinanceSetup getFinanceSetup() throws BusinessDomainException {
        if (this.mFinanceSetup == null) {
            this.mFinanceSetup = this.getAccountingCompany().getFinanceSetup();
        }
        if (this.mFinanceSetup == null) {
            throw FixedAssetTransactionExceptionMapper.makeNoFinanceSetupException();
        }
        return this.mFinanceSetup;
    }

    public TransactionEnum getTransactionEnum() {
        this.requireLoaded();
        return this.mTransactionType;
    }

    public void setTransactionEnum(TransactionEnum transactionType) {
        this.protocol("transactiontype", TransactionMapper.toString((TransactionEnum)this.mTransactionType), TransactionMapper.toString((TransactionEnum)transactionType));
        this.mTransactionType = transactionType;
    }

    public long getTransactionSeqNumber() {
        this.requireLoaded();
        return this.mTransactionSeqNumber;
    }

    public void setTransactionSeqNumber(long transactionSeqNumber) {
        this.protocol("transactionseqnumber", Long.valueOf(this.mTransactionSeqNumber).toString(), Long.valueOf(transactionSeqNumber).toString());
        this.mTransactionSeqNumber = transactionSeqNumber;
    }

    public FixedAsset getFixedAsset() {
        this.requireLoaded();
        return this.mFixedAsset;
    }

    public void setFixedAsset(FixedAssetData fixedAsset) {
        this.protocol("fixedasset", (IPersistentObject)this.mFixedAsset, (IPersistentObject)fixedAsset);
        this.mFixedAsset = fixedAsset;
    }

    public DepreciationArea getDeprArea() {
        this.requireLoaded();
        return this.mDeprArea;
    }

    public void setDeprArea(DepreciationArea deprArea) {
        this.protocol("deprarea", (IPersistentObject)this.mDeprArea, (IPersistentObject)deprArea);
        this.mDeprArea = deprArea;
    }

    public Date getProcessingDate() {
        this.requireLoaded();
        return this.mProcessingDate;
    }

    public void setProcessingDate(Date processingDate) {
        this.protocol("processingdate", this.mProcessingDate, processingDate);
        this.mProcessingDate = processingDate;
    }

    public Date getDocumentDate() {
        this.requireLoaded();
        return this.mDocumentDate;
    }

    public void setDocumentDate(Date documentDate) {
        this.protocol("documentdate", this.mDocumentDate, documentDate);
        this.mDocumentDate = documentDate;
    }

    public Date getTransactionDate() {
        this.requireLoaded();
        return this.mTransactionDate;
    }

    public void setTransactionDate(Date transactionDate) {
        this.protocol("transactiondate", this.mTransactionDate, transactionDate);
        this.mTransactionDate = transactionDate;
    }

    public String getReferenceNumber() {
        this.requireLoaded();
        return this.mReferenceNumber;
    }

    public void setReferenceNumber(String referenceNumber) {
        this.protocol("referencenumber", this.mReferenceNumber, referenceNumber);
        this.mReferenceNumber = referenceNumber;
    }

    public String getSequenceNumber() {
        this.requireLoaded();
        return this.mSequenceNumber;
    }

    public void setSequenceNumber(String sequenceNumber) {
        this.protocol("sequencenumber", this.mSequenceNumber, sequenceNumber);
        this.mSequenceNumber = sequenceNumber;
    }

    public String getOrderNumber() {
        this.requireLoaded();
        return this.mOrderNumber;
    }

    public void setOrderNumber(String orderNumber) {
        this.protocol("ordernumber", this.mOrderNumber, orderNumber);
        this.mOrderNumber = orderNumber;
    }

    public NominalLedgerAccount getAssetAccount() {
        this.requireLoaded();
        if (this.mNominalAccount != null) {
            return this.mNominalAccount.getNominalLedgerAccount();
        }
        return null;
    }

    public NLAccountCompanySetting getAssetAccountSetting() {
        this.requireLoaded();
        return this.mNominalAccount;
    }

    public void setAssetAccount(NLAccountCompanySetting assetAccount) {
        this.mNominalAccount = assetAccount;
    }

    public String getPostingText() {
        this.requireLoaded();
        return this.mPostingText;
    }

    public void setPostingText(String postingText) {
        this.protocol("postingtext", this.mPostingText, postingText);
        this.mPostingText = postingText;
    }

    public String getSummarizedPostingText() {
        this.requireLoaded();
        return this.mSummarizedPostingText;
    }

    public void setSummarizedPostingText(String summarizedPostingText) {
        this.protocol("summarizedpostingtext", this.mSummarizedPostingText, summarizedPostingText);
        this.mSummarizedPostingText = summarizedPostingText;
    }

    public String getQuantity() {
        this.requireLoaded();
        return this.mQuantity;
    }

    public void setQuantity(String quantity) {
        this.protocol("quantity", this.mQuantity, quantity);
        this.mQuantity = quantity;
    }

    public QuantityUnit getQuantityUnit() {
        this.requireLoaded();
        return this.mQuantityUnit;
    }

    public void setQuantityUnit(QuantityUnit quantityUnit) {
        this.protocol("quantityunit", (IPersistentObject)this.mQuantityUnit, (IPersistentObject)quantityUnit);
        this.mQuantityUnit = quantityUnit;
    }

    public PersonalAccount getPersonalAccount() {
        this.requireLoaded();
        return this.mSupplierAccount;
    }

    public void setPersonalAccount(PersonalAccount supplierAccount) {
        this.protocol("supplierAccount", (IPersistentObject)this.mSupplierAccount, (IPersistentObject)supplierAccount);
        this.mSupplierAccount = supplierAccount;
    }

    public FAFinancialYear getFinancialYear() {
        this.requireLoaded();
        return this.mFinancialYear;
    }

    public void setFinancialYear(FAFinancialYear financialYear) {
        this.protocol("financialyear", (IPersistentObject)this.mFinancialYear, (IPersistentObject)financialYear);
        this.mFinancialYear = financialYear;
    }

    public BigDecimal getAmount() {
        this.requireLoaded();
        return this.mAmount;
    }

    public void setAmount(BigDecimal amount) {
        this.protocol("amount", this.mAmount, amount);
        this.mAmount = amount;
    }

    public BigDecimal getAcquisitionAmount() {
        this.requireLoaded();
        return this.mAcquisitionAmount;
    }

    public void setAcquisitionAmount(BigDecimal acquisitionAmount) {
        this.protocol("acquisitionamount", this.mAcquisitionAmount, acquisitionAmount);
        this.mAcquisitionAmount = acquisitionAmount;
    }

    public BigDecimal getDepreciationAmount() {
        this.requireLoaded();
        return this.mDepreciationAmount;
    }

    public void setDepreciationAmount(BigDecimal depreciationAmount) {
        this.protocol("depreciationamount", this.mDepreciationAmount, depreciationAmount);
        this.mDepreciationAmount = depreciationAmount;
    }

    public BigDecimal getSpecDepreciationAmount() {
        this.requireLoaded();
        return this.mSpecDepreciationAmount;
    }

    public void setSpecDepreciationAmount(BigDecimal specDepreciationAmount) {
        this.protocol("specdepreciationamount", this.mSpecDepreciationAmount, specDepreciationAmount);
        this.mSpecDepreciationAmount = specDepreciationAmount;
    }

    public BigDecimal getGrant() {
        this.requireLoaded();
        return this.mGrant;
    }

    public void setGrant(BigDecimal grant) {
        this.protocol("grant", this.mGrant, grant);
        this.mGrant = grant;
    }

    public BigDecimal getPartDisposalPercent() {
        this.requireLoaded();
        return this.mPartDisposalPercent;
    }

    public void setPartDisposalPercent(BigDecimal partDisposalPercent) {
        this.protocol("partdisposalpercent", this.mPartDisposalPercent, partDisposalPercent);
        this.mPartDisposalPercent = partDisposalPercent;
    }

    public BigDecimal getPartDisposalNetBookValue() {
        this.requireLoaded();
        return this.mPartDisposalNetBookValue;
    }

    public void setPartDisposalNetBookValue(BigDecimal partDisposalNetBookValue) {
        this.protocol("partdisposalnetbookvalue", this.mPartDisposalNetBookValue, partDisposalNetBookValue);
        this.mPartDisposalNetBookValue = partDisposalNetBookValue;
    }

    public BigDecimal getReserveAmount() {
        this.requireLoaded();
        return this.mReserveAmount;
    }

    public void setReserveAmount(BigDecimal reserveAmount) {
        this.protocol("reserveamount", this.mReserveAmount, reserveAmount);
        this.mReserveAmount = reserveAmount;
    }

    public BigDecimal getSalesAmount() {
        this.requireLoaded();
        return this.mSalesAmount;
    }

    public void setSalesAmount(BigDecimal salesAmount) {
        this.protocol("salesamount", this.mSalesAmount, salesAmount);
        this.mSalesAmount = salesAmount;
    }

    public short getIncreasePeriodInMonth() {
        this.requireLoaded();
        return this.mIncreasePeriodInMonth;
    }

    public void setIncreasePeriodInMonth(short increasePeriodInMonth) {
        this.protocol("increaseperiodinmonth", this.mIncreasePeriodInMonth, increasePeriodInMonth);
        this.mIncreasePeriodInMonth = increasePeriodInMonth;
    }

    public CalcMethod getCalcMethod() {
        this.requireLoaded();
        return this.mDepreciationMethod;
    }

    public void setCalcMethod(CalcMethod depreciationMethod) {
        this.protocol("depreciationMethod", (IPersistentObject)this.mDepreciationMethod, (IPersistentObject)depreciationMethod);
        this.mDepreciationMethod = depreciationMethod;
    }

    public String getNote() {
        this.requireLoaded();
        return this.mNote;
    }

    public void setNote(String note) {
        this.protocol("note", this.mNote, note);
        this.mNote = note;
    }

    public String[] getAnalysisCodes() {
        this.requireLoaded();
        return this.mAnalcodes;
    }

    public void setAnalysisCodes(String[] analcodes) throws BusinessDomainException {
        this.mAnalcodes = AnalysisCodeManager.getInstance().checkFixedAssetTransactionCodes((Company)this.getAccountingCompany(), analcodes, null);
    }

    public boolean getIsBooked() {
        this.requireLoaded();
        return this.mIsBooked;
    }

    public void setIsBooked(boolean isBooked) {
        this.protocol("isbooked", this.mIsBooked, isBooked);
        this.mIsBooked = isBooked;
    }

    public boolean getIsCanceled() {
        this.requireLoaded();
        return this.mIsCanceled;
    }

    public void setIsCanceled(boolean isCanceled) {
        this.protocol("iscanceled", this.mIsCanceled, isCanceled);
        this.mIsCanceled = isCanceled;
    }

    public boolean getIsCancelation() {
        this.requireLoaded();
        return this.mIsCancelation;
    }

    public void setIsCancelation(boolean isCancelation) {
        this.protocol("iscancelation", this.mIsCancelation, isCancelation);
        this.mIsCancelation = isCancelation;
    }

    public boolean getIsQuantityFor_ToFixedAsset() {
        this.requireLoaded();
        return this.mIsQuantityFor_ToFixedAsset;
    }

    public void setIsQuantityFor_ToFixedAsset(boolean isQuantityFor_ToFixedAsset) {
        this.protocol("isquantityfor_tofixedasset", this.mIsQuantityFor_ToFixedAsset, isQuantityFor_ToFixedAsset);
        this.mIsQuantityFor_ToFixedAsset = isQuantityFor_ToFixedAsset;
    }

    public FATransactionAmount[] getCurrencyAmounts() {
        this.requireLoaded();
        return this.mCurrencyAmounts;
    }

    public void setCurrencyAmounts(FATransactionAmount[] currencyAmounts) {
        this.mCurrencyAmounts = currencyAmounts;
    }

    public ReserveCreationEnum getReserveCreationType() {
        this.requireLoaded();
        return this.mReserveCreationType;
    }

    public void setReserveCreationType(ReserveCreationEnum reserveCreationType) {
        this.protocol("reservecreationtype", ReserveCreationTypeMapper.toString((ReserveCreationEnum)this.mReserveCreationType), ReserveCreationTypeMapper.toString((ReserveCreationEnum)reserveCreationType));
        this.mReserveCreationType = reserveCreationType;
    }

    public DeterminationDisposalValueEnum getDeterminationDisposalValueType() {
        this.requireLoaded();
        return this.mDeterminationDisposalValueType;
    }

    public void setDeterminationDisposalValueType(DeterminationDisposalValueEnum determinationDisposalValueType) {
        this.protocol("determinationdisposalvaluetype", DeterminationDisposalValueTypeMapper.toString((DeterminationDisposalValueEnum)this.mDeterminationDisposalValueType), DeterminationDisposalValueTypeMapper.toString((DeterminationDisposalValueEnum)determinationDisposalValueType));
        this.mDeterminationDisposalValueType = determinationDisposalValueType;
    }

    public BigDecimal getAccumulatedAcquisitionAmount() {
        this.requireLoaded();
        return this.mAccumulatedAcquisitionAmount;
    }

    public void setAccumulatedAcquisitionAmount(BigDecimal accumulatedAcquisitionAmount) {
        this.protocol("accumulatedacquisitionamount", this.mAccumulatedAcquisitionAmount, accumulatedAcquisitionAmount);
        this.mAccumulatedAcquisitionAmount = accumulatedAcquisitionAmount;
    }

    public BigDecimal getAccumulatedDepreciationAmount() {
        this.requireLoaded();
        return this.mAccumulatedDepreciationAmount;
    }

    public void setAccumulatedDepreciationAmount(BigDecimal accumulatedDepreciationAmount) {
        this.protocol("accumulateddepreciationamount", this.mAccumulatedDepreciationAmount, accumulatedDepreciationAmount);
        this.mAccumulatedDepreciationAmount = accumulatedDepreciationAmount;
    }

    public BigDecimal getAccumulatedSpecDepreciationAmount() {
        this.requireLoaded();
        return this.mAccumulatedSpecDepreciationAmount;
    }

    public void setAccumulatedSpecDepreciationAmount(BigDecimal accumulatedSpecDepreciationAmount) {
        this.protocol("accumulatedspecdepreciationamount", this.mAccumulatedSpecDepreciationAmount, accumulatedSpecDepreciationAmount);
        this.mAccumulatedSpecDepreciationAmount = accumulatedSpecDepreciationAmount;
    }

    public BigDecimal getAccumulatedGrant() {
        this.requireLoaded();
        return this.mAccumulatedGrant;
    }

    public void setAccumulatedGrant(BigDecimal accumulatedGrant) {
        this.protocol("accumulatedgrant", this.mAccumulatedGrant, accumulatedGrant);
        this.mAccumulatedGrant = accumulatedGrant;
    }

    public BigDecimal getAccumulatedInterest() {
        this.requireLoaded();
        return this.mAccumulatedInterest;
    }

    public void setAccumulatedInterest(BigDecimal accumulatedInterest) {
        this.protocol("accumulatedinterest", this.mAccumulatedInterest, accumulatedInterest);
        this.mAccumulatedInterest = accumulatedInterest;
    }

    public BigDecimal getNetBookValue() {
        this.requireLoaded();
        return this.mNetBookValue;
    }

    public void setNetBookValue(BigDecimal netBookValue) {
        this.protocol("netbookvalue", this.mNetBookValue, netBookValue);
        this.mNetBookValue = netBookValue;
    }

    public BigDecimal getAccumulatedQuantity() {
        this.requireLoaded();
        return this.mAccumulatedQuantity;
    }

    public void setAccumulatedQuantity(BigDecimal accumulatedQuantity) {
        this.protocol("accumulatedQuantity", this.mAccumulatedQuantity, accumulatedQuantity);
        this.mAccumulatedQuantity = accumulatedQuantity;
    }

    public BigDecimal getPartDisposAccumDeprecAmount() {
        this.requireLoaded();
        return this.mPartDisposAccumDeprecAmount;
    }

    public void setPartDisposAccumDeprecAmount(BigDecimal partDisposAccumDeprecAmount) {
        this.protocol("partdisposaccumdeprecamount", this.mPartDisposAccumDeprecAmount, partDisposAccumDeprecAmount);
        this.mPartDisposAccumDeprecAmount = partDisposAccumDeprecAmount;
    }

    public BigDecimal getPartDisposAccumSpecDeprecAmount() {
        this.requireLoaded();
        return this.mPartDisposAccumSpecDeprecAmount;
    }

    public void setPartDisposAccumSpecDeprecAmount(BigDecimal partDisposAccumSpecDeprecAmount) {
        this.protocol("partdisposaccumspecdeprecamount", this.mPartDisposAccumSpecDeprecAmount, partDisposAccumSpecDeprecAmount);
        this.mPartDisposAccumSpecDeprecAmount = partDisposAccumSpecDeprecAmount;
    }

    public BigDecimal getPartDisposAccumGrant() {
        this.requireLoaded();
        return this.mPartDisposAccumGrant;
    }

    public void setPartDisposAccumGrant(BigDecimal partDisposAccumGrant) {
        this.protocol("partdisposaccumgrant", this.mPartDisposAccumGrant, partDisposAccumGrant);
        this.mPartDisposAccumGrant = partDisposAccumGrant;
    }

    public BigDecimal getPartDisposNetBookValue() {
        this.requireLoaded();
        return this.mPartDisposNetBookValue;
    }

    public void setPartDisposNetBookValue(BigDecimal partDisposNetBookValue) {
        this.protocol("partdisposnetbookvalue", this.mPartDisposNetBookValue, partDisposNetBookValue);
        this.mPartDisposNetBookValue = partDisposNetBookValue;
    }

    public FixedAsset getFixedAssetTransferFrom() {
        this.requireLoaded();
        return this.mFixedAssetTransferFrom;
    }

    public void setFixedAssetTransferFrom(FixedAssetData fixedAssetTransferFrom) {
        this.protocol("fixedassettransferfrom", (IPersistentObject)this.mFixedAssetTransferFrom, (IPersistentObject)fixedAssetTransferFrom);
        this.mFixedAssetTransferFrom = fixedAssetTransferFrom;
    }

    public FixedAsset getFixedAssetTransferTo() {
        this.requireLoaded();
        return this.mFixedAssetTransferTo;
    }

    public void setFixedAssetTransferTo(FixedAssetData fixedAssetTransferTo) {
        this.protocol("fixedassettransferto", (IPersistentObject)this.mFixedAssetTransferTo, (IPersistentObject)fixedAssetTransferTo);
        this.mFixedAssetTransferTo = fixedAssetTransferTo;
    }

    public String getDerivation() {
        this.requireLoaded();
        return this.mDerivation;
    }

    public void setDerivation(String derivation) {
        this.protocol("derivation", this.mDerivation, derivation);
        this.mDerivation = derivation;
    }

    public Date getLastDeprDate() {
        this.requireLoaded();
        return this.mLastDeprDate;
    }

    public void setLastDeprDate(Date lastDeprDate) {
        this.protocol("lastdeprdate", this.mLastDeprDate, lastDeprDate);
        this.mLastDeprDate = lastDeprDate;
    }

    public BigDecimal getNetBookValueBeginFY() {
        this.requireLoaded();
        return this.mNetBookValueBeginFY;
    }

    public void setNetBookValueBeginFY(BigDecimal netBookValueBeginFY) {
        this.protocol("netBookValueBeginFY", this.mNetBookValueBeginFY, netBookValueBeginFY);
        this.mNetBookValueBeginFY = netBookValueBeginFY;
    }

    public BigDecimal getAccumDepr() {
        this.requireLoaded();
        return this.mAccumDepr;
    }

    public void setAccumDepr(BigDecimal accumDepr) {
        this.protocol("accumDepr", this.mAccumDepr, accumDepr);
        this.mAccumDepr = accumDepr;
    }

    public BigDecimal getAccumDeprCancel() {
        this.requireLoaded();
        return this.mAccumDeprCancel;
    }

    public void setAccumDeprCancel(BigDecimal accumDeprCancel) {
        this.protocol("accumDeprCancel", this.mAccumDeprCancel, accumDeprCancel);
        this.mAccumDeprCancel = accumDeprCancel;
    }

    public BigDecimal getAccumSpecDepr() {
        this.requireLoaded();
        return this.mAccumSpecDepr;
    }

    public void setAccumSpecDepr(BigDecimal accumSpecDepr) {
        this.protocol("accumSpecDepr", this.mAccumSpecDepr, accumSpecDepr);
        this.mAccumSpecDepr = accumSpecDepr;
    }

    public BigDecimal getAccumSpecDeprCancel() {
        this.requireLoaded();
        return this.mAccumSpecDeprCancel;
    }

    public void setAccumSpecDeprCancel(BigDecimal accumSpecDeprCancel) {
        this.protocol("accumSpecDeprCancel", this.mAccumSpecDeprCancel, accumSpecDeprCancel);
        this.mAccumSpecDeprCancel = accumSpecDeprCancel;
    }

    public BigDecimal getIncomeOrExpense() {
        this.requireLoaded();
        return this.mIncomeOrExpense;
    }

    public void setIncomeOrExpense(BigDecimal incomeOrExpense) {
        this.protocol("IncomeOrExpense", this.mIncomeOrExpense, incomeOrExpense);
        this.mIncomeOrExpense = incomeOrExpense;
    }

    public BigDecimal getIncomeOrExpenseCancel() {
        this.requireLoaded();
        return this.mIncomeOrExpenseCancel;
    }

    public void setIncomeOrExpenseCancel(BigDecimal incomeOrExpenseCancel) {
        this.protocol("IncomeOrExpenseCancel", this.mIncomeOrExpenseCancel, incomeOrExpenseCancel);
        this.mIncomeOrExpenseCancel = incomeOrExpenseCancel;
    }

    public BigDecimal getAccumGrant() {
        this.requireLoaded();
        return this.mAccumGrant;
    }

    public void setAccumGrant(BigDecimal accumGrant) {
        this.protocol("accumGrant", this.mAccumGrant, accumGrant);
        this.mAccumGrant = accumGrant;
    }

    public BigDecimal getAccumGrantCancel() {
        this.requireLoaded();
        return this.mAccumGrantCancel;
    }

    public void setAccumGrantCancel(BigDecimal accumGrantCancel) {
        this.protocol("accumGrantCancel", this.mAccumGrantCancel, accumGrantCancel);
        this.mAccumGrantCancel = accumGrantCancel;
    }

    public BigDecimal getAccumWriteUp() {
        this.requireLoaded();
        return this.mAccumWriteUp;
    }

    public void setAccumWriteUp(BigDecimal accumWriteUp) {
        this.protocol("accumWriteUp", this.mAccumWriteUp, accumWriteUp);
        this.mAccumWriteUp = accumWriteUp;
    }

    public BigDecimal getAccumWriteUpCancel() {
        this.requireLoaded();
        return this.mAccumWriteUpCancel;
    }

    public void setAccumWriteUpCancel(BigDecimal accumWriteUpCancel) {
        this.protocol("accumWriteUpCancel", this.mAccumWriteUpCancel, accumWriteUpCancel);
        this.mAccumWriteUpCancel = accumWriteUpCancel;
    }

    public BigDecimal getAccumWriteDown() {
        this.requireLoaded();
        return this.mAccumWriteDown;
    }

    public void setAccumWriteDown(BigDecimal accumWriteDown) {
        this.protocol("accumWriteDown", this.mAccumWriteDown, accumWriteDown);
        this.mAccumWriteDown = accumWriteDown;
    }

    public BigDecimal getAccumWriteDownCancel() {
        this.requireLoaded();
        return this.mAccumWriteDownCancel;
    }

    public void setAccumWriteDownCancel(BigDecimal accumWriteDownCancel) {
        this.protocol("accumWriteDownCancel", this.mAccumWriteDownCancel, accumWriteDownCancel);
        this.mAccumWriteDownCancel = accumWriteDownCancel;
    }

    public AutomaticDepreciationTypeEnum getAutomaticDepreciationTyp() {
        this.requireLoaded();
        return this.mAutomDeprType;
    }

    public void setAutomaticDepreciationType(AutomaticDepreciationTypeEnum automDeprType) {
        this.protocol("automdeprtype", AutomaticDepreciationTypeMapper.toString((AutomaticDepreciationTypeEnum)this.mAutomDeprType), AutomaticDepreciationTypeMapper.toString((AutomaticDepreciationTypeEnum)automDeprType));
        this.mAutomDeprType = automDeprType;
    }

    public NominalLedgerAccount getAssetAccountOld() {
        this.requireLoaded();
        if (this.mAssetAccountOld != null) {
            return this.mAssetAccountOld.getNominalLedgerAccount();
        }
        return null;
    }

    public NLAccountCompanySetting getAssetAccountOldSetting() {
        this.requireLoaded();
        return this.mAssetAccountOld;
    }

    public void setAssetAccountOld(NLAccountCompanySetting assetAccountOld) {
        this.mAssetAccountOld = assetAccountOld;
    }

    public boolean getBasedOnExternalAudit() {
        this.requireLoaded();
        return this.mBasedOnExternalAudit;
    }

    public void setBasedOnExternalAudit(boolean basedOnExternalAudit) {
        this.protocol("basedOnExternalAudit", this.mBasedOnExternalAudit, basedOnExternalAudit);
        this.mBasedOnExternalAudit = basedOnExternalAudit;
    }

    public Date getCommissioningDate() {
        this.requireLoaded();
        return this.mCommissioningDate;
    }

    public void setCommissioningDate(Date commissioningDate) {
        this.protocol("commissioningdate", this.mCommissioningDate, commissioningDate);
        this.mCommissioningDate = commissioningDate;
    }

    public IncreaseLifeEnum getIncreaseLifeType() {
        this.requireLoaded();
        return this.mIncreaseLifeType;
    }

    public void setIncreaseLifeType(IncreaseLifeEnum increaseLifeType) {
        this.protocol("increaselifetype", IncreaseLifeTypeMapper.toString((IncreaseLifeEnum)this.mIncreaseLifeType), IncreaseLifeTypeMapper.toString((IncreaseLifeEnum)increaseLifeType));
        this.mIncreaseLifeType = increaseLifeType;
    }

    public FixedAsset getAssetGroupOld() {
        this.requireLoaded();
        return this.mAssetGroupOld;
    }

    public void setAssetGroupOld(FixedAsset assetGroupOld) {
        this.protocol("assetgroupold", (IPersistentObject)this.mAssetGroupOld, (IPersistentObject)assetGroupOld);
        this.mAssetGroupOld = assetGroupOld;
    }

    public FixedAsset getAssetGroupNew() {
        this.requireLoaded();
        return this.mAssetGroupNew;
    }

    public void setAssetGroupNew(FixedAsset assetGroupNew) {
        this.protocol("assetgroupnew", (IPersistentObject)this.mAssetGroupNew, (IPersistentObject)assetGroupNew);
        this.mAssetGroupNew = assetGroupNew;
    }

    public NominalLedgerAccount getAccValuationDeprOld() {
        this.requireLoaded();
        if (this.mAccValuationDeprOld != null) {
            return this.mAccValuationDeprOld.getNominalLedgerAccount();
        }
        return null;
    }

    public NLAccountCompanySetting getAccValuationDeprOldSetting() {
        this.requireLoaded();
        return this.mAccValuationDeprOld;
    }

    public void setAccValuationDeprOldSetting(NLAccountCompanySetting accValuationDeprOld) {
        this.protocol("accvaluationdeprold", (IPersistentObject)this.mAccValuationDeprOld, (IPersistentObject)accValuationDeprOld);
        this.mAccValuationDeprOld = accValuationDeprOld;
    }

    public NominalLedgerAccount getAccValuationDeprNew() {
        this.requireLoaded();
        if (this.mAccValuationDeprNew != null) {
            return this.mAccValuationDeprNew.getNominalLedgerAccount();
        }
        return null;
    }

    public NLAccountCompanySetting getAccValuationDeprNewSetting() {
        this.requireLoaded();
        return this.mAccValuationDeprNew;
    }

    public void setAccValuationDeprNewSetting(NLAccountCompanySetting accValuationDeprNew) {
        this.protocol("accvaluationdeprnew", (IPersistentObject)this.mAccValuationDeprNew, (IPersistentObject)accValuationDeprNew);
        this.mAccValuationDeprNew = accValuationDeprNew;
    }

    public AccountGroup getAccountGroupOld() {
        this.requireLoaded();
        return this.mAccountGroupOld;
    }

    public void setAccountGroupOld(AccountGroup accountGroupOld) {
        this.protocol("accountgroupold", (IPersistentObject)this.mAccountGroupOld, (IPersistentObject)accountGroupOld);
        this.mAccountGroupOld = accountGroupOld;
    }

    public AccountGroup getAccountGroupNew() {
        this.requireLoaded();
        return this.mAccountGroupNew;
    }

    public void setAccountGroupNew(AccountGroup accountGroupNew) {
        this.protocol("accountgroupnew", (IPersistentObject)this.mAccountGroupNew, (IPersistentObject)accountGroupNew);
        this.mAccountGroupNew = accountGroupNew;
    }

    public String getOidFATransactionFromAccounting() {
        this.requireLoaded();
        return this.mOidFATransactionFromAccounting;
    }

    public void setOidFATransactionFromAccounting(String oidFATransactionFromAccounting) {
        this.protocol("oidfatransactionfromaccounting", this.mOidFATransactionFromAccounting, oidFATransactionFromAccounting);
        this.mOidFATransactionFromAccounting = oidFATransactionFromAccounting;
    }

    public CostCentreBase getCostCentreOld() {
        this.requireLoaded();
        return this.mCostCentreOld;
    }

    public void setCostCentreOld(CostCentreBase costCentreOld) {
        this.protocol("costcentreold", (IPersistentObject)this.mCostCentreOld, (IPersistentObject)costCentreOld);
        this.mCostCentreOld = costCentreOld;
    }

    public CostCentreBase getCostCentreNew() {
        this.requireLoaded();
        return this.mCostCentreNew;
    }

    public void setCostCentreNew(CostCentreBase costCentreNew) {
        this.protocol("costcentrenew", (IPersistentObject)this.mCostCentreNew, (IPersistentObject)costCentreNew);
        this.mCostCentreNew = costCentreNew;
    }

    public Falocation getLocationOld() {
        this.requireLoaded();
        return this.mLocationOld;
    }

    public void setLocationOld(Falocation locationOld) {
        this.protocol("locationold", (IPersistentObject)this.mLocationOld, (IPersistentObject)locationOld);
        this.mLocationOld = locationOld;
    }

    public Falocation getLocationNew() {
        this.requireLoaded();
        return this.mLocationNew;
    }

    public void setLocationNew(Falocation locationNew) {
        this.protocol("locationnew", (IPersistentObject)this.mLocationNew, (IPersistentObject)locationNew);
        this.mLocationNew = locationNew;
    }

    public CreditNoteProcessingTimeEnum getCreditNoteProcessingTime() {
        this.requireLoaded();
        return this.mCreditNoteProcessingTime;
    }

    public void setCreditNoteProcessingTime(CreditNoteProcessingTimeEnum creditNoteProcessingTime) {
        this.protocol("creditnoteprocessingtime", CreditNoteProcessingTimeMapper.toString((CreditNoteProcessingTimeEnum)this.mCreditNoteProcessingTime), CreditNoteProcessingTimeMapper.toString((CreditNoteProcessingTimeEnum)creditNoteProcessingTime));
        this.mCreditNoteProcessingTime = creditNoteProcessingTime;
    }

    public BigDecimal getAmountNotUsedDeprIT() {
        this.requireLoaded();
        return this.mAmountNotUsedDeprIT;
    }

    public void setAmountNotUsedDeprIT(BigDecimal amountNotUsedDeprIT) {
        this.protocol("amountnotuseddeprit", this.mAmountNotUsedDeprIT, amountNotUsedDeprIT);
        this.mAmountNotUsedDeprIT = amountNotUsedDeprIT;
    }

    public TransactionTypeEnum getTransactionType() {
        this.requireLoaded();
        return this.mTransactionTypeAcc;
    }

    public void setTransactionType(TransactionTypeEnum transactionTypeAcc) {
        this.protocol("transactiontypeacc", TransactionTypeMapper.toString((TransactionTypeEnum)this.mTransactionTypeAcc), TransactionTypeMapper.toString((TransactionTypeEnum)transactionTypeAcc));
        this.mTransactionTypeAcc = transactionTypeAcc;
    }

    public TransactionType getNLTransactionType() {
        this.requireLoaded();
        return this.mNLTransactionTypeAcc;
    }

    public void setNLTransactionType(TransactionType nlTransactionType) {
        this.protocol("nltransactiontypeacc", PersistableEnumUtils.toSQLPropertyValue((PersistableEnum)this.mNLTransactionTypeAcc), PersistableEnumUtils.toSQLPropertyValue((PersistableEnum)nlTransactionType));
        this.mNLTransactionTypeAcc = nlTransactionType;
    }

    public String getBarcodeNumber() {
        this.requireLoaded();
        return this.mBarcodeNumber;
    }

    public void setBarcodeNumber(String barcodeNumber) {
        this.protocol("barcodenumber", this.mBarcodeNumber, barcodeNumber);
        this.mBarcodeNumber = barcodeNumber;
    }

    public boolean getWithDisposalDepr() {
        this.requireLoaded();
        return this.mWithDisposalDepr;
    }

    public void setWithDisposalDepr(boolean withDisposalDepr) {
        this.protocol("withdisposaldepr", this.mWithDisposalDepr, withDisposalDepr);
        this.mWithDisposalDepr = withDisposalDepr;
    }

    public FullDisposDeprecUntilEnum getFullDisposDeprecUntil() {
        return this.mFullDisposDeprecUntil;
    }

    public void setFullDisposDeprecUntil(FullDisposDeprecUntilEnum fullDisposDeprecUntil) {
        this.protocol("fulldisposdeprecuntil", FullDisposDeprecUntilMapper.toString((FullDisposDeprecUntilEnum)this.mFullDisposDeprecUntil), FullDisposDeprecUntilMapper.toString((FullDisposDeprecUntilEnum)fullDisposDeprecUntil));
        this.mFullDisposDeprecUntil = fullDisposDeprecUntil;
    }

    public boolean getShowAsAddition() {
        this.requireLoaded();
        return this.mShowAsAddition;
    }

    public void setShowAsAddition(boolean showAsAddition) {
        this.protocol("showasaddition", this.mShowAsAddition, showAsAddition);
        this.mShowAsAddition = showAsAddition;
    }

    public boolean getChangeAssetNumber() {
        this.requireLoaded();
        return this.mChangeAssetNumber;
    }

    public void setChangeAssetNumber(boolean changeAssetNumber) {
        this.protocol("changeassetnumber", this.mChangeAssetNumber, changeAssetNumber);
        this.mChangeAssetNumber = changeAssetNumber;
    }

    public String getNewAssetNumber() {
        this.requireLoaded();
        return this.mNewAssetNumber;
    }

    public void setNewAssetNumber(String newAssetNumber) {
        this.protocol("newassetnumber", this.mNewAssetNumber, newAssetNumber);
        this.mNewAssetNumber = newAssetNumber;
    }

    public String getOldAssetNumber() {
        this.requireLoaded();
        return this.mOldAssetNumber;
    }

    public DepreciationFromUntilEnum getPartialDisposDeprecUntil() {
        return this.mPartialDisposDeprecUntil;
    }

    public void setPartialDisposDeprecUntil(DepreciationFromUntilEnum partialDisposDeprecUntil) {
        this.protocol("partialdisposdeprecuntil", DepreciationFromUntilMapper.toString((DepreciationFromUntilEnum)this.mPartialDisposDeprecUntil), DepreciationFromUntilMapper.toString((DepreciationFromUntilEnum)partialDisposDeprecUntil));
        this.mPartialDisposDeprecUntil = partialDisposDeprecUntil;
    }

    public boolean getPostTransaction() {
        this.requireLoaded();
        return this.mPostTransaction;
    }

    public void setPostTransaction(boolean postTransaction) {
        this.protocol("posttransaction", this.mPostTransaction, postTransaction);
        this.mPostTransaction = postTransaction;
    }

    public int getLifeInMonth() {
        this.requireLoaded();
        return this.mLifeInMonth;
    }

    public void setLifeInMonth(int lifeInMonth) {
        this.protocol("lifeinmonth", this.mLifeInMonth, lifeInMonth);
        this.mLifeInMonth = lifeInMonth;
    }

    public int getResLifeInMonth() {
        this.requireLoaded();
        return this.mResLifeInMonth;
    }

    public void setResLifeInMonth(int resLifeInMonth) {
        this.protocol("reslifeinmonth", this.mResLifeInMonth, resLifeInMonth);
        this.mResLifeInMonth = resLifeInMonth;
    }

    public FixedAssetTransaction getCorrespondingTransaction() {
        return this.mCorrespondingTransaction;
    }

    public void setCorrespondingTransaction(FixedAssetTransaction mCorrespondingTransaction) {
        this.mCorrespondingTransaction = mCorrespondingTransaction;
    }

    public BigDecimal getDepResValueNew() {
        return this.mDepResValueNew;
    }

    public void setDepResValueNew(BigDecimal mDepResValueNew) {
        this.mDepResValueNew = mDepResValueNew;
    }

    public BigDecimal getDepResValueOld() {
        return this.mDepResValueOld;
    }

    public void setDepResValueOld(BigDecimal mDepResValueOld) {
        this.mDepResValueOld = mDepResValueOld;
    }

    public CalcMethod getDepreciationMethodOld() {
        return this.mDepreciationMethodOld;
    }

    public void setDepreciationMethodOld(CalcMethod mDepreciationMethodOld) {
        this.mDepreciationMethodOld = mDepreciationMethodOld;
    }

    public static boolean checkTransactionExistence(FixedAsset fixedAsset) {
        return FixedAssetTransactionPersistencyManager.checkTransactionExistence((FixedAsset)fixedAsset);
    }

    public static boolean checkDeprAreaTransactionExistence(FixedAsset fixedAsset, DepreciationArea deprArea) {
        return FixedAssetTransactionPersistencyManager.checkDeprAreaTransactionExistence((FixedAsset)fixedAsset, (DepreciationArea)deprArea);
    }

    public static boolean checkTransactionsAfterDisposal(FixedAsset fixedAsset, DepreciationArea deprArea, Date processingDate) {
        Junction junction = Restrictions.conjunction().add(Restrictions.eq((String)"oidfixedasset", (String)fixedAsset.getObjectid())).add(Restrictions.eq((String)"oiddeprearea", (String)deprArea.getObjectid())).add(Restrictions.ne((String)"transactenum", (String)String.valueOf(TransactionEnum.TRE_AUTOMATIC_DEPR.value()))).add(Restrictions.ne((String)"transactenum", (String)String.valueOf(TransactionEnum.TRE_AUTOMATIC_SPEC_DEPR.value()))).add(Restrictions.ne((String)"transactenum", (String)String.valueOf(TransactionEnum.TRE_INTERESTS.value()))).add(Restrictions.ne((String)"transactenum", (String)String.valueOf(TransactionEnum.TRE_FULL_DISPOSAL.value()))).add(Restrictions.ne((String)"transactenum", (String)String.valueOf(TransactionEnum.TRE_FULL_REPOST.value()))).add(Restrictions.gt((String)"processingdate", (String)DateMapper.toString((Date)processingDate))).add(Restrictions.ne((String)"iscancelled", (String)BooleanMapper.toString((boolean)true))).add(Restrictions.ne((String)"iscancellation", (String)BooleanMapper.toString((boolean)true)));
        return FixedAssetTransactionPersistencyManager.checkTransactionExistence((Criterion)junction);
    }

    public static boolean checkTransactionsOfTypeFullRepostAfterDisposal(FixedAsset fixedAsset, DepreciationArea deprArea, Date processingDate) {
        Junction junction = Restrictions.conjunction().add(Restrictions.eq((String)"oidfixedasset", (String)fixedAsset.getObjectid())).add(Restrictions.eq((String)"oiddeprearea", (String)deprArea.getObjectid())).add(Restrictions.eq((String)"transactenum", (String)String.valueOf(TransactionEnum.TRE_FULL_REPOST.value()))).add(Restrictions.gt((String)"processingdate", (String)DateMapper.toString((Date)processingDate))).add(Restrictions.ne((String)"iscancelled", (String)BooleanMapper.toString((boolean)true))).add(Restrictions.ne((String)"iscancellation", (String)BooleanMapper.toString((boolean)true)));
        return FixedAssetTransactionPersistencyManager.checkTransactionExistence((Criterion)junction);
    }

    public static boolean checkTransactionsAfterActivateAssetUnderConstruction(FixedAsset fixedAsset, DepreciationArea deprArea, Date processingDate) {
        Junction junction = Restrictions.conjunction().add(Restrictions.eq((String)"oidfixedasset", (String)fixedAsset.getObjectid())).add(Restrictions.eq((String)"oiddeprearea", (String)deprArea.getObjectid())).add(Restrictions.ne((String)"transactenum", (String)String.valueOf(TransactionEnum.TRE_PARTIAL_ADDITION.value()))).add(Restrictions.ne((String)"transactenum", (String)String.valueOf(TransactionEnum.TRE_POST_CAPITALIZATION.value()))).add(Restrictions.ne((String)"transactenum", (String)String.valueOf(TransactionEnum.TRE_CREDIT_NOTE.value()))).add(Restrictions.gt((String)"processingdate", (String)DateMapper.toString((Date)processingDate))).add(Restrictions.ne((String)"iscancelled", (String)BooleanMapper.toString((boolean)true))).add(Restrictions.ne((String)"iscancellation", (String)BooleanMapper.toString((boolean)true)));
        return FixedAssetTransactionPersistencyManager.checkTransactionExistence((Criterion)junction);
    }

    public static boolean checkTransactionsOfTypeRepost(FixedAsset fixedAsset) {
        Junction junction = Restrictions.conjunction().add(Restrictions.eq((String)"oidfixedasset", (String)fixedAsset.getObjectid())).add((Criterion)Restrictions.disjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"transactenum", (String)Integer.toString(TransactionEnum.TRE_PARTIAL_REPOST.value())), Restrictions.eq((String)"transactenum", (String)Integer.toString(TransactionEnum.TRE_REPOST_ADDITION.value())), Restrictions.eq((String)"transactenum", (String)Integer.toString(TransactionEnum.TRE_FULL_REPOST.value()))}));
        return FixedAssetTransactionPersistencyManager.checkTransactionExistence((Criterion)junction);
    }

    public static boolean checkTransactionExistence(FixedAssetArea faArea, FAFinancialYear faFinYear) {
        return FixedAssetTransactionPersistencyManager.checkTransactionExistence((FixedAssetArea)faArea, (FAFinancialYear)faFinYear);
    }

    public static boolean checkTransactionExistenceForFixedAssetArea(FixedAsset fixedAsset, DepreciationArea deprArea) {
        return FixedAssetTransactionPersistencyManager.checkTransactionExistenceForFixedAssetArea((FixedAsset)fixedAsset, (DepreciationArea)deprArea);
    }

    public static Date getBiggestProcessingDateForCompany(AccountingCompany accountCompany) {
        try {
            return FatransactionPersistencyAppl.getBiggestProcessingDateForCompany((String)accountCompany.getObjectid());
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    public static Date getInitialAdditionProcessingDate(Date processingDate, FixedAssetData fixedAsset, DepreciationArea deprArea) {
        Date initialProcessingDate = null;
        FixedAssetTransaction[] initialAddition = FixedAssetTransaction.getTransactionsOfTypeAddition(fixedAsset, deprArea);
        if (initialAddition.length > 0 && DateHelper.before((Date)processingDate, (Date)initialAddition[0].getProcessingDate())) {
            initialProcessingDate = initialAddition[0].getProcessingDate();
        }
        return initialProcessingDate;
    }

    public static FixedAssetTransaction getTransactionForBelongsToBalanceSheetArea(FixedAssetTransaction[] transactions) {
        for (int i = 0; i < transactions.length; ++i) {
            if (!transactions[i].getDeprArea().getBelongsToBalanceSheet()) continue;
            return transactions[i];
        }
        return null;
    }

    public static FixedAssetTransaction getTransactionForForeignArea(FixedAssetTransaction[] transactions, FATransactionFromAccounting transactionFromAccounting) {
        for (int j = 0; j < transactions.length; ++j) {
            if (transactions[j].getDeprArea().getBelongsToBalanceSheet() || !transactions[j].getDeprArea().getCurrency().equals(transactionFromAccounting.getForeignCurrency())) continue;
            return transactions[j];
        }
        return null;
    }

    public static short getRemainingLifeIncreaseInMonths(String oidFixedAsset, String oidDepraciationArea, String value, Date documentDate) {
        LOGGER.debug("getRemainingLifeIncreaseInMonths(...)");
        FixedAssetData fixedAsset = FixedAssetPersistencyManager.getFixedAssetData((String)oidFixedAsset);
        DepreciationArea deprArea = DepreciationAreaPersistencyManager.getDepreciationArea((String)oidDepraciationArea);
        FixedAssetArea faArea = fixedAsset.getFixedAssetArea(deprArea);
        DepreciationCalculation deprCalc = new DepreciationCalculation(faArea, DepreciationFunctionEnum.DEFE_CALCULATION);
        List transactCache = deprCalc.buildTransactionsCache(null, null, null, false);
        DepreciationCalculationHelper docDate = DepreciationCalculation.getDeprCalcHelperBeforeOrEqualDate((List)transactCache, (Date)documentDate, (boolean)true, (boolean)false);
        BigDecimal HUNDRED = new BigDecimal("100.00");
        BigDecimal amount = BigDecimalMapper.toBigDecimal((String)value);
        BigDecimal acquisitionValue = docDate.getAccumAcquisitionValue();
        BigDecimal yearDeprAmount = BigDecimal.ZERO;
        if (faArea.getDepreciationPercent() != null && !BigDecimalMapper.isZeroOrNull((BigDecimal)acquisitionValue)) {
            yearDeprAmount = acquisitionValue.multiply(faArea.getDepreciationPercent()).divide(HUNDRED, 2, RoundingMode.HALF_EVEN);
            BigDecimal life = amount.divide(yearDeprAmount, 0, RoundingMode.HALF_EVEN);
            life = life.multiply(new BigDecimal("12"));
            short newLife = life.shortValue();
            return newLife;
        }
        return 0;
    }

    public static PartialDispAcqValueAndPercentageStruct getPartialAcquisitionValue(FixedAssetData fixedAsset, Date documentDate, Date processDate, String percentage, String quantity, FAFinancialYear financialYear, Date transactionDate) {
        LOGGER.debug("getPartialAcquisitionValue(...)");
        DepreciationArea deprAreaBelongsToBalanceSheet = DepreciationArea.getDepreciationAreaBelongsToBlanceSheet((AccountingCompany)fixedAsset.getAccountCompany());
        AssetaccountingSetup aaSetup = AssetaccountingSetup.getValidAssetaccountingSetup((AccountingCompany)fixedAsset.getAccountCompany());
        boolean originTransfer = false;
        Date processingDate = FixedAssetTransaction.calculateProcessingDate(fixedAsset, TransactionEnum.TRE_PARTIAL_DISPOSAL, deprAreaBelongsToBalanceSheet, documentDate, processDate, null, financialYear, null, false, null, null, transactionDate);
        Junction junction = Restrictions.conjunction().add(Restrictions.eq((String)"oidfixedasset", (String)fixedAsset.getObjectid())).add(Restrictions.le((String)"processingdate", (String)DateMapper.toString((Date)processingDate))).add(Restrictions.eq((String)"oiddeprearea", (String)deprAreaBelongsToBalanceSheet.getObjectid()));
        FixedAssetTransaction[] transactions = FixedAssetTransaction.getTransactions(aaSetup, null, (Criterion)junction);
        DepreciationCalculation deprCalc = new DepreciationCalculation(fixedAsset.getFixedAssetArea(deprAreaBelongsToBalanceSheet), DepreciationFunctionEnum.DEFE_CALCULATION);
        deprCalc.buildTransactionsCache(transactions);
        BigDecimal acquisitionValue = transactions[transactions.length - 1].getAccumulatedAcquisitionAmount();
        BigDecimal partDisposAcquisitionValue = BigDecimal.ZERO;
        BigDecimal bdPercentage = BigDecimalMapper.toBigDecimalZero((String)percentage.replace(",", "."));
        BigDecimal bdQuantity = BigDecimalMapper.toBigDecimalZero((String)quantity);
        BigDecimal faQuantity = BigDecimalMapper.toBigDecimalZero((String)fixedAsset.getQuantity());
        if (bdQuantity.compareTo(BigDecimal.ZERO) != 0 && bdPercentage.compareTo(BigDecimal.ZERO) == 0) {
            bdPercentage = new BigDecimal("100.00").multiply(bdQuantity).divide(faQuantity, 20, RoundingMode.HALF_EVEN);
        }
        if (bdPercentage.compareTo(BigDecimal.ZERO) < 0) {
            bdPercentage = bdPercentage.negate();
        }
        if (bdPercentage.compareTo(BigDecimal.ZERO) != 0) {
            partDisposAcquisitionValue = acquisitionValue.multiply(bdPercentage).divide(new BigDecimal("100.00"), 20, RoundingMode.HALF_DOWN).negate();
            partDisposAcquisitionValue = partDisposAcquisitionValue.setScale(2, RoundingMode.HALF_EVEN);
        }
        return new PartialDispAcqValueAndPercentageStruct(BigDecimalMapper.toString((BigDecimal)bdPercentage), BigDecimalMapper.toString((BigDecimal)partDisposAcquisitionValue));
    }

    public static FixedAssetTransaction[] getTransactions(AssetaccountingSetup aaSetup, Order[] order, Criterion filter) {
        FixedAssetTransaction[] transactions = FixedAssetTransactionPersistencyManager.getTransactions((AssetaccountingSetup)aaSetup, (Order[])order, (Criterion)filter);
        return transactions;
    }

    public static boolean getExistsDepreciationsForDeprArea(DepreciationArea deprArea) {
        return FixedAssetTransactionPersistencyManager.getExistsDepreciationsForDeprArea((DepreciationArea)deprArea);
    }

    public static boolean getExistsDepreciations(DepreciationArea deprArea) {
        boolean existsDepreciations = FixedAssetTransactionPersistencyManager.getExistsDepreciations((DepreciationArea)deprArea);
        return existsDepreciations;
    }

    public static boolean getExistsAutomSpecDepreciations(FixedAsset fixedAsset, DepreciationArea deprArea) {
        boolean existsDepreciations = FixedAssetTransactionPersistencyManager.getExistsAutomSpecDepreciations((FixedAsset)fixedAsset, (DepreciationArea)deprArea);
        return existsDepreciations;
    }

    public static FixedAssetTransaction[] getTransactions(FixedAssetData fixedAsset, DepreciationArea deprArea) {
        AssetaccountingSetup aaSetup = AssetaccountingSetup.getValidAssetaccountingSetup((AccountingCompany)fixedAsset.getAccountCompany());
        Junction junction = Restrictions.conjunction().add(Restrictions.eq((String)"oidfixedasset", (String)fixedAsset.getObjectid())).add(Restrictions.eq((String)"oiddeprearea", (String)deprArea.getObjectid()));
        return FixedAssetTransaction.getTransactions(aaSetup, null, (Criterion)junction);
    }

    public static FixedAssetTransaction[] getTransactionsOfTypeAddition(FixedAssetData fixedAsset, DepreciationArea deprArea) {
        AssetaccountingSetup aaSetup = AssetaccountingSetup.getValidAssetaccountingSetup((AccountingCompany)fixedAsset.getAccountCompany());
        Junction junction = Restrictions.conjunction().add(Restrictions.eq((String)"oidfixedasset", (String)fixedAsset.getObjectid())).add(Restrictions.eq((String)"oiddeprearea", (String)deprArea.getObjectid())).add(Restrictions.or((Criterion)Restrictions.eq((String)"transactenum", (String)TransactionMapper.toString((TransactionEnum)TransactionEnum.TRE_NEW_ADDITION)), (Criterion)Restrictions.eq((String)"transactenum", (String)TransactionMapper.toString((TransactionEnum)TransactionEnum.TRE_EXISTING_ADDITION))));
        return FixedAssetTransaction.getTransactions(aaSetup, null, (Criterion)junction);
    }

    public static FixedAssetTransaction[] getTransactionsOfTypeNewAddition(FixedAssetData fixedAsset, DepreciationArea deprArea) {
        AssetaccountingSetup aaSetup = AssetaccountingSetup.getValidAssetaccountingSetup((AccountingCompany)fixedAsset.getAccountCompany());
        Junction junction = Restrictions.conjunction().add(Restrictions.eq((String)"oidfixedasset", (String)fixedAsset.getObjectid())).add(Restrictions.eq((String)"oiddeprearea", (String)deprArea.getObjectid())).add(Restrictions.eq((String)"transactenum", (String)TransactionMapper.toString((TransactionEnum)TransactionEnum.TRE_NEW_ADDITION)));
        return FixedAssetTransaction.getTransactions(aaSetup, null, (Criterion)junction);
    }

    public static FixedAssetTransaction[] getTransactionsOfTypeAdditionForPeriod(FixedAssetData fixedAsset, DepreciationArea deprArea, Date fromDate, Date toDate) {
        AssetaccountingSetup aaSetup = AssetaccountingSetup.getValidAssetaccountingSetup((AccountingCompany)fixedAsset.getAccountCompany());
        Junction junction = Restrictions.conjunction().add(Restrictions.eq((String)"oidfixedasset", (String)fixedAsset.getObjectid())).add(Restrictions.eq((String)"oiddeprearea", (String)deprArea.getObjectid())).add(Restrictions.ge((String)"processingdate", (String)DateMapper.toString((Date)fromDate))).add(Restrictions.le((String)"processingdate", (String)DateMapper.toString((Date)toDate))).add(Restrictions.eq((String)"iscancelled", (String)BooleanMapper.toString((boolean)false))).add(Restrictions.eq((String)"iscancellation", (String)BooleanMapper.toString((boolean)false))).add((Criterion)Restrictions.disjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"transactenum", (String)TransactionMapper.toString((TransactionEnum)TransactionEnum.TRE_NEW_ADDITION)), Restrictions.eq((String)"transactenum", (String)TransactionMapper.toString((TransactionEnum)TransactionEnum.TRE_PARTIAL_ADDITION)), Restrictions.eq((String)"transactenum", (String)TransactionMapper.toString((TransactionEnum)TransactionEnum.TRE_CREDIT_NOTE)), Restrictions.eq((String)"transactenum", (String)TransactionMapper.toString((TransactionEnum)TransactionEnum.TRE_REPOST_ADDITION)), Restrictions.eq((String)"transactenum", (String)TransactionMapper.toString((TransactionEnum)TransactionEnum.TRE_POST_CAPITALIZATION))}));
        return FixedAssetTransaction.getTransactions(aaSetup, null, (Criterion)junction);
    }

    public static boolean checkExistenceOfPostCapitalizationForPeriod(FixedAssetData fixedAsset, DepreciationArea deprArea, Date fromDate, Date toDate) {
        Junction junction = Restrictions.conjunction().add(Restrictions.eq((String)"oidfixedasset", (String)fixedAsset.getObjectid())).add(Restrictions.eq((String)"oiddeprearea", (String)deprArea.getObjectid())).add(Restrictions.ge((String)"processingdate", (String)DateMapper.toString((Date)fromDate))).add(Restrictions.le((String)"processingdate", (String)DateMapper.toString((Date)toDate))).add(Restrictions.eq((String)"iscancelled", (String)BooleanMapper.toString((boolean)false))).add(Restrictions.eq((String)"iscancellation", (String)BooleanMapper.toString((boolean)false))).add(Restrictions.eq((String)"transactenum", (String)TransactionMapper.toString((TransactionEnum)TransactionEnum.TRE_POST_CAPITALIZATION)));
        return FixedAssetTransactionPersistencyManager.checkTransactionExistence((Criterion)junction);
    }

    public static FixedAssetTransaction[] getTransactionsOfTypeDisposalForPeriod(FixedAssetData fixedAsset, DepreciationArea deprArea, Date fromDate, Date toDate) {
        AssetaccountingSetup aaSetup = AssetaccountingSetup.getValidAssetaccountingSetup((AccountingCompany)fixedAsset.getAccountCompany());
        Junction junction = Restrictions.conjunction().add(Restrictions.eq((String)"oidfixedasset", (String)fixedAsset.getObjectid())).add(Restrictions.eq((String)"oiddeprearea", (String)deprArea.getObjectid())).add(Restrictions.ge((String)"processingdate", (String)DateMapper.toString((Date)fromDate))).add(Restrictions.le((String)"processingdate", (String)DateMapper.toString((Date)toDate))).add(Restrictions.eq((String)"iscancelled", (String)BooleanMapper.toString((boolean)false))).add(Restrictions.eq((String)"iscancellation", (String)BooleanMapper.toString((boolean)false))).add((Criterion)Restrictions.disjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"transactenum", (String)TransactionMapper.toString((TransactionEnum)TransactionEnum.TRE_FULL_DISPOSAL)), Restrictions.eq((String)"transactenum", (String)TransactionMapper.toString((TransactionEnum)TransactionEnum.TRE_PARTIAL_DISPOSAL))}));
        return FixedAssetTransaction.getTransactions(aaSetup, null, (Criterion)junction);
    }

    public static FixedAssetTransaction[] getTransactionsOfTypeFullDisposal(FixedAssetData fixedAsset, DepreciationArea deprArea) {
        AssetaccountingSetup aaSetup = AssetaccountingSetup.getValidAssetaccountingSetup((AccountingCompany)fixedAsset.getAccountCompany());
        Junction junction = Restrictions.conjunction().add(Restrictions.eq((String)"oidfixedasset", (String)fixedAsset.getObjectid())).add(Restrictions.eq((String)"oiddeprearea", (String)deprArea.getObjectid())).add(Restrictions.eq((String)"transactenum", (String)TransactionMapper.toString((TransactionEnum)TransactionEnum.TRE_FULL_DISPOSAL)));
        return FixedAssetTransaction.getTransactions(aaSetup, null, (Criterion)junction);
    }

    public static FixedAssetTransaction[] getTransactionsOfTypeAssetAccountTransfer(FixedAssetArea fixedAssetArea) {
        AssetaccountingSetup aaSetup = AssetaccountingSetup.getValidAssetaccountingSetup((AccountingCompany)fixedAssetArea.getFixedAsset().getAccountCompany());
        Junction junction = Restrictions.conjunction().add(Restrictions.eq((String)"oidfixedasset", (String)fixedAssetArea.getFixedAsset().getObjectid())).add(Restrictions.eq((String)"oiddeprearea", (String)fixedAssetArea.getDeprArea().getObjectid())).add((Criterion)Restrictions.disjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"transactenum", (String)TransactionMapper.toString((TransactionEnum)TransactionEnum.TRE_NOM_LEDGER_TRANSFER)), Restrictions.eq((String)"transactenum", (String)TransactionMapper.toString((TransactionEnum)TransactionEnum.TRE_ACTIVATE_ASSET_UNDER_CONSTR))})).add(Restrictions.eq((String)"iscancelled", (String)BooleanMapper.toString((boolean)false))).add(Restrictions.eq((String)"iscancellation", (String)BooleanMapper.toString((boolean)false)));
        Order[] order = new Order[]{Order.asc((String)"processingdate"), Order.asc((String)"transactnumber"), Order.asc((String)"transactenum"), Order.asc((String)"iscancellation")};
        return FixedAssetTransaction.getTransactions(aaSetup, order, (Criterion)junction);
    }

    private static FixedAssetTransaction getOldestTransactionExceptForNewAddition(FixedAssetData fixedAsset, DepreciationArea deprArea) {
        AssetaccountingSetup aaSetup = AssetaccountingSetup.getValidAssetaccountingSetup((AccountingCompany)fixedAsset.getAccountCompany());
        String[] values = new String[]{Integer.toString(0), Integer.toString(1)};
        Junction junction = Restrictions.conjunction().add(Restrictions.eq((String)"oidfixedasset", (String)fixedAsset.getObjectid())).add(Restrictions.eq((String)"oiddeprearea", (String)deprArea.getObjectid())).add(Restrictions.eq((String)"iscancelled", (String)BooleanMapper.toString((boolean)false))).add(Restrictions.eq((String)"iscancellation", (String)BooleanMapper.toString((boolean)false))).add(Restrictions.not((Criterion)Restrictions.in((String)"transactenum", (String[])values)));
        FixedAssetTransaction[] transactions = FixedAssetTransaction.getTransactions(aaSetup, null, (Criterion)junction);
        if (transactions.length > 0) {
            return transactions[0];
        }
        return null;
    }

    public static Date calculateProcessingDate(FixedAssetData fixedAsset, TransactionEnum transactionType, DepreciationArea deprArea, Date documentDate, Date processingDate, Date commissioningDate, FAFinancialYear financialYear, CreditNoteProcessingTimeEnum creditNoteProcessingTimeType, boolean originTransfer, FullDisposDeprecUntilEnum fullDisposDeprecUntilTypeLinked, DepreciationFromUntilEnum deprecUntilTypeLinked, Date transactionDate) {
        try {
            Date middDate;
            int month;
            int halfyear;
            FixedAssetArea[] fixedAssetAreas = fixedAsset.getFixedAssetAreas();
            FAFinancialYear finYearForProcessingDate = financialYear;
            if (finYearForProcessingDate == null || documentDate != null && DateHelper.before((Date)documentDate, (Date)finYearForProcessingDate.getValidFrom()) && transactionType.value() != 1) {
                finYearForProcessingDate = FAFinancialYear.getFAFinancialYearForDate((AccountingCompany)fixedAsset.getAccountCompany(), (Date)documentDate);
            }
            if (transactionType.value() == 0 || transactionType.value() == 1) {
                for (int i = 0; i < fixedAssetAreas.length; ++i) {
                    if (!fixedAssetAreas[i].getDeprArea().equals((Object)deprArea)) continue;
                    if (fixedAssetAreas[i].getDepreciationStart() != null && fixedAssetAreas[i].getDepreciationStart().value() == 5 && fixedAssetAreas[i].getDeprStartDate() != null && !deprArea.getAverage()) {
                        processingDate = fixedAssetAreas[i].getDeprStartDate();
                        continue;
                    }
                    processingDate = DateHelper.getFirstDayOfMonth((Date)fixedAsset.getAcquisitionDate());
                    if (fixedAssetAreas[i].getDeprStartDate() != null && DateHelper.before((Date)fixedAssetAreas[i].getDeprStartDate(), (Date)processingDate)) {
                        processingDate = fixedAssetAreas[i].getDeprStartDate();
                    }
                    if (fixedAssetAreas[i].getStatus().value() != 1 || deprArea.getJurisdictionType() != JurisdictionType.PL) continue;
                    if (fixedAsset.getCommissioningDate() != null) {
                        processingDate = DateHelper.getFirstDayOfMonth((Date)fixedAsset.getCommissioningDate());
                    }
                    if (processingDate != null || fixedAsset.getAcquisitionDate() == null) continue;
                    processingDate = DateHelper.getFirstDayOfMonth((Date)fixedAsset.getAcquisitionDate());
                }
            } else if (transactionType.value() == 2) {
                if (originTransfer) {
                    processingDate = DateHelper.getFirstDayOfMonth((Date)documentDate);
                } else {
                    for (int i = 0; i < fixedAssetAreas.length; ++i) {
                        Date initialProcessingDate;
                        if (!fixedAssetAreas[i].getDeprArea().equals((Object)deprArea)) continue;
                        if (creditNoteProcessingTimeType == null) {
                            creditNoteProcessingTimeType = CreditNoteProcessingTimeEnum.from_int((int)2);
                        }
                        switch (creditNoteProcessingTimeType.value()) {
                            case 0: {
                                if (fixedAssetAreas[i].getStatus().value() == 3 || fixedAssetAreas[i].getStatus().value() == 5 || fixedAssetAreas[i].getStatus().value() == 7) {
                                    processingDate = DateHelper.getFirstDayOfMonth((Date)documentDate);
                                    if (processingDate == null || !DateHelper.before((Date)processingDate, (Date)fixedAsset.getAcquisitionDate())) break;
                                    processingDate = fixedAsset.getAcquisitionDate();
                                    break;
                                }
                                if (fixedAssetAreas[i].getStatus().value() == 1) {
                                    processingDate = DateHelper.getFirstDayOfMonth((Date)documentDate);
                                    if (deprArea.getJurisdictionType() == JurisdictionType.PL) {
                                        if (processingDate == null || !DateHelper.before((Date)processingDate, (Date)fixedAsset.getAcquisitionDate())) break;
                                        processingDate = fixedAsset.getAcquisitionDate();
                                        break;
                                    }
                                    if (processingDate == null || !DateHelper.before((Date)processingDate, (Date)fixedAsset.getAcquisitionDate())) break;
                                    processingDate = DateHelper.getFirstDayOfMonth((Date)fixedAsset.getAcquisitionDate());
                                    break;
                                }
                                if (deprArea.getJurisdictionType() == JurisdictionType.CZ && deprArea.getNote().equals("PARTIAL_ADDITION_CZ")) {
                                    processingDate = DateHelper.getFirstDayOfMonth((Date)documentDate);
                                    if (fixedAssetAreas[i].getDeprStartDate() == null || !DateHelper.after((Date)fixedAssetAreas[i].getDeprStartDate(), (Date)processingDate)) break;
                                    processingDate = fixedAssetAreas[i].getDeprStartDate();
                                    break;
                                }
                                processingDate = fixedAssetAreas[i].getDeprStartDate();
                                if (processingDate == null || !DateHelper.after((Date)finYearForProcessingDate.getValidFrom(), (Date)processingDate)) break;
                                processingDate = DateHelper.getFirstDayOfMonth((Date)documentDate);
                                break;
                            }
                            case 1: {
                                processingDate = finYearForProcessingDate.getValidFrom();
                                if (fixedAssetAreas[i].getStatus().value() == 3 || fixedAssetAreas[i].getStatus().value() == 5 || fixedAssetAreas[i].getStatus().value() == 7) {
                                    if (processingDate == null || !DateHelper.before((Date)processingDate, (Date)fixedAsset.getAcquisitionDate())) break;
                                    processingDate = fixedAsset.getAcquisitionDate();
                                    break;
                                }
                                if (fixedAssetAreas[i].getStatus().value() == 1) {
                                    if (deprArea.getJurisdictionType() == JurisdictionType.PL) {
                                        if (processingDate == null || !DateHelper.before((Date)processingDate, (Date)fixedAsset.getAcquisitionDate())) break;
                                        processingDate = fixedAsset.getAcquisitionDate();
                                        break;
                                    }
                                    if (processingDate == null || !DateHelper.before((Date)processingDate, (Date)fixedAsset.getAcquisitionDate())) break;
                                    processingDate = DateHelper.getFirstDayOfMonth((Date)fixedAsset.getAcquisitionDate());
                                    break;
                                }
                                if (processingDate == null || !DateHelper.before((Date)processingDate, (Date)fixedAssetAreas[i].getDeprStartDate()) || !DateHelper.before((Date)fixedAssetAreas[i].getDeprStartDate(), (Date)fixedAsset.getAcquisitionDate())) break;
                                processingDate = fixedAssetAreas[i].getDeprStartDate();
                                break;
                            }
                            case 2: {
                                processingDate = DateHelper.getFirstDayOfMonth((Date)documentDate);
                                if (fixedAssetAreas[i].getStatus().value() == 3 || fixedAssetAreas[i].getStatus().value() == 5 || fixedAssetAreas[i].getStatus().value() == 7) {
                                    if (processingDate == null || !DateHelper.before((Date)processingDate, (Date)fixedAsset.getAcquisitionDate())) break;
                                    processingDate = fixedAsset.getAcquisitionDate();
                                    break;
                                }
                                if (fixedAssetAreas[i].getStatus().value() == 1) {
                                    if (deprArea.getJurisdictionType() == JurisdictionType.PL) {
                                        if (processingDate == null || !DateHelper.before((Date)processingDate, (Date)fixedAsset.getAcquisitionDate())) break;
                                        processingDate = fixedAsset.getAcquisitionDate();
                                        break;
                                    }
                                    if (processingDate == null || !DateHelper.before((Date)processingDate, (Date)fixedAsset.getAcquisitionDate())) break;
                                    processingDate = DateHelper.getFirstDayOfMonth((Date)fixedAsset.getAcquisitionDate());
                                    break;
                                }
                                if (processingDate == null || !DateHelper.before((Date)processingDate, (Date)fixedAssetAreas[i].getDeprStartDate()) || !DateHelper.before((Date)fixedAssetAreas[i].getDeprStartDate(), (Date)fixedAsset.getAcquisitionDate())) break;
                                processingDate = fixedAssetAreas[i].getDeprStartDate();
                                break;
                            }
                            case 3: {
                                processingDate = DateHelper.getFirstDayOfMonth((Date)documentDate);
                                if (deprArea.getJurisdictionType() == JurisdictionType.CZ && deprArea.getNote().equals("PARTIAL_ADDITION_CZ")) {
                                    processingDate = DateHelper.getFirstDayOfMonth((Date)documentDate);
                                } else {
                                    int month2 = finYearForProcessingDate.getFinancialPeriods().length;
                                    if (month2 > 2) {
                                        halfyear = month2 / 2;
                                        Date middDate2 = new VDate(DateHelper.getFirstDayOfMonth((Date)finYearForProcessingDate.getValidFrom())).addMonths(halfyear).getDate();
                                        processingDate = DateHelper.afterOrEqual((Date)processingDate, (Date)middDate2) ? middDate2 : finYearForProcessingDate.getValidFrom();
                                    }
                                }
                                if (fixedAssetAreas[i].getStatus().value() == 3 || fixedAssetAreas[i].getStatus().value() == 5 || fixedAssetAreas[i].getStatus().value() == 7) {
                                    if (processingDate == null || !DateHelper.before((Date)processingDate, (Date)fixedAsset.getAcquisitionDate())) break;
                                    processingDate = fixedAsset.getAcquisitionDate();
                                    break;
                                }
                                if (fixedAssetAreas[i].getStatus().value() == 1) {
                                    if (processingDate == null || !DateHelper.before((Date)processingDate, (Date)fixedAsset.getAcquisitionDate())) break;
                                    processingDate = DateHelper.getFirstDayOfMonth((Date)fixedAsset.getAcquisitionDate());
                                    break;
                                }
                                if (processingDate == null || !DateHelper.before((Date)processingDate, (Date)fixedAssetAreas[i].getDeprStartDate())) break;
                                processingDate = fixedAssetAreas[i].getDeprStartDate();
                                break;
                            }
                            case 4: {
                                processingDate = documentDate;
                                break;
                            }
                            case 5: {
                                processingDate = DateHelper.getLastDayOfMonth((Date)documentDate);
                                break;
                            }
                            case 6: {
                                processingDate = transactionDate;
                            }
                        }
                        if (processingDate == null) {
                            processingDate = fixedAsset.getAcquisitionDate();
                        }
                        if ((initialProcessingDate = FixedAssetTransaction.getInitialAdditionProcessingDate(processingDate, fixedAsset, deprArea)) == null) continue;
                        processingDate = initialProcessingDate;
                    }
                }
            } else if (transactionType.value() == 4) {
                if (originTransfer) {
                    processingDate = DateHelper.getFirstDayOfMonth((Date)documentDate);
                } else {
                    for (int i = 0; i < fixedAssetAreas.length; ++i) {
                        if (!fixedAssetAreas[i].getDeprArea().equals((Object)deprArea)) continue;
                        if (creditNoteProcessingTimeType == null) {
                            creditNoteProcessingTimeType = CreditNoteProcessingTimeEnum.from_int((int)2);
                        }
                        switch (creditNoteProcessingTimeType.value()) {
                            case 0: {
                                processingDate = fixedAssetAreas[i].getDeprStartDate();
                                FixedAssetTransaction[] transaction = FixedAssetTransaction.getTransactionsOfTypeAddition(fixedAsset, deprArea);
                                if (transaction.length == 1 && transaction[0].getTransactionEnum().value() == 1 && transaction[0].getLastDeprDate() != null) {
                                    processingDate = DateHelper.tomorrow((Date)transaction[0].getLastDeprDate());
                                }
                                if (processingDate != null) break;
                                processingDate = fixedAsset.getAcquisitionDate();
                                break;
                            }
                            case 1: {
                                processingDate = finYearForProcessingDate.getValidFrom();
                                break;
                            }
                            case 2: {
                                processingDate = DateHelper.getFirstDayOfMonth((Date)documentDate);
                                break;
                            }
                            case 3: {
                                processingDate = DateHelper.getFirstDayOfMonth((Date)documentDate);
                                month = finYearForProcessingDate.getFinancialPeriods().length;
                                if (month > 2) {
                                    int halfyear2 = month / 2;
                                    middDate = new VDate(DateHelper.getFirstDayOfMonth((Date)finYearForProcessingDate.getValidFrom())).addMonths(halfyear2).getDate();
                                    processingDate = DateHelper.afterOrEqual((Date)processingDate, (Date)middDate) ? middDate : finYearForProcessingDate.getValidFrom();
                                }
                                if (fixedAssetAreas[i].getStatus().value() == 3 || fixedAssetAreas[i].getStatus().value() == 5 || fixedAssetAreas[i].getStatus().value() == 7) {
                                    if (processingDate == null || !DateHelper.before((Date)processingDate, (Date)fixedAsset.getAcquisitionDate())) break;
                                    processingDate = fixedAsset.getAcquisitionDate();
                                    break;
                                }
                                if (fixedAssetAreas[i].getStatus().value() == 1) {
                                    if (processingDate == null || !DateHelper.before((Date)processingDate, (Date)fixedAsset.getAcquisitionDate())) break;
                                    processingDate = DateHelper.getFirstDayOfMonth((Date)fixedAsset.getAcquisitionDate());
                                    break;
                                }
                                if (processingDate == null || !DateHelper.before((Date)processingDate, (Date)fixedAssetAreas[i].getDeprStartDate())) break;
                                processingDate = fixedAssetAreas[i].getDeprStartDate();
                                break;
                            }
                            case 4: {
                                processingDate = documentDate;
                                break;
                            }
                            case 5: {
                                processingDate = DateHelper.getLastDayOfMonth((Date)documentDate);
                                break;
                            }
                            case 6: {
                                processingDate = transactionDate;
                            }
                        }
                        Date initialProcessingDate = FixedAssetTransaction.getInitialAdditionProcessingDate(processingDate, fixedAsset, deprArea);
                        if (initialProcessingDate == null) continue;
                        processingDate = initialProcessingDate;
                    }
                }
            } else if (transactionType.value() == 3) {
                FixedAssetArea faArea = FixedAssetArea.getFixedAssetArea((FixedAsset)fixedAsset, (DepreciationArea)deprArea);
                if (originTransfer) {
                    processingDate = DateHelper.getFirstDayOfMonth((Date)documentDate);
                } else if (commissioningDate != null) {
                    processingDate = DateHelper.getFirstDayOfMonth((Date)commissioningDate);
                } else if (faArea != null && faArea.getStatus().value() == 10 && faArea.getDeprStartDate() != null && DateHelper.between((Date)fixedAsset.getAcquisitionDate(), (Date)finYearForProcessingDate.getValidFrom(), (Date)finYearForProcessingDate.getValidUntil())) {
                    processingDate = faArea.getDeprStartDate();
                } else {
                    DepreciationFromUntilEnum postCapiatisationType = deprecUntilTypeLinked;
                    if (postCapiatisationType == null) {
                        postCapiatisationType = deprArea.getAddAcquisitions();
                    }
                    switch (postCapiatisationType.value()) {
                        case 0: {
                            processingDate = finYearForProcessingDate.getValidFrom();
                            break;
                        }
                        case 1: {
                            processingDate = DateHelper.getFirstDayOfMonth((Date)documentDate);
                            break;
                        }
                        case 2: {
                            processingDate = DateHelper.getLastDayOfMonth((Date)documentDate);
                            break;
                        }
                        case 3: {
                            processingDate = documentDate;
                            break;
                        }
                        case 4: {
                            processingDate = DateHelper.getFirstDayOfMonth((Date)documentDate);
                            month = finYearForProcessingDate.getFinancialPeriods().length;
                            if (month <= 2) break;
                            int halfyear3 = month / 2;
                            middDate = new VDate(DateHelper.getFirstDayOfMonth((Date)finYearForProcessingDate.getValidFrom())).addMonths(halfyear3).getDate();
                            if (DateHelper.afterOrEqual((Date)processingDate, (Date)middDate)) {
                                processingDate = middDate;
                                break;
                            }
                            processingDate = finYearForProcessingDate.getValidFrom();
                            break;
                        }
                        case 5: {
                            processingDate = transactionDate;
                        }
                    }
                }
            } else if (transactionType.value() == 19) {
                if (originTransfer) {
                    processingDate = DateHelper.getLastDayOfMonth((Date)documentDate);
                } else {
                    DepreciationFromUntilEnum partialDisposDeprecUntilType = deprecUntilTypeLinked;
                    if (partialDisposDeprecUntilType == null) {
                        partialDisposDeprecUntilType = deprArea.getPartitialRetirement();
                    }
                    switch (partialDisposDeprecUntilType.value()) {
                        case 0: {
                            processingDate = finYearForProcessingDate.getValidFrom();
                            break;
                        }
                        case 1: {
                            processingDate = DateHelper.getFirstDayOfMonth((Date)documentDate);
                            break;
                        }
                        case 2: {
                            processingDate = DateHelper.getLastDayOfMonth((Date)documentDate);
                            break;
                        }
                        case 3: {
                            processingDate = documentDate;
                            break;
                        }
                        case 4: {
                            int month3 = finYearForProcessingDate.getFinancialPeriods().length;
                            if (processingDate == null) {
                                processingDate = documentDate;
                            }
                            if (month3 < 3) {
                                processingDate = DateHelper.getLastDayOfMonth((Date)processingDate);
                                break;
                            }
                            halfyear = month3 / 2;
                            Date middDate3 = DateHelper.getLastDayOfMonth((Date)new VDate(DateHelper.getFirstDayOfMonth((Date)finYearForProcessingDate.getValidFrom())).addMonths(halfyear - 1).getDate());
                            if (deprArea.getJurisdictionType() == JurisdictionType.CZ) {
                                processingDate = middDate3;
                                break;
                            }
                            if (DateHelper.after((Date)documentDate, (Date)middDate3)) {
                                processingDate = finYearForProcessingDate.getValidUntil();
                                break;
                            }
                            processingDate = middDate3;
                            break;
                        }
                        case 5: {
                            processingDate = transactionDate;
                        }
                    }
                }
            } else if (transactionType.value() == 20) {
                if (originTransfer) {
                    processingDate = DateHelper.getLastDayOfMonth((Date)documentDate);
                } else {
                    FullDisposDeprecUntilEnum fullDisposDeprecUntilType = fullDisposDeprecUntilTypeLinked;
                    if (fullDisposDeprecUntilType == null) {
                        fullDisposDeprecUntilType = deprArea.getCompleteRetirement();
                    }
                    switch (fullDisposDeprecUntilType.value()) {
                        case 0: {
                            processingDate = finYearForProcessingDate.getValidFrom();
                            break;
                        }
                        case 1: {
                            processingDate = DateHelper.getFirstDayOfMonth((Date)processingDate);
                            break;
                        }
                        case 2: {
                            processingDate = DateHelper.getLastDayOfMonth((Date)processingDate);
                            break;
                        }
                        case 3: {
                            processingDate = finYearForProcessingDate.getValidUntil();
                            break;
                        }
                        case 5: {
                            if (processingDate != null) break;
                            processingDate = documentDate;
                            break;
                        }
                        case 4: {
                            int month4 = finYearForProcessingDate.getFinancialPeriods().length;
                            if (month4 < 3) {
                                processingDate = DateHelper.getLastDayOfMonth((Date)processingDate);
                                break;
                            }
                            halfyear = month4 / 2;
                            Date middDate4 = DateHelper.getLastDayOfMonth((Date)new VDate(DateHelper.getFirstDayOfMonth((Date)finYearForProcessingDate.getValidFrom())).addMonths(halfyear - 1).getDate());
                            if (deprArea.getJurisdictionType() == JurisdictionType.CZ) {
                                processingDate = middDate4;
                                break;
                            }
                            if (DateHelper.after((Date)processingDate, (Date)middDate4)) {
                                processingDate = finYearForProcessingDate.getValidUntil();
                                break;
                            }
                            processingDate = middDate4;
                            break;
                        }
                        case 6: {
                            processingDate = DateHelper.getLastDayOfMonth((Date)processingDate);
                            break;
                        }
                        case 7: {
                            processingDate = transactionDate;
                        }
                    }
                }
            } else if (transactionType.value() == 14) {
                if (creditNoteProcessingTimeType == null) {
                    creditNoteProcessingTimeType = CreditNoteProcessingTimeEnum.from_int((int)5);
                }
                switch (creditNoteProcessingTimeType.value()) {
                    case 2: {
                        processingDate = DateHelper.getFirstDayOfMonth((Date)documentDate);
                        break;
                    }
                    case 5: {
                        processingDate = DateHelper.getLastDayOfMonth((Date)documentDate);
                        break;
                    }
                    default: {
                        processingDate = DateHelper.getLastDayOfMonth((Date)documentDate);
                        break;
                    }
                }
            } else if (transactionType.value() == 15 || transactionType.value() == 26) {
                if (creditNoteProcessingTimeType == null) {
                    creditNoteProcessingTimeType = transactionType.value() == 26 ? CreditNoteProcessingTimeEnum.from_int((int)4) : CreditNoteProcessingTimeEnum.from_int((int)2);
                }
                switch (creditNoteProcessingTimeType.value()) {
                    case 2: {
                        processingDate = DateHelper.getFirstDayOfMonth((Date)documentDate);
                        break;
                    }
                    case 5: {
                        processingDate = DateHelper.getLastDayOfMonth((Date)documentDate);
                        break;
                    }
                    case 4: {
                        processingDate = documentDate;
                        break;
                    }
                    default: {
                        processingDate = DateHelper.getFirstDayOfMonth((Date)documentDate);
                        break;
                    }
                }
            } else if (transactionType.value() == 10 || transactionType.value() == 11 || transactionType.value() == 12 || transactionType.value() == 13 || transactionType.value() == 18 || transactionType.value() == 7) {
                if (originTransfer) {
                    processingDate = DateHelper.getLastDayOfMonth((Date)documentDate);
                }
            } else if (transactionType.value() == 5 || transactionType.value() == 25 || transactionType.value() == 6) {
                if (originTransfer || processingDate == null) {
                    processingDate = DateHelper.getFirstDayOfMonth((Date)documentDate);
                }
            } else if (transactionType.value() == 9) {
                processingDate = DateHelper.getFirstDayOfMonth((Date)documentDate);
            } else if (transactionType.value() == 8) {
                if (processingDate == null) {
                    processingDate = DateHelper.getFirstDayOfMonth((Date)documentDate);
                }
            } else if (transactionType.value() == 21) {
                if (deprArea.getJurisdictionType() == JurisdictionType.PL) {
                    processingDate = DateHelper.getLastDayOfMonth((Date)documentDate);
                } else if (processingDate == null) {
                    processingDate = DateHelper.getFirstDayOfMonth((Date)documentDate);
                } else if (DateHelper.equal((Date)processingDate, (Date)DateHelper.getLastDayOfMonth((Date)processingDate))) {
                    processingDate = DateHelper.yesterday((Date)processingDate);
                }
            }
            if (processingDate == null) {
                processingDate = documentDate;
            }
            for (int i = 0; i < fixedAssetAreas.length; ++i) {
                if (!fixedAssetAreas[i].getDeprArea().equals((Object)deprArea)) continue;
                if (fixedAssetAreas[i].getDeprStartDate() != null) {
                    if (!DateHelper.before((Date)processingDate, (Date)fixedAssetAreas[i].getDeprStartDate()) || !DateHelper.before((Date)processingDate, (Date)fixedAsset.getAcquisitionDate())) continue;
                    if (DateHelper.before((Date)fixedAssetAreas[i].getDeprStartDate(), (Date)fixedAsset.getAcquisitionDate())) {
                        processingDate = fixedAssetAreas[i].getDeprStartDate();
                        continue;
                    }
                    processingDate = DateHelper.getFirstDayOfMonth((Date)fixedAsset.getAcquisitionDate());
                    continue;
                }
                if (!DateHelper.before((Date)processingDate, (Date)fixedAsset.getAcquisitionDate())) continue;
                if (transactionType.value() != 21) {
                    if (fixedAssetAreas[i].getStatus().value() == 1) {
                        if (deprArea.getJurisdictionType() == JurisdictionType.PL) {
                            processingDate = fixedAsset.getAcquisitionDate();
                            continue;
                        }
                        processingDate = DateHelper.getFirstDayOfMonth((Date)fixedAsset.getAcquisitionDate());
                        continue;
                    }
                    processingDate = DateHelper.getFirstDayOfMonth((Date)fixedAsset.getAcquisitionDate());
                    continue;
                }
                processingDate = DateHelper.getFirstDayOfMonth((Date)fixedAsset.getAcquisitionDate());
            }
            if (deprArea.getDayExact() && !deprArea.getAverage() && (transactionType.value() == 2 || transactionType.value() == 3 || transactionType.value() == 4 || transactionType.value() == 24 || transactionType.value() == 6 || transactionType.value() == 23 || transactionType.value() == 19 || transactionType.value() == 5 || transactionType.value() == 25 || transactionType.value() == 21 || transactionType.value() == 14 || transactionType.value() == 15 || transactionType.value() == 26)) {
                processingDate = documentDate;
            }
            return processingDate;
        }
        catch (BusinessDomainException bde) {
            throw ExceptionMapper.makeApplicationException((Throwable)bde);
        }
    }

    public static void checkAndUpdateTransaction(FixedAsset fa, FixedAssetArea[] faAreas, FixedAssetStruct faStruct) throws BusinessDomainException {
        LOGGER.debug("checkAndUpdateTransaction(...)");
        FixedAssetAreaStruct[] faaStruct = faStruct.fixedAssetType.fixedAssetData().assetAreasSeq;
        for (int i = 0; i < faAreas.length; ++i) {
            for (int j = 0; j < faaStruct.length; ++j) {
                if (!faaStruct[j].fixedAssetGroupArea.oidArea.objectId().equals(faAreas[i].getDeprArea().getObjectid())) continue;
                FixedAssetData fad = (FixedAssetData)fa;
                Date oldAcquisitionDate = fad.getAcquisitionDate();
                Date newAcquisitionDate = DateMapper.toDate((String)faStruct.fixedAssetShort.shortData.fixedAssetShortData().acquisitionDate);
                Date oldLastDeprDate = faAreas[i].getLastDeprDate();
                Date newLastDeprDate = DateMapper.toDate((String)faaStruct[j].lastDeprDate);
                Date oldDeprStartDate = faAreas[i].getDeprStartDate();
                Date newDeprStartDate = DateMapper.toDate((String)faaStruct[j].deprStartDate);
                if (newAcquisitionDate == null || oldAcquisitionDate == null || !(!DateHelper.equal((Date)newAcquisitionDate, (Date)oldAcquisitionDate) || newDeprStartDate != null && oldDeprStartDate == null && faaStruct[j].fixedAssetGroupArea.status != StatusEnum.STE_NO_DEPRECIATION || newDeprStartDate == null && oldDeprStartDate != null && faaStruct[j].fixedAssetGroupArea.status != StatusEnum.STE_NO_DEPRECIATION || newDeprStartDate != null && oldDeprStartDate != null && !DateHelper.equal((Date)newDeprStartDate, (Date)oldDeprStartDate) && faaStruct[j].fixedAssetGroupArea.status != StatusEnum.STE_NO_DEPRECIATION || newLastDeprDate != null && oldLastDeprDate == null && faaStruct[j].fixedAssetGroupArea.status != StatusEnum.STE_NO_DEPRECIATION || newLastDeprDate == null && oldLastDeprDate != null && faaStruct[j].fixedAssetGroupArea.status != StatusEnum.STE_NO_DEPRECIATION) && (newLastDeprDate == null || oldLastDeprDate == null || DateHelper.equal((Date)newLastDeprDate, (Date)oldLastDeprDate) || faaStruct[j].fixedAssetGroupArea.status == StatusEnum.STE_NO_DEPRECIATION)) continue;
                Date newProcessingDate = newDeprStartDate != null && DateHelper.before((Date)newDeprStartDate, (Date)newAcquisitionDate) ? DateHelper.getFirstDayOfMonth((Date)newDeprStartDate) : DateHelper.getFirstDayOfMonth((Date)newAcquisitionDate);
                Date newAcquisitionDateFirstDay = DateHelper.getFirstDayOfMonth((Date)newAcquisitionDate);
                FixedAssetTransaction oldestFAT = FixedAssetTransaction.getOldestTransactionExceptForNewAddition(fad, faAreas[i].getDeprArea());
                FixedAssetTransaction[] transactions = FixedAssetTransaction.getTransactionsOfTypeAddition(fad, faAreas[i].getDeprArea());
                for (int k = 0; k < transactions.length; ++k) {
                    if (oldestFAT != null && DateHelper.after((Date)newAcquisitionDateFirstDay, (Date)oldestFAT.getProcessingDate())) {
                        throw FixedAssetTransactionExceptionMapper.makeProcessingDateNotAllowedDomainException((String)"FixedAssetTransaction.check");
                    }
                    transactions[k].setProcessingDate(newProcessingDate);
                    transactions[k].makeSaveable();
                    if (newLastDeprDate == null || faAreas[i].getLastDeprDate() == null || DateHelper.equal((Date)newLastDeprDate, (Date)faAreas[i].getLastDeprDate()) || !transactions[k].getTransactionEnum().equals(TransactionEnum.TRE_EXISTING_ADDITION)) continue;
                    transactions[k].setLastDeprDate(newLastDeprDate);
                    transactions[k].makeSaveable();
                }
            }
        }
    }

    private static void checkAccumulatedAmounts(FixedAssetArea faArea, FixedAssetTransaction faTransact, boolean isCancelationTransact) throws BusinessDomainException {
        AssetaccountingSetup aaSetup = AssetaccountingSetup.getValidAssetaccountingSetup((AccountingCompany)faArea.getFixedAsset().getAccountCompany());
        FixedAssetTransaction[] faTransactions = FixedAssetTransaction.getFixedAssetTransactions(faArea, null, false);
        ArrayList<FixedAssetTransaction> transactList = new ArrayList<FixedAssetTransaction>(Arrays.asList(faTransactions));
        if (!isCancelationTransact) {
            if (StringMapper.isNullString((String)faTransact.getObjectid())) {
                transactList.add(faTransact);
            } else {
                for (FixedAssetTransaction element : transactList) {
                    if (!element.getObjectid().equals(faTransact.getObjectid())) continue;
                    element.setAmount(faTransact.getAmount());
                    element.setProcessingDate(faTransact.getProcessingDate());
                    break;
                }
            }
        } else {
            for (FixedAssetTransaction element : transactList) {
                if (!element.getObjectid().equals(faTransact.getObjectid())) continue;
                transactList.remove(element);
                break;
            }
        }
        FixedAssetTransaction[] newFaTransacts = new FixedAssetTransaction[transactList.size()];
        transactList.toArray(newFaTransacts);
        if (aaSetup != null && aaSetup.getNote().equals("SORT_NEW")) {
            Arrays.sort(newFaTransacts, FixedAssetTransaction.getFATDefaultComparator());
        } else {
            Arrays.sort(newFaTransacts, FixedAssetTransaction.getFATDefaultComparatorOld());
        }
        DepreciationCalculation deprCalc = new DepreciationCalculation(faArea, DepreciationFunctionEnum.DEFE_CALCULATION);
        List transactCache = deprCalc.buildTransactionsCache(newFaTransacts, null, null, false);
        for (int i = 0; i < transactCache.size(); ++i) {
            DepreciationCalculationHelper dch = (DepreciationCalculationHelper)transactCache.get(i);
            if (dch.getIsCancelation() || dch.getIsCanceled()) continue;
            if (BigDecimalMapper.compareTo((BigDecimal)dch.getAccumDepreciationAmountTotal(), (BigDecimal)BigDecimal.ZERO) < 0 && !faArea.getDepBelowZero()) {
                String whichTransaction = "For Fixedasset " + faArea.getFixedAsset().getCode() + ", Transaction from " + DateMapper.toString((Date)dch.getProcessingDate()) + ", DepreciationArea " + faArea.getDeprArea().getCode() + ", TransactionType: " + dch.getTransactionType().value() + ", amount: " + dch.getAmount();
                if (isCancelationTransact) {
                    throw FixedAssetTransactionExceptionMapper.makeCancelAccDeprValueNegativeDomainException((String)"FixedAssetTransaction.check", (String)whichTransaction);
                }
                throw FixedAssetTransactionExceptionMapper.makeAccDeprValueNegativeDomainException((String)"FixedAssetTransaction.check", (String)whichTransaction);
            }
            if (BigDecimalMapper.compareTo((BigDecimal)dch.getAccumAcquisitionValue(), (BigDecimal)BigDecimal.ZERO) >= 0) continue;
            String whichTransaction = "For Fixedasset " + faArea.getFixedAsset().getCode() + ", Transaction from " + DateMapper.toString((Date)dch.getProcessingDate()) + ", DepreciationArea " + faArea.getDeprArea().getCode() + ", TransactionType: " + dch.getTransactionType().value() + ", amount: " + dch.getAmount();
            if (isCancelationTransact) {
                throw FixedAssetTransactionExceptionMapper.makeCancelAcquisitionValueNegativeDomainException((String)"FixedAssetTransaction.check", (String)whichTransaction);
            }
            throw FixedAssetTransactionExceptionMapper.makeAcquisitionValueNegativeDomainException((String)"FixedAssetTransaction.check", (String)whichTransaction);
        }
    }

    public static void checkNetBookValue(FixedAssetArea faArea, FixedAssetTransaction faTransact, boolean isCancelationTransact) throws BusinessDomainException {
        AssetaccountingSetup aaSetup = AssetaccountingSetup.getValidAssetaccountingSetup((AccountingCompany)faArea.getFixedAsset().getAccountCompany());
        FixedAssetTransaction[] faTransactions = FixedAssetTransaction.getFixedAssetTransactions(faArea, faTransact.getProcessingDate(), false);
        ArrayList<FixedAssetTransaction> transactList = new ArrayList<FixedAssetTransaction>(Arrays.asList(faTransactions));
        if (!isCancelationTransact) {
            if (StringMapper.isNullString((String)faTransact.getObjectid())) {
                transactList.add(faTransact);
                if (faTransact.getTransactionEnum().value() == 11) {
                    for (FixedAssetTransaction faElement : transactList) {
                        if (!DateHelper.equal((Date)faTransact.getProcessingDate(), (Date)faElement.getProcessingDate()) || faElement.getTransactionEnum().value() != 10 && faElement.getTransactionEnum().value() != 11) continue;
                        transactList.remove(faElement);
                        break;
                    }
                }
            } else {
                for (FixedAssetTransaction element : transactList) {
                    if (!element.getObjectid().equals(faTransact.getObjectid())) continue;
                    element.setAmount(faTransact.getAmount());
                    element.setProcessingDate(faTransact.getProcessingDate());
                    break;
                }
            }
        } else {
            for (FixedAssetTransaction element : transactList) {
                if (!element.getObjectid().equals(faTransact.getObjectid())) continue;
                transactList.remove(element);
                break;
            }
        }
        FixedAssetTransaction[] newFaTransacts = new FixedAssetTransaction[transactList.size()];
        transactList.toArray(newFaTransacts);
        if (aaSetup != null && aaSetup.getNote().equals("SORT_NEW")) {
            Arrays.sort(newFaTransacts, FixedAssetTransaction.getFATDefaultComparator());
        } else {
            Arrays.sort(newFaTransacts, FixedAssetTransaction.getFATDefaultComparatorOld());
        }
        DepreciationCalculation deprCalc = new DepreciationCalculation(faArea, DepreciationFunctionEnum.DEFE_CALCULATION);
        List transactCache = deprCalc.buildTransactionsCache(newFaTransacts, null, null, false);
        for (int i = 0; i < transactCache.size(); ++i) {
            DepreciationCalculationHelper dch = (DepreciationCalculationHelper)transactCache.get(i);
            if (dch.getIsCancelation() || dch.getIsCanceled() || BigDecimalMapper.compareTo((BigDecimal)dch.getNetBookValue(), (BigDecimal)BigDecimal.ZERO) >= 0 || faArea.getDepBelowZero()) continue;
            String whichTransaction = StringMapper.isNullString((String)dch.getOidFATransaction()) ? "F\u00fcr Anlagegut " + faArea.getFixedAsset().getCode() + ", Bewegung vom " + DateMapper.toString((Date)faTransact.getProcessingDate()) + ", Bewertungsbereich " + faArea.getDeprArea().getCode() + ", Bewegungsart: " + faTransact.getTransactionType().value() + ", Betrag: " + faTransact.getAmount() : "F\u00fcr Anlagegut " + faArea.getFixedAsset().getCode() + ", Bewegung vom " + DateMapper.toString((Date)dch.getProcessingDate()) + ", Bewertungsbereich " + faArea.getDeprArea().getCode() + ", Bewegungsart: " + dch.getTransactionType().value() + ", Betrag: " + dch.getAmount();
            if (isCancelationTransact) {
                throw FixedAssetTransactionExceptionMapper.makeCancelNetBookValueNegativeDomainException((String)"FixedAssetTransaction.check", (String)whichTransaction);
            }
            throw FixedAssetTransactionExceptionMapper.makeNetBookValueNegativeDomainException((String)"FixedAssetTransaction.check", (String)whichTransaction);
        }
    }

    public Object clone() {
        try {
            FixedAssetTransaction cloneTransaction = (FixedAssetTransaction)super.clone();
            return cloneTransaction;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void sortDescending(FixedAssetTransaction[] transaction) {
        int result = 0;
        for (int i = 0; i < transaction.length; ++i) {
            for (int j = 0; j < transaction.length - i - 1; ++j) {
                result = DateHelper.compare((Date)transaction[j].getProcessingDate(), (Date)transaction[j + 1].getProcessingDate());
                if (result == 0) {
                    result = transaction[j].getTransactionEnum().value() - transaction[j + 1].getTransactionEnum().value();
                }
                if (result == 0) {
                    result = (int)transaction[j].getTransactionSeqNumber() - (int)transaction[j + 1].getTransactionSeqNumber();
                }
                if (result == 0) {
                    result = BooleanMapper.toInt((boolean)transaction[j].getIsCancelation()) - BooleanMapper.toInt((boolean)transaction[j + 1].getIsCancelation());
                }
                if (result >= 0) continue;
                FixedAssetTransaction temp = transaction[j];
                transaction[j] = transaction[j + 1];
                transaction[j + 1] = temp;
            }
        }
    }

    public static AutomaticDepreciationTypeEnum determineAutomaticDepreciationType(CalcMethod deprMethod) {
        switch (deprMethod.getMethodTypeEnum().value()) {
            case 0: {
                switch (((DepreciationMethodData)deprMethod).getDepreciationType().value()) {
                    case 0: {
                        return AutomaticDepreciationTypeEnum.ADTE_STRAIGHT_LINE;
                    }
                    case 1: {
                        return AutomaticDepreciationTypeEnum.ADTE_DECLINING_BAL;
                    }
                    case 2: {
                        return AutomaticDepreciationTypeEnum.ADTE_DISTR_REM_LIFE;
                    }
                    case 3: {
                        return AutomaticDepreciationTypeEnum.ADTE_DEPEND_ON_PERF;
                    }
                }
                break;
            }
            case 2: {
                return AutomaticDepreciationTypeEnum.ADTE_DEPRECIATION_PLAN;
            }
        }
        return null;
    }

    public static FixedAssetTransactionDefaultComparator getFATDefaultComparator() {
        return FixedAssetTransactionDefaultComparator.getComparator();
    }

    public static FixedAssetTransactionDefaultComparatorOld getFATDefaultComparatorOld() {
        return FixedAssetTransactionDefaultComparatorOld.getComparator();
    }

    public static FixedAssetTransactionDefaultComparatorDocumentDate getFATDefaultComparatorDocumentDate() {
        return FixedAssetTransactionDefaultComparatorDocumentDate.getComparator();
    }

    public static FixedAssetTransactionDefaultDescendingComparator getFATDefaultDescendingComparator() {
        return FixedAssetTransactionDefaultDescendingComparator.getComparator();
    }

    public static FixedAssetTransactionDefaultDescendingComparatorOld getFATDefaultDescendingComparatorOld() {
        return FixedAssetTransactionDefaultDescendingComparatorOld.getComparator();
    }

    public static FixedAssetTransactionComparator getFATComparator() {
        return FixedAssetTransactionComparator.getComparator();
    }
}

