/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.servantimpl.representative;

import com.infor.igf.ca.model.common.ObjectIdentifierModel;
import com.infor.igf.fi.model.representative.RepresentativeFilterModel;
import com.infor.igf.fi.model.representative.RepresentativeModel;
import com.varial.accounting.domain.financialyear.AccountingCompanyPersistencyManager;
import com.varial.accounting.domain.representative.GDPRRepresentativePersistentObject;
import com.varial.accounting.domain.representative.IRepresentative;
import com.varial.accounting.domain.representative.Representative;
import com.varial.accounting.domain.representative.RepresentativePersistencyManager;
import com.varial.accounting.domain.representative.RepresentativeType;
import com.varial.accounting.domain.representative.export.RepresentativeCSVExport;
import com.varial.accounting.representative.RepresentativeStructCallback;
import com.varial.accounting.servantimpl.AccountingRightList;
import com.varial.accounting.servantimpl.representative.RepresentativeMapper;
import com.varial.accounting.servantimpl.representative.RepresentativeQueryCommand;
import com.varial.accounting.servantimpl.representative.RepresentativeServantService;
import com.varial.administration.servantimpl.AdministrationRightList;
import com.varial.administration.servantimpl.gdpr.GDPRAnonymizationValueManager;
import com.varial.administration.servantimpl.gdpr.GDPRCallbackImpl;
import com.varial.base.UtilitiesManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Junction;
import com.varial.base.persistency.criterion.Order;
import com.varial.base.security.AuthorizationToken;
import com.varial.base.service.AbstractApplicationService;
import com.varial.base.service.LazyRunnableHolder;
import com.varial.framework.basictypes.ReportFileStructCallback;
import com.varial.framework.domain.advisor.export.CSVExportable;
import com.varial.framework.domain.advisor.export.CSVExporter;
import com.varial.framework.domain.gdpr.GDPRData;
import com.varial.framework.domain.gdpr.GDPRExceptionMapper;
import com.varial.framework.domain.gdpr.GDPRUserData;
import com.varial.framework.domain.gdpr.commands.GDPRCommandManager;
import com.varial.framework.domain.gdpr.commands.IGDPRCommandManager;
import com.varial.framework.domain.gdpr.criteriondata.IGDPRPersistentObject;
import com.varial.framework.domain.gdpr.report.GDPRReportData;
import com.varial.serverbase.domain.user.IUser;
import com.varial.serverbase.domain.user.IUserPersistencyManager;
import com.varial.serverbase.domain.user.User;
import com.varial.serverbase.mapper.ExceptionMapper;
import com.varial.serverbase.mapper.StringMapper;
import java.util.List;
import java.util.function.Function;

public class RepresentativeServantImpl
extends AbstractApplicationService
implements RepresentativeServantService {
    private static final IUserPersistencyManager userPersistencyManager = (IUserPersistencyManager)UtilitiesManager.getBean((String)"userPersistencyManager", IUserPersistencyManager.class);
    private final Function<String, IUser> getUserFunction = oidUser -> userPersistencyManager.getUser(oidUser);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RepresentativeModel> getRepresentatives(AuthorizationToken token, String oidCompany, RepresentativeType representativeType) throws BusinessDomainException {
        try {
            this.beginQueryService();
            token.checkAccess(AccountingRightList.getGetRepresentativeRight(), oidCompany);
            Representative[] representatives = RepresentativePersistencyManager.getRepresentatives((String)oidCompany, (RepresentativeType)representativeType);
            List<RepresentativeModel> list = RepresentativeMapper.getInstance().toModel((IRepresentative[])representatives);
            return list;
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepresentativeModel getRepresentativeByCode(AuthorizationToken token, String oidCompany, String code, RepresentativeType representativeType) throws BusinessDomainException {
        try {
            token.checkAccess(AccountingRightList.getGetRepresentativeRight(), oidCompany);
            this.beginQueryService();
            Representative representative = Representative.getRepresentativeByCode((String)oidCompany, (String)code, (RepresentativeType)representativeType);
            if (representative == null) {
                throw ExceptionMapper.makeDataNotFoundPersistencyException((String)code);
            }
            RepresentativeModel representativeModel = RepresentativeMapper.getInstance().toModel((IRepresentative)representative);
            return representativeModel;
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepresentativeModel createRepresentative(AuthorizationToken token, RepresentativeModel model) throws BusinessDomainException {
        try {
            this.beginUpdateService();
            token.checkAccess(AccountingRightList.getCreateRepresentativeRight(), model.getCompanyOid());
            Representative bo = new Representative(AccountingCompanyPersistencyManager.getAccountingCompany((String)model.getCompanyOid()));
            RepresentativeMapper.getInstance().fillBO((IRepresentative)bo, model, this.getUserFunction);
            this.getContext().flush();
            RepresentativeModel representativeModel = RepresentativeMapper.getInstance().toModel((IRepresentative)bo);
            return representativeModel;
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepresentativeModel setRepresentative(AuthorizationToken token, RepresentativeModel model) throws BusinessDomainException {
        try {
            this.beginUpdateService();
            token.checkAccess(AccountingRightList.getCreateRepresentativeRight(), model.getCompanyOid());
            Representative bo = new Representative(model.getObjectIdentifier().getObjectID(), model.getObjectIdentifier().getVersion());
            RepresentativeMapper.getInstance().fillBO((IRepresentative)bo, model, this.getUserFunction);
            this.getContext().flush();
            RepresentativeModel representativeModel = RepresentativeMapper.getInstance().toModel((IRepresentative)bo);
            return representativeModel;
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRepresentative(AuthorizationToken token, String oidCompany, List<ObjectIdentifierModel> objectIdentifiers) throws BusinessDomainException {
        try {
            this.beginUpdateService();
            for (ObjectIdentifierModel objectIdentifier : objectIdentifiers) {
                Representative bo = new Representative(objectIdentifier.getObjectID(), objectIdentifier.getVersion());
                token.checkAccess(AccountingRightList.getCreateRepresentativeRight(), bo.getAccountingCompany().getObjectid());
                bo.destroy();
            }
            this.getContext().flush();
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepresentativeModel getRepresentative(AuthorizationToken token, String oidCompany, String oidRepresentative) throws BusinessDomainException {
        try {
            this.beginQueryService();
            token.checkAccess(AccountingRightList.getGetRepresentativeRight(), oidCompany);
            Representative representative = RepresentativePersistencyManager.getRepresentative((String)oidRepresentative);
            RepresentativeModel representativeModel = RepresentativeMapper.getInstance().toModel((IRepresentative)representative);
            return representativeModel;
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getRepresentativesByFilter(AuthorizationToken token, RepresentativeFilterModel queryFilter, RepresentativeStructCallback callback, LazyRunnableHolder lazyHolder) throws BusinessDomainException {
        try {
            this.beginQueryService();
            token.checkAccess(AccountingRightList.getGetRepresentativeRight(), queryFilter.getCompanyOid());
            int maxRows = 50;
            RepresentativeQueryCommand command = new RepresentativeQueryCommand(token, this.getOrder(), (Criterion)RepresentativeMapper.getInstance().buildQueryFilter(queryFilter), callback, 50);
            lazyHolder.setStandardRunnable((Runnable)command);
            return;
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RepresentativeModel> getRegionManagers(AuthorizationToken token, String oidCompany) throws BusinessDomainException {
        try {
            this.beginQueryService();
            token.checkAccess(AccountingRightList.getGetRepresentativeRight(), oidCompany);
            Representative[] representatives = RepresentativePersistencyManager.getRegionManagers((String)oidCompany);
            List<RepresentativeModel> list = RepresentativeMapper.getInstance().toModel((IRepresentative[])representatives);
            return list;
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void anonymizeRepresentative(AuthorizationToken token, String oidRepresentative, String oidGlobalLanguage, ReportFileStructCallback callback, String printTime, LazyRunnableHolder lazyHolder) throws BusinessDomainException {
        try {
            this.beginQueryService();
            token.checkAccess(AdministrationRightList.getGetGDPRRight());
            Representative representative = this.getRepresentative(oidRepresentative);
            GDPRRepresentativePersistentObject criterionUserPersistentObject = new GDPRRepresentativePersistentObject(representative);
            GDPRAnonymizationValueManager anonymizationValueManager = (GDPRAnonymizationValueManager)UtilitiesManager.getBean((String)"gdprAnonymizationValueManager", GDPRAnonymizationValueManager.class);
            String anonymizationValue = anonymizationValueManager.getNextAnonymizationValue(GDPRAnonymizationValueManager.AnonymizationType.USER);
            GDPRUserData userData = new GDPRUserData(false, false, representative.getRepresentativeType().equals((Object)RepresentativeType.COLLECTION_AGENCY), representative.getRepresentativeType().equals((Object)RepresentativeType.REPRESENTATIVE), false, false);
            GDPRData gdprData = new GDPRData((IGDPRPersistentObject)criterionUserPersistentObject, anonymizationValue, userData, new GDPRReportData(oidGlobalLanguage, printTime, token.getUserId()));
            IGDPRCommandManager commandManager = representative.getRepresentativeType().equals((Object)RepresentativeType.REPRESENTATIVE) ? (IGDPRCommandManager)UtilitiesManager.getBean((String)"gdprRepresenativeCommandManager", GDPRCommandManager.class) : (IGDPRCommandManager)UtilitiesManager.getBean((String)"gdprCollectionAgencyCommandManager", GDPRCommandManager.class);
            commandManager.validate(gdprData);
            GDPRCallbackImpl command = new GDPRCallbackImpl(token, callback, gdprData, commandManager);
            lazyHolder.setStandardRunnable((Runnable)command);
        }
        finally {
            this.endService();
        }
    }

    private Representative getRepresentative(String oidRepresentative) throws BusinessDomainException {
        Representative representative = null;
        if (!StringMapper.isNullString((String)oidRepresentative)) {
            representative = RepresentativePersistencyManager.getRepresentative((String)oidRepresentative);
        }
        if (representative == null) {
            throw GDPRExceptionMapper.makeRepresentativeIsMissingDomainException();
        }
        return representative;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportRepresentative(AuthorizationToken token, String oidCompany, String oidRepresentative, String oidGlobalLanguage, ReportFileStructCallback callback, LazyRunnableHolder lazyRunnable) throws BusinessDomainException {
        try {
            this.beginQueryService();
            token.checkAccess(AccountingRightList.getExportRepresentativeRight(), oidCompany);
            Representative representative = RepresentativePersistencyManager.getRepresentative((String)oidRepresentative);
            RepresentativeCSVExport export = new RepresentativeCSVExport(representative);
            CSVExporter command = new CSVExporter(callback, token, (CSVExportable)export);
            lazyRunnable.setLowPriorityRunnable((Runnable)command);
            return;
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RepresentativeModel> getRepresentativesByFilter(AuthorizationToken token, RepresentativeFilterModel queryFilter) {
        try {
            this.beginQueryService();
            token.checkAccess(AccountingRightList.getGetRepresentativeRight(), queryFilter.getCompanyOid());
            Junction filter = RepresentativeMapper.getInstance().buildQueryFilter(queryFilter);
            User user = userPersistencyManager.getUser(token.getUserObjectId());
            RepresentativeMapper.addAdditionalAccessFilter(filter, user);
            Representative[] representatives = RepresentativePersistencyManager.queryAll((Order[])this.getOrder(), (Criterion)filter);
            List<RepresentativeModel> list = RepresentativeMapper.getInstance().toModel((IRepresentative[])representatives);
            return list;
        }
        finally {
            this.endService();
        }
    }

    private Order[] getOrder() {
        return new Order[]{Order.asc((String)"CODE")};
    }
}

