/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.servantimpl.representative;

import com.infor.igf.ca.mapper.SimpleModelMapper;
import com.infor.igf.ca.model.common.ObjectIdentifierModel;
import com.infor.igf.core.types.PersistableEnum;
import com.infor.igf.core.util.Assert;
import com.infor.igf.core.util.PersistableEnumUtils;
import com.infor.igf.fi.model.representative.RepresentativeFilterModel;
import com.infor.igf.fi.model.representative.RepresentativeModel;
import com.infor.igf.fi.model.representative.RepresentativeShortModel;
import com.varial.accounting.domain.representative.IRepresentative;
import com.varial.accounting.domain.representative.Representative;
import com.varial.accounting.domain.representative.RepresentativePersistencyManager;
import com.varial.accounting.servantimpl.custsupaddress.CustSupAddressMapper;
import com.varial.accounting.servantimpl.personalaccount.PersonalAccountMapper;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.IdentifiableBusinessObject;
import com.varial.base.persistency.criterion.Conjunction;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Junction;
import com.varial.base.persistency.criterion.MatchMode;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.persistency.criterion.SubSelect;
import com.varial.base.persistency.criterion.Subqueries;
import com.varial.base.types.date.DateHelper;
import com.varial.framework.servantimpl.user.UserMapper;
import com.varial.serverbase.domain.user.IUser;
import com.varial.serverbase.domain.user.User;
import com.varial.serverbase.mapper.BooleanMapper;
import com.varial.serverbase.mapper.DateMapper;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public class RepresentativeMapper {
    private RepresentativeMapper() {
    }

    public static RepresentativeMapper getInstance() {
        return SingletonHelper.INSTANCE;
    }

    public List<RepresentativeModel> toModel(IRepresentative[] in) {
        if (in == null) {
            return new ArrayList<RepresentativeModel>();
        }
        return Arrays.stream(in).map(this::toModel).collect(Collectors.toList());
    }

    public RepresentativeModel toModel(IRepresentative bo) {
        Assert.notNull((Object)bo);
        RepresentativeModel model = new RepresentativeModel();
        this.fillShortModel((RepresentativeShortModel)model, bo);
        model.setAreaManager(this.toOptShortModel(bo.getRegionManager()));
        model.setBlock(bo.getStop());
        model.setBlockFrom(SimpleModelMapper.getInstance().toOptionalLocalDate(bo.getStopFrom()));
        model.setBlockTo(SimpleModelMapper.getInstance().toOptionalLocalDate(bo.getStopUntil()));
        model.setBlockNote(Optional.ofNullable(bo.getStopReason()));
        model.setNotes(Optional.ofNullable(bo.getNote()));
        return model;
    }

    public Optional<RepresentativeModel> toOptionalModel(IRepresentative in) {
        return Optional.ofNullable(in == null ? null : this.toModel(in));
    }

    public void fillShortModel(RepresentativeShortModel model, IRepresentative bo) {
        model.setObjectIdentifier(new ObjectIdentifierModel((IdentifiableBusinessObject)bo));
        model.setCode(bo.getCode());
        model.setRepresentativeType(bo.getRepresentativeType());
        model.setSalesInformation(bo.getSalesInformation());
        model.setUser(UserMapper.getInstance().toOptModel(bo.getUser()));
        model.setCompanyOid(bo.getAccountingCompany().getObjectid());
        model.setRepresentativeNumber(Optional.ofNullable(bo.getRepresentativeNumber()));
        model.setSupplier(PersonalAccountMapper.getInstance().toOptShortModel(bo.getSupplier()));
        model.setAddress(CustSupAddressMapper.getInstance().toModel(bo.getAddress()));
    }

    public RepresentativeShortModel toShortModel(IRepresentative bo) {
        RepresentativeShortModel model = new RepresentativeShortModel();
        this.fillShortModel(model, bo);
        return model;
    }

    public Optional<RepresentativeShortModel> toOptShortModel(IRepresentative in) {
        return Optional.ofNullable(in == null ? null : this.toShortModel(in));
    }

    public void fillBO(IRepresentative bo, RepresentativeModel model, Function<String, IUser> getUserFunction) throws BusinessDomainException {
        bo.setCode(model.getCode());
        bo.setRepresentativeType(model.getRepresentativeType());
        bo.setSalesInformation(model.getSalesInformation());
        bo.setRepresentativeNumber(SimpleModelMapper.getInstance().toString(model.getRepresentativeNumber()));
        bo.setStop(model.isBlock());
        bo.setStopFrom(SimpleModelMapper.getInstance().toDate(model.getBlockFrom()));
        bo.setStopUntil(SimpleModelMapper.getInstance().toDate(model.getBlockTo()));
        bo.setStopReason(SimpleModelMapper.getInstance().toString(model.getBlockNote()));
        bo.setNote(SimpleModelMapper.getInstance().toString(model.getNotes()));
        bo.setUser((IUser)model.getUser().map(user -> (IUser)getUserFunction.apply(user.getIdent().getObjectID())).orElse(null));
        bo.setSupplier(PersonalAccountMapper.getInstance().toPersonalAccountBO(model.getSupplier()));
        bo.setRegionManager(this.toBO(model.getAreaManager()));
        bo.setAddress(CustSupAddressMapper.getInstance().toBO(model.getAddress(), model.getCompanyOid()));
    }

    public Representative toBO(Optional<RepresentativeShortModel> in) {
        return in.map(bo -> RepresentativePersistencyManager.getRepresentative((String)bo.getObjectIdentifier().getObjectID())).orElse(null);
    }

    public static void addAdditionalAccessFilter(Junction filter, User user) {
        if (user.getOnlyRepresentative()) {
            filter.add(Restrictions.eq((String)"REPRESENTATIVE_T.OIDUSER", (String)user.getObjectid()));
        }
    }

    public Junction buildQueryFilter(RepresentativeFilterModel filter) {
        Conjunction junction = Restrictions.conjunction();
        junction.add(Restrictions.eq((String)"OIDCOMPANY", (String)filter.getCompanyOid()));
        SimpleModelMapper.getInstance().trim(filter.getCode()).ifPresent(arg_0 -> RepresentativeMapper.lambda$buildQueryFilter$2((Junction)junction, arg_0));
        SimpleModelMapper.getInstance().trim(filter.getRepresentativeNumber()).ifPresent(arg_0 -> RepresentativeMapper.lambda$buildQueryFilter$3((Junction)junction, arg_0));
        filter.getAreaManager().ifPresent(arg_0 -> RepresentativeMapper.lambda$buildQueryFilter$4((Junction)junction, arg_0));
        SimpleModelMapper.getInstance().trim(filter.getName()).ifPresent(arg_0 -> RepresentativeMapper.lambda$buildQueryFilter$5((Junction)junction, arg_0));
        junction.add(Restrictions.eq((String)"ADDRESSTYPE", (String)PersistableEnumUtils.toSQLPropertyValue((PersistableEnum)filter.getRepresentativeType())));
        SimpleModelMapper.getInstance().trim(filter.getSupplierOid()).ifPresent(arg_0 -> RepresentativeMapper.lambda$buildQueryFilter$6((Junction)junction, arg_0));
        if (filter.getBlock().isPresent()) {
            String valueDate = this.getValueDate(filter.getValueDate());
            if (((Boolean)filter.getBlock().get()).booleanValue()) {
                junction.add((Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"STOP", (String)BooleanMapper.toString((boolean)true)), Restrictions.disjunction().add(Restrictions.isNull((String)"STOPFROM")).add(Restrictions.le((String)"STOPFROM", (String)valueDate)), Restrictions.disjunction().add(Restrictions.isNull((String)"STOPUNTIL")).add(Restrictions.ge((String)"STOPUNTIL", (String)valueDate))}));
            } else {
                junction.add((Criterion)Restrictions.disjunction().add(Restrictions.eq((String)"STOP", (String)BooleanMapper.toString((boolean)false))).add((Criterion)Restrictions.conjunction().add(Restrictions.eq((String)"STOP", (String)BooleanMapper.toString((boolean)true))).add((Criterion)Restrictions.disjunction().add((Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.isNotNull((String)"STOPFROM"), Restrictions.gt((String)"STOPFROM", (String)valueDate)})).add((Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.isNotNull((String)"STOPUNTIL"), Restrictions.lt((String)"STOPUNTIL", (String)valueDate)})))));
            }
        }
        return junction;
    }

    private String getValueDate(Optional<LocalDate> valueDate) {
        return DateMapper.toString((Date)valueDate.map(arg_0 -> ((SimpleModelMapper)SimpleModelMapper.getInstance()).toDate(arg_0)).orElse(DateHelper.today()));
    }

    private static /* synthetic */ void lambda$buildQueryFilter$6(Junction junction, String value) {
        junction.add(Restrictions.eq((String)"OIDSUPPLIER", (String)value));
    }

    private static /* synthetic */ void lambda$buildQueryFilter$5(Junction junction, String value) {
        junction.add(Subqueries.in((String)"OIDCUSTSUPADDR", (SubSelect)new SubSelect("SELECT OBJECTID FROM CUSTSUPADDRESS_T", Restrictions.like((String)"NAME", (String)value, (MatchMode)MatchMode.START))));
    }

    private static /* synthetic */ void lambda$buildQueryFilter$4(Junction junction, Boolean value) {
        junction.add(Subqueries.in((String)"OBJECTID", (SubSelect)new SubSelect("SELECT DISTINCT OIDREGIONMANAGER FROM REPRESENTATIVE_T", Restrictions.isNull((String)"OIDREGIONMANAGER"))));
    }

    private static /* synthetic */ void lambda$buildQueryFilter$3(Junction junction, String value) {
        junction.add(Restrictions.like((String)"REPRESENTNUMBER", (String)value, (MatchMode)MatchMode.START));
    }

    private static /* synthetic */ void lambda$buildQueryFilter$2(Junction junction, String value) {
        junction.add(Restrictions.like((String)"CODE", (String)value, (MatchMode)MatchMode.START));
    }

    private static class SingletonHelper {
        private static final RepresentativeMapper INSTANCE = new RepresentativeMapper();

        private SingletonHelper() {
        }
    }
}

