/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.servantimpl.personalaccount;

import com.infor.igf.ca.mapper.SimpleModelMapper;
import com.infor.igf.ca.model.common.ObjectIdentifierModel;
import com.infor.igf.fi.model.nominalledger.NominalLedgerItemMediumModel;
import com.infor.igf.fi.model.personalaccount.CreditInformationModel;
import com.infor.igf.fi.model.personalaccount.PAControlAccountHistoryModel;
import com.infor.igf.fi.model.personalaccount.PersonalAccountCurrentCreditLimitModel;
import com.infor.igf.fi.model.personalaccount.PersonalAccountFilterModel;
import com.infor.igf.fi.model.personalaccount.PersonalAccountModel;
import com.infor.igf.fi.model.personalaccount.PersonalAccountSelectionModel;
import com.infor.igf.fi.model.personalaccount.PersonalAccountShortModel;
import com.infor.igf.fi.model.personalaccount.PersonalAccountShortWithBalanceModel;
import com.infor.igf.fi.model.personalaccount.PersonalAccountTinyModel;
import com.infor.igf.fi.model.personalaccount.PostToNewControlAccountModel;
import com.infor.igf.fi.model.personalaccount.creditcontrol.CreditInsuranceContractModel;
import com.infor.igf.fi.model.personalaccount.creditcontrol.CreditInsuranceShortModel;
import com.infor.igf.fi.model.termsofpayment.DiscountDetailsModel;
import com.infor.igf.fi.model.termsofpayment.DiscountDueDatesModel;
import com.varial.accounting.basictypes.filter.PersonalAccountSelection;
import com.varial.accounting.basictypes.filter.PersonalAccountSelectionPersistencyManager;
import com.varial.accounting.domain.daofactory.DAOFactory;
import com.varial.accounting.domain.dunningletter.DunningLetter;
import com.varial.accounting.domain.financialyear.AccountingCompany;
import com.varial.accounting.domain.financialyear.AccountingCompanyPersistencyManager;
import com.varial.accounting.domain.financialyear.FinancialYear;
import com.varial.accounting.domain.financialyear.FinancialYearPersistencyManager;
import com.varial.accounting.domain.nominalledger.INLItemCompanySetting;
import com.varial.accounting.domain.nominalledger.NLAccountCompanySetting;
import com.varial.accounting.domain.personalaccount.ControlAccountType;
import com.varial.accounting.domain.personalaccount.CreditLimitType;
import com.varial.accounting.domain.personalaccount.Customer;
import com.varial.accounting.domain.personalaccount.IOverdrawnInformation;
import com.varial.accounting.domain.personalaccount.IPersonalAccount;
import com.varial.accounting.domain.personalaccount.OverdrawnInformation;
import com.varial.accounting.domain.personalaccount.OverdrawnInformationManager;
import com.varial.accounting.domain.personalaccount.PAControlAccountHistory;
import com.varial.accounting.domain.personalaccount.PersonalAccount;
import com.varial.accounting.domain.personalaccount.PersonalAccountBankAddressMapper;
import com.varial.accounting.domain.personalaccount.PersonalAccountPersistencyManager;
import com.varial.accounting.domain.personalaccount.PersonalAccountType;
import com.varial.accounting.domain.personalaccount.Supplier;
import com.varial.accounting.domain.personalaccount.balance.PersonalAccountBalanceManager;
import com.varial.accounting.domain.personalaccount.creditcontrol.CreditInsurance;
import com.varial.accounting.domain.personalaccount.creditcontrol.CreditInsuranceContract;
import com.varial.accounting.domain.personalaccount.creditcontrol.CreditInsurancePersistencyManager;
import com.varial.accounting.domain.personalaccount.creditcontrol.CreditLimitHelper;
import com.varial.accounting.domain.personalaccount.creditcontrol.IPersonalAccountCreditLimit;
import com.varial.accounting.domain.personalaccount.creditcontrol.PersonalAccountCreditLimit;
import com.varial.accounting.domain.personalaccount.export.PersonalAccountCSVExport;
import com.varial.accounting.domain.termsofpayment.ITermOfPayment;
import com.varial.accounting.domain.termsofpayment.TermOfPaymentPersistencyManager;
import com.varial.accounting.persistency.personalaccount.PersonalaccountContainer;
import com.varial.accounting.personalaccount.BankAddressStructCallback;
import com.varial.accounting.personalaccount.PersonalAccountShortStructCallback;
import com.varial.accounting.personalaccount.PersonalAccountStruct;
import com.varial.accounting.personalaccount.PersonalAccountStructCallback;
import com.varial.accounting.servantimpl.AccountingRightList;
import com.varial.accounting.servantimpl.nominalledger.NominalLedgerMapper;
import com.varial.accounting.servantimpl.personalaccount.PersonalAccountBankAddressQueryCommand;
import com.varial.accounting.servantimpl.personalaccount.PersonalAccountFilterMapper;
import com.varial.accounting.servantimpl.personalaccount.PersonalAccountMapper;
import com.varial.accounting.servantimpl.personalaccount.PersonalAccountQueryCommand;
import com.varial.accounting.servantimpl.personalaccount.PersonalAccountSelectionMapper;
import com.varial.accounting.servantimpl.personalaccount.PersonalAccountServantService;
import com.varial.accounting.servantimpl.personalaccount.PersonalAccountShortQueryCommand;
import com.varial.base.UtilitiesManager;
import com.varial.base.esb.ChangeListener;
import com.varial.base.esb.SendableAdapter;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Junction;
import com.varial.base.persistency.criterion.Order;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.problem.Problem;
import com.varial.base.problem.ProblemList;
import com.varial.base.security.AuthorizationToken;
import com.varial.base.server.LifecycleManager;
import com.varial.base.service.AbstractApplicationService;
import com.varial.base.service.LazyRunnableHolder;
import com.varial.base.types.date.DateHelper;
import com.varial.framework.basictypes.ReportFileStructCallback;
import com.varial.framework.domain.advisor.export.CSVExportable;
import com.varial.framework.domain.advisor.export.CSVExporter;
import com.varial.framework.domain.company.ICompany;
import com.varial.interfaces.ICurrency;
import com.varial.serverbase.domain.user.IUserPersistencyManager;
import com.varial.serverbase.domain.user.User;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.ExceptionMapper;
import com.varial.serverbase.mapper.StringMapper;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersonalAccountServantImpl
extends AbstractApplicationService
implements PersonalAccountServantService {
    private static final IUserPersistencyManager userPersistencyManager = (IUserPersistencyManager)UtilitiesManager.getBean((String)"userPersistencyManager", IUserPersistencyManager.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(PersonalAccountServantImpl.class);
    private final SendableAdapter<IPersonalAccountCreditLimit> creditLimitAdapter = new SendableAdapter();
    private final SendableAdapter<IPersonalAccountCreditLimit> insuranceLimitAdapter = new SendableAdapter();

    public PersonalAccountServantImpl() {
        this.init();
    }

    private void init() {
        if (UtilitiesManager.getApplicationContext().containsBean("creditLimitSender")) {
            this.creditLimitAdapter.addChangeListener((ChangeListener)UtilitiesManager.getBean((String)"creditLimitSender", ChangeListener.class));
        }
        if (UtilitiesManager.getApplicationContext().containsBean("creditInsuranceLimitSender")) {
            this.insuranceLimitAdapter.addChangeListener((ChangeListener)UtilitiesManager.getBean((String)"creditInsuranceLimitSender", ChangeListener.class));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CreditInsuranceContractModel> getCreditInsuranceContracts(AuthorizationToken token, String oidCreditInsurance) throws BusinessDomainException {
        try {
            this.beginQueryService();
            if (StringMapper.isNullString((String)oidCreditInsurance)) {
                List<CreditInsuranceContractModel> list = Collections.emptyList();
                return list;
            }
            CreditInsurance creditInsurance = CreditInsurancePersistencyManager.getCreditInsuranceWithCache((String)oidCreditInsurance);
            List result = CreditInsuranceContract.getCreditInsuranceContracts((CreditInsurance)creditInsurance);
            List list = SimpleModelMapper.getInstance().toModels(result, PersonalAccountMapper.getInstance().toCreditInsuranceContractModel);
            return list;
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CreditInsuranceShortModel getCreditInsuranceShortByOid(AuthorizationToken token, String oidCreditInsurance) throws BusinessDomainException {
        try {
            this.beginQueryService();
            CreditInsurance creditInsurance = CreditInsurancePersistencyManager.getCreditInsuranceWithCache((String)oidCreditInsurance);
            CreditInsuranceShortModel creditInsuranceShortModel = (CreditInsuranceShortModel)PersonalAccountMapper.getInstance().toCreditInsuranceShortModel.apply(creditInsurance);
            return creditInsuranceShortModel;
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CreditInsuranceShortModel> getCreditInsuranceShorts(AuthorizationToken token) throws BusinessDomainException {
        try {
            this.beginQueryService();
            Object[] result = CreditInsurance.getCreditInsurances();
            List list = SimpleModelMapper.getInstance().toModels(result, PersonalAccountMapper.getInstance().toCreditInsuranceShortModel);
            return list;
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PersonalAccountModel getPersonalAccount(AuthorizationToken token, String oidPersonalAccount) throws BusinessDomainException {
        try {
            this.beginQueryService();
            PersonalAccount personalAccount = PersonalAccountPersistencyManager.getPersonalAccount((String)oidPersonalAccount);
            if (personalAccount.isCustomer()) {
                token.checkAccess(AccountingRightList.getGetCustomerRight(), personalAccount.getAccountingCompany().getObjectid());
            } else {
                token.checkAccess(AccountingRightList.getGetSupplierRight(), personalAccount.getAccountingCompany().getObjectid());
            }
            PersonalAccountModel personalAccountModel = PersonalAccountMapper.getInstance().toModel((IPersonalAccount)personalAccount, true);
            return personalAccountModel;
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PersonalAccountShortModel getShortPersonalAccount(AuthorizationToken token, String oidPersonalAccount) throws BusinessDomainException {
        try {
            this.beginQueryService();
            PersonalAccount personalAccount = PersonalAccountPersistencyManager.getPersonalAccount((String)oidPersonalAccount);
            if (personalAccount.isCustomer()) {
                token.checkAccess(AccountingRightList.getGetCustomerRight(), personalAccount.getAccountingCompany().getObjectid());
            } else {
                token.checkAccess(AccountingRightList.getGetSupplierRight(), personalAccount.getAccountingCompany().getObjectid());
            }
            PersonalAccountShortModel personalAccountShortModel = PersonalAccountMapper.getInstance().toShortModel((IPersonalAccount)personalAccount);
            return personalAccountShortModel;
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyPersonalAccountIntoAllCompanies(AuthorizationToken token, String oidPersonalAccount) throws BusinessDomainException {
        try {
            this.beginUpdateService();
            PersonalAccount personalAccount = PersonalAccountPersistencyManager.getPersonalAccount((String)oidPersonalAccount);
            if (personalAccount.isCustomer()) {
                token.checkAccess(AccountingRightList.getCreateCustomerRight(), personalAccount.getAccountingCompany().getObjectid());
            } else {
                token.checkAccess(AccountingRightList.getCreateSupplierRight(), personalAccount.getAccountingCompany().getObjectid());
            }
            personalAccount.copyPersonalAccountIntoAllCompanies();
            this.getContext().flush();
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PersonalAccountModel createPersonalAccount(AuthorizationToken token, String oidCompany, PersonalAccountModel model) throws BusinessDomainException {
        try {
            Customer bo;
            this.beginUpdateService();
            AccountingCompany company = AccountingCompanyPersistencyManager.getAccountingCompany((String)oidCompany);
            if (model.isCustomer()) {
                bo = new Customer(company);
                token.checkAccess(AccountingRightList.getCreateCustomerRight(), oidCompany);
            } else {
                bo = new Supplier(company);
                token.checkAccess(AccountingRightList.getCreateSupplierRight(), oidCompany);
            }
            PersonalAccountMapper.getInstance().fillBO(model, (PersonalAccount)bo, Optional.empty());
            this.getContext().flush();
            PersonalAccountModel personalAccountModel = PersonalAccountMapper.getInstance().toModel((IPersonalAccount)bo, true);
            return personalAccountModel;
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PersonalAccountModel setPersonalAccount(AuthorizationToken token, PersonalAccountModel model, PostToNewControlAccountModel postToNewControlAccount) throws BusinessDomainException {
        try {
            Customer bo;
            this.beginUpdateService();
            if (model.isCustomer()) {
                bo = new Customer(model.getObjectIdentifier().getObjectID(), model.getObjectIdentifier().getVersion());
                token.checkAccess(AccountingRightList.getCreateCustomerRight(), bo.getAccountingCompany().getObjectid());
            } else {
                bo = new Supplier(model.getObjectIdentifier().getObjectID(), model.getObjectIdentifier().getVersion());
                token.checkAccess(AccountingRightList.getCreateSupplierRight(), bo.getAccountingCompany().getObjectid());
            }
            bo.setPostToNewAccount(postToNewControlAccount != null);
            PersonalAccountCreditLimit[] oldLimits = null;
            if (model.getCustomerSpecificData().isPresent() && this.isPublishingRequired()) {
                oldLimits = bo.getAllLimits();
            }
            PersonalAccountMapper.getInstance().fillBO(model, (PersonalAccount)bo, Optional.ofNullable(postToNewControlAccount));
            if (model.getCustomerSpecificData().isPresent() && this.isPublishingRequired() && bo.isEsbCreated()) {
                PersonalAccountCreditLimit[] newLimits = bo.getAllLimits();
                CreditLimitHelper helper = new CreditLimitHelper((IPersonalAccountCreditLimit[])oldLimits, (IPersonalAccountCreditLimit[])newLimits);
                this.fireEvents(helper.categorize(CreditLimitType.CREDIT_LIMIT), this.creditLimitAdapter);
                this.fireInsuranceModified(helper.pickLatestInsuranceLimit(), this.insuranceLimitAdapter);
            }
            this.getContext().flush();
            PersonalAccountModel personalAccountModel = PersonalAccountMapper.getInstance().toModel((IPersonalAccount)bo, true);
            return personalAccountModel;
        }
        finally {
            this.endService();
        }
    }

    private void fireInsuranceModified(IPersonalAccountCreditLimit limit, SendableAdapter<IPersonalAccountCreditLimit> adapter) {
        if (limit == null) {
            return;
        }
        ProblemList problems = new ProblemList();
        problems = adapter.fireModifyEvent(Arrays.asList(limit), problems);
        if (problems.hasProblems()) {
            for (Problem problem : problems.toList()) {
                LOGGER.error("Problem during ESB sender processing detected!\n{}", (Object)problem.toString());
            }
        }
    }

    private void fireEvents(CreditLimitHelper.CategorizationResult categorizationResult, SendableAdapter<IPersonalAccountCreditLimit> adapter) {
        ProblemList pl = new ProblemList();
        if (!categorizationResult.getAddedLimits().isEmpty()) {
            pl = adapter.fireAddEvent(categorizationResult.getAddedLimits(), pl);
        }
        if (!categorizationResult.getChangedLimits().isEmpty()) {
            pl = adapter.fireModifyEvent(categorizationResult.getChangedLimits(), pl);
        }
        if (!categorizationResult.getDeletedLimits().isEmpty()) {
            pl = adapter.fireDeleteEvent(categorizationResult.getDeletedLimits(), pl);
        }
        if (pl.hasProblems()) {
            for (Problem p : pl.toList()) {
                LOGGER.error("Problem during ESB sender processing detected!\n{}", (Object)p.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePersonalAccounts(AuthorizationToken token, List<ObjectIdentifierModel> oidTsPersonalAccounts) throws BusinessDomainException {
        try {
            this.beginUpdateService();
            for (int i = 0; i < oidTsPersonalAccounts.size(); ++i) {
                PersonalAccount personalAccount = PersonalAccountPersistencyManager.getPersonalAccount((String)oidTsPersonalAccounts.get(i).getObjectID());
                if (personalAccount.isCustomer()) {
                    token.checkAccess(AccountingRightList.getCreateCustomerRight(), personalAccount.getAccountingCompany().getObjectid());
                } else {
                    token.checkAccess(AccountingRightList.getCreateSupplierRight(), personalAccount.getAccountingCompany().getObjectid());
                }
                personalAccount.makeSaveable();
                personalAccount.setVersion(oidTsPersonalAccounts.get(i).getVersion());
                personalAccount.destroy();
            }
            this.getContext().flush();
            return;
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getPersonalAccounts(AuthorizationToken token, PersonalAccountFilterModel queryFilter, PersonalAccountStructCallback callback, LazyRunnableHolder lazyHolder) throws BusinessDomainException {
        try {
            this.beginQueryService();
            int maxRows = 50;
            Junction filter = PersonalAccountFilterMapper.getInstance().buildFilter(queryFilter);
            Order[] sort = new Order[]{Order.asc((String)"code"), Order.desc((String)"ISPARENTACCOUNT")};
            PersonalAccountQueryCommand command = new PersonalAccountQueryCommand(token, sort, (Criterion)filter, callback, 50, queryFilter.isNoZeroBalanceAccounts(), queryFilter.isShowBalances());
            lazyHolder.setStandardRunnable((Runnable)command);
            return;
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getShortPersonalAccounts(AuthorizationToken token, PersonalAccountFilterModel queryFilter, PersonalAccountShortStructCallback callback, LazyRunnableHolder lazyHolder) throws BusinessDomainException {
        try {
            this.beginQueryService();
            this.checkAccess(token, queryFilter);
            int maxRows = 50;
            Junction filter = PersonalAccountFilterMapper.getInstance().buildFilter(queryFilter);
            Order[] sort = new Order[]{Order.asc((String)"code"), Order.desc((String)"ISPARENTACCOUNT")};
            PersonalAccountShortQueryCommand command = new PersonalAccountShortQueryCommand(token, sort, (Criterion)filter, callback, 50, queryFilter.isNoZeroBalanceAccounts(), queryFilter.isShowBalances(), queryFilter.isShowMemberNumber());
            lazyHolder.setStandardRunnable((Runnable)command);
            return;
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PersonalAccountShortWithBalanceModel> getPersonalAccountsForReferenceNumber(AuthorizationToken token, String referenceNumber, String oidCompany, boolean isCustomer) throws BusinessDomainException {
        try {
            this.beginQueryService();
            AccountingCompany company = AccountingCompanyPersistencyManager.getAccountingCompany((String)oidCompany);
            if (isCustomer) {
                token.checkAccess(AccountingRightList.getGetCustomerRight(), oidCompany);
            } else {
                token.checkAccess(AccountingRightList.getGetSupplierRight(), oidCompany);
            }
            PersonalAccount[] personalAccounts = PersonalAccountPersistencyManager.getPersonalAccountsForReferenceNumber((String)referenceNumber, (AccountingCompany)company, (boolean)isCustomer);
            List list = PersonalAccountMapper.getInstance().toShortWithBalanceModel(personalAccounts, false, false);
            return list;
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PersonalAccountShortModel getPersonalAccountShortByCode(AuthorizationToken token, String oidCompany, boolean isCustomer, String code) throws BusinessDomainException {
        try {
            this.beginQueryService();
            AccountingCompany company = AccountingCompanyPersistencyManager.getAccountingCompany((String)oidCompany);
            if (isCustomer) {
                token.checkAccess(AccountingRightList.getGetCustomerRight(), oidCompany);
            } else {
                token.checkAccess(AccountingRightList.getGetSupplierRight(), oidCompany);
            }
            PersonalAccount personalAccount = PersonalAccountPersistencyManager.getTypedPersonalAccountByCode((AccountingCompany)company, (boolean)isCustomer, (String)code);
            if (personalAccount == null) {
                throw ExceptionMapper.makeDataNotFoundPersistencyException((String)code);
            }
            PersonalAccountShortModel personalAccountShortModel = PersonalAccountMapper.getInstance().toShortModel((IPersonalAccount)personalAccount);
            return personalAccountShortModel;
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PersonalAccountModel getPersonalAccountByCode(AuthorizationToken token, String oidCompany, boolean isCustomer, String code) throws BusinessDomainException {
        try {
            this.beginQueryService();
            AccountingCompany company = AccountingCompanyPersistencyManager.getAccountingCompany((String)oidCompany);
            if (isCustomer) {
                token.checkAccess(AccountingRightList.getGetCustomerRight(), oidCompany);
            } else {
                token.checkAccess(AccountingRightList.getGetSupplierRight(), oidCompany);
            }
            PersonalAccount personalAccount = PersonalAccountPersistencyManager.getTypedPersonalAccountByCode((AccountingCompany)company, (boolean)isCustomer, (String)code);
            if (personalAccount == null) {
                throw ExceptionMapper.makeDataNotFoundPersistencyException((String)code);
            }
            PersonalAccountModel personalAccountModel = PersonalAccountMapper.getInstance().toModel((IPersonalAccount)personalAccount, true);
            return personalAccountModel;
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getOidDunningSessionByCreditControlInformation(AuthorizationToken token, String oidCreditControlInformation) throws BusinessDomainException {
        try {
            this.beginQueryService();
            if (StringMapper.isNullString((String)oidCreditControlInformation)) {
                throw ExceptionMapper.makeApplicationException((String)"getOidDunningSessionByCreditControlInformation: oidCreditControlInformation is null");
            }
            String string = DunningLetter.getOIDDunningLetterSessionForCreditControlInformation((String)oidCreditControlInformation);
            return string;
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkPersonalAccountOverdrawn(AuthorizationToken token, String oidPersonalAccount, String oidFinancialYear, String referenceDate) throws BusinessDomainException {
        try {
            this.beginQueryService();
            PersonalAccount personalAccount = PersonalAccountPersistencyManager.getPersonalAccount((String)oidPersonalAccount);
            if (personalAccount.isCustomer()) {
                Customer customer = (Customer)personalAccount;
                FinancialYear financialYear = null;
                if (!StringMapper.isNullString((String)oidFinancialYear)) {
                    financialYear = FinancialYearPersistencyManager.getFinancialYear((String)oidFinancialYear);
                }
                OverdrawnInformationManager manager = new OverdrawnInformationManager(customer, financialYear, DateMapper.toDate((String)referenceDate));
                boolean bl = manager.checkPersonalAccountOverdrawn();
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PersonalAccountStruct getPersonalAccountByCodeAndControlAccountCode(AuthorizationToken token, String oidCompany, boolean isCustomer, String code, String controlAccountCode) throws BusinessDomainException {
        try {
            this.beginQueryService();
            AccountingCompany company = AccountingCompanyPersistencyManager.getAccountingCompany((String)oidCompany);
            if (isCustomer) {
                token.checkAccess(AccountingRightList.getGetCustomerRight(), oidCompany);
            } else {
                token.checkAccess(AccountingRightList.getGetSupplierRight(), oidCompany);
            }
            PersonalAccount personalAccount = PersonalAccountPersistencyManager.getTypedPersonalAccountByCodeForTransfer((AccountingCompany)company, (boolean)isCustomer, (String)code, (String)controlAccountCode);
            if (personalAccount == null) {
                throw ExceptionMapper.makeDataNotFoundPersistencyException((String)code);
            }
            PersonalAccountStruct personalAccountStruct = new com.varial.accounting.domain.personalaccount.PersonalAccountMapper().toIdl(personalAccount, true);
            return personalAccountStruct;
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CreditInformationModel getOverdrawnInformations(AuthorizationToken token, String oidPersonalAccount, String oidFinancialYear, String referenceDate) throws BusinessDomainException {
        try {
            this.beginQueryService();
            Customer personalAccount = PersonalAccountPersistencyManager.getCustomer((String)oidPersonalAccount);
            FinancialYear financialYear = null;
            if (!StringMapper.isNullString((String)oidFinancialYear)) {
                financialYear = FinancialYearPersistencyManager.getFinancialYear((String)oidFinancialYear);
            }
            OverdrawnInformationManager manager = new OverdrawnInformationManager(personalAccount, financialYear, DateMapper.toDate((String)referenceDate));
            OverdrawnInformation overdrawnInformation = manager.getOverdrawnInformation();
            CreditInformationModel creditInformationModel = PersonalAccountMapper.getInstance().toCreditInformationModel((IOverdrawnInformation)overdrawnInformation);
            return creditInformationModel;
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDueDate(AuthorizationToken token, String oidPersonalAccount, String oidTermOfPayment, String calculationDate) throws BusinessDomainException {
        try {
            token.checkAccess(AccountingRightList.getGetTermsOfPaymentRight());
            this.beginQueryService();
            PersonalAccount personalAccount = PersonalAccountPersistencyManager.getPersonalAccount((String)oidPersonalAccount);
            ITermOfPayment termOfPayment = null;
            if (!StringMapper.isNullString((String)oidTermOfPayment)) {
                termOfPayment = TermOfPaymentPersistencyManager.getTermOfPayment((String)oidTermOfPayment);
            }
            String string = DateMapper.toString((Date)personalAccount.getDueDate(termOfPayment, DateMapper.toDate((String)calculationDate)));
            return string;
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DiscountDueDatesModel getDueData(AuthorizationToken token, String oidPersonalAccount, String oidTermOfPayment, String calculationDate) throws BusinessDomainException {
        try {
            this.beginQueryService();
            PersonalAccount personalAccount = PersonalAccountPersistencyManager.getPersonalAccount((String)oidPersonalAccount);
            ITermOfPayment termOfPayment = TermOfPaymentPersistencyManager.getTermOfPayment((String)oidTermOfPayment);
            Date valueDate = DateMapper.toDate((String)calculationDate);
            DiscountDueDatesModel result = new DiscountDueDatesModel();
            result.setPaymentDueDate(SimpleModelMapper.getInstance().toLocalDateOrNull(personalAccount.getDueDate(termOfPayment, valueDate)));
            result.setDiscount1(this.getDiscountDetails(termOfPayment, valueDate, termOfPayment.getDueDate1(valueDate), 1));
            result.setDiscount2(this.getDiscountDetails(termOfPayment, valueDate, termOfPayment.getDueDate2(valueDate), 2));
            result.setDiscount3(this.getDiscountDetails(termOfPayment, valueDate, termOfPayment.getDueDate3(valueDate), 3));
            DiscountDueDatesModel discountDueDatesModel = result;
            return discountDueDatesModel;
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PAControlAccountHistoryModel> getPAControlAccountHistory(AuthorizationToken token, ControlAccountType controlAccountType, String oidPersonalAccount) throws BusinessDomainException {
        try {
            this.beginQueryService();
            PersonalAccount personalAccount = PersonalAccountPersistencyManager.getPersonalAccount((String)oidPersonalAccount);
            if (personalAccount.isCustomer()) {
                token.checkAccess(AccountingRightList.getGetCustomerRight(), personalAccount.getAccountingCompany().getObjectid());
            } else {
                token.checkAccess(AccountingRightList.getGetSupplierRight(), personalAccount.getAccountingCompany().getObjectid());
            }
            List pAControlAccountHistories = PAControlAccountHistory.getPAControlAccountHistories((PersonalAccount)personalAccount, (ControlAccountType)controlAccountType);
            List list = SimpleModelMapper.getInstance().toModels(pAControlAccountHistories, PersonalAccountMapper.getInstance().toPAControlAccountHistoryModel);
            return list;
        }
        finally {
            this.endService();
        }
    }

    private void addAdditionalAccessFilter(AuthorizationToken token, Junction filter) {
        User user = userPersistencyManager.getUser(token.getUserObjectId());
        Criterion additionalFilterForWIN = PersonalAccountSelectionPersistencyManager.getAdditionalFilterForWIN((User)user);
        if (additionalFilterForWIN != null) {
            filter.add(additionalFilterForWIN);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PersonalAccountTinyModel> getTinyPersonalAccounts(AuthorizationToken token, PersonalAccountFilterModel queryFilter) throws BusinessDomainException {
        try {
            PersonalAccount[] personalAccounts;
            this.beginQueryService();
            this.checkAccess(token, queryFilter);
            Junction filter = PersonalAccountFilterMapper.getInstance().buildFilter(queryFilter);
            this.addAdditionalAccessFilter(token, filter);
            PersonalAccountPersistencyManager.checkMaxReadNumberOfPersonalAccountsForREST((Criterion)filter);
            PersonalaccountContainer[] containers = PersonalAccountPersistencyManager.getPersonalAccountContainers((Order[])new Order[]{Order.asc((String)"CODE")}, (Criterion)filter);
            if (containers.length > 0 && queryFilter.isShowAddressDetails()) {
                this.preloadCustSupAddresses(containers[0].oidcompany, containers);
            }
            if ((personalAccounts = (PersonalAccount[])Arrays.stream(containers).map(container -> PersonalAccountPersistencyManager.buildObjectFromContainer((PersonalaccountContainer)container, (boolean)true, (boolean)true)).toArray(PersonalAccount[]::new)).length > 0 && queryFilter.isShowBalances()) {
                PersonalAccountBalanceManager.preloadPersonalAccountBalances((AccountingCompany)personalAccounts[0].getAccountingCompany(), (ICurrency)personalAccounts[0].getCurrentFinanceSetup().getBaseCurrency(), (PersonalAccount[])personalAccounts);
            }
            List list = PersonalAccountMapper.getInstance().toTinyModel((IPersonalAccount[])personalAccounts, queryFilter.isNoZeroBalanceAccounts(), queryFilter.isShowBalances(), queryFilter.isShowAddressDetails(), queryFilter.isShowCreditLimit());
            return list;
        }
        finally {
            this.endService();
        }
    }

    private void preloadCustSupAddresses(String oidcompany, PersonalaccountContainer[] containers) {
        int MAX_OIDS_FOR_SELECT = 100;
        AtomicInteger counter = new AtomicInteger();
        Collection<List<PersonalaccountContainer>> transactionsPartitions = Arrays.stream(containers).collect(Collectors.groupingBy(it -> counter.getAndIncrement() / 100)).values();
        transactionsPartitions.forEach(beans -> DAOFactory.getDAOFactory((String)oidcompany).getCustSupAddressPersistencyMgr().loadAddress(oidcompany, (String[])beans.stream().map(bean -> bean.oidaddress).toArray(String[]::new)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PersonalAccountTinyModel> getTinyPersonalAccountsForPersonalAccountSelection(AuthorizationToken token, String oidCompany, PersonalAccountSelectionModel personalAccountSelectionModel) throws BusinessDomainException {
        try {
            this.beginQueryService();
            boolean isCustomer = personalAccountSelectionModel.getCustomerSpecificData().isPresent();
            if (isCustomer) {
                token.checkAccess(AccountingRightList.getGetCustomerRight(), oidCompany);
            } else {
                token.checkAccess(AccountingRightList.getGetSupplierRight(), oidCompany);
            }
            PersonalAccountSelection personalAccountSelection = PersonalAccountSelectionMapper.getInstance().toBO(personalAccountSelectionModel, true);
            Junction elements = PersonalAccountSelectionPersistencyManager.getFilter((PersonalAccountSelection)personalAccountSelection, (ICompany)AccountingCompanyPersistencyManager.getAccountingCompany((String)oidCompany), (boolean)false);
            this.addAdditionalAccessFilter(token, elements);
            PersonalAccount[] personalAccounts = PersonalAccountPersistencyManager.getPersonalAccounts((Criterion)elements, (Order[])new Order[]{Order.asc((String)"CODE")});
            List list = PersonalAccountMapper.getInstance().toTinyModel((IPersonalAccount[])personalAccounts, false, false, false, false);
            return list;
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PersonalAccountTinyModel> getTinyPersonalAccountByOid(AuthorizationToken token, String oidPersonalAccount) throws BusinessDomainException {
        try {
            this.beginQueryService();
            if (StringMapper.isNullString((String)oidPersonalAccount)) {
                List<PersonalAccountTinyModel> list = Collections.emptyList();
                return list;
            }
            PersonalAccount[] personalAccounts = PersonalAccountPersistencyManager.getPersonalAccounts((Criterion)Restrictions.eq((String)"OBJECTID", (String)oidPersonalAccount), null);
            if (personalAccounts.length > 0) {
                if (personalAccounts[0].isCustomer()) {
                    token.checkAccess(AccountingRightList.getGetCustomerRight(), personalAccounts[0].getAccountingCompanyOid());
                } else {
                    token.checkAccess(AccountingRightList.getGetSupplierRight(), personalAccounts[0].getAccountingCompanyOid());
                }
            }
            List list = PersonalAccountMapper.getInstance().toTinyModel((IPersonalAccount[])personalAccounts, false, false, false, false);
            return list;
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PersonalAccountCurrentCreditLimitModel getPersonalAccountCurrentCreditLimit(AuthorizationToken token, String oidPersonalAccount) {
        try {
            this.beginQueryService();
            PersonalAccount personalAccount = PersonalAccountPersistencyManager.getPersonalAccount((String)oidPersonalAccount);
            if (personalAccount.isCustomer()) {
                token.checkAccess(AccountingRightList.getGetCustomerRight(), personalAccount.getAccountingCompany().getObjectid());
            } else {
                token.checkAccess(AccountingRightList.getGetSupplierRight(), personalAccount.getAccountingCompany().getObjectid());
            }
            PersonalAccountCurrentCreditLimitModel personalAccountCurrentCreditLimitModel = PersonalAccountMapper.getInstance().toPersonalAccountCurrentCreditLimitModel(personalAccount);
            return personalAccountCurrentCreditLimitModel;
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NominalLedgerItemMediumModel getControlAccount(AuthorizationToken token, String oidPersonalAccount, String transactionDate, String oidFinancialYear) throws BusinessDomainException {
        try {
            this.beginQueryService();
            FinancialYear financialYear = FinancialYearPersistencyManager.getFinancialYear((String)oidFinancialYear);
            PersonalAccount personalAccount = PersonalAccountPersistencyManager.getPersonalAccount((String)oidPersonalAccount);
            if (personalAccount.isCustomer()) {
                token.checkAccess(AccountingRightList.getGetCustomerRight(), financialYear.getCompany().getObjectid());
            } else {
                token.checkAccess(AccountingRightList.getGetSupplierRight(), financialYear.getCompany().getObjectid());
            }
            NLAccountCompanySetting nLAccountCompanySetting = personalAccount.getNominalAccount(DateMapper.toDate((String)transactionDate), financialYear);
            NominalLedgerItemMediumModel nominalLedgerItemMediumModel = NominalLedgerMapper.getInstance().toMediumModel((INLItemCompanySetting)nLAccountCompanySetting, false);
            return nominalLedgerItemMediumModel;
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPersonalAccountCodeUnique(AuthorizationToken token, String oidCompany, boolean isCustomer, String code) {
        try {
            this.beginQueryService();
            AccountingCompany company = AccountingCompanyPersistencyManager.getAccountingCompany((String)oidCompany);
            boolean bl = PersonalAccountPersistencyManager.isPersonalAccountCodeUnique((AccountingCompany)company, (boolean)isCustomer, (String)code);
            return bl;
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEcTaxNumberOfPersonalAccountUniqueForCompany(AuthorizationToken token, String oidCompany, boolean isCustomer, String oidCountry, String ecTaxNumber) {
        try {
            this.beginQueryService();
            AccountingCompany company = AccountingCompanyPersistencyManager.getAccountingCompany((String)oidCompany);
            boolean bl = PersonalAccountPersistencyManager.isEcTaxNumberOfPersonalAccountUniqueForCompany((AccountingCompany)company, (boolean)isCustomer, (String)oidCountry, (String)ecTaxNumber);
            return bl;
        }
        finally {
            this.endService();
        }
    }

    private int getDueDays(Date valueDate, Date dueDate) {
        return dueDate != null ? DateHelper.getDiffInDays((Date)dueDate, (Date)valueDate) : 0;
    }

    private BigDecimal getDiscountPerCent(ITermOfPayment termOfPayment, Date valueDate, int pos) {
        if (pos == 1) {
            return termOfPayment.getPercentDiscount1(valueDate);
        }
        if (pos == 2) {
            return termOfPayment.getPercentDiscount2(valueDate);
        }
        return termOfPayment.getPercentDiscount3(valueDate);
    }

    private DiscountDetailsModel getDiscountDetails(ITermOfPayment termOfPayment, Date valueDate, Date dueDate, int pos) {
        if (dueDate == null) {
            return new DiscountDetailsModel(BigDecimalMapper.ZERO, 0, null);
        }
        return new DiscountDetailsModel(this.getDiscountPerCent(termOfPayment, valueDate, pos), this.getDueDays(valueDate, dueDate), SimpleModelMapper.getInstance().toLocalDateOrNull(dueDate));
    }

    private boolean isPublishingRequired() {
        return LifecycleManager.getInstance().jmsSenderIsAvailable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getBankAddresses(AuthorizationToken token, String oidPersonalAccount, String bankName, BankAddressStructCallback callback, LazyRunnableHolder lazyHolder) throws BusinessDomainException {
        try {
            this.beginQueryService();
            PersonalAccount personalAccount = PersonalAccountPersistencyManager.getPersonalAccount((String)oidPersonalAccount);
            if (personalAccount.isCustomer()) {
                token.checkAccess(AccountingRightList.getGetCustomerRight(), personalAccount.getAccountingCompany().getObjectid());
            } else {
                token.checkAccess(AccountingRightList.getGetSupplierRight(), personalAccount.getAccountingCompany().getObjectid());
            }
            int maxRows = 50;
            PersonalAccountBankAddressMapper personalAccountBankAddressMapper = new PersonalAccountBankAddressMapper();
            Junction filter = personalAccountBankAddressMapper.getPersonalAccountBankAddressFilter(personalAccount, bankName);
            Order[] sort = new Order[]{Order.asc((String)"ISDEFAULT")};
            PersonalAccountBankAddressQueryCommand command = new PersonalAccountBankAddressQueryCommand(token, sort, (Criterion)filter, callback, 50);
            lazyHolder.setStandardRunnable((Runnable)command);
            return;
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportPersonalAccount(AuthorizationToken token, String oidCompany, String oidPersonalAccount, String oidGlobalLanguage, ReportFileStructCallback callback, LazyRunnableHolder lazyRunnable) throws BusinessDomainException {
        try {
            this.beginQueryService();
            PersonalAccount personalAccount = PersonalAccountPersistencyManager.getPersonalAccount((String)oidPersonalAccount);
            if (personalAccount.isCustomer()) {
                token.checkAccess(AccountingRightList.getExportCustomerRight(), oidCompany);
            } else {
                token.checkAccess(AccountingRightList.getExportSupplierRight(), oidCompany);
            }
            PersonalAccountCSVExport export = new PersonalAccountCSVExport(personalAccount);
            CSVExporter command = new CSVExporter(callback, token, (CSVExportable)export);
            lazyRunnable.setLowPriorityRunnable((Runnable)command);
            return;
        }
        finally {
            this.endService();
        }
    }

    private void checkAccess(AuthorizationToken token, PersonalAccountFilterModel queryFilter) {
        block5: {
            block4: {
                if (!queryFilter.getAccountType().isPresent() || queryFilter.getAccountType().get() == PersonalAccountType.ALL) break block4;
                switch ((PersonalAccountType)queryFilter.getAccountType().get()) {
                    case CUSTOMER: {
                        token.checkAccess(AccountingRightList.getGetCustomerRight(), queryFilter.getCompanyOid());
                        break block5;
                    }
                    case SUPPLIER: {
                        token.checkAccess(AccountingRightList.getGetSupplierRight(), queryFilter.getCompanyOid());
                        break block5;
                    }
                    default: {
                        throw ExceptionMapper.makeApplicationException((String)"wrong account type");
                    }
                }
            }
            token.checkAccess(AccountingRightList.getGetCustomerRight(), queryFilter.getCompanyOid());
            token.checkAccess(AccountingRightList.getGetSupplierRight(), queryFilter.getCompanyOid());
        }
    }
}

