/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.servantimpl.personalaccount;

import com.infor.igf.core.types.PersistableEnum;
import com.infor.igf.core.util.Assert;
import com.infor.igf.core.util.PersistableEnumUtils;
import com.infor.igf.fi.model.personalaccount.PersonalAccountFilterModel;
import com.varial.accounting.basictypes.filter.FilterHelper;
import com.varial.accounting.domain.financialyear.AccountingCompany;
import com.varial.accounting.domain.financialyear.AccountingCompanyPersistencyManager;
import com.varial.accounting.domain.nominalledger.NLAccountCompanySetting;
import com.varial.accounting.domain.nominalledger.NominalLedgerAccount;
import com.varial.accounting.domain.nominalledger.NominalLedgerItemPersistencyManager;
import com.varial.accounting.domain.personalaccount.DRDSelectionType;
import com.varial.accounting.domain.personalaccount.PersonalAccountType;
import com.varial.accounting.domain.phonetic.PhoneticManagerAccountingImpl;
import com.varial.accounting.servantimpl.openitem.OpenItemFilterMapper;
import com.varial.base.UtilitiesManager;
import com.varial.base.persistency.criterion.Conjunction;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Junction;
import com.varial.base.persistency.criterion.MatchMode;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.persistency.criterion.SubSelect;
import com.varial.base.persistency.criterion.Subqueries;
import com.varial.framework.domain.company.Company;
import com.varial.framework.domain.company.CompanyPersistencyManager;
import com.varial.framework.domain.isoftware.ISoftware;
import com.varial.serverbase.mapper.BooleanMapper;
import java.util.List;
import java.util.Optional;

public class PersonalAccountFilterMapper {
    private PersonalAccountFilterMapper() {
    }

    public static PersonalAccountFilterMapper getInstance() {
        return SingletonHelper.INSTANCE;
    }

    public Junction buildFilter(PersonalAccountFilterModel filter) {
        boolean usePhoneticSearch;
        Assert.notNull((Object)filter);
        boolean searchInCaseSensitive = !ISoftware.getSearchCaseSensitive();
        Junction elements = Restrictions.conjunction().add(Restrictions.eq((String)"OIDCOMPANY", (String)filter.getCompanyOid()));
        if (filter.getAccountType().isPresent() && filter.getAccountType().get() != PersonalAccountType.ALL) {
            boolean isCustomer = filter.getAccountType().get() == PersonalAccountType.CUSTOMER;
            elements.add(Restrictions.eq((String)"ISCUSTOMER", (String)BooleanMapper.toString((boolean)isCustomer)));
            if (isCustomer && filter.isWithoutCreditControlOnly()) {
                elements.add(Restrictions.eq((String)"CREDITCONTROL", (String)BooleanMapper.toString((boolean)false)));
            }
        }
        if (filter.getModeOfPayment().isPresent()) {
            elements.add(Restrictions.eq((String)"PAYMENTTYPE", (String)PersistableEnumUtils.toSQLPropertyValue((PersistableEnum)((PersistableEnum)filter.getModeOfPayment().get()))));
        }
        if (this.isNotEmpty(filter.getGroupAccountsOid())) {
            elements.add(Subqueries.exists((SubSelect)new SubSelect("SELECT OBJECTID FROM PERSACCASSOREL_T", Restrictions.and((Criterion)Restrictions.eqProperty((String)"PERSACCASSOREL_T.OIDPERSONALACC", (String)"PERSONALACCOUNT_T.OBJECTID"), (Criterion)Restrictions.eq((String)"OIDPERSACCASSO", (String)((String)filter.getGroupAccountsOid().get()))))));
        }
        if (this.isNotEmpty(filter.getControlAccountOid())) {
            NominalLedgerAccount nominalLedgerAccount = NominalLedgerItemPersistencyManager.getNominalLedgerAccount((String)((String)filter.getControlAccountOid().get()));
            AccountingCompany accountingCompany = AccountingCompanyPersistencyManager.getAccountingCompany((String)filter.getCompanyOid());
            NLAccountCompanySetting nLAccountCompanySetting = nominalLedgerAccount.getNLAccountCompanySetting(accountingCompany);
            elements.add(Restrictions.eq((String)"OIDNOMINALACCOUNT", (String)nLAccountCompanySetting.getObjectid()));
        }
        this.addOpenItemFilter(filter, elements);
        if (this.isNotEmpty(filter.getMemberNumber())) {
            elements.add(Subqueries.exists((SubSelect)new SubSelect("SELECT OBJECTID FROM MEMBERNUMBER_T", (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eqProperty((String)"MEMBERNUMBER_T.OIDPERSONALACCOUNT", (String)"PERSONALACCOUNT_T.OBJECTID"), FilterHelper.checkForWildCard((String)"MEMBERNUMBER_T.MEMBERNUMBER", (String)((String)filter.getMemberNumber().get()))}))));
        }
        if (this.isNotEmpty(filter.getCode())) {
            elements.add(Restrictions.like((String)"CODE", (String)((String)filter.getCode().get()).trim(), (MatchMode)MatchMode.START, (boolean)searchInCaseSensitive));
        }
        boolean pASearchPlaceholderBefore = ISoftware.getPASearchPlaceholderBefore();
        String pASearchPlaceholderBeforeString = "";
        if (pASearchPlaceholderBefore) {
            pASearchPlaceholderBeforeString = "%";
        }
        if (this.isNotEmpty(filter.getShortAddress())) {
            elements.add(Restrictions.like((String)"SHORTADDRESS", (String)(pASearchPlaceholderBeforeString + ((String)filter.getShortAddress().get()).trim()), (MatchMode)MatchMode.START, (boolean)searchInCaseSensitive));
        }
        Conjunction custSuppFilterList = Restrictions.conjunction();
        boolean custSuppFilterListIsEmpty = true;
        boolean bl = usePhoneticSearch = this.isNotEmpty(filter.getSearchMethod()) && (this.isNotEmpty(filter.getCity()) && ((String)filter.getCity().get()).trim().length() > 2 || this.isNotEmpty(filter.getName()) && ((String)filter.getName().get()).trim().length() > 2);
        if (!usePhoneticSearch && this.isNotEmpty(filter.getName())) {
            custSuppFilterListIsEmpty = false;
            custSuppFilterList.add(Restrictions.like((String)"NAME", (String)(pASearchPlaceholderBeforeString + ((String)filter.getName().get()).trim()), (MatchMode)MatchMode.START, (boolean)searchInCaseSensitive));
        }
        if (this.isNotEmpty(filter.getAddress())) {
            custSuppFilterListIsEmpty = false;
            custSuppFilterList.add(Restrictions.like((String)"STREET", (String)(pASearchPlaceholderBeforeString + ((String)filter.getAddress().get()).trim()), (MatchMode)MatchMode.START, (boolean)searchInCaseSensitive));
        }
        if (this.isNotEmpty(filter.getZipCode())) {
            custSuppFilterListIsEmpty = false;
            custSuppFilterList.add(Restrictions.like((String)"POSTALCODE", (String)(pASearchPlaceholderBeforeString + ((String)filter.getZipCode().get()).trim()), (MatchMode)MatchMode.START));
        }
        if (this.isNotEmpty(filter.getEuTaxRegistrationNo())) {
            custSuppFilterListIsEmpty = false;
            custSuppFilterList.add(Restrictions.like((String)"EUTAXNUMBER", (String)(pASearchPlaceholderBeforeString + ((String)filter.getEuTaxRegistrationNo().get()).trim()), (MatchMode)MatchMode.START));
        }
        if (!usePhoneticSearch && this.isNotEmpty(filter.getCity())) {
            custSuppFilterListIsEmpty = false;
            custSuppFilterList.add(Restrictions.like((String)"TOWN", (String)(pASearchPlaceholderBeforeString + ((String)filter.getCity().get()).trim()), (MatchMode)MatchMode.START, (boolean)searchInCaseSensitive));
        }
        if (this.isNotEmpty(filter.getState())) {
            custSuppFilterListIsEmpty = false;
            custSuppFilterList.add(Restrictions.like((String)"REGION", (String)(pASearchPlaceholderBeforeString + ((String)filter.getState().get()).trim()), (MatchMode)MatchMode.START, (boolean)searchInCaseSensitive));
        }
        if (this.isNotEmpty(filter.getCountryOid())) {
            custSuppFilterListIsEmpty = false;
            custSuppFilterList.add(Restrictions.eq((String)"OIDCOUNTRY", (String)((String)filter.getCountryOid().get())));
        }
        if (!custSuppFilterListIsEmpty) {
            String oidaddress = "PERSONALACCOUNT_T.OIDADDRESS";
            if (filter.isCorrespondenceAddress()) {
                oidaddress = "PERSONALACCOUNT_T.OIDDEVDUNNINGADDR";
            }
            elements.add(Subqueries.exists((SubSelect)new SubSelect("SELECT OBJECTID FROM CUSTSUPADDRESS_T", Restrictions.and((Criterion)Restrictions.eqProperty((String)oidaddress, (String)"CUSTSUPADDRESS_T.OBJECTID"), (Criterion)custSuppFilterList))));
        }
        if (filter.getOneOff().isPresent()) {
            elements.add(Restrictions.eq((String)"ONEOFFACCOUNT", (String)BooleanMapper.toString((Boolean)((Boolean)filter.getOneOff().get()))));
        }
        if (filter.getAnalysisCodes().isPresent() && ((List)filter.getAnalysisCodes().get()).size() > 0) {
            for (int i = 0; i < ((List)filter.getAnalysisCodes().get()).size(); ++i) {
                if (!this.isNotEmpty((Optional)((List)filter.getAnalysisCodes().get()).get(i))) continue;
                elements.add(Restrictions.like((String)("AC" + Integer.toString(i)), (String)((String)((Optional)((List)filter.getAnalysisCodes().get()).get(i)).get()), (MatchMode)MatchMode.START));
            }
        }
        if (filter.isWithoutPostingBlock()) {
            elements.add(Restrictions.eq((String)"STOP", (String)BooleanMapper.toString((boolean)false)));
        }
        if (this.isNotEmpty(filter.getAccountingClerkOid())) {
            elements.add(Restrictions.eq((String)"OIDADVISOR", (String)((String)filter.getAccountingClerkOid().get())));
        }
        if (usePhoneticSearch) {
            Company company = CompanyPersistencyManager.getCompany((String)filter.getCompanyOid());
            String[] phonCodesPA = ((PhoneticManagerAccountingImpl)UtilitiesManager.getBean((String)"PhoneticManagerAccounting", PhoneticManagerAccountingImpl.class)).findOIDsPhonMCSPersAcc(company, (String)filter.getSearchMethod().get(), filter.getName().isPresent() ? (String)filter.getName().get() : null, filter.getCity().isPresent() ? (String)filter.getCity().get() : null);
            if (phonCodesPA.length == 0) {
                phonCodesPA = new String[]{"00"};
            }
            elements.add(Restrictions.in((String)"objectid", (String[])phonCodesPA));
        }
        filter.getDrdSelection().filter(drdSelection -> drdSelection != DRDSelectionType.ALL).ifPresent(filteredDrdSelection -> elements.add(Restrictions.eq((String)"reportdrd", (String)BooleanMapper.toString((filteredDrdSelection == DRDSelectionType.DRDONLY ? 1 : 0) != 0))));
        if (this.isNotEmpty(filter.getIban())) {
            elements.add(Subqueries.exists((SubSelect)new SubSelect("SELECT OBJECTID FROM PERSACCBANKADR_T", (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eqProperty((String)"PERSACCBANKADR_T.OIDPERSONALACC", (String)"PERSONALACCOUNT_T.OBJECTID"), FilterHelper.checkForWildCard((String)"PERSACCBANKADR_T.OTHERREFERENCE", (String)((String)filter.getIban().get()))}))));
        }
        if (this.isNotEmpty(filter.getRepresentativeOid())) {
            elements.add(Restrictions.eq((String)"OIDREPRESENT", (String)((String)filter.getRepresentativeOid().get())));
        }
        if (filter.getFactoring().isPresent()) {
            elements.add(Restrictions.eq((String)"FACTORING", (String)BooleanMapper.toString((Boolean)((Boolean)filter.getFactoring().get()))));
        }
        if (this.isNotEmpty(filter.getNumberAtPartner())) {
            elements.add(Restrictions.like((String)"OWNNUMBERATPARTNER", (String)(pASearchPlaceholderBeforeString + ((String)filter.getNumberAtPartner().get()).trim()), (MatchMode)MatchMode.START, (boolean)searchInCaseSensitive));
        }
        return elements;
    }

    private void addOpenItemFilter(PersonalAccountFilterModel filter, Junction elements) {
        Conjunction openItemFilter = Restrictions.conjunction();
        OpenItemFilterMapper.getInstance().addReferenceNumber(filter.getReferenceNumber(), (Junction)openItemFilter);
        OpenItemFilterMapper.getInstance().addSequenceNumber(filter.getSequenceNumber(), (Junction)openItemFilter);
        OpenItemFilterMapper.getInstance().addOriginalAmount(filter.getOriginalAmount(), (Junction)openItemFilter);
        OpenItemFilterMapper.getInstance().addDocumentDate(filter.getDocumentDate(), (Junction)openItemFilter);
        if (!openItemFilter.isEmpty()) {
            OpenItemFilterMapper.getInstance().addUnfinished(false, (Junction)openItemFilter);
            openItemFilter.add((Criterion)Restrictions.eqProperty((String)"OPENITEM_T.OIDPERSONALACC", (String)"PERSONALACCOUNT_T.OBJECTID"));
            elements.add(Subqueries.exists((SubSelect)new SubSelect("SELECT OBJECTID FROM OPENITEM_T", (Criterion)openItemFilter)));
        }
    }

    private boolean isNotEmpty(Optional<String> string) {
        return string != null && string.isPresent() && !string.get().trim().equals("");
    }

    private static class SingletonHelper {
        private static final PersonalAccountFilterMapper INSTANCE = new PersonalAccountFilterMapper();

        private SingletonHelper() {
        }
    }
}

