/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.servantimpl.paymentrun;

import com.varial.accounting.domain.accountingcheck.AccountingCheckHelper;
import com.varial.accounting.domain.financialyear.AccountingCompany;
import com.varial.accounting.domain.financialyear.AccountingCompanyPersistencyManager;
import com.varial.accounting.domain.payment.AdvancePaymentSession;
import com.varial.accounting.domain.payment.FinancePaymentSession;
import com.varial.accounting.domain.payment.GeneratePaymentSession;
import com.varial.accounting.domain.payment.report.PaymentReportHelper;
import com.varial.accounting.domain.payment.report.SepaPaymentReportTranslator;
import com.varial.accounting.domain.payment.report.bacspaymentrunlist.BacsPaymentContainer;
import com.varial.accounting.domain.payment.report.settlementadvice.SettlementAdviceDataSource;
import com.varial.accounting.domain.personalaccount.RemittanceType;
import com.varial.accounting.persistency.genpayremitoi.GenpayremitoiContainer;
import com.varial.accounting.persistency.genpayremitoi.IGenpayremitoiDao;
import com.varial.accounting.servantimpl.paymentrun.PaymentRunSessionMapper;
import com.varial.base.UtilitiesManager;
import com.varial.base.callback.AbstractAsynchronousPrintCommand;
import com.varial.base.callback.TransactionMode;
import com.varial.base.configuration.Configuration;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.mail.Credentials;
import com.varial.base.mail.EmailAddress;
import com.varial.base.mail.EmailAddressFactory;
import com.varial.base.mail.MailException;
import com.varial.base.mail.MailManager;
import com.varial.base.persistency.criterion.Conjunction;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Order;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.security.AuthorizationToken;
import com.varial.base.session.SessionContext;
import com.varial.common.persistency.payment.PaymentContainer;
import com.varial.framework.basictypes.ReportFileStructCallback;
import com.varial.framework.domain.isoftware.ISoftware;
import com.varial.framework.domain.mail.MailChecker;
import com.varial.framework.domain.mail.MailExceptionMapper;
import com.varial.framework.domain.mailprotocol.MailProtocol;
import com.varial.framework.domain.mailprotocol.MailProtocolEntry;
import com.varial.framework.domain.mailprotocol.MailProtocolProgramEnum;
import com.varial.framework.domain.mailprotocol.MailProtocolReportDataSource;
import com.varial.framework.domain.printservice.PrintProgress;
import com.varial.framework.domain.printservice.ProgressInterface;
import com.varial.framework.domain.reports.JasperReportCompiler;
import com.varial.framework.domain.reports.JasperReportFaxDataSource;
import com.varial.framework.domain.reports.JasperReportManager;
import com.varial.framework.domain.reports.ReportExceptionMapper;
import com.varial.framework.domain.systemoptions.SystemOptionsPersistencyManager;
import com.varial.serverbase.domain.language.Language;
import com.varial.serverbase.domain.language.LanguageManager;
import com.varial.serverbase.domain.user.IUserPersistencyManager;
import com.varial.serverbase.mapper.ExceptionMapper;
import com.varial.serverbase.mapper.StringMapper;
import com.varial.serverbase.persistency.SelectGenerator;
import com.varial.serverbase.persistency.SelectGeneratorDataSet;
import com.varial.serverbase.query.AllCallbackOperations;
import com.varial.serverbase.query.PutDataException;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SettlementAdviceFileCallbackImpl
extends AbstractAsynchronousPrintCommand<ReportFileStructCallback> {
    private static IGenpayremitoiDao daoGenPayRemitOi = (IGenpayremitoiDao)UtilitiesManager.getBean((String)"genpayremitoiDao", IGenpayremitoiDao.class);
    private static final IUserPersistencyManager userPersistencyManager = (IUserPersistencyManager)UtilitiesManager.getBean((String)"userPersistencyManager", IUserPersistencyManager.class);
    private final Configuration configuration = (Configuration)UtilitiesManager.getBean((String)"com.infor.igf.configuration", Configuration.class);
    private static Logger LOGGER = LoggerFactory.getLogger((String)SettlementAdviceFileCallbackImpl.class.getName());
    private static final String PDFFILE_PREFIX = "BSA";
    public static final String PROPKEY_ALTERNATIVEBACSPAYMENTSUPPLIERADVICE = "com.varial.reports.AlternativeBACSPaymentSupplierAdviceXML";
    public static final String ADVICE_DEFAULT_XML = "com/varial/accounting/jasperreport/payment/settlementadvice/BACSPaymentSupplierAdvice.jrxml";
    public static final String ADVICE_DEFAULT_CSV = "com/varial/accounting/jasperreport/payment/settlementadvice/BACSPaymentSupplierAdvice_Ascii.jrxml";
    public static final String ADVICE_XML_WITH_NOTE = "com/varial/accounting/jasperreport/payment/settlementadvice/BACSPaymentSupplierAdvice_WithNote.jrxml";
    private static int STEP_COUNT = 3;
    private final String mOidLanguage;
    private final String mOidCompany;
    private final String mOidSession;
    private final boolean mIsGeneratePayment;
    private final int mLeftMargin;
    private final int mTopMargin;
    private final String oidReport;
    private ProgressInterface mProgressInterface;
    private final boolean mPrintToArchive;
    private JasperReport mJasperReportMailProtocol;
    private MailProtocol mMailProtocol;
    private EmailAddress mFromEmailAddress;
    private MailManager mMailManager;

    public SettlementAdviceFileCallbackImpl(AuthorizationToken token, ReportFileStructCallback callback, String oidLanguage, String oidCompany, String oidSession, boolean isGeneratePayment, int leftMargin, int topMargin, String oidReport, boolean printToArchive) {
        super(token, (AllCallbackOperations)callback, TransactionMode.UPDATE);
        this.mOidLanguage = oidLanguage;
        this.mOidCompany = oidCompany;
        this.mOidSession = oidSession;
        this.mIsGeneratePayment = isGeneratePayment;
        this.mLeftMargin = leftMargin;
        this.mTopMargin = topMargin;
        this.oidReport = oidReport;
        this.mPrintToArchive = printToArchive;
    }

    public void execute() throws BusinessDomainException, PutDataException {
        AccountingCompany company = AccountingCompanyPersistencyManager.getAccountingCompany((String)this.mOidCompany);
        Language language = LanguageManager.getInstance().getLanguage(this.mOidLanguage);
        FinancePaymentSession session = PaymentRunSessionMapper.getFinancePaymentSession((String)this.mOidSession);
        SelectGenerator select = this.getSelectGenerator(session, false);
        int rowCount = select.getRowCount();
        select = null;
        select = this.getSelectGenerator(session, true);
        SelectGeneratorDataSet dataset = select.makeDataset();
        this.mProgressInterface = new PrintProgress((ReportFileStructCallback)this.getCallback());
        String messageMakeData = SepaPaymentReportTranslator.getMakeData((Language)language);
        String messageCalculateData = SepaPaymentReportTranslator.getCalculateData((Language)language);
        int stepForProgressbar = 1;
        int rowNo = 0;
        this.mProgressInterface.updateProgress(1, 1, messageMakeData, 1, STEP_COUNT);
        if (dataset == null || !dataset.hasNext()) {
            throw ReportExceptionMapper.makeNoDataDomainException();
        }
        boolean sendTypeAllLetter = session.getNote().indexOf("#AvisePerBrief#") > -1;
        boolean sendTypeFax = false;
        boolean sendTypeFaxLetter = false;
        boolean sendTypeMail = false;
        boolean sendTypeMailLetter = false;
        boolean sendTypeLetter = false;
        RemittanceType defaultSendType = RemittanceType.EMAIL;
        String advisorMail = "";
        GeneratePaymentSession gpSession = null;
        AdvancePaymentSession apSession = null;
        if (session.isGeneratePaymentSession()) {
            gpSession = (GeneratePaymentSession)session;
            sendTypeAllLetter = gpSession.getSendTypeAllLetter();
            sendTypeMail = gpSession.getSendTypeMail();
            sendTypeMailLetter = gpSession.getSendTypeMailLetter();
            sendTypeFax = gpSession.getSendTypeFax();
            sendTypeFaxLetter = gpSession.getSendTypeFaxLetter();
            sendTypeLetter = gpSession.getSendTypeLetter();
            defaultSendType = gpSession.getDefaultSendType();
            if (!StringMapper.isNullString((String)gpSession.getAdvisorMail())) {
                advisorMail = gpSession.getAdvisorMail();
            }
        } else {
            apSession = (AdvancePaymentSession)session;
        }
        BacsPaymentContainer tmpContainer = null;
        RemittanceType remmitanceType = RemittanceType.NOREMITTANCE;
        rowNo = 0;
        stepForProgressbar = AccountingCheckHelper.getStepForProgressbar((int)rowCount);
        LinkedList<BacsPaymentContainer> listAdviseLetter = new LinkedList<BacsPaymentContainer>();
        LinkedList<BacsPaymentContainer> listAdviseEmail = new LinkedList<BacsPaymentContainer>();
        LinkedList<BacsPaymentContainer> listAdviseEmailAsCSV = new LinkedList<BacsPaymentContainer>();
        LinkedList<BacsPaymentContainer> listAdviseFax = new LinkedList<BacsPaymentContainer>();
        while (dataset.hasNext()) {
            Object[] row = dataset.getNext();
            if (this.mIsGeneratePayment) {
                tmpContainer = new BacsPaymentContainer(gpSession, (GenpayremitoiContainer)row[0], null, "");
                if (this.lessThanEntryLimit(gpSession, (GenpayremitoiContainer)row[0])) {
                    tmpContainer = null;
                }
            } else {
                tmpContainer = new BacsPaymentContainer(apSession, (PaymentContainer)row[0], null, "");
            }
            if (++rowNo % stepForProgressbar == 0) {
                this.mProgressInterface.updateProgress(rowNo, rowCount, messageCalculateData, 2, STEP_COUNT);
            }
            if (tmpContainer == null) continue;
            if (sendTypeAllLetter) {
                listAdviseLetter.add(tmpContainer);
            }
            remmitanceType = tmpContainer.getRemittanceType();
            if (sendTypeMail) {
                switch (remmitanceType) {
                    case EMAIL: {
                        if (StringMapper.isNullString((String)tmpContainer.getEmail())) break;
                        listAdviseEmail.add(tmpContainer);
                        if (!sendTypeMailLetter) break;
                        listAdviseLetter.add(tmpContainer);
                        break;
                    }
                    case ASCII: {
                        if (StringMapper.isNullString((String)tmpContainer.getEmail())) break;
                        listAdviseEmailAsCSV.add(tmpContainer);
                        if (!sendTypeMailLetter) break;
                        listAdviseLetter.add(tmpContainer);
                        break;
                    }
                    case NOREMITTANCE: {
                        if (this.checkDefaultSendType(defaultSendType, tmpContainer, sendTypeMail, sendTypeFax) != RemittanceType.EMAIL) break;
                        listAdviseEmail.add(tmpContainer);
                        if (!sendTypeMailLetter) break;
                        listAdviseLetter.add(tmpContainer);
                        break;
                    }
                }
            }
            if (sendTypeFax) {
                switch (remmitanceType) {
                    case FAX: {
                        if (StringMapper.isNullString((String)tmpContainer.getFax())) break;
                        listAdviseFax.add(tmpContainer);
                        if (!sendTypeFaxLetter) break;
                        listAdviseLetter.add(tmpContainer);
                        break;
                    }
                    case NOREMITTANCE: {
                        if (this.checkDefaultSendType(defaultSendType, tmpContainer, sendTypeMail, sendTypeFax) != RemittanceType.FAX) break;
                        listAdviseFax.add(tmpContainer);
                        if (!sendTypeFaxLetter) break;
                        listAdviseLetter.add(tmpContainer);
                        break;
                    }
                }
            }
            if (sendTypeLetter && (remmitanceType == RemittanceType.LETTER || !listAdviseEmail.contains(tmpContainer) && !listAdviseEmailAsCSV.contains(tmpContainer) && !listAdviseFax.contains(tmpContainer))) {
                listAdviseLetter.add(tmpContainer);
            }
            if (sendTypeAllLetter || sendTypeMail || sendTypeFax || sendTypeLetter) continue;
            if (!StringMapper.isNullString((String)tmpContainer.getEmail())) {
                if (remmitanceType == RemittanceType.EMAIL) {
                    listAdviseEmail.add(tmpContainer);
                    continue;
                }
                if (remmitanceType != RemittanceType.ASCII) continue;
                listAdviseEmailAsCSV.add(tmpContainer);
                continue;
            }
            if (!StringMapper.isNullString((String)tmpContainer.getFax())) {
                listAdviseFax.add(tmpContainer);
                continue;
            }
            listAdviseLetter.add(tmpContainer);
        }
        if (listAdviseEmail.isEmpty() && listAdviseEmailAsCSV.isEmpty() && listAdviseFax.isEmpty() && listAdviseLetter.isEmpty()) {
            throw ReportExceptionMapper.makeNoDataDomainException();
        }
        ArrayList<String> resultList = new ArrayList<String>();
        JasperReport jasperReport = JasperReportCompiler.compileReport((String)this.oidReport, (String)this.getReportDefinition(false));
        JasperReport jasperReportCSV = JasperReportCompiler.compileReport((String)ADVICE_DEFAULT_CSV);
        if (!listAdviseLetter.isEmpty()) {
            resultList.addAll(this.exportLetter(listAdviseLetter, company, session, language, jasperReport));
        }
        if (!listAdviseFax.isEmpty()) {
            resultList.addAll(this.exportFax(listAdviseFax, company, session, language, jasperReport));
        }
        if (!listAdviseEmail.isEmpty() || !listAdviseEmailAsCSV.isEmpty()) {
            this.initMailProtocol(advisorMail, session, language);
            try {
                if (!listAdviseEmail.isEmpty()) {
                    resultList.addAll(this.exportMail(listAdviseEmail, company, session, language, jasperReport, false));
                }
                if (!listAdviseEmailAsCSV.isEmpty()) {
                    resultList.addAll(this.exportMail(listAdviseEmailAsCSV, company, session, language, jasperReportCSV, true));
                }
                resultList.addAll(this.printMailProtocol(company, language, sendTypeMailLetter));
            }
            catch (Exception e) {
                ExceptionMapper.printException((Throwable)e);
            }
        }
        String[] resultArray = new String[resultList.size()];
        resultList.toArray(resultArray);
        try {
            ((ReportFileStructCallback)this.getCallback()).putData(resultArray);
        }
        catch (Exception e) {
            ExceptionMapper.printException((Throwable)e);
        }
    }

    private String getReportDefinition(boolean isCSV) {
        String result = ADVICE_DEFAULT_CSV;
        if (!isCSV) {
            result = ISoftware.isSchmitzwerke() ? ADVICE_XML_WITH_NOTE : ADVICE_DEFAULT_XML;
            String alternativeReport = this.configuration.getString(PROPKEY_ALTERNATIVEBACSPAYMENTSUPPLIERADVICE);
            if (!StringMapper.isNullString((String)alternativeReport)) {
                result = StringMapper.replaceSubString((String)alternativeReport, (String)"bacs", (String)"payment/settlementadvice");
            }
        }
        return result;
    }

    private List<String> printMailProtocol(AccountingCompany company, Language language, boolean sendTypeMailLetter) throws BusinessDomainException {
        ArrayList<String> resultList = new ArrayList<String>();
        String result = "";
        File file = null;
        if (this.mMailProtocol.hasDataToPrint()) {
            MailProtocolReportDataSource mailProtocolReportDataSource = new MailProtocolReportDataSource(language, this.mMailProtocol, company.getCurrentAddress());
            file = JasperReportManager.runReportToPdf((String)this.getToken().getUserId(), (JasperReport)this.mJasperReportMailProtocol, (Map)mailProtocolReportDataSource.getParameters(), (JRDataSource)mailProtocolReportDataSource, (String)"MAILPROT");
            boolean sendingMailFailed = false;
            if (this.mFromEmailAddress != null) {
                try {
                    this.mMailManager.send((Credentials)null, this.mFromEmailAddress, this.mFromEmailAddress, this.mMailProtocol.getSubjectText(), this.mMailProtocol.getMessageText(), file);
                    this.mMailManager.waitAfterMail();
                }
                catch (MailException e) {
                    sendingMailFailed = true;
                    ExceptionMapper.printException((Throwable)MailExceptionMapper.makeMailFailedDomainException((MailException)e));
                }
            }
            if (sendTypeMailLetter || this.mFromEmailAddress == null || sendingMailFailed) {
                result = JasperReportManager.getUrl((File)file);
                resultList.add(result);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("File name: {}", (Object)result);
                }
            }
        }
        return resultList;
    }

    private void initMailProtocol(String advisorMail, FinancePaymentSession session, Language language) {
        String fromEmail = userPersistencyManager.query(SessionContext.getInstance().getSession().getUserCode()).getEmail();
        if (!StringMapper.isNullString((String)advisorMail)) {
            fromEmail = advisorMail;
        }
        this.mFromEmailAddress = MailChecker.getCheckedEmailAddress((String)fromEmail);
        this.mJasperReportMailProtocol = MailProtocol.getReport();
        this.mMailProtocol = new MailProtocol(MailProtocolProgramEnum.PRINT_AVISE, session.getName(), language, this.mFromEmailAddress);
        this.mMailManager = (MailManager)UtilitiesManager.getBean((String)"emailManager", MailManager.class);
    }

    private List<String> exportLetter(List<BacsPaymentContainer> listAdviseLetter, AccountingCompany company, FinancePaymentSession session, Language language, JasperReport jasperReport) throws BusinessDomainException {
        LOGGER.debug("Druck Avise - PDF");
        ArrayList<String> resultList = new ArrayList<String>();
        String result = "";
        File file = null;
        SettlementAdviceDataSource adviseLetterDataSource = this.getDataSource(listAdviseLetter, session, language, false, this.mProgressInterface, this.mPrintToArchive);
        file = this.mPrintToArchive ? JasperReportManager.runReportToArchive((JasperReport)jasperReport, adviseLetterDataSource.getParameters(), (JRDataSource)adviseLetterDataSource, (String)PDFFILE_PREFIX, (byte[])company.getLetterTemplate(), (boolean)false, (int)this.mLeftMargin, (int)this.mTopMargin, (int)0, (int)0) : JasperReportManager.runReportToPdf((String)this.getToken().getUserId(), (JasperReport)jasperReport, adviseLetterDataSource.getParameters(), (JRDataSource)adviseLetterDataSource, (String)PDFFILE_PREFIX, (byte[])company.getLetterTemplate(), (boolean)true, (int)this.mLeftMargin, (int)this.mTopMargin, (int)0, (int)0);
        result = JasperReportManager.getUrl((File)file);
        resultList.add(JasperReportManager.getUrl((File)file));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("File name: {}", (Object)result);
        }
        return resultList;
    }

    private List<String> exportMail(List<BacsPaymentContainer> listAdviseEmail, AccountingCompany company, FinancePaymentSession session, Language language, JasperReport jasperReport, boolean makeCSVFile) throws BusinessDomainException, JRException {
        LOGGER.debug("Druck Avise - EMAIL");
        ArrayList<String> resultList = new ArrayList<String>();
        String result = "";
        File file = null;
        SettlementAdviceDataSource adviseEmailDataSource = this.getDataSource(listAdviseEmail, session, language, true, this.mProgressInterface, this.mPrintToArchive);
        while (adviseEmailDataSource.hasNext()) {
            file = makeCSVFile ? JasperReportManager.runReportToAsciiFile((JasperReport)jasperReport, adviseEmailDataSource.getParameters(), (JRDataSource)adviseEmailDataSource, (String)PDFFILE_PREFIX) : JasperReportManager.runReportToPdf((String)this.getToken().getUserId(), (JasperReport)jasperReport, adviseEmailDataSource.getParameters(), (JRDataSource)adviseEmailDataSource, (String)PDFFILE_PREFIX, (byte[])company.getLetterTemplate(), (boolean)true, (int)this.mLeftMargin, (int)this.mTopMargin, (int)0, (int)0);
            result = JasperReportManager.getUrl((File)file);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("File name: {}", (Object)result);
            }
            String toEmail = adviseEmailDataSource.getEmail();
            LOGGER.debug("toEmail: {}", (Object)toEmail);
            String paCode = adviseEmailDataSource.getPersonalAccountCode();
            String subject = paCode + "; " + adviseEmailDataSource.getSubjectText();
            LOGGER.debug("subject: {}", (Object)subject);
            Object messageText = adviseEmailDataSource.getEmailText();
            if (StringMapper.isNullString((String)messageText)) {
                messageText = StringMapper.toString((String)adviseEmailDataSource.getBodyText()) + "\n" + StringMapper.toString((String)adviseEmailDataSource.getFooterText());
            }
            LOGGER.debug("messageText: {}", messageText);
            if (this.mFromEmailAddress == null) {
                ExceptionMapper.printException((Throwable)MailExceptionMapper.makeNoFromDomainException());
                this.mMailProtocol.addFailedList(new MailProtocolEntry(toEmail, paCode, subject, "", false));
                continue;
            }
            if (MailChecker.wrongEmailAddress((String)toEmail)) {
                ExceptionMapper.printException((Throwable)MailExceptionMapper.makeNoToDomainException());
                this.mMailProtocol.addFailedList(new MailProtocolEntry(toEmail, paCode, subject, this.mMailProtocol.getWrongMailToText(), false));
                continue;
            }
            try {
                this.mMailManager.send((Credentials)null, this.mFromEmailAddress, (Collection)EmailAddressFactory.create((String)toEmail), subject, (String)messageText, file);
                this.mMailProtocol.addSuccessfulList(new MailProtocolEntry(toEmail, paCode, subject, "", true));
                this.mMailManager.waitAfterMail();
            }
            catch (MailException e) {
                ExceptionMapper.printException((Throwable)MailExceptionMapper.makeMailFailedDomainException((MailException)e));
                this.mMailProtocol.addFailedList(new MailProtocolEntry(toEmail, paCode, subject, this.mMailProtocol.getMailFailedText(), false));
            }
        }
        return resultList;
    }

    private List<String> exportFax(List<BacsPaymentContainer> listAdviseFax, AccountingCompany company, FinancePaymentSession session, Language language, JasperReport jasperReport) throws BusinessDomainException {
        LOGGER.debug("Druck Avise - FAX");
        ArrayList<String> resultList = new ArrayList<String>();
        String result = "";
        File file = null;
        String fromFax = SystemOptionsPersistencyManager.query().getFaxSoftware().getCode();
        LOGGER.debug("fax: {}", (Object)fromFax);
        SettlementAdviceDataSource adviseFaxDataSource = this.getDataSource(listAdviseFax, session, language, true, this.mProgressInterface, this.mPrintToArchive);
        while (adviseFaxDataSource.hasNext()) {
            file = JasperReportManager.runReportToFax((JasperReport)jasperReport, adviseFaxDataSource.getParameters(), (JRDataSource)adviseFaxDataSource, (String)("BSA_" + fromFax + "_"), (byte[])company.getLetterTemplate(), (boolean)false, (int)this.mLeftMargin, (int)this.mTopMargin, (int)0, (int)0, (JasperReportFaxDataSource)adviseFaxDataSource);
            result = JasperReportManager.getUrl((File)file);
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug("File name: {}", (Object)result);
        }
        return resultList;
    }

    private SelectGenerator getSelectGenerator(FinancePaymentSession session, boolean withOrderBy) {
        SelectGenerator select;
        Order[] order = null;
        if (withOrderBy) {
            order = PaymentReportHelper.getSortSettlementAdviceGeneratePayment((GeneratePaymentSession)session);
        }
        if (session.isGeneratePaymentSession()) {
            select = new SelectGenerator(PaymentReportHelper.getViewDescriptionGeneratePayment(), order, PaymentReportHelper.getFilterGeneratePayment((GeneratePaymentSession)session, new ArrayList<String>()), null, false);
        } else {
            if (withOrderBy) {
                order = PaymentReportHelper.getSortSettlementAdviceAdvancePayment();
            }
            Conjunction advFilter = Restrictions.conjunction();
            advFilter.add(PaymentReportHelper.getFilterAdvancePaymentPersAcc((AdvancePaymentSession)session, new ArrayList<String>()));
            advFilter.add(PaymentReportHelper.getFilterAdvanceSettlementAdvise());
            select = new SelectGenerator(PaymentReportHelper.getViewDescriptionAdvancePaymentPersAcc(), order, (Criterion)advFilter, null, false);
        }
        return select;
    }

    private RemittanceType checkDefaultSendType(RemittanceType defaultSendType, BacsPaymentContainer tmpContainer, boolean sendTypeMail, boolean sendTypeFax) {
        RemittanceType result = RemittanceType.LETTER;
        boolean hasMail = false;
        boolean hasFax = false;
        hasMail = sendTypeMail && !StringMapper.isNullString((String)tmpContainer.getDefaultEmail());
        boolean bl = hasFax = sendTypeFax && !StringMapper.isNullString((String)tmpContainer.getDefaultFax());
        if (hasMail && hasFax) {
            result = defaultSendType == RemittanceType.EMAIL ? RemittanceType.EMAIL : RemittanceType.FAX;
        } else if (hasMail) {
            result = RemittanceType.EMAIL;
        } else if (hasFax) {
            result = RemittanceType.FAX;
        }
        return result;
    }

    private boolean lessThanEntryLimit(GeneratePaymentSession session, GenpayremitoiContainer genpayremitoiContainer) {
        boolean result = true;
        int entryLimit = session.getEntryLimit();
        String oidPA = genpayremitoiContainer.oidpersonalacc;
        GenpayremitoiContainer[] genRows = daoGenPayRemitOi.getRows(null, PaymentReportHelper.getEntryLimitFilter(session, oidPA, genpayremitoiContainer.p_objectid));
        if (entryLimit > 0 && genRows.length >= entryLimit) {
            result = false;
        }
        return result;
    }

    private SettlementAdviceDataSource getDataSource(List<BacsPaymentContainer> containerList, FinancePaymentSession session, Language language, boolean newDocumentIfGroupChanged, ProgressInterface progressInterface, boolean printToArchive) {
        return new SettlementAdviceDataSource(containerList, session, this.mIsGeneratePayment, language, newDocumentIfGroupChanged, progressInterface, printToArchive);
    }
}

