/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.servantimpl.paymentrun;

import com.varial.accounting.billofexchange.BillOfExchangeTypeEnum;
import com.varial.accounting.domain.bankaccount.BankAccount;
import com.varial.accounting.domain.bankaccount.BankAccountMapper;
import com.varial.accounting.domain.bankaccount.BankAccountPersistencyManager;
import com.varial.accounting.domain.billofexchange.BillOfExchangePersistencyManager;
import com.varial.accounting.domain.financialyear.AccountingCompany;
import com.varial.accounting.domain.financialyear.AccountingCompanyPersistencyManager;
import com.varial.accounting.domain.financialyear.FinancialYear;
import com.varial.accounting.domain.financialyear.FinancialYearPersistencyManager;
import com.varial.accounting.domain.nominalledger.NLAccountCompanySetting;
import com.varial.accounting.domain.openitem.OpenItemPersistencyManager;
import com.varial.accounting.domain.openitemstatus.OpenItemStatus;
import com.varial.accounting.domain.openitemstatus.OpenItemStatusManager;
import com.varial.accounting.domain.openitemstatus.OpenItemStatusType;
import com.varial.accounting.domain.payment.FinancePayment;
import com.varial.accounting.domain.payment.FinancePaymentExceptionMapper;
import com.varial.accounting.domain.payment.FinancePaymentExporter;
import com.varial.accounting.domain.payment.FinancePaymentSession;
import com.varial.accounting.domain.payment.GeneratePayment;
import com.varial.accounting.domain.payment.GeneratePaymentSession;
import com.varial.accounting.domain.payment.PaymentSessionBankAccount;
import com.varial.accounting.domain.payment.report.PaymentReportHelper;
import com.varial.accounting.domain.personalaccount.PersonalAccount;
import com.varial.accounting.domain.personalaccount.PersonalAccountPersistencyManager;
import com.varial.accounting.domain.sequenceno.SequenceNo;
import com.varial.accounting.domain.sequenceno.SessionSequenceNo;
import com.varial.accounting.openitemstatus.OpenItemStatusAccountTypeEnum;
import com.varial.accounting.payment.PaymentSessionStruct;
import com.varial.accounting.paymentrun.BacsPaymentRunListPrintOptionStruct;
import com.varial.accounting.paymentrun.FirstChequeNumberStruct;
import com.varial.accounting.paymentrun.FirstNumberTypeEnum;
import com.varial.accounting.paymentrun.PaymentProposalPrintOptionStruct;
import com.varial.accounting.paymentrun.PaymentRunFunctionEnum;
import com.varial.accounting.paymentrun.PaymentRunQueryStruct;
import com.varial.accounting.servantimpl.AccountingRightList;
import com.varial.accounting.servantimpl.payment.FinancePaymentRightList;
import com.varial.accounting.servantimpl.paymentrun.AccompanyingNoticeReportFileCallbackImpl;
import com.varial.accounting.servantimpl.paymentrun.BacsPaymentRunListFileCallbackImpl;
import com.varial.accounting.servantimpl.paymentrun.BillReportFileCallbackImpl;
import com.varial.accounting.servantimpl.paymentrun.ChequeReportFileCallbackImpl;
import com.varial.accounting.servantimpl.paymentrun.PaymentProposalListFileCallbackImpl;
import com.varial.accounting.servantimpl.paymentrun.PaymentRunServantService;
import com.varial.accounting.servantimpl.paymentrun.PaymentRunSessionMapper;
import com.varial.accounting.servantimpl.paymentrun.SettlementAdviceFileCallbackImpl;
import com.varial.accounting.servantimpl.paymentrun.WhitelistCheckCallbackImpl;
import com.varial.base.UtilitiesManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.jasperreports.JasperReportResource;
import com.varial.base.security.AuthorizationToken;
import com.varial.base.service.AbstractApplicationService;
import com.varial.base.service.LazyRunnableHolder;
import com.varial.base.service.TransactionStatusHolder;
import com.varial.base.service.TransactionalServiceAdapter;
import com.varial.base.types.date.DateHelper;
import com.varial.framework.basictypes.FileExportStruct;
import com.varial.framework.basictypes.ReportFileStructCallback;
import com.varial.framework.correspondencetext.CorrespondenceTextCategoryEnum;
import com.varial.framework.domain.company.JurisdictionType;
import com.varial.framework.domain.correspondencetext.CorrespondenceText;
import com.varial.framework.domain.correspondencetext.CorrespondenceTextPersistencyManager;
import com.varial.framework.domain.paymentbase.Payment;
import com.varial.framework.domain.paymentbase.PaymentExporter;
import com.varial.framework.domain.paymentbase.PaymentRunAction;
import com.varial.framework.domain.paymentbase.PaymentSession;
import com.varial.framework.domain.paymentexportformat.PaymentExportFormat;
import com.varial.framework.domain.reports.ReportExceptionMapper;
import com.varial.framework.domain.reports.ReportPreconditions;
import com.varial.interfaces.IBankAccount;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.ExceptionMapper;
import com.varial.serverbase.mapper.StringMapper;
import com.varial.serverbase.query.ObjectStruct;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaymentRunServantImpl
extends AbstractApplicationService
implements PaymentRunServantService {
    private static Logger LOGGER = LoggerFactory.getLogger((String)PaymentRunServantImpl.class.getName());
    private final BankAccountMapper bankAccountMapper = new BankAccountMapper();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PaymentSessionStruct[] getSessionsFreeForPayment(AuthorizationToken token, PaymentRunQueryStruct filter) throws BusinessDomainException {
        try {
            this.beginQueryService();
            AccountingCompany company = AccountingCompanyPersistencyManager.getAccountingCompany((String)filter.oidCompany);
            token.checkAccess(AccountingRightList.getGetPaymentSessionRight(), company.getObjectid());
            FinancePaymentSession[] result = PaymentRunSessionMapper.getSessionsFreeForPayment((AccountingCompany)company, (PaymentRunQueryStruct)filter);
            PaymentSessionStruct[] paymentSessionStructArray = PaymentRunSessionMapper.toIdl((FinancePaymentSession[])result, (AuthorizationToken)token);
            return paymentSessionStructArray;
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FirstChequeNumberStruct[] getFirstChequeNumbers(AuthorizationToken token, ObjectStruct[] oidTsSessions, FirstNumberTypeEnum firstNumberType) throws BusinessDomainException {
        try {
            BankAccount bankAccount;
            this.beginQueryService();
            HashMap<String, BankAccount> bankAccountsMap = new HashMap<String, BankAccount>();
            for (int i = 0; i < oidTsSessions.length; ++i) {
                FinancePayment[] payments;
                FinancePaymentSession paymentSession = PaymentRunSessionMapper.getFinancePaymentSession((ObjectStruct)oidTsSessions[i]);
                PaymentSessionBankAccount[] bankAccounts = paymentSession.getPaymentSessionBankAccounts();
                if (bankAccounts.length == 1) {
                    bankAccount = bankAccounts[0].getBankAccount();
                    bankAccountsMap.put(bankAccount.getObjectid(), bankAccount);
                    continue;
                }
                block8: for (FinancePayment payment : payments = paymentSession.getFinancePayments()) {
                    switch (firstNumberType.value()) {
                        case 0: {
                            if (!payment.isCheque()) continue block8;
                            BankAccount bankAccount2 = payment.getBankAccount();
                            bankAccountsMap.put(bankAccount2.getObjectid(), bankAccount2);
                            continue block8;
                        }
                        case 1: {
                            if (!payment.isReverseBill()) continue block8;
                            BankAccount bankAccount2 = payment.getBankAccount();
                            bankAccountsMap.put(bankAccount2.getObjectid(), bankAccount2);
                            continue block8;
                        }
                    }
                }
            }
            FirstChequeNumberStruct[] result = new FirstChequeNumberStruct[bankAccountsMap.size()];
            Iterator it = bankAccountsMap.values().iterator();
            int i = 0;
            while (it.hasNext()) {
                bankAccount = (BankAccount)((Object)it.next());
                int firstNumber = 0;
                boolean editable = true;
                if (firstNumberType.value() == 0) {
                    int lastChequeNumber = bankAccount.getChequeNumber();
                    boolean bl = editable = lastChequeNumber == -1;
                    if (!editable) {
                        firstNumber = lastChequeNumber + 1;
                    }
                }
                result[i] = new FirstChequeNumberStruct(this.bankAccountMapper.toShortIdl(bankAccount), firstNumber, editable);
                ++i;
            }
            FirstChequeNumberStruct[] firstChequeNumberStructArray = result;
            return firstChequeNumberStructArray;
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postPayments(AuthorizationToken token, ObjectStruct oidTsSession, TransactionStatusHolder txHolder) throws BusinessDomainException {
        try {
            this.beginUpdateService();
            FinancePaymentSession paymentSession = PaymentRunSessionMapper.getFinancePaymentSession((ObjectStruct)oidTsSession);
            token.checkAccess(FinancePaymentRightList.getPostRight((FinancePaymentSession)paymentSession), paymentSession.getCompany().getObjectid());
            if (paymentSession.isGeneratePaymentSession() && !paymentSession.getIsReverseFactoring()) {
                SessionSequenceNo sessionSequenceNo = SequenceNo.makeSessionSequenceNoForInvoiceAllocation((GeneratePaymentSession)((GeneratePaymentSession)paymentSession));
                if (sessionSequenceNo != null && txHolder.hasTransactionStatus()) {
                    TransactionalServiceAdapter txAdapter = new TransactionalServiceAdapter();
                    txAdapter.commit(txHolder.getTransactionStatus());
                    txHolder.setTransactionStatus(txAdapter.getUpdateTransaction());
                }
                ((GeneratePaymentSession)paymentSession).setSessionSequenceNoForInvoiceAllocation(sessionSequenceNo);
            }
            PersonalAccountPersistencyManager.loadPersonalAccounts((FinancePaymentSession)paymentSession);
            if (paymentSession.isGeneratePaymentSession()) {
                OpenItemPersistencyManager.loadOpenItems((GeneratePaymentSession)((GeneratePaymentSession)paymentSession));
            }
            paymentSession.postPayments();
            this.getContext().flush();
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postBill(AuthorizationToken token, ObjectStruct oidTsSession, int firstBillNumber) throws BusinessDomainException {
        try {
            this.beginUpdateService();
            GeneratePaymentSession billSession = (GeneratePaymentSession)PaymentRunSessionMapper.getFinancePaymentSession((ObjectStruct)oidTsSession);
            token.checkAccess(FinancePaymentRightList.getPostRight((FinancePaymentSession)billSession), billSession.getCompany().getObjectid());
            billSession.createBills(firstBillNumber);
            billSession.postPayments();
            this.getContext().flush();
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printChequesByJasperForDivBankAccounts(AuthorizationToken token, ObjectStruct[] oidTsSessions, FirstChequeNumberStruct[] firstChequeNumbers, String chequeDate, int leftMargin, int topMargin, ReportFileStructCallback callback, boolean testPrint, LazyRunnableHolder lazyHolder) throws BusinessDomainException {
        try {
            if (testPrint) {
                this.beginQueryService();
            } else {
                this.beginUpdateService();
            }
            FinancePaymentSession financePaymentSession = PaymentRunSessionMapper.getFinancePaymentSession((String)oidTsSessions[0].objectid);
            token.checkAccess(AccountingRightList.getPrintChequesRight(), financePaymentSession.getAccountingCompany().getObjectid());
            BankAccountPersistencyManager bankAccountPersistencyManager = (BankAccountPersistencyManager)UtilitiesManager.getBean((String)"bankAccountPersistencyManager", BankAccountPersistencyManager.class);
            for (int i = 0; i < firstChequeNumbers.length; ++i) {
                BankAccount bankAccount = bankAccountPersistencyManager.getBankAccount(firstChequeNumbers[i].bankAccount.oidTs.objectid);
                String xmlFile = bankAccount.getChequeXMLFile();
                LOGGER.debug("BankAccount: {}, xmlFile: {}", (Object)bankAccount.getCode(), (Object)xmlFile);
                if (StringMapper.isNullString((String)xmlFile)) {
                    throw ReportExceptionMapper.makeNoXmlFileForBankAccountDomainException((String)("Bank Account Code: " + bankAccount.getCode()));
                }
                if (JasperReportResource.existsReport((String)xmlFile)) continue;
                throw ReportExceptionMapper.makeNoXmlFileDomainException((String)xmlFile);
            }
            ArrayList<FinancePaymentSession> listGen = new ArrayList<FinancePaymentSession>();
            ArrayList<FinancePaymentSession> listAdv = new ArrayList<FinancePaymentSession>();
            if (!testPrint) {
                for (int i = 0; i < oidTsSessions.length; ++i) {
                    FinancePaymentSession session = PaymentRunSessionMapper.getFinancePaymentSession((String)oidTsSessions[i].objectid);
                    if (session.isGeneratePaymentSession()) {
                        listGen.add(session);
                    } else {
                        listAdv.add(session);
                    }
                    session.makeSaveable();
                    session.printCheques();
                }
                this.getContext().flush();
            }
            ChequeReportFileCallbackImpl command = new ChequeReportFileCallbackImpl(token, callback, listGen, listAdv, firstChequeNumbers, DateMapper.toDate((String)chequeDate), leftMargin, topMargin, testPrint, financePaymentSession.getAccountingCompany().getDefaultLanguage().getObjectid());
            lazyHolder.setLowPriorityRunnable((Runnable)command);
            return;
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printBill(AuthorizationToken token, ObjectStruct oidTsSession, int firstBillNumber, int leftMargin, int topMargin, ReportFileStructCallback callback, String oidFinancialYear, String transactionDate, LazyRunnableHolder lazyHolder) throws BusinessDomainException {
        try {
            GeneratePayment[] generatePayments;
            this.beginUpdateService();
            FinancePaymentSession paymentSession = PaymentRunSessionMapper.getFinancePaymentSession((ObjectStruct)oidTsSession);
            GeneratePaymentSession generatePaymentSession = (GeneratePaymentSession)paymentSession;
            String right = generatePaymentSession.getIsBillPayable() ? AccountingRightList.getPrintBillPayableRight() : AccountingRightList.getPrintBillReceivableRight();
            token.checkAccess(right, generatePaymentSession.getAccountingCompany().getObjectid());
            BankAccount bankAccount = generatePaymentSession.getPaymentSessionBankAccounts()[0].getBankAccount();
            String xmlFile = bankAccount.getBillOfExchangeXMLFile();
            LOGGER.debug("xmlFile: {}", (Object)xmlFile);
            if (StringMapper.isNullString((String)xmlFile)) {
                throw ReportExceptionMapper.makeNoXmlFileBillDomainException((String)("Bank Account Code: " + bankAccount.getCode()));
            }
            if (!JasperReportResource.existsReport((String)xmlFile)) {
                throw ReportExceptionMapper.makeNoXmlFileDomainException((String)xmlFile);
            }
            CorrespondenceTextCategoryEnum textCategory = this.getCorrespondenceTextCategory(generatePaymentSession);
            if (xmlFile.equals("com/varial/accounting/jasperreport/billofexchange/BillOfExchangeReportFalke.jrxml")) {
                ReportPreconditions reportPreconditions = new ReportPreconditions();
                this.checkLanguageVariantsForBill(generatePaymentSession, textCategory, reportPreconditions);
            }
            if ((generatePayments = generatePaymentSession.getGeneratePayments()) != null && generatePayments[0] != null && generatePayments[0].getBillOfExchange() == null) {
                generatePaymentSession.createBills(firstBillNumber);
            }
            generatePaymentSession.printBills();
            FinancialYear year = null;
            Date tDate = null;
            if (!StringMapper.isNullString((String)oidFinancialYear)) {
                year = FinancialYearPersistencyManager.getFinancialYear((String)oidFinancialYear);
                if (!StringMapper.isNullString((String)transactionDate)) {
                    tDate = DateMapper.toDate((String)transactionDate);
                }
            } else {
                year = generatePaymentSession.getFinancialYear();
                tDate = generatePaymentSession.getTransactionDate();
            }
            generatePaymentSession.setBillStatus(OpenItemStatusType.BILL_PRINTED, year, tDate);
            this.getContext().flush();
            FirstChequeNumberStruct[] firstBillNumbers = new FirstChequeNumberStruct[]{new FirstChequeNumberStruct()};
            firstBillNumbers[0].bankAccount = this.bankAccountMapper.toShortIdl(bankAccount);
            firstBillNumbers[0].firstChequeNumber = firstBillNumber;
            BillReportFileCallbackImpl command = new BillReportFileCallbackImpl(token, callback, generatePaymentSession.getObjectid(), firstBillNumbers, leftMargin, topMargin, textCategory, generatePaymentSession.getIsBillReceivable() ? BillOfExchangeTypeEnum.BOETE_BILL_RECEIVABLE : BillOfExchangeTypeEnum.BOETE_BILL_PAYABLE);
            lazyHolder.setLowPriorityRunnable((Runnable)command);
            return;
        }
        finally {
            this.endService();
        }
    }

    public FileExportStruct[] exportBill(AuthorizationToken token, ObjectStruct oidTsSession, int firstBillNumber, String oidFinancialYear, String transactionDate) throws BusinessDomainException {
        try {
            PaymentExporter exporter;
            this.beginUpdateService();
            FinancePaymentSession paymentSession = PaymentRunSessionMapper.getFinancePaymentSession((ObjectStruct)oidTsSession);
            GeneratePaymentSession generatePaymentSession = (GeneratePaymentSession)paymentSession;
            if (!generatePaymentSession.getIsBillPayable() && !generatePaymentSession.getIsBillReceivable()) {
                throw ExceptionMapper.makeApplicationException((String)"Wrong session type");
            }
            PersonalAccountPersistencyManager.loadPersonalAccounts((FinancePaymentSession)generatePaymentSession);
            OpenItemPersistencyManager.loadOpenItems((GeneratePaymentSession)generatePaymentSession);
            FinancialYear year = null;
            Date tDate = null;
            if (!StringMapper.isNullString((String)oidFinancialYear)) {
                year = FinancialYearPersistencyManager.getFinancialYear((String)oidFinancialYear);
            }
            if (!StringMapper.isNullString((String)transactionDate)) {
                tDate = DateMapper.toDateOrNull((String)transactionDate);
            }
            GeneratePayment[] generatePayments = generatePaymentSession.getGeneratePayments();
            PaymentSessionBankAccount[] sessionBankAccounts = generatePaymentSession.getPaymentSessionBankAccounts();
            BankAccount bankAccount = sessionBankAccounts[0].getBankAccount();
            if (!paymentSession.getUseOpenItemStatus()) {
                ArrayList<GeneratePayment> toExport = new ArrayList<GeneratePayment>();
                Date executeDate = DateHelper.today();
                for (int i = 0; i < generatePayments.length; ++i) {
                    if (generatePayments[i].getCashTransaction() == null) continue;
                    if (generatePayments[i].getExecuteDate() == null) {
                        generatePayments[i].makeSaveable();
                        generatePayments[i].setExecuteDate(executeDate);
                        toExport.add(generatePayments[i]);
                        continue;
                    }
                    if (!DateHelper.equal((Date)generatePayments[i].getExecuteDate(), (Date)executeDate)) continue;
                    toExport.add(generatePayments[i]);
                }
                if (toExport.isEmpty()) {
                    throw FinancePaymentExceptionMapper.makeNoPostedBillsDomainException();
                }
                if (toExport.size() == generatePayments.length) {
                    generatePaymentSession.exportBills(true, year, tDate, generatePayments);
                    generatePaymentSession.setIBankAccount((IBankAccount)bankAccount);
                    exporter = PaymentExporter.getPaymentExporter((PaymentSession[])new PaymentSession[]{generatePaymentSession});
                } else {
                    GeneratePayment[] exportPayments = new GeneratePayment[toExport.size()];
                    toExport.toArray(exportPayments);
                    GeneratePaymentSession newSession = new GeneratePaymentSession(generatePaymentSession, bankAccount, executeDate, false, null);
                    newSession.makeReadOnly();
                    newSession.setGeneratePayments(exportPayments);
                    exporter = PaymentExporter.getPaymentExporter((PaymentSession[])new PaymentSession[]{newSession});
                    generatePaymentSession.exportBills(generatePaymentSession.getPaymentsPosted() != null, year, tDate, exportPayments);
                }
            } else {
                if (generatePayments != null && generatePayments[0] != null && generatePayments[0].getBillOfExchange() == null) {
                    generatePaymentSession.createBills(firstBillNumber);
                }
                generatePaymentSession.exportBills(true, year, tDate, generatePayments);
                generatePaymentSession.setIBankAccount((IBankAccount)bankAccount);
                exporter = PaymentExporter.getPaymentExporter((PaymentSession[])new PaymentSession[]{generatePaymentSession});
            }
            exporter.createExport();
            FileExportStruct[] result = exporter.getFileExport();
            this.getContext().flush();
            FileExportStruct[] fileExportStructArray = result;
            return fileExportStructArray;
        }
        catch (IOException e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printReverseBill(AuthorizationToken token, ObjectStruct[] oidTsSessions, FirstChequeNumberStruct[] firstBillNumbers, String billDate, int leftMargin, int topMargin, ReportFileStructCallback callback, LazyRunnableHolder lazyHolder) throws BusinessDomainException {
        try {
            this.beginUpdateService();
            FinancePaymentSession paymentSession = PaymentRunSessionMapper.getFinancePaymentSession((ObjectStruct)oidTsSessions[0]);
            GeneratePaymentSession generatePaymentSession = (GeneratePaymentSession)paymentSession;
            token.checkAccess(AccountingRightList.getPrintBillPayableRight(), generatePaymentSession.getAccountingCompany().getObjectid());
            CorrespondenceTextCategoryEnum textCategory = this.getCorrespondenceTextCategory(generatePaymentSession);
            ReportPreconditions reportPreconditions = new ReportPreconditions();
            BankAccountPersistencyManager bankAccountPersistencyManager = (BankAccountPersistencyManager)UtilitiesManager.getBean((String)"bankAccountPersistencyManager", BankAccountPersistencyManager.class);
            for (int i = 0; i < firstBillNumbers.length; ++i) {
                BankAccount bankAccount = bankAccountPersistencyManager.getBankAccount(firstBillNumbers[i].bankAccount.oidTs.objectid);
                String xmlFile = bankAccount.getBillOfExchangeXMLFile();
                if (StringMapper.isNullString((String)xmlFile)) {
                    throw ReportExceptionMapper.makeNoXmlFileBillDomainException((String)("Bank Account Code: " + bankAccount.getCode()));
                }
                if (xmlFile.equals("com/varial/accounting/jasperreport/billofexchange/BillOfExchangeReportFalke.jrxml")) {
                    this.checkLanguageVariantsForBill(generatePaymentSession, textCategory, reportPreconditions);
                }
                int firstNumber = firstBillNumbers[i].firstChequeNumber;
                generatePaymentSession.createReverseBills(bankAccount, firstNumber);
            }
            generatePaymentSession.printReverseBills();
            this.getContext().flush();
            BillReportFileCallbackImpl command = new BillReportFileCallbackImpl(token, callback, generatePaymentSession.getObjectid(), firstBillNumbers, leftMargin, topMargin, textCategory, BillOfExchangeTypeEnum.BOETE_BILL_REVERSE_SUPPLIER);
            lazyHolder.setLowPriorityRunnable((Runnable)command);
            return;
        }
        finally {
            this.endService();
        }
    }

    public FileExportStruct[] exportPayments(AuthorizationToken token, ObjectStruct[] oidTsSessions) throws BusinessDomainException {
        try {
            this.beginUpdateService();
            List<FinancePaymentSession> exportSessions = this.getExportPaymentSessions(oidTsSessions);
            ArrayList<FileExportStruct> resultList = new ArrayList<FileExportStruct>();
            int sepaFileCounter = 0;
            for (FinancePaymentSession exportPaymentSession : exportSessions) {
                PaymentExporter paymentExporter = FinancePaymentExporter.getPaymentExporter(exportPaymentSession, PaymentRunAction.CREATE_FILE);
                paymentExporter.createExport();
                FileExportStruct[] files = paymentExporter.getFileExport();
                boolean completeFileName = paymentExporter.completeFileName();
                boolean isSepa = exportPaymentSession.getGenerateSepa();
                for (FileExportStruct file : files) {
                    file.fileName = PaymentReportHelper.getFileName(completeFileName, true, file.fileName, exportPaymentSession);
                    if (isSepa) {
                        file.fileName = this.completeFileNameSepa(file.fileName, ++sepaFileCounter);
                    }
                    resultList.add(file);
                }
            }
            this.getContext().flush();
            List<FileExportStruct> exportCheques = this.getExportCheques(exportSessions);
            if (!exportCheques.isEmpty()) {
                resultList.addAll(exportCheques);
            }
            FileExportStruct[] fileExportStructArray = resultList.toArray(new FileExportStruct[0]);
            return fileExportStructArray;
        }
        catch (IOException e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        finally {
            this.endService();
        }
    }

    private List<FinancePaymentSession> getExportPaymentSessions(ObjectStruct[] oidTsSessions) throws BusinessDomainException {
        ArrayList<FinancePaymentSession> exportSessions = new ArrayList<FinancePaymentSession>();
        for (int i = 0; i < oidTsSessions.length; ++i) {
            FinancePaymentSession paymentSession = PaymentRunSessionMapper.getFinancePaymentSession((ObjectStruct)oidTsSessions[i]);
            if (paymentSession.isGeneratePaymentSession() && (((GeneratePaymentSession)paymentSession).getIsBillPayable() || ((GeneratePaymentSession)paymentSession).getIsBillReceivable())) {
                throw ExceptionMapper.makeApplicationException((String)"Wrong session type");
            }
            paymentSession.makeSaveable();
            paymentSession.exportPayment();
            exportSessions.addAll(PaymentRunSessionMapper.makeExportPaymentSessions((FinancePaymentSession)paymentSession));
        }
        return exportSessions;
    }

    private List<FileExportStruct> getExportCheques(List<FinancePaymentSession> sessions) throws BusinessDomainException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("exportPayments | getExportCheques(), sessions.length: <{}>", (Object)sessions.size());
        }
        ArrayList<FileExportStruct> result = new ArrayList<FileExportStruct>();
        FileExportStruct[] files = null;
        BankAccountPersistencyManager bankAccountPersistencyManager = (BankAccountPersistencyManager)UtilitiesManager.getBean((String)"bankAccountPersistencyManager", BankAccountPersistencyManager.class);
        for (FinancePaymentSession session : sessions) {
            PaymentExporter chequeExporter;
            PaymentExportFormat format;
            if (session.getCompany().getJurisdictionType() != JurisdictionType.US) continue;
            BankAccount bankAccount = bankAccountPersistencyManager.getBankAccount(session.getIBankAccount().getObjectid());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("exportPayments | getExportCheques(), bankAccount: <{}>", (Object)bankAccount.getCode());
            }
            if ((format = bankAccount.getExportFormat()) == null) continue;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("exportPayments | getExportCheques(), Exporter: <{}>", (Object)format.getExporterClass());
            }
            if ((chequeExporter = this.getPaymentExporter(bankAccount, new FinancePaymentSession[]{session})) == null || !chequeExporter.hasChequeFile()) continue;
            chequeExporter.createExportCheque();
            files = chequeExporter.getFileExportCheque();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("exportPayments | getExportCheques(), files.length: <{}>", (Object)files.length);
            }
            FileExportStruct file = files[0];
            file.fileName = PaymentReportHelper.getFileName(chequeExporter.completeFileName(), true, file.fileName, session);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("exportPayments | getExportCheques(), file.fileName: <{}>", (Object)file.fileName);
            }
            result.add(file);
        }
        return result;
    }

    private String completeFileNameSepa(String fileName, int counter) {
        StringBuilder sb = new StringBuilder();
        sb.append(fileName).append("_").append(counter).append(".xml");
        return sb.toString();
    }

    private PaymentExporter getPaymentExporter(BankAccount bankAccount, FinancePaymentSession[] paymentSessions) {
        PaymentExporter result = null;
        PaymentExportFormat format = bankAccount.getExportFormat();
        if (format != null) {
            try {
                Class<?> exporterClass = Class.forName(format.getExporterClass());
                result = (PaymentExporter)exporterClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                result.setPaymentSessions((PaymentSession[])paymentSessions);
            }
            catch (Exception e) {
                throw ExceptionMapper.makeApplicationException((Throwable)e);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSessionDone(AuthorizationToken token, ObjectStruct oidTsSession) throws BusinessDomainException {
        try {
            this.beginUpdateService();
            FinancePaymentSession paymentSession = PaymentRunSessionMapper.getFinancePaymentSession((ObjectStruct)oidTsSession);
            token.checkAccess(FinancePaymentRightList.getSetPaymentSessionToDoneRight((FinancePaymentSession)paymentSession), paymentSession.getAccountingCompany().getObjectid());
            paymentSession.setDone();
            this.getContext().flush();
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printBacsPaymentRunList(AuthorizationToken token, String[] oidSessions, BacsPaymentRunListPrintOptionStruct printOptions, ReportFileStructCallback callback, LazyRunnableHolder lazyHolder) throws BusinessDomainException {
        try {
            this.beginQueryService();
            FinancePaymentSession paymentSesion = PaymentRunSessionMapper.getFinancePaymentSession((String)oidSessions[0]);
            token.checkAccess(AccountingRightList.getPrintBacsRight(), paymentSesion.getAccountingCompany().getObjectid());
            BacsPaymentRunListFileCallbackImpl command = new BacsPaymentRunListFileCallbackImpl(token, callback, paymentSesion.getAccountingCompany().getDefaultLanguage().getObjectid(), oidSessions, printOptions);
            lazyHolder.setLowPriorityRunnable((Runnable)command);
            return;
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printBacsSettlementAdvice(AuthorizationToken token, String[] oidSessions, int leftMargin, int topMargin, ReportFileStructCallback callback, String oidReport, boolean printToArchive, LazyRunnableHolder lazyHolder) throws BusinessDomainException {
        try {
            this.beginUpdateService();
            FinancePaymentSession paymentSession = PaymentRunSessionMapper.getFinancePaymentSession((String)oidSessions[0]);
            token.checkAccess(AccountingRightList.getPrintBacsRight(), paymentSession.getAccountingCompany().getObjectid());
            for (int i = 0; i < oidSessions.length; ++i) {
                paymentSession = PaymentRunSessionMapper.getFinancePaymentSession((String)oidSessions[i]);
                if (paymentSession.isGeneratePaymentSession()) {
                    this.checkLanguageVariantsForAdvice((GeneratePaymentSession)paymentSession);
                }
                paymentSession.makeSaveable();
                paymentSession.printRemittanceAdvice();
            }
            this.getContext().flush();
            SettlementAdviceFileCallbackImpl command = new SettlementAdviceFileCallbackImpl(token, callback, paymentSession.getAccountingCompany().getDefaultLanguage().getObjectid(), paymentSession.getAccountingCompany().getObjectid(), paymentSession.getObjectid(), paymentSession.isGeneratePaymentSession(), leftMargin, topMargin, oidReport, printToArchive);
            lazyHolder.setLowPriorityRunnable((Runnable)((Object)command));
            return;
        }
        finally {
            this.endService();
        }
    }

    private void checkLanguageVariantsForAdvice(GeneratePaymentSession generatePaymentSession) throws BusinessDomainException {
        Payment[] payments = null;
        payments = generatePaymentSession.getIsDirectDebit() ? generatePaymentSession.getPaymentsForDirectDebit() : generatePaymentSession.getPaymentsForBacs();
        if (generatePaymentSession.getGeneratePaymentFormType().value() == 3 || generatePaymentSession.getGeneratePaymentFormType().value() == 4) {
            payments = generatePaymentSession.getPayments();
        }
        PersonalAccount[] personalAccounts = new PersonalAccount[payments.length];
        int n = payments.length;
        for (int i = 0; i < n; ++i) {
            personalAccounts[i] = ((GeneratePayment)payments[i]).getPersonalAccount();
        }
        if (generatePaymentSession.getCorrespondenceText() != null && personalAccounts.length > 0) {
            CorrespondenceText text = CorrespondenceTextPersistencyManager.getTextByOid((String)generatePaymentSession.getCorrespondenceText().getObjectid());
            ReportPreconditions reportPreconditions = new ReportPreconditions();
            for (PersonalAccount personalAccount : personalAccounts) {
                reportPreconditions.checkUsedLanguages(text, new String[]{personalAccount.getObjectid()});
            }
        }
    }

    private void checkLanguageVariantsForBill(GeneratePaymentSession generatePaymentSession, CorrespondenceTextCategoryEnum correspondenceTextCategory, ReportPreconditions reportPreconditions) throws BusinessDomainException {
        GeneratePayment[] generatePayments = generatePaymentSession.getGeneratePayments();
        for (int i = 0; i < generatePayments.length; ++i) {
            PersonalAccount personalAccount = generatePayments[i].getPersonalAccount();
            CorrespondenceText[] correspondenceTexts = CorrespondenceTextPersistencyManager.getCorrespondenceTextsByCategory((CorrespondenceTextCategoryEnum)correspondenceTextCategory);
            if (correspondenceTexts == null || correspondenceTexts.length == 0) continue;
            reportPreconditions.checkUsedLanguages(correspondenceTexts[0], new String[]{personalAccount.getObjectid()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printDtausAccompanyingNotice(AuthorizationToken token, String[] oidTsSessions, ReportFileStructCallback callback, LazyRunnableHolder lazyHolder) throws BusinessDomainException {
        try {
            this.beginQueryService();
            FinancePaymentSession paymentSession = PaymentRunSessionMapper.getFinancePaymentSession((String)oidTsSessions[0]);
            token.checkAccess(AccountingRightList.getPrintBacsRight(), paymentSession.getAccountingCompany().getObjectid());
            AccompanyingNoticeReportFileCallbackImpl command = new AccompanyingNoticeReportFileCallbackImpl(token, callback, oidTsSessions);
            lazyHolder.setLowPriorityRunnable((Runnable)command);
            return;
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printPaymentProposalList(AuthorizationToken token, String[] oidSessions, PaymentProposalPrintOptionStruct printOptions, ReportFileStructCallback callback, LazyRunnableHolder lazyHolder) throws BusinessDomainException {
        try {
            this.beginQueryService();
            FinancePaymentSession paymentSession = PaymentRunSessionMapper.getFinancePaymentSession((String)oidSessions[0]);
            token.checkAccess(AccountingRightList.getPrintPaymentProposalListRight(), paymentSession.getAccountingCompany().getObjectid());
            PaymentProposalListFileCallbackImpl command = new PaymentProposalListFileCallbackImpl(token, callback, paymentSession.getAccountingCompany().getDefaultLanguage().getObjectid(), oidSessions, printOptions);
            lazyHolder.setLowPriorityRunnable((Runnable)command);
            return;
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean transactionDateRequired(AuthorizationToken token, ObjectStruct oidTsSession, PaymentRunFunctionEnum paymentRunFunction) throws BusinessDomainException {
        try {
            GeneratePaymentSession generatePaymentSession;
            this.beginQueryService();
            FinancePaymentSession financePaymentSession = PaymentRunSessionMapper.getFinancePaymentSession((ObjectStruct)oidTsSession);
            boolean result = false;
            if (financePaymentSession.isGeneratePaymentSession() && !((GeneratePaymentSession)financePaymentSession).getUseOpenItemStatus() && ((generatePaymentSession = (GeneratePaymentSession)financePaymentSession).getCheques() != null || generatePaymentSession.getPaymentsPosted() != null) && generatePaymentSession.getIsDone() == null) {
                OpenItemStatusManager statusManager = new OpenItemStatusManager(generatePaymentSession.getAccountingCompany());
                OpenItemStatusType newStatusType = OpenItemStatusType.BILL_PRINTED;
                PaymentSessionBankAccount[] paymentSessionBankAccounts = generatePaymentSession.getPaymentSessionBankAccounts();
                for (int i = 0; i < paymentSessionBankAccounts.length; ++i) {
                    BankAccount bankAccount = paymentSessionBankAccounts[i].getBankAccount();
                    OpenItemStatus billStatus = statusManager.getOpenItemStatus(bankAccount, newStatusType, OpenItemStatusAccountTypeEnum.OISATE_BANK_INTERMEDIATE_ACCOUNT);
                    if (billStatus == null) continue;
                    NLAccountCompanySetting newAccount = null;
                    newAccount = generatePaymentSession.getIsBillPayable() ? billStatus.getAccountPayable() : billStatus.getAccountReceivable();
                    if (newAccount != null && (result = BillOfExchangePersistencyManager.executeBillTransferPosting((GeneratePaymentSession)generatePaymentSession, (NLAccountCompanySetting)newAccount, (OpenItemStatusType)newStatusType, (BankAccount)bankAccount))) break;
                }
            }
            boolean bl = result;
            return bl;
        }
        finally {
            this.endService();
        }
    }

    private CorrespondenceTextCategoryEnum getCorrespondenceTextCategory(GeneratePaymentSession paymentSession) {
        return paymentSession.getIsBillPayable() ? CorrespondenceTextCategoryEnum.CTCE_BILL_OF_EXCHANGE_PAYABLE : CorrespondenceTextCategoryEnum.CTCE_BILL_OF_EXCHANGE_RECEIVABLE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkWhiteList(AuthorizationToken token, String[] paymentSessionOids, ReportFileStructCallback callback, LazyRunnableHolder lazyHolder) throws BusinessDomainException {
        try {
            this.beginQueryService();
            FinancePaymentSession paymentSession = PaymentRunSessionMapper.getFinancePaymentSession((String)paymentSessionOids[0]);
            token.checkAccess(AccountingRightList.getPrintPaymentProposalListRight(), paymentSession.getAccountingCompany().getObjectid());
            WhitelistCheckCallbackImpl command = new WhitelistCheckCallbackImpl(token, paymentSessionOids[0], callback);
            lazyHolder.setStandardRunnable((Runnable)command);
            return;
        }
        finally {
            this.endService();
        }
    }
}

