/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.domain.taxregisterreport.report.taxregisterreport;

import com.infor.igf.core.util.StringUtil;
import com.varial.accounting.domain.financialyear.AccountingCompany;
import com.varial.accounting.domain.financialyear.AccountingCompanyPersistencyManager;
import com.varial.accounting.domain.nominaltransactionbase.NominalTransactionBase;
import com.varial.accounting.domain.sequenceno.SequenceNo;
import com.varial.accounting.domain.sequenceno.SequenceNoPersistencyManager;
import com.varial.accounting.domain.taxcode.TaxCode;
import com.varial.accounting.domain.taxcode.TaxCodePersistencyManager;
import com.varial.accounting.domain.taxcode.TaxRate;
import com.varial.accounting.domain.taxcode.TaxRatePersistencyManager;
import com.varial.accounting.domain.taxregisterreport.TaxRegisterReportFlags;
import com.varial.accounting.domain.taxregisterreport.TaxRegisterReportHelper;
import com.varial.accounting.domain.taxregisterreport.report.containers.TaxRegisterReportContainer;
import com.varial.accounting.domain.taxregisterreport.report.containers.TaxRegisterSubreportContainer;
import com.varial.accounting.domain.taxregisterreport.report.taxregisterreport.TaxRegisterSubReportDataSource;
import com.varial.accounting.persistency.nlentry.NlentryContainer;
import com.varial.accounting.persistency.nlentrytaxreg.NlentrytaxregContainer;
import com.varial.accounting.persistency.nltransaction.NltransactionContainer;
import com.varial.accounting.taxregisterreport.TaxRegisterReportStruct;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.jasperreports.JasperParameterHashMap;
import com.varial.base.session.SessionContext;
import com.varial.base.types.date.DateHelper;
import com.varial.framework.basictypes.addresses.PostalAddress;
import com.varial.interfaces.ICurrency;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.domain.language.ILanguage;
import com.varial.serverbase.domain.language.Language;
import com.varial.serverbase.domain.language.LanguageManager;
import com.varial.serverbase.domain.resource.TranslateableResourceList;
import com.varial.serverbase.mapper.BigDecimalFormatter;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.ExceptionMapper;
import com.varial.shared.Version;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaxRegisterReportDataSource
implements JRDataSource {
    protected static final Logger LOGGER = LoggerFactory.getLogger((String)TaxRegisterReportDataSource.class.getName());
    private final Object[][] mDataset;
    private int resultCounter = 0;
    private TaxRegisterReportContainer mContainer;
    private final List<TaxRegisterSubreportContainer> mSubReportContainerList = new ArrayList<TaxRegisterSubreportContainer>();
    private TaxRegisterSubreportContainer[] mOneRegisterContainers;
    private TaxRegisterSubreportContainer[] mAllRegistersContainers = null;
    private String mRegisterCodesForSummaryLineInput = "";
    private String mRegisterCodesForSummaryLineOutput = "";
    private TaxRegisterSubReportDataSource mSubReportOneRegisterDataSource;
    private TaxRegisterSubReportDataSource mSubReportAllRegistersDataSource;
    private final TaxRegisterReportStruct mReport;
    private final AccountingCompany mCompany;
    private final Language mGlobalLanguage;
    private final Language mTextDepLanguage;
    private final ICurrency mCurrency;
    private BigDecimalFormatter mFormatter;
    private boolean mHasNext = true;
    private String mOidRegister = "";
    private Integer mRegisterPageNumber;
    private final TaxRegisterReportFlags mTaxRegisterReportFlags;
    private final boolean mIsReverseChargeMethod;
    private static final String P_FORMATTER = "P_Formatter";
    private static final String P_ISPROVISIONAL = "P_IsProvisional";
    private static final String P_COMPANYADDRESS = "P_CompanyAddress";
    private static final String P_PRINTDATE = "P_PrintDate";
    private static final String P_USER = "P_User";
    private static final String P_PERIODFROM = "P_PeriodFrom";
    private static final String P_PERIODUNTIL = "P_PeriodUntil";
    private static final String P_TAXNUMBER = "P_TaxNumber";
    private static final String P_FINANCIALYEAR = "P_FinancialYear";
    private static final String P_ISSINGLEROW = "P_IsSingleRow";
    private static final String P_TAX_REGISTER_REPORT_FLAGS = "P_TaxRegisterReportFlags";
    private static final String P_TIME = "P_Time";
    private static final String P_RELEASE = "P_Release";
    private static final String P_VATIDNO = "P_VATIdNo";
    private static final String P_ACTIVITYCODE = "P_ActivityCode";
    private static final String F_SUBREPORTONEREGISTER = "F_SubReportOneRegister";
    private static final String F_SUBREPORTALLREGISTERS = "F_SubReportAllRegisters";
    private static final String F_OIDTAXREGISTER = "F_OidTaxRegister";
    private static final String F_OIDENTRY = "F_OidEntry";
    private static final String F_ISINPUTTAX = "F_IsInputTax";
    private static final String F_SEQUENCENO = "F_SequenceNo";
    private static final String F_TRANSACTIONDATE = "F_TransactionDate";
    private static final String F_REFERENCENUMBER = "F_ReferenceNumber";
    private static final String F_DOCUMENTDATE = "F_DocumentDate";
    private static final String F_TAXCODE = "F_TaxCode";
    private static final String F_TAXCODEDESCRIPTION = "F_TaxCodeDescription";
    private static final String F_TAXPERCENT = "F_TaxPercent";
    private static final String F_PAACCOUNTNO = "F_PAAccountNo";
    private static final String F_PASHORTNAME = "F_PAShortName";
    private static final String F_PACITY = "F_PACity";
    private static final String F_PATAXNUMBER = "F_PATaxNumber";
    private static final String F_TAXABLEAMOUNT = "F_TaxableAmount";
    private static final String F_TAXAMOUNT = "F_TaxAmount";
    private static final String F_DEDUCTIBLETAX = "F_DeductibleTax";
    private static final String F_NONDEDUCTIBLETAX = "F_NonDeductibleTax";
    private static final String F_FOREIGNTAXABLEAMOUNT = "F_ForeignTaxableAmount";
    private static final String F_ENTEREDAMOUNT = "F_EnteredAmount";
    private static final String F_FOREIGNDEDUCTIBLETAX = "F_ForeignDeductibleTax";
    private static final String F_FOREIGNNONDEDUCTIBLETAX = "F_ForeignNonDeductibleTax";
    private static final String F_CONVERSIONRATE = "F_ConversionRate";
    private static final String F_ENTEREDCURRENCY = "F_EnteredCurrency";
    private static final String F_ISFOREIGN = "F_IsForeign";
    private static final String F_GROSSAMOUNT = "F_GrossAmount";
    private static final String F_TAXVARIANCE = "F_TaxVariance";
    private static final String F_REGISTERCODE = "F_RegisterCode";
    private static final String F_REGISTERDESCRIPTION = "F_RegisterDescription";
    private static final String F_CURRENCY = "F_Currency";
    private static final String F_REGCODEINPUTSTRING = "F_RegCodeInputString";
    private static final String F_REGCODEOUTPUTSTRING = "F_RegCodeOutputString";
    private static final String F_TAXREGNO = "F_TaxRegNo";
    private static final String F_SHORTCITYTAX = "F_ShortCityTax";
    private static final String F_REGISTERPAGENUMBER = "F_RegisterPageNumber";
    private static final String F_TAXREGJOURNALOID = "F_TaxRegJournalOid";
    private static final String F_OIDTRANSACTION = "F_OidTransaction";
    private static final String F_OIDTAXRATE = "F_OidTaxRate";
    private static final String F_TYPEOFNUMBERING = "F_TypeOfNumbering";
    private static final String F_DOCUMENTTYPE = "F_DocumentType";
    private static final String F_PERSACCECTAXNUMBER = "F_PersAccECTaxNumber";
    private static final String S_COMPANY = "S_Company";
    private static final String S_CITY = "S_City";
    private static final String S_TAXNUMBER = "S_TaxNumber";
    private static final String S_USER = "S_User";
    private static final String S_PAGE = "S_Page";
    private static final String S_PERIODFROM = "S_PeriodFrom";
    private static final String S_PERIODUNTIL = "S_PeriodUntil";
    private static final String S_PRINTDATE = "S_PrintDate";
    private static final String S_SUM = "S_Sum";
    private static final String S_TOTAL = "S_Total";
    private static final String S_PROVISIONAL = "S_Provisional";
    private static final String S_PURCHASE = "S_Purchase";
    private static final String S_SALE = "S_Sale";
    private static final String S_CASH = "S_Cash";
    private static final String S_REGISTER = "S_Register";
    private static final String S_SINGLEREGISTER = "S_SingleRegister";
    private static final String S_SUMMARYALLREGISTERS = "S_SummaryAllRegisters";
    private static final String S_VAT = "S_VAT";
    private static final String S_FINALLY = "S_Finally";
    private static final String S_INPUTTAX = "S_InputTax";
    private static final String S_OUTPUTTAX = "S_OutputTax";
    private static final String S_ACTIVITYCODE = "S_ActivityCode";
    private static final String S_TYPEOFNUMBERING = "S_TypeOfNumbering";
    private static final String S_PERIOD = "S_Period";
    private static final String S_FISCALCODE = "S_FiscalCode";
    private static final String S_VATIDNO = "S_VATIdNo";
    private static final String S_DOCUMENTTYPE = "S_DocumentType";
    private static final String S_YEAR = "S_Year";
    private static final int COMPANY = 0;
    private static final int CITY = 1;
    private static final int TAXNUMBER = 2;
    private static final int USER = 3;
    private static final int PAGE = 4;
    private static final int PERIODFROM = 5;
    private static final int PERIODUNTIL = 6;
    private static final int PRINTDATE = 7;
    private static final int SUM = 8;
    private static final int TOTAL = 9;
    private static final int PROVISIONAL = 10;
    private static final int PURCHASE = 11;
    private static final int SALE = 12;
    private static final int CASH = 13;
    private static final int REGISTER = 14;
    private static final int SINGLEREGISTER = 15;
    private static final int SUMMARYALLREGISTERS = 16;
    private static final int VAT = 17;
    private static final int FINALLY = 18;
    private static final int INPUTTAX = 19;
    private static final int OUTPUTTAX = 20;
    private static final int ACTIVITYCODE = 21;
    private static final int TYPEOFNUMBERING = 22;
    private static final int PERIOD = 23;
    private static final int FISCALCODE = 24;
    private static final int VATIDNO = 25;
    private static final int DOCUMENTTYPEEON = 26;
    private static final int YEAR = 27;
    private static TranslateableResourceList mTaxRegisterReportList = TranslateableResourceList.createTranslateableResourceList("TaxRegisterReportList", new String[]{"Company", "City", "Tax Number", "User", "Page", "Period from", "Period until", "Print Date", "Sum", "Total", "Provisional", "Register Purchase", "Register Sale", "Register Cash", "Register", "List of single register", "Summary of all register", "VAT Itemized List", "Finally", "Input", "Output", "Codice Attivita", "Tipo numerazione", "Periodo", "Codice Fiscale", "P.Iva", "Tipo Doc.", "Anno"});
    private static final String H_SEQUENCENO = "H_SequenceNo";
    private static final String H_TRANSACTIONDATE = "H_TransactionDate";
    private static final String H_REFERENCENUMBER = "H_ReferenceNumber";
    private static final String H_DOCUMENTDATE = "H_DocumentDate";
    private static final String H_TAXCODE = "H_TaxCode";
    private static final String H_TAXCODEDESCRIPTION = "H_TaxCodeDescription";
    private static final String H_PAACCOUNTNO = "H_PAAccountNo";
    private static final String H_PASHORTNAME = "H_PAShortName";
    private static final String H_PACITY = "H_PACity";
    private static final String H_TAXABLEAMOUNT = "H_TaxableAmount";
    private static final String H_PATAXNUMBER = "H_PATaxNumber";
    private static final String H_DEDUCTIBLETAX = "H_DeductibleTax";
    private static final String H_NONDEDUCTIBLETAX = "H_NonDeductibleTax";
    private static final String H_GROSSAMOUNT = "H_GrossAmount";
    private static final String H_TOTALINPERIOD = "H_TotalInPeriod";
    private static final String H_TAXVARIANCE = "H_TaxVariance";
    private static final String H_PAYDATETAXAMOUNT = "H_PayDateTaxAmount";
    private static final String H_TAXAMOUNT = "H_TaxAmount";
    private static final String H_DIFFERITA = "H_Differita";
    private static final String H_CODE = "H_Code";
    private static final String H_TAXREGNO = "H_TaxRegNo";
    private static final String H_CURRENCY = "H_Currency";
    private static final String H_ENTEREDCURRENCY = "H_EnteredCurrency";
    private static final String H_TOTALENTEREDCURRENCY = "H_TotalEnteredCurrency";
    private static final String H_DOCUMENTTYPE = "H_DocumentType";
    private static final String H_PERSACCECTAXNUMBER = "H_PersAccECTaxNumber";
    private static final String H_TAXPERCENT = "H_TaxPercent";
    private static final int SEQUENCENO = 0;
    private static final int TRANSACTIONDATE = 1;
    private static final int REFERENCENUMBER = 2;
    private static final int DOCUMENTDATE = 3;
    private static final int TAXCODE = 4;
    private static final int TAXCODEDESCRIPTION = 5;
    private static final int PAACCOUNTNO = 6;
    private static final int PASHORTNAME = 7;
    private static final int PACITY = 8;
    private static final int TAXABLEAMOUNT = 9;
    private static final int PATAXNUMBER = 10;
    private static final int DEDUCTIBLETAX = 11;
    private static final int NONDEDUCTIBLETAX = 12;
    private static final int GROSSAMOUNT = 13;
    private static final int TOTALINPERIOD = 14;
    private static final int TAXVARIANCE = 15;
    private static final int PAYDATETAXAMOUNT = 16;
    private static final int TAXAMOUNT = 17;
    private static final int DIFFERITA = 18;
    private static final int CODE = 19;
    private static final int TAXREGNO = 20;
    private static final int CURRENCY = 21;
    private static final int ENTEREDCURRENCY = 22;
    private static final int TOTALENTEREDCURRENCY = 23;
    private static final int DOCUMENTTYPE = 24;
    private static final int PERSACCECTAXNUMBER = 25;
    private static final int TAXPERCENT = 26;
    private static TranslateableResourceList mTaxRegisterReportColumnHeaders = TranslateableResourceList.createTranslateableResourceList("TaxRegisterReportColumnHeaders", new String[]{"Sequence No", "Transaction Date", "Reference Number", "Document Date", "Tax Code", "Tax Code Description", "PA Account Number", "PA Name", "PA City", "Taxable Amount", "PA Tax Number", "Deductible Tax", "Non Deductible Tax", "Gross Amount", "Total in Period", "Tax Variance", "Pay Date Tax Amount", "Tax Amount", "Differita", "Code", "Tax Reg. No", "Valuta", "V.E", "Tot.V.E", "Tipo Doc.", "Partita Iva", "Aliq."});

    public TaxRegisterReportDataSource(Object[][] dataset, TaxRegisterReportStruct report, Language globalLanguage, TaxRegisterReportFlags taxRegisterReportFlags, boolean isReverseChargeMethod) {
        this.mDataset = dataset;
        this.mReport = report;
        this.mCompany = AccountingCompanyPersistencyManager.getAccountingCompany((String)this.mReport.oidCompany);
        this.mGlobalLanguage = globalLanguage;
        this.mTextDepLanguage = LanguageManager.getInstance().getLanguage(this.mReport.language.oidTimestamp.objectid);
        this.mCurrency = this.mCompany.getFinanceSetup().getBaseCurrency();
        this.mFormatter = this.mGlobalLanguage.hasLocale() ? new BigDecimalFormatter(this.mGlobalLanguage.getLocale()) : new BigDecimalFormatter();
        this.mFormatter.setDecimalPlaces(Integer.valueOf(2));
        this.mIsReverseChargeMethod = isReverseChargeMethod;
        if (this.mIsReverseChargeMethod) {
            this.initSubReportContainerListReverseCharge();
        } else {
            this.initSubReportContainerList();
        }
        this.makeSubreportAllRegistersContainers();
        this.mTaxRegisterReportFlags = taxRegisterReportFlags;
    }

    private void initSubReportContainerListReverseCharge() {
        int n = this.mDataset.length;
        for (int i = 0; i < n; ++i) {
            NlentryContainer entryContainer = (NlentryContainer)this.mDataset[i][0];
            NlentrytaxregContainer registerContainer = (NlentrytaxregContainer)this.mDataset[i][1];
            BigDecimal deductible = BigDecimalMapper.ZERO;
            BigDecimal nondeductible = BigDecimalMapper.ZERO;
            BigDecimal paydatetax = BigDecimalMapper.ZERO;
            BigDecimal differenceTax = BigDecimalMapper.ZERO;
            NlentryContainer nonDeductContainer = TaxRegisterReportHelper.getNonDeductibleContainer((NlentryContainer)entryContainer);
            boolean isOutput = TaxRegisterReportHelper.isOutputTaxAccount((NlentryContainer)entryContainer);
            if (nonDeductContainer != null && nonDeductContainer.isinputtaxdeduct) {
                deductible = TaxRegisterReportContainer.getAmount(this.mCurrency, entryContainer.baseamount.subtract(nonDeductContainer.baseamount), isOutput, entryContainer.debit);
                nondeductible = this.getAmount(nonDeductContainer.baseamount, isOutput, entryContainer.debit);
            } else if (!isOutput) {
                deductible = this.getAmount(entryContainer.baseamount, isOutput, entryContainer.debit);
                nondeductible = this.mCurrency.round(BigDecimal.valueOf(0L));
            }
            TaxRegisterSubreportContainer container = new TaxRegisterSubreportContainer(this.mCurrency);
            SequenceNo taxRegister = SequenceNoPersistencyManager.getSequenceNo((String)registerContainer.oidtaxregister);
            TaxCode taxCode = TaxCodePersistencyManager.getTaxCode((String)entryContainer.oidtaxcode);
            TaxRate taxRate = TaxRatePersistencyManager.getTaxRate((String)entryContainer.oidtaxrate);
            container.setIsInput(TaxRegisterReportContainer.isInputTax(entryContainer.taxaccounttype, entryContainer.debit));
            container.setTaxRegisterCode(taxRegister.getCode());
            container.setTaxRegisterDescription(taxRegister.getDescription());
            container.setDeductibleAmount(deductible);
            container.setGrossAmount(this.getAmount(entryContainer.totalamount, isOutput, entryContainer.debit));
            container.setNonDeductibleAmount(nondeductible);
            container.setOidTaxCode(taxCode.getObjectid());
            container.setOidTaxRegister(taxRegister.getObjectid());
            container.setPayDateTaxAmount(paydatetax);
            container.setTaxableAmount(this.getAmount(TaxRegisterReportContainer.getNetAmount(entryContainer), isOutput, entryContainer.debit));
            container.setTaxAmount(this.getAmount(entryContainer.baseamount, isOutput, entryContainer.debit));
            container.setTaxCode(taxCode.getCode());
            container.setTaxCodeDescription(taxRate.getDescription(this.mTextDepLanguage));
            container.setDifferenceTaxAmount(differenceTax);
            container.setTransactionType(entryContainer.transactiontype);
            container.setTaxPercent(taxRate.getRate());
            container.setBaseCurrencyCode(this.mCurrency.getCode());
            this.mSubReportContainerList.add(container);
        }
    }

    private BigDecimal getAmount(BigDecimal amount, boolean isOutput, boolean debit) {
        return TaxRegisterReportContainer.getAmount(this.mCurrency, amount, isOutput, debit);
    }

    public boolean next() throws JRException {
        boolean result = false;
        try {
            if (this.resultCounter < this.mDataset.length) {
                this.mHasNext = true;
                this.mRegisterPageNumber = null;
                this.mContainer = this.mIsReverseChargeMethod ? new TaxRegisterReportContainer((NlentryContainer)this.mDataset[this.resultCounter][0], (NlentrytaxregContainer)this.mDataset[this.resultCounter][1], this.mCurrency, this.mTextDepLanguage, this.mOneRegisterContainers) : new TaxRegisterReportContainer((NltransactionContainer)this.mDataset[this.resultCounter][0], (NlentryContainer)this.mDataset[this.resultCounter][1], this.mCurrency, this.mTextDepLanguage, this.mOneRegisterContainers);
                if (this.mContainer.getFirstPageNumber() > 0) {
                    this.mRegisterPageNumber = this.mContainer.getFirstPageNumber();
                }
                if (!this.mOidRegister.equals(this.mContainer.getOidTaxRegister())) {
                    this.makeSubreportOneRegisterContainers(this.mContainer.getOidTaxRegister());
                    this.mSubReportOneRegisterDataSource = new TaxRegisterSubReportDataSource(this.mOneRegisterContainers);
                    this.mOidRegister = this.mContainer.getOidTaxRegister();
                }
                ++this.resultCounter;
            } else {
                this.mHasNext = false;
            }
            result = this.mHasNext;
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        return result;
    }

    public boolean getHasNext() {
        return this.mHasNext;
    }

    public Object getFieldValue(JRField field) throws JRException {
        Object value = null;
        String fieldName = field.getName();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Field Name: {}", (Object)fieldName);
        }
        if (this.mContainer != null) {
            try {
                if (F_ISINPUTTAX.equals(fieldName)) {
                    value = this.mContainer.isInputTax();
                } else if (F_PAACCOUNTNO.equals(fieldName)) {
                    value = this.mContainer.getPaCode();
                } else if (F_PACITY.equals(fieldName)) {
                    value = this.mContainer.getPaCity();
                } else if (F_PASHORTNAME.equals(fieldName)) {
                    value = this.mContainer.getPaShortName();
                } else if (F_PATAXNUMBER.equals(fieldName)) {
                    value = this.mContainer.getPersonalAccountVatTaxNumber();
                } else if (F_SHORTCITYTAX.equals(fieldName)) {
                    value = this.mContainer.getShortCityTax();
                } else if (F_REFERENCENUMBER.equals(fieldName)) {
                    value = this.mContainer.getReferenceNumber();
                } else if (F_SEQUENCENO.equals(fieldName)) {
                    value = this.mContainer.getSequenceNumber();
                } else if (F_TAXREGNO.equals(fieldName)) {
                    value = this.mContainer.getTaxRegNo();
                } else if (F_TRANSACTIONDATE.equals(fieldName)) {
                    value = DateMapper.toString((ILanguage)this.mGlobalLanguage, (Date)this.mContainer.getTransactionDate());
                } else if (F_REGISTERCODE.equals(fieldName)) {
                    value = this.mContainer.getRegisterCode();
                } else if (F_REGISTERDESCRIPTION.equals(fieldName)) {
                    value = this.mContainer.getRegisterDescription();
                } else if (F_OIDTAXREGISTER.equals(fieldName)) {
                    value = this.mContainer.getOidTaxRegister();
                } else if (F_OIDENTRY.equals(fieldName)) {
                    value = this.mContainer.getOidEntry();
                } else if (F_CURRENCY.equals(fieldName)) {
                    value = this.mContainer.getBaseCurrencyCode();
                } else if (F_GROSSAMOUNT.equals(fieldName)) {
                    value = this.mContainer.getGrossAmount();
                } else if (F_SUBREPORTONEREGISTER.equals(fieldName)) {
                    value = this.mSubReportOneRegisterDataSource;
                } else if (F_REGISTERPAGENUMBER.equals(fieldName)) {
                    value = this.mRegisterPageNumber;
                } else if (F_TAXREGJOURNALOID.equals(fieldName)) {
                    value = this.mContainer.getOidTaxRegisterJournal();
                } else if (F_TYPEOFNUMBERING.equals(fieldName)) {
                    value = this.mContainer.getRegisterDescription();
                } else if (F_DOCUMENTTYPE.equals(fieldName)) {
                    value = this.mContainer.getDocumentType();
                } else if (F_PERSACCECTAXNUMBER.equals(fieldName)) {
                    value = this.mContainer.getPersonalAccountEcTaxNumber();
                } else if (F_OIDTRANSACTION.equals(fieldName)) {
                    value = this.mContainer.getOidTransaction();
                } else if (F_OIDTAXRATE.equals(fieldName)) {
                    value = this.mContainer.isSplitPaymentTaxAccount() ? "SplitPayment" : this.mContainer.getOidTaxRate();
                }
                if (value instanceof String) {
                    value = StringUtil.toJasperString((String)((String)value));
                }
            }
            catch (Exception e) {
                ExceptionMapper.printException((Throwable)e);
            }
            if (this.mContainer != null) {
                try {
                    if (F_DOCUMENTDATE.equals(fieldName)) {
                        value = DateMapper.toString((ILanguage)this.mGlobalLanguage, (Date)this.mContainer.getDocumentDate());
                    } else if (F_DEDUCTIBLETAX.equals(fieldName)) {
                        value = this.mContainer.getDeductibleTax();
                    } else if (F_NONDEDUCTIBLETAX.equals(fieldName)) {
                        value = this.mContainer.getNonDeductibleTax();
                    } else if (F_TAXABLEAMOUNT.equals(fieldName)) {
                        value = this.mContainer.getNetAmount();
                    } else if (F_TAXCODE.equals(fieldName)) {
                        value = this.mContainer.getTaxCode();
                    } else if (F_TAXCODEDESCRIPTION.equals(fieldName)) {
                        value = this.mContainer.getTaxCodeDescription();
                    } else if (F_TAXPERCENT.equals(fieldName)) {
                        value = this.mContainer.getTaxPercent();
                    } else if (F_TAXVARIANCE.equals(fieldName)) {
                        value = this.mContainer.getTaxVariance();
                    } else if (F_TAXAMOUNT.equals(fieldName)) {
                        value = this.mContainer.getTaxAmount();
                    } else if (F_FOREIGNTAXABLEAMOUNT.equals(fieldName)) {
                        value = this.mContainer.getNetAmountFC();
                    } else if (F_ENTEREDAMOUNT.equals(fieldName)) {
                        value = this.mContainer.getTaxAmountFC();
                    } else if (F_FOREIGNDEDUCTIBLETAX.equals(fieldName)) {
                        value = this.mContainer.getDeductibleTaxFC();
                    } else if (F_FOREIGNNONDEDUCTIBLETAX.equals(fieldName)) {
                        value = this.mContainer.getNonDeductibleTaxFC();
                    } else if (F_CONVERSIONRATE.equals(fieldName)) {
                        value = this.mContainer.getConversionRate();
                    } else if (F_ENTEREDCURRENCY.equals(fieldName)) {
                        value = this.mContainer.getEnteredCurrencyCode();
                    } else if (F_ISFOREIGN.equals(fieldName)) {
                        value = this.mContainer.isForeign();
                    }
                    if (value instanceof String) {
                        value = StringUtil.toJasperString((String)((String)value));
                    }
                }
                catch (Exception e) {
                    ExceptionMapper.printException((Throwable)e);
                }
            }
            if (this.mAllRegistersContainers != null && this.mAllRegistersContainers.length > 0) {
                try {
                    if (F_SUBREPORTALLREGISTERS.equals(fieldName)) {
                        value = this.mSubReportAllRegistersDataSource;
                    } else if (F_REGCODEINPUTSTRING.equals(fieldName)) {
                        value = this.mRegisterCodesForSummaryLineInput;
                    } else if (F_REGCODEOUTPUTSTRING.equals(fieldName)) {
                        value = this.mRegisterCodesForSummaryLineOutput;
                    }
                }
                catch (Exception e) {
                    ExceptionMapper.printException((Throwable)e);
                }
            }
        }
        return value;
    }

    public Map<String, Object> getParameters() throws BusinessDomainException {
        JasperParameterHashMap parameters = new JasperParameterHashMap();
        parameters.put(S_CASH, mTaxRegisterReportList.getString((ILanguage)this.mGlobalLanguage, 13));
        parameters.put(S_CITY, mTaxRegisterReportList.getString((ILanguage)this.mGlobalLanguage, 1));
        parameters.put(S_COMPANY, mTaxRegisterReportList.getString((ILanguage)this.mGlobalLanguage, 0));
        parameters.put(S_PAGE, mTaxRegisterReportList.getString((ILanguage)this.mGlobalLanguage, 4));
        parameters.put(S_PERIODFROM, mTaxRegisterReportList.getString((ILanguage)this.mGlobalLanguage, 5));
        parameters.put(S_PERIODUNTIL, mTaxRegisterReportList.getString((ILanguage)this.mGlobalLanguage, 6));
        parameters.put(S_PRINTDATE, mTaxRegisterReportList.getString((ILanguage)this.mGlobalLanguage, 7));
        parameters.put(S_PROVISIONAL, mTaxRegisterReportList.getString((ILanguage)this.mGlobalLanguage, 10));
        parameters.put(S_PURCHASE, mTaxRegisterReportList.getString((ILanguage)this.mGlobalLanguage, 11));
        parameters.put(S_SALE, mTaxRegisterReportList.getString((ILanguage)this.mGlobalLanguage, 12));
        parameters.put(S_SUM, mTaxRegisterReportList.getString((ILanguage)this.mGlobalLanguage, 8));
        parameters.put(S_TAXNUMBER, mTaxRegisterReportList.getString((ILanguage)this.mGlobalLanguage, 2));
        parameters.put(S_TOTAL, mTaxRegisterReportList.getString((ILanguage)this.mGlobalLanguage, 9));
        parameters.put(S_USER, mTaxRegisterReportList.getString((ILanguage)this.mGlobalLanguage, 3));
        parameters.put(S_REGISTER, mTaxRegisterReportList.getString((ILanguage)this.mGlobalLanguage, 14));
        parameters.put(S_SINGLEREGISTER, mTaxRegisterReportList.getString((ILanguage)this.mGlobalLanguage, 15));
        parameters.put(S_SUMMARYALLREGISTERS, mTaxRegisterReportList.getString((ILanguage)this.mGlobalLanguage, 16));
        parameters.put(S_VAT, mTaxRegisterReportList.getString((ILanguage)this.mGlobalLanguage, 17));
        parameters.put(S_FINALLY, mTaxRegisterReportList.getString((ILanguage)this.mGlobalLanguage, 18));
        parameters.put(S_INPUTTAX, mTaxRegisterReportList.getString((ILanguage)this.mGlobalLanguage, 19));
        parameters.put(S_OUTPUTTAX, mTaxRegisterReportList.getString((ILanguage)this.mGlobalLanguage, 20));
        parameters.put(S_ACTIVITYCODE, mTaxRegisterReportList.getString((ILanguage)this.mGlobalLanguage, 21));
        parameters.put(S_TYPEOFNUMBERING, mTaxRegisterReportList.getString((ILanguage)this.mGlobalLanguage, 22));
        parameters.put(S_PERIOD, mTaxRegisterReportList.getString((ILanguage)this.mGlobalLanguage, 23));
        parameters.put(S_FISCALCODE, mTaxRegisterReportList.getString((ILanguage)this.mGlobalLanguage, 24));
        parameters.put(S_VATIDNO, mTaxRegisterReportList.getString((ILanguage)this.mGlobalLanguage, 25));
        parameters.put(S_DOCUMENTTYPE, mTaxRegisterReportList.getString((ILanguage)this.mGlobalLanguage, 26));
        parameters.put(S_YEAR, mTaxRegisterReportList.getString((ILanguage)this.mGlobalLanguage, 27));
        parameters.put(H_DEDUCTIBLETAX, mTaxRegisterReportColumnHeaders.getString((ILanguage)this.mGlobalLanguage, 11));
        parameters.put(H_DOCUMENTDATE, mTaxRegisterReportColumnHeaders.getString((ILanguage)this.mGlobalLanguage, 3));
        parameters.put(H_GROSSAMOUNT, mTaxRegisterReportColumnHeaders.getString((ILanguage)this.mGlobalLanguage, 13));
        parameters.put(H_NONDEDUCTIBLETAX, mTaxRegisterReportColumnHeaders.getString((ILanguage)this.mGlobalLanguage, 12));
        parameters.put(H_PAACCOUNTNO, mTaxRegisterReportColumnHeaders.getString((ILanguage)this.mGlobalLanguage, 6));
        parameters.put(H_PACITY, mTaxRegisterReportColumnHeaders.getString((ILanguage)this.mGlobalLanguage, 8));
        parameters.put(H_PASHORTNAME, mTaxRegisterReportColumnHeaders.getString((ILanguage)this.mGlobalLanguage, 7));
        parameters.put(H_PATAXNUMBER, mTaxRegisterReportColumnHeaders.getString((ILanguage)this.mGlobalLanguage, 10));
        parameters.put(H_PAYDATETAXAMOUNT, mTaxRegisterReportColumnHeaders.getString((ILanguage)this.mGlobalLanguage, 16));
        parameters.put(H_REFERENCENUMBER, mTaxRegisterReportColumnHeaders.getString((ILanguage)this.mGlobalLanguage, 2));
        parameters.put(H_SEQUENCENO, mTaxRegisterReportColumnHeaders.getString((ILanguage)this.mGlobalLanguage, 0));
        parameters.put(H_TAXABLEAMOUNT, mTaxRegisterReportColumnHeaders.getString((ILanguage)this.mGlobalLanguage, 9));
        parameters.put(H_TAXCODE, mTaxRegisterReportColumnHeaders.getString((ILanguage)this.mGlobalLanguage, 4));
        parameters.put(H_TAXCODEDESCRIPTION, mTaxRegisterReportColumnHeaders.getString((ILanguage)this.mGlobalLanguage, 5));
        parameters.put(H_TAXVARIANCE, mTaxRegisterReportColumnHeaders.getString((ILanguage)this.mGlobalLanguage, 15));
        parameters.put(H_TOTALINPERIOD, mTaxRegisterReportColumnHeaders.getString((ILanguage)this.mGlobalLanguage, 14));
        parameters.put(H_TRANSACTIONDATE, mTaxRegisterReportColumnHeaders.getString((ILanguage)this.mGlobalLanguage, 1));
        parameters.put(H_TAXAMOUNT, mTaxRegisterReportColumnHeaders.getString((ILanguage)this.mGlobalLanguage, 17));
        parameters.put(H_DIFFERITA, mTaxRegisterReportColumnHeaders.getString((ILanguage)this.mGlobalLanguage, 18));
        parameters.put(H_CODE, mTaxRegisterReportColumnHeaders.getString((ILanguage)this.mGlobalLanguage, 19));
        parameters.put(H_TAXREGNO, mTaxRegisterReportColumnHeaders.getString((ILanguage)this.mGlobalLanguage, 20));
        parameters.put(H_CURRENCY, mTaxRegisterReportColumnHeaders.getString((ILanguage)this.mGlobalLanguage, 21));
        parameters.put(H_ENTEREDCURRENCY, mTaxRegisterReportColumnHeaders.getString((ILanguage)this.mGlobalLanguage, 22));
        parameters.put(H_TOTALENTEREDCURRENCY, mTaxRegisterReportColumnHeaders.getString((ILanguage)this.mGlobalLanguage, 23));
        parameters.put(H_DOCUMENTTYPE, mTaxRegisterReportColumnHeaders.getString((ILanguage)this.mGlobalLanguage, 24));
        parameters.put(H_PERSACCECTAXNUMBER, mTaxRegisterReportColumnHeaders.getString((ILanguage)this.mGlobalLanguage, 25));
        parameters.put(H_TAXPERCENT, mTaxRegisterReportColumnHeaders.getString((ILanguage)this.mGlobalLanguage, 26));
        parameters.put(P_FORMATTER, this.mFormatter);
        PostalAddress postalAddress = this.mCompany.getCurrentAddress().getPostalAddress();
        parameters.put(P_COMPANYADDRESS, postalAddress.getName1() + "\n" + postalAddress.getStreet() + " " + postalAddress.getPostalCode() + " " + postalAddress.getTown());
        parameters.put(P_ISPROVISIONAL, this.mReport.taxRegisterShort.isProvisional);
        parameters.put(P_PERIODFROM, DateMapper.toString((ILanguage)this.mGlobalLanguage, (Date)DateMapper.toDate((String)this.mReport.period.validFrom)));
        parameters.put(P_PERIODUNTIL, DateMapper.toString((ILanguage)this.mGlobalLanguage, (Date)DateMapper.toDate((String)this.mReport.period.validUntil)));
        parameters.put(P_PRINTDATE, DateMapper.toString((ILanguage)this.mGlobalLanguage, (Date)DateHelper.today()));
        parameters.put(P_TAXNUMBER, this.mCompany.getCompanyNumber());
        parameters.put(P_USER, SessionContext.getInstance().getSession().getUserCode());
        parameters.put(P_ISSINGLEROW, this.mReport.singleRow);
        CharSequence cs = this.mReport.period.validFrom.subSequence(0, 4);
        parameters.put(P_FINANCIALYEAR, cs.toString());
        parameters.put(P_TAX_REGISTER_REPORT_FLAGS, this.mTaxRegisterReportFlags);
        parameters.put(P_TIME, VDate.getCurrentLocalizedTime());
        parameters.put(P_RELEASE, Version.getVersion());
        parameters.put(P_VATIDNO, this.mCompany.getECTaxNumber(true));
        parameters.put(P_ACTIVITYCODE, this.mCompany.getBranchOfActivity());
        return parameters;
    }

    private void initSubReportContainerList() {
        int n = this.mDataset.length;
        for (int i = 0; i < n; ++i) {
            NltransactionContainer nlcont = (NltransactionContainer)this.mDataset[i][0];
            NlentryContainer tecont = (NlentryContainer)this.mDataset[i][1];
            BigDecimal deductible = BigDecimalMapper.ZERO;
            BigDecimal nondeductible = BigDecimalMapper.ZERO;
            BigDecimal paydatetax = BigDecimalMapper.ZERO;
            BigDecimal differenceTax = BigDecimalMapper.ZERO;
            NlentryContainer nonDeductContainer = TaxRegisterReportHelper.getNonDeductibleContainer((NlentryContainer)tecont);
            boolean isOutput = TaxRegisterReportHelper.isOutputTaxAccount((NlentryContainer)tecont);
            if (nonDeductContainer != null && nonDeductContainer.isinputtaxdeduct) {
                deductible = this.getAmount(tecont.baseamount.subtract(nonDeductContainer.baseamount), isOutput, tecont.debit);
                nondeductible = this.getAmount(nonDeductContainer.baseamount, isOutput, tecont.debit);
            } else if (tecont.isinputtax) {
                deductible = this.getAmount(tecont.baseamount, isOutput, tecont.debit);
                nondeductible = this.mCurrency.round(BigDecimal.valueOf(0L));
            }
            NominalTransactionBase ntb = TaxRegisterReportHelper.getNominalTransactionBase((String)nlcont.getObjectid());
            TaxRegisterSubreportContainer container = new TaxRegisterSubreportContainer(this.mCurrency);
            TaxCode taxCode = TaxCodePersistencyManager.getTaxCode((String)tecont.oidtaxcode);
            TaxRate taxRate = TaxRatePersistencyManager.getTaxRate((String)tecont.oidtaxrate);
            container.setIsInput(ntb.getIsInputTax());
            container.setTaxRegisterCode(ntb.getTaxRegister().getCode());
            container.setTaxRegisterDescription(ntb.getTaxRegister().getDescription());
            container.setDeductibleAmount(deductible);
            container.setGrossAmount(this.getAmount(ntb.getTotal(), isOutput, tecont.debit));
            container.setNonDeductibleAmount(nondeductible);
            container.setOidTaxCode(taxCode.getObjectid());
            container.setOidTaxRegister(ntb.getTaxRegister().getObjectid());
            container.setPayDateTaxAmount(paydatetax);
            container.setTaxableAmount(this.getAmount(TaxRegisterReportContainer.getNetAmount(tecont), isOutput, tecont.debit));
            container.setTaxAmount(this.getAmount(tecont.baseamount, isOutput, tecont.debit));
            container.setTaxCode(taxCode.getCode());
            container.setTaxCodeDescription(taxRate.getDescription(this.mTextDepLanguage));
            container.setDifferenceTaxAmount(differenceTax);
            container.setTransactionType(ntb.getTransactionType().persistentValue());
            container.setTaxPercent(taxRate.getRate());
            container.setBaseCurrencyCode(this.mCurrency.getCode());
            this.mSubReportContainerList.add(container);
        }
    }

    private List<TaxRegisterSubreportContainer> makeRegisterSums(List<TaxRegisterSubreportContainer> al) {
        ArrayList<TaxRegisterSubreportContainer> containerList = new ArrayList<TaxRegisterSubreportContainer>();
        ArrayList<TaxRegisterSubreportContainer> tempContainerList = new ArrayList<TaxRegisterSubreportContainer>();
        String oidtaxregister = "";
        boolean groupChanged = false;
        int n = al.size();
        for (int i = 0; i < n; ++i) {
            TaxRegisterSubreportContainer sub = al.get(i);
            if (i == 0) {
                oidtaxregister = sub.getOidTaxRegister();
            }
            if (sub.getOidTaxRegister().equals(oidtaxregister)) {
                tempContainerList.add(sub);
                groupChanged = false;
                continue;
            }
            containerList.addAll(this.makeTaxCodeSums(tempContainerList));
            tempContainerList.clear();
            groupChanged = true;
            oidtaxregister = sub.getOidTaxRegister();
            --i;
        }
        if (!groupChanged && !tempContainerList.isEmpty()) {
            containerList.addAll(this.makeTaxCodeSums(tempContainerList));
        }
        return containerList;
    }

    private List<TaxRegisterSubreportContainer> makeTaxCodeSums(List<TaxRegisterSubreportContainer> temp) {
        ArrayList<TaxRegisterSubreportContainer> containerList = new ArrayList<TaxRegisterSubreportContainer>();
        String oidTaxCode = "";
        TaxRegisterSubreportContainer container = null;
        boolean isInput = true;
        int n = temp.size();
        for (int j = 0; j < n; ++j) {
            TaxRegisterSubreportContainer element = temp.get(j);
            if (element.getIsInput() != isInput) {
                oidTaxCode = "";
                isInput = element.getIsInput();
            }
            if (!element.getOidTaxCode().equals(oidTaxCode)) {
                if (container != null) {
                    containerList.add(container);
                }
                container = new TaxRegisterSubreportContainer(this.mCurrency);
                oidTaxCode = element.getOidTaxCode();
                container.setIsInput(element.getIsInput());
                container.setOidTaxCode(oidTaxCode);
                container.setOidTaxRegister(element.getOidTaxRegister());
                container.setTaxCode(element.getTaxCode());
                container.setTaxCodeDescription(element.getTaxCodeDescription());
                container.setTaxRegisterCode(element.getTaxRegisterCode());
                container.setTaxRegisterDescription(element.getTaxRegisterDescription());
                container.setTransactionType(element.getTransactionType());
                container.setTaxPercent(element.getTaxPercent());
                container.setBaseCurrencyCode(element.getBaseCurrencyCode());
                container.addDeductibleAmount(element.getDeductibleAmount());
                container.addDifferenceTaxAmount(element.getDifferenceTaxAmount());
                container.addGrossAmount(element.getGrossAmount());
                container.addNonDeductibleAmount(element.getNonDeductibleAmount());
                container.addPayDateTaxAmount(element.getPayDateTaxAmount());
                container.addTaxableAmount(element.getTaxableAmount());
                container.addTaxAmount(element.getTaxAmount());
                continue;
            }
            container.addDeductibleAmount(element.getDeductibleAmount());
            container.addDifferenceTaxAmount(element.getDifferenceTaxAmount());
            container.addGrossAmount(element.getGrossAmount());
            container.addNonDeductibleAmount(element.getNonDeductibleAmount());
            container.addPayDateTaxAmount(element.getPayDateTaxAmount());
            container.addTaxableAmount(element.getTaxableAmount());
            container.addTaxAmount(element.getTaxAmount());
        }
        if (container != null) {
            containerList.add(container);
        }
        return containerList;
    }

    private void makeSubreportOneRegisterContainers(String oidtaxregister) {
        TaxRegisterSubreportContainer[] ds = TaxRegisterSubreportContainer.getSubReportAmountsAsSortedArray(this.mSubReportContainerList, (boolean)true);
        ArrayList<TaxRegisterSubreportContainer> container = new ArrayList<TaxRegisterSubreportContainer>();
        ArrayList<TaxRegisterSubreportContainer> temp = new ArrayList<TaxRegisterSubreportContainer>();
        for (TaxRegisterSubreportContainer sub : ds) {
            if (!sub.getOidTaxRegister().equals(oidtaxregister)) continue;
            temp.add(sub);
        }
        container.addAll(this.makeTaxCodeSums(temp));
        this.mOneRegisterContainers = new TaxRegisterSubreportContainer[container.size()];
        this.mOneRegisterContainers = container.toArray(this.mOneRegisterContainers);
    }

    private void makeSubreportAllRegistersContainers() {
        this.mAllRegistersContainers = TaxRegisterSubreportContainer.getSubReportAmountsAsSortedArray(this.mSubReportContainerList, (boolean)false);
        ArrayList<TaxRegisterSubreportContainer> containerList = new ArrayList<TaxRegisterSubreportContainer>();
        boolean isinput = true;
        int counter = 0;
        ArrayList<TaxRegisterSubreportContainer> temp = new ArrayList<TaxRegisterSubreportContainer>();
        while (isinput && counter < this.mAllRegistersContainers.length) {
            if (this.mAllRegistersContainers[counter].getIsInput()) {
                temp.add(this.mAllRegistersContainers[counter]);
                isinput = true;
                ++counter;
                continue;
            }
            isinput = false;
        }
        containerList.addAll(this.makeRegisterSums(temp));
        isinput = false;
        temp.clear();
        while (!isinput && counter < this.mAllRegistersContainers.length) {
            if (!this.mAllRegistersContainers[counter].getIsInput()) {
                temp.add(this.mAllRegistersContainers[counter]);
                isinput = false;
                ++counter;
                continue;
            }
            isinput = true;
        }
        containerList.addAll(this.makeRegisterSums(temp));
        this.mAllRegistersContainers = new TaxRegisterSubreportContainer[containerList.size()];
        this.mAllRegistersContainers = containerList.toArray(this.mAllRegistersContainers);
        this.makeRegisterCodeStrings();
        this.mSubReportAllRegistersDataSource = new TaxRegisterSubReportDataSource(this.mAllRegistersContainers, (int)this.mReport.firstPageNumberSummary);
    }

    private void makeRegisterCodeStrings() {
        ArrayList<String> regCodesInput = new ArrayList<String>();
        ArrayList<String> regCodesOutput = new ArrayList<String>();
        this.mRegisterCodesForSummaryLineInput = "";
        this.mRegisterCodesForSummaryLineOutput = "";
        int n = this.mAllRegistersContainers.length;
        for (int i = 0; i < n; ++i) {
            if (this.mAllRegistersContainers[i].getIsInput()) {
                regCodesInput.add(this.mAllRegistersContainers[i].getTaxRegisterCode());
                continue;
            }
            regCodesOutput.add(this.mAllRegistersContainers[i].getTaxRegisterCode());
        }
        if (regCodesInput.isEmpty()) {
            this.mRegisterCodesForSummaryLineInput = "";
        } else if (regCodesInput.size() == 1) {
            this.mRegisterCodesForSummaryLineInput = (String)regCodesInput.get(0);
        } else if (regCodesInput.size() > 1) {
            this.mRegisterCodesForSummaryLineInput = (String)regCodesInput.get(0) + " - ";
            this.mRegisterCodesForSummaryLineInput = this.mRegisterCodesForSummaryLineInput + (String)regCodesInput.get(regCodesInput.size() - 1);
        }
        if (regCodesOutput.isEmpty()) {
            this.mRegisterCodesForSummaryLineOutput = "";
        } else if (regCodesOutput.size() == 1) {
            this.mRegisterCodesForSummaryLineOutput = (String)regCodesOutput.get(0);
        } else if (regCodesOutput.size() > 1) {
            this.mRegisterCodesForSummaryLineOutput = (String)regCodesOutput.get(0) + " - ";
            this.mRegisterCodesForSummaryLineOutput = this.mRegisterCodesForSummaryLineOutput + (String)regCodesOutput.get(regCodesOutput.size() - 1);
        }
    }
}

