/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.domain.taxregisterreport.report.containers;

import com.varial.accounting.domain.custsupaddress.CustSupAddress;
import com.varial.accounting.domain.documenttype.DocumentType;
import com.varial.accounting.domain.nominalledger.TaxAccountTypeEnum;
import com.varial.accounting.domain.nominalledger.TaxAccountTypeMapper;
import com.varial.accounting.domain.nominaltransactionbase.EntryTypeEnum;
import com.varial.accounting.domain.nominaltransactionbase.EntryTypeMapper;
import com.varial.accounting.domain.nominaltransactionbase.NominalLedgerEntry;
import com.varial.accounting.domain.nominaltransactionbase.NominalLedgerEntryPersistencyManager;
import com.varial.accounting.domain.nominaltransactionbase.NominalTransactionBase;
import com.varial.accounting.domain.nominaltransactionbase.PersonalAccountEntry;
import com.varial.accounting.domain.openitem.DeliveryAddress;
import com.varial.accounting.domain.sequenceno.SequenceNo;
import com.varial.accounting.domain.sequenceno.SequenceNoPersistencyManager;
import com.varial.accounting.domain.taxcode.TaxCodePersistencyManager;
import com.varial.accounting.domain.taxcode.TaxRate;
import com.varial.accounting.domain.taxcode.TaxRatePersistencyManager;
import com.varial.accounting.domain.taxregisterreport.TaxRegisterJournal;
import com.varial.accounting.domain.taxregisterreport.TaxRegisterJournalPersistencyManager;
import com.varial.accounting.domain.taxregisterreport.TaxRegisterReportHelper;
import com.varial.accounting.domain.taxregisterreport.report.containers.TaxRegisterSubreportContainer;
import com.varial.accounting.domain.vatreturn.VATReturnHelper;
import com.varial.accounting.persistency.nlentry.NlentryContainer;
import com.varial.accounting.persistency.nlentrytaxreg.NlentrytaxregContainer;
import com.varial.accounting.persistency.nltransaction.NltransactionContainer;
import com.varial.base.persistency.criterion.Conjunction;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.framework.basictypes.addresses.IPostalAddress;
import com.varial.framework.domain.currency.CurrencyPersistencyManager;
import com.varial.framework.domain.isoftware.ISoftware;
import com.varial.interfaces.ICurrency;
import com.varial.serverbase.domain.language.Language;
import com.varial.serverbase.mapper.BooleanMapper;
import com.varial.serverbase.mapper.StringMapper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;

public class TaxRegisterReportContainer {
    private String oidTransaction;
    private String oidEntry;
    private String oidTaxRate;
    private String oidTaxRegister;
    private String oidTaxRegisterJournal;
    private String oidTransactionSequence;
    private String registerCode;
    private String registerDescription;
    private TaxRegisterSubreportContainer[] oneRegisterDataSet;
    private boolean isInputTax;
    private String paCode;
    private String paCity;
    private String paShortName;
    private String personalAccountVatTaxNumber;
    private String personalAccountEcTaxNumber;
    private String shortCityTax;
    private String referenceNumber;
    private String sequenceNumber;
    private Date transactionDate;
    private Date documentDate;
    private String taxRegNo;
    private String baseCurrencyCode;
    private String enteredCurrencyCode;
    private String documentType;
    private BigDecimal conversionRate;
    private boolean isForeign;
    private String transactionNote;
    private BigDecimal transactionAmount;
    private BigDecimal transactionAmountFC;
    private String taxCode;
    private String taxCodeDescription;
    private BigDecimal taxPercent;
    private BigDecimal grossAmount;
    private BigDecimal netAmount;
    private BigDecimal taxAmount;
    private BigDecimal deductibleTax;
    private BigDecimal nonDeductibleTax;
    private BigDecimal taxVariance;
    private BigDecimal grossAmountFC;
    private BigDecimal netAmountFC;
    private BigDecimal taxAmountFC;
    private BigDecimal deductibleTaxFC;
    private BigDecimal nonDeductibleTaxFC;
    private int firstPageNumber;
    private final boolean splitPaymentTaxAccount;

    public TaxRegisterReportContainer(NlentryContainer entryContainer, NlentrytaxregContainer registerContainer, ICurrency currency, Language textDepLanguage, TaxRegisterSubreportContainer[] oneRegisterDataset) {
        NominalTransactionBase ntBase = TaxRegisterReportHelper.getNominalTransactionBase((String)registerContainer.oidtransaction);
        SequenceNo taxRegister = SequenceNoPersistencyManager.getSequenceNo((String)registerContainer.oidtaxregister);
        boolean inputTax = TaxRegisterReportContainer.isInputTax(entryContainer.taxaccounttype, entryContainer.debit);
        DocumentType docType = ntBase.getDocumentType();
        boolean foreignCurrency = !entryContainer.oidenteredcurrency.equals(currency.getObjectid());
        boolean debit = entryContainer.debit;
        NlentryContainer nonDeductContainer = TaxRegisterReportHelper.getNonDeductibleContainer((NlentryContainer)entryContainer);
        this.setOidTransactionSequence("");
        if (ntBase.getSequenceNo() != null) {
            this.setOidTransactionSequence(ntBase.getSequenceNo().getObjectid());
        }
        this.setBaseData(currency, oneRegisterDataset, registerContainer.oidtransaction, registerContainer.getObjectid());
        this.setPersonalAccountData(ntBase);
        this.setTaxRegisterData(taxRegister);
        this.setTaxRegisterJournalData(registerContainer.oidtaxregjournal);
        this.setTaxCodeAndRateData(entryContainer.oidtaxcode, entryContainer.oidtaxrate, entryContainer.conversionrate, textDepLanguage);
        this.setTransactionData(textDepLanguage, entryContainer.referencenumber, entryContainer.sequencenumber, entryContainer.transactiondate, entryContainer.documentdate, docType, registerContainer.taxregisternumber, entryContainer.oidenteredcurrency, inputTax, foreignCurrency);
        this.setTransactionNote(ntBase.getNote());
        this.setTransactionAmounts(entryContainer.totalamount, TaxRegisterReportContainer.getNetAmount(entryContainer), entryContainer.baseamount, entryContainer.taxvariance, entryContainer.enteredamount, entryContainer.oidtaxrate, entryContainer, debit, currency, ntBase, nonDeductContainer);
        this.splitPaymentTaxAccount = TaxRegisterReportContainer.isSplitPaymentTaxAccount(entryContainer);
    }

    private void setTransactionAmounts(BigDecimal grossAmount, BigDecimal netAmount, BigDecimal baseAmount, BigDecimal varianceAmount, BigDecimal enteredAmount, String oidTaxrate, NlentryContainer entryContainer, boolean isDebit, ICurrency currency, NominalTransactionBase ntBase, NlentryContainer nonDeductContainer) {
        Conjunction crit = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidtransaction", (String)ntBase.getObjectid()), Restrictions.eq((String)"oidtaxcode", (String)entryContainer.oidtaxcode), Restrictions.eq((String)"debit", (String)BooleanMapper.toString((boolean)entryContainer.debit)), Restrictions.eq((String)"entrytype", (String)EntryTypeMapper.toString((EntryTypeEnum)EntryTypeEnum.ETE_NOMINALLEDGERENTRY))});
        NominalLedgerEntry[] nlEntries = NominalLedgerEntryPersistencyManager.getCorrespEntriesForTaxEntry(ntBase, (Criterion)crit);
        this.setTransactionAmount(ntBase.getBaseTotal());
        this.setTransactionAmountFC(ntBase.getTotal());
        this.setGrossAmount(TaxRegisterReportContainer.getAmount(currency, grossAmount, !this.isInputTax, isDebit));
        this.setTaxVariance(TaxRegisterReportContainer.getAmount(currency, varianceAmount, !this.isInputTax, isDebit));
        BigDecimal deductTax = BigDecimal.ZERO;
        BigDecimal nonDeductTax = BigDecimal.ZERO;
        BigDecimal deductTaxFC = BigDecimal.ZERO;
        BigDecimal nonDeductTaxFC = BigDecimal.ZERO;
        BigDecimal netFC = TaxRegisterReportHelper.getNotDeductibleNetAmountFC((NominalLedgerEntry[])nlEntries, (String)oidTaxrate);
        if (netFC == null) {
            netFC = netAmount.divide(this.getConversionRate(), 9, RoundingMode.HALF_DOWN);
        }
        if (nonDeductContainer != null && nonDeductContainer.isinputtaxdeduct) {
            deductTax = baseAmount.subtract(nonDeductContainer.baseamount);
            nonDeductTax = nonDeductContainer.baseamount;
            deductTaxFC = enteredAmount.subtract(nonDeductContainer.enteredamount);
            nonDeductTaxFC = nonDeductContainer.enteredamount;
        } else if (!TaxRegisterReportHelper.isOutputTaxAccount((NlentryContainer)entryContainer)) {
            deductTax = baseAmount;
            nonDeductTax = BigDecimal.valueOf(0L);
            deductTaxFC = enteredAmount;
            nonDeductTaxFC = BigDecimal.valueOf(0L);
        }
        this.setNetAmount(TaxRegisterReportContainer.getAmount(currency, netAmount, !this.isInputTax, isDebit));
        this.setTaxAmount(TaxRegisterReportContainer.getAmount(currency, baseAmount, !this.isInputTax, isDebit));
        this.setDeductibleTax(TaxRegisterReportContainer.getAmount(currency, deductTax, !this.isInputTax, isDebit));
        this.setNonDeductibleTax(TaxRegisterReportContainer.getAmount(currency, nonDeductTax, !this.isInputTax, isDebit));
        this.setNetAmountFC(TaxRegisterReportContainer.getAmount(currency, netFC, !this.isInputTax, isDebit));
        this.setTaxAmountFC(TaxRegisterReportContainer.getAmount(currency, enteredAmount, !this.isInputTax, isDebit));
        this.setGrossAmountFC(TaxRegisterReportContainer.getAmount(currency, netFC.add(this.taxAmountFC), !this.isInputTax, isDebit));
        this.setDeductibleTaxFC(TaxRegisterReportContainer.getAmount(currency, deductTaxFC, !this.isInputTax, isDebit));
        this.setNonDeductibleTaxFC(TaxRegisterReportContainer.getAmount(currency, nonDeductTaxFC, !this.isInputTax, isDebit));
    }

    private void setTransactionData(Language textDepLanguage, String referenceNumber, String sequenceNumber, Date transactionDate, Date documentDate, DocumentType documentType, String taxregisterNumber, String oidEnteredCurrency, boolean isInputTax, boolean isForeign) {
        this.setReferenceNumber(referenceNumber);
        this.setSequenceNumber(sequenceNumber);
        this.setTransactionDate(transactionDate);
        this.setDocumentDate(documentDate);
        if (documentType != null) {
            this.setDocumentType(documentType.getDescription(textDepLanguage));
        }
        this.setTaxRegNo(taxregisterNumber);
        this.setEnteredCurrencyCode(CurrencyPersistencyManager.getCurrency((String)oidEnteredCurrency).getCode());
        this.setIsInputTax(isInputTax);
        this.setIsForeign(isForeign);
    }

    private void setTaxCodeAndRateData(String oidTaxCode, String oidTaxRate, BigDecimal conversionRate, Language textDepLanguage) {
        this.setTaxCode(TaxCodePersistencyManager.getTaxCode((String)oidTaxCode).getCode());
        TaxRate taxRate = null;
        if (!StringMapper.isNullString((String)oidTaxRate)) {
            taxRate = TaxRatePersistencyManager.getTaxRate((String)oidTaxRate);
            this.setOidTaxRate(taxRate.getObjectid());
            this.setTaxCodeDescription(taxRate.getDescription(textDepLanguage));
            this.setTaxPercent(taxRate.getRate());
        }
        this.setConversionRate(BigDecimal.ONE);
        if (conversionRate != null) {
            this.setConversionRate(conversionRate);
        }
    }

    private void setBaseData(ICurrency currency, TaxRegisterSubreportContainer[] oneRegisterDataset, String oidTransaction, String oidEntry) {
        this.setBaseCurrencyCode(currency.getCode());
        this.setOneRegisterDataSet(oneRegisterDataset);
        this.setOidTransaction(oidTransaction);
        this.setOidEntry(oidEntry);
    }

    private void setPersonalAccountData(NominalTransactionBase ntBase) {
        String vatNumber = "";
        String ecTaxNumber = "";
        String name = "";
        String name1 = "";
        String code = "";
        String city = "";
        PersonalAccountEntry paEntry = TaxRegisterReportHelper.getPersonalAccountEntry((NominalTransactionBase)ntBase);
        if (paEntry != null) {
            CustSupAddress csa = paEntry.getCustSupAddress();
            vatNumber = csa.getVatTaxNumber();
            code = paEntry.getPersonalAccount().getCode();
            ecTaxNumber = this.getECTaxNumberWithPrefix(paEntry);
            IPostalAddress postalAddress = this.getPostalAddress(paEntry);
            name = this.getName(postalAddress);
            name1 = this.getName1(postalAddress);
            city = this.getCity(postalAddress);
        }
        this.setPaCode(code);
        this.setShortCityTax(name1 + ", " + city + ", " + vatNumber);
        if (ISoftware.isKronospan()) {
            this.setShortCityTax(name + ", " + city + ", " + vatNumber);
        }
        this.setPaCity(city);
        this.setPaShortName(name1);
        this.setPersonalAccountVatTaxNumber(vatNumber);
        this.setPersonalAccountEcTaxNumber(ecTaxNumber);
    }

    private IPostalAddress getPostalAddress(PersonalAccountEntry personalAccountEntry) {
        DeliveryAddress deliveryAddress = this.getDeliveryAddress(personalAccountEntry);
        return this.isDifferentECTaxNumberAvailable(deliveryAddress, personalAccountEntry.getCustSupAddress()) ? deliveryAddress.getPostalAddress() : personalAccountEntry.getCustSupAddress().getPostalAddress();
    }

    private boolean isDifferentECTaxNumberAvailable(DeliveryAddress deliveryAddress, CustSupAddress custSupAddress) {
        return deliveryAddress != null && !StringMapper.isNullString((String)deliveryAddress.getEcTaxNumber()) && deliveryAddress.getPostalAddress() != null && deliveryAddress.getPostalAddress().getCountry() != null && (!StringMapper.equalWithTrim((String)deliveryAddress.getEcTaxNumber(), (String)custSupAddress.getEcTaxNumber()) || !custSupAddress.getPostalAddress().getCountry().equals(deliveryAddress.getPostalAddress().getCountry()));
    }

    private String getECTaxNumberWithPrefix(PersonalAccountEntry personalAccountEntry) {
        String ecCountryCode;
        String ecTaxNumber;
        CustSupAddress custSupAddress;
        DeliveryAddress deliveryAddress = this.getDeliveryAddress(personalAccountEntry);
        if (this.isDifferentECTaxNumberAvailable(deliveryAddress, custSupAddress = personalAccountEntry.getCustSupAddress())) {
            ecTaxNumber = deliveryAddress.getEcTaxNumber();
            ecCountryCode = deliveryAddress.getPostalAddress().getCountry().getECCountryCode();
        } else {
            ecTaxNumber = custSupAddress.getEcTaxNumber();
            ecCountryCode = custSupAddress.getPostalAddress().getCountry().getECCountryCode();
        }
        return !StringMapper.isNullString((String)ecCountryCode) && !StringMapper.isNullString((String)ecTaxNumber) ? ecCountryCode.concat(StringMapper.toString((String)ecTaxNumber)) : null;
    }

    private String getCity(IPostalAddress postalAddress) {
        Object city = postalAddress.getCountry().getCode();
        city = (String)city + "-" + StringMapper.toString((String)postalAddress.getPostalCode());
        city = (String)city + " " + StringMapper.toString((String)postalAddress.getTown());
        return city;
    }

    private String getName(IPostalAddress postalAddress) {
        return postalAddress.getName();
    }

    private String getName1(IPostalAddress postalAddress) {
        return postalAddress.getName1();
    }

    private DeliveryAddress getDeliveryAddress(PersonalAccountEntry personalAccountEntry) {
        return personalAccountEntry.getOpenItems().length > 0 ? personalAccountEntry.getOpenItems()[0].getDeliveryAddress() : null;
    }

    public TaxRegisterReportContainer(NltransactionContainer container, NlentryContainer entryContainer, ICurrency currency, Language textDepLanguage, TaxRegisterSubreportContainer[] oneRegisterDataset) {
        NominalTransactionBase ntBase = TaxRegisterReportHelper.getNominalTransactionBase((String)container.getObjectid());
        SequenceNo taxRegister = ntBase.getTaxRegister();
        DocumentType docType = ntBase.getDocumentType();
        boolean foreign = !entryContainer.oidenteredcurrency.equals(currency.getObjectid());
        boolean debit = entryContainer.debit;
        NlentryContainer nonDeductContainer = TaxRegisterReportHelper.getNonDeductibleContainer((NlentryContainer)entryContainer);
        this.setOidTransactionSequence("");
        if (ntBase.getSequenceNo() != null) {
            this.setOidTransactionSequence(ntBase.getSequenceNo().getObjectid());
        }
        this.setBaseData(currency, oneRegisterDataset, container.getObjectid(), container.getObjectid());
        this.setPersonalAccountData(ntBase);
        this.setTaxRegisterData(taxRegister);
        this.setTaxRegisterJournalData(container.oidtaxregjournal);
        this.setTaxCodeAndRateData(entryContainer.oidtaxcode, entryContainer.oidtaxrate, entryContainer.conversionrate, textDepLanguage);
        this.setTransactionData(textDepLanguage, container.referencenumber, container.sequencenumber, container.transactiondate, entryContainer.documentdate, docType, container.taxregisternumber, container.oidenteredcurrency, container.isinputtax, foreign);
        this.setTransactionNote(ntBase.getNote());
        this.setTransactionAmounts(ntBase.getTotal(), TaxRegisterReportContainer.getNetAmount(entryContainer), entryContainer.baseamount, entryContainer.taxvariance, entryContainer.enteredamount, entryContainer.oidtaxrate, entryContainer, debit, currency, ntBase, nonDeductContainer);
        this.splitPaymentTaxAccount = TaxRegisterReportContainer.isSplitPaymentTaxAccount(entryContainer);
    }

    private void setTaxRegisterJournalData(String oidtaxregjournal) {
        TaxRegisterJournal journal = null;
        if (!StringMapper.isNullString((String)oidtaxregjournal)) {
            journal = TaxRegisterJournalPersistencyManager.getTaxRegisterJournal((String)oidtaxregjournal);
            this.setOidTaxRegisterJournal(oidtaxregjournal);
        }
        if (journal != null && journal.getFirstPageNumber() > 0) {
            this.setFirstPageNumber(journal.getFirstPageNumber());
        } else {
            this.setFirstPageNumber(0);
        }
    }

    private void setTaxRegisterData(SequenceNo taxRegister) {
        if (taxRegister != null) {
            this.setOidTaxRegister(taxRegister.getObjectid());
            this.setRegisterCode(taxRegister.getCode());
            this.setRegisterDescription(taxRegister.getDescription());
        }
    }

    public static BigDecimal getNetAmount(NlentryContainer entryContainer) {
        return TaxRegisterReportContainer.isSplitPaymentTaxAccount(entryContainer) ? BigDecimal.ZERO : entryContainer.netamount;
    }

    private static boolean isSplitPaymentTaxAccount(NlentryContainer entryContainer) {
        TaxAccountTypeEnum taxAccountType = TaxAccountTypeMapper.toTaxAccountType((int)entryContainer.taxaccounttype);
        return TaxAccountTypeEnum.TATE_SPLIT_PAYMENT.equals(taxAccountType) || TaxAccountTypeEnum.TATE_SPLIT_PAYMENT_ACTTAXATION.equals(taxAccountType);
    }

    public static BigDecimal getAmount(ICurrency currency, BigDecimal amount, boolean isOutput, boolean debit) {
        return VATReturnHelper.setSignum((BigDecimal)currency.round(amount), (boolean)isOutput, (boolean)debit);
    }

    public static boolean isInputTax(int taxaccounttype, boolean isDebit) {
        boolean result = false;
        switch (taxaccounttype) {
            case 0: {
                result = true;
                break;
            }
            case 1: {
                result = true;
                break;
            }
            case 6: {
                if (!isDebit) break;
                result = true;
                break;
            }
        }
        return result;
    }

    public String getPaCode() {
        return this.paCode;
    }

    public void setPaCode(String paCode) {
        this.paCode = paCode;
    }

    public String getPaCity() {
        return this.paCity;
    }

    public void setPaCity(String paCity) {
        this.paCity = paCity;
    }

    public String getPaShortName() {
        return this.paShortName;
    }

    public void setPaShortName(String paShortName) {
        this.paShortName = paShortName;
    }

    public String getPersonalAccountVatTaxNumber() {
        return this.personalAccountVatTaxNumber;
    }

    public void setPersonalAccountVatTaxNumber(String personalAccountVatTaxNumber) {
        this.personalAccountVatTaxNumber = personalAccountVatTaxNumber;
    }

    public String getReferenceNumber() {
        return this.referenceNumber;
    }

    public void setReferenceNumber(String referenceNumber) {
        this.referenceNumber = referenceNumber;
    }

    public String getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(String sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public Date getTransactionDate() {
        return this.transactionDate;
    }

    public void setTransactionDate(Date transactionDate) {
        this.transactionDate = transactionDate;
    }

    public String getRegisterCode() {
        return this.registerCode;
    }

    public void setRegisterCode(String registerCode) {
        this.registerCode = registerCode;
    }

    public String getRegisterDescription() {
        return this.registerDescription;
    }

    public void setRegisterDescription(String registerDescription) {
        this.registerDescription = registerDescription;
    }

    public String getBaseCurrencyCode() {
        return this.baseCurrencyCode;
    }

    public void setBaseCurrencyCode(String baseCurrencyCode) {
        this.baseCurrencyCode = baseCurrencyCode;
    }

    public BigDecimal getGrossAmount() {
        return this.grossAmount;
    }

    public void setGrossAmount(BigDecimal grossAmount) {
        this.grossAmount = grossAmount;
    }

    public BigDecimal getGrossAmountFC() {
        return this.grossAmountFC;
    }

    public void setGrossAmountFC(BigDecimal grossAmountFC) {
        this.grossAmountFC = grossAmountFC;
    }

    public TaxRegisterSubreportContainer[] getOneRegisterDataSet() {
        return this.oneRegisterDataSet;
    }

    public void setOneRegisterDataSet(TaxRegisterSubreportContainer[] oneRegisterDataSet) {
        this.oneRegisterDataSet = oneRegisterDataSet;
    }

    public String getOidTaxRegister() {
        return this.oidTaxRegister;
    }

    public void setOidTaxRegister(String oidTaxRegister) {
        this.oidTaxRegister = oidTaxRegister;
    }

    public String getOidEntry() {
        return this.oidEntry;
    }

    public void setOidEntry(String oidEntry) {
        this.oidEntry = oidEntry;
    }

    public boolean isInputTax() {
        return this.isInputTax;
    }

    public void setIsInputTax(boolean isInputTax) {
        this.isInputTax = isInputTax;
    }

    public String getTaxRegNo() {
        return this.taxRegNo;
    }

    public void setTaxRegNo(String taxRegNo) {
        this.taxRegNo = taxRegNo;
    }

    public String getShortCityTax() {
        return this.shortCityTax;
    }

    public void setShortCityTax(String shortCityTax) {
        this.shortCityTax = shortCityTax;
    }

    public String getOidTaxRegisterJournal() {
        return this.oidTaxRegisterJournal;
    }

    public void setOidTaxRegisterJournal(String oidTaxRegisterJournal) {
        this.oidTaxRegisterJournal = oidTaxRegisterJournal;
    }

    public String getDocumentType() {
        return this.documentType;
    }

    public void setDocumentType(String documentType) {
        this.documentType = documentType;
    }

    public String getPersonalAccountEcTaxNumber() {
        return this.personalAccountEcTaxNumber;
    }

    public void setPersonalAccountEcTaxNumber(String personalAccountEcTaxNumber) {
        this.personalAccountEcTaxNumber = personalAccountEcTaxNumber;
    }

    public String getOidTransaction() {
        return this.oidTransaction;
    }

    public void setOidTransaction(String oidTransaction) {
        this.oidTransaction = oidTransaction;
    }

    public String getOidTaxRate() {
        return this.oidTaxRate;
    }

    public void setOidTaxRate(String oidTaxRate) {
        this.oidTaxRate = oidTaxRate;
    }

    public int getFirstPageNumber() {
        return this.firstPageNumber;
    }

    public void setFirstPageNumber(int firstPageNumber) {
        this.firstPageNumber = firstPageNumber;
    }

    public BigDecimal getNetAmount() {
        return this.netAmount;
    }

    public void setNetAmount(BigDecimal netAmount) {
        this.netAmount = netAmount;
    }

    public BigDecimal getTaxAmount() {
        return this.taxAmount;
    }

    public void setTaxAmount(BigDecimal taxAmount) {
        this.taxAmount = taxAmount;
    }

    public BigDecimal getDeductibleTax() {
        return this.deductibleTax;
    }

    public void setDeductibleTax(BigDecimal deductibleTax) {
        this.deductibleTax = deductibleTax;
    }

    public BigDecimal getNonDeductibleTax() {
        return this.nonDeductibleTax;
    }

    public void setNonDeductibleTax(BigDecimal nonDeductibleTax) {
        this.nonDeductibleTax = nonDeductibleTax;
    }

    public BigDecimal getNetAmountFC() {
        return this.netAmountFC;
    }

    public void setNetAmountFC(BigDecimal netAmountFC) {
        this.netAmountFC = netAmountFC;
    }

    public BigDecimal getTaxAmountFC() {
        return this.taxAmountFC;
    }

    public void setTaxAmountFC(BigDecimal taxAmountFC) {
        this.taxAmountFC = taxAmountFC;
    }

    public BigDecimal getDeductibleTaxFC() {
        return this.deductibleTaxFC;
    }

    public void setDeductibleTaxFC(BigDecimal deductibleTaxFC) {
        this.deductibleTaxFC = deductibleTaxFC;
    }

    public BigDecimal getNonDeductibleTaxFC() {
        return this.nonDeductibleTaxFC;
    }

    public void setNonDeductibleTaxFC(BigDecimal nonDeductibleTaxFC) {
        this.nonDeductibleTaxFC = nonDeductibleTaxFC;
    }

    public BigDecimal getConversionRate() {
        return this.conversionRate;
    }

    public void setConversionRate(BigDecimal conversionRate) {
        this.conversionRate = conversionRate;
    }

    public String getEnteredCurrencyCode() {
        return this.enteredCurrencyCode;
    }

    public void setEnteredCurrencyCode(String enteredCurrencyCode) {
        this.enteredCurrencyCode = enteredCurrencyCode;
    }

    public boolean isForeign() {
        return this.isForeign;
    }

    public void setIsForeign(boolean isForeign) {
        this.isForeign = isForeign;
    }

    public BigDecimal getTaxVariance() {
        return this.taxVariance;
    }

    public void setTaxVariance(BigDecimal taxVariance) {
        this.taxVariance = taxVariance;
    }

    public String getTaxCode() {
        return this.taxCode;
    }

    public void setTaxCode(String taxCode) {
        this.taxCode = taxCode;
    }

    public String getTaxCodeDescription() {
        return this.taxCodeDescription;
    }

    public void setTaxCodeDescription(String taxCodeDescription) {
        this.taxCodeDescription = taxCodeDescription;
    }

    public BigDecimal getTaxPercent() {
        return this.taxPercent;
    }

    public void setTaxPercent(BigDecimal taxPercent) {
        this.taxPercent = taxPercent;
    }

    public Date getDocumentDate() {
        return this.documentDate;
    }

    public void setDocumentDate(Date documentDate) {
        this.documentDate = documentDate;
    }

    public String getOidTransactionSequence() {
        return this.oidTransactionSequence;
    }

    public void setOidTransactionSequence(String oidTransactionSequence) {
        this.oidTransactionSequence = oidTransactionSequence;
    }

    public String getTransactionNote() {
        return this.transactionNote;
    }

    public void setTransactionNote(String transactionNote) {
        this.transactionNote = transactionNote;
    }

    public BigDecimal getTransactionAmount() {
        return this.transactionAmount;
    }

    public void setTransactionAmount(BigDecimal transactionAmount) {
        this.transactionAmount = transactionAmount;
    }

    public BigDecimal getTransactionAmountFC() {
        return this.transactionAmountFC;
    }

    public void setTransactionAmountFC(BigDecimal transactionAmountFC) {
        this.transactionAmountFC = transactionAmountFC;
    }

    public boolean isSplitPaymentTaxAccount() {
        return this.splitPaymentTaxAccount;
    }
}

