/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.domain.payment.sepa.schemamapper.version3.credit;

import com.infor.igf.core.util.StringUtil;
import com.varial.accounting.domain.payment.sepa.SepaChargesType;
import com.varial.accounting.domain.payment.sepa.SepaVersionManager;
import com.varial.accounting.domain.payment.sepa.schemamapper.version3.credit.CreditSchemaMapper;
import com.varial.accounting.domain.payment.sepa.schemamapper.version3.credit.PartyIdentificationBuilder;
import com.varial.base.UtilitiesManager;
import com.varial.base.configuration.Configuration;
import com.varial.framework.domain.isoftware.ISoftware;
import com.varial.framework.domain.payment.sepa.data.PartyData;
import com.varial.framework.domain.payment.sepa.data.PaymentData;
import com.varial.framework.domain.payment.sepa.data.PaymentInfoData;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.StringMapper;
import iso.sepa.version3.credit.BranchAndFinancialInstitutionIdentification4;
import iso.sepa.version3.credit.GenericOrganisationIdentification1;
import iso.sepa.version3.credit.OrganisationIdentification4;
import iso.sepa.version3.credit.OrganisationIdentificationSchemeName1Choice;
import iso.sepa.version3.credit.Party6Choice;
import iso.sepa.version3.credit.PartyIdentification32;
import iso.sepa.version3.credit.RegulatoryAuthority2;
import iso.sepa.version3.credit.RegulatoryReporting3;
import iso.sepa.version3.credit.StructuredRegulatoryReporting3;
import java.math.BigDecimal;

public class SepaCreditSchemaMapper
extends CreditSchemaMapper {
    private final SepaVersionManager.CountrySchemaVersion countrySchemaVersion;
    private final boolean isKronospan;

    public SepaCreditSchemaMapper(SepaVersionManager.CountrySchemaVersion countrySchemaVersion) {
        this.countrySchemaVersion = countrySchemaVersion;
        this.isKronospan = ISoftware.isKronospan();
    }

    @Override
    protected RegulatoryReporting3 mapRegulatoryReporting(PaymentData payment) {
        return this.isKronospanLV() && payment.getIsForeignPayment() && payment.getCurrencyCode().equals("EUR") && BigDecimalMapper.compareTo((BigDecimal)payment.getAmount().abs(), (BigDecimal)BigDecimalMapper.toBigDecimal((String)"10000")) > 0 ? this.mapRegulatoryReportingKronospanLV(payment) : null;
    }

    private RegulatoryReporting3 mapRegulatoryReportingKronospanLV(PaymentData payment) {
        RegulatoryReporting3 result = new RegulatoryReporting3();
        RegulatoryAuthority2 regulatoryAuthority = new RegulatoryAuthority2();
        regulatoryAuthority.setCtry("LV");
        result.setAuthrty(regulatoryAuthority);
        StructuredRegulatoryReporting3 srr = new StructuredRegulatoryReporting3();
        srr.setTp("AMK");
        srr.setCtry(payment.getPartyData().getBeneficiaryCountry());
        if (!StringMapper.isNullString((String)payment.getPartyData().getPaymentDetailsCode())) {
            srr.setCd(payment.getPartyData().getPaymentDetailsCode());
        }
        result.getDtls().add(srr);
        return result;
    }

    @Override
    protected SepaChargesType getChargesType(PaymentData payment, PaymentInfoData paymentInfo) {
        return this.isKronospanDK() ? SepaChargesType.getChargesTypeForKronospanDK(payment) : SepaChargesType.SLEV;
    }

    @Override
    protected boolean getBtchBookgValue() {
        return !this.getSetBatchBookingToFalsePL();
    }

    private boolean getSetBatchBookingToFalsePL() {
        return SepaVersionManager.CountrySchemaVersion.SEPA_PL == this.countrySchemaVersion && ((Configuration)UtilitiesManager.getBean((String)"com.infor.igf.configuration", Configuration.class)).getISO20022SetBatchBookingToFalsePL();
    }

    @Override
    protected PartyIdentification32 mapCreditor(PartyData creditor) {
        return new PartyIdentificationBuilder(creditor).withName().withUnstructuredPostalAddress().build();
    }

    @Override
    protected PartyIdentification32 mapDebtor(PartyData debtor) {
        PartyIdentification32 ident = new PartyIdentificationBuilder(debtor).withName().withUnstructuredPostalAddress().build();
        if (ident != null && SepaVersionManager.CountrySchemaVersion.SEPA_FI == this.countrySchemaVersion && StringUtil.isNotEmpty((String)debtor.getServiceID())) {
            ident.setId(this.getDebtorId(debtor.getServiceID()));
        }
        return ident;
    }

    private Party6Choice getDebtorId(String serviceID) {
        Party6Choice id = new Party6Choice();
        id.setOrgId(this.getDebtorOrgId(serviceID));
        return id;
    }

    private OrganisationIdentification4 getDebtorOrgId(String serviceID) {
        OrganisationIdentification4 orgId = new OrganisationIdentification4();
        GenericOrganisationIdentification1 othr = new GenericOrganisationIdentification1();
        othr.setId(serviceID);
        OrganisationIdentificationSchemeName1Choice schemeName = new OrganisationIdentificationSchemeName1Choice();
        schemeName.setCd("BANK");
        othr.setSchmeNm(schemeName);
        orgId.getOthr().add(othr);
        return orgId;
    }

    private boolean isKronospanLV() {
        return SepaVersionManager.CountrySchemaVersion.LV == this.countrySchemaVersion && this.isKronospan;
    }

    private boolean isKronospanDK() {
        return SepaVersionManager.CountrySchemaVersion.DK == this.countrySchemaVersion && this.isKronospan;
    }

    @Override
    protected PartyIdentification32 mapInitiatingParty(PartyData initiatingParty) {
        PartyIdentification32 result = new PartyIdentificationBuilder(initiatingParty).withName().withUnstructuredPostalAddress().build();
        if (result != null && SepaVersionManager.CountrySchemaVersion.SEPA_ES == this.countrySchemaVersion) {
            result.setId(this.getCompanyId(initiatingParty));
        }
        return result;
    }

    private Party6Choice getCompanyId(PartyData companyData) {
        OrganisationIdentification4 orgId = new OrganisationIdentification4();
        GenericOrganisationIdentification1 genOrgId = new GenericOrganisationIdentification1();
        genOrgId.setId(companyData.getCompanyTaxNumber());
        orgId.getOthr().add(genOrgId);
        Party6Choice id = new Party6Choice();
        id.setOrgId(orgId);
        return id;
    }

    @Override
    protected BranchAndFinancialInstitutionIdentification4 getCreditorAgent(PaymentData payment) {
        return StringUtil.isNotEmpty((String)payment.getBic()) ? this.getFinancialInstitution(payment.getBic()) : null;
    }

    @Override
    protected String getServiceLevelCode() {
        return "SEPA";
    }
}

