/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.domain.payment.sepa.schemamapper.version3.credit;

import com.infor.igf.core.util.StringUtil;
import com.varial.framework.domain.payment.sepa.data.LocationData;
import iso.sepa.version3.credit.PostalAddress6;

public class PostalAddressBuilder {
    private final LocationData dto;
    private boolean structuredAddress;

    public PostalAddressBuilder(LocationData dto) {
        this.dto = dto;
        this.structuredAddress = false;
    }

    public PostalAddressBuilder withStructuredAddress(boolean structuredAddress) {
        this.structuredAddress = structuredAddress;
        return this;
    }

    public PostalAddress6 build() {
        if (this.dto == null) {
            return null;
        }
        PostalAddress6 result = new PostalAddress6();
        if (this.structuredAddress) {
            result.setTwnNm(this.dto.getCity());
            if (StringUtil.isNotEmpty((String)this.dto.getPostalCode())) {
                result.setPstCd(this.dto.getPostalCode());
            }
        } else {
            result.getAdrLine().add(this.dto.getAddress());
            result.getAdrLine().add(this.dto.getAddress1());
        }
        result.setCtry(this.dto.getCountryCode());
        return result;
    }
}

